/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons.virtualbox_3_2;

import com.sun.xml.ws.commons.virtualbox_3_2.ISession;
import com.sun.xml.ws.commons.virtualbox_3_2.IVirtualBox;
import com.sun.xml.ws.commons.virtualbox_3_2.PortPool;
import java.net.URL;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import org.virtualbox_3_2.InvalidObjectFaultMsg;
import org.virtualbox_3_2.RuntimeFaultMsg;
import org.virtualbox_3_2.VboxPortType;

public class IWebsessionManager {
    private static PortPool pool = new PortPool(true);
    protected VboxPortType port;

    public IWebsessionManager(URL uRL) {
        this.connect(uRL);
    }

    public IWebsessionManager(String string) {
        this.connect(string);
    }

    public IWebsessionManager(URL uRL, Map<String, Object> map, Map<String, Object> map2) {
        this.connect(uRL.toExternalForm(), map, map2);
    }

    public IWebsessionManager(String string, Map<String, Object> map, Map<String, Object> map2) {
        this.connect(string, map, map2);
    }

    public void connect(URL uRL) {
        this.connect(uRL.toExternalForm());
    }

    public void connect(String string) {
        this.port = pool.getPort();
        try {
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", string);
        }
        catch (Throwable throwable) {
            if (this.port != null) {
                pool.releasePort(this.port);
            }
            throw new WebServiceException(throwable);
        }
    }

    public void connect(String string, Map<String, Object> map, Map<String, Object> map2) {
        this.port = pool.getPort();
        try {
            ((BindingProvider)this.port).getRequestContext();
            if (map != null) {
                ((BindingProvider)this.port).getRequestContext().putAll(map);
            }
            if (map2 != null) {
                ((BindingProvider)this.port).getResponseContext().putAll(map2);
            }
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", string);
        }
        catch (Throwable throwable) {
            if (this.port != null) {
                pool.releasePort(this.port);
            }
            throw new WebServiceException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(IVirtualBox iVirtualBox) {
        try {
            this.logoff(iVirtualBox);
        }
        finally {
            if (this.port != null) {
                pool.releasePort(this.port);
                this.port = null;
            }
        }
    }

    public void cleanupUnused() {
        System.gc();
        Runtime.getRuntime().runFinalization();
    }

    public IVirtualBox logon(String string, String string2) {
        try {
            String string3 = this.port.iWebsessionManagerLogon(string, string2);
            return new IVirtualBox(string3, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public ISession getSessionObject(IVirtualBox iVirtualBox) {
        try {
            String string = this.port.iWebsessionManagerGetSessionObject(iVirtualBox == null ? null : iVirtualBox.getRef());
            return new ISession(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void logoff(IVirtualBox iVirtualBox) {
        try {
            this.port.iWebsessionManagerLogoff(iVirtualBox == null ? null : iVirtualBox.getRef());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }
}

