<?php

/*
* Copyright (C) 2009 Sun Microsystems, Inc.
*
* This file is part of VirtualBox Open Source Edition (OSE), as
* available from http://www.virtualbox.org. This file is free software;
* you can redistribute it and/or modify it under the terms of the GNU
* General Public License (GPL) as published by the Free Software
* Foundation, in version 2 as it comes in the "COPYING" file of the
* VirtualBox OSE distribution. VirtualBox OSE is distributed in the
* hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
*
* Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa
* Clara, CA 95054 USA or visit http://www.sun.com if you need
* additional information or have any questions.
*
* This file is autogenerated from VirtualBox.xidl, DO NOT EDIT!
*/

class VBox_ManagedObject
{
    protected $connection;
    protected $handle;

    public function __construct($soap, $handle = null)
    {
        $this->connection = $soap;
        $this->handle = $handle;
    }

    public function __toString()
    {
        return (string)$this->handle;
    }

    public function __set($attr, $value)
    {
        $methodName = "set" . $attr;
        if (method_exists($this, $methodName))
            $this->$methodName($value);
        else
            throw new Exception("Attribute does not exist");
    }

    public function __get($attr)
    {
        $methodName = "get" . $attr;
        if (method_exists($this, $methodName))
            return $this->$methodName();
        else
            throw new Exception("Attribute does not exist");
    }

   public function getHandle()
   {
       return $this->handle;
   }

   public function cast($class)
   {
       if (is_subclass_of($class, 'VBox_ManagedObject'))
       {
           return new $class($this->connection, $this->handle);
       }
       throw new Exception('Cannot cast VBox_ManagedObject to non-child class VBox_ManagedObject');
   }

   public function releaseRemote()
   {
       try
       {
           $request = new stdClass();
           $request->_this = $this->handle;
           $this->connection->__soapCall('IManagedObjectRef_release', array((array)$request));
       } catch (Exception $ex) {}
   }
}

abstract class VBox_Collection implements ArrayAccess, Iterator, Countable {
    protected $_connection;
    protected $_values;
    protected $_objects;
    protected $_interfaceName;

    public function __construct($soap, array $values = array()) {
        $this->_connection = $soap;
        $this->_values = $values;
        $this->_soapToObject();
    }

    protected function _soapToObject() {
        $this->_objects = array();
        foreach($this->_values as $value)
        {
            $this->_objects[] = new $this->_interfaceName($this->_connection, $value);
        }
    }

    /** ArrayAccess Functions **/
    public function offsetSet($offset, $value) {
        if ($value instanceof $this->_interfaceName)
        {
            if ($offset)
            {
                $this->_objects[$offset] = $value;
            }
            else
            {
                $this->_objects[] = $value;
            }
        }
        else
        {
            throw new Exception("Value must be a instance of " . $this->_interfaceName);
        }
    }

    public function offsetExists($offset) {
        return isset($this->_objects[$offset]);
    }

    public function offsetUnset($offset) {
        unset($this->_objects[$offset]);
    }

    public function offsetGet($offset) {
        return isset($this->_objects[$offset]) ? $this->_objects[$offset] : null;
    }

    /** Iterator Functions **/
    public function rewind() {
        reset($this->_objects);
    }

    public function current() {
        return current($this->_objects);
    }

    public function key() {
        return key($this->_objects);
    }

    public function next() {
        return next($this->_objects);
    }

    public function valid() {
        return ($this->current() !== false);
    }

    /** Countable Functions **/
    public function count() {
        return count($this->_objects);
    }
}

class VBox_ManagedObjectCollection extends VBox_Collection {
    protected $_interfaceName = 'VBox_ManagedObject';

    // Result is undefined if this is called AFTER any call to VBox_Collection::offsetSet or VBox_Collection::offsetUnset
    public function setInterfaceName($interface) {
       if (!is_subclass_of($interface, 'VBox_ManagedObject'))
       {
           throw new Exception('Cannot set collection interface to non-child class of VBox_ManagedObject');
       }
       $this->_interfaceName = $interface;
       $this->_soapToObject();
    }
}

abstract class VBox_Struct {
    protected $connection;

    public function __get($attr)
    {
        $methodName = "get" . $attr;
        if (method_exists($this, $methodName))
            return $this->$methodName();
        else
            throw new Exception("Attribute does not exist");
    }
}

abstract class VBox_StructCollection extends VBox_Collection {

    public function __construct($soap, array $values = array())
    {
        if (!(array_values($values) === $values))
        {
            $values = array((object)$values); //Fix for when struct return value only contains one list item (e.g. one medium attachment)
        }
        parent::__construct($soap, $values);
    }
}

abstract class VBox_Enum {
   protected $_handle;

   public function __construct($connection, $handle)
   {
       if (is_string($handle))
           $this->_handle = $this->ValueMap[$handle];
       else
           $this->_handle = $handle;
   }

   public function __toString()
   {
       return (string)$this->NameMap[$this->_handle];
   }
}

abstract class VBox_EnumCollection extends VBox_Collection {
}


/**
* Generated VBoxWebService Interface Wrapper
*/
class IVirtualBoxErrorInfo extends VBox_ManagedObject {

   public function getResultCode() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBoxErrorInfo_getResultCode', array((array)$request));
       return (int)$response->returnval;
   }

   public function getInterfaceID() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBoxErrorInfo_getInterfaceID', array((array)$request));
       return (string)$response->returnval;
   }

   public function getComponent() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBoxErrorInfo_getComponent', array((array)$request));
       return (string)$response->returnval;
   }

   public function getText() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBoxErrorInfo_getText', array((array)$request));
       return (string)$response->returnval;
   }

   public function getNext() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBoxErrorInfo_getNext', array((array)$request));
       return new IVirtualBoxErrorInfo ($this->connection, $response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IVirtualBoxErrorInfoCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IVirtualBoxErrorInfo";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IDHCPServer extends VBox_ManagedObject {

   public function setConfiguration($arg_IPAddress, $arg_networkMask, $arg_FromIPAddress, $arg_ToIPAddress) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->IPAddress = $arg_IPAddress;
       $request->networkMask = $arg_networkMask;
       $request->FromIPAddress = $arg_FromIPAddress;
       $request->ToIPAddress = $arg_ToIPAddress;
       $response = $this->connection->__soapCall('IDHCPServer_setConfiguration', array((array)$request));
       
       return ;
  }

   public function start($arg_networkName, $arg_trunkName, $arg_trunkType) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->networkName = $arg_networkName;
       $request->trunkName = $arg_trunkName;
       $request->trunkType = $arg_trunkType;
       $response = $this->connection->__soapCall('IDHCPServer_start', array((array)$request));
       
       return ;
  }

   public function stop() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IDHCPServer_stop', array((array)$request));
       
       return ;
  }

   public function getEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IDHCPServer_getEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->enabled = $value;
       }
       else
       {
            $request->enabled = $value->handle;
       }
       $this->connection->__soapCall('IDHCPServer_setEnabled', array((array)$request));
   }

   public function getIPAddress() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IDHCPServer_getIPAddress', array((array)$request));
       return (string)$response->returnval;
   }

   public function getNetworkMask() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IDHCPServer_getNetworkMask', array((array)$request));
       return (string)$response->returnval;
   }

   public function getNetworkName() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IDHCPServer_getNetworkName', array((array)$request));
       return (string)$response->returnval;
   }

   public function getLowerIP() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IDHCPServer_getLowerIP', array((array)$request));
       return (string)$response->returnval;
   }

   public function getUpperIP() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IDHCPServer_getUpperIP', array((array)$request));
       return (string)$response->returnval;
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IDHCPServerCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IDHCPServer";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IVirtualBox extends VBox_ManagedObject {

   public function createMachine($arg_name, $arg_osTypeId, $arg_baseFolder, $arg_id, $arg_override) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->osTypeId = $arg_osTypeId;
       $request->baseFolder = $arg_baseFolder;
       $request->id = $arg_id;
       $request->override = $arg_override;
       $response = $this->connection->__soapCall('IVirtualBox_createMachine', array((array)$request));
       
       return new IMachine ($this->connection, $response->returnval);
  }

   public function createLegacyMachine($arg_name, $arg_osTypeId, $arg_settingsFile, $arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->osTypeId = $arg_osTypeId;
       $request->settingsFile = $arg_settingsFile;
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IVirtualBox_createLegacyMachine', array((array)$request));
       
       return new IMachine ($this->connection, $response->returnval);
  }

   public function openMachine($arg_settingsFile) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->settingsFile = $arg_settingsFile;
       $response = $this->connection->__soapCall('IVirtualBox_openMachine', array((array)$request));
       
       return new IMachine ($this->connection, $response->returnval);
  }

   public function registerMachine($arg_machine) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->machine = $arg_machine;
       $response = $this->connection->__soapCall('IVirtualBox_registerMachine', array((array)$request));
       
       return ;
  }

   public function getMachine($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IVirtualBox_getMachine', array((array)$request));
       
       return new IMachine ($this->connection, $response->returnval);
  }

   public function findMachine($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IVirtualBox_findMachine', array((array)$request));
       
       return new IMachine ($this->connection, $response->returnval);
  }

   public function unregisterMachine($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IVirtualBox_unregisterMachine', array((array)$request));
       
       return new IMachine ($this->connection, $response->returnval);
  }

   public function createAppliance() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IVirtualBox_createAppliance', array((array)$request));
       
       return new IAppliance ($this->connection, $response->returnval);
  }

   public function createHardDisk($arg_format, $arg_location) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->format = $arg_format;
       $request->location = $arg_location;
       $response = $this->connection->__soapCall('IVirtualBox_createHardDisk', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function openHardDisk($arg_location, $arg_accessMode, $arg_setImageId, $arg_imageId, $arg_setParentId, $arg_parentId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->location = $arg_location;
       $request->accessMode = $arg_accessMode;
       $request->setImageId = $arg_setImageId;
       $request->imageId = $arg_imageId;
       $request->setParentId = $arg_setParentId;
       $request->parentId = $arg_parentId;
       $response = $this->connection->__soapCall('IVirtualBox_openHardDisk', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function getHardDisk($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IVirtualBox_getHardDisk', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function findHardDisk($arg_location) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->location = $arg_location;
       $response = $this->connection->__soapCall('IVirtualBox_findHardDisk', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function openDVDImage($arg_location, $arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->location = $arg_location;
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IVirtualBox_openDVDImage', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function getDVDImage($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IVirtualBox_getDVDImage', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function findDVDImage($arg_location) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->location = $arg_location;
       $response = $this->connection->__soapCall('IVirtualBox_findDVDImage', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function openFloppyImage($arg_location, $arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->location = $arg_location;
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IVirtualBox_openFloppyImage', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function getFloppyImage($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IVirtualBox_getFloppyImage', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function findFloppyImage($arg_location) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->location = $arg_location;
       $response = $this->connection->__soapCall('IVirtualBox_findFloppyImage', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function getGuestOSType($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IVirtualBox_getGuestOSType', array((array)$request));
       
       return new IGuestOSType ($this->connection, $response->returnval);
  }

   public function createSharedFolder($arg_name, $arg_hostPath, $arg_writable) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->hostPath = $arg_hostPath;
       $request->writable = $arg_writable;
       $response = $this->connection->__soapCall('IVirtualBox_createSharedFolder', array((array)$request));
       
       return ;
  }

   public function removeSharedFolder($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IVirtualBox_removeSharedFolder', array((array)$request));
       
       return ;
  }

   public function getExtraDataKeys() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IVirtualBox_getExtraDataKeys', array((array)$request));
       
       return (array)$response->returnval;
  }

   public function getExtraData($arg_key) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->key = $arg_key;
       $response = $this->connection->__soapCall('IVirtualBox_getExtraData', array((array)$request));
       
       return (string)$response->returnval;
  }

   public function setExtraData($arg_key, $arg_value) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->key = $arg_key;
       $request->value = $arg_value;
       $response = $this->connection->__soapCall('IVirtualBox_setExtraData', array((array)$request));
       
       return ;
  }

   public function openSession($arg_session, $arg_machineId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->session = $arg_session;
       $request->machineId = $arg_machineId;
       $response = $this->connection->__soapCall('IVirtualBox_openSession', array((array)$request));
       
       return ;
  }

   public function openRemoteSession($arg_session, $arg_machineId, $arg_type, $arg_environment) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->session = $arg_session;
       $request->machineId = $arg_machineId;
       $request->type = $arg_type;
       $request->environment = $arg_environment;
       $response = $this->connection->__soapCall('IVirtualBox_openRemoteSession', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function openExistingSession($arg_session, $arg_machineId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->session = $arg_session;
       $request->machineId = $arg_machineId;
       $response = $this->connection->__soapCall('IVirtualBox_openExistingSession', array((array)$request));
       
       return ;
  }

   public function waitForPropertyChange($arg_what, $arg_timeout) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->what = $arg_what;
       $request->timeout = $arg_timeout;
       $response = $this->connection->__soapCall('IVirtualBox_waitForPropertyChange', array((array)$request));
       
       return array((string)$response->changed, (string)$response->values);
  }

   public function createDHCPServer($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IVirtualBox_createDHCPServer', array((array)$request));
       
       return new IDHCPServer ($this->connection, $response->returnval);
  }

   public function findDHCPServerByNetworkName($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IVirtualBox_findDHCPServerByNetworkName', array((array)$request));
       
       return new IDHCPServer ($this->connection, $response->returnval);
  }

   public function removeDHCPServer($arg_server) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->server = $arg_server;
       $response = $this->connection->__soapCall('IVirtualBox_removeDHCPServer', array((array)$request));
       
       return ;
  }

   public function checkFirmwarePresent($arg_firmwareType, $arg_version) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->firmwareType = $arg_firmwareType;
       $request->version = $arg_version;
       $response = $this->connection->__soapCall('IVirtualBox_checkFirmwarePresent', array((array)$request));
       
       return array((bool)$response->returnval, (string)$response->url, (string)$response->file);
  }

   public function getVersion() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getVersion', array((array)$request));
       return (string)$response->returnval;
   }

   public function getRevision() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getRevision', array((array)$request));
       return (float)$response->returnval;
   }

   public function getPackageType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getPackageType', array((array)$request));
       return (string)$response->returnval;
   }

   public function getHomeFolder() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getHomeFolder', array((array)$request));
       return (string)$response->returnval;
   }

   public function getSettingsFilePath() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getSettingsFilePath', array((array)$request));
       return (string)$response->returnval;
   }

   public function getHost() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getHost', array((array)$request));
       return new IHost ($this->connection, $response->returnval);
   }

   public function getSystemProperties() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getSystemProperties', array((array)$request));
       return new ISystemProperties ($this->connection, $response->returnval);
   }

   public function getMachines() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getMachines', array((array)$request));
       return new IMachineCollection ($this->connection, (array)$response->returnval);
   }

   public function getHardDisks() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getHardDisks', array((array)$request));
       return new IMediumCollection ($this->connection, (array)$response->returnval);
   }

   public function getDVDImages() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getDVDImages', array((array)$request));
       return new IMediumCollection ($this->connection, (array)$response->returnval);
   }

   public function getFloppyImages() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getFloppyImages', array((array)$request));
       return new IMediumCollection ($this->connection, (array)$response->returnval);
   }

   public function getProgressOperations() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getProgressOperations', array((array)$request));
       return new IProgressCollection ($this->connection, (array)$response->returnval);
   }

   public function getGuestOSTypes() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getGuestOSTypes', array((array)$request));
       return new IGuestOSTypeCollection ($this->connection, (array)$response->returnval);
   }

   public function getSharedFolders() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getSharedFolders', array((array)$request));
       return new ISharedFolderCollection ($this->connection, (array)$response->returnval);
   }

   public function getPerformanceCollector() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getPerformanceCollector', array((array)$request));
       return new IPerformanceCollector ($this->connection, $response->returnval);
   }

   public function getDHCPServers() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualBox_getDHCPServers', array((array)$request));
       return new IDHCPServerCollection ($this->connection, (array)$response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IVirtualBoxCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IVirtualBox";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IVFSExplorer extends VBox_ManagedObject {

   public function update() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IVFSExplorer_update', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function cd($arg_aDir) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->aDir = $arg_aDir;
       $response = $this->connection->__soapCall('IVFSExplorer_cd', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function cdUp() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IVFSExplorer_cdUp', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function entryList() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IVFSExplorer_entryList', array((array)$request));
       
       return array((array)$response->aNames, (array)$response->aTypes);
  }

   public function exists($arg_aNames) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->aNames = $arg_aNames;
       $response = $this->connection->__soapCall('IVFSExplorer_exists', array((array)$request));
       
       return (array)$response->returnval;
  }

   public function remove($arg_aNames) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->aNames = $arg_aNames;
       $response = $this->connection->__soapCall('IVFSExplorer_remove', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function getPath() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVFSExplorer_getPath', array((array)$request));
       return (string)$response->returnval;
   }

   public function getType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVFSExplorer_getType', array((array)$request));
       return new VFSType ($this->connection, $response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IVFSExplorerCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IVFSExplorer";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IAppliance extends VBox_ManagedObject {

   public function read($arg_file) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->file = $arg_file;
       $response = $this->connection->__soapCall('IAppliance_read', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function interpret() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IAppliance_interpret', array((array)$request));
       
       return ;
  }

   public function importMachines() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IAppliance_importMachines', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function createVFSExplorer($arg_aUri) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->aUri = $arg_aUri;
       $response = $this->connection->__soapCall('IAppliance_createVFSExplorer', array((array)$request));
       
       return new IVFSExplorer ($this->connection, $response->returnval);
  }

   public function write($arg_format, $arg_path) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->format = $arg_format;
       $request->path = $arg_path;
       $response = $this->connection->__soapCall('IAppliance_write', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function getWarnings() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IAppliance_getWarnings', array((array)$request));
       
       return (array)$response->returnval;
  }

   public function getPath() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IAppliance_getPath', array((array)$request));
       return (string)$response->returnval;
   }

   public function getDisks() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IAppliance_getDisks', array((array)$request));
       return (array)$response->returnval;
   }

   public function getVirtualSystemDescriptions() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IAppliance_getVirtualSystemDescriptions', array((array)$request));
       return new IVirtualSystemDescriptionCollection ($this->connection, (array)$response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IApplianceCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IAppliance";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IVirtualSystemDescription extends VBox_ManagedObject {

   public function getDescription() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IVirtualSystemDescription_getDescription', array((array)$request));
       
       return array(new VirtualSystemDescriptionTypeCollection ($this->connection, (array)$response->aTypes), (array)$response->aRefs, (array)$response->aOvfValues, (array)$response->aVBoxValues, (array)$response->aExtraConfigValues);
  }

   public function getDescriptionByType($arg_aType) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->aType = $arg_aType;
       $response = $this->connection->__soapCall('IVirtualSystemDescription_getDescriptionByType', array((array)$request));
       
       return array(new VirtualSystemDescriptionTypeCollection ($this->connection, (array)$response->aTypes), (array)$response->aRefs, (array)$response->aOvfValues, (array)$response->aVBoxValues, (array)$response->aExtraConfigValues);
  }

   public function getValuesByType($arg_aType, $arg_aWhich) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->aType = $arg_aType;
       $request->aWhich = $arg_aWhich;
       $response = $this->connection->__soapCall('IVirtualSystemDescription_getValuesByType', array((array)$request));
       
       return (array)$response->returnval;
  }

   public function setFinalValues($arg_aEnabled, $arg_aVBoxValues, $arg_aExtraConfigValues) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->aEnabled = $arg_aEnabled;
       $request->aVBoxValues = $arg_aVBoxValues;
       $request->aExtraConfigValues = $arg_aExtraConfigValues;
       $response = $this->connection->__soapCall('IVirtualSystemDescription_setFinalValues', array((array)$request));
       
       return ;
  }

   public function addDescription($arg_aType, $arg_aVBoxValue, $arg_aExtraConfigValue) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->aType = $arg_aType;
       $request->aVBoxValue = $arg_aVBoxValue;
       $request->aExtraConfigValue = $arg_aExtraConfigValue;
       $response = $this->connection->__soapCall('IVirtualSystemDescription_addDescription', array((array)$request));
       
       return ;
  }

   public function getCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVirtualSystemDescription_getCount', array((array)$request));
       return (float)$response->returnval;
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IVirtualSystemDescriptionCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IVirtualSystemDescription";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IBIOSSettings extends VBox_ManagedObject {

   public function getLogoFadeIn() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IBIOSSettings_getLogoFadeIn', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setLogoFadeIn($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->logoFadeIn = $value;
       }
       else
       {
            $request->logoFadeIn = $value->handle;
       }
       $this->connection->__soapCall('IBIOSSettings_setLogoFadeIn', array((array)$request));
   }

   public function getLogoFadeOut() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IBIOSSettings_getLogoFadeOut', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setLogoFadeOut($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->logoFadeOut = $value;
       }
       else
       {
            $request->logoFadeOut = $value->handle;
       }
       $this->connection->__soapCall('IBIOSSettings_setLogoFadeOut', array((array)$request));
   }

   public function getLogoDisplayTime() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IBIOSSettings_getLogoDisplayTime', array((array)$request));
       return (float)$response->returnval;
   }

   public function setLogoDisplayTime($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->logoDisplayTime = $value;
       }
       else
       {
            $request->logoDisplayTime = $value->handle;
       }
       $this->connection->__soapCall('IBIOSSettings_setLogoDisplayTime', array((array)$request));
   }

   public function getLogoImagePath() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IBIOSSettings_getLogoImagePath', array((array)$request));
       return (string)$response->returnval;
   }

   public function setLogoImagePath($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->logoImagePath = $value;
       }
       else
       {
            $request->logoImagePath = $value->handle;
       }
       $this->connection->__soapCall('IBIOSSettings_setLogoImagePath', array((array)$request));
   }

   public function getBootMenuMode() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IBIOSSettings_getBootMenuMode', array((array)$request));
       return new BIOSBootMenuMode ($this->connection, $response->returnval);
   }

   public function setBootMenuMode($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->bootMenuMode = $value;
       }
       else
       {
            $request->bootMenuMode = $value->handle;
       }
       $this->connection->__soapCall('IBIOSSettings_setBootMenuMode', array((array)$request));
   }

   public function getACPIEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IBIOSSettings_getACPIEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setACPIEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->ACPIEnabled = $value;
       }
       else
       {
            $request->ACPIEnabled = $value->handle;
       }
       $this->connection->__soapCall('IBIOSSettings_setACPIEnabled', array((array)$request));
   }

   public function getIOAPICEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IBIOSSettings_getIOAPICEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setIOAPICEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->IOAPICEnabled = $value;
       }
       else
       {
            $request->IOAPICEnabled = $value->handle;
       }
       $this->connection->__soapCall('IBIOSSettings_setIOAPICEnabled', array((array)$request));
   }

   public function getTimeOffset() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IBIOSSettings_getTimeOffset', array((array)$request));
       return (float)$response->returnval;
   }

   public function setTimeOffset($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->timeOffset = $value;
       }
       else
       {
            $request->timeOffset = $value->handle;
       }
       $this->connection->__soapCall('IBIOSSettings_setTimeOffset', array((array)$request));
   }

   public function getPXEDebugEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IBIOSSettings_getPXEDebugEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setPXEDebugEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->PXEDebugEnabled = $value;
       }
       else
       {
            $request->PXEDebugEnabled = $value->handle;
       }
       $this->connection->__soapCall('IBIOSSettings_setPXEDebugEnabled', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IBIOSSettingsCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IBIOSSettings";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IMachine extends VBox_ManagedObject {

   public function setBootOrder($arg_position, $arg_device) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->position = $arg_position;
       $request->device = $arg_device;
       $response = $this->connection->__soapCall('IMachine_setBootOrder', array((array)$request));
       
       return ;
  }

   public function getBootOrder($arg_position) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->position = $arg_position;
       $response = $this->connection->__soapCall('IMachine_getBootOrder', array((array)$request));
       
       return new DeviceType ($this->connection, $response->returnval);
  }

   public function attachDevice($arg_name, $arg_controllerPort, $arg_device, $arg_type, $arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->controllerPort = $arg_controllerPort;
       $request->device = $arg_device;
       $request->type = $arg_type;
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IMachine_attachDevice', array((array)$request));
       
       return ;
  }

   public function detachDevice($arg_name, $arg_controllerPort, $arg_device) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->controllerPort = $arg_controllerPort;
       $request->device = $arg_device;
       $response = $this->connection->__soapCall('IMachine_detachDevice', array((array)$request));
       
       return ;
  }

   public function passthroughDevice($arg_name, $arg_controllerPort, $arg_device, $arg_passthrough) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->controllerPort = $arg_controllerPort;
       $request->device = $arg_device;
       $request->passthrough = $arg_passthrough;
       $response = $this->connection->__soapCall('IMachine_passthroughDevice', array((array)$request));
       
       return ;
  }

   public function mountMedium($arg_name, $arg_controllerPort, $arg_device, $arg_medium, $arg_force) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->controllerPort = $arg_controllerPort;
       $request->device = $arg_device;
       $request->medium = $arg_medium;
       $request->force = $arg_force;
       $response = $this->connection->__soapCall('IMachine_mountMedium', array((array)$request));
       
       return ;
  }

   public function getMedium($arg_name, $arg_controllerPort, $arg_device) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->controllerPort = $arg_controllerPort;
       $request->device = $arg_device;
       $response = $this->connection->__soapCall('IMachine_getMedium', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function getMediumAttachmentsOfController($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IMachine_getMediumAttachmentsOfController', array((array)$request));
       
       return new IMediumAttachmentCollection ($this->connection, (array)$response->returnval);
  }

   public function getMediumAttachment($arg_name, $arg_controllerPort, $arg_device) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->controllerPort = $arg_controllerPort;
       $request->device = $arg_device;
       $response = $this->connection->__soapCall('IMachine_getMediumAttachment', array((array)$request));
       
       return new IMediumAttachment ($this->connection, $response->returnval);
  }

   public function getNetworkAdapter($arg_slot) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->slot = $arg_slot;
       $response = $this->connection->__soapCall('IMachine_getNetworkAdapter', array((array)$request));
       
       return new INetworkAdapter ($this->connection, $response->returnval);
  }

   public function addStorageController($arg_name, $arg_connectionType) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->connectionType = $arg_connectionType;
       $response = $this->connection->__soapCall('IMachine_addStorageController', array((array)$request));
       
       return new IStorageController ($this->connection, $response->returnval);
  }

   public function getStorageControllerByName($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IMachine_getStorageControllerByName', array((array)$request));
       
       return new IStorageController ($this->connection, $response->returnval);
  }

   public function getStorageControllerByInstance($arg_instance) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->instance = $arg_instance;
       $response = $this->connection->__soapCall('IMachine_getStorageControllerByInstance', array((array)$request));
       
       return new IStorageController ($this->connection, $response->returnval);
  }

   public function removeStorageController($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IMachine_removeStorageController', array((array)$request));
       
       return ;
  }

   public function getSerialPort($arg_slot) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->slot = $arg_slot;
       $response = $this->connection->__soapCall('IMachine_getSerialPort', array((array)$request));
       
       return new ISerialPort ($this->connection, $response->returnval);
  }

   public function getParallelPort($arg_slot) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->slot = $arg_slot;
       $response = $this->connection->__soapCall('IMachine_getParallelPort', array((array)$request));
       
       return new IParallelPort ($this->connection, $response->returnval);
  }

   public function getExtraDataKeys() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMachine_getExtraDataKeys', array((array)$request));
       
       return (array)$response->returnval;
  }

   public function getExtraData($arg_key) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->key = $arg_key;
       $response = $this->connection->__soapCall('IMachine_getExtraData', array((array)$request));
       
       return (string)$response->returnval;
  }

   public function setExtraData($arg_key, $arg_value) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->key = $arg_key;
       $request->value = $arg_value;
       $response = $this->connection->__soapCall('IMachine_setExtraData', array((array)$request));
       
       return ;
  }

   public function getCPUProperty($arg_property) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->property = $arg_property;
       $response = $this->connection->__soapCall('IMachine_getCPUProperty', array((array)$request));
       
       return (bool)$response->returnval;
  }

   public function setCPUProperty($arg_property, $arg_value) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->property = $arg_property;
       $request->value = $arg_value;
       $response = $this->connection->__soapCall('IMachine_setCPUProperty', array((array)$request));
       
       return ;
  }

   public function getCPUIDLeaf($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IMachine_getCPUIDLeaf', array((array)$request));
       
       return array((float)$response->valEax, (float)$response->valEbx, (float)$response->valEcx, (float)$response->valEdx);
  }

   public function setCPUIDLeaf($arg_id, $arg_valEax, $arg_valEbx, $arg_valEcx, $arg_valEdx) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $request->valEax = $arg_valEax;
       $request->valEbx = $arg_valEbx;
       $request->valEcx = $arg_valEcx;
       $request->valEdx = $arg_valEdx;
       $response = $this->connection->__soapCall('IMachine_setCPUIDLeaf', array((array)$request));
       
       return ;
  }

   public function removeCPUIDLeaf($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IMachine_removeCPUIDLeaf', array((array)$request));
       
       return ;
  }

   public function removeAllCPUIDLeaves() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMachine_removeAllCPUIDLeaves', array((array)$request));
       
       return ;
  }

   public function getHWVirtExProperty($arg_property) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->property = $arg_property;
       $response = $this->connection->__soapCall('IMachine_getHWVirtExProperty', array((array)$request));
       
       return (bool)$response->returnval;
  }

   public function setHWVirtExProperty($arg_property, $arg_value) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->property = $arg_property;
       $request->value = $arg_value;
       $response = $this->connection->__soapCall('IMachine_setHWVirtExProperty', array((array)$request));
       
       return ;
  }

   public function saveSettings() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMachine_saveSettings', array((array)$request));
       
       return ;
  }

   public function discardSettings() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMachine_discardSettings', array((array)$request));
       
       return ;
  }

   public function deleteSettings() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMachine_deleteSettings', array((array)$request));
       
       return ;
  }

   public function export($arg_aAppliance) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->aAppliance = $arg_aAppliance;
       $response = $this->connection->__soapCall('IMachine_export', array((array)$request));
       
       return new IVirtualSystemDescription ($this->connection, $response->returnval);
  }

   public function getSnapshot($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IMachine_getSnapshot', array((array)$request));
       
       return new ISnapshot ($this->connection, $response->returnval);
  }

   public function findSnapshot($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IMachine_findSnapshot', array((array)$request));
       
       return new ISnapshot ($this->connection, $response->returnval);
  }

   public function setCurrentSnapshot($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IMachine_setCurrentSnapshot', array((array)$request));
       
       return ;
  }

   public function createSharedFolder($arg_name, $arg_hostPath, $arg_writable) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->hostPath = $arg_hostPath;
       $request->writable = $arg_writable;
       $response = $this->connection->__soapCall('IMachine_createSharedFolder', array((array)$request));
       
       return ;
  }

   public function removeSharedFolder($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IMachine_removeSharedFolder', array((array)$request));
       
       return ;
  }

   public function canShowConsoleWindow() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMachine_canShowConsoleWindow', array((array)$request));
       
       return (bool)$response->returnval;
  }

   public function showConsoleWindow() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMachine_showConsoleWindow', array((array)$request));
       
       return (float)$response->returnval;
  }

   public function getGuestProperty($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IMachine_getGuestProperty', array((array)$request));
       
       return array((string)$response->value, (float)$response->timestamp, (string)$response->flags);
  }

   public function getGuestPropertyValue($arg_property) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->property = $arg_property;
       $response = $this->connection->__soapCall('IMachine_getGuestPropertyValue', array((array)$request));
       
       return (string)$response->returnval;
  }

   public function getGuestPropertyTimestamp($arg_property) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->property = $arg_property;
       $response = $this->connection->__soapCall('IMachine_getGuestPropertyTimestamp', array((array)$request));
       
       return (float)$response->returnval;
  }

   public function setGuestProperty($arg_property, $arg_value, $arg_flags) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->property = $arg_property;
       $request->value = $arg_value;
       $request->flags = $arg_flags;
       $response = $this->connection->__soapCall('IMachine_setGuestProperty', array((array)$request));
       
       return ;
  }

   public function setGuestPropertyValue($arg_property, $arg_value) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->property = $arg_property;
       $request->value = $arg_value;
       $response = $this->connection->__soapCall('IMachine_setGuestPropertyValue', array((array)$request));
       
       return ;
  }

   public function enumerateGuestProperties($arg_patterns) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->patterns = $arg_patterns;
       $response = $this->connection->__soapCall('IMachine_enumerateGuestProperties', array((array)$request));
       
       return array((array)$response->name, (array)$response->value, (array)$response->timestamp, (array)$response->flags);
  }

   public function querySavedThumbnailSize($arg_screenId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->screenId = $arg_screenId;
       $response = $this->connection->__soapCall('IMachine_querySavedThumbnailSize', array((array)$request));
       
       return array((float)$response->size, (float)$response->width, (float)$response->height);
  }

   public function readSavedThumbnailToArray($arg_screenId, $arg_BGR) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->screenId = $arg_screenId;
       $request->BGR = $arg_BGR;
       $response = $this->connection->__soapCall('IMachine_readSavedThumbnailToArray', array((array)$request));
       
       return array((array)$response->returnval, (float)$response->width, (float)$response->height);
  }

   public function querySavedScreenshotPNGSize($arg_screenId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->screenId = $arg_screenId;
       $response = $this->connection->__soapCall('IMachine_querySavedScreenshotPNGSize', array((array)$request));
       
       return array((float)$response->size, (float)$response->width, (float)$response->height);
  }

   public function readSavedScreenshotPNGToArray($arg_screenId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->screenId = $arg_screenId;
       $response = $this->connection->__soapCall('IMachine_readSavedScreenshotPNGToArray', array((array)$request));
       
       return array((array)$response->returnval, (float)$response->width, (float)$response->height);
  }

   public function hotPlugCPU($arg_cpu) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->cpu = $arg_cpu;
       $response = $this->connection->__soapCall('IMachine_hotPlugCPU', array((array)$request));
       
       return ;
  }

   public function hotUnplugCPU($arg_cpu) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->cpu = $arg_cpu;
       $response = $this->connection->__soapCall('IMachine_hotUnplugCPU', array((array)$request));
       
       return ;
  }

   public function getCPUStatus($arg_cpu) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->cpu = $arg_cpu;
       $response = $this->connection->__soapCall('IMachine_getCPUStatus', array((array)$request));
       
       return (bool)$response->returnval;
  }

   public function queryLogFilename($arg_idx) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->idx = $arg_idx;
       $response = $this->connection->__soapCall('IMachine_queryLogFilename', array((array)$request));
       
       return (string)$response->returnval;
  }

   public function readLog($arg_idx, $arg_offset, $arg_size) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->idx = $arg_idx;
       $request->offset = $arg_offset;
       $request->size = $arg_size;
       $response = $this->connection->__soapCall('IMachine_readLog', array((array)$request));
       
       return (array)$response->returnval;
  }

   public function getParent() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getParent', array((array)$request));
       return new IVirtualBox ($this->connection, $response->returnval);
   }

   public function getAccessible() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getAccessible', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getAccessError() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getAccessError', array((array)$request));
       return new IVirtualBoxErrorInfo ($this->connection, $response->returnval);
   }

   public function getName() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getName', array((array)$request));
       return (string)$response->returnval;
   }

   public function setName($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->name = $value;
       }
       else
       {
            $request->name = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setName', array((array)$request));
   }

   public function getDescription() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getDescription', array((array)$request));
       return (string)$response->returnval;
   }

   public function setDescription($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->description = $value;
       }
       else
       {
            $request->description = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setDescription', array((array)$request));
   }

   public function getId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getId', array((array)$request));
       return (string)$response->returnval;
   }

   public function getOSTypeId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getOSTypeId', array((array)$request));
       return (string)$response->returnval;
   }

   public function setOSTypeId($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->OSTypeId = $value;
       }
       else
       {
            $request->OSTypeId = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setOSTypeId', array((array)$request));
   }

   public function getHardwareVersion() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getHardwareVersion', array((array)$request));
       return (string)$response->returnval;
   }

   public function setHardwareVersion($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->HardwareVersion = $value;
       }
       else
       {
            $request->HardwareVersion = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setHardwareVersion', array((array)$request));
   }

   public function getHardwareUUID() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getHardwareUUID', array((array)$request));
       return (string)$response->returnval;
   }

   public function setHardwareUUID($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->hardwareUUID = $value;
       }
       else
       {
            $request->hardwareUUID = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setHardwareUUID', array((array)$request));
   }

   public function getCPUCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getCPUCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function setCPUCount($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->CPUCount = $value;
       }
       else
       {
            $request->CPUCount = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setCPUCount', array((array)$request));
   }

   public function getCPUHotPlugEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getCPUHotPlugEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setCPUHotPlugEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->CPUHotPlugEnabled = $value;
       }
       else
       {
            $request->CPUHotPlugEnabled = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setCPUHotPlugEnabled', array((array)$request));
   }

   public function getMemorySize() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getMemorySize', array((array)$request));
       return (float)$response->returnval;
   }

   public function setMemorySize($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->memorySize = $value;
       }
       else
       {
            $request->memorySize = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setMemorySize', array((array)$request));
   }

   public function getMemoryBalloonSize() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getMemoryBalloonSize', array((array)$request));
       return (float)$response->returnval;
   }

   public function setMemoryBalloonSize($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->memoryBalloonSize = $value;
       }
       else
       {
            $request->memoryBalloonSize = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setMemoryBalloonSize', array((array)$request));
   }

   public function getPageFusionEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getPageFusionEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setPageFusionEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->PageFusionEnabled = $value;
       }
       else
       {
            $request->PageFusionEnabled = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setPageFusionEnabled', array((array)$request));
   }

   public function getVRAMSize() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getVRAMSize', array((array)$request));
       return (float)$response->returnval;
   }

   public function setVRAMSize($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->VRAMSize = $value;
       }
       else
       {
            $request->VRAMSize = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setVRAMSize', array((array)$request));
   }

   public function getAccelerate3DEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getAccelerate3DEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setAccelerate3DEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->accelerate3DEnabled = $value;
       }
       else
       {
            $request->accelerate3DEnabled = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setAccelerate3DEnabled', array((array)$request));
   }

   public function getAccelerate2DVideoEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getAccelerate2DVideoEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setAccelerate2DVideoEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->accelerate2DVideoEnabled = $value;
       }
       else
       {
            $request->accelerate2DVideoEnabled = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setAccelerate2DVideoEnabled', array((array)$request));
   }

   public function getMonitorCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getMonitorCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function setMonitorCount($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->monitorCount = $value;
       }
       else
       {
            $request->monitorCount = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setMonitorCount', array((array)$request));
   }

   public function getBIOSSettings() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getBIOSSettings', array((array)$request));
       return new IBIOSSettings ($this->connection, $response->returnval);
   }

   public function getFirmwareType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getFirmwareType', array((array)$request));
       return new FirmwareType ($this->connection, $response->returnval);
   }

   public function setFirmwareType($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->firmwareType = $value;
       }
       else
       {
            $request->firmwareType = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setFirmwareType', array((array)$request));
   }

   public function getPointingHidType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getPointingHidType', array((array)$request));
       return new PointingHidType ($this->connection, $response->returnval);
   }

   public function setPointingHidType($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->pointingHidType = $value;
       }
       else
       {
            $request->pointingHidType = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setPointingHidType', array((array)$request));
   }

   public function getKeyboardHidType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getKeyboardHidType', array((array)$request));
       return new KeyboardHidType ($this->connection, $response->returnval);
   }

   public function setKeyboardHidType($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->keyboardHidType = $value;
       }
       else
       {
            $request->keyboardHidType = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setKeyboardHidType', array((array)$request));
   }

   public function getHpetEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getHpetEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setHpetEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->hpetEnabled = $value;
       }
       else
       {
            $request->hpetEnabled = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setHpetEnabled', array((array)$request));
   }

   public function getSnapshotFolder() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getSnapshotFolder', array((array)$request));
       return (string)$response->returnval;
   }

   public function setSnapshotFolder($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->snapshotFolder = $value;
       }
       else
       {
            $request->snapshotFolder = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setSnapshotFolder', array((array)$request));
   }

   public function getVRDPServer() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getVRDPServer', array((array)$request));
       return new IVRDPServer ($this->connection, $response->returnval);
   }

   public function getMediumAttachments() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getMediumAttachments', array((array)$request));
       return new IMediumAttachmentCollection ($this->connection, (array)$response->returnval);
   }

   public function getUSBController() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getUSBController', array((array)$request));
       return new IUSBController ($this->connection, $response->returnval);
   }

   public function getAudioAdapter() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getAudioAdapter', array((array)$request));
       return new IAudioAdapter ($this->connection, $response->returnval);
   }

   public function getStorageControllers() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getStorageControllers', array((array)$request));
       return new IStorageControllerCollection ($this->connection, (array)$response->returnval);
   }

   public function getSettingsFilePath() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getSettingsFilePath', array((array)$request));
       return (string)$response->returnval;
   }

   public function getSettingsModified() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getSettingsModified', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getSessionState() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getSessionState', array((array)$request));
       return new SessionState ($this->connection, $response->returnval);
   }

   public function getSessionType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getSessionType', array((array)$request));
       return (string)$response->returnval;
   }

   public function getSessionPid() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getSessionPid', array((array)$request));
       return (float)$response->returnval;
   }

   public function getState() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getState', array((array)$request));
       return new MachineState ($this->connection, $response->returnval);
   }

   public function getLastStateChange() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getLastStateChange', array((array)$request));
       return (float)$response->returnval;
   }

   public function getStateFilePath() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getStateFilePath', array((array)$request));
       return (string)$response->returnval;
   }

   public function getLogFolder() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getLogFolder', array((array)$request));
       return (string)$response->returnval;
   }

   public function getCurrentSnapshot() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getCurrentSnapshot', array((array)$request));
       return new ISnapshot ($this->connection, $response->returnval);
   }

   public function getSnapshotCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getSnapshotCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getCurrentStateModified() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getCurrentStateModified', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getSharedFolders() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getSharedFolders', array((array)$request));
       return new ISharedFolderCollection ($this->connection, (array)$response->returnval);
   }

   public function getClipboardMode() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getClipboardMode', array((array)$request));
       return new ClipboardMode ($this->connection, $response->returnval);
   }

   public function setClipboardMode($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->clipboardMode = $value;
       }
       else
       {
            $request->clipboardMode = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setClipboardMode', array((array)$request));
   }

   public function getGuestPropertyNotificationPatterns() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getGuestPropertyNotificationPatterns', array((array)$request));
       return (string)$response->returnval;
   }

   public function setGuestPropertyNotificationPatterns($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->guestPropertyNotificationPatterns = $value;
       }
       else
       {
            $request->guestPropertyNotificationPatterns = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setGuestPropertyNotificationPatterns', array((array)$request));
   }

   public function getTeleporterEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getTeleporterEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setTeleporterEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->teleporterEnabled = $value;
       }
       else
       {
            $request->teleporterEnabled = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setTeleporterEnabled', array((array)$request));
   }

   public function getTeleporterPort() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getTeleporterPort', array((array)$request));
       return (float)$response->returnval;
   }

   public function setTeleporterPort($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->teleporterPort = $value;
       }
       else
       {
            $request->teleporterPort = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setTeleporterPort', array((array)$request));
   }

   public function getTeleporterAddress() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getTeleporterAddress', array((array)$request));
       return (string)$response->returnval;
   }

   public function setTeleporterAddress($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->teleporterAddress = $value;
       }
       else
       {
            $request->teleporterAddress = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setTeleporterAddress', array((array)$request));
   }

   public function getTeleporterPassword() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getTeleporterPassword', array((array)$request));
       return (string)$response->returnval;
   }

   public function setTeleporterPassword($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->teleporterPassword = $value;
       }
       else
       {
            $request->teleporterPassword = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setTeleporterPassword', array((array)$request));
   }

   public function getRTCUseUTC() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getRTCUseUTC', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setRTCUseUTC($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->RTCUseUTC = $value;
       }
       else
       {
            $request->RTCUseUTC = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setRTCUseUTC', array((array)$request));
   }

   public function getIoCacheEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getIoCacheEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setIoCacheEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->ioCacheEnabled = $value;
       }
       else
       {
            $request->ioCacheEnabled = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setIoCacheEnabled', array((array)$request));
   }

   public function getIoCacheSize() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getIoCacheSize', array((array)$request));
       return (float)$response->returnval;
   }

   public function setIoCacheSize($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->ioCacheSize = $value;
       }
       else
       {
            $request->ioCacheSize = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setIoCacheSize', array((array)$request));
   }

   public function getIoBandwidthMax() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMachine_getIoBandwidthMax', array((array)$request));
       return (float)$response->returnval;
   }

   public function setIoBandwidthMax($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->ioBandwidthMax = $value;
       }
       else
       {
            $request->ioBandwidthMax = $value->handle;
       }
       $this->connection->__soapCall('IMachine_setIoBandwidthMax', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IMachineCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IMachine";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IConsole extends VBox_ManagedObject {

   public function powerUp() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_powerUp', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function powerUpPaused() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_powerUpPaused', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function powerDown() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_powerDown', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function reset() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_reset', array((array)$request));
       
       return ;
  }

   public function pause() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_pause', array((array)$request));
       
       return ;
  }

   public function resume() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_resume', array((array)$request));
       
       return ;
  }

   public function powerButton() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_powerButton', array((array)$request));
       
       return ;
  }

   public function sleepButton() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_sleepButton', array((array)$request));
       
       return ;
  }

   public function getPowerButtonHandled() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_getPowerButtonHandled', array((array)$request));
       
       return (bool)$response->returnval;
  }

   public function getGuestEnteredACPIMode() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_getGuestEnteredACPIMode', array((array)$request));
       
       return (bool)$response->returnval;
  }

   public function saveState() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IConsole_saveState', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function adoptSavedState($arg_savedStateFile) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->savedStateFile = $arg_savedStateFile;
       $response = $this->connection->__soapCall('IConsole_adoptSavedState', array((array)$request));
       
       return ;
  }

   public function forgetSavedState($arg_remove) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->remove = $arg_remove;
       $response = $this->connection->__soapCall('IConsole_forgetSavedState', array((array)$request));
       
       return ;
  }

   public function getDeviceActivity($arg_type) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->type = $arg_type;
       $response = $this->connection->__soapCall('IConsole_getDeviceActivity', array((array)$request));
       
       return new DeviceActivity ($this->connection, $response->returnval);
  }

   public function attachUSBDevice($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IConsole_attachUSBDevice', array((array)$request));
       
       return ;
  }

   public function detachUSBDevice($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IConsole_detachUSBDevice', array((array)$request));
       
       return new IUSBDevice ($this->connection, $response->returnval);
  }

   public function findUSBDeviceByAddress($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IConsole_findUSBDeviceByAddress', array((array)$request));
       
       return new IUSBDevice ($this->connection, $response->returnval);
  }

   public function findUSBDeviceById($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IConsole_findUSBDeviceById', array((array)$request));
       
       return new IUSBDevice ($this->connection, $response->returnval);
  }

   public function createSharedFolder($arg_name, $arg_hostPath, $arg_writable) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->hostPath = $arg_hostPath;
       $request->writable = $arg_writable;
       $response = $this->connection->__soapCall('IConsole_createSharedFolder', array((array)$request));
       
       return ;
  }

   public function removeSharedFolder($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IConsole_removeSharedFolder', array((array)$request));
       
       return ;
  }

   public function takeSnapshot($arg_name, $arg_description) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->description = $arg_description;
       $response = $this->connection->__soapCall('IConsole_takeSnapshot', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function deleteSnapshot($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IConsole_deleteSnapshot', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function restoreSnapshot($arg_snapshot) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->snapshot = $arg_snapshot;
       $response = $this->connection->__soapCall('IConsole_restoreSnapshot', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function teleport($arg_hostname, $arg_tcpport, $arg_password, $arg_maxDowntime) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->hostname = $arg_hostname;
       $request->tcpport = $arg_tcpport;
       $request->password = $arg_password;
       $request->maxDowntime = $arg_maxDowntime;
       $response = $this->connection->__soapCall('IConsole_teleport', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function getMachine() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IConsole_getMachine', array((array)$request));
       return new IMachine ($this->connection, $response->returnval);
   }

   public function getState() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IConsole_getState', array((array)$request));
       return new MachineState ($this->connection, $response->returnval);
   }

   public function getGuest() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IConsole_getGuest', array((array)$request));
       return new IGuest ($this->connection, $response->returnval);
   }

   public function getKeyboard() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IConsole_getKeyboard', array((array)$request));
       return new IKeyboard ($this->connection, $response->returnval);
   }

   public function getMouse() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IConsole_getMouse', array((array)$request));
       return new IMouse ($this->connection, $response->returnval);
   }

   public function getDisplay() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IConsole_getDisplay', array((array)$request));
       return new IDisplay ($this->connection, $response->returnval);
   }

   public function getUSBDevices() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IConsole_getUSBDevices', array((array)$request));
       return new IUSBDeviceCollection ($this->connection, (array)$response->returnval);
   }

   public function getRemoteUSBDevices() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IConsole_getRemoteUSBDevices', array((array)$request));
       return new IHostUSBDeviceCollection ($this->connection, (array)$response->returnval);
   }

   public function getSharedFolders() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IConsole_getSharedFolders', array((array)$request));
       return new ISharedFolderCollection ($this->connection, (array)$response->returnval);
   }

   public function getRemoteDisplayInfo() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IConsole_getRemoteDisplayInfo', array((array)$request));
       return new IRemoteDisplayInfo ($this->connection, $response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IConsoleCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IConsole";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IHostNetworkInterface extends VBox_ManagedObject {

   public function enableStaticIpConfig($arg_IPAddress, $arg_networkMask) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->IPAddress = $arg_IPAddress;
       $request->networkMask = $arg_networkMask;
       $response = $this->connection->__soapCall('IHostNetworkInterface_enableStaticIpConfig', array((array)$request));
       
       return ;
  }

   public function enableStaticIpConfigV6($arg_IPV6Address, $arg_IPV6NetworkMaskPrefixLength) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->IPV6Address = $arg_IPV6Address;
       $request->IPV6NetworkMaskPrefixLength = $arg_IPV6NetworkMaskPrefixLength;
       $response = $this->connection->__soapCall('IHostNetworkInterface_enableStaticIpConfigV6', array((array)$request));
       
       return ;
  }

   public function enableDynamicIpConfig() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IHostNetworkInterface_enableDynamicIpConfig', array((array)$request));
       
       return ;
  }

   public function dhcpRediscover() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IHostNetworkInterface_dhcpRediscover', array((array)$request));
       
       return ;
  }

   public function getName() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getName', array((array)$request));
       return (string)$response->returnval;
   }

   public function getId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getId', array((array)$request));
       return (string)$response->returnval;
   }

   public function getNetworkName() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getNetworkName', array((array)$request));
       return (string)$response->returnval;
   }

   public function getDhcpEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getDhcpEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getIPAddress() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getIPAddress', array((array)$request));
       return (string)$response->returnval;
   }

   public function getNetworkMask() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getNetworkMask', array((array)$request));
       return (string)$response->returnval;
   }

   public function getIPV6Supported() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getIPV6Supported', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getIPV6Address() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getIPV6Address', array((array)$request));
       return (string)$response->returnval;
   }

   public function getIPV6NetworkMaskPrefixLength() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getIPV6NetworkMaskPrefixLength', array((array)$request));
       return (float)$response->returnval;
   }

   public function getHardwareAddress() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getHardwareAddress', array((array)$request));
       return (string)$response->returnval;
   }

   public function getMediumType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getMediumType', array((array)$request));
       return new HostNetworkInterfaceMediumType ($this->connection, $response->returnval);
   }

   public function getStatus() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getStatus', array((array)$request));
       return new HostNetworkInterfaceStatus ($this->connection, $response->returnval);
   }

   public function getInterfaceType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostNetworkInterface_getInterfaceType', array((array)$request));
       return new HostNetworkInterfaceType ($this->connection, $response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IHostNetworkInterfaceCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IHostNetworkInterface";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IHost extends VBox_ManagedObject {

   public function getProcessorSpeed($arg_cpuId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->cpuId = $arg_cpuId;
       $response = $this->connection->__soapCall('IHost_getProcessorSpeed', array((array)$request));
       
       return (float)$response->returnval;
  }

   public function getProcessorFeature($arg_feature) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->feature = $arg_feature;
       $response = $this->connection->__soapCall('IHost_getProcessorFeature', array((array)$request));
       
       return (bool)$response->returnval;
  }

   public function getProcessorDescription($arg_cpuId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->cpuId = $arg_cpuId;
       $response = $this->connection->__soapCall('IHost_getProcessorDescription', array((array)$request));
       
       return (string)$response->returnval;
  }

   public function getProcessorCPUIDLeaf($arg_cpuId, $arg_leaf, $arg_subLeaf) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->cpuId = $arg_cpuId;
       $request->leaf = $arg_leaf;
       $request->subLeaf = $arg_subLeaf;
       $response = $this->connection->__soapCall('IHost_getProcessorCPUIDLeaf', array((array)$request));
       
       return array((float)$response->valEax, (float)$response->valEbx, (float)$response->valEcx, (float)$response->valEdx);
  }

   public function createHostOnlyNetworkInterface() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IHost_createHostOnlyNetworkInterface', array((array)$request));
       
       return array(new IProgress ($this->connection, $response->returnval), new IHostNetworkInterface ($this->connection, $response->hostInterface));
  }

   public function removeHostOnlyNetworkInterface($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IHost_removeHostOnlyNetworkInterface', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function createUSBDeviceFilter($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IHost_createUSBDeviceFilter', array((array)$request));
       
       return new IHostUSBDeviceFilter ($this->connection, $response->returnval);
  }

   public function insertUSBDeviceFilter($arg_position, $arg_filter) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->position = $arg_position;
       $request->filter = $arg_filter;
       $response = $this->connection->__soapCall('IHost_insertUSBDeviceFilter', array((array)$request));
       
       return ;
  }

   public function removeUSBDeviceFilter($arg_position) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->position = $arg_position;
       $response = $this->connection->__soapCall('IHost_removeUSBDeviceFilter', array((array)$request));
       
       return ;
  }

   public function findHostDVDDrive($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IHost_findHostDVDDrive', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function findHostFloppyDrive($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IHost_findHostFloppyDrive', array((array)$request));
       
       return new IMedium ($this->connection, $response->returnval);
  }

   public function findHostNetworkInterfaceByName($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IHost_findHostNetworkInterfaceByName', array((array)$request));
       
       return new IHostNetworkInterface ($this->connection, $response->returnval);
  }

   public function findHostNetworkInterfaceById($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IHost_findHostNetworkInterfaceById', array((array)$request));
       
       return new IHostNetworkInterface ($this->connection, $response->returnval);
  }

   public function findHostNetworkInterfacesOfType($arg_type) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->type = $arg_type;
       $response = $this->connection->__soapCall('IHost_findHostNetworkInterfacesOfType', array((array)$request));
       
       return new IHostNetworkInterfaceCollection ($this->connection, (array)$response->returnval);
  }

   public function findUSBDeviceById($arg_id) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->id = $arg_id;
       $response = $this->connection->__soapCall('IHost_findUSBDeviceById', array((array)$request));
       
       return new IHostUSBDevice ($this->connection, $response->returnval);
  }

   public function findUSBDeviceByAddress($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IHost_findUSBDeviceByAddress', array((array)$request));
       
       return new IHostUSBDevice ($this->connection, $response->returnval);
  }

   public function getDVDDrives() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getDVDDrives', array((array)$request));
       return new IMediumCollection ($this->connection, (array)$response->returnval);
   }

   public function getFloppyDrives() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getFloppyDrives', array((array)$request));
       return new IMediumCollection ($this->connection, (array)$response->returnval);
   }

   public function getUSBDevices() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getUSBDevices', array((array)$request));
       return new IHostUSBDeviceCollection ($this->connection, (array)$response->returnval);
   }

   public function getUSBDeviceFilters() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getUSBDeviceFilters', array((array)$request));
       return new IHostUSBDeviceFilterCollection ($this->connection, (array)$response->returnval);
   }

   public function getNetworkInterfaces() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getNetworkInterfaces', array((array)$request));
       return new IHostNetworkInterfaceCollection ($this->connection, (array)$response->returnval);
   }

   public function getProcessorCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getProcessorCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getProcessorOnlineCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getProcessorOnlineCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getProcessorCoreCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getProcessorCoreCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMemorySize() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getMemorySize', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMemoryAvailable() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getMemoryAvailable', array((array)$request));
       return (float)$response->returnval;
   }

   public function getOperatingSystem() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getOperatingSystem', array((array)$request));
       return (string)$response->returnval;
   }

   public function getOSVersion() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getOSVersion', array((array)$request));
       return (string)$response->returnval;
   }

   public function getUTCTime() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getUTCTime', array((array)$request));
       return (float)$response->returnval;
   }

   public function getAcceleration3DAvailable() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHost_getAcceleration3DAvailable', array((array)$request));
       return (bool)$response->returnval;
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IHostCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IHost";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class ISystemProperties extends VBox_ManagedObject {

   public function getMaxDevicesPerPortForStorageBus($arg_bus) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->bus = $arg_bus;
       $response = $this->connection->__soapCall('ISystemProperties_getMaxDevicesPerPortForStorageBus', array((array)$request));
       
       return (float)$response->returnval;
  }

   public function getMinPortCountForStorageBus($arg_bus) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->bus = $arg_bus;
       $response = $this->connection->__soapCall('ISystemProperties_getMinPortCountForStorageBus', array((array)$request));
       
       return (float)$response->returnval;
  }

   public function getMaxPortCountForStorageBus($arg_bus) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->bus = $arg_bus;
       $response = $this->connection->__soapCall('ISystemProperties_getMaxPortCountForStorageBus', array((array)$request));
       
       return (float)$response->returnval;
  }

   public function getMaxInstancesOfStorageBus($arg_bus) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->bus = $arg_bus;
       $response = $this->connection->__soapCall('ISystemProperties_getMaxInstancesOfStorageBus', array((array)$request));
       
       return (float)$response->returnval;
  }

   public function getDeviceTypesForStorageBus($arg_bus) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->bus = $arg_bus;
       $response = $this->connection->__soapCall('ISystemProperties_getDeviceTypesForStorageBus', array((array)$request));
       
       return new DeviceTypeCollection ($this->connection, (array)$response->returnval);
  }

   public function getMinGuestRAM() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getMinGuestRAM', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMaxGuestRAM() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getMaxGuestRAM', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMinGuestVRAM() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getMinGuestVRAM', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMaxGuestVRAM() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getMaxGuestVRAM', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMinGuestCPUCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getMinGuestCPUCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMaxGuestCPUCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getMaxGuestCPUCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMaxGuestMonitors() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getMaxGuestMonitors', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMaxVDISize() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getMaxVDISize', array((array)$request));
       return (float)$response->returnval;
   }

   public function getNetworkAdapterCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getNetworkAdapterCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getSerialPortCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getSerialPortCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getParallelPortCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getParallelPortCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMaxBootPosition() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getMaxBootPosition', array((array)$request));
       return (float)$response->returnval;
   }

   public function getDefaultMachineFolder() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getDefaultMachineFolder', array((array)$request));
       return (string)$response->returnval;
   }

   public function setDefaultMachineFolder($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->defaultMachineFolder = $value;
       }
       else
       {
            $request->defaultMachineFolder = $value->handle;
       }
       $this->connection->__soapCall('ISystemProperties_setDefaultMachineFolder', array((array)$request));
   }

   public function getDefaultHardDiskFolder() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getDefaultHardDiskFolder', array((array)$request));
       return (string)$response->returnval;
   }

   public function setDefaultHardDiskFolder($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->defaultHardDiskFolder = $value;
       }
       else
       {
            $request->defaultHardDiskFolder = $value->handle;
       }
       $this->connection->__soapCall('ISystemProperties_setDefaultHardDiskFolder', array((array)$request));
   }

   public function getMediumFormats() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getMediumFormats', array((array)$request));
       return new IMediumFormatCollection ($this->connection, (array)$response->returnval);
   }

   public function getDefaultHardDiskFormat() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getDefaultHardDiskFormat', array((array)$request));
       return (string)$response->returnval;
   }

   public function setDefaultHardDiskFormat($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->defaultHardDiskFormat = $value;
       }
       else
       {
            $request->defaultHardDiskFormat = $value->handle;
       }
       $this->connection->__soapCall('ISystemProperties_setDefaultHardDiskFormat', array((array)$request));
   }

   public function getFreeDiskSpaceWarning() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getFreeDiskSpaceWarning', array((array)$request));
       return (float)$response->returnval;
   }

   public function setFreeDiskSpaceWarning($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->freeDiskSpaceWarning = $value;
       }
       else
       {
            $request->freeDiskSpaceWarning = $value->handle;
       }
       $this->connection->__soapCall('ISystemProperties_setFreeDiskSpaceWarning', array((array)$request));
   }

   public function getFreeDiskSpacePercentWarning() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getFreeDiskSpacePercentWarning', array((array)$request));
       return (float)$response->returnval;
   }

   public function setFreeDiskSpacePercentWarning($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->freeDiskSpacePercentWarning = $value;
       }
       else
       {
            $request->freeDiskSpacePercentWarning = $value->handle;
       }
       $this->connection->__soapCall('ISystemProperties_setFreeDiskSpacePercentWarning', array((array)$request));
   }

   public function getFreeDiskSpaceError() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getFreeDiskSpaceError', array((array)$request));
       return (float)$response->returnval;
   }

   public function setFreeDiskSpaceError($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->freeDiskSpaceError = $value;
       }
       else
       {
            $request->freeDiskSpaceError = $value->handle;
       }
       $this->connection->__soapCall('ISystemProperties_setFreeDiskSpaceError', array((array)$request));
   }

   public function getFreeDiskSpacePercentError() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getFreeDiskSpacePercentError', array((array)$request));
       return (float)$response->returnval;
   }

   public function setFreeDiskSpacePercentError($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->freeDiskSpacePercentError = $value;
       }
       else
       {
            $request->freeDiskSpacePercentError = $value->handle;
       }
       $this->connection->__soapCall('ISystemProperties_setFreeDiskSpacePercentError', array((array)$request));
   }

   public function getRemoteDisplayAuthLibrary() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getRemoteDisplayAuthLibrary', array((array)$request));
       return (string)$response->returnval;
   }

   public function setRemoteDisplayAuthLibrary($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->remoteDisplayAuthLibrary = $value;
       }
       else
       {
            $request->remoteDisplayAuthLibrary = $value->handle;
       }
       $this->connection->__soapCall('ISystemProperties_setRemoteDisplayAuthLibrary', array((array)$request));
   }

   public function getWebServiceAuthLibrary() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getWebServiceAuthLibrary', array((array)$request));
       return (string)$response->returnval;
   }

   public function setWebServiceAuthLibrary($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->webServiceAuthLibrary = $value;
       }
       else
       {
            $request->webServiceAuthLibrary = $value->handle;
       }
       $this->connection->__soapCall('ISystemProperties_setWebServiceAuthLibrary', array((array)$request));
   }

   public function getLogHistoryCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getLogHistoryCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function setLogHistoryCount($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->LogHistoryCount = $value;
       }
       else
       {
            $request->LogHistoryCount = $value->handle;
       }
       $this->connection->__soapCall('ISystemProperties_setLogHistoryCount', array((array)$request));
   }

   public function getDefaultAudioDriver() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISystemProperties_getDefaultAudioDriver', array((array)$request));
       return new AudioDriverType ($this->connection, $response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class ISystemPropertiesCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "ISystemProperties";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IGuest extends VBox_ManagedObject {

   public function internalGetStatistics() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IGuest_internalGetStatistics', array((array)$request));
       
       return array((float)$response->cpuUser, (float)$response->cpuKernel, (float)$response->cpuIdle, (float)$response->memTotal, (float)$response->memFree, (float)$response->memBalloon, (float)$response->memShared, (float)$response->memCache, (float)$response->pagedTotal, (float)$response->memAllocTotal, (float)$response->memFreeTotal, (float)$response->memBalloonTotal, (float)$response->memSharedTotal);
  }

   public function setCredentials($arg_userName, $arg_password, $arg_domain, $arg_allowInteractiveLogon) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->userName = $arg_userName;
       $request->password = $arg_password;
       $request->domain = $arg_domain;
       $request->allowInteractiveLogon = $arg_allowInteractiveLogon;
       $response = $this->connection->__soapCall('IGuest_setCredentials', array((array)$request));
       
       return ;
  }

   public function executeProcess($arg_execName, $arg_flags, $arg_arguments, $arg_environment, $arg_userName, $arg_password, $arg_timeoutMS) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->execName = $arg_execName;
       $request->flags = $arg_flags;
       $request->arguments = $arg_arguments;
       $request->environment = $arg_environment;
       $request->userName = $arg_userName;
       $request->password = $arg_password;
       $request->timeoutMS = $arg_timeoutMS;
       $response = $this->connection->__soapCall('IGuest_executeProcess', array((array)$request));
       
       return array(new IProgress ($this->connection, $response->returnval), (float)$response->pid);
  }

   public function getProcessOutput($arg_pid, $arg_flags, $arg_timeoutMS, $arg_size) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->pid = $arg_pid;
       $request->flags = $arg_flags;
       $request->timeoutMS = $arg_timeoutMS;
       $request->size = $arg_size;
       $response = $this->connection->__soapCall('IGuest_getProcessOutput', array((array)$request));
       
       return (array)$response->returnval;
  }

   public function getProcessStatus($arg_pid) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->pid = $arg_pid;
       $response = $this->connection->__soapCall('IGuest_getProcessStatus', array((array)$request));
       
       return array((float)$response->returnval, (float)$response->exitcode, (float)$response->flags);
  }

   public function getOSTypeId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IGuest_getOSTypeId', array((array)$request));
       return (string)$response->returnval;
   }

   public function getAdditionsActive() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IGuest_getAdditionsActive', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getAdditionsVersion() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IGuest_getAdditionsVersion', array((array)$request));
       return (string)$response->returnval;
   }

   public function getSupportsSeamless() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IGuest_getSupportsSeamless', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getSupportsGraphics() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IGuest_getSupportsGraphics', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getMemoryBalloonSize() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IGuest_getMemoryBalloonSize', array((array)$request));
       return (float)$response->returnval;
   }

   public function setMemoryBalloonSize($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->memoryBalloonSize = $value;
       }
       else
       {
            $request->memoryBalloonSize = $value->handle;
       }
       $this->connection->__soapCall('IGuest_setMemoryBalloonSize', array((array)$request));
   }

   public function getPageFusionEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IGuest_getPageFusionEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setPageFusionEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->pageFusionEnabled = $value;
       }
       else
       {
            $request->pageFusionEnabled = $value->handle;
       }
       $this->connection->__soapCall('IGuest_setPageFusionEnabled', array((array)$request));
   }

   public function getStatisticsUpdateInterval() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IGuest_getStatisticsUpdateInterval', array((array)$request));
       return (float)$response->returnval;
   }

   public function setStatisticsUpdateInterval($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->statisticsUpdateInterval = $value;
       }
       else
       {
            $request->statisticsUpdateInterval = $value->handle;
       }
       $this->connection->__soapCall('IGuest_setStatisticsUpdateInterval', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IGuestCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IGuest";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IProgress extends VBox_ManagedObject {

   public function setCurrentOperationProgress($arg_percent) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->percent = $arg_percent;
       $response = $this->connection->__soapCall('IProgress_setCurrentOperationProgress', array((array)$request));
       
       return ;
  }

   public function setNextOperation($arg_nextOperationDescription, $arg_nextOperationsWeight) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->nextOperationDescription = $arg_nextOperationDescription;
       $request->nextOperationsWeight = $arg_nextOperationsWeight;
       $response = $this->connection->__soapCall('IProgress_setNextOperation', array((array)$request));
       
       return ;
  }

   public function waitForCompletion($arg_timeout) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->timeout = $arg_timeout;
       $response = $this->connection->__soapCall('IProgress_waitForCompletion', array((array)$request));
       
       return ;
  }

   public function waitForOperationCompletion($arg_operation, $arg_timeout) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->operation = $arg_operation;
       $request->timeout = $arg_timeout;
       $response = $this->connection->__soapCall('IProgress_waitForOperationCompletion', array((array)$request));
       
       return ;
  }

   public function cancel() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IProgress_cancel', array((array)$request));
       
       return ;
  }

   public function getId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getId', array((array)$request));
       return (string)$response->returnval;
   }

   public function getDescription() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getDescription', array((array)$request));
       return (string)$response->returnval;
   }

   public function getInitiator() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getInitiator', array((array)$request));
       return new VBox_ManagedObject ($this->connection, $response->returnval);
   }

   public function getCancelable() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getCancelable', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getPercent() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getPercent', array((array)$request));
       return (float)$response->returnval;
   }

   public function getTimeRemaining() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getTimeRemaining', array((array)$request));
       return (int)$response->returnval;
   }

   public function getCompleted() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getCompleted', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getCanceled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getCanceled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getResultCode() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getResultCode', array((array)$request));
       return (int)$response->returnval;
   }

   public function getErrorInfo() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getErrorInfo', array((array)$request));
       return new IVirtualBoxErrorInfo ($this->connection, $response->returnval);
   }

   public function getOperationCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getOperationCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getOperation() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getOperation', array((array)$request));
       return (float)$response->returnval;
   }

   public function getOperationDescription() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getOperationDescription', array((array)$request));
       return (string)$response->returnval;
   }

   public function getOperationPercent() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getOperationPercent', array((array)$request));
       return (float)$response->returnval;
   }

   public function getTimeout() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IProgress_getTimeout', array((array)$request));
       return (float)$response->returnval;
   }

   public function setTimeout($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->timeout = $value;
       }
       else
       {
            $request->timeout = $value->handle;
       }
       $this->connection->__soapCall('IProgress_setTimeout', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IProgressCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IProgress";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class ISnapshot extends VBox_ManagedObject {

   public function getId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISnapshot_getId', array((array)$request));
       return (string)$response->returnval;
   }

   public function getName() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISnapshot_getName', array((array)$request));
       return (string)$response->returnval;
   }

   public function setName($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->name = $value;
       }
       else
       {
            $request->name = $value->handle;
       }
       $this->connection->__soapCall('ISnapshot_setName', array((array)$request));
   }

   public function getDescription() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISnapshot_getDescription', array((array)$request));
       return (string)$response->returnval;
   }

   public function setDescription($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->description = $value;
       }
       else
       {
            $request->description = $value->handle;
       }
       $this->connection->__soapCall('ISnapshot_setDescription', array((array)$request));
   }

   public function getTimeStamp() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISnapshot_getTimeStamp', array((array)$request));
       return (float)$response->returnval;
   }

   public function getOnline() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISnapshot_getOnline', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getMachine() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISnapshot_getMachine', array((array)$request));
       return new IMachine ($this->connection, $response->returnval);
   }

   public function getParent() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISnapshot_getParent', array((array)$request));
       return new ISnapshot ($this->connection, $response->returnval);
   }

   public function getChildren() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISnapshot_getChildren', array((array)$request));
       return new ISnapshotCollection ($this->connection, (array)$response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class ISnapshotCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "ISnapshot";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IMedium extends VBox_ManagedObject {

   public function refreshState() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMedium_refreshState', array((array)$request));
       
       return new MediumState ($this->connection, $response->returnval);
  }

   public function getSnapshotIds($arg_machineId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->machineId = $arg_machineId;
       $response = $this->connection->__soapCall('IMedium_getSnapshotIds', array((array)$request));
       
       return (array)$response->returnval;
  }

   public function lockRead() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMedium_lockRead', array((array)$request));
       
       return new MediumState ($this->connection, $response->returnval);
  }

   public function unlockRead() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMedium_unlockRead', array((array)$request));
       
       return new MediumState ($this->connection, $response->returnval);
  }

   public function lockWrite() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMedium_lockWrite', array((array)$request));
       
       return new MediumState ($this->connection, $response->returnval);
  }

   public function unlockWrite() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMedium_unlockWrite', array((array)$request));
       
       return new MediumState ($this->connection, $response->returnval);
  }

   public function close() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMedium_close', array((array)$request));
       
       return ;
  }

   public function getProperty($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IMedium_getProperty', array((array)$request));
       
       return (string)$response->returnval;
  }

   public function setProperty($arg_name, $arg_value) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->value = $arg_value;
       $response = $this->connection->__soapCall('IMedium_setProperty', array((array)$request));
       
       return ;
  }

   public function getProperties($arg_names) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->names = $arg_names;
       $response = $this->connection->__soapCall('IMedium_getProperties', array((array)$request));
       
       return array((array)$response->returnval, (array)$response->returnNames);
  }

   public function setProperties($arg_names, $arg_values) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->names = $arg_names;
       $request->values = $arg_values;
       $response = $this->connection->__soapCall('IMedium_setProperties', array((array)$request));
       
       return ;
  }

   public function createBaseStorage($arg_logicalSize, $arg_variant) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->logicalSize = $arg_logicalSize;
       $request->variant = $arg_variant;
       $response = $this->connection->__soapCall('IMedium_createBaseStorage', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function deleteStorage() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMedium_deleteStorage', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function createDiffStorage($arg_target, $arg_variant) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->target = $arg_target;
       $request->variant = $arg_variant;
       $response = $this->connection->__soapCall('IMedium_createDiffStorage', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function mergeTo($arg_target) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->target = $arg_target;
       $response = $this->connection->__soapCall('IMedium_mergeTo', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function cloneTo($arg_target, $arg_variant, $arg_parent) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->target = $arg_target;
       $request->variant = $arg_variant;
       $request->parent = $arg_parent;
       $response = $this->connection->__soapCall('IMedium_cloneTo', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function compact() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMedium_compact', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function resize($arg_logicalSize) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->logicalSize = $arg_logicalSize;
       $response = $this->connection->__soapCall('IMedium_resize', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function reset() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMedium_reset', array((array)$request));
       
       return new IProgress ($this->connection, $response->returnval);
  }

   public function getId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getId', array((array)$request));
       return (string)$response->returnval;
   }

   public function getDescription() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getDescription', array((array)$request));
       return (string)$response->returnval;
   }

   public function setDescription($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->description = $value;
       }
       else
       {
            $request->description = $value->handle;
       }
       $this->connection->__soapCall('IMedium_setDescription', array((array)$request));
   }

   public function getState() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getState', array((array)$request));
       return new MediumState ($this->connection, $response->returnval);
   }

   public function getLocation() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getLocation', array((array)$request));
       return (string)$response->returnval;
   }

   public function setLocation($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->location = $value;
       }
       else
       {
            $request->location = $value->handle;
       }
       $this->connection->__soapCall('IMedium_setLocation', array((array)$request));
   }

   public function getName() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getName', array((array)$request));
       return (string)$response->returnval;
   }

   public function getDeviceType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getDeviceType', array((array)$request));
       return new DeviceType ($this->connection, $response->returnval);
   }

   public function getHostDrive() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getHostDrive', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getSize() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getSize', array((array)$request));
       return (float)$response->returnval;
   }

   public function getFormat() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getFormat', array((array)$request));
       return (string)$response->returnval;
   }

   public function getMediumFormat() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getMediumFormat', array((array)$request));
       return new IMediumFormat ($this->connection, $response->returnval);
   }

   public function getType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getType', array((array)$request));
       return new MediumType ($this->connection, $response->returnval);
   }

   public function setType($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->type = $value;
       }
       else
       {
            $request->type = $value->handle;
       }
       $this->connection->__soapCall('IMedium_setType', array((array)$request));
   }

   public function getParent() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getParent', array((array)$request));
       return new IMedium ($this->connection, $response->returnval);
   }

   public function getChildren() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getChildren', array((array)$request));
       return new IMediumCollection ($this->connection, (array)$response->returnval);
   }

   public function getBase() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getBase', array((array)$request));
       return new IMedium ($this->connection, $response->returnval);
   }

   public function getReadOnly() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getReadOnly', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getLogicalSize() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getLogicalSize', array((array)$request));
       return (float)$response->returnval;
   }

   public function getAutoReset() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getAutoReset', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setAutoReset($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->autoReset = $value;
       }
       else
       {
            $request->autoReset = $value->handle;
       }
       $this->connection->__soapCall('IMedium_setAutoReset', array((array)$request));
   }

   public function getLastAccessError() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getLastAccessError', array((array)$request));
       return (string)$response->returnval;
   }

   public function getMachineIds() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMedium_getMachineIds', array((array)$request));
       return (array)$response->returnval;
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IMediumCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IMedium";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IMediumFormat extends VBox_ManagedObject {

   public function describeProperties() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IMediumFormat_describeProperties', array((array)$request));
       
       return array((array)$response->names, (array)$response->description, new DataTypeCollection ($this->connection, (array)$response->types), (array)$response->flags, (array)$response->defaults);
  }

   public function getId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMediumFormat_getId', array((array)$request));
       return (string)$response->returnval;
   }

   public function getName() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMediumFormat_getName', array((array)$request));
       return (string)$response->returnval;
   }

   public function getFileExtensions() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMediumFormat_getFileExtensions', array((array)$request));
       return (array)$response->returnval;
   }

   public function getCapabilities() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMediumFormat_getCapabilities', array((array)$request));
       return (float)$response->returnval;
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IMediumFormatCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IMediumFormat";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IKeyboard extends VBox_ManagedObject {

   public function putScancode($arg_scancode) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->scancode = $arg_scancode;
       $response = $this->connection->__soapCall('IKeyboard_putScancode', array((array)$request));
       
       return ;
  }

   public function putScancodes($arg_scancodes) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->scancodes = $arg_scancodes;
       $response = $this->connection->__soapCall('IKeyboard_putScancodes', array((array)$request));
       
       return (float)$response->returnval;
  }

   public function putCAD() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IKeyboard_putCAD', array((array)$request));
       
       return ;
  }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IKeyboardCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IKeyboard";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IMouse extends VBox_ManagedObject {

   public function putMouseEvent($arg_dx, $arg_dy, $arg_dz, $arg_dw, $arg_buttonState) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->dx = $arg_dx;
       $request->dy = $arg_dy;
       $request->dz = $arg_dz;
       $request->dw = $arg_dw;
       $request->buttonState = $arg_buttonState;
       $response = $this->connection->__soapCall('IMouse_putMouseEvent', array((array)$request));
       
       return ;
  }

   public function putMouseEventAbsolute($arg_x, $arg_y, $arg_dz, $arg_dw, $arg_buttonState) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->x = $arg_x;
       $request->y = $arg_y;
       $request->dz = $arg_dz;
       $request->dw = $arg_dw;
       $request->buttonState = $arg_buttonState;
       $response = $this->connection->__soapCall('IMouse_putMouseEventAbsolute', array((array)$request));
       
       return ;
  }

   public function getAbsoluteSupported() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMouse_getAbsoluteSupported', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getRelativeSupported() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMouse_getRelativeSupported', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getNeedsHostCursor() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IMouse_getNeedsHostCursor', array((array)$request));
       return (bool)$response->returnval;
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IMouseCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IMouse";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IDisplay extends VBox_ManagedObject {

   public function getScreenResolution($arg_screenId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->screenId = $arg_screenId;
       $response = $this->connection->__soapCall('IDisplay_getScreenResolution', array((array)$request));
       
       return array((float)$response->width, (float)$response->height, (float)$response->bitsPerPixel);
  }

   public function setVideoModeHint($arg_width, $arg_height, $arg_bitsPerPixel, $arg_display) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->width = $arg_width;
       $request->height = $arg_height;
       $request->bitsPerPixel = $arg_bitsPerPixel;
       $request->display = $arg_display;
       $response = $this->connection->__soapCall('IDisplay_setVideoModeHint', array((array)$request));
       
       return ;
  }

   public function setSeamlessMode($arg_enabled) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->enabled = $arg_enabled;
       $response = $this->connection->__soapCall('IDisplay_setSeamlessMode', array((array)$request));
       
       return ;
  }

   public function takeScreenShotToArray($arg_screenId, $arg_width, $arg_height) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->screenId = $arg_screenId;
       $request->width = $arg_width;
       $request->height = $arg_height;
       $response = $this->connection->__soapCall('IDisplay_takeScreenShotToArray', array((array)$request));
       
       return (array)$response->returnval;
  }

   public function invalidateAndUpdate() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IDisplay_invalidateAndUpdate', array((array)$request));
       
       return ;
  }

   public function resizeCompleted($arg_screenId) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->screenId = $arg_screenId;
       $response = $this->connection->__soapCall('IDisplay_resizeCompleted', array((array)$request));
       
       return ;
  }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IDisplayCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IDisplay";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class INetworkAdapter extends VBox_ManagedObject {

   public function attachToNAT() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('INetworkAdapter_attachToNAT', array((array)$request));
       
       return ;
  }

   public function attachToBridgedInterface() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('INetworkAdapter_attachToBridgedInterface', array((array)$request));
       
       return ;
  }

   public function attachToInternalNetwork() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('INetworkAdapter_attachToInternalNetwork', array((array)$request));
       
       return ;
  }

   public function attachToHostOnlyInterface() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('INetworkAdapter_attachToHostOnlyInterface', array((array)$request));
       
       return ;
  }

   public function attachToVDE() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('INetworkAdapter_attachToVDE', array((array)$request));
       
       return ;
  }

   public function detach() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('INetworkAdapter_detach', array((array)$request));
       
       return ;
  }

   public function getAdapterType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getAdapterType', array((array)$request));
       return new NetworkAdapterType ($this->connection, $response->returnval);
   }

   public function setAdapterType($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->adapterType = $value;
       }
       else
       {
            $request->adapterType = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setAdapterType', array((array)$request));
   }

   public function getSlot() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getSlot', array((array)$request));
       return (float)$response->returnval;
   }

   public function getEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->enabled = $value;
       }
       else
       {
            $request->enabled = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setEnabled', array((array)$request));
   }

   public function getMACAddress() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getMACAddress', array((array)$request));
       return (string)$response->returnval;
   }

   public function setMACAddress($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->MACAddress = $value;
       }
       else
       {
            $request->MACAddress = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setMACAddress', array((array)$request));
   }

   public function getAttachmentType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getAttachmentType', array((array)$request));
       return new NetworkAttachmentType ($this->connection, $response->returnval);
   }

   public function getHostInterface() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getHostInterface', array((array)$request));
       return (string)$response->returnval;
   }

   public function setHostInterface($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->hostInterface = $value;
       }
       else
       {
            $request->hostInterface = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setHostInterface', array((array)$request));
   }

   public function getInternalNetwork() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getInternalNetwork', array((array)$request));
       return (string)$response->returnval;
   }

   public function setInternalNetwork($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->internalNetwork = $value;
       }
       else
       {
            $request->internalNetwork = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setInternalNetwork', array((array)$request));
   }

   public function getNATNetwork() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getNATNetwork', array((array)$request));
       return (string)$response->returnval;
   }

   public function setNATNetwork($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->NATNetwork = $value;
       }
       else
       {
            $request->NATNetwork = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setNATNetwork', array((array)$request));
   }

   public function getVDENetwork() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getVDENetwork', array((array)$request));
       return (string)$response->returnval;
   }

   public function setVDENetwork($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->VDENetwork = $value;
       }
       else
       {
            $request->VDENetwork = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setVDENetwork', array((array)$request));
   }

   public function getCableConnected() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getCableConnected', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setCableConnected($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->cableConnected = $value;
       }
       else
       {
            $request->cableConnected = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setCableConnected', array((array)$request));
   }

   public function getLineSpeed() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getLineSpeed', array((array)$request));
       return (float)$response->returnval;
   }

   public function setLineSpeed($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->lineSpeed = $value;
       }
       else
       {
            $request->lineSpeed = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setLineSpeed', array((array)$request));
   }

   public function getTraceEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getTraceEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setTraceEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->traceEnabled = $value;
       }
       else
       {
            $request->traceEnabled = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setTraceEnabled', array((array)$request));
   }

   public function getTraceFile() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getTraceFile', array((array)$request));
       return (string)$response->returnval;
   }

   public function setTraceFile($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->traceFile = $value;
       }
       else
       {
            $request->traceFile = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setTraceFile', array((array)$request));
   }

   public function getNatDriver() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getNatDriver', array((array)$request));
       return new INATEngine ($this->connection, $response->returnval);
   }

   public function getBootPriority() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INetworkAdapter_getBootPriority', array((array)$request));
       return (float)$response->returnval;
   }

   public function setBootPriority($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->bootPriority = $value;
       }
       else
       {
            $request->bootPriority = $value->handle;
       }
       $this->connection->__soapCall('INetworkAdapter_setBootPriority', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class INetworkAdapterCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "INetworkAdapter";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class ISerialPort extends VBox_ManagedObject {

   public function getSlot() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISerialPort_getSlot', array((array)$request));
       return (float)$response->returnval;
   }

   public function getEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISerialPort_getEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->enabled = $value;
       }
       else
       {
            $request->enabled = $value->handle;
       }
       $this->connection->__soapCall('ISerialPort_setEnabled', array((array)$request));
   }

   public function getIOBase() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISerialPort_getIOBase', array((array)$request));
       return (float)$response->returnval;
   }

   public function setIOBase($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->IOBase = $value;
       }
       else
       {
            $request->IOBase = $value->handle;
       }
       $this->connection->__soapCall('ISerialPort_setIOBase', array((array)$request));
   }

   public function getIRQ() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISerialPort_getIRQ', array((array)$request));
       return (float)$response->returnval;
   }

   public function setIRQ($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->IRQ = $value;
       }
       else
       {
            $request->IRQ = $value->handle;
       }
       $this->connection->__soapCall('ISerialPort_setIRQ', array((array)$request));
   }

   public function getHostMode() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISerialPort_getHostMode', array((array)$request));
       return new PortMode ($this->connection, $response->returnval);
   }

   public function setHostMode($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->hostMode = $value;
       }
       else
       {
            $request->hostMode = $value->handle;
       }
       $this->connection->__soapCall('ISerialPort_setHostMode', array((array)$request));
   }

   public function getServer() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISerialPort_getServer', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setServer($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->server = $value;
       }
       else
       {
            $request->server = $value->handle;
       }
       $this->connection->__soapCall('ISerialPort_setServer', array((array)$request));
   }

   public function getPath() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISerialPort_getPath', array((array)$request));
       return (string)$response->returnval;
   }

   public function setPath($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->path = $value;
       }
       else
       {
            $request->path = $value->handle;
       }
       $this->connection->__soapCall('ISerialPort_setPath', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class ISerialPortCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "ISerialPort";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IParallelPort extends VBox_ManagedObject {

   public function getSlot() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IParallelPort_getSlot', array((array)$request));
       return (float)$response->returnval;
   }

   public function getEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IParallelPort_getEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->enabled = $value;
       }
       else
       {
            $request->enabled = $value->handle;
       }
       $this->connection->__soapCall('IParallelPort_setEnabled', array((array)$request));
   }

   public function getIOBase() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IParallelPort_getIOBase', array((array)$request));
       return (float)$response->returnval;
   }

   public function setIOBase($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->IOBase = $value;
       }
       else
       {
            $request->IOBase = $value->handle;
       }
       $this->connection->__soapCall('IParallelPort_setIOBase', array((array)$request));
   }

   public function getIRQ() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IParallelPort_getIRQ', array((array)$request));
       return (float)$response->returnval;
   }

   public function setIRQ($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->IRQ = $value;
       }
       else
       {
            $request->IRQ = $value->handle;
       }
       $this->connection->__soapCall('IParallelPort_setIRQ', array((array)$request));
   }

   public function getPath() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IParallelPort_getPath', array((array)$request));
       return (string)$response->returnval;
   }

   public function setPath($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->path = $value;
       }
       else
       {
            $request->path = $value->handle;
       }
       $this->connection->__soapCall('IParallelPort_setPath', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IParallelPortCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IParallelPort";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IUSBController extends VBox_ManagedObject {

   public function createDeviceFilter($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('IUSBController_createDeviceFilter', array((array)$request));
       
       return new IUSBDeviceFilter ($this->connection, $response->returnval);
  }

   public function insertDeviceFilter($arg_position, $arg_filter) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->position = $arg_position;
       $request->filter = $arg_filter;
       $response = $this->connection->__soapCall('IUSBController_insertDeviceFilter', array((array)$request));
       
       return ;
  }

   public function removeDeviceFilter($arg_position) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->position = $arg_position;
       $response = $this->connection->__soapCall('IUSBController_removeDeviceFilter', array((array)$request));
       
       return new IUSBDeviceFilter ($this->connection, $response->returnval);
  }

   public function getEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBController_getEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->enabled = $value;
       }
       else
       {
            $request->enabled = $value->handle;
       }
       $this->connection->__soapCall('IUSBController_setEnabled', array((array)$request));
   }

   public function getEnabledEhci() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBController_getEnabledEhci', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setEnabledEhci($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->enabledEhci = $value;
       }
       else
       {
            $request->enabledEhci = $value->handle;
       }
       $this->connection->__soapCall('IUSBController_setEnabledEhci', array((array)$request));
   }

   public function getProxyAvailable() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBController_getProxyAvailable', array((array)$request));
       return (bool)$response->returnval;
   }

   public function getUSBStandard() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBController_getUSBStandard', array((array)$request));
       return (int)$response->returnval;
   }

   public function getDeviceFilters() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBController_getDeviceFilters', array((array)$request));
       return new IUSBDeviceFilterCollection ($this->connection, (array)$response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IUSBControllerCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IUSBController";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IUSBDevice extends VBox_ManagedObject {

   public function getId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getId', array((array)$request));
       return (string)$response->returnval;
   }

   public function getVendorId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getVendorId', array((array)$request));
       return (int)$response->returnval;
   }

   public function getProductId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getProductId', array((array)$request));
       return (int)$response->returnval;
   }

   public function getRevision() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getRevision', array((array)$request));
       return (int)$response->returnval;
   }

   public function getManufacturer() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getManufacturer', array((array)$request));
       return (string)$response->returnval;
   }

   public function getProduct() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getProduct', array((array)$request));
       return (string)$response->returnval;
   }

   public function getSerialNumber() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getSerialNumber', array((array)$request));
       return (string)$response->returnval;
   }

   public function getAddress() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getAddress', array((array)$request));
       return (string)$response->returnval;
   }

   public function getPort() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getPort', array((array)$request));
       return (int)$response->returnval;
   }

   public function getVersion() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getVersion', array((array)$request));
       return (int)$response->returnval;
   }

   public function getPortVersion() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getPortVersion', array((array)$request));
       return (int)$response->returnval;
   }

   public function getRemote() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDevice_getRemote', array((array)$request));
       return (bool)$response->returnval;
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IUSBDeviceCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IUSBDevice";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IUSBDeviceFilter extends VBox_ManagedObject {

   public function getName() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getName', array((array)$request));
       return (string)$response->returnval;
   }

   public function setName($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->name = $value;
       }
       else
       {
            $request->name = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setName', array((array)$request));
   }

   public function getActive() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getActive', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setActive($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->active = $value;
       }
       else
       {
            $request->active = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setActive', array((array)$request));
   }

   public function getVendorId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getVendorId', array((array)$request));
       return (string)$response->returnval;
   }

   public function setVendorId($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->vendorId = $value;
       }
       else
       {
            $request->vendorId = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setVendorId', array((array)$request));
   }

   public function getProductId() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getProductId', array((array)$request));
       return (string)$response->returnval;
   }

   public function setProductId($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->productId = $value;
       }
       else
       {
            $request->productId = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setProductId', array((array)$request));
   }

   public function getRevision() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getRevision', array((array)$request));
       return (string)$response->returnval;
   }

   public function setRevision($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->revision = $value;
       }
       else
       {
            $request->revision = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setRevision', array((array)$request));
   }

   public function getManufacturer() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getManufacturer', array((array)$request));
       return (string)$response->returnval;
   }

   public function setManufacturer($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->manufacturer = $value;
       }
       else
       {
            $request->manufacturer = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setManufacturer', array((array)$request));
   }

   public function getProduct() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getProduct', array((array)$request));
       return (string)$response->returnval;
   }

   public function setProduct($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->product = $value;
       }
       else
       {
            $request->product = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setProduct', array((array)$request));
   }

   public function getSerialNumber() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getSerialNumber', array((array)$request));
       return (string)$response->returnval;
   }

   public function setSerialNumber($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->serialNumber = $value;
       }
       else
       {
            $request->serialNumber = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setSerialNumber', array((array)$request));
   }

   public function getPort() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getPort', array((array)$request));
       return (string)$response->returnval;
   }

   public function setPort($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->port = $value;
       }
       else
       {
            $request->port = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setPort', array((array)$request));
   }

   public function getRemote() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getRemote', array((array)$request));
       return (string)$response->returnval;
   }

   public function setRemote($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->remote = $value;
       }
       else
       {
            $request->remote = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setRemote', array((array)$request));
   }

   public function getMaskedInterfaces() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IUSBDeviceFilter_getMaskedInterfaces', array((array)$request));
       return (float)$response->returnval;
   }

   public function setMaskedInterfaces($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->maskedInterfaces = $value;
       }
       else
       {
            $request->maskedInterfaces = $value->handle;
       }
       $this->connection->__soapCall('IUSBDeviceFilter_setMaskedInterfaces', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IUSBDeviceFilterCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IUSBDeviceFilter";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IHostUSBDevice extends IUSBDevice {

   public function getState() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostUSBDevice_getState', array((array)$request));
       return new USBDeviceState ($this->connection, $response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IHostUSBDeviceCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IHostUSBDevice";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IHostUSBDeviceFilter extends IUSBDeviceFilter {

   public function getAction() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IHostUSBDeviceFilter_getAction', array((array)$request));
       return new USBDeviceFilterAction ($this->connection, $response->returnval);
   }

   public function setAction($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->action = $value;
       }
       else
       {
            $request->action = $value->handle;
       }
       $this->connection->__soapCall('IHostUSBDeviceFilter_setAction', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IHostUSBDeviceFilterCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IHostUSBDeviceFilter";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IAudioAdapter extends VBox_ManagedObject {

   public function getEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IAudioAdapter_getEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->enabled = $value;
       }
       else
       {
            $request->enabled = $value->handle;
       }
       $this->connection->__soapCall('IAudioAdapter_setEnabled', array((array)$request));
   }

   public function getAudioController() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IAudioAdapter_getAudioController', array((array)$request));
       return new AudioControllerType ($this->connection, $response->returnval);
   }

   public function setAudioController($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->audioController = $value;
       }
       else
       {
            $request->audioController = $value->handle;
       }
       $this->connection->__soapCall('IAudioAdapter_setAudioController', array((array)$request));
   }

   public function getAudioDriver() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IAudioAdapter_getAudioDriver', array((array)$request));
       return new AudioDriverType ($this->connection, $response->returnval);
   }

   public function setAudioDriver($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->audioDriver = $value;
       }
       else
       {
            $request->audioDriver = $value->handle;
       }
       $this->connection->__soapCall('IAudioAdapter_setAudioDriver', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IAudioAdapterCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IAudioAdapter";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IVRDPServer extends VBox_ManagedObject {

   public function getEnabled() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVRDPServer_getEnabled', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setEnabled($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->enabled = $value;
       }
       else
       {
            $request->enabled = $value->handle;
       }
       $this->connection->__soapCall('IVRDPServer_setEnabled', array((array)$request));
   }

   public function getPorts() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVRDPServer_getPorts', array((array)$request));
       return (string)$response->returnval;
   }

   public function setPorts($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->ports = $value;
       }
       else
       {
            $request->ports = $value->handle;
       }
       $this->connection->__soapCall('IVRDPServer_setPorts', array((array)$request));
   }

   public function getNetAddress() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVRDPServer_getNetAddress', array((array)$request));
       return (string)$response->returnval;
   }

   public function setNetAddress($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->netAddress = $value;
       }
       else
       {
            $request->netAddress = $value->handle;
       }
       $this->connection->__soapCall('IVRDPServer_setNetAddress', array((array)$request));
   }

   public function getAuthType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVRDPServer_getAuthType', array((array)$request));
       return new VRDPAuthType ($this->connection, $response->returnval);
   }

   public function setAuthType($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->authType = $value;
       }
       else
       {
            $request->authType = $value->handle;
       }
       $this->connection->__soapCall('IVRDPServer_setAuthType', array((array)$request));
   }

   public function getAuthTimeout() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVRDPServer_getAuthTimeout', array((array)$request));
       return (float)$response->returnval;
   }

   public function setAuthTimeout($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->authTimeout = $value;
       }
       else
       {
            $request->authTimeout = $value->handle;
       }
       $this->connection->__soapCall('IVRDPServer_setAuthTimeout', array((array)$request));
   }

   public function getAllowMultiConnection() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVRDPServer_getAllowMultiConnection', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setAllowMultiConnection($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->allowMultiConnection = $value;
       }
       else
       {
            $request->allowMultiConnection = $value->handle;
       }
       $this->connection->__soapCall('IVRDPServer_setAllowMultiConnection', array((array)$request));
   }

   public function getReuseSingleConnection() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVRDPServer_getReuseSingleConnection', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setReuseSingleConnection($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->reuseSingleConnection = $value;
       }
       else
       {
            $request->reuseSingleConnection = $value->handle;
       }
       $this->connection->__soapCall('IVRDPServer_setReuseSingleConnection', array((array)$request));
   }

   public function getVideoChannel() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVRDPServer_getVideoChannel', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setVideoChannel($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->videoChannel = $value;
       }
       else
       {
            $request->videoChannel = $value->handle;
       }
       $this->connection->__soapCall('IVRDPServer_setVideoChannel', array((array)$request));
   }

   public function getVideoChannelQuality() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IVRDPServer_getVideoChannelQuality', array((array)$request));
       return (float)$response->returnval;
   }

   public function setVideoChannelQuality($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->videoChannelQuality = $value;
       }
       else
       {
            $request->videoChannelQuality = $value->handle;
       }
       $this->connection->__soapCall('IVRDPServer_setVideoChannelQuality', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IVRDPServerCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IVRDPServer";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class ISession extends VBox_ManagedObject {

   public function close() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('ISession_close', array((array)$request));
       
       return ;
  }

   public function getState() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISession_getState', array((array)$request));
       return new SessionState ($this->connection, $response->returnval);
   }

   public function getType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISession_getType', array((array)$request));
       return new SessionType ($this->connection, $response->returnval);
   }

   public function getMachine() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISession_getMachine', array((array)$request));
       return new IMachine ($this->connection, $response->returnval);
   }

   public function getConsole() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('ISession_getConsole', array((array)$request));
       return new IConsole ($this->connection, $response->returnval);
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class ISessionCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "ISession";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IStorageController extends VBox_ManagedObject {

   public function getIDEEmulationPort($arg_devicePosition) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->devicePosition = $arg_devicePosition;
       $response = $this->connection->__soapCall('IStorageController_getIDEEmulationPort', array((array)$request));
       
       return (int)$response->returnval;
  }

   public function setIDEEmulationPort($arg_devicePosition, $arg_portNumber) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->devicePosition = $arg_devicePosition;
       $request->portNumber = $arg_portNumber;
       $response = $this->connection->__soapCall('IStorageController_setIDEEmulationPort', array((array)$request));
       
       return ;
  }

   public function getName() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IStorageController_getName', array((array)$request));
       return (string)$response->returnval;
   }

   public function getMaxDevicesPerPortCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IStorageController_getMaxDevicesPerPortCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMinPortCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IStorageController_getMinPortCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getMaxPortCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IStorageController_getMaxPortCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getInstance() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IStorageController_getInstance', array((array)$request));
       return (float)$response->returnval;
   }

   public function setInstance($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->instance = $value;
       }
       else
       {
            $request->instance = $value->handle;
       }
       $this->connection->__soapCall('IStorageController_setInstance', array((array)$request));
   }

   public function getPortCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IStorageController_getPortCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function setPortCount($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->portCount = $value;
       }
       else
       {
            $request->portCount = $value->handle;
       }
       $this->connection->__soapCall('IStorageController_setPortCount', array((array)$request));
   }

   public function getBus() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IStorageController_getBus', array((array)$request));
       return new StorageBus ($this->connection, $response->returnval);
   }

   public function getControllerType() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IStorageController_getControllerType', array((array)$request));
       return new StorageControllerType ($this->connection, $response->returnval);
   }

   public function setControllerType($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->controllerType = $value;
       }
       else
       {
            $request->controllerType = $value->handle;
       }
       $this->connection->__soapCall('IStorageController_setControllerType', array((array)$request));
   }

   public function getUseHostIOCache() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IStorageController_getUseHostIOCache', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setUseHostIOCache($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->useHostIOCache = $value;
       }
       else
       {
            $request->useHostIOCache = $value->handle;
       }
       $this->connection->__soapCall('IStorageController_setUseHostIOCache', array((array)$request));
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IStorageControllerCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IStorageController";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IManagedObjectRef extends VBox_ManagedObject {

   public function getInterfaceName() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IManagedObjectRef_getInterfaceName', array((array)$request));
       
       return (string)$response->returnval;
  }

   public function release() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('IManagedObjectRef_release', array((array)$request));
       
       return ;
  }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IManagedObjectRefCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IManagedObjectRef";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IWebsessionManager extends VBox_ManagedObject {

   public function logon($arg_username, $arg_password) { 
       $request = new stdClass();
       
       $request->username = $arg_username;
       $request->password = $arg_password;
       $response = $this->connection->__soapCall('IWebsessionManager_logon', array((array)$request));
       
       return new IVirtualBox ($this->connection, $response->returnval);
  }

   public function getSessionObject($arg_refIVirtualBox) { 
       $request = new stdClass();
       
       $request->refIVirtualBox = $arg_refIVirtualBox;
       $response = $this->connection->__soapCall('IWebsessionManager_getSessionObject', array((array)$request));
       
       return new ISession ($this->connection, $response->returnval);
  }

   public function logoff($arg_refIVirtualBox) { 
       $request = new stdClass();
       
       $request->refIVirtualBox = $arg_refIVirtualBox;
       $response = $this->connection->__soapCall('IWebsessionManager_logoff', array((array)$request));
       
       return ;
  }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IWebsessionManagerCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IWebsessionManager";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IPerformanceMetric extends VBox_ManagedObject {

   public function getMetricName() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IPerformanceMetric_getMetricName', array((array)$request));
       return (string)$response->returnval;
   }

   public function getObject() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IPerformanceMetric_getObject', array((array)$request));
       return new VBox_ManagedObject ($this->connection, $response->returnval);
   }

   public function getDescription() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IPerformanceMetric_getDescription', array((array)$request));
       return (string)$response->returnval;
   }

   public function getPeriod() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IPerformanceMetric_getPeriod', array((array)$request));
       return (float)$response->returnval;
   }

   public function getCount() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IPerformanceMetric_getCount', array((array)$request));
       return (float)$response->returnval;
   }

   public function getUnit() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IPerformanceMetric_getUnit', array((array)$request));
       return (string)$response->returnval;
   }

   public function getMinimumValue() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IPerformanceMetric_getMinimumValue', array((array)$request));
       return (int)$response->returnval;
   }

   public function getMaximumValue() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IPerformanceMetric_getMaximumValue', array((array)$request));
       return (int)$response->returnval;
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IPerformanceMetricCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IPerformanceMetric";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class IPerformanceCollector extends VBox_ManagedObject {

   public function getMetrics($arg_metricNames, $arg_objects) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->metricNames = $arg_metricNames;
       $request->objects = $arg_objects;
       $response = $this->connection->__soapCall('IPerformanceCollector_getMetrics', array((array)$request));
       
       return new IPerformanceMetricCollection ($this->connection, (array)$response->returnval);
  }

   public function setupMetrics($arg_metricNames, $arg_objects, $arg_period, $arg_count) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->metricNames = $arg_metricNames;
       $request->objects = $arg_objects;
       $request->period = $arg_period;
       $request->count = $arg_count;
       $response = $this->connection->__soapCall('IPerformanceCollector_setupMetrics', array((array)$request));
       
       return new IPerformanceMetricCollection ($this->connection, (array)$response->returnval);
  }

   public function enableMetrics($arg_metricNames, $arg_objects) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->metricNames = $arg_metricNames;
       $request->objects = $arg_objects;
       $response = $this->connection->__soapCall('IPerformanceCollector_enableMetrics', array((array)$request));
       
       return new IPerformanceMetricCollection ($this->connection, (array)$response->returnval);
  }

   public function disableMetrics($arg_metricNames, $arg_objects) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->metricNames = $arg_metricNames;
       $request->objects = $arg_objects;
       $response = $this->connection->__soapCall('IPerformanceCollector_disableMetrics', array((array)$request));
       
       return new IPerformanceMetricCollection ($this->connection, (array)$response->returnval);
  }

   public function queryMetricsData($arg_metricNames, $arg_objects) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->metricNames = $arg_metricNames;
       $request->objects = $arg_objects;
       $response = $this->connection->__soapCall('IPerformanceCollector_queryMetricsData', array((array)$request));
       
       return array((array)$response->returnval, (array)$response->returnMetricNames, new VBox_ManagedObjectCollection ($this->connection, (array)$response->returnObjects), (array)$response->returnUnits, (array)$response->returnScales, (array)$response->returnSequenceNumbers, (array)$response->returnDataIndices, (array)$response->returnDataLengths);
  }

   public function getMetricNames() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('IPerformanceCollector_getMetricNames', array((array)$request));
       return (array)$response->returnval;
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class IPerformanceCollectorCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "IPerformanceCollector";
}

/**
* Generated VBoxWebService Interface Wrapper
*/
class INATEngine extends VBox_ManagedObject {

   public function setNetworkSettings($arg_mtu, $arg_sockSnd, $arg_sockRcv, $arg_TcpWndSnd, $arg_TcpWndRcv) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->mtu = $arg_mtu;
       $request->sockSnd = $arg_sockSnd;
       $request->sockRcv = $arg_sockRcv;
       $request->TcpWndSnd = $arg_TcpWndSnd;
       $request->TcpWndRcv = $arg_TcpWndRcv;
       $response = $this->connection->__soapCall('INATEngine_setNetworkSettings', array((array)$request));
       
       return ;
  }

   public function getNetworkSettings() { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $response = $this->connection->__soapCall('INATEngine_getNetworkSettings', array((array)$request));
       
       return array((float)$response->mtu, (float)$response->sockSnd, (float)$response->sockRcv, (float)$response->TcpWndSnd, (float)$response->TcpWndRcv);
  }

   public function addRedirect($arg_name, $arg_proto, $arg_hostIp, $arg_hostPort, $arg_guestIp, $arg_guestPort) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $request->proto = $arg_proto;
       $request->hostIp = $arg_hostIp;
       $request->hostPort = $arg_hostPort;
       $request->guestIp = $arg_guestIp;
       $request->guestPort = $arg_guestPort;
       $response = $this->connection->__soapCall('INATEngine_addRedirect', array((array)$request));
       
       return ;
  }

   public function removeRedirect($arg_name) { 
       $request = new stdClass();
       
       $request->_this = $this->handle;
       
       $request->name = $arg_name;
       $response = $this->connection->__soapCall('INATEngine_removeRedirect', array((array)$request));
       
       return ;
  }

   public function getNetwork() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INATEngine_getNetwork', array((array)$request));
       return (string)$response->returnval;
   }

   public function setNetwork($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->network = $value;
       }
       else
       {
            $request->network = $value->handle;
       }
       $this->connection->__soapCall('INATEngine_setNetwork', array((array)$request));
   }

   public function getHostIP() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INATEngine_getHostIP', array((array)$request));
       return (string)$response->returnval;
   }

   public function setHostIP($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->hostIP = $value;
       }
       else
       {
            $request->hostIP = $value->handle;
       }
       $this->connection->__soapCall('INATEngine_setHostIP', array((array)$request));
   }

   public function getTftpPrefix() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INATEngine_getTftpPrefix', array((array)$request));
       return (string)$response->returnval;
   }

   public function setTftpPrefix($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->tftpPrefix = $value;
       }
       else
       {
            $request->tftpPrefix = $value->handle;
       }
       $this->connection->__soapCall('INATEngine_setTftpPrefix', array((array)$request));
   }

   public function getTftpBootFile() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INATEngine_getTftpBootFile', array((array)$request));
       return (string)$response->returnval;
   }

   public function setTftpBootFile($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->tftpBootFile = $value;
       }
       else
       {
            $request->tftpBootFile = $value->handle;
       }
       $this->connection->__soapCall('INATEngine_setTftpBootFile', array((array)$request));
   }

   public function getTftpNextServer() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INATEngine_getTftpNextServer', array((array)$request));
       return (string)$response->returnval;
   }

   public function setTftpNextServer($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->tftpNextServer = $value;
       }
       else
       {
            $request->tftpNextServer = $value->handle;
       }
       $this->connection->__soapCall('INATEngine_setTftpNextServer', array((array)$request));
   }

   public function getAliasMode() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INATEngine_getAliasMode', array((array)$request));
       return (float)$response->returnval;
   }

   public function setAliasMode($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->aliasMode = $value;
       }
       else
       {
            $request->aliasMode = $value->handle;
       }
       $this->connection->__soapCall('INATEngine_setAliasMode', array((array)$request));
   }

   public function getDnsPassDomain() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INATEngine_getDnsPassDomain', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setDnsPassDomain($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->dnsPassDomain = $value;
       }
       else
       {
            $request->dnsPassDomain = $value->handle;
       }
       $this->connection->__soapCall('INATEngine_setDnsPassDomain', array((array)$request));
   }

   public function getDnsProxy() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INATEngine_getDnsProxy', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setDnsProxy($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->dnsProxy = $value;
       }
       else
       {
            $request->dnsProxy = $value->handle;
       }
       $this->connection->__soapCall('INATEngine_setDnsProxy', array((array)$request));
   }

   public function getDnsUseHostResolver() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INATEngine_getDnsUseHostResolver', array((array)$request));
       return (bool)$response->returnval;
   }

   public function setDnsUseHostResolver($value) {
       $request = new stdClass();
       $request->_this = $this->handle;
       if (is_int($value) || is_string($value) || is_bool($value)) {
            $request->dnsUseHostResolver = $value;
       }
       else
       {
            $request->dnsUseHostResolver = $value->handle;
       }
       $this->connection->__soapCall('INATEngine_setDnsUseHostResolver', array((array)$request));
   }

   public function getRedirects() {
       $request = new stdClass();
       $request->_this = $this->handle;
       $response = $this->connection->__soapCall('INATEngine_getRedirects', array((array)$request));
       return (array)$response->returnval;
   }
}
  
/**
* Generated VBoxWebService Managed Object Collection
*/
class INATEngineCollection extends VBox_ManagedObjectCollection {
   protected $_interfaceName = "INATEngine";
}

/**
* Generated VBoxWebService Struct
*/
class IRemoteDisplayInfo extends VBox_Struct {
    
       protected $active;
    
       protected $port;
    
       protected $numberOfClients;
    
       protected $beginTime;
    
       protected $endTime;
    
       protected $bytesSent;
    
       protected $bytesSentTotal;
    
       protected $bytesReceived;
    
       protected $bytesReceivedTotal;
    
       protected $user;
    
       protected $domain;
    
       protected $clientName;
    
       protected $clientIP;
    
       protected $clientVersion;
    
       protected $encryptionStyle;
    
    public function __construct($connection, $values) {
       $this->connection = $connection;
    
       $this->active = $values->active;
       $this->port = $values->port;
       $this->numberOfClients = $values->numberOfClients;
       $this->beginTime = $values->beginTime;
       $this->endTime = $values->endTime;
       $this->bytesSent = $values->bytesSent;
       $this->bytesSentTotal = $values->bytesSentTotal;
       $this->bytesReceived = $values->bytesReceived;
       $this->bytesReceivedTotal = $values->bytesReceivedTotal;
       $this->user = $values->user;
       $this->domain = $values->domain;
       $this->clientName = $values->clientName;
       $this->clientIP = $values->clientIP;
       $this->clientVersion = $values->clientVersion;
       $this->encryptionStyle = $values->encryptionStyle;
    }

    
    public function getActive() {
        return (bool)$this->active;
    }
    
    public function getPort() {
        return (int)$this->port;
    }
    
    public function getNumberOfClients() {
        return (float)$this->numberOfClients;
    }
    
    public function getBeginTime() {
        return (float)$this->beginTime;
    }
    
    public function getEndTime() {
        return (float)$this->endTime;
    }
    
    public function getBytesSent() {
        return (float)$this->bytesSent;
    }
    
    public function getBytesSentTotal() {
        return (float)$this->bytesSentTotal;
    }
    
    public function getBytesReceived() {
        return (float)$this->bytesReceived;
    }
    
    public function getBytesReceivedTotal() {
        return (float)$this->bytesReceivedTotal;
    }
    
    public function getUser() {
        return (string)$this->user;
    }
    
    public function getDomain() {
        return (string)$this->domain;
    }
    
    public function getClientName() {
        return (string)$this->clientName;
    }
    
    public function getClientIP() {
        return (string)$this->clientIP;
    }
    
    public function getClientVersion() {
        return (float)$this->clientVersion;
    }
    
    public function getEncryptionStyle() {
        return (float)$this->encryptionStyle;
    }
    

}

/**
* Generated VBoxWebService Struct Collection
*/
class IRemoteDisplayInfoCollection extends VBox_StructCollection {
   protected $_interfaceName = "IRemoteDisplayInfo";
}

/**
* Generated VBoxWebService Struct
*/
class IGuestOSType extends VBox_Struct {
    
       protected $familyId;
    
       protected $familyDescription;
    
       protected $id;
    
       protected $description;
    
       protected $is64Bit;
    
       protected $recommendedIOAPIC;
    
       protected $recommendedVirtEx;
    
       protected $recommendedRAM;
    
       protected $recommendedVRAM;
    
       protected $recommendedHDD;
    
       protected $adapterType;
    
       protected $recommendedPae;
    
       protected $recommendedDvdStorageController;
    
       protected $recommendedDvdStorageBus;
    
       protected $recommendedHdStorageController;
    
       protected $recommendedHdStorageBus;
    
       protected $recommendedFirmware;
    
       protected $recommendedUsbHid;
    
       protected $recommendedHpet;
    
       protected $recommendedUsbTablet;
    
       protected $recommendedRtcUseUtc;
    
    public function __construct($connection, $values) {
       $this->connection = $connection;
    
       $this->familyId = $values->familyId;
       $this->familyDescription = $values->familyDescription;
       $this->id = $values->id;
       $this->description = $values->description;
       $this->is64Bit = $values->is64Bit;
       $this->recommendedIOAPIC = $values->recommendedIOAPIC;
       $this->recommendedVirtEx = $values->recommendedVirtEx;
       $this->recommendedRAM = $values->recommendedRAM;
       $this->recommendedVRAM = $values->recommendedVRAM;
       $this->recommendedHDD = $values->recommendedHDD;
       $this->adapterType = $values->adapterType;
       $this->recommendedPae = $values->recommendedPae;
       $this->recommendedDvdStorageController = $values->recommendedDvdStorageController;
       $this->recommendedDvdStorageBus = $values->recommendedDvdStorageBus;
       $this->recommendedHdStorageController = $values->recommendedHdStorageController;
       $this->recommendedHdStorageBus = $values->recommendedHdStorageBus;
       $this->recommendedFirmware = $values->recommendedFirmware;
       $this->recommendedUsbHid = $values->recommendedUsbHid;
       $this->recommendedHpet = $values->recommendedHpet;
       $this->recommendedUsbTablet = $values->recommendedUsbTablet;
       $this->recommendedRtcUseUtc = $values->recommendedRtcUseUtc;
    }

    
    public function getFamilyId() {
        return (string)$this->familyId;
    }
    
    public function getFamilyDescription() {
        return (string)$this->familyDescription;
    }
    
    public function getId() {
        return (string)$this->id;
    }
    
    public function getDescription() {
        return (string)$this->description;
    }
    
    public function getIs64Bit() {
        return (bool)$this->is64Bit;
    }
    
    public function getRecommendedIOAPIC() {
        return (bool)$this->recommendedIOAPIC;
    }
    
    public function getRecommendedVirtEx() {
        return (bool)$this->recommendedVirtEx;
    }
    
    public function getRecommendedRAM() {
        return (float)$this->recommendedRAM;
    }
    
    public function getRecommendedVRAM() {
        return (float)$this->recommendedVRAM;
    }
    
    public function getRecommendedHDD() {
        return (float)$this->recommendedHDD;
    }
    
    public function getAdapterType() {
        return new NetworkAdapterType ($this->connection, $this->adapterType);
    }
    
    public function getRecommendedPae() {
        return (bool)$this->recommendedPae;
    }
    
    public function getRecommendedDvdStorageController() {
        return new StorageControllerType ($this->connection, $this->recommendedDvdStorageController);
    }
    
    public function getRecommendedDvdStorageBus() {
        return new StorageBus ($this->connection, $this->recommendedDvdStorageBus);
    }
    
    public function getRecommendedHdStorageController() {
        return new StorageControllerType ($this->connection, $this->recommendedHdStorageController);
    }
    
    public function getRecommendedHdStorageBus() {
        return new StorageBus ($this->connection, $this->recommendedHdStorageBus);
    }
    
    public function getRecommendedFirmware() {
        return new FirmwareType ($this->connection, $this->recommendedFirmware);
    }
    
    public function getRecommendedUsbHid() {
        return (bool)$this->recommendedUsbHid;
    }
    
    public function getRecommendedHpet() {
        return (bool)$this->recommendedHpet;
    }
    
    public function getRecommendedUsbTablet() {
        return (bool)$this->recommendedUsbTablet;
    }
    
    public function getRecommendedRtcUseUtc() {
        return (bool)$this->recommendedRtcUseUtc;
    }
    

}

/**
* Generated VBoxWebService Struct Collection
*/
class IGuestOSTypeCollection extends VBox_StructCollection {
   protected $_interfaceName = "IGuestOSType";
}

/**
* Generated VBoxWebService Struct
*/
class IMediumAttachment extends VBox_Struct {
    
       protected $medium;
    
       protected $controller;
    
       protected $port;
    
       protected $device;
    
       protected $type;
    
       protected $passthrough;
    
    public function __construct($connection, $values) {
       $this->connection = $connection;
    
       $this->medium = $values->medium;
       $this->controller = $values->controller;
       $this->port = $values->port;
       $this->device = $values->device;
       $this->type = $values->type;
       $this->passthrough = $values->passthrough;
    }

    
    public function getMedium() {
        return new IMedium ($this->connection, $this->medium);
    }
    
    public function getController() {
        return (string)$this->controller;
    }
    
    public function getPort() {
        return (int)$this->port;
    }
    
    public function getDevice() {
        return (int)$this->device;
    }
    
    public function getType() {
        return new DeviceType ($this->connection, $this->type);
    }
    
    public function getPassthrough() {
        return (bool)$this->passthrough;
    }
    

}

/**
* Generated VBoxWebService Struct Collection
*/
class IMediumAttachmentCollection extends VBox_StructCollection {
   protected $_interfaceName = "IMediumAttachment";
}

/**
* Generated VBoxWebService Struct
*/
class ISharedFolder extends VBox_Struct {
    
       protected $name;
    
       protected $hostPath;
    
       protected $accessible;
    
       protected $writable;
    
       protected $lastAccessError;
    
    public function __construct($connection, $values) {
       $this->connection = $connection;
    
       $this->name = $values->name;
       $this->hostPath = $values->hostPath;
       $this->accessible = $values->accessible;
       $this->writable = $values->writable;
       $this->lastAccessError = $values->lastAccessError;
    }

    
    public function getName() {
        return (string)$this->name;
    }
    
    public function getHostPath() {
        return (string)$this->hostPath;
    }
    
    public function getAccessible() {
        return (bool)$this->accessible;
    }
    
    public function getWritable() {
        return (bool)$this->writable;
    }
    
    public function getLastAccessError() {
        return (string)$this->lastAccessError;
    }
    

}

/**
* Generated VBoxWebService Struct Collection
*/
class ISharedFolderCollection extends VBox_StructCollection {
   protected $_interfaceName = "ISharedFolder";
}

/**
* Generated VBoxWebService ENUM
*/
class SettingsVersion extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'v1_0', 2 => 'v1_1', 3 => 'v1_2', 4 => 'v1_3pre', 5 => 'v1_3', 6 => 'v1_4', 7 => 'v1_5', 8 => 'v1_6', 9 => 'v1_7', 10 => 'v1_8', 11 => 'v1_9', 12 => 'v1_10', 13 => 'Future');
   public $ValueMap = array('Null' => 0, 'v1_0' => 1, 'v1_1' => 2, 'v1_2' => 3, 'v1_3pre' => 4, 'v1_3' => 5, 'v1_4' => 6, 'v1_5' => 7, 'v1_6' => 8, 'v1_7' => 9, 'v1_8' => 10, 'v1_9' => 11, 'v1_10' => 12, 'Future' => 13);
}

/**
* Generated VBoxWebService Enum Collection
*/
class SettingsVersionCollection extends VBox_EnumCollection {
   protected $_interfaceName = "SettingsVersion";
}

/**
* Generated VBoxWebService ENUM
*/
class AccessMode extends VBox_Enum {
   public $NameMap = array(1 => 'ReadOnly', 2 => 'ReadWrite');
   public $ValueMap = array('ReadOnly' => 1, 'ReadWrite' => 2);
}

/**
* Generated VBoxWebService Enum Collection
*/
class AccessModeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "AccessMode";
}

/**
* Generated VBoxWebService ENUM
*/
class MachineState extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'PoweredOff', 2 => 'Saved', 3 => 'Teleported', 4 => 'Aborted', 5 => 'Running', 6 => 'Paused', 7 => 'Stuck', 8 => 'Teleporting', 9 => 'LiveSnapshotting', 10 => 'Starting', 11 => 'Stopping', 12 => 'Saving', 13 => 'Restoring', 14 => 'TeleportingPausedVM', 15 => 'TeleportingIn', 16 => 'DeletingSnapshotOnline', 17 => 'DeletingSnapshotPaused', 18 => 'RestoringSnapshot', 19 => 'DeletingSnapshot', 20 => 'SettingUp', );
   public $ValueMap = array('Null' => 0, 'PoweredOff' => 1, 'Saved' => 2, 'Teleported' => 3, 'Aborted' => 4, 'Running' => 5, 'Paused' => 6, 'Stuck' => 7, 'Teleporting' => 8, 'LiveSnapshotting' => 9, 'Starting' => 10, 'Stopping' => 11, 'Saving' => 12, 'Restoring' => 13, 'TeleportingPausedVM' => 14, 'TeleportingIn' => 15, 'DeletingSnapshotOnline' => 16, 'DeletingSnapshotPaused' => 17, 'RestoringSnapshot' => 18, 'DeletingSnapshot' => 19, 'SettingUp' => 20, );
}

/**
* Generated VBoxWebService Enum Collection
*/
class MachineStateCollection extends VBox_EnumCollection {
   protected $_interfaceName = "MachineState";
}

/**
* Generated VBoxWebService ENUM
*/
class SessionState extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'Closed', 2 => 'Open', 3 => 'Spawning', 4 => 'Closing');
   public $ValueMap = array('Null' => 0, 'Closed' => 1, 'Open' => 2, 'Spawning' => 3, 'Closing' => 4);
}

/**
* Generated VBoxWebService Enum Collection
*/
class SessionStateCollection extends VBox_EnumCollection {
   protected $_interfaceName = "SessionState";
}

/**
* Generated VBoxWebService ENUM
*/
class CPUPropertyType extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'PAE', 2 => 'Synthetic');
   public $ValueMap = array('Null' => 0, 'PAE' => 1, 'Synthetic' => 2);
}

/**
* Generated VBoxWebService Enum Collection
*/
class CPUPropertyTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "CPUPropertyType";
}

/**
* Generated VBoxWebService ENUM
*/
class HWVirtExPropertyType extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'Enabled', 2 => 'Exclusive', 3 => 'VPID', 4 => 'NestedPaging', 5 => 'LargePages');
   public $ValueMap = array('Null' => 0, 'Enabled' => 1, 'Exclusive' => 2, 'VPID' => 3, 'NestedPaging' => 4, 'LargePages' => 5);
}

/**
* Generated VBoxWebService Enum Collection
*/
class HWVirtExPropertyTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "HWVirtExPropertyType";
}

/**
* Generated VBoxWebService ENUM
*/
class SessionType extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'Direct', 2 => 'Remote', 3 => 'Existing');
   public $ValueMap = array('Null' => 0, 'Direct' => 1, 'Remote' => 2, 'Existing' => 3);
}

/**
* Generated VBoxWebService Enum Collection
*/
class SessionTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "SessionType";
}

/**
* Generated VBoxWebService ENUM
*/
class DeviceType extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'Floppy', 2 => 'DVD', 3 => 'HardDisk', 4 => 'Network', 5 => 'USB', 6 => 'SharedFolder');
   public $ValueMap = array('Null' => 0, 'Floppy' => 1, 'DVD' => 2, 'HardDisk' => 3, 'Network' => 4, 'USB' => 5, 'SharedFolder' => 6);
}

/**
* Generated VBoxWebService Enum Collection
*/
class DeviceTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "DeviceType";
}

/**
* Generated VBoxWebService ENUM
*/
class DeviceActivity extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'Idle', 2 => 'Reading', 3 => 'Writing');
   public $ValueMap = array('Null' => 0, 'Idle' => 1, 'Reading' => 2, 'Writing' => 3);
}

/**
* Generated VBoxWebService Enum Collection
*/
class DeviceActivityCollection extends VBox_EnumCollection {
   protected $_interfaceName = "DeviceActivity";
}

/**
* Generated VBoxWebService ENUM
*/
class ClipboardMode extends VBox_Enum {
   public $NameMap = array(0 => 'Disabled', 1 => 'HostToGuest', 2 => 'GuestToHost', 3 => 'Bidirectional');
   public $ValueMap = array('Disabled' => 0, 'HostToGuest' => 1, 'GuestToHost' => 2, 'Bidirectional' => 3);
}

/**
* Generated VBoxWebService Enum Collection
*/
class ClipboardModeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "ClipboardMode";
}

/**
* Generated VBoxWebService ENUM
*/
class Scope extends VBox_Enum {
   public $NameMap = array(0 => 'Global', 1 => 'Machine', 2 => 'Session');
   public $ValueMap = array('Global' => 0, 'Machine' => 1, 'Session' => 2);
}

/**
* Generated VBoxWebService Enum Collection
*/
class ScopeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "Scope";
}

/**
* Generated VBoxWebService ENUM
*/
class BIOSBootMenuMode extends VBox_Enum {
   public $NameMap = array(0 => 'Disabled', 1 => 'MenuOnly', 2 => 'MessageAndMenu');
   public $ValueMap = array('Disabled' => 0, 'MenuOnly' => 1, 'MessageAndMenu' => 2);
}

/**
* Generated VBoxWebService Enum Collection
*/
class BIOSBootMenuModeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "BIOSBootMenuMode";
}

/**
* Generated VBoxWebService ENUM
*/
class ProcessorFeature extends VBox_Enum {
   public $NameMap = array(0 => 'HWVirtEx', 1 => 'PAE', 2 => 'LongMode', 3 => 'NestedPaging');
   public $ValueMap = array('HWVirtEx' => 0, 'PAE' => 1, 'LongMode' => 2, 'NestedPaging' => 3);
}

/**
* Generated VBoxWebService Enum Collection
*/
class ProcessorFeatureCollection extends VBox_EnumCollection {
   protected $_interfaceName = "ProcessorFeature";
}

/**
* Generated VBoxWebService ENUM
*/
class FirmwareType extends VBox_Enum {
   public $NameMap = array(1 => 'BIOS', 2 => 'EFI', 3 => 'EFI32', 4 => 'EFI64', 5 => 'EFIDUAL');
   public $ValueMap = array('BIOS' => 1, 'EFI' => 2, 'EFI32' => 3, 'EFI64' => 4, 'EFIDUAL' => 5);
}

/**
* Generated VBoxWebService Enum Collection
*/
class FirmwareTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "FirmwareType";
}

/**
* Generated VBoxWebService ENUM
*/
class PointingHidType extends VBox_Enum {
   public $NameMap = array(1 => 'None', 2 => 'PS2Mouse', 3 => 'USBMouse', 4 => 'USBTablet', 5 => 'ComboMouse');
   public $ValueMap = array('None' => 1, 'PS2Mouse' => 2, 'USBMouse' => 3, 'USBTablet' => 4, 'ComboMouse' => 5);
}

/**
* Generated VBoxWebService Enum Collection
*/
class PointingHidTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "PointingHidType";
}

/**
* Generated VBoxWebService ENUM
*/
class KeyboardHidType extends VBox_Enum {
   public $NameMap = array(1 => 'None', 2 => 'PS2Keyboard', 3 => 'USBKeyboard', 4 => 'ComboKeyboard');
   public $ValueMap = array('None' => 1, 'PS2Keyboard' => 2, 'USBKeyboard' => 3, 'ComboKeyboard' => 4);
}

/**
* Generated VBoxWebService Enum Collection
*/
class KeyboardHidTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "KeyboardHidType";
}

/**
* Generated VBoxWebService ENUM
*/
class VFSType extends VBox_Enum {
   public $NameMap = array(1 => 'File', 2 => 'Cloud', 3 => 'S3', 4 => 'WebDav');
   public $ValueMap = array('File' => 1, 'Cloud' => 2, 'S3' => 3, 'WebDav' => 4);
}

/**
* Generated VBoxWebService Enum Collection
*/
class VFSTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "VFSType";
}

/**
* Generated VBoxWebService ENUM
*/
class VFSFileType extends VBox_Enum {
   public $NameMap = array(1 => 'Unknown', 2 => 'Fifo', 3 => 'DevChar', 4 => 'Directory', 5 => 'DevBlock', 6 => 'File', 7 => 'SymLink', 8 => 'Socket', 9 => 'WhiteOut');
   public $ValueMap = array('Unknown' => 1, 'Fifo' => 2, 'DevChar' => 3, 'Directory' => 4, 'DevBlock' => 5, 'File' => 6, 'SymLink' => 7, 'Socket' => 8, 'WhiteOut' => 9);
}

/**
* Generated VBoxWebService Enum Collection
*/
class VFSFileTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "VFSFileType";
}

/**
* Generated VBoxWebService ENUM
*/
class VirtualSystemDescriptionType extends VBox_Enum {
   public $NameMap = array(1 => 'Ignore', 2 => 'OS', 3 => 'Name', 4 => 'Product', 5 => 'Vendor', 6 => 'Version', 7 => 'ProductUrl', 8 => 'VendorUrl', 9 => 'Description', 10 => 'License', 11 => 'Miscellaneous', 12 => 'CPU', 13 => 'Memory', 14 => 'HardDiskControllerIDE', 15 => 'HardDiskControllerSATA', 16 => 'HardDiskControllerSCSI', 17 => 'HardDiskControllerSAS', 18 => 'HardDiskImage', 19 => 'Floppy', 20 => 'CDROM', 21 => 'NetworkAdapter', 22 => 'USBController', 23 => 'SoundCard');
   public $ValueMap = array('Ignore' => 1, 'OS' => 2, 'Name' => 3, 'Product' => 4, 'Vendor' => 5, 'Version' => 6, 'ProductUrl' => 7, 'VendorUrl' => 8, 'Description' => 9, 'License' => 10, 'Miscellaneous' => 11, 'CPU' => 12, 'Memory' => 13, 'HardDiskControllerIDE' => 14, 'HardDiskControllerSATA' => 15, 'HardDiskControllerSCSI' => 16, 'HardDiskControllerSAS' => 17, 'HardDiskImage' => 18, 'Floppy' => 19, 'CDROM' => 20, 'NetworkAdapter' => 21, 'USBController' => 22, 'SoundCard' => 23);
}

/**
* Generated VBoxWebService Enum Collection
*/
class VirtualSystemDescriptionTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "VirtualSystemDescriptionType";
}

/**
* Generated VBoxWebService ENUM
*/
class VirtualSystemDescriptionValueType extends VBox_Enum {
   public $NameMap = array(1 => 'Reference', 2 => 'Original', 3 => 'Auto', 4 => 'ExtraConfig');
   public $ValueMap = array('Reference' => 1, 'Original' => 2, 'Auto' => 3, 'ExtraConfig' => 4);
}

/**
* Generated VBoxWebService Enum Collection
*/
class VirtualSystemDescriptionValueTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "VirtualSystemDescriptionValueType";
}

/**
* Generated VBoxWebService ENUM
*/
class HostNetworkInterfaceMediumType extends VBox_Enum {
   public $NameMap = array(0 => 'Unknown', 1 => 'Ethernet', 2 => 'PPP', 3 => 'SLIP');
   public $ValueMap = array('Unknown' => 0, 'Ethernet' => 1, 'PPP' => 2, 'SLIP' => 3);
}

/**
* Generated VBoxWebService Enum Collection
*/
class HostNetworkInterfaceMediumTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "HostNetworkInterfaceMediumType";
}

/**
* Generated VBoxWebService ENUM
*/
class HostNetworkInterfaceStatus extends VBox_Enum {
   public $NameMap = array(0 => 'Unknown', 1 => 'Up', 2 => 'Down');
   public $ValueMap = array('Unknown' => 0, 'Up' => 1, 'Down' => 2);
}

/**
* Generated VBoxWebService Enum Collection
*/
class HostNetworkInterfaceStatusCollection extends VBox_EnumCollection {
   protected $_interfaceName = "HostNetworkInterfaceStatus";
}

/**
* Generated VBoxWebService ENUM
*/
class HostNetworkInterfaceType extends VBox_Enum {
   public $NameMap = array(1 => 'Bridged', 2 => 'HostOnly');
   public $ValueMap = array('Bridged' => 1, 'HostOnly' => 2);
}

/**
* Generated VBoxWebService Enum Collection
*/
class HostNetworkInterfaceTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "HostNetworkInterfaceType";
}

/**
* Generated VBoxWebService ENUM
*/
class MediumState extends VBox_Enum {
   public $NameMap = array(0 => 'NotCreated', 1 => 'Created', 2 => 'LockedRead', 3 => 'LockedWrite', 4 => 'Inaccessible', 5 => 'Creating', 6 => 'Deleting');
   public $ValueMap = array('NotCreated' => 0, 'Created' => 1, 'LockedRead' => 2, 'LockedWrite' => 3, 'Inaccessible' => 4, 'Creating' => 5, 'Deleting' => 6);
}

/**
* Generated VBoxWebService Enum Collection
*/
class MediumStateCollection extends VBox_EnumCollection {
   protected $_interfaceName = "MediumState";
}

/**
* Generated VBoxWebService ENUM
*/
class MediumType extends VBox_Enum {
   public $NameMap = array(0 => 'Normal', 1 => 'Immutable', 2 => 'Writethrough', 3 => 'Shareable');
   public $ValueMap = array('Normal' => 0, 'Immutable' => 1, 'Writethrough' => 2, 'Shareable' => 3);
}

/**
* Generated VBoxWebService Enum Collection
*/
class MediumTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "MediumType";
}

/**
* Generated VBoxWebService ENUM
*/
class MediumVariant extends VBox_Enum {
   public $NameMap = array(0 => 'Standard', 0x01 => 'VmdkSplit2G', 0x04 => 'VmdkStreamOptimized', 0x08 => 'VmdkESX', 0x10000 => 'Fixed', 0x20000 => 'Diff');
   public $ValueMap = array('Standard' => 0, 'VmdkSplit2G' => 0x01, 'VmdkStreamOptimized' => 0x04, 'VmdkESX' => 0x08, 'Fixed' => 0x10000, 'Diff' => 0x20000);
}

/**
* Generated VBoxWebService Enum Collection
*/
class MediumVariantCollection extends VBox_EnumCollection {
   protected $_interfaceName = "MediumVariant";
}

/**
* Generated VBoxWebService ENUM
*/
class DataType extends VBox_Enum {
   public $NameMap = array(0 => 'Int32', 1 => 'Int8', 2 => 'String');
   public $ValueMap = array('Int32' => 0, 'Int8' => 1, 'String' => 2);
}

/**
* Generated VBoxWebService Enum Collection
*/
class DataTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "DataType";
}

/**
* Generated VBoxWebService ENUM
*/
class DataFlags extends VBox_Enum {
   public $NameMap = array(0x00 => 'None', 0x01 => 'Mandatory', 0x02 => 'Expert', 0x04 => 'Array', 0x07 => 'FlagMask');
   public $ValueMap = array('None' => 0x00, 'Mandatory' => 0x01, 'Expert' => 0x02, 'Array' => 0x04, 'FlagMask' => 0x07);
}

/**
* Generated VBoxWebService Enum Collection
*/
class DataFlagsCollection extends VBox_EnumCollection {
   protected $_interfaceName = "DataFlags";
}

/**
* Generated VBoxWebService ENUM
*/
class MediumFormatCapabilities extends VBox_Enum {
   public $NameMap = array(0x01 => 'Uuid', 0x02 => 'CreateFixed', 0x04 => 'CreateDynamic', 0x08 => 'CreateSplit2G', 0x10 => 'Differencing', 0x20 => 'Asynchronous', 0x40 => 'File', 0x80 => 'Properties', 0xFF => 'CapabilityMask');
   public $ValueMap = array('Uuid' => 0x01, 'CreateFixed' => 0x02, 'CreateDynamic' => 0x04, 'CreateSplit2G' => 0x08, 'Differencing' => 0x10, 'Asynchronous' => 0x20, 'File' => 0x40, 'Properties' => 0x80, 'CapabilityMask' => 0xFF);
}

/**
* Generated VBoxWebService Enum Collection
*/
class MediumFormatCapabilitiesCollection extends VBox_EnumCollection {
   protected $_interfaceName = "MediumFormatCapabilities";
}

/**
* Generated VBoxWebService ENUM
*/
class MouseButtonState extends VBox_Enum {
   public $NameMap = array(0x01 => 'LeftButton', 0x02 => 'RightButton', 0x04 => 'MiddleButton', 0x08 => 'WheelUp', 0x10 => 'WheelDown', 0x20 => 'XButton1', 0x40 => 'XButton2', 0x7F => 'MouseStateMask');
   public $ValueMap = array('LeftButton' => 0x01, 'RightButton' => 0x02, 'MiddleButton' => 0x04, 'WheelUp' => 0x08, 'WheelDown' => 0x10, 'XButton1' => 0x20, 'XButton2' => 0x40, 'MouseStateMask' => 0x7F);
}

/**
* Generated VBoxWebService Enum Collection
*/
class MouseButtonStateCollection extends VBox_EnumCollection {
   protected $_interfaceName = "MouseButtonState";
}

/**
* Generated VBoxWebService ENUM
*/
class FramebufferPixelFormat extends VBox_Enum {
   public $NameMap = array(0 => 'Opaque', 0x32424752 => 'FOURCC_RGB');
   public $ValueMap = array('Opaque' => 0, 'FOURCC_RGB' => 0x32424752);
}

/**
* Generated VBoxWebService Enum Collection
*/
class FramebufferPixelFormatCollection extends VBox_EnumCollection {
   protected $_interfaceName = "FramebufferPixelFormat";
}

/**
* Generated VBoxWebService ENUM
*/
class NetworkAttachmentType extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'NAT', 2 => 'Bridged', 3 => 'Internal', 4 => 'HostOnly', 5 => 'VDE');
   public $ValueMap = array('Null' => 0, 'NAT' => 1, 'Bridged' => 2, 'Internal' => 3, 'HostOnly' => 4, 'VDE' => 5);
}

/**
* Generated VBoxWebService Enum Collection
*/
class NetworkAttachmentTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "NetworkAttachmentType";
}

/**
* Generated VBoxWebService ENUM
*/
class NetworkAdapterType extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'Am79C970A', 2 => 'Am79C973', 3 => 'I82540EM', 4 => 'I82543GC', 5 => 'I82545EM', 6 => 'Virtio');
   public $ValueMap = array('Null' => 0, 'Am79C970A' => 1, 'Am79C973' => 2, 'I82540EM' => 3, 'I82543GC' => 4, 'I82545EM' => 5, 'Virtio' => 6);
}

/**
* Generated VBoxWebService Enum Collection
*/
class NetworkAdapterTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "NetworkAdapterType";
}

/**
* Generated VBoxWebService ENUM
*/
class PortMode extends VBox_Enum {
   public $NameMap = array(0 => 'Disconnected', 1 => 'HostPipe', 2 => 'HostDevice', 3 => 'RawFile');
   public $ValueMap = array('Disconnected' => 0, 'HostPipe' => 1, 'HostDevice' => 2, 'RawFile' => 3);
}

/**
* Generated VBoxWebService Enum Collection
*/
class PortModeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "PortMode";
}

/**
* Generated VBoxWebService ENUM
*/
class USBDeviceState extends VBox_Enum {
   public $NameMap = array(0 => 'NotSupported', 1 => 'Unavailable', 2 => 'Busy', 3 => 'Available', 4 => 'Held', 5 => 'Captured');
   public $ValueMap = array('NotSupported' => 0, 'Unavailable' => 1, 'Busy' => 2, 'Available' => 3, 'Held' => 4, 'Captured' => 5);
}

/**
* Generated VBoxWebService Enum Collection
*/
class USBDeviceStateCollection extends VBox_EnumCollection {
   protected $_interfaceName = "USBDeviceState";
}

/**
* Generated VBoxWebService ENUM
*/
class USBDeviceFilterAction extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'Ignore', 2 => 'Hold');
   public $ValueMap = array('Null' => 0, 'Ignore' => 1, 'Hold' => 2);
}

/**
* Generated VBoxWebService Enum Collection
*/
class USBDeviceFilterActionCollection extends VBox_EnumCollection {
   protected $_interfaceName = "USBDeviceFilterAction";
}

/**
* Generated VBoxWebService ENUM
*/
class AudioDriverType extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'WinMM', 2 => 'OSS', 3 => 'ALSA', 4 => 'DirectSound', 5 => 'CoreAudio', 6 => 'MMPM', 7 => 'Pulse', 8 => 'SolAudio');
   public $ValueMap = array('Null' => 0, 'WinMM' => 1, 'OSS' => 2, 'ALSA' => 3, 'DirectSound' => 4, 'CoreAudio' => 5, 'MMPM' => 6, 'Pulse' => 7, 'SolAudio' => 8);
}

/**
* Generated VBoxWebService Enum Collection
*/
class AudioDriverTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "AudioDriverType";
}

/**
* Generated VBoxWebService ENUM
*/
class AudioControllerType extends VBox_Enum {
   public $NameMap = array(0 => 'AC97', 1 => 'SB16');
   public $ValueMap = array('AC97' => 0, 'SB16' => 1);
}

/**
* Generated VBoxWebService Enum Collection
*/
class AudioControllerTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "AudioControllerType";
}

/**
* Generated VBoxWebService ENUM
*/
class VRDPAuthType extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'External', 2 => 'Guest');
   public $ValueMap = array('Null' => 0, 'External' => 1, 'Guest' => 2);
}

/**
* Generated VBoxWebService Enum Collection
*/
class VRDPAuthTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "VRDPAuthType";
}

/**
* Generated VBoxWebService ENUM
*/
class StorageBus extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'IDE', 2 => 'SATA', 3 => 'SCSI', 4 => 'Floppy', 5 => 'SAS');
   public $ValueMap = array('Null' => 0, 'IDE' => 1, 'SATA' => 2, 'SCSI' => 3, 'Floppy' => 4, 'SAS' => 5);
}

/**
* Generated VBoxWebService Enum Collection
*/
class StorageBusCollection extends VBox_EnumCollection {
   protected $_interfaceName = "StorageBus";
}

/**
* Generated VBoxWebService ENUM
*/
class StorageControllerType extends VBox_Enum {
   public $NameMap = array(0 => 'Null', 1 => 'LsiLogic', 2 => 'BusLogic', 3 => 'IntelAhci', 4 => 'PIIX3', 5 => 'PIIX4', 6 => 'ICH6', 7 => 'I82078', 8 => 'LsiLogicSas');
   public $ValueMap = array('Null' => 0, 'LsiLogic' => 1, 'BusLogic' => 2, 'IntelAhci' => 3, 'PIIX3' => 4, 'PIIX4' => 5, 'ICH6' => 6, 'I82078' => 7, 'LsiLogicSas' => 8);
}

/**
* Generated VBoxWebService Enum Collection
*/
class StorageControllerTypeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "StorageControllerType";
}

/**
* Generated VBoxWebService ENUM
*/
class NATAliasMode extends VBox_Enum {
   public $NameMap = array(0x1 => 'AliasLog', 0x02 => 'AliasProxyOnly', 0x04 => 'AliasUseSamePorts');
   public $ValueMap = array('AliasLog' => 0x1, 'AliasProxyOnly' => 0x02, 'AliasUseSamePorts' => 0x04);
}

/**
* Generated VBoxWebService Enum Collection
*/
class NATAliasModeCollection extends VBox_EnumCollection {
   protected $_interfaceName = "NATAliasMode";
}

/**
* Generated VBoxWebService ENUM
*/
class NATProtocol extends VBox_Enum {
   public $NameMap = array(0 => 'UDP', 1 => 'TCP');
   public $ValueMap = array('UDP' => 0, 'TCP' => 1);
}

/**
* Generated VBoxWebService Enum Collection
*/
class NATProtocolCollection extends VBox_EnumCollection {
   protected $_interfaceName = "NATProtocol";
}
