/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_4_1;

import java.io.File;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.xpcom.Mozilla;
import org.virtualbox_4_1.EventListenerImpl;
import org.virtualbox_4_1.IEventListener;
import org.virtualbox_4_1.IMachine;
import org.virtualbox_4_1.IProgress;
import org.virtualbox_4_1.ISession;
import org.virtualbox_4_1.IVirtualBox;
import org.virtualbox_4_1.LockType;
import org.virtualbox_4_1.VBoxException;

public class VirtualBoxManager {
    private Mozilla mozilla;
    private IVirtualBox vbox;
    private nsIComponentManager componentManager;
    private static boolean hasInstance = false;
    private static boolean isMozillaInited = false;

    private VirtualBoxManager(Mozilla mozilla) {
        this.mozilla = mozilla;
        this.componentManager = mozilla.getComponentManager();
        this.vbox = new IVirtualBox((org.mozilla.interfaces.IVirtualBox)this.componentManager.createInstanceByContractID("@virtualbox.org/VirtualBox;1", null, "{c28be65f-1a8f-43b4-81f1-eb60cb516e66}"));
    }

    public void connect(String string, String string2, String string3) {
        throw new RuntimeException("Connect doesn't make sense for local bindings");
    }

    public void disconnect() {
        throw new RuntimeException("Disconnect doesn't make sense for local bindings");
    }

    public static void initPerThread() {
    }

    public static void deinitPerThread() {
    }

    public IVirtualBox getVBox() {
        return this.vbox;
    }

    public ISession getSessionObject() {
        return new ISession((org.mozilla.interfaces.ISession)this.componentManager.createInstanceByContractID("@virtualbox.org/Session;1", null, "{12F4DCDB-12B2-4EC1-B7CD-DDD9F6C5BF4D}"));
    }

    public ISession openMachineSession(IMachine iMachine) throws Exception {
        ISession iSession = this.getSessionObject();
        iMachine.lockMachine(iSession, LockType.Shared);
        return iSession;
    }

    public void closeMachineSession(ISession iSession) {
        if (iSession != null) {
            iSession.unlockMachine();
        }
    }

    public static synchronized VirtualBoxManager createInstance(String string) {
        if (hasInstance) {
            throw new VBoxException(null, "only one instance at the time allowed");
        }
        if (string == null || "".equals(string)) {
            string = System.getProperty("vbox.home");
        }
        if (string == null) {
            throw new RuntimeException("vbox.home Java property must be defined to use XPCOM bridge");
        }
        File file = new File(string);
        Mozilla mozilla = Mozilla.getInstance();
        if (!isMozillaInited) {
            mozilla.initialize(file);
            try {
                mozilla.initXPCOM(file, null);
                isMozillaInited = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        hasInstance = true;
        return new VirtualBoxManager(mozilla);
    }

    public IEventListener createListener(Object object) {
        return new IEventListener(new EventListenerImpl(object));
    }

    public void cleanup() {
        VirtualBoxManager.deinitPerThread();
        this.mozilla = null;
        hasInstance = false;
    }

    public boolean progressBar(IProgress iProgress, int n) {
        long l = System.currentTimeMillis() + (long)n;
        while (!iProgress.getCompleted().booleanValue()) {
            this.mozilla.waitForEvents(0L);
            iProgress.waitForCompletion(n);
            if (System.currentTimeMillis() < l) continue;
            return false;
        }
        return true;
    }

    public boolean startVm(String string, String string2, int n) {
        IMachine iMachine = this.vbox.findMachine(string);
        if (iMachine == null) {
            return false;
        }
        ISession iSession = this.getSessionObject();
        if (string2 == null) {
            string2 = "gui";
        }
        IProgress iProgress = iMachine.launchVMProcess(iSession, string2, "");
        this.progressBar(iProgress, n);
        iSession.unlockMachine();
        return true;
    }

    public void waitForEvents(long l) {
        this.mozilla.waitForEvents(l);
    }
}

