
/*
 *  Copyright (C) 2010-2011 Oracle Corporation
 *
 *  This file is part of the VirtualBox SDK, as available from
 *  http://www.virtualbox.org.  This library is free software; you can
 *  redistribute it and/or modify it under the terms of the GNU Lesser General
 *  Public License as published by the Free Software Foundation, in version 2.1
 *  as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 *  This library is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 *  License for more details.
 *
 * IGuest.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_4_1;

import org.virtualbox_4_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;

/**

      The IGuest interface represents information about the operating system
      running inside the virtual machine. Used in
      {@link org.virtualbox_4_1.IConsole#getGuest()}.

      IGuest provides information about the guest operating system, whether
      Guest Additions are installed and other OS-specific virtual machine
      properties.
    
Interface ID: <tt>{ED109B6E-0578-4B17-8ACE-52646789F1A0}</tt>
*/
public class IGuest extends IUnknown {

    public IGuest(String wrapped, VboxPortType port) {
          super(wrapped, port);
    }
/**

        Identifier of the Guest OS type as reported by the Guest
        Additions.
        You may use {@link org.virtualbox_4_1.IVirtualBox#getGuestOSType(String)} to obtain
        an IGuestOSType object representing details about the given
        Guest OS type.
        
NOTE: 
          If Guest Additions are not installed, this value will be
          the same as {@link org.virtualbox_4_1.IMachine#getOSTypeId()}.
        

@return String

*/
    public String getOSTypeId() {
      try {
         String retVal = port.iGuestGetOSTypeId(obj);
         return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Current run level of the Guest Additions.
      
@return org.virtualbox_4_1.AdditionsRunLevelType

*/
    public org.virtualbox_4_1.AdditionsRunLevelType getAdditionsRunLevel() {
      try {
         org.virtualbox_4_1.jaxws.AdditionsRunLevelType retVal = port.iGuestGetAdditionsRunLevel(obj);
         return org.virtualbox_4_1.AdditionsRunLevelType.fromValue(retVal.value());
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Version of the Guest Additions including the revision (3 decimal numbers
        separated by dots + revision number) installed on the guest or empty
        when the Additions are not installed.
      
@return String

*/
    public String getAdditionsVersion() {
      try {
         String retVal = port.iGuestGetAdditionsVersion(obj);
         return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Array of current known facilities. Only returns facilities where a status is known,
        e.g. facilities with an unknown status will not be returned.
      
@return List<org.virtualbox_4_1.IAdditionsFacility>

*/
    public List<org.virtualbox_4_1.IAdditionsFacility> getFacilities() {
      try {
         List<org.virtualbox_4_1.jaxws.IAdditionsFacility> retVal = port.iGuestGetFacilities(obj);
         return Helper.wrap2(org.virtualbox_4_1.IAdditionsFacility.class, org.virtualbox_4_1.jaxws.IAdditionsFacility.class, port, retVal);
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**
Guest system memory balloon size in megabytes (transient property).
@return Long

*/
    public Long getMemoryBalloonSize() {
      try {
         Long retVal = port.iGuestGetMemoryBalloonSize(obj);
         return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**
Guest system memory balloon size in megabytes (transient property).
@param value Long

*/
    public void setMemoryBalloonSize(Long value) {
      try {
        port.iGuestSetMemoryBalloonSize(obj, value);
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**
Interval to update guest statistics in seconds.
@return Long

*/
    public Long getStatisticsUpdateInterval() {
      try {
         Long retVal = port.iGuestGetStatisticsUpdateInterval(obj);
         return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**
Interval to update guest statistics in seconds.
@param value Long

*/
    public void setStatisticsUpdateInterval(Long value) {
      try {
        port.iGuestSetStatisticsUpdateInterval(obj, value);
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
    public static IGuest queryInterface(IUnknown obj) {
       return obj == null ?  null : new IGuest(obj.getWrapped(), obj.getRemoteWSPort());
    }
/**

        Internal method; do not use as it might change at any time.
      
@param cpuUser Percentage of processor time spent in user mode as seen by the guest.

@param cpuKernel Percentage of processor time spent in kernel mode as seen by the guest.

@param cpuIdle Percentage of processor time spent idling as seen by the guest.

@param memTotal Total amount of physical guest RAM.

@param memFree Free amount of physical guest RAM.

@param memBalloon Amount of ballooned physical guest RAM.

@param memShared Amount of shared physical guest RAM.

@param memCache Total amount of guest (disk) cache memory.

@param pagedTotal Total amount of space in the page file.

@param memAllocTotal Total amount of memory allocated by the hypervisor.

@param memFreeTotal Total amount of free memory available in the hypervisor.

@param memBalloonTotal Total amount of memory ballooned by the hypervisor.

@param memSharedTotal Total amount of shared memory in the hypervisor.

*/
    public void internalGetStatistics(Holder<Long> cpuUser, Holder<Long> cpuKernel, Holder<Long> cpuIdle, Holder<Long> memTotal, Holder<Long> memFree, Holder<Long> memBalloon, Holder<Long> memShared, Holder<Long> memCache, Holder<Long> pagedTotal, Holder<Long> memAllocTotal, Holder<Long> memFreeTotal, Holder<Long> memBalloonTotal, Holder<Long> memSharedTotal) {
      try {
        javax.xml.ws.Holder<Long>   tmp_cpuUser = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_cpuKernel = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_cpuIdle = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_memTotal = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_memFree = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_memBalloon = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_memShared = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_memCache = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_pagedTotal = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_memAllocTotal = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_memFreeTotal = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_memBalloonTotal = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_memSharedTotal = new  javax.xml.ws.Holder<Long>();
        port.iGuestInternalGetStatistics(obj, tmp_cpuUser, tmp_cpuKernel, tmp_cpuIdle, tmp_memTotal, tmp_memFree, tmp_memBalloon, tmp_memShared, tmp_memCache, tmp_pagedTotal, tmp_memAllocTotal, tmp_memFreeTotal, tmp_memBalloonTotal, tmp_memSharedTotal);
        cpuUser.value = tmp_cpuUser.value;
        cpuKernel.value = tmp_cpuKernel.value;
        cpuIdle.value = tmp_cpuIdle.value;
        memTotal.value = tmp_memTotal.value;
        memFree.value = tmp_memFree.value;
        memBalloon.value = tmp_memBalloon.value;
        memShared.value = tmp_memShared.value;
        memCache.value = tmp_memCache.value;
        pagedTotal.value = tmp_pagedTotal.value;
        memAllocTotal.value = tmp_memAllocTotal.value;
        memFreeTotal.value = tmp_memFreeTotal.value;
        memBalloonTotal.value = tmp_memBalloonTotal.value;
        memSharedTotal.value = tmp_memSharedTotal.value;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Get the current status of a Guest Additions facility.
      
@param facility Facility to check status for.

@param timestamp Timestamp (in ms) of last status update seen by the host.

@return The current (latest) facility status.

*/
    public org.virtualbox_4_1.AdditionsFacilityStatus getFacilityStatus(org.virtualbox_4_1.AdditionsFacilityType facility, Holder<Long> timestamp) {
      try {
        javax.xml.ws.Holder<Long>   tmp_timestamp = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<org.virtualbox_4_1.jaxws.AdditionsFacilityStatus> retVal = new javax.xml.ws.Holder<org.virtualbox_4_1.jaxws.AdditionsFacilityStatus>();
        port.iGuestGetFacilityStatus(obj, org.virtualbox_4_1.jaxws.AdditionsFacilityType.fromValue(facility.name()), tmp_timestamp, retVal);
        timestamp.value = tmp_timestamp.value;
        return org.virtualbox_4_1.AdditionsFacilityStatus.fromValue(retVal.value.value());
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Retrieve the current status of a certain Guest Additions run level.

        
@param level Status level to check

@return Flag whether the status level has been reached or not

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_NOT_SUPPORTED VBOX_E_NOT_SUPPORTED</td><td>
          Wrong status level specified.
        </td><tr>
</table>

*/
    public Boolean getAdditionsStatus(org.virtualbox_4_1.AdditionsRunLevelType level) {
      try {
        Boolean     retVal;
        retVal = port.iGuestGetAdditionsStatus(obj, org.virtualbox_4_1.jaxws.AdditionsRunLevelType.fromValue(level.name()));
        return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Store login credentials that can be queried by guest operating
        systems with Additions installed. The credentials are transient
        to the session and the guest may also choose to erase them. Note
        that the caller cannot determine whether the guest operating system
        has queried or made use of the credentials.

        
@param userName User name string, can be empty

@param password Password string, can be empty

@param domain Domain name (guest logon scheme specific), can be empty

@param allowInteractiveLogon 
          Flag whether the guest should alternatively allow the user to
          interactively specify different credentials. This flag might
          not be supported by all versions of the Additions.
        

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_VM_ERROR VBOX_E_VM_ERROR</td><td>
          VMM device is not available.
        </td><tr>
</table>

*/
    public void setCredentials(String userName, String password, String domain, Boolean allowInteractiveLogon) {
      try {
        port.iGuestSetCredentials(obj, userName, password, domain, allowInteractiveLogon);
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Executes an existing program inside the guest VM.

        
@param execName 
          Full path name of the command to execute on the guest; the
          commands has to exists in the guest VM in order to be executed.
        

@param flags {@link org.virtualbox_4_1.ExecuteProcessFlag} flags.
        

@param arguments 
          Array of arguments passed to the execution command.
        

@param environment 
          Environment variables that can be set while the command is being
          executed, in form of "NAME=VALUE"; one pair per entry. To unset a
          variable just set its name ("NAME") without a value.
        

@param userName 
          User name under which the command will be executed; has to exist
          and have the appropriate rights to execute programs in the VM.
        

@param password 
          Password of the user account specified.
        

@param timeoutMS 
          The maximum timeout value (in msec) to wait for finished program
          execution. Pass 0 for an infinite timeout.
        

@param pid 
          The PID (process ID) of the started command for later reference.
        

@return Progress object to track the operation completion.

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Could not execute process.
        </td><tr>
</table>

NOTE: 
        Starting at VirtualBox 4.1.8 guest process execution by default is limited
        to serve up to 25 guest processes at a time. If all 25 guest processes
        are still active and running, starting a new guest process will result in an
        appropriate error message.

        If ExecuteProcessFlag_WaitForStdOut and/or respectively
        ExecuteProcessFlag_WaitForStdErr of {@link org.virtualbox_4_1.ExecuteProcessFlag} is
        set, the guest process will not exit until all data from the specified
        stream(s) is/are read out.

        To raise or lower the guest process execution limit, either the guest property
        "/VirtualBox/GuestAdd/VBoxService/--control-procs-max-kept" or VBoxService'
        command line by specifying "--control-procs-max-kept" needs to be modified.
        A restart of the guest OS is required afterwards. To serve unlimited guest
        processes, a value of "0" needs to be set (not recommended).
        

*/
    public org.virtualbox_4_1.IProgress executeProcess(String execName, Long flags, List<String> arguments, List<String> environment, String userName, String password, Long timeoutMS, Holder<Long> pid) {
      try {
        javax.xml.ws.Holder<Long>   tmp_pid = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<String> retVal = new javax.xml.ws.Holder<String>();
        port.iGuestExecuteProcess(obj, execName, flags, arguments, environment, userName, password, timeoutMS, tmp_pid, retVal);
        pid.value = tmp_pid.value;
        return (retVal.value.length() > 0) ? new org.virtualbox_4_1.IProgress(retVal.value, port) : null;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Retrieves output of a formerly started and running guest process.

        
@param pid 
          Process id returned by earlier {@link #executeProcess(String,Long,List,List,String,String,Long,Holder)} call.
        

@param flags {@link org.virtualbox_4_1.ProcessOutputFlag} flags.
        

@param timeoutMS 
          The maximum timeout value (in msec) to wait for output
          data. Pass 0 for an infinite timeout.
        

@param size 
          Size in bytes to read in the buffer.
        

@return 
          Buffer for retrieving the actual output. A data size of 0 means end of file
          if the requested size was not 0. This is the unprocessed
          output data, i.e. the line ending style depends on the platform of
          the system the server is running on.
        

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Could not retrieve output.
        </td><tr>
</table>

NOTE: 
        Starting with VirtualBox 4.1.8 this only will return output data
        from stdout or stderr if flag ExecuteProcessFlag_WaitForStdOut
        and/or respectively ExecuteProcessFlag_WaitForStdErr of
        {@link org.virtualbox_4_1.ExecuteProcessFlag} is set in the
        former {@link #executeProcess(String,Long,List,List,String,String,Long,Holder)} call for this guest process.
        

*/
    public byte[] getProcessOutput(Long pid, Long flags, Long timeoutMS, Long size) {
      try {
        /*base64*/String     retVal;
        retVal = port.iGuestGetProcessOutput(obj, pid, flags, timeoutMS, size);
        return Helper.decodeBase64(retVal);
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Retrieves status, exit code and the exit reason of a formerly started
        guest process. If a guest process exited or got terminated this function
        returns its final status and removes this process from the list of 
        known guest processes for further retrieval.

        
@param pid 
          Process id returned by earlier {@link #executeProcess(String,Long,List,List,String,String,Long,Holder)} call.
        

@param exitcode 
          The exit code (if available).
        

@param flags 
          Additional flags of process status. Not used at the moment and
          must be set to 0.
        

@return 
          The current process status.
        

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Process with specified PID was not found.
        </td><tr>
</table>

*/
    public org.virtualbox_4_1.ExecuteProcessStatus getProcessStatus(Long pid, Holder<Long> exitcode, Holder<Long> flags) {
      try {
        javax.xml.ws.Holder<Long>   tmp_exitcode = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long>   tmp_flags = new  javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<org.virtualbox_4_1.jaxws.ExecuteProcessStatus> retVal = new javax.xml.ws.Holder<org.virtualbox_4_1.jaxws.ExecuteProcessStatus>();
        port.iGuestGetProcessStatus(obj, pid, tmp_exitcode, tmp_flags, retVal);
        exitcode.value = tmp_exitcode.value;
        flags.value = tmp_flags.value;
        return org.virtualbox_4_1.ExecuteProcessStatus.fromValue(retVal.value.value());
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Copies files/directories from guest to the host.

        
@param source 
          Source file on the guest to copy.
        

@param dest 
          Destination path on the host.
        

@param userName 
          User name under which the copy command will be executed; the
          user has to exist and have the appropriate rights to read from
          the source path.
        

@param password 
          Password of the user account specified.
        

@param flags {@link org.virtualbox_4_1.CopyFileFlag} flags. Not used at the moment and should be set to 0.
        

@return Progress object to track the operation completion.

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Error while copying.
        </td><tr>
</table>

*/
    public org.virtualbox_4_1.IProgress copyFromGuest(String source, String dest, String userName, String password, Long flags) {
      try {
        String     retVal;
        retVal = port.iGuestCopyFromGuest(obj, source, dest, userName, password, flags);
        return (retVal.length() > 0) ? new org.virtualbox_4_1.IProgress(retVal, port) : null;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Copies files/directories from host to the guest.

        
@param source 
          Source file on the host to copy.
        

@param dest 
          Destination path on the guest.
        

@param userName 
          User name under which the copy command will be executed; the
          user has to exist and have the appropriate rights to write to
          the destination path.
        

@param password 
          Password of the user account specified.
        

@param flags {@link org.virtualbox_4_1.CopyFileFlag} flags. Not used at the moment and should be set to 0.
        

@return Progress object to track the operation completion.

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Error while copying.
        </td><tr>
</table>

*/
    public org.virtualbox_4_1.IProgress copyToGuest(String source, String dest, String userName, String password, Long flags) {
      try {
        String     retVal;
        retVal = port.iGuestCopyToGuest(obj, source, dest, userName, password, flags);
        return (retVal.length() > 0) ? new org.virtualbox_4_1.IProgress(retVal, port) : null;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Closes a formerly opened guest directory.

        
@param handle 
          Handle of opened directory to close.
        

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Error while closing directory.
        </td><tr>
</table>

*/
    public void directoryClose(Long handle) {
      try {
        port.iGuestDirectoryClose(obj, handle);
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Creates a directory on the guest.

        
@param directory 
          Directory to create.
        

@param userName 
          User name under which the directory creation will be executed; the
          user has to exist and have the appropriate rights to create the
          desired directory.
        

@param password 
          Password of the user account specified.
        

@param mode 
          File mode.
        

@param flags {@link org.virtualbox_4_1.DirectoryCreateFlag} flags.
        

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Error while creating directory.
        </td><tr>
</table>

*/
    public void directoryCreate(String directory, String userName, String password, Long mode, Long flags) {
      try {
        port.iGuestDirectoryCreate(obj, directory, userName, password, mode, flags);
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Opens a directory on the guest.

        
@param directory 
          Directory to read.
        

@param filter 
          Directory filter (DOS style wildcards). Set to empty
          string if no filter required.
        

@param flags {@link org.virtualbox_4_1.DirectoryOpenFlag} flags.
        

@param userName 
          User name under which the directory reading will be performed; the
          user has to exist and have the appropriate rights to access / read the
          desired directory.
        

@param password 
          Password of the user account specified.
        

@return 
          Handle of opened directory returned by openDirectory.
        

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Error while opening / reading directory.
        </td><tr>
</table>

*/
    public Long directoryOpen(String directory, String filter, Long flags, String userName, String password) {
      try {
        Long     retVal;
        retVal = port.iGuestDirectoryOpen(obj, directory, filter, flags, userName, password);
        return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Reads the next directory entry of an opened guest directory.

        
@param handle 
          Handle of opened directory returned by openDirectory.
        

@return 
          Information about next directory entry on success.
        

Expected result codes:
<table>
<tr><td>E_ABORT</td><td>
          When the end of the directory has been reached.
        </td><tr>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Error while opening / reading directory.
        </td><tr>
</table>

*/
    public org.virtualbox_4_1.IGuestDirEntry directoryRead(Long handle) {
      try {
        org.virtualbox_4_1.jaxws.IGuestDirEntry     retVal;
        retVal = port.iGuestDirectoryRead(obj, handle);
        return (retVal != null) ? new org.virtualbox_4_1.IGuestDirEntry(retVal, port) : null;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Checks if the specified file name exists and is a regular file.

        If the file name ends with a slash or backslash, the function assumes
        it's a directory and will check if the specified directory exists and
        is a regular directory.

        
@param file 
          Full path of file to check.
        

@param userName 
          User name under which the lookup will be performed; the
          user has to exist and have the appropriate rights to access / read the
          desired directory.
        

@param password 
          Password of the user account specified.
        

@return 
          True if it's a regular file, false if it isn't (or doesn't exist).
        

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Error while looking up information.
        </td><tr>
</table>

*/
    public Boolean fileExists(String file, String userName, String password) {
      try {
        Boolean     retVal;
        retVal = port.iGuestFileExists(obj, file, userName, password);
        return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Queries the size of a file, given the path to it.

        
@param file 
          Full path of file to query file size for.
        

@param userName 
          User name under which the lookup will be performed; the
          user has to exist and have the appropriate rights to access / read the
          desired directory.
        

@param password 
          Password of the user account specified.
        

@return 
          Size (in bytes) of file specified.
        

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Error while looking up information.
        </td><tr>
</table>

*/
    public Long fileQuerySize(String file, String userName, String password) {
      try {
        Long     retVal;
        retVal = port.iGuestFileQuerySize(obj, file, userName, password);
        return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Sends input into a formerly started process.

        
@param pid 
          Process id returned by earlier {@link #executeProcess(String,Long,List,List,String,String,Long,Holder)} call.
        

@param flags {@link org.virtualbox_4_1.ProcessInputFlag} flags.
        

@param timeoutMS 
          The maximum timeout value (in msec) to wait for getting the
          data transfered to the guest. Pass 0 for an infinite timeout.
        

@param data 
          Buffer of input data to send to the started process to.
        

@return 
          Number of bytes written.
        

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Could not send input.
        </td><tr>
</table>

*/
    public Long setProcessInput(Long pid, Long flags, Long timeoutMS, byte[] data) {
      try {
        Long     retVal;
        retVal = port.iGuestSetProcessInput(obj, pid, flags, timeoutMS, Helper.encodeBase64(data));
        return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Updates already installed Guest Additions in a VM
        (Windows guests only).

        
@param source 
          Path to the Guest Additions .ISO file to use for the upate.
        

@param flags {@link org.virtualbox_4_1.AdditionsUpdateFlag} flags.
        

@return Progress object to track the operation completion.

Expected result codes:
<table>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>
          Error while updating.
        </td><tr>
</table>

*/
    public org.virtualbox_4_1.IProgress updateGuestAdditions(String source, Long flags) {
      try {
        String     retVal;
        retVal = port.iGuestUpdateGuestAdditions(obj, source, flags);
        return (retVal.length() > 0) ? new org.virtualbox_4_1.IProgress(retVal, port) : null;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
}
