
/*
 *  Copyright (C) 2010-2011 Oracle Corporation
 *
 *  This file is part of the VirtualBox SDK, as available from
 *  http://www.virtualbox.org.  This library is free software; you can
 *  redistribute it and/or modify it under the terms of the GNU Lesser General
 *  Public License as published by the Free Software Foundation, in version 2.1
 *  as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 *  This library is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 *  License for more details.
 *
 * KeyboardHidType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_4_1;

import org.virtualbox_4_1.jaxws.*;
import javax.xml.ws.*;
/**

      Type of keyboard device used in a virtual machine.
    
Interface ID: <tt>{5A5B0996-3A3E-44BB-9019-56979812CBCC}</tt>
*/
public enum KeyboardHidType {

/**
No keyboard.
*/
    None(1),
/**
PS/2 keyboard.
*/
    PS2Keyboard(2),
/**
USB keyboard.
*/
    USBKeyboard(3),
/**
Combined device, working as PS/2 or USB keyboard, depending on guest behavior.
      Using of such device can have negative performance implications. 
*/
    ComboKeyboard(4);

    private final int value;

    KeyboardHidType(int v) {
        value = v;
    }

    public int value() {
        return value;
    }

    public static KeyboardHidType fromValue(long v) {
        for (KeyboardHidType c: KeyboardHidType.values()) {
            if (c.value == (int)v) {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static KeyboardHidType fromValue(String v) {
        return valueOf(KeyboardHidType.class, v);
    }
}

