
/*
 *  Copyright (C) 2010-2011 Oracle Corporation
 *
 *  This file is part of the VirtualBox SDK, as available from
 *  http://www.virtualbox.org.  This library is free software; you can
 *  redistribute it and/or modify it under the terms of the GNU Lesser General
 *  Public License as published by the Free Software Foundation, in version 2.1
 *  as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 *  This library is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 *  License for more details.
 *
 * ExecuteProcessFlag.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_4_1;

import org.virtualbox_4_1.jaxws.*;
import javax.xml.ws.*;
/**

      Guest process execution flags.
    
Interface ID: <tt>{286CEB91-5F66-4C96-9845-4483E90E00AE}</tt>
*/
public enum ExecuteProcessFlag {

/**
No flag set.
*/
    None(0),
/**
Only use the specified timeout value to wait for starting the guest process - the guest
        process itself then uses an infinite timeout.
*/
    WaitForProcessStartOnly(1),
/**
Do not report an error when executed processes are still alive when VBoxService or the guest OS is shutting down.
*/
    IgnoreOrphanedProcesses(2),
/**
Don't show the started process according to the guest OS guidelines.
*/
    Hidden(4),
/**
Do not use the user's profile data when exeuting a process.
*/
    NoProfile(8);

    private final int value;

    ExecuteProcessFlag(int v) {
        value = v;
    }

    public int value() {
        return value;
    }

    public static ExecuteProcessFlag fromValue(long v) {
        for (ExecuteProcessFlag c: ExecuteProcessFlag.values()) {
            if (c.value == (int)v) {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static ExecuteProcessFlag fromValue(String v) {
        return valueOf(ExecuteProcessFlag.class, v);
    }
}

