
/*
 *  Copyright (C) 2010-2011 Oracle Corporation
 *
 *  This file is part of the VirtualBox SDK, as available from
 *  http://www.virtualbox.org.  This library is free software; you can
 *  redistribute it and/or modify it under the terms of the GNU Lesser General
 *  Public License as published by the Free Software Foundation, in version 2.1
 *  as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 *  This library is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 *  License for more details.
 *
 * ExecuteProcessStatus.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_4_1;

import org.virtualbox_4_1.jaxws.*;
import javax.xml.ws.*;
/**

      Guest process execution status.
    
Interface ID: <tt>{153768D9-D971-4098-8B5A-C5CB1AB9EA88}</tt>
*/
public enum ExecuteProcessStatus {

/**
Process is in an undefined state.
*/
    Undefined(0),
/**
Process has been started.
*/
    Started(1),
/**
Process terminated normally.
*/
    TerminatedNormally(2),
/**
Process terminated via signal.
*/
    TerminatedSignal(3),
/**
Process terminated abnormally.
*/
    TerminatedAbnormally(4),
/**
Process timed out and was killed.
*/
    TimedOutKilled(5),
/**
Process timed out and was not killed successfully.
*/
    TimedOutAbnormally(6),
/**
Service/OS is stopping, process was killed.
*/
    Down(7),
/**
Something went wrong (error code in flags).
*/
    Error(8);

    private final int value;

    ExecuteProcessStatus(int v) {
        value = v;
    }

    public int value() {
        return value;
    }

    public static ExecuteProcessStatus fromValue(long v) {
        for (ExecuteProcessStatus c: ExecuteProcessStatus.values()) {
            if (c.value == (int)v) {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static ExecuteProcessStatus fromValue(String v) {
        return valueOf(ExecuteProcessStatus.class, v);
    }
}

