
/*
 *  Copyright (C) 2010-2011 Oracle Corporation
 *
 *  This file is part of the VirtualBox SDK, as available from
 *  http://www.virtualbox.org.  This library is free software; you can
 *  redistribute it and/or modify it under the terms of the GNU Lesser General
 *  Public License as published by the Free Software Foundation, in version 2.1
 *  as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 *  This library is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 *  License for more details.
 *
 * IHostPciDevicePlugEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_4_1;

import org.virtualbox_4_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;

/**

      Notification when host PCI device is plugged/unplugged. Plugging
      usually takes place on VM startup, unplug - when
      {@link org.virtualbox_4_1.IMachine#detachHostPciDevice(Integer)} is called.

      
@see org.virtualbox_4_1.IMachine#detachHostPciDevice(Integer)

Interface ID: <tt>{9CEBFC27-C579-4965-8EB7-D31794CD7DCF}</tt>
*/
public class IHostPciDevicePlugEvent extends IMachineEvent {

    public IHostPciDevicePlugEvent(String wrapped, VboxPortType port) {
          super(wrapped, port);
    }
/**

      If device successfully plugged or unplugged.
      
@return Boolean

*/
    public Boolean getPlugged() {
      try {
         Boolean retVal = port.iHostPciDevicePlugEventGetPlugged(obj);
         return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        If operation was successful, if false - 'message' attribute
        may be of interest.
      
@return Boolean

*/
    public Boolean getSuccess() {
      try {
         Boolean retVal = port.iHostPciDevicePlugEventGetSuccess(obj);
         return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Attachment info for this device.
      
@return org.virtualbox_4_1.IPciDeviceAttachment

*/
    public org.virtualbox_4_1.IPciDeviceAttachment getAttachment() {
      try {
         org.virtualbox_4_1.jaxws.IPciDeviceAttachment retVal = port.iHostPciDevicePlugEventGetAttachment(obj);
         return (retVal != null) ? new org.virtualbox_4_1.IPciDeviceAttachment(retVal, port) : null;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
/**

        Optional error message.
      
@return String

*/
    public String getMessage() {
      try {
         String retVal = port.iHostPciDevicePlugEventGetMessage(obj);
         return retVal;
     } catch (InvalidObjectFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     } catch (RuntimeFaultMsg e) {
          throw new VBoxException(e, e.getMessage());
     }
    }
    public static IHostPciDevicePlugEvent queryInterface(IUnknown obj) {
       return obj == null ?  null : new IHostPciDevicePlugEvent(obj.getWrapped(), obj.getRemoteWSPort());
    }
}
