
/*
 *  Copyright (C) 2010-2011 Oracle Corporation
 *
 *  This file is part of the VirtualBox SDK, as available from
 *  http://www.virtualbox.org.  This library is free software; you can
 *  redistribute it and/or modify it under the terms of the GNU Lesser General
 *  Public License as published by the Free Software Foundation, in version 2.1
 *  as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 *  This library is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 *  License for more details.
 *
 * VBoxEventType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_4_1;

import org.virtualbox_4_1.jaxws.*;
import javax.xml.ws.*;
/**

      Type of an event.
      See {@link org.virtualbox_4_1.IEvent} for an introduction to VirtualBox event handling.
    
Interface ID: <tt>{CCE48DB6-8561-479D-8D46-1358BAB45D4E}</tt>
*/
public enum VBoxEventType {

/**

        Invalid event, must be first.
      
*/
    Invalid(0),
/**

        Wildcard for all events.
        Events of this type are never delivered, and only used in
        {@link org.virtualbox_4_1.IEventSource#registerListener(org.virtualbox_4_1.IEventListener,List,Boolean)} call to simplify registration.
      
*/
    Any(1),
/**

        Wildcard for all vetoable events. Events of this type are never delivered, and only
        used in {@link org.virtualbox_4_1.IEventSource#registerListener(org.virtualbox_4_1.IEventListener,List,Boolean)} call to simplify registration.
      
*/
    Vetoable(2),
/**

        Wildcard for all machine events. Events of this type are never delivered, and only used in
        {@link org.virtualbox_4_1.IEventSource#registerListener(org.virtualbox_4_1.IEventListener,List,Boolean)} call to simplify registration.
      
*/
    MachineEvent(3),
/**

        Wildcard for all snapshot events. Events of this type are never delivered, and only used in
        {@link org.virtualbox_4_1.IEventSource#registerListener(org.virtualbox_4_1.IEventListener,List,Boolean)} call to simplify registration.
      
*/
    SnapshotEvent(4),
/**

        Wildcard for all input device (keyboard, mouse) events.
        Events of this type are never delivered, and only used in
        {@link org.virtualbox_4_1.IEventSource#registerListener(org.virtualbox_4_1.IEventListener,List,Boolean)} call to simplify registration.
      
*/
    InputEvent(5),
/**

        Last wildcard.
      
*/
    LastWildcard(31),
/**

        See {@link org.virtualbox_4_1.IMachineStateChangedEvent}.
      
*/
    OnMachineStateChanged(32),
/**

        See {@link org.virtualbox_4_1.IMachineDataChangedEvent}.
      
*/
    OnMachineDataChanged(33),
/**

        See {@link org.virtualbox_4_1.IExtraDataChangedEvent}.
      
*/
    OnExtraDataChanged(34),
/**

        See {@link org.virtualbox_4_1.IExtraDataCanChangeEvent}.
      
*/
    OnExtraDataCanChange(35),
/**

        See {@link org.virtualbox_4_1.IMediumRegisteredEvent}.
      
*/
    OnMediumRegistered(36),
/**

        See {@link org.virtualbox_4_1.IMachineRegisteredEvent}.
      
*/
    OnMachineRegistered(37),
/**

        See {@link org.virtualbox_4_1.ISessionStateChangedEvent}.
      
*/
    OnSessionStateChanged(38),
/**

        See {@link org.virtualbox_4_1.ISnapshotTakenEvent}.
      
*/
    OnSnapshotTaken(39),
/**

        See {@link org.virtualbox_4_1.ISnapshotDeletedEvent}.
      
*/
    OnSnapshotDeleted(40),
/**

        See {@link org.virtualbox_4_1.ISnapshotChangedEvent}.
      
*/
    OnSnapshotChanged(41),
/**

        See {@link org.virtualbox_4_1.IGuestPropertyChangedEvent}.
      
*/
    OnGuestPropertyChanged(42),
/**

        See {@link org.virtualbox_4_1.IMousePointerShapeChangedEvent}.
      
*/
    OnMousePointerShapeChanged(43),
/**

        See {@link org.virtualbox_4_1.IMouseCapabilityChangedEvent}.
      
*/
    OnMouseCapabilityChanged(44),
/**

        See {@link org.virtualbox_4_1.IKeyboardLedsChangedEvent}.
      
*/
    OnKeyboardLedsChanged(45),
/**

        See {@link org.virtualbox_4_1.IStateChangedEvent}.
      
*/
    OnStateChanged(46),
/**

        See {@link org.virtualbox_4_1.IAdditionsStateChangedEvent}.
      
*/
    OnAdditionsStateChanged(47),
/**

        See {@link org.virtualbox_4_1.INetworkAdapterChangedEvent}.
      
*/
    OnNetworkAdapterChanged(48),
/**

        See {@link org.virtualbox_4_1.ISerialPortChangedEvent}.
      
*/
    OnSerialPortChanged(49),
/**

        See {@link org.virtualbox_4_1.IParallelPortChangedEvent}.
      
*/
    OnParallelPortChanged(50),
/**

        See {@link org.virtualbox_4_1.IStorageControllerChangedEvent}.
      
*/
    OnStorageControllerChanged(51),
/**

        See {@link org.virtualbox_4_1.IMediumChangedEvent}.
      
*/
    OnMediumChanged(52),
/**

        See {@link org.virtualbox_4_1.IVRDEServerChangedEvent}.
      
*/
    OnVRDEServerChanged(53),
/**

        See {@link org.virtualbox_4_1.IUSBControllerChangedEvent}.
      
*/
    OnUSBControllerChanged(54),
/**

        See {@link org.virtualbox_4_1.IUSBDeviceStateChangedEvent}.
      
*/
    OnUSBDeviceStateChanged(55),
/**

        See {@link org.virtualbox_4_1.ISharedFolderChangedEvent}.
      
*/
    OnSharedFolderChanged(56),
/**

        See {@link org.virtualbox_4_1.IRuntimeErrorEvent}.
      
*/
    OnRuntimeError(57),
/**

        See {@link org.virtualbox_4_1.ICanShowWindowEvent}.
      
*/
    OnCanShowWindow(58),
/**

        See {@link org.virtualbox_4_1.IShowWindowEvent}.
      
*/
    OnShowWindow(59),
/**

        See {@link org.virtualbox_4_1.ICPUChangedEvent}.
      
*/
    OnCPUChanged(60),
/**

        See {@link org.virtualbox_4_1.IVRDEServerInfoChangedEvent}.
      
*/
    OnVRDEServerInfoChanged(61),
/**

        See {@link org.virtualbox_4_1.IEventSourceChangedEvent}.
      
*/
    OnEventSourceChanged(62),
/**

        See {@link org.virtualbox_4_1.ICPUExecutionCapChangedEvent}.
      
*/
    OnCPUExecutionCapChanged(63),
/**

        See {@link org.virtualbox_4_1.IGuestKeyboardEvent}.
      
*/
    OnGuestKeyboard(64),
/**

        See {@link org.virtualbox_4_1.IGuestMouseEvent}.
      
*/
    OnGuestMouse(65),
/**

        See {@link org.virtualbox_4_1.INATRedirectEvent}.
      
*/
    OnNATRedirect(66),
/**

        See {@link org.virtualbox_4_1.IHostPciDevicePlugEvent}.
      
*/
    OnHostPciDevicePlug(67),
/**

        See {@link org.virtualbox_4_1.IVBoxSVCAvailabilityChangedEvent}.
      
*/
    OnVBoxSVCAvailabilityChanged(68),
/**

        See {@link org.virtualbox_4_1.IBandwidthGroupChangedEvent}.
      
*/
    OnBandwidthGroupChanged(69),
/**

        See {@link org.virtualbox_4_1.IGuestMonitorChangedEvent}.
      
*/
    OnGuestMonitorChanged(70),
/**

        See {@link org.virtualbox_4_1.IStorageDeviceChangedEvent}.
      
*/
    OnStorageDeviceChanged(71),
/**

        Must be last event, used for iterations and structures relying on numerical event values.
      
*/
    Last(72);

    private final int value;

    VBoxEventType(int v) {
        value = v;
    }

    public int value() {
        return value;
    }

    public static VBoxEventType fromValue(long v) {
        for (VBoxEventType c: VBoxEventType.values()) {
            if (c.value == (int)v) {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static VBoxEventType fromValue(String v) {
        return valueOf(VBoxEventType.class, v);
    }
}

