/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_4_2;

import java.util.List;
import org.virtualbox_4_2.AccessMode;
import org.virtualbox_4_2.DeviceType;
import org.virtualbox_4_2.FirmwareType;
import org.virtualbox_4_2.Helper;
import org.virtualbox_4_2.Holder;
import org.virtualbox_4_2.IAppliance;
import org.virtualbox_4_2.IDHCPServer;
import org.virtualbox_4_2.IEventSource;
import org.virtualbox_4_2.IHost;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IMedium;
import org.virtualbox_4_2.IPerformanceCollector;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.ISharedFolder;
import org.virtualbox_4_2.ISystemProperties;
import org.virtualbox_4_2.IUnknown;
import org.virtualbox_4_2.MachineState;
import org.virtualbox_4_2.VBoxException;
import org.virtualbox_4_2.jaxws.IGuestOSType;
import org.virtualbox_4_2.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_4_2.jaxws.RuntimeFaultMsg;
import org.virtualbox_4_2.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IVirtualBox
extends IUnknown {
    public IVirtualBox(String string, VboxPortType vboxPortType) {
        super(string, vboxPortType);
    }

    public String getVersion() {
        try {
            String string = this.port.iVirtualBoxGetVersion(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public String getVersionNormalized() {
        try {
            String string = this.port.iVirtualBoxGetVersionNormalized(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Long getRevision() {
        try {
            Long l = this.port.iVirtualBoxGetRevision(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public String getPackageType() {
        try {
            String string = this.port.iVirtualBoxGetPackageType(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public String getAPIVersion() {
        try {
            String string = this.port.iVirtualBoxGetAPIVersion(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public String getHomeFolder() {
        try {
            String string = this.port.iVirtualBoxGetHomeFolder(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public String getSettingsFilePath() {
        try {
            String string = this.port.iVirtualBoxGetSettingsFilePath(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IHost getHost() {
        try {
            String string = this.port.iVirtualBoxGetHost(this.obj);
            return string.length() > 0 ? new IHost(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public ISystemProperties getSystemProperties() {
        try {
            String string = this.port.iVirtualBoxGetSystemProperties(this.obj);
            return string.length() > 0 ? new ISystemProperties(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IMachine> getMachines() {
        try {
            List<String> list = this.port.iVirtualBoxGetMachines(this.obj);
            return Helper.wrap(IMachine.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<String> getMachineGroups() {
        try {
            List<String> list = this.port.iVirtualBoxGetMachineGroups(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IMedium> getHardDisks() {
        try {
            List<String> list = this.port.iVirtualBoxGetHardDisks(this.obj);
            return Helper.wrap(IMedium.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IMedium> getDVDImages() {
        try {
            List<String> list = this.port.iVirtualBoxGetDVDImages(this.obj);
            return Helper.wrap(IMedium.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IMedium> getFloppyImages() {
        try {
            List<String> list = this.port.iVirtualBoxGetFloppyImages(this.obj);
            return Helper.wrap(IMedium.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IProgress> getProgressOperations() {
        try {
            List<String> list = this.port.iVirtualBoxGetProgressOperations(this.obj);
            return Helper.wrap(IProgress.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<org.virtualbox_4_2.IGuestOSType> getGuestOSTypes() {
        try {
            List<IGuestOSType> list = this.port.iVirtualBoxGetGuestOSTypes(this.obj);
            return Helper.wrap2(org.virtualbox_4_2.IGuestOSType.class, IGuestOSType.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<ISharedFolder> getSharedFolders() {
        try {
            List<org.virtualbox_4_2.jaxws.ISharedFolder> list = this.port.iVirtualBoxGetSharedFolders(this.obj);
            return Helper.wrap2(ISharedFolder.class, org.virtualbox_4_2.jaxws.ISharedFolder.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IPerformanceCollector getPerformanceCollector() {
        try {
            String string = this.port.iVirtualBoxGetPerformanceCollector(this.obj);
            return string.length() > 0 ? new IPerformanceCollector(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IDHCPServer> getDHCPServers() {
        try {
            List<String> list = this.port.iVirtualBoxGetDHCPServers(this.obj);
            return Helper.wrap(IDHCPServer.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IEventSource getEventSource() {
        try {
            String string = this.port.iVirtualBoxGetEventSource(this.obj);
            return string.length() > 0 ? new IEventSource(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<String> getInternalNetworks() {
        try {
            List<String> list = this.port.iVirtualBoxGetInternalNetworks(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<String> getGenericNetworkDrivers() {
        try {
            List<String> list = this.port.iVirtualBoxGetGenericNetworkDrivers(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public static IVirtualBox queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IVirtualBox(iUnknown.getWrapped(), iUnknown.getRemoteWSPort());
    }

    public String composeMachineFilename(String string, String string2, String string3, String string4) {
        try {
            String string5 = this.port.iVirtualBoxComposeMachineFilename(this.obj, string, string2, string3, string4);
            return string5;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IMachine createMachine(String string, String string2, List<String> list, String string3, String string4) {
        try {
            String string5 = this.port.iVirtualBoxCreateMachine(this.obj, string, string2, list, string3, string4);
            return string5.length() > 0 ? new IMachine(string5, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IMachine openMachine(String string) {
        try {
            String string2 = this.port.iVirtualBoxOpenMachine(this.obj, string);
            return string2.length() > 0 ? new IMachine(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void registerMachine(IMachine iMachine) {
        try {
            this.port.iVirtualBoxRegisterMachine(this.obj, iMachine == null ? null : iMachine.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IMachine findMachine(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindMachine(this.obj, string);
            return string2.length() > 0 ? new IMachine(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IMachine> getMachinesByGroups(List<String> list) {
        try {
            List<String> list2 = this.port.iVirtualBoxGetMachinesByGroups(this.obj, list);
            return Helper.wrap(IMachine.class, this.port, list2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<MachineState> getMachineStates(List<IMachine> list) {
        try {
            List<org.virtualbox_4_2.jaxws.MachineState> list2 = this.port.iVirtualBoxGetMachineStates(this.obj, Helper.unwrap(list));
            return Helper.convertEnums(org.virtualbox_4_2.jaxws.MachineState.class, MachineState.class, list2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IAppliance createAppliance() {
        try {
            String string = this.port.iVirtualBoxCreateAppliance(this.obj);
            return string.length() > 0 ? new IAppliance(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IMedium createHardDisk(String string, String string2) {
        try {
            String string3 = this.port.iVirtualBoxCreateHardDisk(this.obj, string, string2);
            return string3.length() > 0 ? new IMedium(string3, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IMedium openMedium(String string, DeviceType deviceType, AccessMode accessMode, Boolean bl) {
        try {
            String string2 = this.port.iVirtualBoxOpenMedium(this.obj, string, org.virtualbox_4_2.jaxws.DeviceType.fromValue(deviceType.name()), org.virtualbox_4_2.jaxws.AccessMode.fromValue(accessMode.name()), bl);
            return string2.length() > 0 ? new IMedium(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public org.virtualbox_4_2.IGuestOSType getGuestOSType(String string) {
        try {
            IGuestOSType iGuestOSType = this.port.iVirtualBoxGetGuestOSType(this.obj, string);
            return iGuestOSType != null ? new org.virtualbox_4_2.IGuestOSType(iGuestOSType, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void createSharedFolder(String string, String string2, Boolean bl, Boolean bl2) {
        try {
            this.port.iVirtualBoxCreateSharedFolder(this.obj, string, string2, bl, bl2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void removeSharedFolder(String string) {
        try {
            this.port.iVirtualBoxRemoveSharedFolder(this.obj, string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<String> getExtraDataKeys() {
        try {
            List<String> list = this.port.iVirtualBoxGetExtraDataKeys(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public String getExtraData(String string) {
        try {
            String string2 = this.port.iVirtualBoxGetExtraData(this.obj, string);
            return string2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void setExtraData(String string, String string2) {
        try {
            this.port.iVirtualBoxSetExtraData(this.obj, string, string2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void setSettingsSecret(String string) {
        try {
            this.port.iVirtualBoxSetSettingsSecret(this.obj, string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IDHCPServer createDHCPServer(String string) {
        try {
            String string2 = this.port.iVirtualBoxCreateDHCPServer(this.obj, string);
            return string2.length() > 0 ? new IDHCPServer(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IDHCPServer findDHCPServerByNetworkName(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindDHCPServerByNetworkName(this.obj, string);
            return string2.length() > 0 ? new IDHCPServer(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void removeDHCPServer(IDHCPServer iDHCPServer) {
        try {
            this.port.iVirtualBoxRemoveDHCPServer(this.obj, iDHCPServer == null ? null : iDHCPServer.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Boolean checkFirmwarePresent(FirmwareType firmwareType, String string, Holder<String> holder, Holder<String> holder2) {
        try {
            javax.xml.ws.Holder holder3 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder4 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder5 = new javax.xml.ws.Holder();
            this.port.iVirtualBoxCheckFirmwarePresent(this.obj, org.virtualbox_4_2.jaxws.FirmwareType.fromValue(firmwareType.name()), string, (javax.xml.ws.Holder<String>)holder3, (javax.xml.ws.Holder<String>)holder4, (javax.xml.ws.Holder<Boolean>)holder5);
            holder.value = holder3.value;
            holder2.value = holder4.value;
            return (Boolean)holder5.value;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }
}

