#!/usr/bin/perl

# This script takes as STDIN an output from the Registry
# (export from regedit.exe) and prefixes every subkey-value
# pair by their hkey,key data member
#
# Copyright 1999 Sylvain St-Germain
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

${prefix} = "";

LINE: while(<>) {
  chomp;
  s/\r$//;                    # Get rid of 0x0a

  next LINE if(/^\s*$/);      # This is an empty line
  next LINE if(/^\s*;/);      # This is a comment (no way to diff it)

  if( /^\[/ ) {
    ${prefix} = ${_};         # assign the prefix for the forthcoming section
    ${prefix} =~ s/\s+\d+$//; # get rid of timestamp
    print "${prefix}\n";
    next LINE;
  }

  print "${prefix}$_\n";
}
