.\" -*- nroff -*-
.TH WINEMAKER 1 "September 27, 2001" "Version 0.5.8" "Windows On Unix"
.SH NAME
winemaker \- generate a build infrastructure for compiling Windows programs on Unix
.SH SYNOPSIS
.B "winemaker "
[
.IR               "--nobanner " "] [ " "--backup " "| " "--nobackup " "] [ "--nosource-fix "
]
.br
  [
.IR               "--lower-none " "| " "--lower-all " "| " "--lower-uppercase "
]
.br
  [
.IR               "--lower-include " "| " "--nolower-include "
]
.br
  [
.IR               "--guiexe " "| " "--windows " "| " "--cuiexe " "| " "--console " "| " "--dll " "| " "--nodlls "
]
.br
  [
.IR               "--wrap " "| " "--nowrap " "] [ " "--mfc " "| " "--nomfc "
]
.br
  [
.IR               "-Dmacro[=defn] " "] [ " "-Idir " "] [ " "-Ldir " "] [ " "-idll" "] [ " "-llibrary "
]
.br
  [
.IR               "--interactive " "] [ " "--single-target name "
]
.br
  [
.IR               "--generated-files " "] [ " "--nogenerated-files " "] [ " "--nogenerated-specs "
]

.SH DESCRIPTION
.PP
.B winemaker
is a perl script designed to help you bootstrap the
process of converting your Windows sources to Winelib programs.
.PP
In order to do this winemaker can perform the following operations:
.PP
- rename your source files and directories to lowercase in the event they
got all uppercased during the transfer.
.PP
- perform Dos to Unix (CRLF to LF) conversions.
.PP
- scan the include statements and resource file references to replace the
backslashes with forward slashes.
.PP
- during the above step winemaker will also perform a case insensitive search
of the referenced file in the include path and rewrite the include statement
with the right case if necessary.
.PP
- winemaker will also check other more exotic issues like '#pragma pack'
usage, use of "afxres.h" in non MFC projects, and more. Whenever it
encounters something out of the ordinary, winemaker will warn you about it.
.PP
- winemaker can also scan a complete directory tree at once, guess what are
the executables and libraries you are trying to build, match them with
source files, and generate the corresponding Makefile.in files.
.PP
- finally winemaker will generate a global Makefile.in file calling out to all
the others, and a configure script customized for use with Winelib.
.PP
- winemaker knows about MFC-based project and will generate customized files.
.PP
.SH OPTIONS
.TP
.I --nobanner
Disables the printing of the banner.
.TP
.I --backup
Directs winemaker to perform a backup of all the source files in which it
makes changes. This is the default.
.TP
.I --nobackup
Tells winemaker not to backup modified source files.
.TP
.I --nosource-fix
Directs winemaker not to try fixing the source files (e.g. Dos to Unix
conversion). This prevents complaints if the files are readonly.
.TP
.I --lower-all
Tells winemaker to rename all files and directories to lowercase.
.TP
.I --lower-uppercase
Tells winemaker to only rename files and directories that have an all
uppercase name.
So "HELLO.C" would be renamed but not "World.c".
.TP
.I --lower-none
Tells winemaker not to rename files and directories to lower case. Note
that this does not prevent the renaming of a file if its extension cannot
be handled as is, e.g. ".Cxx". This is the default.
.TP
.I "--lower-include "
Tells winemaker that if it does not find the file corresponding to an
include statement (or other form of file reference for resource files),
then it should convert that filename to lowercase. This is the default.
.TP
.I "--nolower-include "
Tells winemaker not to modify the include statement if it cannot find the
referenced file.
.TP
.IR "--guiexe " "| " "--windows"
Specifies that whenever winemaker finds an executable target, or a target of
unknown type, it should assume that it is a graphical application.
This is the default.
.TP
.IR "--cuiexe " "| " "--console"
Specifies that whenever winemaker finds an executable target, or a target of
unknown type, it should assume that it is a console application.
.TP
.I --dll
This option tells winemaker that whenever it finds a target of unknown type,
i.e. for which it does not know whether it is an executable or a library,
it should assume it is a library.
.TP
.I --nodlls
This option tells winemaker not to use the standard set of winelib libraries
for imports. That is, any DLL your code uses must be explicitly passed to
winemaker with -i options.
The standard set of libraries is: advapi32.dll, comdlg32.dll, gdi32.dll,
kernel32.dll, odbc32.dll, ole32.dll, oleaut32.dll, shell32.dll, user32.dll,
winspool.drv.
.TP
.I --wrap
Specifies that executable targets should be built as libraries and a small
executable wrapper generated for them. This technique is sometimes required
to solve initialization problems occurring on the application startup.
.TP
.I --nowrap
Specifies that no wrapper should be generated for executable targets. This is
the default.
.TP
.I --mfc
Specifies that the targets are MFC based. In such a case winemaker generates a
configure script with MFC specific options, modifies the include and
library paths accordingly, links the target with the MFC library and
generates wrappers for these targets that are executables.
.TP
.I --nomfc
Specifies that targets are not MFC-based. This option disables use of MFC libraries
even if winemaker encounters files "stdafx.cpp" or "stdafx.h" that would cause it
to enable MFC automatically if neither --nomfc nor --mfc was specified.
.TP
.I -Dmacro[=defn]
Adds the specified macro definition to the global list of macro definitions.
.TP
.I -Idir
Appends the specified directory to the global include path.
.TP
.I -Ldir
Appends the specified directory to the global library path.
.TP
.I -idll
Adds the Winelib library to the global list of Winelib libraries to import.
.TP
.I -llibrary
Adds the specified library to the global list of libraries to link with.
.TP
.I --interactive
Puts winemaker in interactive mode. In this mode winemaker will ask you to
confirm each directory's list of targets, and then to provide directory and
target specific options.
.TP
.I --single-target name
Specifies that there is only one target, and that it is called "name".
.TP
.I --generated-files
Tells winemaker to generate the build infrastructure files, i.e. the spec
files, the wrapper files, the Makefile.in files, the Make.rules.in file, the
configure.in file and the configure script. This is the default.
.TP
.I --nogenerated-files
Tells winemaker not to generate any of the above files.
.TP
.I --nogenerated-specs
Tells winemaker not to generate the spec files when generating files.  This is
particularly useful when using winemaker to generate a build environment and
you already have a spec file.

.SH EXAMPLES
.PP
Here is a typical winemaker use:
.PP
$ winemaker --lower-uppercase -DSTRICT
.PP
The above tells winemaker to scan the current directory and its
subdirectories for source files. Whenever if finds a file or directory which
name is all uppercase, it should rename it to lowercase. It should then fix
all these source files for compilation with Winelib and generate Makefiles.
The '-DSTRICT' specifies that the STRICT macro must be set when compiling
these sources. Finally winemaker will create a global Makefile.in and
configure.in, and run autoconf to generate the configure script.
.PP
The next step would be:
.PP
$ ./configure --with-wine=/usr/local/opt/wine
.PP
This generates the makefiles from the Makefile.in files. The generated
makefiles will fetch the Winelib headers and libraries from the Wine
installation located in /usr/local/opt/wine.
.PP
And finally:
.PP
$ make
.PP
If at this point you get compilation errors (which is quite likely for a
reasonably sized project) then you should consult the Winelib User Guide to
find tips on how to resolve them.
.PP
For an MFC-based project one would have run the following commands instead:
.PP
$ winemaker --lower-uppercase --mfc
.br
$ ./configure --with-wine=/usr/local/opt/wine \\
.br
              --with-mfc=/usr/local/opt/mfc
.br
$ make
.PP

.SH TODO / BUGS
.PP
Winemaker should support the Visual Studio project files (.dsp for newer
versions and .mak for some older versions). This would allow it to be much
more accurate, especially for the macro, include and library path
settings.
.PP
Assuming that the windows executable/library is available, we could
use a pedump-like tool to determine what kind of executable it is (graphical
or console), which libraries it is linked with, and which functions it
exports (for libraries). We could then restore all these settings for the
corresponding Winelib target. The problem is that we should have such a tool
available under the Wine license first.
.PP
The wrapper code should be generic, i.e. you should be able to have just one
wrapper and specify which library to load using an option.
.PP
Furthermore it is not very good at finding the library containing the
executable: it must either be in the current directory or in the
.IR LD_LIBRARY_PATH .
.PP
Winemaker does not support message files and the message compiler yet.
.PP

.SH SEE ALSO
.PP
The Winelib User Guide:
.PP
http://wine.codeweavers.com/docs/winelib-user/
.PP
.BR wine (1)
.PP

.SH AUTHOR
Francois Gouget <fgouget@codeweavers.com> for CodeWeavers
