.TH WINEDUMP 1 "February 2004" "Wine Manpage" "Wine Developers Manual"
.SH NAME
winedump \- A Wine DLL tool
.SH SYNOPSIS
.BR "winedump " [ "-h " "| "
.BI "sym " "<sym> "
|
.BI "spec " "<dll> "
|
.BI "dump " "<dll>"
.RI "] [" "mode_options" ]
.SH DESCRIPTION
.B winedump
is a Wine tool which aims to help:
.nf
A: Reimplementing a Win32 DLL for use within Wine, or
.nf
B: Compiling a Win32 application with Winelib that uses x86 DLLs
.PP
For both tasks in order to be able to link to the Win functions some
glue code is needed.  This 'glue' comes in the form of a \fI.spec\fR file.
The \fI.spec\fR file, along with some dummy code, is used to create a
Wine .so corresponding to the Windows DLL.  The \fBwinebuild\fR program
can then resolve calls made to DLL functions.
.PP
Creating a \fI.spec\fR file is a labour intensive task during which it is
easy to make a mistake. The idea of \fBwinedump\fR is to automate this task
and create the majority of the support code needed for your DLL. In
addition you can have \fBwinedump\fR create code to help you reimplement a
DLL, by providing tracing of calls to the DLL, and (in some cases)
automatically determining the parameters, calling conventions, and
return values of the DLLs functions.
.PP
\fBwinedump\fR can be also used to dump other information from PE files
or to demangle C++ symbols.
.SH MODES
.B winedump
can be used in several different modes.  The first argument to the
program determines the mode winedump will run in.
.IP \fB-h\fR
Help mode.
Basic usage help is printed.
.IP \fBdump\fR
To dump the contents of a PE file.
.IP \fBspec\fR
For generating .spec files and stub DLL's.
.IP \fBsym\fR
Symbol mode.
Used to demangle C++ symbols.
.SH OPTIONS
Mode options depend on the mode given as the first argument.
.PP
.B Help mode:
.nf
No options are used.
The program prints the help info and than exits.
.PP
.B Dump mode:
.IP \fI<dll>\fR
Dumps the content of the dll named \fI<dll>\fR.
.IP \fB-C\fR
Turns on symbol demangling.
.IP \fB-f\fR
Dumps file header information.
This option dumps only the standard PE header structures,
along with the COFF sections available in the file.
.IP "\fB-j \fIsect_name\fR"
Dumps only the content of section sect_name (import,
export, debug).
To dump only a given directory, specify them using this
option. Currently only the import, export and debug
directories are implemented.
.IP \fB-x\fR
Dumps everything.
.PP
.B Spec mode:
.IP \fI<dll>\fR
Use dll for input file and generate implementation code.
.IP "\fB-I \fIdir\fR"
Look for prototypes in '\fIdir\fR' (implies \fB-c\fR). In the case of
Windows DLLs, this could be either the standard include
directory from your compiler, or a SDK include directory.
If you have a text document with prototypes (such as
documentation) that can be used also, however you may need
to delete some non-code lines to ensure that prototypes are
parsed correctly.
The '\fIdir\fR' argument can also be a file specification (e.g.
"include/*"). If it contains wildcards you must quote it to
prevent the shell from expanding it.
If you have no prototypes, specify /dev/null for '\fIdir\fR'.
Winedump may still be able to generate some working stub
code for you.
.IP \fB-c\fR
Generate skeleton code (requires \fB-I\fR).
This option tells winedump to create function stubs for each
function in the DLL. As winedump reads each exported symbol
from the source DLL, it first tries to demangle the name. If
the name is a C++ symbol, the arguments, class and return
value are all encoded into the symbol name. Winedump
converts this information into a C function prototype. If
this fails, the file(s) specified in the \fB-I\fR argument are
scanned for a function prototype. If one is found it is used
for the next step of the process, code generation.
.IP \fB-t\fR
TRACE arguments (implies \fB-c\fR).
This option produces the same code as \fB-c\fR, except that
arguments are printed out when the function is called.
.IP "\fB-f \fIdll\fR"
Forward calls to '\fIdll\fR' (implies \fB-t\fR).
This is the most complicated level of code generation. The
same code is generated as \fB-t\fR, however support is added for
forwarding calls to another DLL. The DLL to forward to is
given as '\fIdll\fR'.
.IP \fB-D\fR
Generate documentation.
By default, winedump generates a standard comment at the
header of each function it generates. Passing this option
makes winedump output a full header template for standard
Wine documentation, listing the parameters and return value
of the function.
.IP "\fB-o \fIname\fR"
Set the output dll name (default: \fIdll\fR).
By default, if winedump is run on DLL 'foo', it creates
files 'foo.spec', 'foo_main.c' etc, and prefixes any
functions generated with 'FOO_'.  If '-o bar' is given,
these will become 'bar.spec', 'bar_main.c' and 'BAR_'
respectively.
.IP \fB-C\fR
Assume __cdecl calls (default: __stdcall).
If winebuild cannot determine the calling convention,
__stdcall is used by default, unless this option has
been given.
Unless \fB-q\fR is given, a warning will be printed for every
function that winedump determines the calling convention
for and which does not match the assumed calling convention.
.IP "\fB-s \fInum\fR"
Start prototype search after symbol '\fInum\fR'.
.IP "\fB-e \fInum\fR"
End prototype search after symbol '\fInum\fR'.
By passing the \fB-s\fR or \fB-e\fR options you can have winedump try to
generate code for only some functions in your DLL. This may
be used to generate a single function, for example, if you
wanted to add functionality to an existing DLL.
.IP "\fB-S \fIsymfile\fR"
Search only prototype names found in '\fIsymfile\fR'.
If you want to only generate code for a subset of exported
functions from your source DLL, you can use this option to
provide a text file containing the names of the symbols to
extract, one per line. Only the symbols present in this file
will be used in your output DLL.
.IP \fB-q\fR
Don't show progress (quiet).
No output is printed unless a fatal error is encountered.
.IP \fB-v\fR
Show lots of detail while working (verbose).
.PP
.B Sym mode:
.IP \fI<sym>\fR
Demangles C++ symbol '\fI<sym>\fR' and then exits.
.SH FILES
.I function_grep.pl
.RS
Perl script used to retrieve a function prototype.
.RE
.PP
Files output in
.B spec mode
for
.I foo.dll:
.nf
.I foo.spec
.RS
This is the .spec file.
.RE
.I foo_dll.h
.nf
.I foo_main.c
.RS
These are the source code files containing the minimum set
of code to build a stub DLL. The C file contains one
function, FOO_Init, which does nothing (but must be
present).
.RE
.I Makefile.in
.RS
This is a template for 'configure' to produce a makefile. It
is designed for a DLL that will be inserted into the Wine
source tree.
.RE
.I foo_install
.RS
A shell script for adding
.I foo
to the Wine source tree.
.SH BUGS
C++ name demangling is currently under development. Since the
algorithm used is not documented, it must be decoded. Many simple
prototypes are already working however.
.SH AUTHORS
Jon P. Griffiths <jon_p_griffiths at yahoo dot com>
.nf
Michael Stefaniuc <mstefani at redhat dot com>
.SH "SEE ALSO"
.BR winedump "'s README file"
.nf
The Winelib User Guide
.nf
The Wine Developers Guide
