.TH XvGetPortAttribute 3X __vendorversion__
.\" $XFree86: xc/doc/man/Xv/XvGetPortAttribute.man,v 1.6 2001/01/27 18:20:35 dawes Exp $
.SH Name
XvGetPortAttribute \- return current port attribute value
.\"
.SH Syntax
.B #include <X11/extensions/Xvlib.h>
.sp 1l
.B XvGetPortAttribute(\fIdpy, port, attribute, p_value\fR)
.sp 1l
\fBDisplay \fI*dpy\fR;
.br
\fBXvPortID \fIport\fR;
.br
\fBAtom \fIattribute\fR;
.br
\fBint \fI*p_value\fR;
.sp 1l
.\"
.SH Arguments
.\"
.IP \fIdpy\fR 8
Specifies the display screen on which the
X Server is to accept requests from X clients.  If the
display option is not specified, X uses the display screen
specified by your DISPLAY environment variable.  The display
option has the format hostname:number.  Using two colons
(::) instead of one (:) indicates that DECnet is to be used
for transport.
.IP \fIport\fR 8
Specifies the port, associated with the given display, for
which the attribute values are to be returned. 
.IP \fIattribute\fR 8
An atom that identifies the attribute to be queried by this
request.  Control atoms are obtained using the XInternAtom
request with a string from the following table.
.IP \fIp_value\fR 8
Pointer to the location where the attribute value is written on
return.
.\"
.SH Description
.\"
.PP
XvGetPortAttribute(3X) returns the current value of the requested
port attribute in the integer pointed to by \fIp_value\fR.  
The attribute is identified using an Atom that equates to the attribute name.  
The XInternAtom request can be used with one of the strings
below to return a matching Atom.
.bp
.PP
.\" .TS
.\" tab(@);
.\" lfHB lfHB lfHB
.\" lfR  lfR  lfR .
.\" _
.\" .PP
.\" .sp 4p
.\" Attribute String@Type@Default
.\" .sp 6p
.\" _
.\" .sp 6p
.\" "XV_ENCODING"@XvEncodingID@Server dependent
.\" "XV_HUE"@[-1000...1000]@0
.\" "XV_SATURATION"@[-1000...1000]@0
.\" "XV_BRIGHTNESS"@[-1000...1000]@0
.\" "XV_CONTRAST"@[-1000...1000]@0
.\" .sp 6p
.\" .TE
.nf
Attribute String        Type             Default

"XV_ENCODING"           XvEncodingID     Server dependent
"XV_HUE"                [-1000...1000]   0
"XV_SATURATION"         [-1000...1000]   0
"XV_BRIGHTNESS"         [-1000...1000]   0
"XV_CONTRAST"           [-1000...1000]   0
.fi
.SH Returned Values
.IP [Success] 8
Returned if XvGetPortAttribute(3X) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if XvGetPortAttribute(3X) failed to allocate memory to process
the request.
.SH Diagnostics
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.IP [BadMatch] 8
Generated if the requested attribute atom does not specify an attribute 
supported by the adaptor.
.SH See Also
.\"
XvSetPortAttribute(3X), XvPortNotify(3X)
.br




