/* $Xorg: tests.c,v 1.4 2001/02/09 02:05:48 xorgcvs Exp $ */

/**** module tests.c ****/
/******************************************************************************

Copyright 1993, 1994, 1998  The Open Group

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.


				NOTICE
                              
This software is being provided by AGE Logic, Inc. under the
following license.  By obtaining, using and/or copying this software,
you agree that you have read, understood, and will comply with these
terms and conditions:

     Permission to use, copy, modify, distribute and sell this
     software and its documentation for any purpose and without
     fee or royalty and to grant others any or all rights granted
     herein is hereby granted, provided that you agree to comply
     with the following copyright notice and statements, including
     the disclaimer, and that the same appears on all copies and
     derivative works of the software and documentation you make.
     
     "Copyright 1993, 1994 by AGE Logic, Inc."
     
     THIS SOFTWARE IS PROVIDED "AS IS".  AGE LOGIC MAKES NO
     REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.  By way of
     example, but not limitation, AGE LOGIC MAKE NO
     REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS
     FOR ANY PARTICULAR PURPOSE OR THAT THE SOFTWARE DOES NOT
     INFRINGE THIRD-PARTY PROPRIETARY RIGHTS.  AGE LOGIC 
     SHALL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE.  IN NO
     EVENT SHALL EITHER PARTY BE LIABLE FOR ANY INDIRECT,
     INCIDENTAL, SPECIAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS
     OF PROFITS, REVENUE, DATA OR USE, INCURRED BY EITHER PARTY OR
     ANY THIRD PARTY, WHETHER IN AN ACTION IN CONTRACT OR TORT OR
     BASED ON A WARRANTY, EVEN IF AGE LOGIC LICENSEES
     HEREUNDER HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
     DAMAGES.
    
     The name of AGE Logic, Inc. may not be used in
     advertising or publicity pertaining to this software without
     specific, written prior permission from AGE Logic.

     Title to this software shall at all times remain with AGE
     Logic, Inc.
*****************************************************************************
  
	tests.c -- test configuration

	Syd Logan -- AGE Logic, Inc.
  
*****************************************************************************/
/* $XFree86: xc/programs/xieperf/tests.c,v 1.5 2001/12/14 20:01:52 dawes Exp $ */

#include <stdio.h> 	/* for stderr */
#include "xieperf.h"


static XIEimage ImageInfo[] = { 
	{ "image.001", 0, xieValSingleBand, { 512, 0, 0 }, 
	  { 512, 0, 0 }, { 8, 0, 0 }, { 256, 0, 0 },
	  xieValDecodeUncompressedSingle, 
          xieValLSFirst, xieValLSFirst, { 8, 0, 0 }, { 4, 0, 0 },
	  { 0, 0, 0 },  0, 0, 0, ( char * ) NULL },
	{ "image.002", 0, xieValSingleBand, { 512, 0, 0 },
	  { 512, 0, 0 }, { 8, 0, 0 }, { 256, 0, 0 },
	  xieValDecodeUncompressedSingle, 
	  xieValLSFirst, xieValLSFirst, { 8, 0, 0 }, { 4, 0, 0 },
	  { 0, 0, 0 }, 0, 0, 0, ( char * ) NULL }, 
	{ "image.003", 0, xieValSingleBand, { 512, 0, 0 },
	  { 512, 0, 0 }, { 8, 0, 0 }, { 256, 0, 0 },
	  xieValDecodeUncompressedSingle, 
	  xieValLSFirst, xieValLSFirst, { 8, 0, 0 }, { 4, 0, 0 },
          { 0, 0, 0 }, 0, 0, 0, ( char * ) NULL }, 
	{ "image.004", 0, xieValTripleBand, { 336, 336, 336 },
          { 270, 270, 270 }, { 8, 8, 8 }, { 256, 256, 256 },
          xieValDecodeUncompressedTriple, 
	  xieValLSFirst, xieValLSFirst, { 24, 24, 24 }, { 0, 0, 0 },
	  { 0, 0, 0 }, xieValBandByPixel, 0, 0, ( char * ) NULL }, 
	{ "image.005", 0, xieValSingleBand, { 2560, 0, 0 }, 
	  { 3300, 0, 0 }, { 1, 0, 0 }, { 2, 0, 0 }, xieValDecodeG42D, 
	  xieValLSFirst, xieValLSFirst, { 8, 0, 0 }, { 4, 0, 0 },
	  { 0, 0, 0 }, 0, 0, 0, ( char * ) NULL },
	{ "image.006", 0, xieValSingleBand, { 512, 0, 0 }, { 512, 0, 0 },
	  { 8, 0, 0 }, { 256, 0, 0 }, xieValDecodeUncompressedSingle, 
	  xieValLSFirst, xieValLSFirst, { 8, 0, 0 }, { 4, 0, 0 },
	  { 0, 0, 0 }, 0, 0, 0, ( char * ) NULL }, 
	{ "image.007", 0, xieValSingleBand, { 1728, 0, 0 }, { 2180, 0, 0 },
	  { 1, 0, 0 }, { 2, 0, 0 }, xieValDecodeG32D, 
	  xieValMSFirst, xieValLSFirst, { 1, 0, 0 }, { 0, 0, 0 },
	  { 0, 0, 0 }, 0, 0, 0, ( char * ) NULL }, 
	{ "image.008", 0, xieValSingleBand, { 1728, 0, 0 },
	  { 2180, 0, 0 }, { 1, 0, 0 }, { 2, 0, 0 },
	  xieValDecodeG31D, xieValMSFirst, xieValLSFirst, 
	  { 1, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 },
	  0, 0, 0, ( char * ) NULL }, 
	{ "image.009", 0, xieValSingleBand, { 1728, 0, 0 }, { 2180, 0, 0 },
	  { 1, 0, 0 }, { 2, 0, 0 }, xieValDecodeTIFFPackBits, 
	  xieValMSFirst, xieValLSFirst, { 1, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 },
	  0, 0, 0, ( char * ) NULL }, 
	{ "image.010", 0, xieValSingleBand, { 1728, 0, 0 }, { 2180, 0, 0 },
	  { 1, 0, 0 }, { 2, 0, 0 }, xieValDecodeTIFF2, 
	  xieValMSFirst, xieValLSFirst, { 1, 0, 0 }, { 0, 0, 0 },
	  { 0, 0, 0 }, 0, 0, 0, ( char * ) NULL }, 
	{ "image.011", 0, xieValTripleBand, { 270, 270, 270 }, 
	  { 450, 450, 450 }, { 8, 8, 8 }, { 256, 256, 256 },
	  xieValDecodeUncompressedTriple, xieValLSFirst, xieValLSFirst, 
	  { 24, 24, 24 }, { 0, 0, 0 }, { 0, 0, 0 },
	  xieValBandByPixel, xieValLSFirst, 0, ( char * ) NULL }, 
	{ "image.012", 0, xieValTripleBand, { 512, 512, 512 },
	  { 512, 512, 512 }, { 8, 8, 8 }, { 256, 256, 256 },
	  xieValDecodeUncompressedTriple, xieValLSFirst, xieValLSFirst, 
          { 8, 8, 8 }, { 0, 0, 0 }, { 0, 0, 0 },
	  xieValBandByPlane, xieValLSFirst, 0, ( char * ) NULL }, 
	{ "image.013", 0, xieValSingleBand, { 512, 0, 0 },
	  { 512, 0, 0 }, { 8, 0, 0 }, { 256, 0, 0 },
	  xieValDecodeUncompressedSingle, 
	  xieValLSFirst, xieValLSFirst, { 8, 0, 0 }, { 4, 0, 0 },
	  { 0, 0, 0 }, 0, 0, 0, ( char * ) NULL }, 
	{ "image.014", 0, xieValSingleBand, { 1728, 0, 0 },
	  { 2180, 0, 0 }, { 1, 0, 0 }, { 2, 0, 0 },
	  xieValDecodeG32D, xieValMSFirst, xieValLSFirst, 
	  { 1, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 },
	  0, 0, 0, ( char * ) NULL }, 
};

XIEimage *
GetImageStruct( which )
int	which;
{
	int	size;

	size = sizeof( ImageInfo ) / sizeof( XIEimage );
	if ( which > size || which <= 0 )
	{
		fprintf( stderr, "GetImageData: invalid ``which''\n" );
		fflush( stderr );
		return( ( XIEimage * ) NULL );
	}
	else
	{
		return( &ImageInfo[ which - 1 ] ); 
	}
}

void
ReclaimPhotomapMemory()
{
	int	i;

	for ( i = 0; i < sizeof( ImageInfo ) / sizeof( XIEimage ); i++ )
		if ( ImageInfo[ i ].data != ( char * ) NULL )
		{
			free( ImageInfo[ i ].data );
			ImageInfo[ i ].data = ( char * ) NULL;
		}
}

static MatchHistogramParms MatchHistogramParmVec[] = 
					{
/* tech, mean, sigma, constant, shape_factor, followed by ROI stuff */
	{ xieValHistogramFlat, 0.0, 0.0, 0.0, True, DomainNone, 0, 0, 0, 0 },
	{ xieValHistogramGaussian, 63.0, 32.0, 0.0, True, DomainNone, 0, 0, 0, 0 },
	{ xieValHistogramGaussian, 128.0, 64.0, 0.0, True, DomainNone, 0, 0, 0, 0 },
	{ xieValHistogramGaussian, 192.0, 32.0, 0.0, True, DomainNone, 0, 0, 0, 0 },
	{ xieValHistogramHyperbolic, 0.0, 0.0, 64.0, True, DomainNone, 0, 0, 0, 0 },
	{ xieValHistogramHyperbolic, 0.0, 0.0, 64.0, False, DomainNone, 0, 0, 0, 0 },
	{ xieValHistogramFlat, 0.0, 0.0, 0.0, True, DomainROI, 50, 50, 150, 150 },
	{ xieValHistogramGaussian, 63.0, 32.0, 0.0, True, DomainROI, 50, 50, 150, 150 },
	{ xieValHistogramGaussian, 128.0, 64.0, 0.0, True, DomainROI, 50, 50, 150, 150 },
	{ xieValHistogramGaussian, 192.0, 32.0, 0.0, True, DomainROI, 50, 50, 150, 150 },
	{ xieValHistogramHyperbolic, 0.0, 0.0, 64.0, True, DomainROI, 50, 50, 150, 150 },
	{ xieValHistogramHyperbolic, 0.0, 0.0, 64.0, False, DomainROI, 50, 50, 150, 150 },
	{ xieValHistogramFlat, 0.0, 0.0, 0.0, True, DomainCtlPlane, 0, 0, 0, 0 },
	{ xieValHistogramGaussian, 63.0, 32.0, 0.0, True, DomainCtlPlane, 0, 0, 0, 0 },
	{ xieValHistogramGaussian, 128.0, 64.0, 0.0, True, DomainCtlPlane, 0, 0, 0, 0 },
	{ xieValHistogramGaussian, 192.0, 32.0, 0.0, True, DomainCtlPlane, 0, 0, 0, 0 },
	{ xieValHistogramHyperbolic, 0.0, 0.0, 64.0, True, DomainCtlPlane, 0, 0, 0, 0 },
	{ xieValHistogramHyperbolic, 0.0, 0.0, 64.0, False, DomainCtlPlane, 0, 0, 0, 0 },
					};

static RedefineParms RedefineParmVec[] = { 
				     { { 0.0, 0.0, 0.0 }, 7, GXor, GXnor } 
				         };

static ModifyParms ModifyParmVec[] = { 
				     { { 0.0, 0.0, 0.0 }, 7, GXinvert } 
				     };

static CvtToIndexParms CvtToIndexParmVec[] = { 
		     { xieValDitherDefault, True, False, False }, 
		     { xieValDitherDefault, True, False, True } 
				             };

static ImportClParms ImportClParmVec[] = {
				     { 10 }, 
				     { 100 }
 					 };

static ErrorParms ErrorParmVec[] = {
		{ xieErrNoLUT },
		{ xieErrNoPhotoflo },
		{ xieErrNoFloLUT },
		{ xieErrNoPhotomap },
		{ xieErrNoROI },
		{ xieErrNoColorList },
		{ xieErrNoPhotospace },
		{ xieErrNoFloAccess },
		{ BadAccess },
		{ BadAlloc },
		{ BadIDChoice },
		{ BadValue },
		{ xieErrNoFloROI },
		{ xieErrNoFloID },
		{ xieErrNoFloOperator },
		{ xieErrNoFloSource },
		{ xieErrNoFloPhotomap },
		{ xieErrNoFloDrawable },
		{ xieErrNoFloGC },
		{ xieErrNoFloElement },
		{ xieErrNoFloColorList },
		{ xieErrNoFloDomain },
		{ xieErrNoFloColormap },
		{ xieErrNoFloMatch },
		{ xieErrNoFloTechnique },
		{ xieErrNoFloValue },
	 };

static EventParms EventParmVec[] = {
		{ xieEvnNoColorAlloc },
		{ xieEvnNoDecodeNotify },
		{ xieEvnNoImportObscured },
		{ xieEvnNoPhotofloDone },
		{ xieEvnNoExportAvailable }
	 };

static ExportClParms ExportClParmVec[] = {
	     { 10, DomainNone, 0, 0, 0, 0 }, 
	     { 100, DomainNone, 0, 0, 0, 0 },
	     { 0, DomainROI, 50, 50, 100, 100 },
	     { 0, DomainCtlPlane, 0, 0, 0, 0 },
 	 };

#define GAMUT_NULL	(XieGamutTechnique)NULL
#define WHITE_NONE 	(XieWhiteAdjustTechnique)xieValWhiteAdjustNone
#define WHITE_DEFAULT 	(XieWhiteAdjustTechnique)xieValWhiteAdjustDefault
#define WHITE_LAB 	(XieWhiteAdjustTechnique)xieValWhiteAdjustCIELabShift
#define LUMA_CCIR601_1  { 0.299 , 0.587 , 0.114  }
#define LUMA_CCIR709    { 0.2125, 0.7154, 0.0721 }
#define LUMA_IGNORE	{ 0.0   , 0.0   , 0.0    }
#define LUMA_ONES	{ 1.0   , 1.0   , 1.0    }
#define WP_IGNORE	{ 0.0   , 0.0   , 0.0    }
#define WP_BUNCH	{ 0.8   , 0.9   , 1.2    }
#define BIAS_NONE	{ 0.0	, 0.0	, 0.0	 }
#define BIAS_SANE	{ 0.0	, 127.0	, 127.0	 }
#define BIAS_CRAZY	{ 0.0	, 31.0	, 7.0	 }
#define LEVEL_SANE	{ 256, 256, 256 }
#define LEVEL_CRAZY	{ 1024, 64, 16 }
#define YCC_SCALE1	1.402
#define YCC_SCALE2	1.3584
#define MAT_IGNORE     	{ 0.0,		0.0,		0.0, \
	 		  0.0,		0.0,		0.0, \
	 		  0.0,		0.0,		0.0 }
#define MAT_TOXYZ     	{ 0.49, 	0.31,		0.20, \
	 		  0.177,	0.813,		0.011, \
	 		  0.0,		0.010,		0.99 }
#define MAT_TORGB 	{ 2.364022,	-0.896193,	-0.467304, \
			 -0.514743,	 1.426476,	 0.088548, \
			  0.005399,	-0.014571,	 1.009324 }
	  
static RGBParms RGBParmVec[] = {
{ xieValCIELabToRGB, RGB_FF,
		MAT_TOXYZ, MAT_TORGB, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_SANE, LUMA_IGNORE, BIAS_NONE, YCC_SCALE1 },

{ xieValCIELabToRGB, RGB_FF,
		MAT_TOXYZ, MAT_TORGB, WHITE_LAB, WP_BUNCH, xieValGamutNone,
		LEVEL_SANE, LUMA_IGNORE, BIAS_NONE, YCC_SCALE1 },

{ xieValCIELabToRGB, RGB_IF,
		MAT_TOXYZ, MAT_TORGB, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_SANE, LUMA_IGNORE, BIAS_NONE, YCC_SCALE1 },

{ xieValCIELabToRGB, RGB_IF,
		MAT_TOXYZ, MAT_TORGB, WHITE_LAB, WP_BUNCH, xieValGamutNone,
		LEVEL_SANE, LUMA_IGNORE, BIAS_NONE, YCC_SCALE1 },

{ xieValCIEXYZToRGB, RGB_FF,
		MAT_TOXYZ, MAT_TORGB, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_SANE, LUMA_IGNORE, BIAS_NONE, YCC_SCALE1 },

{ xieValCIEXYZToRGB, RGB_FF,
		MAT_TOXYZ, MAT_TORGB, WHITE_LAB, WP_BUNCH, xieValGamutNone,
		LEVEL_SANE, LUMA_IGNORE, BIAS_NONE, YCC_SCALE1 },

{ xieValCIEXYZToRGB, RGB_IF,
		MAT_TOXYZ, MAT_TORGB, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_SANE, LUMA_IGNORE, BIAS_NONE, YCC_SCALE1 },

{ xieValCIEXYZToRGB, RGB_IF,
		MAT_TOXYZ, MAT_TORGB, WHITE_LAB, WP_BUNCH, xieValGamutNone,
		LEVEL_SANE, LUMA_IGNORE, BIAS_NONE, YCC_SCALE1 },

{ xieValYCbCrToRGB,  RGB_FF,
		MAT_IGNORE, MAT_IGNORE, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_SANE, LUMA_CCIR601_1, BIAS_NONE, YCC_SCALE1 },

{ xieValYCbCrToRGB,  RGB_II,
		MAT_IGNORE, MAT_IGNORE, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_SANE, LUMA_CCIR601_1, BIAS_SANE, YCC_SCALE1 },

{ xieValYCbCrToRGB,  RGB_II,
		MAT_IGNORE, MAT_IGNORE, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_CRAZY, LUMA_CCIR601_1, BIAS_CRAZY, YCC_SCALE1 },

{ xieValYCbCrToRGB,  RGB_II,
		MAT_IGNORE, MAT_IGNORE, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_SANE, LUMA_CCIR709, BIAS_SANE, YCC_SCALE1 },

{ xieValYCCToRGB,    RGB_FF,
		MAT_IGNORE, MAT_IGNORE, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_SANE, LUMA_CCIR601_1, BIAS_NONE, YCC_SCALE1 },

{ xieValYCCToRGB,    RGB_II,
		MAT_IGNORE, MAT_IGNORE, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_SANE, LUMA_CCIR601_1, BIAS_NONE, YCC_SCALE1 },

{ xieValYCCToRGB,    RGB_II,
		MAT_IGNORE, MAT_IGNORE, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_CRAZY, LUMA_CCIR601_1, BIAS_NONE, YCC_SCALE1 },

{ xieValYCCToRGB,    RGB_II,
		MAT_IGNORE, MAT_IGNORE, WHITE_NONE, WP_IGNORE, xieValGamutNone,
		LEVEL_SANE, LUMA_CCIR601_1, BIAS_NONE, YCC_SCALE2 },

 	 };

static UnconstrainParms UnconstrainParmVec[] = { 
	     { xieValConstrainClipScale } 
	 };

static BandParms BandParmVec[] = { 
{ { 1.0, 0.0, 0.0 }, { 0.0, 1.0, 0.0 }, { 0.0, 0.0, 1.0 }, BandSelect, 0.0, ( Atom ) NULL, False },
{ LUMA_CCIR601_1, LUMA_CCIR601_1, LUMA_CCIR601_1, BandExtract, 0.0, ( Atom ) NULL, False },
{ LUMA_CCIR601_1, LUMA_CCIR601_1, LUMA_CCIR601_1, BandExtract, 0.0, ( Atom ) NULL, False },
{ LUMA_CCIR601_1, LUMA_CCIR601_1, LUMA_CCIR601_1, BandExtract, 0.0, ( Atom ) NULL, False },
{ { 0.0, 0.0, 0.0 }, { 0.0, 0.0, 0.0 }, { 0.0, 0.0, 0.0 }, BandExtract, 0.0, ( Atom ) XA_RGB_BEST_MAP, True },
{ { 0.0, 0.0, 0.0 }, { 0.0, 0.0, 0.0 }, { 0.0, 0.0, 0.0 }, BandExtract, 0.0, ( Atom ) XA_RGB_DEFAULT_MAP, True },
				 };

static CompareParms CompareParmVec[] = { 
	{ xieValLT, { 128.0, 0.0, 0.0 }, True, 7, DomainNone, 0, 0, 0, 0 },
	{ xieValLE, { 128.0, 0.0, 0.0 }, True, 7, DomainNone, 0, 0, 0, 0 },
	{ xieValEQ, { 128.0, 0.0, 0.0 }, True, 7, DomainNone, 0, 0, 0, 0 },
	{ xieValNE, { 128.0, 0.0, 0.0 }, True, 7, DomainNone, 0, 0, 0, 0 },
	{ xieValGE, { 128.0, 0.0, 0.0 }, True, 7, DomainNone, 0, 0, 0, 0 },
	{ xieValGT, { 128.0, 0.0, 0.0 }, True, 7, DomainNone, 0, 0, 0, 0 },
	{ xieValLT, { 128.0, 0.0, 0.0 }, True, 7, DomainROI, 100, 100, 256, 256 },
	{ xieValLE, { 128.0, 0.0, 0.0 }, True, 7, DomainROI, 100, 100, 256, 256 },
	{ xieValEQ, { 128.0, 0.0, 0.0 }, True, 7, DomainROI, 100, 100, 256, 256 },
	{ xieValNE, { 128.0, 0.0, 0.0 }, True, 7, DomainROI, 100, 100, 256, 256 },
	{ xieValGE, { 128.0, 0.0, 0.0 }, True, 7, DomainROI, 100, 100, 256, 256 },
	{ xieValGT, { 128.0, 0.0, 0.0 }, True, 7, DomainROI, 100, 100, 256, 256 },
	{ xieValLT, { 128.0, 0.0, 0.0 }, True, 7, DomainCtlPlane, 0, 0, 0, 0 },
	{ xieValLE, { 128.0, 0.0, 0.0 }, True, 7, DomainCtlPlane, 0, 0, 0, 0 },
	{ xieValEQ, { 128.0, 0.0, 0.0 }, True, 7, DomainCtlPlane, 0, 0, 0, 0 },
	{ xieValNE, { 128.0, 0.0, 0.0 }, True, 7, DomainCtlPlane, 0, 0, 0, 0 },
	{ xieValGE, { 128.0, 0.0, 0.0 }, True, 7, DomainCtlPlane, 0, 0, 0, 0 },
	{ xieValGT, { 128.0, 0.0, 0.0 }, True, 7, DomainCtlPlane, 0, 0, 0, 0 },
				   };

static ArithmeticParms ArithmeticParmVec[] = { 
/* constrained */
{ xieValAdd, { 64.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
{ xieValSub, { 64.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
{ xieValSubRev, { 255.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
{ xieValMul, { 0.66, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
{ xieValDiv, { 1.5, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
{ xieValDivRev, { 25500.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
{ xieValMin, { 128.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
{ xieValMax, { 128.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
{ xieValGamma, { 1.1, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
{ xieValAdd, { 64.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValSub, { 64.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValSubRev, { 255.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValMul, { 0.66, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValDiv, { 1.5, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValDivRev, { 25500.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValMin, { 128.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValMax, { 128.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValGamma, { 1.1, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
/* unconstrained */
{ xieValAdd, { 64.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValSub, { 64.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale,  0.0, 255.0 },
{ xieValSubRev, { 255.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValMul, { 0.66, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValDiv, { 1.5, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValDivRev, { 25500.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValMin, { 128.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValMax, { 128.0, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValGamma, { 1.1, 0.0, 0.0 }, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValAdd, { 64.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValSub, { 64.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValSubRev, { 255.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValMul, { 0.66, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValDiv, { 1.5, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValDivRev, { 25500.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValMin, { 128.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValMax, { 128.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValGamma, { 1.1, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, True, xieValConstrainClipScale, 0.0, 255.0 },
{ xieValAdd, { 64.0, 0.0, 0.0 }, 7, DomainROI, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
/* Constrained, Control Planes */
{ xieValAdd, { 64.0, 0.0, 0.0 }, 7, DomainCtlPlane, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValSub, { 64.0, 0.0, 0.0 }, 7, DomainCtlPlane, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValSubRev, { 255.0, 0.0, 0.0 }, 7, DomainCtlPlane, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValMul, { 0.66, 0.0, 0.0 }, 7, DomainCtlPlane, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValDiv, { 1.5, 0.0, 0.0 }, 7, DomainCtlPlane, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValDivRev, { 25500.0, 0.0, 0.0 }, 7, DomainCtlPlane, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValMin, { 128.0, 0.0, 0.0 }, 7, DomainCtlPlane, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValMax, { 128.0, 0.0, 0.0 }, 7, DomainCtlPlane, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
{ xieValGamma, { 1.1, 0.0, 0.0 }, 7, DomainCtlPlane, 0, 0, 512, 256, False, 0, 0.0, 0.0 },
};

/* The math test ( math.c ) can build arbitrarily long flos of math elements
   strung together. If the flo has two math elements, pass a pointer to
   the ith element in doubleOpsVec, for example, and the value 2. If you
   want to make a tripleOpsVec, for example, you can do that too. */

static XieMathOp singleOpVec[] = {  xieValExp, xieValLn, xieValLog2,
        xieValLog10, xieValSquare, xieValSqrt
};

static XieMathOp doubleOpsVec[][ 2 ] = {
	{ xieValSqrt, xieValSquare },
        { xieValSquare, xieValSqrt },
        { xieValExp, xieValLn },
        { xieValLn, xieValExp },
};

static MathParms MathParmVec[] = { 
{ doubleOpsVec[ 0 ], 2, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainHardClip, 0.0, 0.0 },
{ doubleOpsVec[ 1 ], 2, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainHardClip, 0.0, 0.0 },
{ doubleOpsVec[ 2 ], 2, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainHardClip, 0.0, 0.0 },
{ doubleOpsVec[ 3 ], 2, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainHardClip, 0.0, 0.0 },
{ &singleOpVec[ 2 ], 1, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 8.0 },
{ &singleOpVec[ 3 ], 1, 7, DomainNone, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 2.41 },
{ doubleOpsVec[ 0 ], 2, 7, DomainNone, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
{ doubleOpsVec[ 0 ], 2, 7, DomainROI, 100, 100, 256, 256, True, xieValConstrainHardClip, 0.0, 0.0 },
{ doubleOpsVec[ 1 ], 2, 7, DomainROI, 100, 100, 256, 256, True, xieValConstrainHardClip, 0.0, 0.0 },
{ doubleOpsVec[ 2 ], 2, 7, DomainROI, 100, 100, 256, 256, True, xieValConstrainHardClip, 0.0, 0.0 },
{ doubleOpsVec[ 3 ], 2, 7, DomainROI, 100, 100, 256, 256, True, xieValConstrainHardClip, 0.0, 0.0 },
{ &singleOpVec[ 2 ], 1, 7, DomainROI, 100, 100, 256, 256, True, xieValConstrainClipScale, 0.0, 8.0 },
{ &singleOpVec[ 3 ], 1, 7, DomainROI, 100, 100, 256, 256, True, xieValConstrainClipScale, 0.0, 2.41 },
{ doubleOpsVec[ 0 ], 2, 7, DomainROI, 100, 100, 256, 256, False, 0, 0.0, 0.0 },
{ doubleOpsVec[ 0 ], 2, 7, DomainCtlPlane, 0, 0, 0, 0, True, xieValConstrainHardClip, 0.0, 0.0 },
{ doubleOpsVec[ 1 ], 2, 7, DomainCtlPlane, 0, 0, 0, 0, True, xieValConstrainHardClip, 0.0, 0.0 },
{ doubleOpsVec[ 2 ], 2, 7, DomainCtlPlane, 0, 0, 0, 0, True, xieValConstrainHardClip, 0.0, 0.0 },
{ doubleOpsVec[ 3 ], 2, 7, DomainCtlPlane, 0, 0, 0, 0, True, xieValConstrainHardClip, 0.0, 0.0 },
{ &singleOpVec[ 2 ], 1, 7, DomainCtlPlane, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 8.0 },
{ &singleOpVec[ 3 ], 1, 7, DomainCtlPlane, 0, 0, 0, 0, True, xieValConstrainClipScale, 0.0, 2.41 },
{ doubleOpsVec[ 0 ], 2, 7, DomainCtlPlane, 0, 0, 0, 0, False, 0, 0.0, 0.0 },
};

static BlendParms BlendParmVec[] = { 
		{ { 0.1, 0.0, 0.0 }, 0.5, 7, DomainNone, 0 },
		{ { 220.0, 0.0, 0.0 }, 255.0, 7, DomainNone, 0 },
		{ { 0.0, 0.0, 0.0 }, 250.0, 7, DomainNone, 0 },
		{ { 0.1, 0.0, 0.0 }, 0.5, 7, DomainROI, 5 },
		{ { 220.0, 0.0, 0.0 }, 255.0, 7, DomainROI, 5 },
		{ { 0.0, 0.0, 0.0 }, 250.0, 7, DomainROI, 5 },
		{ { 0.1, 0.0, 0.0 }, 0.5, 7, DomainCtlPlane, 0 },
				   };

static ConvolveParms ConvolveParmVec[] = { 
{ False, 7, DomainNone, 0, 0, 0, 0, xieValConvolveDefault, { 0.0, 0.0, 0.0 }, Boxcar3 },
{ False, 7, DomainNone, 0, 0, 0, 0, xieValConvolveDefault, { 0.0, 0.0, 0.0 }, Boxcar5 },
{ False, 7, DomainNone, 0, 0, 0, 0, xieValConvolveDefault, { 0.0, 0.0, 0.0 }, LaPlacian3 },
{ False, 7, DomainNone, 0, 0, 0, 0, xieValConvolveDefault, { 0.0, 0.0, 0.0 }, LaPlacian5 },
{ False, 7, DomainROI, 100, 100, 256, 256, xieValConvolveDefault, { 0.0, 0.0, 0.0 }, LaPlacian3 },
{ False, 7, DomainROI, 100, 100, 256, 256, xieValConvolveDefault, { 0.0, 0.0, 0.0 }, LaPlacian5 },
{ False, 7, DomainCtlPlane, 0, 0, 0, 0, xieValConvolveDefault, { 0.0, 0.0, 0.0 }, LaPlacian3 },
{ False, 7, DomainCtlPlane, 0, 0, 0, 0, xieValConvolveDefault, { 0.0, 0.0, 0.0 }, LaPlacian5 },
				   };

static ConstrainParms ConstrainParmVec[] = { 
     	{ False, xieValConstrainHardClip, ( int ) NULL }, 
     	{ False, xieValConstrainClipScale, ( int ) ClampInputs }, 
	{ False, xieValConstrainClipScale, ( int ) NULL }, 
	{ True, xieValConstrainHardClip, ( int ) NULL }, 
	{ True, xieValConstrainClipScale, ( int ) ClampInputs }, 
	{ True, xieValConstrainClipScale, ( int ) NULL }, 
				           };

static DitherParms DitherParmVec[] = { 
	{ xieValDitherErrorDiffusion, Drawable, 0, 1 }, 
	{ xieValDitherErrorDiffusion, DrawablePlane, 0, 1 }, 
	{ xieValDitherOrdered, Drawable, 4, 1 }, 
	{ xieValDitherOrdered, DrawablePlane, 4, 1 }, 
	{ xieValDitherOrdered, Drawable, 8, 1 }, 
	{ xieValDitherOrdered, DrawablePlane, 8, 1 }, 
	{ xieValDitherDefault, Drawable, 0, 1 },
	{ xieValDitherDefault, DrawablePlane, 0, 1 }
};

static GeometryParms GeometryParmVec[] = {
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomNearestNeighbor, 12, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomNearestNeighbor, 147, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomNearestNeighbor, 193, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomNearestNeighbor, 311, True },
{ GEO_TYPE_MIRRORX, 512, 512, 0, 0, xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_MIRRORY, 512, 512, 0, 0, xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_MIRRORXY, 512, 512, 0, 0, xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_CROP, 256, 256, 256, 256, xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_SCALE, 128, 128, 0, 0, xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_SCALE, 256, 256, 0, 0, xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_SCALE, 256, 512, 0, 0, xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_SCALE, 512, 128, 0, 0, xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_SCALE, 256, 768, 0, 0, xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_SCALE, 128, 768, 0, 0, xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomAntialias, 12, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomAntialias, 147, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomAntialias, 193, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomAntialias, 311, True },
{ GEO_TYPE_MIRRORX, 512, 512, 0, 0, xieValGeomAntialias, 0, True },
{ GEO_TYPE_MIRRORY, 512, 512, 0, 0, xieValGeomAntialias, 0, True },
{ GEO_TYPE_MIRRORXY, 512, 512, 0, 0, xieValGeomAntialias, 0, True },
{ GEO_TYPE_CROP, 256, 256, 256, 256, xieValGeomAntialias, 0, True },
{ GEO_TYPE_SCALE, 128, 128, 0, 0, xieValGeomAntialias, 0, True },
{ GEO_TYPE_SCALE, 256, 256, 0, 0, xieValGeomAntialias, 0, True },
{ GEO_TYPE_SCALE, 256, 512, 0, 0, xieValGeomAntialias, 0, True },
{ GEO_TYPE_SCALE, 512, 128, 0, 0, xieValGeomAntialias, 0, True },
{ GEO_TYPE_SCALE, 256, 768, 0, 0, xieValGeomAntialias, 0, True },
{ GEO_TYPE_SCALE, 128, 768, 0, 0, xieValGeomAntialias, 0, True },
{ GEO_TYPE_SCALE, 512, 512, 0,0,  xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_SCALE, 512, 512, 0,0,  xieValGeomAntialias, 0, True },
{ GEO_TYPE_SCALE, 512, 512, 0,0,  xieValGeomNearestNeighbor, 0, True },
{ GEO_TYPE_SCALE, 512, 512, 0,0,  xieValGeomAntialias, 0, True },
{ GEO_TYPE_SCALEDROTATE, 512, 512, 0,0,xieValGeomNearestNeighbor, 12, True },
{ GEO_TYPE_SCALEDROTATE, 512, 512, 0,0,xieValGeomNearestNeighbor, 147, True },
{ GEO_TYPE_SCALEDROTATE, 512, 512, 0,0,xieValGeomNearestNeighbor, 193, True },
{ GEO_TYPE_SCALEDROTATE, 512, 512, 0,0,xieValGeomNearestNeighbor, 311, True },
{ GEO_TYPE_SCALEDROTATE, 512, 512, 0,0,xieValGeomAntialias, 12, True },
{ GEO_TYPE_SCALEDROTATE, 512, 512, 0,0,xieValGeomAntialias, 147, True },
{ GEO_TYPE_SCALEDROTATE, 512, 512, 0,0,xieValGeomAntialias, 193, True },
{ GEO_TYPE_SCALEDROTATE, 512, 512, 0,0,xieValGeomAntialias, 311, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomBilinearInterp, 12, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomBilinearInterp, 147, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomBilinearInterp, 193, True },
{ GEO_TYPE_ROTATE, 512, 512, 0, 0, xieValGeomBilinearInterp, 311, True },
{ GEO_TYPE_MIRRORX, 512, 512, 0, 0, xieValGeomBilinearInterp, 0, True },
{ GEO_TYPE_MIRRORY, 512, 512, 0, 0, xieValGeomBilinearInterp, 0, True },
{ GEO_TYPE_MIRRORXY, 512, 512, 0, 0, xieValGeomBilinearInterp, 0, True },
{ GEO_TYPE_CROP, 256, 256, 256, 256, xieValGeomBilinearInterp, 0, True },
{ GEO_TYPE_SCALE, 128, 128, 0, 0, xieValGeomBilinearInterp, 0, True },
{ GEO_TYPE_SCALE, 256, 256, 0, 0, xieValGeomBilinearInterp, 0, True },
{ GEO_TYPE_SCALE, 256, 512, 0, 0, xieValGeomBilinearInterp, 0, True },
{ GEO_TYPE_SCALE, 512, 128, 0, 0, xieValGeomBilinearInterp, 0, True },
{ GEO_TYPE_SCALE, 256, 768, 0, 0, xieValGeomBilinearInterp, 0, True },
{ GEO_TYPE_SCALE, 128, 768, 0, 0, xieValGeomBilinearInterp, 0, True },
{ GEO_TYPE_SCALE, 512, 512, 0,0,xieValGeomAntialias, 0, False },
};

static AbortParms AbortParmVec[] = { 
				     { 256, 256 } 
				   };

static AwaitParms AwaitParmVec[] = { 
				     { 256, 256 } 
			           };

static PasteUpParms PasteUpParmVec[] = { 
				     { NoOverlap },
				     { Overlap } 
			               };

/* SingleBand Parameters for FunnyEncode tests with three EP elements */

XieOrientation SingleFillOrderThreeVec[ 3 ] = { xieValLSFirst, xieValMSFirst, xieValLSFirst };
XieOrientation SinglePixelOrderThreeVec[ 3 ] = { xieValMSFirst, xieValLSFirst, xieValMSFirst };
unsigned char SinglePixelStrideThreeVec[ 3 ] = { 8, 11, 13 };
unsigned char SingleScanlinePadThreeVec[ 3 ] = { 0, 8, 16 };  
 
/* TripleBand Parameters for FunnyEncode tests with three EP elements */

XieOrientation TripleFillOrderThreeVec[ 3 ] = { xieValLSFirst, xieValMSFirst, xieValLSFirst };
XieOrientation TriplePixelOrderThreeVec[ 3 ] = { xieValMSFirst, xieValLSFirst, xieValMSFirst };
unsigned char TriplePixelStrideThreeVec[ 9 ] = { 35, 37, 36, 37, 39, 41, 36, 35, 41 };
unsigned char TripleScanlinePadThreeVec[ 9 ] = { 0, 8, 16, 16, 8, 8, 8, 8, 8 };  
XieOrientation TripleBandOrderThreeVec[ 3 ] = { xieValLSFirst, xieValMSFirst, xieValLSFirst };
XieInterleave TripleInterleaveThreeVec[ 3 ] = { xieValBandByPixel, xieValBandByPlane, xieValBandByPixel };

static FunnyEncodeParms FunnyEncodeParmVec[] = { 
  { 3, SingleFillOrderThreeVec, SinglePixelOrderThreeVec, SinglePixelStrideThreeVec, SingleScanlinePadThreeVec, ( XieOrientation * ) NULL, ( XieInterleave * ) NULL, False, { 0, 0, 0 } },	
  { 3, TripleFillOrderThreeVec, TriplePixelOrderThreeVec, ( unsigned char * ) TriplePixelStrideThreeVec, ( unsigned char * ) TripleScanlinePadThreeVec, ( XieOrientation * ) TripleBandOrderThreeVec, ( XieInterleave * ) TripleInterleaveThreeVec, False, { 0, 0, 0 } },	
  { 3, TripleFillOrderThreeVec, TriplePixelOrderThreeVec, ( unsigned char * ) TriplePixelStrideThreeVec, ( unsigned char * ) TripleScanlinePadThreeVec, ( XieOrientation * ) TripleBandOrderThreeVec, ( XieInterleave * ) TripleInterleaveThreeVec, True, { 5, 10, 7 } },	
  { 3, TripleFillOrderThreeVec, TriplePixelOrderThreeVec, ( unsigned char * ) TriplePixelStrideThreeVec, ( unsigned char * ) TripleScanlinePadThreeVec, ( XieOrientation * ) TripleBandOrderThreeVec, ( XieInterleave * ) TripleInterleaveThreeVec, True, { 7, 13, 11 } },	
  { 3, SingleFillOrderThreeVec, SinglePixelOrderThreeVec, SinglePixelStrideThreeVec, SingleScanlinePadThreeVec, ( XieOrientation * ) NULL, ( XieInterleave * ) NULL, True, { 3, 0, 0 } },	
};

static PointParms PointParmVec[] = { 
		     { False, 8, 8, DomainNone, 0, 0, 0, 0, 7 },
		     { False, 1, 8, DomainNone, 0, 0, 0, 0, 7 },
		     { False, 8, 1, DomainNone, 0, 0, 0, 0, 7 },
		     { False, 8, 8, DomainROI, 100, 100, 256, 256, 7 },
		     { True, 8, 8, DomainNone, 0, 0, 0, 0, 7 },
		     { True, 1, 8, DomainNone, 0, 0, 0, 0, 7 },
		     { True, 8, 1, DomainNone, 0, 0, 0, 0, 7 },
		     { True, 8, 8, DomainROI, 100, 100, 256, 256, 7 },
		     { False, 8, 8, DomainCtlPlane, 0, 0, 0, 0, 7 },
		     { True, 8, 8, DomainCtlPlane, 0, 0, 0, 0, 7 },
			           };

static TriplePointParms TriplePointParmVec[] = { 
	{ DomainNone, 0, 0, 0, 0, XA_RGB_BEST_MAP, 0x7, xieValDitherDefault, 0 },
	{ DomainNone, 0, 0, 0, 0, XA_RGB_DEFAULT_MAP, 0x7, xieValDitherDefault, 0 },
			           };

/* Encode test configuration */

static XieEncodeUncompressedSingleParam encodeSingleParms[] = {
	{ xieValLSFirst, xieValLSFirst, 8, 0 } 
	};

static XieEncodeUncompressedTripleParam encodeTripleParms[] = {
	{ { 24, 24, 24 }, xieValLSFirst, { 0, 0, 0 }, xieValLSFirst, 
	  xieValLSFirst, xieValBandByPixel } 
	};

static XieEncodeG31DParam encodeG31DParms[] = {
	{ True, True, xieValMSFirst }
	};

static XieEncodeG32DParam encodeG32DParms[] = {
	{ False, False, True, xieValMSFirst, 2 }
	};

static XieEncodeG42DParam encodeG42DParms[] = {
	{ False, True, xieValMSFirst }
	};

static XieEncodeServerChoiceParam encodeChoiceParms[] = {
	{ xieValPreferDefault },
	{ xieValPreferSpace },
	{ xieValPreferTime },
	};

static unsigned char q_table[] = {
        16,  11,  10,  16,  24,  40,  51,  61,
        12,  12,  14,  19,  26,  58,  60,  55,
        14,  13,  16,  24,  40,  57,  69,  56,
        14,  17,  22,  29,  51,  87,  80,  62,
        18,  22,  37,  56,  68, 109, 103,  77,
        24,  35,  55,  64,  81, 104, 113,  92,
        49,  64,  78,  87, 103, 121, 120, 101,
        72,  92,  95,  98, 112, 100, 103,  99,

        17,  18,  24,  47,  99,  99,  99,  99,
        18,  21,  26,  66,  99,  99,  99,  99,
        24,  26,  56,  99,  99,  99,  99,  99,
        47,  66,  99,  99,  99,  99,  99,  99,
        99,  99,  99,  99,  99,  99,  99,  99,
        99,  99,  99,  99,  99,  99,  99,  99,
        99,  99,  99,  99,  99,  99,  99,  99,
        99,  99,  99,  99,  99,  99,  99,  99
        };
    
#define NQ_TABLE 128

static unsigned char dc_table[] = {
        0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,

        0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11
        };
    
#define NDC_TABLE 56        

static unsigned char ac_table[] = {
        0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 0x7d,
        0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12,
        0x21, 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07,
        0x22, 0x71, 0x14, 0x32, 0x81, 0x91, 0xa1, 0x08,
        0x23, 0x42, 0xb1, 0xc1, 0x15, 0x52, 0xd1, 0xf0,
        0x24, 0x33, 0x62, 0x72, 0x82, 0x09, 0x0a, 0x16,
        0x17, 0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28,
        0x29, 0x2a, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
        0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
        0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
        0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
        0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
        0x7a, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89,
        0x8a, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98,
        0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
        0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6,
        0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5,
        0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4,
        0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe1, 0xe2,
        0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
        0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
        0xf9, 0xfa,

        0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 0x77,
        0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21,
        0x31, 0x06, 0x12, 0x41, 0x51, 0x07, 0x61, 0x71,
        0x13, 0x22, 0x32, 0x81, 0x08, 0x14, 0x42, 0x91,
        0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33, 0x52, 0xf0,
        0x15, 0x62, 0x72, 0xd1, 0x0a, 0x16, 0x24, 0x34,
        0xe1, 0x25, 0xf1, 0x17, 0x18, 0x19, 0x1a, 0x26,
        0x27, 0x28, 0x29, 0x2a, 0x35, 0x36, 0x37, 0x38,
        0x39, 0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
        0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
        0x59, 0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
        0x69, 0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
        0x79, 0x7a, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
        0x88, 0x89, 0x8a, 0x92, 0x93, 0x94, 0x95, 0x96,
        0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5,
        0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4,
        0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3,
        0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2,
        0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda,
        0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9,
        0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
        0xf9, 0xfa
        };

#define NAC_TABLE 356

static XieEncodeJPEGBaselineParam encodeJPEGBaselineParms[] = {
	{ xieValBandByPixel, xieValLSFirst, { 1, 1, 1 }, { 1, 1, 1 }, ( char * ) NULL, 0, ( char * ) NULL,
	  0, ( char * ) NULL, 0 },
	{ xieValBandByPixel, xieValMSFirst, { 1, 1, 1 }, { 1, 1, 1 }, ( char * ) q_table, NQ_TABLE, 
	  ( char * ) ac_table, NAC_TABLE, ( char * ) dc_table, 
	  NDC_TABLE },
	{ xieValBandByPlane, xieValLSFirst, { 1, 1, 1 }, { 1, 1, 1 }, ( char * ) NULL, 0, ( char * ) NULL,
	  0, ( char * ) NULL, 0 }
	};

static XieEncodeTIFF2Param encodeTIFF2Parms[] = {
	{ xieValMSFirst, False }
	};

static XieEncodeTIFFPackBitsParam encodeTIFFPackBitsParms[] = {
	{ xieValMSFirst }
	};

static EncodeParms EncodeParmVec[] = {
	{ xieValEncodeG31D, ( char * ) &encodeG31DParms[0], False, 0 },
	{ xieValEncodeG32D, ( char * ) &encodeG32DParms[0], False, 0 },
	{ xieValEncodeG42D, ( char * ) &encodeG42DParms[0], False, 0 },
	{ xieValEncodeTIFF2, ( char * ) &encodeTIFF2Parms[0], False, 0 },
	{ xieValEncodeTIFFPackBits, ( char * ) &encodeTIFFPackBitsParms[0], False, 0 },
	{ xieValEncodeUncompressedSingle, ( char * ) &encodeSingleParms[0], False, 0 },
	{ xieValEncodeUncompressedTriple, ( char * ) &encodeTripleParms[0], False, 0 },
	{ xieValEncodeJPEGBaseline, ( char * ) &encodeJPEGBaselineParms[0], False, 0 },
	{ xieValEncodeG31D, ( char * ) &encodeG31DParms[0], True, 0 },
	{ xieValEncodeG32D, ( char * ) &encodeG32DParms[0], True, 0 },
	{ xieValEncodeG42D, ( char * ) &encodeG42DParms[0], True, 0 },
	{ xieValEncodeTIFF2, ( char * ) &encodeTIFF2Parms[0], True, 0 },
	{ xieValEncodeTIFFPackBits, ( char * ) &encodeTIFFPackBitsParms[0], True, 0 },
	{ xieValEncodeUncompressedSingle, ( char * ) &encodeSingleParms[0], True, 0 },
	{ xieValEncodeUncompressedTriple, ( char * ) &encodeTripleParms[0], True, 0 },
	{ xieValEncodeJPEGBaseline, ( char * ) &encodeJPEGBaselineParms[0], True, 0 },
	{ xieValEncodeJPEGBaseline, ( char * ) &encodeJPEGBaselineParms[2], True, 30 },
	{ xieValEncodeJPEGBaseline, ( char * ) &encodeJPEGBaselineParms[2], False, 30 },
	{ xieValEncodeJPEGBaseline, ( char * ) &encodeJPEGBaselineParms[1], True, 30 },
	{ xieValEncodeJPEGBaseline, ( char * ) &encodeJPEGBaselineParms[1], False, 30 },
	{ xieValEncodeServerChoice, ( char * ) &encodeChoiceParms[0], False, 0 },
	{ xieValEncodeServerChoice, ( char * ) &encodeChoiceParms[1], False, 0 },
	{ xieValEncodeServerChoice, ( char * ) &encodeChoiceParms[2], False, 0 }
};

static ImportParms ImportParmVec[] = { 
				     { NoObscure, 0 },
				     { Obscuring, 0 },
				     { Obscured, 0 },
				     { ( int ) NULL, 10 },	/* ROIs */
				     { ( int ) NULL, 100 },
			             };

static LogicalParms LogicalParmVec[] = { 
     { { 0.0, 0.0, 0.0 }, GXclear, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXand, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXandReverse, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXcopy, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXandInverted, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXnoop, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXxor, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXor, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXnor, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXequiv, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXinvert, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXorReverse, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXcopyInverted, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXorInverted, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXnand, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXset, 7, DomainNone, 0 },
     { { 0.0, 0.0, 0.0 }, GXclear, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXand, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXandReverse, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXcopy, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXandInverted, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXnoop, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXxor, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXor, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXnor, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXequiv, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXinvert, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXorReverse, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXcopyInverted, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXorInverted, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXnand, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXset, 7, DomainROI, 5 },
     { { 0.0, 0.0, 0.0 }, GXclear, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXand, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXandReverse, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXcopy, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXandInverted, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXnoop, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXxor, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXor, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXnor, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXequiv, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXinvert, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXorReverse, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXcopyInverted, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXorInverted, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXnand, 7, DomainCtlPlane, 0 },
     { { 0.0, 0.0, 0.0 }, GXset, 7, DomainCtlPlane, 0 },
};

static QueryParms QueryParmVec[] = { 
	{ 0, 0, xieValDefault },
	{ 0, 0, xieValAll },
	{ 0, 0, xieValColorAlloc },
	{ 0, 0, xieValConstrain },
	{ 0, 0, xieValConvertFromRGB },
	{ 0, 0, xieValConvertToRGB },
	{ 0, 0, xieValConvolve },
	{ 0, 0, xieValDecode },
	{ 0, 0, xieValDither },
	{ 0, 0, xieValEncode },
	{ 0, 0, xieValGamut },
	{ 0, 0, xieValGeometry },
	{ 0, 0, xieValHistogram },
	{ 0, 0, xieValWhiteAdjust },
	{ 256, 256, ( XieTechniqueGroup ) NULL }
};

Test test[] = {
  {"-ImportObscuredEvent","ImportObscured event",
		InitEvents, DoImportObscuredEvent, NullProc, 
		EndEvents, VALL, 0, 0,
		{1, CAPA_EVENT, 2048, {  &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &EventParmVec[ 2 ] } }, 
  {"-ColorAllocEvent","ColorAlloc event",
		InitEvents, DoColorAllocEvent, NullProc, 
		EndEvents, VALL, 0, 0,
		{1, SUBSET_FULL | CAPA_EVENT, 2048, 
		{  &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &EventParmVec[ 0 ] } }, 
  {"-PhotofloDoneEvent","PhotofloDone event",
		InitEvents, DoPhotofloDoneEvent, NullProc, 
		EndEvents, VALL, 0, 0,
		{1, CAPA_EVENT, 2048, {  &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &EventParmVec[ 3 ] } }, 
  {"-DecodeNotifyEvent","DecodeNotify event",
		InitEvents, DoDecodeNotifyEvent, NullProc, 
		EndEvents, VALL, 0, 0,
		{1, CAPA_EVENT, 2048, {  &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &EventParmVec[ 1 ] } }, 
  {"-ExportAvailable","ExportAvailable event",
		InitEvents, DoExportAvailableEvent, NullProc, 
		EndEvents, VALL, 0, 0,
		{1, CAPA_EVENT, 2048, {  &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &EventParmVec[ 4 ] } }, 
  {"-BadValue","BadValue error event",
		InitErrors, DoBadValueError, NullProc, 
		EndErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 11 ] } }, 
  {"-LUTError","LUT error event",
		InitErrors, DoLUTError, NullProc, 
		EndErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 0 ] } }, 
  {"-FloLUTError","FloLUT error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 2 ] } }, 
  {"-PhotomapError","Photomap error event",
		InitErrors, DoPhotomapError, NullProc, 
		EndErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 3 ] } }, 
  {"-ROIError","ROI error event",
		InitErrors, DoROIError, NullProc, 
		EndErrors, VALL, 0, 0,
		{1, SUBSET_FULL | CAPA_ERROR, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 4 ] } }, 
  {"-ColorListError","ColorList error event",
		InitErrors, DoColorListError, NullProc, 
		EndErrors, VALL, 0, 0,
		{1, CAPA_ERROR | SUBSET_FULL, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 5 ] } }, 
  {"-PhotospaceError","Photospace error event",
		InitErrors, DoPhotospaceError, NullProc, 
		EndErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 6 ] } }, 
  {"-FloROIError","FloROI error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR | SUBSET_FULL, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 12 ] } }, 
  {"-FloIDError","FloID error event",
		InitFloErrors, DoFloIDError, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 13 ] } }, 
  {"-FloOperatorError","FloOperator error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 14 ] } }, 
  {"-FloSourceError","FloSource error event",
		InitFloErrors, DoFloErrorImmediate, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 15 ] } }, 
  {"-FloPhotomapError","FloPhotomap error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, 
		{ NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 16 ] } }, 
  {"-FloDrawableError","FloDrawable error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 17 ] } }, 
  {"-FloGCError","FloGC error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 18 ] } }, 
  {"-FloElementError","FloElement error event",
		InitFloErrors, DoFloElementError, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 19 ] } }, 
  {"-FloColorListError","FloColorList error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR | SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 20 ] } }, 
  {"-FloDomainError","FloDomain error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 21 ] } }, 
  {"-FloColormapError","FloColormap error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR | SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 22 ] } }, 
  {"-FloAccessError","FloAccess error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 7 ] } }, 
  {"-FloMatchError","FloMatch error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, 
		{  &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 23 ] } }, 
  {"-FloTechniqueError","FloTechnique error event",
		InitFloErrors, DoFloErrorImmediate, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, 
		{  &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 24 ] } }, 
  {"-FloValueError","FloValue error event",
		InitFloErrors, DoErrors, NullProc, 
		EndFloErrors, VALL, 0, 0,
		{1, CAPA_ERROR, 2048, 
		{  NULL, NULL, NULL, NULL }, 
		( XPointer ) &ErrorParmVec[ 25 ] } }, 
  {"-ColorList","XieCreateColorList/XieDestroyColorList",
		InitCreateDestroy, DoCreateDestroyColorList, NullProc, 
		EndCreateDestroy, VALL, 0, 0,
		{1, SUBSET_FULL, 0, 
		{ NULL, NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-LUT","XieCreateLUT/XieDestroyLUT",
		InitCreateDestroy, DoCreateDestroyLUT, NullProc, 
		EndCreateDestroy, VALL, 0, 0,
		{1, 0, 0, 
		{ NULL, NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-Photomap","XieCreatePhotomap/XieDestroyPhotomap",
		InitCreateDestroy, DoCreateDestroyPhotomap, NullProc, 
		EndCreateDestroy, VALL, 0, 0,
		{1, 0, 0, 
		{ NULL, NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-ROI","XieCreateROI/XieDestroyROI",
		InitCreateDestroy, DoCreateDestroyROI, NullProc, 
		EndCreateDestroy, VALL, 0, 0,
		{1, SUBSET_FULL, 0, 
		{ NULL, NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-Photospace","XieCreatePhotospace/XieDestroyPhotospace",
		InitCreateDestroy, DoCreateDestroyPhotospace, NullProc, 
		EndCreateDestroy, VALL, 0, 0,
		{1, 0, 0, 
		{ NULL, NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-Photoflo","XieCreatePhotoflo/XieDestroyPhotoflo size 2",
		InitCreateDestroyPhotoflo, DoCreateDestroyPhotoflo, NullProc, 
		EndCreateDestroyPhotoflo, VALL, 0, 0,
		{1, 0, 2048, 
		{ NULL, NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-QueryPhotomap","XieQueryPhotomap",
		InitQueryPhotomap, DoQueryPhotomap, NullProc, 
		EndQueryPhotomap, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-QueryColorList","XieQueryColorList",
		InitQueryColorList, DoQueryColorList, NullProc, 
		EndQueryColorList, VALL, 0, 0,
		{1, SUBSET_FULL, 0, 
		{ NULL, NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-QueryTechniquesDefault","XieQueryTechniques Default",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, 0, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 0 ] } },
  {"-QueryTechniquesAll","XieQueryTechniques All",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, 0, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 1 ] } },
  {"-QueryTechniquesColorAlloc","XieQueryTechniques ColorAlloc",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, SUBSET_FULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 2 ] } },
  {"-QueryTechniquesConstrain","XieQueryTechniques Constrain",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, SUBSET_FULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 3 ] } },
  {"-QueryTechniquesConvertFromRGB","XieQueryTechniques ConvertFromRGB",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, SUBSET_FULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 4 ] } },
  {"-QueryTechniquesConvertToRGB","XieQueryTechniques ConvertToRGB",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, SUBSET_FULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 5 ] } },
  {"-QueryTechniquesConvolve","XieQueryTechniques Convolve",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, SUBSET_FULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 6 ] } },
  {"-QueryTechniquesDecode","XieQueryTechniques Decode",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, 0, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 7 ] } },
  {"-QueryTechniquesDither","XieQueryTechniques Dither",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, SUBSET_FULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 8 ] } },
  {"-QueryTechniquesEncode","XieQueryTechniques Encode",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, 0, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 9 ] } },
  {"-QueryTechniquesGamut","XieQueryTechniques Gamut",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, SUBSET_FULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 10 ] } },
  {"-QueryTechniquesGeometry","XieQueryTechniques Geometry",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, 0, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 11 ] } },
  {"-QueryTechniquesHistogram","XieQueryTechniques Histogram",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, SUBSET_FULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 12 ] } },
  {"-QueryTechniquesWhiteAdjust","XieQueryTechniques WhiteAdjust",
		InitQueryTechniques, DoQueryTechniques, NullProc, 
		EndQueryTechniques, VALL, 0, 0,
		{1, SUBSET_FULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 13 ] } },
  {"-QueryPhotoflo","XieQueryPhotoflo",
		InitQueryPhotoflo, DoQueryPhotoflo, NullProc, 
		EndQueryPhotoflo, VALL, 0, 0,
		{1, 0, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &QueryParmVec[ 14 ] } },
  {"-PurgeColorList","XiePurgeColorList",
		InitPurgeColorList, DoPurgeColorList, NullProc, 
		EndPurgeColorList, VALL, 0, 0,
		{1, SUBSET_FULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) NULL } },
  {"-Abort","XieAbort",
		InitAbort, DoAbort, NullProc, 
		EndAbort, VALL, 0, 0,
		{1, 0, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &AbortParmVec[ 0 ] } },
  {"-Await","XieAwait",
		InitAwait, DoAwait, NullProc, 
		EndAwait, VALL, 0, 0,
		{1, 0, 2048, { NULL, NULL, NULL, NULL },
		( XPointer ) &AwaitParmVec[ 0 ] } }, 
  {"-importclientlut1","ICL/EL",
		InitImportClientLUT, DoImportClientLUT, NullProc, 
		EndImportClientLUT, VALL, 0, 0,
		{1, 0, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) NULL } },
  {"-importclientphoto1","ICP/EP UncompressedSingle",
		InitImportClientPhoto, DoImportClientPhoto, NullProc, 
		EndImportClientPhoto, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) NULL } }, 
  {"-importclientphoto3","ICP/EP UncompressedTriple",
		InitImportClientPhoto, DoImportClientPhoto, NullProc, 
		EndImportClientPhoto, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 3 ], NULL, NULL, NULL },
		( XPointer ) NULL } }, 
  {"-importclientphoto4","ICP/EP G31D",
		InitImportClientPhoto, DoImportClientPhoto, NullProc, 
		EndImportClientPhoto, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 7 ], NULL, NULL, NULL },
		( XPointer ) NULL } }, 
  {"-importclientphoto5","ICP/EP G32D",
		InitImportClientPhoto, DoImportClientPhoto, NullProc, 
		EndImportClientPhoto, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 6 ], NULL, NULL, NULL },
		( XPointer ) NULL } }, 
  {"-importclientphoto6","ICP/EP G42D",
		InitImportClientPhoto, DoImportClientPhoto, NullProc, 
		EndImportClientPhoto, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 4 ], NULL, NULL, NULL },
		( XPointer ) NULL } }, 
  {"-importclientphoto7","ICP/EP TIFF2",
		InitImportClientPhoto, DoImportClientPhoto, NullProc, 
		EndImportClientPhoto, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 9 ], NULL, NULL, NULL },
		( XPointer ) NULL } }, 
  {"-importclientphoto8","ICP/EP TIFFPackBits",
		InitImportClientPhoto, DoImportClientPhoto, NullProc, 
		EndImportClientPhoto, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 8 ], NULL, NULL, NULL },
		( XPointer ) NULL } }, 
  {"-importclientphoto9","ICP/ED UncompressedSingle",
		InitImportClientPhotoExportDrawable, DoImportClientPhoto, 
		NullProc, EndImportClientPhoto, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) NULL } }, 
  {"-importclientroi1","ICR/ER 10 rectangles",
		InitImportClientROI, DoImportClientROI, NullProc, 
		EndImportClientROI, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ImportClParmVec[0] } },
  {"-importclientroi2","ICR/ER 100 rectangles",
		InitImportClientROI, DoImportClientROI, NullProc, 
		EndImportClientROI, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ImportClParmVec[1] } },
  {"-encodephoto1","IP/EP IP/(BC)/ED G31D",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 0 ] } },
  {"-encodephoto2","IP/EP IP/(BC)/ED G32D",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 1 ] } },
  {"-encodephoto3","IP/EP IP/(BC)/ED G42D",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 2 ] } },
  {"-encodephoto4","IP/EP IP/(BC)/ED TIFF2",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 3 ] } },
  {"-encodephoto5","IP/EP IP/(BC)/ED TiffPackbits",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 4 ] } },
  {"-encodephoto6","IP/EP IP/(BC)/ED UncompressedSingle",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 5 ] } },
  {"-encodephoto7","IP/EP IP/(BC)/ED UncompressedTriple",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 10 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 6 ] } },
  {"-encodephoto8","IP/EP IP/(BC)/ED JPEG TripleBand",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 10 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 7 ] } },
  {"-encodephoto9","IP/EP IP/(BC)/ED JPEG SingleBand",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 1 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 7 ] } },
  {"-encodephoto10","IP/EP IP/(BC)/ED JPEG TripleBand Tables",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 10 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 19 ] } },
  {"-encodephoto11","IP/EP IP/(BC)/ED JPEG SingleBand Tables",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 1 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 19 ] } },
  {"-encodephoto12","IP/EP IP/(BC)/ED ServerChoice Default",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 20 ] } },
  {"-encodephoto13","IP/EP IP/(BC)/ED ServerChoice Space",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 21 ] } },
  {"-encodephoto14","IP/EP IP/(BC)/ED ServerChoice Time",
		InitEncodePhotomap, DoEncodePhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 22 ] } },
  {"-encodeclientphoto1","IP/ECP ICP/(BC)/ED G31D",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 8 ] } },
  {"-encodeclientphoto2","IP/ECP ICP/(BC)/ED G32D",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 9 ] } },
  {"-encodeclientphoto3","IP/ECP ICP/(BC)/ED G42D",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 10 ] } },
  {"-encodeclientphoto4","IP/ECP ICP/(BC)/ED TIFF2",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 11 ] } },
  {"-encodeclientphoto5","IP/ECP ICP/(BC)/ED TiffPackbits",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 13 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 12 ] } },
  {"-encodeclientphoto6","IP/ECP ICP/(BC)/ED UncompressedSingle",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 13 ] } },
  {"-encodeclientphoto7","IP/ECP ICP/(BC)/ED UncompressedTriple",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 10 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 14 ] } },
  {"-encodeclientphoto8","IP/ECP ICP/(BC)/ED JPEG TripleBand ByPixel",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 10 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 15 ] } },
  {"-encodeclientphoto9","IP/ECP ICP/(BC)/ED JPEG SingleBand",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 1 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 16 ] } },
  {"-encodeclientphoto10","IP/ECP ICP/(BC)/ED JPEG TripleBand ByPixel Tables",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 10 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 18 ] } },
  {"-encodeclientphoto11","IP/ECP ICP/(BC)/ED JPEG SingleBand Tables",
		InitEncodePhotomap, DoEncodeClientPhotomap, NullProc, 
		EndEncodePhotomap, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 1 ], NULL, NULL, NULL }, 
		( XPointer ) &EncodeParmVec[ 18 ] } },
  {"-exportclientlut1","IL/ECL",
		InitExportClientLUT, DoExportClientLUT, NullProc, 
		EndExportClientLUT, VALL, 0, 0,
		{1, 0, 2048, { NULL, NULL, NULL, NULL }, ( XPointer ) NULL } },
  {"-exportclientroi1","IR/ECR 10 rectangles",
		InitExportClientROI, DoExportClientROI, NullProc, 
		EndExportClientROI, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ExportClParmVec[0] } },
  {"-exportclientroi2","IR/ECR 100 rectangles",
		InitExportClientROI, DoExportClientROI, NullProc, 
		EndExportClientROI, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { NULL, NULL, NULL, NULL }, 
		( XPointer ) &ExportClParmVec[1] } },
  {"-exportclienthistogram1","IP/ECH Image 1",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) NULL } },
  {"-exportclienthistogram2","IP/ECH Image 2",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL }, 
		( XPointer ) NULL } },
  {"-exportclienthistogram3","IP/ECH Image 3",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL }, 
		( XPointer ) NULL } },
  {"-exportclienthistogram4","IP/ECH Image 4",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 5 ], NULL, NULL, NULL }, 
		( XPointer ) NULL } },
  {"-exportclienthistogramroi1","IP/IR/ECH ROI Image 1",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &ExportClParmVec[ 2 ] } },
  {"-exportclienthistogramroi2","IP/IR/ECH ROI Image 2",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL }, 
		( XPointer ) &ExportClParmVec[ 2 ] } },
  {"-exportclienthistogramroi3","IP/IR/ECH ROI Image 3",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL }, 
		( XPointer ) &ExportClParmVec[ 2 ] } },
  {"-exportclienthistogramroi4","IP/IR/ECH ROI Image 4",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 5 ], NULL, NULL, NULL }, 
		( XPointer ) &ExportClParmVec[ 2 ] } },
  {"-exportclienthistogramcplane1","IP/IP/ECH Control Plane Image 1",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &ExportClParmVec[ 3 ] } },
  {"-exportclienthistogramcplane2","IP/IR/ECH Control Plane Image 2",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL }, 
		( XPointer ) &ExportClParmVec[ 3 ] } },
  {"-exportclienthistogramcplane3","IP/IR/ECH Control Plane Image 3",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL }, 
		( XPointer ) &ExportClParmVec[ 3 ] } },
  {"-exportclienthistogramcplane4","IP/IR/ECH Control Plane Image 4",
		InitExportClientHistogram, DoExportClientHistogram, NullProc, 
		EndExportClientHistogram, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 5 ], NULL, NULL, NULL }, 
		( XPointer ) &ExportClParmVec[ 3 ] } },
  {"-importlut1","IL/EL src = dest",
		InitImportLUT, DoImportLUT, NullProc, 
		EndImportLUT, VALL, 0, 0,
		{1, 0, 2048, { NULL, NULL, NULL, NULL },
		( XPointer ) NULL } }, 
  {"-importphoto1","IP/EP 512x512x8 src = dest",
		InitImportPhoto, DoImportPhoto, NullProc, 
		EndImportPhoto, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) NULL } }, 
  {"-importphoto2","IP/ED 512x512x8",
		InitImportPhotoExportDrawable, DoImportPhoto, NullProc, 
		EndImportPhoto, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
	   	( XPointer ) NULL } }, 
  {"-importroi1","IR/ER 10 rectangles src = dest",
		InitImportROI, DoImportROI, NullProc, 
		EndImportROI, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { NULL, NULL, NULL, NULL },
		( XPointer ) &ImportParmVec[ 3 ] } }, 
  {"-importroi2","IR/ER 100 rectangles src = dest",
		InitImportROI, DoImportROI, NullProc, 
		EndImportROI, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { NULL, NULL, NULL, NULL },
		( XPointer ) &ImportParmVec[ 4 ] } }, 
  {"-importdrawable1","ID/ED 600x600x8 - Pixmap src, window dest",
		InitImportDrawablePixmap, DoImportDrawablePixmap, NullProc, 
		EndImportDrawablePixmap, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ImportParmVec[0] } }, 
  {"-importdrawable2","ID/ED 600x600x8 src = dest, Window",
		InitImportDrawableWindow, DoImportDrawableWindow, NullProc, 
		EndImportDrawableWindow, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ImportParmVec[0] } }, 
  {"-importdrawable3","ID/ED 600x600x8 - Window src, dest obscuring",
		InitImportDrawableWindow, DoImportDrawableWindow, NullProc, 
		EndImportDrawableWindow, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ImportParmVec[2] } }, 
  {"-importdrawable4","ID/ED 600x600x8 - Window src, dest obscured",
		InitImportDrawableWindow, DoImportDrawableWindow, NullProc, 
		EndImportDrawableWindow, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ImportParmVec[1] } }, 
  {"-importdrawable5","IDP/EDP 600x600x8 src = dest, Pixmap src",
		InitImportDrawablePlanePixmap, DoImportDrawablePlanePixmap, 
		NullProc, EndImportDrawablePixmap, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ImportParmVec[0] } }, 
  {"-importdrawable6","IDP/EDP 600x600x8 src = dest, Window src",
		InitImportDrawablePlaneWindow, DoImportDrawablePlaneWindow, 
		NullProc, EndImportDrawableWindow, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ImportParmVec[0] } }, 
  {"-importdrawable7","IDP/EDP 600x600x8 - Window src, dest obscuring",
		InitImportDrawablePlaneWindow, DoImportDrawablePlaneWindow, 
		NullProc, EndImportDrawableWindow, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ImportParmVec[2] } }, 
  {"-importdrawable8","IDP/EDP 600x600x8 - Window src, dest obscured",
		InitImportDrawablePlaneWindow, DoImportDrawablePlaneWindow, 
		NullProc, EndImportDrawableWindow, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ImportParmVec[1] } }, 
  {"-constrain1","Constrain HardClip IP/C/ED 512x512x8",
		InitConstrain, DoConstrain, NullProc,
		EndConstrain, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConstrainParmVec[0] } }, 
  {"-constrain2","Constrain ClipScale IP/C/ED 512x512x8",
		InitConstrain, DoConstrain, NullProc,
		EndConstrain, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConstrainParmVec[1] } }, 
  {"-constrainphoto1","Constrain HardClip IP/C/EP 512x512x8",
		InitConstrain, DoConstrain, NullProc,
		EndConstrain, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConstrainParmVec[3] } }, 
  {"-constrainphoto2","Constrain ClipScale IP/C/EP 512x512x8",
		InitConstrain, DoConstrain, NullProc,
		EndConstrain, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConstrainParmVec[4] } }, 
  {"-convolve1","Convolve IP/C/ED Boxcar 3x3 Default Technique",
		InitConvolve, DoConvolve, NullProc,
		EndConvolve, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConvolveParmVec[0] } }, 
  {"-convolve2","Convolve IP/C/ED Boxcar 5x5 Default Technique",
		InitConvolve, DoConvolve, NullProc,
		EndConvolve, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConvolveParmVec[1] } }, 
  {"-convolve3","Convolve IP/C/ED LaPlacian 3x3 Default Technique",
		InitConvolve, DoConvolve, NullProc,
		EndConvolve, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConvolveParmVec[2] } }, 
  {"-convolve4","Convolve IP/C/ED LaPlacian 5x5 Default Technique",
		InitConvolve, DoConvolve, NullProc,
		EndConvolve, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConvolveParmVec[3] } }, 
  {"-convolveroi1","Convolve IP/C/ED ROI LaPlacian 3x3 Default Technique",
		InitConvolve, DoConvolve, NullProc,
		EndConvolve, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConvolveParmVec[4] } }, 
  {"-convolveroi2","Convolve IP/C/ED ROI LaPlacian 5x5 Default Technique",
		InitConvolve, DoConvolve, NullProc,
		EndConvolve, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConvolveParmVec[5] } }, 
  {"-convolvectlplane1","Convolve IP/C/ED ControlPlane LaPlacian 3x3 Default Technique",
		InitConvolve, DoConvolve, NullProc,
		EndConvolve, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConvolveParmVec[6] } }, 
  {"-convolvectlplane2","Convolve IP/C/ED ControlPlane LaPlacian 5x5 Default Technique",
		InitConvolve, DoConvolve, NullProc,
		EndConvolve, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ConvolveParmVec[7] } }, 
  {"-math1","Math IP/U/M/M/C/ED HardClip sqrt, square",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[0] } }, 
  {"-math2","Math IP/U/M/M/C/ED HardClip square, sqrt",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[1] } }, 
  {"-math3","Math IP/U/M/M/C/ED HardClip exp, ln",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[2] } }, 
  {"-math4","Math IP/U/M/M/C/ED HardClip ln, exp",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[3] } }, 
  {"-math5","Math IP/U/M/C/ED ClipScale log2",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[4] } }, 
  {"-math6","Math IP/U/M/C/ED ClipScale log10",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[5] } }, 
  {"-math7","Math IP/M/M/ED No Clip sqrt, square",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[6] } }, 
  {"-mathroi1","Math ROI IP/IR/U/M/M/C/ED HardClip sqrt, square",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[7] } }, 
  {"-mathroi2","Math ROI IP/IR/U/M/M/C/ED HardClip square, sqrt",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[8] } }, 
  {"-mathroi3","Math ROI IP/IR/U/M/M/C/ED HardClip exp, ln",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[9] } }, 
  {"-mathroi4","Math ROI IP/IR/U/M/M/C/ED HardClip ln, exp",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[10] } }, 
  {"-mathroi5","Math ROI IP/IR/U/M/C/ED ClipScale log2",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[11] } }, 
  {"-mathroi6","Math ROI IP/IR/U/M/C/ED ClipScale log10",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[12] } }, 
  {"-mathroi7","Math ROI IP/IR/M/M/ED No Clip sqrt, square",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[13] } }, 
  {"-mathcplane1","Math Control Plane IP/IP/U/M/M/C/ED HardClip sqrt, square",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[14] } }, 
  {"-mathcplane2","Math Control Plane IP/IP/U/M/M/C/ED HardClip square, sqrt",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[15] } }, 
  {"-mathcplane3","Math Control Plane IP/IP/U/M/M/C/ED HardClip exp, ln",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[16] } }, 
  {"-mathcplane4","Math Control Plane IP/IP/U/M/M/C/ED HardClip ln, exp",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[17] } }, 
  {"-mathcplane5","Math Control Plane IP/IP/U/M/C/ED ClipScale log2",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[18] } }, 
  {"-mathcplane6","Math Control Plane IP/IP/U/M/C/ED ClipScale log10",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[19] } }, 
  {"-mathcplane7","Math Control Plane IP/IP/M/M/ED No Clip sqrt, square",
		InitMath, DoMath, NullProc,
		EndMath, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &MathParmVec[20] } }, 
  {"-arithmeticdyadic1","Arithmetic IP/A/ED Dyadic Add",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[0] } }, 
  {"-arithmeticdyadic2","Arithmetic IP/A/ED Dyadic Sub",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[1] } }, 
  {"-arithmeticdyadic3","Arithmetic IP/A/ED Dyadic SubRev",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[2] } }, 
  {"-arithmeticdyadic4","Arithmetic IP/A/ED Dyadic Min",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[6] } }, 
  {"-arithmeticdyadic5","Arithmetic IP/A/ED Dyadic Max",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[7] } }, 
  {"-arithmeticmonadic1","Arithmetic IP/A/ED Monadic Add 64",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[0] } }, 
  {"-arithmeticmonadic2","Arithmetic IP/A/ED Monadic Sub 64",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[1] } }, 
  {"-arithmeticmonadic3","Arithmetic IP/A/ED Monadic SubRev 250",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[2] } }, 
  {"-arithmeticmonadic4","Arithmetic IP/A/ED Monadic Mul 0.66",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[3] } }, 
  {"-arithmeticmonadic5","Arithmetic IP/A/ED Monadic Div 1.5",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[4] } }, 
  {"-arithmeticmonadic6","Arithmetic IP/A/ED Monadic DivRev 25500",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[5] } }, 
  {"-arithmeticmonadic7","Arithmetic IP/A/ED Monadic Min 128",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[6] } }, 
  {"-arithmeticmonadic8","Arithmetic IP/A/ED Monadic Max 128",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[7] } }, 
  {"-arithmeticmonadic9","Arithmetic IP/A/ED Monadic Gamma 1.1",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[8] } }, 
  {"-arithmeticdyadicroi1","Arithmetic IP/A/ED ROI Dyadic Add",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[9] } }, 
  {"-arithmeticdyadicroi2","Arithmetic IP/A/ED ROI Dyadic Sub",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[10] } }, 
  {"-arithmeticdyadicroi3","Arithmetic IP/A/ED ROI Dyadic SubRev",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[11] } }, 
  {"-arithmeticdyadicroi4","Arithmetic IP/A/ED ROI Dyadic Min",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[15] } }, 
  {"-arithmeticdyadicroi5","Arithmetic IP/A/ED ROI Dyadic Max",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[16] } }, 
  {"-arithmeticmonadicroi1","Arithmetic IP/A/ED ROI Monadic Add 64",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[9] } }, 
  {"-arithmeticmonadicroi2","Arithmetic IP/A/ED ROI Monadic Sub 64",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[10] } }, 
  {"-arithmeticmonadicroi3","Arithmetic IP/A/ED ROI Monadic SubRev 250",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[11] } }, 
  {"-arithmeticmonadicroi4","Arithmetic IP/A/ED ROI Monadic Mul 0.66",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[12] } }, 
  {"-arithmeticmonadicroi5","Arithmetic IP/A/ED ROI Monadic Div 1.5",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[13] } }, 
  {"-arithmeticmonadicroi6","Arithmetic IP/A/ED ROI Monadic DivRev 25500",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[14] } }, 
  {"-arithmeticmonadicroi7","Arithmetic IP/A/ED ROI Monadic Min 128",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[15] } }, 
  {"-arithmeticmonadicroi8","Arithmetic IP/A/ED ROI Monadic Max 128",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[16] } }, 
  {"-arithmeticmonadicroi9","Arithmetic IP/A/ED ROI Monadic Gamma 1.1",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[17] } }, 
  {"-arithmeticdyadiccplane1","Arithmetic IP/A/ED Control Plane Dyadic Add",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[37] } }, 
  {"-arithmeticdyadiccplane2","Arithmetic IP/A/ED Control Plane Dyadic Sub",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[38] } }, 
  {"-arithmeticdyadiccplane3","Arithmetic IP/A/ED Control Plane Dyadic SubRev",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[39] } }, 
  {"-arithmeticdyadiccplane4","Arithmetic IP/A/ED Control Plane Dyadic Min",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[43] } }, 
  {"-arithmeticdyadiccplane5","Arithmetic IP/A/ED Control Plane Dyadic Max",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[44] } }, 
  {"-arithmeticmonadiccplane1","Arithmetic IP/A/ED Control Plane Monadic Add 64",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[37] } }, 
  {"-arithmeticmonadiccplane2","Arithmetic IP/A/ED Control Plane Monadic Sub 64",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[38] } }, 
  {"-arithmeticmonadiccplane3","Arithmetic IP/A/ED Control Plane Monadic SubRev 250",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[39] } }, 
  {"-arithmeticmonadiccplane4","Arithmetic IP/A/ED Control Plane Monadic Mul 0.66",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[40] } }, 
  {"-arithmeticmonadiccplane5","Arithmetic IP/A/ED Control Plane Monadic Div 1.5",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[41] } }, 
  {"-arithmeticmonadiccplane6","Arithmetic IP/A/ED Control Plane Monadic DivRev 25500",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[42] } }, 
  {"-arithmeticmonadiccplane7","Arithmetic IP/A/ED Control Plane Monadic Min 128",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[43] } }, 
  {"-arithmeticmonadiccplane8","Arithmetic IP/A/ED Control Plane Monadic Max 128",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[44] } }, 
  {"-arithmeticmonadiccplane9","Arithmetic IP/A/ED Control Plane Monadic Gamma 1.1",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[45] } }, 
  {"-arithmeticfloatdyadic1","Arithmetic Unconstrained IP/U/A/C/ED Dyadic Add",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[18] } }, 
  {"-arithmeticfloatdyadic2","Arithmetic Unconstrained IP/U/A/C/ED Dyadic Sub",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[19] } }, 
  {"-arithmeticfloatdyadic3","Arithmetic Unconstrained IP/U/A/C/ED Dyadic SubRev",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[20] } }, 
  {"-arithmeticfloatdyadic4","Arithmetic Unconstrained IP/U/A/C/ED Dyadic Min",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[24] } }, 
  {"-arithmeticfloatdyadic5","Arithmetic Unconstrained IP/U/A/C/ED Dyadic Max",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[25] } }, 
  {"-arithmeticfloatmonadic1","Arithmetic Unconstrained IP/U/A/C/ED Monadic Add 64",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[18] } }, 
  {"-arithmeticfloatmonadic2","Arithmetic Unconstrained IP/U/A/C/ED Monadic Sub 64",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[19] } }, 
  {"-arithmeticfloatmonadic3","Arithmetic Unconstrained IP/U/A/C/ED Monadic SubRev 250",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[20] } }, 
  {"-arithmeticfloatmonadic4","Arithmetic Unconstrained IP/U/A/C/ED Monadic Mul 0.66",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[21] } }, 
  {"-arithmeticfloatmonadic5","Arithmetic Unconstrained IP/U/A/C/ED Monadic Div 1.5",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[22] } }, 
  {"-arithmeticfloatmonadic6","Arithmetic Unconstrained IP/U/A/C/ED Monadic DivRev 25500",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[23] } }, 
  {"-arithmeticfloatmonadic7","Arithmetic Unconstrained IP/U/A/C/ED Monadic Min 128",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[24] } }, 
  {"-arithmeticfloatmonadic8","Arithmetic Unconstrained IP/U/A/C/ED Monadic Max 128",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[25] } }, 
  {"-arithmeticfloatmonadic9","Arithmetic Unconstrained IP/U/A/C/ED Monadic Gamma 1.1",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[26] } }, 
  {"-arithmeticroifloatdyadic1","Arithmetic Unconstrained IP/U/A/C/ED ROI Dyadic Add",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[27] } }, 
  {"-arithmeticroifloatdyadic2","Arithmetic Unconstrained IP/U/A/C/ED ROI Dyadic Sub",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[28] } }, 
  {"-arithmeticroifloatdyadic3","Arithmetic Unconstrained IP/U/A/C/ED ROI Dyadic SubRev",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[29] } }, 
  {"-arithmeticroifloatdyadic4","Arithmetic Unconstrained IP/U/A/C/ED ROI Dyadic Min",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[33] } }, 
  {"-arithmeticroifloatdyadic5","Arithmetic Unconstrained IP/U/A/C/ED ROI Dyadic Max",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &ArithmeticParmVec[34] } }, 
  {"-arithmeticroifloatmonadic1","Arithmetic Unconstrained IP/U/A/C/ED ROI Monadic Add 64",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[27] } }, 
  {"-arithmeticroifloatmonadic2","Arithmetic Unconstrained IP/U/A/C/ED ROI Monadic Sub 64",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[28] } }, 
  {"-arithmeticroifloatmonadic3","Arithmetic Unconstrained IP/U/A/C/ED ROI Monadic SubRev 250",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[29] } }, 
  {"-arithmeticroifloatmonadic4","Arithmetic Unconstrained IP/U/A/C/ED ROI Monadic Mul 0.66",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[30] } }, 
  {"-arithmeticroifloatmonadic5","Arithmetic Unconstrained IP/U/A/C/ED ROI Monadic Div 1.5",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[31] } }, 
  {"-arithmeticroifloatmonadic6","Arithmetic Unconstrained IP/U/A/C/ED ROI Monadic DivRev 25500",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[32] } }, 
  {"-arithmeticroifloatmonadic7","Arithmetic Unconstrained IP/U/A/C/ED ROI Monadic Min 128",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[33] } }, 
  {"-arithmeticroifloatmonadic8","Arithmetic Unconstrained IP/U/A/C/ED ROI Monadic Max 128",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[34] } }, 
  {"-arithmeticroifloatmonadic9","Arithmetic Unconstrained IP/U/A/C/ED ROI Monadic Gamma 1.1",
		InitArithmetic, DoArithmetic, NullProc,
		EndArithmetic, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ArithmeticParmVec[35] } }, 
  {"-band1","BandSelect IP/BS/BS/BS/BC/BE/ED Color visual, or IP/BS/D/ED Gray visual 1",
		InitBandSelectExtract, DoBand, NullProc,
		EndBandSelectExtract, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL },
		( XPointer ) &BandParmVec[0] } }, 
  {"-band2","BandCombine IP/IP/IP/BC/BE/ED, BE coeffs = CCIR 601-1",
		InitBandCombine, DoBand, NullProc,
		EndBandCombine, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], &ImageInfo[ 5 ], NULL },
		( XPointer ) &BandParmVec[2] } }, 
  {"-band3","BandExtract IP/BE/ED, Gray ramp, BE coeffs = CCIR 601-1",
		InitBandColormap, DoBand, NullProc,
		EndBandColormap, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL },
		( XPointer ) &BandParmVec[3] } }, 
  {"-band4","BandExtract IP/BE/ED, RGB_BEST_MAP ( or RGB_GRAY_MAP )", 
		InitBandColormap, DoBand, NullProc,
		EndBandColormap, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL },
		( XPointer ) &BandParmVec[4] } }, 
  {"-band5","BandExtract IP/BE/ED, RGB_DEFAULT_MAP ( or RGB_GRAY_MAP )",
		InitBandColormap, DoBand, NullProc,
		EndBandColormap, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL },
		( XPointer ) &BandParmVec[5] } }, 
  {"-comparedyadic1","Compare IP/CMP/EDP Dyadic LT",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[0] } }, 
  {"-comparedyadic2","Compare IP/CMP/EDP Dyadic LE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[1] } }, 
  {"-comparedyadic3","Compare IP/CMP/EDP Dyadic EQ",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[2] } }, 
  {"-comparedyadic4","Compare IP/CMP/EDP Dyadic NE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[3] } }, 
  {"-comparedyadic5","Compare IP/CMP/EDP Dyadic GE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[4] } }, 
  {"-comparedyadic6","Compare IP/CMP/EDP Dyadic GT",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[5] } }, 
  {"-comparemonadic1","Compare IP/CMP/EDP Monadic LT 128",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[0] } }, 
  {"-comparemonadic2","Compare IP/CMP/EDP Monadic LE 128",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[1] } }, 
  {"-comparemonadic3","Compare IP/CMP/EDP Monadic EQ 128",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[2] } }, 
  {"-comparemonadic4","Compare IP/CMP/EDP Monadic NE 128",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[3] } }, 
  {"-comparemonadic5","Compare IP/CMP/EDP Monadic GE 128",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[4] } }, 
  {"-comparemonadic6","Compare IP/CMP/EDP Monadic GT 128",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[5] } }, 
  {"-compareroidyadic1","Compare ROI IP/CMP/EDP Dyadic LT",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[6] } }, 
  {"-compareroidyadic2","Compare ROI IP/CMP/EDP Dyadic LE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[7] } }, 
  {"-compareroidyadic3","Compare ROI IP/CMP/EDP Dyadic EQ",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[8] } }, 
  {"-compareroidyadic4","Compare ROI IP/CMP/EDP Dyadic NE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[9] } }, 
  {"-compareroidyadic5","Compare ROI IP/CMP/EDP Dyadic GE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[10] } }, 
  {"-compareroidyadic6","Compare ROI IP/CMP/EDP Dyadic GT",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[11] } }, 
  {"-compareroimonadic1","Compare ROI IP/CMP/EDP Monadic 128 LT",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[6] } }, 
  {"-compareroimonadic2","Compare ROI IP/CMP/EDP Monadic 128 LE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[7] } }, 
  {"-compareroimonadic3","Compare ROI IP/CMP/EDP Monadic 128 EQ",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[8] } }, 
  {"-compareroimonadic4","Compare ROI IP/CMP/EDP Monadic 128 NE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[9] } }, 
  {"-compareroimonadic5","Compare ROI IP/CMP/EDP Monadic 128 GE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[10] } }, 
  {"-compareroimonadic6","Compare ROI IP/CMP/EDP Monadic 128 GT",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[11] } }, 
  {"-comparecplanedyadic1","Compare Control Plane IP/CMP/EDP Dyadic LT",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[12] } }, 
  {"-comparecplanedyadic2","Compare Control Plane IP/CMP/EDP Dyadic LE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[13] } }, 
  {"-comparecplanedyadic3","Compare Control Plane IP/CMP/EDP Dyadic EQ",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[14] } }, 
  {"-comparecplanedyadic4","Compare Control Plane IP/CMP/EDP Dyadic NE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[15] } }, 
  {"-comparecplanedyadic5","Compare Control Plane IP/CMP/EDP Dyadic GE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[16] } }, 
  {"-comparecplanedyadic6","Compare Control Plane IP/CMP/EDP Dyadic GT",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL },
		( XPointer ) &CompareParmVec[17] } }, 
  {"-comparecplanemonadic1","Compare Control Plane IP/CMP/EDP Monadic 128 LT",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[12] } }, 
  {"-comparecplanemonadic2","Compare Control Plane IP/CMP/EDP Monadic 128 LE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[13] } }, 
  {"-comparecplanemonadic3","Compare Control Plane IP/CMP/EDP Monadic 128 EQ",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[14] } }, 
  {"-comparecplanemonadic4","Compare Control Plane IP/CMP/EDP Monadic 128 NE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[15] } }, 
  {"-comparecplanemonadic5","Compare Control Plane IP/CMP/EDP Monadic 128 GE",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[16] } }, 
  {"-comparecplanemonadic6","Compare Control Plane IP/CMP/EDP Monadic 128 GT",
		InitCompare, DoCompare, NullProc,
		EndCompare, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &CompareParmVec[17] } }, 
  {"-matchhistogram1","MatchHistogram IP/ED/MH/ED/ECH Flat Image 1",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[0] } }, 
  {"-matchhistogram2","MatchHistogram IP/ED/MH/ED/ECH Flat Image 2",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[0] } }, 
  {"-matchhistogram3","MatchHistogram IP/ED/MH/ED/ECH Flat Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL , NULL},
		( XPointer ) &MatchHistogramParmVec[0] } }, 
  {"-matchhistogram4","MatchHistogram IP/ED/MH/ED/ECH Gaussian mean 64 sigma 32 Image 1",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[1] } }, 
  {"-matchhistogram5","MatchHistogram IP/ED/MH/ED/ECH Gaussian mean 64 sigma 32 Image 2",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[1] } }, 
  {"-matchhistogram6","MatchHistogram IP/ED/MH/ED/ECH Gaussian mean 64 sigma 32 Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[1] } }, 
  {"-matchhistogram7","MatchHistogram IP/ED/MH/ED/ECH Gaussian mean 128 sigma 64 Image 1",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[2] } }, 
  {"-matchhistogram8","MatchHistogram IP/ED/MH/ED/ECH Gaussian mean 128 sigma 64 Image 2",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[2] } }, 
  {"-matchhistogram9","MatchHistogram IP/ED/MH/ED/ECH Gaussian mean 128 sigma 64 Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[2] } }, 
  {"-matchhistogram10","MatchHistogram IP/ED/MH/ED/ECH Gaussian mean 192 sigma 32 Image 1",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[3] } }, 
  {"-matchhistogram11","MatchHistogram IP/ED/MH/ED/ECH Gaussian mean 192 sigma 32 Image 2",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[3] } }, 
  {"-matchhistogram12","MatchHistogram IP/ED/MH/ED/ECH Gaussian mean 192 sigma 32 Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[3] } }, 
  {"-matchhistogram13","MatchHistogram IP/ED/MH/ED/ECH Hyperbolic const 64 True Image 1",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[4] } }, 
  {"-matchhistogram14","MatchHistogram IP/ED/MH/ED/ECH Hyperbolic const 64 True Image 2",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[4] } }, 
  {"-matchhistogram15","MatchHistogram IP/ED/MH/ED/ECH Hyperbolic const 64 True Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL},
		( XPointer ) &MatchHistogramParmVec[4] } }, 
  {"-matchhistogram16","MatchHistogram IP/ED/MH/ED/ECH Hyperbolic const 64 False Image 1",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[5] } }, 
  {"-matchhistogram17","MatchHistogram IP/ED/MH/ED/ECH Hyperbolic const 64 False Image 2",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[5] } }, 
  {"-matchhistogram18","MatchHistogram IP/ED/MH/ED/ECH Hyperbolic const 64 False Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[5] } }, 
  {"-matchhistogramroi1","MatchHistogram ROI IP/ED/MH/ED/ECH Flat Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[6] } }, 
  {"-matchhistogramroi2","MatchHistogram ROI IP/ED/MH/ED/ECH Gaussian mean 64 sigma 32 Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[7] } }, 
  {"-matchhistogramroi3","MatchHistogram ROI IP/ED/MH/ED/ECH Gaussian mean 128 sigma 64 Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[8] } }, 
  {"-matchhistogramroi4","MatchHistogram ROI IP/ED/MH/ED/ECH Gaussian mean 192 sigma 32 Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[9] } }, 
  {"-matchhistogramroi5","MatchHistogram ROI IP/ED/MH/ED/ECH Hyperbolic const 64 True Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[10] } }, 
  {"-matchhistogramroi6","MatchHistogram ROI IP/ED/MH/ED/ECH Hyperbolic const 64 True Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[11] } }, 
  {"-matchhistogramcplane1","MatchHistogram Control Plane IP/ED/MH/ED/ECH Flat Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[12] } }, 
  {"-matchhistogramcplane2","MatchHistogram Control Plane IP/ED/MH/ED/ECH Gaussian mean 64 sigma 32 Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[13] } }, 
  {"-matchhistogramcplane3","MatchHistogram Control Plane IP/ED/MH/ED/ECH Gaussian mean 128 sigma 64 Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[14] } }, 
  {"-matchhistogramcplane4","MatchHistogram Control Plane IP/ED/MH/ED/ECH Gaussian mean 192 sigma 32 Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[15] } }, 
  {"-matchhistogramcplane5","MatchHistogram Control Plane IP/ED/MH/ED/ECH Hyperbolic const 64 True Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[16] } }, 
  {"-matchhistogramcplane6","MatchHistogram Control Plane IP/ED/MH/ED/ECH Hyperbolic const 64 True Image 3",
		InitMatchHistogram, DoMatchHistogram, NullProc,
		EndMatchHistogram, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 2 ], NULL, NULL, NULL },
		( XPointer ) &MatchHistogramParmVec[17] } }, 
  {"-unconstrain1","Unconstrain/Constrain ClipScale IP/UC/C/ED 512x512x8",
		InitUnconstrain, DoUnconstrain, NullProc,
		EndUnconstrain, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL},
		( XPointer ) &UnconstrainParmVec[0] } }, 
  {"-pasteup1","PasteUp IP/P/ED 512x512x8",
                InitPasteUp, DoPasteUp, NullProc,
                EndPasteUp, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 1 ], NULL, NULL, NULL },
		( XPointer ) &PasteUpParmVec[0] } }, 
  {"-pasteup2","PasteUp Overlapping tiles with constant fill IP/P/ED 512x512x8",
                InitPasteUp, DoPasteUp, NullProc,
                EndPasteUp, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, { &ImageInfo[ 1 ], NULL, NULL, NULL },
		( XPointer ) &PasteUpParmVec[1] } }, 
  {"-geometry1","Geometry Rotate 12 degrees NearestNeighbor IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[0] } }, 
  {"-geometry2","Geometry Rotate 147 degrees NearestNeighbor IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[1] } }, 
  {"-geometry3","Geometry Rotate 193 degrees Nearest Neighbor IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[2] } }, 
  {"-geometry4","Geometry Rotate 311 degrees Nearest Neighbor IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[3] } }, 
  {"-geometry5","Geometry Mirror X Nearest Neighbor IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[4] } }, 
  {"-geometry6","Geometry Mirror Y Nearest Neighbor IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[5] } }, 
  {"-geometry7","Geometry Mirror XY NearestNeighbor IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[6] } }, 
  {"-geometry8","Crop x=256, y=256, w=256, h=256 NearestNeighbor IP/G/ED",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[7] } }, 
  {"-geometry9","Scale NearestNeighbor 128x128 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[8] } }, 
  {"-geometry10","Scale NearestNeighbor 256x256 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[9] } }, 
  {"-geometry11","Scale NearestNeighbor 256x512 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[10] } }, 
  {"-geometry12","Scale NearestNeighbor 512x128 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[11] } }, 
  {"-geometry13","Scale NearestNeighbor 256x768 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[12] } }, 
  {"-geometry14","Scale NearestNeighbor 768x128 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1,  0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[13] } }, 
  {"-geometry15","Geometry Rotate 12 degrees Antialias IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[14] } }, 
  {"-geometry16","Geometry Rotate 147 degrees Antialias IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[15] } }, 
  {"-geometry17","Geometry Rotate 193 degrees Antialias IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[16] } }, 
  {"-geometry18","Geometry Rotate 311 degrees Antialias IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[17] } }, 
  {"-geometry19","Geometry Mirror X Antialias IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[18] } }, 
  {"-geometry20","Geometry Mirror Y Antialias IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[19] } }, 
  {"-geometry21","Geometry Mirror XY Antialias IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[20] } }, 
  {"-geometry22","Crop x=256, y=256, w=256, h=256 Antialias IP/G/ED",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[21] } }, 
  {"-geometry23","Scale Antialias 128x128 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[22] } }, 
  {"-geometry24","Scale Antialias 256x256 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[23] } }, 
  {"-geometry25","Scale Antialias 256x512 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[24] } }, 
  {"-geometry26","Scale Antialias 512x128 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[25] } }, 
  {"-geometry27","Scale Antialias 256x768 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[26] } }, 
  {"-geometry28","Scale Antialias 768x128 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[27] } }, 
  {"-geometry29","Geometry Rotate 12 degrees Bilinear Interp IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[40] } }, 
  {"-geometry30","Geometry Rotate 147 degrees Bilinear Interp IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[41] } }, 
  {"-geometry31","Geometry Rotate 193 degrees Bilinear Interp IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[42] } }, 
  {"-geometry32","Geometry Rotate 311 degrees Bilinear Interp IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[43] } }, 
  {"-geometry33","Geometry Mirror X Bilinear Interp IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[44] } }, 
  {"-geometry34","Geometry Mirror Y Bilinear Interp IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[45] } }, 
  {"-geometry35","Geometry Mirror XY Bilinear Interp IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[46] } }, 
  {"-geometry36","Crop x=256, y=256, w=256, h=256 Bilinear Interp IP/G/ED",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[47] } }, 
  {"-geometry37","Scale Bilinear Interp 128x128 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[48] } }, 
  {"-geometry38","Scale Bilinear Interp 256x256 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[49] } }, 
  {"-geometry39","Scale Bilinear Interp 256x512 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[50] } }, 
  {"-geometry40","Scale Bilinear Interp 512x128 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[51] } }, 
  {"-geometry41","Scale Bilinear Interp 256x768 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[52] } }, 
  {"-geometry42","Scale Bilinear Interp 768x128 IP/G/ED 512x512x8",
                InitGeometry, DoGeometry, NullProc,
                EndGeometry, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 12 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[53] } }, 
  {"-geomg31dscale1","Geometry Scaled G31D FAX NearestNeighbor IP/G/ED 1728x1102",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 7 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[28] } }, 
  {"-geomg31dscale2","Geometry Scaled G31D FAX AntiAlias IP/G/ED 1728x1102",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 7 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[29] } }, 
  {"-geomtiffpbscale1","Geometry Scaled TIFFPackBits FAX NearestNeighbor IP/G/ED 1728x2132",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 8 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[28] } }, 
  {"-geomtiffpbscale2","Geometry Scaled TIFFPackBits FAX AntiAlias IP/G/ED 1728x2132",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 8 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[29] } }, 
  {"-geomtiff2scale1","Geometry Scaled TIFF2 FAX NearestNeighbor IP/G/ED 1728x2132",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 9 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[28] } }, 
  {"-geomtiff2scale2","Geometry Scaled TIFF2 FAX AntiAlias IP/G/ED 1728x2132",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 9 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[29] } }, 
  {"-geomg32dscale1","Geometry Scaled G32D FAX NearestNeighbor IP/G/ED 1728x2100",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1,  0, 2048, 
		{ &ImageInfo[ 6 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[28] } }, 
  {"-geomg32dscale2","Geometry Scaled G32D FAX AntiAlias IP/G/ED 1728x2100",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1,  0, 2048, 
		{ &ImageInfo[ 6 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[29] } }, 
  {"-geomg4scale1","Geometry Scaled G42D FAX NearestNeighbor IP/G/ED 2560x3300",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1,  0, 2048, 
		{ &ImageInfo[ 4 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[30] } }, 
  {"-geomg4scale2","Geometry Scaled G42D FAX AntiAlias IP/G/ED 2560x3300",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 4 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[31] } }, 
  {"-geometryfax1","Geometry Scaled Rotate 12 degrees G42D FAX NearestNeighbor IP/G/ED 2560x3300",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 4 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[32] } }, 
  {"-geometryfax2","Geometry Scaled Rotate 12 degrees G42D FAX Antialias IP/G/ED 2560x3300",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1,  0, 2048, 
		{ &ImageInfo[ 4 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[36] } }, 
  {"-geometryfaxradio1","Geometry Scaled G42D Antialias IP/G/ED 2560x3300 radio True",
                InitGeometryFAX, DoGeometryFAX, NullProc,
                EndGeometryFAX, VALL, 0, 0,
		{1,  0, 2048, 
		{ &ImageInfo[ 4 ], NULL, NULL, NULL },
		( XPointer ) &GeometryParmVec[54] } }, 
  {"-dither1","Dither diffusion IP/D/ED 512x512x8",
		InitDither, DoDither, NullProc,
		EndDither, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &DitherParmVec[ 0 ] } },
  {"-dither2","Dither diffusion IP/D/EDP 512x512x8",
		InitDither, DoDither, NullProc,
		EndDither, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &DitherParmVec[ 1 ] } },
  {"-dither3","Dither Ordered(4) IP/D/ED 512x512x8",
		InitDither, DoDither, NullProc,
		EndDither, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &DitherParmVec[ 2 ] } },
  {"-dither4","Dither Ordered(4) IP/D/EDP 512x512x8",
		InitDither, DoDither, NullProc,
		EndDither, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &DitherParmVec[ 3 ] } },
  {"-dither5","Dither Ordered(8) IP/D/ED 512x512x8",
		InitDither, DoDither, NullProc,
		EndDither, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &DitherParmVec[ 4 ] } },
  {"-dither6","Dither Ordered(8) IP/D/EDP 512x512x8",
		InitDither, DoDither, NullProc,
		EndDither, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &DitherParmVec[ 5 ] } },
  {"-dither7","Dither default IP/D/ED 512x512x8",
		InitDither, DoDither, NullProc,
		EndDither, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &DitherParmVec[ 6 ] } },
  {"-dither8","Dither default IP/D/EDP 512x512x8",
		InitDither, DoDither, 
		NullProc, EndDither, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &DitherParmVec[ 7 ] } },
  {"-logicalmonadic1","Logical IP/L/ED Monadic Clear ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		 ( XPointer ) &LogicalParmVec[ 0 ] } },
  {"-logicalmonadic2","Logical IP/L/ED Monadic And ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 1 ] } },
  {"-logicalmonadic3","Logical IP/L/ED Monadic AndReverse ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 2 ] } },
  {"-logicalmonadic4","Logical IP/L/ED Monadic Copy ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 3 ] } },
  {"-logicalmonadic5","Logical IP/L/ED Monadic AndInverted ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 4 ] } },
  {"-logicalmonadic6","Logical IP/L/ED Monadic NoOp ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 5 ] } },
  {"-logicalmonadic7","Logical IP/L/ED Monadic Xor ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 6 ] } },
  {"-logicalmonadic8","Logical IP/L/ED Monadic Or ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 7 ] } },
  {"-logicalmonadic9","Logical IP/L/ED Monadic Nor ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 8 ] } },
  {"-logicalmonadic10","Logical IP/L/ED Monadic Equiv ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		 ( XPointer ) &LogicalParmVec[ 9 ] } },
  {"-logicalmonadic11","Logical IP/L/ED Monadic Invert ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		 ( XPointer ) &LogicalParmVec[ 10 ] } },
  {"-logicalmonadic12","Logical IP/L/ED Monadic OrReverse ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		 ( XPointer ) &LogicalParmVec[ 11 ] } },
  {"-logicalmonadic13","Logical IP/L/ED Monadic CopyInverted ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		 ( XPointer ) &LogicalParmVec[ 12 ] } },
  {"-logicalmonadic14","Logical IP/L/ED Monadic OrInverted ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		 ( XPointer ) &LogicalParmVec[ 13 ] } },
  {"-logicalmonadic15","Logical IP/L/ED Monadic Nand ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		 ( XPointer ) &LogicalParmVec[ 14 ] } },
  {"-logicalmonadic16","Logical IP/L/ED Monadic Set ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		 ( XPointer ) &LogicalParmVec[ 15 ] } },
  {"-logicaldyadic1","Logical IP/L/ED Dyadic Clear ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 0 ] } },
  {"-logicaldyadic2","Logical IP/L/ED Dyadic And ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 1 ] } },
  {"-logicaldyadic3","Logical IP/L/ED Dyadic AndReverse ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 2 ] } },
  {"-logicaldyadic4","Logical IP/L/ED Dyadic Copy ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 3 ] } },
  {"-logicaldyadic5","Logical IP/L/ED Dyadic AndInverted ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 4 ] } },
  {"-logicaldyadic6","Logical IP/L/ED Dyadic NoOp ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 5 ] } },
  {"-logicaldyadic7","Logical IP/L/ED Dyadic Xor ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 6 ] } },
  {"-logicaldyadic8","Logical IP/L/ED Dyadic Or ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 7 ] } },
  {"-logicaldyadic9","Logical IP/L/ED Dyadic Nor ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 8 ] } },
  {"-logicaldyadic10","Logical IP/L/ED Dyadic Equiv ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 9 ] } },
  {"-logicaldyadic11","Logical IP/L/ED Dyadic Invert ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 10 ] } },
  {"-logicaldyadic12","Logical IP/L/ED Dyadic OrReverse ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 11 ] } },
  {"-logicaldyadic13","Logical IP/L/ED Dyadic CopyInverted ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 12 ] } },
  {"-logicaldyadic14","Logical IP/L/ED Dyadic OrInverted ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 13 ] } },
  {"-logicaldyadic15","Logical IP/L/ED Dyadic Nand ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 14 ] } },
  {"-logicaldyadic16","Logical IP/L/ED Dyadic Set ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 15 ] } },
  {"-logicalmonadicroi1","ROI Logical IP/IR/L/ED Monadic Clear ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 16 ] } },
  {"-logicalmonadicroi2","ROI Logical IP/IR/L/ED Monadic And ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 17 ] } },
  {"-logicalmonadicroi3","ROI Logical IP/IR/L/ED Monadic AndReverse ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 18 ] } },
  {"-logicalmonadicroi4","ROI Logical IP/IR/L/ED Monadic Copy ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 19 ] } },
  {"-logicalmonadicroi5","ROI Logical IP/IR/L/ED Monadic AndInverted ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 20 ] } },
  {"-logicalmonadicroi6","ROI Logical IP/IR/L/ED Monadic NoOp ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 21 ] } },
  {"-logicalmonadicroi7","ROI Logical IP/IR/L/ED Monadic Xor ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 22 ] } },
  {"-logicalmonadicroi8","ROI Logical IP/IR/L/ED Monadic Or ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 23 ] } },
  {"-logicalmonadicroi9","ROI Logical IP/IR/L/ED Monadic Nor ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 24 ] } },
  {"-logicalmonadicroi10","ROI Logical IP/IR/L/ED Monadic Equiv ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 25 ] } },
  {"-logicalmonadicroi11","ROI Logical IP/IR/L/ED Monadic Invert ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 26 ] } },
  {"-logicalmonadicroi12","ROI Logical IP/IR/L/ED Monadic OrReverse ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 27 ] } },
  {"-logicalmonadicroi13","ROI Logical IP/IR/L/ED Monadic CopyInverted ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 28 ] } },
  {"-logicalmonadicroi14","ROI Logical IP/IR/L/ED Monadic OrInverted ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 29 ] } },
  {"-logicalmonadicroi15","ROI Logical IP/IR/L/ED Monadic Nand ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 30 ] } },
  {"-logicalmonadicroi16","ROI Logical IP/IR/L/ED Monadic Set ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 31 ] } },
  {"-logicaldyadicroi1","ROI Logical IP/IR/L/ED Dyadic Clear ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 16 ] } },
  {"-logicaldyadicroi2","ROI Logical IP/IR/L/ED Dyadic And ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 17 ] } },
  {"-logicaldyadicroi3","ROI Logical IP/IR/L/ED Dyadic AndReverse ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 18 ] } },
  {"-logicaldyadicroi4","ROI Logical IP/IR/L/ED Dyadic Copy ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 19 ] } },
  {"-logicaldyadicroi5","ROI Logical IP/IR/L/ED Dyadic AndInverted ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 20 ] } },
  {"-logicaldyadicroi6","ROI Logical IP/IR/L/ED Dyadic NoOp ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 21 ] } },
  {"-logicaldyadicroi7","ROI Logical IP/IR/L/ED Dyadic Xor ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 22 ] } },
  {"-logicaldyadicroi8","ROI Logical IP/IR/L/ED Dyadic Or ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 23 ] } },
  {"-logicaldyadicroi9","ROI Logical IP/IR/L/ED Dyadic Nor ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 24 ] } },
  {"-logicaldyadicroi10","ROI Logical IP/IR/L/ED Dyadic Equiv ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 25 ] } },
  {"-logicaldyadicroi11","ROI Logical IP/IR/L/ED Dyadic Invert ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 26 ] } },
  {"-logicaldyadicroi12","ROI Logical IP/IR/L/ED Dyadic OrReverse ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 27 ] } },
  {"-logicaldyadicroi13","ROI Logical IP/IR/L/ED Dyadic CopyInverted ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 28 ] } },
  {"-logicaldyadicroi14","ROI Logical IP/IR/L/ED Dyadic OrInverted ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 29 ] } },
  {"-logicaldyadicroi15","ROI Logical IP/IR/L/ED Dyadic Nand ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 30 ] } },
  {"-logicaldyadicroi16","ROI Logical IP/IR/L/ED Dyadic Set ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 31 ] } },
  {"-logicalmonadiccplane1","Control Plane Logical IP/IR/L/ED Monadic Clear ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 32 ] } },
  {"-logicalmonadiccplane2","Control Plane Logical IP/IR/L/ED Monadic And ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 33 ] } },
  {"-logicalmonadiccplane3","Control Plane Logical IP/IR/L/ED Monadic AndReverse ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 34 ] } },
  {"-logicalmonadiccplane4","Control Plane Logical IP/IR/L/ED Monadic Copy ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 35 ] } },
  {"-logicalmonadiccplane5","Control Plane Logical IP/IR/L/ED Monadic AndInverted ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 36 ] } },
  {"-logicalmonadiccplane6","Control Plane Logical IP/IR/L/ED Monadic NoOp ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 37 ] } },
  {"-logicalmonadiccplane7","Control Plane Logical IP/IR/L/ED Monadic Xor ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 38 ] } },
  {"-logicalmonadiccplane8","Control Plane Logical IP/IR/L/ED Monadic Or ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 39 ] } },
  {"-logicalmonadiccplane9","Control Plane Logical IP/IR/L/ED Monadic Nor ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 40 ] } },
  {"-logicalmonadiccplane10","Control Plane Logical IP/IR/L/ED Monadic Equiv ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 41 ] } },
  {"-logicalmonadiccplane11","Control Plane Logical IP/IR/L/ED Monadic Invert ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 42 ] } },
  {"-logicalmonadiccplane12","Control Plane Logical IP/IR/L/ED Monadic OrReverse ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 43 ] } },
  {"-logicalmonadiccplane13","Control Plane Logical IP/IR/L/ED Monadic CopyInverted ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 44 ] } },
  {"-logicalmonadiccplane14","Control Plane Logical IP/IR/L/ED Monadic OrInverted ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 45 ] } },
  {"-logicalmonadiccplane15","Control Plane Logical IP/IR/L/ED Monadic Nand ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 46 ] } },
  {"-logicalmonadiccplane16","Control Plane Logical IP/IR/L/ED Monadic Set ( 0 constant ) ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 47 ] } },
  {"-logicaldyadiccplane1","Control Plane Logical IP/IR/L/ED Dyadic Clear ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 32 ] } },
  {"-logicaldyadiccplane2","Control Plane Logical IP/IR/L/ED Dyadic And ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 33 ] } },
  {"-logicaldyadiccplane3","Control Plane Logical IP/IR/L/ED Dyadic AndReverse ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 34 ] } },
  {"-logicaldyadiccplane4","Control Plane Logical IP/IR/L/ED Dyadic Copy ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 35 ] } },
  {"-logicaldyadiccplane5","Control Plane Logical IP/IR/L/ED Dyadic AndInverted ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 36 ] } },
  {"-logicaldyadiccplane6","Control Plane Logical IP/IR/L/ED Dyadic NoOp ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 37 ] } },
  {"-logicaldyadiccplane7","Control Plane Logical IP/IR/L/ED Dyadic Xor ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 38 ] } },
  {"-logicaldyadiccplane8","Control Plane Logical IP/IR/L/ED Dyadic Or ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 39 ] } },
  {"-logicaldyadiccplane9","Control Plane Logical IP/IR/L/ED Dyadic Nor ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 40 ] } },
  {"-logicaldyadiccplane10","Control Plane Logical IP/IR/L/ED Dyadic Equiv ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 41 ] } },
  {"-logicaldyadiccplane11","Control Plane Logical IP/IR/L/ED Dyadic Invert ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 42 ] } },
  {"-logicaldyadiccplane12","Control Plane Logical IP/IR/L/ED Dyadic OrReverse ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 43 ] } },
  {"-logicaldyadiccplane13","Control Plane Logical IP/IR/L/ED Dyadic CopyInverted ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 44 ] } },
  {"-logicaldyadiccplane14","Control Plane Logical IP/IR/L/ED Dyadic OrInverted ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 45 ] } },
  {"-logicaldyadiccplane15","Control Plane Logical IP/IR/L/ED Dyadic Nand ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 46 ] } },
  {"-logicaldyadiccplane16","Control Plane Logical IP/IR/L/ED Dyadic Set ",
		InitLogical, DoLogical, NullProc,
		EndLogical, VALL, 0, 0,
		{1, SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[1], NULL, NULL }, 
		( XPointer ) &LogicalParmVec[ 47 ] } },
  {"-blend1","Blend monadic src constant 0.1 alpha constant 0.5 IP/B/ED 512x512",
		InitBlend, DoBlend, NullProc,
		EndBlend, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &BlendParmVec[ 0 ] } },
  {"-blend2","Blend dyadic alpha constant 0.5 IP/IP/B/ED 512x512",
		InitBlend, DoBlend, NullProc,
		EndBlend, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL }, 
		( XPointer ) &BlendParmVec[ 0 ] } },
  {"-blendroi1","Blend monadic ROI src constant 0.1 alpha constant 0.5 IP/B/ED 512x512",
		InitBlend, DoBlend, NullProc,
		EndBlend, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &BlendParmVec[ 3 ] } },
  {"-blendroi2","Blend dyadic ROI alpha constant 0.5 IP/IP/B/ED 512x512",
		InitBlend, DoBlend, NullProc,
		EndBlend, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL }, 
		( XPointer ) &BlendParmVec[ 3 ] } },
  {"-blendcplane1","Blend monadic Control Plane src constant 0.1 alpha constant 0.5 IP/B/ED 512x512",
		InitBlend, DoBlend, NullProc,
		EndBlend, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, 
		( XPointer ) &BlendParmVec[ 6 ] } },
  {"-blendcplane2","Blend dyadic Control Plane alpha constant 0.5 IP/IP/B/ED 512x512",
		InitBlend, DoBlend, NullProc,
		EndBlend, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL, NULL }, 
		( XPointer ) &BlendParmVec[ 6 ] } },
  {"-blendalpha1","Blend monadic src constant 220 alpha plane brains IP/IP/B/ED 512x512",
		InitBlend, DoBlend, NullProc,
		EndBlend, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, &ImageInfo[ 5 ], NULL }, 
		( XPointer ) &BlendParmVec[ 1 ] } },
  {"-blendalpha2","Blend dyadic alpha plane alpha constant 250 IP/IP/IP/B/ED 512x512",
		InitBlend, DoBlend, NullProc,
		EndBlend, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 5 ], &ImageInfo[ 1 ], &ImageInfo[ 0 ], NULL }, 
		( XPointer ) &BlendParmVec[ 2 ] } },
  {"-blendalpharoi1","Blend monadic ROI src constant 220 alpha plane brains IP/B/ED 512x512",
		InitBlend, DoBlend, NullProc,
		EndBlend, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 2 ], NULL, &ImageInfo[ 5 ], NULL }, 
		( XPointer ) &BlendParmVec[ 4 ] } },
  {"-blendalpharoi2","Blend dyadic ROI alpha plane alpha constant 250 bird IP/IP/IP/B/ED 512x512",
		InitBlend, DoBlend, NullProc,
		EndBlend, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 2 ], &ImageInfo[ 0 ], &ImageInfo[ 1 ], NULL }, 
		( XPointer ) &BlendParmVec[ 5 ] } },
  {"-triplepoint1","TripleBand Point IP/IL/P/ED 512x512 RGB_BEST_MAP, DitherDefault",
		InitTriplePoint, DoTriplePoint, NullProc,
		EndTriplePoint, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL },
		( XPointer ) &TriplePointParmVec[ 0 ] } }, 
  {"-triplepoint2","TripleBand Point IP/IL/P/ED 512x512 RGB_DEFAULT_MAP, DitherDefault",
		InitTriplePoint, DoTriplePoint, NullProc,
		EndTriplePoint, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL },
		( XPointer ) &TriplePointParmVec[ 1 ] } }, 
  {"-funnyencode1","Funny Encode, SingleBand, 3 Encode steps",
		InitFunnyEncode, DoFunnyEncode, NullProc,
		EndFunnyEncode, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &FunnyEncodeParmVec[ 0 ] } }, 
  {"-funnyencode2","Funny Encode, SingleBand, 3 Encode steps, 3 bits",
		InitFunnyEncode, DoFunnyEncode, NullProc,
		EndFunnyEncode, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &FunnyEncodeParmVec[ 4 ] } }, 
  {"-funnyencode3","Funny Encode Pixel, TripleBand, 3 Encode steps",
		InitFunnyEncode, DoFunnyEncode, NullProc,
		EndFunnyEncode, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL },
		( XPointer ) &FunnyEncodeParmVec[ 1 ] } }, 
  {"-funnyencode4","Funny Encode Pixel, TripleBand, 3 Encode, 5, 10, 7 bits",
		InitFunnyEncode, DoFunnyEncode, NullProc,
		EndFunnyEncode, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL },
		( XPointer ) &FunnyEncodeParmVec[ 2 ] } }, 
  {"-funnyencode5","Funny Encode Pixel, TripleBand, 3 Encode, 7, 13, 11 bits",
		InitFunnyEncode, DoFunnyEncode, NullProc,
		EndFunnyEncode, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL },
		( XPointer ) &FunnyEncodeParmVec[ 3 ] } }, 
  {"-funnyencode6","Funny Encode Plane, TripleBand, 3 Encode steps",
		InitFunnyEncode, DoFunnyEncode, NullProc,
		EndFunnyEncode, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 11 ], NULL, NULL, NULL },
		( XPointer ) &FunnyEncodeParmVec[ 1 ] } }, 
  {"-funnyencode7","Funny Encode Plane, TripleBand, 3 Encode, 5, 10, 7 bits",
		InitFunnyEncode, DoFunnyEncode, NullProc,
		EndFunnyEncode, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 11 ], NULL, NULL, NULL },
		( XPointer ) &FunnyEncodeParmVec[ 2 ] } }, 
  {"-funnyencode8","Funny Encode Plane, TripleBand, 3 Encode, 7, 13, 11 bits",
		InitFunnyEncode, DoFunnyEncode, NullProc,
		EndFunnyEncode, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 11 ], NULL, NULL, NULL },
		( XPointer ) &FunnyEncodeParmVec[ 3 ] } }, 
  {"-point1","Point IP/IL/P/ED 512x512 8 to 8",
		InitPoint, DoPoint, NullProc,
		EndPoint, VALL, 0, 0,
		{1,  0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &PointParmVec[ 0 ] } }, 
  {"-point2","Point IP/IL/P/ED 512x512 1 to 8",
		InitPoint, DoPoint, NullProc,
		EndPoint, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &PointParmVec[ 1 ] } }, 
  {"-point3","Point IP/IL/P/ED 512x512 8 to 1",
		InitPoint, DoPoint, NullProc,
		EndPoint, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &PointParmVec[ 2 ] } }, 
  {"-pointroi1","Point IP/IL/P/ED ROI 512x512 8 to 8",
		InitPoint, DoPoint, NullProc,
		EndPoint, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &PointParmVec[ 3 ] } }, 
  {"-pointcplane1","Point IP/IL/P/ED Control Plane 512x512 8 to 8",
		InitPoint, DoPoint, NullProc,
		EndPoint, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &PointParmVec[ 8 ] } }, 
  {"-pointphoto1","Point IP/IL/P/EP 512x512 8 to 8",
		InitPoint, DoPoint, NullProc,
		EndPoint, VALL, 0, 0,
		{1,  0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &PointParmVec[ 4 ] } }, 
  {"-pointroiphoto1","Point IP/IL/P/EP ROI 512x512 8 to 8",
		InitPoint, DoPoint, NullProc,
		EndPoint, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &PointParmVec[ 7 ] } }, 
  {"-pointcplanephoto1","Point IP/IL/P/EP Control Plane 512x512 8 to 8",
		InitPoint, DoPoint, NullProc,
		EndPoint, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &PointParmVec[ 9 ] } }, 
  {"-redefine","RedefinePhotoflo",
		InitRedefine, DoRedefine, NullProc,
		EndRedefine, VALL, 0, 0,
		{1, 0, 2048, { &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &RedefineParmVec[ 0 ] } }, 
  {"-modify1","ModifyPhotoflo change ROI offsets and size",
		InitModifyROI, DoModifyROI, NullProc,
		EndModifyROI, VALL, 0, 0,
		{1, SUBSET_FULL | 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL },
		( XPointer ) &ModifyParmVec[ 0 ] } }, 
  {"-modify2","ModifyPhotoflo change point element LUT",
		InitModifyPoint, DoModifyPoint, NullProc,
		EndModifyPoint, VALL, 0, 0,
		{1, 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-modify3","ModifyPhotoflo change export drawable x,y location",
		InitModifySimple, DoModifySimple, NullProc,
		EndModifySimple, VALL, 0, 0,
		{1,  0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-modify4","ModifyPhotoflo long flo, low data, random drawable x,y location",
		InitModifyLong1, DoModifyLong1, NullProc,
		EndModifyLong, VALL, 0, 0,
		{1, SUBSET_FULL | 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-modify5","ModifyPhotoflo long flo, low data, geo crop, random drawable x,y location",
		InitModifyLong2, DoModifyLong2, NullProc,
		EndModifyLong, VALL, 0, 0,
		{1, SUBSET_FULL | 0, 2048, 
		{ &ImageInfo[ 0 ], NULL, NULL, NULL }, ( XPointer ) NULL } }, 
  {"-rgb1","IP/U/CFRGB/CTRGB/HC/ED CIELab, Floats",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 0 ] } }, 
  {"-rgb2","IP/U/CFRGB/CTRGB/HC/ED CIELab, Floats, WhiteAdjust",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 1 ] } }, 
  {"-rgb3","IP/CFRGB/CTRGB/CS/ED CIELab, Ints->Floats",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 2 ] } }, 
  {"-rgb4","IP/CFRGB/CTRGB/CS/ED CIELab, Ints->Floats, WhiteAdjust",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 3 ] } }, 
  {"-rgb5","IP/U/CFRGB/CTRGB/HC/ED CIEXYZ, Floats",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 4 ] } }, 
  {"-rgb6","IP/U/CFRGB/CTRGB/HC/ED CIEXYZ, Floats, WhiteAdjust",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 5 ] } }, 
  {"-rgb7","IP/CFRGB/CTRGB/CS/ED CIEXYZ, Ints->Floats",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 6 ] } }, 
  {"-rgb8","IP/CFRGB/CTRGB/CS/ED CIEXYZ, Ints->Floats, WhiteAdjust",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 7 ] } }, 
  {"-rgb9","IP/U/CFRGB/CTRGB/HC/ED YCbCr, Floats",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 8 ] } }, 
  {"-rgb10","IP/CFRGB/CTRGB/ED YCbCr, Integers",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 9 ] } }, 
  {"-rgb11","IP/CFRGB/CTRGB/ED YCbCr, Integers, Levels(1024,64,16)",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 10 ] } }, 
  {"-rgb12","IP/CFRGB/CTRGB/ED YCbCr, Integers, Luma Shift",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 11 ] } }, 
  {"-rgb13","IP/U/CFRGB/CTRGB/HC/ED YCC, Floats",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 12 ] } }, 
  {"-rgb14","IP/CFRGB/CTRGB/ED YCC, Integers",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 13 ] } }, 
  {"-rgb15","IP/CFRGB/CTRGB/ED YCC, Integers, Levels(1024,64,16)",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 14 ] } }, 
  {"-rgb16","IP/CFRGB/CTRGB/ED YCC, Integers, Scale Shift",
		InitRGB, DoRGB, NullProc, EndRGB, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &RGBParmVec[ 15 ] } }, 
  {"-converttoindexpixel","Convert to index BandByPixel IP/CTI/ED",
		InitConvertToIndex, DoConvertToIndex, NullProc,
		EndConvertToIndex, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 10 ], NULL, NULL, NULL }, 
		( XPointer ) &CvtToIndexParmVec[ 0 ] } }, 
  {"-converttoindexplane","Convert to index BandByPlane IP/CTI/ED",
		InitConvertToIndex, DoConvertToIndex, NullProc,
		EndConvertToIndex, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 11 ], NULL, NULL, NULL }, 
		( XPointer ) &CvtToIndexParmVec[ 0 ] } }, 
  {"-convertfromindex","Convert from index ID/CFI/CTI/ED",
		InitConvertToIndex, DoConvertToIndex, NullProc,
		EndConvertToIndex, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 3 ], NULL, NULL, NULL }, 
		( XPointer ) &CvtToIndexParmVec[ 1 ] } }, 
  {"-complex","Complicated Flo",
		InitComplex, DoComplex, NullProc,
		EndComplex, VALL, 0, 0,
		{1,  SUBSET_FULL, 2048, 
		{ &ImageInfo[ 0 ], &ImageInfo[ 1 ], &ImageInfo[ 2 ], 
		&ImageInfo[ 12 ] }, ( XPointer ) NULL } }, 
  {(char * )NULL,(char * )NULL,NULL,NULL, NULL, NULL,(int)NULL, 0, 0,
		{1, (int) NULL, 0, { NULL, NULL, NULL, NULL }, 
		( XPointer ) NULL } },
};
