<?php
//
// ZoneMinder web UK English language file, $Date: 2008-01-08 12:33:11 +0000 (Tue, 08 Jan 2008) $, $Revision: 2281 $
// Copyright (C) 2003, 2004, 2005, 2006  Philip Coombes
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

// ZoneMinder Czech Translation by Lukas Pokorny/Mlada Boleslav

// Notes for Translators
// 0. Get some credit, put your name in the line above (optional)
// 1. When composing the language tokens in your language you should try and keep to roughly the
//   same length text if possible. Abbreviate where necessary as spacing is quite close in a number of places.
// 2. There are four types of string replacement
//   a) Simple replacements are words or short phrases that are static and used directly. This type of
//     replacement can be used 'as is'.
//   b) Complex replacements involve some dynamic element being included and so may require substitution
//     or changing into a different order. The token listed in this file will be passed through sprintf as
//     a formatting string. If the dynamic element is a number you will usually need to use a variable
//     replacement also as described below.
//   c) Variable replacements are used in conjunction with complex replacements and involve the generation
//     of a singular or plural noun depending on the number passed into the zmVlang function. See the 
//     the zmVlang section below for a further description of this.
//   d) Optional strings which can be used to replace the prompts and/or help text for the Options section
//     of the web interface. These are not listed below as they are quite large and held in the database
//     so that they can also be used by the zmconfig.pl script. However you can build up your own list
//     quite easily from the Config table in the database if necessary.
// 3. The tokens listed below are not used to build up phrases or sentences from single words. Therefore
//   you can safely assume that a single word token will only be used in that context.
// 4. In new language files, or if you are changing only a few words or phrases it makes sense from a 
//   maintenance point of view to include the original language file and override the old definitions rather
//   than copy all the language tokens across. To do this change the line below to whatever your base language
//   is and uncomment it.
//require_once( 'zm_lang_en_gb.php' );

// You may need to change the character set here, if your web server does not already
// do this by default, uncomment this if required.
//
// Example
//header( "Content-Type: text/html; charset=iso-8859-2" );

// You may need to change your locale here if your default one is incorrect for the
// language described in this file, or if you have multiple languages supported.
// If you do need to change your locale, be aware that the format of this function
// is subtlely different in versions of PHP before and after 4.3.0, see
// http://uk2.php.net/manual/en/function.setlocale.php for details.
// Also be aware that changing the whole locale may affect some floating point or decimal 
// arithmetic in the database, if this is the case change only the individual locale areas
// that don't affect this rather than all at once. See the examples below.
// Finally, depending on your setup, PHP may not enjoy have multiple locales in a shared 
// threaded environment, if you get funny errors it may be this.
//
// Examples
//setlocale( 'LC_ALL', 'cs_CZ' ); All locale settings pre-4.3.0
// setlocale( LC_ALL, 'en_GB' ); All locale settings 4.3.0 and after
// setlocale( LC_CTYPE, 'en_GB' ); Character class settings 4.3.0 and after
// setlocale( LC_TIME, 'en_GB' ); Date and time formatting 4.3.0 and after

// Simple String Replacements
$zmSlang24BitColour          = '24 bit barevn';
$zmSlang8BitGrey             = '8 bit ed kla';
$zmSlangAction               = 'Akce';
$zmSlangActual               = 'Skuten';
$zmSlangAddNewControl        = 'Pidat nov zen';
$zmSlangAddNewMonitor        = 'Pidat kameru';
$zmSlangAddNewUser           = 'Pidat uivatele';
$zmSlangAddNewZone           = 'Pidat znu';
$zmSlangAlarm                = 'Alarm';
$zmSlangAlarmBrFrames        = 'Alarm<br/>Snmky';
$zmSlangAlarmFrame           = 'Alarm snmek';
$zmSlangAlarmFrameCount      = 'Poet alarm snmk';
$zmSlangAlarmLimits          = 'Limity alarmu';
$zmSlangAlarmMaximumFPS      = 'Alarm Maximum FPS';
$zmSlangAlarmPx              = 'Alarm Px';
$zmSlangAlarmRGBUnset        = 'You must set an alarm RGB colour';
$zmSlangAlert                = 'Pozor';
$zmSlangAll                  = 'Vechny';
$zmSlangApplyingStateChange  = 'Aplikuji zmnu stavu';
$zmSlangApply                = 'Pout';
$zmSlangArchArchived         = 'Pouze archivovan';
$zmSlangArchive              = 'Archiv';
$zmSlangArchived             = 'Archivovn';
$zmSlangArchUnarchived       = 'Pouze nearchivovan';
$zmSlangArea                 = 'Area';
$zmSlangAreaUnits            = 'Area (px/%)';
$zmSlangAttrAlarmFrames      = 'Alarm snmky';
$zmSlangAttrArchiveStatus    = 'Archiv status';
$zmSlangAttrAvgScore         = 'Prm. skre';
$zmSlangAttrCause            = 'Pina';
$zmSlangAttrDate             = 'Datum';
$zmSlangAttrDateTime         = 'Datum/as';
$zmSlangAttrDiskBlocks       = 'Bloky disku';
$zmSlangAttrDiskPercent      = 'Zaplnn disku';
$zmSlangAttrDuration         = 'Prbh';
$zmSlangAttrFrames           = 'Snmky';
$zmSlangAttrId               = 'Id';
$zmSlangAttrMaxScore         = 'Max. skre';
$zmSlangAttrMonitorId        = 'Kamera Id';
$zmSlangAttrMonitorName      = 'Jmno kamery';
$zmSlangAttrName             = 'Jmno';
$zmSlangAttrNotes            = 'Notes';
$zmSlangAttrSystemLoad       = 'System Load';
$zmSlangAttrTime             = 'as';
$zmSlangAttrTotalScore       = 'Celkov skre';
$zmSlangAttrWeekday          = 'Den v tdnu';
$zmSlangAuto                 = 'Auto';
$zmSlangAutoStopTimeout      = 'asov limit pro vypren';
$zmSlangAvgBrScore           = 'Prm.<br/>Skre';
$zmSlangBackground           = 'Background';
$zmSlangBackgroundFilter     = 'Run filter in background';
$zmSlangBadAlarmFrameCount   = 'Alarm frame count must be an integer of one or more';
$zmSlangBadAlarmMaxFPS       = 'Alarm Maximum FPS must be a positive integer or floating point value';
$zmSlangBadChannel           = 'Channel must be set to an integer of zero or more';
$zmSlangBadDevice            = 'Device must be set to a valid value';
$zmSlangBadFormat            = 'Format must be set to an integer of zero or more';
$zmSlangBadFPSReportInterval = 'FPS report interval buffer count must be an integer of 100 or more';
$zmSlangBadFrameSkip         = 'Frame skip count must be an integer of zero or more';
$zmSlangBadHeight            = 'Height must be set to a valid value';
$zmSlangBadHost              = 'Host must be set to a valid ip address or hostname, do not include http://';
$zmSlangBadImageBufferCount  = 'Image buffer size must be an integer of 10 or more';
$zmSlangBadLabelX            = 'Label X co-ordinate must be set to an integer of zero or more';
$zmSlangBadLabelY            = 'Label Y co-ordinate must be set to an integer of zero or more';
$zmSlangBadMaxFPS            = 'Maximum FPS must be a positive integer or floating point value';
$zmSlangBadNameChars         = 'Jmna moho obsahovat pouze alfanumerick znaky a podtrtko i pomlku';
$zmSlangBadPath              = 'Path must be set to a valid value';
$zmSlangBadPort              = 'Port must be set to a valid number';
$zmSlangBadPostEventCount    = 'Post event image count must be an integer of zero or more';
$zmSlangBadPreEventCount     = 'Pre event image count must be at least zero, and less than image buffer size';
$zmSlangBadRefBlendPerc      = 'Reference blend percentage must be a positive integer';
$zmSlangBadSectionLength     = 'Section length must be an integer of 30 or more';
$zmSlangBadSignalCheckColour = 'Signal check colour must be a valid RGB colour string';
$zmSlangBadStreamReplayBuffer= 'Stream replay buffer must be an integer of zero or more';
$zmSlangBadWarmupCount       = 'Warmup frames must be an integer of zero or more';
$zmSlangBadWebColour         = 'Web colour must be a valid web colour string';
$zmSlangBadWidth             = 'Width must be set to a valid value';
$zmSlangBandwidth            = 'Rychlost st';
$zmSlangBlobPx               = 'Znaka Px';
$zmSlangBlobSizes            = 'Velikost znaky';
$zmSlangBlobs                = 'Znaky';
$zmSlangBrightness           = 'Svtlost';
$zmSlangBuffers              = 'Bufery';
$zmSlangCanAutoFocus         = 'Um automaticky zaostit';
$zmSlangCanAutoGain          = 'Um automatick zisk';
$zmSlangCanAutoIris          = 'Um auto iris';
$zmSlangCanAutoWhite         = 'Um automaticky vyvit blou';
$zmSlangCanAutoZoom          = 'Um automaticky zoomovat';
$zmSlangCancelForcedAlarm    = 'Zastavit sputn alarm';
$zmSlangCancel               = 'Zruit';
$zmSlangCanFocusAbs          = 'Um zaostit absolutn';
$zmSlangCanFocusCon          = 'Um prbn zaostit';
$zmSlangCanFocusRel          = 'Um relativn zaostit';
$zmSlangCanFocus             = 'Um zaostit';
$zmSlangCanGainAbs           = 'Um absolutn zisk';
$zmSlangCanGainCon           = 'Um prbn zisk';
$zmSlangCanGainRel           = 'Um relativn zisk';
$zmSlangCanGain              = 'Um zisk';
$zmSlangCanIrisAbs           = 'Um absolutn iris';
$zmSlangCanIrisCon           = 'Um prbn iris';
$zmSlangCanIrisRel           = 'Um relativn iris';
$zmSlangCanIris              = 'Um iris';
$zmSlangCanMoveAbs           = 'Um absoultn pohyb';
$zmSlangCanMoveCon           = 'Um prbn pohyb';
$zmSlangCanMoveDiag          = 'Um diagonln pohyb';
$zmSlangCanMoveMap           = 'Um mapovan pohyb';
$zmSlangCanMoveRel           = 'Um relativn pohyb';
$zmSlangCanMove              = 'Um pohyb';
$zmSlangCanPan               = 'Um oten';
$zmSlangCanReset             = 'Um reset';
$zmSlangCanSetPresets        = 'Um navolit pedvolby';
$zmSlangCanSleep             = 'Me spt';
$zmSlangCanTilt              = 'Um nklon';
$zmSlangCanWake              = 'Lze vzbudit';
$zmSlangCanWhiteAbs          = 'Um absolutn vyven bl';
$zmSlangCanWhiteBal          = 'Um vyven bl';
$zmSlangCanWhiteCon          = 'Um prbn vyven bl';
$zmSlangCanWhiteRel          = 'Um relativn vyven bl';
$zmSlangCanWhite             = 'Um vyven bl';
$zmSlangCanZoomAbs           = 'Um absolutn zoom';
$zmSlangCanZoomCon           = 'Um prbn zoom';
$zmSlangCanZoomRel           = 'Um relativn zoom';
$zmSlangCanZoom              = 'Um zoom';
$zmSlangCaptureHeight        = 'Vka zdrojovho snmku';
$zmSlangCapturePalette       = 'Paleta zdrojovho snmku';
$zmSlangCaptureWidth         = 'ka zdrojovho snmku';
$zmSlangCause                = 'Pina';
$zmSlangCheckMethod          = 'Metoda znakovn alarmem';
$zmSlangChooseFilter         = 'Vybrat filtr';
$zmSlangChoosePreset         = 'Choose Preset';
$zmSlangClose                = 'Zavt';
$zmSlangColour               = 'Barva';
$zmSlangCommand              = 'Pkaz';
$zmSlangConfig               = 'Nastaven';
$zmSlangConfiguredFor        = 'Nastaveno pro';
$zmSlangConfirmDeleteEvents  = 'Are you sure you wish to delete the selected events?';
$zmSlangConfirmPassword      = 'Potvrdit heslo';
$zmSlangConjAnd              = 'a';
$zmSlangConjOr               = 'nebo';
$zmSlangConsole              = 'Konzola';
$zmSlangContactAdmin         = 'Pro detailn info kontaktujte Vaeho administrtora.';
$zmSlangContinue             = 'Pokraovat';
$zmSlangContrast             = 'Kontrast';
$zmSlangControlAddress       = 'Adresa zen';
$zmSlangControlCap           = 'Schopnosti zen';
$zmSlangControlCaps          = 'Typy zen';
$zmSlangControlDevice        = 'Zazen zen';
$zmSlangControllable         = 'diteln';
$zmSlangControlType          = 'Typ zen';
$zmSlangControl              = 'zen';
$zmSlangCycle                = 'Cyklus';
$zmSlangCycleWatch           = 'Cyklick prohlen';
$zmSlangDay                  = 'Den';
$zmSlangDebug                = 'Debug';
$zmSlangDefaultRate          = 'Default Rate';
$zmSlangDefaultScale         = 'Pednastaven velikost';
$zmSlangDefaultView          = 'Default View';
$zmSlangDeleteAndNext        = 'Smazat &amp; Dal';
$zmSlangDeleteAndPrev        = 'Smazat &amp; Pedchoz';
$zmSlangDeleteSavedFilter    = 'Smazat filtr';
$zmSlangDelete               = 'Smazat';
$zmSlangDescription          = 'Popis';
$zmSlangDeviceChannel        = 'Kanl zazen';
$zmSlangDeviceFormat         = 'Formt zazen';
$zmSlangDeviceNumber         = 'slo zarzen';
$zmSlangDevicePath           = 'Cesta k zazen';
$zmSlangDevices              = 'Devices';
$zmSlangDimensions           = 'Rozmry';
$zmSlangDisableAlarms        = 'Zakzat alarmy';
$zmSlangDisk                 = 'Disk';
$zmSlangDonateAlready        = 'Ne, u jsem podpoil';
$zmSlangDonateEnticement     = 'Ji njakou dobu pouvte software ZoneMinder k ochran svho majetku a pedpokldm, e jej shledvte uitenm. Pestoe je ZoneMinder, znovu pipomnm, zdarma a voln en software, stoj jeho vvoj a podpora njak penze. Pokud byste chtl/a podpoit budouc vvoj a nov monosti softwaru, prosm zvate darovn finann pomoci. Darovn je, samozejm, dobrovoln, ale zato velmi cenn mete pispt jakou stkou chcete.<br><br>Pokud mte zjem podpoit n tm, prosm, vyberte ne uvedenou monost, nebo navtivte http://www.zoneminder.com/donate.html.<br><br>Dkuji Vm e jste si vybral/a software ZoneMinder a nezapomete navtvit frum na ZoneMinder.com pro podporu a nvrhy jak udlat ZoneMinder jet lepm ne je dnes.';
$zmSlangDonate               = 'Prosm podpote';
$zmSlangDonateRemindDay      = 'Nyn ne, pipomenout za 1 den';
$zmSlangDonateRemindHour     = 'Nyn ne, pipomenout za hodinu';
$zmSlangDonateRemindMonth    = 'Nyn ne, pipomenout za msc';
$zmSlangDonateRemindNever    = 'Ne, nechci podpoit ZoneMinder, nepipomnat';
$zmSlangDonateRemindWeek     = 'Nyn ne, pipomenout za tden';
$zmSlangDonateYes            = 'Ano, chcit podpoit ZoneMinder nyn';
$zmSlangDownload             = 'Sthnout';
$zmSlangDuration             = 'Prbh';
$zmSlangEdit                 = 'Editovat';
$zmSlangEmail                = 'Email';
$zmSlangEnableAlarms         = 'Povolit alarmy';
$zmSlangEnabled              = 'Povoleno';
$zmSlangEnterNewFilterName   = 'Zadejte nov jmno filtru';
$zmSlangErrorBrackets        = 'Chyba, zkontrolujte prosm zvorky';
$zmSlangError                = 'Chyba';
$zmSlangErrorValidValue      = 'Chyba, zkontrolujte e podmnky maj sprvn hodnoty';
$zmSlangEtc                  = 'atd';
$zmSlangEventFilter          = 'Filtr zznam';
$zmSlangEventId              = 'Id zznamu';
$zmSlangEventName            = 'Jmno zznamu';
$zmSlangEventPrefix          = 'Prefix zznamu';
$zmSlangEvents               = 'Zznamy';
$zmSlangEvent                = 'Zznam';
$zmSlangExclude              = 'Vyjmout';
$zmSlangExecute              = 'Execute';
$zmSlangExportDetails        = 'Exportovat detaily zznamu';
$zmSlangExport               = 'Exportovat';
$zmSlangExportFailed         = 'Chyba pi exportu';
$zmSlangExportFormat         = 'Formt exportovanho souboru';
$zmSlangExportFormatTar      = 'Tar';
$zmSlangExportFormatZip      = 'Zip';
$zmSlangExportFrames         = 'Exportovat detaily snmku';
$zmSlangExportImageFiles     = 'Exportovat obrazov soubory';
$zmSlangExporting            = 'Exportuji';
$zmSlangExportMiscFiles      = 'Exportovat ostatn soubory (jestli existuj)';
$zmSlangExportOptions        = 'Monosti exportu';
$zmSlangExportVideoFiles     = 'Exportovat video soubory (jestli existuj)';
$zmSlangFar                  = 'Daleko';
$zmSlangFastForward          = 'Fast Forward';
$zmSlangFeed                 = 'Nasytit';
$zmSlangFileColours          = 'Barvy souboru';
$zmSlangFilePath             = 'Cesta k souboru';
$zmSlangFile                 = 'Soubor';
$zmSlangFilterArchiveEvents  = 'Archivovat vechny nalezen';
$zmSlangFilterDeleteEvents   = 'Smazat vechny nalezen';
$zmSlangFilterEmailEvents    = 'Poslat email s detaily nalezench';
$zmSlangFilterExecuteEvents  = 'Spustit pkaz na vech nalezench';
$zmSlangFilterMessageEvents  = 'Podat zprvu o vech nalezench';
$zmSlangFilterPx             = 'Filtr Px';
$zmSlangFilters              = 'Filtry';
$zmSlangFilterUnset          = 'You must specify a filter width and height';
$zmSlangFilterUploadEvents   = 'Uploadovat nalezen';
$zmSlangFilterVideoEvents    = 'Create video for all matches';
$zmSlangFirst                = 'Prvn';
$zmSlangFlippedHori          = 'Peklopen vodorovn';
$zmSlangFlippedVert          = 'Peklopen svisle';
$zmSlangFocus                = 'Zaosten';
$zmSlangForceAlarm           = 'Spustit alarm';
$zmSlangFormat               = 'Formt';
$zmSlangFPS                  = 'fps';
$zmSlangFPSReportInterval    = 'FPS Interval pro report';
$zmSlangFrameId              = 'Snmek Id';
$zmSlangFrameRate            = 'Rychlost snmk';
$zmSlangFrameSkip            = 'Vynechat snmek';
$zmSlangFrame                = 'Snmek';
$zmSlangFrames               = 'Snmky';
$zmSlangFTP                  = 'FTP';
$zmSlangFunc                 = 'Funkce';
$zmSlangFunction             = 'Funkce';
$zmSlangGain                 = 'Zisk';
$zmSlangGeneral              = 'General';
$zmSlangGenerateVideo        = 'Generovat video';
$zmSlangGeneratingVideo      = 'Generuji video';
$zmSlangGoToZoneMinder       = 'Jt na ZoneMinder.com';
$zmSlangGrey                 = 'ed';
$zmSlangGroup                = 'Group';
$zmSlangGroups               = 'Skupiny';
$zmSlangHasFocusSpeed        = 'M rychlost zaosten';
$zmSlangHasGainSpeed         = 'M rychlost zisku';
$zmSlangHasHomePreset        = 'M Home volbu';
$zmSlangHasIrisSpeed         = 'M rychlost irisu';
$zmSlangHasPanSpeed          = 'M rychlost oten';
$zmSlangHasPresets           = 'M pedvolby';
$zmSlangHasTiltSpeed         = 'M rychlost nklonu';
$zmSlangHasTurboPan          = 'M Turbo oten';
$zmSlangHasTurboTilt         = 'M Turbo nklon';
$zmSlangHasWhiteSpeed        = 'M rychlost vyven bl';
$zmSlangHasZoomSpeed         = 'M rychlost zoomu';
$zmSlangHighBW               = 'Rychl&nbsp;B/W';
$zmSlangHigh                 = 'Rychl';
$zmSlangHome                 = 'Dom';
$zmSlangHour                 = 'Hodina';
$zmSlangHue                  = 'Odstn';
$zmSlangId                   = 'Id';
$zmSlangIdle                 = 'Pipraven';
$zmSlangIgnore               = 'Ignorovat';
$zmSlangImageBufferSize      = 'Velikost buferu snmk';
$zmSlangImage                = 'Obraz';
$zmSlangImages               = 'Images';
$zmSlangInclude              = 'Vloit';
$zmSlangIn                   = 'Dovnit';
$zmSlangInverted             = 'Pevrcen';
$zmSlangIris                 = 'Iris';
$zmSlangKeyString            = 'Key String';
$zmSlangLabel                = 'Label';
$zmSlangLanguage             = 'Jazyk';
$zmSlangLast                 = 'Posledn';
$zmSlangLimitResultsPost     = 'vsledk'; // This is used at the end of the phrase 'Limit to first N results only'
$zmSlangLimitResultsPre      = 'Zobrazit pouze prvnch'; // This is used at the beginning of the phrase 'Limit to first N results only'
$zmSlangLinkedMonitors       = 'Linked Monitors';
$zmSlangList                 = 'Seznam';
$zmSlangLoad                 = 'Load';
$zmSlangLocal                = 'Lokln';
$zmSlangLoggedInAs           = 'Pihlen jako';
$zmSlangLoggingIn            = 'Pihlauji';
$zmSlangLogin                = 'Pihlsit';
$zmSlangLogout               = 'Odhlsit';
$zmSlangLowBW                = 'Pomal&nbsp;B/W';
$zmSlangLow                  = 'Pomal';
$zmSlangMain                 = 'Hlavn';
$zmSlangMan                  = 'Man';
$zmSlangManual               = 'Manul';
$zmSlangMark                 = 'Oznait';
$zmSlangMaxBandwidth         = 'Max bandwidth';
$zmSlangMaxBrScore           = 'Max.<br/>skre';
$zmSlangMaxFocusRange        = 'Max rozsah zaosten';
$zmSlangMaxFocusSpeed        = 'Max rychlost zaosten';
$zmSlangMaxFocusStep         = 'Max krok zaosten';
$zmSlangMaxGainRange         = 'Max rozsah zisku';
$zmSlangMaxGainSpeed         = 'Max rychlost zisku';
$zmSlangMaxGainStep          = 'Max krok zisku';
$zmSlangMaximumFPS           = 'Maximum FPS';
$zmSlangMaxIrisRange         = 'Max rozsah iris';
$zmSlangMaxIrisSpeed         = 'Max rychlost iris';
$zmSlangMaxIrisStep          = 'Max krok iris';
$zmSlangMax                  = 'Max';
$zmSlangMaxPanRange          = 'Max rozsah oten';
$zmSlangMaxPanSpeed          = 'Max rychlost oten';
$zmSlangMaxPanStep           = 'Max krok oten';
$zmSlangMaxTiltRange         = 'Max rozsah nklonu';
$zmSlangMaxTiltSpeed         = 'Max rychlost nklonu';
$zmSlangMaxTiltStep          = 'Max krok nklonu';
$zmSlangMaxWhiteRange        = 'Max rozsah vyven bl';
$zmSlangMaxWhiteSpeed        = 'Max rychlost vyven bl';
$zmSlangMaxWhiteStep         = 'Max krok vyven bl';
$zmSlangMaxZoomRange         = 'Max rozsah zoomu';
$zmSlangMaxZoomSpeed         = 'Max rychlost zoomu';
$zmSlangMaxZoomStep          = 'Max krok zoomu';
$zmSlangMediumBW             = 'Stedn&nbsp;B/W';
$zmSlangMedium               = 'Stedn';
$zmSlangMinAlarmAreaLtMax    = 'Minimum alarm area should be less than maximum';
$zmSlangMinAlarmAreaUnset    = 'You must specify the minimum alarm pixel count';
$zmSlangMinBlobAreaLtMax     = 'Minimum znakovan oblasti by mlo bt men ne maximum';
$zmSlangMinBlobAreaUnset     = 'You must specify the minimum blob pixel count';
$zmSlangMinBlobLtMinFilter   = 'Minimum blob area should be less than or equal to minimum filter area';
$zmSlangMinBlobsLtMax        = 'Minimum znaek by mlo bt men ne maximum';
$zmSlangMinBlobsUnset        = 'You must specify the minimum blob count';
$zmSlangMinFilterAreaLtMax   = 'Minimum filter area should be less than maximum';
$zmSlangMinFilterAreaUnset   = 'You must specify the minimum filter pixel count';
$zmSlangMinFilterLtMinAlarm  = 'Minimum filter area should be less than or equal to minimum alarm area';
$zmSlangMinFocusRange        = 'Min rozsah zaosten';
$zmSlangMinFocusSpeed        = 'Min rychlost zaosten';
$zmSlangMinFocusStep         = 'Min krok zaosten';
$zmSlangMinGainRange         = 'Min rozsah zisku';
$zmSlangMinGainSpeed         = 'Min rychlost zisku';
$zmSlangMinGainStep          = 'Min krok zisku';
$zmSlangMinIrisRange         = 'Min rozsah iris';
$zmSlangMinIrisSpeed         = 'Min rychlost iris';
$zmSlangMinIrisStep          = 'Min krok iris';
$zmSlangMinPanRange          = 'Min rozsah oten';
$zmSlangMinPanSpeed          = 'Min rychlost oten';
$zmSlangMinPanStep           = 'Min krok oten';
$zmSlangMinPixelThresLtMax   = 'Minimln prh pixelu by ml bt men ne  maximumln';
$zmSlangMinPixelThresUnset   = 'You must specify a minimum pixel threshold';
$zmSlangMinTiltRange         = 'Min rozsah nklonu';
$zmSlangMinTiltSpeed         = 'Min rychlost nklonu';
$zmSlangMinTiltStep          = 'Min krok nklonu';
$zmSlangMinWhiteRange        = 'Min rozsah vyven bl';
$zmSlangMinWhiteSpeed        = 'Min rychlost vyven bl';
$zmSlangMinWhiteStep         = 'Min krok vyven bl';
$zmSlangMinZoomRange         = 'Min rozsah zoomu';
$zmSlangMinZoomSpeed         = 'Min rychlost zoomu';
$zmSlangMinZoomStep          = 'Min krok zoomu';
$zmSlangMisc                 = 'Ostatn';
$zmSlangMonitorIds           = 'Id&nbsp;kamer';
$zmSlangMonitor              = 'Kamera';
$zmSlangMonitorPresetIntro   = 'Select an appropriate preset from the list below.<br><br>Please note that this may overwrite any values you already have configured for this monitor.<br><br>';
$zmSlangMonitorPreset        = 'Monitor Preset';
$zmSlangMonitors             = 'Kamery';
$zmSlangMontage              = 'Sestih';
$zmSlangMonth                = 'Msc';
$zmSlangMove                 = 'Pohyb';
$zmSlangMustBeGe             = 'mus bt vt nebo rovno ne';
$zmSlangMustBeLe             = 'mus bt men nebo rovno ne';
$zmSlangMustConfirmPassword  = 'Muste potvrdit heslo';
$zmSlangMustSupplyPassword   = 'Muste zadat heslo';
$zmSlangMustSupplyUsername   = 'Muste zadat uivatelsk jmno';
$zmSlangName                 = 'Jmno';
$zmSlangNear                 = 'Blzko';
$zmSlangNetwork              = 'S';
$zmSlangNewGroup             = 'Nov skupina';
$zmSlangNewLabel             = 'New Label';
$zmSlangNew                  = 'Nov';
$zmSlangNewPassword          = 'Nov heslo';
$zmSlangNewState             = 'Nov stav';
$zmSlangNewUser              = 'Nov uivatel';
$zmSlangNext                 = 'Dal';
$zmSlangNoFramesRecorded     = 'Pro tento snmek nejsou dn zznamy';
$zmSlangNoGroup              = 'No Group';
$zmSlangNo                   = 'Ne';
$zmSlangNoneAvailable        = 'dn nen dostupn';
$zmSlangNone                 = 'Zakzat';
$zmSlangNormal               = 'Normaln';
$zmSlangNoSavedFilters       = 'dn uloen filtry';
$zmSlangNoStatisticsRecorded = 'Pro tento zznam/snmek nejsou zaznamenny dn statistiky';
$zmSlangNotes                = 'Poznmky';
$zmSlangNumPresets           = 'Poet pedvoleb';
$zmSlangOff                  = 'Off';
$zmSlangOn                   = 'On';
$zmSlangOpen                 = 'Otevt';
$zmSlangOpEq                 = 'rovno';
$zmSlangOpGtEq               = 'vt nebo rovno';
$zmSlangOpGt                 = 'vt';
$zmSlangOpIn                 = 'nin set';
$zmSlangOpLtEq               = 'men nebo rovno';
$zmSlangOpLt                 = 'men';
$zmSlangOpMatches            = 'obsahuje';
$zmSlangOpNe                 = 'nerovn se';
$zmSlangOpNotIn              = 'nnot in set';
$zmSlangOpNotMatches         = 'neobsahuje';
$zmSlangOptionHelp           = 'MonostHelp';
$zmSlangOptionRestartWarning = 'Tyto zmny se neprojev\ndokud systm b. Jakmile\ndokonte provdn zmn prosm\nrestartujte ZoneMinder.';
$zmSlangOptions              = 'Monosti';
$zmSlangOrder                = 'Poad';
$zmSlangOrEnterNewName       = 'nebo vlote nov jmno';
$zmSlangOrientation          = 'Orientace';
$zmSlangOut                  = 'Ven';
$zmSlangOverwriteExisting    = 'Pepsat existujc';
$zmSlangPaged                = 'Strkov';
$zmSlangPanLeft              = 'Posunout vlevo';
$zmSlangPan                  = 'Oten';
$zmSlangPanRight             = 'Posunout vpravo';
$zmSlangPanTilt              = 'Oten/Nklon';
$zmSlangParameter            = 'Parametr';
$zmSlangPassword             = 'Heslo';
$zmSlangPasswordsDifferent   = 'Hesla se neshoduj';
$zmSlangPaths                = 'Cesty';
$zmSlangPause                = 'Pause';
$zmSlangPhoneBW              = 'Modem&nbsp;B/W';
$zmSlangPhone                = 'Modem';
$zmSlangPixelDiff            = 'Pixel Diff';
$zmSlangPixels               = 'pixely';
$zmSlangPlayAll              = 'Pehrt ve';
$zmSlangPlay                 = 'Play';
$zmSlangPleaseWait           = 'Prosm ekejte';
$zmSlangPoint                = 'Point';
$zmSlangPostEventImageBuffer = 'Pozznamov bufer';
$zmSlangPreEventImageBuffer  = 'Pedzznamov bufer';
$zmSlangPreserveAspect       = 'Preserve Aspect Ratio';
$zmSlangPreset               = 'Pedvolba';
$zmSlangPresets              = 'Pedvolby';
$zmSlangPrev                 = 'Zpt';
$zmSlangProtocol             = 'Protocol';
$zmSlangRate                 = 'Rychlost';
$zmSlangReal                 = 'Skuten';
$zmSlangRecord               = 'Nahrvat';
$zmSlangRefImageBlendPct     = 'Reference Image Blend %ge';
$zmSlangRefresh              = 'Obnovit';
$zmSlangRemoteHostName       = 'Adresa';
$zmSlangRemoteHostPath       = 'Cesta';
$zmSlangRemoteHostPort       = 'Port';
$zmSlangRemoteImageColours   = 'Barvy';
$zmSlangRemote               = 'Sov';
$zmSlangRename               = 'Pejmenovat';
$zmSlangReplayAll            = 'All Events';
$zmSlangReplayGapless        = 'Gapless Events';
$zmSlangReplay               = 'Pehrt znovu';
$zmSlangReplay               = 'Replay';
$zmSlangReplaySingle         = 'Single Event';
$zmSlangResetEventCounts     = 'Resetovat poty zznam';
$zmSlangReset                = 'Reset';
$zmSlangRestarting           = 'Restartuji';
$zmSlangRestart              = 'Restartovat';
$zmSlangRestrictedCameraIds  = 'Povolen id kamer';
$zmSlangRestrictedMonitors   = 'Restricted Monitors';
$zmSlangReturnDelay          = 'Prodleva vracen';
$zmSlangReturnLocation       = 'Lokace vrcen';
$zmSlangRewind               = 'Rewind';
$zmSlangRotateLeft           = 'Otoit vlevo';
$zmSlangRotateRight          = 'Otoit vpravo';
$zmSlangRunMode              = 'Reim';
$zmSlangRunning              = 'B';
$zmSlangRunState             = 'Stav';
$zmSlangSaveAs               = 'Uloit jako';
$zmSlangSaveFilter           = 'Uloit filtr';
$zmSlangSave                 = 'Uloit';
$zmSlangScale                = 'Velikost';
$zmSlangScore                = 'Skre';
$zmSlangSecs                 = 'Dlka(s)';
$zmSlangSectionlength        = 'Dlka sekce';
$zmSlangSelectMonitors       = 'Select Monitors';
$zmSlangSelect               = 'Vybrat';
$zmSlangSelfIntersecting     = 'Polygon edges must not intersect';
$zmSlangSetLearnPrefs        = 'Set Learn Prefs'; // This can be ignored for now
$zmSlangSet                  = 'Nastavit';
$zmSlangSetNewBandwidth      = 'Nastavit novou rychlost st';
$zmSlangSetPreset            = 'Nastavit pedvolbu';
$zmSlangSettings             = 'Nastaven';
$zmSlangShowFilterWindow     = 'Zobrazit filtr';
$zmSlangShowTimeline         = 'Zobrazit asovou linii ';
$zmSlangSignalCheckColour    = 'Signal Check Colour';
$zmSlangSize                 = 'Velikost';
$zmSlangSleep                = 'Spt';
$zmSlangSortAsc              = 'Vzestupn';
$zmSlangSortBy               = 'adit dle';
$zmSlangSortDesc             = 'Sestupn';
$zmSlangSourceType           = 'Typ zdroje';
$zmSlangSource               = 'Zdroj';
$zmSlangSpeedHigh            = 'Vysok rychlost';
$zmSlangSpeedLow             = 'Nzk rychlost';
$zmSlangSpeedMedium          = 'Stedn rychlost';
$zmSlangSpeed                = 'Rychlost';
$zmSlangSpeedTurbo           = 'Turbo rychlost';
$zmSlangStart                = 'Start';
$zmSlangState                = 'Stav';
$zmSlangStats                = 'Statistiky';
$zmSlangStatus               = 'Status';
$zmSlangStepBack             = 'Step Back';
$zmSlangStepForward          = 'Step Forward';
$zmSlangStep                 = 'Krok';
$zmSlangStepLarge            = 'Velk krok';
$zmSlangStepMedium           = 'Stedn krok';
$zmSlangStepNone             = 'dn krok';
$zmSlangStepSmall            = 'Mal krok';
$zmSlangStills               = 'Snmky';
$zmSlangStopped              = 'Zastaven';
$zmSlangStop                 = 'Zastavit';
$zmSlangStreamReplayBuffer   = 'Stream Replay Image Buffer';
$zmSlangStream               = 'Stream';
$zmSlangSubmit               = 'Potvrdit';
$zmSlangSystem               = 'System';
$zmSlangTele                 = 'Piblit';
$zmSlangThumbnail            = 'Miniatura';
$zmSlangTilt                 = 'Nklon';
$zmSlangTime                 = 'as';
$zmSlangTimeDelta            = 'Delta asu';
$zmSlangTimeline             = 'asov linie';
$zmSlangTimeStamp            = 'asov raztko';
$zmSlangTimestampLabelFormat = 'Formt asovho raztka';
$zmSlangTimestampLabelX      = 'asov raztko X';
$zmSlangTimestampLabelY      = 'asov raztko Y';
$zmSlangTimestamp            = 'Raztko';
$zmSlangToday                = 'Dnes';
$zmSlangTools                = 'Nstroje';
$zmSlangTotalBrScore         = 'Celkov<br/>skre';
$zmSlangTrackDelay           = 'Prodleva drhy';
$zmSlangTrackMotion          = 'Pohyb po drze';
$zmSlangTriggers             = 'Trigery';
$zmSlangTurboPanSpeed        = 'Rychlost Turbo oten';
$zmSlangTurboTiltSpeed       = 'Rychlost Turbo nklonu';
$zmSlangType                 = 'Typ';
$zmSlangUnarchive            = 'Vyjmout z archivu';
$zmSlangUnits                = 'Jednotky';
$zmSlangUnknown              = 'Neznm';
$zmSlangUpdateAvailable      = 'Je dostupn nov update ZoneMinder.';
$zmSlangUpdateNotNecessary   = 'Update nen poteba.';
$zmSlangUpdate               = 'Update';
$zmSlangUseFilterExprsPost   = '&nbsp;vraz'; // This is used at the end of the phrase 'use N filter expressions'
$zmSlangUseFilterExprsPre    = 'Pout&nbsp;'; // This is used at the beginning of the phrase 'use N filter expressions'
$zmSlangUseFilter            = 'Pout filtr';
$zmSlangUsername             = 'Uivatelsk jmno';
$zmSlangUsers                = 'Uivatel';
$zmSlangUser                 = 'Uivatel';
$zmSlangValue                = 'Hodnota';
$zmSlangVersionIgnore        = 'Ignorovat tuto verzi';
$zmSlangVersionRemindDay     = 'Pipomenout za 1 den';
$zmSlangVersionRemindHour    = 'Pipomenout za hodinu';
$zmSlangVersionRemindNever   = 'Nepipomnat nov veze';
$zmSlangVersionRemindWeek    = 'Pipomenout za tden';
$zmSlangVersion              = 'Verze';
$zmSlangVideoFormat          = 'Video formt';
$zmSlangVideoGenFailed       = 'Chyba pi generovn videa!';
$zmSlangVideoGenFiles        = 'Existujc video soubory';
$zmSlangVideoGenNoFiles      = 'dn video soubory nenalezeny';
$zmSlangVideoGenParms        = 'Parametry generovn videa';
$zmSlangVideoGenSucceeded    = 'Video vygenerovno spn!';
$zmSlangVideoSize            = 'Velikost videa';
$zmSlangVideo                = 'Video';
$zmSlangViewAll              = 'Zobrazit vechny';
$zmSlangViewEvent            = 'Zobrazit zznam';
$zmSlangViewPaged            = 'Zobrazit strkov';
$zmSlangView                 = 'Zobrazit';
$zmSlangWake                 = 'Vzbudit';
$zmSlangWarmupFrames         = 'Zahvac snmky';
$zmSlangWatch                = 'Sledovat';
$zmSlangWebColour            = 'Webov barva';
$zmSlangWeb                  = 'Web';
$zmSlangWeek                 = 'Tden';
$zmSlangWhiteBalance         = 'Vyven bl';
$zmSlangWhite                = 'Bl';
$zmSlangWide                 = 'Oddlit';
$zmSlangX10ActivationString  = 'X10 aktivan etzec';
$zmSlangX10InputAlarmString  = 'X10 input alarm etzec';
$zmSlangX10OutputAlarmString = 'X10 output alarm etzec';
$zmSlangX10                  = 'X10';
$zmSlangX                    = 'X';
$zmSlangYes                  = 'Ano';
$zmSlangYouNoPerms           = 'K tomuto zdroji nemte oprvnn.';
$zmSlangY                    = 'Y';
$zmSlangZoneAlarmColour      = 'Barva alarmu (Red/Green/Blue)';
$zmSlangZoneArea             = 'Zone Area';
$zmSlangZoneFilterSize       = 'Filter Width/Height (pixels)';
$zmSlangZoneMinMaxAlarmArea  = 'Min/Max Alarmed Area';
$zmSlangZoneMinMaxBlobArea   = 'Min/Max Blob Area';
$zmSlangZoneMinMaxBlobs      = 'Min/Max Blobs';
$zmSlangZoneMinMaxFiltArea   = 'Min/Max Filtered Area';
$zmSlangZoneMinMaxPixelThres = 'Min/Max Pixel Threshold (0-255)';
$zmSlangZoneOverloadFrames   = 'Overload Frame Ignore Count';
$zmSlangZones                = 'Zny';
$zmSlangZone                 = 'Zna';
$zmSlangZoomIn               = 'Zvtit';
$zmSlangZoomOut              = 'Zmenit';
$zmSlangZoom                 = 'Zoom';

// Complex replacements with formatting and/or placements, must be passed through sprintf
$zmClangCurrentLogin         = 'Prv je pihlen \'%1$s\'';
$zmClangEventCount           = '%1$s %2$s'; // For example '37 Events' (from Vlang below)
$zmClangLastEvents           = 'Poslednch %1$s %2$s'; // For example 'Last 37 Events' (from Vlang below)
$zmClangLatestRelease        = 'Posledn verze je v%1$s, vy mte v%2$s.';
$zmClangMonitorCount         = '%1$s %2$s'; // For example '4 Monitors' (from Vlang below)
$zmClangMonitorFunction      = 'Funkce %1$s kamery';
$zmClangRunningRecentVer     = 'Pouvte posledn verzi ZoneMinder, v%s.';

// The next section allows you to describe a series of word ending and counts used to 
// generate the correctly conjugated forms of words depending on a count that is associated
// with that word.
// This intended to allow phrases such a '0 potatoes', '1 potato', '2 potatoes' etc to
// conjugate correctly with the associated count.
// In some languages such as English this is fairly simple and can be expressed by assigning
// a count with a singular or plural form of a word and then finding the nearest (lower) value.
// So '0' of something generally ends in 's', 1 of something is singular and has no extra
// ending and 2 or more is a plural and ends in 's' also. So to find the ending for '187' of
// something you would find the nearest lower count (2) and use that ending.
//
// So examples of this would be
// $zmVlangPotato = array( 0=>'Potatoes', 1=>'Potato', 2=>'Potatoes' );
// $zmVlangSheep = array( 0=>'Sheep' );
//
// where you can have as few or as many entries in the array as necessary
// If your language is similar in form to this then use the same format and choose the
// appropriate zmVlang function below.
// If however you have a language with a different format of plural endings then another
// approach is required . For instance in Russian the word endings change continuously
// depending on the last digit (or digits) of the numerator. In this case then zmVlang
// arrays could be written so that the array index just represents an arbitrary 'type'
// and the zmVlang function does the calculation about which version is appropriate.
//
// So an example in Russian might be (using English words, and made up endings as I
// don't know any Russian!!)
// $zmVlangPotato = array( 1=>'Potati', 2=>'Potaton', 3=>'Potaten' );
//
// and the zmVlang function decides that the first form is used for counts ending in
// 0, 5-9 or 11-19 and the second form when ending in 1 etc.
//

// Variable arrays expressing plurality, see the zmVlang description above
$zmVlangEvent                = array( 0=>'Zznam', 1=>'Zznam', 2=>'Zznamy', 5=>'Zznam' );
$zmVlangMonitor              = array( 0=>'Kamer', 1=>'Kamera', 2=>'Kamery', 5=>'Kamer' );

// You will need to choose or write a function that can correlate the plurality string arrays
// with variable counts. This is used to conjugate the Vlang arrays above with a number passed
// in to generate the correct noun form.
//
// In languages such as English this is fairly simple 
// Note this still has to be used with printf etc to get the right formating
function zmVlang( $lang_var_array, $count )
{
	krsort( $lang_var_array );
	foreach ( $lang_var_array as $key=>$value )
	{
		if ( abs($count) >= $key )
		{
			return( $value );
		}
	}
	die( 'Error, unable to correlate variable language string' );
}

// This is an version that could be used in the Russian example above
// The rules are that the first word form is used if the count ends in
// 0, 5-9 or 11-19. The second form is used then the count ends in 1
// (not including 11 as above) and the third form is used when the 
// count ends in 2-4, again excluding any values ending in 12-14.
// 
// function zmVlang( $lang_var_array, $count )
// {
// 	$secondlastdigit = substr( $count, -2, 1 );
// 	$lastdigit = substr( $count, -1, 1 );
// 	// or
// 	// $secondlastdigit = ($count/10)%10;
// 	// $lastdigit = $count%10;
// 
// 	// Get rid of the special cases first, the teens
// 	if ( $secondlastdigit == 1 && $lastdigit != 0 )
// 	{
// 		return( $lang_var_array[1] );
// 	}
// 	switch ( $lastdigit )
// 	{
// 		case 0 :
// 		case 5 :
// 		case 6 :
// 		case 7 :
// 		case 8 :
// 		case 9 :
// 		{
// 			return( $lang_var_array[1] );
// 			break;
// 		}
// 		case 1 :
// 		{
// 			return( $lang_var_array[2] );
// 			break;
// 		}
// 		case 2 :
// 		case 3 :
// 		case 4 :
// 		{
// 			return( $lang_var_array[3] );
// 			break;
// 		}
// 	}
// 	die( 'Error, unable to correlate variable language string' );
// }

// This is an example of how the function is used in the code which you can uncomment and 
// use to test your custom function.
//$monitors = array();
//$monitors[] = 1; // Choose any number
//echo sprintf( $zmClangMonitorCount, count($monitors), zmVlang( $zmVlangMonitor, count($monitors) ) );

// In this section you can override the default prompt and help texts for the options area
// These overrides are in the form of $zmOlangPrompt<option> and $zmOlangHelp<option>
// where <option> represents the option name minus the initial ZM_
// So for example, to override the help text for ZM_LANG_DEFAULT do
//$zmOlangPromptLANG_DEFAULT = "This is a new prompt for this option";
//$zmOlangHelpLANG_DEFAULT = "This is some new help for this option which will be displayed in the popup window when the ? is clicked";
//

?>
