##############################################################################
#
# Copyright (c) 2001, 2002 Zope Corporation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################
from ZopeUndo.Prefix import Prefix

import unittest

class PrefixTest(unittest.TestCase):

    def test(self):
        p1 = Prefix("/a/b")
        for equal in ("/a/b", "/a/b/c", "/a/b/c/d"):
            self.assertEqual(p1, equal)
        for notEqual in ("", "/a/c", "/a/bbb", "///"):
            self.assertNotEqual(p1, notEqual)

        p2 = Prefix("")
        for equal in ("", "/", "/def", "/a/b", "/a/b/c", "/a/b/c/d"):
            self.assertEqual(p2, equal)

    def test_pre327_compat(self):
        string = "a/b/"
        p = Prefix(string)
        # Prior to 3.2.7, Prefix had only a value attribute.  Make sure
        # an old-format Prefix gets converted to new-format automagically.
        length, path = p.length, p.path
        del p.length, p.path
        p.value = len(string), string
        self.assertEqual(repr(p), "Prefix('" + string + "')")
        self.assertEqual(p.length, length)
        self.assertEqual(p.path, path)

        # Ensure the pre-3.2.7 .value attribute gets created too.
        p = Prefix(string)
        self.assertEqual(p.value, (len(string), string))

    def test_username_info(self):
        # Zope Collector 1810; user paths have username appended
        p1 = Prefix('/a/b')
        for equal in ('/a/b spam', '/a/b/c spam', '/a/b/c/b spam'):
            self.assertEqual(p1, equal)
        for notEqual in (" spam", "/a/c spam", "/a/bbb spam", "/// spam"):
            self.assertNotEqual(p1, notEqual)

        p2 = Prefix("")
        for equal in (" eggs", "/ eggs", "/def eggs", "/a/b eggs", 
                      "/a/b/c eggs", "/a/b/c/d eggs"):
            self.assertEqual(p2, equal)


def test_suite():
    return unittest.makeSuite(PrefixTest)
