//
// (C) 2007 DEREZYNSKI Milosz
//

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>

#include <taglib/taglib.h>
#include <taglib/fileref.h>
#include <taglib/tfile.h>
#include <taglib/tag.h>

#include "bmp/database-types.hh"
#include "bmp/library-types.hh"
#include "bmp/library-ops.hh"

using namespace Bmp::DB;
using namespace Glib;
using namespace TagLib;
using namespace std;

namespace Bmp
{
    bool
    metadata_check_file (TagLib::File * file)
    {
      if (!file->isOpen())
        return false;

      if (!file->isValid())
        return false;

      return true;
    }

    void
    metadata_get_common (TagLib::File * file, Row &row)
    {
      ustring value;

      value = (file->tag()->artist().to8Bit (true));
      if (!value.empty() && value.validate())
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_ARTIST ).id, value));

      value = (file->tag()->album().to8Bit (true));
      if (!value.empty() && value.validate())
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_ALBUM ).id, value));

      value = (file->tag()->title().to8Bit (true));
      if (!value.empty() && value.validate())
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_TITLE ).id, value)); 

      value = (file->tag()->genre().to8Bit (true));
      if (!value.empty() && value.validate())
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_GENRE ).id, value));

      value = (file->tag()->comment().to8Bit (true));
      if (!value.empty() && value.validate())
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_COMMENT ).id, value));

      if (file->audioProperties())
      {
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_BITRATE ).id, guint64 (file->audioProperties()->bitrate())));
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_SAMPLERATE ).id, guint64 (file->audioProperties()->sampleRate())));
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_TIME ).id, guint64 (file->audioProperties()->length())));
      }
      else
      {
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_BITRATE ).id, guint64 (0)));
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_SAMPLERATE ).id, guint64 (0)));
          row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_TIME ).id, guint64 (0)));
      }

      row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_TRACK ).id, guint64 (file->tag()->track())));
      row.insert (std::make_pair (get_attribute_info( ATTRIBUTE_DATE ).id, guint64 (file->tag()->year())));

    }

    void
    metadata_set_common (TagLib::File * file, const Track& track)
    {
      TagLib::Tag * tag = file->tag();
      if (tag)
      {
        if (track.title)
            tag->setTitle   (String (track.title.get().c_str(), String::UTF8));

        if (track.artist)
            tag->setArtist  (String (track.artist.get().c_str(), String::UTF8));

        if (track.album)
            tag->setAlbum   (String (track.album.get().c_str(), String::UTF8));

        if (track.comment)
            tag->setComment (String (track.comment.get().c_str(), String::UTF8));

        if (track.genre)
            tag->setGenre   (String (track.genre.get().c_str(), String::UTF8));

        if (track.date)
            tag->setYear    (track.date.get());

        if (track.tracknumber)
            tag->setTrack   (track.tracknumber.get());
      }
      else
      {
        try{
          g_critical ("%s: Couldn't get File's Tag: %s", G_STRLOC, filename_from_uri (track.location.get()).c_str());
        } catch (Glib::ConvertError & cxe) {}
      }
    }

} // end namespace Bmp
