#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>
#include <taglib/fileref.h>
#include <taglib/taglib.h>
#include <taglib/fileref.h>
#include <taglib/tfile.h>
#include <taglib/tag.h>
#include <taglib/oggfile.h>
#include <taglib/vorbisfile.h>
#include <taglib/vorbisproperties.h>
#include <taglib/xiphcomment.h>

#include "bmp/database-types.hh"
#include "bmp/library-types.hh"
#include "bmp/library-ops.hh"

#include "common/common.hh"
#include "xiph/reader.hh"

using namespace Bmp;
using namespace TagLib;
using namespace Glib;

extern "C" int  _plugin_has_accessors;
int  _plugin_has_accessors = 1;

extern "C" int  _plugin_version;
int _plugin_version = PLUGIN_VERSION;

extern "C" const char ** _mimetypes ()
{
  static const char * _types[] =
  {
    "application/ogg",
    NULL
  };
  return _types;
}

extern "C" bool _set (std::string const& filename, Track & track)
{
  Ogg::Vorbis::File opfile (filename.c_str());
  if (!metadata_check_file (&opfile))
    return false;

  Ogg::XiphComment * comment = opfile.tag();
  if (comment)
  {
    metadata_set_common (&opfile, track);

    if (track.mb_album_artist)
      comment->addField (String ("ALBUMARTIST",                         String::UTF8),
                         String (track.mb_album_artist.get(),           String::UTF8));

    if (track.mb_album_artist_id)
      comment->addField (String ("MUSICBRAINZ_ALBUMARTISTID",           String::UTF8),
                         String (track.mb_album_artist_id.get(),        String::UTF8));

    if (track.mb_album_artist_sort_name)
      comment->addField (String ("ALBUMARTISTSORT",                     String::UTF8),
                         String (track.mb_album_artist_sort_name.get(), String::UTF8));

    if (track.mb_track_id)
      comment->addField (String ("MUSICBRAINZ_TRACKID",                 String::UTF8),
                         String (track.mb_track_id.get(),               String::UTF8));

    if (track.mb_album_id)
      comment->addField (String ("MUSICBRAINZ_ALBUMID",                 String::UTF8),
                         String(track.mb_album_id.get(),                String::UTF8));

    if (track.mb_artist_id)
      comment->addField (String ("MUSICBRAINZ_ARTISTID",                String::UTF8),
                         String (track.mb_artist_id.get(),              String::UTF8));

    if (track.mb_artist_sort_name)
      comment->addField (String ("ARTISTSORT",                          String::UTF8),
                         String (track.mb_artist_sort_name.get(),       String::UTF8));

    if (track.mb_release_date)
      comment->addField (String ("DATE", String::UTF8),
                         String (track.mb_release_date.get(), String::UTF8));

    if (track.asin)
      comment->addField (String ("ASIN",            String::UTF8),
                         String (track.asin.get(),  String::UTF8));

    if (track.puid)
      comment->addField (String ("MUSICIP_PUID",   String::UTF8),
                         String (track.puid.get(), String::UTF8));


    opfile.save ();
    return true;
  }
  else
  {
    return false;
  }
}

extern "C" bool _get (std::string const& filename, DB::Row & row)
{
  Ogg::Vorbis::File opfile (filename.c_str());
  if (!metadata_check_file (&opfile))
    return false;

  Ogg::XiphComment * comment = opfile.tag();
  if (comment)
  {
    metadata_get_xiph (comment, row);
    metadata_get_common (&opfile, row);
    return true;
  }

  return false;
}
