//  "BMP" Copyright (C) 2003-2007 BMP development
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_BOOKMARK_MANAGER_HH
#define BMP_BOOKMARK_MANAGER_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <vector>
#include <string>
#include <glibmm/ustring.h>
#include "playbacksource.hh"

using namespace Glib;
using namespace Gtk;

#include "bookmark-types.hh"

namespace Bmp
{
    class BookmarkManager
    {
      public:

        typedef sigc::signal <void, Bookmark &, guint64> SignalBookmarkLoaded;

        struct SignalsT
        {
          SignalBookmarkLoaded BookmarkLoaded;
        };

        SignalsT Signals;

      public:

        BookmarkManager ();
        virtual ~BookmarkManager ();

        guint64
        add_bookmark (Bookmark const& bookmark);

        void
        load_bookmarks ();

        SignalBookmarkLoaded&
        signal_bookmark_loaded ();

      private:

        void
        save_bookmarks ();

        BookmarkV   m_bookmarks;
        MURLIdx     m_indexmap;

    }; // end class BookmarkManager 
} // end namespace Bmp 
  
#endif
