//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_Gst_ERROR_HH
#define BMP_Gst_ERROR_HH

#include <glibmm/ustring.h>
#include <gtkmm/dialog.h>
#include <libglademm/xml.h>

namespace Bmp
{
  class DialogGstError
    : public Gtk::Dialog
  {
    public:
        DialogGstError (BaseObjectType*                        cobject,
                        Glib::RefPtr<Gnome::Glade::Xml> const& xml);
        static DialogGstError* create ();
        virtual ~DialogGstError ();

        int run (Glib::ustring const& main,
                 Glib::ustring const& element,
                 Glib::ustring const& uri,
                 Glib::ustring const& details,
                 Glib::ustring const& helpstring,
                 GQuark domain,
                 gint code);

    private:
        Glib::RefPtr<Gnome::Glade::Xml>	 m_ref_xml;
  };
} // Bmp

#endif // !BMP_Gst_ERROR_HH

