//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_DIALOG_TRACK_DETAILS_HH
#define BMP_DIALOG_TRACK_DETAILS_HH

#include <gtkmm/dialog.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/notebook.h>
#include <gtkmm/textview.h>
#include <libglademm/xml.h>

#include "bmp/base-types.hh"
#include "bmp/ui-types.hh"

#include "lyrics-v2.hh"
#include "lastfm.hh"
using namespace Bmp::LastFM; 
using namespace Bmp::LastFM::XMLRPC; 

namespace Bmp
{
  class TrackInfoView;
  class LastFmWikiView;
  class TrackDetails
    : public Gtk::Window
  {
      Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;

    public:

      TrackDetails (BaseObjectType                       * obj,
                    Glib::RefPtr<Gnome::Glade::Xml> const& xml);
      static TrackDetails* create ();
      virtual ~TrackDetails ();

      void
      display (TrackMetadata const& metadata);

    private:

      void
      got_lyrics (std::string const& lyrics, bool have_em);

      void
      get_lyrics (bool forced = false);

      void
      got_artist (std::string const& metadata, guint code); 

      void
      get_artist ();

    private:

      void
      open_uri (ustring const&);

      void
      split_title ();

      LyricWiki::TextRequestRefP m_lyrics_request;
      LastFM::XMLRPC::ArtistMetadataRequestRefPtr m_artist_request;

      typedef std::vector<TrackMetadata> MetadataV;
      typedef MetadataV::iterator MetadataIter;

      Gtk::Notebook       * m_notebook_artist;
      Gtk::Notebook       * m_notebook_lyrics;
      Bmp::TrackInfoView  * m_widget_trackinfo;
      Gtk::Entry          * m_widget_lyrics_artist;
      Gtk::Entry          * m_widget_lyrics_title;
      Gtk::Image          * m_widget_cover;
      Gtk::TextView       * m_widget_lyrics;
      LastFmWikiView      * m_widget_artist;
      RefPixbuf             m_cover;

      Gtk::Widget         * m_visible_child;

      struct MetaDataData
      {
        MetadataV             V;
        MetadataIter          Iter;
        Glib::Mutex           Lock;

        MetaDataData () : Iter (V.begin())
        {}
      };

      MetaDataData          MData;

      Glib::RefPtr<Gtk::SizeGroup> m_size_group;

  }; //class TrackDetails
} //namespace Bmp 

#endif // !BMP_DIALOG_TRACK_DETAILS_HH

