//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_JAMENDO_API_HH
#define BMP_JAMENDO_API_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <gdkmm/pixbuf.h>

#include <string>
#include <list>

#include "bmp/base-types.hh"
#include "bmp/ui-types.hh"

#include "dialog-simple-progress.hh"
#include "jamendo-types.hh"
#include "database.hh"

namespace Bmp
{
  typedef int ID;
  typedef std::list<int> IDList;

  struct JamendoDataBundle
  {
    JamendoData::ArtistV  m_artists;
  };

  class Jamendo
  {
    private:

      DB::Database * m_db;
      JamendoDataBundle m_bundle;
      bool m_have_cover_cache;

    public:
  
      Jamendo ();
      ~Jamendo ();
  
      //////////////////////////////////
      /////// STUFF NEEDED FOR FRONTEND
      //////////////////////////////////
      
      JamendoDataBundle const&
      data_bundle ();

      void
      update_bundle (SimpleProgress * d = 0);

      void
      db_update ();

      void
      get_albums_by_artist (guint64 artist_id, JamendoData::AlbumV & v);

      void
      get_tracks_by_album  (guint64 album_id, JamendoData::TrackV & v);

      RefPixbuf 
      get_album_cover (ID id); // album ID
  };
}

#endif //!BMP_JAMENDO_API_HH
