//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_LOGGER_HH
#define BMP_LOGGER_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <map>
#include <fstream>
#include <string>

#include <glib/gmessages.h>
#include <glibmm/thread.h>
#include <glibmm/ustring.h>

#include <boost/shared_ptr.hpp>

#define LOG_ALL_LEVELS                (GLogLevelFlags (G_LOG_LEVEL_MASK | G_LOG_FLAG_FATAL | G_LOG_FLAG_RECURSION))
#define BMP_LOGGER_DEFAULT_LOG_LEVEL  (GLogLevelFlags (G_LOG_LEVEL_MESSAGE | G_LOG_LEVEL_INFO))

/* default log file max size: 512kb */
#define BMP_LOGGER_FILE_MAX_SIZE      (std::size_t (1) << 19)

namespace Bmp
{
  class Log
  {
      public:

        Log (Glib::ustring const &domain,
             const std::string   &filename,
             GLogLevelFlags       flags);

        ~Log ();

        void
        log_to_file (const char     *domain,
                     GLogLevelFlags  flags,
                     const char     *message);

      private:

        Log (const Log &original);
        const Log & operator = (const Log &original);

        std::ofstream   logfile;
        Glib::Mutex     file_mutex;
        Glib::ustring   domain;
        std::string     filename;
        unsigned int    id;

        static void
        log_to_file_wrap (const char     *domain,
                          GLogLevelFlags  flags,
                          const char     *message,
                          void           *data);
  };

  class Logger
  {
      public:

        Logger ();

        void
        add_log (Glib::ustring const &domain,
                 const std::string   &filename,
                 GLogLevelFlags       flags);

      private:

        Logger (const Logger &original);
        const Logger & operator = (const Logger &original);

        std::map<Glib::ustring, boost::shared_ptr<Log> > logs;
  };

} // Bmp

#endif // BMP_LOGGER_HPP
