//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_LYRICWIKI_HH
#define BMP_LYRICWIKI_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H
using namespace Glib;
using namespace std;

#include "minisoup.hh"

namespace Bmp
{
  namespace LyricWiki
  {
    class TextRequest;
    typedef Glib::RefPtr<TextRequest> TextRequestRefP;
    typedef sigc::signal<void, std::string const& /* lyrics */, bool /* lyrics found */> SignalLyrics;

    class TextRequest
      : public Glib::Object
    {
        SignalLyrics s_;
      public:
        SignalLyrics & lyrics() { return s_; }
      private:

        TextRequest (ustring const& artist,
                     ustring const& title,
                     int force = 0);

      public:
  
        static TextRequestRefP create (ustring const& artist,
                                       ustring const& title,
                                       int force = 0);
        void run ();
        void cancel ();
        ~TextRequest ();

      private:

        std::string m_lyrics;
        std::string m_cached_file;
        ustring m_artist, m_title;
        int m_force;

        void reply_cb (const char * /* data */, guint /* size */, guint /* HTTP status code */);
        Soup::RequestRefP m_soup_request;
    };
  }
}

#endif //!BMP_LYRICWIKI_HH
