//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <exception>
#include <glib/ghash.h>
#include <glibmm/ustring.h>
#include <glibmm/i18n.h>
#include <sigc++/signal.h>
#include <boost/format.hpp>

#include "bmp/base-types.hh"
#include "bmp/ui-types.hh"
#include "playbacksource.hh"

using namespace Glib;

namespace Bmp
{
        PlaybackSource::SignalNextAsync&
        PlaybackSource::signal_next_async ()
        {
          return mSignalNextAsync;
        }

        PlaybackSource::SignalPrevAsync&
        PlaybackSource::signal_prev_async ()
        {
          return mSignalPrevAsync;
        }

        PlaybackSource::SignalPlayAsync&
        PlaybackSource::signal_play_async ()
        {
          return mSignalPlayAsync;
        }

        PlaybackSource::SignalCaps &
        PlaybackSource::signal_caps ()
        {
          return mSignalCaps;
        }

        PlaybackSource::SignalFlags &
        PlaybackSource::signal_flags ()
        {
          return mSignalFlags;
        }

        PlaybackSource::SignalTrackMetadata &
        PlaybackSource::signal_track_metadata ()
        {
          return mSignalMetadata;
        }

        PlaybackSource::SignalPlaybackRequest &
        PlaybackSource::signal_playback_request ()
        {
          return mSignalPlayRequest;
        }

        PlaybackSource::SignalStopRequest &
        PlaybackSource::signal_stop_request ()
        {
          return mSignalStopRequest;
        }

        PlaybackSource::SignalNextRequest &
        PlaybackSource::signal_next_request ()
        {
          return mSignalNextRequest;
        }

        PlaybackSource::SignalSegment &
        PlaybackSource::signal_segment ()
        {
          return mSignalSegment;
        }

        PlaybackSource::SignalMessage &
        PlaybackSource::signal_message ()
        {
          return mSignalMessage;
        }

        PlaybackSource::SignalMessageClear &
        PlaybackSource::signal_message_clear ()
        {
          return mSignalMessageClear;
        }

        PlaybackSource::SignalEnqueueRequest&
        PlaybackSource::signal_enqueue_request ()
        {
          return mSignalEnqueueRequest;
        }

        void
        PlaybackSource::next_post ()
        {} 

        void
        PlaybackSource::prev_post ()
        {}

        void
        PlaybackSource::skipped ()
        {}

        void
        PlaybackSource::send_caps ()
        {
          mSignalCaps.emit (m_caps);
        }

        void
        PlaybackSource::send_flags ()
        {
          mSignalFlags.emit (m_flags);
        }

        GHashTable*
        PlaybackSource::get_metadata ()
        {
          return 0;
        } 

        void
        PlaybackSource::segment ()
        {};

        ustring
        PlaybackSource::get_name ()
        {
          return m_name;
        }

        void
        PlaybackSource::buffering_done ()
        {};

        std::string
        PlaybackSource::new_error (std::exception const& cxe)
        {
          std::string message = (boost::format (_("%s: %s")) % m_name.c_str() % cxe.what()).str();
          return message;
        }

        std::string
        PlaybackSource::new_message (std::string const& message_in)
        {
          std::string message = (boost::format (_("%s: %s")) % m_name.c_str() % message_in).str(); 
          return message;
        }

} // end namespace Bmp 
