//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#include <gtkmm.h>
#include "stock.hh"
#include "paths.hh"

#include <iostream>

namespace Bmp
{
  using namespace std;
  using namespace Glib;
  using namespace Gtk;
  using namespace Gdk;

  void
  register_stock_icons ()
  {
    RefPtr<Gtk::IconFactory> factory = IconFactory::create ();

    struct StockIconSpec
    {
      char* filename;
      char* stock_id;
    };

    StockIconSpec list[] =
    {   
      { "bmp.png",                      BMP_STOCK_ABOUT             },
      { "silk-add.png",                 BMP_STOCK_ADD               },
      { "approve.png",                  BMP_STOCK_APPROVE           },
      { "approve-partial.png",          BMP_STOCK_APPROVE_PARTIAL   },
      { "artist.png",                   BMP_STOCK_ARTIST            },
      { "artist-blackstar.png",         BMP_STOCK_ARTIST_ALL        },
      { "artist-mb.png",                BMP_STOCK_ARTIST_MB         },
      { "artist-multiple.png",          BMP_STOCK_ARTIST_MULTIPLE   },
      { "audio.png",                    BMP_STOCK_AUDIO             },
      { "cdrom.png",                    BMP_STOCK_CDDA              },
      { "silk-delete.png",              BMP_STOCK_DELETE            },
      { "silk-disk.png",                BMP_STOCK_DISK              },
      { "silk-cart_put.png",            BMP_STOCK_DOWNLOAD          },
      { "silk-cd_edit.png",             BMP_STOCK_EDIT_ALBUM        },
      { "eek.png",                      BMP_STOCK_EEK               },
      { "clear.png",                    BMP_STOCK_ENTRY_CLEAR       },
      { "equalizer.png",                BMP_STOCK_EQ                },
      { "silk-exclamation.png" ,        BMP_STOCK_ERROR             },
      { "feed.png",                     BMP_STOCK_FEED              },
      { "silk-feed_add.png",            BMP_STOCK_FEED_ADD          },
      { "silk-feed_delete.png",         BMP_STOCK_FEED_DELETE       },
      { "silk-feed_disk.png",           BMP_STOCK_FEED_UPDATE       },
      { "silk-folder.png",              BMP_STOCK_FOLDER            },
      { "silk-drive.png",               BMP_STOCK_HARDDISK          },
      { "web.png",                      BMP_STOCK_HTML_LINK         },
      { "jamendo.png",                  BMP_STOCK_JAMENDO           },
      { "lastfm.png",                   BMP_STOCK_LASTFM            },
      { "lastfm-ban.png",               BMP_STOCK_LASTFM_BAN        },
      { "lastfm-love.png",              BMP_STOCK_LASTFM_LOVE       },
      { "lastfm-skip.png",              BMP_STOCK_LASTFM_SKIP       },
      { "library.png",                  BMP_STOCK_LIBRARY           },
      { "silk-server_database.png",     BMP_STOCK_LIBRARY_TRACK     },
      { "silk-world_link.png",          BMP_STOCK_LINK              },
      { "lyrics.png",                   BMP_STOCK_LYRICS            },
      { "musicbrainz.png",              BMP_STOCK_MUSICBRAINZ       },
      { "silk-new.png",                 BMP_STOCK_NEW               },
      { "play.png",                     BMP_STOCK_PLAY              },
      { "playlist.png",                 BMP_STOCK_PLAYLIST          },
      { "silk-plugin.png",              BMP_STOCK_PLUGIN            },
      { "silk-plugin_disabled.png",     BMP_STOCK_PLUGIN_DISABLED   }, 
      { "silk-application_edit.png",    BMP_STOCK_PREFERENCES       },
      { "silk-cd_delete.png",           BMP_STOCK_REMOVE_MUSIC      },
      { "repeat.png",                   BMP_STOCK_REPEAT            },
      { "search.png",                   BMP_STOCK_SEARCH            },
      { "silk-attach.png",              BMP_STOCK_SELECTED          },
      { "shuffle.png",                  BMP_STOCK_SHUFFLE           },
      { "tag.png",                      BMP_STOCK_TAG               },
      { "track.png",                    BMP_STOCK_TRACK             },
      { "undo.png",                     BMP_STOCK_UNDO              },
      { "silk-picture.png",             BMP_STOCK_VIEW              },
      { "xiph.png",                     BMP_STOCK_XIPH              },
    };

    for (unsigned int n = 0; n < G_N_ELEMENTS (list); ++n)
    {
      string filename = build_filename (BMP_IMAGE_DIR_STOCK, list[n].filename);
      RefPtr<Pixbuf> pixbuf = Pixbuf::create_from_file (filename);
      factory->add (StockID (list[n].stock_id), IconSet(pixbuf));
    }

    factory->add_default ();
  }
}
