
//  BMP
//  Copyright (C) 2007 <http://beep-media-player.org> 
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_VIDEO_WIDGET_GST_HH
#define BMP_VIDEO_WIDGET_GST_HH

#include <gtkmm.h>
#include "bmp/glib-addons.hh"

namespace Bmp
{
  enum AspectRatio
  {
    VW_RATIO_AUTO,
    VW_RATIO_SQUARE,
    VW_RATIO_FOURBYTHREE,
    VW_RATIO_ANAMORPHIC,
    VW_RATIO_DVB
  }; 

  typedef std::pair<int, int> Geometry;

  typedef Glib::Property<Geometry> PropGeom;
  typedef Glib::Property<AspectRatio> PropAspectRatio;

  class VideoWindow
    : public Gtk::Widget
  {

    private:

      PropBool        property_playing_;
      PropGeom        property_geometry_;
      PropAspectRatio property_aspect_ratio_;

      Glib::Mutex   mLock;

      int m_video_width_pixels, m_video_height_pixels;

      bool
      on_toplevel_configure_event (GdkEventConfigure *);

      void
      get_media_size (int & width, int & height);

    public:

      Glib::RefPtr<Gdk::Window> mWindow, mVideo;

      VideoWindow ();
      virtual ~VideoWindow ();

      ProxyOf<PropBool>::ReadWrite property_playing();
      ProxyOf<PropGeom>::ReadWrite property_geometry();
      ProxyOf<PropAspectRatio>::ReadWrite property_aspect_ratio();

      GValue * mPar;

    protected:

      virtual void
      on_size_allocate (Gtk::Allocation &);

      virtual void
      on_size_request (Gtk::Requisition *);

      virtual bool
      on_expose_event (GdkEventExpose *);

      virtual bool
      on_configure_event (GdkEventConfigure *);

      virtual void
      on_map ();

      virtual void
      on_unmap ();

      virtual void
      on_unrealize ();

      virtual void
      on_realize ();
  };
}

#endif // !BMP_VIDEO_WIDGET_GST_HH
