# generic GRP (Gentoo Reference Platform) specfile
# used to build a GRP set

# The subarch can be any of the supported catalyst subarches (like athlon-xp).
# Refer to "man catalyst" or <https://wiki.gentoo.org/wiki/Catalyst>
# for supported subarches
# example:
# subarch: athlon-xp
subarch:

# The version stamp is an identifier for the build.  It can be anything you wish
# it to be, but it is usually a date.
# example:
# version_stamp: 2006.1
version_stamp:

# The target specifies what target we want catalyst to do. For GRP, the
# supported targets are: grp
# example:
# target: grp
target: grp

# The rel_type defines what kind of build we are doing.  This is merely another
# identifier, but it useful for allowing multiple concurrent builds.  Usually,
# default will suffice.
# example:
# rel_type: default
rel_type:

# This is the system profile to be used by catalyst to build this target.  It is
# specified as a relative path from /usr/portage/profiles.
# example:
# profile: default-linux/x86/2006.1
profile:

# This specifies which snapshot to use for building this target.
# example:
# snapshot: 2006.1
snapshot:

# This specifies where the seed stage comes from for this target,  The path is
# relative to $clst_sharedir/builds.  The rel_type is also used as a path prefix
# for the seed.
# example:
# default/stage3-x86-2006.1
source_subpath:

# These are the hosts used as distcc slaves when distcc is enabled in your
# catalyst.conf.  It follows the same syntax as distcc-config --set-hosts and
# is entirely optional.
# example:
# distcc_hosts: 127.0.0.1 192.168.0.1
distcc_hosts:

# This is an optional directory containing portage configuration files.  It
# follows the same syntax as /etc/portage and should be consistent across all
# targets to minimize problems.
# example:
# portage_confdir: /etc/portage
portage_confdir:

# This option specifies the location to a portage overlay that you would like to
# have used when building this target.
# example:
# portage_overlay: /usr/local/portage
portage_overlay:

# This allows the optional directory containing the output packages for
# catalyst.  Mainly used as a way for different spec files to access the same
# cache directory.  Default behavior is for this location to be autogenerated
# by catalyst based on the spec file.
# example:
# pkgcache_path: /tmp/packages
pkgcache_path:

# Since GRP is capable of building packages/source sets for more than one CD,
# this defines the layout for the directories under $clst_sharedir/builds.
# example:
# grp: src cd2
grp: src cd2

# GRP is also able to build packages with customized USE settings.  However, it
# is very possible to cause quite a few problems with these, so be careful with
# whatever USE flags you add here.  This is generally used for adding some
# functionality that we do not want on by default for all Gentoo users, but that
# we want on by default in our binaries.  Some examples would be things like the
# socks5 USE flag.
# example:
# grp/use: gtk2 gnome kde qt bonobo cdr esd gtkhtml mozilla mysql perl ruby tcltk cups ldap ssl tcpd -svga
grp/use:

# This tells catalyst what type of GRP set this list of packages will create.
# Valid options here are srcset or pkgset to either download the source, or to
# build packages, respectively.
# example:
# grp/src/type: srcset
grp/src/type:

# Since this is a srcset, these ebuilds will have their distfiles fetched and
# the distfiles will be stored in the src directory under $clst_sharedir/builds.
# Packages will not be made out of this list.  We use this for grabbing things
# that need a compiled kernel to build, or things listed in the Handbook that
# should be available before the first reboot during an install.
# example:
# grp/src/packages: gentoo-sources udev vanilla-sources rp-pppoe speedtouch fcdsl fritzcapi globespan-adsl pptpclient slmodem lvm2 evms iputils vixie-cron fcron dcron sysklogd metalog syslog-ng raidtools jfsutils xfsprogs reiserfsprogs dosfstools ntfsprogs lilo grub isdn4k-utils iproute2 wireless-tools wpa_supplicant pcmcia-cs hotplug coldplug dhcpcd slocate genkernel ipw2100 ipw2200 fxload logrotate
grp/src/packages:

# This is mostly here for completeness.  This is the pkgset definition.
# example:
# grp/cd2/type: pkgset
grp/cd2/type:

# This is our list of packages that will comprise our package set.  These are
# fetched, compiled, and the packages are stored under $clst_sharedir/builds.
# example:
# grp/cd2/packages: dante tsocks sys-apps/eject minicom links acpid apmd parted whois tcpdump cvs zip unzip netcat partimage app-admin/sudo app-cdr/cdrtools gnome emacs dev-lang/ruby enlightenment kde mozilla-firefox mozilla-thunderbird xfce4 openbox fluxbox sylpheed openoffice-bin gimp xemacs xmms abiword gaim xchat pan tetex xcdroast k3b samba nmap gradm ettercap ethereal mplayer
grp/cd2/packages:
