// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_OPTIONS2_IMPORT_DATA_HANDLER2_H_
#define CHROME_BROWSER_UI_WEBUI_OPTIONS2_IMPORT_DATA_HANDLER2_H_
#pragma once

#include "base/basictypes.h"
#include "base/compiler_specific.h"
#include "base/memory/ref_counted.h"
#include "chrome/browser/importer/importer_data_types.h"
#include "chrome/browser/importer/importer_list_observer.h"
#include "chrome/browser/importer/importer_progress_observer.h"
#include "chrome/browser/ui/webui/options2/options_ui2.h"

class ImporterHost;
class ImporterList;

namespace options2 {

// Chrome personal stuff import data overlay UI handler.
class ImportDataHandler : public OptionsPageUIHandler,
                          public importer::ImporterListObserver,
                          public importer::ImporterProgressObserver {
 public:
  ImportDataHandler();
  virtual ~ImportDataHandler();

  // OptionsPageUIHandler:
  virtual void GetLocalizedValues(
      base::DictionaryValue* localized_strings) OVERRIDE;
  virtual void Initialize() OVERRIDE;

  // WebUIMessageHandler:
  virtual void RegisterMessages() OVERRIDE;

 private:
  void ImportData(const base::ListValue* args);

  // importer::ImporterListObserver:
  virtual void OnSourceProfilesLoaded() OVERRIDE;

  // importer::ImporterProgressObserver:
  virtual void ImportStarted() OVERRIDE;
  virtual void ImportItemStarted(importer::ImportItem item) OVERRIDE;
  virtual void ImportItemEnded(importer::ImportItem item) OVERRIDE;
  virtual void ImportEnded() OVERRIDE;

  scoped_refptr<ImporterList> importer_list_;

  // If non-null it means importing is in progress. ImporterHost takes care
  // of deleting itself when import is complete.
  ImporterHost* importer_host_;  // weak

  bool import_did_succeed_;

  DISALLOW_COPY_AND_ASSIGN(ImportDataHandler);
};

}  // namespace options2

#endif  // CHROME_BROWSER_UI_WEBUI_OPTIONS2_IMPORT_DATA_HANDLER2_H_
