// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_SSL_SSL_REQUEST_INFO_H_
#define CONTENT_BROWSER_SSL_SSL_REQUEST_INFO_H_
#pragma once

#include <string>

#include "base/memory/ref_counted.h"
#include "googleurl/src/gurl.h"
#include "net/base/cert_status_flags.h"
#include "webkit/glue/resource_type.h"

// SSLRequestInfo wraps up the information SSLPolicy needs about a request in
// order to update our security IU.  SSLRequestInfo is RefCounted in case we
// need to deal with the request asynchronously.
class SSLRequestInfo : public base::RefCounted<SSLRequestInfo> {
 public:
  SSLRequestInfo(const GURL& url,
                 ResourceType::Type resource_type,
                 int child_id,
                 int ssl_cert_id,
                 net::CertStatus ssl_cert_status);

  const GURL& url() const { return url_; }
  ResourceType::Type resource_type() const { return resource_type_; }
  int child_id() const { return child_id_; }
  int ssl_cert_id() const { return ssl_cert_id_; }
  net::CertStatus ssl_cert_status() const { return ssl_cert_status_; }

 private:
  friend class base::RefCounted<SSLRequestInfo>;

  virtual ~SSLRequestInfo();

  GURL url_;
  ResourceType::Type resource_type_;
  int child_id_;
  int ssl_cert_id_;
  net::CertStatus ssl_cert_status_;

  DISALLOW_COPY_AND_ASSIGN(SSLRequestInfo);
};

#endif  // CONTENT_BROWSER_SSL_SSL_REQUEST_INFO_H_
