# Copyright (c) 2011 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'includes': [
    '../../../build/common.gypi',
  ],
  'variables': {
    'common_sources': [
      'gio.c',
      'gio_mem.c',
      'gprintf.c',
      'gio_mem_snapshot.c',
    ],
    'trusted_sources': [
      '<@(common_sources)',
      'gio_pio.c',
    ],
  },
  'targets': [
    {
      'target_name': 'gio',
      'type': 'static_library',
      'sources': [
        '<@(trusted_sources)',
      ],
    },
  ],
  'conditions': [
    # NOTE: we do not support untrusted gyp build on arm yet.
    ['target_arch!="arm"', {
      'targets' : [
        {
          'target_name': 'gio_lib',
          'type': 'none',
          'variables': {
            'nlib_target': 'libgio.a',
            'build_glibc': 1,
            'build_newlib': 1,
            'sources': ['<@(common_sources)']
          },
          'dependencies': [
            '<(DEPTH)/native_client/tools.gyp:prep_toolchain',
          ],
        },
      ],
    }],
    ['OS=="win"', {
      'targets': [
        {
          'target_name': 'gio64',
          'type': 'static_library',
            'sources': [
              '<@(trusted_sources)',
            ],
          'variables': {
            'win_target': 'x64',
          },
        }
      ],
    }],
  ],
}
