/*
 * This file is part of the WebKit open source project.
 * This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "config.h"

#if ENABLE(Condition1) || ENABLE(Condition2)

#include "WebDOMTestInterface.h"

#include "KURL.h"
#include "TestInterface.h"
#include "TestObj.h"
#include "TestSupplemental.h"
#include "WebDOMString.h"
#include "WebDOMTestObj.h"
#include "WebExceptionHandler.h"
#include "wtf/text/AtomicString.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

struct WebDOMTestInterface::WebDOMTestInterfacePrivate {
    WebDOMTestInterfacePrivate(WebCore::TestInterface* object = 0)
        : impl(object)
    {
    }

    RefPtr<WebCore::TestInterface> impl;
};

WebDOMTestInterface::WebDOMTestInterface()
    : WebDOMObject()
    , m_impl(0)
{
}

WebDOMTestInterface::WebDOMTestInterface(WebCore::TestInterface* impl)
    : WebDOMObject()
    , m_impl(new WebDOMTestInterfacePrivate(impl))
{
}

WebDOMTestInterface::WebDOMTestInterface(const WebDOMTestInterface& copy)
    : WebDOMObject()
{
    m_impl = copy.impl() ? new WebDOMTestInterfacePrivate(copy.impl()) : 0;
}

WebDOMTestInterface& WebDOMTestInterface::operator=(const WebDOMTestInterface& copy)
{
    delete m_impl;
    m_impl = copy.impl() ? new WebDOMTestInterfacePrivate(copy.impl()) : 0;
    return *this;
}

WebCore::TestInterface* WebDOMTestInterface::impl() const
{
    return m_impl ? WTF::getPtr(m_impl->impl) : 0;
}

WebDOMTestInterface::~WebDOMTestInterface()
{
    delete m_impl;
    m_impl = 0;
}

#if ENABLE(Condition11) || ENABLE(Condition12)
WebDOMString WebDOMTestInterface::supplementalStr1() const
{
    if (!impl())
        return WebDOMString();

    return static_cast<const WTF::String&>(TestSupplemental::supplementalStr1(impl()));
}

#endif
#if ENABLE(Condition11) || ENABLE(Condition12)
WebDOMString WebDOMTestInterface::supplementalStr2() const
{
    if (!impl())
        return WebDOMString();

    return static_cast<const WTF::String&>(TestSupplemental::supplementalStr2(impl()));
}

void WebDOMTestInterface::setSupplementalStr2(const WebDOMString& newSupplementalStr2)
{
    if (!impl())
        return;

    TestSupplemental::setSupplementalStr2(impl(), newSupplementalStr2);
}

#endif

#if ENABLE(Condition11) || ENABLE(Condition12)
void WebDOMTestInterface::supplementalMethod1()
{
    if (!impl())
        return;

    WebCore::TestSupplemental::supplementalMethod1(impl());
}

#endif


#if ENABLE(Condition11) || ENABLE(Condition12)
WebDOMTestObj WebDOMTestInterface::supplementalMethod2(const WebDOMString& strArg, const WebDOMTestObj& objArg)
{
    if (!impl())
        return WebDOMTestObj();

    WebCore::ExceptionCode ec = 0;
    WebDOMTestObj result = toWebKit(WTF::getPtr(WebCore::TestSupplemental::supplementalMethod2(impl(), strArg, toWebCore(objArg), ec)));
    webDOMRaiseError(static_cast<WebDOMExceptionCode>(ec));
    return result;
}

#endif

WebCore::TestInterface* toWebCore(const WebDOMTestInterface& wrapper)
{
    return wrapper.impl();
}

WebDOMTestInterface toWebKit(WebCore::TestInterface* value)
{
    return WebDOMTestInterface(value);
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)
