SET(PROJECT_VERSION_MAJOR 0)
SET(PROJECT_VERSION_MINOR 1)
SET(PROJECT_VERSION ${PROJECT_VERSION_MAJOR}.${PROJECT_VERSION_MINOR})

SET(DATA_DIR ${CMAKE_INSTALL_PREFIX}/share/${PROJECT_NAME}-${PROJECT_VERSION})

ADD_DEFINITIONS(-DDATA_DIR="${DATA_DIR}")

ADD_DEFINITIONS(-DBUILDING_BLACKBERRY__)
ADD_DEFINITIONS(-DBUILD_WEBKIT)

# Workaround for now so that SK_DEBUG isn't defined in SkPreConfig.h
ADD_DEFINITIONS(-DSK_RELEASE)

# TODO: Make this build-time configurable
SET(WTF_USE_PTHREADS 1)
ADD_DEFINITIONS(-DWTF_USE_PTHREADS=1)

IF (TARGETING_PLAYBOOK)
    SET(WTF_USE_ACCELERATED_COMPOSITING 1)
    ADD_DEFINITIONS(-DWTF_USE_ACCELERATED_COMPOSITING=1)
    ADD_DEFINITIONS(-DBLACKBERRY_PLATFORM_GRAPHICS_EGL=1)
    ADD_DEFINITIONS(-DBLACKBERRY_PLATFORM_EXPORT_WEBDOM=1)
ENDIF ()

IF (ADDITIONAL_SYSTEM_INCLUDE_PATH)
    SET(CMAKE_INCLUDE_SYSTEM_FLAG_C "-Wp,-isystem")
    SET(CMAKE_INCLUDE_SYSTEM_FLAG_CXX "-Wp,-isystem")
    FOREACH (directory ${ADDITIONAL_SYSTEM_INCLUDE_PATH})
        INCLUDE_DIRECTORIES(SYSTEM ${directory})
    ENDFOREACH ()
ENDIF ()

IF (ENABLE_DRT)
    message("*** DRT is ENABLED ***")
ENDIF ()

ADD_DEFINITIONS(-D__QNXNTO__)
ADD_DEFINITIONS(-D_FILE_OFFSET_BITS=64)
ADD_DEFINITIONS(-D_LARGEFILE64_SOURCE)

# Find a library only in the staging directory (which is the CMAKE_INSTALL_PATH)
# TODO: CMAKE_INSTALL_PATH may not be staging directory.
MACRO(FIND_STAGING_LIBRARY _var _libname)
  FIND_LIBRARY(${_var} ${_libname}
    PATHS "${CMAKE_INSTALL_PREFIX}"
    ENV "QNX_TARGET"
    PATH_SUFFIXES "${CMAKE_SYSTEM_PROCESSOR}/usr/lib" "${CMAKE_SYSTEM_PROCESSOR}/usr/lib/torch-webkit" "${CMAKE_SYSTEM_PROCESSOR}/lib"
    NO_DEFAULT_PATH)
ENDMACRO()

FIND_STAGING_LIBRARY(Skia_LIBRARY grskia)
FIND_STAGING_LIBRARY(Skia_QNX_LIBRARY skia-qnx)
FIND_STAGING_LIBRARY(JPEG_LIBRARY jpeg)
FIND_STAGING_LIBRARY(PNG_LIBRARY png)
FIND_STAGING_LIBRARY(XML2_LIBRARY xml2)
FIND_STAGING_LIBRARY(XSLT_LIBRARY xslt)
FIND_STAGING_LIBRARY(SQLITE3_LIBRARY sqlite3)
FIND_STAGING_LIBRARY(M_LIBRARY m)
FIND_STAGING_LIBRARY(NBUTIL_LIBRARY nbutil)
FIND_STAGING_LIBRARY(FREETYPE_LIBRARY freetype)
FIND_STAGING_LIBRARY(ICUData_LIBRARY icudata)
FIND_STAGING_LIBRARY(ICUI18N_LIBRARY icui18n)
FIND_STAGING_LIBRARY(ICUUC_LIBRARY icuuc)
FIND_STAGING_LIBRARY(Iconv_LIBRARY iconv)
FIND_STAGING_LIBRARY(INTL_LIBRARY intl)
FIND_STAGING_LIBRARY(Z_LIBRARY z)
FIND_STAGING_LIBRARY(Socket_LIBRARY socket)
FIND_STAGING_LIBRARY(CURL_LIBRARY curl)
FIND_STAGING_LIBRARY(SSL_LIBRARY ssl)
FIND_STAGING_LIBRARY(Crypto_LIBRARY crypto)
FIND_STAGING_LIBRARY(WebKitPlatform_LIBRARY webkitplatform)
FIND_STAGING_LIBRARY(UUID_LIBRARY uuid-browser)
FIND_STAGING_LIBRARY(Screen_LIBRARY screen)
FIND_STAGING_LIBRARY(MMR_LIBRARY mmrndclient)
FIND_STAGING_LIBRARY(PPSCache_LIBRARY ppscache)
FIND_STAGING_LIBRARY(MD_LIBRARY md)
FIND_STAGING_LIBRARY(AOI_LIBRARY aoi)
FIND_STAGING_LIBRARY(CLIPBOARD_LIBRARY clipboard)
FIND_STAGING_LIBRARY(EGL_LIBRARY EGL)
FIND_STAGING_LIBRARY(GLESv2_LIBRARY GLESv2)
FIND_STAGING_LIBRARY(STRM_LIBRARY strm)
FIND_STAGING_LIBRARY(HARFBUZZ_LIBRARY harfbuzz)
FIND_STAGING_LIBRARY(FONTCONFIG_LIBRARY fontconfig)
FIND_STAGING_LIBRARY(PROFILING_LIBRARY profilingS)
FIND_STAGING_LIBRARY(LIB_INPUT_UTILITIES input_utilities)

# Show unresolved symbols when doing the final shared object link
IF (PROFILING)
    SET(BLACKBERRY_LINK_FLAGS "-Wl,-z,defs -Wl,-zrelro -Wl,-E")
ELSE (PROFILING)
    SET(BLACKBERRY_LINK_FLAGS "-Wl,-z,defs -Wl,-zrelro")
ENDIF ()

# Set custom CFLAGS for our port
IF (CMAKE_COMPILER_IS_GNUCC)
    SET(CMAKE_CXX_FLAGS "-fstack-protector -fno-rtti -Wformat -Wformat-security -Werror=format-security ${CMAKE_CXX_FLAGS}")
    SET(CMAKE_C_FLAGS "-fstack-protector -fno-rtti -Wformat -Wformat-security -Werror=format-security ${CMAKE_C_FLAGS}")
    SET(JSC_LINK_FLAGS "-N1024K")
ENDIF ()

IF (PROFILING)
    SET(CMAKE_CXX_FLAGS "-finstrument-functions -g ${CMAKE_CXX_FLAGS}")
    SET(CMAKE_C_FLAGS "-finstrument-functions -g ${CMAKE_C_FLAGS}")
ENDIF ()

# FIXME: Make this more elegant
IF (TARGETING_PLAYBOOK)
    SET(CMAKE_CXX_FLAGS "-mfpu=vfpv3 -mthumb -mthumb-interwork ${CMAKE_CXX_FLAGS}")
    SET(CMAKE_C_FLAGS "-mfpu=vfpv3 -mthumb -mthumb-interwork ${CMAKE_C_FLAGS}")
ENDIF ()

ADD_DEFINITIONS(-DRESOURCE_PATH="/usr/share/webkit-owb/resources/")
INCLUDE_DIRECTORIES(${CMAKE_INCLUDE_PATH})

SET(JSC_EXECUTABLE_NAME jsc)

SET(WTF_LIBRARY_NAME wtf)
SET(JavaScriptCore_LIBRARY_NAME javascriptcore)
SET(WebCore_LIBRARY_NAME webcore)
SET(WebKit_LIBRARY_NAME webkit)
SET(WebKit_DRT_LIBRARY_NAME webkit_DRT)

IF (TARGETING_PLAYBOOK)
    WEBKIT_FEATURE(ENABLE_3D_RENDERING "Enable 3D Rendering" DEFAULT ON)
    WEBKIT_FEATURE(ENABLE_WEBGL "Enable WebGL" DEFAULT ON)
ELSE ()
    WEBKIT_FEATURE(ENABLE_3D_RENDERING "Enable 3D Rendering" DEFAULT OFF)
    WEBKIT_FEATURE(ENABLE_WEBGL "Enable WebGL" DEFAULT OFF)
ENDIF ()

WEBKIT_FEATURE(ENABLE_ASSEMBLER_WX_EXCLUSIVE "Assembler WX Exclusive" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_BLACKBERRY_CARET_APPEARANCE "Blackberry Caret Appearance" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_BLOB "Enable blob slice" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_CHANNEL_MESSAGING "Enable channel messaging" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_CLIENT_BASED_GEOLOCATION "Client based Geolocation" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_DATABASE "Enable database" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_DATALIST "Enable datalist" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_DETAILS "Enable details element" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_DEVICE_ORIENTATION "Enable Device Orientation" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_DOM_STORAGE "Enable DOM storage" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_DRAG_SUPPORT "Enable Drag Support" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_EVENTSOURCE "Enable event source" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_EVENT_MODE_METATAGS "Enable meta-tag touch and mouse events" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_FAST_MOBILE_SCROLLING "Enable fast mobile scrolling" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_FILE_SYSTEM "Enable file system" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_FILTERS "Enable SVG filters" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_FIXED_REPORTED_SIZE "Fixed Reported Size" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_FTPDIR "Enable FTP directory browsing" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_GEOLOCATION "Enable geolocation" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_GLIB_SUPPORT "Enable Glib support" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_GROUP_BASED_DATABASE "Enable Group Based Database support" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_ICONDATABASE "Enable icon database" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_IMAGE_DECODER_DOWN_SAMPLING "Enable image decoder down sampling" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_INDEXED_DATABASE "Enable IndexDB" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_INPUT_COLOR "Enable Color Input" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_INSPECTOR "Enable inspector" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_JAVASCRIPT_DEBUGGER "Enable JavaScript debugger" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_MATHML "Enable MathML" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_METER_TAG "Enable Meter Tag" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_NETSCAPE_PLUGIN_API "Enable Netscape plugin API" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_NOTIFICATIONS "Enable notifications" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_OFFLINE_WEB_APPLICATIONS "Enable offline web applications" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_BLACKBERRY_OBJECT_ALLOCATOR "Enable BlackBerry object allocator" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_ORIENTATION_EVENTS "Enable orientation events" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_PROGRESS_TAG "Enable progress tag" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_REPAINT_THROTTLING "Enable repaint throttling" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_RUBY "Enable Ruby" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_SANDBOX "Enable Sandbox" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_SHARED_WORKERS "Enable shared workers" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_SHADOW_DOM "Enable Shadow DOM" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_SVG "Enable SVG" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_SVG_ANIMATION "Enable SVG animation" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_SVG_AS_IMAGE "Enable SVG as image" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_SVG_FONTS "Enable SVG fonts" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_SVG_FOREIGN_OBJECT "Enable SVG foreign object" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_SVG_USE "Enable SVG use" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_TOUCH_EVENTS "Enable touch events " DEFAULT ON)
WEBKIT_FEATURE(ENABLE_VIDEO "Enable video" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_VIEWPORT_REFLOW "Enable viewport reflow" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_WEB_SOCKETS "Enable web sockets" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_WML "Enable WML" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_WORKERS "Enable workers" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_XHTMLMP "Enable XHTMLMP" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_XPATH "Enable XPath" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_XSLT "Enable XSLT" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_CSS3_FLEXBOX "Enable CSS3 Flexbox" DEFAULT ON)
WEBKIT_FEATURE(ENABLE_PLUGIN_PROXY_FOR_VIDEO "Plugin Proxy for Video" DEFAULT OFF)
WEBKIT_FEATURE(ENABLE_ANIMATION_API "Enable animation API" DEFAULT ON)

IF (ENABLE_DRT)
    WEBKIT_FEATURE(ENABLE_DRT "Enable DRT" DEFAULT ON)
ELSE ()
    WEBKIT_FEATURE(ENABLE_DRT "Enable DRT" DEFAULT OFF)
ENDIF ()

IF (CMAKE_SYSTEM_PROCESSOR MATCHES x86)
    WEBKIT_FEATURE(ENABLE_JIT "Enable JIT" DEFAULT OFF)
    WEBKIT_FEATURE(ENABLE_SKIA_GPU_CANVAS "Enable GPU-backed Skia canvases" DEFAULT OFF)
ELSE ()
    WEBKIT_FEATURE(ENABLE_JIT "Enable JIT" DEFAULT ON)
    WEBKIT_FEATURE(ENABLE_SKIA_GPU_CANVAS "Enable GPU-backed Skia canvases" DEFAULT ON)
ENDIF ()

# Some of our files, such as platform/graphics/chromium/ComplexTextControllerLinux.cpp, require a
# newer ICU version than the version associated with the headers in {WebCore, JavaScriptCore}/icu.
# Because of <https://bugs.webkit.org/show_bug.cgi?id=70913> we can't directly reference these newer
# ICU headers within the QNX system header directory. As a workaround, we copy these newer ICU headers
# from the QNX system header directory to a third-party directory under the CMake binary tree.
#
# FIXME: Make this mechanism more general purpose. Maybe accept a list or directories/files to copy
# instead of individual variables. Generalizing this solution may allow us to fix <https://bugs.webkit.org/show_bug.cgi?id=70913>.
SET(BLACKBERRY_THIRD_PARTY_DIR "${CMAKE_BINARY_DIR}/ThirdPartyBlackBerry")
FILE(COPY ${THIRD_PARTY_ICU_DIR} DESTINATION "${BLACKBERRY_THIRD_PARTY_DIR}/icu")
FILE(COPY ${THIRD_PARTY_UNICODE_FILE} DESTINATION ${BLACKBERRY_THIRD_PARTY_DIR})
