# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'includes': [
    '../../build/win_precompile.gypi',
  ],
  'targets': [
    {
      'target_name': 'harfbuzz-ng',
      'type': 'static_library',
      'defines': [
        'HAVE_OT',
        'HAVE_ICU',
      ],
      'sources': [
        'src/hb-blob.cc',
        'src/hb-blob.h',
        'src/hb-buffer-private.hh',
        'src/hb-buffer.cc',
        'src/hb-buffer.h',
        'src/hb-common.cc',
        'src/hb-common.h',
        'src/hb-fallback-shape-private.hh',
        'src/hb-fallback-shape.cc',
        'src/hb-font-private.hh',
        'src/hb-font.cc',
        'src/hb-font.h',
        'src/hb-glib.cc',
        'src/hb-glib.h',
        'src/hb-gobject-enums.cc',
        'src/hb-gobject-structs.cc',
        'src/hb-gobject.h',
        'src/hb-icu.cc',
        'src/hb-icu.h',
        'src/hb-mutex-private.hh',
        'src/hb-object-private.hh',
        'src/hb-open-file-private.hh',
        'src/hb-open-type-private.hh',
        'src/hb-ot-head-table.hh',
        'src/hb-ot-hhea-table.hh',
        'src/hb-ot-hmtx-table.hh',
        'src/hb-ot-layout-common-private.hh',
        'src/hb-ot-layout-gdef-table.hh',
        'src/hb-ot-layout-gpos-table.hh',
        'src/hb-ot-layout-gsub-table.hh',
        'src/hb-ot-layout-gsubgpos-private.hh',
        'src/hb-ot-layout-private.hh',
        'src/hb-ot-layout.cc',
        'src/hb-ot-layout.h',
        'src/hb-ot-map-private.hh',
        'src/hb-ot-map.cc',
        'src/hb-ot-maxp-table.hh',
        'src/hb-ot-name-table.hh',
        'src/hb-ot-shape-complex-arabic-table.hh',
        'src/hb-ot-shape-complex-arabic.cc',
        'src/hb-ot-shape-complex-indic-machine.hh',
        'src/hb-ot-shape-complex-indic-table.hh',
        'src/hb-ot-shape-complex-indic.cc',
        'src/hb-ot-shape-complex-misc.cc',
        'src/hb-ot-shape-complex-private.hh',
        'src/hb-ot-shape-normalize.cc',
        'src/hb-ot-shape-private.hh',
        'src/hb-ot-shape.cc',
        'src/hb-ot-shape.h',
        'src/hb-ot-tag.cc',
        'src/hb-ot-tag.h',
        'src/hb-ot.h',
        'src/hb-private.hh',
        'src/hb-shape.cc',
        'src/hb-shape.h',
        'src/hb-tt-font.cc',
        'src/hb-unicode-private.hh',
        'src/hb-unicode.cc',
        'src/hb-unicode.h',
        'src/hb-version.h',
        'src/hb.h',
      ],
      'sources/': [
        ['exclude', 'src/hb-glib\\.(cc|h)$'],
        ['exclude', 'src/hb-gobject.*\\.(cc|h)$'],
      ],
      'include_dirs': [
        'src',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          'src',
        ],
      },
      'dependencies': [
        '../../third_party/icu/icu.gyp:icuuc',
      ],
      'conditions': [
        ['use_glib == 1', {
          'defines': [
            'HAVE_GLIB',
          ],
          'sources/': [
            ['include', 'src/hb-glib\\.(cc|h)$'],
            ['include', 'src/hb-gobject.*\\.(cc|h)$'],
          ],
          'dependencies': [
            '../../base/base.gyp:base',
          ],
        }],
      ],
    },
  ],
}
