#!/usr/bin/env sh
set -u

LC_ALL=C
export LC_ALL

to_classname() {
	j=${1#?}
	printf '%s' "${1%$j}" | tr 'a-z' 'A-Z'
	echo "${j}Cache"
}

cache_plain='sqlite'
cache_stars=$cache_plain
cache_vary='eix metadata'
cache_includes="parse eixcache metadata $cache_plain"

cat<<END
// AUTOGENERATED BY MAKE .. DO NOT EDIT!
// This file is part of the eix project and distributed under the
// terms of the GNU General Public License v2.
//
// Copyright (c)
//   Wolfgang Frisch <xororand@users.sourceforge.net>
//   Emil Beinroth <emilbeinroth@gmx.net>
//   Martin Väth <martin@mvath.de>

#include <config.h>

#include <string>

#include "cache/cache_map.h"
#include "eixTk/null.h"
END

for cache_name in $cache_includes
do	cat<<END
#include "cache/$cache_name/$cache_name.h"
END
done

cat<<END

class BasicCache;

using std::string;

BasicCache *get_cache(const string& name, const string& appending) {
END

for cache_name in $cache_plain
do	cache_class=`to_classname "$cache_name"`
	cat<<END
	if(name == "$cache_name") {
		return new $cache_class;
	}
END
done
for cache_name in $cache_stars
do	cache_class=`to_classname "$cache_name"`
	cat<<END
	if(name == "$cache_name*") {
		return new $cache_class(true);
	}
END
done
cat<<END
	{  // NOLINT(whitespace/braces)
		ParseCache *p(new ParseCache);
		if(p->initialize(name + appending)) {
			return p;
		}
		delete p;
	}
END
for cache_name in $cache_vary
do	cache_class=`to_classname "$cache_name"`
	cat<<END
	{  // NOLINT(whitespace/braces)
		$cache_class *p(new $cache_class);
		if(p->initialize(name)) {
			return p;
		}
		delete p;
	}
END
done
cat <<END
	return NULLPTR;
}
END
