/* Generated by  */

#ifndef FREERDP_CORE_SETTINGS_STR_H
#define FREERDP_CORE_SETTINGS_STR_H

#include "../core/settings.h"

#include <freerdp/settings.h>
#include <freerdp/log.h>

#define TAG FREERDP_TAG("common.settings")

typedef enum
{
	FREERDP_SETTINGS_TYPE_BOOL,
	FREERDP_SETTINGS_TYPE_UINT16,
	FREERDP_SETTINGS_TYPE_INT16,
	FREERDP_SETTINGS_TYPE_UINT32,
	FREERDP_SETTINGS_TYPE_INT32,
	FREERDP_SETTINGS_TYPE_UINT64,
	FREERDP_SETTINGS_TYPE_INT64,
	FREERDP_SETTINGS_TYPE_STRING,
	FREERDP_SETTINGS_TYPE_POINTER
} FREERDP_SETTINGS_TYPE;

struct settings_str_entry
{
	SSIZE_T id;
	SSIZE_T type;
	const char* str;
};
static const struct settings_str_entry settings_map[] = {
	{ FreeRDP_AadSecurity, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AadSecurity" },
	{ FreeRDP_AllowCacheWaitingList, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AllowCacheWaitingList" },
	{ FreeRDP_AllowDesktopComposition, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_AllowDesktopComposition" },
	{ FreeRDP_AllowFontSmoothing, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AllowFontSmoothing" },
	{ FreeRDP_AllowUnanouncedOrdersFromServer, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_AllowUnanouncedOrdersFromServer" },
	{ FreeRDP_AltSecFrameMarkerSupport, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_AltSecFrameMarkerSupport" },
	{ FreeRDP_AsyncChannels, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AsyncChannels" },
	{ FreeRDP_AsyncUpdate, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AsyncUpdate" },
	{ FreeRDP_AudioCapture, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AudioCapture" },
	{ FreeRDP_AudioPlayback, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AudioPlayback" },
	{ FreeRDP_Authentication, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_Authentication" },
	{ FreeRDP_AuthenticationOnly, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AuthenticationOnly" },
	{ FreeRDP_AutoAcceptCertificate, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AutoAcceptCertificate" },
	{ FreeRDP_AutoDenyCertificate, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AutoDenyCertificate" },
	{ FreeRDP_AutoLogonEnabled, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_AutoLogonEnabled" },
	{ FreeRDP_AutoReconnectionEnabled, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_AutoReconnectionEnabled" },
	{ FreeRDP_BitmapCacheEnabled, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_BitmapCacheEnabled" },
	{ FreeRDP_BitmapCachePersistEnabled, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_BitmapCachePersistEnabled" },
	{ FreeRDP_BitmapCacheV3Enabled, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_BitmapCacheV3Enabled" },
	{ FreeRDP_BitmapCompressionDisabled, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_BitmapCompressionDisabled" },
	{ FreeRDP_CertificateCallbackPreferPEM, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_CertificateCallbackPreferPEM" },
	{ FreeRDP_CompressionEnabled, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_CompressionEnabled" },
	{ FreeRDP_ConnectChildSession, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_ConnectChildSession" },
	{ FreeRDP_ConsoleSession, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_ConsoleSession" },
	{ FreeRDP_CredentialsFromStdin, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_CredentialsFromStdin" },
	{ FreeRDP_DeactivateClientDecoding, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_DeactivateClientDecoding" },
	{ FreeRDP_Decorations, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_Decorations" },
	{ FreeRDP_DesktopResize, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DesktopResize" },
	{ FreeRDP_DeviceRedirection, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DeviceRedirection" },
	{ FreeRDP_DisableCredentialsDelegation, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_DisableCredentialsDelegation" },
	{ FreeRDP_DisableCtrlAltDel, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DisableCtrlAltDel" },
	{ FreeRDP_DisableCursorBlinking, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DisableCursorBlinking" },
	{ FreeRDP_DisableCursorShadow, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DisableCursorShadow" },
	{ FreeRDP_DisableFullWindowDrag, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DisableFullWindowDrag" },
	{ FreeRDP_DisableMenuAnims, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DisableMenuAnims" },
	{ FreeRDP_DisableRemoteAppCapsCheck, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_DisableRemoteAppCapsCheck" },
	{ FreeRDP_DisableThemes, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DisableThemes" },
	{ FreeRDP_DisableWallpaper, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DisableWallpaper" },
	{ FreeRDP_DrawAllowColorSubsampling, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_DrawAllowColorSubsampling" },
	{ FreeRDP_DrawAllowDynamicColorFidelity, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_DrawAllowDynamicColorFidelity" },
	{ FreeRDP_DrawAllowSkipAlpha, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DrawAllowSkipAlpha" },
	{ FreeRDP_DrawGdiPlusCacheEnabled, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_DrawGdiPlusCacheEnabled" },
	{ FreeRDP_DrawGdiPlusEnabled, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DrawGdiPlusEnabled" },
	{ FreeRDP_DrawNineGridEnabled, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DrawNineGridEnabled" },
	{ FreeRDP_DumpRemoteFx, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_DumpRemoteFx" },
	{ FreeRDP_DynamicDaylightTimeDisabled, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_DynamicDaylightTimeDisabled" },
	{ FreeRDP_DynamicResolutionUpdate, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_DynamicResolutionUpdate" },
	{ FreeRDP_EmbeddedWindow, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_EmbeddedWindow" },
	{ FreeRDP_EnableWindowsKey, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_EnableWindowsKey" },
	{ FreeRDP_EncomspVirtualChannel, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_EncomspVirtualChannel" },
	{ FreeRDP_ExtSecurity, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_ExtSecurity" },
	{ FreeRDP_ExternalCertificateManagement, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_ExternalCertificateManagement" },
	{ FreeRDP_FIPSMode, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_FIPSMode" },
	{ FreeRDP_FastPathInput, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_FastPathInput" },
	{ FreeRDP_FastPathOutput, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_FastPathOutput" },
	{ FreeRDP_ForceEncryptedCsPdu, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_ForceEncryptedCsPdu" },
	{ FreeRDP_ForceMultimon, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_ForceMultimon" },
	{ FreeRDP_FrameMarkerCommandEnabled, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_FrameMarkerCommandEnabled" },
	{ FreeRDP_Fullscreen, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_Fullscreen" },
	{ FreeRDP_GatewayArmTransport, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GatewayArmTransport" },
	{ FreeRDP_GatewayBypassLocal, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GatewayBypassLocal" },
	{ FreeRDP_GatewayEnabled, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GatewayEnabled" },
	{ FreeRDP_GatewayHttpExtAuthSspiNtlm, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_GatewayHttpExtAuthSspiNtlm" },
	{ FreeRDP_GatewayHttpTransport, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GatewayHttpTransport" },
	{ FreeRDP_GatewayHttpUseWebsockets, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_GatewayHttpUseWebsockets" },
	{ FreeRDP_GatewayIgnoreRedirectionPolicy, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_GatewayIgnoreRedirectionPolicy" },
	{ FreeRDP_GatewayRpcTransport, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GatewayRpcTransport" },
	{ FreeRDP_GatewayUdpTransport, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GatewayUdpTransport" },
	{ FreeRDP_GatewayUseSameCredentials, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_GatewayUseSameCredentials" },
	{ FreeRDP_GfxAVC444, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GfxAVC444" },
	{ FreeRDP_GfxAVC444v2, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GfxAVC444v2" },
	{ FreeRDP_GfxH264, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GfxH264" },
	{ FreeRDP_GfxPlanar, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GfxPlanar" },
	{ FreeRDP_GfxProgressive, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GfxProgressive" },
	{ FreeRDP_GfxProgressiveV2, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GfxProgressiveV2" },
	{ FreeRDP_GfxSendQoeAck, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GfxSendQoeAck" },
	{ FreeRDP_GfxSmallCache, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GfxSmallCache" },
	{ FreeRDP_GfxThinClient, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GfxThinClient" },
	{ FreeRDP_GrabKeyboard, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GrabKeyboard" },
	{ FreeRDP_GrabMouse, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_GrabMouse" },
	{ FreeRDP_HasExtendedMouseEvent, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_HasExtendedMouseEvent" },
	{ FreeRDP_HasHorizontalWheel, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_HasHorizontalWheel" },
	{ FreeRDP_HasMonitorAttributes, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_HasMonitorAttributes" },
	{ FreeRDP_HasQoeEvent, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_HasQoeEvent" },
	{ FreeRDP_HasRelativeMouseEvent, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_HasRelativeMouseEvent" },
	{ FreeRDP_HiDefRemoteApp, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_HiDefRemoteApp" },
	{ FreeRDP_IPv6Enabled, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_IPv6Enabled" },
	{ FreeRDP_IgnoreCertificate, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_IgnoreCertificate" },
	{ FreeRDP_IgnoreInvalidDevices, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_IgnoreInvalidDevices" },
	{ FreeRDP_JpegCodec, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_JpegCodec" },
	{ FreeRDP_KerberosRdgIsProxy, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_KerberosRdgIsProxy" },
	{ FreeRDP_ListMonitors, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_ListMonitors" },
	{ FreeRDP_LocalConnection, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_LocalConnection" },
	{ FreeRDP_LogonErrors, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_LogonErrors" },
	{ FreeRDP_LogonNotify, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_LogonNotify" },
	{ FreeRDP_LongCredentialsSupported, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_LongCredentialsSupported" },
	{ FreeRDP_LyncRdpMode, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_LyncRdpMode" },
	{ FreeRDP_MaximizeShell, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_MaximizeShell" },
	{ FreeRDP_MouseAttached, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_MouseAttached" },
	{ FreeRDP_MouseHasWheel, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_MouseHasWheel" },
	{ FreeRDP_MouseMotion, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_MouseMotion" },
	{ FreeRDP_MouseUseRelativeMove, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_MouseUseRelativeMove" },
	{ FreeRDP_MstscCookieMode, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_MstscCookieMode" },
	{ FreeRDP_MultiTouchGestures, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_MultiTouchGestures" },
	{ FreeRDP_MultiTouchInput, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_MultiTouchInput" },
	{ FreeRDP_NSCodec, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_NSCodec" },
	{ FreeRDP_NSCodecAllowDynamicColorFidelity, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_NSCodecAllowDynamicColorFidelity" },
	{ FreeRDP_NSCodecAllowSubsampling, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_NSCodecAllowSubsampling" },
	{ FreeRDP_NegotiateSecurityLayer, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_NegotiateSecurityLayer" },
	{ FreeRDP_NetworkAutoDetect, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_NetworkAutoDetect" },
	{ FreeRDP_NlaSecurity, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_NlaSecurity" },
	{ FreeRDP_NoBitmapCompressionHeader, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_NoBitmapCompressionHeader" },
	{ FreeRDP_OldLicenseBehaviour, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_OldLicenseBehaviour" },
	{ FreeRDP_PasswordIsSmartcardPin, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_PasswordIsSmartcardPin" },
	{ FreeRDP_PercentScreenUseHeight, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_PercentScreenUseHeight" },
	{ FreeRDP_PercentScreenUseWidth, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_PercentScreenUseWidth" },
	{ FreeRDP_PlayRemoteFx, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_PlayRemoteFx" },
	{ FreeRDP_PreferIPv6OverIPv4, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_PreferIPv6OverIPv4" },
	{ FreeRDP_PrintReconnectCookie, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_PrintReconnectCookie" },
	{ FreeRDP_PromptForCredentials, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_PromptForCredentials" },
	{ FreeRDP_RdpSecurity, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RdpSecurity" },
	{ FreeRDP_RdstlsSecurity, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RdstlsSecurity" },
	{ FreeRDP_RedirectClipboard, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RedirectClipboard" },
	{ FreeRDP_RedirectDrives, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RedirectDrives" },
	{ FreeRDP_RedirectHomeDrive, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RedirectHomeDrive" },
	{ FreeRDP_RedirectParallelPorts, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RedirectParallelPorts" },
	{ FreeRDP_RedirectPrinters, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RedirectPrinters" },
	{ FreeRDP_RedirectSerialPorts, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RedirectSerialPorts" },
	{ FreeRDP_RedirectSmartCards, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RedirectSmartCards" },
	{ FreeRDP_RedirectWebAuthN, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RedirectWebAuthN" },
	{ FreeRDP_RefreshRect, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RefreshRect" },
	{ FreeRDP_RemdeskVirtualChannel, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RemdeskVirtualChannel" },
	{ FreeRDP_RemoteAppLanguageBarSupported, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_RemoteAppLanguageBarSupported" },
	{ FreeRDP_RemoteApplicationMode, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RemoteApplicationMode" },
	{ FreeRDP_RemoteAssistanceMode, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RemoteAssistanceMode" },
	{ FreeRDP_RemoteAssistanceRequestControl, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_RemoteAssistanceRequestControl" },
	{ FreeRDP_RemoteConsoleAudio, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RemoteConsoleAudio" },
	{ FreeRDP_RemoteCredentialGuard, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RemoteCredentialGuard" },
	{ FreeRDP_RemoteFxCodec, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RemoteFxCodec" },
	{ FreeRDP_RemoteFxImageCodec, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RemoteFxImageCodec" },
	{ FreeRDP_RemoteFxOnly, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_RemoteFxOnly" },
	{ FreeRDP_RestrictedAdminModeRequired, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_RestrictedAdminModeRequired" },
	{ FreeRDP_SaltedChecksum, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SaltedChecksum" },
	{ FreeRDP_SendPreconnectionPdu, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SendPreconnectionPdu" },
	{ FreeRDP_ServerLicenseRequired, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_ServerLicenseRequired" },
	{ FreeRDP_ServerMode, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_ServerMode" },
	{ FreeRDP_SmartSizing, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SmartSizing" },
	{ FreeRDP_SmartcardEmulation, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SmartcardEmulation" },
	{ FreeRDP_SmartcardLogon, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SmartcardLogon" },
	{ FreeRDP_SoftwareGdi, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SoftwareGdi" },
	{ FreeRDP_SoundBeepsEnabled, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SoundBeepsEnabled" },
	{ FreeRDP_SpanMonitors, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SpanMonitors" },
	{ FreeRDP_SupportAsymetricKeys, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SupportAsymetricKeys" },
	{ FreeRDP_SupportDisplayControl, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SupportDisplayControl" },
	{ FreeRDP_SupportDynamicChannels, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SupportDynamicChannels" },
	{ FreeRDP_SupportDynamicTimeZone, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SupportDynamicTimeZone" },
	{ FreeRDP_SupportEchoChannel, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SupportEchoChannel" },
	{ FreeRDP_SupportEdgeActionV1, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SupportEdgeActionV1" },
	{ FreeRDP_SupportEdgeActionV2, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SupportEdgeActionV2" },
	{ FreeRDP_SupportErrorInfoPdu, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SupportErrorInfoPdu" },
	{ FreeRDP_SupportGeometryTracking, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SupportGeometryTracking" },
	{ FreeRDP_SupportGraphicsPipeline, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SupportGraphicsPipeline" },
	{ FreeRDP_SupportHeartbeatPdu, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SupportHeartbeatPdu" },
	{ FreeRDP_SupportMonitorLayoutPdu, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SupportMonitorLayoutPdu" },
	{ FreeRDP_SupportMultitransport, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SupportMultitransport" },
	{ FreeRDP_SupportSSHAgentChannel, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SupportSSHAgentChannel" },
	{ FreeRDP_SupportSkipChannelJoin, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SupportSkipChannelJoin" },
	{ FreeRDP_SupportStatusInfoPdu, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SupportStatusInfoPdu" },
	{ FreeRDP_SupportVideoOptimized, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SupportVideoOptimized" },
	{ FreeRDP_SuppressOutput, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SuppressOutput" },
	{ FreeRDP_SurfaceCommandsEnabled, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SurfaceCommandsEnabled" },
	{ FreeRDP_SurfaceFrameMarkerEnabled, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SurfaceFrameMarkerEnabled" },
	{ FreeRDP_SuspendInput, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_SuspendInput" },
	{ FreeRDP_SynchronousDynamicChannels, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SynchronousDynamicChannels" },
	{ FreeRDP_SynchronousStaticChannels, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_SynchronousStaticChannels" },
	{ FreeRDP_TcpKeepAlive, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_TcpKeepAlive" },
	{ FreeRDP_TlsSecurity, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_TlsSecurity" },
	{ FreeRDP_ToggleFullscreen, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_ToggleFullscreen" },
	{ FreeRDP_TransportDump, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_TransportDump" },
	{ FreeRDP_TransportDumpReplay, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_TransportDumpReplay" },
	{ FreeRDP_UnicodeInput, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_UnicodeInput" },
	{ FreeRDP_UnmapButtons, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_UnmapButtons" },
	{ FreeRDP_UseCommonStdioCallbacks, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_UseCommonStdioCallbacks" },
	{ FreeRDP_UseMultimon, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_UseMultimon" },
	{ FreeRDP_UseRdpSecurityLayer, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_UseRdpSecurityLayer" },
	{ FreeRDP_UsingSavedCredentials, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_UsingSavedCredentials" },
	{ FreeRDP_VideoDisable, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_VideoDisable" },
	{ FreeRDP_VmConnectMode, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_VmConnectMode" },
	{ FreeRDP_WaitForOutputBufferFlush, FREERDP_SETTINGS_TYPE_BOOL,
	  "FreeRDP_WaitForOutputBufferFlush" },
	{ FreeRDP_Workarea, FREERDP_SETTINGS_TYPE_BOOL, "FreeRDP_Workarea" },
	{ FreeRDP_CapsGeneralCompressionLevel, FREERDP_SETTINGS_TYPE_UINT16,
	  "FreeRDP_CapsGeneralCompressionLevel" },
	{ FreeRDP_CapsGeneralCompressionTypes, FREERDP_SETTINGS_TYPE_UINT16,
	  "FreeRDP_CapsGeneralCompressionTypes" },
	{ FreeRDP_CapsProtocolVersion, FREERDP_SETTINGS_TYPE_UINT16, "FreeRDP_CapsProtocolVersion" },
	{ FreeRDP_CapsRemoteUnshareFlag, FREERDP_SETTINGS_TYPE_UINT16,
	  "FreeRDP_CapsRemoteUnshareFlag" },
	{ FreeRDP_CapsUpdateCapabilityFlag, FREERDP_SETTINGS_TYPE_UINT16,
	  "FreeRDP_CapsUpdateCapabilityFlag" },
	{ FreeRDP_DesktopOrientation, FREERDP_SETTINGS_TYPE_UINT16, "FreeRDP_DesktopOrientation" },
	{ FreeRDP_OrderSupportFlags, FREERDP_SETTINGS_TYPE_UINT16, "FreeRDP_OrderSupportFlags" },
	{ FreeRDP_OrderSupportFlagsEx, FREERDP_SETTINGS_TYPE_UINT16, "FreeRDP_OrderSupportFlagsEx" },
	{ FreeRDP_ProxyPort, FREERDP_SETTINGS_TYPE_UINT16, "FreeRDP_ProxyPort" },
	{ FreeRDP_SupportedColorDepths, FREERDP_SETTINGS_TYPE_UINT16, "FreeRDP_SupportedColorDepths" },
	{ FreeRDP_TLSMaxVersion, FREERDP_SETTINGS_TYPE_UINT16, "FreeRDP_TLSMaxVersion" },
	{ FreeRDP_TLSMinVersion, FREERDP_SETTINGS_TYPE_UINT16, "FreeRDP_TLSMinVersion" },
	{ FreeRDP_TextANSICodePage, FREERDP_SETTINGS_TYPE_UINT16, "FreeRDP_TextANSICodePage" },
	{ FreeRDP_AcceptedCertLength, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_AcceptedCertLength" },
	{ FreeRDP_AuthenticationLevel, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_AuthenticationLevel" },
	{ FreeRDP_AutoReconnectMaxRetries, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_AutoReconnectMaxRetries" },
	{ FreeRDP_BitmapCacheV2NumCells, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_BitmapCacheV2NumCells" },
	{ FreeRDP_BitmapCacheV3CodecId, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_BitmapCacheV3CodecId" },
	{ FreeRDP_BitmapCacheVersion, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_BitmapCacheVersion" },
	{ FreeRDP_BrushSupportLevel, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_BrushSupportLevel" },
	{ FreeRDP_ChannelCount, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ChannelCount" },
	{ FreeRDP_ChannelDefArraySize, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ChannelDefArraySize" },
	{ FreeRDP_ClientBuild, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ClientBuild" },
	{ FreeRDP_ClientRandomLength, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ClientRandomLength" },
	{ FreeRDP_ClientSessionId, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ClientSessionId" },
	{ FreeRDP_ClipboardFeatureMask, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ClipboardFeatureMask" },
	{ FreeRDP_ClusterInfoFlags, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ClusterInfoFlags" },
	{ FreeRDP_ColorDepth, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ColorDepth" },
	{ FreeRDP_ColorPointerCacheSize, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_ColorPointerCacheSize" },
	{ FreeRDP_CompDeskSupportLevel, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_CompDeskSupportLevel" },
	{ FreeRDP_CompressionLevel, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_CompressionLevel" },
	{ FreeRDP_ConnectionType, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ConnectionType" },
	{ FreeRDP_CookieMaxLength, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_CookieMaxLength" },
	{ FreeRDP_DesktopHeight, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_DesktopHeight" },
	{ FreeRDP_DesktopPhysicalHeight, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_DesktopPhysicalHeight" },
	{ FreeRDP_DesktopPhysicalWidth, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_DesktopPhysicalWidth" },
	{ FreeRDP_DesktopPosX, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_DesktopPosX" },
	{ FreeRDP_DesktopPosY, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_DesktopPosY" },
	{ FreeRDP_DesktopScaleFactor, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_DesktopScaleFactor" },
	{ FreeRDP_DesktopWidth, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_DesktopWidth" },
	{ FreeRDP_DeviceArraySize, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_DeviceArraySize" },
	{ FreeRDP_DeviceCount, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_DeviceCount" },
	{ FreeRDP_DeviceScaleFactor, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_DeviceScaleFactor" },
	{ FreeRDP_DrawNineGridCacheEntries, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_DrawNineGridCacheEntries" },
	{ FreeRDP_DrawNineGridCacheSize, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_DrawNineGridCacheSize" },
	{ FreeRDP_DynamicChannelArraySize, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_DynamicChannelArraySize" },
	{ FreeRDP_DynamicChannelCount, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_DynamicChannelCount" },
	{ FreeRDP_EarlyCapabilityFlags, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_EarlyCapabilityFlags" },
	{ FreeRDP_EncryptionLevel, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_EncryptionLevel" },
	{ FreeRDP_EncryptionMethods, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_EncryptionMethods" },
	{ FreeRDP_ExtEncryptionMethods, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ExtEncryptionMethods" },
	{ FreeRDP_FakeMouseMotionInterval, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_FakeMouseMotionInterval" },
	{ FreeRDP_Floatbar, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_Floatbar" },
	{ FreeRDP_FrameAcknowledge, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_FrameAcknowledge" },
	{ FreeRDP_GatewayAcceptedCertLength, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_GatewayAcceptedCertLength" },
	{ FreeRDP_GatewayCredentialsSource, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_GatewayCredentialsSource" },
	{ FreeRDP_GatewayPort, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_GatewayPort" },
	{ FreeRDP_GatewayUsageMethod, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_GatewayUsageMethod" },
	{ FreeRDP_GfxCapsFilter, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_GfxCapsFilter" },
	{ FreeRDP_GlyphSupportLevel, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_GlyphSupportLevel" },
	{ FreeRDP_JpegCodecId, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_JpegCodecId" },
	{ FreeRDP_JpegQuality, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_JpegQuality" },
	{ FreeRDP_KeySpec, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_KeySpec" },
	{ FreeRDP_KeyboardCodePage, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_KeyboardCodePage" },
	{ FreeRDP_KeyboardFunctionKey, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_KeyboardFunctionKey" },
	{ FreeRDP_KeyboardHook, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_KeyboardHook" },
	{ FreeRDP_KeyboardLayout, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_KeyboardLayout" },
	{ FreeRDP_KeyboardSubType, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_KeyboardSubType" },
	{ FreeRDP_KeyboardType, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_KeyboardType" },
	{ FreeRDP_LargePointerFlag, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_LargePointerFlag" },
	{ FreeRDP_LoadBalanceInfoLength, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_LoadBalanceInfoLength" },
	{ FreeRDP_MonitorAttributeFlags, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_MonitorAttributeFlags" },
	{ FreeRDP_MonitorCount, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_MonitorCount" },
	{ FreeRDP_MonitorDefArraySize, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_MonitorDefArraySize" },
	{ FreeRDP_MonitorFlags, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_MonitorFlags" },
	{ FreeRDP_MonitorLocalShiftX, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_MonitorLocalShiftX" },
	{ FreeRDP_MonitorLocalShiftY, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_MonitorLocalShiftY" },
	{ FreeRDP_MultifragMaxRequestSize, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_MultifragMaxRequestSize" },
	{ FreeRDP_MultitransportFlags, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_MultitransportFlags" },
	{ FreeRDP_NSCodecColorLossLevel, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_NSCodecColorLossLevel" },
	{ FreeRDP_NSCodecId, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_NSCodecId" },
	{ FreeRDP_NegotiationFlags, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_NegotiationFlags" },
	{ FreeRDP_NumMonitorIds, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_NumMonitorIds" },
	{ FreeRDP_OffscreenCacheEntries, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_OffscreenCacheEntries" },
	{ FreeRDP_OffscreenCacheSize, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_OffscreenCacheSize" },
	{ FreeRDP_OffscreenSupportLevel, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_OffscreenSupportLevel" },
	{ FreeRDP_OsMajorType, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_OsMajorType" },
	{ FreeRDP_OsMinorType, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_OsMinorType" },
	{ FreeRDP_Password51Length, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_Password51Length" },
	{ FreeRDP_PduSource, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_PduSource" },
	{ FreeRDP_PercentScreen, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_PercentScreen" },
	{ FreeRDP_PerformanceFlags, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_PerformanceFlags" },
	{ FreeRDP_PointerCacheSize, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_PointerCacheSize" },
	{ FreeRDP_PreconnectionId, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_PreconnectionId" },
	{ FreeRDP_ProxyType, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ProxyType" },
	{ FreeRDP_RdpVersion, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_RdpVersion" },
	{ FreeRDP_ReceivedCapabilitiesSize, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_ReceivedCapabilitiesSize" },
	{ FreeRDP_RedirectedSessionId, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_RedirectedSessionId" },
	{ FreeRDP_RedirectionAcceptedCertLength, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RedirectionAcceptedCertLength" },
	{ FreeRDP_RedirectionFlags, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_RedirectionFlags" },
	{ FreeRDP_RedirectionGuidLength, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RedirectionGuidLength" },
	{ FreeRDP_RedirectionPasswordLength, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RedirectionPasswordLength" },
	{ FreeRDP_RedirectionPreferType, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RedirectionPreferType" },
	{ FreeRDP_RedirectionTsvUrlLength, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RedirectionTsvUrlLength" },
	{ FreeRDP_RemoteAppNumIconCacheEntries, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RemoteAppNumIconCacheEntries" },
	{ FreeRDP_RemoteAppNumIconCaches, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RemoteAppNumIconCaches" },
	{ FreeRDP_RemoteApplicationExpandCmdLine, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RemoteApplicationExpandCmdLine" },
	{ FreeRDP_RemoteApplicationExpandWorkingDir, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RemoteApplicationExpandWorkingDir" },
	{ FreeRDP_RemoteApplicationSupportLevel, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RemoteApplicationSupportLevel" },
	{ FreeRDP_RemoteApplicationSupportMask, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RemoteApplicationSupportMask" },
	{ FreeRDP_RemoteFxCaptureFlags, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_RemoteFxCaptureFlags" },
	{ FreeRDP_RemoteFxCodecId, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_RemoteFxCodecId" },
	{ FreeRDP_RemoteFxCodecMode, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_RemoteFxCodecMode" },
	{ FreeRDP_RemoteWndSupportLevel, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_RemoteWndSupportLevel" },
	{ FreeRDP_RequestedProtocols, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_RequestedProtocols" },
	{ FreeRDP_SelectedProtocol, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_SelectedProtocol" },
	{ FreeRDP_ServerCertificateLength, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_ServerCertificateLength" },
	{ FreeRDP_ServerLicenseProductIssuersCount, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_ServerLicenseProductIssuersCount" },
	{ FreeRDP_ServerLicenseProductVersion, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_ServerLicenseProductVersion" },
	{ FreeRDP_ServerPort, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ServerPort" },
	{ FreeRDP_ServerRandomLength, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ServerRandomLength" },
	{ FreeRDP_ShareId, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ShareId" },
	{ FreeRDP_SmartSizingHeight, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_SmartSizingHeight" },
	{ FreeRDP_SmartSizingWidth, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_SmartSizingWidth" },
	{ FreeRDP_StaticChannelArraySize, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_StaticChannelArraySize" },
	{ FreeRDP_StaticChannelCount, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_StaticChannelCount" },
	{ FreeRDP_TargetNetAddressCount, FREERDP_SETTINGS_TYPE_UINT32,
	  "FreeRDP_TargetNetAddressCount" },
	{ FreeRDP_TcpAckTimeout, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_TcpAckTimeout" },
	{ FreeRDP_TcpConnectTimeout, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_TcpConnectTimeout" },
	{ FreeRDP_TcpKeepAliveDelay, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_TcpKeepAliveDelay" },
	{ FreeRDP_TcpKeepAliveInterval, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_TcpKeepAliveInterval" },
	{ FreeRDP_TcpKeepAliveRetries, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_TcpKeepAliveRetries" },
	{ FreeRDP_ThreadingFlags, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_ThreadingFlags" },
	{ FreeRDP_TlsSecLevel, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_TlsSecLevel" },
	{ FreeRDP_VCChunkSize, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_VCChunkSize" },
	{ FreeRDP_VCFlags, FREERDP_SETTINGS_TYPE_UINT32, "FreeRDP_VCFlags" },
	{ FreeRDP_XPan, FREERDP_SETTINGS_TYPE_INT32, "FreeRDP_XPan" },
	{ FreeRDP_YPan, FREERDP_SETTINGS_TYPE_INT32, "FreeRDP_YPan" },
	{ FreeRDP_ParentWindowId, FREERDP_SETTINGS_TYPE_UINT64, "FreeRDP_ParentWindowId" },
	{ FreeRDP_AadServerHostname, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_AadServerHostname" },
	{ FreeRDP_AcceptedCert, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_AcceptedCert" },
	{ FreeRDP_ActionScript, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ActionScript" },
	{ FreeRDP_AllowedTlsCiphers, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_AllowedTlsCiphers" },
	{ FreeRDP_AlternateShell, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_AlternateShell" },
	{ FreeRDP_AssistanceFile, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_AssistanceFile" },
	{ FreeRDP_AuthenticationPackageList, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_AuthenticationPackageList" },
	{ FreeRDP_AuthenticationServiceClass, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_AuthenticationServiceClass" },
	{ FreeRDP_BitmapCachePersistFile, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_BitmapCachePersistFile" },
	{ FreeRDP_CardName, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_CardName" },
	{ FreeRDP_CertificateAcceptedFingerprints, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_CertificateAcceptedFingerprints" },
	{ FreeRDP_CertificateName, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_CertificateName" },
	{ FreeRDP_ClientAddress, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ClientAddress" },
	{ FreeRDP_ClientDir, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ClientDir" },
	{ FreeRDP_ClientHostname, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ClientHostname" },
	{ FreeRDP_ClientProductId, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ClientProductId" },
	{ FreeRDP_ClipboardUseSelection, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_ClipboardUseSelection" },
	{ FreeRDP_ComputerName, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ComputerName" },
	{ FreeRDP_ConfigPath, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ConfigPath" },
	{ FreeRDP_ConnectionFile, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ConnectionFile" },
	{ FreeRDP_ContainerName, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ContainerName" },
	{ FreeRDP_CspName, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_CspName" },
	{ FreeRDP_CurrentPath, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_CurrentPath" },
	{ FreeRDP_Domain, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_Domain" },
	{ FreeRDP_DrivesToRedirect, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_DrivesToRedirect" },
	{ FreeRDP_DumpRemoteFxFile, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_DumpRemoteFxFile" },
	{ FreeRDP_DynamicDSTTimeZoneKeyName, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_DynamicDSTTimeZoneKeyName" },
	{ FreeRDP_GatewayAcceptedCert, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_GatewayAcceptedCert" },
	{ FreeRDP_GatewayAccessToken, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_GatewayAccessToken" },
	{ FreeRDP_GatewayAvdAadtenantid, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_GatewayAvdAadtenantid" },
	{ FreeRDP_GatewayAvdActivityhint, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_GatewayAvdActivityhint" },
	{ FreeRDP_GatewayAvdArmpath, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_GatewayAvdArmpath" },
	{ FreeRDP_GatewayAvdDiagnosticserviceurl, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_GatewayAvdDiagnosticserviceurl" },
	{ FreeRDP_GatewayAvdGeo, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_GatewayAvdGeo" },
	{ FreeRDP_GatewayAvdHubdiscoverygeourl, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_GatewayAvdHubdiscoverygeourl" },
	{ FreeRDP_GatewayAvdWvdEndpointPool, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_GatewayAvdWvdEndpointPool" },
	{ FreeRDP_GatewayDomain, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_GatewayDomain" },
	{ FreeRDP_GatewayHostname, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_GatewayHostname" },
	{ FreeRDP_GatewayHttpExtAuthBearer, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_GatewayHttpExtAuthBearer" },
	{ FreeRDP_GatewayPassword, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_GatewayPassword" },
	{ FreeRDP_GatewayUrl, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_GatewayUrl" },
	{ FreeRDP_GatewayUsername, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_GatewayUsername" },
	{ FreeRDP_HomePath, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_HomePath" },
	{ FreeRDP_ImeFileName, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ImeFileName" },
	{ FreeRDP_KerberosArmor, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_KerberosArmor" },
	{ FreeRDP_KerberosCache, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_KerberosCache" },
	{ FreeRDP_KerberosKdcUrl, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_KerberosKdcUrl" },
	{ FreeRDP_KerberosKeytab, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_KerberosKeytab" },
	{ FreeRDP_KerberosLifeTime, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_KerberosLifeTime" },
	{ FreeRDP_KerberosRealm, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_KerberosRealm" },
	{ FreeRDP_KerberosRenewableLifeTime, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_KerberosRenewableLifeTime" },
	{ FreeRDP_KerberosStartTime, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_KerberosStartTime" },
	{ FreeRDP_KeyboardPipeName, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_KeyboardPipeName" },
	{ FreeRDP_KeyboardRemappingList, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_KeyboardRemappingList" },
	{ FreeRDP_NtlmSamFile, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_NtlmSamFile" },
	{ FreeRDP_Password, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_Password" },
	{ FreeRDP_PasswordHash, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_PasswordHash" },
	{ FreeRDP_Pkcs11Module, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_Pkcs11Module" },
	{ FreeRDP_PkinitAnchors, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_PkinitAnchors" },
	{ FreeRDP_PlayRemoteFxFile, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_PlayRemoteFxFile" },
	{ FreeRDP_PreconnectionBlob, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_PreconnectionBlob" },
	{ FreeRDP_ProxyHostname, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ProxyHostname" },
	{ FreeRDP_ProxyPassword, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ProxyPassword" },
	{ FreeRDP_ProxyUsername, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ProxyUsername" },
	{ FreeRDP_RDP2TCPArgs, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_RDP2TCPArgs" },
	{ FreeRDP_ReaderName, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ReaderName" },
	{ FreeRDP_RedirectionAcceptedCert, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RedirectionAcceptedCert" },
	{ FreeRDP_RedirectionDomain, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_RedirectionDomain" },
	{ FreeRDP_RedirectionTargetFQDN, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RedirectionTargetFQDN" },
	{ FreeRDP_RedirectionTargetNetBiosName, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RedirectionTargetNetBiosName" },
	{ FreeRDP_RedirectionUsername, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_RedirectionUsername" },
	{ FreeRDP_RemoteApplicationCmdLine, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteApplicationCmdLine" },
	{ FreeRDP_RemoteApplicationFile, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteApplicationFile" },
	{ FreeRDP_RemoteApplicationGuid, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteApplicationGuid" },
	{ FreeRDP_RemoteApplicationIcon, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteApplicationIcon" },
	{ FreeRDP_RemoteApplicationName, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteApplicationName" },
	{ FreeRDP_RemoteApplicationProgram, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteApplicationProgram" },
	{ FreeRDP_RemoteApplicationWorkingDir, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteApplicationWorkingDir" },
	{ FreeRDP_RemoteAssistancePassStub, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteAssistancePassStub" },
	{ FreeRDP_RemoteAssistancePassword, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteAssistancePassword" },
	{ FreeRDP_RemoteAssistanceRCTicket, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteAssistanceRCTicket" },
	{ FreeRDP_RemoteAssistanceSessionId, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_RemoteAssistanceSessionId" },
	{ FreeRDP_ServerHostname, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_ServerHostname" },
	{ FreeRDP_ServerLicenseCompanyName, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_ServerLicenseCompanyName" },
	{ FreeRDP_ServerLicenseProductName, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_ServerLicenseProductName" },
	{ FreeRDP_ShellWorkingDirectory, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_ShellWorkingDirectory" },
	{ FreeRDP_SmartcardCertificate, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_SmartcardCertificate" },
	{ FreeRDP_SmartcardPrivateKey, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_SmartcardPrivateKey" },
	{ FreeRDP_SspiModule, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_SspiModule" },
	{ FreeRDP_TargetNetAddress, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_TargetNetAddress" },
	{ FreeRDP_TerminalDescriptor, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_TerminalDescriptor" },
	{ FreeRDP_TlsSecretsFile, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_TlsSecretsFile" },
	{ FreeRDP_TransportDumpFile, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_TransportDumpFile" },
	{ FreeRDP_UserSpecifiedServerName, FREERDP_SETTINGS_TYPE_STRING,
	  "FreeRDP_UserSpecifiedServerName" },
	{ FreeRDP_Username, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_Username" },
	{ FreeRDP_WinSCardModule, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_WinSCardModule" },
	{ FreeRDP_WindowTitle, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_WindowTitle" },
	{ FreeRDP_WmClass, FREERDP_SETTINGS_TYPE_STRING, "FreeRDP_WmClass" },
	{ FreeRDP_BitmapCacheV2CellInfo, FREERDP_SETTINGS_TYPE_POINTER,
	  "FreeRDP_BitmapCacheV2CellInfo" },
	{ FreeRDP_ChannelDefArray, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_ChannelDefArray" },
	{ FreeRDP_ClientAutoReconnectCookie, FREERDP_SETTINGS_TYPE_POINTER,
	  "FreeRDP_ClientAutoReconnectCookie" },
	{ FreeRDP_ClientRandom, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_ClientRandom" },
	{ FreeRDP_ClientTimeZone, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_ClientTimeZone" },
	{ FreeRDP_DeviceArray, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_DeviceArray" },
	{ FreeRDP_DynamicChannelArray, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_DynamicChannelArray" },
	{ FreeRDP_FragCache, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_FragCache" },
	{ FreeRDP_GlyphCache, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_GlyphCache" },
	{ FreeRDP_LoadBalanceInfo, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_LoadBalanceInfo" },
	{ FreeRDP_MonitorDefArray, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_MonitorDefArray" },
	{ FreeRDP_MonitorIds, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_MonitorIds" },
	{ FreeRDP_OrderSupport, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_OrderSupport" },
	{ FreeRDP_Password51, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_Password51" },
	{ FreeRDP_RdpServerCertificate, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_RdpServerCertificate" },
	{ FreeRDP_RdpServerRsaKey, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_RdpServerRsaKey" },
	{ FreeRDP_ReceivedCapabilities, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_ReceivedCapabilities" },
	{ FreeRDP_ReceivedCapabilityData, FREERDP_SETTINGS_TYPE_POINTER,
	  "FreeRDP_ReceivedCapabilityData" },
	{ FreeRDP_ReceivedCapabilityDataSizes, FREERDP_SETTINGS_TYPE_POINTER,
	  "FreeRDP_ReceivedCapabilityDataSizes" },
	{ FreeRDP_RedirectionGuid, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_RedirectionGuid" },
	{ FreeRDP_RedirectionPassword, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_RedirectionPassword" },
	{ FreeRDP_RedirectionTargetCertificate, FREERDP_SETTINGS_TYPE_POINTER,
	  "FreeRDP_RedirectionTargetCertificate" },
	{ FreeRDP_RedirectionTsvUrl, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_RedirectionTsvUrl" },
	{ FreeRDP_ServerAutoReconnectCookie, FREERDP_SETTINGS_TYPE_POINTER,
	  "FreeRDP_ServerAutoReconnectCookie" },
	{ FreeRDP_ServerCertificate, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_ServerCertificate" },
	{ FreeRDP_ServerLicenseProductIssuers, FREERDP_SETTINGS_TYPE_POINTER,
	  "FreeRDP_ServerLicenseProductIssuers" },
	{ FreeRDP_ServerRandom, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_ServerRandom" },
	{ FreeRDP_StaticChannelArray, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_StaticChannelArray" },
	{ FreeRDP_TargetNetAddresses, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_TargetNetAddresses" },
	{ FreeRDP_TargetNetPorts, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_TargetNetPorts" },
	{ FreeRDP_instance, FREERDP_SETTINGS_TYPE_POINTER, "FreeRDP_instance" },
};

#endif
