// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/index.html
// assets/bundle.js

package dashboard

import (
	"crypto/sha256"
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

//nolint:misspell
var _indexHtml = []byte(`<!DOCTYPE html>
<html lang="en" style="height: 100%">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Go Ethereum Dashboard</title>
        <link rel="shortcut icon" type="image/ico" href="https://ethereum.org/favicon.ico" />
        <style>
            ::-webkit-scrollbar {
                width: 16px;
            }
            ::-webkit-scrollbar-thumb {
                background: #212121;
            }
            ::-webkit-scrollbar-corner {
                background: transparent;
            }
        </style>
    </head>
    <body style="height: 100%; margin: 0">
        <div id="dashboard" style="height: 100%"></div>
        <script src="bundle.js"></script>
    </body>
</html>
`)

func indexHtmlBytes() ([]byte, error) {
	return _indexHtml, nil
}

func indexHtml() (*asset, error) {
	bytes, err := indexHtmlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "index.html", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x22, 0xc8, 0x3d, 0x86, 0x2f, 0xb4, 0x6a, 0x1f, 0xda, 0xd, 0x54, 0x14, 0xa3, 0x6e, 0x80, 0x56, 0x28, 0xea, 0x44, 0xcf, 0xf5, 0xf2, 0xe, 0xad, 0x19, 0xf5, 0x93, 0xd6, 0x8d, 0x6d, 0x2f, 0x35}}
	return a, nil
}

//nolint:misspell
var _bundleJs = []byte((((((((((`!function(modules) {
    function __webpack_require__(moduleId) {
        if (installedModules[moduleId]) return installedModules[moduleId].exports;
        var module = installedModules[moduleId] = {
            i: moduleId,
            l: !1,
            exports: {}
        };
        return modules[moduleId].call(module.exports, module, module.exports, __webpack_require__), 
        module.l = !0, module.exports;
    }
    var installedModules = {};
    __webpack_require__.m = modules, __webpack_require__.c = installedModules, __webpack_require__.d = function(exports, name, getter) {
        __webpack_require__.o(exports, name) || Object.defineProperty(exports, name, {
            configurable: !1,
            enumerable: !0,
            get: getter
        });
    }, __webpack_require__.n = function(module) {
        var getter = module && module.__esModule ? function() {
            return module.default;
        } : function() {
            return module;
        };
        return __webpack_require__.d(getter, "a", getter), getter;
    }, __webpack_require__.o = function(object, property) {
        return Object.prototype.hasOwnProperty.call(object, property);
    }, __webpack_require__.p = "", __webpack_require__(__webpack_require__.s = 375);
}([ function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        "production" === process.env.NODE_ENV ? module.exports = __webpack_require__(376) : module.exports = __webpack_require__(377);
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    (function(process) {
        if ("production" !== process.env.NODE_ENV) {
            var REACT_ELEMENT_TYPE = "function" == typeof Symbol && Symbol.for && Symbol.for("react.element") || 60103, isValidElement = function(object) {
                return "object" == typeof object && null !== object && object.$$typeof === REACT_ELEMENT_TYPE;
            };
            module.exports = __webpack_require__(418)(isValidElement, !0);
        } else module.exports = __webpack_require__(419)();
    }).call(exports, __webpack_require__(2));
}, function(module, exports) {
    function defaultSetTimout() {
        throw new Error("setTimeout has not been defined");
    }
    function defaultClearTimeout() {
        throw new Error("clearTimeout has not been defined");
    }
    function runTimeout(fun) {
        if (cachedSetTimeout === setTimeout) return setTimeout(fun, 0);
        if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) return cachedSetTimeout = setTimeout, 
        setTimeout(fun, 0);
        try {
            return cachedSetTimeout(fun, 0);
        } catch (e) {
            try {
                return cachedSetTimeout.call(null, fun, 0);
            } catch (e) {
                return cachedSetTimeout.call(this, fun, 0);
            }
        }
    }
    function runClearTimeout(marker) {
        if (cachedClearTimeout === clearTimeout) return clearTimeout(marker);
        if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) return cachedClearTimeout = clearTimeout, 
        clearTimeout(marker);
        try {
            return cachedClearTimeout(marker);
        } catch (e) {
            try {
                return cachedClearTimeout.call(null, marker);
            } catch (e) {
                return cachedClearTimeout.call(this, marker);
            }
        }
    }
    function cleanUpNextTick() {
        draining && currentQueue && (draining = !1, currentQueue.length ? queue = currentQueue.concat(queue) : queueIndex = -1, 
        queue.length && drainQueue());
    }
    function drainQueue() {
        if (!draining) {
            var timeout = runTimeout(cleanUpNextTick);
            draining = !0;
            for (var len = queue.length; len; ) {
                for (currentQueue = queue, queue = []; ++queueIndex < len; ) currentQueue && currentQueue[queueIndex].run();
                queueIndex = -1, len = queue.length;
            }
            currentQueue = null, draining = !1, runClearTimeout(timeout);
        }
    }
    function Item(fun, array) {
        this.fun = fun, this.array = array;
    }
    function noop() {}
    var cachedSetTimeout, cachedClearTimeout, process = module.exports = {};
    !function() {
        try {
            cachedSetTimeout = "function" == typeof setTimeout ? setTimeout : defaultSetTimout;
        } catch (e) {
            cachedSetTimeout = defaultSetTimout;
        }
        try {
            cachedClearTimeout = "function" == typeof clearTimeout ? clearTimeout : defaultClearTimeout;
        } catch (e) {
            cachedClearTimeout = defaultClearTimeout;
        }
    }();
    var currentQueue, queue = [], draining = !1, queueIndex = -1;
    process.nextTick = function(fun) {
        var args = new Array(arguments.length - 1);
        if (arguments.length > 1) for (var i = 1; i < arguments.length; i++) args[i - 1] = arguments[i];
        queue.push(new Item(fun, args)), 1 !== queue.length || draining || runTimeout(drainQueue);
    }, Item.prototype.run = function() {
        this.fun.apply(null, this.array);
    }, process.title = "browser", process.browser = !0, process.env = {}, process.argv = [], 
    process.version = "", process.versions = {}, process.on = noop, process.addListener = noop, 
    process.once = noop, process.off = noop, process.removeListener = noop, process.removeAllListeners = noop, 
    process.emit = noop, process.prependListener = noop, process.prependOnceListener = noop, 
    process.listeners = function(name) {
        return [];
    }, process.binding = function(name) {
        throw new Error("process.binding is not supported");
    }, process.cwd = function() {
        return "/";
    }, process.chdir = function(dir) {
        throw new Error("process.chdir is not supported");
    }, process.umask = function() {
        return 0;
    };
}, function(module, exports, __webpack_require__) {
    var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;
    !function() {
        "use strict";
        function classNames() {
            for (var classes = [], i = 0; i < arguments.length; i++) {
                var arg = arguments[i];
                if (arg) {
                    var argType = typeof arg;
                    if ("string" === argType || "number" === argType) classes.push(arg); else if (Array.isArray(arg)) classes.push(classNames.apply(null, arg)); else if ("object" === argType) for (var key in arg) hasOwn.call(arg, key) && arg[key] && classes.push(key);
                }
            }
            return classes.join(" ");
        }
        var hasOwn = {}.hasOwnProperty;
        void 0 !== module && module.exports ? module.exports = classNames : (__WEBPACK_AMD_DEFINE_ARRAY__ = [], 
        void 0 !== (__WEBPACK_AMD_DEFINE_RESULT__ = function() {
            return classNames;
        }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    }();
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    __webpack_require__.d(__webpack_exports__, "c", function() {
        return PRESENTATION_ATTRIBUTES;
    }), __webpack_require__.d(__webpack_exports__, "a", function() {
        return EVENT_ATTRIBUTES;
    }), __webpack_require__.d(__webpack_exports__, "d", function() {
        return SCALE_TYPES;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return LEGEND_TYPES;
    }), __webpack_require__.d(__webpack_exports__, "j", function() {
        return getDisplayName;
    }), __webpack_require__.d(__webpack_exports__, "h", function() {
        return findAllByType;
    }), __webpack_require__.d(__webpack_exports__, "i", function() {
        return findChildByType;
    }), __webpack_require__.d(__webpack_exports__, "k", function() {
        return getPresentationAttributes;
    }), __webpack_require__.d(__webpack_exports__, "e", function() {
        return filterEventAttributes;
    }), __webpack_require__.d(__webpack_exports__, "f", function() {
        return filterEventsOfChild;
    }), __webpack_require__.d(__webpack_exports__, "q", function() {
        return validateWidthHeight;
    }), __webpack_require__.d(__webpack_exports__, "n", function() {
        return isSsr;
    }), __webpack_require__.d(__webpack_exports__, "g", function() {
        return filterSvgElements;
    }), __webpack_require__.d(__webpack_exports__, "m", function() {
        return isChildrenEqual;
    }), __webpack_require__.d(__webpack_exports__, "p", function() {
        return renderByOrder;
    }), __webpack_require__.d(__webpack_exports__, "l", function() {
        return getReactEventByType;
    }), __webpack_require__.d(__webpack_exports__, "o", function() {
        return parseChildIndex;
    });
    var __WEBPACK_IMPORTED_MODULE_0_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_1_lodash_isString__ = __webpack_require__(173), __WEBPACK_IMPORTED_MODULE_1_lodash_isString___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isString__), __WEBPACK_IMPORTED_MODULE_2_lodash_isObject__ = __webpack_require__(32), __WEBPACK_IMPORTED_MODULE_2_lodash_isObject___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isObject__), __WEBPACK_IMPORTED_MODULE_3_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_3_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_4_lodash_isArray__ = __webpack_require__(13), __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_lodash_isArray__), __WEBPACK_IMPORTED_MODULE_5_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_5_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_react__), __WEBPACK_IMPORTED_MODULE_6_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_6_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_prop_types__), __WEBPACK_IMPORTED_MODULE_7__DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_8__PureRender__ = __webpack_require__(5), PRESENTATION_ATTRIBUTES = {
        alignmentBaseline: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        angle: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        baselineShift: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        clip: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        clipPath: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        clipRule: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        color: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        colorInterpolation: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        colorInterpolationFilters: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        colorProfile: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        colorRendering: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        cursor: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        direction: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "ltr", "rtl", "inherit" ]),
        display: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        dominantBaseline: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        enableBackground: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        fill: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        fillOpacity: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number ]),
        fillRule: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "nonzero", "evenodd", "inherit" ]),
        filter: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        floodColor: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        floodOpacity: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number ]),
        font: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        fontFamily: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        fontSize: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        fontSizeAdjust: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        fontStretch: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "normal", "wider", "narrower", "ultra-condensed", "extra-condensed", "condensed", "semi-condensed", "semi-expanded", "expanded", "extra-expanded", "ultra-expanded", "inherit" ]),
        fontStyle: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "normal", "italic", "oblique", "inherit" ]),
        fontVariant: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "normal", "small-caps", "inherit" ]),
        fontWeight: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "normal", "bold", "bolder", "lighter", 100, 200, 300, 400, 500, 600, 700, 800, 900, "inherit" ]),
        glyphOrientationHorizontal: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        glyphOrientationVertical: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        imageRendering: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "auto", "optimizeSpeed", "optimizeQuality", "inherit" ]),
        kerning: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        letterSpacing: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        lightingColor: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        markerEnd: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        markerMid: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        markerStart: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        mask: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        opacity: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        overflow: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "visible", "hidden", "scroll", "auto", "inherit" ]),
        pointerEvents: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "visiblePainted", "visibleFill", "visibleStroke", "visible", "painted", "fill", "stroke", "all", "none", "inherit" ]),
        shapeRendering: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "auto", "optimizeSpeed", "crispEdges", "geometricPrecision", "inherit" ]),
        stopColor: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        stopOpacity: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        stroke: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        strokeDasharray: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        strokeDashoffset: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        strokeLinecap: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "butt", "round", "square", "inherit" ]),
        strokeLinejoin: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "miter", "round", "bevel", "inherit" ]),
        strokeMiterlimit: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        strokeOpacity: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        strokeWidth: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        textAnchor: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "start", "middle", "end", "inherit" ]),
        textDecoration: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "none", "underline", "overline", "line-through", "blink", "inherit" ]),
        textRendering: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "auto", "optimizeSpeed", "optimizeLegibility", "geometricPrecision", "inherit" ]),
        unicodeBidi: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "normal", "embed", "bidi-override", "inherit" ]),
        visibility: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "visible", "hidden", "collapse", "inherit" ]),
        wordSpacing: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        writingMode: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "lr-tb", "rl-tb", "tb-rl", "lr", "rl", "tb", "inherit" ]),
        transform: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        style: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.object,
        width: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        height: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        dx: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        dy: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        x: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        y: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        r: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        radius: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.array ])
    }, EVENT_ATTRIBUTES = {
        onClick: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onMouseDown: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onMouseUp: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onMouseOver: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onMouseMove: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onMouseOut: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onMouseEnter: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onMouseLeave: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onTouchEnd: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onTouchMove: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onTouchStart: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onTouchCancel: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func
    }, REACT_BROWSER_EVENT_MAP = {
        click: "onClick",
        mousedown: "onMouseDown",
        mouseup: "onMouseUp",
        mouseover: "onMouseOver",
        mousemove: "onMouseMove",
        mouseout: "onMouseOut",
        mouseenter: "onMouseEnter",
        mouseleave: "onMouseLeave",
        touchcancel: "onTouchCancel",
        touchend: "onTouchEnd",
        touchmove: "onTouchMove",
        touchstart: "onTouchStart"
    }, SCALE_TYPES = [ "auto", "linear", "pow", "sqrt", "log", "identity", "time", "band", "point", "ordinal", "quantile", "quantize", "utcTime", "sequential", "threshold" ], LEGEND_TYPES = [ "plainline", "line", "square", "rect", "circle", "cross", "diamond", "star", "triangle", "wye", "none" ], getDisplayName = function(Comp) {
        return Comp ? "string" == typeof Comp ? Comp : Comp.displayName || Comp.name || "Component" : "";
    }, findAllByType = function(children, type) {
        var result = [], types = [];
        return types = __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default()(type) ? type.map(function(t) {
            return getDisplayName(t);
        }) : [ getDisplayName(type) ], __WEBPACK_IMPORTED_MODULE_5_react___default.a.Children.forEach(children, function(child) {
            var childType = child && child.type && (child.type.displayName || child.type.name);
            -1 !== types.indexOf(childType) && result.push(child);
        }), result;
    }, findChildByType = function(children, type) {
        var result = findAllByType(children, type);
        return result && result[0];
    }, getPresentationAttributes = function(el) {
        if (!el || __WEBPACK_IMPORTED_MODULE_3_lodash_isFunction___default()(el)) return null;
        var props = __WEBPACK_IMPORTED_MODULE_5_react___default.a.isValidElement(el) ? el.props : el;
        if (!__WEBPACK_IMPORTED_MODULE_2_lodash_isObject___default()(props)) return null;
        var out = null;
        for (var i in props) ({}).hasOwnProperty.call(props, i) && PRESENTATION_ATTRIBUTES[i] && (out || (out = {}), 
        out[i] = props[i]);
        return out;
    }, getEventHandlerOfElement = function(originalHandler, props) {
        return function(e) {
            return originalHandler(props, e), null;
        };
    }, filterEventAttributes = function(el, newHandler) {
        var wrapCallback = arguments.length > 2 && void 0 !== arguments[2] && arguments[2];
        if (!el || __WEBPACK_IMPORTED_MODULE_3_lodash_isFunction___default()(el)) return null;
        var props = __WEBPACK_IMPORTED_MODULE_5_react___default.a.isValidElement(el) ? el.props : el;
        if (!__WEBPACK_IMPORTED_MODULE_2_lodash_isObject___default()(props)) return null;
        var out = null;
        for (var i in props) ({}).hasOwnProperty.call(props, i) && EVENT_ATTRIBUTES[i] && (out || (out = {}), 
        out[i] = newHandler || (wrapCallback ? getEventHandlerOfElement(props[i], props) : props[i]));
        return out;
    }, getEventHandlerOfChild = function(originalHandler, data, index) {
        return function(e) {
            return originalHandler(data, index, e), null;
        };
    }, filterEventsOfChild = function(props, data, index) {
        if (!__WEBPACK_IMPORTED_MODULE_2_lodash_isObject___default()(props)) return null;
        var out = null;
        for (var i in props) ({}).hasOwnProperty.call(props, i) && EVENT_ATTRIBUTES[i] && __WEBPACK_IMPORTED_MODULE_3_lodash_isFunction___default()(props[i]) && (out || (out = {}), 
        out[i] = getEventHandlerOfChild(props[i], data, index));
        return out;
    }, validateWidthHeight = function(el) {
        if (!el || !el.props) return !1;
        var _el$props = el.props, width = _el$props.width, height = _el$props.height;
        return !(!Object(__WEBPACK_IMPORTED_MODULE_7__DataUtils__.h)(width) || width <= 0 || !Object(__WEBPACK_IMPORTED_MODULE_7__DataUtils__.h)(height) || height <= 0);
    }, isSsr = function() {
        return !("undefined" != typeof window && window.document && window.document.createElement && window.setTimeout);
    }, SVG_TAGS = [ "a", "altGlyph", "altGlyphDef", "altGlyphItem", "animate", "animateColor", "animateMotion", "animateTransform", "circle", "clipPath", "color-profile", "cursor", "defs", "desc", "ellipse", "feBlend", "feColormatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence", "filter", "font", "font-face", "font-face-format", "font-face-name", "font-face-url", "foreignObject", "g", "glyph", "glyphRef", "hkern", "image", "line", "lineGradient", "marker", "mask", "metadata", "missing-glyph", "mpath", "path", "pattern", "polygon", "polyline", "radialGradient", "rect", "script", "set", "stop", "style", "svg", "switch", "symbol", "text", "textPath", "title", "tref", "tspan", "use", "view", "vkern" ], isSvgElement = function(child) {
        return child && child.type && __WEBPACK_IMPORTED_MODULE_1_lodash_isString___default()(child.type) && SVG_TAGS.indexOf(child.type) >= 0;
    }, filterSvgElements = function(children) {
        var svgElements = [];
        return __WEBPACK_IMPORTED_MODULE_5_react___default.a.Children.forEach(children, function(entry) {
            entry && entry.type && __WEBPACK_IMPORTED_MODULE_1_lodash_isString___default()(entry.type) && SVG_TAGS.indexOf(entry.type) >= 0 && svgElements.push(entry);
        }), svgElements;
    }, isSingleChildEqual = function(nextChild, prevChild) {
        if (__WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default()(nextChild) && __WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default()(prevChild)) return !0;
        if (!__WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default()(nextChild) && !__WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default()(prevChild)) {
            var _ref = nextChild.props || {}, nextChildren = _ref.children, nextProps = _objectWithoutProperties(_ref, [ "children" ]), _ref2 = prevChild.props || {}, prevChildren = _ref2.children, prevProps = _objectWithoutProperties(_ref2, [ "children" ]);
            return nextChildren && prevChildren ? Object(__WEBPACK_IMPORTED_MODULE_8__PureRender__.b)(nextProps, prevProps) && isChildrenEqual(nextChildren, prevChildren) : !nextChildren && !prevChildren && Object(__WEBPACK_IMPORTED_MODULE_8__PureRender__.b)(nextProps, prevProps);
        }
        return !1;
    }, isChildrenEqual = function isChildrenEqual(nextChildren, prevChildren) {
        if (nextChildren === prevChildren) return !0;
        if (__WEBPACK_IMPORTED_MODULE_5_react__.Children.count(nextChildren) !== __WEBPACK_IMPORTED_MODULE_5_react__.Children.count(prevChildren)) return !1;
        var count = __WEBPACK_IMPORTED_MODULE_5_react__.Children.count(nextChildren);
        if (0 === count) return !0;
        if (1 === count) return isSingleChildEqual(__WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default()(nextChildren) ? nextChildren[0] : nextChildren, __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default()(prevChildren) ? prevChildren[0] : prevChildren);
        for (var i = 0; i < count; i++) {
            var nextChild = nextChildren[i], prevChild = prevChildren[i];
            if (__WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default()(nextChild) || __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default()(prevChild)) {
                if (!isChildrenEqual(nextChild, prevChild)) return !1;
            } else if (!isSingleChildEqual(nextChild, prevChild)) return !1;
        }
        return !0;
    }, renderByOrder = function(children, renderMap) {
        var elements = [], record = {};
        return __WEBPACK_IMPORTED_MODULE_5_react__.Children.forEach(children, function(child, index) {
            if (child && isSvgElement(child)) elements.push(child); else if (child && renderMap[getDisplayName(child.type)]) {
                var displayName = getDisplayName(child.type), _renderMap$displayNam = renderMap[displayName], handler = _renderMap$displayNam.handler, once = _renderMap$displayNam.once;
                if (once && !record[displayName] || !once) {
                    var results = handler(child, displayName, index);
                    __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default()(results) ? elements = [ elements ].concat(_toConsumableArray(results)) : elements.push(results), 
                    record[displayName] = !0;
                }
            }
        }), elements;
    }, getReactEventByType = function(e) {
        var type = e && e.type;
        return type && REACT_BROWSER_EVENT_MAP[type] ? REACT_BROWSER_EVENT_MAP[type] : null;
    }, parseChildIndex = function(child, children) {
        var result = -1;
        return __WEBPACK_IMPORTED_MODULE_5_react__.Children.forEach(children, function(entry, index) {
            entry === child && (result = index);
        }), result;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function shallowEqual(a, b) {
        for (var key in a) if ({}.hasOwnProperty.call(a, key) && (!{}.hasOwnProperty.call(b, key) || a[key] !== b[key])) return !1;
        for (var _key in b) if ({}.hasOwnProperty.call(b, _key) && !{}.hasOwnProperty.call(a, _key)) return !1;
        return !0;
    }
    function shouldComponentUpdate(props, state) {
        return !shallowEqual(props, this.props) || !shallowEqual(state, this.state);
    }
    function pureRenderDecorator(component) {
        component.prototype.shouldComponentUpdate = shouldComponentUpdate;
    }
    __webpack_exports__.b = shallowEqual, __webpack_exports__.a = pureRenderDecorator;
}, function(module, exports, __webpack_require__) {
    "use strict";
    exports.__esModule = !0;
    var _assign = __webpack_require__(222), _assign2 = function(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }(_assign);
    exports.default = _assign2.default || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    exports.__esModule = !0, exports.default = function(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    };
}, function(module, exports, __webpack_require__) {
    function isFunction(value) {
        if (!isObject(value)) return !1;
        var tag = baseGetTag(value);
        return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
    }
    var baseGetTag = __webpack_require__(41), isObject = __webpack_require__(32), asyncTag = "[object AsyncFunction]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
    module.exports = isFunction;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_require__.d(__webpack_exports__, "j", function() {
        return mathSign;
    }), __webpack_require__.d(__webpack_exports__, "i", function() {
        return isPercent;
    }), __webpack_require__.d(__webpack_exports__, "h", function() {
        return isNumber;
    }), __webpack_require__.d(__webpack_exports__, "g", function() {
        return isNumOrStr;
    }), __webpack_require__.d(__webpack_exports__, "k", function() {
        return uniqueId;
    }), __webpack_require__.d(__webpack_exports__, "d", function() {
        return getPercentValue;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return getAnyElementOfObject;
    }), __webpack_require__.d(__webpack_exports__, "e", function() {
        return hasDuplicate;
    }), __webpack_require__.d(__webpack_exports__, "f", function() {
        return interpolateNumber;
    }), __webpack_require__.d(__webpack_exports__, "a", function() {
        return findEntryInArray;
    }), __webpack_require__.d(__webpack_exports__, "c", function() {
        return getLinearRegression;
    });
    var __WEBPACK_IMPORTED_MODULE_0_lodash_get__ = __webpack_require__(174), __WEBPACK_IMPORTED_MODULE_0_lodash_get___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_get__), __WEBPACK_IMPORTED_MODULE_1_lodash_isArray__ = __webpack_require__(13), __WEBPACK_IMPORTED_MODULE_1_lodash_isArray___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isArray__), __WEBPACK_IMPORTED_MODULE_2_lodash_isNaN__ = __webpack_require__(120), __WEBPACK_IMPORTED_MODULE_2_lodash_isNaN___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isNaN__), __WEBPACK_IMPORTED_MODULE_3_lodash_isNumber__ = __webpack_require__(272), __WEBPACK_IMPORTED_MODULE_3_lodash_isNumber___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_lodash_isNumber__), __WEBPACK_IMPORTED_MODULE_4_lodash_isString__ = __webpack_require__(173), __WEBPACK_IMPORTED_MODULE_4_lodash_isString___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_lodash_isString__), mathSign = function(value) {
        return 0 === value ? 0 : value > 0 ? 1 : -1;
    }, isPercent = function(value) {
        return __WEBPACK_IMPORTED_MODULE_4_lodash_isString___default()(value) && value.indexOf("%") === value.length - 1;
    }, isNumber = function(value) {
        return __WEBPACK_IMPORTED_MODULE_3_lodash_isNumber___default()(value) && !__WEBPACK_IMPORTED_MODULE_2_lodash_isNaN___default()(value);
    }, isNumOrStr = function(value) {
        return isNumber(value) || __WEBPACK_IMPORTED_MODULE_4_lodash_isString___default()(value);
    }, idCounter = 0, uniqueId = function(prefix) {
        var id = ++idCounter;
        return "" + (prefix || "") + id;
    }, getPercentValue = function(percent, totalValue) {
        var defaultValue = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 0, validate = arguments.length > 3 && void 0 !== arguments[3] && arguments[3];
        if (!isNumber(percent) && !__WEBPACK_IMPORTED_MODULE_4_lodash_isString___default()(percent)) return defaultValue;
        var value = void 0;
        if (isPercent(percent)) {
            var index = percent.indexOf("%");
            value = totalValue * parseFloat(percent.slice(0, index)) / 100;
        } else value = +percent;
        return __WEBPACK_IMPORTED_MODULE_2_lodash_isNaN___default()(value) && (value = defaultValue), 
        validate && value > totalValue && (value = totalValue), value;
    }, getAnyElementOfObject = function(obj) {
        if (!obj) return null;
        var keys = Object.keys(obj);
        return keys && keys.length ? obj[keys[0]] : null;
    }, hasDuplicate = function(ary) {
        if (!__WEBPACK_IMPORTED_MODULE_1_lodash_isArray___default()(ary)) return !1;
        for (var len = ary.length, cache = {}, i = 0; i < len; i++) {
            if (cache[ary[i]]) return !0;
            cache[ary[i]] = !0;
        }
        return !1;
    }, interpolateNumber = function(numberA, numberB) {
        return isNumber(numberA) && isNumber(numberB) ? function(t) {
            return numberA + t * (numberB - numberA);
        } : function() {
            return numberB;
        };
    }, findEntryInArray = function(ary, specifiedKey, specifiedValue) {
        return ary && ary.length ? ary.find(function(entry) {
            return entry && __WEBPACK_IMPORTED_MODULE_0_lodash_get___default()(entry, specifiedKey) === specifiedValue;
        }) : null;
    }, getLinearRegression = function(data) {
        if (!data || !data.length) return null;
        for (var len = data.length, xsum = 0, ysum = 0, xysum = 0, xxsum = 0, xmin = 1 / 0, xmax = -1 / 0, i = 0; i < len; i++) xsum += data[i].cx, 
        ysum += data[i].cy, xysum += data[i].cx * data[i].cy, xxsum += data[i].cx * data[i].cx, 
        xmin = Math.min(xmin, data[i].cx), xmax = Math.max(xmax, data[i].cx);
        var a = len * xxsum != xsum * xsum ? (len * xysum - xsum * ysum) / (len * xxsum - xsum * xsum) : 0;
        return {
            xmin: xmin,
            xmax: xmax,
            a: a,
            b: (ysum - a * xsum) / len
        };
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }
        function getDefaultTheme() {
            return defaultTheme || (defaultTheme = (0, _createMuiTheme2.default)());
        }
        Object.defineProperty(exports, "__esModule", {
            value: !0
        }), exports.sheetsManager = void 0;
        var _keys = __webpack_require__(55), _keys2 = _interopRequireDefault(_keys), _extends2 = __webpack_require__(6), _extends3 = _interopRequireDefault(_extends2), _getPrototypeOf = __webpack_require__(26), _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf), _classCallCheck2 = __webpack_require__(27), _classCallCheck3 = _interopRequireDefault(_classCallCheck2), _createClass2 = __webpack_require__(28), _createClass3 = _interopRequireDefault(_createClass2), _possibleConstructorReturn2 = __webpack_require__(29), _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2), _inherits2 = __webpack_require__(30), _inherits3 = _interopRequireDefault(_inherits2), _objectWithoutProperties2 = __webpack_require__(7), _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2), _map = __webpack_require__(440), _map2 = _interopRequireDefault(_map), _minSafeInteger = __webpack_require__(456), _minSafeInteger2 = _interopRequireDefault(_minSafeInteger), _react = __webpack_require__(0), _react2 = _interopRequireDefault(_react), _propTypes = __webpack_require__(1), _propTypes2 = _interopRequireDefault(_propTypes), _warning = __webpack_require__(11), _warning2 = _interopRequireDefault(_warning), _hoistNonReactStatics = __webpack_require__(162), _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics), _getDisplayName = __webpack_require__(244), _getDisplayName2 = _interopRequireDefault(_getDisplayName), _wrapDisplayName = __webpack_require__(79), _wrapDisplayName2 = _interopRequireDefault(_wrapDisplayName), _contextTypes = __webpack_require__(459), _contextTypes2 = _interopRequireDefault(_contextTypes), _jss = __webpack_require__(246), _ns = __webpack_require__(245), ns = function(obj) {
            if (obj && obj.__esModule) return obj;
            var newObj = {};
            if (null != obj) for (var key in obj) Object.prototype.hasOwnProperty.call(obj, key) && (newObj[key] = obj[key]);
            return newObj.default = obj, newObj;
        }(_ns), _jssPreset = __webpack_require__(481), _jssPreset2 = _interopRequireDefault(_jssPreset), _createMuiTheme = __webpack_require__(161), _createMuiTheme2 = _interopRequireDefault(_createMuiTheme), _themeListener = __webpack_require__(160), _themeListener2 = _interopRequireDefault(_themeListener), _createGenerateClassName = __webpack_require__(494), _createGenerateClassName2 = _interopRequireDefault(_createGenerateClassName), _getStylesCreator = __webpack_require__(495), _getStylesCreator2 = _interopRequireDefault(_getStylesCreator), jss = (0, 
        _jss.create)((0, _jssPreset2.default)()), generateClassName = (0, _createGenerateClassName2.default)(), indexCounter = _minSafeInteger2.default, sheetsManager = exports.sheetsManager = new _map2.default(), noopTheme = {}, defaultTheme = void 0, withStyles = function(stylesOrCreator) {
            var options = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
            return function(Component) {
                var _options$withTheme = options.withTheme, withTheme = void 0 !== _options$withTheme && _options$withTheme, _options$flip = options.flip, flip = void 0 === _options$flip ? null : _options$flip, name = options.name, styleSheetOptions = (0, 
                _objectWithoutProperties3.default)(options, [ "withTheme", "flip", "name" ]), stylesCreator = (0, 
                _getStylesCreator2.default)(stylesOrCreator), listenToTheme = stylesCreator.themingEnabled || withTheme || "string" == typeof name;
                indexCounter += 1, stylesCreator.options.index = indexCounter, "production" !== process.env.NODE_ENV && (0, 
                _warning2.default)(indexCounter < 0, [ "Material-UI: you might have a memory leak.", "The indexCounter is not supposed to grow that much." ].join(" "));
                var WithStyles = function(_React$Component) {
                    function WithStyles(props, context) {
                        (0, _classCallCheck3.default)(this, WithStyles);
                        var _this = (0, _possibleConstructorReturn3.default)(this, (WithStyles.__proto__ || (0, 
                        _getPrototypeOf2.default)(WithStyles)).call(this, props, context));
                        _this.state = {}, _this.disableStylesGeneration = !1, _this.jss = null, _this.sheetOptions = null, 
                        _this.sheetsManager = sheetsManager, _this.stylesCreatorSaved = null, _this.theme = null, 
                        _this.unsubscribeId = null, _this.jss = _this.context[ns.jss] || jss;
                        var muiThemeProviderOptions = _this.context.muiThemeProviderOptions;
                        return muiThemeProviderOptions && (muiThemeProviderOptions.sheetsManager && (_this.sheetsManager = muiThemeProviderOptions.sheetsManager), 
                        _this.disableStylesGeneration = muiThemeProviderOptions.disableStylesGeneration), 
                        _this.stylesCreatorSaved = stylesCreator, _this.sheetOptions = (0, _extends3.default)({
                            generateClassName: generateClassName
                        }, _this.context[ns.sheetOptions]), _this.theme = listenToTheme ? _themeListener2.default.initial(context) || getDefaultTheme() : noopTheme, 
                        _this;
                    }
                    return (0, _inherits3.default)(WithStyles, _React$Component), (0, _createClass3.default)(WithStyles, [ {
                        key: "componentWillMount",
                        value: function() {
                            this.attach(this.theme);
                        }
                    }, {
                        key: "componentDidMount",
                        value: function() {
                            var _this2 = this;
                            listenToTheme && (this.unsubscribeId = _themeListener2.default.subscribe(this.context, function(theme) {
                                var oldTheme = _this2.theme;
                                _this2.theme = theme, _this2.attach(_this2.theme), _this2.setState({}, function() {
                                    _this2.detach(oldTheme);
                                });
                            }));
                        }
                    }, {
                        key: "componentWillReceiveProps",
                        value: function() {
                            this.stylesCreatorSaved !== stylesCreator && "production" !== process.env.NODE_ENV && (this.detach(this.theme), 
                            this.stylesCreatorSaved = stylesCreator, this.attach(this.theme));
                        }
                    }, {
                        key: "componentWillUnmount",
                        value: function() {
                            this.detach(this.theme), null !== this.unsubscribeId && _themeListener2.default.unsubscribe(this.context, this.unsubscribeId);
                        }
                    }, {
                        key: "attach",
                        value: function(theme) {
                            if (!this.disableStylesGeneration) {
                                var stylesCreatorSaved = this.stylesCreatorSaved, sheetManager = this.sheetsManager.get(stylesCreatorSaved);
                                sheetManager || (sheetManager = new _map2.default(), this.sheetsManager.set(stylesCreatorSaved, sheetManager));
                                var sheetManagerTheme = sheetManager.get(theme);
                                if (sheetManagerTheme || (sheetManagerTheme = {
                                    refs: 0,
                                    sheet: null
                                }, sheetManager.set(theme, sheetManagerTheme)), 0 === sheetManagerTheme.refs) {
                                    var styles = stylesCreatorSaved.create(theme, name), meta = name;
                                    "production" === process.env.NODE_ENV || meta || (meta = (0, _getDisplayName2.default)(Component));
                                    var sheet = this.jss.createStyleSheet(styles, (0, _extends3.default)({
                                        meta: meta,
                                        classNamePrefix: meta,
                                        flip: "boolean" == typeof flip ? flip : "rtl" === theme.direction,
                                        link: !1
                                    }, this.sheetOptions, stylesCreatorSaved.options, {
                                        name: name
                                    }, styleSheetOptions));
                                    sheetManagerTheme.sheet = sheet, sheet.attach();
                                    var sheetsRegistry = this.context[ns.sheetsRegistry];
                                    sheetsRegistry && sheetsRegistry.add(sheet);
                                }
                                sheetManagerTheme.refs += 1;
                            }
                        }
                    }, {
                        key: "detach",
                        value: function(theme) {
                            if (!this.disableStylesGeneration) {
                                var stylesCreatorSaved = this.stylesCreatorSaved, sheetManager = this.sheetsManager.get(stylesCreatorSaved), sheetManagerTheme = sheetManager.get(theme);
                                if (sheetManagerTheme.refs -= 1, 0 === sheetManagerTheme.refs) {
                                    sheetManager.delete(theme), this.jss.removeStyleSheet(sheetManagerTheme.sheet);
                                    var sheetsRegistry = this.context[ns.sheetsRegistry];
                                    sheetsRegistry && sheetsRegistry.remove(sheetManagerTheme.sheet);
                                }
                            }
                        }
                    }, {
                        key: "render",
                        value: function() {
                            var _this3 = this, _props = this.props, classesProp = _props.classes, innerRef = _props.innerRef, other = (0, 
                            _objectWithoutProperties3.default)(_props, [ "classes", "innerRef" ]), classes = void 0, renderedClasses = {};
                            if (!this.disableStylesGeneration) {
                                var sheetManager = this.sheetsManager.get(this.stylesCreatorSaved), sheetsManagerTheme = sheetManager.get(this.theme);
                                renderedClasses = sheetsManagerTheme.sheet.classes;
                            }
                            classes = classesProp ? (0, _extends3.default)({}, renderedClasses, (0, _keys2.default)(classesProp).reduce(function(accumulator, key) {
                                return "production" !== process.env.NODE_ENV && (0, _warning2.default)(renderedClasses[key] || _this3.disableStylesGeneration, [ "Material-UI: the key ` + ("`" + `" + key + "`)) + ("`" + (` provided to the classes property is not implemented in " + (0, 
                                _getDisplayName2.default)(Component) + ".", "You can only override one of the following: " + (0, 
                                _keys2.default)(renderedClasses).join(",") ].join("\n")), "production" !== process.env.NODE_ENV && (0, 
                                _warning2.default)(!classesProp[key] || "string" == typeof classesProp[key], [ "Material-UI: the key ` + "`"))) + ((`" + key + "` + ("`" + ` provided to the classes property is not valid for " + (0, 
                                _getDisplayName2.default)(Component) + ".", "You need to provide a non empty string instead of: " + classesProp[key] + "." ].join("\n")), 
                                classesProp[key] && (accumulator[key] = renderedClasses[key] + " " + classesProp[key]), 
                                accumulator;
                            }, {})) : renderedClasses;
                            var more = {};
                            return withTheme && (more.theme = this.theme), _react2.default.createElement(Component, (0, 
                            _extends3.default)({
                                classes: classes
                            }, more, other, {
                                ref: innerRef
                            }));
                        }
                    } ]), WithStyles;
                }(_react2.default.Component);
                return WithStyles.propTypes = "production" !== process.env.NODE_ENV ? {
                    classes: _propTypes2.default.object,
                    innerRef: _propTypes2.default.func
                } : {}, WithStyles.contextTypes = (0, _extends3.default)({
                    muiThemeProviderOptions: _propTypes2.default.object
                }, _contextTypes2.default, listenToTheme ? _themeListener2.default.contextTypes : {}), 
                "production" !== process.env.NODE_ENV && (WithStyles.displayName = (0, _wrapDisplayName2.default)(Component, "WithStyles")), 
                (0, _hoistNonReactStatics2.default)(WithStyles, Component), "production" !== process.env.NODE_ENV && (WithStyles.Naked = Component, 
                WithStyles.options = options), WithStyles;
            };
        };
        exports.default = withStyles;
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        var warning = function() {};
        "production" !== process.env.NODE_ENV && (warning = function(condition, format, args) {
            var len = arguments.length;
            args = new Array(len > 2 ? len - 2 : 0);
            for (var key = 2; key < len; key++) args[key - 2] = arguments[key];
            if (void 0 === format) throw new Error("`)) + ("`" + (`warning(condition, format, ...args)` + "`")))) + (((` requires a warning message argument");
            if (format.length < 10 || /^[s\W]*$/.test(format)) throw new Error("The warning format should be able to uniquely identify this warning. Please, use a more descriptive format than: " + format);
            if (!condition) {
                var argIndex = 0, message = "Warning: " + format.replace(/%s/g, function() {
                    return args[argIndex++];
                });
                "undefined" != typeof console && console.error(message);
                try {
                    throw new Error(message);
                } catch (x) {}
            }
        }), module.exports = warning;
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    "use strict";
    exports.__esModule = !0;
    var _defineProperty = __webpack_require__(154), _defineProperty2 = function(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }(_defineProperty);
    exports.default = function(obj, key, value) {
        return key in obj ? (0, _defineProperty2.default)(obj, key, {
            value: value,
            enumerable: !0,
            configurable: !0,
            writable: !0
        }) : obj[key] = value, obj;
    };
}, function(module, exports) {
    var isArray = Array.isArray;
    module.exports = isArray;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function Layer(props) {
        var children = props.children, className = props.className, others = _objectWithoutProperties(props, [ "children", "className" ]), layerClass = __WEBPACK_IMPORTED_MODULE_2_classnames___default()("recharts-layer", className);
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("g", _extends({
            className: layerClass
        }, others), children);
    }
    var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_2_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_classnames__), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, propTypes = {
        className: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
        children: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.node), __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.node ])
    };
    Layer.propTypes = propTypes, __webpack_exports__.a = Layer;
}, function(module, exports, __webpack_require__) {
    var global = __webpack_require__(167), core = __webpack_require__(168), hide = __webpack_require__(266), redefine = __webpack_require__(581), ctx = __webpack_require__(584), $export = function(type, name, source) {
        var key, own, out, exp, IS_FORCED = type & $export.F, IS_GLOBAL = type & $export.G, IS_STATIC = type & $export.S, IS_PROTO = type & $export.P, IS_BIND = type & $export.B, target = IS_GLOBAL ? global : IS_STATIC ? global[name] || (global[name] = {}) : (global[name] || {}).prototype, exports = IS_GLOBAL ? core : core[name] || (core[name] = {}), expProto = exports.prototype || (exports.prototype = {});
        IS_GLOBAL && (source = name);
        for (key in source) own = !IS_FORCED && target && void 0 !== target[key], out = (own ? target : source)[key], 
        exp = IS_BIND && own ? ctx(out, global) : IS_PROTO && "function" == typeof out ? ctx(Function.call, out) : out, 
        target && redefine(target, key, out, type & $export.U), exports[key] != out && hide(exports, key, exp), 
        IS_PROTO && expProto[key] != out && (expProto[key] = out);
    };
    global.core = core, $export.F = 1, $export.G = 2, $export.S = 4, $export.P = 8, 
    $export.B = 16, $export.W = 32, $export.U = 64, $export.R = 128, module.exports = $export;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _defineProperty(obj, key, value) {
        return key in obj ? Object.defineProperty(obj, key, {
            value: value,
            enumerable: !0,
            configurable: !0,
            writable: !0
        }) : obj[key] = value, obj;
    }
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    __webpack_require__.d(__webpack_exports__, "w", function() {
        return getValueByDataKey;
    }), __webpack_require__.d(__webpack_exports__, "n", function() {
        return getDomainOfDataByKey;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return calculateActiveTickIndex;
    }), __webpack_require__.d(__webpack_exports__, "r", function() {
        return getMainColorOfGraphicItem;
    }), __webpack_require__.d(__webpack_exports__, "q", function() {
        return getLegendProps;
    }), __webpack_require__.d(__webpack_exports__, "i", function() {
        return getBarSizeList;
    }), __webpack_require__.d(__webpack_exports__, "h", function() {
        return getBarPosition;
    }), __webpack_require__.d(__webpack_exports__, "a", function() {
        return appendOffsetOfLegend;
    }), __webpack_require__.d(__webpack_exports__, "z", function() {
        return parseErrorBarsOfAxis;
    }), __webpack_require__.d(__webpack_exports__, "o", function() {
        return getDomainOfItemsWithSameAxis;
    }), __webpack_require__.d(__webpack_exports__, "x", function() {
        return isCategorialAxis;
    }), __webpack_require__.d(__webpack_exports__, "m", function() {
        return getCoordinatesOfGrid;
    }), __webpack_require__.d(__webpack_exports__, "u", function() {
        return getTicksOfAxis;
    }), __webpack_require__.d(__webpack_exports__, "d", function() {
        return combineEventHandlers;
    }), __webpack_require__.d(__webpack_exports__, "A", function() {
        return parseScale;
    }), __webpack_require__.d(__webpack_exports__, "c", function() {
        return checkDomainOfScale;
    }), __webpack_require__.d(__webpack_exports__, "f", function() {
        return findPositionOfBar;
    }), __webpack_require__.d(__webpack_exports__, "C", function() {
        return truncateByDomain;
    }), __webpack_require__.d(__webpack_exports__, "s", function() {
        return getStackGroupsByAxisId;
    }), __webpack_require__.d(__webpack_exports__, "v", function() {
        return getTicksOfScale;
    }), __webpack_require__.d(__webpack_exports__, "l", function() {
        return getCateCoordinateOfLine;
    }), __webpack_require__.d(__webpack_exports__, "k", function() {
        return getCateCoordinateOfBar;
    }), __webpack_require__.d(__webpack_exports__, "j", function() {
        return getBaseValueOfBar;
    }), __webpack_require__.d(__webpack_exports__, "e", function() {
        return detectReferenceElementsDomain;
    }), __webpack_require__.d(__webpack_exports__, "t", function() {
        return getStackedDataOfItem;
    }), __webpack_require__.d(__webpack_exports__, "p", function() {
        return getDomainOfStackGroups;
    }), __webpack_require__.d(__webpack_exports__, "B", function() {
        return parseSpecifiedDomain;
    }), __webpack_require__.d(__webpack_exports__, "D", function() {
        return validateCoordinateInRange;
    }), __webpack_require__.d(__webpack_exports__, "g", function() {
        return getBandSizeOfAxis;
    }), __webpack_require__.d(__webpack_exports__, "y", function() {
        return parseDomainOfCategoryAxis;
    });
    var __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__ = __webpack_require__(45), __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__), __WEBPACK_IMPORTED_MODULE_1_lodash_sortBy__ = __webpack_require__(321), __WEBPACK_IMPORTED_MODULE_1_lodash_sortBy___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_sortBy__), __WEBPACK_IMPORTED_MODULE_2_lodash_isNaN__ = __webpack_require__(120), __WEBPACK_IMPORTED_MODULE_2_lodash_isNaN___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isNaN__), __WEBPACK_IMPORTED_MODULE_3_lodash_isString__ = __webpack_require__(173), __WEBPACK_IMPORTED_MODULE_3_lodash_isString___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_lodash_isString__), __WEBPACK_IMPORTED_MODULE_4_lodash_max__ = __webpack_require__(841), __WEBPACK_IMPORTED_MODULE_4_lodash_max___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_lodash_max__), __WEBPACK_IMPORTED_MODULE_5_lodash_min__ = __webpack_require__(328), __WEBPACK_IMPORTED_MODULE_5_lodash_min___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_lodash_min__), __WEBPACK_IMPORTED_MODULE_6_lodash_isArray__ = __webpack_require__(13), __WEBPACK_IMPORTED_MODULE_6_lodash_isArray___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_lodash_isArray__), __WEBPACK_IMPORTED_MODULE_7_lodash_flatMap__ = __webpack_require__(842), __WEBPACK_IMPORTED_MODULE_7_lodash_flatMap___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_lodash_flatMap__), __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_9_lodash_get__ = __webpack_require__(174), __WEBPACK_IMPORTED_MODULE_9_lodash_get___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_9_lodash_get__), __WEBPACK_IMPORTED_MODULE_10_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_10_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_11_recharts_scale__ = __webpack_require__(844), __WEBPACK_IMPORTED_MODULE_12_d3_scale__ = (__webpack_require__.n(__WEBPACK_IMPORTED_MODULE_11_recharts_scale__), 
    __webpack_require__(331)), __WEBPACK_IMPORTED_MODULE_13_d3_shape__ = __webpack_require__(182), __WEBPACK_IMPORTED_MODULE_14__DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_15__cartesian_ReferenceDot__ = __webpack_require__(364), __WEBPACK_IMPORTED_MODULE_16__cartesian_ReferenceLine__ = __webpack_require__(365), __WEBPACK_IMPORTED_MODULE_17__cartesian_ReferenceArea__ = __webpack_require__(366), __WEBPACK_IMPORTED_MODULE_18__cartesian_ErrorBar__ = __webpack_require__(95), __WEBPACK_IMPORTED_MODULE_19__component_Legend__ = __webpack_require__(180), __WEBPACK_IMPORTED_MODULE_20__ReactUtils__ = __webpack_require__(4), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, getValueByDataKey = function(obj, dataKey, defaultValue) {
        return __WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default()(obj) || __WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default()(dataKey) ? defaultValue : Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.g)(dataKey) ? __WEBPACK_IMPORTED_MODULE_9_lodash_get___default()(obj, dataKey, defaultValue) : __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction___default()(dataKey) ? dataKey(obj) : defaultValue;
    }, getDomainOfDataByKey = function(data, key, type, filterNil) {
        var flattenData = __WEBPACK_IMPORTED_MODULE_7_lodash_flatMap___default()(data, function(entry) {
            return getValueByDataKey(entry, key);
        });
        if ("number" === type) {
            var domain = flattenData.filter(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h);
            return [ Math.min.apply(null, domain), Math.max.apply(null, domain) ];
        }
        return (filterNil ? flattenData.filter(function(entry) {
            return !__WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default()(entry);
        }) : flattenData).map(function(entry) {
            return Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.g)(entry) ? entry : "";
        });
    }, calculateActiveTickIndex = function(coordinate, ticks, unsortedTicks, axis) {
        var index = -1, len = ticks.length;
        if (len > 1) {
            if (axis && "angleAxis" === axis.axisType && Math.abs(Math.abs(axis.range[1] - axis.range[0]) - 360) <= 1e-6) for (var range = axis.range, i = 0; i < len; i++) {
                var before = i > 0 ? unsortedTicks[i - 1].coordinate : unsortedTicks[len - 1].coordinate, cur = unsortedTicks[i].coordinate, after = i >= len - 1 ? unsortedTicks[0].coordinate : unsortedTicks[i + 1].coordinate, sameDirectionCoord = void 0;
                if (Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.j)(cur - before) !== Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.j)(after - cur)) {
                    var diffInterval = [];
                    if (Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.j)(after - cur) === Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.j)(range[1] - range[0])) {
                        sameDirectionCoord = after;
                        var curInRange = cur + range[1] - range[0];
                        diffInterval[0] = Math.min(curInRange, (curInRange + before) / 2), diffInterval[1] = Math.max(curInRange, (curInRange + before) / 2);
                    } else {
                        sameDirectionCoord = before;
                        var afterInRange = after + range[1] - range[0];
                        diffInterval[0] = Math.min(cur, (afterInRange + cur) / 2), diffInterval[1] = Math.max(cur, (afterInRange + cur) / 2);
                    }
                    var sameInterval = [ Math.min(cur, (sameDirectionCoord + cur) / 2), Math.max(cur, (sameDirectionCoord + cur) / 2) ];
                    if (coordinate > sameInterval[0] && coordinate <= sameInterval[1] || coordinate >= diffInterval[0] && coordinate <= diffInterval[1]) {
                        index = unsortedTicks[i].index;
                        break;
                    }
                } else {
                    var min = Math.min(before, after), max = Math.max(before, after);
                    if (coordinate > (min + cur) / 2 && coordinate <= (max + cur) / 2) {
                        index = unsortedTicks[i].index;
                        break;
                    }
                }
            } else for (var _i = 0; _i < len; _i++) if (0 === _i && coordinate <= (ticks[_i].coordinate + ticks[_i + 1].coordinate) / 2 || _i > 0 && _i < len - 1 && coordinate > (ticks[_i].coordinate + ticks[_i - 1].coordinate) / 2 && coordinate <= (ticks[_i].coordinate + ticks[_i + 1].coordinate) / 2 || _i === len - 1 && coordinate > (ticks[_i].coordinate + ticks[_i - 1].coordinate) / 2) {
                index = ticks[_i].index;
                break;
            }
        } else index = 0;
        return index;
    }, getMainColorOfGraphicItem = function(item) {
        var displayName = item.type.displayName, result = void 0;
        switch (displayName) {
          case "Line":
          case "Area":
          case "Radar":
            result = item.props.stroke;
            break;

          default:
            result = item.props.fill;
        }
        return result;
    }, getLegendProps = function(_ref) {
        var children = _ref.children, formatedGraphicalItems = _ref.formatedGraphicalItems, legendWidth = _ref.legendWidth, legendContent = _ref.legendContent, legendItem = Object(__WEBPACK_IMPORTED_MODULE_20__ReactUtils__.i)(children, __WEBPACK_IMPORTED_MODULE_19__component_Legend__.a);
        if (!legendItem) return null;
        var legendData = void 0;
        return legendData = legendItem.props && legendItem.props.payload ? legendItem.props && legendItem.props.payload : "children" === legendContent ? (formatedGraphicalItems || []).reduce(function(result, _ref2) {
            var item = _ref2.item, props = _ref2.props, data = props.sectors || props.data || [];
            return result.concat(data.map(function(entry) {
                return {
                    type: legendItem.props.iconType || item.props.legendType,
                    value: entry.name,
                    color: entry.fill,
                    payload: entry
                };
            }));
        }, []) : (formatedGraphicalItems || []).map(function(_ref3) {
            var item = _ref3.item, _item$props = item.props, dataKey = _item$props.dataKey, name = _item$props.name, legendType = _item$props.legendType;
            return {
                inactive: _item$props.hide,
                dataKey: dataKey,
                type: legendItem.props.iconType || legendType || "square",
                color: getMainColorOfGraphicItem(item),
                value: name || dataKey,
                payload: item.props
            };
        }), _extends({}, legendItem.props, __WEBPACK_IMPORTED_MODULE_19__component_Legend__.a.getWithHeight(legendItem, legendWidth), {
            payload: legendData,
            item: legendItem
        });
    }, getBarSizeList = function(_ref4) {
        var globalSize = _ref4.barSize, _ref4$stackGroups = _ref4.stackGroups, stackGroups = void 0 === _ref4$stackGroups ? {} : _ref4$stackGroups;
        if (!stackGroups) return {};
        for (var result = {}, numericAxisIds = Object.keys(stackGroups), i = 0, len = numericAxisIds.length; i < len; i++) for (var sgs = stackGroups[numericAxisIds[i]].stackGroups, stackIds = Object.keys(sgs), j = 0, sLen = stackIds.length; j < sLen; j++) {
            var _sgs$stackIds$j = sgs[stackIds[j]], items = _sgs$stackIds$j.items, cateAxisId = _sgs$stackIds$j.cateAxisId, barItems = items.filter(function(item) {
                return Object(__WEBPACK_IMPORTED_MODULE_20__ReactUtils__.j)(item.type).indexOf("Bar") >= 0;
            });
            if (barItems && barItems.length) {
                var selfSize = barItems[0].props.barSize, cateId = barItems[0].props[cateAxisId];
                result[cateId] || (result[cateId] = []), result[cateId].push({
                    item: barItems[0],
                    stackList: barItems.slice(1),
                    barSize: __WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default()(selfSize) ? globalSize : selfSize
                });
            }
        }
        return result;
    }, getBarPosition = function(_ref5) {
        var barGap = _ref5.barGap, barCategoryGap = _ref5.barCategoryGap, bandSize = _ref5.bandSize, _ref5$sizeList = _ref5.sizeList, sizeList = void 0 === _ref5$sizeList ? [] : _ref5$sizeList, maxBarSize = _ref5.maxBarSize, len = sizeList.length;
        if (len < 1) return null;
        var realBarGap = Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.d)(barGap, bandSize, 0, !0), result = void 0;
        if (sizeList[0].barSize === +sizeList[0].barSize) {
            var useFull = !1, fullBarSize = bandSize / len, sum = sizeList.reduce(function(res, entry) {
                return res + entry.barSize || 0;
            }, 0);
            sum += (len - 1) * realBarGap, sum >= bandSize && (sum -= (len - 1) * realBarGap, 
            realBarGap = 0), sum >= bandSize && fullBarSize > 0 && (useFull = !0, fullBarSize *= .9, 
            sum = len * fullBarSize);
            var offset = (bandSize - sum) / 2 >> 0, prev = {
                offset: offset - realBarGap,
                size: 0
            };
            result = sizeList.reduce(function(res, entry) {
                var newRes = [].concat(_toConsumableArray(res), [ {
                    item: entry.item,
                    position: {
                        offset: prev.offset + prev.size + realBarGap,
                        size: useFull ? fullBarSize : entry.barSize
                    }
                } ]);
                return prev = newRes[newRes.length - 1].position, entry.stackList && entry.stackList.length && entry.stackList.forEach(function(item) {
                    newRes.push({
                        item: item,
                        position: prev
                    });
                }), newRes;
            }, []);
        } else {
            var _offset = Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.d)(barCategoryGap, bandSize, 0, !0);
            bandSize - 2 * _offset - (len - 1) * realBarGap <= 0 && (realBarGap = 0);
            var originalSize = (bandSize - 2 * _offset - (len - 1) * realBarGap) / len;
            originalSize > 1 && (originalSize >>= 0);
            var size = maxBarSize === +maxBarSize ? Math.min(originalSize, maxBarSize) : originalSize;
            result = sizeList.reduce(function(res, entry, i) {
                var newRes = [].concat(_toConsumableArray(res), [ {
                    item: entry.item,
                    position: {
                        offset: _offset + (originalSize + realBarGap) * i + (originalSize - size) / 2,
                        size: size
                    }
                } ]);
                return entry.stackList && entry.stackList.length && entry.stackList.forEach(function(item) {
                    newRes.push({
                        item: item,
                        position: newRes[newRes.length - 1].position
                    });
                }), newRes;
            }, []);
        }
        return result;
    }, appendOffsetOfLegend = function(offset, items, props, legendBox) {
        var children = props.children, width = props.width, height = props.height, margin = props.margin, legendWidth = width - (margin.left || 0) - (margin.right || 0), legendHeight = height - (margin.top || 0) - (margin.bottom || 0), legendProps = getLegendProps({
            children: children,
            items: items,
            legendWidth: legendWidth,
            legendHeight: legendHeight
        }), newOffset = offset;
        if (legendProps) {
            var box = legendBox || {}, align = legendProps.align, verticalAlign = legendProps.verticalAlign, layout = legendProps.layout;
            ("vertical" === layout || "horizontal" === layout && "center" === verticalAlign) && Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(offset[align]) && (newOffset = _extends({}, offset, _defineProperty({}, align, newOffset[align] + (box.width || 0)))), 
            ("horizontal" === layout || "vertical" === layout && "center" === align) && Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(offset[verticalAlign]) && (newOffset = _extends({}, offset, _defineProperty({}, verticalAlign, newOffset[verticalAlign] + (box.height || 0))));
        }
        return newOffset;
    }, getDomainOfErrorBars = function(data, item, dataKey, axisType) {
        var children = item.props.children, errorBars = Object(__WEBPACK_IMPORTED_MODULE_20__ReactUtils__.h)(children, __WEBPACK_IMPORTED_MODULE_18__cartesian_ErrorBar__.a).filter(function(errorBarChild) {
            var direction = errorBarChild.props.direction;
            return !(!__WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default()(direction) && !__WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default()(axisType)) || axisType.indexOf(direction) >= 0;
        });
        if (errorBars && errorBars.length) {
            var keys = errorBars.map(function(errorBarChild) {
                return errorBarChild.props.dataKey;
            });
            return data.reduce(function(result, entry) {
                var entryValue = getValueByDataKey(entry, dataKey, 0), mainValue = __WEBPACK_IMPORTED_MODULE_6_lodash_isArray___default()(entryValue) ? [ __WEBPACK_IMPORTED_MODULE_5_lodash_min___default()(entryValue), __WEBPACK_IMPORTED_MODULE_4_lodash_max___default()(entryValue) ] : [ entryValue, entryValue ], errorDomain = keys.reduce(function(prevErrorArr, k) {
                    var errorValue = getValueByDataKey(entry, k, 0), lowerValue = mainValue[0] - Math.abs(__WEBPACK_IMPORTED_MODULE_6_lodash_isArray___default()(errorValue) ? errorValue[0] : errorValue), upperValue = mainValue[1] + Math.abs(__WEBPACK_IMPORTED_MODULE_6_lodash_isArray___default()(errorValue) ? errorValue[1] : errorValue);
                    return [ Math.min(lowerValue, prevErrorArr[0]), Math.max(upperValue, prevErrorArr[1]) ];
                }, [ 1 / 0, -1 / 0 ]);
                return [ Math.min(errorDomain[0], result[0]), Math.max(errorDomain[1], result[1]) ];
            }, [ 1 / 0, -1 / 0 ]);
        }
        return null;
    }, parseErrorBarsOfAxis = function(data, items, dataKey, axisType) {
        var domains = items.map(function(item) {
            return getDomainOfErrorBars(data, item, dataKey, axisType);
        }).filter(function(entry) {
            return !__WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default()(entry);
        });
        return domains && domains.length ? domains.reduce(function(result, entry) {
            return [ Math.min(result[0], entry[0]), Math.max(result[1], entry[1]) ];
        }, [ 1 / 0, -1 / 0 ]) : null;
    }, getDomainOfItemsWithSameAxis = function(data, items, type, filterNil) {
        var domains = items.map(function(item) {
            var dataKey = item.props.dataKey;
            return "number" === type && dataKey ? getDomainOfErrorBars(data, item, dataKey) || getDomainOfDataByKey(data, dataKey, type, filterNil) : getDomainOfDataByKey(data, dataKey, type, filterNil);
        });
        if ("number" === type) return domains.reduce(function(result, entry) {
            return [ Math.min(result[0], entry[0]), Math.max(result[1], entry[1]) ];
        }, [ 1 / 0, -1 / 0 ]);
        var tag = {};
        return domains.reduce(function(result, entry) {
            for (var i = 0, len = entry.length; i < len; i++) tag[entry[i]] || (tag[entry[i]] = !0, 
            result.push(entry[i]));
            return result;
        }, []);
    }, isCategorialAxis = function(layout, axisType) {
        return "horizontal" === layout && "xAxis" === axisType || "vertical" === layout && "yAxis" === axisType || "centric" === layout && "angleAxis" === axisType || "radial" === layout && "radiusAxis" === axisType;
    }, getCoordinatesOfGrid = function(ticks, min, max) {
        var hasMin = void 0, hasMax = void 0, values = ticks.map(function(entry) {
            return entry.coordinate === min && (hasMin = !0), entry.coordinate === max && (hasMax = !0), 
            entry.coordinate;
        });
        return hasMin || values.push(min), hasMax || values.push(max), values;
    }, getTicksOfAxis = function(axis, isGrid, isAll) {
        if (!axis) return null;
        var scale = axis.scale, duplicateDomain = axis.duplicateDomain, type = axis.type, range = axis.range, offset = (isGrid || isAll) && "category" === type && scale.bandwidth ? scale.bandwidth() / 2 : 0;
        return offset = "angleAxis" === axis.axisType ? 2 * Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.j)(range[0] - range[1]) * offset : offset, 
        isGrid && (axis.ticks || axis.niceTicks) ? (axis.ticks || axis.niceTicks).map(function(entry) {
            var scaleContent = duplicateDomain ? duplicateDomain.indexOf(entry) : entry;
            return {
                coordinate: scale(scaleContent) + offset,
                value: entry,
                offset: offset
            };
        }) : axis.isCategorial && axis.categoricalDomain ? axis.categoricalDomain.map(function(entry, index) {
            return {
                coordinate: scale(entry),
                value: entry,
                index: index,
                offset: offset
            };
        }) : scale.ticks && !isAll ? scale.ticks(axis.tickCount).map(function(entry) {
            return {
                coordinate: scale(entry) + offset,
                value: entry,
                offset: offset
            };
        }) : scale.domain().map(function(entry, index) {
            return {
                coordinate: scale(entry) + offset,
                value: duplicateDomain ? duplicateDomain[entry] : entry,
                index: index,
                offset: offset
            };
        });
    }, combineEventHandlers = function(defaultHandler, parentHandler, childHandler) {
        var customizedHandler = void 0;
        return __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction___default()(childHandler) ? customizedHandler = childHandler : __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction___default()(parentHandler) && (customizedHandler = parentHandler), 
        __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction___default()(defaultHandler) || customizedHandler ? function(arg1, arg2, arg3, arg4) {
            __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction___default()(defaultHandler) && defaultHandler(arg1, arg2, arg3, arg4), 
            __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction___default()(customizedHandler) && customizedHandler(arg1, arg2, arg3, arg4);
        } : null;
    }, parseScale = function(axis, chartType) {
        var scale = axis.scale, type = axis.type, layout = axis.layout, axisType = axis.axisType;
        if ("auto" === scale) return "radial" === layout && "radiusAxis" === axisType ? {
            scale: __WEBPACK_IMPORTED_MODULE_12_d3_scale__.scaleBand(),
            realScaleType: "band"
        } : "radial" === layout && "angleAxis" === axisType ? {
            scale: __WEBPACK_IMPORTED_MODULE_12_d3_scale__.scaleLinear(),
            realScaleType: "linear"
        } : "category" === type && chartType && (chartType.indexOf("LineChart") >= 0 || chartType.indexOf("AreaChart") >= 0) ? {
            scale: __WEBPACK_IMPORTED_MODULE_12_d3_scale__.scalePoint(),
            realScaleType: "point"
        } : "category" === type ? {
            scale: __WEBPACK_IMPORTED_MODULE_12_d3_scale__.scaleBand(),
            realScaleType: "band"
        } : {
            scale: __WEBPACK_IMPORTED_MODULE_12_d3_scale__.scaleLinear(),
            realScaleType: "linear"
        };
        if (__WEBPACK_IMPORTED_MODULE_3_lodash_isString___default()(scale)) {
            var name = "scale" + scale.slice(0, 1).toUpperCase() + scale.slice(1);
            return {
                scale: (__WEBPACK_IMPORTED_MODULE_12_d3_scale__[name] || __WEBPACK_IMPORTED_MODULE_12_d3_scale__.scalePoint)(),
                realScaleType: __WEBPACK_IMPORTED_MODULE_12_d3_scale__[name] ? name : "point"
            };
        }
        return __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction___default()(scale) ? {
            scale: scale
        } : {
            scale: __WEBPACK_IMPORTED_MODULE_12_d3_scale__.scalePoint(),
            realScaleType: "point"
        };
    }, checkDomainOfScale = function(scale) {
        var domain = scale.domain();
        if (domain && !(domain.length <= 2)) {
            var len = domain.length, range = scale.range(), min = Math.min(range[0], range[1]) - 1e-4, max = Math.max(range[0], range[1]) + 1e-4, first = scale(domain[0]), last = scale(domain[len - 1]);
            (first < min || first > max || last < min || last > max) && scale.domain([ domain[0], domain[len - 1] ]);
        }
    }, findPositionOfBar = function(barPosition, child) {
        if (!barPosition) return null;
        for (var i = 0, len = barPosition.length; i < len; i++) if (barPosition[i].item === child) return barPosition[i].position;
        return null;
    }, truncateByDomain = function(value, domain) {
        if (!domain || 2 !== domain.length || !Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(domain[0]) || !Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(domain[1])) return value;
        var min = Math.min(domain[0], domain[1]), max = Math.max(domain[0], domain[1]), result = [ value[0], value[1] ];
        return (!Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(value[0]) || value[0] < min) && (result[0] = min), 
        (!Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(value[1]) || value[1] > max) && (result[1] = max), 
        result[0] > max && (result[0] = max), result[1] < min && (result[1] = min), result;
    }, offsetSign = function(series) {
        var n = series.length;
        if (!(n <= 0)) for (var j = 0, m = series[0].length; j < m; ++j) for (var positive = 0, negative = 0, i = 0; i < n; ++i) {
            var value = __WEBPACK_IMPORTED_MODULE_2_lodash_isNaN___default()(series[i][j][1]) ? series[i][j][0] : series[i][j][1];
            value >= 0 ? (series[i][j][0] = positive, series[i][j][1] = positive + value, positive = series[i][j][1]) : (series[i][j][0] = negative, 
            series[i][j][1] = negative + value, negative = series[i][j][1]);
        }
    }, STACK_OFFSET_MAP = {
        sign: offsetSign,
        expand: __WEBPACK_IMPORTED_MODULE_13_d3_shape__.o,
        none: __WEBPACK_IMPORTED_MODULE_13_d3_shape__.p,
        silhouette: __WEBPACK_IMPORTED_MODULE_13_d3_shape__.q,
        wiggle: __WEBPACK_IMPORTED_MODULE_13_d3_shape__.r
    }, getStackedData = function(data, stackItems, offsetType) {
        var dataKeys = stackItems.map(function(item) {
            return item.props.dataKey;
        });
        return Object(__WEBPACK_IMPORTED_MODULE_13_d3_shape__.n)().keys(dataKeys).value(function(d, key) {
            return +getValueByDataKey(d, key, 0);
        }).order(__WEBPACK_IMPORTED_MODULE_13_d3_shape__.s).offset(STACK_OFFSET_MAP[offsetType])(data);
    }, getStackGroupsByAxisId = function(data, _items, numericAxisId, cateAxisId, offsetType, reverseStackOrder) {
        if (!data) return null;
        var items = reverseStackOrder ? _items.reverse() : _items, stackGroups = items.reduce(function(result, item) {
            var _item$props2 = item.props, stackId = _item$props2.stackId;
            if (_item$props2.hide) return result;
            var axisId = item.props[numericAxisId], parentGroup = result[axisId] || {
                hasStack: !1,
                stackGroups: {}
            };
            if (Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.g)(stackId)) {
                var childGroup = parentGroup.stackGroups[stackId] || {
                    numericAxisId: numericAxisId,
                    cateAxisId: cateAxisId,
                    items: []
                };
                childGroup.items.push(item), parentGroup.hasStack = !0, parentGroup.stackGroups[stackId] = childGroup;
            } else parentGroup.stackGroups[Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.k)("_stackId_")] = {
                numericAxisId: numericAxisId,
                cateAxisId: cateAxisId,
                items: [ item ]
            };
            return _extends({}, result, _defineProperty({}, axisId, parentGroup));
        }, {});
        return Object.keys(stackGroups).reduce(function(result, axisId) {
            var group = stackGroups[axisId];
            return group.hasStack && (group.stackGroups = Object.keys(group.stackGroups).reduce(function(res, stackId) {
                var g = group.stackGroups[stackId];
                return _extends({}, res, _defineProperty({}, stackId, {
                    numericAxisId: numericAxisId,
                    cateAxisId: cateAxisId,
                    items: g.items,
                    stackedData: getStackedData(data, g.items, offsetType)
                }));
            }, {})), _extends({}, result, _defineProperty({}, axisId, group));
        }, {});
    }, calculateDomainOfTicks = function(ticks, type) {
        return "number" === type ? [ Math.min.apply(null, ticks), Math.max.apply(null, ticks) ] : ticks;
    }, getTicksOfScale = function(scale, opts) {
        var realScaleType = opts.realScaleType, type = opts.type, tickCount = opts.tickCount, originalDomain = opts.originalDomain, allowDecimals = opts.allowDecimals, scaleType = realScaleType || opts.scale;
        if ("auto" !== scaleType && "linear" !== scaleType) return null;
        if (tickCount && "number" === type && originalDomain && ("auto" === originalDomain[0] || "auto" === originalDomain[1])) {
            var domain = scale.domain(), tickValues = Object(__WEBPACK_IMPORTED_MODULE_11_recharts_scale__.getNiceTickValues)(domain, tickCount, allowDecimals);
            return scale.domain(calculateDomainOfTicks(tickValues, type)), {
                niceTicks: tickValues
            };
        }
        if (tickCount && "number" === type) {
            var _domain = scale.domain();
            return {
                niceTicks: Object(__WEBPACK_IMPORTED_MODULE_11_recharts_scale__.getTickValuesFixedDomain)(_domain, tickCount, allowDecimals)
            };
        }
        return null;
    }, getCateCoordinateOfLine = function(_ref6) {
        var axis = _ref6.axis, ticks = _ref6.ticks, bandSize = _ref6.bandSize, entry = _ref6.entry, index = _ref6.index;
        if ("category" === axis.type) {
            if (!axis.allowDuplicatedCategory && axis.dataKey && !__WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default()(entry[axis.dataKey])) {
                var matchedTick = Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.a)(ticks, "value", entry[axis.dataKey]);
                if (matchedTick) return matchedTick.coordinate + bandSize / 2;
            }
            return ticks[index] ? ticks[index].coordinate + bandSize / 2 : null;
        }
        var value = getValueByDataKey(entry, axis.dataKey);
        return __WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default()(value) ? null : axis.scale(value);
    }, getCateCoordinateOfBar = function(_ref7) {
        var axis = _ref7.axis, ticks = _ref7.ticks, offset = _ref7.offset, bandSize = _ref7.bandSize, entry = _ref7.entry, index = _ref7.index;
        if ("category" === axis.type) return ticks[index] ? ticks[index].coordinate + offset : null;
        var value = getValueByDataKey(entry, axis.dataKey, axis.domain[index]);
        return __WEBPACK_IMPORTED_MODULE_10_lodash_isNil___default()(value) ? null : axis.scale(value) - bandSize / 2 + offset;
    }, getBaseValueOfBar = function(_ref8) {
        var numericAxis = _ref8.numericAxis, domain = numericAxis.scale.domain();
        if ("number" === numericAxis.type) {
            var min = Math.min(domain[0], domain[1]), max = Math.max(domain[0], domain[1]);
            return min <= 0 && max >= 0 ? 0 : max < 0 ? max : min;
        }
        return domain[0];
    }, detectReferenceElementsDomain = function(children, domain, axisId, axisType, specifiedTicks) {
        var lines = Object(__WEBPACK_IMPORTED_MODULE_20__ReactUtils__.h)(children, __WEBPACK_IMPORTED_MODULE_16__cartesian_ReferenceLine__.a), dots = Object(__WEBPACK_IMPORTED_MODULE_20__ReactUtils__.h)(children, __WEBPACK_IMPORTED_MODULE_15__cartesian_ReferenceDot__.a), elements = lines.concat(dots), areas = Object(__WEBPACK_IMPORTED_MODULE_20__ReactUtils__.h)(children, __WEBPACK_IMPORTED_MODULE_17__cartesian_ReferenceArea__.a), idKey = axisType + "Id", valueKey = axisType[0], finalDomain = domain;
        if (elements.length && (finalDomain = elements.reduce(function(result, el) {
            if (el.props[idKey] === axisId && el.props.alwaysShow && Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(el.props[valueKey])) {
                var value = el.props[valueKey];
                return [ Math.min(result[0], value), Math.max(result[1], value) ];
            }
            return result;
        }, finalDomain)), areas.length) {
            var key1 = valueKey + "1", key2 = valueKey + "2";
            finalDomain = areas.reduce(function(result, el) {
                if (el.props[idKey] === axisId && el.props.alwaysShow && Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(el.props[key1]) && Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(el.props[key2])) {
                    var value1 = el.props[key1], value2 = el.props[key2];
                    return [ Math.min(result[0], value1, value2), Math.max(result[1], value1, value2) ];
                }
                return result;
            }, finalDomain);
        }
        return specifiedTicks && specifiedTicks.length && (finalDomain = specifiedTicks.reduce(function(result, tick) {
            return Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(tick) ? [ Math.min(result[0], tick), Math.max(result[1], tick) ] : result;
        }, finalDomain)), finalDomain;
    }, getStackedDataOfItem = function(item, stackGroups) {
        var stackId = item.props.stackId;
        if (Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.g)(stackId)) {
            var group = stackGroups[stackId];
            if (group && group.items.length) {
                for (var itemIndex = -1, i = 0, len = group.items.length; i < len; i++) if (group.items[i] === item) {
                    itemIndex = i;
                    break;
                }
                return itemIndex >= 0 ? group.stackedData[itemIndex] : null;
            }
        }
        return null;
    }, getDomainOfSingle = function(data) {
        return data.reduce(function(result, entry) {
            return [ Math.min.apply(null, entry.concat([ result[0] ]).filter(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)), Math.max.apply(null, entry.concat([ result[1] ]).filter(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)) ];
        }, [ 1 / 0, -1 / 0 ]);
    }, getDomainOfStackGroups = function(stackGroups, startIndex, endIndex) {
        return Object.keys(stackGroups).reduce(function(result, stackId) {
            var group = stackGroups[stackId], stackedData = group.stackedData, domain = stackedData.reduce(function(res, entry) {
                var s = getDomainOfSingle(entry.slice(startIndex, endIndex + 1));
                return [ Math.min(res[0], s[0]), Math.max(res[1], s[1]) ];
            }, [ 1 / 0, -1 / 0 ]);
            return [ Math.min(domain[0], result[0]), Math.max(domain[1], result[1]) ];
        }, [ 1 / 0, -1 / 0 ]).map(function(result) {
            return result === 1 / 0 || result === -1 / 0 ? 0 : result;
        });
    }, MIN_VALUE_REG = /^dataMin[\s]*-[\s]*([0-9]+([.]{1}[0-9]+){0,1})$/, MAX_VALUE_REG = /^dataMax[\s]*\+[\s]*([0-9]+([.]{1}[0-9]+){0,1})$/, parseSpecifiedDomain = function(specifiedDomain, dataDomain, allowDataOverflow) {
        if (!__WEBPACK_IMPORTED_MODULE_6_lodash_isArray___default()(specifiedDomain)) return dataDomain;
        var domain = [];
        if (Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(specifiedDomain[0])) domain[0] = allowDataOverflow ? specifiedDomain[0] : Math.min(specifiedDomain[0], dataDomain[0]); else if (MIN_VALUE_REG.test(specifiedDomain[0])) {
            var value = +MIN_VALUE_REG.exec(specifiedDomain[0])[1];
            domain[0] = dataDomain[0] - value;
        } else __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction___default()(specifiedDomain[0]) ? domain[0] = specifiedDomain[0](dataDomain[0]) : domain[0] = dataDomain[0];
        if (Object(__WEBPACK_IMPORTED_MODULE_14__DataUtils__.h)(specifiedDomain[1])) domain[1] = allowDataOverflow ? specifiedDomain[1] : Math.max(specifiedDomain[1], dataDomain[1]); else if (MAX_VALUE_REG.test(specifiedDomain[1])) {
            var _value = +MAX_VALUE_REG.exec(specifiedDomain[1])[1];
            domain[1] = dataDomain[1] + _value;
        } else __WEBPACK_IMPORTED_MODULE_8_lodash_isFunction___default()(specifiedDomain[1]) ? domain[1] = specifiedDomain[1](dataDomain[1]) : domain[1] = dataDomain[1];
        return domain;
    }, validateCoordinateInRange = function(coordinate, scale) {
        if (!scale) return !1;
        var range = scale.range(), first = range[0], last = range[range.length - 1];
        return first <= last ? coordinate >= first && coordinate <= last : coordinate >= last && coordinate <= first;
    }, getBandSizeOfAxis = function(axis, ticks) {
        if (axis && axis.scale && axis.scale.bandwidth) return axis.scale.bandwidth();
        if (axis && ticks && ticks.length >= 2) {
            for (var orderedTicks = __WEBPACK_IMPORTED_MODULE_1_lodash_sortBy___default()(ticks, function(o) {
                return o.coordinate;
            }), bandSize = 1 / 0, i = 1, len = orderedTicks.length; i < len; i++) {
                var cur = orderedTicks[i], prev = orderedTicks[i - 1];
                bandSize = Math.min((cur.coordinate || 0) - (prev.coordinate || 0), bandSize);
            }
            return bandSize === 1 / 0 ? 0 : bandSize;
        }
        return 0;
    }, parseDomainOfCategoryAxis = function(specifiedDomain, calculatedDomain, axisChild) {
        return specifiedDomain && specifiedDomain.length ? __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default()(specifiedDomain, __WEBPACK_IMPORTED_MODULE_9_lodash_get___default()(axisChild, "type.defaultProps.domain")) ? calculatedDomain : specifiedDomain : calculatedDomain;
    };
}, function(module, exports) {
    var core = module.exports = {
        version: "2.5.7"
    };
    "number" == typeof __e && (__e = core);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function newInterval(floori, offseti, count, field) {
        function interval(date) {
            return floori(date = new Date(+date)), date;
        }
        return interval.floor = interval, interval.ceil = function(date) {
            return floori(date = new Date(date - 1)), offseti(date, 1), floori(date), date;
        }, interval.round = function(date) {
            var d0 = interval(date), d1 = interval.ceil(date);
            return date - d0 < d1 - date ? d0 : d1;
        }, interval.offset = function(date, step) {
            return offseti(date = new Date(+date), null == step ? 1 : Math.floor(step)), date;
        }, interval.range = function(start, stop, step) {
            var previous, range = [];
            if (start = interval.ceil(start), step = null == step ? 1 : Math.floor(step), !(start < stop && step > 0)) return range;
            do {
                range.push(previous = new Date(+start)), offseti(start, step), floori(start);
            } while (previous < start && start < stop);
            return range;
        }, interval.filter = function(test) {
            return newInterval(function(date) {
                if (date >= date) for (;floori(date), !test(date); ) date.setTime(date - 1);
            }, function(date, step) {
                if (date >= date) if (step < 0) for (;++step <= 0; ) for (;offseti(date, -1), !test(date); ) ; else for (;--step >= 0; ) for (;offseti(date, 1), 
                !test(date); ) ;
            });
        }, count && (interval.count = function(start, end) {
            return t0.setTime(+start), t1.setTime(+end), floori(t0), floori(t1), Math.floor(count(t0, t1));
        }, interval.every = function(step) {
            return step = Math.floor(step), isFinite(step) && step > 0 ? step > 1 ? interval.filter(field ? function(d) {
                return field(d) % step == 0;
            } : function(d) {
                return interval.count(0, d) % step == 0;
            }) : interval : null;
        }), interval;
    }
    __webpack_exports__.a = newInterval;
    var t0 = new Date(), t1 = new Date();
}, function(module, exports, __webpack_require__) {
    var global = __webpack_require__(24), core = __webpack_require__(17), ctx = __webpack_require__(51), hide = __webpack_require__(39), has = __webpack_require__(54), $export = function(type, name, source) {
        var key, own, out, IS_FORCED = type & $export.F, IS_GLOBAL = type & $export.G, IS_STATIC = type & $export.S, IS_PROTO = type & $export.P, IS_BIND = type & $export.B, IS_WRAP = type & $export.W, exports = IS_GLOBAL ? core : core[name] || (core[name] = {}), expProto = exports.prototype, target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {}).prototype;
        IS_GLOBAL && (source = name);
        for (key in source) (own = !IS_FORCED && target && void 0 !== target[key]) && has(exports, key) || (out = own ? target[key] : source[key], 
        exports[key] = IS_GLOBAL && "function" != typeof target[key] ? source[key] : IS_BIND && own ? ctx(out, global) : IS_WRAP && target[key] == out ? function(C) {
            var F = function(a, b, c) {
                if (this instanceof C) {
                    switch (arguments.length) {
                      case 0:
                        return new C();

                      case 1:
                        return new C(a);

                      case 2:
                        return new C(a, b);
                    }
                    return new C(a, b, c);
                }
                return C.apply(this, arguments);
            };
            return F.prototype = C.prototype, F;
        }(out) : IS_PROTO && "function" == typeof out ? ctx(Function.call, out) : out, IS_PROTO && ((exports.virtual || (exports.virtual = {}))[key] = out, 
        type & $export.R && expProto && !expProto[key] && hide(expProto, key, out)));
    };
    $export.F = 1, $export.G = 2, $export.S = 4, $export.P = 8, $export.B = 16, $export.W = 32, 
    $export.U = 64, $export.R = 128, module.exports = $export;
}, function(module, exports) {
    function isNil(value) {
        return null == value;
    }
    module.exports = isNil;
}, function(module, exports, __webpack_require__) {
    var store = __webpack_require__(151)("wks"), uid = __webpack_require__(103), Symbol = __webpack_require__(24).Symbol, USE_SYMBOL = "function" == typeof Symbol;
    (module.exports = function(name) {
        return store[name] || (store[name] = USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)("Symbol." + name));
    }).store = store;
}, function(module, exports, __webpack_require__) {
    var anObject = __webpack_require__(52), IE8_DOM_DEFINE = __webpack_require__(224), toPrimitive = __webpack_require__(145), dP = Object.defineProperty;
    exports.f = __webpack_require__(25) ? Object.defineProperty : function(O, P, Attributes) {
        if (anObject(O), P = toPrimitive(P, !0), anObject(Attributes), IE8_DOM_DEFINE) try {
            return dP(O, P, Attributes);
        } catch (e) {}
        if ("get" in Attributes || "set" in Attributes) throw TypeError("Accessors not supported!");
        return "value" in Attributes && (O[P] = Attributes.value), O;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _defineProperty(obj, key, value) {
        return key in obj ? Object.defineProperty(obj, key, {
            value: value,
            enumerable: !0,
            configurable: !0,
            writable: !0
        }) : obj[key] = value, obj;
    }
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return RADIAN;
    }), __webpack_require__.d(__webpack_exports__, "e", function() {
        return polarToCartesian;
    }), __webpack_require__.d(__webpack_exports__, "c", function() {
        return getMaxRadius;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return formatAxisMap;
    }), __webpack_require__.d(__webpack_exports__, "d", function() {
        return inRangeOfSector;
    });
    var __WEBPACK_IMPORTED_MODULE_0_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_1__DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_2__ChartUtils__ = __webpack_require__(16), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, RADIAN = Math.PI / 180, radianToDegree = function(angleInRadian) {
        return 180 * angleInRadian / Math.PI;
    }, polarToCartesian = function(cx, cy, radius, angle) {
        return {
            x: cx + Math.cos(-RADIAN * angle) * radius,
            y: cy + Math.sin(-RADIAN * angle) * radius
        };
    }, getMaxRadius = function(width, height) {
        var offset = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {
            top: 0,
            right: 0,
            bottom: 0,
            left: 0
        };
        return Math.min(Math.abs(width - (offset.left || 0) - (offset.right || 0)), Math.abs(height - (offset.top || 0) - (offset.bottom || 0))) / 2;
    }, formatAxisMap = function(props, axisMap, offset, axisType, chartName) {
        var width = props.width, height = props.height, startAngle = props.startAngle, endAngle = props.endAngle, cx = Object(__WEBPACK_IMPORTED_MODULE_1__DataUtils__.d)(props.cx, width, width / 2), cy = Object(__WEBPACK_IMPORTED_MODULE_1__DataUtils__.d)(props.cy, height, height / 2), maxRadius = getMaxRadius(width, height, offset), innerRadius = Object(__WEBPACK_IMPORTED_MODULE_1__DataUtils__.d)(props.innerRadius, maxRadius, 0), outerRadius = Object(__WEBPACK_IMPORTED_MODULE_1__DataUtils__.d)(props.outerRadius, maxRadius, .8 * maxRadius);
        return Object.keys(axisMap).reduce(function(result, id) {
            var axis = axisMap[id], domain = axis.domain, reversed = axis.reversed, range = void 0;
            __WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default()(axis.range) ? ("angleAxis" === axisType ? range = [ startAngle, endAngle ] : "radiusAxis" === axisType && (range = [ innerRadius, outerRadius ]), 
            reversed && (range = [ range[1], range[0] ])) : (range = axis.range, startAngle = range[0], 
            endAngle = range[1]);
            var _parseScale = Object(__WEBPACK_IMPORTED_MODULE_2__ChartUtils__.A)(axis, chartName), realScaleType = _parseScale.realScaleType, scale = _parseScale.scale;
            scale.domain(domain).range(range), Object(__WEBPACK_IMPORTED_MODULE_2__ChartUtils__.c)(scale);
            var ticks = Object(__WEBPACK_IMPORTED_MODULE_2__ChartUtils__.v)(scale, _extends({}, axis, {
                realScaleType: realScaleType
            })), finalAxis = _extends({}, axis, ticks, {
                range: range,
                radius: outerRadius,
                realScaleType: realScaleType,
                scale: scale,
                cx: cx,
                cy: cy,
                innerRadius: innerRadius,
                outerRadius: outerRadius,
                startAngle: startAngle,
                endAngle: endAngle
            });
            return _extends({}, result, _defineProperty({}, id, finalAxis));
        }, {});
    }, distanceBetweenPoints = function(point, anotherPoint) {
        var x1 = point.x, y1 = point.y, x2 = anotherPoint.x, y2 = anotherPoint.y;
        return Math.sqrt(Math.pow(x1 - x2, 2) + Math.pow(y1 - y2, 2));
    }, getAngleOfPoint = function(_ref, _ref2) {
        var x = _ref.x, y = _ref.y, cx = _ref2.cx, cy = _ref2.cy, radius = distanceBetweenPoints({
            x: x,
            y: y
        }, {
            x: cx,
            y: cy
        });
        if (radius <= 0) return {
            radius: radius
        };
        var cos = (x - cx) / radius, angleInRadian = Math.acos(cos);
        return y > cy && (angleInRadian = 2 * Math.PI - angleInRadian), {
            radius: radius,
            angle: radianToDegree(angleInRadian),
            angleInRadian: angleInRadian
        };
    }, formatAngleOfSector = function(_ref3) {
        var startAngle = _ref3.startAngle, endAngle = _ref3.endAngle, startCnt = Math.floor(startAngle / 360), endCnt = Math.floor(endAngle / 360), min = Math.min(startCnt, endCnt);
        return {
            startAngle: startAngle - 360 * min,
            endAngle: endAngle - 360 * min
        };
    }, reverseFormatAngleOfSetor = function(angle, _ref4) {
        var startAngle = _ref4.startAngle, endAngle = _ref4.endAngle, startCnt = Math.floor(startAngle / 360), endCnt = Math.floor(endAngle / 360);
        return angle + 360 * Math.min(startCnt, endCnt);
    }, inRangeOfSector = function(_ref5, sector) {
        var x = _ref5.x, y = _ref5.y, _getAngleOfPoint = getAngleOfPoint({
            x: x,
            y: y
        }, sector), radius = _getAngleOfPoint.radius, angle = _getAngleOfPoint.angle, innerRadius = sector.innerRadius, outerRadius = sector.outerRadius;
        if (radius < innerRadius || radius > outerRadius) return !1;
        if (0 === radius) return !0;
        var _formatAngleOfSector = formatAngleOfSector(sector), startAngle = _formatAngleOfSector.startAngle, endAngle = _formatAngleOfSector.endAngle, formatAngle = angle, inRange = void 0;
        if (startAngle <= endAngle) {
            for (;formatAngle > endAngle; ) formatAngle -= 360;
            for (;formatAngle < startAngle; ) formatAngle += 360;
            inRange = formatAngle >= startAngle && formatAngle <= endAngle;
        } else {
            for (;formatAngle > startAngle; ) formatAngle -= 360;
            for (;formatAngle < endAngle; ) formatAngle += 360;
            inRange = formatAngle >= endAngle && formatAngle <= startAngle;
        }
        return inRange ? _extends({}, sector, {
            radius: radius,
            angle: reverseFormatAngleOfSetor(formatAngle, sector)
        }) : null;
    };
}, function(module, exports) {
    var global = module.exports = "undefined" != typeof window && window.Math == Math ? window : "undefined" != typeof self && self.Math == Math ? self : Function("return this")();
    "number" == typeof __g && (__g = global);
}, function(module, exports, __webpack_require__) {
    module.exports = !__webpack_require__(53)(function() {
        return 7 != Object.defineProperty({}, "a", {
            get: function() {
                return 7;
            }
        }).a;
    });
}, function(module, exports, __webpack_require__) {
    module.exports = {
        default: __webpack_require__(394),
        __esModule: !0
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    exports.__esModule = !0, exports.default = function(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    exports.__esModule = !0;
    var _defineProperty = __webpack_require__(154), _defineProperty2 = function(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }(_defineProperty);
    exports.default = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), (0, _defineProperty2.default)(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }();
}, function(module, exports, __webpack_require__) {
    "use strict";
    exports.__esModule = !0;
    var _typeof2 = __webpack_require__(105), _typeof3 = function(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }(_typeof2);
    exports.default = function(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" !== (void 0 === call ? "undefined" : (0, _typeof3.default)(call)) && "function" != typeof call ? self : call;
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    exports.__esModule = !0;
    var _setPrototypeOf = __webpack_require__(411), _setPrototypeOf2 = _interopRequireDefault(_setPrototypeOf), _create = __webpack_require__(415), _create2 = _interopRequireDefault(_create), _typeof2 = __webpack_require__(105), _typeof3 = _interopRequireDefault(_typeof2);
    exports.default = function(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + (void 0 === superClass ? "undefined" : (0, 
        _typeof3.default)(superClass)));
        subClass.prototype = (0, _create2.default)(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (_setPrototypeOf2.default ? (0, _setPrototypeOf2.default)(subClass, superClass) : subClass.__proto__ = superClass);
    };
}, function(module, exports, __webpack_require__) {
    var freeGlobal = __webpack_require__(268), freeSelf = "object" == typeof self && self && self.Object === Object && self, root = freeGlobal || freeSelf || Function("return this")();
    module.exports = root;
}, function(module, exports) {
    function isObject(value) {
        var type = typeof value;
        return null != value && ("object" == type || "function" == type);
    }
    module.exports = isObject;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.translateStyle = exports.AnimateGroup = exports.configBezier = exports.configSpring = void 0;
    var _Animate = __webpack_require__(287), _Animate2 = _interopRequireDefault(_Animate), _easing = __webpack_require__(305), _util = __webpack_require__(132), _AnimateGroup = __webpack_require__(762), _AnimateGroup2 = _interopRequireDefault(_AnimateGroup);
    exports.configSpring = _easing.configSpring, exports.configBezier = _easing.configBezier, 
    exports.AnimateGroup = _AnimateGroup2.default, exports.translateStyle = _util.translateStyle, 
    exports.default = _Animate2.default;
}, function(module, exports) {
    var isArray = Array.isArray;
    module.exports = isArray;
}, function(module, exports) {
    module.exports = function(it) {
        return "object" == typeof it ? null !== it : "function" == typeof it;
    };
}, function(module, exports, __webpack_require__) {
    var freeGlobal = __webpack_require__(292), freeSelf = "object" == typeof self && self && self.Object === Object && self, root = freeGlobal || freeSelf || Function("return this")();
    module.exports = root;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__src_bisect__ = __webpack_require__(332);
    __webpack_require__.d(__webpack_exports__, "b", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_bisect__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_1__src_ascending__ = __webpack_require__(69);
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return __WEBPACK_IMPORTED_MODULE_1__src_ascending__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_2__src_bisector__ = __webpack_require__(333);
    __webpack_require__.d(__webpack_exports__, "c", function() {
        return __WEBPACK_IMPORTED_MODULE_2__src_bisector__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_18__src_quantile__ = (__webpack_require__(848), __webpack_require__(849), 
    __webpack_require__(335), __webpack_require__(337), __webpack_require__(850), __webpack_require__(853), 
    __webpack_require__(854), __webpack_require__(341), __webpack_require__(855), __webpack_require__(856), 
    __webpack_require__(857), __webpack_require__(858), __webpack_require__(342), __webpack_require__(334), 
    __webpack_require__(859), __webpack_require__(204));
    __webpack_require__.d(__webpack_exports__, "d", function() {
        return __WEBPACK_IMPORTED_MODULE_18__src_quantile__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_19__src_range__ = __webpack_require__(339);
    __webpack_require__.d(__webpack_exports__, "e", function() {
        return __WEBPACK_IMPORTED_MODULE_19__src_range__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_23__src_ticks__ = (__webpack_require__(860), __webpack_require__(861), 
    __webpack_require__(862), __webpack_require__(340));
    __webpack_require__.d(__webpack_exports__, "h", function() {
        return __WEBPACK_IMPORTED_MODULE_23__src_ticks__.a;
    }), __webpack_require__.d(__webpack_exports__, "f", function() {
        return __WEBPACK_IMPORTED_MODULE_23__src_ticks__.b;
    }), __webpack_require__.d(__webpack_exports__, "g", function() {
        return __WEBPACK_IMPORTED_MODULE_23__src_ticks__.c;
    });
    __webpack_require__(343), __webpack_require__(336), __webpack_require__(863);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_require__.d(__webpack_exports__, "d", function() {
        return durationSecond;
    }), __webpack_require__.d(__webpack_exports__, "c", function() {
        return durationMinute;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return durationHour;
    }), __webpack_require__.d(__webpack_exports__, "a", function() {
        return durationDay;
    }), __webpack_require__.d(__webpack_exports__, "e", function() {
        return durationWeek;
    });
    var durationSecond = 1e3, durationMinute = 6e4, durationHour = 36e5, durationDay = 864e5, durationWeek = 6048e5;
}, function(module, exports, __webpack_require__) {
    var dP = __webpack_require__(22), createDesc = __webpack_require__(75);
    module.exports = __webpack_require__(25) ? function(object, key, value) {
        return dP.f(object, key, createDesc(1, value));
    } : function(object, key, value) {
        return object[key] = value, object;
    };
}, function(module, exports) {
    var g;
    g = function() {
        return this;
    }();
    try {
        g = g || Function("return this")() || (0, eval)("this");
    } catch (e) {
        "object" == typeof window && (g = window);
    }
    module.exports = g;
}, function(module, exports, __webpack_require__) {
    function baseGetTag(value) {
        return null == value ? void 0 === value ? undefinedTag : nullTag : symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
    }
    var Symbol = __webpack_require__(83), getRawTag = __webpack_require__(603), objectToString = __webpack_require__(604), nullTag = "[object Null]", undefinedTag = "[object Undefined]", symToStringTag = Symbol ? Symbol.toStringTag : void 0;
    module.exports = baseGetTag;
}, function(module, exports) {
    function isObjectLike(value) {
        return null != value && "object" == typeof value;
    }
    module.exports = isObjectLike;
}, function(module, exports) {
    function isObjectLike(value) {
        return null != value && "object" == typeof value;
    }
    module.exports = isObjectLike;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    function Label(props) {
        var viewBox = props.viewBox, position = props.position, value = props.value, children = props.children, content = props.content, _props$className = props.className, className = void 0 === _props$className ? "" : _props$className;
        if (!viewBox || __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(value) && __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(children) && !Object(__WEBPACK_IMPORTED_MODULE_3_react__.isValidElement)(content) && !__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(content)) return null;
        if (Object(__WEBPACK_IMPORTED_MODULE_3_react__.isValidElement)(content)) return Object(__WEBPACK_IMPORTED_MODULE_3_react__.cloneElement)(content, props);
        var label = void 0;
        if (__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(content)) {
            if (label = content(props), Object(__WEBPACK_IMPORTED_MODULE_3_react__.isValidElement)(label)) return label;
        } else label = getLabel(props);
        var isPolarLabel = isPolar(viewBox), attrs = Object(__WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__.k)(props);
        if (isPolarLabel && ("insideStart" === position || "insideEnd" === position || "end" === position)) return renderRadialLabel(props, label, attrs);
        var positionAttrs = isPolarLabel ? getAttrsOfPolarLabel(props) : getAttrsOfCartesianLabel(props);
        return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__Text__.a, _extends({
            className: __WEBPACK_IMPORTED_MODULE_5_classnames___default()("recharts-label", className)
        }, attrs, positionAttrs), label);
    }
    var __WEBPACK_IMPORTED_MODULE_0_lodash_isObject__ = __webpack_require__(32), __WEBPACK_IMPORTED_MODULE_0_lodash_isObject___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isObject__), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_2_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_3_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_3_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_react__), __WEBPACK_IMPORTED_MODULE_4_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_4_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_prop_types__), __WEBPACK_IMPORTED_MODULE_5_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_5_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_classnames__), __WEBPACK_IMPORTED_MODULE_6__Text__ = __webpack_require__(61), __WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_8__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__ = __webpack_require__(23), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, cartesianViewBoxShape = __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.shape({
        x: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        y: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        width: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        height: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number
    }), polarViewBoxShape = __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.shape({
        cx: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        cy: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        innerRadius: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        outerRadius: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        startAngle: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        endAngle: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number
    }), propTypes = {
        viewBox: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ cartesianViewBoxShape, polarViewBoxShape ]),
        formatter: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func,
        value: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string ]),
        offset: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        position: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "top", "left", "right", "bottom", "inside", "outside", "insideLeft", "insideRight", "insideTop", "insideBottom", "insideTopLeft", "insideBottomLeft", "insideTopRight", "insideBottomRight", "insideStart", "insideEnd", "end", "center" ]),
        children: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.node), __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.node ]),
        className: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string,
        content: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func ])
    }, defaultProps = {
        offset: 5
    }, getLabel = function(props) {
        var value = props.value, formatter = props.formatter, label = __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(props.children) ? value : props.children;
        return __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(formatter) ? formatter(label) : label;
    }, getDeltaAngle = function(startAngle, endAngle) {
        return Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.j)(endAngle - startAngle) * Math.min(Math.abs(endAngle - startAngle), 360);
    }, renderRadialLabel = function(labelProps, label, attrs) {
        var position = labelProps.position, viewBox = labelProps.viewBox, offset = labelProps.offset, className = labelProps.className, cx = viewBox.cx, cy = viewBox.cy, innerRadius = viewBox.innerRadius, outerRadius = viewBox.outerRadius, startAngle = viewBox.startAngle, endAngle = viewBox.endAngle, clockWise = viewBox.clockWise, radius = (innerRadius + outerRadius) / 2, deltaAngle = getDeltaAngle(startAngle, endAngle), sign = deltaAngle >= 0 ? 1 : -1, labelAngle = void 0, direction = void 0;
        "insideStart" === position ? (labelAngle = startAngle + sign * offset, direction = clockWise) : "insideEnd" === position ? (labelAngle = endAngle - sign * offset, 
        direction = !clockWise) : "end" === position && (labelAngle = endAngle + sign * offset, 
        direction = clockWise), direction = deltaAngle <= 0 ? direction : !direction;
        var startPoint = Object(__WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__.e)(cx, cy, radius, labelAngle), endPoint = Object(__WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__.e)(cx, cy, radius, labelAngle + 359 * (direction ? 1 : -1)), path = "M" + startPoint.x + "," + startPoint.y + "\n    A" + radius + "," + radius + ",0,1," + (direction ? 0 : 1) + ",\n    " + endPoint.x + "," + endPoint.y, id = __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(labelProps.id) ? Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.k)("recharts-radial-line-") : labelProps.id;
        return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("text", _extends({}, attrs, {
            dominantBaseline: "central",
            className: __WEBPACK_IMPORTED_MODULE_5_classnames___default()("recharts-radial-bar-label", className)
        }), __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("defs", null, __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("path", {
            id: id,
            d: path
        })), __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("textPath", {
            xlinkHref: "#" + id
        }, label));
    }, getAttrsOfPolarLabel = function(props) {
        var viewBox = props.viewBox, offset = props.offset, position = props.position, cx = viewBox.cx, cy = viewBox.cy, innerRadius = viewBox.innerRadius, outerRadius = viewBox.outerRadius, startAngle = viewBox.startAngle, endAngle = viewBox.endAngle, midAngle = (startAngle + endAngle) / 2;
        if ("outside" === position) {
            var _polarToCartesian = Object(__WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__.e)(cx, cy, outerRadius + offset, midAngle), _x = _polarToCartesian.x;
            return {
                x: _x,
                y: _polarToCartesian.y,
                textAnchor: _x >= cx ? "start" : "end",
                verticalAnchor: "middle"
            };
        }
        if ("center" === position) return {
            x: cx,
            y: cy,
            textAnchor: "middle",
            verticalAnchor: "middle"
        };
        var r = (innerRadius + outerRadius) / 2, _polarToCartesian2 = Object(__WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__.e)(cx, cy, r, midAngle);
        return {
            x: _polarToCartesian2.x,
            y: _polarToCartesian2.y,
            textAnchor: "middle",
            verticalAnchor: "middle"
        };
    }, getAttrsOfCartesianLabel = function(props) {
        var viewBox = props.viewBox, offset = props.offset, position = props.position, x = viewBox.x, y = viewBox.y, width = viewBox.width, height = viewBox.height, sign = height >= 0 ? 1 : -1;
        return "top" === position ? {
            x: x + width / 2,
            y: y - sign * offset,
            textAnchor: "middle",
            verticalAnchor: "end"
        } : "bottom" === position ? {
            x: x + width / 2,
            y: y + height + sign * offset,
            textAnchor: "middle",
            verticalAnchor: "start"
        } : "left" === position ? {
            x: x - offset,
            y: y + height / 2,
            textAnchor: "end",
            verticalAnchor: "middle"
        } : "right" === position ? {
            x: x + width + offset,
            y: y + height / 2,
            textAnchor: "start",
            verticalAnchor: "middle"
        } : "insideLeft" === position ? {
            x: x + offset,
            y: y + height / 2,
            textAnchor: "start",
            verticalAnchor: "middle"
        } : "insideRight" === position ? {
            x: x + width - offset,
            y: y + height / 2,
            textAnchor: "end",
            verticalAnchor: "middle"
        } : "insideTop" === position ? {
            x: x + width / 2,
            y: y + sign * offset,
            textAnchor: "middle",
            verticalAnchor: "start"
        } : "insideBottom" === position ? {
            x: x + width / 2,
            y: y + height - sign * offset,
            textAnchor: "middle",
            verticalAnchor: "end"
        } : "insideTopLeft" === position ? {
            x: x + offset,
            y: y + sign * offset,
            textAnchor: "start",
            verticalAnchor: "start"
        } : "insideTopRight" === position ? {
            x: x + width - offset,
            y: y + sign * offset,
            textAnchor: "end",
            verticalAnchor: "start"
        } : "insideBottomLeft" === position ? {
            x: x + offset,
            y: y + height - sign * offset,
            textAnchor: "start",
            verticalAnchor: "end"
        } : "insideBottomRight" === position ? {
            x: x + width - offset,
            y: y + height - sign * offset,
            textAnchor: "end",
            verticalAnchor: "end"
        } : __WEBPACK_IMPORTED_MODULE_0_lodash_isObject___default()(position) && (Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(position.x) || Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.i)(position.x)) && (Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(position.y) || Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.i)(position.y)) ? {
            x: x + Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.d)(position.x, width),
            y: y + Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.d)(position.y, height),
            textAnchor: "end",
            verticalAnchor: "end"
        } : {
            x: x + width / 2,
            y: y + height / 2,
            textAnchor: "middle",
            verticalAnchor: "middle"
        };
    }, isPolar = function(viewBox) {
        return Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(viewBox.cx);
    };
    Label.displayName = "Label", Label.defaultProps = defaultProps, Label.propTypes = propTypes;
    var parseViewBox = function(props) {
        var cx = props.cx, cy = props.cy, angle = props.angle, startAngle = props.startAngle, endAngle = props.endAngle, r = props.r, radius = props.radius, innerRadius = props.innerRadius, outerRadius = props.outerRadius, x = props.x, y = props.y, top = props.top, left = props.left, width = props.width, height = props.height, clockWise = props.clockWise;
        if (Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(width) && Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(height)) {
            if (Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(x) && Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(y)) return {
                x: x,
                y: y,
                width: width,
                height: height
            };
            if (Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(top) && Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(left)) return {
                x: top,
                y: left,
                width: width,
                height: height
            };
        }
        return Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(x) && Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(y) ? {
            x: x,
            y: y,
            width: 0,
            height: 0
        } : Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(cx) && Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(cy) ? {
            cx: cx,
            cy: cy,
            startAngle: startAngle || angle || 0,
            endAngle: endAngle || angle || 0,
            innerRadius: innerRadius || 0,
            outerRadius: outerRadius || radius || r || 0,
            clockWise: clockWise
        } : props.viewBox ? props.viewBox : {};
    }, parseLabel = function(label, viewBox) {
        return label ? !0 === label ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(Label, {
            key: "label-implicit",
            viewBox: viewBox
        }) : Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.g)(label) ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(Label, {
            key: "label-implicit",
            viewBox: viewBox,
            value: label
        }) : Object(__WEBPACK_IMPORTED_MODULE_3_react__.isValidElement)(label) || __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(label) ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(Label, {
            key: "label-implicit",
            content: label,
            viewBox: viewBox
        }) : __WEBPACK_IMPORTED_MODULE_0_lodash_isObject___default()(label) ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(Label, _extends({
            viewBox: viewBox
        }, label, {
            key: "label-implicit"
        })) : null : null;
    }, renderCallByParent = function(parentProps, viewBox) {
        var ckeckPropsLabel = !(arguments.length > 2 && void 0 !== arguments[2]) || arguments[2];
        if (!parentProps || !parentProps.children && ckeckPropsLabel && !parentProps.label) return null;
        var children = parentProps.children, parentViewBox = parseViewBox(parentProps), explicitChilren = Object(__WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__.h)(children, Label).map(function(child, index) {
            return Object(__WEBPACK_IMPORTED_MODULE_3_react__.cloneElement)(child, {
                viewBox: viewBox || parentViewBox,
                key: "label-" + index
            });
        });
        return ckeckPropsLabel ? [ parseLabel(parentProps.label, viewBox || parentViewBox) ].concat(_toConsumableArray(explicitChilren)) : explicitChilren;
    };
    Label.parseViewBox = parseViewBox, Label.renderCallByParent = renderCallByParent, 
    __webpack_exports__.a = Label;
}, function(module, exports, __webpack_require__) {
    function isEqual(value, other) {
        return baseIsEqual(value, other);
    }
    var baseIsEqual = __webpack_require__(199);
    module.exports = isEqual;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__src_color__ = __webpack_require__(207);
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_color__.e;
    }), __webpack_require__.d(__webpack_exports__, "f", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_color__.g;
    }), __webpack_require__.d(__webpack_exports__, "d", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_color__.f;
    });
    var __WEBPACK_IMPORTED_MODULE_1__src_lab__ = __webpack_require__(871);
    __webpack_require__.d(__webpack_exports__, "e", function() {
        return __WEBPACK_IMPORTED_MODULE_1__src_lab__.a;
    }), __webpack_require__.d(__webpack_exports__, "c", function() {
        return __WEBPACK_IMPORTED_MODULE_1__src_lab__.b;
    });
    var __WEBPACK_IMPORTED_MODULE_2__src_cubehelix__ = __webpack_require__(872);
    __webpack_require__.d(__webpack_exports__, "b", function() {
        return __WEBPACK_IMPORTED_MODULE_2__src_cubehelix__.a;
    });
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function LabelList(props) {
        var data = props.data, valueAccessor = props.valueAccessor, dataKey = props.dataKey, clockWise = props.clockWise, id = props.id, others = _objectWithoutProperties(props, [ "data", "valueAccessor", "dataKey", "clockWise", "id" ]);
        return data && data.length ? __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
            className: "recharts-label-list"
        }, data.map(function(entry, index) {
            var value = __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(dataKey) ? valueAccessor(entry, index) : Object(__WEBPACK_IMPORTED_MODULE_10__util_ChartUtils__.w)(entry && entry.payload, dataKey), idProps = __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(id) ? {} : {
                id: id + "-" + index
            };
            return __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__Label__.a, _extends({}, Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(entry), others, idProps, {
                index: index,
                value: value,
                viewBox: __WEBPACK_IMPORTED_MODULE_7__Label__.a.parseViewBox(__WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(clockWise) ? entry : _extends({}, entry, {
                    clockWise: clockWise
                })),
                key: "label-" + index
            }));
        })) : null;
    }
    var __WEBPACK_IMPORTED_MODULE_0_lodash_isObject__ = __webpack_require__(32), __WEBPACK_IMPORTED_MODULE_0_lodash_isObject___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isObject__), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_2_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_3_lodash_last__ = __webpack_require__(922), __WEBPACK_IMPORTED_MODULE_3_lodash_last___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_lodash_last__), __WEBPACK_IMPORTED_MODULE_4_lodash_isArray__ = __webpack_require__(13), __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_lodash_isArray__), __WEBPACK_IMPORTED_MODULE_5_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_5_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_react__), __WEBPACK_IMPORTED_MODULE_6_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_6_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_prop_types__), __WEBPACK_IMPORTED_MODULE_7__Label__ = __webpack_require__(44), __WEBPACK_IMPORTED_MODULE_8__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_10__util_ChartUtils__ = __webpack_require__(16), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, propTypes = {
        id: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        data: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.object),
        valueAccessor: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        clockWise: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.bool,
        dataKey: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func ])
    }, defaultProps = {
        valueAccessor: function(entry) {
            return __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default()(entry.value) ? __WEBPACK_IMPORTED_MODULE_3_lodash_last___default()(entry.value) : entry.value;
        }
    };
    LabelList.propTypes = propTypes, LabelList.displayName = "LabelList";
    var parseLabelList = function(label, data) {
        return label ? !0 === label ? __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(LabelList, {
            key: "labelList-implicit",
            data: data
        }) : __WEBPACK_IMPORTED_MODULE_5_react___default.a.isValidElement(label) || __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(label) ? __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(LabelList, {
            key: "labelList-implicit",
            data: data,
            content: label
        }) : __WEBPACK_IMPORTED_MODULE_0_lodash_isObject___default()(label) ? __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(LabelList, _extends({
            data: data
        }, label, {
            key: "labelList-implicit"
        })) : null : null;
    }, renderCallByParent = function(parentProps, data) {
        var ckeckPropsLabel = !(arguments.length > 2 && void 0 !== arguments[2]) || arguments[2];
        if (!parentProps || !parentProps.children && ckeckPropsLabel && !parentProps.label) return null;
        var children = parentProps.children, explicitChilren = Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.h)(children, LabelList).map(function(child, index) {
            return Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(child, {
                data: data,
                key: "labelList-" + index
            });
        });
        return ckeckPropsLabel ? [ parseLabelList(parentProps.label, data) ].concat(_toConsumableArray(explicitChilren)) : explicitChilren;
    };
    LabelList.renderCallByParent = renderCallByParent, LabelList.defaultProps = defaultProps, 
    __webpack_exports__.a = LabelList;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function _defineProperty(obj, key, value) {
        return key in obj ? Object.defineProperty(obj, key, {
            value: value,
            enumerable: !0,
            configurable: !0,
            writable: !0
        }) : obj[key] = value, obj;
    }
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var __WEBPACK_IMPORTED_MODULE_0_lodash_sortBy__ = __webpack_require__(321), __WEBPACK_IMPORTED_MODULE_0_lodash_sortBy___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_sortBy__), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_2_lodash_range__ = __webpack_require__(373), __WEBPACK_IMPORTED_MODULE_2_lodash_range___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_range__), __WEBPACK_IMPORTED_MODULE_3_lodash_throttle__ = __webpack_require__(933), __WEBPACK_IMPORTED_MODULE_3_lodash_throttle___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_lodash_throttle__), __WEBPACK_IMPORTED_MODULE_4_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_5_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_5_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_react__), __WEBPACK_IMPORTED_MODULE_6_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_6_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_prop_types__), __WEBPACK_IMPORTED_MODULE_7_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_7_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_classnames__), __WEBPACK_IMPORTED_MODULE_8__container_Surface__ = __webpack_require__(82), __WEBPACK_IMPORTED_MODULE_9__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_10__component_Tooltip__ = __webpack_require__(125), __WEBPACK_IMPORTED_MODULE_11__component_Legend__ = __webpack_require__(180), __WEBPACK_IMPORTED_MODULE_12__shape_Curve__ = __webpack_require__(71), __WEBPACK_IMPORTED_MODULE_13__shape_Cross__ = __webpack_require__(367), __WEBPACK_IMPORTED_MODULE_14__shape_Sector__ = __webpack_require__(139), __WEBPACK_IMPORTED_MODULE_15__shape_Dot__ = __webpack_require__(63), __WEBPACK_IMPORTED_MODULE_16__shape_Rectangle__ = __webpack_require__(70), __WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_18__cartesian_CartesianAxis__ = __webpack_require__(374), __WEBPACK_IMPORTED_MODULE_19__cartesian_Brush__ = __webpack_require__(372), __WEBPACK_IMPORTED_MODULE_20__util_DOMUtils__ = __webpack_require__(198), __WEBPACK_IMPORTED_MODULE_21__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__ = __webpack_require__(16), __WEBPACK_IMPORTED_MODULE_23__util_PolarUtils__ = __webpack_require__(23), __WEBPACK_IMPORTED_MODULE_24__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_25__util_Events__ = __webpack_require__(934), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), ORIENT_MAP = {
        xAxis: [ "bottom", "top" ],
        yAxis: [ "left", "right" ]
    }, originCoordinate = {
        x: 0,
        y: 0
    }, generateCategoricalChart = function(_ref) {
        var _class, _temp, _initialiseProps, chartName = _ref.chartName, GraphicalChild = _ref.GraphicalChild, _ref$eventType = _ref.eventType, eventType = void 0 === _ref$eventType ? "axis" : _ref$eventType, axisComponents = _ref.axisComponents, legendContent = _ref.legendContent, formatAxisMap = _ref.formatAxisMap, defaultProps = _ref.defaultProps, propTypes = _ref.propTypes;
        return _temp = _class = function(_Component) {
            function CategoricalChartWrapper(props) {
                _classCallCheck(this, CategoricalChartWrapper);
                var _this = _possibleConstructorReturn(this, (CategoricalChartWrapper.__proto__ || Object.getPrototypeOf(CategoricalChartWrapper)).call(this, props));
                _initialiseProps.call(_this);
                var defaultState = _this.constructor.createDefaultState(props);
                return _this.state = _extends({}, defaultState, {
                    updateId: 0
                }, _this.updateStateOfAxisMapsOffsetAndStackGroups(_extends({
                    props: props
                }, defaultState, {
                    updateId: 0
                }))), _this.uniqueChartId = __WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(props.id) ? Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.k)("recharts") : props.id, 
                props.throttleDelay && (_this.triggeredAfterMouseMove = __WEBPACK_IMPORTED_MODULE_3_lodash_throttle___default()(_this.triggeredAfterMouseMove, props.throttleDelay)), 
                _this;
            }
            return _inherits(CategoricalChartWrapper, _Component), _createClass(CategoricalChartWrapper, [ {
                key: "componentDidMount",
                value: function() {
                    __WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(this.props.syncId) || this.addListener();
                }
            }, {
                key: "componentWillReceiveProps",
                value: function(nextProps) {
                    var _props = this.props, data = _props.data, children = _props.children, width = _props.width, height = _props.height, layout = _props.layout, stackOffset = _props.stackOffset, margin = _props.margin, updateId = this.state.updateId;
                    if (nextProps.data === data && nextProps.width === width && nextProps.height === height && nextProps.layout === layout && nextProps.stackOffset === stackOffset && Object(__WEBPACK_IMPORTED_MODULE_24__util_PureRender__.b)(nextProps.margin, margin)) {
                        if (!Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.m)(nextProps.children, children)) {
                            var hasGlobalData = !__WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(nextProps.data), newUpdateId = hasGlobalData ? updateId : updateId + 1, _state = this.state, dataStartIndex = _state.dataStartIndex, dataEndIndex = _state.dataEndIndex, _defaultState = _extends({}, this.constructor.createDefaultState(nextProps), {
                                dataEndIndex: dataEndIndex,
                                dataStartIndex: dataStartIndex
                            });
                            this.setState(_extends({}, _defaultState, {
                                updateId: newUpdateId
                            }, this.updateStateOfAxisMapsOffsetAndStackGroups(_extends({
                                props: nextProps
                            }, _defaultState, {
                                updateId: newUpdateId
                            }))));
                        }
                    } else {
                        var defaultState = this.constructor.createDefaultState(nextProps);
                        this.setState(_extends({}, defaultState, {
                            updateId: updateId + 1
                        }, this.updateStateOfAxisMapsOffsetAndStackGroups(_extends({
                            props: nextProps
                        }, defaultState, {
                            updateId: updateId + 1
                        }))));
                    }
                    __WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(this.props.syncId) && !__WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(nextProps.syncId) && this.addListener(), 
                    !__WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(this.props.syncId) && __WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(nextProps.syncId) && this.removeListener();
                }
            }, {
                key: "componentWillUnmount",
                value: function() {
                    __WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(this.props.syncId) || this.removeListener(), 
                    "function" == typeof this.triggeredAfterMouseMove.cancel && this.triggeredAfterMouseMove.cancel();
                }
            }, {
                key: "getAxisMap",
                value: function(props, _ref2) {
                    var _ref2$axisType = _ref2.axisType, axisType = void 0 === _ref2$axisType ? "xAxis" : _ref2$axisType, AxisComp = _ref2.AxisComp, graphicalItems = _ref2.graphicalItems, stackGroups = _ref2.stackGroups, dataStartIndex = _ref2.dataStartIndex, dataEndIndex = _ref2.dataEndIndex, children = props.children, axisIdKey = axisType + "Id", axes = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.h)(children, AxisComp), axisMap = {};
                    return axes && axes.length ? axisMap = this.getAxisMapByAxes(props, {
                        axes: axes,
                        graphicalItems: graphicalItems,
                        axisType: axisType,
                        axisIdKey: axisIdKey,
                        stackGroups: stackGroups,
                        dataStartIndex: dataStartIndex,
                        dataEndIndex: dataEndIndex
                    }) : graphicalItems && graphicalItems.length && (axisMap = this.getAxisMapByItems(props, {
                        Axis: AxisComp,
                        graphicalItems: graphicalItems,
                        axisType: axisType,
                        axisIdKey: axisIdKey,
                        stackGroups: stackGroups,
                        dataStartIndex: dataStartIndex,
                        dataEndIndex: dataEndIndex
                    })), axisMap;
                }
            }, {
                key: "getAxisMapByAxes",
                value: function(props, _ref3) {
                    var _this2 = this, axes = _ref3.axes, graphicalItems = _ref3.graphicalItems, axisType = _ref3.axisType, axisIdKey = _ref3.axisIdKey, stackGroups = _ref3.stackGroups, dataStartIndex = _ref3.dataStartIndex, dataEndIndex = _ref3.dataEndIndex, layout = props.layout, children = props.children, stackOffset = props.stackOffset, isCategorial = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.x)(layout, axisType);
                    return axes.reduce(function(result, child) {
                        var _child$props = child.props, type = _child$props.type, dataKey = _child$props.dataKey, allowDataOverflow = _child$props.allowDataOverflow, allowDuplicatedCategory = _child$props.allowDuplicatedCategory, scale = _child$props.scale, ticks = _child$props.ticks, axisId = child.props[axisIdKey], displayedData = _this2.constructor.getDisplayedData(props, {
                            graphicalItems: graphicalItems.filter(function(item) {
                                return item.props[axisIdKey] === axisId;
                            }),
                            dataStartIndex: dataStartIndex,
                            dataEndIndex: dataEndIndex
                        }), len = displayedData.length;
                        if (!result[axisId]) {
                            var domain = void 0, duplicateDomain = void 0, categoricalDomain = void 0;
                            if (dataKey) {
                                if (domain = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.n)(displayedData, dataKey, type), 
                                "category" === type && isCategorial) {
                                    var duplicate = Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.e)(domain);
                                    allowDuplicatedCategory && duplicate ? (duplicateDomain = domain, domain = __WEBPACK_IMPORTED_MODULE_2_lodash_range___default()(0, len)) : allowDuplicatedCategory || (domain = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.y)(child.props.domain, domain, child).reduce(function(finalDomain, entry) {
                                        return finalDomain.indexOf(entry) >= 0 ? finalDomain : [].concat(_toConsumableArray(finalDomain), [ entry ]);
                                    }, []));
                                } else if ("category" === type) domain = allowDuplicatedCategory ? domain.filter(function(entry) {
                                    return "" !== entry && !__WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(entry);
                                }) : Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.y)(child.props.domain, domain, child).reduce(function(finalDomain, entry) {
                                    return finalDomain.indexOf(entry) >= 0 || "" === entry || __WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(entry) ? finalDomain : [].concat(_toConsumableArray(finalDomain), [ entry ]);
                                }, []); else if ("number" === type) {
                                    var errorBarsDomain = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.z)(displayedData, graphicalItems.filter(function(item) {
                                        return item.props[axisIdKey] === axisId && !item.props.hide;
                                    }), dataKey, axisType);
                                    errorBarsDomain && (domain = errorBarsDomain);
                                }
                                !isCategorial || "number" !== type && "auto" === scale || (categoricalDomain = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.n)(displayedData, dataKey, "category"));
                            } else domain = isCategorial ? __WEBPACK_IMPORTED_MODULE_2_lodash_range___default()(0, len) : stackGroups && stackGroups[axisId] && stackGroups[axisId].hasStack && "number" === type ? "expand" === stackOffset ? [ 0, 1 ] : Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.p)(stackGroups[axisId].stackGroups, dataStartIndex, dataEndIndex) : Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.o)(displayedData, graphicalItems.filter(function(item) {
                                return item.props[axisIdKey] === axisId && !item.props.hide;
                            }), type, !0);
                            return "number" === type && (domain = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.e)(children, domain, axisId, axisType, ticks), 
                            child.props.domain && (domain = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.B)(child.props.domain, domain, allowDataOverflow))), 
                            _extends({}, result, _defineProperty({}, axisId, _extends({}, child.props, {
                                axisType: axisType,
                                domain: domain,
                                categoricalDomain: categoricalDomain,
                                duplicateDomain: duplicateDomain,
                                originalDomain: child.props.domain,
                                isCategorial: isCategorial,
                                layout: layout
                            })));
                        }
                        return result;
                    }, {});
                }
            }, {
                key: "getAxisMapByItems",
                value: function(props, _ref4) {
                    var graphicalItems = _ref4.graphicalItems, Axis = _ref4.Axis, axisType = _ref4.axisType, axisIdKey = _ref4.axisIdKey, stackGroups = _ref4.stackGroups, dataStartIndex = _ref4.dataStartIndex, dataEndIndex = _ref4.dataEndIndex, layout = props.layout, children = props.children, displayedData = this.constructor.getDisplayedData(props, {
                        graphicalItems: graphicalItems,
                        dataStartIndex: dataStartIndex,
                        dataEndIndex: dataEndIndex
                    }), len = displayedData.length, isCategorial = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.x)(layout, axisType), index = -1;
                    return graphicalItems.reduce(function(result, child) {
                        var axisId = child.props[axisIdKey];
                        if (!result[axisId]) {
                            index++;
                            var domain = void 0;
                            return isCategorial ? domain = __WEBPACK_IMPORTED_MODULE_2_lodash_range___default()(0, len) : stackGroups && stackGroups[axisId] && stackGroups[axisId].hasStack ? (domain = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.p)(stackGroups[axisId].stackGroups, dataStartIndex, dataEndIndex), 
                            domain = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.e)(children, domain, axisId, axisType)) : (domain = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.B)(Axis.defaultProps.domain, Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.o)(displayedData, graphicalItems.filter(function(item) {
                                return item.props[axisIdKey] === axisId && !item.props.hide;
                            }), "number"), Axis.defaultProps.allowDataOverflow), domain = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.e)(children, domain, axisId, axisType)), 
                            _extends({}, result, _defineProperty({}, axisId, _extends({
                                axisType: axisType
                            }, Axis.defaultProps, {
                                hide: !0,
                                orientation: ORIENT_MAP[axisType] && ORIENT_MAP[axisType][index % 2],
                                domain: domain,
                                originalDomain: Axis.defaultProps.domain,
                                isCategorial: isCategorial,
                                layout: layout
                            })));
                        }
                        return result;
                    }, {});
                }
            }, {
                key: "getActiveCoordinate",
                value: function(tooltipTicks, activeIndex, rangeObj) {
                    var layout = this.props.layout, entry = tooltipTicks.find(function(tick) {
                        return tick && tick.index === activeIndex;
                    });
                    if (entry) {
                        if ("horizontal" === layout) return {
                            x: entry.coordinate,
                            y: rangeObj.y
                        };
                        if ("vertical" === layout) return {
                            x: rangeObj.x,
                            y: entry.coordinate
                        };
                        if ("centric" === layout) {
                            var _angle = entry.coordinate, _radius = rangeObj.radius;
                            return _extends({}, rangeObj, Object(__WEBPACK_IMPORTED_MODULE_23__util_PolarUtils__.e)(rangeObj.cx, rangeObj.cy, _radius, _angle), {
                                angle: _angle,
                                radius: _radius
                            });
                        }
                        var radius = entry.coordinate, angle = rangeObj.angle;
                        return _extends({}, rangeObj, Object(__WEBPACK_IMPORTED_MODULE_23__util_PolarUtils__.e)(rangeObj.cx, rangeObj.cy, radius, angle), {
                            angle: angle,
                            radius: radius
                        });
                    }
                    return originCoordinate;
                }
            }, {
                key: "getMouseInfo",
                value: function(event) {
                    if (!this.container) return null;
                    var containerOffset = Object(__WEBPACK_IMPORTED_MODULE_20__util_DOMUtils__.b)(this.container), e = Object(__WEBPACK_IMPORTED_MODULE_20__util_DOMUtils__.a)(event, containerOffset), rangeObj = this.inRange(e.chartX, e.chartY);
                    if (!rangeObj) return null;
                    var _state2 = this.state, xAxisMap = _state2.xAxisMap, yAxisMap = _state2.yAxisMap;
                    if ("axis" !== eventType && xAxisMap && yAxisMap) {
                        var xScale = Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.b)(xAxisMap).scale, yScale = Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.b)(yAxisMap).scale, xValue = xScale && xScale.invert ? xScale.invert(e.chartX) : null, yValue = yScale && yScale.invert ? yScale.invert(e.chartY) : null;
                        return _extends({}, e, {
                            xValue: xValue,
                            yValue: yValue
                        });
                    }
                    var _state3 = this.state, ticks = _state3.orderedTooltipTicks, axis = _state3.tooltipAxis, tooltipTicks = _state3.tooltipTicks, pos = this.calculateTooltipPos(rangeObj), activeIndex = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.b)(pos, ticks, tooltipTicks, axis);
                    if (activeIndex >= 0 && tooltipTicks) {
                        var activeLabel = tooltipTicks[activeIndex] && tooltipTicks[activeIndex].value, activePayload = this.getTooltipContent(activeIndex, activeLabel), activeCoordinate = this.getActiveCoordinate(ticks, activeIndex, rangeObj);
                        return _extends({}, e, {
                            activeTooltipIndex: activeIndex,
                            activeLabel: activeLabel,
                            activePayload: activePayload,
                            activeCoordinate: activeCoordinate
                        });
                    }
                    return null;
                }
            }, {
                key: "getTooltipContent",
                value: function(activeIndex, activeLabel) {
                    var _state4 = this.state, graphicalItems = _state4.graphicalItems, tooltipAxis = _state4.tooltipAxis, displayedData = this.constructor.getDisplayedData(this.props, this.state);
                    return activeIndex < 0 || !graphicalItems || !graphicalItems.length || activeIndex >= displayedData.length ? null : graphicalItems.reduce(function(result, child) {
                        if (child.props.hide) return result;
                        var _child$props2 = child.props, dataKey = _child$props2.dataKey, name = _child$props2.name, unit = _child$props2.unit, formatter = _child$props2.formatter, data = _child$props2.data, payload = void 0;
                        return payload = tooltipAxis.dataKey && !tooltipAxis.allowDuplicatedCategory ? Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.a)(data || displayedData, tooltipAxis.dataKey, activeLabel) : displayedData[activeIndex], 
                        payload ? [].concat(_toConsumableArray(result), [ _extends({}, Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.k)(child), {
                            dataKey: dataKey,
                            unit: unit,
                            formatter: formatter,
                            name: name || dataKey,
                            color: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.r)(child),
                            value: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.w)(payload, dataKey),
                            payload: payload
                        }) ]) : result;
                    }, []);
                }
            }, {
                key: "getFormatItems",
                value: function(props, currentState) {
                    var _this3 = this, graphicalItems = currentState.graphicalItems, stackGroups = currentState.stackGroups, offset = currentState.offset, updateId = currentState.updateId, dataStartIndex = currentState.dataStartIndex, dataEndIndex = currentState.dataEndIndex, barSize = props.barSize, layout = props.layout, barGap = props.barGap, barCategoryGap = props.barCategoryGap, globalMaxBarSize = props.maxBarSize, _getAxisNameByLayout = this.getAxisNameByLayout(layout), numericAxisName = _getAxisNameByLayout.numericAxisName, cateAxisName = _getAxisNameByLayout.cateAxisName, hasBar = this.constructor.hasBar(graphicalItems), sizeList = hasBar && Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.i)({
                        barSize: barSize,
                        stackGroups: stackGroups
                    }), formatedItems = [];
                    return graphicalItems.forEach(function(item, index) {
                        var displayedData = _this3.constructor.getDisplayedData(props, {
                            dataStartIndex: dataStartIndex,
                            dataEndIndex: dataEndIndex
                        }, item), _item$props = item.props, dataKey = _item$props.dataKey, childMaxBarSize = _item$props.maxBarSize, numericAxisId = item.props[numericAxisName + "Id"], cateAxisId = item.props[cateAxisName + "Id"], axisObj = axisComponents.reduce(function(result, entry) {
                            var _extends4, axisMap = currentState[entry.axisType + "Map"], id = item.props[entry.axisType + "Id"], axis = axisMap && axisMap[id];
                            return _extends({}, result, (_extends4 = {}, _defineProperty(_extends4, entry.axisType, axis), 
                            _defineProperty(_extends4, entry.axisType + "Ticks", Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.u)(axis)), 
                            _extends4));
                        }, {}), cateAxis = axisObj[cateAxisName], cateTicks = axisObj[cateAxisName + "Ticks"], stackedData = stackGroups && stackGroups[numericAxisId] && stackGroups[numericAxisId].hasStack && Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.t)(item, stackGroups[numericAxisId].stackGroups), bandSize = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.g)(cateAxis, cateTicks), maxBarSize = __WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(childMaxBarSize) ? globalMaxBarSize : childMaxBarSize, barPosition = hasBar && Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.h)({
                            barGap: barGap,
                            barCategoryGap: barCategoryGap,
                            bandSize: bandSize,
                            sizeList: sizeList[cateAxisId],
                            maxBarSize: maxBarSize
                        }), componsedFn = item && item.type && item.type.getComposedData;
                        if (componsedFn) {
                            var _extends5;
                            formatedItems.push({
                                props: _extends({}, componsedFn(_extends({}, axisObj, {
                                    displayedData: displayedData,
                                    props: props,
                                    dataKey: dataKey,
                                    item: item,
                                    bandSize: bandSize,
                                    barPosition: barPosition,
                                    offset: offset,
                                    stackedData: stackedData,
                                    layout: layout,
                                    dataStartIndex: dataStartIndex,
                                    dataEndIndex: dataEndIndex,
                                    onItemMouseLeave: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.d)(_this3.handleItemMouseLeave, null, item.props.onMouseLeave),
                                    onItemMouseEnter: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.d)(_this3.handleItemMouseEnter, null, item.props.onMouseEnter)
                                })), (_extends5 = {
                                    key: item.key || "item-" + index
                                }, _defineProperty(_extends5, numericAxisName, axisObj[numericAxisName]), _defineProperty(_extends5, cateAxisName, axisObj[cateAxisName]), 
                                _defineProperty(_extends5, "animationId", updateId), _extends5)),
                                childIndex: Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.o)(item, props.children),
                                item: item
                            });
                        }
                    }), formatedItems;
                }
            }, {
                key: "getCursorRectangle",
                value: function() {
                    var layout = this.props.layout, _state5 = this.state, activeCoordinate = _state5.activeCoordinate, offset = _state5.offset, tooltipAxisBandSize = _state5.tooltipAxisBandSize, halfSize = tooltipAxisBandSize / 2;
                    return {
                        stroke: "none",
                        fill: "#ccc",
                        x: "horizontal" === layout ? activeCoordinate.x - halfSize : offset.left + .5,
                        y: "horizontal" === layout ? offset.top + .5 : activeCoordinate.y - halfSize,
                        width: "horizontal" === layout ? tooltipAxisBandSize : offset.width - 1,
                        height: "horizontal" === layout ? offset.height - 1 : tooltipAxisBandSize
                    };
                }
            }, {
                key: "getCursorPoints",
                value: function() {
                    var layout = this.props.layout, _state6 = this.state, activeCoordinate = _state6.activeCoordinate, offset = _state6.offset, x1 = void 0, y1 = void 0, x2 = void 0, y2 = void 0;
                    if ("horizontal" === layout) x1 = activeCoordinate.x, x2 = x1, y1 = offset.top, 
                    y2 = offset.top + offset.height; else if ("vertical" === layout) y1 = activeCoordinate.y, 
                    y2 = y1, x1 = offset.left, x2 = offset.left + offset.width; else if (!__WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(activeCoordinate.cx) || !__WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(activeCoordinate.cy)) {
                        if ("centric" !== layout) {
                            var _cx = activeCoordinate.cx, _cy = activeCoordinate.cy, radius = activeCoordinate.radius, startAngle = activeCoordinate.startAngle, endAngle = activeCoordinate.endAngle, startPoint = Object(__WEBPACK_IMPORTED_MODULE_23__util_PolarUtils__.e)(_cx, _cy, radius, startAngle), endPoint = Object(__WEBPACK_IMPORTED_MODULE_23__util_PolarUtils__.e)(_cx, _cy, radius, endAngle);
                            return {
                                points: [ startPoint, endPoint ],
                                cx: _cx,
                                cy: _cy,
                                radius: radius,
                                startAngle: startAngle,
                                endAngle: endAngle
                            };
                        }
                        var cx = activeCoordinate.cx, cy = activeCoordinate.cy, innerRadius = activeCoordinate.innerRadius, outerRadius = activeCoordinate.outerRadius, angle = activeCoordinate.angle, innerPoint = Object(__WEBPACK_IMPORTED_MODULE_23__util_PolarUtils__.e)(cx, cy, innerRadius, angle), outerPoint = Object(__WEBPACK_IMPORTED_MODULE_23__util_PolarUtils__.e)(cx, cy, outerRadius, angle);
                        x1 = innerPoint.x, y1 = innerPoint.y, x2 = outerPoint.x, y2 = outerPoint.y;
                    }
                    return [ {
                        x: x1,
                        y: y1
                    }, {
                        x: x2,
                        y: y2
                    } ];
                }
            }, {
                key: "getAxisNameByLayout",
                value: function(layout) {
                    return "horizontal" === layout ? {
                        numericAxisName: "yAxis",
                        cateAxisName: "xAxis"
                    } : "vertical" === layout ? {
                        numericAxisName: "xAxis",
                        cateAxisName: "yAxis"
                    } : "centric" === layout ? {
                        numericAxisName: "radiusAxis",
                        cateAxisName: "angleAxis"
                    } : {
                        numericAxisName: "angleAxis",
                        cateAxisName: "radiusAxis"
                    };
                }
            }, {
                key: "calculateTooltipPos",
                value: function(rangeObj) {
                    var layout = this.props.layout;
                    return "horizontal" === layout ? rangeObj.x : "vertical" === layout ? rangeObj.y : "centric" === layout ? rangeObj.angle : rangeObj.radius;
                }
            }, {
                key: "inRange",
                value: function(x, y) {
                    var layout = this.props.layout;
                    if ("horizontal" === layout || "vertical" === layout) {
                        var offset = this.state.offset;
                        return x >= offset.left && x <= offset.left + offset.width && y >= offset.top && y <= offset.top + offset.height ? {
                            x: x,
                            y: y
                        } : null;
                    }
                    var _state7 = this.state, angleAxisMap = _state7.angleAxisMap, radiusAxisMap = _state7.radiusAxisMap;
                    if (angleAxisMap && radiusAxisMap) {
                        var angleAxis = Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.b)(angleAxisMap);
                        return Object(__WEBPACK_IMPORTED_MODULE_23__util_PolarUtils__.d)({
                            x: x,
                            y: y
                        }, angleAxis);
                    }
                    return null;
                }
            }, {
                key: "parseEventsOfWrapper",
                value: function() {
                    var children = this.props.children, tooltipItem = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.i)(children, __WEBPACK_IMPORTED_MODULE_10__component_Tooltip__.a), tooltipEvents = tooltipItem && "axis" === eventType ? {
                        onMouseEnter: this.handleMouseEnter,
                        onMouseMove: this.handleMouseMove,
                        onMouseLeave: this.handleMouseLeave,
                        onTouchMove: this.handleTouchMove
                    } : {}, outerEvents = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.e)(this.props, this.handleOuterEvent);
                    return _extends({}, outerEvents, tooltipEvents);
                }
            }, {
                key: "updateStateOfAxisMapsOffsetAndStackGroups",
                value: function(_ref5) {
                    var _this4 = this, props = _ref5.props, dataStartIndex = _ref5.dataStartIndex, dataEndIndex = _ref5.dataEndIndex, updateId = _ref5.updateId;
                    if (!Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.q)({
                        props: props
                    })) return null;
                    var children = props.children, layout = props.layout, stackOffset = props.stackOffset, data = props.data, reverseStackOrder = props.reverseStackOrder, _getAxisNameByLayout2 = this.getAxisNameByLayout(layout), numericAxisName = _getAxisNameByLayout2.numericAxisName, cateAxisName = _getAxisNameByLayout2.cateAxisName, graphicalItems = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.h)(children, GraphicalChild), stackGroups = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.s)(data, graphicalItems, numericAxisName + "Id", cateAxisName + "Id", stackOffset, reverseStackOrder), axisObj = axisComponents.reduce(function(result, entry) {
                        var name = entry.axisType + "Map";
                        return _extends({}, result, _defineProperty({}, name, _this4.getAxisMap(props, _extends({}, entry, {
                            graphicalItems: graphicalItems,
                            stackGroups: entry.axisType === numericAxisName && stackGroups,
                            dataStartIndex: dataStartIndex,
                            dataEndIndex: dataEndIndex
                        }))));
                    }, {}), offset = this.calculateOffset(_extends({}, axisObj, {
                        props: props,
                        graphicalItems: graphicalItems
                    }));
                    Object.keys(axisObj).forEach(function(key) {
                        axisObj[key] = formatAxisMap(props, axisObj[key], offset, key.replace("Map", ""), chartName);
                    });
                    var cateAxisMap = axisObj[cateAxisName + "Map"], ticksObj = this.tooltipTicksGenerator(cateAxisMap), formatedGraphicalItems = this.getFormatItems(props, _extends({}, axisObj, {
                        dataStartIndex: dataStartIndex,
                        dataEndIndex: dataEndIndex,
                        updateId: updateId,
                        graphicalItems: graphicalItems,
                        stackGroups: stackGroups,
                        offset: offset
                    }));
                    return _extends({
                        formatedGraphicalItems: formatedGraphicalItems,
                        graphicalItems: graphicalItems,
                        offset: offset,
                        stackGroups: stackGroups
                    }, ticksObj, axisObj);
                }
            }, {
                key: "addListener",
                value: function() {
                    __WEBPACK_IMPORTED_MODULE_25__util_Events__.b.on(__WEBPACK_IMPORTED_MODULE_25__util_Events__.a, this.handleReceiveSyncEvent), 
                    __WEBPACK_IMPORTED_MODULE_25__util_Events__.b.setMaxListeners && __WEBPACK_IMPORTED_MODULE_25__util_Events__.b._maxListeners && __WEBPACK_IMPORTED_MODULE_25__util_Events__.b.setMaxListeners(__WEBPACK_IMPORTED_MODULE_25__util_Events__.b._maxListeners + 1);
                }
            }, {
                key: "removeListener",
                value: function() {
                    __WEBPACK_IMPORTED_MODULE_25__util_Events__.b.removeListener(__WEBPACK_IMPORTED_MODULE_25__util_Events__.a, this.handleReceiveSyncEvent), 
                    __WEBPACK_IMPORTED_MODULE_25__util_Events__.b.setMaxListeners && __WEBPACK_IMPORTED_MODULE_25__util_Events__.b._maxListeners && __WEBPACK_IMPORTED_MODULE_25__util_Events__.b.setMaxListeners(__WEBPACK_IMPORTED_MODULE_25__util_Events__.b._maxListeners - 1);
                }
            }, {
                key: "calculateOffset",
                value: function(_ref6) {
                    var props = _ref6.props, graphicalItems = _ref6.graphicalItems, _ref6$xAxisMap = _ref6.xAxisMap, xAxisMap = void 0 === _ref6$xAxisMap ? {} : _ref6$xAxisMap, _ref6$yAxisMap = _ref6.yAxisMap, yAxisMap = void 0 === _ref6$yAxisMap ? {} : _ref6$yAxisMap, width = props.width, height = props.height, children = props.children, margin = props.margin || {}, brushItem = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.i)(children, __WEBPACK_IMPORTED_MODULE_19__cartesian_Brush__.a), legendItem = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.i)(children, __WEBPACK_IMPORTED_MODULE_11__component_Legend__.a), offsetH = Object.keys(yAxisMap).reduce(function(result, id) {
                        var entry = yAxisMap[id], orientation = entry.orientation;
                        return entry.mirror || entry.hide ? result : _extends({}, result, _defineProperty({}, orientation, result[orientation] + entry.width));
                    }, {
                        left: margin.left || 0,
                        right: margin.right || 0
                    }), offsetV = Object.keys(xAxisMap).reduce(function(result, id) {
                        var entry = xAxisMap[id], orientation = entry.orientation;
                        return entry.mirror || entry.hide ? result : _extends({}, result, _defineProperty({}, orientation, result[orientation] + entry.height));
                    }, {
                        top: margin.top || 0,
                        bottom: margin.bottom || 0
                    }), offset = _extends({}, offsetV, offsetH), brushBottom = offset.bottom;
                    if (brushItem && (offset.bottom += brushItem.props.height || __WEBPACK_IMPORTED_MODULE_19__cartesian_Brush__.a.defaultProps.height), 
                    legendItem && this.legendInstance) {
                        var legendBox = this.legendInstance.getBBox();
                        offset = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.a)(offset, graphicalItems, props, legendBox);
                    }
                    return _extends({
                        brushBottom: brushBottom
                    }, offset, {
                        width: width - offset.left - offset.right,
                        height: height - offset.top - offset.bottom
                    });
                }
            }, {
                key: "triggerSyncEvent",
                value: function(data) {
                    var syncId = this.props.syncId;
                    __WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(syncId) || __WEBPACK_IMPORTED_MODULE_25__util_Events__.b.emit(__WEBPACK_IMPORTED_MODULE_25__util_Events__.a, syncId, this.uniqueChartId, data);
                }
            }, {
                key: "filterFormatItem",
                value: function(item, displayName, childIndex) {
                    for (var formatedGraphicalItems = this.state.formatedGraphicalItems, i = 0, len = formatedGraphicalItems.length; i < len; i++) {
                        var entry = formatedGraphicalItems[i];
                        if (entry.item === item || entry.props.key === item.key || displayName === Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.j)(entry.item.type) && childIndex === entry.childIndex) return entry;
                    }
                    return null;
                }
            }, {
                key: "renderAxis",
                value: function(axisOptions, element, displayName, index) {
                    var _props2 = this.props, width = _props2.width, height = _props2.height;
                    return __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_18__cartesian_CartesianAxis__.a, _extends({}, axisOptions, {
                        className: "recharts-" + axisOptions.axisType + " " + axisOptions.axisType,
                        key: element.key || displayName + "-" + index,
                        viewBox: {
                            x: 0,
                            y: 0,
                            width: width,
                            height: height
                        },
                        ticksGenerator: this.axesTicksGenerator
                    }));
                }
            }, {
                key: "renderLegend",
                value: function() {
                    var _this5 = this, formatedGraphicalItems = this.state.formatedGraphicalItems, _props3 = this.props, children = _props3.children, width = _props3.width, height = _props3.height, margin = this.props.margin || {}, legendWidth = width - (margin.left || 0) - (margin.right || 0), legendHeight = height - (margin.top || 0) - (margin.bottom || 0), props = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.q)({
                        children: children,
                        formatedGraphicalItems: formatedGraphicalItems,
                        legendWidth: legendWidth,
                        legendHeight: legendHeight,
                        legendContent: legendContent
                    });
                    if (!props) return null;
                    var item = props.item, otherProps = _objectWithoutProperties(props, [ "item" ]);
                    return Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(item, _extends({}, otherProps, {
                        chartWidth: width,
                        chartHeight: height,
                        margin: margin,
                        ref: function(legend) {
                            _this5.legendInstance = legend;
                        },
                        onBBoxUpdate: this.handleLegendBBoxUpdate
                    }));
                }
            }, {
                key: "renderTooltip",
                value: function() {
                    var children = this.props.children, tooltipItem = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.i)(children, __WEBPACK_IMPORTED_MODULE_10__component_Tooltip__.a);
                    if (!tooltipItem) return null;
                    var _state8 = this.state, isTooltipActive = _state8.isTooltipActive, activeCoordinate = _state8.activeCoordinate, activePayload = _state8.activePayload, activeLabel = _state8.activeLabel, offset = _state8.offset;
                    return Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(tooltipItem, {
                        viewBox: _extends({}, offset, {
                            x: offset.left,
                            y: offset.top
                        }),
                        active: isTooltipActive,
                        label: activeLabel,
                        payload: isTooltipActive ? activePayload : [],
                        coordinate: activeCoordinate
                    });
                }
            }, {
                key: "renderActiveDot",
                value: function(option, props) {
                    var dot = void 0;
                    return dot = Object(__WEBPACK_IMPORTED_MODULE_5_react__.isValidElement)(option) ? Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(option, props) : __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_15__shape_Dot__.a, props), 
                    __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__container_Layer__.a, {
                        className: "recharts-active-dot",
                        key: props.key
                    }, dot);
                }
            }, {
                key: "renderActivePoints",
                value: function(_ref7) {
                    var item = _ref7.item, activePoint = _ref7.activePoint, basePoint = _ref7.basePoint, childIndex = _ref7.childIndex, isRange = _ref7.isRange, result = [], key = item.props.key, _item$item$props = item.item.props, activeDot = _item$item$props.activeDot, dataKey = _item$item$props.dataKey, dotProps = _extends({
                        index: childIndex,
                        dataKey: dataKey,
                        cx: activePoint.x,
                        cy: activePoint.y,
                        r: 4,
                        fill: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.r)(item.item),
                        strokeWidth: 2,
                        stroke: "#fff",
                        payload: activePoint.payload,
                        value: activePoint.value,
                        key: key + "-activePoint-" + childIndex
                    }, Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.k)(activeDot), Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.e)(activeDot));
                    return result.push(this.renderActiveDot(activeDot, dotProps, childIndex)), basePoint ? result.push(this.renderActiveDot(activeDot, _extends({}, dotProps, {
                        cx: basePoint.x,
                        cy: basePoint.y,
                        key: key + "-basePoint-" + childIndex
                    }), childIndex)) : isRange && result.push(null), result;
                }
            }, {
                key: "render",
                value: function() {
                    var _this6 = this;
                    if (!Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.q)(this)) return null;
                    var _props4 = this.props, children = _props4.children, className = _props4.className, width = _props4.width, height = _props4.height, style = _props4.style, compact = _props4.compact, others = _objectWithoutProperties(_props4, [ "children", "className", "width", "height", "style", "compact" ]), attrs = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.k)(others), map = {
                        CartesianGrid: {
                            handler: this.renderGrid,
                            once: !0
                        },
                        ReferenceArea: {
                            handler: this.renderReferenceElement
                        },
                        ReferenceLine: {
                            handler: this.renderReferenceElement
                        },
                        ReferenceDot: {
                            handler: this.renderReferenceElement
                        },
                        XAxis: {
                            handler: this.renderXAxis
                        },
                        YAxis: {
                            handler: this.renderYAxis
                        },
                        Brush: {
                            handler: this.renderBrush,
                            once: !0
                        },
                        Bar: {
                            handler: this.renderGraphicChild
                        },
                        Line: {
                            handler: this.renderGraphicChild
                        },
                        Area: {
                            handler: this.renderGraphicChild
                        },
                        Radar: {
                            handler: this.renderGraphicChild
                        },
                        RadialBar: {
                            handler: this.renderGraphicChild
                        },
                        Scatter: {
                            handler: this.renderGraphicChild
                        },
                        Pie: {
                            handler: this.renderGraphicChild
                        },
                        Tooltip: {
                            handler: this.renderCursor,
                            once: !0
                        },
                        PolarGrid: {
                            handler: this.renderPolarGrid,
                            once: !0
                        },
                        PolarAngleAxis: {
                            handler: this.renderPolarAxis
                        },
                        PolarRadiusAxis: {
                            handler: this.renderPolarAxis
                        }
                    };
                    if (compact) return __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Surface__.a, _extends({}, attrs, {
                        width: width,
                        height: height
                    }), Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.p)(children, map));
                    var events = this.parseEventsOfWrapper();
                    return __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement("div", _extends({
                        className: __WEBPACK_IMPORTED_MODULE_7_classnames___default()("recharts-wrapper", className),
                        style: _extends({}, style, {
                            position: "relative",
                            cursor: "default",
                            width: width,
                            height: height
                        })
                    }, events, {
                        ref: function(node) {
                            _this6.container = node;
                        }
                    }), __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Surface__.a, _extends({}, attrs, {
                        width: width,
                        height: height
                    }), Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.p)(children, map)), this.renderLegend(), this.renderTooltip());
                }
            } ]), CategoricalChartWrapper;
        }(__WEBPACK_IMPORTED_MODULE_5_react__.Component), _class.displayName = chartName, 
        _class.propTypes = _extends({
            syncId: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number ]),
            compact: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.bool,
            width: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
            height: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
            data: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.object),
            layout: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "horizontal", "vertical" ]),
            stackOffset: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "sign", "expand", "none", "wiggle", "silhouette" ]),
            throttleDelay: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
            margin: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.shape({
                top: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
                right: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
                bottom: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
                left: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number
            }),
            barCategoryGap: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
            barGap: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
            barSize: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
            maxBarSize: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
            style: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.object,
            className: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
            children: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.node), __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.node ]),
            onClick: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
            onMouseLeave: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
            onMouseEnter: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
            onMouseMove: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
            onMouseDown: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
            onMouseUp: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
            reverseStackOrder: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.bool,
            id: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string
        }, propTypes), _class.defaultProps = _extends({
            layout: "horizontal",
            stackOffset: "none",
            barCategoryGap: "10%",
            barGap: 4,
            margin: {
                top: 5,
                right: 5,
                bottom: 5,
                left: 5
            },
            reverseStackOrder: !1
        }, defaultProps), _class.createDefaultState = function(props) {
            var children = props.children, brushItem = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.i)(children, __WEBPACK_IMPORTED_MODULE_19__cartesian_Brush__.a);
            return {
                chartX: 0,
                chartY: 0,
                dataStartIndex: brushItem && brushItem.props && brushItem.props.startIndex || 0,
                dataEndIndex: brushItem && brushItem.props && brushItem.props.endIndex || props.data && props.data.length - 1 || 0,
                activeTooltipIndex: -1,
                isTooltipActive: !1
            };
        }, _class.hasBar = function(graphicalItems) {
            return !(!graphicalItems || !graphicalItems.length) && graphicalItems.some(function(item) {
                var name = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.j)(item && item.type);
                return name && name.indexOf("Bar") >= 0;
            });
        }, _class.getDisplayedData = function(props, _ref8, item) {
            var graphicalItems = _ref8.graphicalItems, dataStartIndex = _ref8.dataStartIndex, dataEndIndex = _ref8.dataEndIndex, itemsData = (graphicalItems || []).reduce(function(result, child) {
                var itemData = child.props.data;
                return itemData && itemData.length ? [].concat(_toConsumableArray(result), _toConsumableArray(itemData)) : result;
            }, []);
            if (itemsData && itemsData.length > 0) return itemsData;
            if (item && item.props && item.props.data && item.props.data.length > 0) return item.props.data;
            var data = props.data;
            return data && data.length && Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.h)(dataStartIndex) && Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.h)(dataEndIndex) ? data.slice(dataStartIndex, dataEndIndex + 1) : [];
        }, _initialiseProps = function() {
            var _this7 = this;
            this.handleLegendBBoxUpdate = function(box) {
                if (box && _this7.legendInstance) {
                    var _state9 = _this7.state, dataStartIndex = _state9.dataStartIndex, dataEndIndex = _state9.dataEndIndex, updateId = _state9.updateId;
                    _this7.setState(_this7.updateStateOfAxisMapsOffsetAndStackGroups({
                        props: _this7.props,
                        dataStartIndex: dataStartIndex,
                        dataEndIndex: dataEndIndex,
                        updateId: updateId
                    }));
                }
            }, this.handleReceiveSyncEvent = function(cId, chartId, data) {
                var _props5 = _this7.props, syncId = _props5.syncId, layout = _props5.layout, updateId = _this7.state.updateId;
                if (syncId === cId && chartId !== _this7.uniqueChartId) {
                    var dataStartIndex = data.dataStartIndex, dataEndIndex = data.dataEndIndex;
                    if (__WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(data.dataStartIndex) && __WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(data.dataEndIndex)) if (__WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(data.activeTooltipIndex)) _this7.setState(data); else {
                        var chartX = data.chartX, chartY = data.chartY, activeTooltipIndex = data.activeTooltipIndex, _state10 = _this7.state, offset = _state10.offset, tooltipTicks = _state10.tooltipTicks;
                        if (!offset) return;
                        var viewBox = _extends({}, offset, {
                            x: offset.left,
                            y: offset.top
                        }), validateChartX = Math.min(chartX, viewBox.x + viewBox.width), validateChartY = Math.min(chartY, viewBox.y + viewBox.height), activeLabel = tooltipTicks[activeTooltipIndex] && tooltipTicks[activeTooltipIndex].value, activePayload = _this7.getTooltipContent(activeTooltipIndex), activeCoordinate = tooltipTicks[activeTooltipIndex] ? {
                            x: "horizontal" === layout ? tooltipTicks[activeTooltipIndex].coordinate : validateChartX,
                            y: "horizontal" === layout ? validateChartY : tooltipTicks[activeTooltipIndex].coordinate
                        } : originCoordinate;
                        _this7.setState(_extends({}, data, {
                            activeLabel: activeLabel,
                            activeCoordinate: activeCoordinate,
                            activePayload: activePayload
                        }));
                    } else _this7.setState(_extends({
                        dataStartIndex: dataStartIndex,
                        dataEndIndex: dataEndIndex
                    }, _this7.updateStateOfAxisMapsOffsetAndStackGroups({
                        props: _this7.props,
                        dataStartIndex: dataStartIndex,
                        dataEndIndex: dataEndIndex,
                        updateId: updateId
                    })));
                }
            }, this.handleBrushChange = function(_ref9) {
                var startIndex = _ref9.startIndex, endIndex = _ref9.endIndex;
                if (startIndex !== _this7.state.dataStartIndex || endIndex !== _this7.state.dataEndIndex) {
                    var updateId = _this7.state.updateId;
                    _this7.setState(function() {
                        return _extends({
                            dataStartIndex: startIndex,
                            dataEndIndex: endIndex
                        }, _this7.updateStateOfAxisMapsOffsetAndStackGroups({
                            props: _this7.props,
                            dataStartIndex: startIndex,
                            dataEndIndex: endIndex,
                            updateId: updateId
                        }));
                    }), _this7.triggerSyncEvent({
                        dataStartIndex: startIndex,
                        dataEndIndex: endIndex
                    });
                }
            }, this.handleMouseEnter = function(e) {
                var onMouseEnter = _this7.props.onMouseEnter, mouse = _this7.getMouseInfo(e);
                if (mouse) {
                    var nextState = _extends({}, mouse, {
                        isTooltipActive: !0
                    });
                    _this7.setState(nextState), _this7.triggerSyncEvent(nextState), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(onMouseEnter) && onMouseEnter(nextState, e);
                }
            }, this.triggeredAfterMouseMove = function(e) {
                var onMouseMove = _this7.props.onMouseMove, mouse = _this7.getMouseInfo(e), nextState = mouse ? _extends({}, mouse, {
                    isTooltipActive: !0
                }) : {
                    isTooltipActive: !1
                };
                _this7.setState(nextState), _this7.triggerSyncEvent(nextState), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(onMouseMove) && onMouseMove(nextState, e);
            }, this.handleItemMouseEnter = function(el) {
                _this7.setState(function() {
                    return {
                        isTooltipActive: !0,
                        activeItem: el,
                        activePayload: el.tooltipPayload,
                        activeCoordinate: el.tooltipPosition || {
                            x: el.cx,
                            y: el.cy
                        }
                    };
                });
            }, this.handleItemMouseLeave = function() {
                _this7.setState(function() {
                    return {
                        isTooltipActive: !1
                    };
                });
            }, this.handleMouseMove = function(e) {
                e && __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(e.persist) && e.persist(), 
                _this7.triggeredAfterMouseMove(e);
            }, this.handleMouseLeave = function(e) {
                var onMouseLeave = _this7.props.onMouseLeave, nextState = {
                    isTooltipActive: !1
                };
                _this7.setState(nextState), _this7.triggerSyncEvent(nextState), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(onMouseLeave) && onMouseLeave(nextState, e);
            }, this.handleOuterEvent = function(e) {
                var eventName = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.l)(e);
                if (eventName && __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(_this7.props[eventName])) {
                    var mouse = _this7.getMouseInfo(e);
                    (0, _this7.props[eventName])(mouse, e);
                }
            }, this.handleClick = function(e) {
                var onClick = _this7.props.onClick;
                if (__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(onClick)) {
                    onClick(_this7.getMouseInfo(e), e);
                }
            }, this.handleMouseDown = function(e) {
                var onMouseDown = _this7.props.onMouseDown;
                if (__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(onMouseDown)) {
                    onMouseDown(_this7.getMouseInfo(e), e);
                }
            }, this.handleMouseUp = function(e) {
                var onMouseUp = _this7.props.onMouseUp;
                if (__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(onMouseUp)) {
                    onMouseUp(_this7.getMouseInfo(e), e);
                }
            }, this.handleTouchMove = function(e) {
                null != e.changedTouches && e.changedTouches.length > 0 && _this7.handleMouseMove(e.changedTouches[0]);
            }, this.verticalCoordinatesGenerator = function(_ref10) {
                var xAxis = _ref10.xAxis, width = _ref10.width, height = _ref10.height, offset = _ref10.offset;
                return Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.m)(__WEBPACK_IMPORTED_MODULE_18__cartesian_CartesianAxis__.a.getTicks(_extends({}, __WEBPACK_IMPORTED_MODULE_18__cartesian_CartesianAxis__.a.defaultProps, xAxis, {
                    ticks: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.u)(xAxis, !0),
                    viewBox: {
                        x: 0,
                        y: 0,
                        width: width,
                        height: height
                    }
                })), offset.left, offset.left + offset.width);
            }, this.horizontalCoordinatesGenerator = function(_ref11) {
                var yAxis = _ref11.yAxis, width = _ref11.width, height = _ref11.height, offset = _ref11.offset;
                return Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.m)(__WEBPACK_IMPORTED_MODULE_18__cartesian_CartesianAxis__.a.getTicks(_extends({}, __WEBPACK_IMPORTED_MODULE_18__cartesian_CartesianAxis__.a.defaultProps, yAxis, {
                    ticks: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.u)(yAxis, !0),
                    viewBox: {
                        x: 0,
                        y: 0,
                        width: width,
                        height: height
                    }
                })), offset.top, offset.top + offset.height);
            }, this.axesTicksGenerator = function(axis) {
                return Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.u)(axis, !0);
            }, this.tooltipTicksGenerator = function(axisMap) {
                var axis = Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.b)(axisMap), tooltipTicks = Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.u)(axis, !1, !0);
                return {
                    tooltipTicks: tooltipTicks,
                    orderedTooltipTicks: __WEBPACK_IMPORTED_MODULE_0_lodash_sortBy___default()(tooltipTicks, function(o) {
                        return o.coordinate;
                    }),
                    tooltipAxis: axis,
                    tooltipAxisBandSize: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.g)(axis)
                };
            }, this.renderCursor = function(element) {
                var _state11 = _this7.state, isTooltipActive = _state11.isTooltipActive, activeCoordinate = _state11.activeCoordinate, activePayload = _state11.activePayload, offset = _state11.offset;
                if (!(element && element.props.cursor && isTooltipActive && activeCoordinate)) return null;
                var layout = _this7.props.layout, restProps = void 0, cursorComp = __WEBPACK_IMPORTED_MODULE_12__shape_Curve__.a;
                if ("ScatterChart" === chartName) restProps = activeCoordinate, cursorComp = __WEBPACK_IMPORTED_MODULE_13__shape_Cross__.a; else if ("BarChart" === chartName) restProps = _this7.getCursorRectangle(), 
                cursorComp = __WEBPACK_IMPORTED_MODULE_16__shape_Rectangle__.a; else if ("radial" === layout) {
                    var _getCursorPoints = _this7.getCursorPoints(), cx = _getCursorPoints.cx, cy = _getCursorPoints.cy, radius = _getCursorPoints.radius, startAngle = _getCursorPoints.startAngle, endAngle = _getCursorPoints.endAngle;
                    restProps = {
                        cx: cx,
                        cy: cy,
                        startAngle: startAngle,
                        endAngle: endAngle,
                        innerRadius: radius,
                        outerRadius: radius
                    }, cursorComp = __WEBPACK_IMPORTED_MODULE_14__shape_Sector__.a;
                } else restProps = {
                    points: _this7.getCursorPoints()
                }, cursorComp = __WEBPACK_IMPORTED_MODULE_12__shape_Curve__.a;
                var key = element.key || "_recharts-cursor", cursorProps = _extends({
                    stroke: "#ccc"
                }, offset, restProps, Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.k)(element.props.cursor), {
                    payload: activePayload,
                    key: key,
                    className: "recharts-tooltip-cursor"
                });
                return Object(__WEBPACK_IMPORTED_MODULE_5_react__.isValidElement)(element.props.cursor) ? Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(element.props.cursor, cursorProps) : Object(__WEBPACK_IMPORTED_MODULE_5_react__.createElement)(cursorComp, cursorProps);
            }, this.renderPolarAxis = function(element, displayName, index) {
                var axisType = element.type.axisType, axisMap = _this7.state[axisType + "Map"], axisOption = axisMap[element.props[axisType + "Id"]];
                return Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(element, _extends({}, axisOption, {
                    className: axisType,
                    key: element.key || displayName + "-" + index,
                    ticks: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.u)(axisOption, !0)
                }));
            }, this.renderXAxis = function(element, displayName, index) {
                var xAxisMap = _this7.state.xAxisMap, axisObj = xAxisMap[element.props.xAxisId];
                return _this7.renderAxis(axisObj, element, displayName, index);
            }, this.renderYAxis = function(element, displayName, index) {
                var yAxisMap = _this7.state.yAxisMap, axisObj = yAxisMap[element.props.yAxisId];
                return _this7.renderAxis(axisObj, element, displayName, index);
            }, this.renderGrid = function(element) {
                var _state12 = _this7.state, xAxisMap = _state12.xAxisMap, yAxisMap = _state12.yAxisMap, offset = _state12.offset, _props6 = _this7.props, width = _props6.width, height = _props6.height, xAxis = Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.b)(xAxisMap), yAxis = Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.b)(yAxisMap), props = element.props || {};
                return Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(element, {
                    key: element.key || "grid",
                    x: Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.h)(props.x) ? props.x : offset.left,
                    y: Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.h)(props.y) ? props.y : offset.top,
                    width: Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.h)(props.width) ? props.width : offset.width,
                    height: Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.h)(props.height) ? props.height : offset.height,
                    xAxis: xAxis,
                    yAxis: yAxis,
                    offset: offset,
                    chartWidth: width,
                    chartHeight: height,
                    verticalCoordinatesGenerator: _this7.verticalCoordinatesGenerator,
                    horizontalCoordinatesGenerator: _this7.horizontalCoordinatesGenerator
                });
            }, this.renderPolarGrid = function(element) {
                var _state13 = _this7.state, radiusAxisMap = _state13.radiusAxisMap, angleAxisMap = _state13.angleAxisMap, radiusAxis = Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.b)(radiusAxisMap), angleAxis = Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.b)(angleAxisMap), cx = angleAxis.cx, cy = angleAxis.cy, innerRadius = angleAxis.innerRadius, outerRadius = angleAxis.outerRadius;
                return Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(element, {
                    polarAngles: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.u)(angleAxis, !0).map(function(entry) {
                        return entry.coordinate;
                    }),
                    polarRadius: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.u)(radiusAxis, !0).map(function(entry) {
                        return entry.coordinate;
                    }),
                    cx: cx,
                    cy: cy,
                    innerRadius: innerRadius,
                    outerRadius: outerRadius,
                    key: element.key || "polar-grid"
                });
            }, this.renderBrush = function(element) {
                var _props7 = _this7.props, margin = _props7.margin, data = _props7.data, _state14 = _this7.state, offset = _state14.offset, dataStartIndex = _state14.dataStartIndex, dataEndIndex = _state14.dataEndIndex, updateId = _state14.updateId;
                return Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(element, {
                    key: element.key || "_recharts-brush",
                    onChange: Object(__WEBPACK_IMPORTED_MODULE_22__util_ChartUtils__.d)(_this7.handleBrushChange, null, element.props.onChange),
                    data: data,
                    x: Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.h)(element.props.x) ? element.props.x : offset.left,
                    y: Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.h)(element.props.y) ? element.props.y : offset.top + offset.height + offset.brushBottom - (margin.bottom || 0),
                    width: Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.h)(element.props.width) ? element.props.width : offset.width,
                    startIndex: dataStartIndex,
                    endIndex: dataEndIndex,
                    updateId: "brush-" + updateId
                });
            }, this.renderReferenceElement = function(element, displayName, index) {
                if (!element) return null;
                var _state15 = _this7.state, xAxisMap = _state15.xAxisMap, yAxisMap = _state15.yAxisMap, offset = _state15.offset, _element$props = element.props, xAxisId = _element$props.xAxisId, yAxisId = _element$props.yAxisId;
                return Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(element, {
                    key: element.key || displayName + "-" + index,
                    xAxis: xAxisMap[xAxisId],
                    yAxis: yAxisMap[yAxisId],
                    viewBox: {
                        x: offset.left,
                        y: offset.top,
                        width: offset.width,
                        height: offset.height
                    }
                });
            }, this.renderGraphicChild = function(element, displayName, index) {
                var item = _this7.filterFormatItem(element, displayName, index);
                if (!item) return null;
                var graphicalItem = Object(__WEBPACK_IMPORTED_MODULE_5_react__.cloneElement)(element, item.props), _state16 = _this7.state, isTooltipActive = _state16.isTooltipActive, tooltipAxis = _state16.tooltipAxis, activeTooltipIndex = _state16.activeTooltipIndex, activeLabel = _state16.activeLabel, children = _this7.props.children, tooltipItem = Object(__WEBPACK_IMPORTED_MODULE_17__util_ReactUtils__.i)(children, __WEBPACK_IMPORTED_MODULE_10__component_Tooltip__.a), _item$props2 = item.props, points = _item$props2.points, isRange = _item$props2.isRange, baseLine = _item$props2.baseLine, _item$item$props2 = item.item.props, activeDot = _item$item$props2.activeDot;
                if (!_item$item$props2.hide && isTooltipActive && tooltipItem && activeDot && activeTooltipIndex >= 0) {
                    var activePoint = void 0, basePoint = void 0;
                    if (tooltipAxis.dataKey && !tooltipAxis.allowDuplicatedCategory ? (activePoint = Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.a)(points, "payload." + tooltipAxis.dataKey, activeLabel), 
                    basePoint = isRange && baseLine && Object(__WEBPACK_IMPORTED_MODULE_21__util_DataUtils__.a)(baseLine, "payload." + tooltipAxis.dataKey, activeLabel)) : (activePoint = points[activeTooltipIndex], 
                    basePoint = isRange && baseLine && baseLine[activeTooltipIndex]), !__WEBPACK_IMPORTED_MODULE_4_lodash_isNil___default()(activePoint)) return [ graphicalItem ].concat(_toConsumableArray(_this7.renderActivePoints({
                        item: item,
                        activePoint: activePoint,
                        basePoint: basePoint,
                        childIndex: activeTooltipIndex,
                        isRange: isRange
                    })));
                }
                return isRange ? [ graphicalItem, null, null ] : [ graphicalItem, null ];
            };
        }, _temp;
    };
    __webpack_exports__.a = generateCategoricalChart;
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        function invariant(condition, format, a, b, c, d, e, f) {
            if (validateFormat(format), !condition) {
                var error;
                if (void 0 === format) error = new Error("Minified exception occurred; use the non-minified dev environment for the full error message and additional helpful warnings."); else {
                    var args = [ a, b, c, d, e, f ], argIndex = 0;
                    error = new Error(format.replace(/%s/g, function() {
                        return args[argIndex++];
                    })), error.name = "Invariant Violation";
                }
                throw error.framesToPop = 1, error;
            }
        }
        var validateFormat = function(format) {};
        "production" !== process.env.NODE_ENV && (validateFormat = function(format) {
            if (void 0 === format) throw new Error("invariant requires an error message argument");
        }), module.exports = invariant;
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    "use strict";
    function makeEmptyFunction(arg) {
        return function() {
            return arg;
        };
    }
    var emptyFunction = function() {};
    emptyFunction.thatReturns = makeEmptyFunction, emptyFunction.thatReturnsFalse = makeEmptyFunction(!1), 
    emptyFunction.thatReturnsTrue = makeEmptyFunction(!0), emptyFunction.thatReturnsNull = makeEmptyFunction(null), 
    emptyFunction.thatReturnsThis = function() {
        return this;
    }, emptyFunction.thatReturnsArgument = function(arg) {
        return arg;
    }, module.exports = emptyFunction;
}, function(module, exports, __webpack_require__) {
    var aFunction = __webpack_require__(223);
    module.exports = function(fn, that, length) {
        if (aFunction(fn), void 0 === that) return fn;
        switch (length) {
          case 1:
            return function(a) {
                return fn.call(that, a);
            };

          case 2:
            return function(a, b) {
                return fn.call(that, a, b);
            };

          case 3:
            return function(a, b, c) {
                return fn.call(that, a, b, c);
            };
        }
        return function() {
            return fn.apply(that, arguments);
        };
    };
}, function(module, exports, __webpack_require__) {
    var isObject = __webpack_require__(35);
    module.exports = function(it) {
        if (!isObject(it)) throw TypeError(it + " is not an object!");
        return it;
    };
}, function(module, exports) {
    module.exports = function(exec) {
        try {
            return !!exec();
        } catch (e) {
            return !0;
        }
    };
}, function(module, exports) {
    var hasOwnProperty = {}.hasOwnProperty;
    module.exports = function(it, key) {
        return hasOwnProperty.call(it, key);
    };
}, function(module, exports, __webpack_require__) {
    module.exports = {
        default: __webpack_require__(421),
        __esModule: !0
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }
        function capitalize(string) {
            if ("production" !== process.env.NODE_ENV && "string" != typeof string) throw new Error("Material-UI: capitalize(string) expects a string argument.");
            return string.charAt(0).toUpperCase() + string.slice(1);
        }
        function contains(obj, pred) {
            return (0, _keys2.default)(pred).every(function(key) {
                return obj.hasOwnProperty(key) && obj[key] === pred[key];
            });
        }
        function findIndex(arr, pred) {
            for (var predType = void 0 === pred ? "undefined" : (0, _typeof3.default)(pred), i = 0; i < arr.length; i += 1) {
                if ("function" === predType && !0 == !!pred(arr[i], i, arr)) return i;
                if ("object" === predType && contains(arr[i], pred)) return i;
                if (-1 !== [ "string", "number", "boolean" ].indexOf(predType)) return arr.indexOf(pred);
            }
            return -1;
        }
        function find(arr, pred) {
            var index = findIndex(arr, pred);
            return index > -1 ? arr[index] : void 0;
        }
        function createChainedFunction() {
            for (var _len = arguments.length, funcs = Array(_len), _key = 0; _key < _len; _key++) funcs[_key] = arguments[_key];
            return funcs.filter(function(func) {
                return null != func;
            }).reduce(function(acc, func) {
                return "production" !== process.env.NODE_ENV && (0, _warning2.default)("function" == typeof func, "Material-UI: invalid Argument Type, must only provide functions, undefined, or null."), 
                function() {
                    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) args[_key2] = arguments[_key2];
                    acc.apply(this, args), func.apply(this, args);
                };
            }, function() {});
        }
        Object.defineProperty(exports, "__esModule", {
            value: !0
        });
        var _typeof2 = __webpack_require__(105), _typeof3 = _interopRequireDefault(_typeof2), _keys = __webpack_require__(55), _keys2 = _interopRequireDefault(_keys);
        exports.capitalize = capitalize, exports.contains = contains, exports.findIndex = findIndex, 
        exports.find = find, exports.createChainedFunction = createChainedFunction;
        var _warning = __webpack_require__(11), _warning2 = _interopRequireDefault(_warning);
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    function getNative(object, key) {
        var value = getValue(object, key);
        return baseIsNative(value) ? value : void 0;
    }
    var baseIsNative = __webpack_require__(611), getValue = __webpack_require__(614);
    module.exports = getNative;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(x) {
        return function() {
            return x;
        };
    };
}, function(module, exports, __webpack_require__) {
    function getNative(object, key) {
        var value = getValue(object, key);
        return baseIsNative(value) ? value : void 0;
    }
    var baseIsNative = __webpack_require__(668), getValue = __webpack_require__(673);
    module.exports = getNative;
}, function(module, exports, __webpack_require__) {
    function baseGetTag(value) {
        return null == value ? void 0 === value ? undefinedTag : nullTag : symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
    }
    var Symbol = __webpack_require__(128), getRawTag = __webpack_require__(669), objectToString = __webpack_require__(670), nullTag = "[object Null]", undefinedTag = "[object Undefined]", symToStringTag = Symbol ? Symbol.toStringTag : void 0;
    module.exports = baseGetTag;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _temp2, __WEBPACK_IMPORTED_MODULE_0_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__), __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__), __WEBPACK_IMPORTED_MODULE_3_reduce_css_calc__ = __webpack_require__(771), __WEBPACK_IMPORTED_MODULE_3_reduce_css_calc___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_reduce_css_calc__), __WEBPACK_IMPORTED_MODULE_4_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_4_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_classnames__), __WEBPACK_IMPORTED_MODULE_5__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_7__util_DOMUtils__ = __webpack_require__(198), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), BREAKING_SPACES = /[ \f\n\r\t\v\u2028\u2029]+/, calculateWordWidths = function(props) {
        try {
            return {
                wordsWithComputedWidth: (__WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default()(props.children) ? [] : props.children.toString().split(BREAKING_SPACES)).map(function(word) {
                    return {
                        word: word,
                        width: Object(__WEBPACK_IMPORTED_MODULE_7__util_DOMUtils__.c)(word, props.style).width
                    };
                }),
                spaceWidth: Object(__WEBPACK_IMPORTED_MODULE_7__util_DOMUtils__.c)(" ", props.style).width
            };
        } catch (e) {
            return null;
        }
    }, Text = (_temp2 = _class = function(_Component) {
        function Text() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, Text);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = Text.__proto__ || Object.getPrototypeOf(Text)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                wordsByLines: []
            }, _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(Text, _Component), _createClass(Text, [ {
            key: "componentWillMount",
            value: function() {
                this.updateWordsByLines(this.props, !0);
            }
        }, {
            key: "componentWillReceiveProps",
            value: function(nextProps) {
                var needCalculate = this.props.children !== nextProps.children || this.props.style !== nextProps.style;
                this.updateWordsByLines(nextProps, needCalculate);
            }
        }, {
            key: "updateWordsByLines",
            value: function(props, needCalculate) {
                if (!props.width && !props.scaleToFit || Object(__WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__.n)()) this.updateWordsWithoutCalculate(props); else {
                    if (needCalculate) {
                        var wordWidths = calculateWordWidths(props);
                        if (!wordWidths) return void this.updateWordsWithoutCalculate(props);
                        var wordsWithComputedWidth = wordWidths.wordsWithComputedWidth, spaceWidth = wordWidths.spaceWidth;
                        this.wordsWithComputedWidth = wordsWithComputedWidth, this.spaceWidth = spaceWidth;
                    }
                    var wordsByLines = this.calculateWordsByLines(this.wordsWithComputedWidth, this.spaceWidth, props.width);
                    this.setState({
                        wordsByLines: wordsByLines
                    });
                }
            }
        }, {
            key: "updateWordsWithoutCalculate",
            value: function(props) {
                var words = __WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default()(props.children) ? [] : props.children.toString().split(BREAKING_SPACES);
                this.setState({
                    wordsByLines: [ {
                        words: words
                    } ]
                });
            }
        }, {
            key: "calculateWordsByLines",
            value: function(wordsWithComputedWidth, spaceWidth, lineWidth) {
                var scaleToFit = this.props.scaleToFit;
                return wordsWithComputedWidth.reduce(function(result, _ref2) {
                    var word = _ref2.word, width = _ref2.width, currentLine = result[result.length - 1];
                    if (currentLine && (null == lineWidth || scaleToFit || currentLine.width + width + spaceWidth < lineWidth)) currentLine.words.push(word), 
                    currentLine.width += width + spaceWidth; else {
                        var newLine = {
                            words: [ word ],
                            width: width
                        };
                        result.push(newLine);
                    }
                    return result;
                }, []);
            }
        }, {
            key: "render",
            value: function() {
                var _props = this.props, dx = _props.dx, dy = _props.dy, textAnchor = _props.textAnchor, verticalAnchor = _props.verticalAnchor, scaleToFit = _props.scaleToFit, angle = _props.angle, lineHeight = _props.lineHeight, capHeight = _props.capHeight, className = _props.className, textProps = _objectWithoutProperties(_props, [ "dx", "dy", "textAnchor", "verticalAnchor", "scaleToFit", "angle", "lineHeight", "capHeight", "className" ]), wordsByLines = this.state.wordsByLines;
                if (!Object(__WEBPACK_IMPORTED_MODULE_5__util_DataUtils__.g)(textProps.x) || !Object(__WEBPACK_IMPORTED_MODULE_5__util_DataUtils__.g)(textProps.y)) return null;
                var x = textProps.x + (Object(__WEBPACK_IMPORTED_MODULE_5__util_DataUtils__.h)(dx) ? dx : 0), y = textProps.y + (Object(__WEBPACK_IMPORTED_MODULE_5__util_DataUtils__.h)(dy) ? dy : 0), startDy = void 0;
                switch (verticalAnchor) {
                  case "start":
                    startDy = __WEBPACK_IMPORTED_MODULE_3_reduce_css_calc___default()("calc(" + capHeight + ")");
                    break;

                  case "middle":
                    startDy = __WEBPACK_IMPORTED_MODULE_3_reduce_css_calc___default()("calc(" + (wordsByLines.length - 1) / 2 + " * -" + lineHeight + " + (" + capHeight + " / 2))");
                    break;

                  default:
                    startDy = __WEBPACK_IMPORTED_MODULE_3_reduce_css_calc___default()("calc(" + (wordsByLines.length - 1) + " * -" + lineHeight + ")");
                }
                var transforms = [];
                if (scaleToFit) {
                    var lineWidth = wordsByLines[0].width;
                    transforms.push("scale(" + this.props.width / lineWidth + ")");
                }
                return angle && transforms.push("rotate(" + angle + ", " + x + ", " + y + ")"), 
                transforms.length && (textProps.transform = transforms.join(" ")), __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement("text", _extends({}, Object(__WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__.k)(textProps), {
                    x: x,
                    y: y,
                    className: __WEBPACK_IMPORTED_MODULE_4_classnames___default()("recharts-text", className),
                    textAnchor: textAnchor
                }), wordsByLines.map(function(line, index) {
                    return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement("tspan", {
                        x: x,
                        dy: 0 === index ? startDy : lineHeight,
                        key: index
                    }, line.words.join(" "));
                }));
            }
        } ]), Text;
    }(__WEBPACK_IMPORTED_MODULE_1_react__.Component), _class.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__.c, {
        scaleToFit: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
        angle: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        textAnchor: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf([ "start", "middle", "end", "inherit" ]),
        verticalAnchor: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf([ "start", "middle", "end" ]),
        style: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object
    }), _class.defaultProps = {
        x: 0,
        y: 0,
        lineHeight: "1em",
        capHeight: "0.71em",
        scaleToFit: !1,
        textAnchor: "start",
        verticalAnchor: "end"
    }, _temp2);
    __webpack_exports__.a = Text;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return map;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return slice;
    });
    var array = Array.prototype, map = array.map, slice = array.slice;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_2_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_classnames__), __WEBPACK_IMPORTED_MODULE_3__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__ = __webpack_require__(4), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), Dot = Object(__WEBPACK_IMPORTED_MODULE_3__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function Dot() {
            return _classCallCheck(this, Dot), _possibleConstructorReturn(this, (Dot.__proto__ || Object.getPrototypeOf(Dot)).apply(this, arguments));
        }
        return _inherits(Dot, _Component), _createClass(Dot, [ {
            key: "render",
            value: function() {
                var _props = this.props, cx = _props.cx, cy = _props.cy, r = _props.r, className = _props.className, layerClass = __WEBPACK_IMPORTED_MODULE_2_classnames___default()("recharts-dot", className);
                return cx === +cx && cy === +cy && r === +r ? __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("circle", _extends({}, Object(__WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__.k)(this.props), Object(__WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__.e)(this.props, null, !0), {
                    className: layerClass,
                    cx: cx,
                    cy: cy,
                    r: r
                })) : null;
            }
        } ]), Dot;
    }(__WEBPACK_IMPORTED_MODULE_0_react__.Component), _class2.displayName = "Dot", _class2.propTypes = {
        className: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
        cx: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        cy: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        r: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number
    }, _class = _temp)) || _class;
    __webpack_exports__.a = Dot;
}, function(module, exports, __webpack_require__) {
    var IObject = __webpack_require__(146), defined = __webpack_require__(148);
    module.exports = function(it) {
        return IObject(defined(it));
    };
}, function(module, exports, __webpack_require__) {
    var defined = __webpack_require__(148);
    module.exports = function(it) {
        return Object(defined(it));
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
        return typeof obj;
    } : function(obj) {
        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), _warning = __webpack_require__(11), _warning2 = _interopRequireDefault(_warning), _toCss = __webpack_require__(163), _toCss2 = _interopRequireDefault(_toCss), _toCssValue = __webpack_require__(110), _toCssValue2 = _interopRequireDefault(_toCssValue), StyleRule = function() {
        function StyleRule(key, style, options) {
            _classCallCheck(this, StyleRule), this.type = "style", this.isProcessed = !1;
            var sheet = options.sheet, Renderer = options.Renderer, selector = options.selector;
            this.key = key, this.options = options, this.style = style, selector && (this.selectorText = selector), 
            this.renderer = sheet ? sheet.renderer : new Renderer();
        }
        return _createClass(StyleRule, [ {
            key: "prop",
            value: function(name, value) {
                if (void 0 === value) return this.style[name];
                if (this.style[name] === value) return this;
                value = this.options.jss.plugins.onChangeValue(value, name, this);
                var isEmpty = null == value || !1 === value, isDefined = name in this.style;
                if (isEmpty && !isDefined) return this;
                var remove = isEmpty && isDefined;
                if (remove ? delete this.style[name] : this.style[name] = value, this.renderable) return remove ? this.renderer.removeProperty(this.renderable, name) : this.renderer.setProperty(this.renderable, name, value), 
                this;
                var sheet = this.options.sheet;
                return sheet && sheet.attached && (0, _warning2.default)(!1, 'Rule is not linked. Missing sheet option "link: true".'), 
                this;
            }
        }, {
            key: "applyTo",
            value: function(renderable) {
                var json = this.toJSON();
                for (var prop in json) this.renderer.setProperty(renderable, prop, json[prop]);
                return this;
            }
        }, {
            key: "toJSON",
            value: function() {
                var json = {};
                for (var prop in this.style) {
                    var value = this.style[prop];
                    "object" !== (void 0 === value ? "undefined" : _typeof(value)) ? json[prop] = value : Array.isArray(value) && (json[prop] = (0, 
                    _toCssValue2.default)(value));
                }
                return json;
            }
        }, {
            key: "toString",
            value: function(options) {
                var sheet = this.options.sheet, link = !!sheet && sheet.options.link, opts = link ? _extends({}, options, {
                    allowEmpty: !0
                }) : options;
                return (0, _toCss2.default)(this.selector, this.style, opts);
            }
        }, {
            key: "selector",
            set: function(selector) {
                if (selector !== this.selectorText && (this.selectorText = selector, this.renderable)) {
                    if (!this.renderer.setSelector(this.renderable, selector) && this.renderable) {
                        var renderable = this.renderer.replaceRule(this.renderable, this);
                        renderable && (this.renderable = renderable);
                    }
                }
            },
            get: function() {
                return this.selectorText;
            }
        } ]), StyleRule;
    }();
    exports.default = StyleRule;
}, function(module, exports, __webpack_require__) {
    function isSymbol(value) {
        return "symbol" == typeof value || isObjectLike(value) && baseGetTag(value) == symbolTag;
    }
    var baseGetTag = __webpack_require__(41), isObjectLike = __webpack_require__(42), symbolTag = "[object Symbol]";
    module.exports = isSymbol;
}, function(module, exports) {
    function identity(value) {
        return value;
    }
    module.exports = identity;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(a, b) {
        return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp2, __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_2_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_classnames__), __WEBPACK_IMPORTED_MODULE_3_react_smooth__ = __webpack_require__(33), __WEBPACK_IMPORTED_MODULE_3_react_smooth___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_react_smooth__), __WEBPACK_IMPORTED_MODULE_4__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__ = __webpack_require__(4), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), getRectangePath = function(x, y, width, height, radius) {
        var maxRadius = Math.min(Math.abs(width) / 2, Math.abs(height) / 2), sign = height >= 0 ? 1 : -1, clockWise = height >= 0 ? 1 : 0, path = void 0;
        if (maxRadius > 0 && radius instanceof Array) {
            for (var newRadius = [], i = 0; i < 4; i++) newRadius[i] = radius[i] > maxRadius ? maxRadius : radius[i];
            path = "M" + x + "," + (y + sign * newRadius[0]), newRadius[0] > 0 && (path += "A " + newRadius[0] + "," + newRadius[0] + ",0,0," + clockWise + "," + (x + newRadius[0]) + "," + y), 
            path += "L " + (x + width - newRadius[1]) + "," + y, newRadius[1] > 0 && (path += "A " + newRadius[1] + "," + newRadius[1] + ",0,0," + clockWise + ",\n        " + (x + width) + "," + (y + sign * newRadius[1])), 
            path += "L " + (x + width) + "," + (y + height - sign * newRadius[2]), newRadius[2] > 0 && (path += "A " + newRadius[2] + "," + newRadius[2] + ",0,0," + clockWise + ",\n        " + (x + width - newRadius[2]) + "," + (y + height)), 
            path += "L " + (x + newRadius[3]) + "," + (y + height), newRadius[3] > 0 && (path += "A " + newRadius[3] + "," + newRadius[3] + ",0,0," + clockWise + ",\n        " + x + "," + (y + height - sign * newRadius[3])), 
            path += "Z";
        } else if (maxRadius > 0 && radius === +radius && radius > 0) {
            var _newRadius = Math.min(maxRadius, radius);
            path = "M " + x + "," + (y + sign * _newRadius) + "\n            A " + _newRadius + "," + _newRadius + ",0,0," + clockWise + "," + (x + _newRadius) + "," + y + "\n            L " + (x + width - _newRadius) + "," + y + "\n            A " + _newRadius + "," + _newRadius + ",0,0," + clockWise + "," + (x + width) + "," + (y + sign * _newRadius) + "\n            L " + (x + width) + "," + (y + height - sign * _newRadius) + "\n            A " + _newRadius + "," + _newRadius + ",0,0," + clockWise + "," + (x + width - _newRadius) + "," + (y + height) + "\n            L " + (x + _newRadius) + "," + (y + height) + "\n            A " + _newRadius + "," + _newRadius + ",0,0," + clockWise + "," + x + "," + (y + height - sign * _newRadius) + " Z";
        } else path = "M " + x + "," + y + " h " + width + " v " + height + " h " + -width + " Z";
        return path;
    }, Rectangle = Object(__WEBPACK_IMPORTED_MODULE_4__util_PureRender__.a)((_temp2 = _class2 = function(_Component) {
        function Rectangle() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, Rectangle);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = Rectangle.__proto__ || Object.getPrototypeOf(Rectangle)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                totalLength: -1
            }, _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(Rectangle, _Component), _createClass(Rectangle, [ {
            key: "componentDidMount",
            value: function() {
                if (this.node && this.node.getTotalLength) try {
                    var totalLength = this.node.getTotalLength();
                    totalLength && this.setState({
                        totalLength: totalLength
                    });
                } catch (err) {}
            }
        }, {
            key: "render",
            value: function() {
                var _this2 = this, _props = this.props, x = _props.x, y = _props.y, width = _props.width, height = _props.height, radius = _props.radius, className = _props.className, totalLength = this.state.totalLength, _props2 = this.props, animationEasing = _props2.animationEasing, animationDuration = _props2.animationDuration, animationBegin = _props2.animationBegin, isAnimationActive = _props2.isAnimationActive, isUpdateAnimationActive = _props2.isUpdateAnimationActive;
                if (x !== +x || y !== +y || width !== +width || height !== +height || 0 === width || 0 === height) return null;
                var layerClass = __WEBPACK_IMPORTED_MODULE_2_classnames___default()("recharts-rectangle", className);
                return isUpdateAnimationActive ? __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3_react_smooth___default.a, {
                    canBegin: totalLength > 0,
                    from: {
                        width: width,
                        height: height,
                        x: x,
                        y: y
                    },
                    to: {
                        width: width,
                        height: height,
                        x: x,
                        y: y
                    },
                    duration: animationDuration,
                    animationEasing: animationEasing,
                    isActive: isUpdateAnimationActive
                }, function(_ref2) {
                    var currWidth = _ref2.width, currHeight = _ref2.height, currX = _ref2.x, currY = _ref2.y;
                    return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3_react_smooth___default.a, {
                        canBegin: totalLength > 0,
                        from: "0px " + (-1 === totalLength ? 1 : totalLength) + "px",
                        to: totalLength + "px 0px",
                        attributeName: "strokeDasharray",
                        begin: animationBegin,
                        duration: animationDuration,
                        isActive: isAnimationActive,
                        easing: animationEasing
                    }, __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("path", _extends({}, Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.k)(_this2.props), Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.e)(_this2.props), {
                        className: layerClass,
                        d: getRectangePath(currX, currY, currWidth, currHeight, radius),
                        ref: function(node) {
                            _this2.node = node;
                        }
                    })));
                }) : __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("path", _extends({}, Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.k)(this.props), Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.e)(this.props), {
                    className: layerClass,
                    d: getRectangePath(x, y, width, height, radius)
                }));
            }
        } ]), Rectangle;
    }(__WEBPACK_IMPORTED_MODULE_0_react__.Component), _class2.displayName = "Rectangle", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.c, __WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.a, {
        className: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
        x: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        y: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        width: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        height: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        radius: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.array ]),
        isAnimationActive: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        isUpdateAnimationActive: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        animationBegin: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        animationDuration: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        animationEasing: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "ease", "ease-in", "ease-out", "ease-in-out", "linear" ])
    }), _class2.defaultProps = {
        x: 0,
        y: 0,
        width: 0,
        height: 0,
        radius: 0,
        isAnimationActive: !1,
        isUpdateAnimationActive: !1,
        animationBegin: 0,
        animationDuration: 1500,
        animationEasing: "ease"
    }, _class = _temp2)) || _class;
    __webpack_exports__.a = Rectangle;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_lodash_isArray__ = __webpack_require__(13), __WEBPACK_IMPORTED_MODULE_0_lodash_isArray___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isArray__), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_2_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_2_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_react__), __WEBPACK_IMPORTED_MODULE_3_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_3_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_prop_types__), __WEBPACK_IMPORTED_MODULE_4_d3_shape__ = __webpack_require__(182), __WEBPACK_IMPORTED_MODULE_5_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_5_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_classnames__), __WEBPACK_IMPORTED_MODULE_6__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_8__util_DataUtils__ = __webpack_require__(9), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), CURVE_FACTORIES = {
        curveBasisClosed: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.c,
        curveBasisOpen: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.d,
        curveBasis: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.b,
        curveLinearClosed: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.f,
        curveLinear: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.e,
        curveMonotoneX: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.g,
        curveMonotoneY: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.h,
        curveNatural: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.i,
        curveStep: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.j,
        curveStepAfter: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.k,
        curveStepBefore: __WEBPACK_IMPORTED_MODULE_4_d3_shape__.l
    }, defined = function(p) {
        return p.x === +p.x && p.y === +p.y;
    }, getX = function(p) {
        return p.x;
    }, getY = function(p) {
        return p.y;
    }, getCurveFactory = function(type, layout) {
        if (__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(type)) return type;
        var name = "curve" + type.slice(0, 1).toUpperCase() + type.slice(1);
        return "curveMonotone" === name && layout ? CURVE_FACTORIES[name + ("vertical" === layout ? "Y" : "X")] : CURVE_FACTORIES[name] || __WEBPACK_IMPORTED_MODULE_4_d3_shape__.e;
    }, Curve = Object(__WEBPACK_IMPORTED_MODULE_6__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function Curve() {
            return _classCallCheck(this, Curve), _possibleConstructorReturn(this, (Curve.__proto__ || Object.getPrototypeOf(Curve)).apply(this, arguments));
        }
        return _inherits(Curve, _Component), _createClass(Curve, [ {
            key: "getPath",
            value: function() {
                var _props = this.props, type = _props.type, points = _props.points, baseLine = _props.baseLine, layout = _props.layout, connectNulls = _props.connectNulls, curveFactory = getCurveFactory(type, layout), formatPoints = connectNulls ? points.filter(function(entry) {
                    return defined(entry);
                }) : points, lineFunction = void 0;
                if (__WEBPACK_IMPORTED_MODULE_0_lodash_isArray___default()(baseLine)) {
                    var areaPoints = formatPoints.map(function(entry, index) {
                        return _extends({}, entry, {
                            base: baseLine[index]
                        });
                    });
                    return lineFunction = "vertical" === layout ? Object(__WEBPACK_IMPORTED_MODULE_4_d3_shape__.a)().y(getY).x1(getX).x0(function(d) {
                        return d.base.x;
                    }) : Object(__WEBPACK_IMPORTED_MODULE_4_d3_shape__.a)().x(getX).y1(getY).y0(function(d) {
                        return d.base.y;
                    }), lineFunction.defined(defined).curve(curveFactory), lineFunction(areaPoints);
                }
                return lineFunction = "vertical" === layout && Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(baseLine) ? Object(__WEBPACK_IMPORTED_MODULE_4_d3_shape__.a)().y(getY).x1(getX).x0(baseLine) : Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.h)(baseLine) ? Object(__WEBPACK_IMPORTED_MODULE_4_d3_shape__.a)().x(getX).y1(getY).y0(baseLine) : Object(__WEBPACK_IMPORTED_MODULE_4_d3_shape__.m)().x(getX).y(getY), 
                lineFunction.defined(defined).curve(curveFactory), lineFunction(formatPoints);
            }
        }, {
            key: "render",
            value: function() {
                var _props2 = this.props, className = _props2.className, points = _props2.points, path = _props2.path, pathRef = _props2.pathRef;
                if (!(points && points.length || path)) return null;
                var realPath = points && points.length ? this.getPath() : path;
                return __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement("path", _extends({}, Object(__WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__.k)(this.props), Object(__WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__.e)(this.props, null, !0), {
                    className: __WEBPACK_IMPORTED_MODULE_5_classnames___default()("recharts-curve", className),
                    d: realPath,
                    ref: pathRef
                }));
            }
        } ]), Curve;
    }(__WEBPACK_IMPORTED_MODULE_2_react__.Component), _class2.displayName = "Curve", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__.c, {
        className: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string,
        type: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOf([ "basis", "basisClosed", "basisOpen", "linear", "linearClosed", "natural", "monotoneX", "monotoneY", "monotone", "step", "stepBefore", "stepAfter" ]), __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func ]),
        layout: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOf([ "horizontal", "vertical" ]),
        baseLine: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.array ]),
        points: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object),
        connectNulls: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool,
        path: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string,
        pathRef: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func
    }), _class2.defaultProps = {
        type: "linear",
        points: [],
        connectNulls: !1
    }, _class = _temp)) || _class;
    __webpack_exports__.a = Curve;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = (__webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), 
    __webpack_require__(1)), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_3__util_ReactUtils__ = __webpack_require__(4), _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), XAxis = Object(__WEBPACK_IMPORTED_MODULE_2__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function XAxis() {
            return _classCallCheck(this, XAxis), _possibleConstructorReturn(this, (XAxis.__proto__ || Object.getPrototypeOf(XAxis)).apply(this, arguments));
        }
        return _inherits(XAxis, _Component), _createClass(XAxis, [ {
            key: "render",
            value: function() {
                return null;
            }
        } ]), XAxis;
    }(__WEBPACK_IMPORTED_MODULE_0_react__.Component), _class2.displayName = "XAxis", 
    _class2.propTypes = {
        allowDecimals: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        allowDuplicatedCategory: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        hide: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        name: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number ]),
        unit: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number ]),
        xAxisId: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number ]),
        domain: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "auto", "dataMin", "dataMax" ]) ])),
        dataKey: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func ]),
        width: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        height: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        mirror: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        orientation: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "top", "bottom" ]),
        type: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "number", "category" ]),
        ticks: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.array,
        tickCount: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        tickFormatter: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
        padding: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.shape({
            left: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
            right: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number
        }),
        allowDataOverflow: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        scale: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf(__WEBPACK_IMPORTED_MODULE_3__util_ReactUtils__.d), __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func ]),
        tick: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.element ]),
        axisLine: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object ]),
        tickLine: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object ]),
        minTickGap: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        tickSize: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        interval: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "preserveStart", "preserveEnd", "preserveStartEnd" ]) ]),
        reversed: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool
    }, _class2.defaultProps = {
        allowDecimals: !0,
        hide: !1,
        orientation: "bottom",
        width: 0,
        height: 30,
        mirror: !1,
        xAxisId: 0,
        tickCount: 5,
        type: "category",
        domain: [ 0, "auto" ],
        padding: {
            left: 0,
            right: 0
        },
        allowDataOverflow: !1,
        scale: "auto",
        reversed: !1,
        allowDuplicatedCategory: !0
    }, _class = _temp)) || _class;
    __webpack_exports__.a = XAxis;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = (__webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), 
    __webpack_require__(1)), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2__util_PureRender__ = __webpack_require__(5), _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), YAxis = Object(__WEBPACK_IMPORTED_MODULE_2__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function YAxis() {
            return _classCallCheck(this, YAxis), _possibleConstructorReturn(this, (YAxis.__proto__ || Object.getPrototypeOf(YAxis)).apply(this, arguments));
        }
        return _inherits(YAxis, _Component), _createClass(YAxis, [ {
            key: "render",
            value: function() {
                return null;
            }
        } ]), YAxis;
    }(__WEBPACK_IMPORTED_MODULE_0_react__.Component), _class2.displayName = "YAxis", 
    _class2.propTypes = {
        allowDecimals: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        allowDuplicatedCategory: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        hide: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        name: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number ]),
        unit: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number ]),
        yAxisId: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number ]),
        domain: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "auto", "dataMin", "dataMax" ]) ])),
        dataKey: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func ]),
        ticks: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.array,
        tickCount: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        tickFormatter: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
        width: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        height: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        mirror: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        orientation: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "left", "right" ]),
        type: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "number", "category" ]),
        padding: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.shape({
            top: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
            bottom: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number
        }),
        allowDataOverflow: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
        scale: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "auto", "linear", "pow", "sqrt", "log", "identity", "time", "band", "point", "ordinal", "quantile", "quantize", "utcTime", "sequential", "threshold" ]), __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func ]),
        tick: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.element ]),
        axisLine: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object ]),
        tickLine: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object ]),
        minTickGap: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        tickSize: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        interval: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "preserveStart", "preserveEnd", "preserveStartEnd" ]) ]),
        reversed: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool
    }, _class2.defaultProps = {
        allowDuplicatedCategory: !0,
        allowDecimals: !0,
        hide: !1,
        orientation: "left",
        width: 60,
        height: 0,
        mirror: !1,
        yAxisId: 0,
        tickCount: 5,
        type: "number",
        domain: [ 0, "auto" ],
        padding: {
            top: 0,
            bottom: 0
        },
        allowDataOverflow: !1,
        scale: "auto",
        reversed: !1
    }, _class = _temp)) || _class;
    __webpack_exports__.a = YAxis;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function toObject(val) {
        if (null === val || void 0 === val) throw new TypeError("Object.assign cannot be called with null or undefined");
        return Object(val);
    }
    var getOwnPropertySymbols = Object.getOwnPropertySymbols, hasOwnProperty = Object.prototype.hasOwnProperty, propIsEnumerable = Object.prototype.propertyIsEnumerable;
    module.exports = function() {
        try {
            if (!Object.assign) return !1;
            var test1 = new String("abc");
            if (test1[5] = "de", "5" === Object.getOwnPropertyNames(test1)[0]) return !1;
            for (var test2 = {}, i = 0; i < 10; i++) test2["_" + String.fromCharCode(i)] = i;
            if ("0123456789" !== Object.getOwnPropertyNames(test2).map(function(n) {
                return test2[n];
            }).join("")) return !1;
            var test3 = {};
            return "abcdefghijklmnopqrst".split("").forEach(function(letter) {
                test3[letter] = letter;
            }), "abcdefghijklmnopqrst" === Object.keys(Object.assign({}, test3)).join("");
        } catch (err) {
            return !1;
        }
    }() ? Object.assign : function(target, source) {
        for (var from, symbols, to = toObject(target), s = 1; s < arguments.length; s++) {
            from = Object(arguments[s]);
            for (var key in from) hasOwnProperty.call(from, key) && (to[key] = from[key]);
            if (getOwnPropertySymbols) {
                symbols = getOwnPropertySymbols(from);
                for (var i = 0; i < symbols.length; i++) propIsEnumerable.call(from, symbols[i]) && (to[symbols[i]] = from[symbols[i]]);
            }
        }
        return to;
    };
}, function(module, exports) {
    module.exports = function(bitmap, value) {
        return {
            enumerable: !(1 & bitmap),
            configurable: !(2 & bitmap),
            writable: !(4 & bitmap),
            value: value
        };
    };
}, function(module, exports, __webpack_require__) {
    var $keys = __webpack_require__(226), enumBugKeys = __webpack_require__(152);
    module.exports = Object.keys || function(O) {
        return $keys(O, enumBugKeys);
    };
}, function(module, exports) {
    module.exports = {};
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    function createBreakpoints(breakpoints) {
        function up(key) {
            return "@media (min-width:" + ("number" == typeof values[key] ? values[key] : key) + unit + ")";
        }
        function down(key) {
            var endIndex = keys.indexOf(key) + 1, upperbound = values[keys[endIndex]];
            return endIndex === keys.length ? up("xs") : "@media (max-width:" + (("number" == typeof upperbound && endIndex > 0 ? upperbound : key) - step / 100) + unit + ")";
        }
        function between(start, end) {
            var endIndex = keys.indexOf(end) + 1;
            return endIndex === keys.length ? up(start) : "@media (min-width:" + values[start] + unit + ") and (max-width:" + (values[keys[endIndex]] - step / 100) + unit + ")";
        }
        function only(key) {
            return between(key, key);
        }
        function width(key) {
            return values[key];
        }
        var _breakpoints$values = breakpoints.values, values = void 0 === _breakpoints$values ? {
            xs: 0,
            sm: 600,
            md: 960,
            lg: 1280,
            xl: 1920
        } : _breakpoints$values, _breakpoints$unit = breakpoints.unit, unit = void 0 === _breakpoints$unit ? "px" : _breakpoints$unit, _breakpoints$step = breakpoints.step, step = void 0 === _breakpoints$step ? 5 : _breakpoints$step, other = (0, 
        _objectWithoutProperties3.default)(breakpoints, [ "values", "unit", "step" ]);
        return (0, _extends3.default)({
            keys: keys,
            values: values,
            up: up,
            down: down,
            between: between,
            only: only,
            width: width
        }, other);
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.keys = void 0;
    var _extends2 = __webpack_require__(6), _extends3 = _interopRequireDefault(_extends2), _objectWithoutProperties2 = __webpack_require__(7), _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);
    exports.default = createBreakpoints;
    var keys = exports.keys = [ "xs", "sm", "md", "lg", "xl" ];
}, function(module, exports, __webpack_require__) {
    "use strict";
    exports.__esModule = !0;
    var _getDisplayName = __webpack_require__(244), _getDisplayName2 = function(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }(_getDisplayName), wrapDisplayName = function(BaseComponent, hocName) {
        return hocName + "(" + (0, _getDisplayName2.default)(BaseComponent) + ")";
    };
    exports.default = wrapDisplayName;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), _createRule = __webpack_require__(111), _createRule2 = _interopRequireDefault(_createRule), _linkRule = __webpack_require__(249), _linkRule2 = _interopRequireDefault(_linkRule), _StyleRule = __webpack_require__(66), _StyleRule2 = _interopRequireDefault(_StyleRule), _escape = __webpack_require__(467), _escape2 = _interopRequireDefault(_escape), RuleList = function() {
        function RuleList(options) {
            _classCallCheck(this, RuleList), this.map = {}, this.raw = {}, this.index = [], 
            this.options = options, this.classes = options.classes;
        }
        return _createClass(RuleList, [ {
            key: "add",
            value: function(name, decl, options) {
                var _options = this.options, parent = _options.parent, sheet = _options.sheet, jss = _options.jss, Renderer = _options.Renderer, generateClassName = _options.generateClassName;
                options = _extends({
                    classes: this.classes,
                    parent: parent,
                    sheet: sheet,
                    jss: jss,
                    Renderer: Renderer,
                    generateClassName: generateClassName
                }, options), !options.selector && this.classes[name] && (options.selector = "." + (0, 
                _escape2.default)(this.classes[name])), this.raw[name] = decl;
                var rule = (0, _createRule2.default)(name, decl, options), className = void 0;
                !options.selector && rule instanceof _StyleRule2.default && (className = generateClassName(rule, sheet), 
                rule.selector = "." + (0, _escape2.default)(className)), this.register(rule, className);
                var index = void 0 === options.index ? this.index.length : options.index;
                return this.index.splice(index, 0, rule), rule;
            }
        }, {
            key: "get",
            value: function(name) {
                return this.map[name];
            }
        }, {
            key: "remove",
            value: function(rule) {
                this.unregister(rule), this.index.splice(this.indexOf(rule), 1);
            }
        }, {
            key: "indexOf",
            value: function(rule) {
                return this.index.indexOf(rule);
            }
        }, {
            key: "process",
            value: function() {
                var plugins = this.options.jss.plugins;
                this.index.slice(0).forEach(plugins.onProcessRule, plugins);
            }
        }, {
            key: "register",
            value: function(rule, className) {
                this.map[rule.key] = rule, rule instanceof _StyleRule2.default && (this.map[rule.selector] = rule, 
                className && (this.classes[rule.key] = className));
            }
        }, {
            key: "unregister",
            value: function(rule) {
                delete this.map[rule.key], rule instanceof _StyleRule2.default && (delete this.map[rule.selector], 
                delete this.classes[rule.key]);
            }
        }, {
            key: "update",
            value: function(name, data) {
                var _options2 = this.options, plugins = _options2.jss.plugins, sheet = _options2.sheet;
                if ("string" == typeof name) return void plugins.onUpdate(data, this.get(name), sheet);
                for (var index = 0; index < this.index.length; index++) plugins.onUpdate(name, this.index[index], sheet);
            }
        }, {
            key: "link",
            value: function(cssRules) {
                for (var map = this.options.sheet.renderer.getUnescapedKeysMap(this.index), i = 0; i < cssRules.length; i++) {
                    var cssRule = cssRules[i], _key = this.options.sheet.renderer.getKey(cssRule);
                    map[_key] && (_key = map[_key]);
                    var rule = this.map[_key];
                    rule && (0, _linkRule2.default)(rule, cssRule);
                }
            }
        }, {
            key: "toString",
            value: function(options) {
                for (var str = "", sheet = this.options.sheet, link = !!sheet && sheet.options.link, index = 0; index < this.index.length; index++) {
                    var rule = this.index[index], css = rule.toString(options);
                    (css || link) && (str && (str += "\n"), str += css);
                }
                return str;
            }
        } ]), RuleList;
    }();
    exports.default = RuleList;
}, function(module, exports, __webpack_require__) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, menuSkeletons = [ {
        id: "home",
        menu: {
            title: "Home",
            icon: "home"
        }
    }, {
        id: "chain",
        menu: {
            title: "Chain",
            icon: "link"
        }
    }, {
        id: "txpool",
        menu: {
            title: "TxPool",
            icon: "credit-card"
        }
    }, {
        id: "network",
        menu: {
            title: "Network",
            icon: "globe"
        }
    }, {
        id: "system",
        menu: {
            title: "System",
            icon: "tachometer"
        }
    }, {
        id: "logs",
        menu: {
            title: "Logs",
            icon: "list"
        }
    } ];
    exports.MENU = new Map(menuSkeletons.map(function(_ref) {
        var id = _ref.id, menu = _ref.menu;
        return [ id, _extends({
            id: id
        }, menu) ];
    })), exports.DURATION = 200, exports.styles = {
        light: {
            color: "rgba(255, 255, 255, 0.54)"
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function Surface(props) {
        var children = props.children, width = props.width, height = props.height, viewBox = props.viewBox, className = props.className, style = props.style, others = _objectWithoutProperties(props, [ "children", "width", "height", "viewBox", "className", "style" ]), svgView = viewBox || {
            width: width,
            height: height,
            x: 0,
            y: 0
        }, layerClass = __WEBPACK_IMPORTED_MODULE_2_classnames___default()("recharts-surface", className), attrs = Object(__WEBPACK_IMPORTED_MODULE_3__util_ReactUtils__.k)(others);
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("svg", _extends({}, attrs, {
            className: layerClass,
            width: width,
            height: height,
            style: style,
            viewBox: svgView.x + " " + svgView.y + " " + svgView.width + " " + svgView.height,
            version: "1.1"
        }), children);
    }
    var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_2_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_classnames__), __WEBPACK_IMPORTED_MODULE_3__util_ReactUtils__ = __webpack_require__(4), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, propTypes = {
        width: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number.isRequired,
        height: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number.isRequired,
        viewBox: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
            width: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
            height: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number
        }),
        className: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
        style: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object,
        children: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.node), __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.node ])
    };
    Surface.propTypes = propTypes, __webpack_exports__.a = Surface;
}, function(module, exports, __webpack_require__) {
    var root = __webpack_require__(31), Symbol = root.Symbol;
    module.exports = Symbol;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__src_path__ = __webpack_require__(633);
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_path__.a;
    });
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function acos(x) {
        return x > 1 ? 0 : x < -1 ? pi : Math.acos(x);
    }
    function asin(x) {
        return x >= 1 ? halfPi : x <= -1 ? -halfPi : Math.asin(x);
    }
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return abs;
    }), __webpack_require__.d(__webpack_exports__, "d", function() {
        return atan2;
    }), __webpack_require__.d(__webpack_exports__, "e", function() {
        return cos;
    }), __webpack_require__.d(__webpack_exports__, "h", function() {
        return max;
    }), __webpack_require__.d(__webpack_exports__, "i", function() {
        return min;
    }), __webpack_require__.d(__webpack_exports__, "k", function() {
        return sin;
    }), __webpack_require__.d(__webpack_exports__, "l", function() {
        return sqrt;
    }), __webpack_require__.d(__webpack_exports__, "f", function() {
        return epsilon;
    }), __webpack_require__.d(__webpack_exports__, "j", function() {
        return pi;
    }), __webpack_require__.d(__webpack_exports__, "g", function() {
        return halfPi;
    }), __webpack_require__.d(__webpack_exports__, "m", function() {
        return tau;
    }), __webpack_exports__.b = acos, __webpack_exports__.c = asin;
    var abs = Math.abs, atan2 = Math.atan2, cos = Math.cos, max = Math.max, min = Math.min, sin = Math.sin, sqrt = Math.sqrt, epsilon = 1e-12, pi = Math.PI, halfPi = pi / 2, tau = 2 * pi;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(series, order) {
        if ((n = series.length) > 1) for (var j, s0, n, i = 1, s1 = series[order[0]], m = s1.length; i < n; ++i) for (s0 = s1, 
        s1 = series[order[i]], j = 0; j < m; ++j) s1[j][1] += s1[j][0] = isNaN(s0[j][1]) ? s0[j][0] : s0[j][1];
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(series) {
        for (var n = series.length, o = new Array(n); --n >= 0; ) o[n] = n;
        return o;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function Cell() {
        return null;
    }
    var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1__util_ReactUtils__ = (__webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), 
    __webpack_require__(4)), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    };
    Cell.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_1__util_ReactUtils__.c), 
    Cell.displayName = "Cell", __webpack_exports__.a = Cell;
}, function(module, exports, __webpack_require__) {
    function baseIteratee(value) {
        return "function" == typeof value ? value : null == value ? identity : "object" == typeof value ? isArray(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value) : property(value);
    }
    var baseMatches = __webpack_require__(815), baseMatchesProperty = __webpack_require__(818), identity = __webpack_require__(68), isArray = __webpack_require__(13), property = __webpack_require__(822);
    module.exports = baseIteratee;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(x) {
        return null === x ? NaN : +x;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function linearish(scale) {
        var domain = scale.domain;
        return scale.ticks = function(count) {
            var d = domain();
            return Object(__WEBPACK_IMPORTED_MODULE_0_d3_array__.h)(d[0], d[d.length - 1], null == count ? 10 : count);
        }, scale.tickFormat = function(count, specifier) {
            return Object(__WEBPACK_IMPORTED_MODULE_3__tickFormat__.a)(domain(), count, specifier);
        }, scale.nice = function(count) {
            null == count && (count = 10);
            var step, d = domain(), i0 = 0, i1 = d.length - 1, start = d[i0], stop = d[i1];
            return stop < start && (step = start, start = stop, stop = step, step = i0, i0 = i1, 
            i1 = step), step = Object(__WEBPACK_IMPORTED_MODULE_0_d3_array__.f)(start, stop, count), 
            step > 0 ? (start = Math.floor(start / step) * step, stop = Math.ceil(stop / step) * step, 
            step = Object(__WEBPACK_IMPORTED_MODULE_0_d3_array__.f)(start, stop, count)) : step < 0 && (start = Math.ceil(start * step) / step, 
            stop = Math.floor(stop * step) / step, step = Object(__WEBPACK_IMPORTED_MODULE_0_d3_array__.f)(start, stop, count)), 
            step > 0 ? (d[i0] = Math.floor(start / step) * step, d[i1] = Math.ceil(stop / step) * step, 
            domain(d)) : step < 0 && (d[i0] = Math.ceil(start * step) / step, d[i1] = Math.floor(stop * step) / step, 
            domain(d)), scale;
        }, scale;
    }
    function linear() {
        var scale = Object(__WEBPACK_IMPORTED_MODULE_2__continuous__.b)(__WEBPACK_IMPORTED_MODULE_2__continuous__.c, __WEBPACK_IMPORTED_MODULE_1_d3_interpolate__.c);
        return scale.copy = function() {
            return Object(__WEBPACK_IMPORTED_MODULE_2__continuous__.a)(scale, linear());
        }, linearish(scale);
    }
    __webpack_exports__.b = linearish, __webpack_exports__.a = linear;
    var __WEBPACK_IMPORTED_MODULE_0_d3_array__ = __webpack_require__(37), __WEBPACK_IMPORTED_MODULE_1_d3_interpolate__ = __webpack_require__(92), __WEBPACK_IMPORTED_MODULE_2__continuous__ = __webpack_require__(137), __WEBPACK_IMPORTED_MODULE_3__tickFormat__ = __webpack_require__(883);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__src_value__ = __webpack_require__(206);
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_value__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_5__src_number__ = (__webpack_require__(349), __webpack_require__(209), 
    __webpack_require__(347), __webpack_require__(350), __webpack_require__(136));
    __webpack_require__.d(__webpack_exports__, "c", function() {
        return __WEBPACK_IMPORTED_MODULE_5__src_number__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_7__src_round__ = (__webpack_require__(351), __webpack_require__(873));
    __webpack_require__.d(__webpack_exports__, "d", function() {
        return __WEBPACK_IMPORTED_MODULE_7__src_round__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_15__src_cubehelix__ = (__webpack_require__(352), __webpack_require__(874), 
    __webpack_require__(877), __webpack_require__(346), __webpack_require__(878), __webpack_require__(879), 
    __webpack_require__(880), __webpack_require__(881));
    __webpack_require__.d(__webpack_exports__, "b", function() {
        return __WEBPACK_IMPORTED_MODULE_15__src_cubehelix__.a;
    });
    __webpack_require__(882);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function linear(a, d) {
        return function(t) {
            return a + t * d;
        };
    }
    function exponential(a, b, y) {
        return a = Math.pow(a, y), b = Math.pow(b, y) - a, y = 1 / y, function(t) {
            return Math.pow(a + t * b, y);
        };
    }
    function hue(a, b) {
        var d = b - a;
        return d ? linear(a, d > 180 || d < -180 ? d - 360 * Math.round(d / 360) : d) : Object(__WEBPACK_IMPORTED_MODULE_0__constant__.a)(isNaN(a) ? b : a);
    }
    function gamma(y) {
        return 1 == (y = +y) ? nogamma : function(a, b) {
            return b - a ? exponential(a, b, y) : Object(__WEBPACK_IMPORTED_MODULE_0__constant__.a)(isNaN(a) ? b : a);
        };
    }
    function nogamma(a, b) {
        var d = b - a;
        return d ? linear(a, d) : Object(__WEBPACK_IMPORTED_MODULE_0__constant__.a)(isNaN(a) ? b : a);
    }
    __webpack_exports__.c = hue, __webpack_exports__.b = gamma, __webpack_exports__.a = nogamma;
    var __WEBPACK_IMPORTED_MODULE_0__constant__ = __webpack_require__(348);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(s) {
        return s.match(/.{6}/g).map(function(x) {
            return "#" + x;
        });
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _temp, __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_3__util_ReactUtils__ = __webpack_require__(4), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), ErrorBar = (_temp = _class = function(_Component) {
        function ErrorBar() {
            return _classCallCheck(this, ErrorBar), _possibleConstructorReturn(this, (ErrorBar.__proto__ || Object.getPrototypeOf(ErrorBar)).apply(this, arguments));
        }
        return _inherits(ErrorBar, _Component), _createClass(ErrorBar, [ {
            key: "renderErrorBars",
            value: function() {
                var _props = this.props, offset = _props.offset, layout = _props.layout, width = _props.width, dataKey = _props.dataKey, data = _props.data, dataPointFormatter = _props.dataPointFormatter, xAxis = _props.xAxis, yAxis = _props.yAxis, others = _objectWithoutProperties(_props, [ "offset", "layout", "width", "dataKey", "data", "dataPointFormatter", "xAxis", "yAxis" ]), props = Object(__WEBPACK_IMPORTED_MODULE_3__util_ReactUtils__.k)(others);
                return data.map(function(entry, i) {
                    var _dataPointFormatter = dataPointFormatter(entry, dataKey), x = _dataPointFormatter.x, y = _dataPointFormatter.y, value = _dataPointFormatter.value, errorVal = _dataPointFormatter.errorVal;
                    if (!errorVal) return null;
                    var xMid = void 0, yMid = void 0, xMin = void 0, yMin = void 0, xMax = void 0, yMax = void 0, scale = void 0, coordsTop = void 0, coordsMid = void 0, coordsBot = void 0, lowBound = void 0, highBound = void 0;
                    return Array.isArray(errorVal) ? (lowBound = errorVal[0], highBound = errorVal[1]) : (lowBound = errorVal, 
                    highBound = errorVal), "vertical" === layout ? (scale = xAxis.scale, xMid = value, 
                    yMid = y + offset, xMin = scale(xMid - lowBound), yMin = yMid + width, xMax = scale(xMid + highBound), 
                    yMax = yMid - width, coordsTop = {
                        x1: xMax,
                        y1: yMin,
                        x2: xMax,
                        y2: yMax
                    }, coordsMid = {
                        x1: xMin,
                        y1: yMid,
                        x2: xMax,
                        y2: yMid
                    }, coordsBot = {
                        x1: xMin,
                        y1: yMin,
                        x2: xMin,
                        y2: yMax
                    }) : "horizontal" === layout && (scale = yAxis.scale, xMid = x + offset, yMid = value, 
                    xMin = xMid - width, xMax = xMid + width, yMin = scale(yMid - lowBound), yMax = scale(yMid + highBound), 
                    coordsTop = {
                        x1: xMin,
                        y1: yMax,
                        x2: xMax,
                        y2: yMax
                    }, coordsMid = {
                        x1: xMid,
                        y1: yMin,
                        x2: xMid,
                        y2: yMax
                    }, coordsBot = {
                        x1: xMin,
                        y1: yMin,
                        x2: xMax,
                        y2: yMin
                    }), __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__container_Layer__.a, _extends({
                        className: "recharts-errorBar",
                        key: i
                    }, props), __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("line", coordsTop), __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("line", coordsMid), __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("line", coordsBot));
                });
            }
        }, {
            key: "render",
            value: function() {
                return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__container_Layer__.a, {
                    className: "recharts-errorBars"
                }, this.renderErrorBars());
            }
        } ]), ErrorBar;
    }(__WEBPACK_IMPORTED_MODULE_0_react__.Component), _class.propTypes = {
        dataKey: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func ]).isRequired,
        data: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.array,
        xAxis: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object,
        yAxis: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object,
        layout: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
        dataPointFormatter: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
        stroke: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
        strokeWidth: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        width: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        offset: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number
    }, _class.defaultProps = {
        stroke: "black",
        strokeWidth: 1.5,
        width: 5,
        offset: 0,
        layout: "horizontal"
    }, _temp);
    __webpack_exports__.a = ErrorBar;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _defineProperty(obj, key, value) {
        return key in obj ? Object.defineProperty(obj, key, {
            value: value,
            enumerable: !0,
            configurable: !0,
            writable: !0
        }) : obj[key] = value, obj;
    }
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return formatAxisMap;
    });
    var __WEBPACK_IMPORTED_MODULE_0__ChartUtils__ = __webpack_require__(16), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, formatAxisMap = function(props, axisMap, offset, axisType, chartName) {
        var width = props.width, height = props.height, layout = props.layout, ids = Object.keys(axisMap), steps = {
            left: offset.left,
            leftMirror: offset.left,
            right: width - offset.right,
            rightMirror: width - offset.right,
            top: offset.top,
            topMirror: offset.top,
            bottom: height - offset.bottom,
            bottomMirror: height - offset.bottom
        };
        return ids.reduce(function(result, id) {
            var axis = axisMap[id], orientation = axis.orientation, domain = axis.domain, _axis$padding = axis.padding, padding = void 0 === _axis$padding ? {} : _axis$padding, mirror = axis.mirror, reversed = axis.reversed, offsetKey = orientation + (mirror ? "Mirror" : ""), range = void 0, x = void 0, y = void 0, needSpace = void 0;
            range = "xAxis" === axisType ? [ offset.left + (padding.left || 0), offset.left + offset.width - (padding.right || 0) ] : "yAxis" === axisType ? "horizontal" === layout ? [ offset.top + offset.height - (padding.bottom || 0), offset.top + (padding.top || 0) ] : [ offset.top + (padding.top || 0), offset.top + offset.height - (padding.bottom || 0) ] : axis.range, 
            reversed && (range = [ range[1], range[0] ]);
            var _parseScale = Object(__WEBPACK_IMPORTED_MODULE_0__ChartUtils__.A)(axis, chartName), scale = _parseScale.scale, realScaleType = _parseScale.realScaleType;
            scale.domain(domain).range(range), Object(__WEBPACK_IMPORTED_MODULE_0__ChartUtils__.c)(scale);
            var ticks = Object(__WEBPACK_IMPORTED_MODULE_0__ChartUtils__.v)(scale, _extends({}, axis, {
                realScaleType: realScaleType
            }));
            "xAxis" === axisType ? (needSpace = "top" === orientation && !mirror || "bottom" === orientation && mirror, 
            x = offset.left, y = steps[offsetKey] - needSpace * axis.height) : "yAxis" === axisType && (needSpace = "left" === orientation && !mirror || "right" === orientation && mirror, 
            x = steps[offsetKey] - needSpace * axis.width, y = offset.top);
            var finalAxis = _extends({}, axis, ticks, {
                realScaleType: realScaleType,
                x: x,
                y: y,
                scale: scale,
                width: "xAxis" === axisType ? offset.width : axis.width,
                height: "yAxis" === axisType ? offset.height : axis.height
            });
            return finalAxis.bandSize = Object(__WEBPACK_IMPORTED_MODULE_0__ChartUtils__.g)(finalAxis, ticks), 
            axis.hide || "xAxis" !== axisType ? axis.hide || (steps[offsetKey] += (needSpace ? -1 : 1) * finalAxis.width) : steps[offsetKey] += (needSpace ? -1 : 1) * finalAxis.height, 
            _extends({}, result, _defineProperty({}, id, finalAxis));
        }, {});
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        var emptyObject = {};
        "production" !== process.env.NODE_ENV && Object.freeze(emptyObject), module.exports = emptyObject;
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        var emptyFunction = __webpack_require__(50), warning = emptyFunction;
        if ("production" !== process.env.NODE_ENV) {
            var printWarning = function(format) {
                for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) args[_key - 1] = arguments[_key];
                var argIndex = 0, message = "Warning: " + format.replace(/%s/g, function() {
                    return args[argIndex++];
                });
                "undefined" != typeof console && console.error(message);
                try {
                    throw new Error(message);
                } catch (x) {}
            };
            warning = function(condition, format) {
                if (void 0 === format) throw new Error("` + ("`" + `warning(condition, format, ...args)`)) + ("`" + (` requires a warning message argument");
                if (0 !== format.indexOf("Failed Composite propType: ") && !condition) {
                    for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) args[_key2 - 2] = arguments[_key2];
                    printWarning.apply(void 0, [ format ].concat(args));
                }
            };
        }
        module.exports = warning;
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        function checkDCE() {
            if ("undefined" != typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ && "function" == typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE) {
                if ("production" !== process.env.NODE_ENV) throw new Error("^_^");
                try {
                    __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(checkDCE);
                } catch (err) {
                    console.error(err);
                }
            }
        }
        "production" === process.env.NODE_ENV ? (checkDCE(), module.exports = __webpack_require__(378)) : module.exports = __webpack_require__(381);
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    "use strict";
    function is(x, y) {
        return x === y ? 0 !== x || 0 !== y || 1 / x == 1 / y : x !== x && y !== y;
    }
    function shallowEqual(objA, objB) {
        if (is(objA, objB)) return !0;
        if ("object" != typeof objA || null === objA || "object" != typeof objB || null === objB) return !1;
        var keysA = Object.keys(objA), keysB = Object.keys(objB);
        if (keysA.length !== keysB.length) return !1;
        for (var i = 0; i < keysA.length; i++) if (!hasOwnProperty.call(objB, keysA[i]) || !is(objA[keysA[i]], objB[keysA[i]])) return !1;
        return !0;
    }
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    module.exports = shallowEqual;
}, function(module, exports, __webpack_require__) {
    var toInteger = __webpack_require__(149), min = Math.min;
    module.exports = function(it) {
        return it > 0 ? min(toInteger(it), 9007199254740991) : 0;
    };
}, function(module, exports) {
    module.exports = !0;
}, function(module, exports) {
    var id = 0, px = Math.random();
    module.exports = function(key) {
        return "Symbol(".concat(void 0 === key ? "" : key, ")_", (++id + px).toString(36));
    };
}, function(module, exports) {
    exports.f = {}.propertyIsEnumerable;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    exports.__esModule = !0;
    var _iterator = __webpack_require__(396), _iterator2 = _interopRequireDefault(_iterator), _symbol = __webpack_require__(404), _symbol2 = _interopRequireDefault(_symbol), _typeof = "function" == typeof _symbol2.default && "symbol" == typeof _iterator2.default ? function(obj) {
        return typeof obj;
    } : function(obj) {
        return obj && "function" == typeof _symbol2.default && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj;
    };
    exports.default = "function" == typeof _symbol2.default && "symbol" === _typeof(_iterator2.default) ? function(obj) {
        return void 0 === obj ? "undefined" : _typeof(obj);
    } : function(obj) {
        return obj && "function" == typeof _symbol2.default && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : void 0 === obj ? "undefined" : _typeof(obj);
    };
}, function(module, exports, __webpack_require__) {
    var anObject = __webpack_require__(52), dPs = __webpack_require__(400), enumBugKeys = __webpack_require__(152), IE_PROTO = __webpack_require__(150)("IE_PROTO"), Empty = function() {}, createDict = function() {
        var iframeDocument, iframe = __webpack_require__(225)("iframe"), i = enumBugKeys.length;
        for (iframe.style.display = "none", __webpack_require__(401).appendChild(iframe), 
        iframe.src = "javascript:", iframeDocument = iframe.contentWindow.document, iframeDocument.open(), 
        iframeDocument.write("<script>document.F=Object<\/script>"), iframeDocument.close(), 
        createDict = iframeDocument.F; i--; ) delete createDict.prototype[enumBugKeys[i]];
        return createDict();
    };
    module.exports = Object.create || function(O, Properties) {
        var result;
        return null !== O ? (Empty.prototype = anObject(O), result = new Empty(), Empty.prototype = null, 
        result[IE_PROTO] = O) : result = createDict(), void 0 === Properties ? result : dPs(result, Properties);
    };
}, function(module, exports, __webpack_require__) {
    var def = __webpack_require__(22).f, has = __webpack_require__(54), TAG = __webpack_require__(21)("toStringTag");
    module.exports = function(it, tag, stat) {
        it && !has(it = stat ? it : it.prototype, TAG) && def(it, TAG, {
            configurable: !0,
            value: tag
        });
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function isNonNullObject(value) {
        return !!value && "object" == typeof value;
    }
    function isSpecial(value) {
        var stringValue = Object.prototype.toString.call(value);
        return "[object RegExp]" === stringValue || "[object Date]" === stringValue || isReactElement(value);
    }
    function isReactElement(value) {
        return value.$$typeof === REACT_ELEMENT_TYPE;
    }
    function emptyTarget(val) {
        return Array.isArray(val) ? [] : {};
    }
    function cloneUnlessOtherwiseSpecified(value, optionsArgument) {
        return optionsArgument && !1 === optionsArgument.clone || !isMergeableObject(value) ? value : deepmerge(emptyTarget(value), value, optionsArgument);
    }
    function defaultArrayMerge(target, source, optionsArgument) {
        return target.concat(source).map(function(element) {
            return cloneUnlessOtherwiseSpecified(element, optionsArgument);
        });
    }
    function mergeObject(target, source, optionsArgument) {
        var destination = {};
        return isMergeableObject(target) && Object.keys(target).forEach(function(key) {
            destination[key] = cloneUnlessOtherwiseSpecified(target[key], optionsArgument);
        }), Object.keys(source).forEach(function(key) {
            isMergeableObject(source[key]) && target[key] ? destination[key] = deepmerge(target[key], source[key], optionsArgument) : destination[key] = cloneUnlessOtherwiseSpecified(source[key], optionsArgument);
        }), destination;
    }
    function deepmerge(target, source, optionsArgument) {
        var sourceIsArray = Array.isArray(source), targetIsArray = Array.isArray(target), options = optionsArgument || {
            arrayMerge: defaultArrayMerge
        };
        if (sourceIsArray === targetIsArray) return sourceIsArray ? (options.arrayMerge || defaultArrayMerge)(target, source, optionsArgument) : mergeObject(target, source, optionsArgument);
        return cloneUnlessOtherwiseSpecified(source, optionsArgument);
    }
    Object.defineProperty(__webpack_exports__, "__esModule", {
        value: !0
    });
    var isMergeableObject = function(value) {
        return isNonNullObject(value) && !isSpecial(value);
    }, canUseSymbol = "function" == typeof Symbol && Symbol.for, REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for("react.element") : 60103;
    deepmerge.all = function(array, optionsArgument) {
        if (!Array.isArray(array)) throw new Error("first argument should be an array");
        return array.reduce(function(prev, next) {
            return deepmerge(prev, next, optionsArgument);
        }, {});
    };
    var deepmerge_1 = deepmerge;
    __webpack_exports__.default = deepmerge_1;
}, function(module, exports, __webpack_require__) {
    var ctx = __webpack_require__(51), call = __webpack_require__(239), isArrayIter = __webpack_require__(240), anObject = __webpack_require__(52), toLength = __webpack_require__(101), getIterFn = __webpack_require__(241), BREAK = {}, RETURN = {}, exports = module.exports = function(iterable, entries, fn, that, ITERATOR) {
        var length, step, iterator, result, iterFn = ITERATOR ? function() {
            return iterable;
        } : getIterFn(iterable), f = ctx(fn, that, entries ? 2 : 1), index = 0;
        if ("function" != typeof iterFn) throw TypeError(iterable + " is not iterable!");
        if (isArrayIter(iterFn)) {
            for (length = toLength(iterable.length); length > index; index++) if ((result = entries ? f(anObject(step = iterable[index])[0], step[1]) : f(iterable[index])) === BREAK || result === RETURN) return result;
        } else for (iterator = iterFn.call(iterable); !(step = iterator.next()).done; ) if ((result = call(iterator, f, step.value, entries)) === BREAK || result === RETURN) return result;
    };
    exports.BREAK = BREAK, exports.RETURN = RETURN;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function toCssValue(value) {
        var ignoreImportant = arguments.length > 1 && void 0 !== arguments[1] && arguments[1];
        if (!Array.isArray(value)) return value;
        var cssValue = "";
        if (Array.isArray(value[0])) for (var i = 0; i < value.length && "!important" !== value[i]; i++) cssValue && (cssValue += ", "), 
        cssValue += join(value[i], " "); else cssValue = join(value, ", ");
        return ignoreImportant || "!important" !== value[value.length - 1] || (cssValue += " !important"), 
        cssValue;
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.default = toCssValue;
    var join = function(value, by) {
        for (var result = "", i = 0; i < value.length && "!important" !== value[i]; i++) result && (result += by), 
        result += value[i];
        return result;
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    function createRule() {
        var name = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : "unnamed", decl = arguments[1], options = arguments[2], jss = options.jss, declCopy = (0, 
        _cloneStyle2.default)(decl), rule = jss.plugins.onCreateRule(name, declCopy, options);
        return rule || ("@" === name[0] && (0, _warning2.default)(!1, "[JSS] Unknown at-rule %s", name), 
        new _StyleRule2.default(name, declCopy, options));
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.default = createRule;
    var _warning = __webpack_require__(11), _warning2 = _interopRequireDefault(_warning), _StyleRule = __webpack_require__(66), _StyleRule2 = _interopRequireDefault(_StyleRule), _cloneStyle = __webpack_require__(463), _cloneStyle2 = _interopRequireDefault(_cloneStyle);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    Object.defineProperty(__webpack_exports__, "__esModule", {
        value: !0
    }), __webpack_require__.d(__webpack_exports__, "isBrowser", function() {
        return isBrowser;
    });
    var _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
        return typeof obj;
    } : function(obj) {
        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    }, isBrowser = "object" === ("undefined" == typeof window ? "undefined" : _typeof(window)) && "object" === ("undefined" == typeof document ? "undefined" : _typeof(document)) && 9 === document.nodeType;
    __webpack_exports__.default = isBrowser;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _Typography = __webpack_require__(528);
    Object.defineProperty(exports, "default", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_Typography).default;
        }
    });
}, function(module, exports) {
    module.exports = function(exec) {
        try {
            return !!exec();
        } catch (e) {
            return !0;
        }
    };
}, function(module, exports, __webpack_require__) {
    var getNative = __webpack_require__(57), nativeCreate = getNative(Object, "create");
    module.exports = nativeCreate;
}, function(module, exports, __webpack_require__) {
    function ListCache(entries) {
        var index = -1, length = null == entries ? 0 : entries.length;
        for (this.clear(); ++index < length; ) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
        }
    }
    var listCacheClear = __webpack_require__(619), listCacheDelete = __webpack_require__(620), listCacheGet = __webpack_require__(621), listCacheHas = __webpack_require__(622), listCacheSet = __webpack_require__(623);
    ListCache.prototype.clear = listCacheClear, ListCache.prototype.delete = listCacheDelete, 
    ListCache.prototype.get = listCacheGet, ListCache.prototype.has = listCacheHas, 
    ListCache.prototype.set = listCacheSet, module.exports = ListCache;
}, function(module, exports, __webpack_require__) {
    function assocIndexOf(array, key) {
        for (var length = array.length; length--; ) if (eq(array[length][0], key)) return length;
        return -1;
    }
    var eq = __webpack_require__(177);
    module.exports = assocIndexOf;
}, function(module, exports, __webpack_require__) {
    function getMapData(map, key) {
        var data = map.__data__;
        return isKeyable(key) ? data["string" == typeof key ? "string" : "hash"] : data.map;
    }
    var isKeyable = __webpack_require__(625);
    module.exports = getMapData;
}, function(module, exports, __webpack_require__) {
    function toKey(value) {
        if ("string" == typeof value || isSymbol(value)) return value;
        var result = value + "";
        return "0" == result && 1 / value == -INFINITY ? "-0" : result;
    }
    var isSymbol = __webpack_require__(67), INFINITY = 1 / 0;
    module.exports = toKey;
}, function(module, exports, __webpack_require__) {
    function isNaN(value) {
        return isNumber(value) && value != +value;
    }
    var isNumber = __webpack_require__(272);
    module.exports = isNaN;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function Linear(context) {
        this._context = context;
    }
    Linear.prototype = {
        areaStart: function() {
            this._line = 0;
        },
        areaEnd: function() {
            this._line = NaN;
        },
        lineStart: function() {
            this._point = 0;
        },
        lineEnd: function() {
            (this._line || 0 !== this._line && 1 === this._point) && this._context.closePath(), 
            this._line = 1 - this._line;
        },
        point: function(x, y) {
            switch (x = +x, y = +y, this._point) {
              case 0:
                this._point = 1, this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y);
                break;

              case 1:
                this._point = 2;

              default:
                this._context.lineTo(x, y);
            }
        }
    }, __webpack_exports__.a = function(context) {
        return new Linear(context);
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function() {};
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function point(that, x, y) {
        that._context.bezierCurveTo((2 * that._x0 + that._x1) / 3, (2 * that._y0 + that._y1) / 3, (that._x0 + 2 * that._x1) / 3, (that._y0 + 2 * that._y1) / 3, (that._x0 + 4 * that._x1 + x) / 6, (that._y0 + 4 * that._y1 + y) / 6);
    }
    function Basis(context) {
        this._context = context;
    }
    __webpack_exports__.c = point, __webpack_exports__.a = Basis, Basis.prototype = {
        areaStart: function() {
            this._line = 0;
        },
        areaEnd: function() {
            this._line = NaN;
        },
        lineStart: function() {
            this._x0 = this._x1 = this._y0 = this._y1 = NaN, this._point = 0;
        },
        lineEnd: function() {
            switch (this._point) {
              case 3:
                point(this, this._x1, this._y1);

              case 2:
                this._context.lineTo(this._x1, this._y1);
            }
            (this._line || 0 !== this._line && 1 === this._point) && this._context.closePath(), 
            this._line = 1 - this._line;
        },
        point: function(x, y) {
            switch (x = +x, y = +y, this._point) {
              case 0:
                this._point = 1, this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y);
                break;

              case 1:
                this._point = 2;
                break;

              case 2:
                this._point = 3, this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6);

              default:
                point(this, x, y);
            }
            this._x0 = this._x1, this._x1 = x, this._y0 = this._y1, this._y1 = y;
        }
    }, __webpack_exports__.b = function(context) {
        return new Basis(context);
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function point(that, x, y) {
        that._context.bezierCurveTo(that._x1 + that._k * (that._x2 - that._x0), that._y1 + that._k * (that._y2 - that._y0), that._x2 + that._k * (that._x1 - x), that._y2 + that._k * (that._y1 - y), that._x2, that._y2);
    }
    function Cardinal(context, tension) {
        this._context = context, this._k = (1 - tension) / 6;
    }
    __webpack_exports__.b = point, __webpack_exports__.a = Cardinal, Cardinal.prototype = {
        areaStart: function() {
            this._line = 0;
        },
        areaEnd: function() {
            this._line = NaN;
        },
        lineStart: function() {
            this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN, this._point = 0;
        },
        lineEnd: function() {
            switch (this._point) {
              case 2:
                this._context.lineTo(this._x2, this._y2);
                break;

              case 3:
                point(this, this._x1, this._y1);
            }
            (this._line || 0 !== this._line && 1 === this._point) && this._context.closePath(), 
            this._line = 1 - this._line;
        },
        point: function(x, y) {
            switch (x = +x, y = +y, this._point) {
              case 0:
                this._point = 1, this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y);
                break;

              case 1:
                this._point = 2, this._x1 = x, this._y1 = y;
                break;

              case 2:
                this._point = 3;

              default:
                point(this, x, y);
            }
            this._x0 = this._x1, this._x1 = this._x2, this._x2 = x, this._y0 = this._y1, this._y1 = this._y2, 
            this._y2 = y;
        }
    };
    !function custom(tension) {
        function cardinal(context) {
            return new Cardinal(context, tension);
        }
        return cardinal.tension = function(tension) {
            return custom(+tension);
        }, cardinal;
    }(0);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp2, __WEBPACK_IMPORTED_MODULE_0_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_2_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_2_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_react__), __WEBPACK_IMPORTED_MODULE_3_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_3_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_prop_types__), __WEBPACK_IMPORTED_MODULE_4_react_smooth__ = __webpack_require__(33), __WEBPACK_IMPORTED_MODULE_5__DefaultTooltipContent__ = (__webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_react_smooth__), 
    __webpack_require__(765)), __WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_7__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_8__util_PureRender__ = __webpack_require__(5), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), propTypes = {
        content: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func ]),
        viewBox: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            width: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            height: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number
        }),
        active: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool,
        separator: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string,
        formatter: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func,
        offset: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        itemStyle: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object,
        labelStyle: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object,
        wrapperStyle: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object,
        cursor: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object ]),
        coordinate: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number
        }),
        position: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number
        }),
        label: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.any,
        payload: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.shape({
            name: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.any,
            value: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.array ]),
            unit: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.any
        })),
        isAnimationActive: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool,
        animationDuration: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        animationEasing: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOf([ "ease", "ease-in", "ease-out", "ease-in-out", "linear" ]),
        itemSorter: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func,
        filterNull: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool,
        useTranslate3d: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool
    }, defaultProps = {
        active: !1,
        offset: 10,
        viewBox: {
            x1: 0,
            x2: 0,
            y1: 0,
            y2: 0
        },
        coordinate: {
            x: 0,
            y: 0
        },
        cursorStyle: {},
        separator: " : ",
        wrapperStyle: {},
        itemStyle: {},
        labelStyle: {},
        cursor: !0,
        isAnimationActive: !Object(__WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__.n)(),
        animationEasing: "ease",
        animationDuration: 400,
        itemSorter: function() {
            return -1;
        },
        filterNull: !0,
        useTranslate3d: !1
    }, renderContent = function(content, props) {
        return __WEBPACK_IMPORTED_MODULE_2_react___default.a.isValidElement(content) ? __WEBPACK_IMPORTED_MODULE_2_react___default.a.cloneElement(content, props) : __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(content) ? content(props) : __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__DefaultTooltipContent__.a, props);
    }, Tooltip = Object(__WEBPACK_IMPORTED_MODULE_8__util_PureRender__.a)((_temp2 = _class2 = function(_Component) {
        function Tooltip() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, Tooltip);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = Tooltip.__proto__ || Object.getPrototypeOf(Tooltip)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                boxWidth: -1,
                boxHeight: -1
            }, _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(Tooltip, _Component), _createClass(Tooltip, [ {
            key: "componentDidMount",
            value: function() {
                this.updateBBox();
            }
        }, {
            key: "componentDidUpdate",
            value: function() {
                this.updateBBox();
            }
        }, {
            key: "updateBBox",
            value: function() {
                var _state = this.state, boxWidth = _state.boxWidth, boxHeight = _state.boxHeight;
                if (this.wrapperNode && this.wrapperNode.getBoundingClientRect) {
                    var box = this.wrapperNode.getBoundingClientRect();
                    (Math.abs(box.width - boxWidth) > 1 || Math.abs(box.height - boxHeight) > 1) && this.setState({
                        boxWidth: box.width,
                        boxHeight: box.height
                    });
                } else -1 === boxWidth && -1 === boxHeight || this.setState({
                    boxWidth: -1,
                    boxHeight: -1
                });
            }
        }, {
            key: "render",
            value: function() {
                var _this2 = this, _props = this.props, payload = _props.payload, isAnimationActive = _props.isAnimationActive, animationDuration = _props.animationDuration, animationEasing = _props.animationEasing, filterNull = _props.filterNull, finalPayload = filterNull && payload && payload.length ? payload.filter(function(entry) {
                    return !__WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default()(entry.value);
                }) : payload, hasPayload = finalPayload && finalPayload.length, _props2 = this.props, content = _props2.content, viewBox = _props2.viewBox, coordinate = _props2.coordinate, position = _props2.position, active = _props2.active, offset = _props2.offset, wrapperStyle = _props2.wrapperStyle, outerStyle = _extends({
                    pointerEvents: "none",
                    visibility: active && hasPayload ? "visible" : "hidden",
                    position: "absolute",
                    top: 0
                }, wrapperStyle), translateX = void 0, translateY = void 0;
                if (position && Object(__WEBPACK_IMPORTED_MODULE_7__util_DataUtils__.h)(position.x) && Object(__WEBPACK_IMPORTED_MODULE_7__util_DataUtils__.h)(position.y)) translateX = position.x, 
                translateY = position.y; else {
                    var _state2 = this.state, boxWidth = _state2.boxWidth, boxHeight = _state2.boxHeight;
                    boxWidth > 0 && boxHeight > 0 && coordinate ? (translateX = position && Object(__WEBPACK_IMPORTED_MODULE_7__util_DataUtils__.h)(position.x) ? position.x : Math.max(coordinate.x + boxWidth + offset > viewBox.x + viewBox.width ? coordinate.x - boxWidth - offset : coordinate.x + offset, viewBox.x), 
                    translateY = position && Object(__WEBPACK_IMPORTED_MODULE_7__util_DataUtils__.h)(position.y) ? position.y : Math.max(coordinate.y + boxHeight + offset > viewBox.y + viewBox.height ? coordinate.y - boxHeight - offset : coordinate.y + offset, viewBox.y)) : outerStyle.visibility = "hidden";
                }
                return outerStyle = _extends({}, outerStyle, Object(__WEBPACK_IMPORTED_MODULE_4_react_smooth__.translateStyle)({
                    transform: this.props.useTranslate3d ? "translate3d(" + translateX + "px, " + translateY + "px, 0)" : "translate(" + translateX + "px, " + translateY + "px)"
                })), isAnimationActive && active && (outerStyle = _extends({}, outerStyle, Object(__WEBPACK_IMPORTED_MODULE_4_react_smooth__.translateStyle)({
                    transition: "transform " + animationDuration + "ms " + animationEasing
                }))), __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement("div", {
                    className: "recharts-tooltip-wrapper",
                    style: outerStyle,
                    ref: function(node) {
                        _this2.wrapperNode = node;
                    }
                }, renderContent(content, _extends({}, this.props, {
                    payload: finalPayload
                })));
            }
        } ]), Tooltip;
    }(__WEBPACK_IMPORTED_MODULE_2_react__.Component), _class2.displayName = "Tooltip", 
    _class2.propTypes = propTypes, _class2.defaultProps = defaultProps, _class = _temp2)) || _class;
    __webpack_exports__.a = Tooltip;
}, function(module, exports, __webpack_require__) {
    function ListCache(entries) {
        var index = -1, length = null == entries ? 0 : entries.length;
        for (this.clear(); ++index < length; ) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
        }
    }
    var listCacheClear = __webpack_require__(658), listCacheDelete = __webpack_require__(659), listCacheGet = __webpack_require__(660), listCacheHas = __webpack_require__(661), listCacheSet = __webpack_require__(662);
    ListCache.prototype.clear = listCacheClear, ListCache.prototype.delete = listCacheDelete, 
    ListCache.prototype.get = listCacheGet, ListCache.prototype.has = listCacheHas, 
    ListCache.prototype.set = listCacheSet, module.exports = ListCache;
}, function(module, exports, __webpack_require__) {
    function assocIndexOf(array, key) {
        for (var length = array.length; length--; ) if (eq(array[length][0], key)) return length;
        return -1;
    }
    var eq = __webpack_require__(290);
    module.exports = assocIndexOf;
}, function(module, exports, __webpack_require__) {
    var root = __webpack_require__(36), Symbol = root.Symbol;
    module.exports = Symbol;
}, function(module, exports, __webpack_require__) {
    var getNative = __webpack_require__(59), nativeCreate = getNative(Object, "create");
    module.exports = nativeCreate;
}, function(module, exports, __webpack_require__) {
    function getMapData(map, key) {
        var data = map.__data__;
        return isKeyable(key) ? data["string" == typeof key ? "string" : "hash"] : data.map;
    }
    var isKeyable = __webpack_require__(682);
    module.exports = getMapData;
}, function(module, exports) {
    module.exports = function(module) {
        return module.webpackPolyfill || (module.deprecate = function() {}, module.paths = [], 
        module.children || (module.children = []), Object.defineProperty(module, "loaded", {
            enumerable: !0,
            get: function() {
                return module.l;
            }
        }), Object.defineProperty(module, "id", {
            enumerable: !0,
            get: function() {
                return module.i;
            }
        }), module.webpackPolyfill = 1), module;
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        function _defineProperty(obj, key, value) {
            return key in obj ? Object.defineProperty(obj, key, {
                value: value,
                enumerable: !0,
                configurable: !0,
                writable: !0
            }) : obj[key] = value, obj;
        }
        Object.defineProperty(exports, "__esModule", {
            value: !0
        }), exports.warn = exports.getTransitionVal = exports.compose = exports.translateStyle = exports.mapObject = exports.debugf = exports.debug = exports.log = exports.generatePrefixStyle = exports.getDashCase = exports.identity = exports.getIntersectionKeys = void 0;
        var _intersection2 = __webpack_require__(719), _intersection3 = function(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }(_intersection2), _extends = Object.assign || function(target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = arguments[i];
                for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
            }
            return target;
        }, PREFIX_LIST = [ "Webkit", "Moz", "O", "ms" ], IN_LINE_PREFIX_LIST = [ "-webkit-", "-moz-", "-o-", "-ms-" ], IN_COMPATIBLE_PROPERTY = [ "transform", "transformOrigin", "transition" ], identity = (exports.getIntersectionKeys = function(preObj, nextObj) {
            return (0, _intersection3.default)(Object.keys(preObj), Object.keys(nextObj));
        }, exports.identity = function(param) {
            return param;
        }), getDashCase = exports.getDashCase = function(name) {
            return name.replace(/([A-Z])/g, function(v) {
                return "-" + v.toLowerCase();
            });
        }, generatePrefixStyle = exports.generatePrefixStyle = function(name, value) {
            if (-1 === IN_COMPATIBLE_PROPERTY.indexOf(name)) return _defineProperty({}, name, value);
            var isTransition = "transition" === name, camelName = name.replace(/(\w)/, function(v) {
                return v.toUpperCase();
            }), styleVal = value;
            return PREFIX_LIST.reduce(function(result, property, i) {
                return isTransition && (styleVal = value.replace(/(transform|transform-origin)/gim, IN_LINE_PREFIX_LIST[i] + "$1")), 
                _extends({}, result, _defineProperty({}, property + camelName, styleVal));
            }, {});
        }, log = exports.log = function() {
            var _console;
            (_console = console).log.apply(_console, arguments);
        }, isDev = (exports.debug = function(name) {
            return function(item) {
                return log(name, item), item;
            };
        }, exports.debugf = function(tag, f) {
            return function() {
                for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
                var res = f.apply(void 0, args), name = tag || f.name || "anonymous function", argNames = "(" + args.map(JSON.stringify).join(", ") + ")";
                return log(name + ": " + argNames + " => " + JSON.stringify(res)), res;
            };
        }, exports.mapObject = function(fn, obj) {
            return Object.keys(obj).reduce(function(res, key) {
                return _extends({}, res, _defineProperty({}, key, fn(key, obj[key])));
            }, {});
        }, exports.translateStyle = function(style) {
            return Object.keys(style).reduce(function(res, key) {
                return _extends({}, res, generatePrefixStyle(key, res[key]));
            }, style);
        }, exports.compose = function() {
            for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) args[_key2] = arguments[_key2];
            if (!args.length) return identity;
            var fns = args.reverse(), firstFn = fns[0], tailsFn = fns.slice(1);
            return function() {
                return tailsFn.reduce(function(res, fn) {
                    return fn(res);
                }, firstFn.apply(void 0, arguments));
            };
        }, exports.getTransitionVal = function(props, duration, easing) {
            return props.map(function(prop) {
                return getDashCase(prop) + " " + duration + "ms " + easing;
            }).join(",");
        }, "production" !== process.env.NODE_ENV);
        exports.warn = function(condition, format, a, b, c, d, e, f) {
            if (isDev && "undefined" != typeof console && console.warn && (void 0 === format && console.warn("LogUtils requires an error message argument"), 
            !condition)) if (void 0 === format) console.warn("Minified exception occurred; use the non-minified dev environment for the full error message and additional helpful warnings."); else {
                var args = [ a, b, c, d, e, f ], argIndex = 0;
                console.warn(format.replace(/%s/g, function() {
                    return args[argIndex++];
                }));
            }
        };
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    function toKey(value) {
        if ("string" == typeof value || isSymbol(value)) return value;
        var result = value + "";
        return "0" == result && 1 / value == -INFINITY ? "-0" : result;
    }
    var isSymbol = __webpack_require__(197), INFINITY = 1 / 0;
    module.exports = toKey;
}, function(module, exports, __webpack_require__) {
    function isArrayLike(value) {
        return null != value && isLength(value.length) && !isFunction(value);
    }
    var isFunction = __webpack_require__(8), isLength = __webpack_require__(203);
    module.exports = isArrayLike;
}, function(module, exports, __webpack_require__) {
    function baseExtremum(array, iteratee, comparator) {
        for (var index = -1, length = array.length; ++index < length; ) {
            var value = array[index], current = iteratee(value);
            if (null != current && (void 0 === computed ? current === current && !isSymbol(current) : comparator(current, computed))) var computed = current, result = value;
        }
        return result;
    }
    var isSymbol = __webpack_require__(67);
    module.exports = baseExtremum;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(a, b) {
        return a = +a, b -= a, function(t) {
            return a + b * t;
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function deinterpolateLinear(a, b) {
        return (b -= a = +a) ? function(x) {
            return (x - a) / b;
        } : Object(__WEBPACK_IMPORTED_MODULE_3__constant__.a)(b);
    }
    function deinterpolateClamp(deinterpolate) {
        return function(a, b) {
            var d = deinterpolate(a = +a, b = +b);
            return function(x) {
                return x <= a ? 0 : x >= b ? 1 : d(x);
            };
        };
    }
    function reinterpolateClamp(reinterpolate) {
        return function(a, b) {
            var r = reinterpolate(a = +a, b = +b);
            return function(t) {
                return t <= 0 ? a : t >= 1 ? b : r(t);
            };
        };
    }
    function bimap(domain, range, deinterpolate, reinterpolate) {
        var d0 = domain[0], d1 = domain[1], r0 = range[0], r1 = range[1];
        return d1 < d0 ? (d0 = deinterpolate(d1, d0), r0 = reinterpolate(r1, r0)) : (d0 = deinterpolate(d0, d1), 
        r0 = reinterpolate(r0, r1)), function(x) {
            return r0(d0(x));
        };
    }
    function polymap(domain, range, deinterpolate, reinterpolate) {
        var j = Math.min(domain.length, range.length) - 1, d = new Array(j), r = new Array(j), i = -1;
        for (domain[j] < domain[0] && (domain = domain.slice().reverse(), range = range.slice().reverse()); ++i < j; ) d[i] = deinterpolate(domain[i], domain[i + 1]), 
        r[i] = reinterpolate(range[i], range[i + 1]);
        return function(x) {
            var i = Object(__WEBPACK_IMPORTED_MODULE_0_d3_array__.b)(domain, x, 1, j) - 1;
            return r[i](d[i](x));
        };
    }
    function copy(source, target) {
        return target.domain(source.domain()).range(source.range()).interpolate(source.interpolate()).clamp(source.clamp());
    }
    function continuous(deinterpolate, reinterpolate) {
        function rescale() {
            return piecewise = Math.min(domain.length, range.length) > 2 ? polymap : bimap, 
            output = input = null, scale;
        }
        function scale(x) {
            return (output || (output = piecewise(domain, range, clamp ? deinterpolateClamp(deinterpolate) : deinterpolate, interpolate)))(+x);
        }
        var piecewise, output, input, domain = unit, range = unit, interpolate = __WEBPACK_IMPORTED_MODULE_1_d3_interpolate__.a, clamp = !1;
        return scale.invert = function(y) {
            return (input || (input = piecewise(range, domain, deinterpolateLinear, clamp ? reinterpolateClamp(reinterpolate) : reinterpolate)))(+y);
        }, scale.domain = function(_) {
            return arguments.length ? (domain = __WEBPACK_IMPORTED_MODULE_2__array__.a.call(_, __WEBPACK_IMPORTED_MODULE_4__number__.a), 
            rescale()) : domain.slice();
        }, scale.range = function(_) {
            return arguments.length ? (range = __WEBPACK_IMPORTED_MODULE_2__array__.b.call(_), 
            rescale()) : range.slice();
        }, scale.rangeRound = function(_) {
            return range = __WEBPACK_IMPORTED_MODULE_2__array__.b.call(_), interpolate = __WEBPACK_IMPORTED_MODULE_1_d3_interpolate__.d, 
            rescale();
        }, scale.clamp = function(_) {
            return arguments.length ? (clamp = !!_, rescale()) : clamp;
        }, scale.interpolate = function(_) {
            return arguments.length ? (interpolate = _, rescale()) : interpolate;
        }, rescale();
    }
    __webpack_exports__.c = deinterpolateLinear, __webpack_exports__.a = copy, __webpack_exports__.b = continuous;
    var __WEBPACK_IMPORTED_MODULE_0_d3_array__ = __webpack_require__(37), __WEBPACK_IMPORTED_MODULE_1_d3_interpolate__ = __webpack_require__(92), __WEBPACK_IMPORTED_MODULE_2__array__ = __webpack_require__(62), __WEBPACK_IMPORTED_MODULE_3__constant__ = __webpack_require__(210), __WEBPACK_IMPORTED_MODULE_4__number__ = __webpack_require__(353), unit = [ 0, 1 ];
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__formatDecimal__ = __webpack_require__(211);
    __webpack_exports__.a = function(x) {
        return x = Object(__WEBPACK_IMPORTED_MODULE_0__formatDecimal__.a)(Math.abs(x)), 
        x ? x[1] : NaN;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_2_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_classnames__), __WEBPACK_IMPORTED_MODULE_3__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_5__util_PolarUtils__ = __webpack_require__(23), __WEBPACK_IMPORTED_MODULE_6__util_DataUtils__ = __webpack_require__(9), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), getDeltaAngle = function(startAngle, endAngle) {
        return Object(__WEBPACK_IMPORTED_MODULE_6__util_DataUtils__.j)(endAngle - startAngle) * Math.min(Math.abs(endAngle - startAngle), 359.999);
    }, getTangentCircle = function(_ref) {
        var cx = _ref.cx, cy = _ref.cy, radius = _ref.radius, angle = _ref.angle, sign = _ref.sign, isExternal = _ref.isExternal, cornerRadius = _ref.cornerRadius, centerRadius = cornerRadius * (isExternal ? 1 : -1) + radius, theta = Math.asin(cornerRadius / centerRadius) / __WEBPACK_IMPORTED_MODULE_5__util_PolarUtils__.a, centerAngle = angle + sign * theta;
        return {
            center: Object(__WEBPACK_IMPORTED_MODULE_5__util_PolarUtils__.e)(cx, cy, centerRadius, centerAngle),
            circleTangency: Object(__WEBPACK_IMPORTED_MODULE_5__util_PolarUtils__.e)(cx, cy, radius, centerAngle),
            lineTangency: Object(__WEBPACK_IMPORTED_MODULE_5__util_PolarUtils__.e)(cx, cy, centerRadius * Math.cos(theta * __WEBPACK_IMPORTED_MODULE_5__util_PolarUtils__.a), angle),
            theta: theta
        };
    }, getSectorPath = function(_ref2) {
        var cx = _ref2.cx, cy = _ref2.cy, innerRadius = _ref2.innerRadius, outerRadius = _ref2.outerRadius, startAngle = _ref2.startAngle, endAngle = _ref2.endAngle, angle = getDeltaAngle(startAngle, endAngle), tempEndAngle = startAngle + angle, outerStartPoint = Object(__WEBPACK_IMPORTED_MODULE_5__util_PolarUtils__.e)(cx, cy, outerRadius, startAngle), outerEndPoint = Object(__WEBPACK_IMPORTED_MODULE_5__util_PolarUtils__.e)(cx, cy, outerRadius, tempEndAngle), path = "M " + outerStartPoint.x + "," + outerStartPoint.y + "\n    A " + outerRadius + "," + outerRadius + ",0,\n    " + +(Math.abs(angle) > 180) + "," + +(startAngle > tempEndAngle) + ",\n    " + outerEndPoint.x + "," + outerEndPoint.y + "\n  ";
        if (innerRadius > 0) {
            var innerStartPoint = Object(__WEBPACK_IMPORTED_MODULE_5__util_PolarUtils__.e)(cx, cy, innerRadius, startAngle), innerEndPoint = Object(__WEBPACK_IMPORTED_MODULE_5__util_PolarUtils__.e)(cx, cy, innerRadius, tempEndAngle);
            path += "L " + innerEndPoint.x + "," + innerEndPoint.y + "\n            A " + innerRadius + "," + innerRadius + ",0,\n            " + +(Math.abs(angle) > 180) + "," + +(startAngle <= tempEndAngle) + ",\n            " + innerStartPoint.x + "," + innerStartPoint.y + " Z";
        } else path += "L " + cx + "," + cy + " Z";
        return path;
    }, getSectorWithCorner = function(_ref3) {
        var cx = _ref3.cx, cy = _ref3.cy, innerRadius = _ref3.innerRadius, outerRadius = _ref3.outerRadius, cornerRadius = _ref3.cornerRadius, startAngle = _ref3.startAngle, endAngle = _ref3.endAngle, sign = Object(__WEBPACK_IMPORTED_MODULE_6__util_DataUtils__.j)(endAngle - startAngle), _getTangentCircle = getTangentCircle({
            cx: cx,
            cy: cy,
            radius: outerRadius,
            angle: startAngle,
            sign: sign,
            cornerRadius: cornerRadius
        }), soct = _getTangentCircle.circleTangency, solt = _getTangentCircle.lineTangency, sot = _getTangentCircle.theta, _getTangentCircle2 = getTangentCircle({
            cx: cx,
            cy: cy,
            radius: outerRadius,
            angle: endAngle,
            sign: -sign,
            cornerRadius: cornerRadius
        }), eoct = _getTangentCircle2.circleTangency, eolt = _getTangentCircle2.lineTangency, eot = _getTangentCircle2.theta, outerArcAngle = Math.abs(startAngle - endAngle) - sot - eot;
        if (outerArcAngle < 0) return getSectorPath({
            cx: cx,
            cy: cy,
            innerRadius: innerRadius,
            outerRadius: outerRadius,
            startAngle: startAngle,
            endAngle: endAngle
        });
        var path = "M " + solt.x + "," + solt.y + "\n    A" + cornerRadius + "," + cornerRadius + ",0,0," + +(sign < 0) + "," + soct.x + "," + soct.y + "\n    A" + outerRadius + "," + outerRadius + ",0," + +(outerArcAngle > 180) + "," + +(sign < 0) + "," + eoct.x + "," + eoct.y + "\n    A" + cornerRadius + "," + cornerRadius + ",0,0," + +(sign < 0) + "," + eolt.x + "," + eolt.y + "\n  ";
        if (innerRadius > 0) {
            var _getTangentCircle3 = getTangentCircle({
                cx: cx,
                cy: cy,
                radius: innerRadius,
                angle: startAngle,
                sign: sign,
                isExternal: !0,
                cornerRadius: cornerRadius
            }), sict = _getTangentCircle3.circleTangency, silt = _getTangentCircle3.lineTangency, sit = _getTangentCircle3.theta, _getTangentCircle4 = getTangentCircle({
                cx: cx,
                cy: cy,
                radius: innerRadius,
                angle: endAngle,
                sign: -sign,
                isExternal: !0,
                cornerRadius: cornerRadius
            }), eict = _getTangentCircle4.circleTangency, eilt = _getTangentCircle4.lineTangency, eit = _getTangentCircle4.theta, innerArcAngle = Math.abs(startAngle - endAngle) - sit - eit;
            if (innerArcAngle < 0) return path + "L" + cx + "," + cy + "Z";
            path += "L" + eilt.x + "," + eilt.y + "\n      A" + cornerRadius + "," + cornerRadius + ",0,0," + +(sign < 0) + "," + eict.x + "," + eict.y + "\n      A" + innerRadius + "," + innerRadius + ",0," + +(innerArcAngle > 180) + "," + +(sign > 0) + "," + sict.x + "," + sict.y + "\n      A" + cornerRadius + "," + cornerRadius + ",0,0," + +(sign < 0) + "," + silt.x + "," + silt.y + "Z";
        } else path += "L" + cx + "," + cy + "Z";
        return path;
    }, Sector = Object(__WEBPACK_IMPORTED_MODULE_3__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function Sector() {
            return _classCallCheck(this, Sector), _possibleConstructorReturn(this, (Sector.__proto__ || Object.getPrototypeOf(Sector)).apply(this, arguments));
        }
        return _inherits(Sector, _Component), _createClass(Sector, [ {
            key: "render",
            value: function() {
                var _props = this.props, cx = _props.cx, cy = _props.cy, innerRadius = _props.innerRadius, outerRadius = _props.outerRadius, cornerRadius = _props.cornerRadius, startAngle = _props.startAngle, endAngle = _props.endAngle, className = _props.className;
                if (outerRadius < innerRadius || startAngle === endAngle) return null;
                var layerClass = __WEBPACK_IMPORTED_MODULE_2_classnames___default()("recharts-sector", className), deltaRadius = outerRadius - innerRadius, cr = Object(__WEBPACK_IMPORTED_MODULE_6__util_DataUtils__.d)(cornerRadius, deltaRadius, 0, !0), path = void 0;
                return path = cr > 0 && Math.abs(startAngle - endAngle) < 360 ? getSectorWithCorner({
                    cx: cx,
                    cy: cy,
                    innerRadius: innerRadius,
                    outerRadius: outerRadius,
                    cornerRadius: Math.min(cr, deltaRadius / 2),
                    startAngle: startAngle,
                    endAngle: endAngle
                }) : getSectorPath({
                    cx: cx,
                    cy: cy,
                    innerRadius: innerRadius,
                    outerRadius: outerRadius,
                    startAngle: startAngle,
                    endAngle: endAngle
                }), __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("path", _extends({}, Object(__WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__.k)(this.props), Object(__WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__.e)(this.props), {
                    className: layerClass,
                    d: path
                }));
            }
        } ]), Sector;
    }(__WEBPACK_IMPORTED_MODULE_0_react__.Component), _class2.displayName = "Sector", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__.c, {
        className: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
        cx: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        cy: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        innerRadius: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        outerRadius: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        startAngle: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        endAngle: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        cornerRadius: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string ])
    }), _class2.defaultProps = {
        cx: 0,
        cy: 0,
        innerRadius: 0,
        outerRadius: 0,
        startAngle: 0,
        endAngle: 0,
        cornerRadius: 0
    }, _class = _temp)) || _class;
    __webpack_exports__.a = Sector;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_1_lodash_minBy__ = __webpack_require__(924), __WEBPACK_IMPORTED_MODULE_1_lodash_minBy___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_minBy__), __WEBPACK_IMPORTED_MODULE_2_lodash_maxBy__ = __webpack_require__(368), __WEBPACK_IMPORTED_MODULE_2_lodash_maxBy___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_maxBy__), __WEBPACK_IMPORTED_MODULE_3_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_3_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_react__), __WEBPACK_IMPORTED_MODULE_4_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_4_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_prop_types__), __WEBPACK_IMPORTED_MODULE_5__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_6__component_Text__ = __webpack_require__(61), __WEBPACK_IMPORTED_MODULE_7__component_Label__ = __webpack_require__(44), __WEBPACK_IMPORTED_MODULE_8__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_10__util_PolarUtils__ = __webpack_require__(23), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), PolarRadiusAxis = Object(__WEBPACK_IMPORTED_MODULE_5__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function PolarRadiusAxis() {
            return _classCallCheck(this, PolarRadiusAxis), _possibleConstructorReturn(this, (PolarRadiusAxis.__proto__ || Object.getPrototypeOf(PolarRadiusAxis)).apply(this, arguments));
        }
        return _inherits(PolarRadiusAxis, _Component), _createClass(PolarRadiusAxis, [ {
            key: "getTickValueCoord",
            value: function(_ref) {
                var coordinate = _ref.coordinate, _props = this.props, angle = _props.angle, cx = _props.cx, cy = _props.cy;
                return Object(__WEBPACK_IMPORTED_MODULE_10__util_PolarUtils__.e)(cx, cy, coordinate, angle);
            }
        }, {
            key: "getTickTextAnchor",
            value: function() {
                var orientation = this.props.orientation, textAnchor = void 0;
                switch (orientation) {
                  case "left":
                    textAnchor = "end";
                    break;

                  case "right":
                    textAnchor = "start";
                    break;

                  default:
                    textAnchor = "middle";
                }
                return textAnchor;
            }
        }, {
            key: "getViewBox",
            value: function() {
                var _props2 = this.props, cx = _props2.cx, cy = _props2.cy, angle = _props2.angle, ticks = _props2.ticks, maxRadiusTick = __WEBPACK_IMPORTED_MODULE_2_lodash_maxBy___default()(ticks, function(entry) {
                    return entry.coordinate || 0;
                });
                return {
                    cx: cx,
                    cy: cy,
                    startAngle: angle,
                    endAngle: angle,
                    innerRadius: __WEBPACK_IMPORTED_MODULE_1_lodash_minBy___default()(ticks, function(entry) {
                        return entry.coordinate || 0;
                    }).coordinate || 0,
                    outerRadius: maxRadiusTick.coordinate || 0
                };
            }
        }, {
            key: "renderAxisLine",
            value: function() {
                var _props3 = this.props, cx = _props3.cx, cy = _props3.cy, angle = _props3.angle, ticks = _props3.ticks, axisLine = _props3.axisLine, others = _objectWithoutProperties(_props3, [ "cx", "cy", "angle", "ticks", "axisLine" ]), extent = ticks.reduce(function(result, entry) {
                    return [ Math.min(result[0], entry.coordinate), Math.max(result[1], entry.coordinate) ];
                }, [ 1 / 0, -1 / 0 ]), point0 = Object(__WEBPACK_IMPORTED_MODULE_10__util_PolarUtils__.e)(cx, cy, extent[0], angle), point1 = Object(__WEBPACK_IMPORTED_MODULE_10__util_PolarUtils__.e)(cx, cy, extent[1], angle), props = _extends({}, Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(others), {
                    fill: "none"
                }, Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(axisLine), {
                    x1: point0.x,
                    y1: point0.y,
                    x2: point1.x,
                    y2: point1.y
                });
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("line", _extends({
                    className: "recharts-polar-radius-axis-line"
                }, props));
            }
        }, {
            key: "renderTickItem",
            value: function(option, props, value) {
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__component_Text__.a, _extends({}, props, {
                    className: "recharts-polar-radius-axis-tick-value"
                }), value);
            }
        }, {
            key: "renderTicks",
            value: function() {
                var _this2 = this, _props4 = this.props, ticks = _props4.ticks, tick = _props4.tick, angle = _props4.angle, tickFormatter = _props4.tickFormatter, stroke = _props4.stroke, others = _objectWithoutProperties(_props4, [ "ticks", "tick", "angle", "tickFormatter", "stroke" ]), textAnchor = this.getTickTextAnchor(), axisProps = Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(others), customTickProps = Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(tick), items = ticks.map(function(entry, i) {
                    var coord = _this2.getTickValueCoord(entry), tickProps = _extends({
                        textAnchor: textAnchor,
                        transform: "rotate(" + (90 - angle) + ", " + coord.x + ", " + coord.y + ")"
                    }, axisProps, {
                        stroke: "none",
                        fill: stroke
                    }, customTickProps, {
                        index: i
                    }, coord, {
                        payload: entry
                    });
                    return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, _extends({
                        className: "recharts-polar-radius-axis-tick",
                        key: "tick-" + i
                    }, Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.f)(_this2.props, entry, i)), _this2.renderTickItem(tick, tickProps, tickFormatter ? tickFormatter(entry.value) : entry.value));
                });
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    className: "recharts-polar-radius-axis-ticks"
                }, items);
            }
        }, {
            key: "render",
            value: function() {
                var _props5 = this.props, ticks = _props5.ticks, axisLine = _props5.axisLine, tick = _props5.tick;
                return ticks && ticks.length ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    className: "recharts-polar-radius-axis"
                }, axisLine && this.renderAxisLine(), tick && this.renderTicks(), __WEBPACK_IMPORTED_MODULE_7__component_Label__.a.renderCallByParent(this.props, this.getViewBox())) : null;
            }
        } ]), PolarRadiusAxis;
    }(__WEBPACK_IMPORTED_MODULE_3_react__.Component), _class2.displayName = "PolarRadiusAxis", 
    _class2.axisType = "radiusAxis", _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.c, __WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.a, {
        type: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "number", "category" ]),
        cx: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        cy: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        hide: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool,
        radiusAxisId: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        angle: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        tickCount: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        ticks: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.shape({
            value: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.any,
            coordinate: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number
        })),
        orientation: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "left", "right", "middle" ]),
        axisLine: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object ]),
        tick: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func ]),
        stroke: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string,
        tickFormatter: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func,
        domain: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "auto", "dataMin", "dataMax" ]) ])),
        scale: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "auto", "linear", "pow", "sqrt", "log", "identity", "time", "band", "point", "ordinal", "quantile", "quantize", "utcTime", "sequential", "threshold" ]), __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func ]),
        allowDataOverflow: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool,
        allowDuplicatedCategory: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool
    }), _class2.defaultProps = {
        type: "number",
        radiusAxisId: 0,
        cx: 0,
        cy: 0,
        angle: 0,
        orientation: "right",
        stroke: "#ccc",
        axisLine: !0,
        tick: !0,
        tickCount: 5,
        domain: [ 0, "auto" ],
        allowDataOverflow: !1,
        scale: "auto",
        allowDuplicatedCategory: !0
    }, _class = _temp)) || _class;
    __webpack_exports__.a = PolarRadiusAxis;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__), __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__), __WEBPACK_IMPORTED_MODULE_3__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_4__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_6__shape_Dot__ = __webpack_require__(63), __WEBPACK_IMPORTED_MODULE_7__shape_Polygon__ = __webpack_require__(214), __WEBPACK_IMPORTED_MODULE_8__component_Text__ = __webpack_require__(61), __WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__ = __webpack_require__(23), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), RADIAN = Math.PI / 180, PolarAngleAxis = Object(__WEBPACK_IMPORTED_MODULE_3__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function PolarAngleAxis() {
            return _classCallCheck(this, PolarAngleAxis), _possibleConstructorReturn(this, (PolarAngleAxis.__proto__ || Object.getPrototypeOf(PolarAngleAxis)).apply(this, arguments));
        }
        return _inherits(PolarAngleAxis, _Component), _createClass(PolarAngleAxis, [ {
            key: "getTickLineCoord",
            value: function(data) {
                var _props = this.props, cx = _props.cx, cy = _props.cy, radius = _props.radius, orientation = _props.orientation, tickLine = _props.tickLine, tickLineSize = tickLine && tickLine.size || 8, p1 = Object(__WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__.e)(cx, cy, radius, data.coordinate), p2 = Object(__WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__.e)(cx, cy, radius + ("inner" === orientation ? -1 : 1) * tickLineSize, data.coordinate);
                return {
                    x1: p1.x,
                    y1: p1.y,
                    x2: p2.x,
                    y2: p2.y
                };
            }
        }, {
            key: "getTickTextAnchor",
            value: function(data) {
                var orientation = this.props.orientation, cos = Math.cos(-data.coordinate * RADIAN);
                return cos > 1e-5 ? "outer" === orientation ? "start" : "end" : cos < -1e-5 ? "outer" === orientation ? "end" : "start" : "middle";
            }
        }, {
            key: "renderAxisLine",
            value: function() {
                var _props2 = this.props, cx = _props2.cx, cy = _props2.cy, radius = _props2.radius, axisLine = _props2.axisLine, axisLineType = _props2.axisLineType, props = _extends({}, Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.k)(this.props), {
                    fill: "none"
                }, Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.k)(axisLine));
                if ("circle" === axisLineType) return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__shape_Dot__.a, _extends({
                    className: "recharts-polar-angle-axis-line"
                }, props, {
                    cx: cx,
                    cy: cy,
                    r: radius
                }));
                var ticks = this.props.ticks, points = ticks.map(function(entry) {
                    return Object(__WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__.e)(cx, cy, radius, entry.coordinate);
                });
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__shape_Polygon__.a, _extends({
                    className: "recharts-polar-angle-axis-line"
                }, props, {
                    points: points
                }));
            }
        }, {
            key: "renderTickItem",
            value: function(option, props, value) {
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_1_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__component_Text__.a, _extends({}, props, {
                    className: "recharts-polar-angle-axis-tick-value"
                }), value);
            }
        }, {
            key: "renderTicks",
            value: function() {
                var _this2 = this, _props3 = this.props, ticks = _props3.ticks, tick = _props3.tick, tickLine = _props3.tickLine, tickFormatter = _props3.tickFormatter, stroke = _props3.stroke, axisProps = Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.k)(this.props), customTickProps = Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.k)(tick), tickLineProps = _extends({}, axisProps, {
                    fill: "none"
                }, Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.k)(tickLine)), items = ticks.map(function(entry, i) {
                    var lineCoord = _this2.getTickLineCoord(entry), textAnchor = _this2.getTickTextAnchor(entry), tickProps = _extends({
                        textAnchor: textAnchor
                    }, axisProps, {
                        stroke: "none",
                        fill: stroke
                    }, customTickProps, {
                        index: i,
                        payload: entry,
                        x: lineCoord.x2,
                        y: lineCoord.y2
                    });
                    return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__container_Layer__.a, _extends({
                        className: "recharts-polar-angle-axis-tick",
                        key: "tick-" + i
                    }, Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.f)(_this2.props, entry, i)), tickLine && __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement("line", _extends({
                        className: "recharts-polar-angle-axis-tick-line"
                    }, tickLineProps, lineCoord)), tick && _this2.renderTickItem(tick, tickProps, tickFormatter ? tickFormatter(entry.value) : entry.value));
                });
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__container_Layer__.a, {
                    className: "recharts-polar-angle-axis-ticks"
                }, items);
            }
        }, {
            key: "render",
            value: function() {
                var _props4 = this.props, ticks = _props4.ticks, radius = _props4.radius, axisLine = _props4.axisLine;
                return radius <= 0 || !ticks || !ticks.length ? null : __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__container_Layer__.a, {
                    className: "recharts-polar-angle-axis"
                }, axisLine && this.renderAxisLine(), this.renderTicks());
            }
        } ]), PolarAngleAxis;
    }(__WEBPACK_IMPORTED_MODULE_1_react__.Component), _class2.displayName = "PolarAngleAxis", 
    _class2.axisType = "angleAxis", _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.c, __WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.a, {
        type: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf([ "number", "category" ]),
        angleAxisId: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number ]),
        dataKey: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func ]),
        cx: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        cy: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        radius: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        hide: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
        scale: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.d), __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func ]),
        axisLine: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object ]),
        axisLineType: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf([ "polygon", "circle" ]),
        tickLine: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object ]),
        tick: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.element ]),
        ticks: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.shape({
            value: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.any,
            coordinate: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number
        })),
        stroke: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string,
        orientation: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf([ "inner", "outer" ]),
        tickFormatter: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
        allowDuplicatedCategory: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool
    }), _class2.defaultProps = {
        type: "category",
        angleAxisId: 0,
        scale: "auto",
        cx: 0,
        cy: 0,
        domain: [ 0, "auto" ],
        orientation: "outer",
        axisLine: !0,
        tickLine: !0,
        tick: !0,
        hide: !1,
        allowDuplicatedCategory: !0
    }, _class = _temp)) || _class;
    __webpack_exports__.a = PolarAngleAxis;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = (__webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), 
    __webpack_require__(1)), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2__util_PureRender__ = __webpack_require__(5), _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), ZAxis = Object(__WEBPACK_IMPORTED_MODULE_2__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function ZAxis() {
            return _classCallCheck(this, ZAxis), _possibleConstructorReturn(this, (ZAxis.__proto__ || Object.getPrototypeOf(ZAxis)).apply(this, arguments));
        }
        return _inherits(ZAxis, _Component), _createClass(ZAxis, [ {
            key: "render",
            value: function() {
                return null;
            }
        } ]), ZAxis;
    }(__WEBPACK_IMPORTED_MODULE_0_react__.Component), _class2.displayName = "ZAxis", 
    _class2.propTypes = {
        type: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "number", "category" ]),
        name: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number ]),
        unit: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number ]),
        zAxisId: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number ]),
        dataKey: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func ]),
        range: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number),
        scale: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "auto", "linear", "pow", "sqrt", "log", "identity", "time", "band", "point", "ordinal", "quantile", "quantize", "utcTime", "sequential", "threshold" ]), __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func ])
    }, _class2.defaultProps = {
        zAxisId: 0,
        range: [ 64, 64 ],
        scale: "auto",
        type: "number"
    }, _class = _temp)) || _class;
    __webpack_exports__.a = ZAxis;
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
            if ("production" !== process.env.NODE_ENV) for (var typeSpecName in typeSpecs) if (typeSpecs.hasOwnProperty(typeSpecName)) {
                var error;
                try {
                    invariant("function" == typeof typeSpecs[typeSpecName], "%s: %s type ` + "`"))) + ((`%s` + ("`" + ` is invalid; it must be a function, usually from the `)) + ("`" + (`prop-types` + "`"))))) + ((((` package, but received ` + ("`" + `%s`)) + ("`" + (`.", componentName || "React class", location, typeSpecName, typeof typeSpecs[typeSpecName]), 
                    error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);
                } catch (ex) {
                    error = ex;
                }
                if (warning(!error || error instanceof Error, "%s: type specification of %s ` + "`"))) + ((`%s` + ("`" + ` is invalid; the type checker function must return `)) + ("`" + (`null` + "`")))) + (((` or an ` + ("`" + `Error`)) + ("`" + (` but returned a %s. You may have forgotten to pass an argument to the type checker creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and shape all require an argument).", componentName || "React class", location, typeSpecName, typeof error), 
                error instanceof Error && !(error.message in loggedTypeFailures)) {
                    loggedTypeFailures[error.message] = !0;
                    var stack = getStack ? getStack() : "";
                    warning(!1, "Failed %s type: %s%s", location, error.message, null != stack ? stack : "");
                }
            }
        }
        if ("production" !== process.env.NODE_ENV) var invariant = __webpack_require__(49), warning = __webpack_require__(98), ReactPropTypesSecret = __webpack_require__(144), loggedTypeFailures = {};
        module.exports = checkPropTypes;
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    "use strict";
    module.exports = "SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";
}, function(module, exports, __webpack_require__) {
    var isObject = __webpack_require__(35);
    module.exports = function(it, S) {
        if (!isObject(it)) return it;
        var fn, val;
        if (S && "function" == typeof (fn = it.toString) && !isObject(val = fn.call(it))) return val;
        if ("function" == typeof (fn = it.valueOf) && !isObject(val = fn.call(it))) return val;
        if (!S && "function" == typeof (fn = it.toString) && !isObject(val = fn.call(it))) return val;
        throw TypeError("Can't convert object to primitive value");
    };
}, function(module, exports, __webpack_require__) {
    var cof = __webpack_require__(147);
    module.exports = Object("z").propertyIsEnumerable(0) ? Object : function(it) {
        return "String" == cof(it) ? it.split("") : Object(it);
    };
}, function(module, exports) {
    var toString = {}.toString;
    module.exports = function(it) {
        return toString.call(it).slice(8, -1);
    };
}, function(module, exports) {
    module.exports = function(it) {
        if (void 0 == it) throw TypeError("Can't call method on  " + it);
        return it;
    };
}, function(module, exports) {
    var ceil = Math.ceil, floor = Math.floor;
    module.exports = function(it) {
        return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
    };
}, function(module, exports, __webpack_require__) {
    var shared = __webpack_require__(151)("keys"), uid = __webpack_require__(103);
    module.exports = function(key) {
        return shared[key] || (shared[key] = uid(key));
    };
}, function(module, exports, __webpack_require__) {
    var core = __webpack_require__(17), global = __webpack_require__(24), store = global["__core-js_shared__"] || (global["__core-js_shared__"] = {});
    (module.exports = function(key, value) {
        return store[key] || (store[key] = void 0 !== value ? value : {});
    })("versions", []).push({
        version: core.version,
        mode: __webpack_require__(102) ? "pure" : "global",
        copyright: "© 2018 Denis Pushkarev (zloirock.ru)"
    });
}, function(module, exports) {
    module.exports = "constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(",");
}, function(module, exports) {
    exports.f = Object.getOwnPropertySymbols;
}, function(module, exports, __webpack_require__) {
    module.exports = {
        default: __webpack_require__(392),
        __esModule: !0
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    var $at = __webpack_require__(398)(!0);
    __webpack_require__(156)(String, "String", function(iterated) {
        this._t = String(iterated), this._i = 0;
    }, function() {
        var point, O = this._t, index = this._i;
        return index >= O.length ? {
            value: void 0,
            done: !0
        } : (point = $at(O, index), this._i += point.length, {
            value: point,
            done: !1
        });
    });
}, function(module, exports, __webpack_require__) {
    "use strict";
    var LIBRARY = __webpack_require__(102), $export = __webpack_require__(19), redefine = __webpack_require__(229), hide = __webpack_require__(39), Iterators = __webpack_require__(77), $iterCreate = __webpack_require__(399), setToStringTag = __webpack_require__(107), getPrototypeOf = __webpack_require__(227), ITERATOR = __webpack_require__(21)("iterator"), BUGGY = !([].keys && "next" in [].keys()), returnThis = function() {
        return this;
    };
    module.exports = function(Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
        $iterCreate(Constructor, NAME, next);
        var methods, key, IteratorPrototype, getMethod = function(kind) {
            if (!BUGGY && kind in proto) return proto[kind];
            switch (kind) {
              case "keys":
              case "values":
                return function() {
                    return new Constructor(this, kind);
                };
            }
            return function() {
                return new Constructor(this, kind);
            };
        }, TAG = NAME + " Iterator", DEF_VALUES = "values" == DEFAULT, VALUES_BUG = !1, proto = Base.prototype, $native = proto[ITERATOR] || proto["@@iterator"] || DEFAULT && proto[DEFAULT], $default = $native || getMethod(DEFAULT), $entries = DEFAULT ? DEF_VALUES ? getMethod("entries") : $default : void 0, $anyNative = "Array" == NAME ? proto.entries || $native : $native;
        if ($anyNative && (IteratorPrototype = getPrototypeOf($anyNative.call(new Base()))) !== Object.prototype && IteratorPrototype.next && (setToStringTag(IteratorPrototype, TAG, !0), 
        LIBRARY || "function" == typeof IteratorPrototype[ITERATOR] || hide(IteratorPrototype, ITERATOR, returnThis)), 
        DEF_VALUES && $native && "values" !== $native.name && (VALUES_BUG = !0, $default = function() {
            return $native.call(this);
        }), LIBRARY && !FORCED || !BUGGY && !VALUES_BUG && proto[ITERATOR] || hide(proto, ITERATOR, $default), 
        Iterators[NAME] = $default, Iterators[TAG] = returnThis, DEFAULT) if (methods = {
            values: DEF_VALUES ? $default : getMethod("values"),
            keys: IS_SET ? $default : getMethod("keys"),
            entries: $entries
        }, FORCED) for (key in methods) key in proto || redefine(proto, key, methods[key]); else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
        return methods;
    };
}, function(module, exports, __webpack_require__) {
    exports.f = __webpack_require__(21);
}, function(module, exports, __webpack_require__) {
    var META = __webpack_require__(103)("meta"), isObject = __webpack_require__(35), has = __webpack_require__(54), setDesc = __webpack_require__(22).f, id = 0, isExtensible = Object.isExtensible || function() {
        return !0;
    }, FREEZE = !__webpack_require__(53)(function() {
        return isExtensible(Object.preventExtensions({}));
    }), setMeta = function(it) {
        setDesc(it, META, {
            value: {
                i: "O" + ++id,
                w: {}
            }
        });
    }, fastKey = function(it, create) {
        if (!isObject(it)) return "symbol" == typeof it ? it : ("string" == typeof it ? "S" : "P") + it;
        if (!has(it, META)) {
            if (!isExtensible(it)) return "F";
            if (!create) return "E";
            setMeta(it);
        }
        return it[META].i;
    }, getWeak = function(it, create) {
        if (!has(it, META)) {
            if (!isExtensible(it)) return !0;
            if (!create) return !1;
            setMeta(it);
        }
        return it[META].w;
    }, onFreeze = function(it) {
        return FREEZE && meta.NEED && isExtensible(it) && !has(it, META) && setMeta(it), 
        it;
    }, meta = module.exports = {
        KEY: META,
        NEED: !1,
        fastKey: fastKey,
        getWeak: getWeak,
        onFreeze: onFreeze
    };
}, function(module, exports, __webpack_require__) {
    var global = __webpack_require__(24), core = __webpack_require__(17), LIBRARY = __webpack_require__(102), wksExt = __webpack_require__(157), defineProperty = __webpack_require__(22).f;
    module.exports = function(name) {
        var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});
        "_" == name.charAt(0) || name in $Symbol || defineProperty($Symbol, name, {
            value: wksExt.f(name)
        });
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.CHANNEL = void 0;
    var _defineProperty2 = __webpack_require__(12), _defineProperty3 = _interopRequireDefault(_defineProperty2), _propTypes = __webpack_require__(1), _propTypes2 = _interopRequireDefault(_propTypes), CHANNEL = exports.CHANNEL = "__THEMING__", themeListener = {
        contextTypes: (0, _defineProperty3.default)({}, CHANNEL, _propTypes2.default.object),
        initial: function(context) {
            return context[CHANNEL] ? context[CHANNEL].getState() : null;
        },
        subscribe: function(context, cb) {
            return context[CHANNEL] ? context[CHANNEL].subscribe(cb) : null;
        },
        unsubscribe: function(context, subscriptionId) {
            context[CHANNEL] && context[CHANNEL].unsubscribe(subscriptionId);
        }
    };
    exports.default = themeListener;
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }
        function createMuiTheme() {
            var options = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}, _options$palette = options.palette, paletteInput = void 0 === _options$palette ? {} : _options$palette, _options$breakpoints = options.breakpoints, breakpointsInput = void 0 === _options$breakpoints ? {} : _options$breakpoints, _options$mixins = options.mixins, mixinsInput = void 0 === _options$mixins ? {} : _options$mixins, _options$typography = options.typography, typographyInput = void 0 === _options$typography ? {} : _options$typography, shadowsInput = options.shadows, other = (0, 
            _objectWithoutProperties3.default)(options, [ "palette", "breakpoints", "mixins", "typography", "shadows" ]), palette = (0, 
            _createPalette2.default)(paletteInput), breakpoints = (0, _createBreakpoints2.default)(breakpointsInput), muiTheme = (0, 
            _extends3.default)({
                direction: "ltr",
                palette: palette,
                typography: (0, _createTypography2.default)(palette, typographyInput),
                mixins: (0, _createMixins2.default)(breakpoints, _spacing2.default, mixinsInput),
                breakpoints: breakpoints,
                shadows: shadowsInput || _shadows2.default
            }, (0, _deepmerge2.default)({
                transitions: _transitions2.default,
                spacing: _spacing2.default,
                zIndex: _zIndex2.default
            }, other));
            return "production" !== process.env.NODE_ENV && (0, _warning2.default)(25 === muiTheme.shadows.length, "Material-UI: the shadows array provided to createMuiTheme should support 25 elevations."), 
            muiTheme;
        }
        Object.defineProperty(exports, "__esModule", {
            value: !0
        });
        var _extends2 = __webpack_require__(6), _extends3 = _interopRequireDefault(_extends2), _objectWithoutProperties2 = __webpack_require__(7), _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2), _deepmerge = __webpack_require__(108), _deepmerge2 = _interopRequireDefault(_deepmerge), _warning = __webpack_require__(11), _warning2 = _interopRequireDefault(_warning), _createTypography = __webpack_require__(423), _createTypography2 = _interopRequireDefault(_createTypography), _createBreakpoints = __webpack_require__(78), _createBreakpoints2 = _interopRequireDefault(_createBreakpoints), _createPalette = __webpack_require__(424), _createPalette2 = _interopRequireDefault(_createPalette), _createMixins = __webpack_require__(431), _createMixins2 = _interopRequireDefault(_createMixins), _shadows = __webpack_require__(432), _shadows2 = _interopRequireDefault(_shadows), _transitions = __webpack_require__(433), _transitions2 = _interopRequireDefault(_transitions), _zIndex = __webpack_require__(437), _zIndex2 = _interopRequireDefault(_zIndex), _spacing = __webpack_require__(438), _spacing2 = _interopRequireDefault(_spacing);
        exports.default = createMuiTheme;
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    !function(global, factory) {
        module.exports = factory();
    }(0, function() {
        "use strict";
        var REACT_STATICS = {
            childContextTypes: !0,
            contextTypes: !0,
            defaultProps: !0,
            displayName: !0,
            getDefaultProps: !0,
            getDerivedStateFromProps: !0,
            mixins: !0,
            propTypes: !0,
            type: !0
        }, KNOWN_STATICS = {
            name: !0,
            length: !0,
            prototype: !0,
            caller: !0,
            callee: !0,
            arguments: !0,
            arity: !0
        }, defineProperty = Object.defineProperty, getOwnPropertyNames = Object.getOwnPropertyNames, getOwnPropertySymbols = Object.getOwnPropertySymbols, getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor, getPrototypeOf = Object.getPrototypeOf, objectPrototype = getPrototypeOf && getPrototypeOf(Object);
        return function hoistNonReactStatics(targetComponent, sourceComponent, blacklist) {
            if ("string" != typeof sourceComponent) {
                if (objectPrototype) {
                    var inheritedComponent = getPrototypeOf(sourceComponent);
                    inheritedComponent && inheritedComponent !== objectPrototype && hoistNonReactStatics(targetComponent, inheritedComponent, blacklist);
                }
                var keys = getOwnPropertyNames(sourceComponent);
                getOwnPropertySymbols && (keys = keys.concat(getOwnPropertySymbols(sourceComponent)));
                for (var i = 0; i < keys.length; ++i) {
                    var key = keys[i];
                    if (!(REACT_STATICS[key] || KNOWN_STATICS[key] || blacklist && blacklist[key])) {
                        var descriptor = getOwnPropertyDescriptor(sourceComponent, key);
                        try {
                            defineProperty(targetComponent, key, descriptor);
                        } catch (e) {}
                    }
                }
                return targetComponent;
            }
            return targetComponent;
        };
    });
}, function(module, exports, __webpack_require__) {
    "use strict";
    function indentStr(str, indent) {
        for (var result = "", index = 0; index < indent; index++) result += "  ";
        return result + str;
    }
    function toCss(selector, style) {
        var options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {}, result = "";
        if (!style) return result;
        var _options$indent = options.indent, indent = void 0 === _options$indent ? 0 : _options$indent, fallbacks = style.fallbacks;
        if (indent++, fallbacks) if (Array.isArray(fallbacks)) for (var index = 0; index < fallbacks.length; index++) {
            var fallback = fallbacks[index];
            for (var prop in fallback) {
                var value = fallback[prop];
                null != value && (result += "\n" + indentStr(prop + ": " + (0, _toCssValue2.default)(value) + ";", indent));
            }
        } else for (var _prop in fallbacks) {
            var _value = fallbacks[_prop];
            null != _value && (result += "\n" + indentStr(_prop + ": " + (0, _toCssValue2.default)(_value) + ";", indent));
        }
        for (var _prop2 in style) {
            var _value2 = style[_prop2];
            null != _value2 && "fallbacks" !== _prop2 && (result += "\n" + indentStr(_prop2 + ": " + (0, 
            _toCssValue2.default)(_value2) + ";", indent));
        }
        return result || options.allowEmpty ? (indent--, result = indentStr(selector + " {" + result + "\n", indent) + indentStr("}", indent)) : result;
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.default = toCss;
    var _toCssValue = __webpack_require__(110), _toCssValue2 = function(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }(_toCssValue);
}, function(module, exports, __webpack_require__) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _SheetsRegistry = __webpack_require__(247), _SheetsRegistry2 = function(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }(_SheetsRegistry);
    exports.default = new _SheetsRegistry2.default();
}, function(module, exports, __webpack_require__) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _isInBrowser = __webpack_require__(112), _isInBrowser2 = function(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }(_isInBrowser), js = "", css = "";
    if (_isInBrowser2.default) {
        var jsCssMap = {
            Moz: "-moz-",
            ms: "-ms-",
            O: "-o-",
            Webkit: "-webkit-"
        }, style = document.createElement("p").style;
        for (var key in jsCssMap) if (key + "Transform" in style) {
            js = key, css = jsCssMap[key];
            break;
        }
    }
    exports.default = {
        js: js,
        css: css
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }
        function _objectWithoutProperties(obj, keys) {
            var target = {};
            for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
            return target;
        }
        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
        }
        function _possibleConstructorReturn(self, call) {
            if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            return !call || "object" != typeof call && "function" != typeof call ? self : call;
        }
        function _inherits(subClass, superClass) {
            if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: !1,
                    writable: !0,
                    configurable: !0
                }
            }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
        }
        function noop() {}
        exports.__esModule = !0, exports.EXITING = exports.ENTERED = exports.ENTERING = exports.EXITED = exports.UNMOUNTED = void 0;
        var _propTypes = __webpack_require__(1), PropTypes = function(obj) {
            if (obj && obj.__esModule) return obj;
            var newObj = {};
            if (null != obj) for (var key in obj) Object.prototype.hasOwnProperty.call(obj, key) && (newObj[key] = obj[key]);
            return newObj.default = obj, newObj;
        }(_propTypes), _react = __webpack_require__(0), _react2 = _interopRequireDefault(_react), _reactDom = __webpack_require__(99), _reactDom2 = _interopRequireDefault(_reactDom), _PropTypes = __webpack_require__(519), UNMOUNTED = exports.UNMOUNTED = "unmounted", EXITED = exports.EXITED = "exited", ENTERING = exports.ENTERING = "entering", ENTERED = exports.ENTERED = "entered", EXITING = exports.EXITING = "exiting", Transition = function(_React$Component) {
            function Transition(props, context) {
                _classCallCheck(this, Transition);
                var _this = _possibleConstructorReturn(this, _React$Component.call(this, props, context)), parentGroup = context.transitionGroup, appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear, initialStatus = void 0;
                return _this.nextStatus = null, props.in ? appear ? (initialStatus = EXITED, _this.nextStatus = ENTERING) : initialStatus = ENTERED : initialStatus = props.unmountOnExit || props.mountOnEnter ? UNMOUNTED : EXITED, 
                _this.state = {
                    status: initialStatus
                }, _this.nextCallback = null, _this;
            }
            return _inherits(Transition, _React$Component), Transition.prototype.getChildContext = function() {
                return {
                    transitionGroup: null
                };
            }, Transition.prototype.componentDidMount = function() {
                this.updateStatus(!0);
            }, Transition.prototype.componentWillReceiveProps = function(nextProps) {
                var _ref = this.pendingState || this.state, status = _ref.status;
                nextProps.in ? (status === UNMOUNTED && this.setState({
                    status: EXITED
                }), status !== ENTERING && status !== ENTERED && (this.nextStatus = ENTERING)) : status !== ENTERING && status !== ENTERED || (this.nextStatus = EXITING);
            }, Transition.prototype.componentDidUpdate = function() {
                this.updateStatus();
            }, Transition.prototype.componentWillUnmount = function() {
                this.cancelNextCallback();
            }, Transition.prototype.getTimeouts = function() {
                var timeout = this.props.timeout, exit = void 0, enter = void 0, appear = void 0;
                return exit = enter = appear = timeout, null != timeout && "number" != typeof timeout && (exit = timeout.exit, 
                enter = timeout.enter, appear = timeout.appear), {
                    exit: exit,
                    enter: enter,
                    appear: appear
                };
            }, Transition.prototype.updateStatus = function() {
                var mounting = arguments.length > 0 && void 0 !== arguments[0] && arguments[0], nextStatus = this.nextStatus;
                if (null !== nextStatus) {
                    this.nextStatus = null, this.cancelNextCallback();
                    var node = _reactDom2.default.findDOMNode(this);
                    nextStatus === ENTERING ? this.performEnter(node, mounting) : this.performExit(node);
                } else this.props.unmountOnExit && this.state.status === EXITED && this.setState({
                    status: UNMOUNTED
                });
            }, Transition.prototype.performEnter = function(node, mounting) {
                var _this2 = this, enter = this.props.enter, appearing = this.context.transitionGroup ? this.context.transitionGroup.isMounting : mounting, timeouts = this.getTimeouts();
                if (!mounting && !enter) return void this.safeSetState({
                    status: ENTERED
                }, function() {
                    _this2.props.onEntered(node);
                });
                this.props.onEnter(node, appearing), this.safeSetState({
                    status: ENTERING
                }, function() {
                    _this2.props.onEntering(node, appearing), _this2.onTransitionEnd(node, timeouts.enter, function() {
                        _this2.safeSetState({
                            status: ENTERED
                        }, function() {
                            _this2.props.onEntered(node, appearing);
                        });
                    });
                });
            }, Transition.prototype.performExit = function(node) {
                var _this3 = this, exit = this.props.exit, timeouts = this.getTimeouts();
                if (!exit) return void this.safeSetState({
                    status: EXITED
                }, function() {
                    _this3.props.onExited(node);
                });
                this.props.onExit(node), this.safeSetState({
                    status: EXITING
                }, function() {
                    _this3.props.onExiting(node), _this3.onTransitionEnd(node, timeouts.exit, function() {
                        _this3.safeSetState({
                            status: EXITED
                        }, function() {
                            _this3.props.onExited(node);
                        });
                    });
                });
            }, Transition.prototype.cancelNextCallback = function() {
                null !== this.nextCallback && (this.nextCallback.cancel(), this.nextCallback = null);
            }, Transition.prototype.safeSetState = function(nextState, callback) {
                var _this4 = this;
                this.pendingState = nextState, callback = this.setNextCallback(callback), this.setState(nextState, function() {
                    _this4.pendingState = null, callback();
                });
            }, Transition.prototype.setNextCallback = function(callback) {
                var _this5 = this, active = !0;
                return this.nextCallback = function(event) {
                    active && (active = !1, _this5.nextCallback = null, callback(event));
                }, this.nextCallback.cancel = function() {
                    active = !1;
                }, this.nextCallback;
            }, Transition.prototype.onTransitionEnd = function(node, timeout, handler) {
                this.setNextCallback(handler), node ? (this.props.addEndListener && this.props.addEndListener(node, this.nextCallback), 
                null != timeout && setTimeout(this.nextCallback, timeout)) : setTimeout(this.nextCallback, 0);
            }, Transition.prototype.render = function() {
                var status = this.state.status;
                if (status === UNMOUNTED) return null;
                var _props = this.props, children = _props.children, childProps = _objectWithoutProperties(_props, [ "children" ]);
                if (delete childProps.in, delete childProps.mountOnEnter, delete childProps.unmountOnExit, 
                delete childProps.appear, delete childProps.enter, delete childProps.exit, delete childProps.timeout, 
                delete childProps.addEndListener, delete childProps.onEnter, delete childProps.onEntering, 
                delete childProps.onEntered, delete childProps.onExit, delete childProps.onExiting, 
                delete childProps.onExited, "function" == typeof children) return children(status, childProps);
                var child = _react2.default.Children.only(children);
                return _react2.default.cloneElement(child, childProps);
            }, Transition;
        }(_react2.default.Component);
        Transition.contextTypes = {
            transitionGroup: PropTypes.object
        }, Transition.childContextTypes = {
            transitionGroup: function() {}
        }, Transition.propTypes = "production" !== process.env.NODE_ENV ? {
            children: PropTypes.oneOfType([ PropTypes.func.isRequired, PropTypes.element.isRequired ]).isRequired,
            in: PropTypes.bool,
            mountOnEnter: PropTypes.bool,
            unmountOnExit: PropTypes.bool,
            appear: PropTypes.bool,
            enter: PropTypes.bool,
            exit: PropTypes.bool,
            timeout: function(props) {
                for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) args[_key - 1] = arguments[_key];
                var pt = _PropTypes.timeoutsShape;
                return props.addEndListener || (pt = pt.isRequired), pt.apply(void 0, [ props ].concat(args));
            },
            addEndListener: PropTypes.func,
            onEnter: PropTypes.func,
            onEntering: PropTypes.func,
            onEntered: PropTypes.func,
            onExit: PropTypes.func,
            onExiting: PropTypes.func,
            onExited: PropTypes.func
        } : {}, Transition.defaultProps = {
            in: !1,
            mountOnEnter: !1,
            unmountOnExit: !1,
            appear: !1,
            enter: !0,
            exit: !0,
            onEnter: noop,
            onEntering: noop,
            onEntered: noop,
            onExit: noop,
            onExiting: noop,
            onExited: noop
        }, Transition.UNMOUNTED = 0, Transition.EXITED = 1, Transition.ENTERING = 2, Transition.ENTERED = 3, 
        Transition.EXITING = 4, exports.default = Transition;
    }).call(exports, __webpack_require__(2));
}, function(module, exports) {
    var global = module.exports = "undefined" != typeof window && window.Math == Math ? window : "undefined" != typeof self && self.Math == Math ? self : Function("return this")();
    "number" == typeof __g && (__g = global);
}, function(module, exports) {
    var core = module.exports = {
        version: "2.5.1"
    };
    "number" == typeof __e && (__e = core);
}, function(module, exports) {
    module.exports = function(it) {
        return "object" == typeof it ? null !== it : "function" == typeof it;
    };
}, function(module, exports, __webpack_require__) {
    module.exports = !__webpack_require__(114)(function() {
        return 7 != Object.defineProperty({}, "a", {
            get: function() {
                return 7;
            }
        }).a;
    });
}, function(module, exports) {
    module.exports = Math.sign || function(x) {
        return 0 == (x = +x) || x != x ? x : x < 0 ? -1 : 1;
    };
}, function(module, exports) {
    var $expm1 = Math.expm1;
    module.exports = !$expm1 || $expm1(10) > 22025.465794806718 || $expm1(10) < 22025.465794806718 || -2e-17 != $expm1(-2e-17) ? function(x) {
        return 0 == (x = +x) ? x : x > -1e-6 && x < 1e-6 ? x + x * x / 2 : Math.exp(x) - 1;
    } : $expm1;
}, function(module, exports, __webpack_require__) {
    function isString(value) {
        return "string" == typeof value || !isArray(value) && isObjectLike(value) && baseGetTag(value) == stringTag;
    }
    var baseGetTag = __webpack_require__(41), isArray = __webpack_require__(13), isObjectLike = __webpack_require__(42), stringTag = "[object String]";
    module.exports = isString;
}, function(module, exports, __webpack_require__) {
    function get(object, path, defaultValue) {
        var result = null == object ? void 0 : baseGet(object, path);
        return void 0 === result ? defaultValue : result;
    }
    var baseGet = __webpack_require__(269);
    module.exports = get;
}, function(module, exports, __webpack_require__) {
    function isKey(value, object) {
        if (isArray(value)) return !1;
        var type = typeof value;
        return !("number" != type && "symbol" != type && "boolean" != type && null != value && !isSymbol(value)) || (reIsPlainProp.test(value) || !reIsDeepProp.test(value) || null != object && value in Object(object));
    }
    var isArray = __webpack_require__(13), isSymbol = __webpack_require__(67), reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/;
    module.exports = isKey;
}, function(module, exports, __webpack_require__) {
    function MapCache(entries) {
        var index = -1, length = null == entries ? 0 : entries.length;
        for (this.clear(); ++index < length; ) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
        }
    }
    var mapCacheClear = __webpack_require__(608), mapCacheDelete = __webpack_require__(624), mapCacheGet = __webpack_require__(626), mapCacheHas = __webpack_require__(627), mapCacheSet = __webpack_require__(628);
    MapCache.prototype.clear = mapCacheClear, MapCache.prototype.delete = mapCacheDelete, 
    MapCache.prototype.get = mapCacheGet, MapCache.prototype.has = mapCacheHas, MapCache.prototype.set = mapCacheSet, 
    module.exports = MapCache;
}, function(module, exports) {
    function eq(value, other) {
        return value === other || value !== value && other !== other;
    }
    module.exports = eq;
}, function(module, exports, __webpack_require__) {
    var getNative = __webpack_require__(57), root = __webpack_require__(31), Map = getNative(root, "Map");
    module.exports = Map;
}, function(module, exports) {
    function arrayMap(array, iteratee) {
        for (var index = -1, length = null == array ? 0 : array.length, result = Array(length); ++index < length; ) result[index] = iteratee(array[index], index, array);
        return result;
    }
    module.exports = arrayMap;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp2, __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__), __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__), __WEBPACK_IMPORTED_MODULE_3__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_4__DefaultLegendContent__ = __webpack_require__(631), __WEBPACK_IMPORTED_MODULE_5__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__ = __webpack_require__(4), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), renderContent = function(content, props) {
        return __WEBPACK_IMPORTED_MODULE_1_react___default.a.isValidElement(content) ? __WEBPACK_IMPORTED_MODULE_1_react___default.a.cloneElement(content, props) : __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(content) ? content(props) : __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__DefaultLegendContent__.a, props);
    }, ICON_TYPES = __WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__.b.filter(function(type) {
        return "none" !== type;
    }), Legend = Object(__WEBPACK_IMPORTED_MODULE_3__util_PureRender__.a)((_temp2 = _class2 = function(_Component) {
        function Legend() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, Legend);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = Legend.__proto__ || Object.getPrototypeOf(Legend)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                boxWidth: -1,
                boxHeight: -1
            }, _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(Legend, _Component), _createClass(Legend, [ {
            key: "componentDidMount",
            value: function() {
                this.updateBBox();
            }
        }, {
            key: "componentDidUpdate",
            value: function() {
                this.updateBBox();
            }
        }, {
            key: "getBBox",
            value: function() {
                var _state = this.state, boxWidth = _state.boxWidth, boxHeight = _state.boxHeight;
                return boxWidth >= 0 && boxHeight >= 0 ? {
                    width: boxWidth,
                    height: boxHeight
                } : null;
            }
        }, {
            key: "getDefaultPosition",
            value: function(style) {
                var _props = this.props, layout = _props.layout, align = _props.align, verticalAlign = _props.verticalAlign, margin = _props.margin, chartWidth = _props.chartWidth, chartHeight = _props.chartHeight, hPos = void 0, vPos = void 0;
                if (!style || (void 0 === style.left || null === style.left) && (void 0 === style.right || null === style.right)) if ("center" === align && "vertical" === layout) {
                    var box = this.getBBox() || {
                        width: 0
                    };
                    hPos = {
                        left: ((chartWidth || 0) - box.width) / 2
                    };
                } else hPos = "right" === align ? {
                    right: margin && margin.right || 0
                } : {
                    left: margin && margin.left || 0
                };
                if (!style || (void 0 === style.top || null === style.top) && (void 0 === style.bottom || null === style.bottom)) if ("middle" === verticalAlign) {
                    var _box = this.getBBox() || {
                        height: 0
                    };
                    vPos = {
                        top: ((chartHeight || 0) - _box.height) / 2
                    };
                } else vPos = "bottom" === verticalAlign ? {
                    bottom: margin && margin.bottom || 0
                } : {
                    top: margin && margin.top || 0
                };
                return _extends({}, hPos, vPos);
            }
        }, {
            key: "updateBBox",
            value: function() {
                var _state2 = this.state, boxWidth = _state2.boxWidth, boxHeight = _state2.boxHeight, onBBoxUpdate = this.props.onBBoxUpdate;
                if (this.wrapperNode && this.wrapperNode.getBoundingClientRect) {
                    var box = this.wrapperNode.getBoundingClientRect();
                    (Math.abs(box.width - boxWidth) > 1 || Math.abs(box.height - boxHeight) > 1) && this.setState({
                        boxWidth: box.width,
                        boxHeight: box.height
                    }, function() {
                        onBBoxUpdate && onBBoxUpdate(box);
                    });
                } else -1 === boxWidth && -1 === boxHeight || this.setState({
                    boxWidth: -1,
                    boxHeight: -1
                }, function() {
                    onBBoxUpdate && onBBoxUpdate(null);
                });
            }
        }, {
            key: "render",
            value: function() {
                var _this2 = this, _props2 = this.props, content = _props2.content, width = _props2.width, height = _props2.height, wrapperStyle = _props2.wrapperStyle, outerStyle = _extends({
                    position: "absolute",
                    width: width || "auto",
                    height: height || "auto"
                }, this.getDefaultPosition(wrapperStyle), wrapperStyle);
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement("div", {
                    className: "recharts-legend-wrapper",
                    style: outerStyle,
                    ref: function(node) {
                        _this2.wrapperNode = node;
                    }
                }, renderContent(content, this.props));
            }
        } ], [ {
            key: "getWithHeight",
            value: function(item, chartWidth) {
                var layout = item.props.layout;
                return "vertical" === layout && Object(__WEBPACK_IMPORTED_MODULE_5__util_DataUtils__.h)(item.props.height) ? {
                    height: item.props.height
                } : "horizontal" === layout ? {
                    width: item.props.width || chartWidth
                } : null;
            }
        } ]), Legend;
    }(__WEBPACK_IMPORTED_MODULE_1_react__.Component), _class2.displayName = "Legend", 
    _class2.propTypes = {
        content: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func ]),
        wrapperStyle: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object,
        chartWidth: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        chartHeight: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        width: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        height: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        iconSize: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        iconType: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf(ICON_TYPES),
        layout: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf([ "horizontal", "vertical" ]),
        align: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf([ "center", "left", "right" ]),
        verticalAlign: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf([ "top", "bottom", "middle" ]),
        margin: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.shape({
            top: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            left: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            bottom: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            right: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number
        }),
        payload: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.shape({
            value: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.any,
            id: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.any,
            type: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf(__WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__.b)
        })),
        formatter: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
        onMouseEnter: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
        onMouseLeave: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
        onClick: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
        onBBoxUpdate: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func
    }, _class2.defaultProps = {
        iconSize: 14,
        layout: "horizontal",
        align: "center",
        verticalAlign: "bottom"
    }, _class = _temp2)) || _class;
    __webpack_exports__.a = Legend;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2_d3_shape__ = __webpack_require__(182), __WEBPACK_IMPORTED_MODULE_3_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_3_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_classnames__), __WEBPACK_IMPORTED_MODULE_4__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__ = __webpack_require__(4), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), SYMBOL_FACTORIES = {
        symbolCircle: __WEBPACK_IMPORTED_MODULE_2_d3_shape__.u,
        symbolCross: __WEBPACK_IMPORTED_MODULE_2_d3_shape__.v,
        symbolDiamond: __WEBPACK_IMPORTED_MODULE_2_d3_shape__.w,
        symbolSquare: __WEBPACK_IMPORTED_MODULE_2_d3_shape__.x,
        symbolStar: __WEBPACK_IMPORTED_MODULE_2_d3_shape__.y,
        symbolTriangle: __WEBPACK_IMPORTED_MODULE_2_d3_shape__.z,
        symbolWye: __WEBPACK_IMPORTED_MODULE_2_d3_shape__.A
    }, RADIAN = Math.PI / 180, getSymbolFactory = function(type) {
        var name = "symbol" + type.slice(0, 1).toUpperCase() + type.slice(1);
        return SYMBOL_FACTORIES[name] || __WEBPACK_IMPORTED_MODULE_2_d3_shape__.u;
    }, calculateAreaSize = function(size, sizeType, type) {
        if ("area" === sizeType) return size;
        switch (type) {
          case "cross":
            return 5 * size * size / 9;

          case "diamond":
            return .5 * size * size / Math.sqrt(3);

          case "square":
            return size * size;

          case "star":
            var angle = 18 * RADIAN;
            return 1.25 * size * size * (Math.tan(angle) - Math.tan(2 * angle) * Math.pow(Math.tan(angle), 2));

          case "triangle":
            return Math.sqrt(3) * size * size / 4;

          case "wye":
            return (21 - 10 * Math.sqrt(3)) * size * size / 8;

          default:
            return Math.PI * size * size / 4;
        }
    }, Symbols = Object(__WEBPACK_IMPORTED_MODULE_4__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function Symbols() {
            return _classCallCheck(this, Symbols), _possibleConstructorReturn(this, (Symbols.__proto__ || Object.getPrototypeOf(Symbols)).apply(this, arguments));
        }
        return _inherits(Symbols, _Component), _createClass(Symbols, [ {
            key: "getPath",
            value: function() {
                var _props = this.props, size = _props.size, sizeType = _props.sizeType, type = _props.type, symbolFactory = getSymbolFactory(type);
                return Object(__WEBPACK_IMPORTED_MODULE_2_d3_shape__.t)().type(symbolFactory).size(calculateAreaSize(size, sizeType, type))();
            }
        }, {
            key: "render",
            value: function() {
                var _props2 = this.props, className = _props2.className, cx = _props2.cx, cy = _props2.cy, size = _props2.size;
                return cx === +cx && cy === +cy && size === +size ? __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("path", _extends({}, Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.k)(this.props), Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.e)(this.props), {
                    className: __WEBPACK_IMPORTED_MODULE_3_classnames___default()("recharts-symbols", className),
                    transform: "translate(" + cx + ", " + cy + ")",
                    d: this.getPath()
                })) : null;
            }
        } ]), Symbols;
    }(__WEBPACK_IMPORTED_MODULE_0_react__.Component), _class2.displayName = "Symbols", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.c, {
        className: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
        type: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "circle", "cross", "diamond", "square", "star", "triangle", "wye" ]),
        cx: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        cy: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        size: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        sizeType: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([ "area", "diameter" ])
    }), _class2.defaultProps = {
        type: "circle",
        size: 64,
        sizeType: "area"
    }, _class = _temp)) || _class;
    __webpack_exports__.a = Symbols;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_1__src_area__ = (__webpack_require__(632), __webpack_require__(273));
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return __WEBPACK_IMPORTED_MODULE_1__src_area__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_2__src_line__ = __webpack_require__(183);
    __webpack_require__.d(__webpack_exports__, "m", function() {
        return __WEBPACK_IMPORTED_MODULE_2__src_line__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_8__src_symbol__ = (__webpack_require__(634), __webpack_require__(637), 
    __webpack_require__(275), __webpack_require__(276), __webpack_require__(638), __webpack_require__(639));
    __webpack_require__.d(__webpack_exports__, "t", function() {
        return __WEBPACK_IMPORTED_MODULE_8__src_symbol__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_9__src_symbol_circle__ = __webpack_require__(278);
    __webpack_require__.d(__webpack_exports__, "u", function() {
        return __WEBPACK_IMPORTED_MODULE_9__src_symbol_circle__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_10__src_symbol_cross__ = __webpack_require__(279);
    __webpack_require__.d(__webpack_exports__, "v", function() {
        return __WEBPACK_IMPORTED_MODULE_10__src_symbol_cross__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_11__src_symbol_diamond__ = __webpack_require__(280);
    __webpack_require__.d(__webpack_exports__, "w", function() {
        return __WEBPACK_IMPORTED_MODULE_11__src_symbol_diamond__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_12__src_symbol_square__ = __webpack_require__(282);
    __webpack_require__.d(__webpack_exports__, "x", function() {
        return __WEBPACK_IMPORTED_MODULE_12__src_symbol_square__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_13__src_symbol_star__ = __webpack_require__(281);
    __webpack_require__.d(__webpack_exports__, "y", function() {
        return __WEBPACK_IMPORTED_MODULE_13__src_symbol_star__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_14__src_symbol_triangle__ = __webpack_require__(283);
    __webpack_require__.d(__webpack_exports__, "z", function() {
        return __WEBPACK_IMPORTED_MODULE_14__src_symbol_triangle__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_15__src_symbol_wye__ = __webpack_require__(284);
    __webpack_require__.d(__webpack_exports__, "A", function() {
        return __WEBPACK_IMPORTED_MODULE_15__src_symbol_wye__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_16__src_curve_basisClosed__ = __webpack_require__(640);
    __webpack_require__.d(__webpack_exports__, "c", function() {
        return __WEBPACK_IMPORTED_MODULE_16__src_curve_basisClosed__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_17__src_curve_basisOpen__ = __webpack_require__(641);
    __webpack_require__.d(__webpack_exports__, "d", function() {
        return __WEBPACK_IMPORTED_MODULE_17__src_curve_basisOpen__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_18__src_curve_basis__ = __webpack_require__(123);
    __webpack_require__.d(__webpack_exports__, "b", function() {
        return __WEBPACK_IMPORTED_MODULE_18__src_curve_basis__.b;
    });
    var __WEBPACK_IMPORTED_MODULE_26__src_curve_linearClosed__ = (__webpack_require__(642), 
    __webpack_require__(285), __webpack_require__(286), __webpack_require__(124), __webpack_require__(643), 
    __webpack_require__(644), __webpack_require__(185), __webpack_require__(645));
    __webpack_require__.d(__webpack_exports__, "f", function() {
        return __WEBPACK_IMPORTED_MODULE_26__src_curve_linearClosed__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_27__src_curve_linear__ = __webpack_require__(121);
    __webpack_require__.d(__webpack_exports__, "e", function() {
        return __WEBPACK_IMPORTED_MODULE_27__src_curve_linear__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_28__src_curve_monotone__ = __webpack_require__(646);
    __webpack_require__.d(__webpack_exports__, "g", function() {
        return __WEBPACK_IMPORTED_MODULE_28__src_curve_monotone__.a;
    }), __webpack_require__.d(__webpack_exports__, "h", function() {
        return __WEBPACK_IMPORTED_MODULE_28__src_curve_monotone__.b;
    });
    var __WEBPACK_IMPORTED_MODULE_29__src_curve_natural__ = __webpack_require__(647);
    __webpack_require__.d(__webpack_exports__, "i", function() {
        return __WEBPACK_IMPORTED_MODULE_29__src_curve_natural__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_30__src_curve_step__ = __webpack_require__(648);
    __webpack_require__.d(__webpack_exports__, "j", function() {
        return __WEBPACK_IMPORTED_MODULE_30__src_curve_step__.a;
    }), __webpack_require__.d(__webpack_exports__, "k", function() {
        return __WEBPACK_IMPORTED_MODULE_30__src_curve_step__.b;
    }), __webpack_require__.d(__webpack_exports__, "l", function() {
        return __WEBPACK_IMPORTED_MODULE_30__src_curve_step__.c;
    });
    var __WEBPACK_IMPORTED_MODULE_31__src_stack__ = __webpack_require__(649);
    __webpack_require__.d(__webpack_exports__, "n", function() {
        return __WEBPACK_IMPORTED_MODULE_31__src_stack__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_32__src_offset_expand__ = __webpack_require__(650);
    __webpack_require__.d(__webpack_exports__, "o", function() {
        return __WEBPACK_IMPORTED_MODULE_32__src_offset_expand__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_34__src_offset_none__ = (__webpack_require__(651), 
    __webpack_require__(86));
    __webpack_require__.d(__webpack_exports__, "p", function() {
        return __WEBPACK_IMPORTED_MODULE_34__src_offset_none__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_35__src_offset_silhouette__ = __webpack_require__(652);
    __webpack_require__.d(__webpack_exports__, "q", function() {
        return __WEBPACK_IMPORTED_MODULE_35__src_offset_silhouette__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_36__src_offset_wiggle__ = __webpack_require__(653);
    __webpack_require__.d(__webpack_exports__, "r", function() {
        return __WEBPACK_IMPORTED_MODULE_36__src_offset_wiggle__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_40__src_order_none__ = (__webpack_require__(186), 
    __webpack_require__(654), __webpack_require__(655), __webpack_require__(87));
    __webpack_require__.d(__webpack_exports__, "s", function() {
        return __WEBPACK_IMPORTED_MODULE_40__src_order_none__.a;
    });
    __webpack_require__(656);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0_d3_path__ = __webpack_require__(84), __WEBPACK_IMPORTED_MODULE_1__constant__ = __webpack_require__(58), __WEBPACK_IMPORTED_MODULE_2__curve_linear__ = __webpack_require__(121), __WEBPACK_IMPORTED_MODULE_3__point__ = __webpack_require__(184);
    __webpack_exports__.a = function() {
        function line(data) {
            var i, d, buffer, n = data.length, defined0 = !1;
            for (null == context && (output = curve(buffer = Object(__WEBPACK_IMPORTED_MODULE_0_d3_path__.a)())), 
            i = 0; i <= n; ++i) !(i < n && defined(d = data[i], i, data)) === defined0 && ((defined0 = !defined0) ? output.lineStart() : output.lineEnd()), 
            defined0 && output.point(+x(d, i, data), +y(d, i, data));
            if (buffer) return output = null, buffer + "" || null;
        }
        var x = __WEBPACK_IMPORTED_MODULE_3__point__.a, y = __WEBPACK_IMPORTED_MODULE_3__point__.b, defined = Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(!0), context = null, curve = __WEBPACK_IMPORTED_MODULE_2__curve_linear__.a, output = null;
        return line.x = function(_) {
            return arguments.length ? (x = "function" == typeof _ ? _ : Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(+_), 
            line) : x;
        }, line.y = function(_) {
            return arguments.length ? (y = "function" == typeof _ ? _ : Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(+_), 
            line) : y;
        }, line.defined = function(_) {
            return arguments.length ? (defined = "function" == typeof _ ? _ : Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(!!_), 
            line) : defined;
        }, line.curve = function(_) {
            return arguments.length ? (curve = _, null != context && (output = curve(context)), 
            line) : curve;
        }, line.context = function(_) {
            return arguments.length ? (null == _ ? context = output = null : output = curve(context = _), 
            line) : context;
        }, line;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function x(p) {
        return p[0];
    }
    function y(p) {
        return p[1];
    }
    __webpack_exports__.a = x, __webpack_exports__.b = y;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function point(that, x, y) {
        var x1 = that._x1, y1 = that._y1, x2 = that._x2, y2 = that._y2;
        if (that._l01_a > __WEBPACK_IMPORTED_MODULE_0__math__.f) {
            var a = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a, n = 3 * that._l01_a * (that._l01_a + that._l12_a);
            x1 = (x1 * a - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n, y1 = (y1 * a - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;
        }
        if (that._l23_a > __WEBPACK_IMPORTED_MODULE_0__math__.f) {
            var b = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a, m = 3 * that._l23_a * (that._l23_a + that._l12_a);
            x2 = (x2 * b + that._x1 * that._l23_2a - x * that._l12_2a) / m, y2 = (y2 * b + that._y1 * that._l23_2a - y * that._l12_2a) / m;
        }
        that._context.bezierCurveTo(x1, y1, x2, y2, that._x2, that._y2);
    }
    function CatmullRom(context, alpha) {
        this._context = context, this._alpha = alpha;
    }
    __webpack_exports__.a = point;
    var __WEBPACK_IMPORTED_MODULE_0__math__ = __webpack_require__(85), __WEBPACK_IMPORTED_MODULE_1__cardinal__ = __webpack_require__(124);
    CatmullRom.prototype = {
        areaStart: function() {
            this._line = 0;
        },
        areaEnd: function() {
            this._line = NaN;
        },
        lineStart: function() {
            this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN, this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
        },
        lineEnd: function() {
            switch (this._point) {
              case 2:
                this._context.lineTo(this._x2, this._y2);
                break;

              case 3:
                this.point(this._x2, this._y2);
            }
            (this._line || 0 !== this._line && 1 === this._point) && this._context.closePath(), 
            this._line = 1 - this._line;
        },
        point: function(x, y) {
            if (x = +x, y = +y, this._point) {
                var x23 = this._x2 - x, y23 = this._y2 - y;
                this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
            }
            switch (this._point) {
              case 0:
                this._point = 1, this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y);
                break;

              case 1:
                this._point = 2;
                break;

              case 2:
                this._point = 3;

              default:
                point(this, x, y);
            }
            this._l01_a = this._l12_a, this._l12_a = this._l23_a, this._l01_2a = this._l12_2a, 
            this._l12_2a = this._l23_2a, this._x0 = this._x1, this._x1 = this._x2, this._x2 = x, 
            this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;
        }
    };
    !function custom(alpha) {
        function catmullRom(context) {
            return alpha ? new CatmullRom(context, alpha) : new __WEBPACK_IMPORTED_MODULE_1__cardinal__.a(context, 0);
        }
        return catmullRom.alpha = function(alpha) {
            return custom(+alpha);
        }, catmullRom;
    }(.5);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function sum(series) {
        for (var v, s = 0, i = -1, n = series.length; ++i < n; ) (v = +series[i][1]) && (s += v);
        return s;
    }
    __webpack_exports__.b = sum;
    var __WEBPACK_IMPORTED_MODULE_0__none__ = __webpack_require__(87);
    __webpack_exports__.a = function(series) {
        var sums = series.map(sum);
        return Object(__WEBPACK_IMPORTED_MODULE_0__none__.a)(series).sort(function(a, b) {
            return sums[a] - sums[b];
        });
    };
}, function(module, exports, __webpack_require__) {
    function baseIsEqual(value, other, bitmask, customizer, stack) {
        return value === other || (null == value || null == other || !isObjectLike(value) && !isObjectLike(other) ? value !== value && other !== other : baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack));
    }
    var baseIsEqualDeep = __webpack_require__(657), isObjectLike = __webpack_require__(43);
    module.exports = baseIsEqual;
}, function(module, exports, __webpack_require__) {
    var getNative = __webpack_require__(59), root = __webpack_require__(36), Map = getNative(root, "Map");
    module.exports = Map;
}, function(module, exports) {
    function isObject(value) {
        var type = typeof value;
        return null != value && ("object" == type || "function" == type);
    }
    module.exports = isObject;
}, function(module, exports, __webpack_require__) {
    function MapCache(entries) {
        var index = -1, length = null == entries ? 0 : entries.length;
        for (this.clear(); ++index < length; ) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
        }
    }
    var mapCacheClear = __webpack_require__(674), mapCacheDelete = __webpack_require__(681), mapCacheGet = __webpack_require__(683), mapCacheHas = __webpack_require__(684), mapCacheSet = __webpack_require__(685);
    MapCache.prototype.clear = mapCacheClear, MapCache.prototype.delete = mapCacheDelete, 
    MapCache.prototype.get = mapCacheGet, MapCache.prototype.has = mapCacheHas, MapCache.prototype.set = mapCacheSet, 
    module.exports = MapCache;
}, function(module, exports, __webpack_require__) {
    function keys(object) {
        return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
    }
    var arrayLikeKeys = __webpack_require__(699), baseKeys = __webpack_require__(705), isArrayLike = __webpack_require__(193);
    module.exports = keys;
}, function(module, exports) {
    function isLength(value) {
        return "number" == typeof value && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }
    var MAX_SAFE_INTEGER = 9007199254740991;
    module.exports = isLength;
}, function(module, exports, __webpack_require__) {
    function isArrayLike(value) {
        return null != value && isLength(value.length) && !isFunction(value);
    }
    var isFunction = __webpack_require__(291), isLength = __webpack_require__(192);
    module.exports = isArrayLike;
}, function(module, exports) {
    function arrayMap(array, iteratee) {
        for (var index = -1, length = null == array ? 0 : array.length, result = Array(length); ++index < length; ) result[index] = iteratee(array[index], index, array);
        return result;
    }
    module.exports = arrayMap;
}, function(module, exports) {
    function identity(value) {
        return value;
    }
    module.exports = identity;
}, function(module, exports, __webpack_require__) {
    function isKey(value, object) {
        if (isArray(value)) return !1;
        var type = typeof value;
        return !("number" != type && "symbol" != type && "boolean" != type && null != value && !isSymbol(value)) || (reIsPlainProp.test(value) || !reIsDeepProp.test(value) || null != object && value in Object(object));
    }
    var isArray = __webpack_require__(34), isSymbol = __webpack_require__(197), reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/;
    module.exports = isKey;
}, function(module, exports, __webpack_require__) {
    function isSymbol(value) {
        return "symbol" == typeof value || isObjectLike(value) && baseGetTag(value) == symbolTag;
    }
    var baseGetTag = __webpack_require__(60), isObjectLike = __webpack_require__(43), symbolTag = "[object Symbol]";
    module.exports = isSymbol;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    function autoCompleteStyle(name, value) {
        return STYLE_LIST.indexOf(name) >= 0 && value === +value ? value + "px" : value;
    }
    function camelToMiddleLine(text) {
        return text.split("").reduce(function(result, entry) {
            return entry === entry.toUpperCase() ? [].concat(_toConsumableArray(result), [ "-", entry.toLowerCase() ]) : [].concat(_toConsumableArray(result), [ entry ]);
        }, []).join("");
    }
    __webpack_require__.d(__webpack_exports__, "c", function() {
        return getStringSize;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return getOffset;
    }), __webpack_require__.d(__webpack_exports__, "a", function() {
        return calculateChartCoordinate;
    });
    var __WEBPACK_IMPORTED_MODULE_0__ReactUtils__ = __webpack_require__(4), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, stringCache = {
        widthCache: {},
        cacheCount: 0
    }, SPAN_STYLE = {
        position: "absolute",
        top: "-20000px",
        left: 0,
        padding: 0,
        margin: 0,
        border: "none",
        whiteSpace: "pre"
    }, STYLE_LIST = [ "minWidth", "maxWidth", "width", "minHeight", "maxHeight", "height", "top", "left", "fontSize", "lineHeight", "padding", "margin", "paddingLeft", "paddingRight", "paddingTop", "paddingBottom", "marginLeft", "marginRight", "marginTop", "marginBottom" ], getStyleString = function(style) {
        return Object.keys(style).reduce(function(result, s) {
            return "" + result + camelToMiddleLine(s) + ":" + autoCompleteStyle(s, style[s]) + ";";
        }, "");
    }, getStringSize = function(text) {
        var style = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
        if (void 0 === text || null === text || Object(__WEBPACK_IMPORTED_MODULE_0__ReactUtils__.n)()) return {
            width: 0,
            height: 0
        };
        var str = "" + text, styleString = getStyleString(style), cacheKey = str + "-" + styleString;
        if (stringCache.widthCache[cacheKey]) return stringCache.widthCache[cacheKey];
        try {
            var measurementSpan = document.getElementById("recharts_measurement_span");
            measurementSpan || (measurementSpan = document.createElement("span"), measurementSpan.setAttribute("id", "recharts_measurement_span"), 
            document.body.appendChild(measurementSpan));
            var measurementSpanStyle = _extends({}, SPAN_STYLE, style);
            Object.keys(measurementSpanStyle).map(function(styleKey) {
                return measurementSpan.style[styleKey] = measurementSpanStyle[styleKey], styleKey;
            }), measurementSpan.textContent = str;
            var rect = measurementSpan.getBoundingClientRect(), result = {
                width: rect.width,
                height: rect.height
            };
            return stringCache.widthCache[cacheKey] = result, ++stringCache.cacheCount > 2e3 && (stringCache.cacheCount = 0, 
            stringCache.widthCache = {}), result;
        } catch (e) {
            return {
                width: 0,
                height: 0
            };
        }
    }, getOffset = function(el) {
        var html = el.ownerDocument.documentElement, box = {
            top: 0,
            left: 0
        };
        return void 0 !== el.getBoundingClientRect && (box = el.getBoundingClientRect()), 
        {
            top: box.top + window.pageYOffset - html.clientTop,
            left: box.left + window.pageXOffset - html.clientLeft
        };
    }, calculateChartCoordinate = function(event, offset) {
        return {
            chartX: Math.round(event.pageX - offset.left),
            chartY: Math.round(event.pageY - offset.top)
        };
    };
}, function(module, exports, __webpack_require__) {
    function baseIsEqual(value, other, bitmask, customizer, stack) {
        return value === other || (null == value || null == other || !isObjectLike(value) && !isObjectLike(other) ? value !== value && other !== other : baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack));
    }
    var baseIsEqualDeep = __webpack_require__(778), isObjectLike = __webpack_require__(42);
    module.exports = baseIsEqual;
}, function(module, exports, __webpack_require__) {
    function keys(object) {
        return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
    }
    var arrayLikeKeys = __webpack_require__(799), baseKeys = __webpack_require__(805), isArrayLike = __webpack_require__(134);
    module.exports = keys;
}, function(module, exports, __webpack_require__) {
    var baseIsArguments = __webpack_require__(801), isObjectLike = __webpack_require__(42), objectProto = Object.prototype, hasOwnProperty = objectProto.hasOwnProperty, propertyIsEnumerable = objectProto.propertyIsEnumerable, isArguments = baseIsArguments(function() {
        return arguments;
    }()) ? baseIsArguments : function(value) {
        return isObjectLike(value) && hasOwnProperty.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
    };
    module.exports = isArguments;
}, function(module, exports) {
    function isIndex(value, length) {
        var type = typeof value;
        return !!(length = null == length ? MAX_SAFE_INTEGER : length) && ("number" == type || "symbol" != type && reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
    }
    var MAX_SAFE_INTEGER = 9007199254740991, reIsUint = /^(?:0|[1-9]\d*)$/;
    module.exports = isIndex;
}, function(module, exports) {
    function isLength(value) {
        return "number" == typeof value && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }
    var MAX_SAFE_INTEGER = 9007199254740991;
    module.exports = isLength;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__number__ = __webpack_require__(90);
    __webpack_exports__.a = function(values, p, valueof) {
        if (null == valueof && (valueof = __WEBPACK_IMPORTED_MODULE_0__number__.a), n = values.length) {
            if ((p = +p) <= 0 || n < 2) return +valueof(values[0], 0, values);
            if (p >= 1) return +valueof(values[n - 1], n - 1, values);
            var n, i = (n - 1) * p, i0 = Math.floor(i), value0 = +valueof(values[i0], i0, values);
            return value0 + (+valueof(values[i0 + 1], i0 + 1, values) - value0) * (i - i0);
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function Map() {}
    function map(object, f) {
        var map = new Map();
        if (object instanceof Map) object.each(function(value, key) {
            map.set(key, value);
        }); else if (Array.isArray(object)) {
            var o, i = -1, n = object.length;
            if (null == f) for (;++i < n; ) map.set(i, object[i]); else for (;++i < n; ) map.set(f(o = object[i], i, object), o);
        } else if (object) for (var key in object) map.set(key, object[key]);
        return map;
    }
    __webpack_require__.d(__webpack_exports__, "b", function() {
        return prefix;
    });
    var prefix = "$";
    Map.prototype = map.prototype = {
        constructor: Map,
        has: function(key) {
            return prefix + key in this;
        },
        get: function(key) {
            return this[prefix + key];
        },
        set: function(key, value) {
            return this[prefix + key] = value, this;
        },
        remove: function(key) {
            var property = prefix + key;
            return property in this && delete this[property];
        },
        clear: function() {
            for (var property in this) property[0] === prefix && delete this[property];
        },
        keys: function() {
            var keys = [];
            for (var property in this) property[0] === prefix && keys.push(property.slice(1));
            return keys;
        },
        values: function() {
            var values = [];
            for (var property in this) property[0] === prefix && values.push(this[property]);
            return values;
        },
        entries: function() {
            var entries = [];
            for (var property in this) property[0] === prefix && entries.push({
                key: property.slice(1),
                value: this[property]
            });
            return entries;
        },
        size: function() {
            var size = 0;
            for (var property in this) property[0] === prefix && ++size;
            return size;
        },
        empty: function() {
            for (var property in this) if (property[0] === prefix) return !1;
            return !0;
        },
        each: function(f) {
            for (var property in this) property[0] === prefix && f(this[property], property.slice(1), this);
        }
    }, __webpack_exports__.a = map;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0_d3_color__ = __webpack_require__(46), __WEBPACK_IMPORTED_MODULE_1__rgb__ = __webpack_require__(346), __WEBPACK_IMPORTED_MODULE_2__array__ = __webpack_require__(349), __WEBPACK_IMPORTED_MODULE_3__date__ = __webpack_require__(350), __WEBPACK_IMPORTED_MODULE_4__number__ = __webpack_require__(136), __WEBPACK_IMPORTED_MODULE_5__object__ = __webpack_require__(351), __WEBPACK_IMPORTED_MODULE_6__string__ = __webpack_require__(352), __WEBPACK_IMPORTED_MODULE_7__constant__ = __webpack_require__(348);
    __webpack_exports__.a = function(a, b) {
        var c, t = typeof b;
        return null == b || "boolean" === t ? Object(__WEBPACK_IMPORTED_MODULE_7__constant__.a)(b) : ("number" === t ? __WEBPACK_IMPORTED_MODULE_4__number__.a : "string" === t ? (c = Object(__WEBPACK_IMPORTED_MODULE_0_d3_color__.a)(b)) ? (b = c, 
        __WEBPACK_IMPORTED_MODULE_1__rgb__.a) : __WEBPACK_IMPORTED_MODULE_6__string__.a : b instanceof __WEBPACK_IMPORTED_MODULE_0_d3_color__.a ? __WEBPACK_IMPORTED_MODULE_1__rgb__.a : b instanceof Date ? __WEBPACK_IMPORTED_MODULE_3__date__.a : Array.isArray(b) ? __WEBPACK_IMPORTED_MODULE_2__array__.a : "function" != typeof b.valueOf && "function" != typeof b.toString || isNaN(b) ? __WEBPACK_IMPORTED_MODULE_5__object__.a : __WEBPACK_IMPORTED_MODULE_4__number__.a)(a, b);
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function Color() {}
    function color(format) {
        var m;
        return format = (format + "").trim().toLowerCase(), (m = reHex3.exec(format)) ? (m = parseInt(m[1], 16), 
        new Rgb(m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | 240 & m, (15 & m) << 4 | 15 & m, 1)) : (m = reHex6.exec(format)) ? rgbn(parseInt(m[1], 16)) : (m = reRgbInteger.exec(format)) ? new Rgb(m[1], m[2], m[3], 1) : (m = reRgbPercent.exec(format)) ? new Rgb(255 * m[1] / 100, 255 * m[2] / 100, 255 * m[3] / 100, 1) : (m = reRgbaInteger.exec(format)) ? rgba(m[1], m[2], m[3], m[4]) : (m = reRgbaPercent.exec(format)) ? rgba(255 * m[1] / 100, 255 * m[2] / 100, 255 * m[3] / 100, m[4]) : (m = reHslPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, 1) : (m = reHslaPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, m[4]) : named.hasOwnProperty(format) ? rgbn(named[format]) : "transparent" === format ? new Rgb(NaN, NaN, NaN, 0) : null;
    }
    function rgbn(n) {
        return new Rgb(n >> 16 & 255, n >> 8 & 255, 255 & n, 1);
    }
    function rgba(r, g, b, a) {
        return a <= 0 && (r = g = b = NaN), new Rgb(r, g, b, a);
    }
    function rgbConvert(o) {
        return o instanceof Color || (o = color(o)), o ? (o = o.rgb(), new Rgb(o.r, o.g, o.b, o.opacity)) : new Rgb();
    }
    function rgb(r, g, b, opacity) {
        return 1 === arguments.length ? rgbConvert(r) : new Rgb(r, g, b, null == opacity ? 1 : opacity);
    }
    function Rgb(r, g, b, opacity) {
        this.r = +r, this.g = +g, this.b = +b, this.opacity = +opacity;
    }
    function hsla(h, s, l, a) {
        return a <= 0 ? h = s = l = NaN : l <= 0 || l >= 1 ? h = s = NaN : s <= 0 && (h = NaN), 
        new Hsl(h, s, l, a);
    }
    function hslConvert(o) {
        if (o instanceof Hsl) return new Hsl(o.h, o.s, o.l, o.opacity);
        if (o instanceof Color || (o = color(o)), !o) return new Hsl();
        if (o instanceof Hsl) return o;
        o = o.rgb();
        var r = o.r / 255, g = o.g / 255, b = o.b / 255, min = Math.min(r, g, b), max = Math.max(r, g, b), h = NaN, s = max - min, l = (max + min) / 2;
        return s ? (h = r === max ? (g - b) / s + 6 * (g < b) : g === max ? (b - r) / s + 2 : (r - g) / s + 4, 
        s /= l < .5 ? max + min : 2 - max - min, h *= 60) : s = l > 0 && l < 1 ? 0 : h, 
        new Hsl(h, s, l, o.opacity);
    }
    function hsl(h, s, l, opacity) {
        return 1 === arguments.length ? hslConvert(h) : new Hsl(h, s, l, null == opacity ? 1 : opacity);
    }
    function Hsl(h, s, l, opacity) {
        this.h = +h, this.s = +s, this.l = +l, this.opacity = +opacity;
    }
    function hsl2rgb(h, m1, m2) {
        return 255 * (h < 60 ? m1 + (m2 - m1) * h / 60 : h < 180 ? m2 : h < 240 ? m1 + (m2 - m1) * (240 - h) / 60 : m1);
    }
    __webpack_exports__.a = Color, __webpack_require__.d(__webpack_exports__, "d", function() {
        return darker;
    }), __webpack_require__.d(__webpack_exports__, "c", function() {
        return brighter;
    }), __webpack_exports__.e = color, __webpack_exports__.h = rgbConvert, __webpack_exports__.g = rgb, 
    __webpack_exports__.b = Rgb, __webpack_exports__.f = hsl;
    var __WEBPACK_IMPORTED_MODULE_0__define__ = __webpack_require__(208), darker = .7, brighter = 1 / darker, reI = "\\s*([+-]?\\d+)\\s*", reN = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*", reP = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*", reHex3 = /^#([0-9a-f]{3})$/, reHex6 = /^#([0-9a-f]{6})$/, reRgbInteger = new RegExp("^rgb\\(" + [ reI, reI, reI ] + "\\)$"), reRgbPercent = new RegExp("^rgb\\(" + [ reP, reP, reP ] + "\\)$"), reRgbaInteger = new RegExp("^rgba\\(" + [ reI, reI, reI, reN ] + "\\)$"), reRgbaPercent = new RegExp("^rgba\\(" + [ reP, reP, reP, reN ] + "\\)$"), reHslPercent = new RegExp("^hsl\\(" + [ reN, reP, reP ] + "\\)$"), reHslaPercent = new RegExp("^hsla\\(" + [ reN, reP, reP, reN ] + "\\)$"), named = {
        aliceblue: 15792383,
        antiquewhite: 16444375,
        aqua: 65535,
        aquamarine: 8388564,
        azure: 15794175,
        beige: 16119260,
        bisque: 16770244,
        black: 0,
        blanchedalmond: 16772045,
        blue: 255,
        blueviolet: 9055202,
        brown: 10824234,
        burlywood: 14596231,
        cadetblue: 6266528,
        chartreuse: 8388352,
        chocolate: 13789470,
        coral: 16744272,
        cornflowerblue: 6591981,
        cornsilk: 16775388,
        crimson: 14423100,
        cyan: 65535,
        darkblue: 139,
        darkcyan: 35723,
        darkgoldenrod: 12092939,
        darkgray: 11119017,
        darkgreen: 25600,
        darkgrey: 11119017,
        darkkhaki: 12433259,
        darkmagenta: 9109643,
        darkolivegreen: 5597999,
        darkorange: 16747520,
        darkorchid: 10040012,
        darkred: 9109504,
        darksalmon: 15308410,
        darkseagreen: 9419919,
        darkslateblue: 4734347,
        darkslategray: 3100495,
        darkslategrey: 3100495,
        darkturquoise: 52945,
        darkviolet: 9699539,
        deeppink: 16716947,
        deepskyblue: 49151,
        dimgray: 6908265,
        dimgrey: 6908265,
        dodgerblue: 2003199,
        firebrick: 11674146,
        floralwhite: 16775920,
        forestgreen: 2263842,
        fuchsia: 16711935,
        gainsboro: 14474460,
        ghostwhite: 16316671,
        gold: 16766720,
        goldenrod: 14329120,
        gray: 8421504,
        green: 32768,
        greenyellow: 11403055,
        grey: 8421504,
        honeydew: 15794160,
        hotpink: 16738740,
        indianred: 13458524,
        indigo: 4915330,
        ivory: 16777200,
        khaki: 15787660,
        lavender: 15132410,
        lavenderblush: 16773365,
        lawngreen: 8190976,
        lemonchiffon: 16775885,
        lightblue: 11393254,
        lightcoral: 15761536,
        lightcyan: 14745599,
        lightgoldenrodyellow: 16448210,
        lightgray: 13882323,
        lightgreen: 9498256,
        lightgrey: 13882323,
        lightpink: 16758465,
        lightsalmon: 16752762,
        lightseagreen: 2142890,
        lightskyblue: 8900346,
        lightslategray: 7833753,
        lightslategrey: 7833753,
        lightsteelblue: 11584734,
        lightyellow: 16777184,
        lime: 65280,
        limegreen: 3329330,
        linen: 16445670,
        magenta: 16711935,
        maroon: 8388608,
        mediumaquamarine: 6737322,
        mediumblue: 205,
        mediumorchid: 12211667,
        mediumpurple: 9662683,
        mediumseagreen: 3978097,
        mediumslateblue: 8087790,
        mediumspringgreen: 64154,
        mediumturquoise: 4772300,
        mediumvioletred: 13047173,
        midnightblue: 1644912,
        mintcream: 16121850,
        mistyrose: 16770273,
        moccasin: 16770229,
        navajowhite: 16768685,
        navy: 128,
        oldlace: 16643558,
        olive: 8421376,
        olivedrab: 7048739,
        orange: 16753920,
        orangered: 16729344,
        orchid: 14315734,
        palegoldenrod: 15657130,
        palegreen: 10025880,
        paleturquoise: 11529966,
        palevioletred: 14381203,
        papayawhip: 16773077,
        peachpuff: 16767673,
        peru: 13468991,
        pink: 16761035,
        plum: 14524637,
        powderblue: 11591910,
        purple: 8388736,
        rebeccapurple: 6697881,
        red: 16711680,
        rosybrown: 12357519,
        royalblue: 4286945,
        saddlebrown: 9127187,
        salmon: 16416882,
        sandybrown: 16032864,
        seagreen: 3050327,
        seashell: 16774638,
        sienna: 10506797,
        silver: 12632256,
        skyblue: 8900331,
        slateblue: 6970061,
        slategray: 7372944,
        slategrey: 7372944,
        snow: 16775930,
        springgreen: 65407,
        steelblue: 4620980,
        tan: 13808780,
        teal: 32896,
        thistle: 14204888,
        tomato: 16737095,
        turquoise: 4251856,
        violet: 15631086,
        wheat: 16113331,
        white: 16777215,
        whitesmoke: 16119285,
        yellow: 16776960,
        yellowgreen: 10145074
    };
    Object(__WEBPACK_IMPORTED_MODULE_0__define__.a)(Color, color, {
        displayable: function() {
            return this.rgb().displayable();
        },
        toString: function() {
            return this.rgb() + "";
        }
    }), Object(__WEBPACK_IMPORTED_MODULE_0__define__.a)(Rgb, rgb, Object(__WEBPACK_IMPORTED_MODULE_0__define__.b)(Color, {
        brighter: function(k) {
            return k = null == k ? brighter : Math.pow(brighter, k), new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
        },
        darker: function(k) {
            return k = null == k ? darker : Math.pow(darker, k), new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
        },
        rgb: function() {
            return this;
        },
        displayable: function() {
            return 0 <= this.r && this.r <= 255 && 0 <= this.g && this.g <= 255 && 0 <= this.b && this.b <= 255 && 0 <= this.opacity && this.opacity <= 1;
        },
        toString: function() {
            var a = this.opacity;
            return a = isNaN(a) ? 1 : Math.max(0, Math.min(1, a)), (1 === a ? "rgb(" : "rgba(") + Math.max(0, Math.min(255, Math.round(this.r) || 0)) + ", " + Math.max(0, Math.min(255, Math.round(this.g) || 0)) + ", " + Math.max(0, Math.min(255, Math.round(this.b) || 0)) + (1 === a ? ")" : ", " + a + ")");
        }
    })), Object(__WEBPACK_IMPORTED_MODULE_0__define__.a)(Hsl, hsl, Object(__WEBPACK_IMPORTED_MODULE_0__define__.b)(Color, {
        brighter: function(k) {
            return k = null == k ? brighter : Math.pow(brighter, k), new Hsl(this.h, this.s, this.l * k, this.opacity);
        },
        darker: function(k) {
            return k = null == k ? darker : Math.pow(darker, k), new Hsl(this.h, this.s, this.l * k, this.opacity);
        },
        rgb: function() {
            var h = this.h % 360 + 360 * (this.h < 0), s = isNaN(h) || isNaN(this.s) ? 0 : this.s, l = this.l, m2 = l + (l < .5 ? l : 1 - l) * s, m1 = 2 * l - m2;
            return new Rgb(hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2), hsl2rgb(h, m1, m2), hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2), this.opacity);
        },
        displayable: function() {
            return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && 0 <= this.l && this.l <= 1 && 0 <= this.opacity && this.opacity <= 1;
        }
    }));
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function extend(parent, definition) {
        var prototype = Object.create(parent.prototype);
        for (var key in definition) prototype[key] = definition[key];
        return prototype;
    }
    __webpack_exports__.b = extend, __webpack_exports__.a = function(constructor, factory, prototype) {
        constructor.prototype = factory.prototype = prototype, prototype.constructor = constructor;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function basis(t1, v0, v1, v2, v3) {
        var t2 = t1 * t1, t3 = t2 * t1;
        return ((1 - 3 * t1 + 3 * t2 - t3) * v0 + (4 - 6 * t2 + 3 * t3) * v1 + (1 + 3 * t1 + 3 * t2 - 3 * t3) * v2 + t3 * v3) / 6;
    }
    __webpack_exports__.a = basis, __webpack_exports__.b = function(values) {
        var n = values.length - 1;
        return function(t) {
            var i = t <= 0 ? t = 0 : t >= 1 ? (t = 1, n - 1) : Math.floor(t * n), v1 = values[i], v2 = values[i + 1], v0 = i > 0 ? values[i - 1] : 2 * v1 - v2, v3 = i < n - 1 ? values[i + 2] : 2 * v2 - v1;
            return basis((t - i / n) * n, v0, v1, v2, v3);
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(x) {
        return function() {
            return x;
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(x, p) {
        if ((i = (x = p ? x.toExponential(p - 1) : x.toExponential()).indexOf("e")) < 0) return null;
        var i, coefficient = x.slice(0, i);
        return [ coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient, +x.slice(i + 1) ];
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_1__src_millisecond__ = (__webpack_require__(18), __webpack_require__(898));
    __webpack_require__.d(__webpack_exports__, "c", function() {
        return __WEBPACK_IMPORTED_MODULE_1__src_millisecond__.a;
    }), __webpack_require__.d(__webpack_exports__, "n", function() {
        return __WEBPACK_IMPORTED_MODULE_1__src_millisecond__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_2__src_second__ = __webpack_require__(899);
    __webpack_require__.d(__webpack_exports__, "g", function() {
        return __WEBPACK_IMPORTED_MODULE_2__src_second__.a;
    }), __webpack_require__.d(__webpack_exports__, "r", function() {
        return __WEBPACK_IMPORTED_MODULE_2__src_second__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_3__src_minute__ = __webpack_require__(900);
    __webpack_require__.d(__webpack_exports__, "d", function() {
        return __WEBPACK_IMPORTED_MODULE_3__src_minute__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_4__src_hour__ = __webpack_require__(901);
    __webpack_require__.d(__webpack_exports__, "b", function() {
        return __WEBPACK_IMPORTED_MODULE_4__src_hour__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_5__src_day__ = __webpack_require__(902);
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return __WEBPACK_IMPORTED_MODULE_5__src_day__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_6__src_week__ = __webpack_require__(903);
    __webpack_require__.d(__webpack_exports__, "j", function() {
        return __WEBPACK_IMPORTED_MODULE_6__src_week__.b;
    }), __webpack_require__.d(__webpack_exports__, "h", function() {
        return __WEBPACK_IMPORTED_MODULE_6__src_week__.b;
    }), __webpack_require__.d(__webpack_exports__, "e", function() {
        return __WEBPACK_IMPORTED_MODULE_6__src_week__.a;
    }), __webpack_require__.d(__webpack_exports__, "i", function() {
        return __WEBPACK_IMPORTED_MODULE_6__src_week__.c;
    });
    var __WEBPACK_IMPORTED_MODULE_7__src_month__ = __webpack_require__(904);
    __webpack_require__.d(__webpack_exports__, "f", function() {
        return __WEBPACK_IMPORTED_MODULE_7__src_month__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_8__src_year__ = __webpack_require__(905);
    __webpack_require__.d(__webpack_exports__, "k", function() {
        return __WEBPACK_IMPORTED_MODULE_8__src_year__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_9__src_utcMinute__ = __webpack_require__(906);
    __webpack_require__.d(__webpack_exports__, "o", function() {
        return __WEBPACK_IMPORTED_MODULE_9__src_utcMinute__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_10__src_utcHour__ = __webpack_require__(907);
    __webpack_require__.d(__webpack_exports__, "m", function() {
        return __WEBPACK_IMPORTED_MODULE_10__src_utcHour__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_11__src_utcDay__ = __webpack_require__(908);
    __webpack_require__.d(__webpack_exports__, "l", function() {
        return __WEBPACK_IMPORTED_MODULE_11__src_utcDay__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_12__src_utcWeek__ = __webpack_require__(909);
    __webpack_require__.d(__webpack_exports__, "u", function() {
        return __WEBPACK_IMPORTED_MODULE_12__src_utcWeek__.b;
    }), __webpack_require__.d(__webpack_exports__, "s", function() {
        return __WEBPACK_IMPORTED_MODULE_12__src_utcWeek__.b;
    }), __webpack_require__.d(__webpack_exports__, "p", function() {
        return __WEBPACK_IMPORTED_MODULE_12__src_utcWeek__.a;
    }), __webpack_require__.d(__webpack_exports__, "t", function() {
        return __WEBPACK_IMPORTED_MODULE_12__src_utcWeek__.c;
    });
    var __WEBPACK_IMPORTED_MODULE_13__src_utcMonth__ = __webpack_require__(910);
    __webpack_require__.d(__webpack_exports__, "q", function() {
        return __WEBPACK_IMPORTED_MODULE_13__src_utcMonth__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_14__src_utcYear__ = __webpack_require__(911);
    __webpack_require__.d(__webpack_exports__, "v", function() {
        return __WEBPACK_IMPORTED_MODULE_14__src_utcYear__.a;
    });
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return timeFormat;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return utcFormat;
    }), __webpack_require__.d(__webpack_exports__, "c", function() {
        return utcParse;
    });
    var locale, timeFormat, timeParse, utcFormat, utcParse, __WEBPACK_IMPORTED_MODULE_0__locale__ = __webpack_require__(362);
    !function(definition) {
        locale = Object(__WEBPACK_IMPORTED_MODULE_0__locale__.a)(definition), timeFormat = locale.format, 
        timeParse = locale.parse, utcFormat = locale.utcFormat, utcParse = locale.utcParse;
    }({
        dateTime: "%x, %X",
        date: "%-m/%-d/%Y",
        time: "%-I:%M:%S %p",
        periods: [ "AM", "PM" ],
        days: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
        shortDays: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
        months: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ],
        shortMonths: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ]
    });
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_2_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_classnames__), __WEBPACK_IMPORTED_MODULE_3__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__ = __webpack_require__(4), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), getPolygonPoints = function(points) {
        return points.reduce(function(result, entry) {
            return entry.x === +entry.x && entry.y === +entry.y && result.push([ entry.x, entry.y ]), 
            result;
        }, []).join(" ");
    }, Polygon = Object(__WEBPACK_IMPORTED_MODULE_3__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function Polygon() {
            return _classCallCheck(this, Polygon), _possibleConstructorReturn(this, (Polygon.__proto__ || Object.getPrototypeOf(Polygon)).apply(this, arguments));
        }
        return _inherits(Polygon, _Component), _createClass(Polygon, [ {
            key: "render",
            value: function() {
                var _props = this.props, points = _props.points, className = _props.className;
                if (!points || !points.length) return null;
                var layerClass = __WEBPACK_IMPORTED_MODULE_2_classnames___default()("recharts-polygon", className);
                return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("polygon", _extends({}, Object(__WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__.k)(this.props), Object(__WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__.e)(this.props), {
                    className: layerClass,
                    points: getPolygonPoints(points)
                }));
            }
        } ]), Polygon;
    }(__WEBPACK_IMPORTED_MODULE_0_react__.Component), _class2.displayName = "Polygon", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_4__util_ReactUtils__.c, {
        className: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
        points: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number
        }))
    }), _class = _temp)) || _class;
    __webpack_exports__.a = Polygon;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp2, __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__ = __webpack_require__(45), __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_2_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_3_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_3_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_react__), __WEBPACK_IMPORTED_MODULE_4_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_4_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_prop_types__), __WEBPACK_IMPORTED_MODULE_5_react_smooth__ = __webpack_require__(33), __WEBPACK_IMPORTED_MODULE_5_react_smooth___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_react_smooth__), __WEBPACK_IMPORTED_MODULE_6_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_6_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_classnames__), __WEBPACK_IMPORTED_MODULE_7__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_8__shape_Curve__ = __webpack_require__(71), __WEBPACK_IMPORTED_MODULE_9__shape_Dot__ = __webpack_require__(63), __WEBPACK_IMPORTED_MODULE_10__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_11__component_LabelList__ = __webpack_require__(47), __WEBPACK_IMPORTED_MODULE_12__ErrorBar__ = __webpack_require__(95), __WEBPACK_IMPORTED_MODULE_13__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_15__util_ChartUtils__ = __webpack_require__(16), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), Line = Object(__WEBPACK_IMPORTED_MODULE_7__util_PureRender__.a)((_temp2 = _class2 = function(_Component) {
        function Line() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, Line);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = Line.__proto__ || Object.getPrototypeOf(Line)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                isAnimationFinished: !0,
                totalLength: 0
            }, _this.id = Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.k)("recharts-line-"), 
            _this.cachePrevData = function(points) {
                _this.setState({
                    prevPoints: points
                });
            }, _this.pathRef = function(node) {
                _this.mainCurve = node;
            }, _this.handleAnimationEnd = function() {
                _this.setState({
                    isAnimationFinished: !0
                }), _this.props.onAnimationEnd();
            }, _this.handleAnimationStart = function() {
                _this.setState({
                    isAnimationFinished: !1
                }), _this.props.onAnimationStart();
            }, _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(Line, _Component), _createClass(Line, [ {
            key: "componentDidMount",
            value: function() {
                if (this.props.isAnimationActive) {
                    var totalLength = this.getTotalLength();
                    this.setState({
                        totalLength: totalLength
                    });
                }
            }
        }, {
            key: "componentWillReceiveProps",
            value: function(nextProps) {
                var _props = this.props, animationId = _props.animationId, points = _props.points;
                nextProps.animationId !== animationId && this.cachePrevData(points);
            }
        }, {
            key: "getTotalLength",
            value: function() {
                var curveDom = this.mainCurve;
                try {
                    return curveDom && curveDom.getTotalLength && curveDom.getTotalLength() || 0;
                } catch (err) {
                    return 0;
                }
            }
        }, {
            key: "getStrokeDasharray",
            value: function(length, totalLength, lines) {
                for (var lineLength = lines.reduce(function(pre, next) {
                    return pre + next;
                }), count = parseInt(length / lineLength, 10), remainLength = length % lineLength, restLength = totalLength - length, remainLines = [], i = 0, sum = 0; ;sum += lines[i], 
                ++i) if (sum + lines[i] > remainLength) {
                    remainLines = [].concat(_toConsumableArray(lines.slice(0, i)), [ remainLength - sum ]);
                    break;
                }
                var emptyLines = remainLines.length % 2 == 0 ? [ 0, restLength ] : [ restLength ];
                return [].concat(_toConsumableArray(this.repeat(lines, count)), _toConsumableArray(remainLines), emptyLines).map(function(line) {
                    return line + "px";
                }).join(", ");
            }
        }, {
            key: "repeat",
            value: function(lines, count) {
                for (var linesUnit = lines.length % 2 != 0 ? [].concat(_toConsumableArray(lines), [ 0 ]) : lines, result = [], i = 0; i < count; ++i) result = [].concat(_toConsumableArray(result), _toConsumableArray(linesUnit));
                return result;
            }
        }, {
            key: "renderErrorBar",
            value: function() {
                function dataPointFormatter(dataPoint, dataKey) {
                    return {
                        x: dataPoint.x,
                        y: dataPoint.y,
                        value: dataPoint.value,
                        errorVal: Object(__WEBPACK_IMPORTED_MODULE_15__util_ChartUtils__.w)(dataPoint.payload, dataKey)
                    };
                }
                if (this.props.isAnimationActive && !this.state.isAnimationFinished) return null;
                var _props2 = this.props, points = _props2.points, xAxis = _props2.xAxis, yAxis = _props2.yAxis, layout = _props2.layout, children = _props2.children, errorBarItems = Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.h)(children, __WEBPACK_IMPORTED_MODULE_12__ErrorBar__.a);
                return errorBarItems ? errorBarItems.map(function(item, i) {
                    return __WEBPACK_IMPORTED_MODULE_3_react___default.a.cloneElement(item, {
                        key: i,
                        data: points,
                        xAxis: xAxis,
                        yAxis: yAxis,
                        layout: layout,
                        dataPointFormatter: dataPointFormatter
                    });
                }) : null;
            }
        }, {
            key: "renderDotItem",
            value: function(option, props) {
                var dotItem = void 0;
                if (__WEBPACK_IMPORTED_MODULE_3_react___default.a.isValidElement(option)) dotItem = __WEBPACK_IMPORTED_MODULE_3_react___default.a.cloneElement(option, props); else if (__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(option)) dotItem = option(props); else {
                    var className = __WEBPACK_IMPORTED_MODULE_6_classnames___default()("recharts-line-dot", option ? option.className : "");
                    dotItem = __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__shape_Dot__.a, _extends({}, props, {
                        className: className
                    }));
                }
                return dotItem;
            }
        }, {
            key: "renderDots",
            value: function() {
                var _this2 = this;
                if (this.props.isAnimationActive && !this.state.isAnimationFinished) return null;
                var _props3 = this.props, dot = _props3.dot, points = _props3.points, dataKey = _props3.dataKey, lineProps = Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.k)(this.props), customDotProps = Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.k)(dot), dotEvents = Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.e)(dot), dots = points.map(function(entry, i) {
                    var dotProps = _extends({
                        key: "dot-" + i,
                        r: 3
                    }, lineProps, customDotProps, dotEvents, {
                        value: entry.value,
                        dataKey: dataKey,
                        cx: entry.x,
                        cy: entry.y,
                        index: i,
                        payload: entry.payload
                    });
                    return _this2.renderDotItem(dot, dotProps);
                });
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__container_Layer__.a, {
                    className: "recharts-line-dots",
                    key: "dots"
                }, dots);
            }
        }, {
            key: "renderCurveStatically",
            value: function(points, needClip, props) {
                var _props4 = this.props, type = _props4.type, layout = _props4.layout, connectNulls = _props4.connectNulls, id = _props4.id, clipPathId = __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(id) ? this.id : id, curveProps = _extends({}, Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.k)(this.props), Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.e)(this.props), {
                    fill: "none",
                    className: "recharts-line-curve",
                    clipPath: needClip ? "url(#clipPath-" + clipPathId + ")" : null,
                    points: points
                }, props, {
                    type: type,
                    layout: layout,
                    connectNulls: connectNulls
                });
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__shape_Curve__.a, _extends({}, curveProps, {
                    pathRef: this.pathRef
                }));
            }
        }, {
            key: "renderCurveWithAnimation",
            value: function(needClip) {
                var _this3 = this, _props5 = this.props, points = _props5.points, strokeDasharray = _props5.strokeDasharray, isAnimationActive = _props5.isAnimationActive, animationBegin = _props5.animationBegin, animationDuration = _props5.animationDuration, animationEasing = _props5.animationEasing, animationId = _props5.animationId, width = _props5.width, height = _props5.height, _state = (_objectWithoutProperties(_props5, [ "points", "strokeDasharray", "isAnimationActive", "animationBegin", "animationDuration", "animationEasing", "animationId", "width", "height" ]), 
                this.state), prevPoints = _state.prevPoints, totalLength = _state.totalLength;
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5_react_smooth___default.a, {
                    begin: animationBegin,
                    duration: animationDuration,
                    isActive: isAnimationActive,
                    easing: animationEasing,
                    from: {
                        t: 0
                    },
                    to: {
                        t: 1
                    },
                    key: "line-" + animationId,
                    onAnimationEnd: this.handleAnimationEnd,
                    onAnimationStart: this.handleAnimationStart
                }, function(_ref2) {
                    var t = _ref2.t;
                    if (prevPoints) {
                        var stepData = points.map(function(entry, index) {
                            if (prevPoints[index]) {
                                var prev = prevPoints[index], _interpolatorX = Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.f)(prev.x, entry.x), _interpolatorY = Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.f)(prev.y, entry.y);
                                return _extends({}, entry, {
                                    x: _interpolatorX(t),
                                    y: _interpolatorY(t)
                                });
                            }
                            var interpolatorX = Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.f)(2 * width, entry.x), interpolatorY = Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.f)(height / 2, entry.y);
                            return _extends({}, entry, {
                                x: interpolatorX(t),
                                y: interpolatorY(t)
                            });
                        });
                        return _this3.renderCurveStatically(stepData, needClip);
                    }
                    var interpolator = Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.f)(0, totalLength), curLength = interpolator(t), currentStrokeDasharray = void 0;
                    if (strokeDasharray) {
                        var lines = strokeDasharray.split(/[,\s]+/gim).map(function(num) {
                            return parseFloat(num);
                        });
                        currentStrokeDasharray = _this3.getStrokeDasharray(curLength, totalLength, lines);
                    } else currentStrokeDasharray = curLength + "px " + (totalLength - curLength) + "px";
                    return _this3.renderCurveStatically(points, needClip, {
                        strokeDasharray: currentStrokeDasharray
                    });
                });
            }
        }, {
            key: "renderCurve",
            value: function(needClip) {
                var _props6 = this.props, points = _props6.points, isAnimationActive = _props6.isAnimationActive, _state2 = this.state, prevPoints = _state2.prevPoints, totalLength = _state2.totalLength;
                return isAnimationActive && points && points.length && (!prevPoints && totalLength > 0 || !__WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default()(prevPoints, points)) ? this.renderCurveWithAnimation(needClip) : this.renderCurveStatically(points, needClip);
            }
        }, {
            key: "render",
            value: function() {
                var _props7 = this.props, hide = _props7.hide, dot = _props7.dot, points = _props7.points, className = _props7.className, xAxis = _props7.xAxis, yAxis = _props7.yAxis, top = _props7.top, left = _props7.left, width = _props7.width, height = _props7.height, isAnimationActive = _props7.isAnimationActive, id = _props7.id;
                if (hide || !points || !points.length) return null;
                var isAnimationFinished = this.state.isAnimationFinished, hasSinglePoint = 1 === points.length, layerClass = __WEBPACK_IMPORTED_MODULE_6_classnames___default()("recharts-line", className), needClip = xAxis && xAxis.allowDataOverflow || yAxis && yAxis.allowDataOverflow, clipPathId = __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(id) ? this.id : id;
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__container_Layer__.a, {
                    className: layerClass
                }, needClip ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("defs", null, __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("clipPath", {
                    id: "clipPath-" + clipPathId
                }, __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("rect", {
                    x: left,
                    y: top,
                    width: width,
                    height: height
                }))) : null, !hasSinglePoint && this.renderCurve(needClip), this.renderErrorBar(), (hasSinglePoint || dot) && this.renderDots(), (!isAnimationActive || isAnimationFinished) && __WEBPACK_IMPORTED_MODULE_11__component_LabelList__.a.renderCallByParent(this.props, points));
            }
        } ]), Line;
    }(__WEBPACK_IMPORTED_MODULE_3_react__.Component), _class2.displayName = "Line", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.c, __WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.a, {
        className: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string,
        type: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "basis", "basisClosed", "basisOpen", "linear", "linearClosed", "natural", "monotoneX", "monotoneY", "monotone", "step", "stepBefore", "stepAfter" ]), __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func ]),
        unit: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        name: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        yAxisId: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        xAxisId: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        yAxis: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object,
        xAxis: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object,
        legendType: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.b),
        layout: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "horizontal", "vertical" ]),
        connectNulls: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool,
        hide: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool,
        activeDot: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool ]),
        dot: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool ]),
        top: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        left: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        width: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        height: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        points: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
            value: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.value
        })),
        onAnimationStart: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func,
        onAnimationEnd: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func,
        isAnimationActive: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool,
        animationBegin: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        animationDuration: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        animationEasing: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "ease", "ease-in", "ease-out", "ease-in-out", "linear" ]),
        animationId: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        id: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string
    }), _class2.defaultProps = {
        xAxisId: 0,
        yAxisId: 0,
        connectNulls: !1,
        activeDot: !0,
        dot: !0,
        legendType: "line",
        stroke: "#3182bd",
        strokeWidth: 1,
        fill: "#fff",
        points: [],
        isAnimationActive: !Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.n)(),
        animationBegin: 0,
        animationDuration: 1500,
        animationEasing: "ease",
        hide: !1,
        onAnimationStart: function() {},
        onAnimationEnd: function() {}
    }, _class2.getComposedData = function(_ref3) {
        var props = _ref3.props, xAxis = _ref3.xAxis, yAxis = _ref3.yAxis, xAxisTicks = _ref3.xAxisTicks, yAxisTicks = _ref3.yAxisTicks, dataKey = _ref3.dataKey, bandSize = _ref3.bandSize, displayedData = _ref3.displayedData, offset = _ref3.offset, layout = props.layout, points = displayedData.map(function(entry, index) {
            var value = Object(__WEBPACK_IMPORTED_MODULE_15__util_ChartUtils__.w)(entry, dataKey);
            return "horizontal" === layout ? {
                x: Object(__WEBPACK_IMPORTED_MODULE_15__util_ChartUtils__.l)({
                    axis: xAxis,
                    ticks: xAxisTicks,
                    bandSize: bandSize,
                    entry: entry,
                    index: index
                }),
                y: __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(value) ? null : yAxis.scale(value),
                value: value,
                payload: entry
            } : {
                x: __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(value) ? null : xAxis.scale(value),
                y: Object(__WEBPACK_IMPORTED_MODULE_15__util_ChartUtils__.l)({
                    axis: yAxis,
                    ticks: yAxisTicks,
                    bandSize: bandSize,
                    entry: entry,
                    index: index
                }),
                value: value,
                payload: entry
            };
        });
        return _extends({
            points: points,
            layout: layout
        }, offset);
    }, _class = _temp2)) || _class;
    __webpack_exports__.a = Line;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp2, __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__ = __webpack_require__(45), __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__), __WEBPACK_IMPORTED_MODULE_1_lodash_isNaN__ = __webpack_require__(120), __WEBPACK_IMPORTED_MODULE_1_lodash_isNaN___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isNaN__), __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_3_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_4_lodash_isArray__ = __webpack_require__(13), __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_lodash_isArray__), __WEBPACK_IMPORTED_MODULE_5_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_5_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_react__), __WEBPACK_IMPORTED_MODULE_6_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_6_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_prop_types__), __WEBPACK_IMPORTED_MODULE_7_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_7_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_classnames__), __WEBPACK_IMPORTED_MODULE_8_react_smooth__ = __webpack_require__(33), __WEBPACK_IMPORTED_MODULE_8_react_smooth___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8_react_smooth__), __WEBPACK_IMPORTED_MODULE_9__shape_Curve__ = __webpack_require__(71), __WEBPACK_IMPORTED_MODULE_10__shape_Dot__ = __webpack_require__(63), __WEBPACK_IMPORTED_MODULE_11__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_12__component_LabelList__ = __webpack_require__(47), __WEBPACK_IMPORTED_MODULE_13__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_15__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__ = __webpack_require__(16), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), Area = Object(__WEBPACK_IMPORTED_MODULE_13__util_PureRender__.a)((_temp2 = _class2 = function(_Component) {
        function Area() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, Area);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = Area.__proto__ || Object.getPrototypeOf(Area)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                isAnimationFinished: !0
            }, _this.id = Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.k)("recharts-area-"), 
            _this.cachePrevData = function(points, baseLine) {
                _this.setState({
                    prevPoints: points,
                    prevBaseLine: baseLine
                });
            }, _this.handleAnimationEnd = function() {
                var onAnimationEnd = _this.props.onAnimationEnd;
                _this.setState({
                    isAnimationFinished: !0
                }), __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction___default()(onAnimationEnd) && onAnimationEnd();
            }, _this.handleAnimationStart = function() {
                var onAnimationStart = _this.props.onAnimationStart;
                _this.setState({
                    isAnimationFinished: !1
                }), __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction___default()(onAnimationStart) && onAnimationStart();
            }, _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(Area, _Component), _createClass(Area, [ {
            key: "componentWillReceiveProps",
            value: function(nextProps) {
                var _props = this.props, animationId = _props.animationId, points = _props.points, baseLine = _props.baseLine;
                nextProps.animationId !== animationId && this.cachePrevData(points, baseLine);
            }
        }, {
            key: "renderDots",
            value: function() {
                var _this2 = this;
                if (this.props.isAnimationActive && !this.state.isAnimationFinished) return null;
                var _props2 = this.props, dot = _props2.dot, points = _props2.points, dataKey = _props2.dataKey, areaProps = Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.k)(this.props), customDotProps = Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.k)(dot), dotEvents = Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.e)(dot), dots = points.map(function(entry, i) {
                    var dotProps = _extends({
                        key: "dot-" + i,
                        r: 3
                    }, areaProps, customDotProps, dotEvents, {
                        dataKey: dataKey,
                        cx: entry.x,
                        cy: entry.y,
                        index: i,
                        value: entry.value,
                        payload: entry.payload
                    });
                    return _this2.constructor.renderDotItem(dot, dotProps);
                });
                return __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_11__container_Layer__.a, {
                    className: "recharts-area-dots"
                }, dots);
            }
        }, {
            key: "renderHorizontalRect",
            value: function(alpha) {
                var _props3 = this.props, baseLine = _props3.baseLine, points = _props3.points, strokeWidth = _props3.strokeWidth, startX = points[0].x, endX = points[points.length - 1].x, width = alpha * Math.abs(startX - endX), maxY = Math.max.apply(null, points.map(function(entry) {
                    return entry.y || 0;
                }));
                return Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.h)(baseLine) ? maxY = Math.max(baseLine, maxY) : baseLine && __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default()(baseLine) && baseLine.length && (maxY = Math.max(Math.max.apply(null, baseLine.map(function(entry) {
                    return entry.y || 0;
                })), maxY)), Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.h)(maxY) ? __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement("rect", {
                    x: startX < endX ? startX : startX - width,
                    y: 0,
                    width: width,
                    height: maxY + (strokeWidth || 1)
                }) : null;
            }
        }, {
            key: "renderVerticalRect",
            value: function(alpha) {
                var _props4 = this.props, baseLine = _props4.baseLine, points = _props4.points, strokeWidth = _props4.strokeWidth, startY = points[0].y, endY = points[points.length - 1].y, height = alpha * Math.abs(startY - endY), maxX = Math.max.apply(null, points.map(function(entry) {
                    return entry.x || 0;
                }));
                return Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.h)(baseLine) ? maxX = Math.max(baseLine, maxX) : baseLine && __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default()(baseLine) && baseLine.length && (maxX = Math.max(Math.max.apply(null, baseLine.map(function(entry) {
                    return entry.x || 0;
                })), maxX)), Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.h)(maxX) ? __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement("rect", {
                    x: 0,
                    y: startY < endY ? startY : startY - height,
                    width: maxX + (strokeWidth || 1),
                    height: height
                }) : null;
            }
        }, {
            key: "renderClipRect",
            value: function(alpha) {
                return "vertical" === this.props.layout ? this.renderVerticalRect(alpha) : this.renderHorizontalRect(alpha);
            }
        }, {
            key: "renderAreaStatically",
            value: function(points, baseLine, needClip) {
                var _props5 = this.props, layout = _props5.layout, type = _props5.type, stroke = _props5.stroke, connectNulls = _props5.connectNulls, isRange = _props5.isRange;
                return __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_11__container_Layer__.a, {
                    clipPath: needClip ? "url(#clipPath-" + this.id + ")" : null
                }, __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__shape_Curve__.a, _extends({}, this.props, {
                    points: points,
                    baseLine: baseLine,
                    stroke: "none",
                    className: "recharts-area-area"
                })), "none" !== stroke && __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__shape_Curve__.a, _extends({}, Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.k)(this.props), {
                    className: "recharts-area-curve",
                    layout: layout,
                    type: type,
                    connectNulls: connectNulls,
                    fill: "none",
                    points: points
                })), "none" !== stroke && isRange && __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__shape_Curve__.a, _extends({}, Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.k)(this.props), {
                    className: "recharts-area-curve",
                    layout: layout,
                    type: type,
                    connectNulls: connectNulls,
                    fill: "none",
                    points: baseLine
                })));
            }
        }, {
            key: "renderAreaWithAnimation",
            value: function(needClip) {
                var _this3 = this, _props6 = this.props, points = _props6.points, baseLine = _props6.baseLine, isAnimationActive = _props6.isAnimationActive, animationBegin = _props6.animationBegin, animationDuration = _props6.animationDuration, animationEasing = _props6.animationEasing, animationId = _props6.animationId, id = _props6.id, _state = this.state, prevPoints = _state.prevPoints, prevBaseLine = _state.prevBaseLine, clipPathId = __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(id) ? this.id : id;
                return __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8_react_smooth___default.a, {
                    begin: animationBegin,
                    duration: animationDuration,
                    isActive: isAnimationActive,
                    easing: animationEasing,
                    from: {
                        t: 0
                    },
                    to: {
                        t: 1
                    },
                    key: "area-" + animationId,
                    onAnimationEnd: this.handleAnimationEnd,
                    onAnimationStart: this.handleAnimationStart
                }, function(_ref2) {
                    var t = _ref2.t;
                    if (prevPoints) {
                        var stepPoints = points.map(function(entry, index) {
                            if (prevPoints[index]) {
                                var prev = prevPoints[index], interpolatorX = Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.f)(prev.x, entry.x), interpolatorY = Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.f)(prev.y, entry.y);
                                return _extends({}, entry, {
                                    x: interpolatorX(t),
                                    y: interpolatorY(t)
                                });
                            }
                            return entry;
                        }), stepBaseLine = void 0;
                        if (Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.h)(baseLine)) {
                            stepBaseLine = Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.f)(prevBaseLine, baseLine)(t);
                        } else if (__WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(baseLine) || __WEBPACK_IMPORTED_MODULE_1_lodash_isNaN___default()(baseLine)) {
                            var _interpolator = Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.f)(prevBaseLine, 0);
                            stepBaseLine = _interpolator(t);
                        } else stepBaseLine = baseLine.map(function(entry, index) {
                            if (prevBaseLine[index]) {
                                var prev = prevBaseLine[index], interpolatorX = Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.f)(prev.x, entry.x), interpolatorY = Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.f)(prev.y, entry.y);
                                return _extends({}, entry, {
                                    x: interpolatorX(t),
                                    y: interpolatorY(t)
                                });
                            }
                            return entry;
                        });
                        return _this3.renderAreaStatically(stepPoints, stepBaseLine, needClip);
                    }
                    return __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_11__container_Layer__.a, null, __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement("defs", null, __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement("clipPath", {
                        id: "animationClipPath-" + clipPathId
                    }, _this3.renderClipRect(t))), __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_11__container_Layer__.a, {
                        clipPath: "url(#animationClipPath-" + clipPathId + ")"
                    }, _this3.renderAreaStatically(points, baseLine, needClip)));
                });
            }
        }, {
            key: "renderArea",
            value: function(needClip) {
                var _props7 = this.props, points = _props7.points, baseLine = _props7.baseLine, isAnimationActive = _props7.isAnimationActive, _state2 = this.state, prevPoints = _state2.prevPoints, prevBaseLine = _state2.prevBaseLine, totalLength = _state2.totalLength;
                return isAnimationActive && points && points.length && (!prevPoints && totalLength > 0 || !__WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default()(prevPoints, points) || !__WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default()(prevBaseLine, baseLine)) ? this.renderAreaWithAnimation(needClip) : this.renderAreaStatically(points, baseLine, needClip);
            }
        }, {
            key: "render",
            value: function() {
                var _props8 = this.props, hide = _props8.hide, dot = _props8.dot, points = _props8.points, className = _props8.className, top = _props8.top, left = _props8.left, xAxis = _props8.xAxis, yAxis = _props8.yAxis, width = _props8.width, height = _props8.height, isAnimationActive = _props8.isAnimationActive, id = _props8.id;
                if (hide || !points || !points.length) return null;
                var isAnimationFinished = this.state.isAnimationFinished, hasSinglePoint = 1 === points.length, layerClass = __WEBPACK_IMPORTED_MODULE_7_classnames___default()("recharts-area", className), needClip = xAxis && xAxis.allowDataOverflow || yAxis && yAxis.allowDataOverflow, clipPathId = __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(id) ? this.id : id;
                return __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_11__container_Layer__.a, {
                    className: layerClass
                }, needClip ? __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement("defs", null, __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement("clipPath", {
                    id: "clipPath-" + clipPathId
                }, __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement("rect", {
                    x: left,
                    y: top,
                    width: width,
                    height: height
                }))) : null, hasSinglePoint ? null : this.renderArea(needClip), (dot || hasSinglePoint) && this.renderDots(), (!isAnimationActive || isAnimationFinished) && __WEBPACK_IMPORTED_MODULE_12__component_LabelList__.a.renderCallByParent(this.props, points));
            }
        } ]), Area;
    }(__WEBPACK_IMPORTED_MODULE_5_react__.Component), _class2.displayName = "Area", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.c, __WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.a, {
        className: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string,
        dataKey: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func ]).isRequired,
        type: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "basis", "basisClosed", "basisOpen", "linear", "linearClosed", "natural", "monotoneX", "monotoneY", "monotone", "step", "stepBefore", "stepAfter" ]), __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func ]),
        unit: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number ]),
        name: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number ]),
        yAxisId: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number ]),
        xAxisId: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number ]),
        yAxis: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.object,
        xAxis: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.object,
        stackId: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string ]),
        legendType: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.b),
        connectNulls: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.bool,
        activeDot: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.bool ]),
        dot: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.bool ]),
        label: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.bool ]),
        hide: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.bool,
        layout: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "horizontal", "vertical" ]),
        baseLine: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.array ]),
        isRange: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.bool,
        points: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
            value: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.array ])
        })),
        onAnimationStart: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        onAnimationEnd: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func,
        animationId: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        isAnimationActive: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.bool,
        animationBegin: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        animationDuration: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number,
        animationEasing: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.oneOf([ "ease", "ease-in", "ease-out", "ease-in-out", "linear" ]),
        id: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.string
    }), _class2.defaultProps = {
        stroke: "#3182bd",
        fill: "#3182bd",
        fillOpacity: .6,
        xAxisId: 0,
        yAxisId: 0,
        legendType: "line",
        connectNulls: !1,
        points: [],
        dot: !1,
        activeDot: !0,
        hide: !1,
        isAnimationActive: !Object(__WEBPACK_IMPORTED_MODULE_14__util_ReactUtils__.n)(),
        animationBegin: 0,
        animationDuration: 1500,
        animationEasing: "ease"
    }, _class2.getBaseValue = function(props, xAxis, yAxis) {
        var layout = props.layout, baseValue = props.baseValue;
        if (Object(__WEBPACK_IMPORTED_MODULE_15__util_DataUtils__.h)(baseValue)) return baseValue;
        var numericAxis = "horizontal" === layout ? yAxis : xAxis, domain = numericAxis.scale.domain();
        if ("number" === numericAxis.type) {
            var max = Math.max(domain[0], domain[1]), min = Math.min(domain[0], domain[1]);
            return "dataMin" === baseValue ? min : "dataMax" === baseValue ? max : max < 0 ? max : Math.max(Math.min(domain[0], domain[1]), 0);
        }
        return "dataMin" === baseValue ? domain[0] : "dataMax" === baseValue ? domain[1] : domain[0];
    }, _class2.getComposedData = function(_ref3) {
        var props = _ref3.props, xAxis = _ref3.xAxis, yAxis = _ref3.yAxis, xAxisTicks = _ref3.xAxisTicks, yAxisTicks = _ref3.yAxisTicks, bandSize = _ref3.bandSize, dataKey = _ref3.dataKey, stackedData = _ref3.stackedData, dataStartIndex = _ref3.dataStartIndex, displayedData = _ref3.displayedData, offset = _ref3.offset, layout = props.layout, hasStack = stackedData && stackedData.length, baseValue = Area.getBaseValue(props, xAxis, yAxis), isRange = !1, points = displayedData.map(function(entry, index) {
            var value = void 0;
            return hasStack ? value = stackedData[dataStartIndex + index] : (value = Object(__WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__.w)(entry, dataKey), 
            __WEBPACK_IMPORTED_MODULE_4_lodash_isArray___default()(value) ? isRange = !0 : value = [ baseValue, value ]), 
            "horizontal" === layout ? {
                x: Object(__WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__.l)({
                    axis: xAxis,
                    ticks: xAxisTicks,
                    bandSize: bandSize,
                    entry: entry,
                    index: index
                }),
                y: __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(value[1]) ? null : yAxis.scale(value[1]),
                value: value,
                payload: entry
            } : {
                x: __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(value[1]) ? null : xAxis.scale(value[1]),
                y: Object(__WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__.l)({
                    axis: yAxis,
                    ticks: yAxisTicks,
                    bandSize: bandSize,
                    entry: entry,
                    index: index
                }),
                value: value,
                payload: entry
            };
        }), baseLine = void 0;
        return baseLine = hasStack || isRange ? points.map(function(entry) {
            return {
                x: "horizontal" === layout ? entry.x : xAxis.scale(entry && entry.value[0]),
                y: "horizontal" === layout ? yAxis.scale(entry && entry.value[0]) : entry.y
            };
        }) : "horizontal" === layout ? yAxis.scale(baseValue) : xAxis.scale(baseValue), 
        _extends({
            points: points,
            baseLine: baseLine,
            layout: layout,
            isRange: isRange
        }, offset);
    }, _class2.renderDotItem = function(option, props) {
        return __WEBPACK_IMPORTED_MODULE_5_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_5_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_5_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__shape_Dot__.a, _extends({}, props, {
            className: "recharts-area-dot"
        }));
    }, _class = _temp2)) || _class;
    __webpack_exports__.a = Area;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp2, __WEBPACK_IMPORTED_MODULE_0_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_1_lodash_isEqual__ = __webpack_require__(45), __WEBPACK_IMPORTED_MODULE_1_lodash_isEqual___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isEqual__), __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_3_lodash_isArray__ = __webpack_require__(13), __WEBPACK_IMPORTED_MODULE_3_lodash_isArray___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_lodash_isArray__), __WEBPACK_IMPORTED_MODULE_4_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_4_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_react__), __WEBPACK_IMPORTED_MODULE_5_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_5_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_prop_types__), __WEBPACK_IMPORTED_MODULE_6_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_6_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_classnames__), __WEBPACK_IMPORTED_MODULE_7_react_smooth__ = __webpack_require__(33), __WEBPACK_IMPORTED_MODULE_7_react_smooth___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_react_smooth__), __WEBPACK_IMPORTED_MODULE_8__shape_Rectangle__ = __webpack_require__(70), __WEBPACK_IMPORTED_MODULE_9__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_10__ErrorBar__ = __webpack_require__(95), __WEBPACK_IMPORTED_MODULE_11__component_Cell__ = __webpack_require__(88), __WEBPACK_IMPORTED_MODULE_12__component_LabelList__ = __webpack_require__(47), __WEBPACK_IMPORTED_MODULE_13__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_14__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__ = __webpack_require__(16), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), Bar = Object(__WEBPACK_IMPORTED_MODULE_13__util_PureRender__.a)((_temp2 = _class2 = function(_Component) {
        function Bar() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, Bar);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = Bar.__proto__ || Object.getPrototypeOf(Bar)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                isAnimationFinished: !1
            }, _this.id = Object(__WEBPACK_IMPORTED_MODULE_14__util_DataUtils__.k)("recharts-bar-"), 
            _this.cachePrevData = function(data) {
                _this.setState({
                    prevData: data
                });
            }, _this.handleAnimationEnd = function() {
                _this.setState({
                    isAnimationFinished: !0
                }), _this.props.onAnimationEnd();
            }, _this.handleAnimationStart = function() {
                _this.setState({
                    isAnimationFinished: !1
                }), _this.props.onAnimationStart();
            }, _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(Bar, _Component), _createClass(Bar, [ {
            key: "componentWillReceiveProps",
            value: function(nextProps) {
                var _props = this.props, animationId = _props.animationId, data = _props.data;
                nextProps.animationId !== animationId && this.cachePrevData(data);
            }
        }, {
            key: "renderRectangle",
            value: function(option, props) {
                return __WEBPACK_IMPORTED_MODULE_4_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_4_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__shape_Rectangle__.a, props);
            }
        }, {
            key: "renderRectanglesStatically",
            value: function(data) {
                var _this2 = this, shape = this.props.shape, baseProps = Object(__WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__.k)(this.props);
                return data && data.map(function(entry, i) {
                    var props = _extends({}, baseProps, entry, {
                        index: i
                    });
                    return __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__container_Layer__.a, _extends({
                        className: "recharts-bar-rectangle"
                    }, Object(__WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__.f)(_this2.props, entry, i), {
                        key: "rectangle-" + i
                    }), _this2.renderRectangle(shape, props));
                });
            }
        }, {
            key: "renderRectanglesWithAnimation",
            value: function() {
                var _this3 = this, _props2 = this.props, data = _props2.data, layout = _props2.layout, isAnimationActive = _props2.isAnimationActive, animationBegin = _props2.animationBegin, animationDuration = _props2.animationDuration, animationEasing = _props2.animationEasing, animationId = _props2.animationId, prevData = (_props2.width, 
                this.state.prevData);
                return __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7_react_smooth___default.a, {
                    begin: animationBegin,
                    duration: animationDuration,
                    isActive: isAnimationActive,
                    easing: animationEasing,
                    from: {
                        t: 0
                    },
                    to: {
                        t: 1
                    },
                    key: "bar-" + animationId,
                    onAnimationEnd: this.handleAnimationEnd,
                    onAnimationStart: this.handleAnimationStart
                }, function(_ref2) {
                    var t = _ref2.t, stepData = data.map(function(entry, index) {
                        var prev = prevData && prevData[index];
                        if (prev) {
                            var interpolatorX = Object(__WEBPACK_IMPORTED_MODULE_14__util_DataUtils__.f)(prev.x, entry.x), interpolatorY = Object(__WEBPACK_IMPORTED_MODULE_14__util_DataUtils__.f)(prev.y, entry.y), interpolatorWidth = Object(__WEBPACK_IMPORTED_MODULE_14__util_DataUtils__.f)(prev.width, entry.width), interpolatorHeight = Object(__WEBPACK_IMPORTED_MODULE_14__util_DataUtils__.f)(prev.height, entry.height);
                            return _extends({}, entry, {
                                x: interpolatorX(t),
                                y: interpolatorY(t),
                                width: interpolatorWidth(t),
                                height: interpolatorHeight(t)
                            });
                        }
                        if ("horizontal" === layout) {
                            var _interpolatorHeight = Object(__WEBPACK_IMPORTED_MODULE_14__util_DataUtils__.f)(0, entry.height), h = _interpolatorHeight(t);
                            return _extends({}, entry, {
                                y: entry.y + entry.height - h,
                                height: h
                            });
                        }
                        var interpolator = Object(__WEBPACK_IMPORTED_MODULE_14__util_DataUtils__.f)(0, entry.width), w = interpolator(t);
                        return _extends({}, entry, {
                            width: w
                        });
                    });
                    return __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__container_Layer__.a, null, _this3.renderRectanglesStatically(stepData));
                });
            }
        }, {
            key: "renderRectangles",
            value: function() {
                var _props3 = this.props, data = _props3.data, isAnimationActive = _props3.isAnimationActive, prevData = this.state.prevData;
                return !(isAnimationActive && data && data.length) || prevData && __WEBPACK_IMPORTED_MODULE_1_lodash_isEqual___default()(prevData, data) ? this.renderRectanglesStatically(data) : this.renderRectanglesWithAnimation();
            }
        }, {
            key: "renderBackground",
            value: function(sectors) {
                var _this4 = this, data = this.props.data, backgroundProps = Object(__WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__.k)(this.props.background);
                return data.map(function(entry, i) {
                    var background = (entry.value, entry.background), rest = _objectWithoutProperties(entry, [ "value", "background" ]);
                    if (!background) return null;
                    var props = _extends({}, rest, {
                        fill: "#eee"
                    }, background, backgroundProps, Object(__WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__.f)(_this4.props, entry, i), {
                        index: i,
                        key: "background-bar-" + i,
                        className: "recharts-bar-background-rectangle"
                    });
                    return _this4.renderRectangle(background, props);
                });
            }
        }, {
            key: "renderErrorBar",
            value: function() {
                function dataPointFormatter(dataPoint, dataKey) {
                    return {
                        x: dataPoint.x,
                        y: dataPoint.y,
                        value: dataPoint.value,
                        errorVal: Object(__WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__.w)(dataPoint, dataKey)
                    };
                }
                if (this.props.isAnimationActive && !this.state.isAnimationFinished) return null;
                var _props4 = this.props, data = _props4.data, xAxis = _props4.xAxis, yAxis = _props4.yAxis, layout = _props4.layout, children = _props4.children, errorBarItems = Object(__WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__.h)(children, __WEBPACK_IMPORTED_MODULE_10__ErrorBar__.a);
                if (!errorBarItems) return null;
                var offset = "vertical" === layout ? data[0].height / 2 : data[0].width / 2;
                return errorBarItems.map(function(item, i) {
                    return __WEBPACK_IMPORTED_MODULE_4_react___default.a.cloneElement(item, {
                        key: i,
                        data: data,
                        xAxis: xAxis,
                        yAxis: yAxis,
                        layout: layout,
                        offset: offset,
                        dataPointFormatter: dataPointFormatter
                    });
                });
            }
        }, {
            key: "render",
            value: function() {
                var _props5 = this.props, hide = _props5.hide, data = _props5.data, className = _props5.className, xAxis = _props5.xAxis, yAxis = _props5.yAxis, left = _props5.left, top = _props5.top, width = _props5.width, height = _props5.height, isAnimationActive = _props5.isAnimationActive, background = _props5.background, id = _props5.id;
                if (hide || !data || !data.length) return null;
                var isAnimationFinished = this.state.isAnimationFinished, layerClass = __WEBPACK_IMPORTED_MODULE_6_classnames___default()("recharts-bar", className), needClip = xAxis && xAxis.allowDataOverflow || yAxis && yAxis.allowDataOverflow, clipPathId = __WEBPACK_IMPORTED_MODULE_0_lodash_isNil___default()(id) ? this.id : id;
                return __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__container_Layer__.a, {
                    className: layerClass
                }, needClip ? __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement("defs", null, __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement("clipPath", {
                    id: "clipPath-" + clipPathId
                }, __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement("rect", {
                    x: left,
                    y: top,
                    width: width,
                    height: height
                }))) : null, __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__container_Layer__.a, {
                    className: "recharts-bar-rectangles",
                    clipPath: needClip ? "url(#clipPath-" + clipPathId + ")" : null
                }, background ? this.renderBackground() : null, this.renderRectangles()), this.renderErrorBar(), (!isAnimationActive || isAnimationFinished) && __WEBPACK_IMPORTED_MODULE_12__component_LabelList__.a.renderCallByParent(this.props, data));
            }
        } ]), Bar;
    }(__WEBPACK_IMPORTED_MODULE_4_react__.Component), _class2.displayName = "Bar", _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__.c, __WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__.a, {
        className: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string,
        layout: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOf([ "vertical", "horizontal" ]),
        xAxisId: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string ]),
        yAxisId: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string ]),
        yAxis: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.object,
        xAxis: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.object,
        stackId: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string ]),
        barSize: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        unit: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number ]),
        name: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number ]),
        dataKey: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func ]).isRequired,
        legendType: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOf(__WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__.b),
        minPointSize: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        maxBarSize: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        hide: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.bool,
        shape: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.element ]),
        data: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
            width: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
            height: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
            radius: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.array ]),
            value: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.array ])
        })),
        onAnimationStart: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func,
        onAnimationEnd: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func,
        animationId: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        isAnimationActive: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.bool,
        animationBegin: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        animationDuration: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        animationEasing: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOf([ "ease", "ease-in", "ease-out", "ease-in-out", "linear" ]),
        id: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string
    }), _class2.defaultProps = {
        xAxisId: 0,
        yAxisId: 0,
        legendType: "rect",
        minPointSize: 0,
        hide: !1,
        data: [],
        layout: "vertical",
        isAnimationActive: !Object(__WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__.n)(),
        animationBegin: 0,
        animationDuration: 400,
        animationEasing: "ease",
        onAnimationStart: function() {},
        onAnimationEnd: function() {}
    }, _class2.getComposedData = function(_ref3) {
        var props = _ref3.props, item = _ref3.item, barPosition = _ref3.barPosition, bandSize = _ref3.bandSize, xAxis = _ref3.xAxis, yAxis = _ref3.yAxis, xAxisTicks = _ref3.xAxisTicks, yAxisTicks = _ref3.yAxisTicks, stackedData = _ref3.stackedData, dataStartIndex = _ref3.dataStartIndex, displayedData = _ref3.displayedData, offset = _ref3.offset, pos = Object(__WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__.f)(barPosition, item);
        if (!pos) return [];
        var layout = props.layout, _item$props = item.props, dataKey = _item$props.dataKey, children = _item$props.children, minPointSize = _item$props.minPointSize, numericAxis = "horizontal" === layout ? yAxis : xAxis, stackedDomain = stackedData ? numericAxis.scale.domain() : null, baseValue = Object(__WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__.j)({
            props: props,
            numericAxis: numericAxis
        }), cells = Object(__WEBPACK_IMPORTED_MODULE_15__util_ReactUtils__.h)(children, __WEBPACK_IMPORTED_MODULE_11__component_Cell__.a), rects = displayedData.map(function(entry, index) {
            var value = void 0, x = void 0, y = void 0, width = void 0, height = void 0, background = void 0;
            if (stackedData ? value = Object(__WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__.C)(stackedData[dataStartIndex + index], stackedDomain) : (value = Object(__WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__.w)(entry, dataKey), 
            __WEBPACK_IMPORTED_MODULE_3_lodash_isArray___default()(value) || (value = [ baseValue, value ])), 
            "horizontal" === layout) {
                if (x = Object(__WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__.k)({
                    axis: xAxis,
                    ticks: xAxisTicks,
                    bandSize: bandSize,
                    offset: pos.offset,
                    entry: entry,
                    index: index
                }), y = yAxis.scale(value[1]), width = pos.size, height = yAxis.scale(value[0]) - yAxis.scale(value[1]), 
                background = {
                    x: x,
                    y: yAxis.y,
                    width: width,
                    height: yAxis.height
                }, Math.abs(minPointSize) > 0 && Math.abs(height) < Math.abs(minPointSize)) {
                    var delta = Object(__WEBPACK_IMPORTED_MODULE_14__util_DataUtils__.j)(height || minPointSize) * (Math.abs(minPointSize) - Math.abs(height));
                    y -= delta, height += delta;
                }
            } else if (x = xAxis.scale(value[0]), y = Object(__WEBPACK_IMPORTED_MODULE_16__util_ChartUtils__.k)({
                axis: yAxis,
                ticks: yAxisTicks,
                bandSize: bandSize,
                offset: pos.offset,
                entry: entry,
                index: index
            }), width = xAxis.scale(value[1]) - xAxis.scale(value[0]), height = pos.size, background = {
                x: xAxis.x,
                y: y,
                width: xAxis.width,
                height: height
            }, Math.abs(minPointSize) > 0 && Math.abs(width) < Math.abs(minPointSize)) {
                var _delta = Object(__WEBPACK_IMPORTED_MODULE_14__util_DataUtils__.j)(width || minPointSize) * (Math.abs(minPointSize) - Math.abs(width));
                width += _delta;
            }
            return _extends({}, entry, {
                x: x,
                y: y,
                width: width,
                height: height,
                value: stackedData ? value : value[1],
                payload: entry,
                background: background
            }, cells && cells[index] && cells[index].props);
        });
        return _extends({
            data: rects,
            layout: layout
        }, offset);
    }, _class = _temp2)) || _class;
    __webpack_exports__.a = Bar;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp2, __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__ = __webpack_require__(45), __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_2_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_3_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_3_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_react__), __WEBPACK_IMPORTED_MODULE_4_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_4_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_prop_types__), __WEBPACK_IMPORTED_MODULE_5_react_smooth__ = __webpack_require__(33), __WEBPACK_IMPORTED_MODULE_5_react_smooth___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_react_smooth__), __WEBPACK_IMPORTED_MODULE_6_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_6_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_classnames__), __WEBPACK_IMPORTED_MODULE_7__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_8__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_9__component_LabelList__ = __webpack_require__(47), __WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_11__ZAxis__ = __webpack_require__(142), __WEBPACK_IMPORTED_MODULE_12__shape_Curve__ = __webpack_require__(71), __WEBPACK_IMPORTED_MODULE_13__shape_Symbols__ = __webpack_require__(181), __WEBPACK_IMPORTED_MODULE_14__ErrorBar__ = __webpack_require__(95), __WEBPACK_IMPORTED_MODULE_15__component_Cell__ = __webpack_require__(88), __WEBPACK_IMPORTED_MODULE_16__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_17__util_ChartUtils__ = __webpack_require__(16), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), Scatter = Object(__WEBPACK_IMPORTED_MODULE_7__util_PureRender__.a)((_temp2 = _class2 = function(_Component) {
        function Scatter() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, Scatter);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = Scatter.__proto__ || Object.getPrototypeOf(Scatter)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                isAnimationFinished: !1
            }, _this.cachePrevPoints = function(points) {
                _this.setState({
                    prevPoints: points
                });
            }, _this.handleAnimationEnd = function() {
                _this.setState({
                    isAnimationFinished: !0
                });
            }, _this.handleAnimationStart = function() {
                _this.setState({
                    isAnimationFinished: !1
                });
            }, _this.id = Object(__WEBPACK_IMPORTED_MODULE_16__util_DataUtils__.k)("recharts-scatter-"), 
            _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(Scatter, _Component), _createClass(Scatter, [ {
            key: "componentWillReceiveProps",
            value: function(nextProps) {
                var _props = this.props, animationId = _props.animationId, points = _props.points;
                nextProps.animationId !== animationId && this.cachePrevPoints(points);
            }
        }, {
            key: "renderSymbolItem",
            value: function(option, props) {
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_13__shape_Symbols__.a, _extends({}, props, {
                    type: option
                }));
            }
        }, {
            key: "renderSymbolsStatically",
            value: function(points) {
                var _this2 = this, _props2 = this.props, shape = _props2.shape, activeShape = _props2.activeShape, activeIndex = _props2.activeIndex, baseProps = Object(__WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__.k)(this.props);
                return points.map(function(entry, i) {
                    var props = _extends({
                        key: "symbol-" + i
                    }, baseProps, entry);
                    return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, _extends({
                        className: "recharts-scatter-symbol"
                    }, Object(__WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__.f)(_this2.props, entry, i), {
                        key: "symbol-" + i
                    }), _this2.renderSymbolItem(activeIndex === i ? activeShape : shape, props));
                });
            }
        }, {
            key: "renderSymbolsWithAnimation",
            value: function() {
                var _this3 = this, _props3 = this.props, points = _props3.points, isAnimationActive = _props3.isAnimationActive, animationBegin = _props3.animationBegin, animationDuration = _props3.animationDuration, animationEasing = _props3.animationEasing, animationId = _props3.animationId, prevPoints = this.state.prevPoints;
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5_react_smooth___default.a, {
                    begin: animationBegin,
                    duration: animationDuration,
                    isActive: isAnimationActive,
                    easing: animationEasing,
                    from: {
                        t: 0
                    },
                    to: {
                        t: 1
                    },
                    key: "pie-" + animationId,
                    onAnimationEnd: this.handleAnimationEnd,
                    onAnimationStart: this.handleAnimationStart
                }, function(_ref2) {
                    var t = _ref2.t, stepData = points.map(function(entry, index) {
                        var prev = prevPoints && prevPoints[index];
                        if (prev) {
                            var interpolatorCx = Object(__WEBPACK_IMPORTED_MODULE_16__util_DataUtils__.f)(prev.cx, entry.cx), interpolatorCy = Object(__WEBPACK_IMPORTED_MODULE_16__util_DataUtils__.f)(prev.cy, entry.cy), interpolatorSize = Object(__WEBPACK_IMPORTED_MODULE_16__util_DataUtils__.f)(prev.size, entry.size);
                            return _extends({}, entry, {
                                cx: interpolatorCx(t),
                                cy: interpolatorCy(t),
                                size: interpolatorSize(t)
                            });
                        }
                        var interpolator = Object(__WEBPACK_IMPORTED_MODULE_16__util_DataUtils__.f)(0, entry.size);
                        return _extends({}, entry, {
                            size: interpolator(t)
                        });
                    });
                    return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, null, _this3.renderSymbolsStatically(stepData));
                });
            }
        }, {
            key: "renderSymbols",
            value: function() {
                var _props4 = this.props, points = _props4.points, isAnimationActive = _props4.isAnimationActive, prevPoints = this.state.prevPoints;
                return !(isAnimationActive && points && points.length) || prevPoints && __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default()(prevPoints, points) ? this.renderSymbolsStatically(points) : this.renderSymbolsWithAnimation();
            }
        }, {
            key: "renderErrorBar",
            value: function() {
                function dataPointFormatterY(dataPoint, dataKey) {
                    return {
                        x: dataPoint.cx,
                        y: dataPoint.cy,
                        value: dataPoint.y,
                        errorVal: Object(__WEBPACK_IMPORTED_MODULE_17__util_ChartUtils__.w)(dataPoint, dataKey)
                    };
                }
                function dataPointFormatterX(dataPoint, dataKey) {
                    return {
                        x: dataPoint.cx,
                        y: dataPoint.cy,
                        value: dataPoint.x,
                        errorVal: Object(__WEBPACK_IMPORTED_MODULE_17__util_ChartUtils__.w)(dataPoint, dataKey)
                    };
                }
                if (this.props.isAnimationActive && !this.state.isAnimationFinished) return null;
                var _props5 = this.props, points = _props5.points, xAxis = _props5.xAxis, yAxis = _props5.yAxis, children = _props5.children, errorBarItems = Object(__WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__.h)(children, __WEBPACK_IMPORTED_MODULE_14__ErrorBar__.a);
                return errorBarItems ? errorBarItems.map(function(item, i) {
                    var direction = item.props.direction;
                    return __WEBPACK_IMPORTED_MODULE_3_react___default.a.cloneElement(item, {
                        key: i,
                        data: points,
                        xAxis: xAxis,
                        yAxis: yAxis,
                        layout: "x" === direction ? "vertical" : "horizontal",
                        dataPointFormatter: "x" === direction ? dataPointFormatterX : dataPointFormatterY
                    });
                }) : null;
            }
        }, {
            key: "renderLine",
            value: function() {
                var _props6 = this.props, points = _props6.points, line = _props6.line, lineType = _props6.lineType, lineJointType = _props6.lineJointType, scatterProps = Object(__WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__.k)(this.props), customLineProps = Object(__WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__.k)(line), linePoints = void 0, lineItem = void 0;
                if ("joint" === lineType) linePoints = points.map(function(entry) {
                    return {
                        x: entry.cx,
                        y: entry.cy
                    };
                }); else if ("fitting" === lineType) {
                    var _getLinearRegression = Object(__WEBPACK_IMPORTED_MODULE_16__util_DataUtils__.c)(points), xmin = _getLinearRegression.xmin, xmax = _getLinearRegression.xmax, a = _getLinearRegression.a, b = _getLinearRegression.b, linearExp = function(x) {
                        return a * x + b;
                    };
                    linePoints = [ {
                        x: xmin,
                        y: linearExp(xmin)
                    }, {
                        x: xmax,
                        y: linearExp(xmax)
                    } ];
                }
                var lineProps = _extends({}, scatterProps, {
                    fill: "none",
                    stroke: scatterProps && scatterProps.fill
                }, customLineProps, {
                    points: linePoints
                });
                return lineItem = __WEBPACK_IMPORTED_MODULE_3_react___default.a.isValidElement(line) ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.cloneElement(line, lineProps) : __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(line) ? line(lineProps) : __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_12__shape_Curve__.a, _extends({}, lineProps, {
                    type: lineJointType
                })), __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    className: "recharts-scatter-line",
                    key: "recharts-scatter-line"
                }, lineItem);
            }
        }, {
            key: "render",
            value: function() {
                var _props7 = this.props, hide = _props7.hide, points = _props7.points, line = _props7.line, className = _props7.className, xAxis = _props7.xAxis, yAxis = _props7.yAxis, left = _props7.left, top = _props7.top, width = _props7.width, height = _props7.height, id = _props7.id;
                if (hide || !points || !points.length) return null;
                var _state = this.state, isAnimationActive = _state.isAnimationActive, isAnimationFinished = _state.isAnimationFinished, layerClass = __WEBPACK_IMPORTED_MODULE_6_classnames___default()("recharts-scatter", className), needClip = xAxis && xAxis.allowDataOverflow || yAxis && yAxis.allowDataOverflow, clipPathId = __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(id) ? this.id : id;
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    className: layerClass,
                    clipPath: needClip ? "url(#clipPath-" + clipPathId + ")" : null
                }, needClip ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("defs", null, __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("clipPath", {
                    id: "clipPath-" + clipPathId
                }, __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement("rect", {
                    x: left,
                    y: top,
                    width: width,
                    height: height
                }))) : null, line && this.renderLine(), this.renderErrorBar(), __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    key: "recharts-scatter-symbols"
                }, this.renderSymbols()), (!isAnimationActive || isAnimationFinished) && __WEBPACK_IMPORTED_MODULE_9__component_LabelList__.a.renderCallByParent(this.props, points));
            }
        } ]), Scatter;
    }(__WEBPACK_IMPORTED_MODULE_3_react__.Component), _class2.displayName = "Scatter", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__.a, __WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__.c, {
        xAxisId: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        yAxisId: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        zAxisId: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        line: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element ]),
        lineType: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "fitting", "joint" ]),
        lineJointType: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "basis", "basisClosed", "basisOpen", "linear", "linearClosed", "natural", "monotoneX", "monotoneY", "monotone", "step", "stepBefore", "stepAfter" ]), __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func ]),
        legendType: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf(__WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__.b),
        className: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string,
        name: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        activeIndex: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        activeShape: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element ]),
        shape: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "circle", "cross", "diamond", "square", "star", "triangle", "wye" ]), __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func ]),
        points: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.shape({
            cx: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
            cy: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
            size: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
            node: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.shape({
                x: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string ]),
                y: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string ]),
                z: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string ])
            }),
            payload: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.any
        })),
        hide: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool,
        isAnimationActive: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool,
        animationId: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        animationBegin: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        animationDuration: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        animationEasing: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "ease", "ease-in", "ease-out", "ease-in-out", "linear" ])
    }), _class2.defaultProps = {
        xAxisId: 0,
        yAxisId: 0,
        zAxisId: 0,
        legendType: "circle",
        lineType: "joint",
        lineJointType: "linear",
        data: [],
        shape: "circle",
        hide: !1,
        isAnimationActive: !Object(__WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__.n)(),
        animationBegin: 0,
        animationDuration: 400,
        animationEasing: "linear"
    }, _class2.getComposedData = function(_ref3) {
        var xAxis = _ref3.xAxis, yAxis = _ref3.yAxis, zAxis = _ref3.zAxis, item = _ref3.item, displayedData = _ref3.displayedData, onItemMouseLeave = _ref3.onItemMouseLeave, onItemMouseEnter = _ref3.onItemMouseEnter, offset = _ref3.offset, xAxisTicks = _ref3.xAxisTicks, cells = Object(__WEBPACK_IMPORTED_MODULE_10__util_ReactUtils__.h)(item.props.children, __WEBPACK_IMPORTED_MODULE_15__component_Cell__.a), xAxisDataKey = __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(xAxis.dataKey) ? item.props.dataKey : xAxis.dataKey, yAxisDataKey = __WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(yAxis.dataKey) ? item.props.dataKey : yAxis.dataKey, zAxisDataKey = zAxis && zAxis.dataKey, defaultRangeZ = zAxis ? zAxis.range : __WEBPACK_IMPORTED_MODULE_11__ZAxis__.a.defaultProps.range, defaultZ = defaultRangeZ && defaultRangeZ[0], xBandSize = xAxis.scale.bandwidth ? xAxis.scale.bandwidth() : 0, yBandSize = yAxis.scale.bandwidth ? yAxis.scale.bandwidth() : 0, points = displayedData.map(function(entry, index) {
            var x = entry[xAxisDataKey], y = entry[yAxisDataKey], z = !__WEBPACK_IMPORTED_MODULE_2_lodash_isNil___default()(zAxisDataKey) && entry[zAxisDataKey] || "-", tooltipPayload = [ {
                name: xAxis.name || xAxis.dataKey,
                unit: xAxis.unit || "",
                value: x,
                payload: entry
            }, {
                name: yAxis.name || yAxis.dataKey,
                unit: yAxis.unit || "",
                value: y,
                payload: entry
            } ];
            "-" !== z && tooltipPayload.push({
                name: zAxis.name || zAxis.dataKey,
                unit: zAxis.unit || "",
                value: z,
                payload: entry
            });
            var cx = Object(__WEBPACK_IMPORTED_MODULE_17__util_ChartUtils__.l)({
                axis: xAxis,
                ticks: xAxisTicks,
                bandSize: xBandSize,
                entry: entry,
                index: index
            }), cy = Object(__WEBPACK_IMPORTED_MODULE_17__util_ChartUtils__.l)({
                axis: yAxis,
                ticks: xAxisTicks,
                bandSize: yBandSize,
                entry: entry,
                index: index
            }), size = "-" !== z ? zAxis.scale(z) : defaultZ, radius = Math.sqrt(Math.max(size, 0) / Math.PI);
            return _extends({}, entry, {
                cx: cx,
                cy: cy,
                x: cx - radius,
                y: cy - radius,
                xAxis: xAxis,
                yAxis: yAxis,
                zAxis: zAxis,
                width: 2 * radius,
                height: 2 * radius,
                size: size,
                node: {
                    x: x,
                    y: y,
                    z: z
                },
                tooltipPayload: tooltipPayload,
                tooltipPosition: {
                    x: cx,
                    y: cy
                },
                payload: entry
            }, cells && cells[index] && cells[index].props);
        });
        return _extends({
            onMouseLeave: onItemMouseLeave,
            onMouseEnter: onItemMouseEnter,
            points: points
        }, offset);
    }, _class = _temp2)) || _class;
    __webpack_exports__.a = Scatter;
}, function(module, exports, __webpack_require__) {
    "use strict";
    var canUseDOM = !("undefined" == typeof window || !window.document || !window.document.createElement), ExecutionEnvironment = {
        canUseDOM: canUseDOM,
        canUseWorkers: "undefined" != typeof Worker,
        canUseEventListeners: canUseDOM && !(!window.addEventListener && !window.attachEvent),
        canUseViewport: canUseDOM && !!window.screen,
        isInWorker: !canUseDOM
    };
    module.exports = ExecutionEnvironment;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function getActiveElement(doc) {
        if (void 0 === (doc = doc || ("undefined" != typeof document ? document : void 0))) return null;
        try {
            return doc.activeElement || doc.body;
        } catch (e) {
            return doc.body;
        }
    }
    module.exports = getActiveElement;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function containsNode(outerNode, innerNode) {
        return !(!outerNode || !innerNode) && (outerNode === innerNode || !isTextNode(outerNode) && (isTextNode(innerNode) ? containsNode(outerNode, innerNode.parentNode) : "contains" in outerNode ? outerNode.contains(innerNode) : !!outerNode.compareDocumentPosition && !!(16 & outerNode.compareDocumentPosition(innerNode))));
    }
    var isTextNode = __webpack_require__(379);
    module.exports = containsNode;
}, function(module, exports, __webpack_require__) {
    module.exports = {
        default: __webpack_require__(387),
        __esModule: !0
    };
}, function(module, exports) {
    module.exports = function(it) {
        if ("function" != typeof it) throw TypeError(it + " is not a function!");
        return it;
    };
}, function(module, exports, __webpack_require__) {
    module.exports = !__webpack_require__(25) && !__webpack_require__(53)(function() {
        return 7 != Object.defineProperty(__webpack_require__(225)("div"), "a", {
            get: function() {
                return 7;
            }
        }).a;
    });
}, function(module, exports, __webpack_require__) {
    var isObject = __webpack_require__(35), document = __webpack_require__(24).document, is = isObject(document) && isObject(document.createElement);
    module.exports = function(it) {
        return is ? document.createElement(it) : {};
    };
}, function(module, exports, __webpack_require__) {
    var has = __webpack_require__(54), toIObject = __webpack_require__(64), arrayIndexOf = __webpack_require__(390)(!1), IE_PROTO = __webpack_require__(150)("IE_PROTO");
    module.exports = function(object, names) {
        var key, O = toIObject(object), i = 0, result = [];
        for (key in O) key != IE_PROTO && has(O, key) && result.push(key);
        for (;names.length > i; ) has(O, key = names[i++]) && (~arrayIndexOf(result, key) || result.push(key));
        return result;
    };
}, function(module, exports, __webpack_require__) {
    var has = __webpack_require__(54), toObject = __webpack_require__(65), IE_PROTO = __webpack_require__(150)("IE_PROTO"), ObjectProto = Object.prototype;
    module.exports = Object.getPrototypeOf || function(O) {
        return O = toObject(O), has(O, IE_PROTO) ? O[IE_PROTO] : "function" == typeof O.constructor && O instanceof O.constructor ? O.constructor.prototype : O instanceof Object ? ObjectProto : null;
    };
}, function(module, exports, __webpack_require__) {
    var $export = __webpack_require__(19), core = __webpack_require__(17), fails = __webpack_require__(53);
    module.exports = function(KEY, exec) {
        var fn = (core.Object || {})[KEY] || Object[KEY], exp = {};
        exp[KEY] = exec(fn), $export($export.S + $export.F * fails(function() {
            fn(1);
        }), "Object", exp);
    };
}, function(module, exports, __webpack_require__) {
    module.exports = __webpack_require__(39);
}, function(module, exports, __webpack_require__) {
    __webpack_require__(402);
    for (var global = __webpack_require__(24), hide = __webpack_require__(39), Iterators = __webpack_require__(77), TO_STRING_TAG = __webpack_require__(21)("toStringTag"), DOMIterables = "CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,TextTrackList,TouchList".split(","), i = 0; i < DOMIterables.length; i++) {
        var NAME = DOMIterables[i], Collection = global[NAME], proto = Collection && Collection.prototype;
        proto && !proto[TO_STRING_TAG] && hide(proto, TO_STRING_TAG, NAME), Iterators[NAME] = Iterators.Array;
    }
}, function(module, exports) {
    module.exports = function(done, value) {
        return {
            value: value,
            done: !!done
        };
    };
}, function(module, exports, __webpack_require__) {
    var cof = __webpack_require__(147);
    module.exports = Array.isArray || function(arg) {
        return "Array" == cof(arg);
    };
}, function(module, exports, __webpack_require__) {
    var $keys = __webpack_require__(226), hiddenKeys = __webpack_require__(152).concat("length", "prototype");
    exports.f = Object.getOwnPropertyNames || function(O) {
        return $keys(O, hiddenKeys);
    };
}, function(module, exports, __webpack_require__) {
    var pIE = __webpack_require__(104), createDesc = __webpack_require__(75), toIObject = __webpack_require__(64), toPrimitive = __webpack_require__(145), has = __webpack_require__(54), IE8_DOM_DEFINE = __webpack_require__(224), gOPD = Object.getOwnPropertyDescriptor;
    exports.f = __webpack_require__(25) ? gOPD : function(O, P) {
        if (O = toIObject(O), P = toPrimitive(P, !0), IE8_DOM_DEFINE) try {
            return gOPD(O, P);
        } catch (e) {}
        if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);
    };
}, function(module, exports) {}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    function exactProp(propTypes, componentNameInError) {
        return (0, _extends4.default)({}, propTypes, (0, _defineProperty3.default)({}, specialProperty, function(props) {
            var unknownProps = (0, _keys2.default)(props).filter(function(prop) {
                return !propTypes.hasOwnProperty(prop);
            });
            return unknownProps.length > 0 ? new TypeError(componentNameInError + ": unknown props found: " + unknownProps.join(", ") + ". Please remove the unknown properties.") : null;
        }));
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.specialProperty = void 0;
    var _defineProperty2 = __webpack_require__(12), _defineProperty3 = _interopRequireDefault(_defineProperty2), _keys = __webpack_require__(55), _keys2 = _interopRequireDefault(_keys), _extends3 = __webpack_require__(6), _extends4 = _interopRequireDefault(_extends3);
    exports.default = exactProp;
    var specialProperty = exports.specialProperty = "exact-prop: ​";
}, function(module, exports, __webpack_require__) {
    var hide = __webpack_require__(39);
    module.exports = function(target, src, safe) {
        for (var key in src) safe && target[key] ? target[key] = src[key] : hide(target, key, src[key]);
        return target;
    };
}, function(module, exports) {
    module.exports = function(it, Constructor, name, forbiddenField) {
        if (!(it instanceof Constructor) || void 0 !== forbiddenField && forbiddenField in it) throw TypeError(name + ": incorrect invocation!");
        return it;
    };
}, function(module, exports, __webpack_require__) {
    var anObject = __webpack_require__(52);
    module.exports = function(iterator, fn, value, entries) {
        try {
            return entries ? fn(anObject(value)[0], value[1]) : fn(value);
        } catch (e) {
            var ret = iterator.return;
            throw void 0 !== ret && anObject(ret.call(iterator)), e;
        }
    };
}, function(module, exports, __webpack_require__) {
    var Iterators = __webpack_require__(77), ITERATOR = __webpack_require__(21)("iterator"), ArrayProto = Array.prototype;
    module.exports = function(it) {
        return void 0 !== it && (Iterators.Array === it || ArrayProto[ITERATOR] === it);
    };
}, function(module, exports, __webpack_require__) {
    var classof = __webpack_require__(242), ITERATOR = __webpack_require__(21)("iterator"), Iterators = __webpack_require__(77);
    module.exports = __webpack_require__(17).getIteratorMethod = function(it) {
        if (void 0 != it) return it[ITERATOR] || it["@@iterator"] || Iterators[classof(it)];
    };
}, function(module, exports, __webpack_require__) {
    var cof = __webpack_require__(147), TAG = __webpack_require__(21)("toStringTag"), ARG = "Arguments" == cof(function() {
        return arguments;
    }()), tryGet = function(it, key) {
        try {
            return it[key];
        } catch (e) {}
    };
    module.exports = function(it) {
        var O, T, B;
        return void 0 === it ? "Undefined" : null === it ? "Null" : "string" == typeof (T = tryGet(O = Object(it), TAG)) ? T : ARG ? cof(O) : "Object" == (B = cof(O)) && "function" == typeof O.callee ? "Arguments" : B;
    };
}, function(module, exports, __webpack_require__) {
    var isObject = __webpack_require__(35);
    module.exports = function(it, TYPE) {
        if (!isObject(it) || it._t !== TYPE) throw TypeError("Incompatible receiver, " + TYPE + " required!");
        return it;
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    exports.__esModule = !0;
    var getDisplayName = function(Component) {
        if ("string" == typeof Component) return Component;
        if (Component) return Component.displayName || Component.name || "Component";
    };
    exports.default = getDisplayName;
}, function(module, exports, __webpack_require__) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    exports.jss = "64a55d578f856d258dc345b094a2a2b3", exports.sheetsRegistry = "d4bd0baacbc52bbd48bbb9eb24344ecd", 
    exports.managers = "b768b78919504fba9de2c03545c5cd3a", exports.sheetOptions = "6fc570d6bd61383819d0f9e7407c452d";
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.create = exports.createGenerateClassName = exports.sheets = exports.RuleList = exports.SheetsManager = exports.SheetsRegistry = exports.toCssValue = exports.getDynamicStyles = void 0;
    var _getDynamicStyles = __webpack_require__(461);
    Object.defineProperty(exports, "getDynamicStyles", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_getDynamicStyles).default;
        }
    });
    var _toCssValue = __webpack_require__(110);
    Object.defineProperty(exports, "toCssValue", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_toCssValue).default;
        }
    });
    var _SheetsRegistry = __webpack_require__(247);
    Object.defineProperty(exports, "SheetsRegistry", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_SheetsRegistry).default;
        }
    });
    var _SheetsManager = __webpack_require__(462);
    Object.defineProperty(exports, "SheetsManager", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_SheetsManager).default;
        }
    });
    var _RuleList = __webpack_require__(80);
    Object.defineProperty(exports, "RuleList", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_RuleList).default;
        }
    });
    var _sheets = __webpack_require__(164);
    Object.defineProperty(exports, "sheets", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_sheets).default;
        }
    });
    var _createGenerateClassName = __webpack_require__(250);
    Object.defineProperty(exports, "createGenerateClassName", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_createGenerateClassName).default;
        }
    });
    var _Jss = __webpack_require__(469), _Jss2 = _interopRequireDefault(_Jss), create = exports.create = function(options) {
        return new _Jss2.default(options);
    };
    exports.default = create();
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), SheetsRegistry = function() {
        function SheetsRegistry() {
            _classCallCheck(this, SheetsRegistry), this.registry = [];
        }
        return _createClass(SheetsRegistry, [ {
            key: "add",
            value: function(sheet) {
                var registry = this.registry, index = sheet.options.index;
                if (-1 === registry.indexOf(sheet)) {
                    if (0 === registry.length || index >= this.index) return void registry.push(sheet);
                    for (var i = 0; i < registry.length; i++) if (registry[i].options.index > index) return void registry.splice(i, 0, sheet);
                }
            }
        }, {
            key: "reset",
            value: function() {
                this.registry = [];
            }
        }, {
            key: "remove",
            value: function(sheet) {
                var index = this.registry.indexOf(sheet);
                this.registry.splice(index, 1);
            }
        }, {
            key: "toString",
            value: function(options) {
                return this.registry.filter(function(sheet) {
                    return sheet.attached;
                }).map(function(sheet) {
                    return sheet.toString(options);
                }).join("\n");
            }
        }, {
            key: "index",
            get: function() {
                return 0 === this.registry.length ? 0 : this.registry[this.registry.length - 1].options.index;
            }
        } ]), SheetsRegistry;
    }();
    exports.default = SheetsRegistry;
}, function(module, exports, __webpack_require__) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _symbolObservable = __webpack_require__(464), _symbolObservable2 = function(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }(_symbolObservable);
    exports.default = function(value) {
        return value && value[_symbolObservable2.default] && value === value[_symbolObservable2.default]();
    };
}, function(module, exports, __webpack_require__) {
    "use strict";
    function linkRule(rule, cssRule) {
        rule.renderable = cssRule, rule.rules && cssRule.cssRules && rule.rules.link(cssRule.cssRules);
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.default = linkRule;
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }
        Object.defineProperty(exports, "__esModule", {
            value: !0
        });
        var _warning = __webpack_require__(11), _warning2 = _interopRequireDefault(_warning), _StyleSheet = __webpack_require__(251), _moduleId = (_interopRequireDefault(_StyleSheet), 
        __webpack_require__(468)), _moduleId2 = _interopRequireDefault(_moduleId), env = process.env.NODE_ENV;
        exports.default = function() {
            var ruleCounter = 0, defaultPrefix = "production" === env ? "c" : "";
            return function(rule, sheet) {
                (ruleCounter += 1) > 1e10 && (0, _warning2.default)(!1, "[JSS] You might have a memory leak. Rule counter is at %s.", ruleCounter);
                var prefix = defaultPrefix, jssId = "";
                return sheet && (prefix = sheet.options.classNamePrefix || defaultPrefix, null != sheet.options.jss.id && (jssId += sheet.options.jss.id)), 
                "production" === env ? "" + prefix + _moduleId2.default + jssId + ruleCounter : prefix + rule.key + "-" + _moduleId2.default + (jssId && "-" + jssId) + "-" + ruleCounter;
            };
        };
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), _linkRule = __webpack_require__(249), _linkRule2 = _interopRequireDefault(_linkRule), _RuleList = __webpack_require__(80), _RuleList2 = _interopRequireDefault(_RuleList), StyleSheet = function() {
        function StyleSheet(styles, options) {
            _classCallCheck(this, StyleSheet), this.attached = !1, this.deployed = !1, this.linked = !1, 
            this.classes = {}, this.options = _extends({}, options, {
                sheet: this,
                parent: this,
                classes: this.classes
            }), this.renderer = new options.Renderer(this), this.rules = new _RuleList2.default(this.options);
            for (var name in styles) this.rules.add(name, styles[name]);
            this.rules.process();
        }
        return _createClass(StyleSheet, [ {
            key: "attach",
            value: function() {
                return this.attached ? this : (this.deployed || this.deploy(), this.renderer.attach(), 
                !this.linked && this.options.link && this.link(), this.attached = !0, this);
            }
        }, {
            key: "detach",
            value: function() {
                return this.attached ? (this.renderer.detach(), this.attached = !1, this) : this;
            }
        }, {
            key: "addRule",
            value: function(name, decl, options) {
                var queue = this.queue;
                this.attached && !queue && (this.queue = []);
                var rule = this.rules.add(name, decl, options);
                return this.options.jss.plugins.onProcessRule(rule), this.attached ? this.deployed ? (queue ? queue.push(rule) : (this.insertRule(rule), 
                this.queue && (this.queue.forEach(this.insertRule, this), this.queue = void 0)), 
                rule) : rule : (this.deployed = !1, rule);
            }
        }, {
            key: "insertRule",
            value: function(rule) {
                var renderable = this.renderer.insertRule(rule);
                renderable && this.options.link && (0, _linkRule2.default)(rule, renderable);
            }
        }, {
            key: "addRules",
            value: function(styles, options) {
                var added = [];
                for (var name in styles) added.push(this.addRule(name, styles[name], options));
                return added;
            }
        }, {
            key: "getRule",
            value: function(name) {
                return this.rules.get(name);
            }
        }, {
            key: "deleteRule",
            value: function(name) {
                var rule = this.rules.get(name);
                return !!rule && (this.rules.remove(rule), !this.attached || !rule.renderable || this.renderer.deleteRule(rule.renderable));
            }
        }, {
            key: "indexOf",
            value: function(rule) {
                return this.rules.indexOf(rule);
            }
        }, {
            key: "deploy",
            value: function() {
                return this.renderer.deploy(), this.deployed = !0, this;
            }
        }, {
            key: "link",
            value: function() {
                var cssRules = this.renderer.getRules();
                return cssRules && this.rules.link(cssRules), this.linked = !0, this;
            }
        }, {
            key: "update",
            value: function(name, data) {
                return this.rules.update(name, data), this;
            }
        }, {
            key: "toString",
            value: function(options) {
                return this.rules.toString(options);
            }
        } ]), StyleSheet;
    }();
    exports.default = StyleSheet;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _ButtonBase = __webpack_require__(505);
    Object.defineProperty(exports, "default", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_ButtonBase).default;
        }
    });
}, function(module, exports) {
    exports = module.exports = function(searchInput) {
        if (searchInput && "object" == typeof searchInput) {
            var hasKeyCode = searchInput.which || searchInput.keyCode || searchInput.charCode;
            hasKeyCode && (searchInput = hasKeyCode);
        }
        if ("number" == typeof searchInput) return names[searchInput];
        var search = String(searchInput), foundNamedKey = codes[search.toLowerCase()];
        if (foundNamedKey) return foundNamedKey;
        var foundNamedKey = aliases[search.toLowerCase()];
        return foundNamedKey || (1 === search.length ? search.charCodeAt(0) : void 0);
    };
    var codes = exports.code = exports.codes = {
        backspace: 8,
        tab: 9,
        enter: 13,
        shift: 16,
        ctrl: 17,
        alt: 18,
        "pause/break": 19,
        "caps lock": 20,
        esc: 27,
        space: 32,
        "page up": 33,
        "page down": 34,
        end: 35,
        home: 36,
        left: 37,
        up: 38,
        right: 39,
        down: 40,
        insert: 45,
        delete: 46,
        command: 91,
        "left command": 91,
        "right command": 93,
        "numpad *": 106,
        "numpad +": 107,
        "numpad -": 109,
        "numpad .": 110,
        "numpad /": 111,
        "num lock": 144,
        "scroll lock": 145,
        "my computer": 182,
        "my calculator": 183,
        ";": 186,
        "=": 187,
        ",": 188,
        "-": 189,
        ".": 190,
        "/": 191,
        "` + "`"))) + ((`": 192,
        "[": 219,
        "\\": 220,
        "]": 221,
        "'": 222
    }, aliases = exports.aliases = {
        windows: 91,
        "⇧": 16,
        "⌥": 18,
        "⌃": 17,
        "⌘": 91,
        ctl: 17,
        control: 17,
        option: 18,
        pause: 19,
        break: 19,
        caps: 20,
        return: 13,
        escape: 27,
        spc: 32,
        pgup: 33,
        pgdn: 34,
        ins: 45,
        del: 46,
        cmd: 91
    };
    for (i = 97; i < 123; i++) codes[String.fromCharCode(i)] = i - 32;
    for (var i = 48; i < 58; i++) codes[i - 48] = i;
    for (i = 1; i < 13; i++) codes["f" + i] = i + 111;
    for (i = 0; i < 10; i++) codes["numpad " + i] = i + 96;
    var names = exports.names = exports.title = {};
    for (i in codes) names[codes[i]] = i;
    for (var alias in aliases) codes[alias] = aliases[alias];
}, function(module, exports, __webpack_require__) {
    "use strict";
    function ownerDocument(node) {
        return node && node.ownerDocument || document;
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.default = ownerDocument, module.exports = exports.default;
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }
        function _objectWithoutProperties(obj, keys) {
            var target = {};
            for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
            return target;
        }
        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
        }
        function _possibleConstructorReturn(self, call) {
            if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            return !call || "object" != typeof call && "function" != typeof call ? self : call;
        }
        function _inherits(subClass, superClass) {
            if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: !1,
                    writable: !0,
                    configurable: !0
                }
            }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
        }
        exports.__esModule = !0;
        var _extends = Object.assign || function(target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = arguments[i];
                for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
            }
            return target;
        }, _propTypes = __webpack_require__(1), _propTypes2 = _interopRequireDefault(_propTypes), _react = __webpack_require__(0), _react2 = _interopRequireDefault(_react), _ChildMapping = __webpack_require__(517), values = Object.values || function(obj) {
            return Object.keys(obj).map(function(k) {
                return obj[k];
            });
        }, propTypes = {
            component: _propTypes2.default.any,
            children: _propTypes2.default.node,
            appear: _propTypes2.default.bool,
            enter: _propTypes2.default.bool,
            exit: _propTypes2.default.bool,
            childFactory: _propTypes2.default.func
        }, defaultProps = {
            component: "div",
            childFactory: function(child) {
                return child;
            }
        }, TransitionGroup = function(_React$Component) {
            function TransitionGroup(props, context) {
                _classCallCheck(this, TransitionGroup);
                var _this = _possibleConstructorReturn(this, _React$Component.call(this, props, context));
                return _this.handleExited = function(key, node, originalHandler) {
                    var currentChildMapping = (0, _ChildMapping.getChildMapping)(_this.props.children);
                    key in currentChildMapping || (originalHandler && originalHandler(node), _this.setState(function(state) {
                        var children = _extends({}, state.children);
                        return delete children[key], {
                            children: children
                        };
                    }));
                }, _this.state = {
                    children: (0, _ChildMapping.getChildMapping)(props.children, function(child) {
                        var onExited = function(node) {
                            _this.handleExited(child.key, node, child.props.onExited);
                        };
                        return (0, _react.cloneElement)(child, {
                            onExited: onExited,
                            in: !0,
                            appear: _this.getProp(child, "appear"),
                            enter: _this.getProp(child, "enter"),
                            exit: _this.getProp(child, "exit")
                        });
                    })
                }, _this;
            }
            return _inherits(TransitionGroup, _React$Component), TransitionGroup.prototype.getChildContext = function() {
                return {
                    transitionGroup: {
                        isMounting: !this.appeared
                    }
                };
            }, TransitionGroup.prototype.getProp = function(child, prop) {
                var props = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : this.props;
                return null != props[prop] ? props[prop] : child.props[prop];
            }, TransitionGroup.prototype.componentDidMount = function() {
                this.appeared = !0;
            }, TransitionGroup.prototype.componentWillReceiveProps = function(nextProps) {
                var _this2 = this, prevChildMapping = this.state.children, nextChildMapping = (0, 
                _ChildMapping.getChildMapping)(nextProps.children), children = (0, _ChildMapping.mergeChildMappings)(prevChildMapping, nextChildMapping);
                Object.keys(children).forEach(function(key) {
                    var child = children[key];
                    if ((0, _react.isValidElement)(child)) {
                        var onExited = function(node) {
                            _this2.handleExited(child.key, node, child.props.onExited);
                        }, hasPrev = key in prevChildMapping, hasNext = key in nextChildMapping, prevChild = prevChildMapping[key], isLeaving = (0, 
                        _react.isValidElement)(prevChild) && !prevChild.props.in;
                        !hasNext || hasPrev && !isLeaving ? hasNext || !hasPrev || isLeaving ? hasNext && hasPrev && (0, 
                        _react.isValidElement)(prevChild) && (children[key] = (0, _react.cloneElement)(child, {
                            onExited: onExited,
                            in: prevChild.props.in,
                            exit: _this2.getProp(child, "exit", nextProps),
                            enter: _this2.getProp(child, "enter", nextProps)
                        })) : children[key] = (0, _react.cloneElement)(child, {
                            in: !1
                        }) : children[key] = (0, _react.cloneElement)(child, {
                            onExited: onExited,
                            in: !0,
                            exit: _this2.getProp(child, "exit", nextProps),
                            enter: _this2.getProp(child, "enter", nextProps)
                        });
                    }
                }), this.setState({
                    children: children
                });
            }, TransitionGroup.prototype.render = function() {
                var _props = this.props, Component = _props.component, childFactory = _props.childFactory, props = _objectWithoutProperties(_props, [ "component", "childFactory" ]), children = this.state.children;
                return delete props.appear, delete props.enter, delete props.exit, _react2.default.createElement(Component, props, values(children).map(childFactory));
            }, TransitionGroup;
        }(_react2.default.Component);
        TransitionGroup.childContextTypes = {
            transitionGroup: _propTypes2.default.object.isRequired
        }, TransitionGroup.propTypes = "production" !== process.env.NODE_ENV ? propTypes : {}, 
        TransitionGroup.defaultProps = defaultProps, exports.default = TransitionGroup, 
        module.exports = exports.default;
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    function cloneChildrenWithClassName(children, className) {
        return _react2.default.Children.map(children, function(child) {
            return _react2.default.isValidElement(child) && _react2.default.cloneElement(child, {
                className: (0, _classnames2.default)(child.props.className, className)
            });
        });
    }
    function isMuiElement(element, muiNames) {
        return _react2.default.isValidElement(element) && -1 !== muiNames.indexOf(element.type.muiName);
    }
    function isMuiComponent(element, muiNames) {
        return -1 !== muiNames.indexOf(element.muiName);
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.cloneChildrenWithClassName = cloneChildrenWithClassName, exports.isMuiElement = isMuiElement, 
    exports.isMuiComponent = isMuiComponent;
    var _react = __webpack_require__(0), _react2 = _interopRequireDefault(_react), _classnames = __webpack_require__(3), _classnames2 = _interopRequireDefault(_classnames);
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _SvgIcon = __webpack_require__(521);
    Object.defineProperty(exports, "default", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_SvgIcon).default;
        }
    });
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _Icon = __webpack_require__(522);
    Object.defineProperty(exports, "default", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_Icon).default;
        }
    });
}, function(module, exports, __webpack_require__) {
    "use strict";
    exports.__esModule = !0;
    var _setStatic = __webpack_require__(526), _setStatic2 = function(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }(_setStatic), setDisplayName = function(displayName) {
        return (0, _setStatic2.default)("displayName", displayName);
    };
    exports.default = setDisplayName;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _List = __webpack_require__(531);
    Object.defineProperty(exports, "default", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_List).default;
        }
    });
    var _ListItem = __webpack_require__(532);
    Object.defineProperty(exports, "ListItem", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_ListItem).default;
        }
    });
    var _ListItemAvatar = __webpack_require__(533);
    Object.defineProperty(exports, "ListItemAvatar", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_ListItemAvatar).default;
        }
    });
    var _ListItemText = __webpack_require__(534);
    Object.defineProperty(exports, "ListItemText", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_ListItemText).default;
        }
    });
    var _ListItemIcon = __webpack_require__(535);
    Object.defineProperty(exports, "ListItemIcon", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_ListItemIcon).default;
        }
    });
    var _ListItemSecondaryAction = __webpack_require__(536);
    Object.defineProperty(exports, "ListItemSecondaryAction", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_ListItemSecondaryAction).default;
        }
    });
    var _ListSubheader = __webpack_require__(537);
    Object.defineProperty(exports, "ListSubheader", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_ListSubheader).default;
        }
    });
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.inserter = void 0;
    var _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), _react = __webpack_require__(0), _react2 = _interopRequireDefault(_react), _List = __webpack_require__(260), _List2 = _interopRequireDefault(_List), _escapeHtml = __webpack_require__(550), _escapeHtml2 = _interopRequireDefault(_escapeHtml), requestBand = .05, fieldPadding = new Map(), createChunk = function(records) {
        var content = "";
        return records.forEach(function(record) {
            var t = record.t, ctx = record.ctx, lvl = record.lvl, msg = record.msg, color = "#ce3c23";
            switch (lvl) {
              case "trace":
              case "trce":
                lvl = "TRACE", color = "#3465a4";
                break;

              case "debug":
              case "dbug":
                lvl = "DEBUG", color = "#3d989b";
                break;

              case "info":
                lvl = "INFO&nbsp;", color = "#4c8f0f";
                break;

              case "warn":
                lvl = "WARN&nbsp;", color = "#b79a22";
                break;

              case "error":
              case "eror":
                lvl = "ERROR", color = "#754b70";
                break;

              case "crit":
                lvl = "CRIT&nbsp;", color = "#ce3c23";
                break;

              default:
                lvl = "";
            }
            var time = new Date(t);
            if ("" === lvl || !(time instanceof Date) || isNaN(time) || "string" != typeof msg || !Array.isArray(ctx)) return void (content += '<span style="color:#ce3c23">Invalid log record</span><br />');
            ctx.length > 0 && (msg += "&nbsp;".repeat(Math.max(40 - msg.length, 0)));
            var month = ("0" + (time.getMonth() + 1)).slice(-2), date = ("0" + time.getDate()).slice(-2), hours = ("0" + time.getHours()).slice(-2), minutes = ("0" + time.getMinutes()).slice(-2), seconds = ("0" + time.getSeconds()).slice(-2);
            content += '<span style="color:' + color + '">' + lvl + "</span>[" + month + "-" + date + "|" + hours + ":" + minutes + ":" + seconds + "] " + msg;
            for (var i = 0; i < ctx.length; i += 2) {
                var key = (0, _escapeHtml2.default)(ctx[i]), val = (0, _escapeHtml2.default)(ctx[i + 1]), padding = fieldPadding.get(key);
                ("number" != typeof padding || padding < val.length) && (padding = val.length, fieldPadding.set(key, padding));
                var p = "";
                i < ctx.length - 2 && (p = "&nbsp;".repeat(padding - val.length)), content += ' <span style="color:' + color + '">' + key + "</span>=" + val + p;
            }
            content += "<br />";
        }), content;
    }, ADDED = 1, REMOVED = -1, styles = (exports.inserter = function(limit) {
        return function(update, prev) {
            if (prev.topChanged = 0, prev.bottomChanged = 0, !Array.isArray(update.chunk) || update.chunk.length < 1) return prev;
            Array.isArray(prev.chunks) || (prev.chunks = []);
            var content = createChunk(update.chunk);
            if (!update.source) return prev.endBottom ? prev.chunks.length < 1 ? [ {
                content: content,
                name: "00000000000000.log"
            } ] : (prev.chunks[prev.chunks.length - 1].content += content, prev.bottomChanged = ADDED, 
            prev) : prev;
            var chunk = {
                content: content,
                name: update.source.name
            };
            return prev.chunks.length > 0 && update.source.name < prev.chunks[0].name ? (update.source.last && (prev.endTop = !0), 
            prev.chunks.length >= limit && (prev.endBottom = !1, prev.chunks.splice(limit - 1, prev.chunks.length - limit + 1), 
            prev.bottomChanged = REMOVED), prev.chunks = [ chunk ].concat(_toConsumableArray(prev.chunks)), 
            prev.topChanged = ADDED, prev) : (update.source.last && (prev.endBottom = !0), prev.chunks.length >= limit && (prev.endTop = !1, 
            prev.chunks.splice(0, prev.chunks.length - limit + 1), prev.topChanged = REMOVED), 
            prev.chunks = [].concat(_toConsumableArray(prev.chunks), [ chunk ]), prev.bottomChanged = ADDED, 
            prev);
        };
    }, {
        logListItem: {
            padding: 0,
            lineHeight: 1.231
        },
        logChunk: {
            color: "white",
            fontFamily: "monospace",
            whiteSpace: "nowrap",
            width: 0
        },
        waitMsg: {
            textAlign: "center",
            color: "white",
            fontFamily: "monospace"
        }
    }), Logs = function(_Component) {
        function Logs(props) {
            _classCallCheck(this, Logs);
            var _this = _possibleConstructorReturn(this, (Logs.__proto__ || Object.getPrototypeOf(Logs)).call(this, props));
            return _this.onScroll = function() {
                if (_this.state.requestAllowed && void 0 !== _this.content) {
                    var logs = _this.props.content.logs;
                    logs.chunks.length < 1 || (_this.atTop() && !logs.endTop ? _this.sendRequest(logs.chunks[0].name, !0) : _this.atBottom() && !logs.endBottom && _this.sendRequest(logs.chunks[logs.chunks.length - 1].name, !1));
                }
            }, _this.sendRequest = function(name, past) {
                _this.setState({
                    requestAllowed: !1
                }), _this.props.send(JSON.stringify({
                    Logs: {
                        Name: name,
                        Past: past
                    }
                }));
            }, _this.atTop = function() {
                return _this.props.container.scrollTop <= _this.props.container.scrollHeight * requestBand;
            }, _this.atBottom = function() {
                var container = _this.props.container;
                return container.scrollHeight - container.scrollTop <= container.clientHeight + container.scrollHeight * requestBand;
            }, _this.beforeUpdate = function() {
                var firstHeight = 0, chunkList = _this.content.children[1];
                return chunkList && chunkList.children[0] && (firstHeight = chunkList.children[0].clientHeight), 
                {
                    scrollTop: _this.props.container.scrollTop,
                    firstHeight: firstHeight
                };
            }, _this.didUpdate = function(prevProps, prevState, snapshot) {
                if (void 0 !== _this.props.shouldUpdate.logs && void 0 !== _this.content && null !== snapshot) {
                    var logs = _this.props.content.logs, container = _this.props.container;
                    if (!(void 0 === container || logs.chunks.length < 1)) {
                        if (_this.content.clientHeight < container.clientHeight) return void (logs.endTop || _this.sendRequest(logs.chunks[0].name, !0));
                        var scrollTop = snapshot.scrollTop;
                        logs.topChanged === ADDED ? scrollTop += _this.content.children[1].children[0].clientHeight : logs.bottomChanged === ADDED && (logs.topChanged === REMOVED ? scrollTop -= snapshot.firstHeight : _this.atBottom() && logs.endBottom && (scrollTop = container.scrollHeight - container.clientHeight)), 
                        container.scrollTop = scrollTop, _this.setState({
                            requestAllowed: !0
                        });
                    }
                }
            }, _this.content = _react2.default.createRef(), _this.state = {
                requestAllowed: !0
            }, _this;
        }
        return _inherits(Logs, _Component), _createClass(Logs, [ {
            key: "componentDidMount",
            value: function() {
                var container = this.props.container;
                if (void 0 !== container) {
                    container.scrollTop = container.scrollHeight - container.clientHeight;
                    var logs = this.props.content.logs;
                    void 0 === this.content || logs.chunks.length < 1 || this.content.clientHeight < container.clientHeight && !logs.endTop && this.sendRequest(logs.chunks[0].name, !0);
                }
            }
        }, {
            key: "render",
            value: function() {
                var _this2 = this;
                return _react2.default.createElement("div", {
                    ref: function(_ref) {
                        _this2.content = _ref;
                    }
                }, _react2.default.createElement("div", {
                    style: styles.waitMsg
                }, this.props.content.logs.endTop ? "No more logs." : "Waiting for server..."), _react2.default.createElement(_List2.default, null, this.props.content.logs.chunks.map(function(c, index) {
                    return _react2.default.createElement(_List.ListItem, {
                        style: styles.logListItem,
                        key: index
                    }, _react2.default.createElement("div", {
                        style: styles.logChunk,
                        dangerouslySetInnerHTML: {
                            __html: c.content
                        }
                    }));
                })), this.props.content.logs.endBottom || _react2.default.createElement("div", {
                    style: styles.waitMsg
                }, "Waiting for server..."));
            }
        } ]), Logs;
    }(_react.Component);
    exports.default = Logs;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _Grid = __webpack_require__(552);
    Object.defineProperty(exports, "default", {
        enumerable: !0,
        get: function() {
            return _interopRequireDefault(_Grid).default;
        }
    });
}, function(module, exports) {
    function isObject(value) {
        var type = typeof value;
        return null != value && ("object" == type || "function" == type);
    }
    module.exports = isObject;
}, function(module, exports, __webpack_require__) {
    var freeGlobal = __webpack_require__(562), freeSelf = "object" == typeof self && self && self.Object === Object && self, root = freeGlobal || freeSelf || Function("return this")();
    module.exports = root;
}, function(module, exports, __webpack_require__) {
    var root = __webpack_require__(264), Symbol = root.Symbol;
    module.exports = Symbol;
}, function(module, exports, __webpack_require__) {
    var dP = __webpack_require__(575), createDesc = __webpack_require__(580);
    module.exports = __webpack_require__(170) ? function(object, key, value) {
        return dP.f(object, key, createDesc(1, value));
    } : function(object, key, value) {
        return object[key] = value, object;
    };
}, function(module, exports) {
    module.exports = Math.log1p || function(x) {
        return (x = +x) > -1e-8 && x < 1e-8 ? x - x * x / 2 : Math.log(1 + x);
    };
}, function(module, exports, __webpack_require__) {
    (function(global) {
        var freeGlobal = "object" == typeof global && global && global.Object === Object && global;
        module.exports = freeGlobal;
    }).call(exports, __webpack_require__(40));
}, function(module, exports, __webpack_require__) {
    function baseGet(object, path) {
        path = castPath(path, object);
        for (var index = 0, length = path.length; null != object && index < length; ) object = object[toKey(path[index++])];
        return index && index == length ? object : void 0;
    }
    var castPath = __webpack_require__(270), toKey = __webpack_require__(119);
    module.exports = baseGet;
}, function(module, exports, __webpack_require__) {
    function castPath(value, object) {
        return isArray(value) ? value : isKey(value, object) ? [ value ] : stringToPath(toString(value));
    }
    var isArray = __webpack_require__(13), isKey = __webpack_require__(175), stringToPath = __webpack_require__(605), toString = __webpack_require__(629);
    module.exports = castPath;
}, function(module, exports) {
    function toSource(func) {
        if (null != func) {
            try {
                return funcToString.call(func);
            } catch (e) {}
            try {
                return func + "";
            } catch (e) {}
        }
        return "";
    }
    var funcProto = Function.prototype, funcToString = funcProto.toString;
    module.exports = toSource;
}, function(module, exports, __webpack_require__) {
    function isNumber(value) {
        return "number" == typeof value || isObjectLike(value) && baseGetTag(value) == numberTag;
    }
    var baseGetTag = __webpack_require__(41), isObjectLike = __webpack_require__(42), numberTag = "[object Number]";
    module.exports = isNumber;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0_d3_path__ = __webpack_require__(84), __WEBPACK_IMPORTED_MODULE_1__constant__ = __webpack_require__(58), __WEBPACK_IMPORTED_MODULE_2__curve_linear__ = __webpack_require__(121), __WEBPACK_IMPORTED_MODULE_3__line__ = __webpack_require__(183), __WEBPACK_IMPORTED_MODULE_4__point__ = __webpack_require__(184);
    __webpack_exports__.a = function() {
        function area(data) {
            var i, j, k, d, buffer, n = data.length, defined0 = !1, x0z = new Array(n), y0z = new Array(n);
            for (null == context && (output = curve(buffer = Object(__WEBPACK_IMPORTED_MODULE_0_d3_path__.a)())), 
            i = 0; i <= n; ++i) {
                if (!(i < n && defined(d = data[i], i, data)) === defined0) if (defined0 = !defined0) j = i, 
                output.areaStart(), output.lineStart(); else {
                    for (output.lineEnd(), output.lineStart(), k = i - 1; k >= j; --k) output.point(x0z[k], y0z[k]);
                    output.lineEnd(), output.areaEnd();
                }
                defined0 && (x0z[i] = +x0(d, i, data), y0z[i] = +y0(d, i, data), output.point(x1 ? +x1(d, i, data) : x0z[i], y1 ? +y1(d, i, data) : y0z[i]));
            }
            if (buffer) return output = null, buffer + "" || null;
        }
        function arealine() {
            return Object(__WEBPACK_IMPORTED_MODULE_3__line__.a)().defined(defined).curve(curve).context(context);
        }
        var x0 = __WEBPACK_IMPORTED_MODULE_4__point__.a, x1 = null, y0 = Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(0), y1 = __WEBPACK_IMPORTED_MODULE_4__point__.b, defined = Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(!0), context = null, curve = __WEBPACK_IMPORTED_MODULE_2__curve_linear__.a, output = null;
        return area.x = function(_) {
            return arguments.length ? (x0 = "function" == typeof _ ? _ : Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(+_), 
            x1 = null, area) : x0;
        }, area.x0 = function(_) {
            return arguments.length ? (x0 = "function" == typeof _ ? _ : Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(+_), 
            area) : x0;
        }, area.x1 = function(_) {
            return arguments.length ? (x1 = null == _ ? null : "function" == typeof _ ? _ : Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(+_), 
            area) : x1;
        }, area.y = function(_) {
            return arguments.length ? (y0 = "function" == typeof _ ? _ : Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(+_), 
            y1 = null, area) : y0;
        }, area.y0 = function(_) {
            return arguments.length ? (y0 = "function" == typeof _ ? _ : Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(+_), 
            area) : y0;
        }, area.y1 = function(_) {
            return arguments.length ? (y1 = null == _ ? null : "function" == typeof _ ? _ : Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(+_), 
            area) : y1;
        }, area.lineX0 = area.lineY0 = function() {
            return arealine().x(x0).y(y0);
        }, area.lineY1 = function() {
            return arealine().x(x0).y(y1);
        }, area.lineX1 = function() {
            return arealine().x(x1).y(y0);
        }, area.defined = function(_) {
            return arguments.length ? (defined = "function" == typeof _ ? _ : Object(__WEBPACK_IMPORTED_MODULE_1__constant__.a)(!!_), 
            area) : defined;
        }, area.curve = function(_) {
            return arguments.length ? (curve = _, null != context && (output = curve(context)), 
            area) : curve;
        }, area.context = function(_) {
            return arguments.length ? (null == _ ? context = output = null : output = curve(context = _), 
            area) : context;
        }, area;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function Radial(curve) {
        this._curve = curve;
    }
    function curveRadial(curve) {
        function radial(context) {
            return new Radial(curve(context));
        }
        return radial._curve = curve, radial;
    }
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return curveRadialLinear;
    }), __webpack_exports__.b = curveRadial;
    var __WEBPACK_IMPORTED_MODULE_0__linear__ = __webpack_require__(121), curveRadialLinear = curveRadial(__WEBPACK_IMPORTED_MODULE_0__linear__.a);
    Radial.prototype = {
        areaStart: function() {
            this._curve.areaStart();
        },
        areaEnd: function() {
            this._curve.areaEnd();
        },
        lineStart: function() {
            this._curve.lineStart();
        },
        lineEnd: function() {
            this._curve.lineEnd();
        },
        point: function(a, r) {
            this._curve.point(r * Math.sin(a), r * -Math.cos(a));
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function lineRadial(l) {
        var c = l.curve;
        return l.angle = l.x, delete l.x, l.radius = l.y, delete l.y, l.curve = function(_) {
            return arguments.length ? c(Object(__WEBPACK_IMPORTED_MODULE_0__curve_radial__.b)(_)) : c()._curve;
        }, l;
    }
    __webpack_exports__.a = lineRadial;
    var __WEBPACK_IMPORTED_MODULE_0__curve_radial__ = __webpack_require__(274);
    __webpack_require__(183);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(x, y) {
        return [ (y = +y) * Math.cos(x -= Math.PI / 2), y * Math.sin(x) ];
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return slice;
    });
    var slice = Array.prototype.slice;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__math__ = __webpack_require__(85);
    __webpack_exports__.a = {
        draw: function(context, size) {
            var r = Math.sqrt(size / __WEBPACK_IMPORTED_MODULE_0__math__.j);
            context.moveTo(r, 0), context.arc(0, 0, r, 0, __WEBPACK_IMPORTED_MODULE_0__math__.m);
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = {
        draw: function(context, size) {
            var r = Math.sqrt(size / 5) / 2;
            context.moveTo(-3 * r, -r), context.lineTo(-r, -r), context.lineTo(-r, -3 * r), 
            context.lineTo(r, -3 * r), context.lineTo(r, -r), context.lineTo(3 * r, -r), context.lineTo(3 * r, r), 
            context.lineTo(r, r), context.lineTo(r, 3 * r), context.lineTo(-r, 3 * r), context.lineTo(-r, r), 
            context.lineTo(-3 * r, r), context.closePath();
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var tan30 = Math.sqrt(1 / 3), tan30_2 = 2 * tan30;
    __webpack_exports__.a = {
        draw: function(context, size) {
            var y = Math.sqrt(size / tan30_2), x = y * tan30;
            context.moveTo(0, -y), context.lineTo(x, 0), context.lineTo(0, y), context.lineTo(-x, 0), 
            context.closePath();
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__math__ = __webpack_require__(85), kr = Math.sin(__WEBPACK_IMPORTED_MODULE_0__math__.j / 10) / Math.sin(7 * __WEBPACK_IMPORTED_MODULE_0__math__.j / 10), kx = Math.sin(__WEBPACK_IMPORTED_MODULE_0__math__.m / 10) * kr, ky = -Math.cos(__WEBPACK_IMPORTED_MODULE_0__math__.m / 10) * kr;
    __webpack_exports__.a = {
        draw: function(context, size) {
            var r = Math.sqrt(.8908130915292852 * size), x = kx * r, y = ky * r;
            context.moveTo(0, -r), context.lineTo(x, y);
            for (var i = 1; i < 5; ++i) {
                var a = __WEBPACK_IMPORTED_MODULE_0__math__.m * i / 5, c = Math.cos(a), s = Math.sin(a);
                context.lineTo(s * r, -c * r), context.lineTo(c * x - s * y, s * x + c * y);
            }
            context.closePath();
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = {
        draw: function(context, size) {
            var w = Math.sqrt(size), x = -w / 2;
            context.rect(x, x, w, w);
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var sqrt3 = Math.sqrt(3);
    __webpack_exports__.a = {
        draw: function(context, size) {
            var y = -Math.sqrt(size / (3 * sqrt3));
            context.moveTo(0, 2 * y), context.lineTo(-sqrt3 * y, -y), context.lineTo(sqrt3 * y, -y), 
            context.closePath();
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var c = -.5, s = Math.sqrt(3) / 2, k = 1 / Math.sqrt(12), a = 3 * (k / 2 + 1);
    __webpack_exports__.a = {
        draw: function(context, size) {
            var r = Math.sqrt(size / a), x0 = r / 2, y0 = r * k, x1 = x0, y1 = r * k + r, x2 = -x1, y2 = y1;
            context.moveTo(x0, y0), context.lineTo(x1, y1), context.lineTo(x2, y2), context.lineTo(c * x0 - s * y0, s * x0 + c * y0), 
            context.lineTo(c * x1 - s * y1, s * x1 + c * y1), context.lineTo(c * x2 - s * y2, s * x2 + c * y2), 
            context.lineTo(c * x0 + s * y0, c * y0 - s * x0), context.lineTo(c * x1 + s * y1, c * y1 - s * x1), 
            context.lineTo(c * x2 + s * y2, c * y2 - s * x2), context.closePath();
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function CardinalClosed(context, tension) {
        this._context = context, this._k = (1 - tension) / 6;
    }
    __webpack_exports__.a = CardinalClosed;
    var __WEBPACK_IMPORTED_MODULE_0__noop__ = __webpack_require__(122), __WEBPACK_IMPORTED_MODULE_1__cardinal__ = __webpack_require__(124);
    CardinalClosed.prototype = {
        areaStart: __WEBPACK_IMPORTED_MODULE_0__noop__.a,
        areaEnd: __WEBPACK_IMPORTED_MODULE_0__noop__.a,
        lineStart: function() {
            this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN, 
            this._point = 0;
        },
        lineEnd: function() {
            switch (this._point) {
              case 1:
                this._context.moveTo(this._x3, this._y3), this._context.closePath();
                break;

              case 2:
                this._context.lineTo(this._x3, this._y3), this._context.closePath();
                break;

              case 3:
                this.point(this._x3, this._y3), this.point(this._x4, this._y4), this.point(this._x5, this._y5);
            }
        },
        point: function(x, y) {
            switch (x = +x, y = +y, this._point) {
              case 0:
                this._point = 1, this._x3 = x, this._y3 = y;
                break;

              case 1:
                this._point = 2, this._context.moveTo(this._x4 = x, this._y4 = y);
                break;

              case 2:
                this._point = 3, this._x5 = x, this._y5 = y;
                break;

              default:
                Object(__WEBPACK_IMPORTED_MODULE_1__cardinal__.b)(this, x, y);
            }
            this._x0 = this._x1, this._x1 = this._x2, this._x2 = x, this._y0 = this._y1, this._y1 = this._y2, 
            this._y2 = y;
        }
    };
    !function custom(tension) {
        function cardinal(context) {
            return new CardinalClosed(context, tension);
        }
        return cardinal.tension = function(tension) {
            return custom(+tension);
        }, cardinal;
    }(0);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function CardinalOpen(context, tension) {
        this._context = context, this._k = (1 - tension) / 6;
    }
    __webpack_exports__.a = CardinalOpen;
    var __WEBPACK_IMPORTED_MODULE_0__cardinal__ = __webpack_require__(124);
    CardinalOpen.prototype = {
        areaStart: function() {
            this._line = 0;
        },
        areaEnd: function() {
            this._line = NaN;
        },
        lineStart: function() {
            this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN, this._point = 0;
        },
        lineEnd: function() {
            (this._line || 0 !== this._line && 3 === this._point) && this._context.closePath(), 
            this._line = 1 - this._line;
        },
        point: function(x, y) {
            switch (x = +x, y = +y, this._point) {
              case 0:
                this._point = 1;
                break;

              case 1:
                this._point = 2;
                break;

              case 2:
                this._point = 3, this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
                break;

              case 3:
                this._point = 4;

              default:
                Object(__WEBPACK_IMPORTED_MODULE_0__cardinal__.b)(this, x, y);
            }
            this._x0 = this._x1, this._x1 = this._x2, this._x2 = x, this._y0 = this._y1, this._y1 = this._y2, 
            this._y2 = y;
        }
    };
    !function custom(tension) {
        function cardinal(context) {
            return new CardinalOpen(context, tension);
        }
        return cardinal.tension = function(tension) {
            return custom(+tension);
        }, cardinal;
    }(0);
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    function _defineProperty(obj, key, value) {
        return key in obj ? Object.defineProperty(obj, key, {
            value: value,
            enumerable: !0,
            configurable: !0,
            writable: !0
        }) : obj[key] = value, obj;
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var _class, _class2, _temp, _isEqual2 = __webpack_require__(288), _isEqual3 = _interopRequireDefault(_isEqual2), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), _react = __webpack_require__(0), _react2 = _interopRequireDefault(_react), _propTypes = __webpack_require__(1), _propTypes2 = _interopRequireDefault(_propTypes), _AnimateManager = __webpack_require__(713), _AnimateManager2 = _interopRequireDefault(_AnimateManager), _PureRender = __webpack_require__(716), _PureRender2 = _interopRequireDefault(_PureRender), _easing = __webpack_require__(305), _configUpdate = __webpack_require__(737), _configUpdate2 = _interopRequireDefault(_configUpdate), _util = __webpack_require__(132), Animate = (0, 
    _PureRender2.default)((_temp = _class2 = function(_Component) {
        function Animate(props, context) {
            _classCallCheck(this, Animate);
            var _this = _possibleConstructorReturn(this, (Animate.__proto__ || Object.getPrototypeOf(Animate)).call(this, props, context)), _this$props = _this.props, isActive = _this$props.isActive, attributeName = _this$props.attributeName, from = _this$props.from, to = _this$props.to, steps = _this$props.steps, children = _this$props.children;
            if (_this.handleStyleChange = _this.handleStyleChange.bind(_this), _this.changeStyle = _this.changeStyle.bind(_this), 
            !isActive) return _this.state = {
                style: {}
            }, "function" == typeof children && (_this.state = {
                style: to
            }), _possibleConstructorReturn(_this);
            if (steps && steps.length) _this.state = {
                style: steps[0].style
            }; else if (from) {
                if ("function" == typeof children) return _this.state = {
                    style: from
                }, _possibleConstructorReturn(_this);
                _this.state = {
                    style: attributeName ? _defineProperty({}, attributeName, from) : from
                };
            } else _this.state = {
                style: {}
            };
            return _this;
        }
        return _inherits(Animate, _Component), _createClass(Animate, [ {
            key: "componentDidMount",
            value: function() {
                var _props = this.props, isActive = _props.isActive, canBegin = _props.canBegin;
                this.mounted = !0, isActive && canBegin && this.runAnimation(this.props);
            }
        }, {
            key: "componentWillReceiveProps",
            value: function(nextProps) {
                var isActive = nextProps.isActive, canBegin = nextProps.canBegin, attributeName = nextProps.attributeName, shouldReAnimate = nextProps.shouldReAnimate;
                if (canBegin) {
                    if (!isActive) return void this.setState({
                        style: attributeName ? _defineProperty({}, attributeName, nextProps.to) : nextProps.to
                    });
                    if (!((0, _isEqual3.default)(this.props.to, nextProps.to) && this.props.canBegin && this.props.isActive)) {
                        var isTriggered = !this.props.canBegin || !this.props.isActive;
                        this.manager && this.manager.stop(), this.stopJSAnimation && this.stopJSAnimation();
                        var from = isTriggered || shouldReAnimate ? nextProps.from : this.props.to;
                        this.setState({
                            style: attributeName ? _defineProperty({}, attributeName, from) : from
                        }), this.runAnimation(_extends({}, nextProps, {
                            from: from,
                            begin: 0
                        }));
                    }
                }
            }
        }, {
            key: "componentWillUnmount",
            value: function() {
                this.mounted = !1, this.unSubscribe && this.unSubscribe(), this.manager && (this.manager.stop(), 
                this.manager = null), this.stopJSAnimation && this.stopJSAnimation();
            }
        }, {
            key: "runJSAnimation",
            value: function(props) {
                var _this2 = this, from = props.from, to = props.to, duration = props.duration, easing = props.easing, begin = props.begin, onAnimationEnd = props.onAnimationEnd, onAnimationStart = props.onAnimationStart, startAnimation = (0, 
                _configUpdate2.default)(from, to, (0, _easing.configEasing)(easing), duration, this.changeStyle), finalStartAnimation = function() {
                    _this2.stopJSAnimation = startAnimation();
                };
                this.manager.start([ onAnimationStart, begin, finalStartAnimation, duration, onAnimationEnd ]);
            }
        }, {
            key: "runStepAnimation",
            value: function(props) {
                var _this3 = this, steps = props.steps, begin = props.begin, onAnimationStart = props.onAnimationStart, _steps$ = steps[0], initialStyle = _steps$.style, _steps$$duration = _steps$.duration, initialTime = void 0 === _steps$$duration ? 0 : _steps$$duration, addStyle = function(sequence, nextItem, index) {
                    if (0 === index) return sequence;
                    var duration = nextItem.duration, _nextItem$easing = nextItem.easing, easing = void 0 === _nextItem$easing ? "ease" : _nextItem$easing, style = nextItem.style, nextProperties = nextItem.properties, onAnimationEnd = nextItem.onAnimationEnd, preItem = index > 0 ? steps[index - 1] : nextItem, properties = nextProperties || Object.keys(style);
                    if ("function" == typeof easing || "spring" === easing) return [].concat(_toConsumableArray(sequence), [ _this3.runJSAnimation.bind(_this3, {
                        from: preItem.style,
                        to: style,
                        duration: duration,
                        easing: easing
                    }), duration ]);
                    var transition = (0, _util.getTransitionVal)(properties, duration, easing), newStyle = _extends({}, preItem.style, style, {
                        transition: transition
                    });
                    return [].concat(_toConsumableArray(sequence), [ newStyle, duration, onAnimationEnd ]).filter(_util.identity);
                };
                return this.manager.start([ onAnimationStart ].concat(_toConsumableArray(steps.reduce(addStyle, [ initialStyle, Math.max(initialTime, begin) ])), [ props.onAnimationEnd ]));
            }
        }, {
            key: "runAnimation",
            value: function(props) {
                this.manager || (this.manager = (0, _AnimateManager2.default)());
                var begin = props.begin, duration = props.duration, attributeName = props.attributeName, propsTo = (props.from, 
                props.to), easing = props.easing, onAnimationStart = props.onAnimationStart, onAnimationEnd = props.onAnimationEnd, steps = props.steps, children = props.children, manager = this.manager;
                if (this.unSubscribe = manager.subscribe(this.handleStyleChange), "function" == typeof easing || "function" == typeof children || "spring" === easing) return void this.runJSAnimation(props);
                if (steps.length > 1) return void this.runStepAnimation(props);
                var to = attributeName ? _defineProperty({}, attributeName, propsTo) : propsTo, transition = (0, 
                _util.getTransitionVal)(Object.keys(to), duration, easing);
                manager.start([ onAnimationStart, begin, _extends({}, to, {
                    transition: transition
                }), duration, onAnimationEnd ]);
            }
        }, {
            key: "handleStyleChange",
            value: function(style) {
                this.changeStyle(style);
            }
        }, {
            key: "changeStyle",
            value: function(style) {
                this.mounted && this.setState({
                    style: style
                });
            }
        }, {
            key: "render",
            value: function() {
                var _props2 = this.props, children = _props2.children, isActive = (_props2.begin, 
                _props2.duration, _props2.attributeName, _props2.easing, _props2.isActive), others = (_props2.steps, 
                _props2.from, _props2.to, _props2.canBegin, _props2.onAnimationEnd, _props2.shouldReAnimate, 
                _props2.onAnimationReStart, _objectWithoutProperties(_props2, [ "children", "begin", "duration", "attributeName", "easing", "isActive", "steps", "from", "to", "canBegin", "onAnimationEnd", "shouldReAnimate", "onAnimationReStart" ])), count = _react.Children.count(children), stateStyle = (0, 
                _util.translateStyle)(this.state.style);
                if ("function" == typeof children) return children(stateStyle);
                if (!isActive || 0 === count) return children;
                var cloneContainer = function(container) {
                    var _container$props = container.props, _container$props$styl = _container$props.style, style = void 0 === _container$props$styl ? {} : _container$props$styl, className = _container$props.className;
                    return (0, _react.cloneElement)(container, _extends({}, others, {
                        style: _extends({}, style, stateStyle),
                        className: className
                    }));
                };
                if (1 === count) {
                    _react.Children.only(children);
                    return cloneContainer(_react.Children.only(children));
                }
                return _react2.default.createElement("div", null, _react.Children.map(children, function(child) {
                    return cloneContainer(child);
                }));
            }
        } ]), Animate;
    }(_react.Component), _class2.displayName = "Animate", _class2.propTypes = {
        from: _propTypes2.default.oneOfType([ _propTypes2.default.object, _propTypes2.default.string ]),
        to: _propTypes2.default.oneOfType([ _propTypes2.default.object, _propTypes2.default.string ]),
        attributeName: _propTypes2.default.string,
        duration: _propTypes2.default.number,
        begin: _propTypes2.default.number,
        easing: _propTypes2.default.oneOfType([ _propTypes2.default.string, _propTypes2.default.func ]),
        steps: _propTypes2.default.arrayOf(_propTypes2.default.shape({
            duration: _propTypes2.default.number.isRequired,
            style: _propTypes2.default.object.isRequired,
            easing: _propTypes2.default.oneOfType([ _propTypes2.default.oneOf([ "ease", "ease-in", "ease-out", "ease-in-out", "linear" ]), _propTypes2.default.func ]),
            properties: _propTypes2.default.arrayOf("string"),
            onAnimationEnd: _propTypes2.default.func
        })),
        children: _propTypes2.default.oneOfType([ _propTypes2.default.node, _propTypes2.default.func ]),
        isActive: _propTypes2.default.bool,
        canBegin: _propTypes2.default.bool,
        onAnimationEnd: _propTypes2.default.func,
        shouldReAnimate: _propTypes2.default.bool,
        onAnimationStart: _propTypes2.default.func,
        onAnimationReStart: _propTypes2.default.func
    }, _class2.defaultProps = {
        begin: 0,
        duration: 1e3,
        from: "",
        to: "",
        attributeName: "",
        easing: "ease",
        isActive: !0,
        canBegin: !0,
        steps: [],
        onAnimationEnd: function() {},
        onAnimationStart: function() {}
    }, _class = _temp)) || _class;
    exports.default = Animate;
}, function(module, exports, __webpack_require__) {
    function isEqual(value, other) {
        return baseIsEqual(value, other);
    }
    var baseIsEqual = __webpack_require__(187);
    module.exports = isEqual;
}, function(module, exports, __webpack_require__) {
    function Stack(entries) {
        var data = this.__data__ = new ListCache(entries);
        this.size = data.size;
    }
    var ListCache = __webpack_require__(126), stackClear = __webpack_require__(663), stackDelete = __webpack_require__(664), stackGet = __webpack_require__(665), stackHas = __webpack_require__(666), stackSet = __webpack_require__(667);
    Stack.prototype.clear = stackClear, Stack.prototype.delete = stackDelete, Stack.prototype.get = stackGet, 
    Stack.prototype.has = stackHas, Stack.prototype.set = stackSet, module.exports = Stack;
}, function(module, exports) {
    function eq(value, other) {
        return value === other || value !== value && other !== other;
    }
    module.exports = eq;
}, function(module, exports, __webpack_require__) {
    function isFunction(value) {
        if (!isObject(value)) return !1;
        var tag = baseGetTag(value);
        return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
    }
    var baseGetTag = __webpack_require__(60), isObject = __webpack_require__(189), asyncTag = "[object AsyncFunction]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
    module.exports = isFunction;
}, function(module, exports, __webpack_require__) {
    (function(global) {
        var freeGlobal = "object" == typeof global && global && global.Object === Object && global;
        module.exports = freeGlobal;
    }).call(exports, __webpack_require__(40));
}, function(module, exports) {
    function toSource(func) {
        if (null != func) {
            try {
                return funcToString.call(func);
            } catch (e) {}
            try {
                return func + "";
            } catch (e) {}
        }
        return "";
    }
    var funcProto = Function.prototype, funcToString = funcProto.toString;
    module.exports = toSource;
}, function(module, exports, __webpack_require__) {
    function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG, arrLength = array.length, othLength = other.length;
        if (arrLength != othLength && !(isPartial && othLength > arrLength)) return !1;
        var stacked = stack.get(array);
        if (stacked && stack.get(other)) return stacked == other;
        var index = -1, result = !0, seen = bitmask & COMPARE_UNORDERED_FLAG ? new SetCache() : void 0;
        for (stack.set(array, other), stack.set(other, array); ++index < arrLength; ) {
            var arrValue = array[index], othValue = other[index];
            if (customizer) var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
            if (void 0 !== compared) {
                if (compared) continue;
                result = !1;
                break;
            }
            if (seen) {
                if (!arraySome(other, function(othValue, othIndex) {
                    if (!cacheHas(seen, othIndex) && (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) return seen.push(othIndex);
                })) {
                    result = !1;
                    break;
                }
            } else if (arrValue !== othValue && !equalFunc(arrValue, othValue, bitmask, customizer, stack)) {
                result = !1;
                break;
            }
        }
        return stack.delete(array), stack.delete(other), result;
    }
    var SetCache = __webpack_require__(295), arraySome = __webpack_require__(688), cacheHas = __webpack_require__(296), COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
    module.exports = equalArrays;
}, function(module, exports, __webpack_require__) {
    function SetCache(values) {
        var index = -1, length = null == values ? 0 : values.length;
        for (this.__data__ = new MapCache(); ++index < length; ) this.add(values[index]);
    }
    var MapCache = __webpack_require__(190), setCacheAdd = __webpack_require__(686), setCacheHas = __webpack_require__(687);
    SetCache.prototype.add = SetCache.prototype.push = setCacheAdd, SetCache.prototype.has = setCacheHas, 
    module.exports = SetCache;
}, function(module, exports) {
    function cacheHas(cache, key) {
        return cache.has(key);
    }
    module.exports = cacheHas;
}, function(module, exports) {
    function arrayFilter(array, predicate) {
        for (var index = -1, length = null == array ? 0 : array.length, resIndex = 0, result = []; ++index < length; ) {
            var value = array[index];
            predicate(value, index, array) && (result[resIndex++] = value);
        }
        return result;
    }
    module.exports = arrayFilter;
}, function(module, exports, __webpack_require__) {
    var baseIsArguments = __webpack_require__(701), isObjectLike = __webpack_require__(43), objectProto = Object.prototype, hasOwnProperty = objectProto.hasOwnProperty, propertyIsEnumerable = objectProto.propertyIsEnumerable, isArguments = baseIsArguments(function() {
        return arguments;
    }()) ? baseIsArguments : function(value) {
        return isObjectLike(value) && hasOwnProperty.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
    };
    module.exports = isArguments;
}, function(module, exports, __webpack_require__) {
    (function(module) {
        var root = __webpack_require__(36), stubFalse = __webpack_require__(702), freeExports = "object" == typeof exports && exports && !exports.nodeType && exports, freeModule = freeExports && "object" == typeof module && module && !module.nodeType && module, moduleExports = freeModule && freeModule.exports === freeExports, Buffer = moduleExports ? root.Buffer : void 0, nativeIsBuffer = Buffer ? Buffer.isBuffer : void 0, isBuffer = nativeIsBuffer || stubFalse;
        module.exports = isBuffer;
    }).call(exports, __webpack_require__(131)(module));
}, function(module, exports) {
    function isIndex(value, length) {
        var type = typeof value;
        return !!(length = null == length ? MAX_SAFE_INTEGER : length) && ("number" == type || "symbol" != type && reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
    }
    var MAX_SAFE_INTEGER = 9007199254740991, reIsUint = /^(?:0|[1-9]\d*)$/;
    module.exports = isIndex;
}, function(module, exports, __webpack_require__) {
    var baseIsTypedArray = __webpack_require__(703), baseUnary = __webpack_require__(302), nodeUtil = __webpack_require__(704), nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray, isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
    module.exports = isTypedArray;
}, function(module, exports) {
    function baseUnary(func) {
        return function(value) {
            return func(value);
        };
    }
    module.exports = baseUnary;
}, function(module, exports) {
    function overArg(func, transform) {
        return function(arg) {
            return func(transform(arg));
        };
    }
    module.exports = overArg;
}, function(module, exports, __webpack_require__) {
    (function(global) {
        for (var now = __webpack_require__(715), root = "undefined" == typeof window ? global : window, vendors = [ "moz", "webkit" ], suffix = "AnimationFrame", raf = root["request" + suffix], caf = root["cancel" + suffix] || root["cancelRequest" + suffix], i = 0; !raf && i < vendors.length; i++) raf = root[vendors[i] + "Request" + suffix], 
        caf = root[vendors[i] + "Cancel" + suffix] || root[vendors[i] + "CancelRequest" + suffix];
        if (!raf || !caf) {
            var last = 0, id = 0, queue = [];
            raf = function(callback) {
                if (0 === queue.length) {
                    var _now = now(), next = Math.max(0, 1e3 / 60 - (_now - last));
                    last = next + _now, setTimeout(function() {
                        var cp = queue.slice(0);
                        queue.length = 0;
                        for (var i = 0; i < cp.length; i++) if (!cp[i].cancelled) try {
                            cp[i].callback(last);
                        } catch (e) {
                            setTimeout(function() {
                                throw e;
                            }, 0);
                        }
                    }, Math.round(next));
                }
                return queue.push({
                    handle: ++id,
                    callback: callback,
                    cancelled: !1
                }), id;
            }, caf = function(handle) {
                for (var i = 0; i < queue.length; i++) queue[i].handle === handle && (queue[i].cancelled = !0);
            };
        }
        module.exports = function(fn) {
            return raf.call(root, fn);
        }, module.exports.cancel = function() {
            caf.apply(root, arguments);
        }, module.exports.polyfill = function(object) {
            object || (object = root), object.requestAnimationFrame = raf, object.cancelAnimationFrame = caf;
        };
    }).call(exports, __webpack_require__(40));
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    }), exports.configEasing = exports.configSpring = exports.configBezier = void 0;
    var _util = __webpack_require__(132), cubicBezierFactor = function(c1, c2) {
        return [ 0, 3 * c1, 3 * c2 - 6 * c1, 3 * c1 - 3 * c2 + 1 ];
    }, multyTime = function(params, t) {
        return params.map(function(param, i) {
            return param * Math.pow(t, i);
        }).reduce(function(pre, curr) {
            return pre + curr;
        });
    }, cubicBezier = function(c1, c2) {
        return function(t) {
            var params = cubicBezierFactor(c1, c2);
            return multyTime(params, t);
        };
    }, derivativeCubicBezier = function(c1, c2) {
        return function(t) {
            var params = cubicBezierFactor(c1, c2), newParams = [].concat(_toConsumableArray(params.map(function(param, i) {
                return param * i;
            }).slice(1)), [ 0 ]);
            return multyTime(newParams, t);
        };
    }, configBezier = exports.configBezier = function() {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
        var x1 = args[0], y1 = args[1], x2 = args[2], y2 = args[3];
        if (1 === args.length) switch (args[0]) {
          case "linear":
            x1 = 0, y1 = 0, x2 = 1, y2 = 1;
            break;

          case "ease":
            x1 = .25, y1 = .1, x2 = .25, y2 = 1;
            break;

          case "ease-in":
            x1 = .42, y1 = 0, x2 = 1, y2 = 1;
            break;

          case "ease-out":
            x1 = .42, y1 = 0, x2 = .58, y2 = 1;
            break;

          case "ease-in-out":
            x1 = 0, y1 = 0, x2 = .58, y2 = 1;
            break;

          default:
            (0, _util.warn)(!1, "[configBezier]: arguments should be one of oneOf 'linear', 'ease', 'ease-in', 'ease-out', 'ease-in-out', instead received %s", args);
        }
        (0, _util.warn)([ x1, x2, y1, y2 ].every(function(num) {
            return "number" == typeof num && num >= 0 && num <= 1;
        }), "[configBezier]: arguments should be x1, y1, x2, y2 of [0, 1] instead received %s", args);
        var curveX = cubicBezier(x1, x2), curveY = cubicBezier(y1, y2), derCurveX = derivativeCubicBezier(x1, x2), rangeValue = function(value) {
            return value > 1 ? 1 : value < 0 ? 0 : value;
        }, bezier = function(_t) {
            for (var t = _t > 1 ? 1 : _t, x = t, i = 0; i < 8; ++i) {
                var evalT = curveX(x) - t, derVal = derCurveX(x);
                if (Math.abs(evalT - t) < 1e-4 || derVal < 1e-4) return curveY(x);
                x = rangeValue(x - evalT / derVal);
            }
            return curveY(x);
        };
        return bezier.isStepper = !1, bezier;
    }, configSpring = exports.configSpring = function() {
        var config = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}, _config$stiff = config.stiff, stiff = void 0 === _config$stiff ? 100 : _config$stiff, _config$damping = config.damping, damping = void 0 === _config$damping ? 8 : _config$damping, _config$dt = config.dt, dt = void 0 === _config$dt ? 17 : _config$dt, stepper = function(currX, destX, currV) {
            var FSpring = -(currX - destX) * stiff, FDamping = currV * damping, newV = currV + (FSpring - FDamping) * dt / 1e3, newX = currV * dt / 1e3 + currX;
            return Math.abs(newX - destX) < 1e-4 && Math.abs(newV) < 1e-4 ? [ destX, 0 ] : [ newX, newV ];
        };
        return stepper.isStepper = !0, stepper.dt = dt, stepper;
    };
    exports.configEasing = function() {
        for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) args[_key2] = arguments[_key2];
        var easing = args[0];
        if ("string" == typeof easing) switch (easing) {
          case "ease":
          case "ease-in-out":
          case "ease-out":
          case "ease-in":
          case "linear":
            return configBezier(easing);

          case "spring":
            return configSpring();

          default:
            (0, _util.warn)(!1, "[configEasing]: first argument should be one of 'ease', 'ease-in', 'ease-out', 'ease-in-out', 'linear' and 'spring', instead  received %s", args);
        }
        return "function" == typeof easing ? easing : ((0, _util.warn)(!1, "[configEasing]: first argument type should be function or string, instead received %s", args), 
        null);
    };
}, function(module, exports, __webpack_require__) {
    function isStrictComparable(value) {
        return value === value && !isObject(value);
    }
    var isObject = __webpack_require__(189);
    module.exports = isStrictComparable;
}, function(module, exports) {
    function matchesStrictComparable(key, srcValue) {
        return function(object) {
            return null != object && (object[key] === srcValue && (void 0 !== srcValue || key in Object(object)));
        };
    }
    module.exports = matchesStrictComparable;
}, function(module, exports, __webpack_require__) {
    function baseGet(object, path) {
        path = castPath(path, object);
        for (var index = 0, length = path.length; null != object && index < length; ) object = object[toKey(path[index++])];
        return index && index == length ? object : void 0;
    }
    var castPath = __webpack_require__(309), toKey = __webpack_require__(133);
    module.exports = baseGet;
}, function(module, exports, __webpack_require__) {
    function castPath(value, object) {
        return isArray(value) ? value : isKey(value, object) ? [ value ] : stringToPath(toString(value));
    }
    var isArray = __webpack_require__(34), isKey = __webpack_require__(196), stringToPath = __webpack_require__(751), toString = __webpack_require__(754);
    module.exports = castPath;
}, function(module, exports, __webpack_require__) {
    function debounce(func, wait, options) {
        function invokeFunc(time) {
            var args = lastArgs, thisArg = lastThis;
            return lastArgs = lastThis = void 0, lastInvokeTime = time, result = func.apply(thisArg, args);
        }
        function leadingEdge(time) {
            return lastInvokeTime = time, timerId = setTimeout(timerExpired, wait), leading ? invokeFunc(time) : result;
        }
        function remainingWait(time) {
            var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
            return maxing ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
        }
        function shouldInvoke(time) {
            var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
            return void 0 === lastCallTime || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
        }
        function timerExpired() {
            var time = now();
            if (shouldInvoke(time)) return trailingEdge(time);
            timerId = setTimeout(timerExpired, remainingWait(time));
        }
        function trailingEdge(time) {
            return timerId = void 0, trailing && lastArgs ? invokeFunc(time) : (lastArgs = lastThis = void 0, 
            result);
        }
        function cancel() {
            void 0 !== timerId && clearTimeout(timerId), lastInvokeTime = 0, lastArgs = lastCallTime = lastThis = timerId = void 0;
        }
        function flush() {
            return void 0 === timerId ? result : trailingEdge(now());
        }
        function debounced() {
            var time = now(), isInvoking = shouldInvoke(time);
            if (lastArgs = arguments, lastThis = this, lastCallTime = time, isInvoking) {
                if (void 0 === timerId) return leadingEdge(lastCallTime);
                if (maxing) return timerId = setTimeout(timerExpired, wait), invokeFunc(lastCallTime);
            }
            return void 0 === timerId && (timerId = setTimeout(timerExpired, wait)), result;
        }
        var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = !1, maxing = !1, trailing = !0;
        if ("function" != typeof func) throw new TypeError(FUNC_ERROR_TEXT);
        return wait = toNumber(wait) || 0, isObject(options) && (leading = !!options.leading, 
        maxing = "maxWait" in options, maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait, 
        trailing = "trailing" in options ? !!options.trailing : trailing), debounced.cancel = cancel, 
        debounced.flush = flush, debounced;
    }
    var isObject = __webpack_require__(32), now = __webpack_require__(767), toNumber = __webpack_require__(311), FUNC_ERROR_TEXT = "Expected a function", nativeMax = Math.max, nativeMin = Math.min;
    module.exports = debounce;
}, function(module, exports, __webpack_require__) {
    function toNumber(value) {
        if ("number" == typeof value) return value;
        if (isSymbol(value)) return NAN;
        if (isObject(value)) {
            var other = "function" == typeof value.valueOf ? value.valueOf() : value;
            value = isObject(other) ? other + "" : other;
        }
        if ("string" != typeof value) return 0 === value ? value : +value;
        value = value.replace(reTrim, "");
        var isBinary = reIsBinary.test(value);
        return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
    }
    var isObject = __webpack_require__(32), isSymbol = __webpack_require__(67), NAN = NaN, reTrim = /^\s+|\s+$/g, reIsBadHex = /^[-+]0x[0-9a-f]+$/i, reIsBinary = /^0b[01]+$/i, reIsOctal = /^0o[0-7]+$/i, freeParseInt = parseInt;
    module.exports = toNumber;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    (function(process) {
        __webpack_require__.d(__webpack_exports__, "a", function() {
            return warn;
        });
        var isDev = "production" !== process.env.NODE_ENV, warn = function(condition, format, a, b, c, d, e, f) {
            if (isDev && "undefined" != typeof console && console.warn && (void 0 === format && console.warn("LogUtils requires an error message argument"), 
            !condition)) if (void 0 === format) console.warn("Minified exception occurred; use the non-minified dev environment for the full error message and additional helpful warnings."); else {
                var args = [ a, b, c, d, e, f ], argIndex = 0;
                console.warn(format.replace(/%s/g, function() {
                    return args[argIndex++];
                }));
            }
        };
    }).call(__webpack_exports__, __webpack_require__(2));
}, function(module, exports) {
    function balanced(a, b, str) {
        a instanceof RegExp && (a = maybeMatch(a, str)), b instanceof RegExp && (b = maybeMatch(b, str));
        var r = range(a, b, str);
        return r && {
            start: r[0],
            end: r[1],
            pre: str.slice(0, r[0]),
            body: str.slice(r[0] + a.length, r[1]),
            post: str.slice(r[1] + b.length)
        };
    }
    function maybeMatch(reg, str) {
        var m = str.match(reg);
        return m ? m[0] : null;
    }
    function range(a, b, str) {
        var begs, beg, left, right, result, ai = str.indexOf(a), bi = str.indexOf(b, ai + 1), i = ai;
        if (ai >= 0 && bi > 0) {
            for (begs = [], left = str.length; i >= 0 && !result; ) i == ai ? (begs.push(i), 
            ai = str.indexOf(a, i + 1)) : 1 == begs.length ? result = [ begs.pop(), bi ] : (beg = begs.pop(), 
            beg < left && (left = beg, right = bi), bi = str.indexOf(b, i + 1)), i = ai < bi && ai >= 0 ? ai : bi;
            begs.length && (result = [ left, right ]);
        }
        return result;
    }
    module.exports = balanced, balanced.range = range;
}, function(module, exports, __webpack_require__) {
    function Stack(entries) {
        var data = this.__data__ = new ListCache(entries);
        this.size = data.size;
    }
    var ListCache = __webpack_require__(116), stackClear = __webpack_require__(779), stackDelete = __webpack_require__(780), stackGet = __webpack_require__(781), stackHas = __webpack_require__(782), stackSet = __webpack_require__(783);
    Stack.prototype.clear = stackClear, Stack.prototype.delete = stackDelete, Stack.prototype.get = stackGet, 
    Stack.prototype.has = stackHas, Stack.prototype.set = stackSet, module.exports = Stack;
}, function(module, exports, __webpack_require__) {
    function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG, arrLength = array.length, othLength = other.length;
        if (arrLength != othLength && !(isPartial && othLength > arrLength)) return !1;
        var stacked = stack.get(array);
        if (stacked && stack.get(other)) return stacked == other;
        var index = -1, result = !0, seen = bitmask & COMPARE_UNORDERED_FLAG ? new SetCache() : void 0;
        for (stack.set(array, other), stack.set(other, array); ++index < arrLength; ) {
            var arrValue = array[index], othValue = other[index];
            if (customizer) var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
            if (void 0 !== compared) {
                if (compared) continue;
                result = !1;
                break;
            }
            if (seen) {
                if (!arraySome(other, function(othValue, othIndex) {
                    if (!cacheHas(seen, othIndex) && (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) return seen.push(othIndex);
                })) {
                    result = !1;
                    break;
                }
            } else if (arrValue !== othValue && !equalFunc(arrValue, othValue, bitmask, customizer, stack)) {
                result = !1;
                break;
            }
        }
        return stack.delete(array), stack.delete(other), result;
    }
    var SetCache = __webpack_require__(784), arraySome = __webpack_require__(787), cacheHas = __webpack_require__(788), COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
    module.exports = equalArrays;
}, function(module, exports) {
    function arrayPush(array, values) {
        for (var index = -1, length = values.length, offset = array.length; ++index < length; ) array[offset + index] = values[index];
        return array;
    }
    module.exports = arrayPush;
}, function(module, exports, __webpack_require__) {
    (function(module) {
        var root = __webpack_require__(31), stubFalse = __webpack_require__(802), freeExports = "object" == typeof exports && exports && !exports.nodeType && exports, freeModule = freeExports && "object" == typeof module && module && !module.nodeType && module, moduleExports = freeModule && freeModule.exports === freeExports, Buffer = moduleExports ? root.Buffer : void 0, nativeIsBuffer = Buffer ? Buffer.isBuffer : void 0, isBuffer = nativeIsBuffer || stubFalse;
        module.exports = isBuffer;
    }).call(exports, __webpack_require__(131)(module));
}, function(module, exports, __webpack_require__) {
    var baseIsTypedArray = __webpack_require__(803), baseUnary = __webpack_require__(319), nodeUtil = __webpack_require__(804), nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray, isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
    module.exports = isTypedArray;
}, function(module, exports) {
    function baseUnary(func) {
        return function(value) {
            return func(value);
        };
    }
    module.exports = baseUnary;
}, function(module, exports) {
    function overArg(func, transform) {
        return function(arg) {
            return func(transform(arg));
        };
    }
    module.exports = overArg;
}, function(module, exports, __webpack_require__) {
    var baseFlatten = __webpack_require__(322), baseOrderBy = __webpack_require__(814), baseRest = __webpack_require__(833), isIterateeCall = __webpack_require__(326), sortBy = baseRest(function(collection, iteratees) {
        if (null == collection) return [];
        var length = iteratees.length;
        return length > 1 && isIterateeCall(collection, iteratees[0], iteratees[1]) ? iteratees = [] : length > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2]) && (iteratees = [ iteratees[0] ]), 
        baseOrderBy(collection, baseFlatten(iteratees, 1), []);
    });
    module.exports = sortBy;
}, function(module, exports, __webpack_require__) {
    function baseFlatten(array, depth, predicate, isStrict, result) {
        var index = -1, length = array.length;
        for (predicate || (predicate = isFlattenable), result || (result = []); ++index < length; ) {
            var value = array[index];
            depth > 0 && predicate(value) ? depth > 1 ? baseFlatten(value, depth - 1, predicate, isStrict, result) : arrayPush(result, value) : isStrict || (result[result.length] = value);
        }
        return result;
    }
    var arrayPush = __webpack_require__(316), isFlattenable = __webpack_require__(813);
    module.exports = baseFlatten;
}, function(module, exports, __webpack_require__) {
    function isStrictComparable(value) {
        return value === value && !isObject(value);
    }
    var isObject = __webpack_require__(32);
    module.exports = isStrictComparable;
}, function(module, exports) {
    function matchesStrictComparable(key, srcValue) {
        return function(object) {
            return null != object && (object[key] === srcValue && (void 0 !== srcValue || key in Object(object)));
        };
    }
    module.exports = matchesStrictComparable;
}, function(module, exports, __webpack_require__) {
    function baseMap(collection, iteratee) {
        var index = -1, result = isArrayLike(collection) ? Array(collection.length) : [];
        return baseEach(collection, function(value, key, collection) {
            result[++index] = iteratee(value, key, collection);
        }), result;
    }
    var baseEach = __webpack_require__(825), isArrayLike = __webpack_require__(134);
    module.exports = baseMap;
}, function(module, exports, __webpack_require__) {
    function isIterateeCall(value, index, object) {
        if (!isObject(object)) return !1;
        var type = typeof index;
        return !!("number" == type ? isArrayLike(object) && isIndex(index, object.length) : "string" == type && index in object) && eq(object[index], value);
    }
    var eq = __webpack_require__(177), isArrayLike = __webpack_require__(134), isIndex = __webpack_require__(202), isObject = __webpack_require__(32);
    module.exports = isIterateeCall;
}, function(module, exports) {
    function baseGt(value, other) {
        return value > other;
    }
    module.exports = baseGt;
}, function(module, exports, __webpack_require__) {
    function min(array) {
        return array && array.length ? baseExtremum(array, identity, baseLt) : void 0;
    }
    var baseExtremum = __webpack_require__(135), baseLt = __webpack_require__(329), identity = __webpack_require__(68);
    module.exports = min;
}, function(module, exports) {
    function baseLt(value, other) {
        return value < other;
    }
    module.exports = baseLt;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];
            return arr2;
        }
        return Array.from(arr);
    }
    Object.defineProperty(exports, "__esModule", {
        value: !0
    });
    var identity = function(i) {
        return i;
    }, PLACE_HOLDER = exports.PLACE_HOLDER = {
        "@@functional/placeholder": !0
    }, isPlaceHolder = function(val) {
        return val === PLACE_HOLDER;
    }, curry0 = function(fn) {
        return function _curried() {
            return 0 === arguments.length || 1 === arguments.length && isPlaceHolder(arguments.length <= 0 ? void 0 : arguments[0]) ? _curried : fn.apply(void 0, arguments);
        };
    }, curryN = function curryN(n, fn) {
        return 1 === n ? fn : curry0(function() {
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            var argsLength = args.filter(function(arg) {
                return arg !== PLACE_HOLDER;
            }).length;
            return argsLength >= n ? fn.apply(void 0, args) : curryN(n - argsLength, curry0(function() {
                for (var _len2 = arguments.length, restArgs = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) restArgs[_key2] = arguments[_key2];
                var newArgs = args.map(function(arg) {
                    return isPlaceHolder(arg) ? restArgs.shift() : arg;
                });
                return fn.apply(void 0, _toConsumableArray(newArgs).concat(restArgs));
            }));
        });
    }, curry = exports.curry = function(fn) {
        return curryN(fn.length, fn);
    };
    exports.range = function(begin, end) {
        for (var arr = [], i = begin; i < end; ++i) arr[i - begin] = i;
        return arr;
    }, exports.map = curry(function(fn, arr) {
        return Array.isArray(arr) ? arr.map(fn) : Object.keys(arr).map(function(key) {
            return arr[key];
        }).map(fn);
    }), exports.compose = function() {
        for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) args[_key3] = arguments[_key3];
        if (!args.length) return identity;
        var fns = args.reverse(), firstFn = fns[0], tailsFn = fns.slice(1);
        return function() {
            return tailsFn.reduce(function(res, fn) {
                return fn(res);
            }, firstFn.apply(void 0, arguments));
        };
    }, exports.reverse = function(arr) {
        return Array.isArray(arr) ? arr.reverse() : arr.split("").reverse.join("");
    }, exports.memoize = function(fn) {
        var lastArgs = null, lastResult = null;
        return function() {
            for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) args[_key4] = arguments[_key4];
            return lastArgs && args.every(function(val, i) {
                return val === lastArgs[i];
            }) ? lastResult : (lastArgs = args, lastResult = fn.apply(void 0, args));
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    Object.defineProperty(__webpack_exports__, "__esModule", {
        value: !0
    });
    var __WEBPACK_IMPORTED_MODULE_0__src_band__ = __webpack_require__(847);
    __webpack_require__.d(__webpack_exports__, "scaleBand", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_band__.a;
    }), __webpack_require__.d(__webpack_exports__, "scalePoint", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_band__.b;
    });
    var __WEBPACK_IMPORTED_MODULE_1__src_identity__ = __webpack_require__(870);
    __webpack_require__.d(__webpack_exports__, "scaleIdentity", function() {
        return __WEBPACK_IMPORTED_MODULE_1__src_identity__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_2__src_linear__ = __webpack_require__(91);
    __webpack_require__.d(__webpack_exports__, "scaleLinear", function() {
        return __WEBPACK_IMPORTED_MODULE_2__src_linear__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_3__src_log__ = __webpack_require__(893);
    __webpack_require__.d(__webpack_exports__, "scaleLog", function() {
        return __WEBPACK_IMPORTED_MODULE_3__src_log__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_4__src_ordinal__ = __webpack_require__(344);
    __webpack_require__.d(__webpack_exports__, "scaleOrdinal", function() {
        return __WEBPACK_IMPORTED_MODULE_4__src_ordinal__.a;
    }), __webpack_require__.d(__webpack_exports__, "scaleImplicit", function() {
        return __WEBPACK_IMPORTED_MODULE_4__src_ordinal__.b;
    });
    var __WEBPACK_IMPORTED_MODULE_5__src_pow__ = __webpack_require__(894);
    __webpack_require__.d(__webpack_exports__, "scalePow", function() {
        return __WEBPACK_IMPORTED_MODULE_5__src_pow__.a;
    }), __webpack_require__.d(__webpack_exports__, "scaleSqrt", function() {
        return __WEBPACK_IMPORTED_MODULE_5__src_pow__.b;
    });
    var __WEBPACK_IMPORTED_MODULE_6__src_quantile__ = __webpack_require__(895);
    __webpack_require__.d(__webpack_exports__, "scaleQuantile", function() {
        return __WEBPACK_IMPORTED_MODULE_6__src_quantile__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_7__src_quantize__ = __webpack_require__(896);
    __webpack_require__.d(__webpack_exports__, "scaleQuantize", function() {
        return __WEBPACK_IMPORTED_MODULE_7__src_quantize__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_8__src_threshold__ = __webpack_require__(897);
    __webpack_require__.d(__webpack_exports__, "scaleThreshold", function() {
        return __WEBPACK_IMPORTED_MODULE_8__src_threshold__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_9__src_time__ = __webpack_require__(360);
    __webpack_require__.d(__webpack_exports__, "scaleTime", function() {
        return __WEBPACK_IMPORTED_MODULE_9__src_time__.b;
    });
    var __WEBPACK_IMPORTED_MODULE_10__src_utcTime__ = __webpack_require__(913);
    __webpack_require__.d(__webpack_exports__, "scaleUtc", function() {
        return __WEBPACK_IMPORTED_MODULE_10__src_utcTime__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_11__src_category10__ = __webpack_require__(914);
    __webpack_require__.d(__webpack_exports__, "schemeCategory10", function() {
        return __WEBPACK_IMPORTED_MODULE_11__src_category10__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_12__src_category20b__ = __webpack_require__(915);
    __webpack_require__.d(__webpack_exports__, "schemeCategory20b", function() {
        return __WEBPACK_IMPORTED_MODULE_12__src_category20b__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_13__src_category20c__ = __webpack_require__(916);
    __webpack_require__.d(__webpack_exports__, "schemeCategory20c", function() {
        return __WEBPACK_IMPORTED_MODULE_13__src_category20c__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_14__src_category20__ = __webpack_require__(917);
    __webpack_require__.d(__webpack_exports__, "schemeCategory20", function() {
        return __WEBPACK_IMPORTED_MODULE_14__src_category20__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_15__src_cubehelix__ = __webpack_require__(918);
    __webpack_require__.d(__webpack_exports__, "interpolateCubehelixDefault", function() {
        return __WEBPACK_IMPORTED_MODULE_15__src_cubehelix__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_16__src_rainbow__ = __webpack_require__(919);
    __webpack_require__.d(__webpack_exports__, "interpolateRainbow", function() {
        return __WEBPACK_IMPORTED_MODULE_16__src_rainbow__.b;
    }), __webpack_require__.d(__webpack_exports__, "interpolateWarm", function() {
        return __WEBPACK_IMPORTED_MODULE_16__src_rainbow__.c;
    }), __webpack_require__.d(__webpack_exports__, "interpolateCool", function() {
        return __WEBPACK_IMPORTED_MODULE_16__src_rainbow__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_17__src_viridis__ = __webpack_require__(920);
    __webpack_require__.d(__webpack_exports__, "interpolateViridis", function() {
        return __WEBPACK_IMPORTED_MODULE_17__src_viridis__.a;
    }), __webpack_require__.d(__webpack_exports__, "interpolateMagma", function() {
        return __WEBPACK_IMPORTED_MODULE_17__src_viridis__.c;
    }), __webpack_require__.d(__webpack_exports__, "interpolateInferno", function() {
        return __WEBPACK_IMPORTED_MODULE_17__src_viridis__.b;
    }), __webpack_require__.d(__webpack_exports__, "interpolatePlasma", function() {
        return __WEBPACK_IMPORTED_MODULE_17__src_viridis__.d;
    });
    var __WEBPACK_IMPORTED_MODULE_18__src_sequential__ = __webpack_require__(921);
    __webpack_require__.d(__webpack_exports__, "scaleSequential", function() {
        return __WEBPACK_IMPORTED_MODULE_18__src_sequential__.a;
    });
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__ascending__ = __webpack_require__(69), __WEBPACK_IMPORTED_MODULE_1__bisector__ = __webpack_require__(333), ascendingBisect = Object(__WEBPACK_IMPORTED_MODULE_1__bisector__.a)(__WEBPACK_IMPORTED_MODULE_0__ascending__.a), bisectRight = ascendingBisect.right;
    ascendingBisect.left;
    __webpack_exports__.a = bisectRight;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function ascendingComparator(f) {
        return function(d, x) {
            return Object(__WEBPACK_IMPORTED_MODULE_0__ascending__.a)(f(d), x);
        };
    }
    var __WEBPACK_IMPORTED_MODULE_0__ascending__ = __webpack_require__(69);
    __webpack_exports__.a = function(compare) {
        return 1 === compare.length && (compare = ascendingComparator(compare)), {
            left: function(a, x, lo, hi) {
                for (null == lo && (lo = 0), null == hi && (hi = a.length); lo < hi; ) {
                    var mid = lo + hi >>> 1;
                    compare(a[mid], x) < 0 ? lo = mid + 1 : hi = mid;
                }
                return lo;
            },
            right: function(a, x, lo, hi) {
                for (null == lo && (lo = 0), null == hi && (hi = a.length); lo < hi; ) {
                    var mid = lo + hi >>> 1;
                    compare(a[mid], x) > 0 ? hi = mid : lo = mid + 1;
                }
                return lo;
            }
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function pair(a, b) {
        return [ a, b ];
    }
    __webpack_exports__.a = pair;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__variance__ = __webpack_require__(336);
    __webpack_exports__.a = function(array, f) {
        var v = Object(__WEBPACK_IMPORTED_MODULE_0__variance__.a)(array, f);
        return v ? Math.sqrt(v) : v;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__number__ = __webpack_require__(90);
    __webpack_exports__.a = function(values, valueof) {
        var value, delta, n = values.length, m = 0, i = -1, mean = 0, sum = 0;
        if (null == valueof) for (;++i < n; ) isNaN(value = Object(__WEBPACK_IMPORTED_MODULE_0__number__.a)(values[i])) || (delta = value - mean, 
        mean += delta / ++m, sum += delta * (value - mean)); else for (;++i < n; ) isNaN(value = Object(__WEBPACK_IMPORTED_MODULE_0__number__.a)(valueof(values[i], i, values))) || (delta = value - mean, 
        mean += delta / ++m, sum += delta * (value - mean));
        if (m > 1) return sum / (m - 1);
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(values, valueof) {
        var value, min, max, n = values.length, i = -1;
        if (null == valueof) {
            for (;++i < n; ) if (null != (value = values[i]) && value >= value) for (min = max = value; ++i < n; ) null != (value = values[i]) && (min > value && (min = value), 
            max < value && (max = value));
        } else for (;++i < n; ) if (null != (value = valueof(values[i], i, values)) && value >= value) for (min = max = value; ++i < n; ) null != (value = valueof(values[i], i, values)) && (min > value && (min = value), 
        max < value && (max = value));
        return [ min, max ];
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_require__.d(__webpack_exports__, "b", function() {
        return slice;
    }), __webpack_require__.d(__webpack_exports__, "a", function() {
        return map;
    });
    var array = Array.prototype, slice = array.slice, map = array.map;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(start, stop, step) {
        start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, 
        start = 0, 1) : n < 3 ? 1 : +step;
        for (var i = -1, n = 0 | Math.max(0, Math.ceil((stop - start) / step)), range = new Array(n); ++i < n; ) range[i] = start + i * step;
        return range;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function tickIncrement(start, stop, count) {
        var step = (stop - start) / Math.max(0, count), power = Math.floor(Math.log(step) / Math.LN10), error = step / Math.pow(10, power);
        return power >= 0 ? (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1) * Math.pow(10, power) : -Math.pow(10, -power) / (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1);
    }
    function tickStep(start, stop, count) {
        var step0 = Math.abs(stop - start) / Math.max(0, count), step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)), error = step0 / step1;
        return error >= e10 ? step1 *= 10 : error >= e5 ? step1 *= 5 : error >= e2 && (step1 *= 2), 
        stop < start ? -step1 : step1;
    }
    __webpack_exports__.b = tickIncrement, __webpack_exports__.c = tickStep;
    var e10 = Math.sqrt(50), e5 = Math.sqrt(10), e2 = Math.sqrt(2);
    __webpack_exports__.a = function(start, stop, count) {
        var reverse, n, ticks, step, i = -1;
        if (stop = +stop, start = +start, count = +count, start === stop && count > 0) return [ start ];
        if ((reverse = stop < start) && (n = start, start = stop, stop = n), 0 === (step = tickIncrement(start, stop, count)) || !isFinite(step)) return [];
        if (step > 0) for (start = Math.ceil(start / step), stop = Math.floor(stop / step), 
        ticks = new Array(n = Math.ceil(stop - start + 1)); ++i < n; ) ticks[i] = (start + i) * step; else for (start = Math.floor(start * step), 
        stop = Math.ceil(stop * step), ticks = new Array(n = Math.ceil(start - stop + 1)); ++i < n; ) ticks[i] = (start - i) / step;
        return reverse && ticks.reverse(), ticks;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(values) {
        return Math.ceil(Math.log(values.length) / Math.LN2) + 1;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(values, valueof) {
        var value, min, n = values.length, i = -1;
        if (null == valueof) {
            for (;++i < n; ) if (null != (value = values[i]) && value >= value) for (min = value; ++i < n; ) null != (value = values[i]) && min > value && (min = value);
        } else for (;++i < n; ) if (null != (value = valueof(values[i], i, values)) && value >= value) for (min = value; ++i < n; ) null != (value = valueof(values[i], i, values)) && min > value && (min = value);
        return min;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function length(d) {
        return d.length;
    }
    var __WEBPACK_IMPORTED_MODULE_0__min__ = __webpack_require__(342);
    __webpack_exports__.a = function(matrix) {
        if (!(n = matrix.length)) return [];
        for (var i = -1, m = Object(__WEBPACK_IMPORTED_MODULE_0__min__.a)(matrix, length), transpose = new Array(m); ++i < m; ) for (var n, j = -1, row = transpose[i] = new Array(n); ++j < n; ) row[j] = matrix[j][i];
        return transpose;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function ordinal(range) {
        function scale(d) {
            var key = d + "", i = index.get(key);
            if (!i) {
                if (unknown !== implicit) return unknown;
                index.set(key, i = domain.push(d));
            }
            return range[(i - 1) % range.length];
        }
        var index = Object(__WEBPACK_IMPORTED_MODULE_0_d3_collection__.a)(), domain = [], unknown = implicit;
        return range = null == range ? [] : __WEBPACK_IMPORTED_MODULE_1__array__.b.call(range), 
        scale.domain = function(_) {
            if (!arguments.length) return domain.slice();
            domain = [], index = Object(__WEBPACK_IMPORTED_MODULE_0_d3_collection__.a)();
            for (var d, key, i = -1, n = _.length; ++i < n; ) index.has(key = (d = _[i]) + "") || index.set(key, domain.push(d));
            return scale;
        }, scale.range = function(_) {
            return arguments.length ? (range = __WEBPACK_IMPORTED_MODULE_1__array__.b.call(_), 
            scale) : range.slice();
        }, scale.unknown = function(_) {
            return arguments.length ? (unknown = _, scale) : unknown;
        }, scale.copy = function() {
            return ordinal().domain(domain).range(range).unknown(unknown);
        }, scale;
    }
    __webpack_require__.d(__webpack_exports__, "b", function() {
        return implicit;
    }), __webpack_exports__.a = ordinal;
    var __WEBPACK_IMPORTED_MODULE_0_d3_collection__ = __webpack_require__(864), __WEBPACK_IMPORTED_MODULE_1__array__ = __webpack_require__(62), implicit = {
        name: "implicit"
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return deg2rad;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return rad2deg;
    });
    var deg2rad = Math.PI / 180, rad2deg = 180 / Math.PI;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function rgbSpline(spline) {
        return function(colors) {
            var i, color, n = colors.length, r = new Array(n), g = new Array(n), b = new Array(n);
            for (i = 0; i < n; ++i) color = Object(__WEBPACK_IMPORTED_MODULE_0_d3_color__.f)(colors[i]), 
            r[i] = color.r || 0, g[i] = color.g || 0, b[i] = color.b || 0;
            return r = spline(r), g = spline(g), b = spline(b), color.opacity = 1, function(t) {
                return color.r = r(t), color.g = g(t), color.b = b(t), color + "";
            };
        };
    }
    var __WEBPACK_IMPORTED_MODULE_0_d3_color__ = __webpack_require__(46), __WEBPACK_IMPORTED_MODULE_1__basis__ = __webpack_require__(209), __WEBPACK_IMPORTED_MODULE_2__basisClosed__ = __webpack_require__(347), __WEBPACK_IMPORTED_MODULE_3__color__ = __webpack_require__(93);
    __webpack_exports__.a = function rgbGamma(y) {
        function rgb(start, end) {
            var r = color((start = Object(__WEBPACK_IMPORTED_MODULE_0_d3_color__.f)(start)).r, (end = Object(__WEBPACK_IMPORTED_MODULE_0_d3_color__.f)(end)).r), g = color(start.g, end.g), b = color(start.b, end.b), opacity = Object(__WEBPACK_IMPORTED_MODULE_3__color__.a)(start.opacity, end.opacity);
            return function(t) {
                return start.r = r(t), start.g = g(t), start.b = b(t), start.opacity = opacity(t), 
                start + "";
            };
        }
        var color = Object(__WEBPACK_IMPORTED_MODULE_3__color__.b)(y);
        return rgb.gamma = rgbGamma, rgb;
    }(1);
    rgbSpline(__WEBPACK_IMPORTED_MODULE_1__basis__.b), rgbSpline(__WEBPACK_IMPORTED_MODULE_2__basisClosed__.a);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__basis__ = __webpack_require__(209);
    __webpack_exports__.a = function(values) {
        var n = values.length;
        return function(t) {
            var i = Math.floor(((t %= 1) < 0 ? ++t : t) * n), v0 = values[(i + n - 1) % n], v1 = values[i % n], v2 = values[(i + 1) % n], v3 = values[(i + 2) % n];
            return Object(__WEBPACK_IMPORTED_MODULE_0__basis__.a)((t - i / n) * n, v0, v1, v2, v3);
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(x) {
        return function() {
            return x;
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__value__ = __webpack_require__(206);
    __webpack_exports__.a = function(a, b) {
        var i, nb = b ? b.length : 0, na = a ? Math.min(nb, a.length) : 0, x = new Array(na), c = new Array(nb);
        for (i = 0; i < na; ++i) x[i] = Object(__WEBPACK_IMPORTED_MODULE_0__value__.a)(a[i], b[i]);
        for (;i < nb; ++i) c[i] = b[i];
        return function(t) {
            for (i = 0; i < na; ++i) c[i] = x[i](t);
            return c;
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(a, b) {
        var d = new Date();
        return a = +a, b -= a, function(t) {
            return d.setTime(a + b * t), d;
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__value__ = __webpack_require__(206);
    __webpack_exports__.a = function(a, b) {
        var k, i = {}, c = {};
        null !== a && "object" == typeof a || (a = {}), null !== b && "object" == typeof b || (b = {});
        for (k in b) k in a ? i[k] = Object(__WEBPACK_IMPORTED_MODULE_0__value__.a)(a[k], b[k]) : c[k] = b[k];
        return function(t) {
            for (k in i) c[k] = i[k](t);
            return c;
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function zero(b) {
        return function() {
            return b;
        };
    }
    function one(b) {
        return function(t) {
            return b(t) + "";
        };
    }
    var __WEBPACK_IMPORTED_MODULE_0__number__ = __webpack_require__(136), reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, reB = new RegExp(reA.source, "g");
    __webpack_exports__.a = function(a, b) {
        var am, bm, bs, bi = reA.lastIndex = reB.lastIndex = 0, i = -1, s = [], q = [];
        for (a += "", b += ""; (am = reA.exec(a)) && (bm = reB.exec(b)); ) (bs = bm.index) > bi && (bs = b.slice(bi, bs), 
        s[i] ? s[i] += bs : s[++i] = bs), (am = am[0]) === (bm = bm[0]) ? s[i] ? s[i] += bm : s[++i] = bm : (s[++i] = null, 
        q.push({
            i: i,
            x: Object(__WEBPACK_IMPORTED_MODULE_0__number__.a)(am, bm)
        })), bi = reB.lastIndex;
        return bi < b.length && (bs = b.slice(bi), s[i] ? s[i] += bs : s[++i] = bs), s.length < 2 ? q[0] ? one(q[0].x) : zero(b) : (b = q.length, 
        function(t) {
            for (var o, i = 0; i < b; ++i) s[(o = q[i]).i] = o.x(t);
            return s.join("");
        });
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(x) {
        return +x;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__src_defaultLocale__ = __webpack_require__(884);
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_defaultLocale__.a;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_defaultLocale__.b;
    });
    var __WEBPACK_IMPORTED_MODULE_2__src_formatSpecifier__ = (__webpack_require__(355), 
    __webpack_require__(356));
    __webpack_require__.d(__webpack_exports__, "c", function() {
        return __WEBPACK_IMPORTED_MODULE_2__src_formatSpecifier__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_3__src_precisionFixed__ = __webpack_require__(890);
    __webpack_require__.d(__webpack_exports__, "d", function() {
        return __WEBPACK_IMPORTED_MODULE_3__src_precisionFixed__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_4__src_precisionPrefix__ = __webpack_require__(891);
    __webpack_require__.d(__webpack_exports__, "e", function() {
        return __WEBPACK_IMPORTED_MODULE_4__src_precisionPrefix__.a;
    });
    var __WEBPACK_IMPORTED_MODULE_5__src_precisionRound__ = __webpack_require__(892);
    __webpack_require__.d(__webpack_exports__, "f", function() {
        return __WEBPACK_IMPORTED_MODULE_5__src_precisionRound__.a;
    });
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__exponent__ = __webpack_require__(138), __WEBPACK_IMPORTED_MODULE_1__formatGroup__ = __webpack_require__(885), __WEBPACK_IMPORTED_MODULE_2__formatNumerals__ = __webpack_require__(886), __WEBPACK_IMPORTED_MODULE_3__formatSpecifier__ = __webpack_require__(356), __WEBPACK_IMPORTED_MODULE_4__formatTypes__ = __webpack_require__(357), __WEBPACK_IMPORTED_MODULE_5__formatPrefixAuto__ = __webpack_require__(358), __WEBPACK_IMPORTED_MODULE_6__identity__ = __webpack_require__(889), prefixes = [ "y", "z", "a", "f", "p", "n", "µ", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y" ];
    __webpack_exports__.a = function(locale) {
        function newFormat(specifier) {
            function format(value) {
                var i, n, c, valuePrefix = prefix, valueSuffix = suffix;
                if ("c" === type) valueSuffix = formatType(value) + valueSuffix, value = ""; else {
                    value = +value;
                    var valueNegative = value < 0;
                    if (value = formatType(Math.abs(value), precision), valueNegative && 0 == +value && (valueNegative = !1), 
                    valuePrefix = (valueNegative ? "(" === sign ? sign : "-" : "-" === sign || "(" === sign ? "" : sign) + valuePrefix, 
                    valueSuffix = ("s" === type ? prefixes[8 + __WEBPACK_IMPORTED_MODULE_5__formatPrefixAuto__.b / 3] : "") + valueSuffix + (valueNegative && "(" === sign ? ")" : ""), 
                    maybeSuffix) for (i = -1, n = value.length; ++i < n; ) if (48 > (c = value.charCodeAt(i)) || c > 57) {
                        valueSuffix = (46 === c ? decimal + value.slice(i + 1) : value.slice(i)) + valueSuffix, 
                        value = value.slice(0, i);
                        break;
                    }
                }
                comma && !zero && (value = group(value, 1 / 0));
                var length = valuePrefix.length + value.length + valueSuffix.length, padding = length < width ? new Array(width - length + 1).join(fill) : "";
                switch (comma && zero && (value = group(padding + value, padding.length ? width - valueSuffix.length : 1 / 0), 
                padding = ""), align) {
                  case "<":
                    value = valuePrefix + value + valueSuffix + padding;
                    break;

                  case "=":
                    value = valuePrefix + padding + value + valueSuffix;
                    break;

                  case "^":
                    value = padding.slice(0, length = padding.length >> 1) + valuePrefix + value + valueSuffix + padding.slice(length);
                    break;

                  default:
                    value = padding + valuePrefix + value + valueSuffix;
                }
                return numerals(value);
            }
            specifier = Object(__WEBPACK_IMPORTED_MODULE_3__formatSpecifier__.a)(specifier);
            var fill = specifier.fill, align = specifier.align, sign = specifier.sign, symbol = specifier.symbol, zero = specifier.zero, width = specifier.width, comma = specifier.comma, precision = specifier.precision, type = specifier.type, prefix = "$" === symbol ? currency[0] : "#" === symbol && /[boxX]/.test(type) ? "0" + type.toLowerCase() : "", suffix = "$" === symbol ? currency[1] : /[%p]/.test(type) ? percent : "", formatType = __WEBPACK_IMPORTED_MODULE_4__formatTypes__.a[type], maybeSuffix = !type || /[defgprs%]/.test(type);
            return precision = null == precision ? type ? 6 : 12 : /[gprs]/.test(type) ? Math.max(1, Math.min(21, precision)) : Math.max(0, Math.min(20, precision)), 
            format.toString = function() {
                return specifier + "";
            }, format;
        }
        function formatPrefix(specifier, value) {
            var f = newFormat((specifier = Object(__WEBPACK_IMPORTED_MODULE_3__formatSpecifier__.a)(specifier), 
            specifier.type = "f", specifier)), e = 3 * Math.max(-8, Math.min(8, Math.floor(Object(__WEBPACK_IMPORTED_MODULE_0__exponent__.a)(value) / 3))), k = Math.pow(10, -e), prefix = prefixes[8 + e / 3];
            return function(value) {
                return f(k * value) + prefix;
            };
        }
        var group = locale.grouping && locale.thousands ? Object(__WEBPACK_IMPORTED_MODULE_1__formatGroup__.a)(locale.grouping, locale.thousands) : __WEBPACK_IMPORTED_MODULE_6__identity__.a, currency = locale.currency, decimal = locale.decimal, numerals = locale.numerals ? Object(__WEBPACK_IMPORTED_MODULE_2__formatNumerals__.a)(locale.numerals) : __WEBPACK_IMPORTED_MODULE_6__identity__.a, percent = locale.percent || "%";
        return {
            format: newFormat,
            formatPrefix: formatPrefix
        };
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function formatSpecifier(specifier) {
        return new FormatSpecifier(specifier);
    }
    function FormatSpecifier(specifier) {
        if (!(match = re.exec(specifier))) throw new Error("invalid format: " + specifier);
        var match, fill = match[1] || " ", align = match[2] || ">", sign = match[3] || "-", symbol = match[4] || "", zero = !!match[5], width = match[6] && +match[6], comma = !!match[7], precision = match[8] && +match[8].slice(1), type = match[9] || "";
        "n" === type ? (comma = !0, type = "g") : __WEBPACK_IMPORTED_MODULE_0__formatTypes__.a[type] || (type = ""), 
        (zero || "0" === fill && "=" === align) && (zero = !0, fill = "0", align = "="), 
        this.fill = fill, this.align = align, this.sign = sign, this.symbol = symbol, this.zero = zero, 
        this.width = width, this.comma = comma, this.precision = precision, this.type = type;
    }
    __webpack_exports__.a = formatSpecifier;
    var __WEBPACK_IMPORTED_MODULE_0__formatTypes__ = __webpack_require__(357), re = /^(?:(.)?([<>=^]))?([+\-\( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?([a-z%])?$/i;
    formatSpecifier.prototype = FormatSpecifier.prototype, FormatSpecifier.prototype.toString = function() {
        return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (null == this.width ? "" : Math.max(1, 0 | this.width)) + (this.comma ? "," : "") + (null == this.precision ? "" : "." + Math.max(0, 0 | this.precision)) + this.type;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__formatDefault__ = __webpack_require__(887), __WEBPACK_IMPORTED_MODULE_1__formatPrefixAuto__ = __webpack_require__(358), __WEBPACK_IMPORTED_MODULE_2__formatRounded__ = __webpack_require__(888);
    __webpack_exports__.a = {
        "": __WEBPACK_IMPORTED_MODULE_0__formatDefault__.a,
        "%": function(x, p) {
            return (100 * x).toFixed(p);
        },
        b: function(x) {
            return Math.round(x).toString(2);
        },
        c: function(x) {
            return x + "";
        },
        d: function(x) {
            return Math.round(x).toString(10);
        },
        e: function(x, p) {
            return x.toExponential(p);
        },
        f: function(x, p) {
            return x.toFixed(p);
        },
        g: function(x, p) {
            return x.toPrecision(p);
        },
        o: function(x) {
            return Math.round(x).toString(8);
        },
        p: function(x, p) {
            return Object(__WEBPACK_IMPORTED_MODULE_2__formatRounded__.a)(100 * x, p);
        },
        r: __WEBPACK_IMPORTED_MODULE_2__formatRounded__.a,
        s: __WEBPACK_IMPORTED_MODULE_1__formatPrefixAuto__.a,
        X: function(x) {
            return Math.round(x).toString(16).toUpperCase();
        },
        x: function(x) {
            return Math.round(x).toString(16);
        }
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_require__.d(__webpack_exports__, "b", function() {
        return prefixExponent;
    });
    var prefixExponent, __WEBPACK_IMPORTED_MODULE_0__formatDecimal__ = __webpack_require__(211);
    __webpack_exports__.a = function(x, p) {
        var d = Object(__WEBPACK_IMPORTED_MODULE_0__formatDecimal__.a)(x, p);
        if (!d) return x + "";
        var coefficient = d[0], exponent = d[1], i = exponent - (prefixExponent = 3 * Math.max(-8, Math.min(8, Math.floor(exponent / 3)))) + 1, n = coefficient.length;
        return i === n ? coefficient : i > n ? coefficient + new Array(i - n + 1).join("0") : i > 0 ? coefficient.slice(0, i) + "." + coefficient.slice(i) : "0." + new Array(1 - i).join("0") + Object(__WEBPACK_IMPORTED_MODULE_0__formatDecimal__.a)(x, Math.max(0, p + i - 1))[0];
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    __webpack_exports__.a = function(domain, interval) {
        domain = domain.slice();
        var t, i0 = 0, i1 = domain.length - 1, x0 = domain[i0], x1 = domain[i1];
        return x1 < x0 && (t = i0, i0 = i1, i1 = t, t = x0, x0 = x1, x1 = t), domain[i0] = interval.floor(x0), 
        domain[i1] = interval.ceil(x1), domain;
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function date(t) {
        return new Date(t);
    }
    function number(t) {
        return t instanceof Date ? +t : +new Date(+t);
    }
    function calendar(year, month, week, day, hour, minute, second, millisecond, format) {
        function tickFormat(date) {
            return (second(date) < date ? formatMillisecond : minute(date) < date ? formatSecond : hour(date) < date ? formatMinute : day(date) < date ? formatHour : month(date) < date ? week(date) < date ? formatDay : formatWeek : year(date) < date ? formatMonth : formatYear)(date);
        }
        function tickInterval(interval, start, stop, step) {
            if (null == interval && (interval = 10), "number" == typeof interval) {
                var target = Math.abs(stop - start) / interval, i = Object(__WEBPACK_IMPORTED_MODULE_0_d3_array__.c)(function(i) {
                    return i[2];
                }).right(tickIntervals, target);
                i === tickIntervals.length ? (step = Object(__WEBPACK_IMPORTED_MODULE_0_d3_array__.g)(start / durationYear, stop / durationYear, interval), 
                interval = year) : i ? (i = tickIntervals[target / tickIntervals[i - 1][2] < tickIntervals[i][2] / target ? i - 1 : i], 
                step = i[1], interval = i[0]) : (step = Object(__WEBPACK_IMPORTED_MODULE_0_d3_array__.g)(start, stop, interval), 
                interval = millisecond);
            }
            return null == step ? interval : interval.every(step);
        }
        var scale = Object(__WEBPACK_IMPORTED_MODULE_5__continuous__.b)(__WEBPACK_IMPORTED_MODULE_5__continuous__.c, __WEBPACK_IMPORTED_MODULE_1_d3_interpolate__.c), invert = scale.invert, domain = scale.domain, formatMillisecond = format(".%L"), formatSecond = format(":%S"), formatMinute = format("%I:%M"), formatHour = format("%I %p"), formatDay = format("%a %d"), formatWeek = format("%b %d"), formatMonth = format("%B"), formatYear = format("%Y"), tickIntervals = [ [ second, 1, durationSecond ], [ second, 5, 5 * durationSecond ], [ second, 15, 15 * durationSecond ], [ second, 30, 30 * durationSecond ], [ minute, 1, durationMinute ], [ minute, 5, 5 * durationMinute ], [ minute, 15, 15 * durationMinute ], [ minute, 30, 30 * durationMinute ], [ hour, 1, durationHour ], [ hour, 3, 3 * durationHour ], [ hour, 6, 6 * durationHour ], [ hour, 12, 12 * durationHour ], [ day, 1, durationDay ], [ day, 2, 2 * durationDay ], [ week, 1, durationWeek ], [ month, 1, durationMonth ], [ month, 3, 3 * durationMonth ], [ year, 1, durationYear ] ];
        return scale.invert = function(y) {
            return new Date(invert(y));
        }, scale.domain = function(_) {
            return arguments.length ? domain(__WEBPACK_IMPORTED_MODULE_4__array__.a.call(_, number)) : domain().map(date);
        }, scale.ticks = function(interval, step) {
            var t, d = domain(), t0 = d[0], t1 = d[d.length - 1], r = t1 < t0;
            return r && (t = t0, t0 = t1, t1 = t), t = tickInterval(interval, t0, t1, step), 
            t = t ? t.range(t0, t1 + 1) : [], r ? t.reverse() : t;
        }, scale.tickFormat = function(count, specifier) {
            return null == specifier ? tickFormat : format(specifier);
        }, scale.nice = function(interval, step) {
            var d = domain();
            return (interval = tickInterval(interval, d[0], d[d.length - 1], step)) ? domain(Object(__WEBPACK_IMPORTED_MODULE_6__nice__.a)(d, interval)) : scale;
        }, scale.copy = function() {
            return Object(__WEBPACK_IMPORTED_MODULE_5__continuous__.a)(scale, calendar(year, month, week, day, hour, minute, second, millisecond, format));
        }, scale;
    }
    __webpack_exports__.a = calendar;
    var __WEBPACK_IMPORTED_MODULE_0_d3_array__ = __webpack_require__(37), __WEBPACK_IMPORTED_MODULE_1_d3_interpolate__ = __webpack_require__(92), __WEBPACK_IMPORTED_MODULE_2_d3_time__ = __webpack_require__(212), __WEBPACK_IMPORTED_MODULE_3_d3_time_format__ = __webpack_require__(361), __WEBPACK_IMPORTED_MODULE_4__array__ = __webpack_require__(62), __WEBPACK_IMPORTED_MODULE_5__continuous__ = __webpack_require__(137), __WEBPACK_IMPORTED_MODULE_6__nice__ = __webpack_require__(359), durationSecond = 1e3, durationMinute = 60 * durationSecond, durationHour = 60 * durationMinute, durationDay = 24 * durationHour, durationWeek = 7 * durationDay, durationMonth = 30 * durationDay, durationYear = 365 * durationDay;
    __webpack_exports__.b = function() {
        return calendar(__WEBPACK_IMPORTED_MODULE_2_d3_time__.k, __WEBPACK_IMPORTED_MODULE_2_d3_time__.f, __WEBPACK_IMPORTED_MODULE_2_d3_time__.j, __WEBPACK_IMPORTED_MODULE_2_d3_time__.a, __WEBPACK_IMPORTED_MODULE_2_d3_time__.b, __WEBPACK_IMPORTED_MODULE_2_d3_time__.d, __WEBPACK_IMPORTED_MODULE_2_d3_time__.g, __WEBPACK_IMPORTED_MODULE_2_d3_time__.c, __WEBPACK_IMPORTED_MODULE_3_d3_time_format__.a).domain([ new Date(2e3, 0, 1), new Date(2e3, 0, 2) ]);
    };
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    var __WEBPACK_IMPORTED_MODULE_0__src_defaultLocale__ = __webpack_require__(213);
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_defaultLocale__.a;
    }), __webpack_require__.d(__webpack_exports__, "b", function() {
        return __WEBPACK_IMPORTED_MODULE_0__src_defaultLocale__.b;
    });
    __webpack_require__(362), __webpack_require__(363), __webpack_require__(912);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function localDate(d) {
        if (0 <= d.y && d.y < 100) {
            var date = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
            return date.setFullYear(d.y), date;
        }
        return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
    }
    function utcDate(d) {
        if (0 <= d.y && d.y < 100) {
            var date = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
            return date.setUTCFullYear(d.y), date;
        }
        return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
    }
    function newYear(y) {
        return {
            y: y,
            m: 0,
            d: 1,
            H: 0,
            M: 0,
            S: 0,
            L: 0
        };
    }
    function formatLocale(locale) {
        function newFormat(specifier, formats) {
            return function(date) {
                var c, pad, format, string = [], i = -1, j = 0, n = specifier.length;
                for (date instanceof Date || (date = new Date(+date)); ++i < n; ) 37 === specifier.charCodeAt(i) && (string.push(specifier.slice(j, i)), 
                null != (pad = pads[c = specifier.charAt(++i)]) ? c = specifier.charAt(++i) : pad = "e" === c ? " " : "0", 
                (format = formats[c]) && (c = format(date, pad)), string.push(c), j = i + 1);
                return string.push(specifier.slice(j, i)), string.join("");
            };
        }
        function newParse(specifier, newDate) {
            return function(string) {
                var week, day, d = newYear(1900), i = parseSpecifier(d, specifier, string += "", 0);
                if (i != string.length) return null;
                if ("Q" in d) return new Date(d.Q);
                if ("p" in d && (d.H = d.H % 12 + 12 * d.p), "V" in d) {
                    if (d.V < 1 || d.V > 53) return null;
                    "w" in d || (d.w = 1), "Z" in d ? (week = utcDate(newYear(d.y)), day = week.getUTCDay(), 
                    week = day > 4 || 0 === day ? __WEBPACK_IMPORTED_MODULE_0_d3_time__.p.ceil(week) : Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.p)(week), 
                    week = __WEBPACK_IMPORTED_MODULE_0_d3_time__.l.offset(week, 7 * (d.V - 1)), d.y = week.getUTCFullYear(), 
                    d.m = week.getUTCMonth(), d.d = week.getUTCDate() + (d.w + 6) % 7) : (week = newDate(newYear(d.y)), 
                    day = week.getDay(), week = day > 4 || 0 === day ? __WEBPACK_IMPORTED_MODULE_0_d3_time__.e.ceil(week) : Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.e)(week), 
                    week = __WEBPACK_IMPORTED_MODULE_0_d3_time__.a.offset(week, 7 * (d.V - 1)), d.y = week.getFullYear(), 
                    d.m = week.getMonth(), d.d = week.getDate() + (d.w + 6) % 7);
                } else ("W" in d || "U" in d) && ("w" in d || (d.w = "u" in d ? d.u % 7 : "W" in d ? 1 : 0), 
                day = "Z" in d ? utcDate(newYear(d.y)).getUTCDay() : newDate(newYear(d.y)).getDay(), 
                d.m = 0, d.d = "W" in d ? (d.w + 6) % 7 + 7 * d.W - (day + 5) % 7 : d.w + 7 * d.U - (day + 6) % 7);
                return "Z" in d ? (d.H += d.Z / 100 | 0, d.M += d.Z % 100, utcDate(d)) : newDate(d);
            };
        }
        function parseSpecifier(d, specifier, string, j) {
            for (var c, parse, i = 0, n = specifier.length, m = string.length; i < n; ) {
                if (j >= m) return -1;
                if (37 === (c = specifier.charCodeAt(i++))) {
                    if (c = specifier.charAt(i++), !(parse = parses[c in pads ? specifier.charAt(i++) : c]) || (j = parse(d, string, j)) < 0) return -1;
                } else if (c != string.charCodeAt(j++)) return -1;
            }
            return j;
        }
        function parsePeriod(d, string, i) {
            var n = periodRe.exec(string.slice(i));
            return n ? (d.p = periodLookup[n[0].toLowerCase()], i + n[0].length) : -1;
        }
        function parseShortWeekday(d, string, i) {
            var n = shortWeekdayRe.exec(string.slice(i));
            return n ? (d.w = shortWeekdayLookup[n[0].toLowerCase()], i + n[0].length) : -1;
        }
        function parseWeekday(d, string, i) {
            var n = weekdayRe.exec(string.slice(i));
            return n ? (d.w = weekdayLookup[n[0].toLowerCase()], i + n[0].length) : -1;
        }
        function parseShortMonth(d, string, i) {
            var n = shortMonthRe.exec(string.slice(i));
            return n ? (d.m = shortMonthLookup[n[0].toLowerCase()], i + n[0].length) : -1;
        }
        function parseMonth(d, string, i) {
            var n = monthRe.exec(string.slice(i));
            return n ? (d.m = monthLookup[n[0].toLowerCase()], i + n[0].length) : -1;
        }
        function parseLocaleDateTime(d, string, i) {
            return parseSpecifier(d, locale_dateTime, string, i);
        }
        function parseLocaleDate(d, string, i) {
            return parseSpecifier(d, locale_date, string, i);
        }
        function parseLocaleTime(d, string, i) {
            return parseSpecifier(d, locale_time, string, i);
        }
        function formatShortWeekday(d) {
            return locale_shortWeekdays[d.getDay()];
        }
        function formatWeekday(d) {
            return locale_weekdays[d.getDay()];
        }
        function formatShortMonth(d) {
            return locale_shortMonths[d.getMonth()];
        }
        function formatMonth(d) {
            return locale_months[d.getMonth()];
        }
        function formatPeriod(d) {
            return locale_periods[+(d.getHours() >= 12)];
        }
        function formatUTCShortWeekday(d) {
            return locale_shortWeekdays[d.getUTCDay()];
        }
        function formatUTCWeekday(d) {
            return locale_weekdays[d.getUTCDay()];
        }
        function formatUTCShortMonth(d) {
            return locale_shortMonths[d.getUTCMonth()];
        }
        function formatUTCMonth(d) {
            return locale_months[d.getUTCMonth()];
        }
        function formatUTCPeriod(d) {
            return locale_periods[+(d.getUTCHours() >= 12)];
        }
        var locale_dateTime = locale.dateTime, locale_date = locale.date, locale_time = locale.time, locale_periods = locale.periods, locale_weekdays = locale.days, locale_shortWeekdays = locale.shortDays, locale_months = locale.months, locale_shortMonths = locale.shortMonths, periodRe = formatRe(locale_periods), periodLookup = formatLookup(locale_periods), weekdayRe = formatRe(locale_weekdays), weekdayLookup = formatLookup(locale_weekdays), shortWeekdayRe = formatRe(locale_shortWeekdays), shortWeekdayLookup = formatLookup(locale_shortWeekdays), monthRe = formatRe(locale_months), monthLookup = formatLookup(locale_months), shortMonthRe = formatRe(locale_shortMonths), shortMonthLookup = formatLookup(locale_shortMonths), formats = {
            a: formatShortWeekday,
            A: formatWeekday,
            b: formatShortMonth,
            B: formatMonth,
            c: null,
            d: formatDayOfMonth,
            e: formatDayOfMonth,
            f: formatMicroseconds,
            H: formatHour24,
            I: formatHour12,
            j: formatDayOfYear,
            L: formatMilliseconds,
            m: formatMonthNumber,
            M: formatMinutes,
            p: formatPeriod,
            Q: formatUnixTimestamp,
            s: formatUnixTimestampSeconds,
            S: formatSeconds,
            u: formatWeekdayNumberMonday,
            U: formatWeekNumberSunday,
            V: formatWeekNumberISO,
            w: formatWeekdayNumberSunday,
            W: formatWeekNumberMonday,
            x: null,
            X: null,
            y: formatYear,
            Y: formatFullYear,
            Z: formatZone,
            "%": formatLiteralPercent
        }, utcFormats = {
            a: formatUTCShortWeekday,
            A: formatUTCWeekday,
            b: formatUTCShortMonth,
            B: formatUTCMonth,
            c: null,
            d: formatUTCDayOfMonth,
            e: formatUTCDayOfMonth,
            f: formatUTCMicroseconds,
            H: formatUTCHour24,
            I: formatUTCHour12,
            j: formatUTCDayOfYear,
            L: formatUTCMilliseconds,
            m: formatUTCMonthNumber,
            M: formatUTCMinutes,
            p: formatUTCPeriod,
            Q: formatUnixTimestamp,
            s: formatUnixTimestampSeconds,
            S: formatUTCSeconds,
            u: formatUTCWeekdayNumberMonday,
            U: formatUTCWeekNumberSunday,
            V: formatUTCWeekNumberISO,
            w: formatUTCWeekdayNumberSunday,
            W: formatUTCWeekNumberMonday,
            x: null,
            X: null,
            y: formatUTCYear,
            Y: formatUTCFullYear,
            Z: formatUTCZone,
            "%": formatLiteralPercent
        }, parses = {
            a: parseShortWeekday,
            A: parseWeekday,
            b: parseShortMonth,
            B: parseMonth,
            c: parseLocaleDateTime,
            d: parseDayOfMonth,
            e: parseDayOfMonth,
            f: parseMicroseconds,
            H: parseHour24,
            I: parseHour24,
            j: parseDayOfYear,
            L: parseMilliseconds,
            m: parseMonthNumber,
            M: parseMinutes,
            p: parsePeriod,
            Q: parseUnixTimestamp,
            s: parseUnixTimestampSeconds,
            S: parseSeconds,
            u: parseWeekdayNumberMonday,
            U: parseWeekNumberSunday,
            V: parseWeekNumberISO,
            w: parseWeekdayNumberSunday,
            W: parseWeekNumberMonday,
            x: parseLocaleDate,
            X: parseLocaleTime,
            y: parseYear,
            Y: parseFullYear,
            Z: parseZone,
            "%": parseLiteralPercent
        };
        return formats.x = newFormat(locale_date, formats), formats.X = newFormat(locale_time, formats), 
        formats.c = newFormat(locale_dateTime, formats), utcFormats.x = newFormat(locale_date, utcFormats), 
        utcFormats.X = newFormat(locale_time, utcFormats), utcFormats.c = newFormat(locale_dateTime, utcFormats), 
        {
            format: function(specifier) {
                var f = newFormat(specifier += "", formats);
                return f.toString = function() {
                    return specifier;
                }, f;
            },
            parse: function(specifier) {
                var p = newParse(specifier += "", localDate);
                return p.toString = function() {
                    return specifier;
                }, p;
            },
            utcFormat: function(specifier) {
                var f = newFormat(specifier += "", utcFormats);
                return f.toString = function() {
                    return specifier;
                }, f;
            },
            utcParse: function(specifier) {
                var p = newParse(specifier, utcDate);
                return p.toString = function() {
                    return specifier;
                }, p;
            }
        };
    }
    function pad(value, fill, width) {
        var sign = value < 0 ? "-" : "", string = (sign ? -value : value) + "", length = string.length;
        return sign + (length < width ? new Array(width - length + 1).join(fill) + string : string);
    }
    function requote(s) {
        return s.replace(requoteRe, "\\$&");
    }
    function formatRe(names) {
        return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
    }
    function formatLookup(names) {
        for (var map = {}, i = -1, n = names.length; ++i < n; ) map[names[i].toLowerCase()] = i;
        return map;
    }
    function parseWeekdayNumberSunday(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 1));
        return n ? (d.w = +n[0], i + n[0].length) : -1;
    }
    function parseWeekdayNumberMonday(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 1));
        return n ? (d.u = +n[0], i + n[0].length) : -1;
    }
    function parseWeekNumberSunday(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 2));
        return n ? (d.U = +n[0], i + n[0].length) : -1;
    }
    function parseWeekNumberISO(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 2));
        return n ? (d.V = +n[0], i + n[0].length) : -1;
    }
    function parseWeekNumberMonday(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 2));
        return n ? (d.W = +n[0], i + n[0].length) : -1;
    }
    function parseFullYear(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 4));
        return n ? (d.y = +n[0], i + n[0].length) : -1;
    }
    function parseYear(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 2));
        return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2e3), i + n[0].length) : -1;
    }
    function parseZone(d, string, i) {
        var n = /^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string.slice(i, i + 6));
        return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i + n[0].length) : -1;
    }
    function parseMonthNumber(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 2));
        return n ? (d.m = n[0] - 1, i + n[0].length) : -1;
    }
    function parseDayOfMonth(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 2));
        return n ? (d.d = +n[0], i + n[0].length) : -1;
    }
    function parseDayOfYear(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 3));
        return n ? (d.m = 0, d.d = +n[0], i + n[0].length) : -1;
    }
    function parseHour24(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 2));
        return n ? (d.H = +n[0], i + n[0].length) : -1;
    }
    function parseMinutes(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 2));
        return n ? (d.M = +n[0], i + n[0].length) : -1;
    }
    function parseSeconds(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 2));
        return n ? (d.S = +n[0], i + n[0].length) : -1;
    }
    function parseMilliseconds(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 3));
        return n ? (d.L = +n[0], i + n[0].length) : -1;
    }
    function parseMicroseconds(d, string, i) {
        var n = numberRe.exec(string.slice(i, i + 6));
        return n ? (d.L = Math.floor(n[0] / 1e3), i + n[0].length) : -1;
    }
    function parseLiteralPercent(d, string, i) {
        var n = percentRe.exec(string.slice(i, i + 1));
        return n ? i + n[0].length : -1;
    }
    function parseUnixTimestamp(d, string, i) {
        var n = numberRe.exec(string.slice(i));
        return n ? (d.Q = +n[0], i + n[0].length) : -1;
    }
    function parseUnixTimestampSeconds(d, string, i) {
        var n = numberRe.exec(string.slice(i));
        return n ? (d.Q = 1e3 * +n[0], i + n[0].length) : -1;
    }
    function formatDayOfMonth(d, p) {
        return pad(d.getDate(), p, 2);
    }
    function formatHour24(d, p) {
        return pad(d.getHours(), p, 2);
    }
    function formatHour12(d, p) {
        return pad(d.getHours() % 12 || 12, p, 2);
    }
    function formatDayOfYear(d, p) {
        return pad(1 + __WEBPACK_IMPORTED_MODULE_0_d3_time__.a.count(Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.k)(d), d), p, 3);
    }
    function formatMilliseconds(d, p) {
        return pad(d.getMilliseconds(), p, 3);
    }
    function formatMicroseconds(d, p) {
        return formatMilliseconds(d, p) + "000";
    }
    function formatMonthNumber(d, p) {
        return pad(d.getMonth() + 1, p, 2);
    }
    function formatMinutes(d, p) {
        return pad(d.getMinutes(), p, 2);
    }
    function formatSeconds(d, p) {
        return pad(d.getSeconds(), p, 2);
    }
    function formatWeekdayNumberMonday(d) {
        var day = d.getDay();
        return 0 === day ? 7 : day;
    }
    function formatWeekNumberSunday(d, p) {
        return pad(__WEBPACK_IMPORTED_MODULE_0_d3_time__.h.count(Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.k)(d), d), p, 2);
    }
    function formatWeekNumberISO(d, p) {
        var day = d.getDay();
        return d = day >= 4 || 0 === day ? Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.i)(d) : __WEBPACK_IMPORTED_MODULE_0_d3_time__.i.ceil(d), 
        pad(__WEBPACK_IMPORTED_MODULE_0_d3_time__.i.count(Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.k)(d), d) + (4 === Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.k)(d).getDay()), p, 2);
    }
    function formatWeekdayNumberSunday(d) {
        return d.getDay();
    }
    function formatWeekNumberMonday(d, p) {
        return pad(__WEBPACK_IMPORTED_MODULE_0_d3_time__.e.count(Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.k)(d), d), p, 2);
    }
    function formatYear(d, p) {
        return pad(d.getFullYear() % 100, p, 2);
    }
    function formatFullYear(d, p) {
        return pad(d.getFullYear() % 1e4, p, 4);
    }
    function formatZone(d) {
        var z = d.getTimezoneOffset();
        return (z > 0 ? "-" : (z *= -1, "+")) + pad(z / 60 | 0, "0", 2) + pad(z % 60, "0", 2);
    }
    function formatUTCDayOfMonth(d, p) {
        return pad(d.getUTCDate(), p, 2);
    }
    function formatUTCHour24(d, p) {
        return pad(d.getUTCHours(), p, 2);
    }
    function formatUTCHour12(d, p) {
        return pad(d.getUTCHours() % 12 || 12, p, 2);
    }
    function formatUTCDayOfYear(d, p) {
        return pad(1 + __WEBPACK_IMPORTED_MODULE_0_d3_time__.l.count(Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.v)(d), d), p, 3);
    }
    function formatUTCMilliseconds(d, p) {
        return pad(d.getUTCMilliseconds(), p, 3);
    }
    function formatUTCMicroseconds(d, p) {
        return formatUTCMilliseconds(d, p) + "000";
    }
    function formatUTCMonthNumber(d, p) {
        return pad(d.getUTCMonth() + 1, p, 2);
    }
    function formatUTCMinutes(d, p) {
        return pad(d.getUTCMinutes(), p, 2);
    }
    function formatUTCSeconds(d, p) {
        return pad(d.getUTCSeconds(), p, 2);
    }
    function formatUTCWeekdayNumberMonday(d) {
        var dow = d.getUTCDay();
        return 0 === dow ? 7 : dow;
    }
    function formatUTCWeekNumberSunday(d, p) {
        return pad(__WEBPACK_IMPORTED_MODULE_0_d3_time__.s.count(Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.v)(d), d), p, 2);
    }
    function formatUTCWeekNumberISO(d, p) {
        var day = d.getUTCDay();
        return d = day >= 4 || 0 === day ? Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.t)(d) : __WEBPACK_IMPORTED_MODULE_0_d3_time__.t.ceil(d), 
        pad(__WEBPACK_IMPORTED_MODULE_0_d3_time__.t.count(Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.v)(d), d) + (4 === Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.v)(d).getUTCDay()), p, 2);
    }
    function formatUTCWeekdayNumberSunday(d) {
        return d.getUTCDay();
    }
    function formatUTCWeekNumberMonday(d, p) {
        return pad(__WEBPACK_IMPORTED_MODULE_0_d3_time__.p.count(Object(__WEBPACK_IMPORTED_MODULE_0_d3_time__.v)(d), d), p, 2);
    }
    function formatUTCYear(d, p) {
        return pad(d.getUTCFullYear() % 100, p, 2);
    }
    function formatUTCFullYear(d, p) {
        return pad(d.getUTCFullYear() % 1e4, p, 4);
    }
    function formatUTCZone() {
        return "+0000";
    }
    function formatLiteralPercent() {
        return "%";
    }
    function formatUnixTimestamp(d) {
        return +d;
    }
    function formatUnixTimestampSeconds(d) {
        return Math.floor(+d / 1e3);
    }
    __webpack_exports__.a = formatLocale;
    var __WEBPACK_IMPORTED_MODULE_0_d3_time__ = __webpack_require__(212), pads = {
        "-": "",
        _: " ",
        "0": "0"
    }, numberRe = /^\s*\d+/, percentRe = /^%/, requoteRe = /[\\^$*+?|[\]().{}]/g;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function formatIsoNative(date) {
        return date.toISOString();
    }
    __webpack_require__.d(__webpack_exports__, "a", function() {
        return isoSpecifier;
    });
    var __WEBPACK_IMPORTED_MODULE_0__defaultLocale__ = __webpack_require__(213), isoSpecifier = "%Y-%m-%dT%H:%M:%S.%LZ";
    Date.prototype.toISOString || Object(__WEBPACK_IMPORTED_MODULE_0__defaultLocale__.b)(isoSpecifier);
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__), __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__), __WEBPACK_IMPORTED_MODULE_3_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_3_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_classnames__), __WEBPACK_IMPORTED_MODULE_4__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_5__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_6__shape_Dot__ = __webpack_require__(63), __WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_8__component_Label__ = __webpack_require__(44), __WEBPACK_IMPORTED_MODULE_9__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_10__util_ChartUtils__ = __webpack_require__(16), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), ReferenceDot = Object(__WEBPACK_IMPORTED_MODULE_4__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function ReferenceDot() {
            return _classCallCheck(this, ReferenceDot), _possibleConstructorReturn(this, (ReferenceDot.__proto__ || Object.getPrototypeOf(ReferenceDot)).apply(this, arguments));
        }
        return _inherits(ReferenceDot, _Component), _createClass(ReferenceDot, [ {
            key: "getCoordinate",
            value: function() {
                var _props = this.props, x = _props.x, y = _props.y, xAxis = _props.xAxis, yAxis = _props.yAxis, xScale = xAxis.scale, yScale = yAxis.scale, result = {
                    cx: xScale(x) + (xScale.bandwidth ? xScale.bandwidth() / 2 : 0),
                    cy: yScale(y) + (yScale.bandwidth ? yScale.bandwidth() / 2 : 0)
                };
                return Object(__WEBPACK_IMPORTED_MODULE_10__util_ChartUtils__.D)(result.cx, xScale) && Object(__WEBPACK_IMPORTED_MODULE_10__util_ChartUtils__.D)(result.cy, yScale) ? result : null;
            }
        }, {
            key: "renderDot",
            value: function(option, props) {
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_1_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__shape_Dot__.a, _extends({}, props, {
                    cx: props.cx,
                    cy: props.cy,
                    className: "recharts-reference-dot-dot"
                }));
            }
        }, {
            key: "render",
            value: function() {
                var _props2 = this.props, x = _props2.x, y = _props2.y, r = _props2.r, isX = Object(__WEBPACK_IMPORTED_MODULE_9__util_DataUtils__.g)(x), isY = Object(__WEBPACK_IMPORTED_MODULE_9__util_DataUtils__.g)(y);
                if (!isX || !isY) return null;
                var coordinate = this.getCoordinate();
                if (!coordinate) return null;
                var _props3 = this.props, shape = _props3.shape, className = _props3.className, dotProps = _extends({}, Object(__WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__.k)(this.props), Object(__WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__.e)(this.props), coordinate);
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__container_Layer__.a, {
                    className: __WEBPACK_IMPORTED_MODULE_3_classnames___default()("recharts-reference-dot", className)
                }, this.renderDot(shape, dotProps), __WEBPACK_IMPORTED_MODULE_8__component_Label__.a.renderCallByParent(this.props, {
                    x: coordinate.cx - r,
                    y: coordinate.cy - r,
                    width: 2 * r,
                    height: 2 * r
                }));
            }
        } ]), ReferenceDot;
    }(__WEBPACK_IMPORTED_MODULE_1_react__.Component), _class2.displayName = "ReferenceDot", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__.c, __WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__.a, {
        r: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        xAxis: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.shape({
            scale: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func
        }),
        yAxis: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.shape({
            scale: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func
        }),
        isFront: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
        alwaysShow: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
        x: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        y: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        className: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        yAxisId: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number ]),
        xAxisId: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number ]),
        shape: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.element ])
    }), _class2.defaultProps = {
        isFront: !1,
        alwaysShow: !1,
        xAxisId: 0,
        yAxisId: 0,
        r: 10,
        fill: "#fff",
        stroke: "#ccc",
        fillOpacity: 1,
        strokeWidth: 1
    }, _class = _temp)) || _class;
    __webpack_exports__.a = ReferenceDot;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__), __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__), __WEBPACK_IMPORTED_MODULE_3_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_3_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_classnames__), __WEBPACK_IMPORTED_MODULE_4__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_5__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_7__component_Label__ = __webpack_require__(44), __WEBPACK_IMPORTED_MODULE_8__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_9__util_ChartUtils__ = __webpack_require__(16), _slicedToArray = function() {
        function sliceIterator(arr, i) {
            var _arr = [], _n = !0, _d = !1, _e = void 0;
            try {
                for (var _s, _i = arr[Symbol.iterator](); !(_n = (_s = _i.next()).done) && (_arr.push(_s.value), 
                !i || _arr.length !== i); _n = !0) ;
            } catch (err) {
                _d = !0, _e = err;
            } finally {
                try {
                    !_n && _i.return && _i.return();
                } finally {
                    if (_d) throw _e;
                }
            }
            return _arr;
        }
        return function(arr, i) {
            if (Array.isArray(arr)) return arr;
            if (Symbol.iterator in Object(arr)) return sliceIterator(arr, i);
            throw new TypeError("Invalid attempt to destructure non-iterable instance");
        };
    }(), _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, renderLine = function(option, props) {
        return __WEBPACK_IMPORTED_MODULE_1_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_1_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement("line", _extends({}, props, {
            className: "recharts-reference-line-line"
        }));
    }, ReferenceLine = Object(__WEBPACK_IMPORTED_MODULE_4__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function ReferenceLine() {
            return _classCallCheck(this, ReferenceLine), _possibleConstructorReturn(this, (ReferenceLine.__proto__ || Object.getPrototypeOf(ReferenceLine)).apply(this, arguments));
        }
        return _inherits(ReferenceLine, _Component), _createClass(ReferenceLine, [ {
            key: "getEndPoints",
            value: function(isX, isY) {
                var _props = this.props, xAxis = _props.xAxis, yAxis = _props.yAxis, viewBox = _props.viewBox, x = viewBox.x, y = viewBox.y, width = viewBox.width, height = viewBox.height;
                if (isY) {
                    var value = this.props.y, scale = yAxis.scale, offset = scale.bandwidth ? scale.bandwidth() / 2 : 0, coord = scale(value) + offset;
                    if (Object(__WEBPACK_IMPORTED_MODULE_9__util_ChartUtils__.D)(coord, scale)) return "left" === yAxis.orientation ? [ {
                        x: x,
                        y: coord
                    }, {
                        x: x + width,
                        y: coord
                    } ] : [ {
                        x: x + width,
                        y: coord
                    }, {
                        x: x,
                        y: coord
                    } ];
                } else if (isX) {
                    var _value = this.props.x, _scale = xAxis.scale, _offset = _scale.bandwidth ? _scale.bandwidth() / 2 : 0, _coord = _scale(_value) + _offset;
                    if (Object(__WEBPACK_IMPORTED_MODULE_9__util_ChartUtils__.D)(_coord, _scale)) return "top" === xAxis.orientation ? [ {
                        x: _coord,
                        y: y
                    }, {
                        x: _coord,
                        y: y + height
                    } ] : [ {
                        x: _coord,
                        y: y + height
                    }, {
                        x: _coord,
                        y: y
                    } ];
                }
                return null;
            }
        }, {
            key: "render",
            value: function() {
                var _props2 = this.props, x = _props2.x, y = _props2.y, shape = _props2.shape, className = _props2.className, isX = Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.g)(x), isY = Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.g)(y);
                if (!isX && !isY) return null;
                var endPoints = this.getEndPoints(isX, isY);
                if (!endPoints) return null;
                var _endPoints = _slicedToArray(endPoints, 2), start = _endPoints[0], end = _endPoints[1], props = _extends({}, Object(__WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__.k)(this.props), Object(__WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__.e)(this.props), {
                    x1: start.x,
                    y1: start.y,
                    x2: end.x,
                    y2: end.y
                });
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__container_Layer__.a, {
                    className: __WEBPACK_IMPORTED_MODULE_3_classnames___default()("recharts-reference-line", className)
                }, renderLine(shape, props), __WEBPACK_IMPORTED_MODULE_7__component_Label__.a.renderCallByParent(this.props, {
                    x: Math.min(props.x1, props.x2),
                    y: Math.min(props.y1, props.y2),
                    width: Math.abs(props.x2 - props.x1),
                    height: Math.abs(props.y2 - props.y1)
                }));
            }
        } ]), ReferenceLine;
    }(__WEBPACK_IMPORTED_MODULE_1_react__.Component), _class2.displayName = "ReferenceLine", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_6__util_ReactUtils__.c, {
        viewBox: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            width: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            height: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number
        }),
        xAxis: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object,
        yAxis: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object,
        isFront: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
        alwaysShow: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
        x: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        y: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        className: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        yAxisId: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number ]),
        xAxisId: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number ]),
        shape: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func
    }), _class2.defaultProps = {
        isFront: !1,
        alwaysShow: !1,
        xAxisId: 0,
        yAxisId: 0,
        fill: "none",
        stroke: "#ccc",
        fillOpacity: 1,
        strokeWidth: 1
    }, _class = _temp)) || _class;
    __webpack_exports__.a = ReferenceLine;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__), __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__), __WEBPACK_IMPORTED_MODULE_3_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_3_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_classnames__), __WEBPACK_IMPORTED_MODULE_4__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_5__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_6__component_Label__ = __webpack_require__(44), __WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_8__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_9__util_ChartUtils__ = __webpack_require__(16), __WEBPACK_IMPORTED_MODULE_10__shape_Rectangle__ = __webpack_require__(70), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), ReferenceArea = Object(__WEBPACK_IMPORTED_MODULE_4__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function ReferenceArea() {
            return _classCallCheck(this, ReferenceArea), _possibleConstructorReturn(this, (ReferenceArea.__proto__ || Object.getPrototypeOf(ReferenceArea)).apply(this, arguments));
        }
        return _inherits(ReferenceArea, _Component), _createClass(ReferenceArea, [ {
            key: "getRect",
            value: function(hasX1, hasX2, hasY1, hasY2) {
                var _props = this.props, xValue1 = _props.x1, xValue2 = _props.x2, yValue1 = _props.y1, yValue2 = _props.y2, xAxis = _props.xAxis, yAxis = _props.yAxis, xScale = xAxis.scale, yScale = yAxis.scale, xOffset = xScale.bandwidth ? xScale.bandwidth() / 2 : 0, yOffset = yScale.bandwidth ? yScale.bandwidth() / 2 : 0, xRange = xScale.range(), yRange = yScale.range(), x1 = void 0, x2 = void 0, y1 = void 0, y2 = void 0;
                return x1 = hasX1 ? xScale(xValue1) + xOffset : xRange[0], x2 = hasX2 ? xScale(xValue2) + xOffset : xRange[1], 
                y1 = hasY1 ? yScale(yValue1) + yOffset : yRange[0], y2 = hasY2 ? yScale(yValue2) + yOffset : yRange[1], 
                Object(__WEBPACK_IMPORTED_MODULE_9__util_ChartUtils__.D)(x1, xScale) && Object(__WEBPACK_IMPORTED_MODULE_9__util_ChartUtils__.D)(x2, xScale) && Object(__WEBPACK_IMPORTED_MODULE_9__util_ChartUtils__.D)(y1, yScale) && Object(__WEBPACK_IMPORTED_MODULE_9__util_ChartUtils__.D)(y2, yScale) ? {
                    x: Math.min(x1, x2),
                    y: Math.min(y1, y2),
                    width: Math.abs(x2 - x1),
                    height: Math.abs(y2 - y1)
                } : null;
            }
        }, {
            key: "renderRect",
            value: function(option, props) {
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_1_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__shape_Rectangle__.a, _extends({}, props, {
                    className: "recharts-reference-area-rect"
                }));
            }
        }, {
            key: "render",
            value: function() {
                var _props2 = this.props, x1 = _props2.x1, x2 = _props2.x2, y1 = _props2.y1, y2 = _props2.y2, className = _props2.className, hasX1 = Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.g)(x1), hasX2 = Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.g)(x2), hasY1 = Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.g)(y1), hasY2 = Object(__WEBPACK_IMPORTED_MODULE_8__util_DataUtils__.g)(y2);
                if (!(hasX1 || hasX2 || hasY1 || hasY2)) return null;
                var rect = this.getRect(hasX1, hasX2, hasY1, hasY2);
                if (!rect) return null;
                var shape = this.props.shape;
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__container_Layer__.a, {
                    className: __WEBPACK_IMPORTED_MODULE_3_classnames___default()("recharts-reference-area", className)
                }, this.renderRect(shape, _extends({}, this.props, rect)), __WEBPACK_IMPORTED_MODULE_6__component_Label__.a.renderCallByParent(this.props, rect));
            }
        } ]), ReferenceArea;
    }(__WEBPACK_IMPORTED_MODULE_1_react__.Component), _class2.displayName = "ReferenceArea", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_7__util_ReactUtils__.c, {
        viewBox: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            width: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            height: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number
        }),
        xAxis: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object,
        yAxis: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object,
        isFront: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
        alwaysShow: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
        x1: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        x2: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        y1: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        y2: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        className: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string ]),
        yAxisId: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number ]),
        xAxisId: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number ]),
        shape: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.element ])
    }), _class2.defaultProps = {
        isFront: !1,
        alwaysShow: !1,
        xAxisId: 0,
        yAxisId: 0,
        r: 10,
        fill: "#ccc",
        fillOpacity: .5,
        stroke: "none",
        strokeWidth: 1
    }, _class = _temp)) || _class;
    __webpack_exports__.a = ReferenceArea;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__), __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__), __WEBPACK_IMPORTED_MODULE_2_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_2_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_classnames__), __WEBPACK_IMPORTED_MODULE_3__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_4__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__ = __webpack_require__(4), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), Cross = Object(__WEBPACK_IMPORTED_MODULE_3__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function Cross() {
            return _classCallCheck(this, Cross), _possibleConstructorReturn(this, (Cross.__proto__ || Object.getPrototypeOf(Cross)).apply(this, arguments));
        }
        return _inherits(Cross, _Component), _createClass(Cross, [ {
            key: "getPath",
            value: function(x, y, width, height, top, left) {
                return "M" + x + "," + top + "v" + height + "M" + left + "," + y + "h" + width;
            }
        }, {
            key: "render",
            value: function() {
                var _props = this.props, x = _props.x, y = _props.y, width = _props.width, height = _props.height, top = _props.top, left = _props.left, className = _props.className;
                return Object(__WEBPACK_IMPORTED_MODULE_4__util_DataUtils__.h)(x) && Object(__WEBPACK_IMPORTED_MODULE_4__util_DataUtils__.h)(y) && Object(__WEBPACK_IMPORTED_MODULE_4__util_DataUtils__.h)(width) && Object(__WEBPACK_IMPORTED_MODULE_4__util_DataUtils__.h)(height) && Object(__WEBPACK_IMPORTED_MODULE_4__util_DataUtils__.h)(top) && Object(__WEBPACK_IMPORTED_MODULE_4__util_DataUtils__.h)(left) ? __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement("path", _extends({}, Object(__WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.k)(this.props), {
                    className: __WEBPACK_IMPORTED_MODULE_2_classnames___default()("recharts-cross", className),
                    d: this.getPath(x, y, width, height, top, left)
                })) : null;
            }
        } ]), Cross;
    }(__WEBPACK_IMPORTED_MODULE_0_react__.Component), _class2.displayName = "Cross", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_5__util_ReactUtils__.c, {
        x: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        y: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        width: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        height: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        top: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        left: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,
        className: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string
    }), _class2.defaultProps = {
        x: 0,
        y: 0,
        top: 0,
        left: 0,
        width: 0,
        height: 0
    }, _class = _temp)) || _class;
    __webpack_exports__.a = Cross;
}, function(module, exports, __webpack_require__) {
    function maxBy(array, iteratee) {
        return array && array.length ? baseExtremum(array, baseIteratee(iteratee, 2), baseGt) : void 0;
    }
    var baseExtremum = __webpack_require__(135), baseGt = __webpack_require__(327), baseIteratee = __webpack_require__(89);
    module.exports = maxBy;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp2, __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__ = __webpack_require__(45), __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__), __WEBPACK_IMPORTED_MODULE_1_lodash_isPlainObject__ = __webpack_require__(925), __WEBPACK_IMPORTED_MODULE_1_lodash_isPlainObject___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isPlainObject__), __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_3_lodash_isNil__ = __webpack_require__(20), __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_lodash_isNil__), __WEBPACK_IMPORTED_MODULE_4_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_4_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_react__), __WEBPACK_IMPORTED_MODULE_5_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_5_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_prop_types__), __WEBPACK_IMPORTED_MODULE_6_react_smooth__ = __webpack_require__(33), __WEBPACK_IMPORTED_MODULE_6_react_smooth___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_react_smooth__), __WEBPACK_IMPORTED_MODULE_7_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_7_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_classnames__), __WEBPACK_IMPORTED_MODULE_8__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_9__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_10__shape_Sector__ = __webpack_require__(139), __WEBPACK_IMPORTED_MODULE_11__shape_Curve__ = __webpack_require__(71), __WEBPACK_IMPORTED_MODULE_12__component_Text__ = __webpack_require__(61), __WEBPACK_IMPORTED_MODULE_13__component_Label__ = __webpack_require__(44), __WEBPACK_IMPORTED_MODULE_14__component_LabelList__ = __webpack_require__(47), __WEBPACK_IMPORTED_MODULE_15__component_Cell__ = __webpack_require__(88), __WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_17__util_PolarUtils__ = __webpack_require__(23), __WEBPACK_IMPORTED_MODULE_18__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_19__util_ChartUtils__ = __webpack_require__(16), __WEBPACK_IMPORTED_MODULE_20__util_LogUtils__ = __webpack_require__(312), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), Pie = Object(__WEBPACK_IMPORTED_MODULE_8__util_PureRender__.a)((_temp2 = _class2 = function(_Component) {
        function Pie() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, Pie);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = Pie.__proto__ || Object.getPrototypeOf(Pie)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                isAnimationFinished: !1,
                isAnimationStarted: !1
            }, _this.id = Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.k)("recharts-pie-"), 
            _this.cachePrevData = function(sectors) {
                _this.setState({
                    prevSectors: sectors
                });
            }, _this.handleAnimationEnd = function() {
                _this.setState({
                    isAnimationFinished: !0
                });
            }, _this.handleAnimationStart = function() {
                _this.setState({
                    isAnimationStarted: !0
                });
            }, _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(Pie, _Component), _createClass(Pie, [ {
            key: "componentWillReceiveProps",
            value: function(nextProps) {
                var _props = this.props, animationId = _props.animationId, sectors = _props.sectors;
                nextProps.isAnimationActive !== this.props.isAnimationActive ? this.cachePrevData([]) : nextProps.animationId !== animationId && this.cachePrevData(sectors);
            }
        }, {
            key: "getTextAnchor",
            value: function(x, cx) {
                return x > cx ? "start" : x < cx ? "end" : "middle";
            }
        }, {
            key: "isActiveIndex",
            value: function(i) {
                var activeIndex = this.props.activeIndex;
                return Array.isArray(activeIndex) ? -1 !== activeIndex.indexOf(i) : i === activeIndex;
            }
        }, {
            key: "renderLabelLineItem",
            value: function(option, props) {
                return __WEBPACK_IMPORTED_MODULE_4_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_4_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_11__shape_Curve__.a, _extends({}, props, {
                    type: "linear",
                    className: "recharts-pie-label-line"
                }));
            }
        }, {
            key: "renderLabelItem",
            value: function(option, props, value) {
                if (__WEBPACK_IMPORTED_MODULE_4_react___default.a.isValidElement(option)) return __WEBPACK_IMPORTED_MODULE_4_react___default.a.cloneElement(option, props);
                var label = value;
                return __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction___default()(option) && (label = option(props), 
                __WEBPACK_IMPORTED_MODULE_4_react___default.a.isValidElement(label)) ? label : __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_12__component_Text__.a, _extends({}, props, {
                    alignmentBaseline: "middle",
                    className: "recharts-pie-label-text"
                }), label);
            }
        }, {
            key: "renderLabels",
            value: function(sectors) {
                var _this2 = this;
                if (this.props.isAnimationActive && !this.state.isAnimationFinished) return null;
                var _props2 = this.props, label = _props2.label, labelLine = _props2.labelLine, dataKey = _props2.dataKey, valueKey = _props2.valueKey, pieProps = Object(__WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__.k)(this.props), customLabelProps = Object(__WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__.k)(label), customLabelLineProps = Object(__WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__.k)(labelLine), offsetRadius = label && label.offsetRadius || 20, labels = sectors.map(function(entry, i) {
                    var midAngle = (entry.startAngle + entry.endAngle) / 2, endPoint = Object(__WEBPACK_IMPORTED_MODULE_17__util_PolarUtils__.e)(entry.cx, entry.cy, entry.outerRadius + offsetRadius, midAngle), labelProps = _extends({}, pieProps, entry, {
                        stroke: "none"
                    }, customLabelProps, {
                        index: i,
                        textAnchor: _this2.getTextAnchor(endPoint.x, entry.cx)
                    }, endPoint), lineProps = _extends({}, pieProps, entry, {
                        fill: "none",
                        stroke: entry.fill
                    }, customLabelLineProps, {
                        index: i,
                        points: [ Object(__WEBPACK_IMPORTED_MODULE_17__util_PolarUtils__.e)(entry.cx, entry.cy, entry.outerRadius, midAngle), endPoint ]
                    }), realDataKey = dataKey;
                    return __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(dataKey) && __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(valueKey) ? realDataKey = "value" : __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(dataKey) && (realDataKey = valueKey), 
                    __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__container_Layer__.a, {
                        key: "label-" + i
                    }, labelLine && _this2.renderLabelLineItem(labelLine, lineProps), _this2.renderLabelItem(label, labelProps, Object(__WEBPACK_IMPORTED_MODULE_19__util_ChartUtils__.w)(entry, realDataKey)));
                });
                return __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__container_Layer__.a, {
                    className: "recharts-pie-labels"
                }, labels);
            }
        }, {
            key: "renderSectorItem",
            value: function(option, props) {
                return __WEBPACK_IMPORTED_MODULE_4_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_4_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_2_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_1_lodash_isPlainObject___default()(option) ? __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__shape_Sector__.a, _extends({}, props, option)) : __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__shape_Sector__.a, props);
            }
        }, {
            key: "renderSectorsStatically",
            value: function(sectors) {
                var _this3 = this, activeShape = this.props.activeShape;
                return sectors.map(function(entry, i) {
                    return __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__container_Layer__.a, _extends({
                        className: "recharts-pie-sector"
                    }, Object(__WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__.f)(_this3.props, entry, i), {
                        key: "sector-" + i
                    }), _this3.renderSectorItem(_this3.isActiveIndex(i) ? activeShape : null, entry));
                });
            }
        }, {
            key: "renderSectorsWithAnimation",
            value: function() {
                var _this4 = this, _props3 = this.props, sectors = _props3.sectors, isAnimationActive = _props3.isAnimationActive, animationBegin = _props3.animationBegin, animationDuration = _props3.animationDuration, animationEasing = _props3.animationEasing, animationId = _props3.animationId, prevSectors = this.state.prevSectors;
                return __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6_react_smooth___default.a, {
                    begin: animationBegin,
                    duration: animationDuration,
                    isActive: isAnimationActive,
                    easing: animationEasing,
                    from: {
                        t: 0
                    },
                    to: {
                        t: 1
                    },
                    key: "pie-" + animationId,
                    onAnimationEnd: this.handleAnimationEnd
                }, function(_ref2) {
                    var t = _ref2.t, stepData = [], first = sectors && sectors[0], curAngle = first.startAngle;
                    return sectors.forEach(function(entry, index) {
                        var prev = prevSectors && prevSectors[index], paddingAngle = index > 0 ? entry.paddingAngle : 0;
                        if (prev) {
                            var angleIp = Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.f)(prev.endAngle - prev.startAngle, entry.endAngle - entry.startAngle), latest = _extends({}, entry, {
                                startAngle: curAngle + paddingAngle,
                                endAngle: curAngle + angleIp(t) + paddingAngle
                            });
                            stepData.push(latest), curAngle = latest.endAngle;
                        } else {
                            var endAngle = entry.endAngle, startAngle = entry.startAngle, interpolatorAngle = Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.f)(0, endAngle - startAngle), deltaAngle = interpolatorAngle(t), _latest = _extends({}, entry, {
                                startAngle: curAngle + paddingAngle,
                                endAngle: curAngle + deltaAngle + paddingAngle
                            });
                            stepData.push(_latest), curAngle = _latest.endAngle;
                        }
                    }), __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__container_Layer__.a, null, _this4.renderSectorsStatically(stepData));
                });
            }
        }, {
            key: "renderSectors",
            value: function() {
                var _props4 = this.props, sectors = _props4.sectors, isAnimationActive = _props4.isAnimationActive, prevSectors = this.state.prevSectors;
                return !(isAnimationActive && sectors && sectors.length) || prevSectors && __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default()(prevSectors, sectors) ? this.renderSectorsStatically(sectors) : this.renderSectorsWithAnimation();
            }
        }, {
            key: "render",
            value: function() {
                var _props5 = this.props, hide = _props5.hide, sectors = _props5.sectors, className = _props5.className, label = _props5.label, cx = _props5.cx, cy = _props5.cy, innerRadius = _props5.innerRadius, outerRadius = _props5.outerRadius, isAnimationActive = _props5.isAnimationActive, id = _props5.id;
                if (hide || !sectors || !sectors.length || !Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.h)(cx) || !Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.h)(cy) || !Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.h)(innerRadius) || !Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.h)(outerRadius)) return null;
                var isAnimationFinished = this.state.isAnimationFinished, layerClass = __WEBPACK_IMPORTED_MODULE_7_classnames___default()("recharts-pie", className);
                return __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__container_Layer__.a, {
                    className: layerClass
                }, __WEBPACK_IMPORTED_MODULE_4_react___default.a.createElement("g", {
                    clipPath: "url(#" + (__WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(id) ? this.id : id) + ")"
                }, this.renderSectors()), label && this.renderLabels(sectors), __WEBPACK_IMPORTED_MODULE_13__component_Label__.a.renderCallByParent(this.props, null, !1), (!isAnimationActive || isAnimationFinished) && __WEBPACK_IMPORTED_MODULE_14__component_LabelList__.a.renderCallByParent(this.props, sectors, !1));
            }
        } ]), Pie;
    }(__WEBPACK_IMPORTED_MODULE_4_react__.Component), _class2.displayName = "Pie", _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__.c, __WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__.a, {
        className: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string,
        animationId: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        cx: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string ]),
        cy: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string ]),
        startAngle: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        endAngle: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        paddingAngle: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        innerRadius: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string ]),
        outerRadius: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string ]),
        cornerRadius: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string ]),
        dataKey: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func ]).isRequired,
        nameKey: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func ]),
        valueKey: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func ]),
        data: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.object),
        minAngle: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        legendType: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOf(__WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__.b),
        maxRadius: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        sectors: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.object),
        hide: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.bool,
        labelLine: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.bool ]),
        label: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.shape({
            offsetRadius: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number
        }), __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.bool ]),
        activeShape: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.element ]),
        activeIndex: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number) ]),
        isAnimationActive: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.bool,
        animationBegin: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        animationDuration: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,
        animationEasing: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOf([ "ease", "ease-in", "ease-out", "ease-in-out", "spring", "linear" ]),
        id: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string
    }), _class2.defaultProps = {
        stroke: "#fff",
        fill: "#808080",
        legendType: "rect",
        cx: "50%",
        cy: "50%",
        startAngle: 0,
        endAngle: 360,
        innerRadius: 0,
        outerRadius: "80%",
        paddingAngle: 0,
        labelLine: !0,
        hide: !1,
        minAngle: 0,
        isAnimationActive: !Object(__WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__.n)(),
        animationBegin: 400,
        animationDuration: 1500,
        animationEasing: "ease",
        nameKey: "name"
    }, _class2.parseDeltaAngle = function(_ref3) {
        var startAngle = _ref3.startAngle, endAngle = _ref3.endAngle;
        return Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.j)(endAngle - startAngle) * Math.min(Math.abs(endAngle - startAngle), 360);
    }, _class2.getRealPieData = function(item) {
        var _item$props = item.props, data = _item$props.data, children = _item$props.children, presentationProps = Object(__WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__.k)(item.props), cells = Object(__WEBPACK_IMPORTED_MODULE_16__util_ReactUtils__.h)(children, __WEBPACK_IMPORTED_MODULE_15__component_Cell__.a);
        return data && data.length ? data.map(function(entry, index) {
            return _extends({
                payload: entry
            }, presentationProps, entry, cells && cells[index] && cells[index].props);
        }) : cells && cells.length ? cells.map(function(cell) {
            return _extends({}, presentationProps, cell.props);
        }) : [];
    }, _class2.parseCoordinateOfPie = function(item, offset) {
        var top = offset.top, left = offset.left, width = offset.width, height = offset.height, maxPieRadius = Object(__WEBPACK_IMPORTED_MODULE_17__util_PolarUtils__.c)(width, height);
        return {
            cx: left + Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.d)(item.props.cx, width, width / 2),
            cy: top + Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.d)(item.props.cy, height, height / 2),
            innerRadius: Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.d)(item.props.innerRadius, maxPieRadius, 0),
            outerRadius: Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.d)(item.props.outerRadius, maxPieRadius, .8 * maxPieRadius),
            maxRadius: item.props.maxRadius || Math.sqrt(width * width + height * height) / 2
        };
    }, _class2.getComposedData = function(_ref4) {
        var item = _ref4.item, offset = _ref4.offset, onItemMouseLeave = _ref4.onItemMouseLeave, onItemMouseEnter = _ref4.onItemMouseEnter, pieData = Pie.getRealPieData(item);
        if (!pieData || !pieData.length) return [];
        var _item$props2 = item.props, cornerRadius = _item$props2.cornerRadius, startAngle = _item$props2.startAngle, endAngle = _item$props2.endAngle, paddingAngle = _item$props2.paddingAngle, dataKey = _item$props2.dataKey, nameKey = _item$props2.nameKey, valueKey = _item$props2.valueKey, minAngle = Math.abs(item.props.minAngle), coordinate = Pie.parseCoordinateOfPie(item, offset), len = pieData.length, deltaAngle = Pie.parseDeltaAngle({
            startAngle: startAngle,
            endAngle: endAngle
        }), absDeltaAngle = Math.abs(deltaAngle), totalPadingAngle = (absDeltaAngle >= 360 ? len : len - 1) * paddingAngle, realTotalAngle = absDeltaAngle - len * minAngle - totalPadingAngle, realDataKey = dataKey;
        __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(dataKey) && __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(valueKey) ? (Object(__WEBPACK_IMPORTED_MODULE_20__util_LogUtils__.a)(!1, 'Use "dataKey" to specify the value of pie,\n      the props "valueKey" will be deprecated in 1.1.0'), 
        realDataKey = "value") : __WEBPACK_IMPORTED_MODULE_3_lodash_isNil___default()(dataKey) && (Object(__WEBPACK_IMPORTED_MODULE_20__util_LogUtils__.a)(!1, 'Use "dataKey" to specify the value of pie,\n      the props "valueKey" will be deprecated in 1.1.0'), 
        realDataKey = valueKey);
        var sum = pieData.reduce(function(result, entry) {
            var val = Object(__WEBPACK_IMPORTED_MODULE_19__util_ChartUtils__.w)(entry, realDataKey, 0);
            return result + (Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.h)(val) ? val : 0);
        }, 0), sectors = void 0;
        if (sum > 0) {
            var prev = void 0;
            sectors = pieData.map(function(entry, i) {
                var val = Object(__WEBPACK_IMPORTED_MODULE_19__util_ChartUtils__.w)(entry, realDataKey, 0), name = Object(__WEBPACK_IMPORTED_MODULE_19__util_ChartUtils__.w)(entry, nameKey, i), percent = (Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.h)(val) ? val : 0) / sum, tempStartAngle = void 0;
                tempStartAngle = i ? prev.endAngle + Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.j)(deltaAngle) * paddingAngle : startAngle;
                var tempEndAngle = tempStartAngle + Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.j)(deltaAngle) * (minAngle + percent * realTotalAngle), midAngle = (tempStartAngle + tempEndAngle) / 2, middleRadius = (coordinate.innerRadius + coordinate.outerRadius) / 2, tooltipPayload = [ {
                    name: name,
                    value: val,
                    payload: entry
                } ], tooltipPosition = Object(__WEBPACK_IMPORTED_MODULE_17__util_PolarUtils__.e)(coordinate.cx, coordinate.cy, middleRadius, midAngle);
                return prev = _extends({
                    percent: percent,
                    cornerRadius: cornerRadius,
                    name: name,
                    tooltipPayload: tooltipPayload,
                    midAngle: midAngle,
                    middleRadius: middleRadius,
                    tooltipPosition: tooltipPosition
                }, entry, coordinate, {
                    value: Object(__WEBPACK_IMPORTED_MODULE_19__util_ChartUtils__.w)(entry, realDataKey),
                    startAngle: tempStartAngle,
                    endAngle: tempEndAngle,
                    payload: entry,
                    paddingAngle: Object(__WEBPACK_IMPORTED_MODULE_18__util_DataUtils__.j)(deltaAngle) * paddingAngle
                });
            });
        }
        return _extends({}, coordinate, {
            sectors: sectors,
            data: pieData,
            onMouseLeave: onItemMouseLeave,
            onMouseEnter: onItemMouseEnter
        });
    }, _class = _temp2)) || _class;
    __webpack_exports__.a = Pie;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp2, __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__ = __webpack_require__(45), __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_2_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_2_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_react__), __WEBPACK_IMPORTED_MODULE_3_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_3_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_prop_types__), __WEBPACK_IMPORTED_MODULE_4_react_smooth__ = __webpack_require__(33), __WEBPACK_IMPORTED_MODULE_4_react_smooth___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_react_smooth__), __WEBPACK_IMPORTED_MODULE_5_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_5_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_classnames__), __WEBPACK_IMPORTED_MODULE_6__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_7__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_8__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__ = __webpack_require__(23), __WEBPACK_IMPORTED_MODULE_10__util_ChartUtils__ = __webpack_require__(16), __WEBPACK_IMPORTED_MODULE_11__shape_Polygon__ = __webpack_require__(214), __WEBPACK_IMPORTED_MODULE_12__shape_Dot__ = __webpack_require__(63), __WEBPACK_IMPORTED_MODULE_13__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_14__component_LabelList__ = __webpack_require__(47), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), Radar = Object(__WEBPACK_IMPORTED_MODULE_7__util_PureRender__.a)((_temp2 = _class2 = function(_Component) {
        function Radar() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, Radar);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = Radar.__proto__ || Object.getPrototypeOf(Radar)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                isAnimationFinished: !1
            }, _this.cachePrevData = function(points) {
                _this.setState({
                    prevPoints: points
                });
            }, _this.handleAnimationEnd = function() {
                _this.setState({
                    isAnimationFinished: !0
                });
            }, _this.handleAnimationStart = function() {
                _this.setState({
                    isAnimationFinished: !1
                });
            }, _this.handleMouseEnter = function(e) {
                var onMouseEnter = _this.props.onMouseEnter;
                onMouseEnter && onMouseEnter(_this.props, e);
            }, _this.handleMouseLeave = function(e) {
                var onMouseLeave = _this.props.onMouseLeave;
                onMouseLeave && onMouseLeave(_this.props, e);
            }, _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(Radar, _Component), _createClass(Radar, [ {
            key: "componentWillReceiveProps",
            value: function(nextProps) {
                var _props = this.props, animationId = _props.animationId, points = _props.points;
                nextProps.animationId !== animationId && this.cachePrevData(points);
            }
        }, {
            key: "renderDotItem",
            value: function(option, props) {
                return __WEBPACK_IMPORTED_MODULE_2_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_2_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_12__shape_Dot__.a, _extends({}, props, {
                    className: "recharts-radar-dot"
                }));
            }
        }, {
            key: "renderDots",
            value: function(points) {
                var _this2 = this, _props2 = this.props, dot = _props2.dot, dataKey = _props2.dataKey, baseProps = Object(__WEBPACK_IMPORTED_MODULE_8__util_ReactUtils__.k)(this.props), customDotProps = Object(__WEBPACK_IMPORTED_MODULE_8__util_ReactUtils__.k)(dot), dots = points.map(function(entry, i) {
                    var dotProps = _extends({
                        key: "dot-" + i,
                        r: 3
                    }, baseProps, customDotProps, {
                        dataKey: dataKey,
                        cx: entry.x,
                        cy: entry.y,
                        index: i,
                        playload: entry
                    });
                    return _this2.renderDotItem(dot, dotProps);
                });
                return __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_13__container_Layer__.a, {
                    className: "recharts-radar-dots"
                }, dots);
            }
        }, {
            key: "renderPolygonStatically",
            value: function(points) {
                var _props3 = this.props, shape = _props3.shape, dot = _props3.dot, radar = void 0;
                return radar = __WEBPACK_IMPORTED_MODULE_2_react___default.a.isValidElement(shape) ? __WEBPACK_IMPORTED_MODULE_2_react___default.a.cloneElement(shape, _extends({}, this.props, {
                    points: points
                })) : __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(shape) ? shape(_extends({}, this.props, {
                    points: points
                })) : __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_11__shape_Polygon__.a, _extends({}, Object(__WEBPACK_IMPORTED_MODULE_8__util_ReactUtils__.e)(this.props), {
                    onMouseEnter: this.handleMouseEnter,
                    onMouseLeave: this.handleMouseLeave
                }, Object(__WEBPACK_IMPORTED_MODULE_8__util_ReactUtils__.k)(this.props), {
                    points: points
                })), __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_13__container_Layer__.a, {
                    className: "recharts-radar-polygon"
                }, radar, dot ? this.renderDots(points) : null);
            }
        }, {
            key: "renderPolygonWithAnimation",
            value: function() {
                var _this3 = this, _props4 = this.props, points = _props4.points, isAnimationActive = _props4.isAnimationActive, animationBegin = _props4.animationBegin, animationDuration = _props4.animationDuration, animationEasing = _props4.animationEasing, animationId = _props4.animationId, prevPoints = this.state.prevPoints;
                return __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4_react_smooth___default.a, {
                    begin: animationBegin,
                    duration: animationDuration,
                    isActive: isAnimationActive,
                    easing: animationEasing,
                    from: {
                        t: 0
                    },
                    to: {
                        t: 1
                    },
                    key: "radar-" + animationId,
                    onAnimationEnd: this.handleAnimationEnd,
                    onAnimationStart: this.handleAnimationStart
                }, function(_ref2) {
                    var t = _ref2.t, stepData = points.map(function(entry, index) {
                        var prev = prevPoints && prevPoints[index];
                        if (prev) {
                            var _interpolatorX = Object(__WEBPACK_IMPORTED_MODULE_6__util_DataUtils__.f)(prev.x, entry.x), _interpolatorY = Object(__WEBPACK_IMPORTED_MODULE_6__util_DataUtils__.f)(prev.y, entry.y);
                            return _extends({}, entry, {
                                x: _interpolatorX(t),
                                y: _interpolatorY(t)
                            });
                        }
                        var interpolatorX = Object(__WEBPACK_IMPORTED_MODULE_6__util_DataUtils__.f)(entry.cx, entry.x), interpolatorY = Object(__WEBPACK_IMPORTED_MODULE_6__util_DataUtils__.f)(entry.cy, entry.y);
                        return _extends({}, entry, {
                            x: interpolatorX(t),
                            y: interpolatorY(t)
                        });
                    });
                    return _this3.renderPolygonStatically(stepData);
                });
            }
        }, {
            key: "renderPolygon",
            value: function() {
                var _props5 = this.props, points = _props5.points, isAnimationActive = _props5.isAnimationActive, prevPoints = this.state.prevPoints;
                return !(isAnimationActive && points && points.length) || prevPoints && __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default()(prevPoints, points) ? this.renderPolygonStatically(points) : this.renderPolygonWithAnimation();
            }
        }, {
            key: "render",
            value: function() {
                var _props6 = this.props, hide = _props6.hide, className = _props6.className, points = _props6.points, isAnimationActive = _props6.isAnimationActive;
                if (hide || !points || !points.length) return null;
                var isAnimationFinished = this.state.isAnimationFinished, layerClass = __WEBPACK_IMPORTED_MODULE_5_classnames___default()("recharts-radar", className);
                return __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_13__container_Layer__.a, {
                    className: layerClass
                }, this.renderPolygon(), (!isAnimationActive || isAnimationFinished) && __WEBPACK_IMPORTED_MODULE_14__component_LabelList__.a.renderCallByParent(this.props, points));
            }
        } ]), Radar;
    }(__WEBPACK_IMPORTED_MODULE_2_react__.Component), _class2.displayName = "Radar", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_8__util_ReactUtils__.c, {
        className: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string,
        dataKey: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func ]).isRequired,
        angleAxisId: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number ]),
        radiusAxisId: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number ]),
        points: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            cx: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            cy: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            angle: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            radius: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            value: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            payload: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object
        })),
        shape: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func ]),
        activeDot: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool ]),
        dot: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool ]),
        label: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool ]),
        legendType: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOf(__WEBPACK_IMPORTED_MODULE_8__util_ReactUtils__.b),
        hide: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool,
        onMouseEnter: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func,
        onMouseLeave: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func,
        onClick: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func,
        isAnimationActive: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.bool,
        animationId: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        animationBegin: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        animationDuration: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        animationEasing: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOf([ "ease", "ease-in", "ease-out", "ease-in-out", "linear" ])
    }), _class2.defaultProps = {
        angleAxisId: 0,
        radiusAxisId: 0,
        hide: !1,
        activeDot: !0,
        dot: !1,
        legendType: "rect",
        isAnimationActive: !Object(__WEBPACK_IMPORTED_MODULE_8__util_ReactUtils__.n)(),
        animationBegin: 0,
        animationDuration: 1500,
        animationEasing: "ease"
    }, _class2.getComposedData = function(_ref3) {
        var radiusAxis = _ref3.radiusAxis, angleAxis = _ref3.angleAxis, displayedData = _ref3.displayedData, dataKey = _ref3.dataKey, bandSize = _ref3.bandSize, cx = angleAxis.cx, cy = angleAxis.cy;
        return {
            points: displayedData.map(function(entry, i) {
                var name = Object(__WEBPACK_IMPORTED_MODULE_10__util_ChartUtils__.w)(entry, angleAxis.dataKey, i), value = Object(__WEBPACK_IMPORTED_MODULE_10__util_ChartUtils__.w)(entry, dataKey, 0), angle = angleAxis.scale(name) + (bandSize || 0), radius = radiusAxis.scale(value);
                return _extends({}, Object(__WEBPACK_IMPORTED_MODULE_9__util_PolarUtils__.e)(cx, cy, radius, angle), {
                    name: name,
                    value: value,
                    cx: cx,
                    cy: cy,
                    radius: radius,
                    angle: angle,
                    payload: entry
                });
            })
        };
    }, _class = _temp2)) || _class;
    __webpack_exports__.a = Radar;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp2, __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__ = __webpack_require__(45), __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isEqual__), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_2_lodash_isArray__ = __webpack_require__(13), __WEBPACK_IMPORTED_MODULE_2_lodash_isArray___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_isArray__), __WEBPACK_IMPORTED_MODULE_3_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_3_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_react__), __WEBPACK_IMPORTED_MODULE_4_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_4_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_prop_types__), __WEBPACK_IMPORTED_MODULE_5_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_5_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_classnames__), __WEBPACK_IMPORTED_MODULE_6_react_smooth__ = __webpack_require__(33), __WEBPACK_IMPORTED_MODULE_6_react_smooth___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_react_smooth__), __WEBPACK_IMPORTED_MODULE_7__shape_Sector__ = __webpack_require__(139), __WEBPACK_IMPORTED_MODULE_8__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_10__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_11__component_LabelList__ = __webpack_require__(47), __WEBPACK_IMPORTED_MODULE_12__component_Cell__ = __webpack_require__(88), __WEBPACK_IMPORTED_MODULE_13__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_14__util_ChartUtils__ = __webpack_require__(16), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), RadialBar = Object(__WEBPACK_IMPORTED_MODULE_10__util_PureRender__.a)((_temp2 = _class2 = function(_Component) {
        function RadialBar() {
            var _ref, _temp, _this, _ret;
            _classCallCheck(this, RadialBar);
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
            return _temp = _this = _possibleConstructorReturn(this, (_ref = RadialBar.__proto__ || Object.getPrototypeOf(RadialBar)).call.apply(_ref, [ this ].concat(args))), 
            _this.state = {
                isAnimationFinished: !1
            }, _this.cachePrevData = function(data) {
                _this.setState({
                    prevData: data
                });
            }, _this.handleAnimationEnd = function() {
                _this.setState({
                    isAnimationFinished: !0
                });
            }, _this.handleAnimationStart = function() {
                _this.setState({
                    isAnimationFinished: !1
                });
            }, _ret = _temp, _possibleConstructorReturn(_this, _ret);
        }
        return _inherits(RadialBar, _Component), _createClass(RadialBar, [ {
            key: "componentWillReceiveProps",
            value: function(nextProps) {
                var _props = this.props, animationId = _props.animationId, data = _props.data;
                nextProps.animationId !== animationId && this.cachePrevData(data);
            }
        }, {
            key: "getDeltaAngle",
            value: function() {
                var _props2 = this.props, startAngle = _props2.startAngle, endAngle = _props2.endAngle;
                return Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.j)(endAngle - startAngle) * Math.min(Math.abs(endAngle - startAngle), 360);
            }
        }, {
            key: "renderSectorShape",
            value: function(shape, props) {
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.isValidElement(shape) ? __WEBPACK_IMPORTED_MODULE_3_react___default.a.cloneElement(shape, props) : __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(shape) ? shape(props) : __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__shape_Sector__.a, props);
            }
        }, {
            key: "renderSectorsStatically",
            value: function(sectors) {
                var _this2 = this, _props3 = this.props, shape = _props3.shape, activeShape = _props3.activeShape, activeIndex = _props3.activeIndex, cornerRadius = _props3.cornerRadius, others = _objectWithoutProperties(_props3, [ "shape", "activeShape", "activeIndex", "cornerRadius" ]), baseProps = Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(others);
                return sectors.map(function(entry, i) {
                    var props = _extends({}, baseProps, {
                        cornerRadius: cornerRadius
                    }, entry, Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.f)(_this2.props, entry, i), {
                        key: "sector-" + i,
                        className: "recharts-radial-bar-sector"
                    });
                    return _this2.renderSectorShape(i === activeIndex ? activeShape : shape, props);
                });
            }
        }, {
            key: "renderSectorsWithAnimation",
            value: function() {
                var _this3 = this, _props4 = this.props, data = _props4.data, isAnimationActive = _props4.isAnimationActive, animationBegin = _props4.animationBegin, animationDuration = _props4.animationDuration, animationEasing = _props4.animationEasing, animationId = _props4.animationId, prevData = this.state.prevData;
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6_react_smooth___default.a, {
                    begin: animationBegin,
                    duration: animationDuration,
                    isActive: isAnimationActive,
                    easing: animationEasing,
                    from: {
                        t: 0
                    },
                    to: {
                        t: 1
                    },
                    key: "radialBar-" + animationId,
                    onAnimationStart: this.handleAnimationStart,
                    onAnimationEnd: this.handleAnimationEnd
                }, function(_ref2) {
                    var t = _ref2.t, stepData = data.map(function(entry, index) {
                        var prev = prevData && prevData[index];
                        if (prev) {
                            var interpolatorStartAngle = Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.f)(prev.startAngle, entry.startAngle), interpolatorEndAngle = Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.f)(prev.endAngle, entry.endAngle);
                            return _extends({}, entry, {
                                startAngle: interpolatorStartAngle(t),
                                endAngle: interpolatorEndAngle(t)
                            });
                        }
                        var endAngle = entry.endAngle, startAngle = entry.startAngle, interpolator = Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.f)(startAngle, endAngle);
                        return _extends({}, entry, {
                            endAngle: interpolator(t)
                        });
                    });
                    return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, null, _this3.renderSectorsStatically(stepData));
                });
            }
        }, {
            key: "renderSectors",
            value: function() {
                var _props5 = this.props, data = _props5.data, isAnimationActive = _props5.isAnimationActive, prevData = this.state.prevData;
                return !(isAnimationActive && data && data.length) || prevData && __WEBPACK_IMPORTED_MODULE_0_lodash_isEqual___default()(prevData, data) ? this.renderSectorsStatically(data) : this.renderSectorsWithAnimation();
            }
        }, {
            key: "renderBackground",
            value: function(sectors) {
                var _this4 = this, cornerRadius = this.props.cornerRadius, backgroundProps = Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(this.props.background);
                return sectors.map(function(entry, i) {
                    var background = (entry.value, entry.background), rest = _objectWithoutProperties(entry, [ "value", "background" ]);
                    if (!background) return null;
                    var props = _extends({
                        cornerRadius: cornerRadius
                    }, rest, {
                        fill: "#eee"
                    }, background, backgroundProps, Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.f)(_this4.props, entry, i), {
                        index: i,
                        key: "sector-" + i,
                        className: "recharts-radial-bar-background-sector"
                    });
                    return _this4.renderSectorShape(background, props);
                });
            }
        }, {
            key: "render",
            value: function() {
                var _props6 = this.props, hide = _props6.hide, data = _props6.data, className = _props6.className, background = _props6.background, isAnimationActive = _props6.isAnimationActive;
                if (hide || !data || !data.length) return null;
                var isAnimationFinished = this.state.isAnimationFinished, layerClass = __WEBPACK_IMPORTED_MODULE_5_classnames___default()("recharts-area", className);
                return __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    className: layerClass
                }, background && __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    className: "recharts-radial-bar-background"
                }, this.renderBackground(data)), __WEBPACK_IMPORTED_MODULE_3_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    className: "recharts-radial-bar-sectors"
                }, this.renderSectors(data)), (!isAnimationActive || isAnimationFinished) && __WEBPACK_IMPORTED_MODULE_11__component_LabelList__.a.renderCallByParent(_extends({}, this.props, {
                    clockWise: this.getDeltaAngle() < 0
                }), data));
            }
        } ]), RadialBar;
    }(__WEBPACK_IMPORTED_MODULE_3_react__.Component), _class2.displayName = "RadialBar", 
    _class2.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.c, {
        className: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string,
        angleAxisId: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        radiusAxisId: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number ]),
        shape: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element ]),
        activeShape: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element ]),
        activeIndex: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        dataKey: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func ]).isRequired,
        cornerRadius: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string ]),
        minPointSize: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        maxBarSize: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        data: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.arrayOf(__WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.shape({
            cx: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
            cy: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
            innerRadius: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
            outerRadius: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
            value: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.value
        })),
        legendType: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.b),
        label: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object ]),
        background: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.element ]),
        hide: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool,
        onMouseEnter: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func,
        onMouseLeave: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func,
        onClick: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func,
        isAnimationActive: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool,
        animationBegin: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        animationDuration: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,
        animationEasing: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.oneOf([ "ease", "ease-in", "ease-out", "ease-in-out", "linear", "spring" ])
    }), _class2.defaultProps = {
        angleAxisId: 0,
        radiusAxisId: 0,
        minPointSize: 0,
        hide: !1,
        legendType: "rect",
        data: [],
        isAnimationActive: !Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.n)(),
        animationBegin: 0,
        animationDuration: 1500,
        animationEasing: "ease"
    }, _class2.getComposedData = function(_ref3) {
        var item = _ref3.item, props = _ref3.props, radiusAxis = _ref3.radiusAxis, radiusAxisTicks = _ref3.radiusAxisTicks, angleAxis = _ref3.angleAxis, angleAxisTicks = _ref3.angleAxisTicks, displayedData = _ref3.displayedData, dataKey = _ref3.dataKey, stackedData = _ref3.stackedData, barPosition = _ref3.barPosition, bandSize = _ref3.bandSize, dataStartIndex = _ref3.dataStartIndex, pos = Object(__WEBPACK_IMPORTED_MODULE_14__util_ChartUtils__.f)(barPosition, item);
        if (!pos) return [];
        var cx = angleAxis.cx, cy = angleAxis.cy, layout = props.layout, _item$props = item.props, children = _item$props.children, minPointSize = _item$props.minPointSize, numericAxis = "radial" === layout ? angleAxis : radiusAxis, stackedDomain = stackedData ? numericAxis.scale.domain() : null, baseValue = Object(__WEBPACK_IMPORTED_MODULE_14__util_ChartUtils__.j)({
            props: props,
            numericAxis: numericAxis
        }), cells = Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.h)(children, __WEBPACK_IMPORTED_MODULE_12__component_Cell__.a);
        return {
            data: displayedData.map(function(entry, index) {
                var value = void 0, innerRadius = void 0, outerRadius = void 0, startAngle = void 0, endAngle = void 0, backgroundSector = void 0;
                if (stackedData ? value = Object(__WEBPACK_IMPORTED_MODULE_14__util_ChartUtils__.C)(stackedData[dataStartIndex + index], stackedDomain) : (value = Object(__WEBPACK_IMPORTED_MODULE_14__util_ChartUtils__.w)(entry, dataKey), 
                __WEBPACK_IMPORTED_MODULE_2_lodash_isArray___default()(value) || (value = [ baseValue, value ])), 
                "radial" === layout) {
                    innerRadius = Object(__WEBPACK_IMPORTED_MODULE_14__util_ChartUtils__.k)({
                        axis: radiusAxis,
                        ticks: radiusAxisTicks,
                        bandSize: bandSize,
                        offset: pos.offset,
                        entry: entry,
                        index: index
                    }), endAngle = angleAxis.scale(value[1]), startAngle = angleAxis.scale(value[0]), 
                    outerRadius = innerRadius + pos.size;
                    var deltaAngle = endAngle - startAngle;
                    if (Math.abs(minPointSize) > 0 && Math.abs(deltaAngle) < Math.abs(minPointSize)) {
                        endAngle += Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.j)(deltaAngle || minPointSize) * (Math.abs(minPointSize) - Math.abs(deltaAngle));
                    }
                    backgroundSector = {
                        background: {
                            cx: cx,
                            cy: cy,
                            innerRadius: innerRadius,
                            outerRadius: outerRadius,
                            startAngle: props.startAngle,
                            endAngle: props.endAngle
                        }
                    };
                } else {
                    innerRadius = radiusAxis.scale(value[0]), outerRadius = radiusAxis.scale(value[1]), 
                    startAngle = Object(__WEBPACK_IMPORTED_MODULE_14__util_ChartUtils__.k)({
                        axis: angleAxis,
                        ticks: angleAxisTicks,
                        bandSize: bandSize,
                        offset: pos.offset,
                        entry: entry,
                        index: index
                    }), endAngle = startAngle + pos.size;
                    var deltaRadius = outerRadius - innerRadius;
                    if (Math.abs(minPointSize) > 0 && Math.abs(deltaRadius) < Math.abs(minPointSize)) {
                        outerRadius += Object(__WEBPACK_IMPORTED_MODULE_13__util_DataUtils__.j)(deltaRadius || minPointSize) * (Math.abs(minPointSize) - Math.abs(deltaRadius));
                    }
                }
                return _extends({}, entry, backgroundSector, {
                    payload: entry,
                    value: stackedData ? value : value[1],
                    cx: cx,
                    cy: cy,
                    innerRadius: innerRadius,
                    outerRadius: outerRadius,
                    startAngle: startAngle,
                    endAngle: endAngle
                }, cells && cells[index] && cells[index].props);
            }),
            layout: layout
        };
    }, _class = _temp2)) || _class;
    __webpack_exports__.a = RadialBar;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _defineProperty(obj, key, value) {
        return key in obj ? Object.defineProperty(obj, key, {
            value: value,
            enumerable: !0,
            configurable: !0,
            writable: !0
        }) : obj[key] = value, obj;
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _class2, _temp, __WEBPACK_IMPORTED_MODULE_0_lodash_range__ = __webpack_require__(373), __WEBPACK_IMPORTED_MODULE_0_lodash_range___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_range__), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_2_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_2_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_react__), __WEBPACK_IMPORTED_MODULE_3_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_3_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_prop_types__), __WEBPACK_IMPORTED_MODULE_4_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_4_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_classnames__), __WEBPACK_IMPORTED_MODULE_5_d3_scale__ = __webpack_require__(331), __WEBPACK_IMPORTED_MODULE_6__util_ChartUtils__ = __webpack_require__(16), __WEBPACK_IMPORTED_MODULE_7__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_8__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_9__component_Text__ = __webpack_require__(61), __WEBPACK_IMPORTED_MODULE_10__util_DataUtils__ = __webpack_require__(9), __WEBPACK_IMPORTED_MODULE_11__util_CssPrefixUtils__ = __webpack_require__(930), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), Brush = Object(__WEBPACK_IMPORTED_MODULE_7__util_PureRender__.a)((_temp = _class2 = function(_Component) {
        function Brush(props) {
            _classCallCheck(this, Brush);
            var _this = _possibleConstructorReturn(this, (Brush.__proto__ || Object.getPrototypeOf(Brush)).call(this, props));
            return _this.handleDrag = function(e) {
                _this.leaveTimer && (clearTimeout(_this.leaveTimer), _this.leaveTimer = null), _this.state.isTravellerMoving ? _this.handleTravellerMove(e) : _this.state.isSlideMoving && _this.handleSlideDrag(e);
            }, _this.handleTouchMove = function(e) {
                null != e.changedTouches && e.changedTouches.length > 0 && _this.handleDrag(e.changedTouches[0]);
            }, _this.handleDragEnd = function() {
                _this.setState({
                    isTravellerMoving: !1,
                    isSlideMoving: !1
                });
            }, _this.handleLeaveWrapper = function() {
                (_this.state.isTravellerMoving || _this.state.isSlideMoving) && (_this.leaveTimer = setTimeout(_this.handleDragEnd, 1e3));
            }, _this.handleEnterSlideOrTraveller = function() {
                _this.setState({
                    isTextActive: !0
                });
            }, _this.handleLeaveSlideOrTraveller = function() {
                _this.setState({
                    isTextActive: !1
                });
            }, _this.handleSlideDragStart = function(e) {
                var event = e.changedTouches && e.changedTouches.length ? e.changedTouches[0] : e;
                _this.setState({
                    isTravellerMoving: !1,
                    isSlideMoving: !0,
                    slideMoveStartX: event.pageX
                });
            }, _this.travellerDragStartHandlers = {
                startX: _this.handleTravellerDragStart.bind(_this, "startX"),
                endX: _this.handleTravellerDragStart.bind(_this, "endX")
            }, _this.state = props.data && props.data.length ? _this.updateScale(props) : {}, 
            _this;
        }
        return _inherits(Brush, _Component), _createClass(Brush, [ {
            key: "componentWillReceiveProps",
            value: function(nextProps) {
                var _this2 = this, _props = this.props, data = _props.data, width = _props.width, x = _props.x, travellerWidth = _props.travellerWidth, updateId = _props.updateId;
                (nextProps.data !== data || nextProps.updateId !== updateId) && nextProps.data && nextProps.data.length ? this.setState(this.updateScale(nextProps)) : nextProps.width === width && nextProps.x === x && nextProps.travellerWidth === travellerWidth || (this.scale.range([ nextProps.x, nextProps.x + nextProps.width - nextProps.travellerWidth ]), 
                this.scaleValues = this.scale.domain().map(function(entry) {
                    return _this2.scale(entry);
                }), this.setState({
                    startX: this.scale(nextProps.startIndex),
                    endX: this.scale(nextProps.endIndex)
                }));
            }
        }, {
            key: "componentWillUnmount",
            value: function() {
                this.scale = null, this.scaleValues = null, this.leaveTimer && (clearTimeout(this.leaveTimer), 
                this.leaveTimer = null);
            }
        }, {
            key: "getIndexInRange",
            value: function(range, x) {
                for (var len = range.length, start = 0, end = len - 1; end - start > 1; ) {
                    var middle = Math.floor((start + end) / 2);
                    range[middle] > x ? end = middle : start = middle;
                }
                return x >= range[end] ? end : start;
            }
        }, {
            key: "getIndex",
            value: function(_ref) {
                var startX = _ref.startX, endX = _ref.endX, _props2 = this.props, gap = _props2.gap, data = _props2.data, lastIndex = data.length - 1, min = Math.min(startX, endX), max = Math.max(startX, endX), minIndex = this.getIndexInRange(this.scaleValues, min), maxIndex = this.getIndexInRange(this.scaleValues, max);
                return {
                    startIndex: minIndex - minIndex % gap,
                    endIndex: maxIndex === lastIndex ? lastIndex : maxIndex - maxIndex % gap
                };
            }
        }, {
            key: "getTextOfTick",
            value: function(index) {
                var _props3 = this.props, data = _props3.data, tickFormatter = _props3.tickFormatter, dataKey = _props3.dataKey, text = Object(__WEBPACK_IMPORTED_MODULE_6__util_ChartUtils__.w)(data[index], dataKey, index);
                return __WEBPACK_IMPORTED_MODULE_1_lodash_isFunction___default()(tickFormatter) ? tickFormatter(text) : text;
            }
        }, {
            key: "handleSlideDrag",
            value: function(e) {
                var _state = this.state, slideMoveStartX = _state.slideMoveStartX, startX = _state.startX, endX = _state.endX, _props4 = this.props, x = _props4.x, width = _props4.width, travellerWidth = _props4.travellerWidth, startIndex = _props4.startIndex, endIndex = _props4.endIndex, onChange = _props4.onChange, delta = e.pageX - slideMoveStartX;
                delta > 0 ? delta = Math.min(delta, x + width - travellerWidth - endX, x + width - travellerWidth - startX) : delta < 0 && (delta = Math.max(delta, x - startX, x - endX));
                var newIndex = this.getIndex({
                    startX: startX + delta,
                    endX: endX + delta
                });
                newIndex.startIndex === startIndex && newIndex.endIndex === endIndex || !onChange || onChange(newIndex), 
                this.setState({
                    startX: startX + delta,
                    endX: endX + delta,
                    slideMoveStartX: e.pageX
                });
            }
        }, {
            key: "handleTravellerDragStart",
            value: function(id, e) {
                var event = e.changedTouches && e.changedTouches.length ? e.changedTouches[0] : e;
                this.setState({
                    isSlideMoving: !1,
                    isTravellerMoving: !0,
                    movingTravellerId: id,
                    brushMoveStartX: event.pageX
                });
            }
        }, {
            key: "handleTravellerMove",
            value: function(e) {
                var _setState, _state2 = this.state, brushMoveStartX = _state2.brushMoveStartX, movingTravellerId = _state2.movingTravellerId, endX = _state2.endX, startX = _state2.startX, prevValue = this.state[movingTravellerId], _props5 = this.props, x = _props5.x, width = _props5.width, travellerWidth = _props5.travellerWidth, onChange = _props5.onChange, gap = _props5.gap, data = _props5.data, params = {
                    startX: this.state.startX,
                    endX: this.state.endX
                }, delta = e.pageX - brushMoveStartX;
                delta > 0 ? delta = Math.min(delta, x + width - travellerWidth - prevValue) : delta < 0 && (delta = Math.max(delta, x - prevValue)), 
                params[movingTravellerId] = prevValue + delta;
                var newIndex = this.getIndex(params), startIndex = newIndex.startIndex, endIndex = newIndex.endIndex, isFullGap = function() {
                    var lastIndex = data.length - 1;
                    return "startX" === movingTravellerId && (endX > startX ? startIndex % gap == 0 : endIndex % gap == 0) || endX < startX && endIndex === lastIndex || "endX" === movingTravellerId && (endX > startX ? endIndex % gap == 0 : startIndex % gap == 0) || endX > startX && endIndex === lastIndex;
                };
                this.setState((_setState = {}, _defineProperty(_setState, movingTravellerId, prevValue + delta), 
                _defineProperty(_setState, "brushMoveStartX", e.pageX), _setState), function() {
                    onChange && isFullGap() && onChange(newIndex);
                });
            }
        }, {
            key: "updateScale",
            value: function(props) {
                var _this3 = this, data = props.data, startIndex = props.startIndex, endIndex = props.endIndex, x = props.x, width = props.width, travellerWidth = props.travellerWidth, len = data.length;
                return this.scale = Object(__WEBPACK_IMPORTED_MODULE_5_d3_scale__.scalePoint)().domain(__WEBPACK_IMPORTED_MODULE_0_lodash_range___default()(0, len)).range([ x, x + width - travellerWidth ]), 
                this.scaleValues = this.scale.domain().map(function(entry) {
                    return _this3.scale(entry);
                }), {
                    isTextActive: !1,
                    isSlideMoving: !1,
                    isTravellerMoving: !1,
                    startX: this.scale(startIndex),
                    endX: this.scale(endIndex)
                };
            }
        }, {
            key: "renderBackground",
            value: function() {
                var _props6 = this.props, x = _props6.x, y = _props6.y, width = _props6.width, height = _props6.height, fill = _props6.fill, stroke = _props6.stroke;
                return __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement("rect", {
                    stroke: stroke,
                    fill: fill,
                    x: x,
                    y: y,
                    width: width,
                    height: height
                });
            }
        }, {
            key: "renderPanorama",
            value: function() {
                var _props7 = this.props, x = _props7.x, y = _props7.y, width = _props7.width, height = _props7.height, data = _props7.data, children = _props7.children, padding = _props7.padding, chartElement = __WEBPACK_IMPORTED_MODULE_2_react__.Children.only(children);
                return chartElement ? __WEBPACK_IMPORTED_MODULE_2_react___default.a.cloneElement(chartElement, {
                    x: x,
                    y: y,
                    width: width,
                    height: height,
                    margin: padding,
                    compact: !0,
                    data: data
                }) : null;
            }
        }, {
            key: "renderTraveller",
            value: function(travellerX, id) {
                var _props8 = this.props, y = _props8.y, travellerWidth = _props8.travellerWidth, height = _props8.height, stroke = _props8.stroke, lineY = Math.floor(y + height / 2) - 1, x = Math.max(travellerX, this.props.x);
                return __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    className: "recharts-brush-traveller",
                    onMouseEnter: this.handleEnterSlideOrTraveller,
                    onMouseLeave: this.handleLeaveSlideOrTraveller,
                    onMouseDown: this.travellerDragStartHandlers[id],
                    onTouchStart: this.travellerDragStartHandlers[id],
                    style: {
                        cursor: "col-resize"
                    }
                }, __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement("rect", {
                    x: x,
                    y: y,
                    width: travellerWidth,
                    height: height,
                    fill: stroke,
                    stroke: "none"
                }), __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement("line", {
                    x1: x + 1,
                    y1: lineY,
                    x2: x + travellerWidth - 1,
                    y2: lineY,
                    fill: "none",
                    stroke: "#fff"
                }), __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement("line", {
                    x1: x + 1,
                    y1: lineY + 2,
                    x2: x + travellerWidth - 1,
                    y2: lineY + 2,
                    fill: "none",
                    stroke: "#fff"
                }));
            }
        }, {
            key: "renderSlide",
            value: function(startX, endX) {
                var _props9 = this.props, y = _props9.y, height = _props9.height, stroke = _props9.stroke;
                return __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement("rect", {
                    className: "recharts-brush-slide",
                    onMouseEnter: this.handleEnterSlideOrTraveller,
                    onMouseLeave: this.handleLeaveSlideOrTraveller,
                    onMouseDown: this.handleSlideDragStart,
                    onTouchStart: this.handleSlideDragStart,
                    style: {
                        cursor: "move"
                    },
                    stroke: "none",
                    fill: stroke,
                    fillOpacity: .2,
                    x: Math.min(startX, endX),
                    y: y,
                    width: Math.abs(endX - startX),
                    height: height
                });
            }
        }, {
            key: "renderText",
            value: function() {
                var _props10 = this.props, startIndex = _props10.startIndex, endIndex = _props10.endIndex, y = _props10.y, height = _props10.height, travellerWidth = _props10.travellerWidth, stroke = _props10.stroke, _state3 = this.state, startX = _state3.startX, endX = _state3.endX, attrs = {
                    pointerEvents: "none",
                    fill: stroke
                };
                return __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    className: "recharts-brush-texts"
                }, __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__component_Text__.a, _extends({
                    textAnchor: "end",
                    verticalAnchor: "middle",
                    x: Math.min(startX, endX) - 5,
                    y: y + height / 2
                }, attrs), this.getTextOfTick(startIndex)), __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__component_Text__.a, _extends({
                    textAnchor: "start",
                    verticalAnchor: "middle",
                    x: Math.max(startX, endX) + travellerWidth + 5,
                    y: y + height / 2
                }, attrs), this.getTextOfTick(endIndex)));
            }
        }, {
            key: "render",
            value: function() {
                var _props11 = this.props, data = _props11.data, className = _props11.className, children = _props11.children, x = _props11.x, y = _props11.y, width = _props11.width, height = _props11.height, _state4 = this.state, startX = _state4.startX, endX = _state4.endX, isTextActive = _state4.isTextActive, isSlideMoving = _state4.isSlideMoving, isTravellerMoving = _state4.isTravellerMoving;
                if (!data || !data.length || !Object(__WEBPACK_IMPORTED_MODULE_10__util_DataUtils__.h)(x) || !Object(__WEBPACK_IMPORTED_MODULE_10__util_DataUtils__.h)(y) || !Object(__WEBPACK_IMPORTED_MODULE_10__util_DataUtils__.h)(width) || !Object(__WEBPACK_IMPORTED_MODULE_10__util_DataUtils__.h)(height) || width <= 0 || height <= 0) return null;
                var layerClass = __WEBPACK_IMPORTED_MODULE_4_classnames___default()("recharts-brush", className), isPanoramic = 1 === __WEBPACK_IMPORTED_MODULE_2_react___default.a.Children.count(children), style = Object(__WEBPACK_IMPORTED_MODULE_11__util_CssPrefixUtils__.a)("userSelect", "none");
                return __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__container_Layer__.a, {
                    className: layerClass,
                    onMouseMove: this.handleDrag,
                    onMouseLeave: this.handleLeaveWrapper,
                    onMouseUp: this.handleDragEnd,
                    onTouchEnd: this.handleDragEnd,
                    onTouchMove: this.handleTouchMove,
                    style: style
                }, this.renderBackground(), isPanoramic && this.renderPanorama(), this.renderSlide(startX, endX), this.renderTraveller(startX, "startX"), this.renderTraveller(endX, "endX"), (isTextActive || isSlideMoving || isTravellerMoving) && this.renderText());
            }
        } ]), Brush;
    }(__WEBPACK_IMPORTED_MODULE_2_react__.Component), _class2.displayName = "Brush", 
    _class2.propTypes = {
        className: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string,
        fill: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string,
        stroke: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string,
        x: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        y: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        width: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        height: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number.isRequired,
        travellerWidth: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        gap: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        padding: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.shape({
            top: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            right: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            bottom: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
            left: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number
        }),
        dataKey: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func ]),
        data: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.array,
        startIndex: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        endIndex: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number,
        tickFormatter: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func,
        children: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.node,
        onChange: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.func,
        updateId: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.number ])
    }, _class2.defaultProps = {
        height: 40,
        travellerWidth: 5,
        gap: 1,
        fill: "#fff",
        stroke: "#666",
        padding: {
            top: 1,
            right: 1,
            bottom: 1,
            left: 1
        }
    }, _class = _temp)) || _class;
    __webpack_exports__.a = Brush;
}, function(module, exports, __webpack_require__) {
    var createRange = __webpack_require__(927), range = createRange();
    module.exports = range;
}, function(module, __webpack_exports__, __webpack_require__) {
    "use strict";
    function _objectWithoutProperties(obj, keys) {
        var target = {};
        for (var i in obj) keys.indexOf(i) >= 0 || Object.prototype.hasOwnProperty.call(obj, i) && (target[i] = obj[i]);
        return target;
    }
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
        if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        return !call || "object" != typeof call && "function" != typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
        if ("function" != typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: !1,
                writable: !0,
                configurable: !0
            }
        }), superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var _class, _temp, __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__ = __webpack_require__(8), __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_isFunction__), __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0), __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__), __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1), __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__), __WEBPACK_IMPORTED_MODULE_3_classnames__ = __webpack_require__(3), __WEBPACK_IMPORTED_MODULE_3_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_classnames__), __WEBPACK_IMPORTED_MODULE_4__util_PureRender__ = __webpack_require__(5), __WEBPACK_IMPORTED_MODULE_5__util_DOMUtils__ = __webpack_require__(198), __WEBPACK_IMPORTED_MODULE_6__container_Layer__ = __webpack_require__(14), __WEBPACK_IMPORTED_MODULE_7__component_Text__ = __webpack_require__(61), __WEBPACK_IMPORTED_MODULE_8__component_Label__ = __webpack_require__(44), __WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__ = __webpack_require__(4), __WEBPACK_IMPORTED_MODULE_10__util_DataUtils__ = __webpack_require__(9), _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
        }
        return target;
    }, _createClass = function() {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, 
                "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target, descriptor.key, descriptor);
            }
        }
        return function(Constructor, protoProps, staticProps) {
            return protoProps && defineProperties(Constructor.prototype, protoProps), staticProps && defineProperties(Constructor, staticProps), 
            Constructor;
        };
    }(), CartesianAxis = (_temp = _class = function(_Component) {
        function CartesianAxis() {
            return _classCallCheck(this, CartesianAxis), _possibleConstructorReturn(this, (CartesianAxis.__proto__ || Object.getPrototypeOf(CartesianAxis)).apply(this, arguments));
        }
        return _inherits(CartesianAxis, _Component), _createClass(CartesianAxis, [ {
            key: "shouldComponentUpdate",
            value: function(_ref, state) {
                var viewBox = _ref.viewBox, restProps = _objectWithoutProperties(_ref, [ "viewBox" ]), _props = this.props, viewBoxOld = _props.viewBox, restPropsOld = _objectWithoutProperties(_props, [ "viewBox" ]);
                return !Object(__WEBPACK_IMPORTED_MODULE_4__util_PureRender__.b)(viewBox, viewBoxOld) || !Object(__WEBPACK_IMPORTED_MODULE_4__util_PureRender__.b)(restProps, restPropsOld) || !Object(__WEBPACK_IMPORTED_MODULE_4__util_PureRender__.b)(state, this.state);
            }
        }, {
            key: "getTickLineCoord",
            value: function(data) {
                var _props2 = this.props, x = _props2.x, y = _props2.y, width = _props2.width, height = _props2.height, orientation = _props2.orientation, tickSize = _props2.tickSize, mirror = _props2.mirror, tickMargin = _props2.tickMargin, x1 = void 0, x2 = void 0, y1 = void 0, y2 = void 0, tx = void 0, ty = void 0, sign = mirror ? -1 : 1, finalTickSize = data.tickSize || tickSize, tickCoord = Object(__WEBPACK_IMPORTED_MODULE_10__util_DataUtils__.h)(data.tickCoord) ? data.tickCoord : data.coordinate;
                switch (orientation) {
                  case "top":
                    x1 = x2 = data.coordinate, y2 = y + !mirror * height, y1 = y2 - sign * finalTickSize, 
                    ty = y1 - sign * tickMargin, tx = tickCoord;
                    break;

                  case "left":
                    y1 = y2 = data.coordinate, x2 = x + !mirror * width, x1 = x2 - sign * finalTickSize, 
                    tx = x1 - sign * tickMargin, ty = tickCoord;
                    break;

                  case "right":
                    y1 = y2 = data.coordinate, x2 = x + mirror * width, x1 = x2 + sign * finalTickSize, 
                    tx = x1 + sign * tickMargin, ty = tickCoord;
                    break;

                  default:
                    x1 = x2 = data.coordinate, y2 = y + mirror * height, y1 = y2 + sign * finalTickSize, 
                    ty = y1 + sign * tickMargin, tx = tickCoord;
                }
                return {
                    line: {
                        x1: x1,
                        y1: y1,
                        x2: x2,
                        y2: y2
                    },
                    tick: {
                        x: tx,
                        y: ty
                    }
                };
            }
        }, {
            key: "getTickTextAnchor",
            value: function() {
                var _props3 = this.props, orientation = _props3.orientation, mirror = _props3.mirror, textAnchor = void 0;
                switch (orientation) {
                  case "left":
                    textAnchor = mirror ? "start" : "end";
                    break;

                  case "right":
                    textAnchor = mirror ? "end" : "start";
                    break;

                  default:
                    textAnchor = "middle";
                }
                return textAnchor;
            }
        }, {
            key: "getTickVerticalAnchor",
            value: function() {
                var _props4 = this.props, orientation = _props4.orientation, mirror = _props4.mirror, verticalAnchor = "end";
                switch (orientation) {
                  case "left":
                  case "right":
                    verticalAnchor = "middle";
                    break;

                  case "top":
                    verticalAnchor = mirror ? "start" : "end";
                    break;

                  default:
                    verticalAnchor = mirror ? "end" : "start";
                }
                return verticalAnchor;
            }
        }, {
            key: "renderAxisLine",
            value: function() {
                var _props5 = this.props, x = _props5.x, y = _props5.y, width = _props5.width, height = _props5.height, orientation = _props5.orientation, axisLine = _props5.axisLine, mirror = _props5.mirror, props = _extends({}, Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(this.props), {
                    fill: "none"
                }, Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(axisLine));
                if ("top" === orientation || "bottom" === orientation) {
                    var needHeight = "top" === orientation && !mirror || "bottom" === orientation && mirror;
                    props = _extends({}, props, {
                        x1: x,
                        y1: y + needHeight * height,
                        x2: x + width,
                        y2: y + needHeight * height
                    });
                } else {
                    var needWidth = "left" === orientation && !mirror || "right" === orientation && mirror;
                    props = _extends({}, props, {
                        x1: x + needWidth * width,
                        y1: y,
                        x2: x + needWidth * width,
                        y2: y + height
                    });
                }
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement("line", _extends({
                    className: "recharts-cartesian-axis-line"
                }, props));
            }
        }, {
            key: "renderTickItem",
            value: function(option, props, value) {
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.isValidElement(option) ? __WEBPACK_IMPORTED_MODULE_1_react___default.a.cloneElement(option, props) : __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(option) ? option(props) : __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__component_Text__.a, _extends({}, props, {
                    className: "recharts-cartesian-axis-tick-value"
                }), value);
            }
        }, {
            key: "renderTicks",
            value: function(ticks) {
                var _this2 = this, _props6 = this.props, tickLine = _props6.tickLine, stroke = _props6.stroke, tick = _props6.tick, tickFormatter = _props6.tickFormatter, unit = _props6.unit, finalTicks = CartesianAxis.getTicks(_extends({}, this.props, {
                    ticks: ticks
                })), textAnchor = this.getTickTextAnchor(), verticalAnchor = this.getTickVerticalAnchor(), axisProps = Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(this.props), customTickProps = Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(tick), tickLineProps = _extends({}, axisProps, {
                    fill: "none"
                }, Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.k)(tickLine)), items = finalTicks.map(function(entry, i) {
                    var _getTickLineCoord = _this2.getTickLineCoord(entry), lineCoord = _getTickLineCoord.line, tickCoord = _getTickLineCoord.tick, tickProps = _extends({
                        textAnchor: textAnchor,
                        verticalAnchor: verticalAnchor
                    }, axisProps, {
                        stroke: "none",
                        fill: stroke
                    }, customTickProps, tickCoord, {
                        index: i,
                        payload: entry,
                        visibleTicksCount: finalTicks.length
                    });
                    return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__container_Layer__.a, _extends({
                        className: "recharts-cartesian-axis-tick",
                        key: "tick-" + i
                    }, Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.f)(_this2.props, entry, i)), tickLine && __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement("line", _extends({
                        className: "recharts-cartesian-axis-tick-line"
                    }, tickLineProps, lineCoord)), tick && _this2.renderTickItem(tick, tickProps, "" + (__WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(tickFormatter) ? tickFormatter(entry.value) : entry.value) + (unit || "")));
                });
                return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement("g", {
                    className: "recharts-cartesian-axis-ticks"
                }, items);
            }
        }, {
            key: "render",
            value: function() {
                var _props7 = this.props, axisLine = _props7.axisLine, width = _props7.width, height = _props7.height, ticksGenerator = _props7.ticksGenerator, className = _props7.className;
                if (_props7.hide) return null;
                var _props8 = this.props, ticks = _props8.ticks, noTicksProps = _objectWithoutProperties(_props8, [ "ticks" ]), finalTicks = ticks;
                return __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(ticksGenerator) && (finalTicks = ticksGenerator(ticks && ticks.length > 0 ? this.props : noTicksProps)), 
                width <= 0 || height <= 0 || !finalTicks || !finalTicks.length ? null : __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__container_Layer__.a, {
                    className: __WEBPACK_IMPORTED_MODULE_3_classnames___default()("recharts-cartesian-axis", className)
                }, axisLine && this.renderAxisLine(), this.renderTicks(finalTicks), __WEBPACK_IMPORTED_MODULE_8__component_Label__.a.renderCallByParent(this.props));
            }
        } ], [ {
            key: "getTicks",
            value: function(props) {
                var tick = props.tick, ticks = props.ticks, viewBox = props.viewBox, minTickGap = props.minTickGap, orientation = props.orientation, interval = props.interval, tickFormatter = props.tickFormatter, unit = props.unit;
                return ticks && ticks.length && tick ? Object(__WEBPACK_IMPORTED_MODULE_10__util_DataUtils__.h)(interval) || Object(__WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.n)() ? CartesianAxis.getNumberIntervalTicks(ticks, Object(__WEBPACK_IMPORTED_MODULE_10__util_DataUtils__.h)(interval) ? interval : 0) : "preserveStartEnd" === interval ? CartesianAxis.getTicksStart({
                    ticks: ticks,
                    tickFormatter: tickFormatter,
                    viewBox: viewBox,
                    orientation: orientation,
                    minTickGap: minTickGap,
                    unit: unit
                }, !0) : "preserveStart" === interval ? CartesianAxis.getTicksStart({
                    ticks: ticks,
                    tickFormatter: tickFormatter,
                    viewBox: viewBox,
                    orientation: orientation,
                    minTickGap: minTickGap,
                    unit: unit
                }) : CartesianAxis.getTicksEnd({
                    ticks: ticks,
                    tickFormatter: tickFormatter,
                    viewBox: viewBox,
                    orientation: orientation,
                    minTickGap: minTickGap,
                    unit: unit
                }) : [];
            }
        }, {
            key: "getNumberIntervalTicks",
            value: function(ticks, interval) {
                return ticks.filter(function(entry, i) {
                    return i % (interval + 1) == 0;
                });
            }
        }, {
            key: "getTicksStart",
            value: function(_ref2, preserveEnd) {
                var ticks = _ref2.ticks, tickFormatter = _ref2.tickFormatter, viewBox = _ref2.viewBox, orientation = _ref2.orientation, minTickGap = _ref2.minTickGap, unit = _ref2.unit, x = viewBox.x, y = viewBox.y, width = viewBox.width, height = viewBox.height, sizeKey = "top" === orientation || "bottom" === orientation ? "width" : "height", result = (ticks || []).slice(), unitSize = unit ? Object(__WEBPACK_IMPORTED_MODULE_5__util_DOMUtils__.c)(unit)[sizeKey] : 0, len = result.length, sign = len >= 2 ? Object(__WEBPACK_IMPORTED_MODULE_10__util_DataUtils__.j)(result[1].coordinate - result[0].coordinate) : 1, start = void 0, end = void 0;
                if (1 === sign ? (start = "width" === sizeKey ? x : y, end = "width" === sizeKey ? x + width : y + height) : (start = "width" === sizeKey ? x + width : y + height, 
                end = "width" === sizeKey ? x : y), preserveEnd) {
                    var tail = ticks[len - 1], tailContent = __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(tickFormatter) ? tickFormatter(tail.value) : tail.value, tailSize = Object(__WEBPACK_IMPORTED_MODULE_5__util_DOMUtils__.c)(tailContent)[sizeKey] + unitSize, tailGap = sign * (tail.coordinate + sign * tailSize / 2 - end);
                    result[len - 1] = tail = _extends({}, tail, {
                        tickCoord: tailGap > 0 ? tail.coordinate - tailGap * sign : tail.coordinate
                    });
                    sign * (tail.tickCoord - sign * tailSize / 2 - start) >= 0 && sign * (tail.tickCoord + sign * tailSize / 2 - end) <= 0 && (end = tail.tickCoord - sign * (tailSize / 2 + minTickGap), 
                    result[len - 1] = _extends({}, tail, {
                        isShow: !0
                    }));
                }
                for (var count = preserveEnd ? len - 1 : len, i = 0; i < count; i++) {
                    var entry = result[i], content = __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(tickFormatter) ? tickFormatter(entry.value) : entry.value, size = Object(__WEBPACK_IMPORTED_MODULE_5__util_DOMUtils__.c)(content)[sizeKey] + unitSize;
                    if (0 === i) {
                        var gap = sign * (entry.coordinate - sign * size / 2 - start);
                        result[i] = entry = _extends({}, entry, {
                            tickCoord: gap < 0 ? entry.coordinate - gap * sign : entry.coordinate
                        });
                    } else result[i] = entry = _extends({}, entry, {
                        tickCoord: entry.coordinate
                    });
                    sign * (entry.tickCoord - sign * size / 2 - start) >= 0 && sign * (entry.tickCoord + sign * size / 2 - end) <= 0 && (start = entry.tickCoord + sign * (size / 2 + minTickGap), 
                    result[i] = _extends({}, entry, {
                        isShow: !0
                    }));
                }
                return result.filter(function(entry) {
                    return entry.isShow;
                });
            }
        }, {
            key: "getTicksEnd",
            value: function(_ref3) {
                var ticks = _ref3.ticks, tickFormatter = _ref3.tickFormatter, viewBox = _ref3.viewBox, orientation = _ref3.orientation, minTickGap = _ref3.minTickGap, unit = _ref3.unit, x = viewBox.x, y = viewBox.y, width = viewBox.width, height = viewBox.height, sizeKey = "top" === orientation || "bottom" === orientation ? "width" : "height", unitSize = unit ? Object(__WEBPACK_IMPORTED_MODULE_5__util_DOMUtils__.c)(unit)[sizeKey] : 0, result = (ticks || []).slice(), len = result.length, sign = len >= 2 ? Object(__WEBPACK_IMPORTED_MODULE_10__util_DataUtils__.j)(result[1].coordinate - result[0].coordinate) : 1, start = void 0, end = void 0;
                1 === sign ? (start = "width" === sizeKey ? x : y, end = "width" === sizeKey ? x + width : y + height) : (start = "width" === sizeKey ? x + width : y + height, 
                end = "width" === sizeKey ? x : y);
                for (var i = len - 1; i >= 0; i--) {
                    var entry = result[i], content = __WEBPACK_IMPORTED_MODULE_0_lodash_isFunction___default()(tickFormatter) ? tickFormatter(entry.value) : entry.value, size = Object(__WEBPACK_IMPORTED_MODULE_5__util_DOMUtils__.c)(content)[sizeKey] + unitSize;
                    if (i === len - 1) {
                        var gap = sign * (entry.coordinate + sign * size / 2 - end);
                        result[i] = entry = _extends({}, entry, {
                            tickCoord: gap > 0 ? entry.coordinate - gap * sign : entry.coordinate
                        });
                    } else result[i] = entry = _extends({}, entry, {
                        tickCoord: entry.coordinate
                    });
                    sign * (entry.tickCoord - sign * size / 2 - start) >= 0 && sign * (entry.tickCoord + sign * size / 2 - end) <= 0 && (end = entry.tickCoord - sign * (size / 2 + minTickGap), 
                    result[i] = _extends({}, entry, {
                        isShow: !0
                    }));
                }
                return result.filter(function(entry) {
                    return entry.isShow;
                });
            }
        } ]), CartesianAxis;
    }(__WEBPACK_IMPORTED_MODULE_1_react__.Component), _class.displayName = "CartesianAxis", 
    _class.propTypes = _extends({}, __WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.c, __WEBPACK_IMPORTED_MODULE_9__util_ReactUtils__.a, {
        className: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string,
        x: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        y: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        width: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        height: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        orientation: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf([ "top", "bottom", "left", "right" ]),
        viewBox: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.shape({
            x: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            y: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            width: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
            height: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number
        }),
        tick: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.element ]),
        axisLine: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object ]),
        tickLine: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object ]),
        mirror: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
        tickMargin: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number.isRequired,
        minTickGap: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        ticks: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.array,
        tickSize: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number,
        stroke: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string,
        tickFormatter: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
        ticksGenerator: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
        interval: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOfType([ __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.oneOf([ "preserveStart", "preserveEnd", "preserveStartEnd" ]) ])
    }), _class.defaultProps = {
        x: 0,
        y: 0,
        width: 0,
        height: 0,
        viewBox: {
            x: 0,
            y: 0,
            width: 0,
            height: 0
        },
        orientation: "bottom",
        ticks: [],
        stroke: "#666",
        tickLine: !0,
        axisLine: !0,
        tick: !0,
        mirror: !1,
        minTickGap: 5,
        tickSize: 6,
        tickMargin: 2,
        interval: "preserveEnd"
    }, _temp);
    __webpack_exports__.a = CartesianAxis;
}, function(module, exports, __webpack_require__) {
    "use strict";
    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }
    var _react = __webpack_require__(0), _react2 = _interopRequireDefault(_react), _reactDom = __webpack_require__(99), _MuiThemeProvider = __webpack_require__(386), _MuiThemeProvider2 = _interopRequireDefault(_MuiThemeProvider), _createMuiTheme = __webpack_require__(161), _createMuiTheme2 = _interopRequireDefault(_createMuiTheme), _Dashboard = __webpack_require__(439), _Dashboard2 = _interopRequireDefault(_Dashboard), theme = (0, 
    _createMuiTheme2.default)({
        palette: {
            type: "dark"
        }
    }), dashboard = document.getElementById("dashboard");
    dashboard && (0, _reactDom.render)(_react2.default.createElement(_MuiThemeProvider2.default, {
        theme: theme
    }, _react2.default.createElement(_Dashboard2.default, null)), dashboard);
}, function(module, exports, __webpack_require__) {
    "use strict";
    function D(a) {
        for (var b = arguments.length - 1, e = "https://reactjs.org/docs/error-decoder.html?invariant=" + a, c = 0; c < b; c++) e += "&args[]=" + encodeURIComponent(arguments[c + 1]);
        n(!1, "Minified React error #" + a + "; visit %s for the full message or use the non-minified dev environment for full errors and additional helpful warnings. ", e);
    }
    function F(a, b, e) {
        this.props = a, this.context = b, this.refs = p, this.updater = e || E;
    }
    function G() {}
    function H(a, b, e) {
        this.props = a, this.context = b, this.refs = p, this.updater = e || E;
    }
    function M(a, b, e) {
        var c = void 0, d = {}, g = null, h = null;
        if (null != b) for (c in void 0 !== b.ref && (h = b.ref), void 0 !== b.key && (g = "" + b.key), 
        b) K.call(b, c) && !L.hasOwnProperty(c) && (d[c] = b[c]);
        var f = arguments.length - 2;
        if (1 === f) d.children = e; else if (1 < f) {
            for (var l = Array(f), m = 0; m < f; m++) l[m] = arguments[m + 2];
            d.children = l;
        }
        if (a && a.defaultProps) for (c in f = a.defaultProps) void 0 === d[c] && (d[c] = f[c]);
        return {
            $$typeof: t,
            type: a,
            key: g,
            ref: h,
            props: d,
            _owner: J.current
        };
    }
    function N(a) {
        return "object" == typeof a && null !== a && a.$$typeof === t;
    }
    function escape(a) {
        var b = {
            "=": "=0",
            ":": "=2"
        };
        return "$" + ("" + a).replace(/[=:]/g, function(a) {
            return b[a];
        });
    }
    function Q(a, b, e, c) {
        if (P.length) {
            var d = P.pop();
            return d.result = a, d.keyPrefix = b, d.func = e, d.context = c, d.count = 0, d;
        }
        return {
            result: a,
            keyPrefix: b,
            func: e,
            context: c,
            count: 0
        };
    }
    function R(a) {
        a.result = null, a.keyPrefix = null, a.func = null, a.context = null, a.count = 0, 
        10 > P.length && P.push(a);
    }
    function S(a, b, e, c) {
        var d = typeof a;
        "undefined" !== d && "boolean" !== d || (a = null);
        var g = !1;
        if (null === a) g = !0; else switch (d) {
          case "string":
          case "number":
            g = !0;
            break;

          case "object":
            switch (a.$$typeof) {
              case t:
              case u:
                g = !0;
            }
        }
        if (g) return e(c, a, "" === b ? "." + T(a, 0) : b), 1;
        if (g = 0, b = "" === b ? "." : b + ":", Array.isArray(a)) for (var h = 0; h < a.length; h++) {
            d = a[h];
            var f = b + T(d, h);
            g += S(d, f, e, c);
        } else if (null === a || void 0 === a ? f = null : (f = C && a[C] || a["@@iterator"], 
        f = "function" == typeof f ? f : null), "function" == typeof f) for (a = f.call(a), 
        h = 0; !(d = a.next()).done; ) d = d.value, f = b + T(d, h++), g += S(d, f, e, c); else "object" === d && (e = "" + a, 
        D("31", "[object Object]" === e ? "object with keys {" + Object.keys(a).join(", ") + "}" : e, ""));
        return g;
    }
    function T(a, b) {
        return "object" == typeof a && null !== a && null != a.key ? escape(a.key) : b.toString(36);
    }
    function U(a, b) {
        a.func.call(a.context, b, a.count++);
    }
    function V(a, b, e) {
        var c = a.result, d = a.keyPrefix;
        a = a.func.call(a.context, b, a.count++), Array.isArray(a) ? W(a, c, e, q.thatReturnsArgument) : null != a && (N(a) && (b = d + (!a.key || b && b.key === a.key ? "" : ("" + a.key).replace(O, "$&/") + "/") + e, 
        a = {
            $$typeof: t,
            type: a.type,
            key: b,
            ref: a.ref,
            props: a.props,
            _owner: a._owner
        }), c.push(a));
    }
    function W(a, b, e, c, d) {
        var g = "";
        null != e && (g = ("" + e).replace(O, "$&/") + "/"), b = Q(b, g, c, d), null == a || S(a, "", V, b), 
        R(b);
    }
    var k = __webpack_require__(74), n = __webpack_require__(49), p = __webpack_require__(97), q = __webpack_require__(50), r = "function" == typeof Symbol && Symbol.for, t = r ? Symbol.for("react.element") : 60103, u = r ? Symbol.for("react.portal") : 60106, v = r ? Symbol.for("react.fragment") : 60107, w = r ? Symbol.for("react.strict_mode") : 60108, x = r ? Symbol.for("react.profiler") : 60114, y = r ? Symbol.for("react.provider") : 60109, z = r ? Symbol.for("react.context") : 60110, A = r ? Symbol.for("react.async_mode") : 60111, B = r ? Symbol.for("react.forward_ref") : 60112;
    r && Symbol.for("react.timeout");
    var C = "function" == typeof Symbol && Symbol.iterator, E = {
        isMounted: function() {
            return !1;
        },
        enqueueForceUpdate: function() {},
        enqueueReplaceState: function() {},
        enqueueSetState: function() {}
    };
    F.prototype.isReactComponent = {}, F.prototype.setState = function(a, b) {
        "object" != typeof a && "function" != typeof a && null != a && D("85"), this.updater.enqueueSetState(this, a, b, "setState");
    }, F.prototype.forceUpdate = function(a) {
        this.updater.enqueueForceUpdate(this, a, "forceUpdate");
    }, G.prototype = F.prototype;
    var I = H.prototype = new G();
    I.constructor = H, k(I, F.prototype), I.isPureReactComponent = !0;
    var J = {
        current: null
    }, K = Object.prototype.hasOwnProperty, L = {
        key: !0,
        ref: !0,
        __self: !0,
        __source: !0
    }, O = /\/+/g, P = [], X = {
        Children: {
            map: function(a, b, e) {
                if (null == a) return a;
                var c = [];
                return W(a, c, null, b, e), c;
            },
            forEach: function(a, b, e) {
                if (null == a) return a;
                b = Q(null, null, b, e), null == a || S(a, "", U, b), R(b);
            },
            count: function(a) {
                return null == a ? 0 : S(a, "", q.thatReturnsNull, null);
            },
            toArray: function(a) {
                var b = [];
                return W(a, b, null, q.thatReturnsArgument), b;
            },
            only: function(a) {
                return N(a) || D("143"), a;
            }
        },
        createRef: function() {
            return {
                current: null
            };
        },
        Component: F,
        PureComponent: H,
        createContext: function(a, b) {
            return void 0 === b && (b = null), a = {
                $$typeof: z,
                _calculateChangedBits: b,
                _defaultValue: a,
                _currentValue: a,
                _currentValue2: a,
                _changedBits: 0,
                _changedBits2: 0,
                Provider: null,
                Consumer: null
            }, a.Provider = {
                $$typeof: y,
                _context: a
            }, a.Consumer = a;
        },
        forwardRef: function(a) {
            return {
                $$typeof: B,
                render: a
            };
        },
        Fragment: v,
        StrictMode: w,
        unstable_AsyncMode: A,
        unstable_Profiler: x,
        createElement: M,
        cloneElement: function(a, b, e) {
            (null === a || void 0 === a) && D("267", a);
            var c = void 0, d = k({}, a.props), g = a.key, h = a.ref, f = a._owner;
            if (null != b) {
                void 0 !== b.ref && (h = b.ref, f = J.current), void 0 !== b.key && (g = "" + b.key);
                var l = void 0;
                a.type && a.type.defaultProps && (l = a.type.defaultProps);
                for (c in b) K.call(b, c) && !L.hasOwnProperty(c) && (d[c] = void 0 === b[c] && void 0 !== l ? l[c] : b[c]);
            }
            if (1 === (c = arguments.length - 2)) d.children = e; else if (1 < c) {
                l = Array(c);
                for (var m = 0; m < c; m++) l[m] = arguments[m + 2];
                d.children = l;
            }
            return {
                $$typeof: t,
                type: a.type,
                key: g,
                ref: h,
                props: d,
                _owner: f
            };
        },
        createFactory: function(a) {
            var b = M.bind(null, a);
            return b.type = a, b;
        },
        isValidElement: N,
        version: "16.4.0",
        __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: {
            ReactCurrentOwner: J,
            assign: k
        }
    }, Y = {
        default: X
    }, Z = Y && X || Y;
    module.exports = Z.default ? Z.default : Z;
}, function(module, exports, __webpack_require__) {
    "use strict";
    (function(process) {
        "production" !== process.env.NODE_ENV && function() {
            function getIteratorFn(maybeIterable) {
                if (null === maybeIterable || void 0 === maybeIterable) return null;
                var maybeIterator = MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL];
                return "function" == typeof maybeIterator ? maybeIterator : null;
            }
            function warnNoop(publicInstance, callerName) {
                var _constructor = publicInstance.constructor, componentName = _constructor && (_constructor.displayName || _constructor.name) || "ReactClass", warningKey = componentName + "." + callerName;
                didWarnStateUpdateForUnmountedComponent[warningKey] || (warning(!1, "Can't call %s on a component that is not yet mounted. This is a no-op, but it might indicate a bug in your application. Instead, assign to ` + ("`" + `this.state`)) + ("`" + (` directly or define a ` + "`")))))) + (((((`state = {};` + ("`" + ` class property with the desired state in the %s component.", callerName, componentName), 
                didWarnStateUpdateForUnmountedComponent[warningKey] = !0);
            }
            function Component(props, context, updater) {
                this.props = props, this.context = context, this.refs = emptyObject, this.updater = updater || ReactNoopUpdateQueue;
            }
            function ComponentDummy() {}
            function PureComponent(props, context, updater) {
                this.props = props, this.context = context, this.refs = emptyObject, this.updater = updater || ReactNoopUpdateQueue;
            }
            function createRef() {
                var refObject = {
                    current: null
                };
                return Object.seal(refObject), refObject;
            }
            function hasValidRef(config) {
                if (hasOwnProperty.call(config, "ref")) {
                    var getter = Object.getOwnPropertyDescriptor(config, "ref").get;
                    if (getter && getter.isReactWarning) return !1;
                }
                return void 0 !== config.ref;
            }
            function hasValidKey(config) {
                if (hasOwnProperty.call(config, "key")) {
                    var getter = Object.getOwnPropertyDescriptor(config, "key").get;
                    if (getter && getter.isReactWarning) return !1;
                }
                return void 0 !== config.key;
            }
            function defineKeyPropWarningGetter(props, displayName) {
                var warnAboutAccessingKey = function() {
                    specialPropKeyWarningShown || (specialPropKeyWarningShown = !0, warning(!1, "%s: `)) + ("`" + (`key` + "`"))) + ((` is not a prop. Trying to access it will result in ` + ("`" + `undefined`)) + ("`" + (` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://fb.me/react-special-props)", displayName));
                };
                warnAboutAccessingKey.isReactWarning = !0, Object.defineProperty(props, "key", {
                    get: warnAboutAccessingKey,
                    configurable: !0
                });
            }
            function defineRefPropWarningGetter(props, displayName) {
                var warnAboutAccessingRef = function() {
                    specialPropRefWarningShown || (specialPropRefWarningShown = !0, warning(!1, "%s: ` + "`")))) + (((`ref` + ("`" + ` is not a prop. Trying to access it will result in `)) + ("`" + (`undefined` + "`"))) + ((` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://fb.me/react-special-props)", displayName));
                };
                warnAboutAccessingRef.isReactWarning = !0, Object.defineProperty(props, "ref", {
                    get: warnAboutAccessingRef,
                    configurable: !0
                });
            }
            function createElement(type, config, children) {
                var propName = void 0, props = {}, key = null, ref = null, self = null, source = null;
                if (null != config) {
                    hasValidRef(config) && (ref = config.ref), hasValidKey(config) && (key = "" + config.key), 
                    self = void 0 === config.__self ? null : config.__self, source = void 0 === config.__source ? null : config.__source;
                    for (propName in config) hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName) && (props[propName] = config[propName]);
                }
                var childrenLength = arguments.length - 2;
                if (1 === childrenLength) props.children = children; else if (childrenLength > 1) {
                    for (var childArray = Array(childrenLength), i = 0; i < childrenLength; i++) childArray[i] = arguments[i + 2];
                    Object.freeze && Object.freeze(childArray), props.children = childArray;
                }
                if (type && type.defaultProps) {
                    var defaultProps = type.defaultProps;
                    for (propName in defaultProps) void 0 === props[propName] && (props[propName] = defaultProps[propName]);
                }
                if ((key || ref) && (void 0 === props.$$typeof || props.$$typeof !== REACT_ELEMENT_TYPE)) {
                    var displayName = "function" == typeof type ? type.displayName || type.name || "Unknown" : type;
                    key && defineKeyPropWarningGetter(props, displayName), ref && defineRefPropWarningGetter(props, displayName);
                }
                return ReactElement(type, key, ref, self, source, ReactCurrentOwner.current, props);
            }
            function cloneAndReplaceKey(oldElement, newKey) {
                return ReactElement(oldElement.type, newKey, oldElement.ref, oldElement._self, oldElement._source, oldElement._owner, oldElement.props);
            }
            function cloneElement(element, config, children) {
                (null === element || void 0 === element) && invariant(!1, "React.cloneElement(...): The argument must be a React element, but you passed %s.", element);
                var propName = void 0, props = _assign({}, element.props), key = element.key, ref = element.ref, self = element._self, source = element._source, owner = element._owner;
                if (null != config) {
                    hasValidRef(config) && (ref = config.ref, owner = ReactCurrentOwner.current), hasValidKey(config) && (key = "" + config.key);
                    var defaultProps = void 0;
                    element.type && element.type.defaultProps && (defaultProps = element.type.defaultProps);
                    for (propName in config) hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName) && (void 0 === config[propName] && void 0 !== defaultProps ? props[propName] = defaultProps[propName] : props[propName] = config[propName]);
                }
                var childrenLength = arguments.length - 2;
                if (1 === childrenLength) props.children = children; else if (childrenLength > 1) {
                    for (var childArray = Array(childrenLength), i = 0; i < childrenLength; i++) childArray[i] = arguments[i + 2];
                    props.children = childArray;
                }
                return ReactElement(element.type, key, ref, self, source, owner, props);
            }
            function isValidElement(object) {
                return "object" == typeof object && null !== object && object.$$typeof === REACT_ELEMENT_TYPE;
            }
            function escape(key) {
                var escaperLookup = {
                    "=": "=0",
                    ":": "=2"
                };
                return "$" + ("" + key).replace(/[=:]/g, function(match) {
                    return escaperLookup[match];
                });
            }
            function escapeUserProvidedKey(text) {
                return ("" + text).replace(userProvidedKeyEscapeRegex, "$&/");
            }
            function getPooledTraverseContext(mapResult, keyPrefix, mapFunction, mapContext) {
                if (traverseContextPool.length) {
                    var traverseContext = traverseContextPool.pop();
                    return traverseContext.result = mapResult, traverseContext.keyPrefix = keyPrefix, 
                    traverseContext.func = mapFunction, traverseContext.context = mapContext, traverseContext.count = 0, 
                    traverseContext;
                }
                return {
                    result: mapResult,
                    keyPrefix: keyPrefix,
                    func: mapFunction,
                    context: mapContext,
                    count: 0
                };
            }
            function releaseTraverseContext(traverseContext) {
                traverseContext.result = null, traverseContext.keyPrefix = null, traverseContext.func = null, 
                traverseContext.context = null, traverseContext.count = 0, traverseContextPool.length < POOL_SIZE && traverseContextPool.push(traverseContext);
            }
            function traverseAllChildrenImpl(children, nameSoFar, callback, traverseContext) {
                var type = typeof children;
                "undefined" !== type && "boolean" !== type || (children = null);
                var invokeCallback = !1;
                if (null === children) invokeCallback = !0; else switch (type) {
                  case "string":
                  case "number":
                    invokeCallback = !0;
                    break;

                  case "object":
                    switch (children.$$typeof) {
                      case REACT_ELEMENT_TYPE:
                      case REACT_PORTAL_TYPE:
                        invokeCallback = !0;
                    }
                }
                if (invokeCallback) return callback(traverseContext, children, "" === nameSoFar ? SEPARATOR + getComponentKey(children, 0) : nameSoFar), 
                1;
                var child = void 0, nextName = void 0, subtreeCount = 0, nextNamePrefix = "" === nameSoFar ? SEPARATOR : nameSoFar + SUBSEPARATOR;
                if (Array.isArray(children)) for (var i = 0; i < children.length; i++) child = children[i], 
                nextName = nextNamePrefix + getComponentKey(child, i), subtreeCount += traverseAllChildrenImpl(child, nextName, callback, traverseContext); else {
                    var iteratorFn = getIteratorFn(children);
                    if ("function" == typeof iteratorFn) {
                        iteratorFn === children.entries && (didWarnAboutMaps || warning(!1, "Using Maps as children is unsupported and will likely yield unexpected results. Convert it to a sequence/iterable of keyed ReactElements instead.%s", ReactDebugCurrentFrame.getStackAddendum()), 
                        didWarnAboutMaps = !0);
                        for (var iterator = iteratorFn.call(children), step = void 0, ii = 0; !(step = iterator.next()).done; ) child = step.value, 
                        nextName = nextNamePrefix + getComponentKey(child, ii++), subtreeCount += traverseAllChildrenImpl(child, nextName, callback, traverseContext);
                    } else if ("object" === type) {
                        var addendum = "";
                        addendum = " If you meant to render a collection of children, use an array instead." + ReactDebugCurrentFrame.getStackAddendum();
                        var childrenString = "" + children;
                        invariant(!1, "Objects are not valid as a React child (found: %s).%s", "[object Object]" === childrenString ? "object with keys {" + Object.keys(children).join(", ") + "}" : childrenString, addendum);
                    }
                }
                return subtreeCount;
            }
            function traverseAllChildren(children, callback, traverseContext) {
                return null == children ? 0 : traverseAllChildrenImpl(children, "", callback, traverseContext);
            }
            function getComponentKey(component, index) {
                return "object" == typeof component && null !== component && null != component.key ? escape(component.key) : index.toString(36);
            }
            function forEachSingleChild(bookKeeping, child, name) {
                var func = bookKeeping.func, context = bookKeeping.context;
                func.call(context, child, bookKeeping.count++);
            }
            function forEachChildren(children, forEachFunc, forEachContext) {
                if (null == children) return children;
                var traverseContext = getPooledTraverseContext(null, null, forEachFunc, forEachContext);
                traverseAllChildren(children, forEachSingleChild, traverseContext), releaseTraverseContext(traverseContext);
            }
            function mapSingleChildIntoContext(bookKeeping, child, childKey) {
                var result = bookKeeping.result, keyPrefix = bookKeeping.keyPrefix, func = bookKeeping.func, context = bookKeeping.context, mappedChild = func.call(context, child, bookKeeping.count++);
                Array.isArray(mappedChild) ? mapIntoWithKeyPrefixInternal(mappedChild, result, childKey, emptyFunction.thatReturnsArgument) : null != mappedChild && (isValidElement(mappedChild) && (mappedChild = cloneAndReplaceKey(mappedChild, keyPrefix + (!mappedChild.key || child && child.key === mappedChild.key ? "" : escapeUserProvidedKey(mappedChild.key) + "/") + childKey)), 
                result.push(mappedChild));
            }
            function mapIntoWithKeyPrefixInternal(children, array, prefix, func, context) {
                var escapedPrefix = "";
                null != prefix && (escapedPrefix = escapeUserProvidedKey(prefix) + "/");
                var traverseContext = getPooledTraverseContext(array, escapedPrefix, func, context);
                traverseAllChildren(children, mapSingleChildIntoContext, traverseContext), releaseTraverseContext(traverseContext);
            }
            function mapChildren(children, func, context) {
                if (null == children) return children;
                var result = [];
                return mapIntoWithKeyPrefixInternal(children, result, null, func, context), result;
            }
            function countChildren(children) {
                return traverseAllChildren(children, emptyFunction.thatReturnsNull, null);
            }
            function toArray(children) {
                var result = [];
                return mapIntoWithKeyPrefixInternal(children, result, null, emptyFunction.thatReturnsArgument), 
                result;
            }
            function onlyChild(children) {
                return isValidElement(children) || invariant(!1, "React.Children.only expected to receive a single React element child."), 
                children;
            }
            function createContext(defaultValue, calculateChangedBits) {
                void 0 === calculateChangedBits ? calculateChangedBits = null : null !== calculateChangedBits && "function" != typeof calculateChangedBits && warning(!1, "createContext: Expected the optional second argument to be a function. Instead received: %s", calculateChangedBits);
                var context = {
                    $$typeof: REACT_CONTEXT_TYPE,
                    _calculateChangedBits: calculateChangedBits,
                    _defaultValue: defaultValue,
                    _currentValue: defaultValue,
                    _currentValue2: defaultValue,
                    _changedBits: 0,
                    _changedBits2: 0,
                    Provider: null,
                    Consumer: null
                };
                return context.Provider = {
                    $$typeof: REACT_PROVIDER_TYPE,
                    _context: context
                }, context.Consumer = context, context._currentRenderer = null, context._currentRenderer2 = null, 
                context;
            }
            function forwardRef(render) {
                return "function" != typeof render && warning(!1, "forwardRef requires a render function but was given %s.", null === render ? "null" : typeof render), 
                null != render && (null != render.defaultProps || null != render.propTypes) && warning(!1, "forwardRef render functions do not support propTypes or defaultProps. Did you accidentally pass a React component?"), 
                {
                    $$typeof: REACT_FORWARD_REF_TYPE,
                    render: render
                };
            }
            function isValidElementType(type) {
                return "string" == typeof type || "function" == typeof type || type === REACT_FRAGMENT_TYPE || type === REACT_ASYNC_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_TIMEOUT_TYPE || "object" == typeof type && null !== type && (type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE);
            }
            function getComponentName(fiber) {
                var type = fiber.type;
                if ("function" == typeof type) return type.displayName || type.name;
                if ("string" == typeof type) return type;
                switch (type) {
                  case REACT_ASYNC_MODE_TYPE:
                    return "AsyncMode";

                  case REACT_CONTEXT_TYPE:
                    return "Context.Consumer";

                  case REACT_FRAGMENT_TYPE:
                    return "ReactFragment";

                  case REACT_PORTAL_TYPE:
                    return "ReactPortal";

                  case REACT_PROFILER_TYPE:
                    return "Profiler(" + fiber.pendingProps.id + ")";

                  case REACT_PROVIDER_TYPE:
                    return "Context.Provider";

                  case REACT_STRICT_MODE_TYPE:
                    return "StrictMode";

                  case REACT_TIMEOUT_TYPE:
                    return "Timeout";
                }
                if ("object" == typeof type && null !== type) switch (type.$$typeof) {
                  case REACT_FORWARD_REF_TYPE:
                    var functionName = type.render.displayName || type.render.name || "";
                    return "" !== functionName ? "ForwardRef(" + functionName + ")" : "ForwardRef";
                }
                return null;
            }
            function getDeclarationErrorAddendum() {
                if (ReactCurrentOwner.current) {
                    var name = getComponentName(ReactCurrentOwner.current);
                    if (name) return "\n\nCheck the render method of ` + ("`" + `" + name + "`)) + ("`" + (`.";
                }
                return "";
            }
            function getSourceInfoErrorAddendum(elementProps) {
                if (null !== elementProps && void 0 !== elementProps && void 0 !== elementProps.__source) {
                    var source = elementProps.__source;
                    return "\n\nCheck your code at " + source.fileName.replace(/^.*[\\\/]/, "") + ":" + source.lineNumber + ".";
                }
                return "";
            }
            function getCurrentComponentErrorInfo(parentType) {
                var info = getDeclarationErrorAddendum();
                if (!info) {
                    var parentName = "string" == typeof parentType ? parentType : parentType.displayName || parentType.name;
                    parentName && (info = "\n\nCheck the top-level render call using <" + parentName + ">.");
                }
                return info;
            }
            function validateExplicitKey(element, parentType) {
                if (element._store && !element._store.validated && null == element.key) {
                    element._store.validated = !0;
                    var currentComponentErrorInfo = getCurrentComponentErrorInfo(parentType);
                    if (!ownerHasKeyUseWarning[currentComponentErrorInfo]) {
                        ownerHasKeyUseWarning[currentComponentErrorInfo] = !0;
                        var childOwner = "";
                        element && element._owner && element._owner !== ReactCurrentOwner.current && (childOwner = " It was passed a child from " + getComponentName(element._owner) + "."), 
                        currentlyValidatingElement = element, warning(!1, 'Each child in an array or iterator should have a unique "key" prop.%s%s See https://fb.me/react-warning-keys for more information.%s', currentComponentErrorInfo, childOwner, getStackAddendum()), 
                        currentlyValidatingElement = null;
                    }
                }
            }
            function validateChildKeys(node, parentType) {
                if ("object" == typeof node) if (Array.isArray(node)) for (var i = 0; i < node.length; i++) {
                    var child = node[i];
                    isValidElement(child) && validateExplicitKey(child, parentType);
                } else if (isValidElement(node)) node._store && (node._store.validated = !0); else if (node) {
                    var iteratorFn = getIteratorFn(node);
                    if ("function" == typeof iteratorFn && iteratorFn !== node.entries) for (var iterator = iteratorFn.call(node), step = void 0; !(step = iterator.next()).done; ) isValidElement(step.value) && validateExplicitKey(step.value, parentType);
                }
            }
            function validatePropTypes(element) {
                var componentClass = element.type;
                if ("function" == typeof componentClass) {
                    var name = componentClass.displayName || componentClass.name, propTypes = componentClass.propTypes;
                    propTypes ? (currentlyValidatingElement = element, checkPropTypes(propTypes, element.props, "prop", name, getStackAddendum), 
                    currentlyValidatingElement = null) : void 0 === componentClass.PropTypes || propTypesMisspellWarningShown || (propTypesMisspellWarningShown = !0, 
                    warning(!1, "Component %s declared ` + "`"))))) + ((((`PropTypes` + ("`" + ` instead of `)) + ("`" + (`propTypes` + "`"))) + ((`. Did you misspell the property assignment?", name || "Unknown")), 
                    "function" == typeof componentClass.getDefaultProps && (componentClass.getDefaultProps.isReactClassApproved || warning(!1, "getDefaultProps is only used on classic React.createClass definitions. Use a static property named ` + ("`" + `defaultProps`)) + ("`" + (` instead."));
                }
            }
            function validateFragmentProps(fragment) {
                currentlyValidatingElement = fragment;
                for (var keys = Object.keys(fragment.props), i = 0; i < keys.length; i++) {
                    var key = keys[i];
                    if ("children" !== key && "key" !== key) {
                        warning(!1, "Invalid prop ` + "`")))) + (((`%s` + ("`" + ` supplied to `)) + ("`" + (`React.Fragment` + "`"))) + ((`. React.Fragment can only have ` + ("`" + `key`)) + ("`" + (` and ` + "`"))))))) + ((((((`children` + ("`" + ` props.%s", key, getStackAddendum());
                        break;
                    }
                }
                null !== fragment.ref && warning(!1, "Invalid attribute `)) + ("`" + (`ref` + "`"))) + ((` supplied to ` + ("`" + `React.Fragment`)) + ("`" + (`.%s", getStackAddendum()), 
                currentlyValidatingElement = null;
            }
            function createElementWithValidation(type, props, children) {
                var validType = isValidElementType(type);
                if (!validType) {
                    var info = "";
                    (void 0 === type || "object" == typeof type && null !== type && 0 === Object.keys(type).length) && (info += " You likely forgot to export your component from the file it's defined in, or you might have mixed up default and named imports.");
                    var sourceInfo = getSourceInfoErrorAddendum(props);
                    info += sourceInfo || getDeclarationErrorAddendum(), info += getStackAddendum() || "";
                    var typeString = void 0;
                    typeString = null === type ? "null" : Array.isArray(type) ? "array" : typeof type, 
                    warning(!1, "React.createElement: type is invalid -- expected a string (for built-in components) or a class/function (for composite components) but got: %s.%s", typeString, info);
                }
                var element = createElement.apply(this, arguments);
                if (null == element) return element;
                if (validType) for (var i = 2; i < arguments.length; i++) validateChildKeys(arguments[i], type);
                return type === REACT_FRAGMENT_TYPE ? validateFragmentProps(element) : validatePropTypes(element), 
                element;
            }
            function createFactoryWithValidation(type) {
                var validatedFactory = createElementWithValidation.bind(null, type);
                return validatedFactory.type = type, Object.defineProperty(validatedFactory, "type", {
                    enumerable: !1,
                    get: function() {
                        return lowPriorityWarning$1(!1, "Factory.type is deprecated. Access the class directly before passing it to createFactory."), 
                        Object.defineProperty(this, "type", {
                            value: type
                        }), type;
                    }
                }), validatedFactory;
            }
            function cloneElementWithValidation(element, props, children) {
                for (var newElement = cloneElement.apply(this, arguments), i = 2; i < arguments.length; i++) validateChildKeys(arguments[i], newElement.type);
                return validatePropTypes(newElement), newElement;
            }
            var _assign = __webpack_require__(74), invariant = __webpack_require__(49), emptyObject = __webpack_require__(97), warning = __webpack_require__(98), emptyFunction = __webpack_require__(50), checkPropTypes = __webpack_require__(143), hasSymbol = "function" == typeof Symbol && Symbol.for, REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for("react.element") : 60103, REACT_PORTAL_TYPE = hasSymbol ? Symbol.for("react.portal") : 60106, REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for("react.fragment") : 60107, REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for("react.strict_mode") : 60108, REACT_PROFILER_TYPE = hasSymbol ? Symbol.for("react.profiler") : 60114, REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for("react.provider") : 60109, REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for("react.context") : 60110, REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for("react.async_mode") : 60111, REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for("react.forward_ref") : 60112, REACT_TIMEOUT_TYPE = hasSymbol ? Symbol.for("react.timeout") : 60113, MAYBE_ITERATOR_SYMBOL = "function" == typeof Symbol && Symbol.iterator, FAUX_ITERATOR_SYMBOL = "@@iterator", lowPriorityWarning = function() {}, printWarning = function(format) {
                for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) args[_key - 1] = arguments[_key];
                var argIndex = 0, message = "Warning: " + format.replace(/%s/g, function() {
                    return args[argIndex++];
                });
                "undefined" != typeof console && console.warn(message);
                try {
                    throw new Error(message);
                } catch (x) {}
            };
            lowPriorityWarning = function(condition, format) {
                if (void 0 === format) throw new Error("` + "`")))) + (((`warning(condition, format, ...args)` + ("`" + ` requires a warning message argument");
                if (!condition) {
                    for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) args[_key2 - 2] = arguments[_key2];
                    printWarning.apply(void 0, [ format ].concat(args));
                }
            };
            var lowPriorityWarning$1 = lowPriorityWarning, didWarnStateUpdateForUnmountedComponent = {}, ReactNoopUpdateQueue = {
                isMounted: function(publicInstance) {
                    return !1;
                },
                enqueueForceUpdate: function(publicInstance, callback, callerName) {
                    warnNoop(publicInstance, "forceUpdate");
                },
                enqueueReplaceState: function(publicInstance, completeState, callback, callerName) {
                    warnNoop(publicInstance, "replaceState");
                },
                enqueueSetState: function(publicInstance, partialState, callback, callerName) {
                    warnNoop(publicInstance, "setState");
                }
            };
            Component.prototype.isReactComponent = {}, Component.prototype.setState = function(partialState, callback) {
                "object" != typeof partialState && "function" != typeof partialState && null != partialState && invariant(!1, "setState(...): takes an object of state variables to update or a function which returns an object of state variables."), 
                this.updater.enqueueSetState(this, partialState, callback, "setState");
            }, Component.prototype.forceUpdate = function(callback) {
                this.updater.enqueueForceUpdate(this, callback, "forceUpdate");
            };
            var deprecatedAPIs = {
                isMounted: [ "isMounted", "Instead, make sure to clean up subscriptions and pending requests in componentWillUnmount to prevent memory leaks." ],
                replaceState: [ "replaceState", "Refactor your code to use setState instead (see https://github.com/facebook/react/issues/3236)." ]
            };
            for (var fnName in deprecatedAPIs) deprecatedAPIs.hasOwnProperty(fnName) && function(methodName, info) {
                Object.defineProperty(Component.prototype, methodName, {
                    get: function() {
                        lowPriorityWarning$1(!1, "%s(...) is deprecated in plain JavaScript React classes. %s", info[0], info[1]);
                    }
                });
            }(fnName, deprecatedAPIs[fnName]);
            ComponentDummy.prototype = Component.prototype;
            var pureComponentPrototype = PureComponent.prototype = new ComponentDummy();
            pureComponentPrototype.constructor = PureComponent, _assign(pureComponentPrototype, Component.prototype), 
            pureComponentPrototype.isPureReactComponent = !0;
            var ReactCurrentOwner = {
                current: null
            }, hasOwnProperty = Object.prototype.hasOwnProperty, RESERVED_PROPS = {
                key: !0,
                ref: !0,
                __self: !0,
                __source: !0
            }, specialPropKeyWarningShown = void 0, specialPropRefWarningShown = void 0, ReactElement = function(type, key, ref, self, source, owner, props) {
                var element = {
                    $$typeof: REACT_ELEMENT_TYPE,
                    type: type,
                    key: key,
                    ref: ref,
                    props: props,
                    _owner: owner
                };
                return element._store = {}, Object.defineProperty(element._store, "validated", {
                    configurable: !1,
                    enumerable: !1,
                    writable: !0,
                    value: !1
                }), Object.defineProperty(element, "_self", {
                    configurable: !1,
                    enumerable: !1,
                    writable: !1,
                    value: self
                }), Object.defineProperty(element, "_source", {
                    configurable: !1,
                    enumerable: !1,
                    writable: !1,
                    value: source
                }), Object.freeze && (Object.freeze(element.props), Object.freeze(element)), element;
            }, ReactDebugCurrentFrame = {};
            ReactDebugCurrentFrame.getCurrentStack = null, ReactDebugCurrentFrame.getStackAddendum = function() {
                var impl = ReactDebugCurrentFrame.getCurrentStack;
                return impl ? impl() : null;
            };
            var SEPARATOR = ".", SUBSEPARATOR = ":", didWarnAboutMaps = !1, userProvidedKeyEscapeRegex = /\/+/g, POOL_SIZE = 10, traverseContextPool = [], describeComponentFrame = function(name, source, ownerName) {
                return "\n    in " + (name || "Unknown") + (source ? " (at " + source.fileName.replace(/^.*[\\\/]/, "") + ":" + source.lineNumber + ")" : ownerName ? " (created by " + ownerName + ")" : "");
            }, currentlyValidatingElement = void 0, propTypesMisspellWarningShown = void 0, getDisplayName = function() {}, getStackAddendum = function() {};
            currentlyValidatingElement = null, propTypesMisspellWarningShown = !1, getDisplayName = function(element) {
                return null == element ? "#empty" : "string" == typeof element || "number" == typeof element ? "#text" : "string" == typeof element.type ? element.type : element.type === REACT_FRAGMENT_TYPE ? "React.Fragment" : element.type.displayName || element.type.name || "Unknown";
            }, getStackAddendum = function() {
                var stack = "";
                if (currentlyValidatingElement) {
                    var name = getDisplayName(currentlyValidatingElement), owner = currentlyValidatingElement._owner;
                    stack += describeComponentFrame(name, currentlyValidatingElement._source, owner && getComponentName(owner));
                }
                return stack += ReactDebugCurrentFrame.getStackAddendum() || "";
            };
            var ownerHasKeyUseWarning = {}, React = {
                Children: {
                    map: mapChildren,
                    forEach: forEachChildren,
                    count: countChildren,
                    toArray: toArray,
                    only: onlyChild
                },
                createRef: createRef,
                Component: Component,
                PureComponent: PureComponent,
                createContext: createContext,
                forwardRef: forwardRef,
                Fragment: REACT_FRAGMENT_TYPE,
                StrictMode: REACT_STRICT_MODE_TYPE,
                unstable_AsyncMode: REACT_ASYNC_MODE_TYPE,
                unstable_Profiler: REACT_PROFILER_TYPE,
                createElement: createElementWithValidation,
                cloneElement: cloneElementWithValidation,
                createFactory: createFactoryWithValidation,
                isValidElement: isValidElement,
                version: "16.4.0",
                __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: {
                    ReactCurrentOwner: ReactCurrentOwner,
                    assign: _assign
                }
            };
            _assign(React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED, {
                ReactDebugCurrentFrame: ReactDebugCurrentFrame,
                ReactComponentTreeHook: {}
            });
            var React$2 = Object.freeze({
                default: React
            }), React$3 = React$2 && React || React$2, react = React$3.default ? React$3.default : React$3;
            module.exports = react;
        }();
    }).call(exports, __webpack_require__(2));
}, function(module, exports, __webpack_require__) {
    "use strict";
    function A(a) {
        for (var b = arguments.length - 1, c = "https://reactjs.org/docs/error-decoder.html?invariant=" + a, d = 0; d < b; d++) c += "&args[]=" + encodeURIComponent(arguments[d + 1]);
        aa(!1, "Minified React error #" + a + "; visit %s for the full message or use the non-minified dev environment for full errors and additional helpful warnings. ", c);
    }
    function ia(a, b, c, d, e, f, g, h, k) {
        this._hasCaughtError = !1, this._caughtError = null;
        var n = Array.prototype.slice.call(arguments, 3);
        try {
            b.apply(c, n);
        } catch (r) {
            this._caughtError = r, this._hasCaughtError = !0;
        }
    }
    function ka() {
        if (B._hasRethrowError) {
            var a = B._rethrowError;
            throw B._rethrowError = null, B._hasRethrowError = !1, a;
        }
    }
    function na() {
        if (la) for (var a in ma) {
            var b = ma[a], c = la.indexOf(a);
            if (-1 < c || A("96", a), !oa[c]) {
                b.extractEvents || A("97", a), oa[c] = b, c = b.eventTypes;
                for (var d in c) {
                    var e = void 0, f = c[d], g = b, h = d;
                    pa.hasOwnProperty(h) && A("99", h), pa[h] = f;
                    var k = f.phasedRegistrationNames;
                    if (k) {
                        for (e in k) k.hasOwnProperty(e) && qa(k[e], g, h);
                        e = !0;
                    } else f.registrationName ? (qa(f.registrationName, g, h), e = !0) : e = !1;
                    e || A("98", d, a);
                }
            }
        }
    }
    function qa(a, b, c) {
        ra[a] && A("100", a), ra[a] = b, sa[a] = b.eventTypes[c].dependencies;
    }
    function ta(a) {
        la && A("101"), la = Array.prototype.slice.call(a), na();
    }
    function ua(a) {
        var c, b = !1;
        for (c in a) if (a.hasOwnProperty(c)) {
            var d = a[c];
            ma.hasOwnProperty(c) && ma[c] === d || (ma[c] && A("102", c), ma[c] = d, b = !0);
        }
        b && na();
    }
    function za(a, b, c, d) {
        b = a.type || "unknown-event", a.currentTarget = ya(d), B.invokeGuardedCallbackAndCatchFirstError(b, c, void 0, a), 
        a.currentTarget = null;
    }
    function Aa(a, b) {
        return null == b && A("30"), null == a ? b : Array.isArray(a) ? Array.isArray(b) ? (a.push.apply(a, b), 
        a) : (a.push(b), a) : Array.isArray(b) ? [ a ].concat(b) : [ a, b ];
    }
    function Ba(a, b, c) {
        Array.isArray(a) ? a.forEach(b, c) : a && b.call(c, a);
    }
    function Da(a, b) {
        if (a) {
            var c = a._dispatchListeners, d = a._dispatchInstances;
            if (Array.isArray(c)) for (var e = 0; e < c.length && !a.isPropagationStopped(); e++) za(a, b, c[e], d[e]); else c && za(a, b, c, d);
            a._dispatchListeners = null, a._dispatchInstances = null, a.isPersistent() || a.constructor.release(a);
        }
    }
    function Ea(a) {
        return Da(a, !0);
    }
    function Fa(a) {
        return Da(a, !1);
    }
    function Ha(a, b) {
        var c = a.stateNode;
        if (!c) return null;
        var d = wa(c);
        if (!d) return null;
        c = d[b];
        a: switch (b) {
          case "onClick":
          case "onClickCapture":
          case "onDoubleClick":
          case "onDoubleClickCapture":
          case "onMouseDown":
          case "onMouseDownCapture":
          case "onMouseMove":
          case "onMouseMoveCapture":
          case "onMouseUp":
          case "onMouseUpCapture":
            (d = !d.disabled) || (a = a.type, d = !("button" === a || "input" === a || "select" === a || "textarea" === a)), 
            a = !d;
            break a;

          default:
            a = !1;
        }
        return a ? null : (c && "function" != typeof c && A("231", b, typeof c), c);
    }
    function Ia(a, b) {
        null !== a && (Ca = Aa(Ca, a)), a = Ca, Ca = null, a && (b ? Ba(a, Ea) : Ba(a, Fa), 
        Ca && A("95"), B.rethrowCaughtError());
    }
    function Ja(a, b, c, d) {
        for (var e = null, f = 0; f < oa.length; f++) {
            var g = oa[f];
            g && (g = g.extractEvents(a, b, c, d)) && (e = Aa(e, g));
        }
        Ia(e, !1);
    }
    function Na(a) {
        if (a[C]) return a[C];
        for (;!a[C]; ) {
            if (!a.parentNode) return null;
            a = a.parentNode;
        }
        return a = a[C], 5 === a.tag || 6 === a.tag ? a : null;
    }
    function Oa(a) {
        if (5 === a.tag || 6 === a.tag) return a.stateNode;
        A("33");
    }
    function Pa(a) {
        return a[Ma] || null;
    }
    function F(a) {
        do {
            a = a.return;
        } while (a && 5 !== a.tag);
        return a || null;
    }
    function Ra(a, b, c) {
        for (var d = []; a; ) d.push(a), a = F(a);
        for (a = d.length; 0 < a--; ) b(d[a], "captured", c);
        for (a = 0; a < d.length; a++) b(d[a], "bubbled", c);
    }
    function Sa(a, b, c) {
        (b = Ha(a, c.dispatchConfig.phasedRegistrationNames[b])) && (c._dispatchListeners = Aa(c._dispatchListeners, b), 
        c._dispatchInstances = Aa(c._dispatchInstances, a));
    }
    function Ta(a) {
        a && a.dispatchConfig.phasedRegistrationNames && Ra(a._targetInst, Sa, a);
    }
    function Ua(a) {
        if (a && a.dispatchConfig.phasedRegistrationNames) {
            var b = a._targetInst;
            b = b ? F(b) : null, Ra(b, Sa, a);
        }
    }
    function Va(a, b, c) {
        a && c && c.dispatchConfig.registrationName && (b = Ha(a, c.dispatchConfig.registrationName)) && (c._dispatchListeners = Aa(c._dispatchListeners, b), 
        c._dispatchInstances = Aa(c._dispatchInstances, a));
    }
    function Xa(a) {
        a && a.dispatchConfig.registrationName && Va(a._targetInst, null, a);
    }
    function Ya(a) {
        Ba(a, Ta);
    }
    function Za(a, b, c, d) {
        if (c && d) a: {
            for (var e = c, f = d, g = 0, h = e; h; h = F(h)) g++;
            h = 0;
            for (var k = f; k; k = F(k)) h++;
            for (;0 < g - h; ) e = F(e), g--;
            for (;0 < h - g; ) f = F(f), h--;
            for (;g--; ) {
                if (e === f || e === f.alternate) break a;
                e = F(e), f = F(f);
            }
            e = null;
        } else e = null;
        for (f = e, e = []; c && c !== f && (null === (g = c.alternate) || g !== f); ) e.push(c), 
        c = F(c);
        for (c = []; d && d !== f && (null === (g = d.alternate) || g !== f); ) c.push(d), 
        d = F(d);
        for (d = 0; d < e.length; d++) Va(e[d], "bubbled", a);
        for (a = c.length; 0 < a--; ) Va(c[a], "captured", b);
    }
    function ab(a, b) {
        var c = {};
        return c[a.toLowerCase()] = b.toLowerCase(), c["Webkit" + a] = "webkit" + b, c["Moz" + a] = "moz" + b, 
        c["ms" + a] = "MS" + b, c["O" + a] = "o" + b.toLowerCase(), c;
    }
    function eb(a) {
        if (cb[a]) return cb[a];
        if (!bb[a]) return a;
        var c, b = bb[a];
        for (c in b) if (b.hasOwnProperty(c) && c in db) return cb[a] = b[c];
        return a;
    }
    function lb() {
        return !kb && m.canUseDOM && (kb = "textContent" in document.documentElement ? "textContent" : "innerText"), 
        kb;
    }
    function mb() {
        if (G._fallbackText) return G._fallbackText;
        var a, d, b = G._startText, c = b.length, e = nb(), f = e.length;
        for (a = 0; a < c && b[a] === e[a]; a++) ;
        var g = c - a;
        for (d = 1; d <= g && b[c - d] === e[f - d]; d++) ;
        return G._fallbackText = e.slice(a, 1 < d ? 1 - d : void 0), G._fallbackText;
    }
    function nb() {
        return "value" in G._root ? G._root.value : G._root[lb()];
    }
    function H(a, b, c, d) {
        this.dispatchConfig = a, this._targetInst = b, this.nativeEvent = c, a = this.constructor.Interface;
        for (var e in a) a.hasOwnProperty(e) && ((b = a[e]) ? this[e] = b(c) : "target" === e ? this.target = d : this[e] = c[e]);
        return this.isDefaultPrevented = (null != c.defaultPrevented ? c.defaultPrevented : !1 === c.returnValue) ? v.thatReturnsTrue : v.thatReturnsFalse, 
        this.isPropagationStopped = v.thatReturnsFalse, this;
    }
    function rb(a, b, c, d) {
        if (this.eventPool.length) {
            var e = this.eventPool.pop();
            return this.call(e, a, b, c, d), e;
        }
        return new this(a, b, c, d);
    }
    function sb(a) {
        a instanceof this || A("223"), a.destructor(), 10 > this.eventPool.length && this.eventPool.push(a);
    }
    function qb(a) {
        a.eventPool = [], a.getPooled = rb, a.release = sb;
    }
    function Db(a, b) {
        switch (a) {
          case "keyup":
            return -1 !== vb.indexOf(b.keyCode);

          case "keydown":
            return 229 !== b.keyCode;

          case "keypress":
          case "mousedown":
          case "blur":
            return !0;

          default:
            return !1;
        }
    }
    function Eb(a) {
        return a = a.detail, "object" == typeof a && "data" in a ? a.data : null;
    }
    function Gb(a, b) {
        switch (a) {
          case "compositionend":
            return Eb(b);

          case "keypress":
            return 32 !== b.which ? null : (Cb = !0, Ab);

          case "textInput":
            return a = b.data, a === Ab && Cb ? null : a;

          default:
            return null;
        }
    }
    function Hb(a, b) {
        if (Fb) return "compositionend" === a || !wb && Db(a, b) ? (a = mb(), G._root = null, 
        G._startText = null, G._fallbackText = null, Fb = !1, a) : null;
        switch (a) {
          case "paste":
            return null;

          case "keypress":
            if (!(b.ctrlKey || b.altKey || b.metaKey) || b.ctrlKey && b.altKey) {
                if (b.char && 1 < b.char.length) return b.char;
                if (b.which) return String.fromCharCode(b.which);
            }
            return null;

          case "compositionend":
            return zb ? null : b.data;

          default:
            return null;
        }
    }
    function Nb(a) {
        if (a = xa(a)) {
            Jb && "function" == typeof Jb.restoreControlledState || A("194");
            var b = wa(a.stateNode);
            Jb.restoreControlledState(a.stateNode, a.type, b);
        }
    }
    function Ob(a) {
        Lb ? Mb ? Mb.push(a) : Mb = [ a ] : Lb = a;
    }
    function Pb() {
        return null !== Lb || null !== Mb;
    }
    function Qb() {
        if (Lb) {
            var a = Lb, b = Mb;
            if (Mb = Lb = null, Nb(a), b) for (a = 0; a < b.length; a++) Nb(b[a]);
        }
    }
    function Sb(a, b) {
        return a(b);
    }
    function Tb(a, b, c) {
        return a(b, c);
    }
    function Ub() {}
    function Wb(a, b) {
        if (Vb) return a(b);
        Vb = !0;
        try {
            return Sb(a, b);
        } finally {
            Vb = !1, Pb() && (Ub(), Qb());
        }
    }
    function Yb(a) {
        var b = a && a.nodeName && a.nodeName.toLowerCase();
        return "input" === b ? !!Xb[a.type] : "textarea" === b;
    }
    function Zb(a) {
        return a = a.target || window, a.correspondingUseElement && (a = a.correspondingUseElement), 
        3 === a.nodeType ? a.parentNode : a;
    }
    function $b(a, b) {
        return !(!m.canUseDOM || b && !("addEventListener" in document)) && (a = "on" + a, 
        b = a in document, b || (b = document.createElement("div"), b.setAttribute(a, "return;"), 
        b = "function" == typeof b[a]), b);
    }
    function ac(a) {
        var b = a.type;
        return (a = a.nodeName) && "input" === a.toLowerCase() && ("checkbox" === b || "radio" === b);
    }
    function bc(a) {
        var b = ac(a) ? "checked" : "value", c = Object.getOwnPropertyDescriptor(a.constructor.prototype, b), d = "" + a[b];
        if (!a.hasOwnProperty(b) && void 0 !== c && "function" == typeof c.get && "function" == typeof c.set) {
            var e = c.get, f = c.set;
            return Object.defineProperty(a, b, {
                configurable: !0,
                get: function() {
                    return e.call(this);
                },
                set: function(a) {
                    d = "" + a, f.call(this, a);
                }
            }), Object.defineProperty(a, b, {
                enumerable: c.enumerable
            }), {
                getValue: function() {
                    return d;
                },
                setValue: function(a) {
                    d = "" + a;
                },
                stopTracking: function() {
                    a._valueTracker = null, delete a[b];
                }
            };
        }
    }
    function cc(a) {
        a._valueTracker || (a._valueTracker = bc(a));
    }
    function dc(a) {
        if (!a) return !1;
        var b = a._valueTracker;
        if (!b) return !0;
        var c = b.getValue(), d = "";
        return a && (d = ac(a) ? a.checked ? "true" : "false" : a.value), (a = d) !== c && (b.setValue(a), 
        !0);
    }
    function sc(a) {
        return null === a || void 0 === a ? null : (a = rc && a[rc] || a["@@iterator"], 
        "function" == typeof a ? a : null);
    }
    function tc(a) {
        var b = a.type;
        if ("function" == typeof b) return b.displayName || b.name;
        if ("string" == typeof b) return b;
        switch (b) {
          case oc:
            return "AsyncMode";

          case nc:
            return "Context.Consumer";

          case hc:
            return "ReactFragment";

          case gc:
            return "ReactPortal";

          case jc:
            return "Profiler(" + a.pendingProps.id + ")";

          case mc:
            return "Context.Provider";

          case ic:
            return "StrictMode";

          case qc:
            return "Timeout";
        }
        if ("object" == typeof b && null !== b) switch (b.$$typeof) {
          case pc:
            return a = b.render.displayName || b.render.name || "", "" !== a ? "ForwardRef(" + a + ")" : "ForwardRef";
        }
        return null;
    }
    function vc(a) {
        var b = "";
        do {
            a: switch (a.tag) {
              case 0:
              case 1:
              case 2:
              case 5:
                var c = a._debugOwner, d = a._debugSource, e = tc(a), f = null;
                c && (f = tc(c)), c = d, e = "\n    in " + (e || "Unknown") + (c ? " (at " + c.fileName.replace(/^.*[\\\/]/, "") + ":" + c.lineNumber + ")" : f ? " (created by " + f + ")" : "");
                break a;

              default:
                e = "";
            }
            b += e, a = a.return;
        } while (a);
        return b;
    }
    function zc(a) {
        return !!yc.hasOwnProperty(a) || !xc.hasOwnProperty(a) && (wc.test(a) ? yc[a] = !0 : (xc[a] = !0, 
        !1));
    }
    function Ac(a, b, c, d) {
        if (null !== c && 0 === c.type) return !1;
        switch (typeof b) {
          case "function":
          case "symbol":
            return !0;

          case "boolean":
            return !d && (null !== c ? !c.acceptsBooleans : "data-" !== (a = a.toLowerCase().slice(0, 5)) && "aria-" !== a);

          default:
            return !1;
        }
    }
    function Bc(a, b, c, d) {
        if (null === b || void 0 === b || Ac(a, b, c, d)) return !0;
        if (d) return !1;
        if (null !== c) switch (c.type) {
          case 3:
            return !b;

          case 4:
            return !1 === b;

          case 5:
            return isNaN(b);

          case 6:
            return isNaN(b) || 1 > b;
        }
        return !1;
    }
    function J(a, b, c, d, e) {
        this.acceptsBooleans = 2 === b || 3 === b || 4 === b, this.attributeName = d, this.attributeNamespace = e, 
        this.mustUseProperty = c, this.propertyN