/*************************************************************************
 * Copyright (c) 2013 AT&T Intellectual Property 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Details at https://graphviz.org
 *************************************************************************/

#include <sparse/color_palette.h>
#include <string.h>
#include <common/macros.h>

int knownColorScheme(const char* name)
{
  int r, g, b;

  return streq(name,"rgb") 
      || streq(name,"lab") 
      || streq(name,"gray") 
      || color_palettes_Q(name) 
      || (sscanf(name,"#%02X%02X%02X", &r, &g, &b) == 3);
}

char *color_palettes_get(char *color_palette_name){
  int i;
  for (i = 0; i < npalettes; i++){
    if (strcmp(color_palette_name, color_palettes[i][0]) == 0){
      return color_palettes[i][1];
    }
  }
  return NULL;
}

int color_palettes_Q(const char *color_palette_name) {
  int i;
  for (i = 0; i < npalettes; i++){
    if (strcmp(color_palette_name, color_palettes[i][0]) == 0){
      return 1;
    }
  }
  return 0;
}


char *color_palettes[npalettes][2] = {{"accent3","#7fc97f,#beaed4,#fdc086"},
				      {"accent4","#7fc97f,#beaed4,#fdc086,#ffff99"},
				      {"accent5","#7fc97f,#beaed4,#fdc086,#ffff99,#386cb0"},
				      {"accent6","#7fc97f,#beaed4,#fdc086,#ffff99,#386cb0,#f0027f"},
				      {"accent7","#7fc97f,#beaed4,#fdc086,#ffff99,#386cb0,#f0027f,#bf5b17"},
				      {"accent8","#7fc97f,#beaed4,#fdc086,#ffff99,#386cb0,#f0027f,#bf5b17,#666666"},
				      {"blues3","#deebf7,#9ecae1,#3182bd"},
				      {"blues4","#eff3ff,#bdd7e7,#6baed6,#2171b5"},
				      {"blues5","#eff3ff,#bdd7e7,#6baed6,#3182bd,#08519c"},
				      {"blues6","#eff3ff,#c6dbef,#9ecae1,#6baed6,#3182bd,#08519c"},
				      {"blues7","#eff3ff,#c6dbef,#9ecae1,#6baed6,#4292c6,#2171b5,#084594"},
				      {"blues8","#f7fbff,#deebf7,#c6dbef,#9ecae1,#6baed6,#4292c6,#2171b5,#084594"},
				      {"blues9","#f7fbff,#deebf7,#c6dbef,#9ecae1,#6baed6,#4292c6,#2171b5,#08519c,#08306b"},
				      {"brbg10","#543005,#8c510a,#bf812d,#dfc27d,#f6e8c3,#c7eae5,#80cdc1,#35978f,#01665e,#003c30"},
				      {"brbg11","#543005,#8c510a,#bf812d,#dfc27d,#f6e8c3,#f5f5f5,#c7eae5,#80cdc1,#35978f,#01665e,#003c30"},
				      {"brbg3","#d8b365,#f5f5f5,#5ab4ac"},
				      {"brbg4","#a6611a,#dfc27d,#80cdc1,#018571"},
				      {"brbg5","#a6611a,#dfc27d,#f5f5f5,#80cdc1,#018571"},
				      {"brbg6","#8c510a,#d8b365,#f6e8c3,#c7eae5,#5ab4ac,#01665e"},
				      {"brbg7","#8c510a,#d8b365,#f6e8c3,#f5f5f5,#c7eae5,#5ab4ac,#01665e"},
				      {"brbg8","#8c510a,#bf812d,#dfc27d,#f6e8c3,#c7eae5,#80cdc1,#35978f,#01665e"},
				      {"brbg9","#8c510a,#bf812d,#dfc27d,#f6e8c3,#f5f5f5,#c7eae5,#80cdc1,#35978f,#01665e"},
				      {"bugn3","#e5f5f9,#99d8c9,#2ca25f"},
				      {"bugn4","#edf8fb,#b2e2e2,#66c2a4,#238b45"},
				      {"bugn5","#edf8fb,#b2e2e2,#66c2a4,#2ca25f,#006d2c"},
				      {"bugn6","#edf8fb,#ccece6,#99d8c9,#66c2a4,#2ca25f,#006d2c"},
				      {"bugn7","#edf8fb,#ccece6,#99d8c9,#66c2a4,#41ae76,#238b45,#005824"},
				      {"bugn8","#f7fcfd,#e5f5f9,#ccece6,#99d8c9,#66c2a4,#41ae76,#238b45,#005824"},
				      {"bugn9","#f7fcfd,#e5f5f9,#ccece6,#99d8c9,#66c2a4,#41ae76,#238b45,#006d2c,#00441b"},
				      {"bupu3","#e0ecf4,#9ebcda,#8856a7"},
				      {"bupu4","#edf8fb,#b3cde3,#8c96c6,#88419d"},
				      {"bupu5","#edf8fb,#b3cde3,#8c96c6,#8856a7,#810f7c"},
				      {"bupu6","#edf8fb,#bfd3e6,#9ebcda,#8c96c6,#8856a7,#810f7c"},
				      {"bupu7","#edf8fb,#bfd3e6,#9ebcda,#8c96c6,#8c6bb1,#88419d,#6e016b"},
				      {"bupu8","#f7fcfd,#e0ecf4,#bfd3e6,#9ebcda,#8c96c6,#8c6bb1,#88419d,#6e016b"},
				      {"bupu9","#f7fcfd,#e0ecf4,#bfd3e6,#9ebcda,#8c96c6,#8c6bb1,#88419d,#810f7c,#4d004b"},
				      {"dark23","#1b9e77,#d95f02,#7570b3"},
				      {"dark24","#1b9e77,#d95f02,#7570b3,#e7298a"},
				      {"dark25","#1b9e77,#d95f02,#7570b3,#e7298a,#66a61e"},
				      {"dark26","#1b9e77,#d95f02,#7570b3,#e7298a,#66a61e,#e6ab02"},
				      {"dark27","#1b9e77,#d95f02,#7570b3,#e7298a,#66a61e,#e6ab02,#a6761d"},
				      {"dark28","#1b9e77,#d95f02,#7570b3,#e7298a,#66a61e,#e6ab02,#a6761d,#666666"},
				      {"gnbu3","#e0f3db,#a8ddb5,#43a2ca"},
				      {"gnbu4","#f0f9e8,#bae4bc,#7bccc4,#2b8cbe"},
				      {"gnbu5","#f0f9e8,#bae4bc,#7bccc4,#43a2ca,#0868ac"},
				      {"gnbu6","#f0f9e8,#ccebc5,#a8ddb5,#7bccc4,#43a2ca,#0868ac"},
				      {"gnbu7","#f0f9e8,#ccebc5,#a8ddb5,#7bccc4,#4eb3d3,#2b8cbe,#08589e"},
				      {"gnbu8","#f7fcf0,#e0f3db,#ccebc5,#a8ddb5,#7bccc4,#4eb3d3,#2b8cbe,#08589e"},
				      {"gnbu9","#f7fcf0,#e0f3db,#ccebc5,#a8ddb5,#7bccc4,#4eb3d3,#2b8cbe,#0868ac,#084081"},
				      {"greens3","#e5f5e0,#a1d99b,#31a354"},
				      {"greens4","#edf8e9,#bae4b3,#74c476,#238b45"},
				      {"greens5","#edf8e9,#bae4b3,#74c476,#31a354,#006d2c"},
				      {"greens6","#edf8e9,#c7e9c0,#a1d99b,#74c476,#31a354,#006d2c"},
				      {"greens7","#edf8e9,#c7e9c0,#a1d99b,#74c476,#41ab5d,#238b45,#005a32"},
				      {"greens8","#f7fcf5,#e5f5e0,#c7e9c0,#a1d99b,#74c476,#41ab5d,#238b45,#005a32"},
				      {"greens9","#f7fcf5,#e5f5e0,#c7e9c0,#a1d99b,#74c476,#41ab5d,#238b45,#006d2c,#00441b"},
				      {"greys3","#f0f0f0,#bdbdbd,#636363"},
				      {"greys4","#f7f7f7,#cccccc,#969696,#525252"},
				      {"greys5","#f7f7f7,#cccccc,#969696,#636363,#252525"},
				      {"greys6","#f7f7f7,#d9d9d9,#bdbdbd,#969696,#636363,#252525"},
				      {"greys7","#f7f7f7,#d9d9d9,#bdbdbd,#969696,#737373,#525252,#252525"},
				      {"greys8","#ffffff,#f0f0f0,#d9d9d9,#bdbdbd,#969696,#737373,#525252,#252525"},
				      {"greys9","#ffffff,#f0f0f0,#d9d9d9,#bdbdbd,#969696,#737373,#525252,#252525,#000000"},
				      {"oranges3","#fee6ce,#fdae6b,#e6550d"},
				      {"oranges4","#feedde,#fdbe85,#fd8d3c,#d94701"},
				      {"oranges5","#feedde,#fdbe85,#fd8d3c,#e6550d,#a63603"},
				      {"oranges6","#feedde,#fdd0a2,#fdae6b,#fd8d3c,#e6550d,#a63603"},
				      {"oranges7","#feedde,#fdd0a2,#fdae6b,#fd8d3c,#f16913,#d94801,#8c2d04"},
				      {"oranges8","#fff5eb,#fee6ce,#fdd0a2,#fdae6b,#fd8d3c,#f16913,#d94801,#8c2d04"},
				      {"oranges9","#fff5eb,#fee6ce,#fdd0a2,#fdae6b,#fd8d3c,#f16913,#d94801,#a63603,#7f2704"},
				      {"orrd3","#fee8c8,#fdbb84,#e34a33"},
				      {"orrd4","#fef0d9,#fdcc8a,#fc8d59,#d7301f"},
				      {"orrd5","#fef0d9,#fdcc8a,#fc8d59,#e34a33,#b30000"},
				      {"orrd6","#fef0d9,#fdd49e,#fdbb84,#fc8d59,#e34a33,#b30000"},
				      {"orrd7","#fef0d9,#fdd49e,#fdbb84,#fc8d59,#ef6548,#d7301f,#990000"},
				      {"orrd8","#fff7ec,#fee8c8,#fdd49e,#fdbb84,#fc8d59,#ef6548,#d7301f,#990000"},
				      {"orrd9","#fff7ec,#fee8c8,#fdd49e,#fdbb84,#fc8d59,#ef6548,#d7301f,#b30000,#7f0000"},
				      {"paired10","#a6cee3,#1f78b4,#b2df8a,#33a02c,#fb9a99,#e31a1c,#fdbf6f,#ff7f00,#cab2d6,#6a3d9a"},
				      {"paired11","#a6cee3,#1f78b4,#b2df8a,#33a02c,#fb9a99,#e31a1c,#fdbf6f,#ff7f00,#cab2d6,#6a3d9a,#ffff99"},
				      {"paired12","#a6cee3,#1f78b4,#b2df8a,#33a02c,#fb9a99,#e31a1c,#fdbf6f,#ff7f00,#cab2d6,#6a3d9a,#ffff99,#b15928"},
				      {"paired3","#a6cee3,#1f78b4,#b2df8a"},
				      {"paired4","#a6cee3,#1f78b4,#b2df8a,#33a02c"},
				      {"paired5","#a6cee3,#1f78b4,#b2df8a,#33a02c,#fb9a99"},
				      {"paired6","#a6cee3,#1f78b4,#b2df8a,#33a02c,#fb9a99,#e31a1c"},
				      {"paired7","#a6cee3,#1f78b4,#b2df8a,#33a02c,#fb9a99,#e31a1c,#fdbf6f"},
				      {"paired8","#a6cee3,#1f78b4,#b2df8a,#33a02c,#fb9a99,#e31a1c,#fdbf6f,#ff7f00"},
				      {"paired9","#a6cee3,#1f78b4,#b2df8a,#33a02c,#fb9a99,#e31a1c,#fdbf6f,#ff7f00,#cab2d6"},
				      {"pastel13","#fbb4ae,#b3cde3,#ccebc5"},
				      {"pastel14","#fbb4ae,#b3cde3,#ccebc5,#decbe4"},
				      {"pastel15","#fbb4ae,#b3cde3,#ccebc5,#decbe4,#fed9a6"},
				      {"pastel16","#fbb4ae,#b3cde3,#ccebc5,#decbe4,#fed9a6,#ffffcc"},
				      {"pastel17","#fbb4ae,#b3cde3,#ccebc5,#decbe4,#fed9a6,#ffffcc,#e5d8bd"},
				      {"pastel18","#fbb4ae,#b3cde3,#ccebc5,#decbe4,#fed9a6,#ffffcc,#e5d8bd,#fddaec"},
				      {"pastel19","#fbb4ae,#b3cde3,#ccebc5,#decbe4,#fed9a6,#ffffcc,#e5d8bd,#fddaec,#f2f2f2"},
				      {"pastel23","#b3e2cd,#fdcdac,#cbd5e8"},
				      {"pastel24","#b3e2cd,#fdcdac,#cbd5e8,#f4cae4"},
				      {"pastel25","#b3e2cd,#fdcdac,#cbd5e8,#f4cae4,#e6f5c9"},
				      {"pastel26","#b3e2cd,#fdcdac,#cbd5e8,#f4cae4,#e6f5c9,#fff2ae"},
				      {"pastel27","#b3e2cd,#fdcdac,#cbd5e8,#f4cae4,#e6f5c9,#fff2ae,#f1e2cc"},
				      {"pastel28","#b3e2cd,#fdcdac,#cbd5e8,#f4cae4,#e6f5c9,#fff2ae,#f1e2cc,#cccccc"},
				      {"piyg10","#8e0152,#c51b7d,#de77ae,#f1b6da,#fde0ef,#e6f5d0,#b8e186,#7fbc41,#4d9221,#276419"},
				      {"piyg11","#8e0152,#c51b7d,#de77ae,#f1b6da,#fde0ef,#f7f7f7,#e6f5d0,#b8e186,#7fbc41,#4d9221,#276419"},
				      {"piyg3","#e9a3c9,#f7f7f7,#a1d76a"},
				      {"piyg4","#d01c8b,#f1b6da,#b8e186,#4dac26"},
				      {"piyg5","#d01c8b,#f1b6da,#f7f7f7,#b8e186,#4dac26"},
				      {"piyg6","#c51b7d,#e9a3c9,#fde0ef,#e6f5d0,#a1d76a,#4d9221"},
				      {"piyg7","#c51b7d,#e9a3c9,#fde0ef,#f7f7f7,#e6f5d0,#a1d76a,#4d9221"},
				      {"piyg8","#c51b7d,#de77ae,#f1b6da,#fde0ef,#e6f5d0,#b8e186,#7fbc41,#4d9221"},
				      {"piyg9","#c51b7d,#de77ae,#f1b6da,#fde0ef,#f7f7f7,#e6f5d0,#b8e186,#7fbc41,#4d9221"},
				      {"prgn10","#40004b,#762a83,#9970ab,#c2a5cf,#e7d4e8,#d9f0d3,#a6dba0,#5aae61,#1b7837,#00441b"},
				      {"prgn11","#40004b,#762a83,#9970ab,#c2a5cf,#e7d4e8,#f7f7f7,#d9f0d3,#a6dba0,#5aae61,#1b7837,#00441b"},
				      {"prgn3","#af8dc3,#f7f7f7,#7fbf7b"},
				      {"prgn4","#7b3294,#c2a5cf,#a6dba0,#008837"},
				      {"prgn5","#7b3294,#c2a5cf,#f7f7f7,#a6dba0,#008837"},
				      {"prgn6","#762a83,#af8dc3,#e7d4e8,#d9f0d3,#7fbf7b,#1b7837"},
				      {"prgn7","#762a83,#af8dc3,#e7d4e8,#f7f7f7,#d9f0d3,#7fbf7b,#1b7837"},
				      {"prgn8","#762a83,#9970ab,#c2a5cf,#e7d4e8,#d9f0d3,#a6dba0,#5aae61,#1b7837"},
				      {"prgn9","#762a83,#9970ab,#c2a5cf,#e7d4e8,#f7f7f7,#d9f0d3,#a6dba0,#5aae61,#1b7837"},
				      {"pubu3","#ece7f2,#a6bddb,#2b8cbe"},
				      {"pubu4","#f1eef6,#bdc9e1,#74a9cf,#0570b0"},
				      {"pubu5","#f1eef6,#bdc9e1,#74a9cf,#2b8cbe,#045a8d"},
				      {"pubu6","#f1eef6,#d0d1e6,#a6bddb,#74a9cf,#2b8cbe,#045a8d"},
				      {"pubu7","#f1eef6,#d0d1e6,#a6bddb,#74a9cf,#3690c0,#0570b0,#034e7b"},
				      {"pubu8","#fff7fb,#ece7f2,#d0d1e6,#a6bddb,#74a9cf,#3690c0,#0570b0,#034e7b"},
				      {"pubu9","#fff7fb,#ece7f2,#d0d1e6,#a6bddb,#74a9cf,#3690c0,#0570b0,#045a8d,#023858"},
				      {"pubugn3","#ece2f0,#a6bddb,#1c9099"},
				      {"pubugn4","#f6eff7,#bdc9e1,#67a9cf,#02818a"},
				      {"pubugn5","#f6eff7,#bdc9e1,#67a9cf,#1c9099,#016c59"},
				      {"pubugn6","#f6eff7,#d0d1e6,#a6bddb,#67a9cf,#1c9099,#016c59"},
				      {"pubugn7","#f6eff7,#d0d1e6,#a6bddb,#67a9cf,#3690c0,#02818a,#016450"},
				      {"pubugn8","#fff7fb,#ece2f0,#d0d1e6,#a6bddb,#67a9cf,#3690c0,#02818a,#016450"},
				      {"pubugn9","#fff7fb,#ece2f0,#d0d1e6,#a6bddb,#67a9cf,#3690c0,#02818a,#016c59,#014636"},
				      {"puor10","#7f3b08,#b35806,#e08214,#fdb863,#fee0b6,#d8daeb,#b2abd2,#8073ac,#542788,#2d004b"},
				      {"puor11","#7f3b08,#b35806,#e08214,#fdb863,#fee0b6,#f7f7f7,#d8daeb,#b2abd2,#8073ac,#542788,#2d004b"},
				      {"puor3","#f1a340,#f7f7f7,#998ec3"},
				      {"puor4","#e66101,#fdb863,#b2abd2,#5e3c99"},
				      {"puor5","#e66101,#fdb863,#f7f7f7,#b2abd2,#5e3c99"},
				      {"puor6","#b35806,#f1a340,#fee0b6,#d8daeb,#998ec3,#542788"},
				      {"puor7","#b35806,#f1a340,#fee0b6,#f7f7f7,#d8daeb,#998ec3,#542788"},
				      {"puor8","#b35806,#e08214,#fdb863,#fee0b6,#d8daeb,#b2abd2,#8073ac,#542788"},
				      {"puor9","#b35806,#e08214,#fdb863,#fee0b6,#f7f7f7,#d8daeb,#b2abd2,#8073ac,#542788"},
				      {"purd3","#e7e1ef,#c994c7,#dd1c77"},
				      {"purd4","#f1eef6,#d7b5d8,#df65b0,#ce1256"},
				      {"purd5","#f1eef6,#d7b5d8,#df65b0,#dd1c77,#980043"},
				      {"purd6","#f1eef6,#d4b9da,#c994c7,#df65b0,#dd1c77,#980043"},
				      {"purd7","#f1eef6,#d4b9da,#c994c7,#df65b0,#e7298a,#ce1256,#91003f"},
				      {"purd8","#f7f4f9,#e7e1ef,#d4b9da,#c994c7,#df65b0,#e7298a,#ce1256,#91003f"},
				      {"purd9","#f7f4f9,#e7e1ef,#d4b9da,#c994c7,#df65b0,#e7298a,#ce1256,#980043,#67001f"},
				      {"purples3","#efedf5,#bcbddc,#756bb1"},
				      {"purples4","#f2f0f7,#cbc9e2,#9e9ac8,#6a51a3"},
				      {"purples5","#f2f0f7,#cbc9e2,#9e9ac8,#756bb1,#54278f"},
				      {"purples6","#f2f0f7,#dadaeb,#bcbddc,#9e9ac8,#756bb1,#54278f"},
				      {"purples7","#f2f0f7,#dadaeb,#bcbddc,#9e9ac8,#807dba,#6a51a3,#4a1486"},
				      {"purples8","#fcfbfd,#efedf5,#dadaeb,#bcbddc,#9e9ac8,#807dba,#6a51a3,#4a1486"},
				      {"purples9","#fcfbfd,#efedf5,#dadaeb,#bcbddc,#9e9ac8,#807dba,#6a51a3,#54278f,#3f007d"},
				      {"rdbu10","#67001f,#b2182b,#d6604d,#f4a582,#fddbc7,#d1e5f0,#92c5de,#4393c3,#2166ac,#053061"},
				      {"rdbu11","#67001f,#b2182b,#d6604d,#f4a582,#fddbc7,#f7f7f7,#d1e5f0,#92c5de,#4393c3,#2166ac,#053061"},
				      {"rdbu3","#ef8a62,#f7f7f7,#67a9cf"},
				      {"rdbu4","#ca0020,#f4a582,#92c5de,#0571b0"},
				      {"rdbu5","#ca0020,#f4a582,#f7f7f7,#92c5de,#0571b0"},
				      {"rdbu6","#b2182b,#ef8a62,#fddbc7,#d1e5f0,#67a9cf,#2166ac"},
				      {"rdbu7","#b2182b,#ef8a62,#fddbc7,#f7f7f7,#d1e5f0,#67a9cf,#2166ac"},
				      {"rdbu8","#b2182b,#d6604d,#f4a582,#fddbc7,#d1e5f0,#92c5de,#4393c3,#2166ac"},
				      {"rdbu9","#b2182b,#d6604d,#f4a582,#fddbc7,#f7f7f7,#d1e5f0,#92c5de,#4393c3,#2166ac"},
				      {"rdgy10","#67001f,#b2182b,#d6604d,#f4a582,#fddbc7,#e0e0e0,#bababa,#878787,#4d4d4d,#1a1a1a"},
				      {"rdgy11","#67001f,#b2182b,#d6604d,#f4a582,#fddbc7,#ffffff,#e0e0e0,#bababa,#878787,#4d4d4d,#1a1a1a"},
				      {"rdgy3","#ef8a62,#ffffff,#999999"},
				      {"rdgy4","#ca0020,#f4a582,#bababa,#404040"},
				      {"rdgy5","#ca0020,#f4a582,#ffffff,#bababa,#404040"},
				      {"rdgy6","#b2182b,#ef8a62,#fddbc7,#e0e0e0,#999999,#4d4d4d"},
				      {"rdgy7","#b2182b,#ef8a62,#fddbc7,#ffffff,#e0e0e0,#999999,#4d4d4d"},
				      {"rdgy8","#b2182b,#d6604d,#f4a582,#fddbc7,#e0e0e0,#bababa,#878787,#4d4d4d"},
				      {"rdgy9","#b2182b,#d6604d,#f4a582,#fddbc7,#ffffff,#e0e0e0,#bababa,#878787,#4d4d4d"},
				      {"rdpu3","#fde0dd,#fa9fb5,#c51b8a"},
				      {"rdpu4","#feebe2,#fbb4b9,#f768a1,#ae017e"},
				      {"rdpu5","#feebe2,#fbb4b9,#f768a1,#c51b8a,#7a0177"},
				      {"rdpu6","#feebe2,#fcc5c0,#fa9fb5,#f768a1,#c51b8a,#7a0177"},
				      {"rdpu7","#feebe2,#fcc5c0,#fa9fb5,#f768a1,#dd3497,#ae017e,#7a0177"},
				      {"rdpu8","#fff7f3,#fde0dd,#fcc5c0,#fa9fb5,#f768a1,#dd3497,#ae017e,#7a0177"},
				      {"rdpu9","#fff7f3,#fde0dd,#fcc5c0,#fa9fb5,#f768a1,#dd3497,#ae017e,#7a0177,#49006a"},
				      {"rdylbu10","#a50026,#d73027,#f46d43,#fdae61,#fee090,#e0f3f8,#abd9e9,#74add1,#4575b4,#313695"},
				      {"rdylbu11","#a50026,#d73027,#f46d43,#fdae61,#fee090,#ffffbf,#e0f3f8,#abd9e9,#74add1,#4575b4,#313695"},
				      {"rdylbu3","#fc8d59,#ffffbf,#91bfdb"},
				      {"rdylbu4","#d7191c,#fdae61,#abd9e9,#2c7bb6"},
				      {"rdylbu5","#d7191c,#fdae61,#ffffbf,#abd9e9,#2c7bb6"},
				      {"rdylbu6","#d73027,#fc8d59,#fee090,#e0f3f8,#91bfdb,#4575b4"},
				      {"rdylbu7","#d73027,#fc8d59,#fee090,#ffffbf,#e0f3f8,#91bfdb,#4575b4"},
				      {"rdylbu8","#d73027,#f46d43,#fdae61,#fee090,#e0f3f8,#abd9e9,#74add1,#4575b4"},
				      {"rdylbu9","#d73027,#f46d43,#fdae61,#fee090,#ffffbf,#e0f3f8,#abd9e9,#74add1,#4575b4"},
				      {"rdylgn10","#a50026,#d73027,#f46d43,#fdae61,#fee08b,#d9ef8b,#a6d96a,#66bd63,#1a9850,#006837"},
				      {"rdylgn11","#a50026,#d73027,#f46d43,#fdae61,#fee08b,#ffffbf,#d9ef8b,#a6d96a,#66bd63,#1a9850,#006837"},
				      {"rdylgn3","#fc8d59,#ffffbf,#91cf60"},
				      {"rdylgn4","#d7191c,#fdae61,#a6d96a,#1a9641"},
				      {"rdylgn5","#d7191c,#fdae61,#ffffbf,#a6d96a,#1a9641"},
				      {"rdylgn6","#d73027,#fc8d59,#fee08b,#d9ef8b,#91cf60,#1a9850"},
				      {"rdylgn7","#d73027,#fc8d59,#fee08b,#ffffbf,#d9ef8b,#91cf60,#1a9850"},
				      {"rdylgn8","#d73027,#f46d43,#fdae61,#fee08b,#d9ef8b,#a6d96a,#66bd63,#1a9850"},
				      {"rdylgn9","#d73027,#f46d43,#fdae61,#fee08b,#ffffbf,#d9ef8b,#a6d96a,#66bd63,#1a9850"},
				      {"reds3","#fee0d2,#fc9272,#de2d26"},
				      {"reds4","#fee5d9,#fcae91,#fb6a4a,#cb181d"},
				      {"reds5","#fee5d9,#fcae91,#fb6a4a,#de2d26,#a50f15"},
				      {"reds6","#fee5d9,#fcbba1,#fc9272,#fb6a4a,#de2d26,#a50f15"},
				      {"reds7","#fee5d9,#fcbba1,#fc9272,#fb6a4a,#ef3b2c,#cb181d,#99000d"},
				      {"reds8","#fff5f0,#fee0d2,#fcbba1,#fc9272,#fb6a4a,#ef3b2c,#cb181d,#99000d"},
				      {"reds9","#fff5f0,#fee0d2,#fcbba1,#fc9272,#fb6a4a,#ef3b2c,#cb181d,#a50f15,#67000d"},
				      {"set13","#e41a1c,#377eb8,#4daf4a"},
				      {"set14","#e41a1c,#377eb8,#4daf4a,#984ea3"},
				      {"set15","#e41a1c,#377eb8,#4daf4a,#984ea3,#ff7f00"},
				      {"set16","#e41a1c,#377eb8,#4daf4a,#984ea3,#ff7f00,#ffff33"},
				      {"set17","#e41a1c,#377eb8,#4daf4a,#984ea3,#ff7f00,#ffff33,#a65628"},
				      {"set18","#e41a1c,#377eb8,#4daf4a,#984ea3,#ff7f00,#ffff33,#a65628,#f781bf"},
				      {"set19","#e41a1c,#377eb8,#4daf4a,#984ea3,#ff7f00,#ffff33,#a65628,#f781bf,#999999"},
				      {"set23","#66c2a5,#fc8d62,#8da0cb"},
				      {"set24","#66c2a5,#fc8d62,#8da0cb,#e78ac3"},
				      {"set25","#66c2a5,#fc8d62,#8da0cb,#e78ac3,#a6d854"},
				      {"set26","#66c2a5,#fc8d62,#8da0cb,#e78ac3,#a6d854,#ffd92f"},
				      {"set27","#66c2a5,#fc8d62,#8da0cb,#e78ac3,#a6d854,#ffd92f,#e5c494"},
				      {"set28","#66c2a5,#fc8d62,#8da0cb,#e78ac3,#a6d854,#ffd92f,#e5c494,#b3b3b3"},
				      {"set310","#8dd3c7,#ffffb3,#bebada,#fb8072,#80b1d3,#fdb462,#b3de69,#fccde5,#d9d9d9,#bc80bd"},
				      {"set311","#8dd3c7,#ffffb3,#bebada,#fb8072,#80b1d3,#fdb462,#b3de69,#fccde5,#d9d9d9,#bc80bd,#ccebc5"},
				      {"set312","#8dd3c7,#ffffb3,#bebada,#fb8072,#80b1d3,#fdb462,#b3de69,#fccde5,#d9d9d9,#bc80bd,#ccebc5,#ffed6f"},
				      {"set33","#8dd3c7,#ffffb3,#bebada"},
				      {"set34","#8dd3c7,#ffffb3,#bebada,#fb8072"},
				      {"set35","#8dd3c7,#ffffb3,#bebada,#fb8072,#80b1d3"},
				      {"set36","#8dd3c7,#ffffb3,#bebada,#fb8072,#80b1d3,#fdb462"},
				      {"set37","#8dd3c7,#ffffb3,#bebada,#fb8072,#80b1d3,#fdb462,#b3de69"},
				      {"set38","#8dd3c7,#ffffb3,#bebada,#fb8072,#80b1d3,#fdb462,#b3de69,#fccde5"},
				      {"set39","#8dd3c7,#ffffb3,#bebada,#fb8072,#80b1d3,#fdb462,#b3de69,#fccde5,#d9d9d9"},
				      {"spectral10","#9e0142,#d53e4f,#f46d43,#fdae61,#fee08b,#e6f598,#abdda4,#66c2a5,#3288bd,#5e4fa2"},
				      {"spectral11","#9e0142,#d53e4f,#f46d43,#fdae61,#fee08b,#ffffbf,#e6f598,#abdda4,#66c2a5,#3288bd,#5e4fa2"},
				      {"spectral3","#fc8d59,#ffffbf,#99d594"},
				      {"spectral4","#d7191c,#fdae61,#abdda4,#2b83ba"},
				      {"spectral5","#d7191c,#fdae61,#ffffbf,#abdda4,#2b83ba"},
				      {"spectral6","#d53e4f,#fc8d59,#fee08b,#e6f598,#99d594,#3288bd"},
				      {"spectral7","#d53e4f,#fc8d59,#fee08b,#ffffbf,#e6f598,#99d594,#3288bd"},
				      {"spectral8","#d53e4f,#f46d43,#fdae61,#fee08b,#e6f598,#abdda4,#66c2a5,#3288bd"},
				      {"spectral9","#d53e4f,#f46d43,#fdae61,#fee08b,#ffffbf,#e6f598,#abdda4,#66c2a5,#3288bd"},
				      {"ylgn3","#f7fcb9,#addd8e,#31a354"},
				      {"ylgn4","#ffffcc,#c2e699,#78c679,#238443"},
				      {"ylgn5","#ffffcc,#c2e699,#78c679,#31a354,#006837"},
				      {"ylgn6","#ffffcc,#d9f0a3,#addd8e,#78c679,#31a354,#006837"},
				      {"ylgn7","#ffffcc,#d9f0a3,#addd8e,#78c679,#41ab5d,#238443,#005a32"},
				      {"ylgn8","#ffffe5,#f7fcb9,#d9f0a3,#addd8e,#78c679,#41ab5d,#238443,#005a32"},
				      {"ylgn9","#ffffe5,#f7fcb9,#d9f0a3,#addd8e,#78c679,#41ab5d,#238443,#006837,#004529"},
				      {"ylgnbu3","#edf8b1,#7fcdbb,#2c7fb8"},
				      {"ylgnbu4","#ffffcc,#a1dab4,#41b6c4,#225ea8"},
				      {"ylgnbu5","#ffffcc,#a1dab4,#41b6c4,#2c7fb8,#253494"},
				      {"ylgnbu6","#ffffcc,#c7e9b4,#7fcdbb,#41b6c4,#2c7fb8,#253494"},
				      {"ylgnbu7","#ffffcc,#c7e9b4,#7fcdbb,#41b6c4,#1d91c0,#225ea8,#0c2c84"},
				      {"ylgnbu8","#ffffd9,#edf8b1,#c7e9b4,#7fcdbb,#41b6c4,#1d91c0,#225ea8,#0c2c84"},
				      {"ylgnbu9","#ffffd9,#edf8b1,#c7e9b4,#7fcdbb,#41b6c4,#1d91c0,#225ea8,#253494,#081d58"},
				      {"ylorbr3","#fff7bc,#fec44f,#d95f0e"},
				      {"ylorbr4","#ffffd4,#fed98e,#fe9929,#cc4c02"},
				      {"ylorbr5","#ffffd4,#fed98e,#fe9929,#d95f0e,#993404"},
				      {"ylorbr6","#ffffd4,#fee391,#fec44f,#fe9929,#d95f0e,#993404"},
				      {"ylorbr7","#ffffd4,#fee391,#fec44f,#fe9929,#ec7014,#cc4c02,#8c2d04"},
				      {"ylorbr8","#ffffe5,#fff7bc,#fee391,#fec44f,#fe9929,#ec7014,#cc4c02,#8c2d04"},
				      {"ylorbr9","#ffffe5,#fff7bc,#fee391,#fec44f,#fe9929,#ec7014,#cc4c02,#993404,#662506"},
				      {"ylorrd3","#ffeda0,#feb24c,#f03b20"},
				      {"ylorrd4","#ffffb2,#fecc5c,#fd8d3c,#e31a1c"},
				      {"ylorrd5","#ffffb2,#fecc5c,#fd8d3c,#f03b20,#bd0026"},
				      {"ylorrd6","#ffffb2,#fed976,#feb24c,#fd8d3c,#f03b20,#bd0026"},
				      {"ylorrd7","#ffffb2,#fed976,#feb24c,#fd8d3c,#fc4e2a,#e31a1c,#b10026"},
				      {"ylorrd8","#ffffcc,#ffeda0,#fed976,#feb24c,#fd8d3c,#fc4e2a,#e31a1c,#b10026"},
				      {"ylorrd9","#ffffcc,#ffeda0,#fed976,#feb24c,#fd8d3c,#fc4e2a,#e31a1c,#bd0026,#800026"}};



float palette_pastel[1001][3] = {{0.984313725490196f, 0.7058823529411764f, 0.6823529411764706f}, 
				 {0.9831843137254901f, 0.7062745098039215f, 0.6831843137254903f}, 
				 {0.9820549019607843f, 0.7066666666666666f, 0.6840156862745098f}, 
				 {0.9809254901960783f, 0.7070588235294117f, 0.6848470588235295f}, 
				 {0.9797960784313725f, 0.7074509803921568f, 0.685678431372549f}, 
				 {0.9786666666666666f, 0.7078431372549019f, 0.6865098039215687f}, 
				 {0.9775372549019608f, 0.708235294117647f, 0.6873411764705882f}, 
				 {0.9764078431372548f, 0.7086274509803921f, 0.6881725490196079f}, 
				 {0.975278431372549f, 0.7090196078431372f, 0.6890039215686274f}, 
				 {0.9741490196078431f, 0.7094117647058823f, 0.6898352941176471f}, 
				 {0.9730196078431372f, 0.7098039215686274f, 0.6906666666666667f}, 
				 {0.9718901960784313f, 0.7101960784313724f, 0.6914980392156863f}, 
				 {0.9707607843137255f, 0.7105882352941176f, 0.6923294117647059f}, 
				 {0.9696313725490195f, 0.7109803921568627f, 0.6931607843137255f}, 
				 {0.9685019607843137f, 0.7113725490196078f, 0.6939921568627451f}, 
				 {0.9673725490196078f, 0.7117647058823529f, 0.6948235294117647f}, 
				 {0.9662431372549019f, 0.7121568627450979f, 0.6956549019607843f}, 
				 {0.965113725490196f, 0.7125490196078431f, 0.6964862745098039f}, 
				 {0.9639843137254901f, 0.7129411764705882f, 0.6973176470588236f}, 
				 {0.9628549019607843f, 0.7133333333333333f, 0.6981490196078431f}, 
				 {0.9617254901960783f, 0.7137254901960783f, 0.6989803921568628f}, 
				 {0.9605960784313725f, 0.7141176470588235f, 0.6998117647058824f}, 
				 {0.9594666666666666f, 0.7145098039215686f, 0.700643137254902f}, 
				 {0.9583372549019608f, 0.7149019607843137f, 0.7014745098039216f}, 
				 {0.9572078431372548f, 0.7152941176470587f, 0.7023058823529412f}, 
				 {0.956078431372549f, 0.7156862745098038f, 0.7031372549019608f}, 
				 {0.9549490196078431f, 0.716078431372549f, 0.7039686274509804f}, 
				 {0.9538196078431372f, 0.7164705882352941f, 0.7048f}, 
				 {0.9526901960784313f, 0.7168627450980392f, 0.7056313725490196f}, 
				 {0.9515607843137255f, 0.7172549019607842f, 0.7064627450980392f}, 
				 {0.9504313725490195f, 0.7176470588235293f, 0.7072941176470589f}, 
				 {0.9493019607843136f, 0.7180392156862745f, 0.7081254901960784f}, 
				 {0.9481725490196078f, 0.7184313725490196f, 0.7089568627450981f}, 
				 {0.9470431372549019f, 0.7188235294117646f, 0.7097882352941176f}, 
				 {0.945913725490196f, 0.7192156862745097f, 0.7106196078431373f}, 
				 {0.9447843137254901f, 0.7196078431372549f, 0.7114509803921569f}, 
				 {0.9436549019607843f, 0.72f, 0.7122823529411765f}, 
				 {0.9425254901960783f, 0.720392156862745f, 0.7131137254901961f}, 
				 {0.9413960784313725f, 0.7207843137254901f, 0.7139450980392157f}, 
				 {0.9402666666666666f, 0.7211764705882352f, 0.7147764705882353f}, 
				 {0.9391372549019608f, 0.7215686274509804f, 0.7156078431372549f}, 
				 {0.9380078431372548f, 0.7219607843137255f, 0.7164392156862746f}, 
				 {0.936878431372549f, 0.7223529411764705f, 0.7172705882352941f}, 
				 {0.9357490196078431f, 0.7227450980392156f, 0.7181019607843138f}, 
				 {0.9346196078431372f, 0.7231372549019608f, 0.7189333333333333f}, 
				 {0.9334901960784313f, 0.7235294117647059f, 0.719764705882353f}, 
				 {0.9323607843137255f, 0.7239215686274509f, 0.7205960784313725f}, 
				 {0.9312313725490196f, 0.724313725490196f, 0.7214274509803922f}, 
				 {0.9301019607843136f, 0.7247058823529411f, 0.7222588235294117f}, 
				 {0.9289725490196078f, 0.7250980392156863f, 0.7230901960784314f}, 
				 {0.9278431372549019f, 0.7254901960784313f, 0.7239215686274509f}, 
				 {0.926713725490196f, 0.7258823529411764f, 0.7247529411764706f}, 
				 {0.9255843137254901f, 0.7262745098039215f, 0.7255843137254903f}, 
				 {0.9244549019607843f, 0.7266666666666666f, 0.7264156862745098f}, 
				 {0.9233254901960783f, 0.7270588235294118f, 0.7272470588235294f}, 
				 {0.9221960784313725f, 0.7274509803921568f, 0.728078431372549f}, 
				 {0.9210666666666666f, 0.7278431372549019f, 0.7289098039215687f}, 
				 {0.9199372549019608f, 0.728235294117647f, 0.7297411764705882f}, 
				 {0.9188078431372548f, 0.7286274509803922f, 0.7305725490196079f}, 
				 {0.917678431372549f, 0.7290196078431372f, 0.7314039215686274f}, 
				 {0.9165490196078431f, 0.7294117647058823f, 0.7322352941176471f}, 
				 {0.9154196078431371f, 0.7298039215686274f, 0.7330666666666666f}, 
				 {0.9142901960784313f, 0.7301960784313725f, 0.7338980392156863f}, 
				 {0.9131607843137255f, 0.7305882352941176f, 0.7347294117647059f}, 
				 {0.9120313725490196f, 0.7309803921568627f, 0.7355607843137255f}, 
				 {0.9109019607843136f, 0.7313725490196078f, 0.7363921568627451f}, 
				 {0.9097725490196078f, 0.7317647058823529f, 0.7372235294117647f}, 
				 {0.9086431372549019f, 0.7321568627450981f, 0.7380549019607843f}, 
				 {0.907513725490196f, 0.7325490196078431f, 0.7388862745098039f}, 
				 {0.9063843137254901f, 0.7329411764705882f, 0.7397176470588236f}, 
				 {0.9052549019607843f, 0.7333333333333333f, 0.7405490196078431f}, 
				 {0.9041254901960784f, 0.7337254901960784f, 0.7413803921568628f}, 
				 {0.9029960784313725f, 0.7341176470588235f, 0.7422117647058823f}, 
				 {0.9018666666666666f, 0.7345098039215686f, 0.743043137254902f}, 
				 {0.9007372549019608f, 0.7349019607843137f, 0.7438745098039216f}, 
				 {0.8996078431372548f, 0.7352941176470588f, 0.7447058823529412f}, 
				 {0.898478431372549f, 0.7356862745098038f, 0.7455372549019608f}, 
				 {0.8973490196078431f, 0.736078431372549f, 0.7463686274509804f}, 
				 {0.8962196078431373f, 0.7364705882352941f, 0.7472f}, 
				 {0.8950901960784313f, 0.7368627450980392f, 0.7480313725490196f}, 
				 {0.8939607843137254f, 0.7372549019607842f, 0.7488627450980392f}, 
				 {0.8928313725490196f, 0.7376470588235293f, 0.7496941176470588f}, 
				 {0.8917019607843136f, 0.7380392156862745f, 0.7505254901960784f}, 
				 {0.8905725490196078f, 0.7384313725490196f, 0.751356862745098f}, 
				 {0.8894431372549019f, 0.7388235294117647f, 0.7521882352941176f}, 
				 {0.888313725490196f, 0.7392156862745097f, 0.7530196078431373f}, 
				 {0.8871843137254901f, 0.7396078431372549f, 0.7538509803921569f}, 
				 {0.8860549019607843f, 0.74f, 0.7546823529411765f}, 
				 {0.8849254901960784f, 0.7403921568627451f, 0.755513725490196f}, 
				 {0.8837960784313725f, 0.7407843137254901f, 0.7563450980392157f}, 
				 {0.8826666666666666f, 0.7411764705882352f, 0.7571764705882353f}, 
				 {0.8815372549019608f, 0.7415686274509804f, 0.7580078431372549f}, 
				 {0.8804078431372548f, 0.7419607843137255f, 0.7588392156862745f}, 
				 {0.879278431372549f, 0.7423529411764705f, 0.7596705882352941f}, 
				 {0.8781490196078431f, 0.7427450980392156f, 0.7605019607843138f}, 
				 {0.8770196078431372f, 0.7431372549019608f, 0.7613333333333333f}, 
				 {0.8758901960784313f, 0.7435294117647059f, 0.762164705882353f}, 
				 {0.8747607843137254f, 0.743921568627451f, 0.7629960784313725f}, 
				 {0.8736313725490196f, 0.744313725490196f, 0.7638274509803922f}, 
				 {0.8725019607843136f, 0.7447058823529411f, 0.7646588235294117f}, 
				 {0.8713725490196078f, 0.7450980392156863f, 0.7654901960784314f}, 
				 {0.8702431372549019f, 0.7454901960784314f, 0.7663215686274509f}, 
				 {0.869113725490196f, 0.7458823529411764f, 0.7671529411764706f}, 
				 {0.8679843137254901f, 0.7462745098039215f, 0.7679843137254903f}, 
				 {0.8668549019607843f, 0.7466666666666666f, 0.7688156862745098f}, 
				 {0.8657254901960784f, 0.7470588235294118f, 0.7696470588235294f}, 
				 {0.8645960784313725f, 0.7474509803921568f, 0.770478431372549f}, 
				 {0.8634666666666666f, 0.7478431372549019f, 0.7713098039215687f}, 
				 {0.8623372549019608f, 0.748235294117647f, 0.7721411764705882f}, 
				 {0.8612078431372548f, 0.7486274509803922f, 0.7729725490196078f}, 
				 {0.8600784313725489f, 0.7490196078431373f, 0.7738039215686274f}, 
				 {0.8589490196078431f, 0.7494117647058823f, 0.7746352941176471f}, 
				 {0.8578196078431373f, 0.7498039215686274f, 0.7754666666666666f}, 
				 {0.8566901960784313f, 0.7501960784313725f, 0.7762980392156863f}, 
				 {0.8555607843137254f, 0.7505882352941177f, 0.7771294117647058f}, 
				 {0.8544313725490196f, 0.7509803921568627f, 0.7779607843137255f}, 
				 {0.8533019607843136f, 0.7513725490196078f, 0.778792156862745f}, 
				 {0.8521725490196078f, 0.7517647058823529f, 0.7796235294117647f}, 
				 {0.8510431372549019f, 0.7521568627450981f, 0.7804549019607843f}, 
				 {0.8499137254901961f, 0.7525490196078432f, 0.7812862745098039f}, 
				 {0.8487843137254901f, 0.7529411764705882f, 0.7821176470588235f}, 
				 {0.8476549019607843f, 0.7533333333333333f, 0.7829490196078431f}, 
				 {0.8465254901960784f, 0.7537254901960784f, 0.7837803921568627f}, 
				 {0.8453960784313725f, 0.7541176470588236f, 0.7846117647058823f}, 
				 {0.8442666666666666f, 0.7545098039215686f, 0.785443137254902f}, 
				 {0.8431372549019607f, 0.7549019607843137f, 0.7862745098039216f}, 
				 {0.8420078431372549f, 0.7552941176470588f, 0.7871058823529411f}, 
				 {0.840878431372549f, 0.7556862745098039f, 0.7879372549019608f}, 
				 {0.8397490196078431f, 0.756078431372549f, 0.7887686274509804f}, 
				 {0.8386196078431372f, 0.7564705882352941f, 0.7896f}, 
				 {0.8374901960784313f, 0.7568627450980392f, 0.7904313725490196f}, 
				 {0.8363607843137254f, 0.7572549019607843f, 0.7912627450980392f}, 
				 {0.8352313725490196f, 0.7576470588235295f, 0.7920941176470588f}, 
				 {0.8341019607843136f, 0.7580392156862745f, 0.7929254901960784f}, 
				 {0.8329725490196078f, 0.7584313725490196f, 0.793756862745098f}, 
				 {0.8318431372549019f, 0.7588235294117647f, 0.7945882352941176f}, 
				 {0.830713725490196f, 0.7592156862745097f, 0.7954196078431373f}, 
				 {0.8295843137254901f, 0.7596078431372549f, 0.7962509803921568f}, 
				 {0.8284549019607843f, 0.76f, 0.7970823529411765f}, 
				 {0.8273254901960784f, 0.7603921568627451f, 0.797913725490196f}, 
				 {0.8261960784313724f, 0.7607843137254902f, 0.7987450980392157f}, 
				 {0.8250666666666666f, 0.7611764705882353f, 0.7995764705882353f}, 
				 {0.8239372549019607f, 0.7615686274509804f, 0.8004078431372549f}, 
				 {0.8228078431372549f, 0.7619607843137255f, 0.8012392156862745f}, 
				 {0.8216784313725489f, 0.7623529411764706f, 0.8020705882352941f}, 
				 {0.8205490196078431f, 0.7627450980392156f, 0.8029019607843138f}, 
				 {0.8194196078431373f, 0.7631372549019608f, 0.8037333333333333f}, 
				 {0.8182901960784313f, 0.7635294117647059f, 0.8045647058823528f}, 
				 {0.8171607843137254f, 0.763921568627451f, 0.8053960784313725f}, 
				 {0.8160313725490196f, 0.764313725490196f, 0.8062274509803922f}, 
				 {0.8149019607843137f, 0.7647058823529411f, 0.8070588235294117f}, 
				 {0.8137725490196078f, 0.7650980392156863f, 0.8078901960784314f}, 
				 {0.8126431372549019f, 0.7654901960784314f, 0.8087215686274509f}, 
				 {0.8115137254901961f, 0.7658823529411765f, 0.8095529411764706f}, 
				 {0.8103843137254901f, 0.7662745098039215f, 0.8103843137254901f}, 
				 {0.8092549019607842f, 0.7666666666666666f, 0.8112156862745098f}, 
				 {0.8081254901960784f, 0.7670588235294118f, 0.8120470588235293f}, 
				 {0.8069960784313726f, 0.7674509803921569f, 0.812878431372549f}, 
				 {0.8058666666666666f, 0.7678431372549019f, 0.8137098039215687f}, 
				 {0.8047372549019607f, 0.768235294117647f, 0.8145411764705882f}, 
				 {0.8036078431372549f, 0.7686274509803922f, 0.8153725490196078f}, 
				 {0.8024784313725489f, 0.7690196078431373f, 0.8162039215686274f}, 
				 {0.8013490196078431f, 0.7694117647058824f, 0.8170352941176471f}, 
				 {0.8002196078431372f, 0.7698039215686274f, 0.8178666666666666f}, 
				 {0.7990901960784313f, 0.7701960784313726f, 0.8186980392156863f}, 
				 {0.7979607843137254f, 0.7705882352941177f, 0.8195294117647058f}, 
				 {0.7968313725490195f, 0.7709803921568628f, 0.8203607843137255f}, 
				 {0.7957019607843137f, 0.7713725490196078f, 0.821192156862745f}, 
				 {0.7945725490196078f, 0.7717647058823529f, 0.8220235294117647f}, 
				 {0.7934431372549019f, 0.7721568627450981f, 0.8228549019607843f}, 
				 {0.792313725490196f, 0.7725490196078432f, 0.8236862745098039f}, 
				 {0.7911843137254901f, 0.7729411764705882f, 0.8245176470588236f}, 
				 {0.7900549019607842f, 0.7733333333333333f, 0.8253490196078431f}, 
				 {0.7889254901960784f, 0.7737254901960784f, 0.8261803921568627f}, 
				 {0.7877960784313724f, 0.7741176470588236f, 0.8270117647058823f}, 
				 {0.7866666666666666f, 0.7745098039215687f, 0.827843137254902f}, 
				 {0.7855372549019608f, 0.7749019607843137f, 0.8286745098039215f}, 
				 {0.7844078431372549f, 0.7752941176470588f, 0.8295058823529411f}, 
				 {0.7832784313725489f, 0.7756862745098039f, 0.8303372549019608f}, 
				 {0.7821490196078431f, 0.7760784313725491f, 0.8311686274509804f}, 
				 {0.7810196078431372f, 0.7764705882352941f, 0.832f}, 
				 {0.7798901960784314f, 0.7768627450980392f, 0.8328313725490195f}, 
				 {0.7787607843137254f, 0.7772549019607843f, 0.8336627450980392f}, 
				 {0.7776313725490196f, 0.7776470588235294f, 0.8344941176470588f}, 
				 {0.7765019607843137f, 0.7780392156862745f, 0.8353254901960784f}, 
				 {0.7753725490196077f, 0.7784313725490196f, 0.836156862745098f}, 
				 {0.7742431372549019f, 0.7788235294117647f, 0.8369882352941176f}, 
				 {0.7731137254901961f, 0.7792156862745098f, 0.8378196078431372f}, 
				 {0.7719843137254901f, 0.779607843137255f, 0.8386509803921568f}, 
				 {0.7708549019607842f, 0.78f, 0.8394823529411765f}, 
				 {0.7697254901960784f, 0.7803921568627451f, 0.840313725490196f}, 
				 {0.7685960784313725f, 0.7807843137254902f, 0.8411450980392157f}, 
				 {0.7674666666666666f, 0.7811764705882354f, 0.8419764705882353f}, 
				 {0.7663372549019607f, 0.7815686274509804f, 0.8428078431372549f}, 
				 {0.7652078431372549f, 0.7819607843137255f, 0.8436392156862744f}, 
				 {0.7640784313725489f, 0.7823529411764706f, 0.8444705882352941f}, 
				 {0.7629490196078431f, 0.7827450980392157f, 0.8453019607843137f}, 
				 {0.7618196078431372f, 0.7831372549019608f, 0.8461333333333333f}, 
				 {0.7606901960784314f, 0.7835294117647059f, 0.8469647058823528f}, 
				 {0.7595607843137254f, 0.783921568627451f, 0.8477960784313725f}, 
				 {0.7584313725490195f, 0.7843137254901961f, 0.8486274509803922f}, 
				 {0.7573019607843137f, 0.7847058823529411f, 0.8494588235294117f}, 
				 {0.7561725490196078f, 0.7850980392156863f, 0.8502901960784314f}, 
				 {0.7550431372549019f, 0.7854901960784314f, 0.8511215686274509f}, 
				 {0.753913725490196f, 0.7858823529411765f, 0.8519529411764706f}, 
				 {0.7527843137254902f, 0.7862745098039216f, 0.8527843137254901f}, 
				 {0.7516549019607842f, 0.7866666666666666f, 0.8536156862745098f}, 
				 {0.7505254901960784f, 0.7870588235294118f, 0.8544470588235293f}, 
				 {0.7493960784313725f, 0.7874509803921569f, 0.855278431372549f}, 
				 {0.7482666666666666f, 0.787843137254902f, 0.8561098039215685f}, 
				 {0.7471372549019607f, 0.788235294117647f, 0.8569411764705882f}, 
				 {0.7460078431372549f, 0.7886274509803921f, 0.8577725490196078f}, 
				 {0.7448784313725489f, 0.7890196078431373f, 0.8586039215686274f}, 
				 {0.7437490196078431f, 0.7894117647058824f, 0.8594352941176471f}, 
				 {0.7426196078431372f, 0.7898039215686274f, 0.8602666666666666f}, 
				 {0.7414901960784314f, 0.7901960784313725f, 0.8610980392156862f}, 
				 {0.7403607843137254f, 0.7905882352941177f, 0.8619294117647058f}, 
				 {0.7392313725490196f, 0.7909803921568628f, 0.8627607843137255f}, 
				 {0.7381019607843137f, 0.7913725490196079f, 0.863592156862745f}, 
				 {0.7369725490196077f, 0.7917647058823529f, 0.8644235294117647f}, 
				 {0.7358431372549019f, 0.7921568627450981f, 0.8652549019607843f}, 
				 {0.7347137254901961f, 0.7925490196078432f, 0.8660862745098039f}, 
				 {0.7335843137254902f, 0.7929411764705883f, 0.8669176470588235f}, 
				 {0.7324549019607842f, 0.7933333333333333f, 0.8677490196078431f}, 
				 {0.7313254901960784f, 0.7937254901960784f, 0.8685803921568627f}, 
				 {0.7301960784313725f, 0.7941176470588236f, 0.8694117647058823f}, 
				 {0.7290666666666665f, 0.7945098039215687f, 0.870243137254902f}, 
				 {0.7279372549019607f, 0.7949019607843137f, 0.8710745098039215f}, 
				 {0.7268078431372549f, 0.7952941176470588f, 0.8719058823529411f}, 
				 {0.725678431372549f, 0.7956862745098039f, 0.8727372549019607f}, 
				 {0.724549019607843f, 0.7960784313725491f, 0.8735686274509804f}, 
				 {0.7234196078431372f, 0.7964705882352942f, 0.8744f}, 
				 {0.7222901960784314f, 0.7968627450980392f, 0.8752313725490195f}, 
				 {0.7211607843137254f, 0.7972549019607843f, 0.8760627450980392f}, 
				 {0.7200313725490195f, 0.7976470588235295f, 0.8768941176470588f}, 
				 {0.7189019607843137f, 0.7980392156862746f, 0.8777254901960784f}, 
				 {0.7177725490196079f, 0.7984313725490196f, 0.878556862745098f}, 
				 {0.7166431372549019f, 0.7988235294117647f, 0.8793882352941176f}, 
				 {0.715513725490196f, 0.7992156862745099f, 0.8802196078431372f}, 
				 {0.7143843137254902f, 0.799607843137255f, 0.8810509803921568f}, 
				 {0.7132549019607843f, 0.8f, 0.8818823529411765f}, 
				 {0.7121254901960784f, 0.8003921568627451f, 0.882713725490196f}, 
				 {0.7109960784313725f, 0.8007843137254902f, 0.8835450980392157f}, 
				 {0.7098666666666666f, 0.8011764705882354f, 0.8843764705882352f}, 
				 {0.7087372549019607f, 0.8015686274509805f, 0.8852078431372549f}, 
				 {0.7076078431372548f, 0.8019607843137255f, 0.8860392156862744f}, 
				 {0.706478431372549f, 0.8023529411764706f, 0.8868705882352941f}, 
				 {0.7053490196078431f, 0.8027450980392157f, 0.8877019607843137f}, 
				 {0.7042196078431372f, 0.8031372549019609f, 0.8885333333333333f}, 
				 {0.7030901960784313f, 0.8035294117647059f, 0.8893647058823528f}, 
				 {0.7019607843137254f, 0.803921568627451f, 0.8901960784313725f}, 
				 {0.7023529411764705f, 0.8043921568627451f, 0.8897254901960784f}, 
				 {0.7027450980392156f, 0.8048627450980392f, 0.8892549019607843f}, 
				 {0.7031372549019608f, 0.8053333333333333f, 0.8887843137254902f}, 
				 {0.7035294117647058f, 0.8058039215686275f, 0.888313725490196f}, 
				 {0.7039215686274509f, 0.8062745098039216f, 0.8878431372549019f}, 
				 {0.704313725490196f, 0.8067450980392157f, 0.8873725490196078f}, 
				 {0.7047058823529412f, 0.8072156862745098f, 0.8869019607843137f}, 
				 {0.7050980392156863f, 0.8076862745098039f, 0.8864313725490196f}, 
				 {0.7054901960784313f, 0.8081568627450981f, 0.8859607843137254f}, 
				 {0.7058823529411764f, 0.8086274509803922f, 0.8854901960784313f}, 
				 {0.7062745098039215f, 0.8090980392156863f, 0.8850196078431372f}, 
				 {0.7066666666666667f, 0.8095686274509805f, 0.884549019607843f}, 
				 {0.7070588235294117f, 0.8100392156862746f, 0.8840784313725489f}, 
				 {0.7074509803921568f, 0.8105098039215687f, 0.8836078431372548f}, 
				 {0.7078431372549019f, 0.8109803921568628f, 0.8831372549019607f}, 
				 {0.7082352941176471f, 0.8114509803921569f, 0.8826666666666666f}, 
				 {0.7086274509803921f, 0.811921568627451f, 0.8821960784313725f}, 
				 {0.7090196078431372f, 0.8123921568627451f, 0.8817254901960784f}, 
				 {0.7094117647058823f, 0.8128627450980392f, 0.8812549019607843f}, 
				 {0.7098039215686274f, 0.8133333333333334f, 0.8807843137254902f}, 
				 {0.7101960784313726f, 0.8138039215686275f, 0.880313725490196f}, 
				 {0.7105882352941176f, 0.8142745098039216f, 0.8798431372549019f}, 
				 {0.7109803921568627f, 0.8147450980392157f, 0.8793725490196078f}, 
				 {0.7113725490196078f, 0.8152156862745098f, 0.8789019607843137f}, 
				 {0.7117647058823529f, 0.8156862745098039f, 0.8784313725490196f}, 
				 {0.712156862745098f, 0.816156862745098f, 0.8779607843137255f}, 
				 {0.7125490196078431f, 0.8166274509803921f, 0.8774901960784314f}, 
				 {0.7129411764705882f, 0.8170980392156864f, 0.8770196078431372f}, 
				 {0.7133333333333333f, 0.8175686274509805f, 0.876549019607843f}, 
				 {0.7137254901960784f, 0.8180392156862746f, 0.8760784313725489f}, 
				 {0.7141176470588235f, 0.8185098039215687f, 0.8756078431372548f}, 
				 {0.7145098039215686f, 0.8189803921568628f, 0.8751372549019607f}, 
				 {0.7149019607843137f, 0.8194509803921569f, 0.8746666666666666f}, 
				 {0.7152941176470587f, 0.819921568627451f, 0.8741960784313725f}, 
				 {0.7156862745098039f, 0.8203921568627451f, 0.8737254901960784f}, 
				 {0.716078431372549f, 0.8208627450980392f, 0.8732549019607843f}, 
				 {0.7164705882352941f, 0.8213333333333334f, 0.8727843137254901f}, 
				 {0.7168627450980392f, 0.8218039215686275f, 0.872313725490196f}, 
				 {0.7172549019607842f, 0.8222745098039216f, 0.8718431372549019f}, 
				 {0.7176470588235294f, 0.8227450980392157f, 0.8713725490196078f}, 
				 {0.7180392156862745f, 0.8232156862745098f, 0.8709019607843137f}, 
				 {0.7184313725490196f, 0.8236862745098039f, 0.8704313725490196f}, 
				 {0.7188235294117646f, 0.824156862745098f, 0.8699607843137255f}, 
				 {0.7192156862745097f, 0.8246274509803921f, 0.8694901960784314f}, 
				 {0.7196078431372549f, 0.8250980392156863f, 0.8690196078431373f}, 
				 {0.72f, 0.8255686274509804f, 0.8685490196078431f}, 
				 {0.720392156862745f, 0.8260392156862745f, 0.868078431372549f}, 
				 {0.7207843137254901f, 0.8265098039215686f, 0.8676078431372549f}, 
				 {0.7211764705882353f, 0.8269803921568628f, 0.8671372549019607f}, 
				 {0.7215686274509804f, 0.8274509803921569f, 0.8666666666666666f}, 
				 {0.7219607843137255f, 0.827921568627451f, 0.8661960784313725f}, 
				 {0.7223529411764705f, 0.8283921568627451f, 0.8657254901960784f}, 
				 {0.7227450980392156f, 0.8288627450980393f, 0.8652549019607843f}, 
				 {0.7231372549019608f, 0.8293333333333334f, 0.8647843137254901f}, 
				 {0.7235294117647059f, 0.8298039215686275f, 0.864313725490196f}, 
				 {0.7239215686274509f, 0.8302745098039216f, 0.8638431372549019f}, 
				 {0.724313725490196f, 0.8307450980392157f, 0.8633725490196078f}, 
				 {0.7247058823529411f, 0.8312156862745098f, 0.8629019607843137f}, 
				 {0.7250980392156863f, 0.8316862745098039f, 0.8624313725490196f}, 
				 {0.7254901960784313f, 0.832156862745098f, 0.8619607843137255f}, 
				 {0.7258823529411764f, 0.8326274509803921f, 0.8614901960784314f}, 
				 {0.7262745098039215f, 0.8330980392156863f, 0.8610196078431372f}, 
				 {0.7266666666666667f, 0.8335686274509804f, 0.8605490196078431f}, 
				 {0.7270588235294118f, 0.8340392156862745f, 0.860078431372549f}, 
				 {0.7274509803921568f, 0.8345098039215686f, 0.8596078431372549f}, 
				 {0.7278431372549019f, 0.8349803921568627f, 0.8591372549019608f}, 
				 {0.7282352941176471f, 0.8354509803921568f, 0.8586666666666667f}, 
				 {0.7286274509803922f, 0.835921568627451f, 0.8581960784313725f}, 
				 {0.7290196078431372f, 0.8363921568627452f, 0.8577254901960784f}, 
				 {0.7294117647058823f, 0.8368627450980393f, 0.8572549019607842f}, 
				 {0.7298039215686274f, 0.8373333333333334f, 0.8567843137254901f}, 
				 {0.7301960784313726f, 0.8378039215686275f, 0.856313725490196f}, 
				 {0.7305882352941176f, 0.8382745098039216f, 0.8558431372549019f}, 
				 {0.7309803921568627f, 0.8387450980392157f, 0.8553725490196078f}, 
				 {0.7313725490196078f, 0.8392156862745098f, 0.8549019607843137f}, 
				 {0.7317647058823529f, 0.8396862745098039f, 0.8544313725490196f}, 
				 {0.7321568627450981f, 0.840156862745098f, 0.8539607843137255f}, 
				 {0.7325490196078431f, 0.8406274509803922f, 0.8534901960784314f}, 
				 {0.7329411764705882f, 0.8410980392156863f, 0.8530196078431372f}, 
				 {0.7333333333333333f, 0.8415686274509804f, 0.8525490196078431f}, 
				 {0.7337254901960785f, 0.8420392156862745f, 0.852078431372549f}, 
				 {0.7341176470588235f, 0.8425098039215686f, 0.8516078431372549f}, 
				 {0.7345098039215686f, 0.8429803921568627f, 0.8511372549019608f}, 
				 {0.7349019607843137f, 0.8434509803921568f, 0.8506666666666667f}, 
				 {0.7352941176470588f, 0.843921568627451f, 0.8501960784313725f}, 
				 {0.735686274509804f, 0.8443921568627452f, 0.8497254901960783f}, 
				 {0.736078431372549f, 0.8448627450980393f, 0.8492549019607842f}, 
				 {0.7364705882352941f, 0.8453333333333334f, 0.8487843137254901f}, 
				 {0.7368627450980392f, 0.8458039215686275f, 0.848313725490196f}, 
				 {0.7372549019607844f, 0.8462745098039216f, 0.8478431372549019f}, 
				 {0.7376470588235294f, 0.8467450980392157f, 0.8473725490196078f}, 
				 {0.7380392156862745f, 0.8472156862745098f, 0.8469019607843137f}, 
				 {0.7384313725490196f, 0.8476862745098039f, 0.8464313725490196f}, 
				 {0.7388235294117647f, 0.848156862745098f, 0.8459607843137255f}, 
				 {0.7392156862745098f, 0.8486274509803922f, 0.8454901960784313f}, 
				 {0.7396078431372549f, 0.8490980392156863f, 0.8450196078431372f}, 
				 {0.74f, 0.8495686274509804f, 0.8445490196078431f}, 
				 {0.7403921568627451f, 0.8500392156862745f, 0.844078431372549f}, 
				 {0.7407843137254901f, 0.8505098039215686f, 0.8436078431372549f}, 
				 {0.7411764705882353f, 0.8509803921568627f, 0.8431372549019608f}, 
				 {0.7415686274509804f, 0.8514509803921568f, 0.8426666666666667f}, 
				 {0.7419607843137255f, 0.8519215686274509f, 0.8421960784313726f}, 
				 {0.7423529411764705f, 0.852392156862745f, 0.8417254901960785f}, 
				 {0.7427450980392156f, 0.8528627450980392f, 0.8412549019607843f}, 
				 {0.7431372549019608f, 0.8533333333333333f, 0.8407843137254902f}, 
				 {0.7435294117647059f, 0.8538039215686274f, 0.8403137254901961f}, 
				 {0.743921568627451f, 0.8542745098039215f, 0.839843137254902f}, 
				 {0.744313725490196f, 0.8547450980392157f, 0.8393725490196078f}, 
				 {0.7447058823529411f, 0.8552156862745098f, 0.8389019607843137f}, 
				 {0.7450980392156863f, 0.855686274509804f, 0.8384313725490196f}, 
				 {0.7454901960784314f, 0.8561568627450981f, 0.8379607843137254f}, 
				 {0.7458823529411764f, 0.8566274509803922f, 0.8374901960784313f}, 
				 {0.7462745098039215f, 0.8570980392156863f, 0.8370196078431372f}, 
				 {0.7466666666666667f, 0.8575686274509804f, 0.8365490196078431f}, 
				 {0.7470588235294118f, 0.8580392156862745f, 0.836078431372549f}, 
				 {0.7474509803921568f, 0.8585098039215686f, 0.8356078431372549f}, 
				 {0.7478431372549019f, 0.8589803921568627f, 0.8351372549019608f}, 
				 {0.748235294117647f, 0.8594509803921568f, 0.8346666666666667f}, 
				 {0.7486274509803922f, 0.859921568627451f, 0.8341960784313726f}, 
				 {0.7490196078431373f, 0.8603921568627451f, 0.8337254901960784f}, 
				 {0.7494117647058823f, 0.8608627450980392f, 0.8332549019607843f}, 
				 {0.7498039215686274f, 0.8613333333333333f, 0.8327843137254902f}, 
				 {0.7501960784313726f, 0.8618039215686274f, 0.8323137254901961f}, 
				 {0.7505882352941177f, 0.8622745098039215f, 0.831843137254902f}, 
				 {0.7509803921568627f, 0.8627450980392157f, 0.8313725490196078f}, 
				 {0.7513725490196078f, 0.8632156862745098f, 0.8309019607843137f}, 
				 {0.7517647058823529f, 0.863686274509804f, 0.8304313725490196f}, 
				 {0.7521568627450981f, 0.8641568627450981f, 0.8299607843137254f}, 
				 {0.7525490196078432f, 0.8646274509803922f, 0.8294901960784313f}, 
				 {0.7529411764705882f, 0.8650980392156863f, 0.8290196078431372f}, 
				 {0.7533333333333333f, 0.8655686274509804f, 0.8285490196078431f}, 
				 {0.7537254901960785f, 0.8660392156862745f, 0.828078431372549f}, 
				 {0.7541176470588236f, 0.8665098039215686f, 0.8276078431372549f}, 
				 {0.7545098039215686f, 0.8669803921568627f, 0.8271372549019608f}, 
				 {0.7549019607843137f, 0.8674509803921568f, 0.8266666666666667f}, 
				 {0.7552941176470588f, 0.867921568627451f, 0.8261960784313725f}, 
				 {0.755686274509804f, 0.8683921568627451f, 0.8257254901960784f}, 
				 {0.756078431372549f, 0.8688627450980392f, 0.8252549019607843f}, 
				 {0.7564705882352941f, 0.8693333333333333f, 0.8247843137254902f}, 
				 {0.7568627450980392f, 0.8698039215686274f, 0.8243137254901961f}, 
				 {0.7572549019607844f, 0.8702745098039215f, 0.823843137254902f}, 
				 {0.7576470588235295f, 0.8707450980392157f, 0.8233725490196078f}, 
				 {0.7580392156862745f, 0.8712156862745097f, 0.8229019607843138f}, 
				 {0.7584313725490196f, 0.871686274509804f, 0.8224313725490195f}, 
				 {0.7588235294117647f, 0.8721568627450981f, 0.8219607843137254f}, 
				 {0.7592156862745099f, 0.8726274509803922f, 0.8214901960784313f}, 
				 {0.7596078431372549f, 0.8730980392156863f, 0.8210196078431372f}, 
				 {0.76f, 0.8735686274509804f, 0.8205490196078431f}, 
				 {0.7603921568627451f, 0.8740392156862745f, 0.820078431372549f}, 
				 {0.7607843137254902f, 0.8745098039215686f, 0.8196078431372549f}, 
				 {0.7611764705882353f, 0.8749803921568627f, 0.8191372549019608f}, 
				 {0.7615686274509804f, 0.8754509803921569f, 0.8186666666666667f}, 
				 {0.7619607843137255f, 0.875921568627451f, 0.8181960784313725f}, 
				 {0.7623529411764706f, 0.8763921568627451f, 0.8177254901960784f}, 
				 {0.7627450980392158f, 0.8768627450980392f, 0.8172549019607843f}, 
				 {0.7631372549019608f, 0.8773333333333333f, 0.8167843137254902f}, 
				 {0.7635294117647059f, 0.8778039215686274f, 0.8163137254901961f}, 
				 {0.763921568627451f, 0.8782745098039215f, 0.815843137254902f}, 
				 {0.764313725490196f, 0.8787450980392156f, 0.8153725490196079f}, 
				 {0.7647058823529412f, 0.8792156862745097f, 0.8149019607843138f}, 
				 {0.7650980392156863f, 0.879686274509804f, 0.8144313725490195f}, 
				 {0.7654901960784314f, 0.8801568627450981f, 0.8139607843137254f}, 
				 {0.7658823529411765f, 0.8806274509803922f, 0.8134901960784313f}, 
				 {0.7662745098039216f, 0.8810980392156863f, 0.8130196078431372f}, 
				 {0.7666666666666667f, 0.8815686274509804f, 0.8125490196078431f}, 
				 {0.7670588235294118f, 0.8820392156862745f, 0.812078431372549f}, 
				 {0.7674509803921569f, 0.8825098039215686f, 0.8116078431372549f}, 
				 {0.7678431372549019f, 0.8829803921568627f, 0.8111372549019608f}, 
				 {0.7682352941176471f, 0.8834509803921569f, 0.8106666666666666f}, 
				 {0.7686274509803922f, 0.883921568627451f, 0.8101960784313725f}, 
				 {0.7690196078431373f, 0.8843921568627451f, 0.8097254901960784f}, 
				 {0.7694117647058824f, 0.8848627450980392f, 0.8092549019607843f}, 
				 {0.7698039215686274f, 0.8853333333333333f, 0.8087843137254902f}, 
				 {0.7701960784313726f, 0.8858039215686274f, 0.8083137254901961f}, 
				 {0.7705882352941177f, 0.8862745098039215f, 0.807843137254902f}, 
				 {0.7709803921568628f, 0.8867450980392156f, 0.8073725490196079f}, 
				 {0.7713725490196078f, 0.8872156862745098f, 0.8069019607843138f}, 
				 {0.7717647058823529f, 0.8876862745098039f, 0.8064313725490196f}, 
				 {0.7721568627450981f, 0.888156862745098f, 0.8059607843137255f}, 
				 {0.7725490196078432f, 0.8886274509803921f, 0.8054901960784314f}, 
				 {0.7729411764705882f, 0.8890980392156862f, 0.8050196078431373f}, 
				 {0.7733333333333333f, 0.8895686274509804f, 0.8045490196078431f}, 
				 {0.7737254901960784f, 0.8900392156862744f, 0.8040784313725491f}, 
				 {0.7741176470588236f, 0.8905098039215686f, 0.8036078431372549f}, 
				 {0.7745098039215687f, 0.8909803921568628f, 0.8031372549019608f}, 
				 {0.7749019607843137f, 0.8914509803921569f, 0.8026666666666666f}, 
				 {0.7752941176470588f, 0.891921568627451f, 0.8021960784313725f}, 
				 {0.775686274509804f, 0.8923921568627451f, 0.8017254901960784f}, 
				 {0.7760784313725491f, 0.8928627450980392f, 0.8012549019607843f}, 
				 {0.7764705882352941f, 0.8933333333333333f, 0.8007843137254902f}, 
				 {0.7768627450980392f, 0.8938039215686274f, 0.8003137254901961f}, 
				 {0.7772549019607844f, 0.8942745098039215f, 0.799843137254902f}, 
				 {0.7776470588235295f, 0.8947450980392156f, 0.7993725490196079f}, 
				 {0.7780392156862745f, 0.8952156862745098f, 0.7989019607843137f}, 
				 {0.7784313725490196f, 0.8956862745098039f, 0.7984313725490196f}, 
				 {0.7788235294117647f, 0.896156862745098f, 0.7979607843137255f}, 
				 {0.7792156862745099f, 0.8966274509803921f, 0.7974901960784314f}, 
				 {0.779607843137255f, 0.8970980392156862f, 0.7970196078431373f}, 
				 {0.78f, 0.8975686274509803f, 0.7965490196078432f}, 
				 {0.7803921568627451f, 0.8980392156862744f, 0.7960784313725491f}, 
				 {0.7807843137254902f, 0.8985098039215687f, 0.7956078431372549f}, 
				 {0.7811764705882354f, 0.8989803921568627f, 0.7951372549019609f}, 
				 {0.7815686274509804f, 0.8994509803921569f, 0.7946666666666666f}, 
				 {0.7819607843137255f, 0.899921568627451f, 0.7941960784313725f}, 
				 {0.7823529411764706f, 0.9003921568627451f, 0.7937254901960784f}, 
				 {0.7827450980392157f, 0.9008627450980392f, 0.7932549019607843f}, 
				 {0.7831372549019608f, 0.9013333333333333f, 0.7927843137254902f}, 
				 {0.7835294117647059f, 0.9018039215686274f, 0.7923137254901961f}, 
				 {0.783921568627451f, 0.9022745098039215f, 0.791843137254902f}, 
				 {0.7843137254901961f, 0.9027450980392157f, 0.7913725490196079f}, 
				 {0.7847058823529413f, 0.9032156862745098f, 0.7909019607843137f}, 
				 {0.7850980392156863f, 0.9036862745098039f, 0.7904313725490196f}, 
				 {0.7854901960784314f, 0.904156862745098f, 0.7899607843137255f}, 
				 {0.7858823529411765f, 0.9046274509803921f, 0.7894901960784314f}, 
				 {0.7862745098039217f, 0.9050980392156862f, 0.7890196078431373f}, 
				 {0.7866666666666667f, 0.9055686274509803f, 0.7885490196078432f}, 
				 {0.7870588235294118f, 0.9060392156862744f, 0.7880784313725491f}, 
				 {0.7874509803921569f, 0.9065098039215687f, 0.7876078431372548f}, 
				 {0.787843137254902f, 0.9069803921568627f, 0.7871372549019608f}, 
				 {0.7882352941176471f, 0.9074509803921569f, 0.7866666666666666f}, 
				 {0.7886274509803922f, 0.907921568627451f, 0.7861960784313725f}, 
				 {0.7890196078431373f, 0.9083921568627451f, 0.7857254901960784f}, 
				 {0.7894117647058824f, 0.9088627450980392f, 0.7852549019607843f}, 
				 {0.7898039215686274f, 0.9093333333333333f, 0.7847843137254902f}, 
				 {0.7901960784313726f, 0.9098039215686274f, 0.7843137254901961f}, 
				 {0.7905882352941177f, 0.9102745098039215f, 0.783843137254902f}, 
				 {0.7909803921568628f, 0.9107450980392157f, 0.7833725490196078f}, 
				 {0.7913725490196079f, 0.9112156862745098f, 0.7829019607843137f}, 
				 {0.791764705882353f, 0.9116862745098039f, 0.7824313725490196f}, 
				 {0.7921568627450981f, 0.912156862745098f, 0.7819607843137255f}, 
				 {0.7925490196078432f, 0.9126274509803921f, 0.7814901960784314f}, 
				 {0.7929411764705883f, 0.9130980392156862f, 0.7810196078431373f}, 
				 {0.7933333333333333f, 0.9135686274509803f, 0.7805490196078432f}, 
				 {0.7937254901960784f, 0.9140392156862744f, 0.7800784313725491f}, 
				 {0.7941176470588236f, 0.9145098039215686f, 0.779607843137255f}, 
				 {0.7945098039215687f, 0.9149803921568627f, 0.7791372549019608f}, 
				 {0.7949019607843137f, 0.9154509803921568f, 0.7786666666666667f}, 
				 {0.7952941176470588f, 0.9159215686274509f, 0.7781960784313726f}, 
				 {0.795686274509804f, 0.916392156862745f, 0.7777254901960785f}, 
				 {0.7960784313725491f, 0.9168627450980391f, 0.7772549019607844f}, 
				 {0.7964705882352942f, 0.9173333333333333f, 0.7767843137254902f}, 
				 {0.7968627450980392f, 0.9178039215686273f, 0.7763137254901962f}, 
				 {0.7972549019607844f, 0.9182745098039216f, 0.775843137254902f}, 
				 {0.7976470588235295f, 0.9187450980392157f, 0.7753725490196078f}, 
				 {0.7980392156862746f, 0.9192156862745098f, 0.7749019607843137f}, 
				 {0.7984313725490196f, 0.9196862745098039f, 0.7744313725490196f}, 
				 {0.7988235294117647f, 0.920156862745098f, 0.7739607843137255f}, 
				 {0.7992156862745099f, 0.9206274509803921f, 0.7734901960784314f}, 
				 {0.799607843137255f, 0.9210980392156862f, 0.7730196078431373f}, 
				 {0.8f, 0.9215686274509803f, 0.7725490196078432f}, 
				 {0.8002823529411766f, 0.9210666666666666f, 0.773035294117647f}, 
				 {0.800564705882353f, 0.9205647058823528f, 0.773521568627451f}, 
				 {0.8008470588235295f, 0.9200627450980392f, 0.7740078431372549f}, 
				 {0.801129411764706f, 0.9195607843137255f, 0.7744941176470589f}, 
				 {0.8014117647058824f, 0.9190588235294117f, 0.7749803921568628f}, 
				 {0.8016941176470589f, 0.918556862745098f, 0.7754666666666667f}, 
				 {0.8019764705882353f, 0.9180549019607842f, 0.7759529411764706f}, 
				 {0.8022588235294118f, 0.9175529411764706f, 0.7764392156862745f}, 
				 {0.8025411764705883f, 0.9170509803921568f, 0.7769254901960785f}, 
				 {0.8028235294117647f, 0.9165490196078431f, 0.7774117647058824f}, 
				 {0.8031058823529412f, 0.9160470588235293f, 0.7778980392156863f}, 
				 {0.8033882352941177f, 0.9155450980392156f, 0.7783843137254902f}, 
				 {0.8036705882352941f, 0.9150431372549019f, 0.7788705882352942f}, 
				 {0.8039529411764706f, 0.9145411764705882f, 0.7793568627450981f}, 
				 {0.8042352941176472f, 0.9140392156862744f, 0.779843137254902f}, 
				 {0.8045176470588236f, 0.9135372549019607f, 0.7803294117647059f}, 
				 {0.8048000000000001f, 0.913035294117647f, 0.7808156862745098f}, 
				 {0.8050823529411765f, 0.9125333333333333f, 0.7813019607843138f}, 
				 {0.805364705882353f, 0.9120313725490196f, 0.7817882352941177f}, 
				 {0.8056470588235295f, 0.9115294117647058f, 0.7822745098039215f}, 
				 {0.8059294117647059f, 0.9110274509803921f, 0.7827607843137255f}, 
				 {0.8062117647058824f, 0.9105254901960783f, 0.7832470588235294f}, 
				 {0.8064941176470589f, 0.9100235294117647f, 0.7837333333333334f}, 
				 {0.8067764705882353f, 0.9095215686274509f, 0.7842196078431373f}, 
				 {0.8070588235294118f, 0.9090196078431372f, 0.7847058823529413f}, 
				 {0.8073411764705882f, 0.9085176470588234f, 0.7851921568627451f}, 
				 {0.8076235294117647f, 0.9080156862745097f, 0.785678431372549f}, 
				 {0.8079058823529413f, 0.907513725490196f, 0.786164705882353f}, 
				 {0.8081882352941177f, 0.9070117647058823f, 0.7866509803921569f}, 
				 {0.8084705882352942f, 0.9065098039215685f, 0.7871372549019608f}, 
				 {0.8087529411764707f, 0.9060078431372548f, 0.7876235294117647f}, 
				 {0.8090352941176471f, 0.9055058823529412f, 0.7881098039215687f}, 
				 {0.8093176470588236f, 0.9050039215686274f, 0.7885960784313726f}, 
				 {0.8096000000000001f, 0.9045019607843137f, 0.7890823529411765f}, 
				 {0.8098823529411765f, 0.9039999999999999f, 0.7895686274509804f}, 
				 {0.810164705882353f, 0.9034980392156862f, 0.7900549019607843f}, 
				 {0.8104470588235294f, 0.9029960784313725f, 0.7905411764705883f}, 
				 {0.8107294117647059f, 0.9024941176470588f, 0.7910274509803922f}, 
				 {0.8110117647058824f, 0.901992156862745f, 0.7915137254901962f}, 
				 {0.8112941176470588f, 0.9014901960784313f, 0.792f}, 
				 {0.8115764705882353f, 0.9009882352941175f, 0.7924862745098039f}, 
				 {0.8118588235294119f, 0.9004862745098039f, 0.7929725490196079f}, 
				 {0.8121411764705883f, 0.8999843137254901f, 0.7934588235294118f}, 
				 {0.8124235294117648f, 0.8994823529411764f, 0.7939450980392158f}, 
				 {0.8127058823529413f, 0.8989803921568627f, 0.7944313725490196f}, 
				 {0.8129882352941177f, 0.8984784313725489f, 0.7949176470588235f}, 
				 {0.8132705882352942f, 0.8979764705882353f, 0.7954039215686275f}, 
				 {0.8135529411764706f, 0.8974745098039215f, 0.7958901960784314f}, 
				 {0.8138352941176471f, 0.8969725490196078f, 0.7963764705882354f}, 
				 {0.8141176470588236f, 0.896470588235294f, 0.7968627450980392f}, 
				 {0.8144f, 0.8959686274509803f, 0.7973490196078432f}, 
				 {0.8146823529411765f, 0.8954666666666666f, 0.7978352941176471f}, 
				 {0.814964705882353f, 0.8949647058823529f, 0.798321568627451f}, 
				 {0.8152470588235294f, 0.8944627450980391f, 0.798807843137255f}, 
				 {0.815529411764706f, 0.8939607843137254f, 0.7992941176470588f}, 
				 {0.8158117647058825f, 0.8934588235294116f, 0.7997803921568628f}, 
				 {0.8160941176470589f, 0.892956862745098f, 0.8002666666666667f}, 
				 {0.8163764705882354f, 0.8924549019607843f, 0.8007529411764707f}, 
				 {0.8166588235294118f, 0.8919529411764705f, 0.8012392156862745f}, 
				 {0.8169411764705883f, 0.8914509803921568f, 0.8017254901960784f}, 
				 {0.8172235294117648f, 0.890949019607843f, 0.8022117647058824f}, 
				 {0.8175058823529412f, 0.8904470588235294f, 0.8026980392156863f}, 
				 {0.8177882352941177f, 0.8899450980392156f, 0.8031843137254903f}, 
				 {0.8180705882352942f, 0.8894431372549019f, 0.8036705882352941f}, 
				 {0.8183529411764706f, 0.8889411764705881f, 0.8041568627450981f}, 
				 {0.8186352941176471f, 0.8884392156862744f, 0.804643137254902f}, 
				 {0.8189176470588235f, 0.8879372549019607f, 0.8051294117647059f}, 
				 {0.8192f, 0.887435294117647f, 0.8056156862745099f}, 
				 {0.8194823529411766f, 0.8869333333333332f, 0.8061019607843137f}, 
				 {0.819764705882353f, 0.8864313725490195f, 0.8065882352941177f}, 
				 {0.8200470588235295f, 0.8859294117647059f, 0.8070745098039216f}, 
				 {0.820329411764706f, 0.8854274509803921f, 0.8075607843137256f}, 
				 {0.8206117647058824f, 0.8849254901960784f, 0.8080470588235295f}, 
				 {0.8208941176470589f, 0.8844235294117646f, 0.8085333333333333f}, 
				 {0.8211764705882354f, 0.8839215686274509f, 0.8090196078431373f}, 
				 {0.8214588235294118f, 0.8834196078431371f, 0.8095058823529412f}, 
				 {0.8217411764705883f, 0.8829176470588235f, 0.8099921568627451f}, 
				 {0.8220235294117647f, 0.8824156862745097f, 0.810478431372549f}, 
				 {0.8223058823529412f, 0.8819137254901961f, 0.8109647058823529f}, 
				 {0.8225882352941176f, 0.8814117647058823f, 0.8114509803921568f}, 
				 {0.8228705882352941f, 0.8809098039215686f, 0.8119372549019608f}, 
				 {0.8231529411764706f, 0.8804078431372548f, 0.8124235294117647f}, 
				 {0.823435294117647f, 0.8799058823529411f, 0.8129098039215686f}, 
				 {0.8237176470588236f, 0.8794039215686275f, 0.8133960784313725f}, 
				 {0.8240000000000001f, 0.8789019607843137f, 0.8138823529411765f}, 
				 {0.8242823529411765f, 0.8784f, 0.8143686274509804f}, 
				 {0.824564705882353f, 0.8778980392156862f, 0.8148549019607843f}, 
				 {0.8248470588235295f, 0.8773960784313725f, 0.8153411764705882f}, 
				 {0.8251294117647059f, 0.8768941176470588f, 0.8158274509803921f}, 
				 {0.8254117647058824f, 0.8763921568627451f, 0.8163137254901961f}, 
				 {0.8256941176470588f, 0.8758901960784313f, 0.8168f}, 
				 {0.8259764705882353f, 0.8753882352941176f, 0.817286274509804f}, 
				 {0.8262588235294118f, 0.8748862745098038f, 0.8177725490196078f}, 
				 {0.8265411764705882f, 0.8743843137254902f, 0.8182588235294117f}, 
				 {0.8268235294117647f, 0.8738823529411764f, 0.8187450980392157f}, 
				 {0.8271058823529412f, 0.8733803921568627f, 0.8192313725490196f}, 
				 {0.8273882352941176f, 0.872878431372549f, 0.8197176470588236f}, 
				 {0.8276705882352942f, 0.8723764705882353f, 0.8202039215686274f}, 
				 {0.8279529411764706f, 0.8718745098039216f, 0.8206901960784314f}, 
				 {0.8282352941176471f, 0.8713725490196078f, 0.8211764705882353f}, 
				 {0.8285176470588236f, 0.8708705882352941f, 0.8216627450980392f}, 
				 {0.8288f, 0.8703686274509803f, 0.8221490196078431f}, 
				 {0.8290823529411765f, 0.8698666666666666f, 0.822635294117647f}, 
				 {0.829364705882353f, 0.8693647058823529f, 0.823121568627451f}, 
				 {0.8296470588235294f, 0.8688627450980392f, 0.8236078431372549f}, 
				 {0.8299294117647059f, 0.8683607843137254f, 0.8240941176470588f}, 
				 {0.8302117647058824f, 0.8678588235294117f, 0.8245803921568627f}, 
				 {0.8304941176470588f, 0.867356862745098f, 0.8250666666666666f}, 
				 {0.8307764705882353f, 0.8668549019607843f, 0.8255529411764706f}, 
				 {0.8310588235294118f, 0.8663529411764705f, 0.8260392156862745f}, 
				 {0.8313411764705883f, 0.8658509803921568f, 0.8265254901960785f}, 
				 {0.8316235294117648f, 0.865349019607843f, 0.8270117647058823f}, 
				 {0.8319058823529412f, 0.8648470588235294f, 0.8274980392156862f}, 
				 {0.8321882352941177f, 0.8643450980392157f, 0.8279843137254902f}, 
				 {0.8324705882352942f, 0.8638431372549019f, 0.8284705882352941f}, 
				 {0.8327529411764706f, 0.8633411764705882f, 0.828956862745098f}, 
				 {0.8330352941176471f, 0.8628392156862744f, 0.8294431372549019f}, 
				 {0.8333176470588236f, 0.8623372549019608f, 0.8299294117647059f}, 
				 {0.8336f, 0.861835294117647f, 0.8304156862745098f}, 
				 {0.8338823529411765f, 0.8613333333333333f, 0.8309019607843137f}, 
				 {0.8341647058823529f, 0.8608313725490195f, 0.8313882352941177f}, 
				 {0.8344470588235294f, 0.8603294117647058f, 0.8318745098039215f}, 
				 {0.8347294117647059f, 0.8598274509803921f, 0.8323607843137255f}, 
				 {0.8350117647058823f, 0.8593254901960784f, 0.8328470588235294f}, 
				 {0.8352941176470589f, 0.8588235294117647f, 0.8333333333333333f}, 
				 {0.8355764705882354f, 0.8583215686274509f, 0.8338196078431372f}, 
				 {0.8358588235294118f, 0.8578196078431372f, 0.8343058823529411f}, 
				 {0.8361411764705883f, 0.8573176470588235f, 0.8347921568627451f}, 
				 {0.8364235294117648f, 0.8568156862745098f, 0.835278431372549f}, 
				 {0.8367058823529412f, 0.856313725490196f, 0.835764705882353f}, 
				 {0.8369882352941177f, 0.8558117647058823f, 0.8362509803921568f}, 
				 {0.8372705882352941f, 0.8553098039215685f, 0.8367372549019607f}, 
				 {0.8375529411764706f, 0.8548078431372549f, 0.8372235294117647f}, 
				 {0.8378352941176471f, 0.8543058823529411f, 0.8377098039215686f}, 
				 {0.8381176470588235f, 0.8538039215686274f, 0.8381960784313726f}, 
				 {0.8384f, 0.8533019607843136f, 0.8386823529411764f}, 
				 {0.8386823529411765f, 0.8528f, 0.8391686274509804f}, 
				 {0.838964705882353f, 0.8522980392156863f, 0.8396549019607843f}, 
				 {0.8392470588235295f, 0.8517960784313725f, 0.8401411764705882f}, 
				 {0.8395294117647059f, 0.8512941176470588f, 0.8406274509803922f}, 
				 {0.8398117647058824f, 0.850792156862745f, 0.841113725490196f}, 
				 {0.8400941176470589f, 0.8502901960784313f, 0.8416f}, 
				 {0.8403764705882353f, 0.8497882352941176f, 0.8420862745098039f}, 
				 {0.8406588235294118f, 0.8492862745098039f, 0.8425725490196079f}, 
				 {0.8409411764705883f, 0.8487843137254901f, 0.8430588235294117f}, 
				 {0.8412235294117647f, 0.8482823529411764f, 0.8435450980392156f}, 
				 {0.8415058823529412f, 0.8477803921568627f, 0.8440313725490196f}, 
				 {0.8417882352941177f, 0.847278431372549f, 0.8445176470588235f}, 
				 {0.8420705882352941f, 0.8467764705882352f, 0.8450039215686275f}, 
				 {0.8423529411764706f, 0.8462745098039215f, 0.8454901960784313f}, 
				 {0.8426352941176471f, 0.8457725490196077f, 0.8459764705882353f}, 
				 {0.8429176470588235f, 0.845270588235294f, 0.8464627450980392f}, 
				 {0.8432000000000001f, 0.8447686274509804f, 0.8469490196078431f}, 
				 {0.8434823529411765f, 0.8442666666666666f, 0.8474352941176471f}, 
				 {0.843764705882353f, 0.8437647058823529f, 0.8479215686274509f}, 
				 {0.8440470588235295f, 0.8432627450980391f, 0.8484078431372549f}, 
				 {0.8443294117647059f, 0.8427607843137255f, 0.8488941176470588f}, 
				 {0.8446117647058824f, 0.8422588235294117f, 0.8493803921568628f}, 
				 {0.8448941176470589f, 0.841756862745098f, 0.8498666666666667f}, 
				 {0.8451764705882353f, 0.8412549019607842f, 0.8503529411764705f}, 
				 {0.8454588235294118f, 0.8407529411764705f, 0.8508392156862745f}, 
				 {0.8457411764705882f, 0.8402509803921567f, 0.8513254901960784f}, 
				 {0.8460235294117647f, 0.8397490196078431f, 0.8518117647058824f}, 
				 {0.8463058823529412f, 0.8392470588235293f, 0.8522980392156863f}, 
				 {0.8465882352941176f, 0.8387450980392156f, 0.8527843137254902f}, 
				 {0.8468705882352942f, 0.8382431372549018f, 0.8532705882352941f}, 
				 {0.8471529411764707f, 0.8377411764705882f, 0.853756862745098f}, 
				 {0.8474352941176471f, 0.8372392156862745f, 0.854243137254902f}, 
				 {0.8477176470588236f, 0.8367372549019607f, 0.8547294117647058f}, 
				 {0.8480000000000001f, 0.836235294117647f, 0.8552156862745098f}, 
				 {0.8482823529411765f, 0.8357333333333332f, 0.8557019607843137f}, 
				 {0.848564705882353f, 0.8352313725490196f, 0.8561882352941176f}, 
				 {0.8488470588235294f, 0.8347294117647058f, 0.8566745098039216f}, 
				 {0.8491294117647059f, 0.8342274509803921f, 0.8571607843137254f}, 
				 {0.8494117647058824f, 0.8337254901960783f, 0.8576470588235294f}, 
				 {0.8496941176470588f, 0.8332235294117646f, 0.8581333333333333f}, 
				 {0.8499764705882353f, 0.832721568627451f, 0.8586196078431372f}, 
				 {0.8502588235294118f, 0.8322196078431372f, 0.8591058823529412f}, 
				 {0.8505411764705882f, 0.8317176470588235f, 0.859592156862745f}, 
				 {0.8508235294117648f, 0.8312156862745097f, 0.860078431372549f}, 
				 {0.8511058823529412f, 0.830713725490196f, 0.8605647058823529f}, 
				 {0.8513882352941177f, 0.8302117647058823f, 0.8610509803921569f}, 
				 {0.8516705882352942f, 0.8297098039215686f, 0.8615372549019608f}, 
				 {0.8519529411764706f, 0.8292078431372548f, 0.8620235294117646f}, 
				 {0.8522352941176471f, 0.8287058823529411f, 0.8625098039215686f}, 
				 {0.8525176470588236f, 0.8282039215686274f, 0.8629960784313725f}, 
				 {0.8528f, 0.8277019607843137f, 0.8634823529411765f}, 
				 {0.8530823529411765f, 0.8271999999999999f, 0.8639686274509804f}, 
				 {0.853364705882353f, 0.8266980392156862f, 0.8644549019607843f}, 
				 {0.8536470588235294f, 0.8261960784313724f, 0.8649411764705882f}, 
				 {0.8539294117647059f, 0.8256941176470587f, 0.8654274509803921f}, 
				 {0.8542117647058824f, 0.825192156862745f, 0.8659137254901961f}, 
				 {0.8544941176470588f, 0.8246901960784313f, 0.8664f}, 
				 {0.8547764705882354f, 0.8241882352941176f, 0.8668862745098039f}, 
				 {0.8550588235294118f, 0.8236862745098038f, 0.8673725490196078f}, 
				 {0.8553411764705883f, 0.8231843137254902f, 0.8678588235294118f}, 
				 {0.8556235294117648f, 0.8226823529411764f, 0.8683450980392157f}, 
				 {0.8559058823529412f, 0.8221803921568627f, 0.8688313725490195f}, 
				 {0.8561882352941177f, 0.8216784313725489f, 0.8693176470588235f}, 
				 {0.8564705882352942f, 0.8211764705882352f, 0.8698039215686274f}, 
				 {0.8567529411764706f, 0.8206745098039214f, 0.8702901960784314f}, 
				 {0.8570352941176471f, 0.8201725490196078f, 0.8707764705882353f}, 
				 {0.8573176470588235f, 0.819670588235294f, 0.8712627450980392f}, 
				 {0.8576f, 0.8191686274509804f, 0.871749019607843f}, 
				 {0.8578823529411764f, 0.8186666666666667f, 0.872235294117647f}, 
				 {0.8581647058823529f, 0.8181647058823529f, 0.8727215686274509f}, 
				 {0.8584470588235295f, 0.8176627450980392f, 0.8732078431372549f}, 
				 {0.8587294117647059f, 0.8171607843137254f, 0.8736941176470587f}, 
				 {0.8590117647058824f, 0.8166588235294118f, 0.8741803921568627f}, 
				 {0.8592941176470589f, 0.816156862745098f, 0.8746666666666666f}, 
				 {0.8595764705882353f, 0.8156549019607843f, 0.8751529411764705f}, 
				 {0.8598588235294118f, 0.8151529411764705f, 0.8756392156862745f}, 
				 {0.8601411764705883f, 0.8146509803921569f, 0.8761254901960783f}, 
				 {0.8604235294117647f, 0.8141490196078431f, 0.8766117647058823f}, 
				 {0.8607058823529412f, 0.8136470588235294f, 0.8770980392156862f}, 
				 {0.8609882352941176f, 0.8131450980392156f, 0.8775843137254902f}, 
				 {0.8612705882352941f, 0.8126431372549019f, 0.878070588235294f}, 
				 {0.8615529411764706f, 0.8121411764705881f, 0.8785568627450979f}, 
				 {0.861835294117647f, 0.8116392156862745f, 0.8790431372549019f}, 
				 {0.8621176470588235f, 0.8111372549019608f, 0.8795294117647058f}, 
				 {0.8624f, 0.810635294117647f, 0.8800156862745098f}, 
				 {0.8626823529411765f, 0.8101333333333333f, 0.8805019607843136f}, 
				 {0.862964705882353f, 0.8096313725490196f, 0.8809882352941176f}, 
				 {0.8632470588235295f, 0.8091294117647059f, 0.8814745098039215f}, 
				 {0.8635294117647059f, 0.8086274509803921f, 0.8819607843137254f}, 
				 {0.8638117647058824f, 0.8081254901960784f, 0.8824470588235294f}, 
				 {0.8640941176470588f, 0.8076235294117646f, 0.8829333333333332f}, 
				 {0.8643764705882353f, 0.8071215686274509f, 0.8834196078431372f}, 
				 {0.8646588235294118f, 0.8066196078431372f, 0.8839058823529411f}, 
				 {0.8649411764705882f, 0.8061176470588235f, 0.8843921568627451f}, 
				 {0.8652235294117647f, 0.8056156862745097f, 0.884878431372549f}, 
				 {0.8655058823529412f, 0.805113725490196f, 0.8853647058823528f}, 
				 {0.8657882352941176f, 0.8046117647058824f, 0.8858509803921568f}, 
				 {0.8660705882352941f, 0.8041098039215686f, 0.8863372549019607f}, 
				 {0.8663529411764705f, 0.8036078431372549f, 0.8868235294117647f}, 
				 {0.8666352941176471f, 0.8031058823529411f, 0.8873098039215686f}, 
				 {0.8669176470588236f, 0.8026039215686274f, 0.8877960784313725f}, 
				 {0.8672f, 0.8021019607843136f, 0.8882823529411764f}, 
				 {0.8674823529411765f, 0.8016f, 0.8887686274509803f}, 
				 {0.867764705882353f, 0.8010980392156862f, 0.8892549019607843f}, 
				 {0.8680470588235294f, 0.8005960784313725f, 0.8897411764705881f}, 
				 {0.8683294117647059f, 0.8000941176470587f, 0.8902274509803921f}, 
				 {0.8686117647058824f, 0.7995921568627451f, 0.890713725490196f}, 
				 {0.8688941176470588f, 0.7990901960784313f, 0.8912f}, 
				 {0.8691764705882353f, 0.7985882352941176f, 0.8916862745098039f}, 
				 {0.8694588235294118f, 0.7980862745098039f, 0.8921725490196077f}, 
				 {0.8697411764705882f, 0.7975843137254901f, 0.8926588235294117f}, 
				 {0.8700235294117648f, 0.7970823529411765f, 0.8931450980392156f}, 
				 {0.8703058823529412f, 0.7965803921568627f, 0.8936313725490196f}, 
				 {0.8705882352941177f, 0.796078431372549f, 0.8941176470588235f}, 
				 {0.8710901960784314f, 0.7962980392156862f, 0.8931450980392156f}, 
				 {0.8715921568627452f, 0.7965176470588234f, 0.8921725490196077f}, 
				 {0.8720941176470588f, 0.7967372549019607f, 0.8911999999999999f}, 
				 {0.8725960784313725f, 0.796956862745098f, 0.8902274509803921f}, 
				 {0.8730980392156863f, 0.7971764705882353f, 0.8892549019607843f}, 
				 {0.8736f, 0.7973960784313725f, 0.8882823529411764f}, 
				 {0.8741019607843138f, 0.7976156862745097f, 0.8873098039215686f}, 
				 {0.8746039215686274f, 0.797835294117647f, 0.8863372549019607f}, 
				 {0.8751058823529412f, 0.7980549019607842f, 0.8853647058823528f}, 
				 {0.8756078431372549f, 0.7982745098039216f, 0.884392156862745f}, 
				 {0.8761098039215687f, 0.7984941176470588f, 0.8834196078431372f}, 
				 {0.8766117647058824f, 0.798713725490196f, 0.8824470588235294f}, 
				 {0.8771137254901961f, 0.7989333333333333f, 0.8814745098039215f}, 
				 {0.8776156862745098f, 0.7991529411764705f, 0.8805019607843136f}, 
				 {0.8781176470588236f, 0.7993725490196077f, 0.8795294117647058f}, 
				 {0.8786196078431373f, 0.7995921568627451f, 0.8785568627450979f}, 
				 {0.879121568627451f, 0.7998117647058823f, 0.8775843137254902f}, 
				 {0.8796235294117647f, 0.8000313725490196f, 0.8766117647058823f}, 
				 {0.8801254901960784f, 0.8002509803921568f, 0.8756392156862745f}, 
				 {0.8806274509803922f, 0.800470588235294f, 0.8746666666666666f}, 
				 {0.8811294117647059f, 0.8006901960784313f, 0.8736941176470587f}, 
				 {0.8816313725490197f, 0.8009098039215686f, 0.8727215686274509f}, 
				 {0.8821333333333333f, 0.8011294117647059f, 0.871749019607843f}, 
				 {0.8826352941176471f, 0.8013490196078431f, 0.8707764705882353f}, 
				 {0.8831372549019608f, 0.8015686274509803f, 0.8698039215686274f}, 
				 {0.8836392156862746f, 0.8017882352941176f, 0.8688313725490195f}, 
				 {0.8841411764705882f, 0.8020078431372548f, 0.8678588235294117f}, 
				 {0.884643137254902f, 0.8022274509803922f, 0.8668862745098038f}, 
				 {0.8851450980392157f, 0.8024470588235294f, 0.865913725490196f}, 
				 {0.8856470588235295f, 0.8026666666666666f, 0.8649411764705881f}, 
				 {0.8861490196078432f, 0.8028862745098039f, 0.8639686274509804f}, 
				 {0.8866509803921568f, 0.8031058823529411f, 0.8629960784313725f}, 
				 {0.8871529411764706f, 0.8033254901960784f, 0.8620235294117646f}, 
				 {0.8876549019607843f, 0.8035450980392156f, 0.8610509803921568f}, 
				 {0.8881568627450981f, 0.8037647058823529f, 0.8600784313725489f}, 
				 {0.8886588235294118f, 0.8039843137254902f, 0.859105882352941f}, 
				 {0.8891607843137255f, 0.8042039215686274f, 0.8581333333333332f}, 
				 {0.8896627450980392f, 0.8044235294117646f, 0.8571607843137254f}, 
				 {0.890164705882353f, 0.8046431372549019f, 0.8561882352941176f}, 
				 {0.8906666666666667f, 0.8048627450980391f, 0.8552156862745097f}, 
				 {0.8911686274509805f, 0.8050823529411765f, 0.8542431372549019f}, 
				 {0.8916705882352941f, 0.8053019607843137f, 0.853270588235294f}, 
				 {0.8921725490196079f, 0.805521568627451f, 0.8522980392156861f}, 
				 {0.8926745098039216f, 0.8057411764705882f, 0.8513254901960783f}, 
				 {0.8931764705882353f, 0.8059607843137254f, 0.8503529411764705f}, 
				 {0.8936784313725491f, 0.8061803921568627f, 0.8493803921568627f}, 
				 {0.8941803921568627f, 0.8064f, 0.8484078431372548f}, 
				 {0.8946823529411765f, 0.8066196078431372f, 0.847435294117647f}, 
				 {0.8951843137254902f, 0.8068392156862745f, 0.8464627450980391f}, 
				 {0.895686274509804f, 0.8070588235294117f, 0.8454901960784312f}, 
				 {0.8961882352941177f, 0.807278431372549f, 0.8445176470588235f}, 
				 {0.8966901960784314f, 0.8074980392156862f, 0.8435450980392156f}, 
				 {0.8971921568627451f, 0.8077176470588235f, 0.8425725490196078f}, 
				 {0.8976941176470589f, 0.8079372549019608f, 0.8415999999999999f}, 
				 {0.8981960784313726f, 0.808156862745098f, 0.840627450980392f}, 
				 {0.8986980392156864f, 0.8083764705882353f, 0.8396549019607842f}, 
				 {0.8992f, 0.8085960784313725f, 0.8386823529411763f}, 
				 {0.8997019607843137f, 0.8088156862745097f, 0.8377098039215686f}, 
				 {0.9002039215686275f, 0.8090352941176471f, 0.8367372549019607f}, 
				 {0.9007058823529412f, 0.8092549019607843f, 0.8357647058823529f}, 
				 {0.901207843137255f, 0.8094745098039215f, 0.834792156862745f}, 
				 {0.9017098039215686f, 0.8096941176470588f, 0.8338196078431371f}, 
				 {0.9022117647058824f, 0.809913725490196f, 0.8328470588235293f}, 
				 {0.9027137254901961f, 0.8101333333333333f, 0.8318745098039215f}, 
				 {0.9032156862745099f, 0.8103529411764706f, 0.8309019607843137f}, 
				 {0.9037176470588236f, 0.8105725490196078f, 0.8299294117647058f}, 
				 {0.9042196078431373f, 0.8107921568627451f, 0.8289568627450979f}, 
				 {0.904721568627451f, 0.8110117647058823f, 0.8279843137254901f}, 
				 {0.9052235294117648f, 0.8112313725490196f, 0.8270117647058822f}, 
				 {0.9057254901960785f, 0.8114509803921568f, 0.8260392156862744f}, 
				 {0.9062274509803923f, 0.811670588235294f, 0.8250666666666666f}, 
				 {0.9067294117647059f, 0.8118901960784314f, 0.8240941176470588f}, 
				 {0.9072313725490196f, 0.8121098039215686f, 0.8231215686274509f}, 
				 {0.9077333333333334f, 0.8123294117647059f, 0.822149019607843f}, 
				 {0.9082352941176471f, 0.8125490196078431f, 0.8211764705882352f}, 
				 {0.9087372549019608f, 0.8127686274509803f, 0.8202039215686273f}, 
				 {0.9092392156862745f, 0.8129882352941176f, 0.8192313725490195f}, 
				 {0.9097411764705883f, 0.8132078431372549f, 0.8182588235294117f}, 
				 {0.910243137254902f, 0.8134274509803922f, 0.8172862745098038f}, 
				 {0.9107450980392158f, 0.8136470588235294f, 0.816313725490196f}, 
				 {0.9112470588235295f, 0.8138666666666666f, 0.8153411764705881f}, 
				 {0.9117490196078432f, 0.8140862745098039f, 0.8143686274509803f}, 
				 {0.9122509803921569f, 0.8143058823529411f, 0.8133960784313725f}, 
				 {0.9127529411764705f, 0.8145254901960783f, 0.8124235294117647f}, 
				 {0.9132549019607843f, 0.8147450980392157f, 0.8114509803921569f}, 
				 {0.913756862745098f, 0.8149647058823529f, 0.810478431372549f}, 
				 {0.9142588235294118f, 0.8151843137254902f, 0.8095058823529412f}, 
				 {0.9147607843137255f, 0.8154039215686274f, 0.8085333333333333f}, 
				 {0.9152627450980392f, 0.8156235294117646f, 0.8075607843137255f}, 
				 {0.9157647058823529f, 0.8158431372549019f, 0.8065882352941176f}, 
				 {0.9162666666666667f, 0.8160627450980391f, 0.8056156862745099f}, 
				 {0.9167686274509804f, 0.8162823529411765f, 0.804643137254902f}, 
				 {0.9172705882352941f, 0.8165019607843137f, 0.8036705882352941f}, 
				 {0.9177725490196078f, 0.8167215686274509f, 0.8026980392156863f}, 
				 {0.9182745098039216f, 0.8169411764705882f, 0.8017254901960784f}, 
				 {0.9187764705882353f, 0.8171607843137254f, 0.8007529411764706f}, 
				 {0.919278431372549f, 0.8173803921568626f, 0.7997803921568627f}, 
				 {0.9197803921568628f, 0.8176f, 0.798807843137255f}, 
				 {0.9202823529411764f, 0.8178196078431372f, 0.7978352941176471f}, 
				 {0.9207843137254902f, 0.8180392156862745f, 0.7968627450980392f}, 
				 {0.9212862745098039f, 0.8182588235294117f, 0.7958901960784314f}, 
				 {0.9217882352941177f, 0.8184784313725489f, 0.7949176470588235f}, 
				 {0.9222901960784313f, 0.8186980392156862f, 0.7939450980392156f}, 
				 {0.9227921568627451f, 0.8189176470588235f, 0.7929725490196078f}, 
				 {0.9232941176470588f, 0.8191372549019608f, 0.792f}, 
				 {0.9237960784313726f, 0.819356862745098f, 0.7910274509803922f}, 
				 {0.9242980392156863f, 0.8195764705882352f, 0.7900549019607843f}, 
				 {0.9248f, 0.8197960784313725f, 0.7890823529411765f}, 
				 {0.9253019607843137f, 0.8200156862745097f, 0.7881098039215686f}, 
				 {0.9258039215686275f, 0.8202352941176471f, 0.7871372549019607f}, 
				 {0.9263058823529412f, 0.8204549019607843f, 0.7861647058823529f}, 
				 {0.926807843137255f, 0.8206745098039215f, 0.7851921568627451f}, 
				 {0.9273098039215686f, 0.8208941176470588f, 0.7842196078431373f}, 
				 {0.9278117647058823f, 0.821113725490196f, 0.7832470588235294f}, 
				 {0.9283137254901961f, 0.8213333333333332f, 0.7822745098039215f}, 
				 {0.9288156862745098f, 0.8215529411764706f, 0.7813019607843137f}, 
				 {0.9293176470588236f, 0.8217725490196078f, 0.7803294117647058f}, 
				 {0.9298196078431372f, 0.8219921568627451f, 0.779356862745098f}, 
				 {0.930321568627451f, 0.8222117647058823f, 0.7783843137254902f}, 
				 {0.9308235294117647f, 0.8224313725490195f, 0.7774117647058824f}, 
				 {0.9313254901960785f, 0.8226509803921568f, 0.7764392156862745f}, 
				 {0.9318274509803922f, 0.822870588235294f, 0.7754666666666666f}, 
				 {0.9323294117647059f, 0.8230901960784314f, 0.7744941176470588f}, 
				 {0.9328313725490196f, 0.8233098039215686f, 0.7735215686274509f}, 
				 {0.9333333333333333f, 0.8235294117647058f, 0.7725490196078431f}, 
				 {0.9338352941176471f, 0.8237490196078431f, 0.7715764705882353f}, 
				 {0.9343372549019608f, 0.8239686274509803f, 0.7706039215686274f}, 
				 {0.9348392156862745f, 0.8241882352941177f, 0.7696313725490196f}, 
				 {0.9353411764705882f, 0.8244078431372549f, 0.7686588235294117f}, 
				 {0.935843137254902f, 0.8246274509803921f, 0.7676862745098039f}, 
				 {0.9363450980392157f, 0.8248470588235294f, 0.7667137254901961f}, 
				 {0.9368470588235295f, 0.8250666666666666f, 0.7657411764705881f}, 
				 {0.9373490196078431f, 0.8252862745098039f, 0.7647686274509804f}, 
				 {0.9378509803921569f, 0.8255058823529411f, 0.7637960784313725f}, 
				 {0.9383529411764706f, 0.8257254901960784f, 0.7628235294117647f}, 
				 {0.9388549019607844f, 0.8259450980392157f, 0.7618509803921568f}, 
				 {0.9393568627450981f, 0.8261647058823529f, 0.760878431372549f}, 
				 {0.9398588235294117f, 0.8263843137254901f, 0.7599058823529412f}, 
				 {0.9403607843137255f, 0.8266039215686274f, 0.7589333333333332f}, 
				 {0.9408627450980392f, 0.8268235294117646f, 0.7579607843137255f}, 
				 {0.941364705882353f, 0.827043137254902f, 0.7569882352941176f}, 
				 {0.9418666666666666f, 0.8272627450980392f, 0.7560156862745098f}, 
				 {0.9423686274509804f, 0.8274823529411764f, 0.7550431372549019f}, 
				 {0.9428705882352941f, 0.8277019607843137f, 0.754070588235294f}, 
				 {0.9433725490196079f, 0.8279215686274509f, 0.7530980392156863f}, 
				 {0.9438745098039216f, 0.8281411764705882f, 0.7521254901960783f}, 
				 {0.9443764705882354f, 0.8283607843137255f, 0.7511529411764706f}, 
				 {0.944878431372549f, 0.8285803921568627f, 0.7501803921568627f}, 
				 {0.9453803921568628f, 0.8288f, 0.7492078431372549f}, 
				 {0.9458823529411765f, 0.8290196078431372f, 0.748235294117647f}, 
				 {0.9463843137254903f, 0.8292392156862745f, 0.7472627450980391f}, 
				 {0.9468862745098039f, 0.8294588235294117f, 0.7462901960784314f}, 
				 {0.9473882352941176f, 0.8296784313725489f, 0.7453176470588235f}, 
				 {0.9478901960784314f, 0.8298980392156863f, 0.7443450980392157f}, 
				 {0.9483921568627451f, 0.8301176470588235f, 0.7433725490196078f}, 
				 {0.9488941176470589f, 0.8303372549019608f, 0.7424f}, 
				 {0.9493960784313726f, 0.830556862745098f, 0.7414274509803921f}, 
				 {0.9498980392156863f, 0.8307764705882352f, 0.7404549019607842f}, 
				 {0.9504f, 0.8309960784313726f, 0.7394823529411765f}, 
				 {0.9509019607843138f, 0.8312156862745098f, 0.7385098039215686f}, 
				 {0.9514039215686275f, 0.831435294117647f, 0.7375372549019608f}, 
				 {0.9519058823529412f, 0.8316549019607843f, 0.7365647058823529f}, 
				 {0.9524078431372549f, 0.8318745098039215f, 0.735592156862745f}, 
				 {0.9529098039215687f, 0.8320941176470588f, 0.7346196078431372f}, 
				 {0.9534117647058824f, 0.832313725490196f, 0.7336470588235293f}, 
				 {0.9539137254901962f, 0.8325333333333333f, 0.7326745098039216f}, 
				 {0.9544156862745098f, 0.8327529411764706f, 0.7317019607843137f}, 
				 {0.9549176470588235f, 0.8329725490196078f, 0.7307294117647058f}, 
				 {0.9554196078431373f, 0.8331921568627451f, 0.729756862745098f}, 
				 {0.955921568627451f, 0.8334117647058823f, 0.7287843137254901f}, 
				 {0.9564235294117648f, 0.8336313725490195f, 0.7278117647058823f}, 
				 {0.9569254901960784f, 0.8338509803921569f, 0.7268392156862744f}, 
				 {0.9574274509803922f, 0.8340705882352941f, 0.7258666666666667f}, 
				 {0.9579294117647059f, 0.8342901960784314f, 0.7248941176470588f}, 
				 {0.9584313725490197f, 0.8345098039215686f, 0.7239215686274509f}, 
				 {0.9589333333333334f, 0.8347294117647058f, 0.7229490196078431f}, 
				 {0.959435294117647f, 0.8349490196078431f, 0.7219764705882352f}, 
				 {0.9599372549019608f, 0.8351686274509804f, 0.7210039215686274f}, 
				 {0.9604392156862745f, 0.8353882352941177f, 0.7200313725490195f}, 
				 {0.9609411764705883f, 0.8356078431372549f, 0.7190588235294118f}, 
				 {0.961443137254902f, 0.8358274509803921f, 0.7180862745098039f}, 
				 {0.9619450980392157f, 0.8360470588235294f, 0.717113725490196f}, 
				 {0.9624470588235294f, 0.8362666666666666f, 0.7161411764705882f}, 
				 {0.9629490196078432f, 0.836486274509804f, 0.7151686274509803f}, 
				 {0.9634509803921569f, 0.8367058823529412f, 0.7141960784313726f}, 
				 {0.9639529411764707f, 0.8369254901960784f, 0.7132235294117646f}, 
				 {0.9644549019607843f, 0.8371450980392157f, 0.7122509803921568f}, 
				 {0.9649568627450981f, 0.8373647058823529f, 0.711278431372549f}, 
				 {0.9654588235294118f, 0.8375843137254901f, 0.7103058823529411f}, 
				 {0.9659607843137256f, 0.8378039215686275f, 0.7093333333333333f}, 
				 {0.9664627450980392f, 0.8380235294117647f, 0.7083607843137254f}, 
				 {0.966964705882353f, 0.838243137254902f, 0.7073882352941177f}, 
				 {0.9674666666666667f, 0.8384627450980392f, 0.7064156862745097f}, 
				 {0.9679686274509804f, 0.8386823529411764f, 0.7054431372549019f}, 
				 {0.9684705882352942f, 0.8389019607843137f, 0.7044705882352941f}, 
				 {0.9689725490196079f, 0.8391215686274509f, 0.7034980392156862f}, 
				 {0.9694745098039216f, 0.8393411764705883f, 0.7025254901960784f}, 
				 {0.9699764705882353f, 0.8395607843137255f, 0.7015529411764705f}, 
				 {0.9704784313725491f, 0.8397803921568627f, 0.7005803921568627f}, 
				 {0.9709803921568628f, 0.84f, 0.6996078431372548f}, 
				 {0.9714823529411765f, 0.8402196078431372f, 0.698635294117647f}, 
				 {0.9719843137254902f, 0.8404392156862744f, 0.6976627450980392f}, 
				 {0.972486274509804f, 0.8406588235294118f, 0.6966901960784313f}, 
				 {0.9729882352941177f, 0.840878431372549f, 0.6957176470588234f}, 
				 {0.9734901960784315f, 0.8410980392156863f, 0.6947450980392156f}, 
				 {0.9739921568627452f, 0.8413176470588235f, 0.6937725490196078f}, 
				 {0.9744941176470588f, 0.8415372549019607f, 0.6928f}, 
				 {0.9749960784313726f, 0.841756862745098f, 0.6918274509803921f}, 
				 {0.9754980392156863f, 0.8419764705882353f, 0.6908549019607843f}, 
				 {0.976f, 0.8421960784313725f, 0.6898823529411765f}, 
				 {0.9765019607843137f, 0.8424156862745098f, 0.6889098039215686f}, 
				 {0.9770039215686275f, 0.842635294117647f, 0.6879372549019608f}, 
				 {0.9775058823529412f, 0.8428549019607843f, 0.6869647058823529f}, 
				 {0.9780078431372549f, 0.8430745098039215f, 0.6859921568627452f}, 
				 {0.9785098039215686f, 0.8432941176470587f, 0.6850196078431373f}, 
				 {0.9790117647058824f, 0.8435137254901961f, 0.6840470588235295f}, 
				 {0.9795137254901961f, 0.8437333333333333f, 0.6830745098039216f}, 
				 {0.9800156862745097f, 0.8439529411764706f, 0.6821019607843137f}, 
				 {0.9805176470588235f, 0.8441725490196078f, 0.681129411764706f}, 
				 {0.9810196078431372f, 0.844392156862745f, 0.680156862745098f}, 
				 {0.981521568627451f, 0.8446117647058823f, 0.6791843137254903f}, 
				 {0.9820235294117647f, 0.8448313725490195f, 0.6782117647058824f}, 
				 {0.9825254901960785f, 0.8450509803921569f, 0.6772392156862745f}, 
				 {0.9830274509803921f, 0.8452705882352941f, 0.6762666666666667f}, 
				 {0.9835294117647059f, 0.8454901960784313f, 0.6752941176470588f}, 
				 {0.9840313725490196f, 0.8457098039215686f, 0.6743215686274511f}, 
				 {0.9845333333333334f, 0.8459294117647058f, 0.6733490196078431f}, 
				 {0.985035294117647f, 0.8461490196078431f, 0.6723764705882354f}, 
				 {0.9855372549019608f, 0.8463686274509804f, 0.6714039215686275f}, 
				 {0.9860392156862745f, 0.8465882352941176f, 0.6704313725490196f}, 
				 {0.9865411764705883f, 0.8468078431372549f, 0.6694588235294118f}, 
				 {0.987043137254902f, 0.8470274509803921f, 0.6684862745098039f}, 
				 {0.9875450980392158f, 0.8472470588235294f, 0.6675137254901962f}, 
				 {0.9880470588235294f, 0.8474666666666666f, 0.6665411764705883f}, 
				 {0.9885490196078431f, 0.8476862745098039f, 0.6655686274509804f}, 
				 {0.9890509803921569f, 0.8479058823529412f, 0.6645960784313726f}, 
				 {0.9895529411764706f, 0.8481254901960784f, 0.6636235294117647f}, 
				 {0.9900549019607843f, 0.8483450980392157f, 0.6626509803921569f}, 
				 {0.990556862745098f, 0.8485647058823529f, 0.661678431372549f}, 
				 {0.9910588235294118f, 0.8487843137254901f, 0.6607058823529413f}, 
				 {0.9915607843137255f, 0.8490039215686275f, 0.6597333333333334f}, 
				 {0.9920627450980393f, 0.8492235294117647f, 0.6587607843137255f}, 
				 {0.9925647058823529f, 0.849443137254902f, 0.6577882352941177f}, 
				 {0.9930666666666667f, 0.8496627450980392f, 0.6568156862745098f}, 
				 {0.9935686274509804f, 0.8498823529411764f, 0.655843137254902f}, 
				 {0.9940705882352942f, 0.8501019607843137f, 0.6548705882352941f}, 
				 {0.9945725490196079f, 0.850321568627451f, 0.6538980392156863f}, 
				 {0.9950745098039215f, 0.8505411764705882f, 0.6529254901960785f}, 
				 {0.9955764705882353f, 0.8507607843137255f, 0.6519529411764706f}, 
				 {0.996078431372549f, 0.8509803921568627f, 0.6509803921568628f}};

float palette_blue_to_yellow[1001][3]={{0.f, 0.f, 1.f}, {0.001f, 0.001f, 0.999f}, {0.002f, 0.002f, 0.998f}, 
				       {0.003f, 0.003f, 0.997f}, {0.004f, 0.004f, 0.996f}, {0.005f, 0.005f, 0.995f}, 
				       {0.006f, 0.006f, 0.994f}, {0.007f, 0.007f, 0.993f}, {0.008f, 0.008f, 0.992f}, 
				       {0.009000000000000001f, 0.009000000000000001f, 0.991f}, {0.01f, 0.01f, 0.99f}, 
				       {0.011f, 0.011f, 0.989f}, {0.012f, 0.012f, 0.988f}, 
				       {0.013000000000000001f, 0.013000000000000001f, 0.987f}, {0.014f, 0.014f, 0.986f}, 
				       {0.015f, 0.015f, 0.985f}, {0.016f, 0.016f, 0.984f}, {0.017f, 0.017f, 0.983f}, 
				       {0.018000000000000002f, 0.018000000000000002f, 0.982f}, {0.019f, 0.019f, 0.981f}, 
				       {0.02f, 0.02f, 0.98f}, {0.021f, 0.021f, 0.979f}, {0.022f, 0.022f, 0.978f}, 
				       {0.023f, 0.023f, 0.977f}, {0.024f, 0.024f, 0.976f}, {0.025f, 0.025f, 0.975f}, 
				       {0.026000000000000002f, 0.026000000000000002f, 0.974f}, {0.027f, 0.027f, 0.973f}, 
				       {0.028f, 0.028f, 0.972f}, {0.029f, 0.029f, 0.971f}, {0.03f, 0.03f, 0.97f}, 
				       {0.031f, 0.031f, 0.969f}, {0.032f, 0.032f, 0.968f}, {0.033f, 0.033f, 0.967f}, 
				       {0.034f, 0.034f, 0.966f}, {0.035f, 0.035f, 0.965f}, 
				       {0.036000000000000004f, 0.036000000000000004f, 0.964f}, {0.037f, 0.037f, 0.963f}, 
				       {0.038f, 0.038f, 0.962f}, {0.039f, 0.039f, 0.961f}, {0.04f, 0.04f, 0.96f}, 
				       {0.041f, 0.041f, 0.959f}, {0.042f, 0.042f, 0.958f}, 
				       {0.043000000000000003f, 0.043000000000000003f, 0.957f}, {0.044f, 0.044f, 0.956f}, 
				       {0.045f, 0.045f, 0.955f}, {0.046f, 0.046f, 0.954f}, {0.047f, 0.047f, 0.953f}, 
				       {0.048f, 0.048f, 0.952f}, {0.049f, 0.049f, 0.951f}, {0.05f, 0.05f, 0.95f}, 
				       {0.051000000000000004f, 0.051000000000000004f, 0.949f}, 
				       {0.052000000000000005f, 0.052000000000000005f, 0.948f}, {0.053f, 0.053f, 0.947f}, 
				       {0.054f, 0.054f, 0.946f}, {0.055f, 0.055f, 0.945f}, {0.056f, 0.056f, 0.944f}, 
				       {0.057f, 0.057f, 0.943f}, {0.058f, 0.058f, 0.942f}, 
				       {0.059000000000000004f, 0.059000000000000004f, 0.941f}, {0.06f, 0.06f, 0.94f}, 
				       {0.061f, 0.061f, 0.9390000000000001f}, {0.062f, 0.062f, 0.938f}, 
				       {0.063f, 0.063f, 0.937f}, {0.064f, 0.064f, 0.9359999999999999f}, 
				       {0.065f, 0.065f, 0.935f}, {0.066f, 0.066f, 0.9339999999999999f}, 
				       {0.067f, 0.067f, 0.933f}, {0.068f, 0.068f, 0.9319999999999999f}, 
				       {0.069f, 0.069f, 0.931f}, {0.07f, 0.07f, 0.9299999999999999f}, 
				       {0.07100000000000001f, 0.07100000000000001f, 0.929f}, 
				       {0.07200000000000001f, 0.07200000000000001f, 0.9279999999999999f}, 
				       {0.073f, 0.073f, 0.927f}, {0.074f, 0.074f, 0.926f}, {0.075f, 0.075f, 0.925f}, 
				       {0.076f, 0.076f, 0.924f}, {0.077f, 0.077f, 0.923f}, {0.078f, 0.078f, 0.922f}, 
				       {0.079f, 0.079f, 0.921f}, {0.08f, 0.08f, 0.92f}, {0.081f, 0.081f, 0.919f}, 
				       {0.082f, 0.082f, 0.918f}, {0.083f, 0.083f, 0.917f}, {0.084f, 0.084f, 0.916f}, 
				       {0.085f, 0.085f, 0.915f}, {0.08600000000000001f, 0.08600000000000001f, 0.914f}, 
				       {0.08700000000000001f, 0.08700000000000001f, 0.913f}, {0.088f, 0.088f, 0.912f}, 
				       {0.089f, 0.089f, 0.911f}, {0.09f, 0.09f, 0.91f}, {0.091f, 0.091f, 0.909f}, 
				       {0.092f, 0.092f, 0.908f}, {0.093f, 0.093f, 0.907f}, {0.094f, 0.094f, 0.906f}, 
				       {0.095f, 0.095f, 0.905f}, {0.096f, 0.096f, 0.904f}, {0.097f, 0.097f, 0.903f}, 
				       {0.098f, 0.098f, 0.902f}, {0.099f, 0.099f, 0.901f}, {0.1f, 0.1f, 0.9f}, 
				       {0.101f, 0.101f, 0.899f}, {0.10200000000000001f, 0.10200000000000001f, 0.898f}, 
				       {0.10300000000000001f, 0.10300000000000001f, 0.897f}, 
				       {0.10400000000000001f, 0.10400000000000001f, 0.896f}, {0.105f, 0.105f, 0.895f}, 
				       {0.106f, 0.106f, 0.894f}, {0.107f, 0.107f, 0.893f}, {0.108f, 0.108f, 0.892f}, 
				       {0.109f, 0.109f, 0.891f}, {0.11f, 0.11f, 0.89f}, {0.111f, 0.111f, 0.889f}, 
				       {0.112f, 0.112f, 0.888f}, {0.113f, 0.113f, 0.887f}, {0.114f, 0.114f, 0.886f}, 
				       {0.115f, 0.115f, 0.885f}, {0.116f, 0.116f, 0.884f}, {0.117f, 0.117f, 0.883f}, 
				       {0.11800000000000001f, 0.11800000000000001f, 0.882f}, 
				       {0.11900000000000001f, 0.11900000000000001f, 0.881f}, {0.12f, 0.12f, 0.88f}, 
				       {0.121f, 0.121f, 0.879f}, {0.122f, 0.122f, 0.878f}, {0.123f, 0.123f, 0.877f}, 
				       {0.124f, 0.124f, 0.876f}, {0.125f, 0.125f, 0.875f}, {0.126f, 0.126f, 0.874f}, 
				       {0.127f, 0.127f, 0.873f}, {0.128f, 0.128f, 0.872f}, {0.129f, 0.129f, 0.871f}, 
				       {0.13f, 0.13f, 0.87f}, {0.131f, 0.131f, 0.869f}, {0.132f, 0.132f, 0.868f}, 
				       {0.133f, 0.133f, 0.867f}, {0.134f, 0.134f, 0.866f}, {0.135f, 0.135f, 0.865f}, 
				       {0.136f, 0.136f, 0.864f}, {0.137f, 0.137f, 0.863f}, {0.138f, 0.138f, 0.862f}, 
				       {0.139f, 0.139f, 0.861f}, {0.14f, 0.14f, 0.86f}, {0.14100000000000001f, 
										   0.14100000000000001f, 0.859f}, {0.14200000000000002f, 0.14200000000000002f, 
														 0.858f}, {0.14300000000000002f, 0.14300000000000002f, 0.857f}, 
				       {0.14400000000000002f, 0.14400000000000002f, 0.856f}, {0.145f, 0.145f, 0.855f}, 
				       {0.146f, 0.146f, 0.854f}, {0.147f, 0.147f, 0.853f}, {0.148f, 0.148f, 0.852f}, 
				       {0.149f, 0.149f, 0.851f}, {0.15f, 0.15f, 0.85f}, {0.151f, 0.151f, 0.849f}, 
				       {0.152f, 0.152f, 0.848f}, {0.153f, 0.153f, 0.847f}, {0.154f, 0.154f, 0.846f}, 
				       {0.155f, 0.155f, 0.845f}, {0.156f, 0.156f, 0.844f}, {0.157f, 0.157f, 0.843f}, 
				       {0.158f, 0.158f, 0.842f}, {0.159f, 0.159f, 0.841f}, {0.16f, 0.16f, 0.84f}, 
				       {0.161f, 0.161f, 0.839f}, {0.162f, 0.162f, 0.838f}, {0.163f, 0.163f, 0.837f}, 
				       {0.164f, 0.164f, 0.836f}, {0.165f, 0.165f, 0.835f}, {0.166f, 0.166f, 0.834f}, 
				       {0.167f, 0.167f, 0.833f}, {0.168f, 0.168f, 0.832f}, {0.169f, 0.169f, 0.831f}, 
				       {0.17f, 0.17f, 0.83f}, {0.171f, 0.171f, 0.829f}, {0.17200000000000001f, 
										   0.17200000000000001f, 0.828f}, {0.17300000000000001f, 0.17300000000000001f, 
														 0.827f}, {0.17400000000000002f, 0.17400000000000002f, 0.826f}, 
				       {0.17500000000000002f, 0.17500000000000002f, 0.825f}, 
				       {0.176f, 0.176f, 0.8240000000000001f}, {0.177f, 0.177f, 0.823f}, 
				       {0.178f, 0.178f, 0.8220000000000001f}, {0.179f, 0.179f, 0.821f}, 
				       {0.18f, 0.18f, 0.8200000000000001f}, {0.181f, 0.181f, 0.819f}, 
				       {0.182f, 0.182f, 0.8180000000000001f}, {0.183f, 0.183f, 0.817f}, 
				       {0.184f, 0.184f, 0.8160000000000001f}, {0.185f, 0.185f, 0.815f}, 
				       {0.186f, 0.186f, 0.8140000000000001f}, {0.187f, 0.187f, 0.813f}, 
				       {0.188f, 0.188f, 0.812f}, {0.189f, 0.189f, 0.8109999999999999f}, 
				       {0.19f, 0.19f, 0.81f}, {0.191f, 0.191f, 0.8089999999999999f}, 
				       {0.192f, 0.192f, 0.808f}, {0.193f, 0.193f, 0.8069999999999999f}, 
				       {0.194f, 0.194f, 0.806f}, {0.195f, 0.195f, 0.8049999999999999f}, 
				       {0.196f, 0.196f, 0.804f}, {0.197f, 0.197f, 0.8029999999999999f}, 
				       {0.198f, 0.198f, 0.802f}, {0.199f, 0.199f, 0.8009999999999999f}, {0.2f, 0.2f, 0.8f}, 
				       {0.201f, 0.201f, 0.7989999999999999f}, {0.202f, 0.202f, 0.798f}, 
				       {0.203f, 0.203f, 0.7969999999999999f}, {0.20400000000000001f, 
									    0.20400000000000001f, 0.796f}, {0.20500000000000002f, 0.20500000000000002f, 
													  0.7949999999999999f}, {0.20600000000000002f, 0.20600000000000002f, 0.794f}, 
				       {0.20700000000000002f, 0.20700000000000002f, 0.7929999999999999f}, 
				       {0.20800000000000002f, 0.20800000000000002f, 0.792f}, {0.209f, 0.209f, 0.791f}, 
				       {0.21f, 0.21f, 0.79f}, {0.211f, 0.211f, 0.789f}, {0.212f, 0.212f, 0.788f}, 
				       {0.213f, 0.213f, 0.787f}, {0.214f, 0.214f, 0.786f}, {0.215f, 0.215f, 0.785f}, 
				       {0.216f, 0.216f, 0.784f}, {0.217f, 0.217f, 0.783f}, {0.218f, 0.218f, 0.782f}, 
				       {0.219f, 0.219f, 0.781f}, {0.22f, 0.22f, 0.78f}, {0.221f, 0.221f, 0.779f}, 
				       {0.222f, 0.222f, 0.778f}, {0.223f, 0.223f, 0.777f}, {0.224f, 0.224f, 0.776f}, 
				       {0.225f, 0.225f, 0.775f}, {0.226f, 0.226f, 0.774f}, {0.227f, 0.227f, 0.773f}, 
				       {0.228f, 0.228f, 0.772f}, {0.229f, 0.229f, 0.771f}, {0.23f, 0.23f, 0.77f}, 
				       {0.231f, 0.231f, 0.769f}, {0.232f, 0.232f, 0.768f}, {0.233f, 0.233f, 0.767f}, 
				       {0.234f, 0.234f, 0.766f}, {0.23500000000000001f, 0.23500000000000001f, 0.765f}, 
				       {0.23600000000000002f, 0.23600000000000002f, 0.764f}, 
				       {0.23700000000000002f, 0.23700000000000002f, 0.763f}, 
				       {0.23800000000000002f, 0.23800000000000002f, 0.762f}, 
				       {0.23900000000000002f, 0.23900000000000002f, 0.761f}, {0.24f, 0.24f, 0.76f}, 
				       {0.241f, 0.241f, 0.759f}, {0.242f, 0.242f, 0.758f}, {0.243f, 0.243f, 0.757f}, 
				       {0.244f, 0.244f, 0.756f}, {0.245f, 0.245f, 0.755f}, {0.246f, 0.246f, 0.754f}, 
				       {0.247f, 0.247f, 0.753f}, {0.248f, 0.248f, 0.752f}, {0.249f, 0.249f, 0.751f}, 
				       {0.25f, 0.25f, 0.75f}, {0.251f, 0.251f, 0.749f}, {0.252f, 0.252f, 0.748f}, 
				       {0.253f, 0.253f, 0.747f}, {0.254f, 0.254f, 0.746f}, {0.255f, 0.255f, 0.745f}, 
				       {0.256f, 0.256f, 0.744f}, {0.257f, 0.257f, 0.743f}, {0.258f, 0.258f, 0.742f}, 
				       {0.259f, 0.259f, 0.741f}, {0.26f, 0.26f, 0.74f}, {0.261f, 0.261f, 0.739f}, 
				       {0.262f, 0.262f, 0.738f}, {0.263f, 0.263f, 0.737f}, {0.264f, 0.264f, 0.736f}, 
				       {0.265f, 0.265f, 0.735f}, {0.266f, 0.266f, 0.734f}, {0.267f, 0.267f, 0.733f}, 
				       {0.268f, 0.268f, 0.732f}, {0.269f, 0.269f, 0.731f}, {0.27f, 0.27f, 0.73f}, 
				       {0.271f, 0.271f, 0.729f}, {0.272f, 0.272f, 0.728f}, {0.273f, 0.273f, 0.727f}, 
				       {0.274f, 0.274f, 0.726f}, {0.275f, 0.275f, 0.725f}, {0.276f, 0.276f, 0.724f}, 
				       {0.277f, 0.277f, 0.723f}, {0.278f, 0.278f, 0.722f}, {0.279f, 0.279f, 0.721f}, 
				       {0.28f, 0.28f, 0.72f}, {0.281f, 0.281f, 0.719f}, {0.28200000000000003f, 
										   0.28200000000000003f, 0.718f}, {0.28300000000000003f, 0.28300000000000003f, 
														 0.717f}, {0.28400000000000003f, 0.28400000000000003f, 0.716f}, 
				       {0.28500000000000003f, 0.28500000000000003f, 0.715f}, 
				       {0.28600000000000003f, 0.28600000000000003f, 0.714f}, 
				       {0.28700000000000003f, 0.28700000000000003f, 0.713f}, 
				       {0.28800000000000003f, 0.28800000000000003f, 0.712f}, 
				       {0.289f, 0.289f, 0.7110000000000001f}, {0.29f, 0.29f, 0.71f}, 
				       {0.291f, 0.291f, 0.7090000000000001f}, {0.292f, 0.292f, 0.708f}, 
				       {0.293f, 0.293f, 0.7070000000000001f}, {0.294f, 0.294f, 0.706f}, 
				       {0.295f, 0.295f, 0.7050000000000001f}, {0.296f, 0.296f, 0.704f}, 
				       {0.297f, 0.297f, 0.7030000000000001f}, {0.298f, 0.298f, 0.702f}, 
				       {0.299f, 0.299f, 0.7010000000000001f}, {0.3f, 0.3f, 0.7f}, 
				       {0.301f, 0.301f, 0.6990000000000001f}, {0.302f, 0.302f, 0.698f}, 
				       {0.303f, 0.303f, 0.6970000000000001f}, {0.304f, 0.304f, 0.696f}, 
				       {0.305f, 0.305f, 0.6950000000000001f}, {0.306f, 0.306f, 0.694f}, 
				       {0.307f, 0.307f, 0.6930000000000001f}, {0.308f, 0.308f, 0.692f}, 
				       {0.309f, 0.309f, 0.6910000000000001f}, {0.31f, 0.31f, 0.69f}, 
				       {0.311f, 0.311f, 0.6890000000000001f}, {0.312f, 0.312f, 0.688f}, 
				       {0.313f, 0.313f, 0.687f}, {0.314f, 0.314f, 0.6859999999999999f}, 
				       {0.315f, 0.315f, 0.685f}, {0.316f, 0.316f, 0.6839999999999999f}, 
				       {0.317f, 0.317f, 0.683f}, {0.318f, 0.318f, 0.6819999999999999f}, 
				       {0.319f, 0.319f, 0.681f}, {0.32f, 0.32f, 0.6799999999999999f}, 
				       {0.321f, 0.321f, 0.679f}, {0.322f, 0.322f, 0.6779999999999999f}, 
				       {0.323f, 0.323f, 0.677f}, {0.324f, 0.324f, 0.6759999999999999f}, 
				       {0.325f, 0.325f, 0.675f}, {0.326f, 0.326f, 0.6739999999999999f}, 
				       {0.327f, 0.327f, 0.673f}, {0.328f, 0.328f, 0.6719999999999999f}, 
				       {0.329f, 0.329f, 0.671f}, {0.33f, 0.33f, 0.6699999999999999f}, 
				       {0.331f, 0.331f, 0.669f}, {0.332f, 0.332f, 0.6679999999999999f}, 
				       {0.333f, 0.333f, 0.667f}, {0.334f, 0.334f, 0.6659999999999999f}, 
				       {0.335f, 0.335f, 0.665f}, {0.336f, 0.336f, 0.6639999999999999f}, 
				       {0.337f, 0.337f, 0.663f}, {0.338f, 0.338f, 0.6619999999999999f}, 
				       {0.339f, 0.339f, 0.661f}, {0.34f, 0.34f, 0.6599999999999999f}, 
				       {0.341f, 0.341f, 0.659f}, {0.342f, 0.342f, 0.6579999999999999f}, 
				       {0.343f, 0.343f, 0.657f}, {0.34400000000000003f, 0.34400000000000003f, 
							       0.6559999999999999f}, {0.34500000000000003f, 0.34500000000000003f, 0.655f}, 
				       {0.34600000000000003f, 0.34600000000000003f, 0.6539999999999999f}, 
				       {0.34700000000000003f, 0.34700000000000003f, 0.653f}, 
				       {0.34800000000000003f, 0.34800000000000003f, 0.6519999999999999f}, 
				       {0.34900000000000003f, 0.34900000000000003f, 0.651f}, 
				       {0.35000000000000003f, 0.35000000000000003f, 0.6499999999999999f}, 
				       {0.35100000000000003f, 0.35100000000000003f, 0.649f}, {0.352f, 0.352f, 0.648f}, 
				       {0.353f, 0.353f, 0.647f}, {0.354f, 0.354f, 0.646f}, {0.355f, 0.355f, 0.645f}, 
				       {0.356f, 0.356f, 0.644f}, {0.357f, 0.357f, 0.643f}, {0.358f, 0.358f, 0.642f}, 
				       {0.359f, 0.359f, 0.641f}, {0.36f, 0.36f, 0.64f}, {0.361f, 0.361f, 0.639f}, 
				       {0.362f, 0.362f, 0.638f}, {0.363f, 0.363f, 0.637f}, {0.364f, 0.364f, 0.636f}, 
				       {0.365f, 0.365f, 0.635f}, {0.366f, 0.366f, 0.634f}, {0.367f, 0.367f, 0.633f}, 
				       {0.368f, 0.368f, 0.632f}, {0.369f, 0.369f, 0.631f}, {0.37f, 0.37f, 0.63f}, 
				       {0.371f, 0.371f, 0.629f}, {0.372f, 0.372f, 0.628f}, {0.373f, 0.373f, 0.627f}, 
				       {0.374f, 0.374f, 0.626f}, {0.375f, 0.375f, 0.625f}, {0.376f, 0.376f, 0.624f}, 
				       {0.377f, 0.377f, 0.623f}, {0.378f, 0.378f, 0.622f}, {0.379f, 0.379f, 0.621f}, 
				       {0.38f, 0.38f, 0.62f}, {0.381f, 0.381f, 0.619f}, {0.382f, 0.382f, 0.618f}, 
				       {0.383f, 0.383f, 0.617f}, {0.384f, 0.384f, 0.616f}, {0.385f, 0.385f, 0.615f}, 
				       {0.386f, 0.386f, 0.614f}, {0.387f, 0.387f, 0.613f}, {0.388f, 0.388f, 0.612f}, 
				       {0.389f, 0.389f, 0.611f}, {0.39f, 0.39f, 0.61f}, {0.391f, 0.391f, 0.609f}, 
				       {0.392f, 0.392f, 0.608f}, {0.393f, 0.393f, 0.607f}, {0.394f, 0.394f, 0.606f}, 
				       {0.395f, 0.395f, 0.605f}, {0.396f, 0.396f, 0.604f}, {0.397f, 0.397f, 0.603f}, 
				       {0.398f, 0.398f, 0.602f}, {0.399f, 0.399f, 0.601f}, {0.4f, 0.4f, 0.6f}, 
				       {0.401f, 0.401f, 0.599f}, {0.402f, 0.402f, 0.598f}, {0.403f, 0.403f, 0.597f}, 
				       {0.404f, 0.404f, 0.596f}, {0.405f, 0.405f, 0.595f}, {0.406f, 0.406f, 0.594f}, 
				       {0.40700000000000003f, 0.40700000000000003f, 0.593f}, 
				       {0.40800000000000003f, 0.40800000000000003f, 0.592f}, 
				       {0.40900000000000003f, 0.40900000000000003f, 0.591f}, 
				       {0.41000000000000003f, 0.41000000000000003f, 0.59f}, 
				       {0.41100000000000003f, 0.41100000000000003f, 0.589f}, 
				       {0.41200000000000003f, 0.41200000000000003f, 0.588f}, 
				       {0.41300000000000003f, 0.41300000000000003f, 0.587f}, 
				       {0.41400000000000003f, 0.41400000000000003f, 0.586f}, 
				       {0.41500000000000004f, 0.41500000000000004f, 0.585f}, 
				       {0.41600000000000004f, 0.41600000000000004f, 0.584f}, {0.417f, 0.417f, 0.583f}, 
				       {0.418f, 0.418f, 0.5820000000000001f}, {0.419f, 0.419f, 0.581f}, 
				       {0.42f, 0.42f, 0.5800000000000001f}, {0.421f, 0.421f, 0.579f}, 
				       {0.422f, 0.422f, 0.5780000000000001f}, {0.423f, 0.423f, 0.577f}, 
				       {0.424f, 0.424f, 0.5760000000000001f}, {0.425f, 0.425f, 0.575f}, 
				       {0.426f, 0.426f, 0.5740000000000001f}, {0.427f, 0.427f, 0.573f}, 
				       {0.428f, 0.428f, 0.5720000000000001f}, {0.429f, 0.429f, 0.571f}, 
				       {0.43f, 0.43f, 0.5700000000000001f}, {0.431f, 0.431f, 0.569f}, 
				       {0.432f, 0.432f, 0.5680000000000001f}, {0.433f, 0.433f, 0.567f}, 
				       {0.434f, 0.434f, 0.5660000000000001f}, {0.435f, 0.435f, 0.565f}, 
				       {0.436f, 0.436f, 0.5640000000000001f}, {0.437f, 0.437f, 0.563f}, 
				       {0.438f, 0.438f, 0.562f}, {0.439f, 0.439f, 0.5609999999999999f}, 
				       {0.44f, 0.44f, 0.56f}, {0.441f, 0.441f, 0.5589999999999999f}, 
				       {0.442f, 0.442f, 0.558f}, {0.443f, 0.443f, 0.5569999999999999f}, 
				       {0.444f, 0.444f, 0.556f}, {0.445f, 0.445f, 0.5549999999999999f}, 
				       {0.446f, 0.446f, 0.554f}, {0.447f, 0.447f, 0.5529999999999999f}, 
				       {0.448f, 0.448f, 0.552f}, {0.449f, 0.449f, 0.5509999999999999f}, 
				       {0.45f, 0.45f, 0.55f}, {0.451f, 0.451f, 0.5489999999999999f}, 
				       {0.452f, 0.452f, 0.548f}, {0.453f, 0.453f, 0.5469999999999999f}, 
				       {0.454f, 0.454f, 0.546f}, {0.455f, 0.455f, 0.5449999999999999f}, 
				       {0.456f, 0.456f, 0.544f}, {0.457f, 0.457f, 0.5429999999999999f}, 
				       {0.458f, 0.458f, 0.542f}, {0.459f, 0.459f, 0.5409999999999999f}, 
				       {0.46f, 0.46f, 0.54f}, {0.461f, 0.461f, 0.5389999999999999f}, 
				       {0.462f, 0.462f, 0.538f}, {0.463f, 0.463f, 0.5369999999999999f}, 
				       {0.464f, 0.464f, 0.536f}, {0.465f, 0.465f, 0.5349999999999999f}, 
				       {0.466f, 0.466f, 0.534f}, {0.467f, 0.467f, 0.5329999999999999f}, 
				       {0.468f, 0.468f, 0.532f}, {0.46900000000000003f, 0.46900000000000003f, 
							       0.5309999999999999f}, {0.47000000000000003f, 0.47000000000000003f, 0.53f}, 
				       {0.47100000000000003f, 0.47100000000000003f, 0.5289999999999999f}, 
				       {0.47200000000000003f, 0.47200000000000003f, 0.528f}, 
				       {0.47300000000000003f, 0.47300000000000003f, 0.5269999999999999f}, 
				       {0.47400000000000003f, 0.47400000000000003f, 0.526f}, 
				       {0.47500000000000003f, 0.47500000000000003f, 0.5249999999999999f}, 
				       {0.47600000000000003f, 0.47600000000000003f, 0.524f}, 
				       {0.47700000000000004f, 0.47700000000000004f, 0.5229999999999999f}, 
				       {0.47800000000000004f, 0.47800000000000004f, 0.522f}, 
				       {0.47900000000000004f, 0.47900000000000004f, 0.5209999999999999f}, 
				       {0.48f, 0.48f, 0.52f}, {0.481f, 0.481f, 0.519f}, {0.482f, 0.482f, 0.518f}, 
				       {0.483f, 0.483f, 0.517f}, {0.484f, 0.484f, 0.516f}, {0.485f, 0.485f, 0.515f}, 
				       {0.486f, 0.486f, 0.514f}, {0.487f, 0.487f, 0.513f}, {0.488f, 0.488f, 0.512f}, 
				       {0.489f, 0.489f, 0.511f}, {0.49f, 0.49f, 0.51f}, {0.491f, 0.491f, 0.509f}, 
				       {0.492f, 0.492f, 0.508f}, {0.493f, 0.493f, 0.507f}, {0.494f, 0.494f, 0.506f}, 
				       {0.495f, 0.495f, 0.505f}, {0.496f, 0.496f, 0.504f}, {0.497f, 0.497f, 0.503f}, 
				       {0.498f, 0.498f, 0.502f}, {0.499f, 0.499f, 0.501f}, {0.5f, 0.5f, 0.5f}, 
				       {0.501f, 0.501f, 0.499f}, {0.502f, 0.502f, 0.498f}, {0.503f, 0.503f, 0.497f}, 
				       {0.504f, 0.504f, 0.496f}, {0.505f, 0.505f, 0.495f}, {0.506f, 0.506f, 0.494f}, 
				       {0.507f, 0.507f, 0.493f}, {0.508f, 0.508f, 0.492f}, {0.509f, 0.509f, 0.491f}, 
				       {0.51f, 0.51f, 0.49f}, {0.511f, 0.511f, 0.489f}, {0.512f, 0.512f, 0.488f}, 
				       {0.513f, 0.513f, 0.487f}, {0.514f, 0.514f, 0.486f}, {0.515f, 0.515f, 0.485f}, 
				       {0.516f, 0.516f, 0.484f}, {0.517f, 0.517f, 0.483f}, {0.518f, 0.518f, 0.482f}, 
				       {0.519f, 0.519f, 0.481f}, {0.52f, 0.52f, 0.48f}, {0.521f, 0.521f, 0.479f}, 
				       {0.522f, 0.522f, 0.478f}, {0.523f, 0.523f, 0.477f}, {0.524f, 0.524f, 0.476f}, 
				       {0.525f, 0.525f, 0.475f}, {0.526f, 0.526f, 0.474f}, {0.527f, 0.527f, 0.473f}, 
				       {0.528f, 0.528f, 0.472f}, {0.529f, 0.529f, 0.471f}, {0.53f, 0.53f, 0.47f}, 
				       {0.531f, 0.531f, 0.469f}, {0.532f, 0.532f, 0.46799999999999997f}, 
				       {0.533f, 0.533f, 0.46699999999999997f}, {0.534f, 0.534f, 0.46599999999999997f}, 
				       {0.535f, 0.535f, 0.46499999999999997f}, {0.536f, 0.536f, 0.46399999999999997f}, 
				       {0.537f, 0.537f, 0.46299999999999997f}, {0.538f, 0.538f, 0.46199999999999997f}, 
				       {0.539f, 0.539f, 0.46099999999999997f}, {0.54f, 0.54f, 0.45999999999999996f}, 
				       {0.541f, 0.541f, 0.45899999999999996f}, {0.542f, 0.542f, 0.45799999999999996f}, 
				       {0.543f, 0.543f, 0.45699999999999996f}, {0.544f, 0.544f, 0.45599999999999996f}, 
				       {0.545f, 0.545f, 0.45499999999999996f}, {0.546f, 0.546f, 0.45399999999999996f}, 
				       {0.547f, 0.547f, 0.45299999999999996f}, {0.548f, 0.548f, 0.45199999999999996f}, 
				       {0.549f, 0.549f, 0.45099999999999996f}, {0.55f, 0.55f, 0.44999999999999996f}, 
				       {0.551f, 0.551f, 0.44899999999999995f}, {0.552f, 0.552f, 0.44799999999999995f}, 
				       {0.553f, 0.553f, 0.44699999999999995f}, {0.554f, 0.554f, 0.44599999999999995f}, 
				       {0.555f, 0.555f, 0.44499999999999995f}, {0.556f, 0.556f, 0.44399999999999995f}, 
				       {0.557f, 0.557f, 0.44299999999999995f}, {0.558f, 0.558f, 0.44199999999999995f}, 
				       {0.559f, 0.559f, 0.44099999999999995f}, {0.56f, 0.56f, 0.43999999999999995f}, 
				       {0.561f, 0.561f, 0.43899999999999995f}, {0.562f, 0.562f, 0.43799999999999994f}, 
				       {0.5630000000000001f, 0.5630000000000001f, 0.43699999999999994f}, 
				       {0.5640000000000001f, 0.5640000000000001f, 0.43599999999999994f}, 
				       {0.5650000000000001f, 0.5650000000000001f, 0.43499999999999994f}, 
				       {0.5660000000000001f, 0.5660000000000001f, 0.43399999999999994f}, 
				       {0.5670000000000001f, 0.5670000000000001f, 0.43299999999999994f}, 
				       {0.5680000000000001f, 0.5680000000000001f, 0.43199999999999994f}, 
				       {0.5690000000000001f, 0.5690000000000001f, 0.43099999999999994f}, 
				       {0.5700000000000001f, 0.5700000000000001f, 0.42999999999999994f}, 
				       {0.5710000000000001f, 0.5710000000000001f, 0.42899999999999994f}, 
				       {0.5720000000000001f, 0.5720000000000001f, 0.42799999999999994f}, 
				       {0.5730000000000001f, 0.5730000000000001f, 0.42699999999999994f}, 
				       {0.5740000000000001f, 0.5740000000000001f, 0.42599999999999993f}, 
				       {0.5750000000000001f, 0.5750000000000001f, 0.42499999999999993f}, 
				       {0.5760000000000001f, 0.5760000000000001f, 0.42399999999999993f}, 
				       {0.577f, 0.577f, 0.42300000000000004f}, {0.578f, 0.578f, 0.42200000000000004f}, 
				       {0.579f, 0.579f, 0.42100000000000004f}, {0.58f, 0.58f, 0.42000000000000004f}, 
				       {0.581f, 0.581f, 0.41900000000000004f}, {0.582f, 0.582f, 0.41800000000000004f}, 
				       {0.583f, 0.583f, 0.41700000000000004f}, {0.584f, 0.584f, 0.41600000000000004f}, 
				       {0.585f, 0.585f, 0.41500000000000004f}, {0.586f, 0.586f, 0.41400000000000003f}, 
				       {0.587f, 0.587f, 0.41300000000000003f}, {0.588f, 0.588f, 0.41200000000000003f}, 
				       {0.589f, 0.589f, 0.41100000000000003f}, {0.59f, 0.59f, 0.41000000000000003f}, 
				       {0.591f, 0.591f, 0.40900000000000003f}, {0.592f, 0.592f, 0.40800000000000003f}, 
				       {0.593f, 0.593f, 0.40700000000000003f}, {0.594f, 0.594f, 0.406f}, 
				       {0.595f, 0.595f, 0.405f}, {0.596f, 0.596f, 0.404f}, {0.597f, 0.597f, 0.403f}, 
				       {0.598f, 0.598f, 0.402f}, {0.599f, 0.599f, 0.401f}, {0.6f, 0.6f, 0.4f}, 
				       {0.601f, 0.601f, 0.399f}, {0.602f, 0.602f, 0.398f}, {0.603f, 0.603f, 0.397f}, 
				       {0.604f, 0.604f, 0.396f}, {0.605f, 0.605f, 0.395f}, {0.606f, 0.606f, 0.394f}, 
				       {0.607f, 0.607f, 0.393f}, {0.608f, 0.608f, 0.392f}, {0.609f, 0.609f, 0.391f}, 
				       {0.61f, 0.61f, 0.39f}, {0.611f, 0.611f, 0.389f}, {0.612f, 0.612f, 0.388f}, 
				       {0.613f, 0.613f, 0.387f}, {0.614f, 0.614f, 0.386f}, {0.615f, 0.615f, 0.385f}, 
				       {0.616f, 0.616f, 0.384f}, {0.617f, 0.617f, 0.383f}, {0.618f, 0.618f, 0.382f}, 
				       {0.619f, 0.619f, 0.381f}, {0.62f, 0.62f, 0.38f}, {0.621f, 0.621f, 0.379f}, 
				       {0.622f, 0.622f, 0.378f}, {0.623f, 0.623f, 0.377f}, {0.624f, 0.624f, 0.376f}, 
				       {0.625f, 0.625f, 0.375f}, {0.626f, 0.626f, 0.374f}, {0.627f, 0.627f, 0.373f}, 
				       {0.628f, 0.628f, 0.372f}, {0.629f, 0.629f, 0.371f}, {0.63f, 0.63f, 0.37f}, 
				       {0.631f, 0.631f, 0.369f}, {0.632f, 0.632f, 0.368f}, {0.633f, 0.633f, 0.367f}, 
				       {0.634f, 0.634f, 0.366f}, {0.635f, 0.635f, 0.365f}, {0.636f, 0.636f, 0.364f}, 
				       {0.637f, 0.637f, 0.363f}, {0.638f, 0.638f, 0.362f}, {0.639f, 0.639f, 0.361f}, 
				       {0.64f, 0.64f, 0.36f}, {0.641f, 0.641f, 0.359f}, {0.642f, 0.642f, 0.358f}, 
				       {0.643f, 0.643f, 0.357f}, {0.644f, 0.644f, 0.356f}, {0.645f, 0.645f, 0.355f}, 
				       {0.646f, 0.646f, 0.354f}, {0.647f, 0.647f, 0.353f}, {0.648f, 0.648f, 0.352f}, 
				       {0.649f, 0.649f, 0.351f}, {0.65f, 0.65f, 0.35f}, {0.651f, 0.651f, 0.349f}, 
				       {0.652f, 0.652f, 0.348f}, {0.653f, 0.653f, 0.347f}, {0.654f, 0.654f, 0.346f}, 
				       {0.655f, 0.655f, 0.345f}, {0.656f, 0.656f, 0.344f}, 
				       {0.657f, 0.657f, 0.34299999999999997f}, {0.658f, 0.658f, 0.34199999999999997f}, 
				       {0.659f, 0.659f, 0.34099999999999997f}, {0.66f, 0.66f, 0.33999999999999997f}, 
				       {0.661f, 0.661f, 0.33899999999999997f}, {0.662f, 0.662f, 0.33799999999999997f}, 
				       {0.663f, 0.663f, 0.33699999999999997f}, {0.664f, 0.664f, 0.33599999999999997f}, 
				       {0.665f, 0.665f, 0.33499999999999996f}, {0.666f, 0.666f, 0.33399999999999996f}, 
				       {0.667f, 0.667f, 0.33299999999999996f}, {0.668f, 0.668f, 0.33199999999999996f}, 
				       {0.669f, 0.669f, 0.33099999999999996f}, {0.67f, 0.67f, 0.32999999999999996f}, 
				       {0.671f, 0.671f, 0.32899999999999996f}, {0.672f, 0.672f, 0.32799999999999996f}, 
				       {0.673f, 0.673f, 0.32699999999999996f}, {0.674f, 0.674f, 0.32599999999999996f}, 
				       {0.675f, 0.675f, 0.32499999999999996f}, {0.676f, 0.676f, 0.32399999999999995f}, 
				       {0.677f, 0.677f, 0.32299999999999995f}, {0.678f, 0.678f, 0.32199999999999995f}, 
				       {0.679f, 0.679f, 0.32099999999999995f}, {0.68f, 0.68f, 0.31999999999999995f}, 
				       {0.681f, 0.681f, 0.31899999999999995f}, {0.682f, 0.682f, 0.31799999999999995f}, 
				       {0.683f, 0.683f, 0.31699999999999995f}, {0.684f, 0.684f, 0.31599999999999995f}, 
				       {0.685f, 0.685f, 0.31499999999999995f}, {0.686f, 0.686f, 0.31399999999999995f}, 
				       {0.687f, 0.687f, 0.31299999999999994f}, {0.6880000000000001f, 
									     0.6880000000000001f, 0.31199999999999994f}, 
				       {0.6890000000000001f, 0.6890000000000001f, 0.31099999999999994f}, 
				       {0.6900000000000001f, 0.6900000000000001f, 0.30999999999999994f}, 
				       {0.6910000000000001f, 0.6910000000000001f, 0.30899999999999994f}, 
				       {0.6920000000000001f, 0.6920000000000001f, 0.30799999999999994f}, 
				       {0.6930000000000001f, 0.6930000000000001f, 0.30699999999999994f}, 
				       {0.6940000000000001f, 0.6940000000000001f, 0.30599999999999994f}, 
				       {0.6950000000000001f, 0.6950000000000001f, 0.30499999999999994f}, 
				       {0.6960000000000001f, 0.6960000000000001f, 0.30399999999999994f}, 
				       {0.6970000000000001f, 0.6970000000000001f, 0.30299999999999994f}, 
				       {0.6980000000000001f, 0.6980000000000001f, 0.30199999999999994f}, 
				       {0.6990000000000001f, 0.6990000000000001f, 0.30099999999999993f}, 
				       {0.7000000000000001f, 0.7000000000000001f, 0.29999999999999993f}, 
				       {0.7010000000000001f, 0.7010000000000001f, 0.29899999999999993f}, 
				       {0.7020000000000001f, 0.7020000000000001f, 0.29799999999999993f}, 
				       {0.7030000000000001f, 0.7030000000000001f, 0.29699999999999993f}, 
				       {0.704f, 0.704f, 0.29600000000000004f}, {0.705f, 0.705f, 0.29500000000000004f}, 
				       {0.706f, 0.706f, 0.29400000000000004f}, {0.707f, 0.707f, 0.29300000000000004f}, 
				       {0.708f, 0.708f, 0.29200000000000004f}, {0.709f, 0.709f, 0.29100000000000004f}, 
				       {0.71f, 0.71f, 0.29000000000000004f}, {0.711f, 0.711f, 0.28900000000000003f}, 
				       {0.712f, 0.712f, 0.28800000000000003f}, {0.713f, 0.713f, 0.28700000000000003f}, 
				       {0.714f, 0.714f, 0.28600000000000003f}, {0.715f, 0.715f, 0.28500000000000003f}, 
				       {0.716f, 0.716f, 0.28400000000000003f}, {0.717f, 0.717f, 0.28300000000000003f}, 
				       {0.718f, 0.718f, 0.28200000000000003f}, {0.719f, 0.719f, 0.281f}, 
				       {0.72f, 0.72f, 0.28f}, {0.721f, 0.721f, 0.279f}, {0.722f, 0.722f, 0.278f}, 
				       {0.723f, 0.723f, 0.277f}, {0.724f, 0.724f, 0.276f}, {0.725f, 0.725f, 0.275f}, 
				       {0.726f, 0.726f, 0.274f}, {0.727f, 0.727f, 0.273f}, {0.728f, 0.728f, 0.272f}, 
				       {0.729f, 0.729f, 0.271f}, {0.73f, 0.73f, 0.27f}, {0.731f, 0.731f, 0.269f}, 
				       {0.732f, 0.732f, 0.268f}, {0.733f, 0.733f, 0.267f}, {0.734f, 0.734f, 0.266f}, 
				       {0.735f, 0.735f, 0.265f}, {0.736f, 0.736f, 0.264f}, {0.737f, 0.737f, 0.263f}, 
				       {0.738f, 0.738f, 0.262f}, {0.739f, 0.739f, 0.261f}, {0.74f, 0.74f, 0.26f}, 
				       {0.741f, 0.741f, 0.259f}, {0.742f, 0.742f, 0.258f}, {0.743f, 0.743f, 0.257f}, 
				       {0.744f, 0.744f, 0.256f}, {0.745f, 0.745f, 0.255f}, {0.746f, 0.746f, 0.254f}, 
				       {0.747f, 0.747f, 0.253f}, {0.748f, 0.748f, 0.252f}, {0.749f, 0.749f, 0.251f}, 
				       {0.75f, 0.75f, 0.25f}, {0.751f, 0.751f, 0.249f}, {0.752f, 0.752f, 0.248f}, 
				       {0.753f, 0.753f, 0.247f}, {0.754f, 0.754f, 0.246f}, {0.755f, 0.755f, 0.245f}, 
				       {0.756f, 0.756f, 0.244f}, {0.757f, 0.757f, 0.243f}, {0.758f, 0.758f, 0.242f}, 
				       {0.759f, 0.759f, 0.241f}, {0.76f, 0.76f, 0.24f}, {0.761f, 0.761f, 0.239f}, 
				       {0.762f, 0.762f, 0.238f}, {0.763f, 0.763f, 0.237f}, {0.764f, 0.764f, 0.236f}, 
				       {0.765f, 0.765f, 0.235f}, {0.766f, 0.766f, 0.23399999999999999f}, 
				       {0.767f, 0.767f, 0.23299999999999998f}, {0.768f, 0.768f, 0.23199999999999998f}, 
				       {0.769f, 0.769f, 0.23099999999999998f}, {0.77f, 0.77f, 0.22999999999999998f}, 
				       {0.771f, 0.771f, 0.22899999999999998f}, {0.772f, 0.772f, 0.22799999999999998f}, 
				       {0.773f, 0.773f, 0.22699999999999998f}, {0.774f, 0.774f, 0.22599999999999998f}, 
				       {0.775f, 0.775f, 0.22499999999999998f}, {0.776f, 0.776f, 0.22399999999999998f}, 
				       {0.777f, 0.777f, 0.22299999999999998f}, {0.778f, 0.778f, 0.22199999999999998f}, 
				       {0.779f, 0.779f, 0.22099999999999997f}, {0.78f, 0.78f, 0.21999999999999997f}, 
				       {0.781f, 0.781f, 0.21899999999999997f}, {0.782f, 0.782f, 0.21799999999999997f}, 
				       {0.783f, 0.783f, 0.21699999999999997f}, {0.784f, 0.784f, 0.21599999999999997f}, 
				       {0.785f, 0.785f, 0.21499999999999997f}, {0.786f, 0.786f, 0.21399999999999997f}, 
				       {0.787f, 0.787f, 0.21299999999999997f}, {0.788f, 0.788f, 0.21199999999999997f}, 
				       {0.789f, 0.789f, 0.21099999999999997f}, {0.79f, 0.79f, 0.20999999999999996f}, 
				       {0.791f, 0.791f, 0.20899999999999996f}, {0.792f, 0.792f, 0.20799999999999996f}, 
				       {0.793f, 0.793f, 0.20699999999999996f}, {0.794f, 0.794f, 0.20599999999999996f}, 
				       {0.795f, 0.795f, 0.20499999999999996f}, {0.796f, 0.796f, 0.20399999999999996f}, 
				       {0.797f, 0.797f, 0.20299999999999996f}, {0.798f, 0.798f, 0.20199999999999996f}, 
				       {0.799f, 0.799f, 0.20099999999999996f}, {0.8f, 0.8f, 0.19999999999999996f}, 
				       {0.801f, 0.801f, 0.19899999999999995f}, {0.802f, 0.802f, 0.19799999999999995f}, 
				       {0.803f, 0.803f, 0.19699999999999995f}, {0.804f, 0.804f, 0.19599999999999995f}, 
				       {0.805f, 0.805f, 0.19499999999999995f}, {0.806f, 0.806f, 0.19399999999999995f}, 
				       {0.807f, 0.807f, 0.19299999999999995f}, {0.808f, 0.808f, 0.19199999999999995f}, 
				       {0.809f, 0.809f, 0.19099999999999995f}, {0.81f, 0.81f, 0.18999999999999995f}, 
				       {0.811f, 0.811f, 0.18899999999999995f}, {0.812f, 0.812f, 0.18799999999999994f}, 
				       {0.8130000000000001f, 0.8130000000000001f, 0.18699999999999994f}, 
				       {0.8140000000000001f, 0.8140000000000001f, 0.18599999999999994f}, 
				       {0.8150000000000001f, 0.8150000000000001f, 0.18499999999999994f}, 
				       {0.8160000000000001f, 0.8160000000000001f, 0.18399999999999994f}, 
				       {0.8170000000000001f, 0.8170000000000001f, 0.18299999999999994f}, 
				       {0.8180000000000001f, 0.8180000000000001f, 0.18199999999999994f}, 
				       {0.8190000000000001f, 0.8190000000000001f, 0.18099999999999994f}, 
				       {0.8200000000000001f, 0.8200000000000001f, 0.17999999999999994f}, 
				       {0.8210000000000001f, 0.8210000000000001f, 0.17899999999999994f}, 
				       {0.8220000000000001f, 0.8220000000000001f, 0.17799999999999994f}, 
				       {0.8230000000000001f, 0.8230000000000001f, 0.17699999999999994f}, 
				       {0.8240000000000001f, 0.8240000000000001f, 0.17599999999999993f}, 
				       {0.8250000000000001f, 0.8250000000000001f, 0.17499999999999993f}, 
				       {0.8260000000000001f, 0.8260000000000001f, 0.17399999999999993f}, 
				       {0.8270000000000001f, 0.8270000000000001f, 0.17299999999999993f}, 
				       {0.8280000000000001f, 0.8280000000000001f, 0.17199999999999993f}, 
				       {0.8290000000000001f, 0.8290000000000001f, 0.17099999999999993f}, 
				       {0.8300000000000001f, 0.8300000000000001f, 0.16999999999999993f}, 
				       {0.8310000000000001f, 0.8310000000000001f, 0.16899999999999993f}, 
				       {0.8320000000000001f, 0.8320000000000001f, 0.16799999999999993f}, 
				       {0.833f, 0.833f, 0.16700000000000004f}, {0.834f, 0.834f, 0.16600000000000004f}, 
				       {0.835f, 0.835f, 0.16500000000000004f}, {0.836f, 0.836f, 0.16400000000000003f}, 
				       {0.837f, 0.837f, 0.16300000000000003f}, {0.838f, 0.838f, 0.16200000000000003f}, 
				       {0.839f, 0.839f, 0.16100000000000003f}, {0.84f, 0.84f, 0.16000000000000003f}, 
				       {0.841f, 0.841f, 0.15900000000000003f}, {0.842f, 0.842f, 0.15800000000000003f}, 
				       {0.843f, 0.843f, 0.15700000000000003f}, {0.844f, 0.844f, 0.15600000000000003f}, 
				       {0.845f, 0.845f, 0.15500000000000003f}, {0.846f, 0.846f, 0.15400000000000003f}, 
				       {0.847f, 0.847f, 0.15300000000000002f}, {0.848f, 0.848f, 0.15200000000000002f}, 
				       {0.849f, 0.849f, 0.15100000000000002f}, {0.85f, 0.85f, 0.15000000000000002f}, 
				       {0.851f, 0.851f, 0.14900000000000002f}, {0.852f, 0.852f, 0.14800000000000002f}, 
				       {0.853f, 0.853f, 0.14700000000000002f}, {0.854f, 0.854f, 0.14600000000000002f}, 
				       {0.855f, 0.855f, 0.14500000000000002f}, {0.856f, 0.856f, 0.14400000000000002f}, 
				       {0.857f, 0.857f, 0.14300000000000002f}, {0.858f, 0.858f, 0.14200000000000002f}, 
				       {0.859f, 0.859f, 0.14100000000000001f}, {0.86f, 0.86f, 0.14f}, 
				       {0.861f, 0.861f, 0.139f}, {0.862f, 0.862f, 0.138f}, {0.863f, 0.863f, 0.137f}, 
				       {0.864f, 0.864f, 0.136f}, {0.865f, 0.865f, 0.135f}, {0.866f, 0.866f, 0.134f}, 
				       {0.867f, 0.867f, 0.133f}, {0.868f, 0.868f, 0.132f}, {0.869f, 0.869f, 0.131f}, 
				       {0.87f, 0.87f, 0.13f}, {0.871f, 0.871f, 0.129f}, {0.872f, 0.872f, 0.128f}, 
				       {0.873f, 0.873f, 0.127f}, {0.874f, 0.874f, 0.126f}, {0.875f, 0.875f, 0.125f}, 
				       {0.876f, 0.876f, 0.124f}, {0.877f, 0.877f, 0.123f}, {0.878f, 0.878f, 0.122f}, 
				       {0.879f, 0.879f, 0.121f}, {0.88f, 0.88f, 0.12f}, {0.881f, 0.881f, 0.119f}, 
				       {0.882f, 0.882f, 0.118f}, {0.883f, 0.883f, 0.11699999999999999f}, 
				       {0.884f, 0.884f, 0.11599999999999999f}, {0.885f, 0.885f, 0.11499999999999999f}, 
				       {0.886f, 0.886f, 0.11399999999999999f}, {0.887f, 0.887f, 0.11299999999999999f}, 
				       {0.888f, 0.888f, 0.11199999999999999f}, {0.889f, 0.889f, 0.11099999999999999f}, 
				       {0.89f, 0.89f, 0.10999999999999999f}, {0.891f, 0.891f, 0.10899999999999999f}, 
				       {0.892f, 0.892f, 0.10799999999999998f}, {0.893f, 0.893f, 0.10699999999999998f}, 
				       {0.894f, 0.894f, 0.10599999999999998f}, {0.895f, 0.895f, 0.10499999999999998f}, 
				       {0.896f, 0.896f, 0.10399999999999998f}, {0.897f, 0.897f, 0.10299999999999998f}, 
				       {0.898f, 0.898f, 0.10199999999999998f}, {0.899f, 0.899f, 0.10099999999999998f}, 
				       {0.9f, 0.9f, 0.09999999999999998f}, {0.901f, 0.901f, 0.09899999999999998f}, 
				       {0.902f, 0.902f, 0.09799999999999998f}, {0.903f, 0.903f, 0.09699999999999998f}, 
				       {0.904f, 0.904f, 0.09599999999999997f}, {0.905f, 0.905f, 0.09499999999999997f}, 
				       {0.906f, 0.906f, 0.09399999999999997f}, {0.907f, 0.907f, 0.09299999999999997f}, 
				       {0.908f, 0.908f, 0.09199999999999997f}, {0.909f, 0.909f, 0.09099999999999997f}, 
				       {0.91f, 0.91f, 0.08999999999999997f}, {0.911f, 0.911f, 0.08899999999999997f}, 
				       {0.912f, 0.912f, 0.08799999999999997f}, {0.913f, 0.913f, 0.08699999999999997f}, 
				       {0.914f, 0.914f, 0.08599999999999997f}, {0.915f, 0.915f, 0.08499999999999996f}, 
				       {0.916f, 0.916f, 0.08399999999999996f}, {0.917f, 0.917f, 0.08299999999999996f}, 
				       {0.918f, 0.918f, 0.08199999999999996f}, {0.919f, 0.919f, 0.08099999999999996f}, 
				       {0.92f, 0.92f, 0.07999999999999996f}, {0.921f, 0.921f, 0.07899999999999996f}, 
				       {0.922f, 0.922f, 0.07799999999999996f}, {0.923f, 0.923f, 0.07699999999999996f}, 
				       {0.924f, 0.924f, 0.07599999999999996f}, {0.925f, 0.925f, 0.07499999999999996f}, 
				       {0.926f, 0.926f, 0.07399999999999995f}, {0.927f, 0.927f, 0.07299999999999995f}, 
				       {0.928f, 0.928f, 0.07199999999999995f}, {0.929f, 0.929f, 0.07099999999999995f}, 
				       {0.93f, 0.93f, 0.06999999999999995f}, {0.931f, 0.931f, 0.06899999999999995f}, 
				       {0.932f, 0.932f, 0.06799999999999995f}, {0.933f, 0.933f, 0.06699999999999995f}, 
				       {0.934f, 0.934f, 0.06599999999999995f}, {0.935f, 0.935f, 0.06499999999999995f}, 
				       {0.936f, 0.936f, 0.06399999999999995f}, {0.937f, 0.937f, 0.06299999999999994f}, 
				       {0.9380000000000001f, 0.9380000000000001f, 0.061999999999999944f}, 
				       {0.9390000000000001f, 0.9390000000000001f, 0.06099999999999994f}, 
				       {0.9400000000000001f, 0.9400000000000001f, 0.05999999999999994f}, 
				       {0.9410000000000001f, 0.9410000000000001f, 0.05899999999999994f}, 
				       {0.9420000000000001f, 0.9420000000000001f, 0.05799999999999994f}, 
				       {0.9430000000000001f, 0.9430000000000001f, 0.05699999999999994f}, 
				       {0.9440000000000001f, 0.9440000000000001f, 0.05599999999999994f}, 
				       {0.9450000000000001f, 0.9450000000000001f, 0.05499999999999994f}, 
				       {0.9460000000000001f, 0.9460000000000001f, 0.05399999999999994f}, 
				       {0.9470000000000001f, 0.9470000000000001f, 0.052999999999999936f}, 
				       {0.9480000000000001f, 0.9480000000000001f, 0.051999999999999935f}, 
				       {0.9490000000000001f, 0.9490000000000001f, 0.050999999999999934f}, 
				       {0.9500000000000001f, 0.9500000000000001f, 0.04999999999999993f}, 
				       {0.9510000000000001f, 0.9510000000000001f, 0.04899999999999993f}, 
				       {0.9520000000000001f, 0.9520000000000001f, 0.04799999999999993f}, 
				       {0.9530000000000001f, 0.9530000000000001f, 0.04699999999999993f}, 
				       {0.9540000000000001f, 0.9540000000000001f, 0.04599999999999993f}, 
				       {0.9550000000000001f, 0.9550000000000001f, 0.04499999999999993f}, 
				       {0.9560000000000001f, 0.9560000000000001f, 0.04399999999999993f}, 
				       {0.9570000000000001f, 0.9570000000000001f, 0.04299999999999993f}, 
				       {0.9580000000000001f, 0.9580000000000001f, 0.041999999999999926f}, 
				       {0.9590000000000001f, 0.9590000000000001f, 0.040999999999999925f}, 
				       {0.96f, 0.96f, 0.040000000000000036f}, {0.961f, 0.961f, 0.039000000000000035f}, 
				       {0.962f, 0.962f, 0.038000000000000034f}, {0.963f, 0.963f, 0.03700000000000003f}, 
				       {0.964f, 0.964f, 0.03600000000000003f}, {0.965f, 0.965f, 0.03500000000000003f}, 
				       {0.966f, 0.966f, 0.03400000000000003f}, {0.967f, 0.967f, 0.03300000000000003f}, 
				       {0.968f, 0.968f, 0.03200000000000003f}, {0.969f, 0.969f, 0.031000000000000028f}, 
				       {0.97f, 0.97f, 0.030000000000000027f}, {0.971f, 0.971f, 0.029000000000000026f}, 
				       {0.972f, 0.972f, 0.028000000000000025f}, {0.973f, 0.973f, 0.027000000000000024f}, 
				       {0.974f, 0.974f, 0.026000000000000023f}, {0.975f, 0.975f, 0.025000000000000022f}, 
				       {0.976f, 0.976f, 0.02400000000000002f}, {0.977f, 0.977f, 0.02300000000000002f}, 
				       {0.978f, 0.978f, 0.02200000000000002f}, {0.979f, 0.979f, 0.02100000000000002f}, 
				       {0.98f, 0.98f, 0.020000000000000018f}, {0.981f, 0.981f, 0.019000000000000017f}, 
				       {0.982f, 0.982f, 0.018000000000000016f}, {0.983f, 0.983f, 0.017000000000000015f}, 
				       {0.984f, 0.984f, 0.016000000000000014f}, {0.985f, 0.985f, 0.015000000000000013f}, 
				       {0.986f, 0.986f, 0.014000000000000012f}, {0.987f, 0.987f, 0.013000000000000012f}, 
				       {0.988f, 0.988f, 0.01200000000000001f}, {0.989f, 0.989f, 0.01100000000000001f}, 
				       {0.99f, 0.99f, 0.010000000000000009f}, {0.991f, 0.991f, 0.009000000000000008f}, 
				       {0.992f, 0.992f, 0.008000000000000007f}, {0.993f, 0.993f, 0.007000000000000006f}, 
				       {0.994f, 0.994f, 0.006000000000000005f}, {0.995f, 0.995f, 0.0050000000000000044f}, 
				       {0.996f, 0.996f, 0.0040000000000000036f}, 
				       {0.997f, 0.997f, 0.0030000000000000027f}, 
				       {0.998f, 0.998f, 0.0020000000000000018f}, 
				       {0.999f, 0.999f, 0.0010000000000000009f}, {1.f, 1.f, 0.f}};






float palette_grey_to_red[1001][3]={{0.99f, 0.99f, 0.99f}, {0.99001f, 0.98901f, 0.98901f}, 
				    {0.99002f, 0.98802f, 0.98802f}, {0.99003f, 0.98703f, 0.98703f}, 
				    {0.99004f, 0.98604f, 0.98604f}, {0.99005f, 0.98505f, 0.98505f}, 
				    {0.9900599999999999f, 0.98406f, 0.98406f}, {0.99007f, 0.98307f, 0.98307f}, 
				    {0.99008f, 0.98208f, 0.98208f}, {0.99009f, 0.98109f, 0.98109f}, 
				    {0.9901f, 0.9801f, 0.9801f}, {0.99011f, 0.97911f, 0.97911f}, 
				    {0.99012f, 0.97812f, 0.97812f}, {0.99013f, 0.9771299999999999f, 
								  0.9771299999999999f}, {0.99014f, 0.97614f, 0.97614f}, 
				    {0.99015f, 0.97515f, 0.97515f}, {0.99016f, 0.97416f, 0.97416f}, 
				    {0.99017f, 0.97317f, 0.97317f}, {0.99018f, 0.97218f, 0.97218f}, 
				    {0.99019f, 0.97119f, 0.97119f}, {0.9902f, 0.9702f, 0.9702f}, 
				    {0.99021f, 0.96921f, 0.96921f}, {0.99022f, 0.96822f, 0.96822f}, 
				    {0.9902299999999999f, 0.96723f, 0.96723f}, {0.99024f, 0.96624f, 0.96624f}, 
				    {0.99025f, 0.9652499999999999f, 0.9652499999999999f}, 
				    {0.99026f, 0.96426f, 0.96426f}, {0.99027f, 0.96327f, 0.96327f}, 
				    {0.9902799999999999f, 0.96228f, 0.96228f}, {0.99029f, 0.96129f, 0.96129f}, 
				    {0.9903f, 0.9603f, 0.9603f}, {0.99031f, 0.95931f, 0.95931f}, 
				    {0.99032f, 0.95832f, 0.95832f}, {0.99033f, 0.95733f, 0.95733f}, 
				    {0.99034f, 0.95634f, 0.95634f}, {0.99035f, 0.95535f, 0.95535f}, 
				    {0.99036f, 0.95436f, 0.95436f}, {0.99037f, 0.95337f, 0.95337f}, 
				    {0.99038f, 0.95238f, 0.95238f}, {0.99039f, 0.95139f, 0.95139f}, 
				    {0.9904f, 0.9504f, 0.9504f}, {0.99041f, 0.94941f, 0.94941f}, 
				    {0.99042f, 0.94842f, 0.94842f}, {0.99043f, 0.94743f, 0.94743f}, 
				    {0.99044f, 0.94644f, 0.94644f}, {0.9904499999999999f, 0.94545f, 0.94545f}, 
				    {0.99046f, 0.94446f, 0.94446f}, {0.99047f, 0.94347f, 0.94347f}, 
				    {0.99048f, 0.94248f, 0.94248f}, {0.99049f, 0.9414899999999999f, 
								  0.9414899999999999f}, {0.9904999999999999f, 0.9405f, 0.9405f}, 
				    {0.99051f, 0.93951f, 0.93951f}, {0.99052f, 0.93852f, 0.93852f}, 
				    {0.99053f, 0.93753f, 0.93753f}, {0.99054f, 0.93654f, 0.93654f}, 
				    {0.99055f, 0.93555f, 0.93555f}, {0.99056f, 0.93456f, 0.93456f}, 
				    {0.99057f, 0.93357f, 0.93357f}, {0.99058f, 0.93258f, 0.93258f}, 
				    {0.99059f, 0.93159f, 0.93159f}, {0.9906f, 0.9306f, 0.9306f}, 
				    {0.99061f, 0.92961f, 0.92961f}, {0.99062f, 0.92862f, 0.92862f}, 
				    {0.99063f, 0.92763f, 0.92763f}, {0.99064f, 0.92664f, 0.92664f}, 
				    {0.99065f, 0.92565f, 0.92565f}, {0.99066f, 0.92466f, 0.92466f}, 
				    {0.9906699999999999f, 0.92367f, 0.92367f}, {0.99068f, 0.92268f, 0.92268f}, 
				    {0.99069f, 0.92169f, 0.92169f}, {0.9907f, 0.9207f, 0.9207f}, 
				    {0.99071f, 0.91971f, 0.91971f}, {0.99072f, 0.91872f, 0.91872f}, 
				    {0.99073f, 0.9177299999999999f, 0.9177299999999999f}, 
				    {0.99074f, 0.91674f, 0.91674f}, {0.99075f, 0.91575f, 0.91575f}, 
				    {0.99076f, 0.91476f, 0.91476f}, {0.99077f, 0.91377f, 0.91377f}, 
				    {0.99078f, 0.91278f, 0.91278f}, {0.99079f, 0.91179f, 0.91179f}, 
				    {0.9908f, 0.9107999999999999f, 0.9107999999999999f}, 
				    {0.99081f, 0.90981f, 0.90981f}, {0.99082f, 0.90882f, 0.90882f}, 
				    {0.99083f, 0.90783f, 0.90783f}, {0.9908399999999999f, 0.90684f, 0.90684f}, 
				    {0.99085f, 0.90585f, 0.90585f}, {0.99086f, 0.90486f, 0.90486f}, 
				    {0.99087f, 0.90387f, 0.90387f}, {0.99088f, 0.90288f, 0.90288f}, 
				    {0.9908899999999999f, 0.90189f, 0.90189f}, {0.9909f, 0.9009f, 0.9009f}, 
				    {0.99091f, 0.89991f, 0.89991f}, {0.99092f, 0.8989199999999999f, 
								  0.8989199999999999f}, {0.99093f, 0.89793f, 0.89793f}, 
				    {0.99094f, 0.89694f, 0.89694f}, {0.99095f, 0.89595f, 0.89595f}, 
				    {0.99096f, 0.89496f, 0.89496f}, {0.99097f, 0.8939699999999999f, 
								  0.8939699999999999f}, {0.99098f, 0.89298f, 0.89298f}, 
				    {0.99099f, 0.89199f, 0.89199f}, {0.991f, 0.891f, 0.891f}, 
				    {0.99101f, 0.89001f, 0.89001f}, {0.99102f, 0.88902f, 0.88902f}, 
				    {0.99103f, 0.88803f, 0.88803f}, {0.99104f, 0.8870399999999999f, 
								  0.8870399999999999f}, {0.99105f, 0.88605f, 0.88605f}, 
				    {0.9910599999999999f, 0.88506f, 0.88506f}, {0.99107f, 0.88407f, 0.88407f}, 
				    {0.99108f, 0.88308f, 0.88308f}, {0.99109f, 0.88209f, 0.88209f}, 
				    {0.9911f, 0.8811f, 0.8811f}, {0.99111f, 0.88011f, 0.88011f}, 
				    {0.99112f, 0.87912f, 0.87912f}, {0.99113f, 0.87813f, 0.87813f}, 
				    {0.99114f, 0.87714f, 0.87714f}, {0.99115f, 0.87615f, 0.87615f}, 
				    {0.99116f, 0.8751599999999999f, 0.8751599999999999f}, 
				    {0.99117f, 0.87417f, 0.87417f}, {0.99118f, 0.87318f, 0.87318f}, 
				    {0.99119f, 0.87219f, 0.87219f}, {0.9912f, 0.8712f, 0.8712f}, 
				    {0.99121f, 0.87021f, 0.87021f}, {0.99122f, 0.86922f, 0.86922f}, 
				    {0.9912299999999999f, 0.86823f, 0.86823f}, {0.99124f, 0.86724f, 0.86724f}, 
				    {0.99125f, 0.86625f, 0.86625f}, {0.99126f, 0.86526f, 0.86526f}, 
				    {0.99127f, 0.86427f, 0.86427f}, {0.9912799999999999f, 0.86328f, 0.86328f}, 
				    {0.99129f, 0.86229f, 0.86229f}, {0.9913f, 0.8613f, 0.8613f}, 
				    {0.99131f, 0.86031f, 0.86031f}, {0.99132f, 0.85932f, 0.85932f}, 
				    {0.99133f, 0.85833f, 0.85833f}, {0.99134f, 0.85734f, 0.85734f}, 
				    {0.99135f, 0.85635f, 0.85635f}, {0.99136f, 0.85536f, 0.85536f}, 
				    {0.99137f, 0.85437f, 0.85437f}, {0.99138f, 0.85338f, 0.85338f}, 
				    {0.99139f, 0.85239f, 0.85239f}, {0.9914f, 0.8513999999999999f, 
								  0.8513999999999999f}, {0.99141f, 0.85041f, 0.85041f}, 
				    {0.99142f, 0.84942f, 0.84942f}, {0.99143f, 0.84843f, 0.84843f}, 
				    {0.99144f, 0.84744f, 0.84744f}, {0.9914499999999999f, 0.84645f, 0.84645f}, 
				    {0.99146f, 0.84546f, 0.84546f}, {0.99147f, 0.84447f, 0.84447f}, 
				    {0.99148f, 0.84348f, 0.84348f}, {0.99149f, 0.84249f, 0.84249f}, 
				    {0.9915f, 0.8415f, 0.8415f}, {0.99151f, 0.84051f, 0.84051f}, 
				    {0.99152f, 0.83952f, 0.83952f}, {0.99153f, 0.83853f, 0.83853f}, 
				    {0.99154f, 0.83754f, 0.83754f}, {0.99155f, 0.83655f, 0.83655f}, 
				    {0.99156f, 0.83556f, 0.83556f}, {0.99157f, 0.83457f, 0.83457f}, 
				    {0.99158f, 0.83358f, 0.83358f}, {0.99159f, 0.8325899999999999f, 
								  0.8325899999999999f}, {0.9916f, 0.8316f, 0.8316f}, {0.99161f, 0.83061f, 0.83061f}, 
				    {0.99162f, 0.82962f, 0.82962f}, {0.99163f, 0.82863f, 0.82863f}, 
				    {0.99164f, 0.8276399999999999f, 0.8276399999999999f}, 
				    {0.99165f, 0.82665f, 0.82665f}, {0.99166f, 0.82566f, 0.82566f}, 
				    {0.9916699999999999f, 0.82467f, 0.82467f}, {0.99168f, 0.82368f, 0.82368f}, 
				    {0.99169f, 0.8226899999999999f, 0.8226899999999999f}, {0.9917f, 0.8217f, 0.8217f}, 
				    {0.99171f, 0.8207099999999999f, 0.8207099999999999f}, 
				    {0.99172f, 0.81972f, 0.81972f}, {0.99173f, 0.81873f, 0.81873f}, 
				    {0.99174f, 0.8177399999999999f, 0.8177399999999999f}, 
				    {0.99175f, 0.81675f, 0.81675f}, {0.99176f, 0.81576f, 0.81576f}, 
				    {0.99177f, 0.81477f, 0.81477f}, {0.99178f, 0.81378f, 0.81378f}, 
				    {0.99179f, 0.81279f, 0.81279f}, {0.9918f, 0.8118f, 0.8118f}, 
				    {0.99181f, 0.81081f, 0.81081f}, {0.99182f, 0.80982f, 0.80982f}, 
				    {0.99183f, 0.8088299999999999f, 0.8088299999999999f}, 
				    {0.9918399999999999f, 0.80784f, 0.80784f}, {0.99185f, 0.80685f, 0.80685f}, 
				    {0.99186f, 0.80586f, 0.80586f}, {0.99187f, 0.80487f, 0.80487f}, 
				    {0.99188f, 0.8038799999999999f, 0.8038799999999999f}, 
				    {0.9918899999999999f, 0.80289f, 0.80289f}, {0.9919f, 0.8019000000000001f, 
									     0.8019000000000001f}, {0.99191f, 0.80091f, 0.80091f}, 
				    {0.99192f, 0.79992f, 0.79992f}, {0.99193f, 0.79893f, 0.79893f}, 
				    {0.99194f, 0.79794f, 0.79794f}, {0.99195f, 0.79695f, 0.79695f}, 
				    {0.99196f, 0.79596f, 0.79596f}, {0.99197f, 0.79497f, 0.79497f}, 
				    {0.99198f, 0.79398f, 0.79398f}, {0.99199f, 0.79299f, 0.79299f}, 
				    {0.992f, 0.792f, 0.792f}, {0.99201f, 0.79101f, 0.79101f}, 
				    {0.99202f, 0.79002f, 0.79002f}, {0.99203f, 0.78903f, 0.78903f}, 
				    {0.99204f, 0.78804f, 0.78804f}, {0.99205f, 0.78705f, 0.78705f}, 
				    {0.9920599999999999f, 0.78606f, 0.78606f}, {0.99207f, 0.7850699999999999f, 
									     0.7850699999999999f}, {0.99208f, 0.78408f, 0.78408f}, 
				    {0.99209f, 0.7830900000000001f, 0.7830900000000001f}, {0.9921f, 0.7821f, 0.7821f}, 
				    {0.99211f, 0.78111f, 0.78111f}, {0.99212f, 0.78012f, 0.78012f}, 
				    {0.99213f, 0.77913f, 0.77913f}, {0.99214f, 0.77814f, 0.77814f}, 
				    {0.99215f, 0.77715f, 0.77715f}, {0.99216f, 0.77616f, 0.77616f}, 
				    {0.99217f, 0.77517f, 0.77517f}, {0.99218f, 0.77418f, 0.77418f}, 
				    {0.99219f, 0.77319f, 0.77319f}, {0.9922f, 0.7722f, 0.7722f}, 
				    {0.99221f, 0.77121f, 0.77121f}, {0.99222f, 0.77022f, 0.77022f}, 
				    {0.99223f, 0.76923f, 0.76923f}, {0.99224f, 0.76824f, 0.76824f}, 
				    {0.99225f, 0.76725f, 0.76725f}, {0.99226f, 0.7662599999999999f, 
								  0.7662599999999999f}, {0.99227f, 0.76527f, 0.76527f}, 
				    {0.9922799999999999f, 0.76428f, 0.76428f}, {0.99229f, 0.76329f, 0.76329f}, 
				    {0.9923f, 0.7623f, 0.7623f}, {0.99231f, 0.7613099999999999f, 0.7613099999999999f}, 
				    {0.99232f, 0.76032f, 0.76032f}, {0.99233f, 0.75933f, 0.75933f}, 
				    {0.99234f, 0.75834f, 0.75834f}, {0.99235f, 0.75735f, 0.75735f}, 
				    {0.99236f, 0.7563599999999999f, 0.7563599999999999f}, 
				    {0.99237f, 0.75537f, 0.75537f}, {0.99238f, 0.7543799999999999f, 
								  0.7543799999999999f}, {0.99239f, 0.75339f, 0.75339f}, {0.9924f, 0.7524f, 0.7524f}, 
				    {0.99241f, 0.75141f, 0.75141f}, {0.99242f, 0.75042f, 0.75042f}, 
				    {0.99243f, 0.74943f, 0.74943f}, {0.99244f, 0.74844f, 0.74844f}, 
				    {0.9924499999999999f, 0.74745f, 0.74745f}, {0.99246f, 0.74646f, 0.74646f}, 
				    {0.99247f, 0.74547f, 0.74547f}, {0.99248f, 0.74448f, 0.74448f}, 
				    {0.99249f, 0.74349f, 0.74349f}, {0.9924999999999999f, 0.7424999999999999f, 
								  0.7424999999999999f}, {0.99251f, 0.74151f, 0.74151f}, 
				    {0.99252f, 0.74052f, 0.74052f}, {0.99253f, 0.73953f, 0.73953f}, 
				    {0.99254f, 0.73854f, 0.73854f}, {0.99255f, 0.7375499999999999f, 
								  0.7375499999999999f}, {0.99256f, 0.73656f, 0.73656f}, 
				    {0.99257f, 0.7355700000000001f, 0.7355700000000001f}, 
				    {0.99258f, 0.73458f, 0.73458f}, {0.99259f, 0.73359f, 0.73359f}, 
				    {0.9926f, 0.7325999999999999f, 0.7325999999999999f}, 
				    {0.99261f, 0.73161f, 0.73161f}, {0.99262f, 0.73062f, 0.73062f}, 
				    {0.99263f, 0.72963f, 0.72963f}, {0.99264f, 0.72864f, 0.72864f}, 
				    {0.99265f, 0.7276499999999999f, 0.7276499999999999f}, 
				    {0.99266f, 0.72666f, 0.72666f}, {0.9926699999999999f, 0.72567f, 0.72567f}, 
				    {0.99268f, 0.72468f, 0.72468f}, {0.99269f, 0.7236899999999999f, 
								  0.7236899999999999f}, {0.9927f, 0.7226999999999999f, 0.7226999999999999f}, 
				    {0.99271f, 0.72171f, 0.72171f}, {0.99272f, 0.72072f, 0.72072f}, 
				    {0.99273f, 0.71973f, 0.71973f}, {0.99274f, 0.7187399999999999f, 
								  0.7187399999999999f}, {0.99275f, 0.71775f, 0.71775f}, 
				    {0.99276f, 0.71676f, 0.71676f}, {0.99277f, 0.71577f, 0.71577f}, 
				    {0.99278f, 0.71478f, 0.71478f}, {0.99279f, 0.7137899999999999f, 
								  0.7137899999999999f}, {0.9928f, 0.7128f, 0.7128f}, 
				    {0.99281f, 0.7118099999999999f, 0.7118099999999999f}, 
				    {0.99282f, 0.71082f, 0.71082f}, {0.99283f, 0.70983f, 0.70983f}, 
				    {0.99284f, 0.7088399999999999f, 0.7088399999999999f}, 
				    {0.99285f, 0.70785f, 0.70785f}, {0.99286f, 0.70686f, 0.70686f}, 
				    {0.99287f, 0.70587f, 0.70587f}, {0.99288f, 0.70488f, 0.70488f}, 
				    {0.9928899999999999f, 0.70389f, 0.70389f}, {0.9929f, 0.7029000000000001f, 
									     0.7029000000000001f}, {0.99291f, 0.70191f, 0.70191f}, 
				    {0.99292f, 0.70092f, 0.70092f}, {0.99293f, 0.6999299999999999f, 
								  0.6999299999999999f}, {0.99294f, 0.69894f, 0.69894f}, 
				    {0.99295f, 0.6979500000000001f, 0.6979500000000001f}, 
				    {0.99296f, 0.69696f, 0.69696f}, {0.99297f, 0.69597f, 0.69597f}, 
				    {0.99298f, 0.6949799999999999f, 0.6949799999999999f}, 
				    {0.99299f, 0.69399f, 0.69399f}, {0.993f, 0.6930000000000001f, 
								  0.6930000000000001f}, {0.99301f, 0.69201f, 0.69201f}, 
				    {0.99302f, 0.69102f, 0.69102f}, {0.99303f, 0.6900299999999999f, 
								  0.6900299999999999f}, {0.99304f, 0.68904f, 0.68904f}, 
				    {0.99305f, 0.68805f, 0.68805f}, {0.9930599999999999f, 0.68706f, 0.68706f}, 
				    {0.99307f, 0.68607f, 0.68607f}, {0.99308f, 0.68508f, 0.68508f}, 
				    {0.99309f, 0.68409f, 0.68409f}, {0.9931f, 0.6831f, 0.6831f}, 
				    {0.99311f, 0.68211f, 0.68211f}, {0.99312f, 0.68112f, 0.68112f}, 
				    {0.99313f, 0.68013f, 0.68013f}, {0.99314f, 0.67914f, 0.67914f}, 
				    {0.99315f, 0.67815f, 0.67815f}, {0.99316f, 0.67716f, 0.67716f}, 
				    {0.99317f, 0.6761699999999999f, 0.6761699999999999f}, 
				    {0.99318f, 0.67518f, 0.67518f}, {0.99319f, 0.6741900000000001f, 
								  0.6741900000000001f}, {0.9932f, 0.6732f, 0.6732f}, {0.99321f, 0.67221f, 0.67221f}, 
				    {0.99322f, 0.6712199999999999f, 0.6712199999999999f}, 
				    {0.99323f, 0.67023f, 0.67023f}, {0.99324f, 0.6692400000000001f, 
								  0.6692400000000001f}, {0.99325f, 0.66825f, 0.66825f}, 
				    {0.99326f, 0.66726f, 0.66726f}, {0.99327f, 0.6662699999999999f, 
								  0.6662699999999999f}, {0.9932799999999999f, 0.66528f, 0.66528f}, 
				    {0.99329f, 0.66429f, 0.66429f}, {0.9933f, 0.6633f, 0.6633f}, 
				    {0.99331f, 0.66231f, 0.66231f}, {0.99332f, 0.6613199999999999f, 
								  0.6613199999999999f}, {0.99333f, 0.66033f, 0.66033f}, 
				    {0.99334f, 0.65934f, 0.65934f}, {0.99335f, 0.65835f, 0.65835f}, 
				    {0.99336f, 0.6573599999999999f, 0.6573599999999999f}, 
				    {0.99337f, 0.6563699999999999f, 0.6563699999999999f}, 
				    {0.99338f, 0.65538f, 0.65538f}, {0.99339f, 0.65439f, 0.65439f}, 
				    {0.9934f, 0.6534f, 0.6534f}, {0.99341f, 0.6524099999999999f, 0.6524099999999999f}, 
				    {0.99342f, 0.6514199999999999f, 0.6514199999999999f}, 
				    {0.99343f, 0.65043f, 0.65043f}, {0.99344f, 0.64944f, 0.64944f}, 
				    {0.9934499999999999f, 0.64845f, 0.64845f}, {0.99346f, 0.6474599999999999f, 
									     0.6474599999999999f}, {0.99347f, 0.64647f, 0.64647f}, 
				    {0.99348f, 0.6454799999999999f, 0.6454799999999999f}, 
				    {0.99349f, 0.64449f, 0.64449f}, {0.9935f, 0.6435f, 0.6435f}, 
				    {0.99351f, 0.6425099999999999f, 0.6425099999999999f}, 
				    {0.99352f, 0.6415200000000001f, 0.6415200000000001f}, 
				    {0.99353f, 0.64053f, 0.64053f}, {0.99354f, 0.63954f, 0.63954f}, 
				    {0.99355f, 0.63855f, 0.63855f}, {0.99356f, 0.63756f, 0.63756f}, 
				    {0.99357f, 0.6365700000000001f, 0.6365700000000001f}, 
				    {0.99358f, 0.63558f, 0.63558f}, {0.99359f, 0.63459f, 0.63459f}, 
				    {0.9936f, 0.6335999999999999f, 0.6335999999999999f}, 
				    {0.99361f, 0.63261f, 0.63261f}, {0.99362f, 0.6316200000000001f, 
								  0.6316200000000001f}, {0.99363f, 0.63063f, 0.63063f}, 
				    {0.99364f, 0.62964f, 0.62964f}, {0.99365f, 0.6286499999999999f, 
								  0.6286499999999999f}, {0.99366f, 0.62766f, 0.62766f}, 
				    {0.9936699999999999f, 0.6266700000000001f, 0.6266700000000001f}, 
				    {0.99368f, 0.62568f, 0.62568f}, {0.99369f, 0.62469f, 0.62469f}, 
				    {0.9937f, 0.6236999999999999f, 0.6236999999999999f}, 
				    {0.99371f, 0.62271f, 0.62271f}, {0.99372f, 0.62172f, 0.62172f}, 
				    {0.99373f, 0.62073f, 0.62073f}, {0.99374f, 0.61974f, 0.61974f}, 
				    {0.99375f, 0.61875f, 0.61875f}, {0.99376f, 0.61776f, 0.61776f}, 
				    {0.99377f, 0.61677f, 0.61677f}, {0.99378f, 0.61578f, 0.61578f}, 
				    {0.99379f, 0.61479f, 0.61479f}, {0.9938f, 0.6138f, 0.6138f}, 
				    {0.99381f, 0.61281f, 0.61281f}, {0.99382f, 0.61182f, 0.61182f}, 
				    {0.99383f, 0.61083f, 0.61083f}, {0.99384f, 0.6098399999999999f, 
								  0.6098399999999999f}, {0.99385f, 0.60885f, 0.60885f}, 
				    {0.99386f, 0.6078600000000001f, 0.6078600000000001f}, 
				    {0.99387f, 0.60687f, 0.60687f}, {0.99388f, 0.60588f, 0.60588f}, 
				    {0.9938899999999999f, 0.6048899999999999f, 0.6048899999999999f}, 
				    {0.9939f, 0.6039f, 0.6039f}, {0.99391f, 0.6029100000000001f, 0.6029100000000001f}, 
				    {0.99392f, 0.60192f, 0.60192f}, {0.99393f, 0.60093f, 0.60093f}, 
				    {0.99394f, 0.5999399999999999f, 0.5999399999999999f}, 
				    {0.99395f, 0.59895f, 0.59895f}, {0.99396f, 0.59796f, 0.59796f}, 
				    {0.99397f, 0.59697f, 0.59697f}, {0.99398f, 0.59598f, 0.59598f}, 
				    {0.99399f, 0.5949899999999999f, 0.5949899999999999f}, {0.994f, 0.594f, 0.594f}, 
				    {0.99401f, 0.59301f, 0.59301f}, {0.99402f, 0.59202f, 0.59202f}, 
				    {0.99403f, 0.5910299999999999f, 0.5910299999999999f}, 
				    {0.99404f, 0.5900399999999999f, 0.5900399999999999f}, 
				    {0.99405f, 0.58905f, 0.58905f}, {0.9940599999999999f, 0.58806f, 0.58806f}, 
				    {0.99407f, 0.58707f, 0.58707f}, {0.99408f, 0.5860799999999999f, 
								  0.5860799999999999f}, {0.99409f, 0.5850899999999999f, 0.5850899999999999f}, 
				    {0.9941f, 0.5841f, 0.5841f}, {0.99411f, 0.58311f, 0.58311f}, 
				    {0.99412f, 0.58212f, 0.58212f}, {0.99413f, 0.5811299999999999f, 
								  0.5811299999999999f}, {0.99414f, 0.5801399999999999f, 0.5801399999999999f}, 
				    {0.99415f, 0.5791499999999999f, 0.5791499999999999f}, 
				    {0.99416f, 0.57816f, 0.57816f}, {0.99417f, 0.57717f, 0.57717f}, 
				    {0.99418f, 0.57618f, 0.57618f}, {0.99419f, 0.5751900000000001f, 
								  0.5751900000000001f}, {0.9942f, 0.5742f, 0.5742f}, {0.99421f, 0.57321f, 0.57321f}, 
				    {0.99422f, 0.57222f, 0.57222f}, {0.99423f, 0.57123f, 0.57123f}, 
				    {0.99424f, 0.5702400000000001f, 0.5702400000000001f}, 
				    {0.99425f, 0.56925f, 0.56925f}, {0.99426f, 0.56826f, 0.56826f}, 
				    {0.99427f, 0.5672699999999999f, 0.5672699999999999f}, 
				    {0.9942799999999999f, 0.56628f, 0.56628f}, {0.99429f, 0.5652900000000001f, 
									     0.5652900000000001f}, {0.9943f, 0.5643f, 0.5643f}, {0.99431f, 0.56331f, 0.56331f}, 
				    {0.99432f, 0.5623199999999999f, 0.5623199999999999f}, 
				    {0.99433f, 0.56133f, 0.56133f}, {0.99434f, 0.5603400000000001f, 
								  0.5603400000000001f}, {0.99435f, 0.55935f, 0.55935f}, 
				    {0.99436f, 0.55836f, 0.55836f}, {0.99437f, 0.5573699999999999f, 
								  0.5573699999999999f}, {0.99438f, 0.55638f, 0.55638f}, 
				    {0.99439f, 0.55539f, 0.55539f}, {0.9944f, 0.5544f, 0.5544f}, 
				    {0.99441f, 0.55341f, 0.55341f}, {0.99442f, 0.5524199999999999f, 
								  0.5524199999999999f}, {0.99443f, 0.55143f, 0.55143f}, 
				    {0.99444f, 0.55044f, 0.55044f}, {0.99445f, 0.54945f, 0.54945f}, 
				    {0.99446f, 0.54846f, 0.54846f}, {0.99447f, 0.54747f, 0.54747f}, 
				    {0.99448f, 0.54648f, 0.54648f}, {0.99449f, 0.54549f, 0.54549f}, 
				    {0.9944999999999999f, 0.5445f, 0.5445f}, {0.99451f, 0.5435099999999999f, 
									   0.5435099999999999f}, {0.99452f, 0.54252f, 0.54252f}, 
				    {0.99453f, 0.54153f, 0.54153f}, {0.99454f, 0.54054f, 0.54054f}, 
				    {0.99455f, 0.53955f, 0.53955f}, {0.99456f, 0.5385599999999999f, 
								  0.5385599999999999f}, {0.99457f, 0.53757f, 0.53757f}, 
				    {0.99458f, 0.5365800000000001f, 0.5365800000000001f}, 
				    {0.99459f, 0.53559f, 0.53559f}, {0.9946f, 0.5346f, 0.5346f}, 
				    {0.99461f, 0.5336099999999999f, 0.5336099999999999f}, 
				    {0.99462f, 0.53262f, 0.53262f}, {0.99463f, 0.53163f, 0.53163f}, 
				    {0.99464f, 0.53064f, 0.53064f}, {0.99465f, 0.52965f, 0.52965f}, 
				    {0.99466f, 0.5286599999999999f, 0.5286599999999999f}, 
				    {0.9946699999999999f, 0.52767f, 0.52767f}, {0.99468f, 0.52668f, 0.52668f}, 
				    {0.99469f, 0.52569f, 0.52569f}, {0.9947f, 0.5246999999999999f, 
								  0.5246999999999999f}, {0.99471f, 0.5237099999999999f, 0.5237099999999999f}, 
				    {0.99472f, 0.52272f, 0.52272f}, {0.99473f, 0.52173f, 0.52173f}, 
				    {0.99474f, 0.52074f, 0.52074f}, {0.99475f, 0.5197499999999999f, 
								  0.5197499999999999f}, {0.99476f, 0.5187599999999999f, 0.5187599999999999f}, 
				    {0.99477f, 0.51777f, 0.51777f}, {0.99478f, 0.51678f, 0.51678f}, 
				    {0.99479f, 0.51579f, 0.51579f}, {0.9948f, 0.5148f, 0.5148f}, 
				    {0.99481f, 0.51381f, 0.51381f}, {0.99482f, 0.51282f, 0.51282f}, 
				    {0.99483f, 0.51183f, 0.51183f}, {0.99484f, 0.51084f, 0.51084f}, 
				    {0.99485f, 0.50985f, 0.50985f}, {0.99486f, 0.5088600000000001f, 
								  0.5088600000000001f}, {0.99487f, 0.50787f, 0.50787f}, 
				    {0.99488f, 0.50688f, 0.50688f}, {0.9948899999999999f, 0.50589f, 0.50589f}, 
				    {0.9949f, 0.5049f, 0.5049f}, {0.99491f, 0.5039100000000001f, 0.5039100000000001f}, 
				    {0.99492f, 0.50292f, 0.50292f}, {0.99493f, 0.50193f, 0.50193f}, 
				    {0.99494f, 0.5009399999999999f, 0.5009399999999999f}, 
				    {0.99495f, 0.49995f, 0.49995f}, {0.99496f, 0.49896f, 0.49896f}, 
				    {0.99497f, 0.49797f, 0.49797f}, {0.99498f, 0.49698f, 0.49698f}, 
				    {0.99499f, 0.49599f, 0.49599f}, {0.995f, 0.495f, 0.495f}, 
				    {0.99501f, 0.49401f, 0.49401f}, {0.99502f, 0.49302f, 0.49302f}, 
				    {0.99503f, 0.49202999999999997f, 0.49202999999999997f}, 
				    {0.99504f, 0.49104f, 0.49104f}, {0.99505f, 0.49005f, 0.49005f}, 
				    {0.99506f, 0.48905999999999994f, 0.48905999999999994f}, 
				    {0.99507f, 0.48807f, 0.48807f}, {0.99508f, 0.48707999999999996f, 
								  0.48707999999999996f}, {0.99509f, 0.48609f, 0.48609f}, 
				    {0.9951f, 0.4851f, 0.4851f}, {0.99511f, 0.48411000000000004f, 
							       0.48411000000000004f}, {0.99512f, 0.48312f, 0.48312f}, 
				    {0.99513f, 0.48212999999999995f, 0.48212999999999995f}, 
				    {0.99514f, 0.48114f, 0.48114f}, {0.99515f, 0.48014999999999997f, 
								  0.48014999999999997f}, {0.99516f, 0.47916000000000003f, 0.47916000000000003f}, 
				    {0.99517f, 0.47817f, 0.47817f}, {0.99518f, 0.47717999999999994f, 
								  0.47717999999999994f}, {0.99519f, 0.47619f, 0.47619f}, 
				    {0.9952f, 0.47519999999999996f, 0.47519999999999996f}, 
				    {0.99521f, 0.47421f, 0.47421f}, {0.99522f, 0.47322f, 0.47322f}, 
				    {0.99523f, 0.4722299999999999f, 0.4722299999999999f}, 
				    {0.99524f, 0.47124f, 0.47124f}, {0.99525f, 0.47024999999999995f, 
								  0.47024999999999995f}, {0.99526f, 0.46926f, 0.46926f}, 
				    {0.99527f, 0.46826999999999996f, 0.46826999999999996f}, 
				    {0.9952799999999999f, 0.4672799999999999f, 0.4672799999999999f}, 
				    {0.99529f, 0.46629f, 0.46629f}, {0.9953f, 0.46529999999999994f, 
								  0.46529999999999994f}, {0.99531f, 0.46431f, 0.46431f}, 
				    {0.99532f, 0.46331999999999995f, 0.46331999999999995f}, 
				    {0.99533f, 0.46233f, 0.46233f}, {0.99534f, 0.46134f, 0.46134f}, 
				    {0.99535f, 0.4603499999999999f, 0.4603499999999999f}, 
				    {0.99536f, 0.45936f, 0.45936f}, {0.99537f, 0.45836999999999994f, 
								  0.45836999999999994f}, {0.99538f, 0.45738f, 0.45738f}, 
				    {0.99539f, 0.45638999999999996f, 0.45638999999999996f}, 
				    {0.9954f, 0.4553999999999999f, 0.4553999999999999f}, 
				    {0.99541f, 0.45441f, 0.45441f}, {0.99542f, 0.45341999999999993f, 
								  0.45341999999999993f}, {0.99543f, 0.45243f, 0.45243f}, 
				    {0.99544f, 0.45143999999999995f, 0.45143999999999995f}, 
				    {0.99545f, 0.4504499999999999f, 0.4504499999999999f}, 
				    {0.99546f, 0.44945999999999997f, 0.44945999999999997f}, 
				    {0.99547f, 0.4484699999999999f, 0.4484699999999999f}, 
				    {0.99548f, 0.44748f, 0.44748f}, {0.99549f, 0.44648999999999994f, 
								  0.44648999999999994f}, {0.9955f, 0.4455f, 0.4455f}, 
				    {0.99551f, 0.44450999999999996f, 0.44450999999999996f}, 
				    {0.99552f, 0.4435199999999999f, 0.4435199999999999f}, 
				    {0.99553f, 0.44253f, 0.44253f}, {0.99554f, 0.44153999999999993f, 
								  0.44153999999999993f}, {0.99555f, 0.44055f, 0.44055f}, 
				    {0.99556f, 0.43955999999999995f, 0.43955999999999995f}, 
				    {0.99557f, 0.4385699999999999f, 0.4385699999999999f}, 
				    {0.99558f, 0.43757999999999997f, 0.43757999999999997f}, 
				    {0.99559f, 0.4365899999999999f, 0.4365899999999999f}, {0.9956f, 0.4356f, 0.4356f}, 
				    {0.99561f, 0.43460999999999994f, 0.43460999999999994f}, 
				    {0.99562f, 0.4336199999999999f, 0.4336199999999999f}, 
				    {0.99563f, 0.43262999999999996f, 0.43262999999999996f}, 
				    {0.99564f, 0.4316399999999999f, 0.4316399999999999f}, 
				    {0.99565f, 0.43065f, 0.43065f}, {0.99566f, 0.42965999999999993f, 
								  0.42965999999999993f}, {0.9956699999999999f, 0.4286699999999999f, 
											 0.4286699999999999f}, {0.99568f, 0.42767999999999995f, 0.42767999999999995f}, 
				    {0.99569f, 0.4266899999999999f, 0.4266899999999999f}, 
				    {0.9957f, 0.42569999999999997f, 0.42569999999999997f}, 
				    {0.99571f, 0.4247099999999999f, 0.4247099999999999f}, 
				    {0.99572f, 0.42372f, 0.42372f}, {0.99573f, 0.42272999999999994f, 
								  0.42272999999999994f}, {0.99574f, 0.4217399999999999f, 0.4217399999999999f}, 
				    {0.99575f, 0.42074999999999996f, 0.42074999999999996f}, 
				    {0.99576f, 0.4197599999999999f, 0.4197599999999999f}, 
				    {0.99577f, 0.4187700000000001f, 0.4187700000000001f}, 
				    {0.99578f, 0.41778000000000004f, 0.41778000000000004f}, 
				    {0.99579f, 0.41679f, 0.41679f}, {0.9958f, 0.41580000000000006f, 
								  0.41580000000000006f}, {0.99581f, 0.41481f, 0.41481f}, 
				    {0.99582f, 0.4138200000000001f, 0.4138200000000001f}, 
				    {0.99583f, 0.41283000000000003f, 0.41283000000000003f}, 
				    {0.99584f, 0.41184f, 0.41184f}, {0.99585f, 0.41085000000000005f, 
								  0.41085000000000005f}, {0.99586f, 0.40986f, 0.40986f}, 
				    {0.99587f, 0.40887000000000007f, 0.40887000000000007f}, 
				    {0.99588f, 0.40788f, 0.40788f}, {0.9958899999999999f, 0.40689f, 0.40689f}, 
				    {0.9959f, 0.40590000000000004f, 0.40590000000000004f}, 
				    {0.99591f, 0.40491f, 0.40491f}, {0.99592f, 0.40392000000000006f, 
								  0.40392000000000006f}, {0.99593f, 0.40293f, 0.40293f}, 
				    {0.99594f, 0.4019400000000001f, 0.4019400000000001f}, 
				    {0.99595f, 0.40095000000000003f, 0.40095000000000003f}, 
				    {0.99596f, 0.39996f, 0.39996f}, {0.99597f, 0.39897000000000005f, 
								  0.39897000000000005f}, {0.99598f, 0.39798f, 0.39798f}, 
				    {0.99599f, 0.39699000000000007f, 0.39699000000000007f}, {0.996f, 0.396f, 0.396f}, 
				    {0.99601f, 0.39501f, 0.39501f}, {0.99602f, 0.39402000000000004f, 
								  0.39402000000000004f}, {0.99603f, 0.39303f, 0.39303f}, 
				    {0.99604f, 0.39204000000000006f, 0.39204000000000006f}, 
				    {0.99605f, 0.39105f, 0.39105f}, {0.99606f, 0.39005999999999996f, 
								  0.39005999999999996f}, {0.99607f, 0.38907f, 0.38907f}, 
				    {0.99608f, 0.38808f, 0.38808f}, {0.99609f, 0.38709000000000005f, 
								  0.38709000000000005f}, {0.9961f, 0.3861f, 0.3861f}, 
				    {0.99611f, 0.38511000000000006f, 0.38511000000000006f}, 
				    {0.99612f, 0.38412f, 0.38412f}, {0.99613f, 0.38312999999999997f, 
								  0.38312999999999997f}, {0.99614f, 0.38214000000000004f, 0.38214000000000004f}, 
				    {0.99615f, 0.38115f, 0.38115f}, {0.99616f, 0.38016000000000005f, 
								  0.38016000000000005f}, {0.99617f, 0.37917f, 0.37917f}, 
				    {0.99618f, 0.37817999999999996f, 0.37817999999999996f}, 
				    {0.99619f, 0.37719f, 0.37719f}, {0.9962f, 0.3762f, 0.3762f}, 
				    {0.99621f, 0.37521000000000004f, 0.37521000000000004f}, 
				    {0.99622f, 0.37422f, 0.37422f}, {0.99623f, 0.37322999999999995f, 
								  0.37322999999999995f}, {0.99624f, 0.37224f, 0.37224f}, 
				    {0.99625f, 0.37124999999999997f, 0.37124999999999997f}, 
				    {0.99626f, 0.37026000000000003f, 0.37026000000000003f}, 
				    {0.99627f, 0.36927f, 0.36927f}, {0.9962799999999999f, 0.36827999999999994f, 
								  0.36827999999999994f}, {0.99629f, 0.36729f, 0.36729f}, 
				    {0.9963f, 0.36629999999999996f, 0.36629999999999996f}, 
				    {0.99631f, 0.36531f, 0.36531f}, {0.99632f, 0.36432f, 0.36432f}, 
				    {0.99633f, 0.36333000000000004f, 0.36333000000000004f}, 
				    {0.99634f, 0.36234f, 0.36234f}, {0.99635f, 0.36134999999999995f, 
								  0.36134999999999995f}, {0.99636f, 0.36036f, 0.36036f}, 
				    {0.99637f, 0.35936999999999997f, 0.35936999999999997f}, 
				    {0.99638f, 0.35838000000000003f, 0.35838000000000003f}, 
				    {0.99639f, 0.35739f, 0.35739f}, {0.9964f, 0.35639999999999994f, 
								  0.35639999999999994f}, {0.99641f, 0.35541f, 0.35541f}, 
				    {0.99642f, 0.35441999999999996f, 0.35441999999999996f}, 
				    {0.99643f, 0.35343f, 0.35343f}, {0.99644f, 0.35244f, 0.35244f}, 
				    {0.99645f, 0.35144999999999993f, 0.35144999999999993f}, 
				    {0.99646f, 0.35046f, 0.35046f}, {0.99647f, 0.34946999999999995f, 
								  0.34946999999999995f}, {0.99648f, 0.34848f, 0.34848f}, 
				    {0.99649f, 0.34748999999999997f, 0.34748999999999997f}, 
				    {0.9964999999999999f, 0.34650000000000003f, 0.34650000000000003f}, 
				    {0.99651f, 0.34551f, 0.34551f}, {0.99652f, 0.34451999999999994f, 
								  0.34451999999999994f}, {0.99653f, 0.34353f, 0.34353f}, 
				    {0.99654f, 0.34253999999999996f, 0.34253999999999996f}, 
				    {0.99655f, 0.34155f, 0.34155f}, {0.99656f, 0.34056f, 0.34056f}, 
				    {0.99657f, 0.3395699999999999f, 0.3395699999999999f}, 
				    {0.99658f, 0.33858f, 0.33858f}, {0.99659f, 0.33758999999999995f, 
								  0.33758999999999995f}, {0.9966f, 0.3366f, 0.3366f}, 
				    {0.99661f, 0.33560999999999996f, 0.33560999999999996f}, 
				    {0.99662f, 0.3346199999999999f, 0.3346199999999999f}, 
				    {0.99663f, 0.33363f, 0.33363f}, {0.99664f, 0.33263999999999994f, 
								  0.33263999999999994f}, {0.99665f, 0.33165f, 0.33165f}, 
				    {0.99666f, 0.33065999999999995f, 0.33065999999999995f}, 
				    {0.99667f, 0.3296699999999999f, 0.3296699999999999f}, 
				    {0.99668f, 0.32867999999999997f, 0.32867999999999997f}, 
				    {0.99669f, 0.3276899999999999f, 0.3276899999999999f}, {0.9967f, 0.3267f, 0.3267f}, 
				    {0.99671f, 0.32570999999999994f, 0.32570999999999994f}, 
				    {0.99672f, 0.32472f, 0.32472f}, {0.99673f, 0.32372999999999996f, 
								  0.32372999999999996f}, {0.99674f, 0.3227399999999999f, 0.3227399999999999f}, 
				    {0.99675f, 0.32175f, 0.32175f}, {0.99676f, 0.32075999999999993f, 
								  0.32075999999999993f}, {0.99677f, 0.31977f, 0.31977f}, 
				    {0.99678f, 0.31877999999999995f, 0.31877999999999995f}, 
				    {0.99679f, 0.3177899999999999f, 0.3177899999999999f}, 
				    {0.9968f, 0.31679999999999997f, 0.31679999999999997f}, 
				    {0.99681f, 0.3158099999999999f, 0.3158099999999999f}, 
				    {0.99682f, 0.31482f, 0.31482f}, {0.99683f, 0.31382999999999994f, 
								  0.31382999999999994f}, {0.99684f, 0.3128399999999999f, 0.3128399999999999f}, 
				    {0.99685f, 0.31184999999999996f, 0.31184999999999996f}, 
				    {0.99686f, 0.3108599999999999f, 0.3108599999999999f}, 
				    {0.99687f, 0.30987f, 0.30987f}, {0.99688f, 0.30887999999999993f, 
								  0.30887999999999993f}, {0.9968899999999999f, 0.3078899999999999f, 
											 0.3078899999999999f}, {0.9969f, 0.30689999999999995f, 0.30689999999999995f}, 
				    {0.99691f, 0.3059099999999999f, 0.3059099999999999f}, 
				    {0.99692f, 0.30491999999999997f, 0.30491999999999997f}, 
				    {0.99693f, 0.3039299999999999f, 0.3039299999999999f}, 
				    {0.99694f, 0.30294f, 0.30294f}, {0.99695f, 0.30194999999999994f, 
								  0.30194999999999994f}, {0.99696f, 0.3009599999999999f, 0.3009599999999999f}, 
				    {0.99697f, 0.29996999999999996f, 0.29996999999999996f}, 
				    {0.99698f, 0.2989799999999999f, 0.2989799999999999f}, 
				    {0.99699f, 0.29799f, 0.29799f}, {0.997f, 0.29699999999999993f, 
								  0.29699999999999993f}, {0.99701f, 0.2960099999999999f, 0.2960099999999999f}, 
				    {0.99702f, 0.29501999999999995f, 0.29501999999999995f}, 
				    {0.99703f, 0.2940299999999999f, 0.2940299999999999f}, 
				    {0.99704f, 0.2930400000000001f, 0.2930400000000001f}, 
				    {0.99705f, 0.29205000000000003f, 0.29205000000000003f}, 
				    {0.99706f, 0.29106f, 0.29106f}, {0.99707f, 0.29007000000000005f, 
								  0.29007000000000005f}, {0.99708f, 0.28908f, 0.28908f}, 
				    {0.99709f, 0.28809000000000007f, 0.28809000000000007f}, 
				    {0.9971f, 0.2871f, 0.2871f}, {0.99711f, 0.2861100000000001f, 0.2861100000000001f}, 
				    {0.99712f, 0.28512000000000004f, 0.28512000000000004f}, 
				    {0.99713f, 0.28413f, 0.28413f}, {0.99714f, 0.28314000000000006f, 
								  0.28314000000000006f}, {0.99715f, 0.28215f, 0.28215f}, 
				    {0.99716f, 0.2811600000000001f, 0.2811600000000001f}, 
				    {0.99717f, 0.28017000000000003f, 0.28017000000000003f}, 
				    {0.99718f, 0.27918f, 0.27918f}, {0.99719f, 0.27819000000000005f, 
								  0.27819000000000005f}, {0.9972f, 0.2772f, 0.2772f}, 
				    {0.99721f, 0.27621000000000007f, 0.27621000000000007f}, 
				    {0.99722f, 0.27522f, 0.27522f}, {0.99723f, 0.27423f, 0.27423f}, 
				    {0.99724f, 0.27324000000000004f, 0.27324000000000004f}, 
				    {0.99725f, 0.27225f, 0.27225f}, {0.99726f, 0.27126000000000006f, 
								  0.27126000000000006f}, {0.99727f, 0.27027f, 0.27027f}, 
				    {0.9972799999999999f, 0.26927999999999996f, 0.26927999999999996f}, 
				    {0.99729f, 0.26829000000000003f, 0.26829000000000003f}, 
				    {0.9973f, 0.2673f, 0.2673f}, {0.99731f, 0.26631000000000005f, 
							       0.26631000000000005f}, {0.99732f, 0.26532f, 0.26532f}, 
				    {0.99733f, 0.26433000000000006f, 0.26433000000000006f}, 
				    {0.99734f, 0.26334f, 0.26334f}, {0.99735f, 0.26234999999999997f, 
								  0.26234999999999997f}, {0.99736f, 0.26136000000000004f, 0.26136000000000004f}, 
				    {0.99737f, 0.26037f, 0.26037f}, {0.99738f, 0.25938000000000005f, 
								  0.25938000000000005f}, {0.99739f, 0.25839f, 0.25839f}, 
				    {0.9974f, 0.25739999999999996f, 0.25739999999999996f}, 
				    {0.99741f, 0.25641f, 0.25641f}, {0.99742f, 0.25542f, 0.25542f}, 
				    {0.99743f, 0.25443000000000005f, 0.25443000000000005f}, 
				    {0.99744f, 0.25344f, 0.25344f}, {0.99745f, 0.25244999999999995f, 
								  0.25244999999999995f}, {0.99746f, 0.25146f, 0.25146f}, 
				    {0.99747f, 0.25046999999999997f, 0.25046999999999997f}, 
				    {0.99748f, 0.24948000000000004f, 0.24948000000000004f}, 
				    {0.99749f, 0.24849f, 0.24849f}, {0.9975f, 0.24750000000000005f, 
								  0.24750000000000005f}, {0.99751f, 0.24651f, 0.24651f}, 
				    {0.99752f, 0.24551999999999996f, 0.24551999999999996f}, 
				    {0.99753f, 0.24453000000000003f, 0.24453000000000003f}, 
				    {0.99754f, 0.24353999999999998f, 0.24353999999999998f}, 
				    {0.99755f, 0.24255000000000004f, 0.24255000000000004f}, 
				    {0.99756f, 0.24156f, 0.24156f}, {0.99757f, 0.24056999999999995f, 
								  0.24056999999999995f}, {0.99758f, 0.23958000000000002f, 0.23958000000000002f}, 
				    {0.99759f, 0.23858999999999997f, 0.23858999999999997f}, 
				    {0.9976f, 0.23760000000000003f, 0.23760000000000003f}, 
				    {0.99761f, 0.23661f, 0.23661f}, {0.99762f, 0.23561999999999994f, 
								  0.23561999999999994f}, {0.99763f, 0.23463f, 0.23463f}, 
				    {0.99764f, 0.23363999999999996f, 0.23363999999999996f}, 
				    {0.99765f, 0.23265000000000002f, 0.23265000000000002f}, 
				    {0.99766f, 0.23165999999999998f, 0.23165999999999998f}, 
				    {0.99767f, 0.23066999999999993f, 0.23066999999999993f}, 
				    {0.99768f, 0.22968f, 0.22968f}, {0.99769f, 0.22868999999999995f, 
								  0.22868999999999995f}, {0.9977f, 0.2277f, 0.2277f}, 
				    {0.99771f, 0.22670999999999997f, 0.22670999999999997f}, 
				    {0.99772f, 0.22572000000000003f, 0.22572000000000003f}, 
				    {0.99773f, 0.22472999999999999f, 0.22472999999999999f}, 
				    {0.99774f, 0.22373999999999994f, 0.22373999999999994f}, 
				    {0.99775f, 0.22275f, 0.22275f}, {0.99776f, 0.22175999999999996f, 
								  0.22175999999999996f}, {0.99777f, 0.22077000000000002f, 0.22077000000000002f}, 
				    {0.99778f, 0.21977999999999998f, 0.21977999999999998f}, 
				    {0.99779f, 0.21878999999999993f, 0.21878999999999993f}, 
				    {0.9978f, 0.2178f, 0.2178f}, {0.99781f, 0.21680999999999995f, 
							       0.21680999999999995f}, {0.99782f, 0.21582f, 0.21582f}, 
				    {0.99783f, 0.21482999999999997f, 0.21482999999999997f}, 
				    {0.99784f, 0.21383999999999992f, 0.21383999999999992f}, 
				    {0.99785f, 0.21284999999999998f, 0.21284999999999998f}, 
				    {0.99786f, 0.21185999999999994f, 0.21185999999999994f}, 
				    {0.99787f, 0.21087f, 0.21087f}, {0.99788f, 0.20987999999999996f, 
								  0.20987999999999996f}, {0.9978899999999999f, 0.2088899999999999f, 
											 0.2088899999999999f}, {0.9979f, 0.20789999999999997f, 0.20789999999999997f}, 
				    {0.99791f, 0.20690999999999993f, 0.20690999999999993f}, 
				    {0.99792f, 0.20592f, 0.20592f}, {0.99793f, 0.20492999999999995f, 
								  0.20492999999999995f}, {0.99794f, 0.20394f, 0.20394f}, 
				    {0.99795f, 0.20294999999999996f, 0.20294999999999996f}, 
				    {0.99796f, 0.20195999999999992f, 0.20195999999999992f}, 
				    {0.99797f, 0.20096999999999998f, 0.20096999999999998f}, 
				    {0.99798f, 0.19997999999999994f, 0.19997999999999994f}, 
				    {0.99799f, 0.19899f, 0.19899f}, {0.998f, 0.19799999999999995f, 
								  0.19799999999999995f}, {0.99801f, 0.1970099999999999f, 0.1970099999999999f}, 
				    {0.99802f, 0.19601999999999997f, 0.19601999999999997f}, 
				    {0.99803f, 0.19502999999999993f, 0.19502999999999993f}, 
				    {0.99804f, 0.19404f, 0.19404f}, {0.99805f, 0.19304999999999994f, 
								  0.19304999999999994f}, {0.99806f, 0.1920599999999999f, 0.1920599999999999f}, 
				    {0.99807f, 0.19106999999999996f, 0.19106999999999996f}, 
				    {0.99808f, 0.19007999999999992f, 0.19007999999999992f}, 
				    {0.99809f, 0.18908999999999998f, 0.18908999999999998f}, 
				    {0.9981f, 0.18809999999999993f, 0.18809999999999993f}, 
				    {0.99811f, 0.18711f, 0.18711f}, {0.99812f, 0.18611999999999995f, 
								  0.18611999999999995f}, {0.99813f, 0.1851299999999999f, 0.1851299999999999f}, 
				    {0.99814f, 0.18413999999999997f, 0.18413999999999997f}, 
				    {0.99815f, 0.18314999999999992f, 0.18314999999999992f}, 
				    {0.99816f, 0.18216f, 0.18216f}, {0.99817f, 0.18116999999999994f, 
								  0.18116999999999994f}, {0.99818f, 0.1801799999999999f, 0.1801799999999999f}, 
				    {0.99819f, 0.17918999999999996f, 0.17918999999999996f}, 
				    {0.9982f, 0.17819999999999991f, 0.17819999999999991f}, 
				    {0.99821f, 0.17720999999999998f, 0.17720999999999998f}, 
				    {0.99822f, 0.17621999999999993f, 0.17621999999999993f}, 
				    {0.99823f, 0.17522999999999989f, 0.17522999999999989f}, 
				    {0.99824f, 0.17423999999999995f, 0.17423999999999995f}, 
				    {0.99825f, 0.1732499999999999f, 0.1732499999999999f}, 
				    {0.99826f, 0.17225999999999997f, 0.17225999999999997f}, 
				    {0.99827f, 0.17126999999999992f, 0.17126999999999992f}, 
				    {0.99828f, 0.17027999999999988f, 0.17027999999999988f}, 
				    {0.99829f, 0.16928999999999994f, 0.16928999999999994f}, 
				    {0.9983f, 0.1682999999999999f, 0.1682999999999999f}, 
				    {0.99831f, 0.16730999999999996f, 0.16730999999999996f}, 
				    {0.99832f, 0.1663199999999999f, 0.1663199999999999f}, 
				    {0.99833f, 0.1653300000000001f, 0.1653300000000001f}, 
				    {0.99834f, 0.16434000000000004f, 0.16434000000000004f}, 
				    {0.99835f, 0.16335f, 0.16335f}, {0.99836f, 0.16236000000000006f, 
								  0.16236000000000006f}, {0.99837f, 0.16137f, 0.16137f}, 
				    {0.99838f, 0.16038000000000008f, 0.16038000000000008f}, 
				    {0.99839f, 0.15939000000000003f, 0.15939000000000003f}, 
				    {0.9984f, 0.15839999999999999f, 0.15839999999999999f}, 
				    {0.99841f, 0.15741000000000005f, 0.15741000000000005f}, 
				    {0.99842f, 0.15642f, 0.15642f}, {0.99843f, 0.15543000000000007f, 
								  0.15543000000000007f}, {0.99844f, 0.15444000000000002f, 0.15444000000000002f}, 
				    {0.99845f, 0.15344999999999998f, 0.15344999999999998f}, 
				    {0.99846f, 0.15246000000000004f, 0.15246000000000004f}, 
				    {0.99847f, 0.15147f, 0.15147f}, {0.99848f, 0.15048000000000006f, 
								  0.15048000000000006f}, {0.99849f, 0.14949f, 0.14949f}, 
				    {0.9984999999999999f, 0.14849999999999997f, 0.14849999999999997f}, 
				    {0.99851f, 0.14751000000000003f, 0.14751000000000003f}, 
				    {0.99852f, 0.14651999999999998f, 0.14651999999999998f}, 
				    {0.99853f, 0.14553000000000005f, 0.14553000000000005f}, 
				    {0.99854f, 0.14454f, 0.14454f}, {0.99855f, 0.14355000000000007f, 
								  0.14355000000000007f}, {0.99856f, 0.14256000000000002f, 0.14256000000000002f}, 
				    {0.99857f, 0.14156999999999997f, 0.14156999999999997f}, 
				    {0.99858f, 0.14058000000000004f, 0.14058000000000004f}, 
				    {0.99859f, 0.13959f, 0.13959f}, {0.9986f, 0.13860000000000006f, 
								  0.13860000000000006f}, {0.99861f, 0.13761f, 0.13761f}, 
				    {0.99862f, 0.13661999999999996f, 0.13661999999999996f}, 
				    {0.99863f, 0.13563000000000003f, 0.13563000000000003f}, 
				    {0.99864f, 0.13463999999999998f, 0.13463999999999998f}, 
				    {0.99865f, 0.13365000000000005f, 0.13365000000000005f}, 
				    {0.99866f, 0.13266f, 0.13266f}, {0.99867f, 0.13166999999999995f, 
								  0.13166999999999995f}, {0.99868f, 0.13068000000000002f, 0.13068000000000002f}, 
				    {0.99869f, 0.12968999999999997f, 0.12968999999999997f}, 
				    {0.9987f, 0.12870000000000004f, 0.12870000000000004f}, 
				    {0.99871f, 0.12771f, 0.12771f}, {0.99872f, 0.12672000000000005f, 
								  0.12672000000000005f}, {0.99873f, 0.12573f, 0.12573f}, 
				    {0.99874f, 0.12473999999999996f, 0.12473999999999996f}, 
				    {0.99875f, 0.12375000000000003f, 0.12375000000000003f}, 
				    {0.99876f, 0.12275999999999998f, 0.12275999999999998f}, 
				    {0.99877f, 0.12177000000000004f, 0.12177000000000004f}, 
				    {0.99878f, 0.12078f, 0.12078f}, {0.99879f, 0.11978999999999995f, 
								  0.11978999999999995f}, {0.9988f, 0.11880000000000002f, 0.11880000000000002f}, 
				    {0.99881f, 0.11780999999999997f, 0.11780999999999997f}, 
				    {0.99882f, 0.11682000000000003f, 0.11682000000000003f}, 
				    {0.99883f, 0.11582999999999999f, 0.11582999999999999f}, 
				    {0.99884f, 0.11483999999999994f, 0.11483999999999994f}, 
				    {0.99885f, 0.11385f, 0.11385f}, {0.99886f, 0.11285999999999996f, 
								  0.11285999999999996f}, {0.99887f, 0.11187000000000002f, 0.11187000000000002f}, 
				    {0.99888f, 0.11087999999999998f, 0.11087999999999998f}, 
				    {0.99889f, 0.10988999999999993f, 0.10988999999999993f}, 
				    {0.9989f, 0.1089f, 0.1089f}, {0.99891f, 0.10790999999999995f, 
							       0.10790999999999995f}, {0.99892f, 0.10692000000000002f, 0.10692000000000002f}, 
				    {0.99893f, 0.10592999999999997f, 0.10592999999999997f}, 
				    {0.99894f, 0.10494000000000003f, 0.10494000000000003f}, 
				    {0.99895f, 0.10394999999999999f, 0.10394999999999999f}, 
				    {0.99896f, 0.10295999999999994f, 0.10295999999999994f}, 
				    {0.99897f, 0.10197f, 0.10197f}, {0.99898f, 0.10097999999999996f, 
								  0.10097999999999996f}, {0.99899f, 0.09999000000000002f, 0.09999000000000002f}, 
				    {0.999f, 0.09899999999999998f, 0.09899999999999998f}, 
				    {0.99901f, 0.09800999999999993f, 0.09800999999999993f}, 
				    {0.99902f, 0.09702f, 0.09702f}, {0.99903f, 0.09602999999999995f, 
								  0.09602999999999995f}, {0.99904f, 0.09504000000000001f, 0.09504000000000001f}, 
				    {0.99905f, 0.09404999999999997f, 0.09404999999999997f}, 
				    {0.99906f, 0.09305999999999992f, 0.09305999999999992f}, 
				    {0.99907f, 0.09206999999999999f, 0.09206999999999999f}, 
				    {0.99908f, 0.09107999999999994f, 0.09107999999999994f}, 
				    {0.99909f, 0.09009f, 0.09009f}, {0.9991f, 0.08909999999999996f, 
								  0.08909999999999996f}, {0.99911f, 0.08811000000000002f, 0.08811000000000002f}, 
				    {0.99912f, 0.08711999999999998f, 0.08711999999999998f}, 
				    {0.99913f, 0.08612999999999993f, 0.08612999999999993f}, 
				    {0.99914f, 0.08514f, 0.08514f}, {0.99915f, 0.08414999999999995f, 
								  0.08414999999999995f}, {0.99916f, 0.08316000000000001f, 0.08316000000000001f}, 
				    {0.99917f, 0.08216999999999997f, 0.08216999999999997f}, 
				    {0.99918f, 0.08117999999999992f, 0.08117999999999992f}, 
				    {0.99919f, 0.08018999999999998f, 0.08018999999999998f}, 
				    {0.9992f, 0.07919999999999994f, 0.07919999999999994f}, 
				    {0.99921f, 0.07821f, 0.07821f}, {0.99922f, 0.07721999999999996f, 
								  0.07721999999999996f}, {0.99923f, 0.07622999999999991f, 0.07622999999999991f}, 
				    {0.99924f, 0.07523999999999997f, 0.07523999999999997f}, 
				    {0.99925f, 0.07424999999999993f, 0.07424999999999993f}, 
				    {0.99926f, 0.07325999999999999f, 0.07325999999999999f}, 
				    {0.99927f, 0.07226999999999995f, 0.07226999999999995f}, 
				    {0.99928f, 0.0712799999999999f, 0.0712799999999999f}, 
				    {0.99929f, 0.07028999999999996f, 0.07028999999999996f}, 
				    {0.9993f, 0.06929999999999992f, 0.06929999999999992f}, 
				    {0.99931f, 0.06830999999999998f, 0.06830999999999998f}, 
				    {0.99932f, 0.06731999999999994f, 0.06731999999999994f}, 
				    {0.99933f, 0.06633f, 0.06633f}, {0.99934f, 0.06533999999999995f, 
								  0.06533999999999995f}, {0.99935f, 0.06434999999999991f, 0.06434999999999991f}, 
				    {0.99936f, 0.06335999999999997f, 0.06335999999999997f}, 
				    {0.99937f, 0.062369999999999925f, 0.062369999999999925f}, 
				    {0.99938f, 0.06137999999999999f, 0.06137999999999999f}, 
				    {0.99939f, 0.060389999999999944f, 0.060389999999999944f}, 
				    {0.9994f, 0.0593999999999999f, 0.0593999999999999f}, 
				    {0.99941f, 0.05840999999999996f, 0.05840999999999996f}, 
				    {0.99942f, 0.057419999999999916f, 0.057419999999999916f}, 
				    {0.99943f, 0.05642999999999998f, 0.05642999999999998f}, 
				    {0.99944f, 0.055439999999999934f, 0.055439999999999934f}, 
				    {0.99945f, 0.05444999999999989f, 0.05444999999999989f}, 
				    {0.99946f, 0.05345999999999995f, 0.05345999999999995f}, 
				    {0.99947f, 0.052469999999999906f, 0.052469999999999906f}, 
				    {0.99948f, 0.05147999999999997f, 0.05147999999999997f}, 
				    {0.99949f, 0.050489999999999924f, 0.050489999999999924f}, 
				    {0.9995f, 0.04949999999999999f, 0.04949999999999999f}, 
				    {0.99951f, 0.04850999999999994f, 0.04850999999999994f}, 
				    {0.99952f, 0.047519999999999896f, 0.047519999999999896f}, 
				    {0.99953f, 0.04652999999999996f, 0.04652999999999996f}, 
				    {0.99954f, 0.045539999999999914f, 0.045539999999999914f}, 
				    {0.99955f, 0.04454999999999998f, 0.04454999999999998f}, 
				    {0.99956f, 0.04355999999999993f, 0.04355999999999993f}, 
				    {0.99957f, 0.042569999999999886f, 0.042569999999999886f}, 
				    {0.99958f, 0.04157999999999995f, 0.04157999999999995f}, 
				    {0.99959f, 0.040589999999999904f, 0.040589999999999904f}, 
				    {0.9996f, 0.03960000000000008f, 0.03960000000000008f}, 
				    {0.99961f, 0.03861000000000003f, 0.03861000000000003f}, 
				    {0.99962f, 0.03761999999999999f, 0.03761999999999999f}, 
				    {0.99963f, 0.03663000000000005f, 0.03663000000000005f}, 
				    {0.99964f, 0.035640000000000005f, 0.035640000000000005f}, 
				    {0.99965f, 0.03465000000000007f, 0.03465000000000007f}, 
				    {0.99966f, 0.03366000000000002f, 0.03366000000000002f}, 
				    {0.99967f, 0.03266999999999998f, 0.03266999999999998f}, 
				    {0.99968f, 0.03168000000000004f, 0.03168000000000004f}, 
				    {0.99969f, 0.030689999999999995f, 0.030689999999999995f}, 
				    {0.9997f, 0.02970000000000006f, 0.02970000000000006f}, 
				    {0.99971f, 0.028710000000000013f, 0.028710000000000013f}, 
				    {0.99972f, 0.027720000000000078f, 0.027720000000000078f}, 
				    {0.99973f, 0.02673000000000003f, 0.02673000000000003f}, 
				    {0.99974f, 0.025739999999999985f, 0.025739999999999985f}, 
				    {0.99975f, 0.02475000000000005f, 0.02475000000000005f}, 
				    {0.99976f, 0.023760000000000003f, 0.023760000000000003f}, 
				    {0.99977f, 0.022770000000000068f, 0.022770000000000068f}, 
				    {0.99978f, 0.02178000000000002f, 0.02178000000000002f}, 
				    {0.99979f, 0.020789999999999975f, 0.020789999999999975f}, 
				    {0.9998f, 0.01980000000000004f, 0.01980000000000004f}, 
				    {0.99981f, 0.018809999999999993f, 0.018809999999999993f}, 
				    {0.99982f, 0.017820000000000058f, 0.017820000000000058f}, 
				    {0.99983f, 0.01683000000000001f, 0.01683000000000001f}, 
				    {0.99984f, 0.015839999999999965f, 0.015839999999999965f}, 
				    {0.99985f, 0.01485000000000003f, 0.01485000000000003f}, 
				    {0.99986f, 0.013859999999999983f, 0.013859999999999983f}, 
				    {0.99987f, 0.012870000000000048f, 0.012870000000000048f}, 
				    {0.99988f, 0.011880000000000002f, 0.011880000000000002f}, 
				    {0.99989f, 0.010889999999999955f, 0.010889999999999955f}, 
				    {0.9999f, 0.00990000000000002f, 0.00990000000000002f}, 
				    {0.99991f, 0.008909999999999973f, 0.008909999999999973f}, 
				    {0.99992f, 0.007920000000000038f, 0.007920000000000038f}, 
				    {0.99993f, 0.006929999999999992f, 0.006929999999999992f}, 
				    {0.99994f, 0.005940000000000056f, 0.005940000000000056f}, 
				    {0.99995f, 0.00495000000000001f, 0.00495000000000001f}, 
				    {0.99996f, 0.0039599999999999635f, 0.0039599999999999635f}, 
				    {0.99997f, 0.002970000000000028f, 0.002970000000000028f}, 
				    {0.99998f, 0.0019799999999999818f, 0.0019799999999999818f}, 
				    {0.99999f, 0.0009900000000000464f, 0.0009900000000000464f}, {1.f, 0.f, 0.f}};



float palette_white_to_red[1001][3]={{1.f, 1.f, 1.f}, {0.99001f, 0.98901f, 0.98901f}, 
				     {0.99002f, 0.98802f, 0.98802f}, {0.99003f, 0.98703f, 0.98703f}, 
				     {0.99004f, 0.98604f, 0.98604f}, {0.99005f, 0.98505f, 0.98505f}, 
				     {0.9900599999999999f, 0.98406f, 0.98406f}, {0.99007f, 0.98307f, 0.98307f}, 
				     {0.99008f, 0.98208f, 0.98208f}, {0.99009f, 0.98109f, 0.98109f}, 
				     {0.9901f, 0.9801f, 0.9801f}, {0.99011f, 0.97911f, 0.97911f}, 
				     {0.99012f, 0.97812f, 0.97812f}, {0.99013f, 0.9771299999999999f, 
								   0.9771299999999999f}, {0.99014f, 0.97614f, 0.97614f}, 
				     {0.99015f, 0.97515f, 0.97515f}, {0.99016f, 0.97416f, 0.97416f}, 
				     {0.99017f, 0.97317f, 0.97317f}, {0.99018f, 0.97218f, 0.97218f}, 
				     {0.99019f, 0.97119f, 0.97119f}, {0.9902f, 0.9702f, 0.9702f}, 
				     {0.99021f, 0.96921f, 0.96921f}, {0.99022f, 0.96822f, 0.96822f}, 
				     {0.9902299999999999f, 0.96723f, 0.96723f}, {0.99024f, 0.96624f, 0.96624f}, 
				     {0.99025f, 0.9652499999999999f, 0.9652499999999999f}, 
				     {0.99026f, 0.96426f, 0.96426f}, {0.99027f, 0.96327f, 0.96327f}, 
				     {0.9902799999999999f, 0.96228f, 0.96228f}, {0.99029f, 0.96129f, 0.96129f}, 
				     {0.9903f, 0.9603f, 0.9603f}, {0.99031f, 0.95931f, 0.95931f}, 
				     {0.99032f, 0.95832f, 0.95832f}, {0.99033f, 0.95733f, 0.95733f}, 
				     {0.99034f, 0.95634f, 0.95634f}, {0.99035f, 0.95535f, 0.95535f}, 
				     {0.99036f, 0.95436f, 0.95436f}, {0.99037f, 0.95337f, 0.95337f}, 
				     {0.99038f, 0.95238f, 0.95238f}, {0.99039f, 0.95139f, 0.95139f}, 
				     {0.9904f, 0.9504f, 0.9504f}, {0.99041f, 0.94941f, 0.94941f}, 
				     {0.99042f, 0.94842f, 0.94842f}, {0.99043f, 0.94743f, 0.94743f}, 
				     {0.99044f, 0.94644f, 0.94644f}, {0.9904499999999999f, 0.94545f, 0.94545f}, 
				     {0.99046f, 0.94446f, 0.94446f}, {0.99047f, 0.94347f, 0.94347f}, 
				     {0.99048f, 0.94248f, 0.94248f}, {0.99049f, 0.9414899999999999f, 
								   0.9414899999999999f}, {0.9904999999999999f, 0.9405f, 0.9405f}, 
				     {0.99051f, 0.93951f, 0.93951f}, {0.99052f, 0.93852f, 0.93852f}, 
				     {0.99053f, 0.93753f, 0.93753f}, {0.99054f, 0.93654f, 0.93654f}, 
				     {0.99055f, 0.93555f, 0.93555f}, {0.99056f, 0.93456f, 0.93456f}, 
				     {0.99057f, 0.93357f, 0.93357f}, {0.99058f, 0.93258f, 0.93258f}, 
				     {0.99059f, 0.93159f, 0.93159f}, {0.9906f, 0.9306f, 0.9306f}, 
				     {0.99061f, 0.92961f, 0.92961f}, {0.99062f, 0.92862f, 0.92862f}, 
				     {0.99063f, 0.92763f, 0.92763f}, {0.99064f, 0.92664f, 0.92664f}, 
				     {0.99065f, 0.92565f, 0.92565f}, {0.99066f, 0.92466f, 0.92466f}, 
				     {0.9906699999999999f, 0.92367f, 0.92367f}, {0.99068f, 0.92268f, 0.92268f}, 
				     {0.99069f, 0.92169f, 0.92169f}, {0.9907f, 0.9207f, 0.9207f}, 
				     {0.99071f, 0.91971f, 0.91971f}, {0.99072f, 0.91872f, 0.91872f}, 
				     {0.99073f, 0.9177299999999999f, 0.9177299999999999f}, 
				     {0.99074f, 0.91674f, 0.91674f}, {0.99075f, 0.91575f, 0.91575f}, 
				     {0.99076f, 0.91476f, 0.91476f}, {0.99077f, 0.91377f, 0.91377f}, 
				     {0.99078f, 0.91278f, 0.91278f}, {0.99079f, 0.91179f, 0.91179f}, 
				     {0.9908f, 0.9107999999999999f, 0.9107999999999999f}, 
				     {0.99081f, 0.90981f, 0.90981f}, {0.99082f, 0.90882f, 0.90882f}, 
				     {0.99083f, 0.90783f, 0.90783f}, {0.9908399999999999f, 0.90684f, 0.90684f}, 
				     {0.99085f, 0.90585f, 0.90585f}, {0.99086f, 0.90486f, 0.90486f}, 
				     {0.99087f, 0.90387f, 0.90387f}, {0.99088f, 0.90288f, 0.90288f}, 
				     {0.9908899999999999f, 0.90189f, 0.90189f}, {0.9909f, 0.9009f, 0.9009f}, 
				     {0.99091f, 0.89991f, 0.89991f}, {0.99092f, 0.8989199999999999f, 
								   0.8989199999999999f}, {0.99093f, 0.89793f, 0.89793f}, 
				     {0.99094f, 0.89694f, 0.89694f}, {0.99095f, 0.89595f, 0.89595f}, 
				     {0.99096f, 0.89496f, 0.89496f}, {0.99097f, 0.8939699999999999f, 
								   0.8939699999999999f}, {0.99098f, 0.89298f, 0.89298f}, 
				     {0.99099f, 0.89199f, 0.89199f}, {0.991f, 0.891f, 0.891f}, 
				     {0.99101f, 0.89001f, 0.89001f}, {0.99102f, 0.88902f, 0.88902f}, 
				     {0.99103f, 0.88803f, 0.88803f}, {0.99104f, 0.8870399999999999f, 
								   0.8870399999999999f}, {0.99105f, 0.88605f, 0.88605f}, 
				     {0.9910599999999999f, 0.88506f, 0.88506f}, {0.99107f, 0.88407f, 0.88407f}, 
				     {0.99108f, 0.88308f, 0.88308f}, {0.99109f, 0.88209f, 0.88209f}, 
				     {0.9911f, 0.8811f, 0.8811f}, {0.99111f, 0.88011f, 0.88011f}, 
				     {0.99112f, 0.87912f, 0.87912f}, {0.99113f, 0.87813f, 0.87813f}, 
				     {0.99114f, 0.87714f, 0.87714f}, {0.99115f, 0.87615f, 0.87615f}, 
				     {0.99116f, 0.8751599999999999f, 0.8751599999999999f}, 
				     {0.99117f, 0.87417f, 0.87417f}, {0.99118f, 0.87318f, 0.87318f}, 
				     {0.99119f, 0.87219f, 0.87219f}, {0.9912f, 0.8712f, 0.8712f}, 
				     {0.99121f, 0.87021f, 0.87021f}, {0.99122f, 0.86922f, 0.86922f}, 
				     {0.9912299999999999f, 0.86823f, 0.86823f}, {0.99124f, 0.86724f, 0.86724f}, 
				     {0.99125f, 0.86625f, 0.86625f}, {0.99126f, 0.86526f, 0.86526f}, 
				     {0.99127f, 0.86427f, 0.86427f}, {0.9912799999999999f, 0.86328f, 0.86328f}, 
				     {0.99129f, 0.86229f, 0.86229f}, {0.9913f, 0.8613f, 0.8613f}, 
				     {0.99131f, 0.86031f, 0.86031f}, {0.99132f, 0.85932f, 0.85932f}, 
				     {0.99133f, 0.85833f, 0.85833f}, {0.99134f, 0.85734f, 0.85734f}, 
				     {0.99135f, 0.85635f, 0.85635f}, {0.99136f, 0.85536f, 0.85536f}, 
				     {0.99137f, 0.85437f, 0.85437f}, {0.99138f, 0.85338f, 0.85338f}, 
				     {0.99139f, 0.85239f, 0.85239f}, {0.9914f, 0.8513999999999999f, 
								   0.8513999999999999f}, {0.99141f, 0.85041f, 0.85041f}, 
				     {0.99142f, 0.84942f, 0.84942f}, {0.99143f, 0.84843f, 0.84843f}, 
				     {0.99144f, 0.84744f, 0.84744f}, {0.9914499999999999f, 0.84645f, 0.84645f}, 
				     {0.99146f, 0.84546f, 0.84546f}, {0.99147f, 0.84447f, 0.84447f}, 
				     {0.99148f, 0.84348f, 0.84348f}, {0.99149f, 0.84249f, 0.84249f}, 
				     {0.9915f, 0.8415f, 0.8415f}, {0.99151f, 0.84051f, 0.84051f}, 
				     {0.99152f, 0.83952f, 0.83952f}, {0.99153f, 0.83853f, 0.83853f}, 
				     {0.99154f, 0.83754f, 0.83754f}, {0.99155f, 0.83655f, 0.83655f}, 
				     {0.99156f, 0.83556f, 0.83556f}, {0.99157f, 0.83457f, 0.83457f}, 
				     {0.99158f, 0.83358f, 0.83358f}, {0.99159f, 0.8325899999999999f, 
								   0.8325899999999999f}, {0.9916f, 0.8316f, 0.8316f}, {0.99161f, 0.83061f, 0.83061f}, 
				     {0.99162f, 0.82962f, 0.82962f}, {0.99163f, 0.82863f, 0.82863f}, 
				     {0.99164f, 0.8276399999999999f, 0.8276399999999999f}, 
				     {0.99165f, 0.82665f, 0.82665f}, {0.99166f, 0.82566f, 0.82566f}, 
				     {0.9916699999999999f, 0.82467f, 0.82467f}, {0.99168f, 0.82368f, 0.82368f}, 
				     {0.99169f, 0.8226899999999999f, 0.8226899999999999f}, {0.9917f, 0.8217f, 0.8217f}, 
				     {0.99171f, 0.8207099999999999f, 0.8207099999999999f}, 
				     {0.99172f, 0.81972f, 0.81972f}, {0.99173f, 0.81873f, 0.81873f}, 
				     {0.99174f, 0.8177399999999999f, 0.8177399999999999f}, 
				     {0.99175f, 0.81675f, 0.81675f}, {0.99176f, 0.81576f, 0.81576f}, 
				     {0.99177f, 0.81477f, 0.81477f}, {0.99178f, 0.81378f, 0.81378f}, 
				     {0.99179f, 0.81279f, 0.81279f}, {0.9918f, 0.8118f, 0.8118f}, 
				     {0.99181f, 0.81081f, 0.81081f}, {0.99182f, 0.80982f, 0.80982f}, 
				     {0.99183f, 0.8088299999999999f, 0.8088299999999999f}, 
				     {0.9918399999999999f, 0.80784f, 0.80784f}, {0.99185f, 0.80685f, 0.80685f}, 
				     {0.99186f, 0.80586f, 0.80586f}, {0.99187f, 0.80487f, 0.80487f}, 
				     {0.99188f, 0.8038799999999999f, 0.8038799999999999f}, 
				     {0.9918899999999999f, 0.80289f, 0.80289f}, {0.9919f, 0.8019000000000001f, 
									      0.8019000000000001f}, {0.99191f, 0.80091f, 0.80091f}, 
				     {0.99192f, 0.79992f, 0.79992f}, {0.99193f, 0.79893f, 0.79893f}, 
				     {0.99194f, 0.79794f, 0.79794f}, {0.99195f, 0.79695f, 0.79695f}, 
				     {0.99196f, 0.79596f, 0.79596f}, {0.99197f, 0.79497f, 0.79497f}, 
				     {0.99198f, 0.79398f, 0.79398f}, {0.99199f, 0.79299f, 0.79299f}, 
				     {0.992f, 0.792f, 0.792f}, {0.99201f, 0.79101f, 0.79101f}, 
				     {0.99202f, 0.79002f, 0.79002f}, {0.99203f, 0.78903f, 0.78903f}, 
				     {0.99204f, 0.78804f, 0.78804f}, {0.99205f, 0.78705f, 0.78705f}, 
				     {0.9920599999999999f, 0.78606f, 0.78606f}, {0.99207f, 0.7850699999999999f, 
									      0.7850699999999999f}, {0.99208f, 0.78408f, 0.78408f}, 
				     {0.99209f, 0.7830900000000001f, 0.7830900000000001f}, {0.9921f, 0.7821f, 0.7821f}, 
				     {0.99211f, 0.78111f, 0.78111f}, {0.99212f, 0.78012f, 0.78012f}, 
				     {0.99213f, 0.77913f, 0.77913f}, {0.99214f, 0.77814f, 0.77814f}, 
				     {0.99215f, 0.77715f, 0.77715f}, {0.99216f, 0.77616f, 0.77616f}, 
				     {0.99217f, 0.77517f, 0.77517f}, {0.99218f, 0.77418f, 0.77418f}, 
				     {0.99219f, 0.77319f, 0.77319f}, {0.9922f, 0.7722f, 0.7722f}, 
				     {0.99221f, 0.77121f, 0.77121f}, {0.99222f, 0.77022f, 0.77022f}, 
				     {0.99223f, 0.76923f, 0.76923f}, {0.99224f, 0.76824f, 0.76824f}, 
				     {0.99225f, 0.76725f, 0.76725f}, {0.99226f, 0.7662599999999999f, 
								   0.7662599999999999f}, {0.99227f, 0.76527f, 0.76527f}, 
				     {0.9922799999999999f, 0.76428f, 0.76428f}, {0.99229f, 0.76329f, 0.76329f}, 
				     {0.9923f, 0.7623f, 0.7623f}, {0.99231f, 0.7613099999999999f, 0.7613099999999999f}, 
				     {0.99232f, 0.76032f, 0.76032f}, {0.99233f, 0.75933f, 0.75933f}, 
				     {0.99234f, 0.75834f, 0.75834f}, {0.99235f, 0.75735f, 0.75735f}, 
				     {0.99236f, 0.7563599999999999f, 0.7563599999999999f}, 
				     {0.99237f, 0.75537f, 0.75537f}, {0.99238f, 0.7543799999999999f, 
								   0.7543799999999999f}, {0.99239f, 0.75339f, 0.75339f}, {0.9924f, 0.7524f, 0.7524f}, 
				     {0.99241f, 0.75141f, 0.75141f}, {0.99242f, 0.75042f, 0.75042f}, 
				     {0.99243f, 0.74943f, 0.74943f}, {0.99244f, 0.74844f, 0.74844f}, 
				     {0.9924499999999999f, 0.74745f, 0.74745f}, {0.99246f, 0.74646f, 0.74646f}, 
				     {0.99247f, 0.74547f, 0.74547f}, {0.99248f, 0.74448f, 0.74448f}, 
				     {0.99249f, 0.74349f, 0.74349f}, {0.9924999999999999f, 0.7424999999999999f, 
								   0.7424999999999999f}, {0.99251f, 0.74151f, 0.74151f}, 
				     {0.99252f, 0.74052f, 0.74052f}, {0.99253f, 0.73953f, 0.73953f}, 
				     {0.99254f, 0.73854f, 0.73854f}, {0.99255f, 0.7375499999999999f, 
								   0.7375499999999999f}, {0.99256f, 0.73656f, 0.73656f}, 
				     {0.99257f, 0.7355700000000001f, 0.7355700000000001f}, 
				     {0.99258f, 0.73458f, 0.73458f}, {0.99259f, 0.73359f, 0.73359f}, 
				     {0.9926f, 0.7325999999999999f, 0.7325999999999999f}, 
				     {0.99261f, 0.73161f, 0.73161f}, {0.99262f, 0.73062f, 0.73062f}, 
				     {0.99263f, 0.72963f, 0.72963f}, {0.99264f, 0.72864f, 0.72864f}, 
				     {0.99265f, 0.7276499999999999f, 0.7276499999999999f}, 
				     {0.99266f, 0.72666f, 0.72666f}, {0.9926699999999999f, 0.72567f, 0.72567f}, 
				     {0.99268f, 0.72468f, 0.72468f}, {0.99269f, 0.7236899999999999f, 
								   0.7236899999999999f}, {0.9927f, 0.7226999999999999f, 0.7226999999999999f}, 
				     {0.99271f, 0.72171f, 0.72171f}, {0.99272f, 0.72072f, 0.72072f}, 
				     {0.99273f, 0.71973f, 0.71973f}, {0.99274f, 0.7187399999999999f, 
								   0.7187399999999999f}, {0.99275f, 0.71775f, 0.71775f}, 
				     {0.99276f, 0.71676f, 0.71676f}, {0.99277f, 0.71577f, 0.71577f}, 
				     {0.99278f, 0.71478f, 0.71478f}, {0.99279f, 0.7137899999999999f, 
								   0.7137899999999999f}, {0.9928f, 0.7128f, 0.7128f}, 
				     {0.99281f, 0.7118099999999999f, 0.7118099999999999f}, 
				     {0.99282f, 0.71082f, 0.71082f}, {0.99283f, 0.70983f, 0.70983f}, 
				     {0.99284f, 0.7088399999999999f, 0.7088399999999999f}, 
				     {0.99285f, 0.70785f, 0.70785f}, {0.99286f, 0.70686f, 0.70686f}, 
				     {0.99287f, 0.70587f, 0.70587f}, {0.99288f, 0.70488f, 0.70488f}, 
				     {0.9928899999999999f, 0.70389f, 0.70389f}, {0.9929f, 0.7029000000000001f, 
									      0.7029000000000001f}, {0.99291f, 0.70191f, 0.70191f}, 
				     {0.99292f, 0.70092f, 0.70092f}, {0.99293f, 0.6999299999999999f, 
								   0.6999299999999999f}, {0.99294f, 0.69894f, 0.69894f}, 
				     {0.99295f, 0.6979500000000001f, 0.6979500000000001f}, 
				     {0.99296f, 0.69696f, 0.69696f}, {0.99297f, 0.69597f, 0.69597f}, 
				     {0.99298f, 0.6949799999999999f, 0.6949799999999999f}, 
				     {0.99299f, 0.69399f, 0.69399f}, {0.993f, 0.6930000000000001f, 
								   0.6930000000000001f}, {0.99301f, 0.69201f, 0.69201f}, 
				     {0.99302f, 0.69102f, 0.69102f}, {0.99303f, 0.6900299999999999f, 
								   0.6900299999999999f}, {0.99304f, 0.68904f, 0.68904f}, 
				     {0.99305f, 0.68805f, 0.68805f}, {0.9930599999999999f, 0.68706f, 0.68706f}, 
				     {0.99307f, 0.68607f, 0.68607f}, {0.99308f, 0.68508f, 0.68508f}, 
				     {0.99309f, 0.68409f, 0.68409f}, {0.9931f, 0.6831f, 0.6831f}, 
				     {0.99311f, 0.68211f, 0.68211f}, {0.99312f, 0.68112f, 0.68112f}, 
				     {0.99313f, 0.68013f, 0.68013f}, {0.99314f, 0.67914f, 0.67914f}, 
				     {0.99315f, 0.67815f, 0.67815f}, {0.99316f, 0.67716f, 0.67716f}, 
				     {0.99317f, 0.6761699999999999f, 0.6761699999999999f}, 
				     {0.99318f, 0.67518f, 0.67518f}, {0.99319f, 0.6741900000000001f, 
								   0.6741900000000001f}, {0.9932f, 0.6732f, 0.6732f}, {0.99321f, 0.67221f, 0.67221f}, 
				     {0.99322f, 0.6712199999999999f, 0.6712199999999999f}, 
				     {0.99323f, 0.67023f, 0.67023f}, {0.99324f, 0.6692400000000001f, 
								   0.6692400000000001f}, {0.99325f, 0.66825f, 0.66825f}, 
				     {0.99326f, 0.66726f, 0.66726f}, {0.99327f, 0.6662699999999999f, 
								   0.6662699999999999f}, {0.9932799999999999f, 0.66528f, 0.66528f}, 
				     {0.99329f, 0.66429f, 0.66429f}, {0.9933f, 0.6633f, 0.6633f}, 
				     {0.99331f, 0.66231f, 0.66231f}, {0.99332f, 0.6613199999999999f, 
								   0.6613199999999999f}, {0.99333f, 0.66033f, 0.66033f}, 
				     {0.99334f, 0.65934f, 0.65934f}, {0.99335f, 0.65835f, 0.65835f}, 
				     {0.99336f, 0.6573599999999999f, 0.6573599999999999f}, 
				     {0.99337f, 0.6563699999999999f, 0.6563699999999999f}, 
				     {0.99338f, 0.65538f, 0.65538f}, {0.99339f, 0.65439f, 0.65439f}, 
				     {0.9934f, 0.6534f, 0.6534f}, {0.99341f, 0.6524099999999999f, 0.6524099999999999f}, 
				     {0.99342f, 0.6514199999999999f, 0.6514199999999999f}, 
				     {0.99343f, 0.65043f, 0.65043f}, {0.99344f, 0.64944f, 0.64944f}, 
				     {0.9934499999999999f, 0.64845f, 0.64845f}, {0.99346f, 0.6474599999999999f, 
									      0.6474599999999999f}, {0.99347f, 0.64647f, 0.64647f}, 
				     {0.99348f, 0.6454799999999999f, 0.6454799999999999f}, 
				     {0.99349f, 0.64449f, 0.64449f}, {0.9935f, 0.6435f, 0.6435f}, 
				     {0.99351f, 0.6425099999999999f, 0.6425099999999999f}, 
				     {0.99352f, 0.6415200000000001f, 0.6415200000000001f}, 
				     {0.99353f, 0.64053f, 0.64053f}, {0.99354f, 0.63954f, 0.63954f}, 
				     {0.99355f, 0.63855f, 0.63855f}, {0.99356f, 0.63756f, 0.63756f}, 
				     {0.99357f, 0.6365700000000001f, 0.6365700000000001f}, 
				     {0.99358f, 0.63558f, 0.63558f}, {0.99359f, 0.63459f, 0.63459f}, 
				     {0.9936f, 0.6335999999999999f, 0.6335999999999999f}, 
				     {0.99361f, 0.63261f, 0.63261f}, {0.99362f, 0.6316200000000001f, 
								   0.6316200000000001f}, {0.99363f, 0.63063f, 0.63063f}, 
				     {0.99364f, 0.62964f, 0.62964f}, {0.99365f, 0.6286499999999999f, 
								   0.6286499999999999f}, {0.99366f, 0.62766f, 0.62766f}, 
				     {0.9936699999999999f, 0.6266700000000001f, 0.6266700000000001f}, 
				     {0.99368f, 0.62568f, 0.62568f}, {0.99369f, 0.62469f, 0.62469f}, 
				     {0.9937f, 0.6236999999999999f, 0.6236999999999999f}, 
				     {0.99371f, 0.62271f, 0.62271f}, {0.99372f, 0.62172f, 0.62172f}, 
				     {0.99373f, 0.62073f, 0.62073f}, {0.99374f, 0.61974f, 0.61974f}, 
				     {0.99375f, 0.61875f, 0.61875f}, {0.99376f, 0.61776f, 0.61776f}, 
				     {0.99377f, 0.61677f, 0.61677f}, {0.99378f, 0.61578f, 0.61578f}, 
				     {0.99379f, 0.61479f, 0.61479f}, {0.9938f, 0.6138f, 0.6138f}, 
				     {0.99381f, 0.61281f, 0.61281f}, {0.99382f, 0.61182f, 0.61182f}, 
				     {0.99383f, 0.61083f, 0.61083f}, {0.99384f, 0.6098399999999999f, 
								   0.6098399999999999f}, {0.99385f, 0.60885f, 0.60885f}, 
				     {0.99386f, 0.6078600000000001f, 0.6078600000000001f}, 
				     {0.99387f, 0.60687f, 0.60687f}, {0.99388f, 0.60588f, 0.60588f}, 
				     {0.9938899999999999f, 0.6048899999999999f, 0.6048899999999999f}, 
				     {0.9939f, 0.6039f, 0.6039f}, {0.99391f, 0.6029100000000001f, 0.6029100000000001f}, 
				     {0.99392f, 0.60192f, 0.60192f}, {0.99393f, 0.60093f, 0.60093f}, 
				     {0.99394f, 0.5999399999999999f, 0.5999399999999999f}, 
				     {0.99395f, 0.59895f, 0.59895f}, {0.99396f, 0.59796f, 0.59796f}, 
				     {0.99397f, 0.59697f, 0.59697f}, {0.99398f, 0.59598f, 0.59598f}, 
				     {0.99399f, 0.5949899999999999f, 0.5949899999999999f}, {0.994f, 0.594f, 0.594f}, 
				     {0.99401f, 0.59301f, 0.59301f}, {0.99402f, 0.59202f, 0.59202f}, 
				     {0.99403f, 0.5910299999999999f, 0.5910299999999999f}, 
				     {0.99404f, 0.5900399999999999f, 0.5900399999999999f}, 
				     {0.99405f, 0.58905f, 0.58905f}, {0.9940599999999999f, 0.58806f, 0.58806f}, 
				     {0.99407f, 0.58707f, 0.58707f}, {0.99408f, 0.5860799999999999f, 
								   0.5860799999999999f}, {0.99409f, 0.5850899999999999f, 0.5850899999999999f}, 
				     {0.9941f, 0.5841f, 0.5841f}, {0.99411f, 0.58311f, 0.58311f}, 
				     {0.99412f, 0.58212f, 0.58212f}, {0.99413f, 0.5811299999999999f, 
								   0.5811299999999999f}, {0.99414f, 0.5801399999999999f, 0.5801399999999999f}, 
				     {0.99415f, 0.5791499999999999f, 0.5791499999999999f}, 
				     {0.99416f, 0.57816f, 0.57816f}, {0.99417f, 0.57717f, 0.57717f}, 
				     {0.99418f, 0.57618f, 0.57618f}, {0.99419f, 0.5751900000000001f, 
								   0.5751900000000001f}, {0.9942f, 0.5742f, 0.5742f}, {0.99421f, 0.57321f, 0.57321f}, 
				     {0.99422f, 0.57222f, 0.57222f}, {0.99423f, 0.57123f, 0.57123f}, 
				     {0.99424f, 0.5702400000000001f, 0.5702400000000001f}, 
				     {0.99425f, 0.56925f, 0.56925f}, {0.99426f, 0.56826f, 0.56826f}, 
				     {0.99427f, 0.5672699999999999f, 0.5672699999999999f}, 
				     {0.9942799999999999f, 0.56628f, 0.56628f}, {0.99429f, 0.5652900000000001f, 
									      0.5652900000000001f}, {0.9943f, 0.5643f, 0.5643f}, {0.99431f, 0.56331f, 0.56331f}, 
				     {0.99432f, 0.5623199999999999f, 0.5623199999999999f}, 
				     {0.99433f, 0.56133f, 0.56133f}, {0.99434f, 0.5603400000000001f, 
								   0.5603400000000001f}, {0.99435f, 0.55935f, 0.55935f}, 
				     {0.99436f, 0.55836f, 0.55836f}, {0.99437f, 0.5573699999999999f, 
								   0.5573699999999999f}, {0.99438f, 0.55638f, 0.55638f}, 
				     {0.99439f, 0.55539f, 0.55539f}, {0.9944f, 0.5544f, 0.5544f}, 
				     {0.99441f, 0.55341f, 0.55341f}, {0.99442f, 0.5524199999999999f, 
								   0.5524199999999999f}, {0.99443f, 0.55143f, 0.55143f}, 
				     {0.99444f, 0.55044f, 0.55044f}, {0.99445f, 0.54945f, 0.54945f}, 
				     {0.99446f, 0.54846f, 0.54846f}, {0.99447f, 0.54747f, 0.54747f}, 
				     {0.99448f, 0.54648f, 0.54648f}, {0.99449f, 0.54549f, 0.54549f}, 
				     {0.9944999999999999f, 0.5445f, 0.5445f}, {0.99451f, 0.5435099999999999f, 
									    0.5435099999999999f}, {0.99452f, 0.54252f, 0.54252f}, 
				     {0.99453f, 0.54153f, 0.54153f}, {0.99454f, 0.54054f, 0.54054f}, 
				     {0.99455f, 0.53955f, 0.53955f}, {0.99456f, 0.5385599999999999f, 
								   0.5385599999999999f}, {0.99457f, 0.53757f, 0.53757f}, 
				     {0.99458f, 0.5365800000000001f, 0.5365800000000001f}, 
				     {0.99459f, 0.53559f, 0.53559f}, {0.9946f, 0.5346f, 0.5346f}, 
				     {0.99461f, 0.5336099999999999f, 0.5336099999999999f}, 
				     {0.99462f, 0.53262f, 0.53262f}, {0.99463f, 0.53163f, 0.53163f}, 
				     {0.99464f, 0.53064f, 0.53064f}, {0.99465f, 0.52965f, 0.52965f}, 
				     {0.99466f, 0.5286599999999999f, 0.5286599999999999f}, 
				     {0.9946699999999999f, 0.52767f, 0.52767f}, {0.99468f, 0.52668f, 0.52668f}, 
				     {0.99469f, 0.52569f, 0.52569f}, {0.9947f, 0.5246999999999999f, 
								   0.5246999999999999f}, {0.99471f, 0.5237099999999999f, 0.5237099999999999f}, 
				     {0.99472f, 0.52272f, 0.52272f}, {0.99473f, 0.52173f, 0.52173f}, 
				     {0.99474f, 0.52074f, 0.52074f}, {0.99475f, 0.5197499999999999f, 
								   0.5197499999999999f}, {0.99476f, 0.5187599999999999f, 0.5187599999999999f}, 
				     {0.99477f, 0.51777f, 0.51777f}, {0.99478f, 0.51678f, 0.51678f}, 
				     {0.99479f, 0.51579f, 0.51579f}, {0.9948f, 0.5148f, 0.5148f}, 
				     {0.99481f, 0.51381f, 0.51381f}, {0.99482f, 0.51282f, 0.51282f}, 
				     {0.99483f, 0.51183f, 0.51183f}, {0.99484f, 0.51084f, 0.51084f}, 
				     {0.99485f, 0.50985f, 0.50985f}, {0.99486f, 0.5088600000000001f, 
								   0.5088600000000001f}, {0.99487f, 0.50787f, 0.50787f}, 
				     {0.99488f, 0.50688f, 0.50688f}, {0.9948899999999999f, 0.50589f, 0.50589f}, 
				     {0.9949f, 0.5049f, 0.5049f}, {0.99491f, 0.5039100000000001f, 0.5039100000000001f}, 
				     {0.99492f, 0.50292f, 0.50292f}, {0.99493f, 0.50193f, 0.50193f}, 
				     {0.99494f, 0.5009399999999999f, 0.5009399999999999f}, 
				     {0.99495f, 0.49995f, 0.49995f}, {0.99496f, 0.49896f, 0.49896f}, 
				     {0.99497f, 0.49797f, 0.49797f}, {0.99498f, 0.49698f, 0.49698f}, 
				     {0.99499f, 0.49599f, 0.49599f}, {0.995f, 0.495f, 0.495f}, 
				     {0.99501f, 0.49401f, 0.49401f}, {0.99502f, 0.49302f, 0.49302f}, 
				     {0.99503f, 0.49202999999999997f, 0.49202999999999997f}, 
				     {0.99504f, 0.49104f, 0.49104f}, {0.99505f, 0.49005f, 0.49005f}, 
				     {0.99506f, 0.48905999999999994f, 0.48905999999999994f}, 
				     {0.99507f, 0.48807f, 0.48807f}, {0.99508f, 0.48707999999999996f, 
								   0.48707999999999996f}, {0.99509f, 0.48609f, 0.48609f}, 
				     {0.9951f, 0.4851f, 0.4851f}, {0.99511f, 0.48411000000000004f, 
								0.48411000000000004f}, {0.99512f, 0.48312f, 0.48312f}, 
				     {0.99513f, 0.48212999999999995f, 0.48212999999999995f}, 
				     {0.99514f, 0.48114f, 0.48114f}, {0.99515f, 0.48014999999999997f, 
								   0.48014999999999997f}, {0.99516f, 0.47916000000000003f, 0.47916000000000003f}, 
				     {0.99517f, 0.47817f, 0.47817f}, {0.99518f, 0.47717999999999994f, 
								   0.47717999999999994f}, {0.99519f, 0.47619f, 0.47619f}, 
				     {0.9952f, 0.47519999999999996f, 0.47519999999999996f}, 
				     {0.99521f, 0.47421f, 0.47421f}, {0.99522f, 0.47322f, 0.47322f}, 
				     {0.99523f, 0.4722299999999999f, 0.4722299999999999f}, 
				     {0.99524f, 0.47124f, 0.47124f}, {0.99525f, 0.47024999999999995f, 
								   0.47024999999999995f}, {0.99526f, 0.46926f, 0.46926f}, 
				     {0.99527f, 0.46826999999999996f, 0.46826999999999996f}, 
				     {0.9952799999999999f, 0.4672799999999999f, 0.4672799999999999f}, 
				     {0.99529f, 0.46629f, 0.46629f}, {0.9953f, 0.46529999999999994f, 
								   0.46529999999999994f}, {0.99531f, 0.46431f, 0.46431f}, 
				     {0.99532f, 0.46331999999999995f, 0.46331999999999995f}, 
				     {0.99533f, 0.46233f, 0.46233f}, {0.99534f, 0.46134f, 0.46134f}, 
				     {0.99535f, 0.4603499999999999f, 0.4603499999999999f}, 
				     {0.99536f, 0.45936f, 0.45936f}, {0.99537f, 0.45836999999999994f, 
								   0.45836999999999994f}, {0.99538f, 0.45738f, 0.45738f}, 
				     {0.99539f, 0.45638999999999996f, 0.45638999999999996f}, 
				     {0.9954f, 0.4553999999999999f, 0.4553999999999999f}, 
				     {0.99541f, 0.45441f, 0.45441f}, {0.99542f, 0.45341999999999993f, 
								   0.45341999999999993f}, {0.99543f, 0.45243f, 0.45243f}, 
				     {0.99544f, 0.45143999999999995f, 0.45143999999999995f}, 
				     {0.99545f, 0.4504499999999999f, 0.4504499999999999f}, 
				     {0.99546f, 0.44945999999999997f, 0.44945999999999997f}, 
				     {0.99547f, 0.4484699999999999f, 0.4484699999999999f}, 
				     {0.99548f, 0.44748f, 0.44748f}, {0.99549f, 0.44648999999999994f, 
								   0.44648999999999994f}, {0.9955f, 0.4455f, 0.4455f}, 
				     {0.99551f, 0.44450999999999996f, 0.44450999999999996f}, 
				     {0.99552f, 0.4435199999999999f, 0.4435199999999999f}, 
				     {0.99553f, 0.44253f, 0.44253f}, {0.99554f, 0.44153999999999993f, 
								   0.44153999999999993f}, {0.99555f, 0.44055f, 0.44055f}, 
				     {0.99556f, 0.43955999999999995f, 0.43955999999999995f}, 
				     {0.99557f, 0.4385699999999999f, 0.4385699999999999f}, 
				     {0.99558f, 0.43757999999999997f, 0.43757999999999997f}, 
				     {0.99559f, 0.4365899999999999f, 0.4365899999999999f}, {0.9956f, 0.4356f, 0.4356f}, 
				     {0.99561f, 0.43460999999999994f, 0.43460999999999994f}, 
				     {0.99562f, 0.4336199999999999f, 0.4336199999999999f}, 
				     {0.99563f, 0.43262999999999996f, 0.43262999999999996f}, 
				     {0.99564f, 0.4316399999999999f, 0.4316399999999999f}, 
				     {0.99565f, 0.43065f, 0.43065f}, {0.99566f, 0.42965999999999993f, 
								   0.42965999999999993f}, {0.9956699999999999f, 0.4286699999999999f, 
											  0.4286699999999999f}, {0.99568f, 0.42767999999999995f, 0.42767999999999995f}, 
				     {0.99569f, 0.4266899999999999f, 0.4266899999999999f}, 
				     {0.9957f, 0.42569999999999997f, 0.42569999999999997f}, 
				     {0.99571f, 0.4247099999999999f, 0.4247099999999999f}, 
				     {0.99572f, 0.42372f, 0.42372f}, {0.99573f, 0.42272999999999994f, 
								   0.42272999999999994f}, {0.99574f, 0.4217399999999999f, 0.4217399999999999f}, 
				     {0.99575f, 0.42074999999999996f, 0.42074999999999996f}, 
				     {0.99576f, 0.4197599999999999f, 0.4197599999999999f}, 
				     {0.99577f, 0.4187700000000001f, 0.4187700000000001f}, 
				     {0.99578f, 0.41778000000000004f, 0.41778000000000004f}, 
				     {0.99579f, 0.41679f, 0.41679f}, {0.9958f, 0.41580000000000006f, 
								   0.41580000000000006f}, {0.99581f, 0.41481f, 0.41481f}, 
				     {0.99582f, 0.4138200000000001f, 0.4138200000000001f}, 
				     {0.99583f, 0.41283000000000003f, 0.41283000000000003f}, 
				     {0.99584f, 0.41184f, 0.41184f}, {0.99585f, 0.41085000000000005f, 
								   0.41085000000000005f}, {0.99586f, 0.40986f, 0.40986f}, 
				     {0.99587f, 0.40887000000000007f, 0.40887000000000007f}, 
				     {0.99588f, 0.40788f, 0.40788f}, {0.9958899999999999f, 0.40689f, 0.40689f}, 
				     {0.9959f, 0.40590000000000004f, 0.40590000000000004f}, 
				     {0.99591f, 0.40491f, 0.40491f}, {0.99592f, 0.40392000000000006f, 
								   0.40392000000000006f}, {0.99593f, 0.40293f, 0.40293f}, 
				     {0.99594f, 0.4019400000000001f, 0.4019400000000001f}, 
				     {0.99595f, 0.40095000000000003f, 0.40095000000000003f}, 
				     {0.99596f, 0.39996f, 0.39996f}, {0.99597f, 0.39897000000000005f, 
								   0.39897000000000005f}, {0.99598f, 0.39798f, 0.39798f}, 
				     {0.99599f, 0.39699000000000007f, 0.39699000000000007f}, {0.996f, 0.396f, 0.396f}, 
				     {0.99601f, 0.39501f, 0.39501f}, {0.99602f, 0.39402000000000004f, 
								   0.39402000000000004f}, {0.99603f, 0.39303f, 0.39303f}, 
				     {0.99604f, 0.39204000000000006f, 0.39204000000000006f}, 
				     {0.99605f, 0.39105f, 0.39105f}, {0.99606f, 0.39005999999999996f, 
								   0.39005999999999996f}, {0.99607f, 0.38907f, 0.38907f}, 
				     {0.99608f, 0.38808f, 0.38808f}, {0.99609f, 0.38709000000000005f, 
								   0.38709000000000005f}, {0.9961f, 0.3861f, 0.3861f}, 
				     {0.99611f, 0.38511000000000006f, 0.38511000000000006f}, 
				     {0.99612f, 0.38412f, 0.38412f}, {0.99613f, 0.38312999999999997f, 
								   0.38312999999999997f}, {0.99614f, 0.38214000000000004f, 0.38214000000000004f}, 
				     {0.99615f, 0.38115f, 0.38115f}, {0.99616f, 0.38016000000000005f, 
								   0.38016000000000005f}, {0.99617f, 0.37917f, 0.37917f}, 
				     {0.99618f, 0.37817999999999996f, 0.37817999999999996f}, 
				     {0.99619f, 0.37719f, 0.37719f}, {0.9962f, 0.3762f, 0.3762f}, 
				     {0.99621f, 0.37521000000000004f, 0.37521000000000004f}, 
				     {0.99622f, 0.37422f, 0.37422f}, {0.99623f, 0.37322999999999995f, 
								   0.37322999999999995f}, {0.99624f, 0.37224f, 0.37224f}, 
				     {0.99625f, 0.37124999999999997f, 0.37124999999999997f}, 
				     {0.99626f, 0.37026000000000003f, 0.37026000000000003f}, 
				     {0.99627f, 0.36927f, 0.36927f}, {0.9962799999999999f, 0.36827999999999994f, 
								   0.36827999999999994f}, {0.99629f, 0.36729f, 0.36729f}, 
				     {0.9963f, 0.36629999999999996f, 0.36629999999999996f}, 
				     {0.99631f, 0.36531f, 0.36531f}, {0.99632f, 0.36432f, 0.36432f}, 
				     {0.99633f, 0.36333000000000004f, 0.36333000000000004f}, 
				     {0.99634f, 0.36234f, 0.36234f}, {0.99635f, 0.36134999999999995f, 
								   0.36134999999999995f}, {0.99636f, 0.36036f, 0.36036f}, 
				     {0.99637f, 0.35936999999999997f, 0.35936999999999997f}, 
				     {0.99638f, 0.35838000000000003f, 0.35838000000000003f}, 
				     {0.99639f, 0.35739f, 0.35739f}, {0.9964f, 0.35639999999999994f, 
								   0.35639999999999994f}, {0.99641f, 0.35541f, 0.35541f}, 
				     {0.99642f, 0.35441999999999996f, 0.35441999999999996f}, 
				     {0.99643f, 0.35343f, 0.35343f}, {0.99644f, 0.35244f, 0.35244f}, 
				     {0.99645f, 0.35144999999999993f, 0.35144999999999993f}, 
				     {0.99646f, 0.35046f, 0.35046f}, {0.99647f, 0.34946999999999995f, 
								   0.34946999999999995f}, {0.99648f, 0.34848f, 0.34848f}, 
				     {0.99649f, 0.34748999999999997f, 0.34748999999999997f}, 
				     {0.9964999999999999f, 0.34650000000000003f, 0.34650000000000003f}, 
				     {0.99651f, 0.34551f, 0.34551f}, {0.99652f, 0.34451999999999994f, 
								   0.34451999999999994f}, {0.99653f, 0.34353f, 0.34353f}, 
				     {0.99654f, 0.34253999999999996f, 0.34253999999999996f}, 
				     {0.99655f, 0.34155f, 0.34155f}, {0.99656f, 0.34056f, 0.34056f}, 
				     {0.99657f, 0.3395699999999999f, 0.3395699999999999f}, 
				     {0.99658f, 0.33858f, 0.33858f}, {0.99659f, 0.33758999999999995f, 
								   0.33758999999999995f}, {0.9966f, 0.3366f, 0.3366f}, 
				     {0.99661f, 0.33560999999999996f, 0.33560999999999996f}, 
				     {0.99662f, 0.3346199999999999f, 0.3346199999999999f}, 
				     {0.99663f, 0.33363f, 0.33363f}, {0.99664f, 0.33263999999999994f, 
								   0.33263999999999994f}, {0.99665f, 0.33165f, 0.33165f}, 
				     {0.99666f, 0.33065999999999995f, 0.33065999999999995f}, 
				     {0.99667f, 0.3296699999999999f, 0.3296699999999999f}, 
				     {0.99668f, 0.32867999999999997f, 0.32867999999999997f}, 
				     {0.99669f, 0.3276899999999999f, 0.3276899999999999f}, {0.9967f, 0.3267f, 0.3267f}, 
				     {0.99671f, 0.32570999999999994f, 0.32570999999999994f}, 
				     {0.99672f, 0.32472f, 0.32472f}, {0.99673f, 0.32372999999999996f, 
								   0.32372999999999996f}, {0.99674f, 0.3227399999999999f, 0.3227399999999999f}, 
				     {0.99675f, 0.32175f, 0.32175f}, {0.99676f, 0.32075999999999993f, 
								   0.32075999999999993f}, {0.99677f, 0.31977f, 0.31977f}, 
				     {0.99678f, 0.31877999999999995f, 0.31877999999999995f}, 
				     {0.99679f, 0.3177899999999999f, 0.3177899999999999f}, 
				     {0.9968f, 0.31679999999999997f, 0.31679999999999997f}, 
				     {0.99681f, 0.3158099999999999f, 0.3158099999999999f}, 
				     {0.99682f, 0.31482f, 0.31482f}, {0.99683f, 0.31382999999999994f, 
								   0.31382999999999994f}, {0.99684f, 0.3128399999999999f, 0.3128399999999999f}, 
				     {0.99685f, 0.31184999999999996f, 0.31184999999999996f}, 
				     {0.99686f, 0.3108599999999999f, 0.3108599999999999f}, 
				     {0.99687f, 0.30987f, 0.30987f}, {0.99688f, 0.30887999999999993f, 
								   0.30887999999999993f}, {0.9968899999999999f, 0.3078899999999999f, 
											  0.3078899999999999f}, {0.9969f, 0.30689999999999995f, 0.30689999999999995f}, 
				     {0.99691f, 0.3059099999999999f, 0.3059099999999999f}, 
				     {0.99692f, 0.30491999999999997f, 0.30491999999999997f}, 
				     {0.99693f, 0.3039299999999999f, 0.3039299999999999f}, 
				     {0.99694f, 0.30294f, 0.30294f}, {0.99695f, 0.30194999999999994f, 
								   0.30194999999999994f}, {0.99696f, 0.3009599999999999f, 0.3009599999999999f}, 
				     {0.99697f, 0.29996999999999996f, 0.29996999999999996f}, 
				     {0.99698f, 0.2989799999999999f, 0.2989799999999999f}, 
				     {0.99699f, 0.29799f, 0.29799f}, {0.997f, 0.29699999999999993f, 
								   0.29699999999999993f}, {0.99701f, 0.2960099999999999f, 0.2960099999999999f}, 
				     {0.99702f, 0.29501999999999995f, 0.29501999999999995f}, 
				     {0.99703f, 0.2940299999999999f, 0.2940299999999999f}, 
				     {0.99704f, 0.2930400000000001f, 0.2930400000000001f}, 
				     {0.99705f, 0.29205000000000003f, 0.29205000000000003f}, 
				     {0.99706f, 0.29106f, 0.29106f}, {0.99707f, 0.29007000000000005f, 
								   0.29007000000000005f}, {0.99708f, 0.28908f, 0.28908f}, 
				     {0.99709f, 0.28809000000000007f, 0.28809000000000007f}, 
				     {0.9971f, 0.2871f, 0.2871f}, {0.99711f, 0.2861100000000001f, 0.2861100000000001f}, 
				     {0.99712f, 0.28512000000000004f, 0.28512000000000004f}, 
				     {0.99713f, 0.28413f, 0.28413f}, {0.99714f, 0.28314000000000006f, 
								   0.28314000000000006f}, {0.99715f, 0.28215f, 0.28215f}, 
				     {0.99716f, 0.2811600000000001f, 0.2811600000000001f}, 
				     {0.99717f, 0.28017000000000003f, 0.28017000000000003f}, 
				     {0.99718f, 0.27918f, 0.27918f}, {0.99719f, 0.27819000000000005f, 
								   0.27819000000000005f}, {0.9972f, 0.2772f, 0.2772f}, 
				     {0.99721f, 0.27621000000000007f, 0.27621000000000007f}, 
				     {0.99722f, 0.27522f, 0.27522f}, {0.99723f, 0.27423f, 0.27423f}, 
				     {0.99724f, 0.27324000000000004f, 0.27324000000000004f}, 
				     {0.99725f, 0.27225f, 0.27225f}, {0.99726f, 0.27126000000000006f, 
								   0.27126000000000006f}, {0.99727f, 0.27027f, 0.27027f}, 
				     {0.9972799999999999f, 0.26927999999999996f, 0.26927999999999996f}, 
				     {0.99729f, 0.26829000000000003f, 0.26829000000000003f}, 
				     {0.9973f, 0.2673f, 0.2673f}, {0.99731f, 0.26631000000000005f, 
								0.26631000000000005f}, {0.99732f, 0.26532f, 0.26532f}, 
				     {0.99733f, 0.26433000000000006f, 0.26433000000000006f}, 
				     {0.99734f, 0.26334f, 0.26334f}, {0.99735f, 0.26234999999999997f, 
								   0.26234999999999997f}, {0.99736f, 0.26136000000000004f, 0.26136000000000004f}, 
				     {0.99737f, 0.26037f, 0.26037f}, {0.99738f, 0.25938000000000005f, 
								   0.25938000000000005f}, {0.99739f, 0.25839f, 0.25839f}, 
				     {0.9974f, 0.25739999999999996f, 0.25739999999999996f}, 
				     {0.99741f, 0.25641f, 0.25641f}, {0.99742f, 0.25542f, 0.25542f}, 
				     {0.99743f, 0.25443000000000005f, 0.25443000000000005f}, 
				     {0.99744f, 0.25344f, 0.25344f}, {0.99745f, 0.25244999999999995f, 
								   0.25244999999999995f}, {0.99746f, 0.25146f, 0.25146f}, 
				     {0.99747f, 0.25046999999999997f, 0.25046999999999997f}, 
				     {0.99748f, 0.24948000000000004f, 0.24948000000000004f}, 
				     {0.99749f, 0.24849f, 0.24849f}, {0.9975f, 0.24750000000000005f, 
								   0.24750000000000005f}, {0.99751f, 0.24651f, 0.24651f}, 
				     {0.99752f, 0.24551999999999996f, 0.24551999999999996f}, 
				     {0.99753f, 0.24453000000000003f, 0.24453000000000003f}, 
				     {0.99754f, 0.24353999999999998f, 0.24353999999999998f}, 
				     {0.99755f, 0.24255000000000004f, 0.24255000000000004f}, 
				     {0.99756f, 0.24156f, 0.24156f}, {0.99757f, 0.24056999999999995f, 
								   0.24056999999999995f}, {0.99758f, 0.23958000000000002f, 0.23958000000000002f}, 
				     {0.99759f, 0.23858999999999997f, 0.23858999999999997f}, 
				     {0.9976f, 0.23760000000000003f, 0.23760000000000003f}, 
				     {0.99761f, 0.23661f, 0.23661f}, {0.99762f, 0.23561999999999994f, 
								   0.23561999999999994f}, {0.99763f, 0.23463f, 0.23463f}, 
				     {0.99764f, 0.23363999999999996f, 0.23363999999999996f}, 
				     {0.99765f, 0.23265000000000002f, 0.23265000000000002f}, 
				     {0.99766f, 0.23165999999999998f, 0.23165999999999998f}, 
				     {0.99767f, 0.23066999999999993f, 0.23066999999999993f}, 
				     {0.99768f, 0.22968f, 0.22968f}, {0.99769f, 0.22868999999999995f, 
								   0.22868999999999995f}, {0.9977f, 0.2277f, 0.2277f}, 
				     {0.99771f, 0.22670999999999997f, 0.22670999999999997f}, 
				     {0.99772f, 0.22572000000000003f, 0.22572000000000003f}, 
				     {0.99773f, 0.22472999999999999f, 0.22472999999999999f}, 
				     {0.99774f, 0.22373999999999994f, 0.22373999999999994f}, 
				     {0.99775f, 0.22275f, 0.22275f}, {0.99776f, 0.22175999999999996f, 
								   0.22175999999999996f}, {0.99777f, 0.22077000000000002f, 0.22077000000000002f}, 
				     {0.99778f, 0.21977999999999998f, 0.21977999999999998f}, 
				     {0.99779f, 0.21878999999999993f, 0.21878999999999993f}, 
				     {0.9978f, 0.2178f, 0.2178f}, {0.99781f, 0.21680999999999995f, 
								0.21680999999999995f}, {0.99782f, 0.21582f, 0.21582f}, 
				     {0.99783f, 0.21482999999999997f, 0.21482999999999997f}, 
				     {0.99784f, 0.21383999999999992f, 0.21383999999999992f}, 
				     {0.99785f, 0.21284999999999998f, 0.21284999999999998f}, 
				     {0.99786f, 0.21185999999999994f, 0.21185999999999994f}, 
				     {0.99787f, 0.21087f, 0.21087f}, {0.99788f, 0.20987999999999996f, 
								   0.20987999999999996f}, {0.9978899999999999f, 0.2088899999999999f, 
											  0.2088899999999999f}, {0.9979f, 0.20789999999999997f, 0.20789999999999997f}, 
				     {0.99791f, 0.20690999999999993f, 0.20690999999999993f}, 
				     {0.99792f, 0.20592f, 0.20592f}, {0.99793f, 0.20492999999999995f, 
								   0.20492999999999995f}, {0.99794f, 0.20394f, 0.20394f}, 
				     {0.99795f, 0.20294999999999996f, 0.20294999999999996f}, 
				     {0.99796f, 0.20195999999999992f, 0.20195999999999992f}, 
				     {0.99797f, 0.20096999999999998f, 0.20096999999999998f}, 
				     {0.99798f, 0.19997999999999994f, 0.19997999999999994f}, 
				     {0.99799f, 0.19899f, 0.19899f}, {0.998f, 0.19799999999999995f, 
								   0.19799999999999995f}, {0.99801f, 0.1970099999999999f, 0.1970099999999999f}, 
				     {0.99802f, 0.19601999999999997f, 0.19601999999999997f}, 
				     {0.99803f, 0.19502999999999993f, 0.19502999999999993f}, 
				     {0.99804f, 0.19404f, 0.19404f}, {0.99805f, 0.19304999999999994f, 
								   0.19304999999999994f}, {0.99806f, 0.1920599999999999f, 0.1920599999999999f}, 
				     {0.99807f, 0.19106999999999996f, 0.19106999999999996f}, 
				     {0.99808f, 0.19007999999999992f, 0.19007999999999992f}, 
				     {0.99809f, 0.18908999999999998f, 0.18908999999999998f}, 
				     {0.9981f, 0.18809999999999993f, 0.18809999999999993f}, 
				     {0.99811f, 0.18711f, 0.18711f}, {0.99812f, 0.18611999999999995f, 
								   0.18611999999999995f}, {0.99813f, 0.1851299999999999f, 0.1851299999999999f}, 
				     {0.99814f, 0.18413999999999997f, 0.18413999999999997f}, 
				     {0.99815f, 0.18314999999999992f, 0.18314999999999992f}, 
				     {0.99816f, 0.18216f, 0.18216f}, {0.99817f, 0.18116999999999994f, 
								   0.18116999999999994f}, {0.99818f, 0.1801799999999999f, 0.1801799999999999f}, 
				     {0.99819f, 0.17918999999999996f, 0.17918999999999996f}, 
				     {0.9982f, 0.17819999999999991f, 0.17819999999999991f}, 
				     {0.99821f, 0.17720999999999998f, 0.17720999999999998f}, 
				     {0.99822f, 0.17621999999999993f, 0.17621999999999993f}, 
				     {0.99823f, 0.17522999999999989f, 0.17522999999999989f}, 
				     {0.99824f, 0.17423999999999995f, 0.17423999999999995f}, 
				     {0.99825f, 0.1732499999999999f, 0.1732499999999999f}, 
				     {0.99826f, 0.17225999999999997f, 0.17225999999999997f}, 
				     {0.99827f, 0.17126999999999992f, 0.17126999999999992f}, 
				     {0.99828f, 0.17027999999999988f, 0.17027999999999988f}, 
				     {0.99829f, 0.16928999999999994f, 0.16928999999999994f}, 
				     {0.9983f, 0.1682999999999999f, 0.1682999999999999f}, 
				     {0.99831f, 0.16730999999999996f, 0.16730999999999996f}, 
				     {0.99832f, 0.1663199999999999f, 0.1663199999999999f}, 
				     {0.99833f, 0.1653300000000001f, 0.1653300000000001f}, 
				     {0.99834f, 0.16434000000000004f, 0.16434000000000004f}, 
				     {0.99835f, 0.16335f, 0.16335f}, {0.99836f, 0.16236000000000006f, 
								   0.16236000000000006f}, {0.99837f, 0.16137f, 0.16137f}, 
				     {0.99838f, 0.16038000000000008f, 0.16038000000000008f}, 
				     {0.99839f, 0.15939000000000003f, 0.15939000000000003f}, 
				     {0.9984f, 0.15839999999999999f, 0.15839999999999999f}, 
				     {0.99841f, 0.15741000000000005f, 0.15741000000000005f}, 
				     {0.99842f, 0.15642f, 0.15642f}, {0.99843f, 0.15543000000000007f, 
								   0.15543000000000007f}, {0.99844f, 0.15444000000000002f, 0.15444000000000002f}, 
				     {0.99845f, 0.15344999999999998f, 0.15344999999999998f}, 
				     {0.99846f, 0.15246000000000004f, 0.15246000000000004f}, 
				     {0.99847f, 0.15147f, 0.15147f}, {0.99848f, 0.15048000000000006f, 
								   0.15048000000000006f}, {0.99849f, 0.14949f, 0.14949f}, 
				     {0.9984999999999999f, 0.14849999999999997f, 0.14849999999999997f}, 
				     {0.99851f, 0.14751000000000003f, 0.14751000000000003f}, 
				     {0.99852f, 0.14651999999999998f, 0.14651999999999998f}, 
				     {0.99853f, 0.14553000000000005f, 0.14553000000000005f}, 
				     {0.99854f, 0.14454f, 0.14454f}, {0.99855f, 0.14355000000000007f, 
								   0.14355000000000007f}, {0.99856f, 0.14256000000000002f, 0.14256000000000002f}, 
				     {0.99857f, 0.14156999999999997f, 0.14156999999999997f}, 
				     {0.99858f, 0.14058000000000004f, 0.14058000000000004f}, 
				     {0.99859f, 0.13959f, 0.13959f}, {0.9986f, 0.13860000000000006f, 
								   0.13860000000000006f}, {0.99861f, 0.13761f, 0.13761f}, 
				     {0.99862f, 0.13661999999999996f, 0.13661999999999996f}, 
				     {0.99863f, 0.13563000000000003f, 0.13563000000000003f}, 
				     {0.99864f, 0.13463999999999998f, 0.13463999999999998f}, 
				     {0.99865f, 0.13365000000000005f, 0.13365000000000005f}, 
				     {0.99866f, 0.13266f, 0.13266f}, {0.99867f, 0.13166999999999995f, 
								   0.13166999999999995f}, {0.99868f, 0.13068000000000002f, 0.13068000000000002f}, 
				     {0.99869f, 0.12968999999999997f, 0.12968999999999997f}, 
				     {0.9987f, 0.12870000000000004f, 0.12870000000000004f}, 
				     {0.99871f, 0.12771f, 0.12771f}, {0.99872f, 0.12672000000000005f, 
								   0.12672000000000005f}, {0.99873f, 0.12573f, 0.12573f}, 
				     {0.99874f, 0.12473999999999996f, 0.12473999999999996f}, 
				     {0.99875f, 0.12375000000000003f, 0.12375000000000003f}, 
				     {0.99876f, 0.12275999999999998f, 0.12275999999999998f}, 
				     {0.99877f, 0.12177000000000004f, 0.12177000000000004f}, 
				     {0.99878f, 0.12078f, 0.12078f}, {0.99879f, 0.11978999999999995f, 
								   0.11978999999999995f}, {0.9988f, 0.11880000000000002f, 0.11880000000000002f}, 
				     {0.99881f, 0.11780999999999997f, 0.11780999999999997f}, 
				     {0.99882f, 0.11682000000000003f, 0.11682000000000003f}, 
				     {0.99883f, 0.11582999999999999f, 0.11582999999999999f}, 
				     {0.99884f, 0.11483999999999994f, 0.11483999999999994f}, 
				     {0.99885f, 0.11385f, 0.11385f}, {0.99886f, 0.11285999999999996f, 
								   0.11285999999999996f}, {0.99887f, 0.11187000000000002f, 0.11187000000000002f}, 
				     {0.99888f, 0.11087999999999998f, 0.11087999999999998f}, 
				     {0.99889f, 0.10988999999999993f, 0.10988999999999993f}, 
				     {0.9989f, 0.1089f, 0.1089f}, {0.99891f, 0.10790999999999995f, 
								0.10790999999999995f}, {0.99892f, 0.10692000000000002f, 0.10692000000000002f}, 
				     {0.99893f, 0.10592999999999997f, 0.10592999999999997f}, 
				     {0.99894f, 0.10494000000000003f, 0.10494000000000003f}, 
				     {0.99895f, 0.10394999999999999f, 0.10394999999999999f}, 
				     {0.99896f, 0.10295999999999994f, 0.10295999999999994f}, 
				     {0.99897f, 0.10197f, 0.10197f}, {0.99898f, 0.10097999999999996f, 
								   0.10097999999999996f}, {0.99899f, 0.09999000000000002f, 0.09999000000000002f}, 
				     {0.999f, 0.09899999999999998f, 0.09899999999999998f}, 
				     {0.99901f, 0.09800999999999993f, 0.09800999999999993f}, 
				     {0.99902f, 0.09702f, 0.09702f}, {0.99903f, 0.09602999999999995f, 
								   0.09602999999999995f}, {0.99904f, 0.09504000000000001f, 0.09504000000000001f}, 
				     {0.99905f, 0.09404999999999997f, 0.09404999999999997f}, 
				     {0.99906f, 0.09305999999999992f, 0.09305999999999992f}, 
				     {0.99907f, 0.09206999999999999f, 0.09206999999999999f}, 
				     {0.99908f, 0.09107999999999994f, 0.09107999999999994f}, 
				     {0.99909f, 0.09009f, 0.09009f}, {0.9991f, 0.08909999999999996f, 
								   0.08909999999999996f}, {0.99911f, 0.08811000000000002f, 0.08811000000000002f}, 
				     {0.99912f, 0.08711999999999998f, 0.08711999999999998f}, 
				     {0.99913f, 0.08612999999999993f, 0.08612999999999993f}, 
				     {0.99914f, 0.08514f, 0.08514f}, {0.99915f, 0.08414999999999995f, 
								   0.08414999999999995f}, {0.99916f, 0.08316000000000001f, 0.08316000000000001f}, 
				     {0.99917f, 0.08216999999999997f, 0.08216999999999997f}, 
				     {0.99918f, 0.08117999999999992f, 0.08117999999999992f}, 
				     {0.99919f, 0.08018999999999998f, 0.08018999999999998f}, 
				     {0.9992f, 0.07919999999999994f, 0.07919999999999994f}, 
				     {0.99921f, 0.07821f, 0.07821f}, {0.99922f, 0.07721999999999996f, 
								   0.07721999999999996f}, {0.99923f, 0.07622999999999991f, 0.07622999999999991f}, 
				     {0.99924f, 0.07523999999999997f, 0.07523999999999997f}, 
				     {0.99925f, 0.07424999999999993f, 0.07424999999999993f}, 
				     {0.99926f, 0.07325999999999999f, 0.07325999999999999f}, 
				     {0.99927f, 0.07226999999999995f, 0.07226999999999995f}, 
				     {0.99928f, 0.0712799999999999f, 0.0712799999999999f}, 
				     {0.99929f, 0.07028999999999996f, 0.07028999999999996f}, 
				     {0.9993f, 0.06929999999999992f, 0.06929999999999992f}, 
				     {0.99931f, 0.06830999999999998f, 0.06830999999999998f}, 
				     {0.99932f, 0.06731999999999994f, 0.06731999999999994f}, 
				     {0.99933f, 0.06633f, 0.06633f}, {0.99934f, 0.06533999999999995f, 
								   0.06533999999999995f}, {0.99935f, 0.06434999999999991f, 0.06434999999999991f}, 
				     {0.99936f, 0.06335999999999997f, 0.06335999999999997f}, 
				     {0.99937f, 0.062369999999999925f, 0.062369999999999925f}, 
				     {0.99938f, 0.06137999999999999f, 0.06137999999999999f}, 
				     {0.99939f, 0.060389999999999944f, 0.060389999999999944f}, 
				     {0.9994f, 0.0593999999999999f, 0.0593999999999999f}, 
				     {0.99941f, 0.05840999999999996f, 0.05840999999999996f}, 
				     {0.99942f, 0.057419999999999916f, 0.057419999999999916f}, 
				     {0.99943f, 0.05642999999999998f, 0.05642999999999998f}, 
				     {0.99944f, 0.055439999999999934f, 0.055439999999999934f}, 
				     {0.99945f, 0.05444999999999989f, 0.05444999999999989f}, 
				     {0.99946f, 0.05345999999999995f, 0.05345999999999995f}, 
				     {0.99947f, 0.052469999999999906f, 0.052469999999999906f}, 
				     {0.99948f, 0.05147999999999997f, 0.05147999999999997f}, 
				     {0.99949f, 0.050489999999999924f, 0.050489999999999924f}, 
				     {0.9995f, 0.04949999999999999f, 0.04949999999999999f}, 
				     {0.99951f, 0.04850999999999994f, 0.04850999999999994f}, 
				     {0.99952f, 0.047519999999999896f, 0.047519999999999896f}, 
				     {0.99953f, 0.04652999999999996f, 0.04652999999999996f}, 
				     {0.99954f, 0.045539999999999914f, 0.045539999999999914f}, 
				     {0.99955f, 0.04454999999999998f, 0.04454999999999998f}, 
				     {0.99956f, 0.04355999999999993f, 0.04355999999999993f}, 
				     {0.99957f, 0.042569999999999886f, 0.042569999999999886f}, 
				     {0.99958f, 0.04157999999999995f, 0.04157999999999995f}, 
				     {0.99959f, 0.040589999999999904f, 0.040589999999999904f}, 
				     {0.9996f, 0.03960000000000008f, 0.03960000000000008f}, 
				     {0.99961f, 0.03861000000000003f, 0.03861000000000003f}, 
				     {0.99962f, 0.03761999999999999f, 0.03761999999999999f}, 
				     {0.99963f, 0.03663000000000005f, 0.03663000000000005f}, 
				     {0.99964f, 0.035640000000000005f, 0.035640000000000005f}, 
				     {0.99965f, 0.03465000000000007f, 0.03465000000000007f}, 
				     {0.99966f, 0.03366000000000002f, 0.03366000000000002f}, 
				     {0.99967f, 0.03266999999999998f, 0.03266999999999998f}, 
				     {0.99968f, 0.03168000000000004f, 0.03168000000000004f}, 
				     {0.99969f, 0.030689999999999995f, 0.030689999999999995f}, 
				     {0.9997f, 0.02970000000000006f, 0.02970000000000006f}, 
				     {0.99971f, 0.028710000000000013f, 0.028710000000000013f}, 
				     {0.99972f, 0.027720000000000078f, 0.027720000000000078f}, 
				     {0.99973f, 0.02673000000000003f, 0.02673000000000003f}, 
				     {0.99974f, 0.025739999999999985f, 0.025739999999999985f}, 
				     {0.99975f, 0.02475000000000005f, 0.02475000000000005f}, 
				     {0.99976f, 0.023760000000000003f, 0.023760000000000003f}, 
				     {0.99977f, 0.022770000000000068f, 0.022770000000000068f}, 
				     {0.99978f, 0.02178000000000002f, 0.02178000000000002f}, 
				     {0.99979f, 0.020789999999999975f, 0.020789999999999975f}, 
				     {0.9998f, 0.01980000000000004f, 0.01980000000000004f}, 
				     {0.99981f, 0.018809999999999993f, 0.018809999999999993f}, 
				     {0.99982f, 0.017820000000000058f, 0.017820000000000058f}, 
				     {0.99983f, 0.01683000000000001f, 0.01683000000000001f}, 
				     {0.99984f, 0.015839999999999965f, 0.015839999999999965f}, 
				     {0.99985f, 0.01485000000000003f, 0.01485000000000003f}, 
				     {0.99986f, 0.013859999999999983f, 0.013859999999999983f}, 
				     {0.99987f, 0.012870000000000048f, 0.012870000000000048f}, 
				     {0.99988f, 0.011880000000000002f, 0.011880000000000002f}, 
				     {0.99989f, 0.010889999999999955f, 0.010889999999999955f}, 
				     {0.9999f, 0.00990000000000002f, 0.00990000000000002f}, 
				     {0.99991f, 0.008909999999999973f, 0.008909999999999973f}, 
				     {0.99992f, 0.007920000000000038f, 0.007920000000000038f}, 
				     {0.99993f, 0.006929999999999992f, 0.006929999999999992f}, 
				     {0.99994f, 0.005940000000000056f, 0.005940000000000056f}, 
				     {0.99995f, 0.00495000000000001f, 0.00495000000000001f}, 
				     {0.99996f, 0.0039599999999999635f, 0.0039599999999999635f}, 
				     {0.99997f, 0.002970000000000028f, 0.002970000000000028f}, 
				     {0.99998f, 0.0019799999999999818f, 0.0019799999999999818f}, 
				     {0.99999f, 0.0009900000000000464f, 0.0009900000000000464f}, {1.f, 0.f, 0.f}};
float palette_grey[1001][3]={{0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, 
			     {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 
											  0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 
																			      0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}, {0.99f, 0.99f, 0.99f}};

/*11 class divergin */
float palette_primary[1001][3]={{0.6196078431372549f, 0.00392156862745098f, 0.2588235294117647f},
				{0.621764705882353f, 0.006313725490196077f, 0.2593333333333333f},
				{0.623921568627451f, 0.008705882352941174f, 0.25984313725490193f},
				{0.626078431372549f, 0.011098039215686273f, 0.26035294117647056f},
				{0.6282352941176471f, 0.01349019607843137f, 0.2608627450980392f},
				{0.6303921568627451f, 0.01588235294117647f, 0.2613725490196078f},
				{0.6325490196078432f, 0.018274509803921566f, 0.26188235294117646f},
				{0.6347058823529412f, 0.020666666666666663f, 0.2623921568627451f},
				{0.6368627450980392f, 0.02305882352941176f, 0.2629019607843137f},
				{0.6390196078431373f, 0.025450980392156857f, 0.26341176470588235f},
				{0.6411764705882353f, 0.027843137254901958f, 0.263921568627451f},
				{0.6433333333333333f, 0.03023529411764705f, 0.2644313725490196f},
				{0.6454901960784314f, 0.03262745098039215f, 0.26494117647058824f},
				{0.6476470588235295f, 0.03501960784313725f, 0.2654509803921568f},
				{0.6498039215686274f, 0.037411764705882346f, 0.26596078431372544f},
				{0.6519607843137255f, 0.03980392156862744f, 0.26647058823529407f},
				{0.6541176470588236f, 0.04219607843137254f, 0.2669803921568627f},
				{0.6562745098039215f, 0.044588235294117644f, 0.26749019607843133f},
				{0.6584313725490196f, 0.046980392156862734f, 0.26799999999999996f},
				{0.6605882352941177f, 0.04937254901960783f, 0.2685098039215686f},
				{0.6627450980392157f, 0.051764705882352935f, 0.2690196078431372f},
				{0.6649019607843137f, 0.05415686274509803f, 0.26952941176470585f},
				{0.6670588235294118f, 0.05654901960784312f, 0.2700392156862745f},
				{0.6692156862745098f, 0.058941176470588226f, 0.2705490196078431f},
				{0.6713725490196079f, 0.06133333333333332f, 0.27105882352941174f},
				{0.6735294117647059f, 0.06372549019607843f, 0.27156862745098037f},
				{0.6756862745098039f, 0.0661176470588235f, 0.272078431372549f},
				{0.677843137254902f, 0.06850980392156861f, 0.27258823529411763f},
				{0.68f, 0.07090196078431371f, 0.27309803921568626f},
				{0.682156862745098f, 0.07329411764705882f, 0.2736078431372549f},
				{0.6843137254901961f, 0.0756862745098039f, 0.2741176470588235f},
				{0.6864705882352942f, 0.07807843137254901f, 0.27462745098039215f},
				{0.6886274509803921f, 0.0804705882352941f, 0.2751372549019608f},
				{0.6907843137254902f, 0.0828627450980392f, 0.2756470588235294f},
				{0.6929411764705883f, 0.08525490196078431f, 0.27615686274509804f},
				{0.6950980392156862f, 0.0876470588235294f, 0.27666666666666667f},
				{0.6972549019607843f, 0.09003921568627449f, 0.2771764705882353f},
				{0.6994117647058824f, 0.09243137254901959f, 0.2776862745098039f},
				{0.7015686274509804f, 0.09482352941176468f, 0.2781960784313725f},
				{0.7037254901960784f, 0.09721568627450979f, 0.27870588235294114f},
				{0.7058823529411765f, 0.09960784313725489f, 0.27921568627450977f},
				{0.7080392156862745f, 0.10199999999999998f, 0.2797254901960784f},
				{0.7101960784313726f, 0.10439215686274508f, 0.280235294117647f},
				{0.7123529411764706f, 0.10678431372549016f, 0.28074509803921566f},
				{0.7145098039215686f, 0.10917647058823526f, 0.2812549019607843f},
				{0.7166666666666667f, 0.11156862745098037f, 0.2817647058823529f},
				{0.7188235294117648f, 0.11396078431372547f, 0.28227450980392155f},
				{0.7209803921568627f, 0.11635294117647056f, 0.2827843137254902f},
				{0.7231372549019608f, 0.11874509803921567f, 0.2832941176470588f},
				{0.7252941176470589f, 0.12113725490196077f, 0.28380392156862744f},
				{0.7274509803921569f, 0.12352941176470586f, 0.28431372549019607f},
				{0.7296078431372549f, 0.12592156862745096f, 0.2848235294117647f},
				{0.731764705882353f, 0.12831372549019604f, 0.2853333333333333f},
				{0.733921568627451f, 0.13070588235294117f, 0.28584313725490196f},
				{0.736078431372549f, 0.13309803921568625f, 0.2863529411764706f},
				{0.7382352941176471f, 0.13549019607843132f, 0.2868627450980392f},
				{0.7403921568627451f, 0.13788235294117646f, 0.28737254901960785f},
				{0.7425490196078431f, 0.14027450980392153f, 0.2878823529411765f},
				{0.7447058823529412f, 0.14266666666666666f, 0.2883921568627451f},
				{0.7468627450980392f, 0.14505882352941174f, 0.28890196078431374f},
				{0.7490196078431373f, 0.14745098039215682f, 0.28941176470588237f},
				{0.7511764705882353f, 0.14984313725490195f, 0.289921568627451f},
				{0.7533333333333334f, 0.15223529411764702f, 0.29043137254901963f},
				{0.7554901960784314f, 0.1546274509803921f, 0.29094117647058826f},
				{0.7576470588235295f, 0.15701960784313723f, 0.2914509803921569f},
				{0.7598039215686274f, 0.1594117647058823f, 0.29196078431372546f},
				{0.7619607843137255f, 0.16180392156862744f, 0.2924705882352941f},
				{0.7641176470588236f, 0.16419607843137252f, 0.2929803921568627f},
				{0.7662745098039216f, 0.16658823529411765f, 0.29349019607843135f},
				{0.7684313725490196f, 0.16898039215686272f, 0.294f},
				{0.7705882352941177f, 0.1713725490196078f, 0.2945098039215686f},
				{0.7727450980392156f, 0.17376470588235288f, 0.29501960784313724f},
				{0.7749019607843137f, 0.176156862745098f, 0.2955294117647059f},
				{0.7770588235294118f, 0.17854901960784308f, 0.2960392156862745f},
				{0.7792156862745098f, 0.18094117647058822f, 0.29654901960784313f},
				{0.7813725490196078f, 0.1833333333333333f, 0.29705882352941176f},
				{0.7835294117647059f, 0.18572549019607837f, 0.2975686274509804f},
				{0.7856862745098039f, 0.1881176470588235f, 0.298078431372549f},
				{0.787843137254902f, 0.19050980392156858f, 0.29858823529411765f},
				{0.79f, 0.1929019607843137f, 0.2990980392156863f},
				{0.7921568627450981f, 0.19529411764705878f, 0.2996078431372549f},
				{0.7943137254901961f, 0.19768627450980386f, 0.30011764705882354f},
				{0.7964705882352942f, 0.200078431372549f, 0.3006274509803922f},
				{0.7986274509803921f, 0.20247058823529407f, 0.3011372549019608f},
				{0.8007843137254902f, 0.2048627450980392f, 0.30164705882352943f},
				{0.8029411764705883f, 0.20725490196078428f, 0.30215686274509806f},
				{0.8050980392156862f, 0.20964705882352935f, 0.30266666666666664f},
				{0.8072549019607843f, 0.21203921568627443f, 0.30317647058823527f},
				{0.8094117647058824f, 0.21443137254901956f, 0.3036862745098039f},
				{0.8115686274509804f, 0.21682352941176464f, 0.30419607843137253f},
				{0.8137254901960784f, 0.21921568627450977f, 0.30470588235294116f},
				{0.8158823529411765f, 0.22160784313725485f, 0.3052156862745098f},
				{0.8180392156862746f, 0.22399999999999998f, 0.3057254901960784f},
				{0.8201960784313725f, 0.22639215686274505f, 0.30623529411764705f},
				{0.8223529411764706f, 0.22878431372549013f, 0.3067450980392157f},
				{0.8245098039215686f, 0.23117647058823526f, 0.3072549019607843f},
				{0.8266666666666667f, 0.23356862745098034f, 0.30776470588235294f},
				{0.8288235294117647f, 0.23596078431372547f, 0.30827450980392157f},
				{0.8309803921568628f, 0.23835294117647055f, 0.3087843137254902f},
				{0.8331372549019608f, 0.24074509803921562f, 0.30929411764705883f},
				{0.8352941176470589f, 0.24313725490196078f, 0.30980392156862746f},
				{0.8365098039215687f, 0.24498039215686274f, 0.30933333333333335f},
				{0.8377254901960784f, 0.2468235294117647f, 0.30886274509803924f},
				{0.8389411764705883f, 0.24866666666666667f, 0.3083921568627451f},
				{0.840156862745098f, 0.25050980392156863f, 0.307921568627451f},
				{0.8413725490196079f, 0.25235294117647056f, 0.30745098039215685f},
				{0.8425882352941176f, 0.25419607843137254f, 0.30698039215686274f},
				{0.8438039215686275f, 0.2560392156862745f, 0.3065098039215686f},
				{0.8450196078431372f, 0.25788235294117645f, 0.3060392156862745f},
				{0.8462352941176471f, 0.25972549019607843f, 0.3055686274509804f},
				{0.8474509803921568f, 0.26156862745098036f, 0.3050980392156863f},
				{0.8486666666666667f, 0.26341176470588235f, 0.3046274509803922f},
				{0.8498823529411765f, 0.26525490196078433f, 0.30415686274509807f},
				{0.8510980392156863f, 0.26709803921568626f, 0.30368627450980396f},
				{0.8523137254901961f, 0.26894117647058824f, 0.3032156862745098f},
				{0.8535294117647059f, 0.27078431372549017f, 0.3027450980392157f},
				{0.8547450980392157f, 0.27262745098039215f, 0.30227450980392156f},
				{0.8559607843137255f, 0.27447058823529413f, 0.30180392156862745f},
				{0.8571764705882353f, 0.27631372549019606f, 0.30133333333333334f},
				{0.8583921568627451f, 0.27815686274509804f, 0.30086274509803923f},
				{0.8596078431372549f, 0.27999999999999997f, 0.3003921568627451f},
				{0.8608235294117648f, 0.28184313725490195f, 0.299921568627451f},
				{0.8620392156862745f, 0.2836862745098039f, 0.2994509803921569f},
				{0.8632549019607844f, 0.28552941176470586f, 0.29898039215686273f},
				{0.8644705882352941f, 0.28737254901960785f, 0.2985098039215686f},
				{0.865686274509804f, 0.2892156862745098f, 0.2980392156862745f},
				{0.8669019607843137f, 0.29105882352941176f, 0.2975686274509804f},
				{0.8681176470588235f, 0.29290196078431374f, 0.2970980392156863f},
				{0.8693333333333333f, 0.29474509803921567f, 0.29662745098039217f},
				{0.8705490196078431f, 0.29658823529411765f, 0.29615686274509806f},
				{0.871764705882353f, 0.2984313725490196f, 0.29568627450980395f},
				{0.8729803921568627f, 0.30027450980392156f, 0.29521568627450984f},
				{0.8741960784313726f, 0.3021176470588235f, 0.29474509803921567f},
				{0.8754117647058823f, 0.3039607843137255f, 0.29427450980392156f},
				{0.8766274509803922f, 0.30580392156862746f, 0.29380392156862745f},
				{0.8778431372549019f, 0.3076470588235294f, 0.29333333333333333f},
				{0.8790588235294118f, 0.30949019607843137f, 0.2928627450980392f},
				{0.8802745098039215f, 0.3113333333333333f, 0.2923921568627451f},
				{0.8814901960784314f, 0.3131764705882353f, 0.291921568627451f},
				{0.8827058823529411f, 0.3150196078431372f, 0.2914509803921569f},
				{0.883921568627451f, 0.3168627450980392f, 0.2909803921568628f},
				{0.8851372549019608f, 0.31870588235294117f, 0.29050980392156867f},
				{0.8863529411764706f, 0.3205490196078431f, 0.2900392156862745f},
				{0.8875686274509804f, 0.3223921568627451f, 0.2895686274509804f},
				{0.8887843137254902f, 0.32423529411764707f, 0.2890980392156863f},
				{0.89f, 0.326078431372549f, 0.28862745098039216f},
				{0.8912156862745098f, 0.327921568627451f, 0.28815686274509805f},
				{0.8924313725490196f, 0.3297647058823529f, 0.28768627450980394f},
				{0.8936470588235293f, 0.3316078431372549f, 0.28721568627450983f},
				{0.8948627450980392f, 0.3334509803921568f, 0.2867450980392157f},
				{0.896078431372549f, 0.3352941176470588f, 0.28627450980392155f},
				{0.8972941176470588f, 0.3371372549019608f, 0.28580392156862744f},
				{0.8985098039215687f, 0.3389803921568627f, 0.2853333333333333f},
				{0.8997254901960784f, 0.3408235294117647f, 0.2848627450980392f},
				{0.9009411764705882f, 0.3426666666666667f, 0.2843921568627451f},
				{0.902156862745098f, 0.3445098039215686f, 0.283921568627451f},
				{0.9033725490196078f, 0.3463529411764706f, 0.2834509803921569f},
				{0.9045882352941176f, 0.3481960784313725f, 0.28298039215686277f},
				{0.9058039215686274f, 0.3500392156862745f, 0.28250980392156866f},
				{0.9070196078431372f, 0.3518823529411764f, 0.28203921568627455f},
				{0.908235294117647f, 0.3537254901960784f, 0.2815686274509804f},
				{0.9094509803921569f, 0.3555686274509804f, 0.28109803921568627f},
				{0.9106666666666666f, 0.3574117647058823f, 0.28062745098039216f},
				{0.9118823529411765f, 0.3592549019607843f, 0.28015686274509805f},
				{0.9130980392156862f, 0.3610980392156863f, 0.27968627450980393f},
				{0.9143137254901961f, 0.3629411764705882f, 0.2792156862745098f},
				{0.9155294117647058f, 0.3647843137254902f, 0.2787450980392157f},
				{0.9167450980392157f, 0.3666274509803921f, 0.2782745098039216f},
				{0.9179607843137254f, 0.3684705882352941f, 0.27780392156862743f},
				{0.9191764705882353f, 0.37031372549019603f, 0.2773333333333333f},
				{0.9203921568627451f, 0.372156862745098f, 0.2768627450980392f},
				{0.9216078431372549f, 0.374f, 0.2763921568627451f},
				{0.9228235294117646f, 0.3758431372549019f, 0.275921568627451f},
				{0.9240392156862745f, 0.37768627450980385f, 0.2754509803921569f},
				{0.9252549019607843f, 0.37952941176470584f, 0.27498039215686276f},
				{0.926470588235294f, 0.3813725490196078f, 0.27450980392156865f},
				{0.9276862745098039f, 0.38321568627450975f, 0.27403921568627454f},
				{0.9289019607843136f, 0.38505882352941173f, 0.27356862745098043f},
				{0.9301176470588235f, 0.3869019607843137f, 0.27309803921568626f},
				{0.9313333333333333f, 0.38874509803921564f, 0.27262745098039215f},
				{0.9325490196078431f, 0.3905882352941176f, 0.27215686274509804f},
				{0.9337647058823529f, 0.3924313725490196f, 0.2716862745098039f},
				{0.9349803921568627f, 0.39427450980392154f, 0.2712156862745098f},
				{0.9361960784313725f, 0.3961176470588235f, 0.2707450980392157f},
				{0.9374117647058823f, 0.3979607843137255f, 0.2702745098039216f},
				{0.9386274509803921f, 0.39980392156862743f, 0.2698039215686275f},
				{0.9398431372549019f, 0.40164705882352936f, 0.26933333333333337f},
				{0.9410588235294117f, 0.40349019607843134f, 0.2688627450980392f},
				{0.9422745098039215f, 0.4053333333333333f, 0.2683921568627451f},
				{0.9434901960784313f, 0.40717647058823525f, 0.267921568627451f},
				{0.9447058823529411f, 0.4090196078431372f, 0.26745098039215687f},
				{0.9459215686274509f, 0.4108627450980392f, 0.26698039215686276f},
				{0.9471372549019608f, 0.41270588235294114f, 0.26650980392156864f},
				{0.9483529411764705f, 0.41454901960784307f, 0.26603921568627453f},
				{0.9495686274509804f, 0.41639215686274506f, 0.2655686274509804f},
				{0.9507843137254901f, 0.41823529411764704f, 0.2650980392156863f},
				{0.952f, 0.42007843137254897f, 0.26462745098039214f},
				{0.9532156862745097f, 0.42192156862745095f, 0.26415686274509803f},
				{0.9544313725490196f, 0.42376470588235293f, 0.2636862745098039f},
				{0.9556470588235293f, 0.42560784313725486f, 0.2632156862745098f},
				{0.9568627450980391f, 0.42745098039215684f, 0.2627450980392157f},
				{0.9572156862745097f, 0.43f, 0.263921568627451f},
				{0.9575686274509804f, 0.43254901960784314f, 0.2650980392156863f},
				{0.9579215686274509f, 0.43509803921568624f, 0.2662745098039216f},
				{0.9582745098039215f, 0.4376470588235294f, 0.26745098039215687f},
				{0.958627450980392f, 0.44019607843137254f, 0.26862745098039215f},
				{0.9589803921568627f, 0.4427450980392157f, 0.2698039215686275f},
				{0.9593333333333333f, 0.4452941176470588f, 0.27098039215686276f},
				{0.9596862745098038f, 0.44784313725490194f, 0.27215686274509804f},
				{0.9600392156862745f, 0.4503921568627451f, 0.2733333333333333f},
				{0.960392156862745f, 0.45294117647058824f, 0.27450980392156865f},
				{0.9607450980392156f, 0.45549019607843133f, 0.27568627450980393f},
				{0.9610980392156863f, 0.4580392156862745f, 0.2768627450980392f},
				{0.9614509803921568f, 0.46058823529411763f, 0.2780392156862745f},
				{0.9618039215686274f, 0.4631372549019608f, 0.2792156862745098f},
				{0.962156862745098f, 0.46568627450980393f, 0.2803921568627451f},
				{0.9625098039215686f, 0.468235294117647f, 0.2815686274509804f},
				{0.9628627450980392f, 0.4707843137254902f, 0.2827450980392157f},
				{0.9632156862745097f, 0.47333333333333333f, 0.283921568627451f},
				{0.9635686274509804f, 0.4758823529411765f, 0.28509803921568627f},
				{0.9639215686274509f, 0.4784313725490196f, 0.28627450980392155f},
				{0.9642745098039215f, 0.4809803921568627f, 0.2874509803921569f},
				{0.9646274509803922f, 0.4835294117647059f, 0.28862745098039216f},
				{0.9649803921568627f, 0.486078431372549f, 0.28980392156862744f},
				{0.9653333333333333f, 0.4886274509803922f, 0.2909803921568627f},
				{0.9656862745098038f, 0.49117647058823527f, 0.29215686274509806f},
				{0.9660392156862745f, 0.4937254901960784f, 0.29333333333333333f},
				{0.966392156862745f, 0.49627450980392157f, 0.2945098039215686f},
				{0.9667450980392156f, 0.49882352941176467f, 0.2956862745098039f},
				{0.9670980392156863f, 0.5013725490196078f, 0.2968627450980392f},
				{0.9674509803921568f, 0.503921568627451f, 0.2980392156862745f},
				{0.9678039215686274f, 0.5064705882352941f, 0.2992156862745098f},
				{0.968156862745098f, 0.5090196078431373f, 0.3003921568627451f},
				{0.9685098039215686f, 0.5115686274509804f, 0.3015686274509804f},
				{0.9688627450980392f, 0.5141176470588236f, 0.3027450980392157f},
				{0.9692156862745098f, 0.5166666666666666f, 0.303921568627451f},
				{0.9695686274509804f, 0.5192156862745098f, 0.3050980392156863f},
				{0.9699215686274509f, 0.5217647058823529f, 0.30627450980392157f},
				{0.9702745098039215f, 0.5243137254901961f, 0.30745098039215685f},
				{0.9706274509803922f, 0.5268627450980392f, 0.3086274509803921f},
				{0.9709803921568627f, 0.5294117647058824f, 0.30980392156862746f},
				{0.9713333333333333f, 0.5319607843137255f, 0.31098039215686274f},
				{0.9716862745098039f, 0.5345098039215687f, 0.312156862745098f},
				{0.9720392156862745f, 0.5370588235294117f, 0.31333333333333335f},
				{0.972392156862745f, 0.5396078431372549f, 0.31450980392156863f},
				{0.9727450980392156f, 0.542156862745098f, 0.3156862745098039f},
				{0.9730980392156863f, 0.5447058823529412f, 0.3168627450980392f},
				{0.9734509803921568f, 0.5472549019607843f, 0.3180392156862745f},
				{0.9738039215686274f, 0.5498039215686275f, 0.3192156862745098f},
				{0.974156862745098f, 0.5523529411764706f, 0.3203921568627451f},
				{0.9745098039215686f, 0.5549019607843138f, 0.32156862745098036f},
				{0.9748627450980392f, 0.5574509803921568f, 0.3227450980392157f},
				{0.9752156862745098f, 0.56f, 0.323921568627451f},
				{0.9755686274509804f, 0.5625490196078431f, 0.32509803921568625f},
				{0.9759215686274509f, 0.5650980392156862f, 0.3262745098039216f},
				{0.9762745098039216f, 0.5676470588235294f, 0.32745098039215687f},
				{0.9766274509803922f, 0.5701960784313725f, 0.32862745098039214f},
				{0.9769803921568627f, 0.5727450980392157f, 0.3298039215686274f},
				{0.9773333333333333f, 0.5752941176470588f, 0.3309803921568627f},
				{0.9776862745098039f, 0.577843137254902f, 0.33215686274509804f},
				{0.9780392156862745f, 0.580392156862745f, 0.3333333333333333f},
				{0.978392156862745f, 0.5829411764705883f, 0.3345098039215686f},
				{0.9787450980392157f, 0.5854901960784313f, 0.33568627450980393f},
				{0.9790980392156863f, 0.5880392156862745f, 0.3368627450980392f},
				{0.9794509803921568f, 0.5905882352941176f, 0.3380392156862745f},
				{0.9798039215686274f, 0.5931372549019608f, 0.3392156862745098f},
				{0.9801568627450981f, 0.5956862745098039f, 0.3403921568627451f},
				{0.9805098039215686f, 0.5982352941176471f, 0.3415686274509804f},
				{0.9808627450980392f, 0.6007843137254902f, 0.34274509803921566f},
				{0.9812156862745098f, 0.6033333333333334f, 0.34392156862745094f},
				{0.9815686274509804f, 0.6058823529411765f, 0.34509803921568627f},
				{0.981921568627451f, 0.6084313725490196f, 0.34627450980392155f},
				{0.9822745098039216f, 0.6109803921568627f, 0.3474509803921568f},
				{0.9826274509803922f, 0.6135294117647059f, 0.34862745098039216f},
				{0.9829803921568627f, 0.616078431372549f, 0.34980392156862744f},
				{0.9833333333333334f, 0.6186274509803922f, 0.3509803921568627f},
				{0.983686274509804f, 0.6211764705882353f, 0.352156862745098f},
				{0.9840392156862745f, 0.6237254901960785f, 0.3533333333333333f},
				{0.9843921568627451f, 0.6262745098039215f, 0.3545098039215686f},
				{0.9847450980392157f, 0.6288235294117647f, 0.3556862745098039f},
				{0.9850980392156863f, 0.6313725490196078f, 0.35686274509803917f},
				{0.9854509803921568f, 0.633921568627451f, 0.3580392156862745f},
				{0.9858039215686275f, 0.6364705882352941f, 0.3592156862745098f},
				{0.9861568627450981f, 0.6390196078431373f, 0.36039215686274506f},
				{0.9865098039215686f, 0.6415686274509804f, 0.3615686274509804f},
				{0.9868627450980393f, 0.6441176470588236f, 0.3627450980392157f},
				{0.9872156862745098f, 0.6466666666666666f, 0.36392156862745095f},
				{0.9875686274509804f, 0.6492156862745098f, 0.36509803921568623f},
				{0.987921568627451f, 0.6517647058823529f, 0.3662745098039215f},
				{0.9882745098039216f, 0.6543137254901961f, 0.36745098039215685f},
				{0.9886274509803922f, 0.6568627450980392f, 0.3686274509803921f},
				{0.9889803921568627f, 0.6594117647058824f, 0.3698039215686274f},
				{0.9893333333333334f, 0.6619607843137255f, 0.37098039215686274f},
				{0.989686274509804f, 0.6645098039215687f, 0.372156862745098f},
				{0.9900392156862745f, 0.6670588235294117f, 0.3733333333333333f},
				{0.9903921568627452f, 0.669607843137255f, 0.37450980392156863f},
				{0.9907450980392157f, 0.672156862745098f, 0.3756862745098039f},
				{0.9910980392156863f, 0.6747058823529412f, 0.3768627450980392f},
				{0.9914509803921568f, 0.6772549019607843f, 0.37803921568627447f},
				{0.9918039215686275f, 0.6798039215686275f, 0.3792156862745098f},
				{0.9921568627450981f, 0.6823529411764706f, 0.3803921568627451f},
				{0.9921960784313726f, 0.6843137254901961f, 0.38203921568627447f},
				{0.9922352941176471f, 0.6862745098039216f, 0.3836862745098039f},
				{0.9922745098039216f, 0.6882352941176471f, 0.3853333333333333f},
				{0.9923137254901961f, 0.6901960784313725f, 0.38698039215686275f},
				{0.9923529411764707f, 0.692156862745098f, 0.38862745098039214f},
				{0.9923921568627452f, 0.6941176470588235f, 0.39027450980392153f},
				{0.9924313725490196f, 0.696078431372549f, 0.391921568627451f},
				{0.9924705882352941f, 0.6980392156862745f, 0.39356862745098037f},
				{0.9925098039215686f, 0.7000000000000001f, 0.39521568627450976f},
				{0.9925490196078431f, 0.7019607843137255f, 0.3968627450980392f},
				{0.9925882352941177f, 0.703921568627451f, 0.3985098039215686f},
				{0.9926274509803922f, 0.7058823529411765f, 0.40015686274509804f},
				{0.9926666666666667f, 0.707843137254902f, 0.40180392156862743f},
				{0.9927058823529412f, 0.7098039215686275f, 0.4034509803921568f},
				{0.9927450980392157f, 0.711764705882353f, 0.40509803921568627f},
				{0.9927843137254903f, 0.7137254901960784f, 0.40674509803921566f},
				{0.9928235294117648f, 0.7156862745098039f, 0.4083921568627451f},
				{0.9928627450980393f, 0.7176470588235294f, 0.4100392156862745f},
				{0.9929019607843137f, 0.7196078431372549f, 0.4116862745098039f},
				{0.9929411764705882f, 0.7215686274509804f, 0.41333333333333333f},
				{0.9929803921568627f, 0.7235294117647059f, 0.4149803921568627f},
				{0.9930196078431373f, 0.7254901960784313f, 0.4166274509803921f},
				{0.9930588235294118f, 0.7274509803921568f, 0.41827450980392156f},
				{0.9930980392156863f, 0.7294117647058823f, 0.41992156862745095f},
				{0.9931372549019608f, 0.7313725490196079f, 0.42156862745098034f},
				{0.9931764705882353f, 0.7333333333333334f, 0.4232156862745098f},
				{0.9932156862745098f, 0.7352941176470589f, 0.4248627450980392f},
				{0.9932549019607844f, 0.7372549019607844f, 0.4265098039215686f},
				{0.9932941176470589f, 0.7392156862745098f, 0.428156862745098f},
				{0.9933333333333334f, 0.7411764705882353f, 0.4298039215686274f},
				{0.9933725490196079f, 0.7431372549019608f, 0.43145098039215685f},
				{0.9934117647058823f, 0.7450980392156863f, 0.43309803921568624f},
				{0.9934509803921568f, 0.7470588235294118f, 0.4347450980392157f},
				{0.9934901960784314f, 0.7490196078431373f, 0.4363921568627451f},
				{0.9935294117647059f, 0.7509803921568627f, 0.43803921568627446f},
				{0.9935686274509804f, 0.7529411764705882f, 0.4396862745098039f},
				{0.9936078431372549f, 0.7549019607843137f, 0.4413333333333333f},
				{0.9936470588235294f, 0.7568627450980392f, 0.4429803921568627f},
				{0.993686274509804f, 0.7588235294117647f, 0.44462745098039214f},
				{0.9937254901960785f, 0.7607843137254902f, 0.4462745098039215f},
				{0.993764705882353f, 0.7627450980392156f, 0.44792156862745097f},
				{0.9938039215686275f, 0.7647058823529412f, 0.44956862745098036f},
				{0.993843137254902f, 0.7666666666666666f, 0.45121568627450975f},
				{0.9938823529411764f, 0.7686274509803922f, 0.4528627450980392f},
				{0.993921568627451f, 0.7705882352941177f, 0.4545098039215686f},
				{0.9939607843137255f, 0.7725490196078432f, 0.45615686274509804f},
				{0.994f, 0.7745098039215687f, 0.4578039215686274f},
				{0.9940392156862745f, 0.7764705882352941f, 0.4594509803921568f},
				{0.994078431372549f, 0.7784313725490196f, 0.46109803921568626f},
				{0.9941176470588236f, 0.7803921568627451f, 0.46274509803921565f},
				{0.9941568627450981f, 0.7823529411764706f, 0.46439215686274504f},
				{0.9941960784313726f, 0.7843137254901961f, 0.4660392156862745f},
				{0.9942352941176471f, 0.7862745098039216f, 0.4676862745098039f},
				{0.9942745098039216f, 0.788235294117647f, 0.46933333333333327f},
				{0.9943137254901961f, 0.7901960784313725f, 0.4709803921568627f},
				{0.9943529411764707f, 0.792156862745098f, 0.4726274509803921f},
				{0.9943921568627451f, 0.7941176470588236f, 0.47427450980392155f},
				{0.9944313725490196f, 0.7960784313725491f, 0.47592156862745094f},
				{0.9944705882352941f, 0.7980392156862746f, 0.47756862745098033f},
				{0.9945098039215686f, 0.8f, 0.4792156862745098f},
				{0.9945490196078431f, 0.8019607843137255f, 0.48086274509803917f},
				{0.9945882352941177f, 0.803921568627451f, 0.4825098039215686f},
				{0.9946274509803922f, 0.8058823529411765f, 0.484156862745098f},
				{0.9946666666666667f, 0.807843137254902f, 0.4858039215686274f},
				{0.9947058823529412f, 0.8098039215686275f, 0.48745098039215684f},
				{0.9947450980392157f, 0.8117647058823529f, 0.48909803921568623f},
				{0.9947843137254903f, 0.8137254901960784f, 0.4907450980392156f},
				{0.9948235294117648f, 0.8156862745098039f, 0.49239215686274507f},
				{0.9948627450980392f, 0.8176470588235294f, 0.4940392156862745f},
				{0.9949019607843137f, 0.8196078431372549f, 0.4956862745098039f},
				{0.9949411764705882f, 0.8215686274509804f, 0.4973333333333333f},
				{0.9949803921568627f, 0.8235294117647058f, 0.4989803921568627f},
				{0.9950196078431373f, 0.8254901960784313f, 0.5006274509803921f},
				{0.9950588235294118f, 0.8274509803921568f, 0.5022745098039215f},
				{0.9950980392156863f, 0.8294117647058823f, 0.503921568627451f},
				{0.9951372549019608f, 0.8313725490196078f, 0.5055686274509803f},
				{0.9951764705882353f, 0.8333333333333333f, 0.5072156862745097f},
				{0.9952156862745098f, 0.8352941176470589f, 0.5088627450980392f},
				{0.9952549019607844f, 0.8372549019607843f, 0.5105098039215685f},
				{0.9952941176470589f, 0.8392156862745098f, 0.512156862745098f},
				{0.9953333333333334f, 0.8411764705882353f, 0.5138039215686274f},
				{0.9953725490196078f, 0.8431372549019608f, 0.5154509803921569f},
				{0.9954117647058823f, 0.8450980392156863f, 0.5170980392156862f},
				{0.9954509803921568f, 0.8470588235294118f, 0.5187450980392156f},
				{0.9954901960784314f, 0.8490196078431372f, 0.5203921568627451f},
				{0.9955294117647059f, 0.8509803921568627f, 0.5220392156862744f},
				{0.9955686274509804f, 0.8529411764705882f, 0.5236862745098039f},
				{0.9956078431372549f, 0.8549019607843137f, 0.5253333333333333f},
				{0.9956470588235294f, 0.8568627450980392f, 0.5269803921568627f},
				{0.995686274509804f, 0.8588235294117647f, 0.5286274509803921f},
				{0.9957254901960785f, 0.8607843137254902f, 0.5302745098039215f},
				{0.995764705882353f, 0.8627450980392157f, 0.531921568627451f},
				{0.9958039215686275f, 0.8647058823529412f, 0.5335686274509803f},
				{0.9958431372549019f, 0.8666666666666667f, 0.5352156862745098f},
				{0.9958823529411764f, 0.8686274509803922f, 0.5368627450980392f},
				{0.995921568627451f, 0.8705882352941177f, 0.5385098039215686f},
				{0.9959607843137255f, 0.8725490196078431f, 0.540156862745098f},
				{0.996f, 0.8745098039215686f, 0.5418039215686274f},
				{0.9960392156862745f, 0.8764705882352941f, 0.5434509803921568f},
				{0.996078431372549f, 0.8784313725490196f, 0.5450980392156862f},
				{0.9961176470588236f, 0.8796470588235294f, 0.5471372549019607f},
				{0.9961568627450981f, 0.8808627450980392f, 0.5491764705882353f},
				{0.9961960784313726f, 0.882078431372549f, 0.5512156862745098f},
				{0.9962352941176471f, 0.8832941176470588f, 0.5532549019607843f},
				{0.9962745098039216f, 0.8845098039215686f, 0.5552941176470588f},
				{0.9963137254901961f, 0.8857254901960784f, 0.5573333333333332f},
				{0.9963529411764706f, 0.8869411764705882f, 0.5593725490196078f},
				{0.9963921568627451f, 0.888156862745098f, 0.5614117647058823f},
				{0.9964313725490196f, 0.8893725490196078f, 0.5634509803921568f},
				{0.9964705882352941f, 0.8905882352941177f, 0.5654901960784313f},
				{0.9965098039215686f, 0.8918039215686274f, 0.5675294117647058f},
				{0.9965490196078431f, 0.8930196078431373f, 0.5695686274509804f},
				{0.9965882352941177f, 0.894235294117647f, 0.5716078431372549f},
				{0.9966274509803922f, 0.8954509803921569f, 0.5736470588235294f},
				{0.9966666666666667f, 0.8966666666666666f, 0.5756862745098039f},
				{0.9967058823529412f, 0.8978823529411765f, 0.5777254901960784f},
				{0.9967450980392157f, 0.8990980392156863f, 0.5797647058823528f},
				{0.9967843137254903f, 0.9003137254901961f, 0.5818039215686274f},
				{0.9968235294117647f, 0.9015294117647059f, 0.5838431372549019f},
				{0.9968627450980392f, 0.9027450980392157f, 0.5858823529411764f},
				{0.9969019607843137f, 0.9039607843137255f, 0.5879215686274509f},
				{0.9969411764705882f, 0.9051764705882352f, 0.5899607843137255f},
				{0.9969803921568627f, 0.9063921568627451f, 0.592f},
				{0.9970196078431373f, 0.9076078431372548f, 0.5940392156862745f},
				{0.9970588235294118f, 0.9088235294117647f, 0.596078431372549f},
				{0.9970980392156863f, 0.9100392156862745f, 0.5981176470588235f},
				{0.9971372549019608f, 0.9112549019607843f, 0.6001568627450979f},
				{0.9971764705882353f, 0.9124705882352941f, 0.6021960784313725f},
				{0.9972156862745098f, 0.9136862745098039f, 0.604235294117647f},
				{0.9972549019607844f, 0.9149019607843137f, 0.6062745098039215f},
				{0.9972941176470589f, 0.9161176470588235f, 0.608313725490196f},
				{0.9973333333333333f, 0.9173333333333333f, 0.6103529411764705f},
				{0.9973725490196078f, 0.9185490196078432f, 0.6123921568627451f},
				{0.9974117647058823f, 0.9197647058823529f, 0.6144313725490196f},
				{0.9974509803921568f, 0.9209803921568628f, 0.6164705882352941f},
				{0.9974901960784314f, 0.9221960784313725f, 0.6185098039215686f},
				{0.9975294117647059f, 0.9234117647058824f, 0.6205490196078431f},
				{0.9975686274509804f, 0.9246274509803921f, 0.6225882352941177f},
				{0.9976078431372549f, 0.925843137254902f, 0.6246274509803921f},
				{0.9976470588235294f, 0.9270588235294117f, 0.6266666666666666f},
				{0.997686274509804f, 0.9282745098039216f, 0.6287058823529411f},
				{0.9977254901960785f, 0.9294901960784314f, 0.6307450980392156f},
				{0.997764705882353f, 0.9307058823529412f, 0.6327843137254902f},
				{0.9978039215686274f, 0.931921568627451f, 0.6348235294117647f},
				{0.9978431372549019f, 0.9331372549019608f, 0.6368627450980392f},
				{0.9978823529411764f, 0.9343529411764706f, 0.6389019607843137f},
				{0.997921568627451f, 0.9355686274509804f, 0.6409411764705882f},
				{0.9979607843137255f, 0.9367843137254902f, 0.6429803921568628f},
				{0.998f, 0.938f, 0.6450196078431372f},
				{0.9980392156862745f, 0.9392156862745098f, 0.6470588235294117f},
				{0.998078431372549f, 0.9404313725490197f, 0.6490980392156862f},
				{0.9981176470588236f, 0.9416470588235294f, 0.6511372549019607f},
				{0.9981568627450981f, 0.9428627450980392f, 0.6531764705882352f},
				{0.9981960784313726f, 0.944078431372549f, 0.6552156862745098f},
				{0.9982352941176471f, 0.9452941176470588f, 0.6572549019607843f},
				{0.9982745098039216f, 0.9465098039215686f, 0.6592941176470588f},
				{0.998313725490196f, 0.9477254901960784f, 0.6613333333333333f},
				{0.9983529411764706f, 0.9489411764705882f, 0.6633725490196078f},
				{0.9983921568627451f, 0.950156862745098f, 0.6654117647058824f},
				{0.9984313725490196f, 0.9513725490196079f, 0.6674509803921569f},
				{0.9984705882352941f, 0.9525882352941176f, 0.6694901960784313f},
				{0.9985098039215686f, 0.9538039215686275f, 0.6715294117647058f},
				{0.9985490196078431f, 0.9550196078431372f, 0.6735686274509803f},
				{0.9985882352941177f, 0.9562352941176471f, 0.6756078431372549f},
				{0.9986274509803922f, 0.9574509803921568f, 0.6776470588235294f},
				{0.9986666666666667f, 0.9586666666666667f, 0.6796862745098039f},
				{0.9987058823529412f, 0.9598823529411765f, 0.6817254901960784f},
				{0.9987450980392157f, 0.9610980392156863f, 0.6837647058823529f},
				{0.9987843137254901f, 0.9623137254901961f, 0.6858039215686275f},
				{0.9988235294117647f, 0.9635294117647059f, 0.687843137254902f},
				{0.9988627450980392f, 0.9647450980392157f, 0.6898823529411764f},
				{0.9989019607843137f, 0.9659607843137255f, 0.6919215686274509f},
				{0.9989411764705882f, 0.9671764705882353f, 0.6939607843137254f},
				{0.9989803921568627f, 0.968392156862745f, 0.696f},
				{0.9990196078431373f, 0.9696078431372549f, 0.6980392156862745f},
				{0.9990588235294118f, 0.9708235294117646f, 0.700078431372549f},
				{0.9990980392156863f, 0.9720392156862745f, 0.7021176470588235f},
				{0.9991372549019608f, 0.9732549019607843f, 0.704156862745098f},
				{0.9991764705882353f, 0.9744705882352941f, 0.7061960784313726f},
				{0.9992156862745099f, 0.9756862745098039f, 0.7082352941176471f},
				{0.9992549019607844f, 0.9769019607843137f, 0.7102745098039216f},
				{0.9992941176470588f, 0.9781176470588235f, 0.7123137254901961f},
				{0.9993333333333333f, 0.9793333333333334f, 0.7143529411764706f},
				{0.9993725490196078f, 0.9805490196078431f, 0.716392156862745f},
				{0.9994117647058823f, 0.981764705882353f, 0.7184313725490196f},
				{0.9994509803921569f, 0.9829803921568627f, 0.7204705882352941f},
				{0.9994901960784314f, 0.9841960784313726f, 0.7225098039215686f},
				{0.9995294117647059f, 0.9854117647058823f, 0.7245490196078431f},
				{0.9995686274509804f, 0.9866274509803922f, 0.7265882352941176f},
				{0.9996078431372549f, 0.9878431372549019f, 0.7286274509803922f},
				{0.9996470588235294f, 0.9890588235294118f, 0.7306666666666666f},
				{0.999686274509804f, 0.9902745098039216f, 0.7327058823529411f},
				{0.9997254901960785f, 0.9914901960784314f, 0.7347450980392156f},
				{0.9997647058823529f, 0.9927058823529412f, 0.7367843137254901f},
				{0.9998039215686274f, 0.993921568627451f, 0.7388235294117647f},
				{0.9998431372549019f, 0.9951372549019608f, 0.7408627450980392f},
				{0.9998823529411764f, 0.9963529411764706f, 0.7429019607843137f},
				{0.999921568627451f, 0.9975686274509804f, 0.7449411764705882f},
				{0.9999607843137255f, 0.9987843137254901f, 0.7469803921568627f},
				{1.f, 1.f, 0.7490196078431373f},
				{0.9990196078431373f, 0.9996078431372549f, 0.7474901960784314f},
				{0.9980392156862745f, 0.9992156862745099f, 0.7459607843137255f},
				{0.9970588235294118f, 0.9988235294117647f, 0.7444313725490196f},
				{0.996078431372549f, 0.9984313725490196f, 0.7429019607843137f},
				{0.9950980392156863f, 0.9980392156862745f, 0.7413725490196078f},
				{0.9941176470588236f, 0.9976470588235294f, 0.7398431372549019f},
				{0.9931372549019608f, 0.9972549019607844f, 0.738313725490196f},
				{0.9921568627450981f, 0.9968627450980392f, 0.7367843137254902f},
				{0.9911764705882353f, 0.9964705882352941f, 0.7352549019607844f},
				{0.9901960784313726f, 0.996078431372549f, 0.7337254901960785f},
				{0.9892156862745098f, 0.995686274509804f, 0.7321960784313726f},
				{0.9882352941176471f, 0.9952941176470588f, 0.7306666666666667f},
				{0.9872549019607844f, 0.9949019607843137f, 0.7291372549019608f},
				{0.9862745098039216f, 0.9945098039215686f, 0.7276078431372549f},
				{0.9852941176470589f, 0.9941176470588236f, 0.726078431372549f},
				{0.9843137254901961f, 0.9937254901960785f, 0.7245490196078431f},
				{0.9833333333333333f, 0.9933333333333333f, 0.7230196078431372f},
				{0.9823529411764705f, 0.9929411764705882f, 0.7214901960784313f},
				{0.9813725490196078f, 0.9925490196078431f, 0.7199607843137255f},
				{0.9803921568627451f, 0.9921568627450981f, 0.7184313725490196f},
				{0.9794117647058823f, 0.991764705882353f, 0.7169019607843137f},
				{0.9784313725490196f, 0.9913725490196078f, 0.7153725490196079f},
				{0.9774509803921568f, 0.9909803921568627f, 0.713843137254902f},
				{0.9764705882352941f, 0.9905882352941177f, 0.7123137254901961f},
				{0.9754901960784313f, 0.9901960784313726f, 0.7107843137254902f},
				{0.9745098039215686f, 0.9898039215686275f, 0.7092549019607843f},
				{0.9735294117647059f, 0.9894117647058823f, 0.7077254901960784f},
				{0.9725490196078431f, 0.9890196078431372f, 0.7061960784313726f},
				{0.9715686274509804f, 0.9886274509803922f, 0.7046666666666667f},
				{0.9705882352941176f, 0.9882352941176471f, 0.7031372549019608f},
				{0.9696078431372549f, 0.9878431372549019f, 0.7016078431372549f},
				{0.9686274509803922f, 0.9874509803921568f, 0.700078431372549f},
				{0.9676470588235294f, 0.9870588235294118f, 0.6985490196078431f},
				{0.9666666666666667f, 0.9866666666666667f, 0.6970196078431372f},
				{0.9656862745098039f, 0.9862745098039216f, 0.6954901960784313f},
				{0.9647058823529412f, 0.9858823529411764f, 0.6939607843137255f},
				{0.9637254901960784f, 0.9854901960784314f, 0.6924313725490197f},
				{0.9627450980392157f, 0.9850980392156863f, 0.6909019607843138f},
				{0.961764705882353f, 0.9847058823529412f, 0.6893725490196079f},
				{0.9607843137254902f, 0.9843137254901961f, 0.687843137254902f},
				{0.9598039215686275f, 0.983921568627451f, 0.6863137254901961f},
				{0.9588235294117647f, 0.9835294117647059f, 0.6847843137254902f},
				{0.957843137254902f, 0.9831372549019608f, 0.6832549019607843f},
				{0.9568627450980393f, 0.9827450980392157f, 0.6817254901960784f},
				{0.9558823529411765f, 0.9823529411764707f, 0.6801960784313725f},
				{0.9549019607843138f, 0.9819607843137255f, 0.6786666666666666f},
				{0.953921568627451f, 0.9815686274509804f, 0.6771372549019608f},
				{0.9529411764705883f, 0.9811764705882353f, 0.6756078431372549f},
				{0.9519607843137254f, 0.9807843137254902f, 0.674078431372549f},
				{0.9509803921568627f, 0.9803921568627452f, 0.6725490196078432f},
				{0.95f, 0.98f, 0.6710196078431373f},
				{0.9490196078431372f, 0.9796078431372549f, 0.6694901960784314f},
				{0.9480392156862745f, 0.9792156862745098f, 0.6679607843137255f},
				{0.9470588235294117f, 0.9788235294117648f, 0.6664313725490196f},
				{0.946078431372549f, 0.9784313725490196f, 0.6649019607843137f},
				{0.9450980392156862f, 0.9780392156862745f, 0.6633725490196078f},
				{0.9441176470588235f, 0.9776470588235294f, 0.661843137254902f},
				{0.9431372549019608f, 0.9772549019607844f, 0.6603137254901961f},
				{0.942156862745098f, 0.9768627450980393f, 0.6587843137254902f},
				{0.9411764705882353f, 0.9764705882352941f, 0.6572549019607843f},
				{0.9401960784313725f, 0.976078431372549f, 0.6557254901960784f},
				{0.9392156862745098f, 0.9756862745098039f, 0.6541960784313725f},
				{0.9382352941176471f, 0.9752941176470589f, 0.6526666666666666f},
				{0.9372549019607843f, 0.9749019607843138f, 0.6511372549019607f},
				{0.9362745098039216f, 0.9745098039215686f, 0.649607843137255f},
				{0.9352941176470588f, 0.9741176470588235f, 0.6480784313725491f},
				{0.9343137254901961f, 0.9737254901960785f, 0.6465490196078432f},
				{0.9333333333333333f, 0.9733333333333334f, 0.6450196078431373f},
				{0.9323529411764706f, 0.9729411764705882f, 0.6434901960784314f},
				{0.9313725490196079f, 0.9725490196078431f, 0.6419607843137255f},
				{0.9303921568627451f, 0.972156862745098f, 0.6404313725490196f},
				{0.9294117647058824f, 0.971764705882353f, 0.6389019607843137f},
				{0.9284313725490196f, 0.9713725490196079f, 0.6373725490196078f},
				{0.9274509803921569f, 0.9709803921568627f, 0.6358431372549019f},
				{0.9264705882352942f, 0.9705882352941176f, 0.634313725490196f},
				{0.9254901960784314f, 0.9701960784313726f, 0.6327843137254902f},
				{0.9245098039215687f, 0.9698039215686275f, 0.6312549019607843f},
				{0.9235294117647059f, 0.9694117647058824f, 0.6297254901960785f},
				{0.9225490196078432f, 0.9690196078431372f, 0.6281960784313725f},
				{0.9215686274509804f, 0.9686274509803922f, 0.6266666666666667f},
				{0.9205882352941177f, 0.9682352941176471f, 0.6251372549019608f},
				{0.919607843137255f, 0.967843137254902f, 0.6236078431372549f},
				{0.9186274509803922f, 0.9674509803921569f, 0.622078431372549f},
				{0.9176470588235294f, 0.9670588235294117f, 0.6205490196078431f},
				{0.9166666666666666f, 0.9666666666666667f, 0.6190196078431373f},
				{0.915686274509804f, 0.9662745098039216f, 0.6174901960784314f},
				{0.9147058823529413f, 0.9658823529411765f, 0.6159607843137255f},
				{0.9137254901960784f, 0.9654901960784315f, 0.6144313725490196f},
				{0.9127450980392157f, 0.9650980392156863f, 0.6129019607843137f},
				{0.9117647058823529f, 0.9647058823529412f, 0.6113725490196078f},
				{0.9107843137254902f, 0.9643137254901961f, 0.609843137254902f},
				{0.9098039215686274f, 0.963921568627451f, 0.608313725490196f},
				{0.9088235294117647f, 0.963529411764706f, 0.6067843137254902f},
				{0.907843137254902f, 0.9631372549019608f, 0.6052549019607842f},
				{0.9068627450980392f, 0.9627450980392157f, 0.6037254901960785f},
				{0.9058823529411765f, 0.9623529411764706f, 0.6021960784313726f},
				{0.9049019607843137f, 0.9619607843137256f, 0.6006666666666667f},
				{0.903921568627451f, 0.9615686274509804f, 0.5991372549019608f},
				{0.9029411764705882f, 0.9611764705882353f, 0.5976078431372549f},
				{0.9019607843137255f, 0.9607843137254902f, 0.596078431372549f},
				{0.8996470588235295f, 0.959843137254902f, 0.5965490196078431f},
				{0.8973333333333333f, 0.9589019607843138f, 0.5970196078431372f},
				{0.8950196078431373f, 0.9579607843137256f, 0.5974901960784313f},
				{0.8927058823529412f, 0.9570196078431373f, 0.5979607843137255f},
				{0.8903921568627451f, 0.956078431372549f, 0.5984313725490196f},
				{0.888078431372549f, 0.9551372549019608f, 0.5989019607843137f},
				{0.8857647058823529f, 0.9541960784313726f, 0.5993725490196078f},
				{0.8834509803921569f, 0.9532549019607843f, 0.5998431372549019f},
				{0.8811372549019608f, 0.9523137254901961f, 0.600313725490196f},
				{0.8788235294117647f, 0.9513725490196079f, 0.6007843137254902f},
				{0.8765098039215686f, 0.9504313725490197f, 0.6012549019607843f},
				{0.8741960784313726f, 0.9494901960784314f, 0.6017254901960785f},
				{0.8718823529411764f, 0.9485490196078432f, 0.6021960784313726f},
				{0.8695686274509804f, 0.9476078431372549f, 0.6026666666666667f},
				{0.8672549019607844f, 0.9466666666666667f, 0.6031372549019608f},
				{0.8649411764705882f, 0.9457254901960784f, 0.6036078431372549f},
				{0.8626274509803922f, 0.9447843137254902f, 0.604078431372549f},
				{0.8603137254901961f, 0.943843137254902f, 0.6045490196078431f},
				{0.858f, 0.9429019607843138f, 0.6050196078431372f},
				{0.855686274509804f, 0.9419607843137255f, 0.6054901960784314f},
				{0.8533725490196078f, 0.9410196078431373f, 0.6059607843137255f},
				{0.8510588235294118f, 0.9400784313725491f, 0.6064313725490196f},
				{0.8487450980392157f, 0.9391372549019608f, 0.6069019607843137f},
				{0.8464313725490196f, 0.9381960784313725f, 0.6073725490196078f},
				{0.8441176470588235f, 0.9372549019607843f, 0.6078431372549019f},
				{0.8418039215686275f, 0.9363137254901961f, 0.608313725490196f},
				{0.8394901960784313f, 0.9353725490196079f, 0.6087843137254901f},
				{0.8371764705882353f, 0.9344313725490196f, 0.6092549019607842f},
				{0.8348627450980393f, 0.9334901960784314f, 0.6097254901960784f},
				{0.8325490196078431f, 0.9325490196078432f, 0.6101960784313725f},
				{0.8302352941176471f, 0.931607843137255f, 0.6106666666666667f},
				{0.827921568627451f, 0.9306666666666666f, 0.6111372549019608f},
				{0.8256078431372549f, 0.9297254901960784f, 0.6116078431372549f},
				{0.8232941176470588f, 0.9287843137254902f, 0.612078431372549f},
				{0.8209803921568627f, 0.927843137254902f, 0.6125490196078431f},
				{0.8186666666666667f, 0.9269019607843137f, 0.6130196078431372f},
				{0.8163529411764706f, 0.9259607843137255f, 0.6134901960784314f},
				{0.8140392156862745f, 0.9250196078431373f, 0.6139607843137255f},
				{0.8117254901960784f, 0.9240784313725491f, 0.6144313725490196f},
				{0.8094117647058824f, 0.9231372549019609f, 0.6149019607843137f},
				{0.8070980392156862f, 0.9221960784313725f, 0.6153725490196078f},
				{0.8047843137254902f, 0.9212549019607843f, 0.6158431372549019f},
				{0.8024705882352942f, 0.9203137254901961f, 0.616313725490196f},
				{0.800156862745098f, 0.9193725490196079f, 0.6167843137254901f},
				{0.797843137254902f, 0.9184313725490196f, 0.6172549019607843f},
				{0.7955294117647058f, 0.9174901960784314f, 0.6177254901960784f},
				{0.7932156862745098f, 0.9165490196078432f, 0.6181960784313725f},
				{0.7909019607843137f, 0.915607843137255f, 0.6186666666666666f},
				{0.7885882352941176f, 0.9146666666666667f, 0.6191372549019607f},
				{0.7862745098039216f, 0.9137254901960785f, 0.6196078431372549f},
				{0.7839607843137255f, 0.9127843137254902f, 0.620078431372549f},
				{0.7816470588235294f, 0.911843137254902f, 0.6205490196078431f},
				{0.7793333333333333f, 0.9109019607843137f, 0.6210196078431373f},
				{0.7770196078431373f, 0.9099607843137255f, 0.6214901960784314f},
				{0.7747058823529411f, 0.9090196078431373f, 0.6219607843137255f},
				{0.7723921568627451f, 0.9080784313725491f, 0.6224313725490196f},
				{0.770078431372549f, 0.9071372549019608f, 0.6229019607843137f},
				{0.7677647058823529f, 0.9061960784313726f, 0.6233725490196078f},
				{0.7654509803921569f, 0.9052549019607844f, 0.6238431372549019f},
				{0.7631372549019608f, 0.9043137254901961f, 0.624313725490196f},
				{0.7608235294117647f, 0.9033725490196078f, 0.6247843137254901f},
				{0.7585098039215686f, 0.9024313725490196f, 0.6252549019607843f},
				{0.7561960784313725f, 0.9014901960784314f, 0.6257254901960784f},
				{0.7538823529411764f, 0.9005490196078432f, 0.6261960784313725f},
				{0.7515686274509803f, 0.899607843137255f, 0.6266666666666666f},
				{0.7492549019607843f, 0.8986666666666667f, 0.6271372549019607f},
				{0.7469411764705882f, 0.8977254901960785f, 0.6276078431372548f},
				{0.7446274509803921f, 0.8967843137254903f, 0.6280784313725489f},
				{0.742313725490196f, 0.8958431372549019f, 0.6285490196078432f},
				{0.74f, 0.8949019607843137f, 0.6290196078431372f},
				{0.7376862745098038f, 0.8939607843137255f, 0.6294901960784314f},
				{0.7353725490196078f, 0.8930196078431373f, 0.6299607843137255f},
				{0.7330588235294118f, 0.892078431372549f, 0.6304313725490196f},
				{0.7307450980392156f, 0.8911372549019608f, 0.6309019607843137f},
				{0.7284313725490196f, 0.8901960784313726f, 0.6313725490196078f},
				{0.7261176470588235f, 0.8892549019607844f, 0.6318431372549019f},
				{0.7238039215686274f, 0.888313725490196f, 0.632313725490196f},
				{0.7214901960784313f, 0.8873725490196078f, 0.6327843137254902f},
				{0.7191764705882353f, 0.8864313725490196f, 0.6332549019607843f},
				{0.7168627450980392f, 0.8854901960784314f, 0.6337254901960784f},
				{0.7145490196078431f, 0.8845490196078432f, 0.6341960784313725f},
				{0.7122352941176471f, 0.8836078431372549f, 0.6346666666666666f},
				{0.7099215686274509f, 0.8826666666666667f, 0.6351372549019607f},
				{0.7076078431372549f, 0.8817254901960785f, 0.6356078431372548f},
				{0.7052941176470587f, 0.8807843137254903f, 0.6360784313725489f},
				{0.7029803921568627f, 0.879843137254902f, 0.636549019607843f},
				{0.7006666666666667f, 0.8789019607843138f, 0.6370196078431372f},
				{0.6983529411764706f, 0.8779607843137255f, 0.6374901960784313f},
				{0.6960392156862745f, 0.8770196078431373f, 0.6379607843137254f},
				{0.6937254901960784f, 0.876078431372549f, 0.6384313725490196f},
				{0.6914117647058823f, 0.8751372549019608f, 0.6389019607843137f},
				{0.6890980392156862f, 0.8741960784313726f, 0.6393725490196078f},
				{0.6867843137254901f, 0.8732549019607844f, 0.6398431372549019f},
				{0.684470588235294f, 0.8723137254901961f, 0.640313725490196f},
				{0.682156862745098f, 0.8713725490196078f, 0.6407843137254902f},
				{0.6798431372549019f, 0.8704313725490196f, 0.6412549019607843f},
				{0.6775294117647058f, 0.8694901960784314f, 0.6417254901960784f},
				{0.6752156862745098f, 0.8685490196078431f, 0.6421960784313725f},
				{0.6729019607843136f, 0.8676078431372549f, 0.6426666666666666f},
				{0.6705882352941176f, 0.8666666666666667f, 0.6431372549019607f},
				{0.6678823529411764f, 0.8656078431372549f, 0.6431764705882352f},
				{0.6651764705882353f, 0.8645490196078431f, 0.6432156862745098f},
				{0.662470588235294f, 0.8634901960784314f, 0.6432549019607843f},
				{0.6597647058823529f, 0.8624313725490196f, 0.6432941176470588f},
				{0.6570588235294117f, 0.8613725490196079f, 0.6433333333333333f},
				{0.6543529411764706f, 0.8603137254901961f, 0.6433725490196078f},
				{0.6516470588235294f, 0.8592549019607844f, 0.6434117647058823f},
				{0.6489411764705882f, 0.8581960784313726f, 0.6434509803921568f},
				{0.646235294117647f, 0.8571372549019608f, 0.6434901960784313f},
				{0.6435294117647058f, 0.856078431372549f, 0.6435294117647058f},
				{0.6408235294117647f, 0.8550196078431372f, 0.6435686274509803f},
				{0.6381176470588235f, 0.8539607843137255f, 0.6436078431372548f},
				{0.6354117647058823f, 0.8529019607843138f, 0.6436470588235293f},
				{0.6327058823529411f, 0.851843137254902f, 0.6436862745098039f},
				{0.63f, 0.8507843137254902f, 0.6437254901960784f},
				{0.6272941176470588f, 0.8497254901960785f, 0.6437647058823529f},
				{0.6245882352941176f, 0.8486666666666667f, 0.6438039215686274f},
				{0.6218823529411764f, 0.8476078431372549f, 0.6438431372549019f},
				{0.6191764705882352f, 0.8465490196078431f, 0.6438823529411765f},
				{0.6164705882352941f, 0.8454901960784313f, 0.643921568627451f},
				{0.6137647058823529f, 0.8444313725490196f, 0.6439607843137255f},
				{0.6110588235294118f, 0.8433725490196079f, 0.6439999999999999f},
				{0.6083529411764705f, 0.8423137254901961f, 0.6440392156862744f},
				{0.6056470588235294f, 0.8412549019607843f, 0.6440784313725489f},
				{0.6029411764705882f, 0.8401960784313726f, 0.6441176470588235f},
				{0.600235294117647f, 0.8391372549019608f, 0.644156862745098f},
				{0.5975294117647059f, 0.838078431372549f, 0.6441960784313725f},
				{0.5948235294117646f, 0.8370196078431372f, 0.644235294117647f},
				{0.5921176470588235f, 0.8359607843137254f, 0.6442745098039215f},
				{0.5894117647058823f, 0.8349019607843138f, 0.644313725490196f},
				{0.5867058823529412f, 0.833843137254902f, 0.6443529411764706f},
				{0.584f, 0.8327843137254902f, 0.6443921568627451f},
				{0.5812941176470587f, 0.8317254901960784f, 0.6444313725490196f},
				{0.5785882352941176f, 0.8306666666666667f, 0.6444705882352941f},
				{0.5758823529411764f, 0.8296078431372549f, 0.6445098039215686f},
				{0.5731764705882353f, 0.8285490196078431f, 0.644549019607843f},
				{0.5704705882352941f, 0.8274901960784313f, 0.6445882352941176f},
				{0.567764705882353f, 0.8264313725490197f, 0.6446274509803921f},
				{0.5650588235294117f, 0.8253725490196079f, 0.6446666666666666f},
				{0.5623529411764706f, 0.8243137254901961f, 0.6447058823529411f},
				{0.5596470588235294f, 0.8232549019607843f, 0.6447450980392156f},
				{0.5569411764705882f, 0.8221960784313725f, 0.6447843137254902f},
				{0.554235294117647f, 0.8211372549019608f, 0.6448235294117647f},
				{0.5515294117647058f, 0.820078431372549f, 0.6448627450980392f},
				{0.5488235294117647f, 0.8190196078431372f, 0.6449019607843137f},
				{0.5461176470588235f, 0.8179607843137255f, 0.6449411764705882f},
				{0.5434117647058824f, 0.8169019607843138f, 0.6449803921568628f},
				{0.5407058823529411f, 0.815843137254902f, 0.6450196078431373f},
				{0.538f, 0.8147843137254902f, 0.6450588235294118f},
				{0.5352941176470588f, 0.8137254901960784f, 0.6450980392156862f},
				{0.5325882352941176f, 0.8126666666666666f, 0.6451372549019607f},
				{0.5298823529411765f, 0.8116078431372549f, 0.6451764705882352f},
				{0.5271764705882352f, 0.8105490196078431f, 0.6452156862745098f},
				{0.5244705882352941f, 0.8094901960784313f, 0.6452549019607843f},
				{0.5217647058823529f, 0.8084313725490196f, 0.6452941176470588f},
				{0.5190588235294118f, 0.8073725490196079f, 0.6453333333333333f},
				{0.5163529411764706f, 0.8063137254901961f, 0.6453725490196078f},
				{0.5136470588235293f, 0.8052549019607843f, 0.6454117647058824f},
				{0.5109411764705882f, 0.8041960784313725f, 0.6454509803921569f},
				{0.5082352941176471f, 0.8031372549019608f, 0.6454901960784314f},
				{0.5055294117647059f, 0.802078431372549f, 0.6455294117647059f},
				{0.5028235294117647f, 0.8010196078431373f, 0.6455686274509804f},
				{0.5001176470588236f, 0.7999607843137255f, 0.6456078431372549f},
				{0.49741176470588233f, 0.7989019607843137f, 0.6456470588235295f},
				{0.49470588235294116f, 0.797843137254902f, 0.6456862745098039f},
				{0.492f, 0.7967843137254902f, 0.6457254901960784f},
				{0.4892941176470588f, 0.7957254901960784f, 0.6457647058823529f},
				{0.48658823529411765f, 0.7946666666666666f, 0.6458039215686274f},
				{0.48388235294117643f, 0.7936078431372549f, 0.6458431372549019f},
				{0.4811764705882353f, 0.7925490196078431f, 0.6458823529411765f},
				{0.47847058823529415f, 0.7914901960784314f, 0.645921568627451f},
				{0.475764705882353f, 0.7904313725490196f, 0.6459607843137255f},
				{0.47305882352941175f, 0.7893725490196078f, 0.646f},
				{0.47035294117647064f, 0.7883137254901961f, 0.6460392156862745f},
				{0.4676470588235294f, 0.7872549019607843f, 0.6460784313725491f},
				{0.46494117647058825f, 0.7861960784313725f, 0.6461176470588236f},
				{0.4622352941176471f, 0.7851372549019607f, 0.6461568627450981f},
				{0.45952941176470585f, 0.784078431372549f, 0.6461960784313726f},
				{0.45682352941176474f, 0.7830196078431373f, 0.646235294117647f},
				{0.4541176470588235f, 0.7819607843137255f, 0.6462745098039215f},
				{0.45141176470588235f, 0.7809019607843137f, 0.6463137254901961f},
				{0.4487058823529412f, 0.779843137254902f, 0.6463529411764706f},
				{0.446f, 0.7787843137254902f, 0.6463921568627451f},
				{0.44329411764705884f, 0.7777254901960784f, 0.6464313725490196f},
				{0.4405882352941176f, 0.7766666666666666f, 0.6464705882352941f},
				{0.4378823529411765f, 0.7756078431372548f, 0.6465098039215686f},
				{0.43517647058823533f, 0.7745490196078431f, 0.6465490196078432f},
				{0.43247058823529416f, 0.7734901960784314f, 0.6465882352941177f},
				{0.42976470588235294f, 0.7724313725490196f, 0.6466274509803922f},
				{0.4270588235294118f, 0.7713725490196078f, 0.6466666666666667f},
				{0.4243529411764706f, 0.770313725490196f, 0.6467058823529412f},
				{0.42164705882352943f, 0.7692549019607843f, 0.6467450980392158f},
				{0.41894117647058826f, 0.7681960784313725f, 0.6467843137254902f},
				{0.4162352941176471f, 0.7671372549019607f, 0.6468235294117647f},
				{0.4135294117647059f, 0.7660784313725489f, 0.6468627450980392f},
				{0.4108235294117647f, 0.7650196078431373f, 0.6469019607843137f},
				{0.40811764705882353f, 0.7639607843137255f, 0.6469411764705882f},
				{0.40541176470588236f, 0.7629019607843137f, 0.6469803921568628f},
				{0.4027058823529412f, 0.7618431372549019f, 0.6470196078431373f},
				{0.4f, 0.7607843137254902f, 0.6470588235294118f},
				{0.3979607843137255f, 0.7585098039215686f, 0.648f},
				{0.395921568627451f, 0.756235294117647f, 0.6489411764705882f},
				{0.3938823529411765f, 0.7539607843137255f, 0.6498823529411765f},
				{0.391843137254902f, 0.7516862745098039f, 0.6508235294117647f},
				{0.3898039215686275f, 0.7494117647058823f, 0.651764705882353f},
				{0.38776470588235296f, 0.7471372549019607f, 0.6527058823529412f},
				{0.38572549019607844f, 0.7448627450980392f, 0.6536470588235295f},
				{0.3836862745098039f, 0.7425882352941177f, 0.6545882352941177f},
				{0.38164705882352945f, 0.740313725490196f, 0.6555294117647059f},
				{0.37960784313725493f, 0.7380392156862745f, 0.6564705882352941f},
				{0.3775686274509804f, 0.7357647058823529f, 0.6574117647058824f},
				{0.3755294117647059f, 0.7334901960784314f, 0.6583529411764706f},
				{0.37349019607843137f, 0.7312156862745097f, 0.6592941176470588f},
				{0.3714509803921569f, 0.7289411764705882f, 0.6602352941176471f},
				{0.3694117647058824f, 0.7266666666666667f, 0.6611764705882354f},
				{0.36737254901960786f, 0.724392156862745f, 0.6621176470588236f},
				{0.36533333333333334f, 0.7221176470588235f, 0.6630588235294118f},
				{0.3632941176470588f, 0.7198431372549019f, 0.664f},
				{0.36125490196078436f, 0.7175686274509804f, 0.6649411764705883f},
				{0.35921568627450984f, 0.7152941176470587f, 0.6658823529411765f},
				{0.3571764705882353f, 0.7130196078431372f, 0.6668235294117647f},
				{0.3551372549019608f, 0.7107450980392157f, 0.6677647058823529f},
				{0.3530980392156863f, 0.7084705882352941f, 0.6687058823529413f},
				{0.35105882352941176f, 0.7061960784313726f, 0.6696470588235295f},
				{0.34901960784313724f, 0.7039215686274509f, 0.6705882352941177f},
				{0.34698039215686277f, 0.7016470588235294f, 0.6715294117647059f},
				{0.34494117647058825f, 0.6993725490196078f, 0.6724705882352942f},
				{0.34290196078431373f, 0.6970980392156862f, 0.6734117647058824f},
				{0.3408627450980392f, 0.6948235294117646f, 0.6743529411764706f},
				{0.33882352941176475f, 0.6925490196078431f, 0.6752941176470588f},
				{0.3367843137254902f, 0.6902745098039216f, 0.676235294117647f},
				{0.3347450980392157f, 0.688f, 0.6771764705882354f},
				{0.3327058823529412f, 0.6857254901960784f, 0.6781176470588236f},
				{0.33066666666666666f, 0.6834509803921568f, 0.6790588235294118f},
				{0.32862745098039214f, 0.6811764705882353f, 0.68f},
				{0.3265882352941177f, 0.6789019607843138f, 0.6809411764705883f},
				{0.32454901960784316f, 0.6766274509803921f, 0.6818823529411765f},
				{0.32250980392156864f, 0.6743529411764706f, 0.6828235294117647f},
				{0.3204705882352941f, 0.672078431372549f, 0.6837647058823529f},
				{0.3184313725490196f, 0.6698039215686274f, 0.6847058823529412f},
				{0.31639215686274513f, 0.6675294117647058f, 0.6856470588235295f},
				{0.3143529411764706f, 0.6652549019607843f, 0.6865882352941177f},
				{0.3123137254901961f, 0.6629803921568628f, 0.6875294117647059f},
				{0.31027450980392157f, 0.6607058823529411f, 0.6884705882352942f},
				{0.30823529411764705f, 0.6584313725490196f, 0.6894117647058824f},
				{0.30619607843137253f, 0.656156862745098f, 0.6903529411764706f},
				{0.30415686274509807f, 0.6538823529411765f, 0.6912941176470588f},
				{0.30211764705882355f, 0.6516078431372548f, 0.6922352941176471f},
				{0.300078431372549f, 0.6493333333333333f, 0.6931764705882353f},
				{0.2980392156862745f, 0.6470588235294117f, 0.6941176470588235f},
				{0.29600000000000004f, 0.6447843137254902f, 0.6950588235294118f},
				{0.2939607843137255f, 0.6425098039215686f, 0.6960000000000001f},
				{0.291921568627451f, 0.640235294117647f, 0.6969411764705883f},
				{0.2898823529411765f, 0.6379607843137255f, 0.6978823529411765f},
				{0.28784313725490196f, 0.635686274509804f, 0.6988235294117647f},
				{0.28580392156862744f, 0.6334117647058823f, 0.699764705882353f},
				{0.2837647058823529f, 0.6311372549019607f, 0.7007058823529412f},
				{0.2817254901960784f, 0.6288627450980392f, 0.7016470588235294f},
				{0.27968627450980393f, 0.6265882352941177f, 0.7025882352941176f},
				{0.2776470588235294f, 0.624313725490196f, 0.703529411764706f},
				{0.2756078431372549f, 0.6220392156862745f, 0.7044705882352942f},
				{0.27356862745098043f, 0.619764705882353f, 0.7054117647058824f},
				{0.2715294117647059f, 0.6174901960784314f, 0.7063529411764706f},
				{0.2694901960784314f, 0.6152156862745097f, 0.7072941176470589f},
				{0.26745098039215687f, 0.6129411764705882f, 0.7082352941176471f},
				{0.26541176470588235f, 0.6106666666666667f, 0.7091764705882353f},
				{0.2633725490196078f, 0.6083921568627451f, 0.7101176470588235f},
				{0.2613333333333333f, 0.6061176470588235f, 0.7110588235294117f},
				{0.2592941176470588f, 0.6038431372549019f, 0.7120000000000001f},
				{0.25725490196078427f, 0.6015686274509804f, 0.7129411764705883f},
				{0.25521568627450986f, 0.5992941176470589f, 0.7138823529411765f},
				{0.25317647058823534f, 0.5970196078431372f, 0.7148235294117647f},
				{0.2511372549019608f, 0.5947450980392157f, 0.715764705882353f},
				{0.2490980392156863f, 0.5924705882352941f, 0.7167058823529412f},
				{0.24705882352941178f, 0.5901960784313726f, 0.7176470588235294f},
				{0.24501960784313725f, 0.587921568627451f, 0.7185882352941176f},
				{0.24298039215686273f, 0.5856470588235294f, 0.719529411764706f},
				{0.24094117647058824f, 0.5833725490196078f, 0.7204705882352942f},
				{0.23890196078431372f, 0.5810980392156863f, 0.7214117647058824f},
				{0.2368627450980392f, 0.5788235294117647f, 0.7223529411764706f},
				{0.2348235294117647f, 0.5765490196078431f, 0.7232941176470589f},
				{0.2327843137254902f, 0.5742745098039216f, 0.7242352941176471f},
				{0.23074509803921567f, 0.5720000000000001f, 0.7251764705882353f},
				{0.22870588235294118f, 0.5697254901960784f, 0.7261176470588235f},
				{0.22666666666666666f, 0.5674509803921568f, 0.7270588235294118f},
				{0.22462745098039216f, 0.5651764705882353f, 0.728f},
				{0.22258823529411764f, 0.5629019607843138f, 0.7289411764705882f},
				{0.22054901960784315f, 0.5606274509803921f, 0.7298823529411765f},
				{0.21850980392156863f, 0.5583529411764706f, 0.7308235294117648f},
				{0.2164705882352941f, 0.5560784313725491f, 0.731764705882353f},
				{0.21443137254901962f, 0.5538039215686275f, 0.7327058823529412f},
				{0.2123921568627451f, 0.5515294117647059f, 0.7336470588235294f},
				{0.21035294117647058f, 0.5492549019607843f, 0.7345882352941177f},
				{0.20831372549019608f, 0.5469803921568628f, 0.7355294117647059f},
				{0.20627450980392156f, 0.5447058823529412f, 0.7364705882352942f},
				{0.20423529411764704f, 0.5424313725490196f, 0.7374117647058824f},
				{0.20219607843137252f, 0.5401568627450981f, 0.7383529411764707f},
				{0.20015686274509803f, 0.5378823529411765f, 0.7392941176470589f},
				{0.1981176470588235f, 0.5356078431372548f, 0.7402352941176471f},
				{0.19607843137254902f, 0.5333333333333333f, 0.7411764705882353f},
				{0.19780392156862744f, 0.5310980392156862f, 0.7401176470588235f},
				{0.19952941176470587f, 0.5288627450980392f, 0.7390588235294118f},
				{0.2012549019607843f, 0.5266274509803921f, 0.738f},
				{0.20298039215686275f, 0.5243921568627451f, 0.7369411764705882f},
				{0.20470588235294118f, 0.522156862745098f, 0.7358823529411765f},
				{0.2064313725490196f, 0.519921568627451f, 0.7348235294117648f},
				{0.20815686274509804f, 0.5176862745098039f, 0.733764705882353f},
				{0.20988235294117646f, 0.5154509803921569f, 0.7327058823529412f},
				{0.2116078431372549f, 0.5132156862745098f, 0.7316470588235294f},
				{0.21333333333333332f, 0.5109803921568628f, 0.7305882352941176f},
				{0.21505882352941175f, 0.5087450980392156f, 0.7295294117647059f},
				{0.2167843137254902f, 0.5065098039215686f, 0.7284705882352941f},
				{0.21850980392156863f, 0.5042745098039215f, 0.7274117647058824f},
				{0.22023529411764706f, 0.5020392156862745f, 0.7263529411764706f},
				{0.22196078431372548f, 0.49980392156862746f, 0.7252941176470589f},
				{0.2236862745098039f, 0.4975686274509804f, 0.7242352941176471f},
				{0.22541176470588237f, 0.49533333333333335f, 0.7231764705882353f},
				{0.2271372549019608f, 0.4930980392156863f, 0.7221176470588235f},
				{0.22886274509803922f, 0.49086274509803923f, 0.7210588235294118f},
				{0.23058823529411765f, 0.4886274509803922f, 0.72f},
				{0.23231372549019608f, 0.4863921568627451f, 0.7189411764705882f},
				{0.2340392156862745f, 0.48415686274509806f, 0.7178823529411765f},
				{0.23576470588235293f, 0.481921568627451f, 0.7168235294117647f},
				{0.23749019607843136f, 0.47968627450980394f, 0.715764705882353f},
				{0.23921568627450981f, 0.47745098039215683f, 0.7147058823529412f},
				{0.24094117647058824f, 0.47521568627450983f, 0.7136470588235294f},
				{0.24266666666666667f, 0.4729803921568628f, 0.7125882352941176f},
				{0.2443921568627451f, 0.4707450980392157f, 0.7115294117647059f},
				{0.24611764705882352f, 0.4685098039215686f, 0.7104705882352941f},
				{0.24784313725490195f, 0.4662745098039216f, 0.7094117647058824f},
				{0.2495686274509804f, 0.4640392156862745f, 0.7083529411764706f},
				{0.25129411764705883f, 0.4618039215686275f, 0.7072941176470589f},
				{0.25301960784313726f, 0.45956862745098037f, 0.7062352941176471f},
				{0.2547450980392157f, 0.4573333333333333f, 0.7051764705882353f},
				{0.2564705882352941f, 0.45509803921568626f, 0.7041176470588235f},
				{0.25819607843137254f, 0.45286274509803925f, 0.7030588235294117f},
				{0.25992156862745097f, 0.45062745098039214f, 0.702f},
				{0.2616470588235294f, 0.44839215686274514f, 0.7009411764705883f},
				{0.2633725490196078f, 0.446156862745098f, 0.6998823529411765f},
				{0.2650980392156863f, 0.44392156862745097f, 0.6988235294117647f},
				{0.2668235294117647f, 0.4416862745098039f, 0.697764705882353f},
				{0.26854901960784316f, 0.43945098039215685f, 0.6967058823529412f},
				{0.27027450980392154f, 0.4372156862745098f, 0.6956470588235294f},
				{0.272f, 0.4349803921568628f, 0.6945882352941176f},
				{0.27372549019607845f, 0.4327450980392157f, 0.6935294117647058f},
				{0.2754509803921569f, 0.4305098039215686f, 0.6924705882352942f},
				{0.2771764705882353f, 0.42827450980392157f, 0.6914117647058824f},
				{0.27890196078431373f, 0.4260392156862745f, 0.6903529411764706f},
				{0.28062745098039216f, 0.42380392156862745f, 0.6892941176470588f},
				{0.2823529411764706f, 0.4215686274509804f, 0.6882352941176471f},
				{0.284078431372549f, 0.41933333333333334f, 0.6871764705882353f},
				{0.28580392156862744f, 0.4170980392156863f, 0.6861176470588235f},
				{0.28752941176470587f, 0.4148627450980392f, 0.6850588235294117f},
				{0.2892549019607843f, 0.41262745098039216f, 0.6839999999999999f},
				{0.2909803921568628f, 0.4103921568627451f, 0.6829411764705883f},
				{0.29270588235294115f, 0.40815686274509805f, 0.6818823529411765f},
				{0.29443137254901963f, 0.405921568627451f, 0.6808235294117647f},
				{0.29615686274509806f, 0.40368627450980393f, 0.6797647058823529f},
				{0.2978823529411765f, 0.4014509803921569f, 0.6787058823529412f},
				{0.2996078431372549f, 0.3992156862745098f, 0.6776470588235294f},
				{0.30133333333333334f, 0.39698039215686276f, 0.6765882352941176f},
				{0.30305882352941177f, 0.3947450980392157f, 0.6755294117647059f},
				{0.3047843137254902f, 0.39250980392156865f, 0.6744705882352942f},
				{0.3065098039215686f, 0.3902745098039216f, 0.6734117647058824f},
				{0.30823529411764705f, 0.38803921568627453f, 0.6723529411764706f},
				{0.3099607843137255f, 0.3858039215686275f, 0.6712941176470588f},
				{0.3116862745098039f, 0.3835686274509804f, 0.670235294117647f},
				{0.3134117647058824f, 0.3813333333333333f, 0.6691764705882353f},
				{0.3151372549019608f, 0.3790980392156863f, 0.6681176470588235f},
				{0.31686274509803924f, 0.3768627450980392f, 0.6670588235294117f},
				{0.3185882352941176f, 0.3746274509803922f, 0.666f},
				{0.3203137254901961f, 0.3723921568627451f, 0.6649411764705883f},
				{0.32203921568627447f, 0.37015686274509807f, 0.6638823529411765f},
				{0.32376470588235295f, 0.367921568627451f, 0.6628235294117647f},
				{0.3254901960784314f, 0.36568627450980395f, 0.6617647058823529f},
				{0.3272156862745098f, 0.3634509803921569f, 0.6607058823529411f},
				{0.32894117647058824f, 0.36121568627450984f, 0.6596470588235294f},
				{0.33066666666666666f, 0.3589803921568628f, 0.6585882352941176f},
				{0.3323921568627451f, 0.3567450980392157f, 0.6575294117647059f},
				{0.3341176470588235f, 0.3545098039215686f, 0.6564705882352941f},
				{0.335843137254902f, 0.3522745098039216f, 0.6554117647058824f},
				{0.3375686274509804f, 0.3500392156862745f, 0.6543529411764706f},
				{0.33929411764705886f, 0.3478039215686275f, 0.6532941176470588f},
				{0.34101960784313723f, 0.3455686274509804f, 0.652235294117647f},
				{0.3427450980392157f, 0.3433333333333334f, 0.6511764705882352f},
				{0.3444705882352941f, 0.3410980392156863f, 0.6501176470588235f},
				{0.34619607843137257f, 0.33886274509803926f, 0.6490588235294117f},
				{0.34792156862745094f, 0.3366274509803922f, 0.648f},
				{0.3496470588235294f, 0.33439215686274515f, 0.6469411764705882f},
				{0.35137254901960785f, 0.33215686274509804f, 0.6458823529411765f},
				{0.3530980392156863f, 0.32992156862745103f, 0.6448235294117647f},
				{0.3548235294117647f, 0.3276862745098039f, 0.6437647058823529f},
				{0.35654901960784313f, 0.3254509803921569f, 0.6427058823529411f},
				{0.3582745098039216f, 0.3232156862745098f, 0.6416470588235293f},
				{0.36f, 0.3209803921568628f, 0.6405882352941176f},
				{0.36172549019607847f, 0.3187450980392157f, 0.6395294117647059f},
				{0.36345098039215684f, 0.3165098039215687f, 0.6384705882352941f},
				{0.3651764705882353f, 0.3142745098039216f, 0.6374117647058823f},
				{0.36690196078431375f, 0.3120392156862745f, 0.6363529411764706f},
				{0.3686274509803922f, 0.30980392156862746f, 0.6352941176470588f}};

/*(Table[Blend[
  Map[(RGBColor @@ # &), ({{255, 245, 240}, {254, 224, 210}, {252, 
  187, 161}, {252, 146, 114}, {251, 106, 74}, {239, 59, 
  44}, {203, 24, 29}, {165, 15, 21}, {103, 0, 13}}/255), {1}],
  x/1000], {x, 0, 1000, 1.}] /. RGBColor -> List) >> /tmp/1*/

float palette_sequential_singlehue_red[1001][3]={{1.f, 0.9607843137254902f, 0.9411764705882353f}, 
						 {0.9999686274509804f, 0.9601254901960785f, 0.9402352941176471f}, 
						 {0.9999372549019608f, 0.9594666666666667f, 0.9392941176470588f}, 
						 {0.9999058823529412f, 0.958807843137255f, 0.9383529411764706f}, 
						 {0.9998745098039216f, 0.9581490196078432f, 0.9374117647058824f}, 
						 {0.9998431372549019f, 0.9574901960784314f, 0.936470588235294f}, 
						 {0.9998117647058824f, 0.9568313725490196f, 0.9355294117647058f}, 
						 {0.9997803921568628f, 0.9561725490196079f, 0.9345882352941176f}, 
						 {0.9997490196078431f, 0.9555137254901961f, 0.9336470588235294f}, 
						 {0.9997176470588235f, 0.9548549019607844f, 0.9327058823529412f}, 
						 {0.999686274509804f, 0.9541960784313726f, 0.9317647058823529f}, 
						 {0.9996549019607843f, 0.9535372549019608f, 0.9308235294117647f}, 
						 {0.9996235294117647f, 0.952878431372549f, 0.9298823529411765f}, 
						 {0.999592156862745f, 0.9522196078431373f, 0.9289411764705883f}, 
						 {0.9995607843137255f, 0.9515607843137255f, 0.9279999999999999f}, 
						 {0.9995294117647059f, 0.9509019607843138f, 0.9270588235294117f}, 
						 {0.9994980392156863f, 0.950243137254902f, 0.9261176470588235f}, 
						 {0.9994666666666666f, 0.9495843137254902f, 0.9251764705882353f}, 
						 {0.9994352941176471f, 0.9489254901960784f, 0.924235294117647f}, 
						 {0.9994039215686275f, 0.9482666666666667f, 0.9232941176470588f}, 
						 {0.9993725490196078f, 0.9476078431372549f, 0.9223529411764706f}, 
						 {0.9993411764705883f, 0.9469490196078432f, 0.9214117647058824f}, 
						 {0.9993098039215687f, 0.9462901960784313f, 0.9204705882352942f}, 
						 {0.999278431372549f, 0.9456313725490196f, 0.9195294117647058f}, 
						 {0.9992470588235294f, 0.9449725490196078f, 0.9185882352941176f}, 
						 {0.9992156862745099f, 0.9443137254901961f, 0.9176470588235294f}, 
						 {0.9991843137254902f, 0.9436549019607843f, 0.9167058823529411f}, 
						 {0.9991529411764706f, 0.9429960784313726f, 0.9157647058823529f}, 
						 {0.9991215686274509f, 0.9423372549019609f, 0.9148235294117647f}, 
						 {0.9990901960784314f, 0.941678431372549f, 0.9138823529411765f}, 
						 {0.9990588235294118f, 0.9410196078431373f, 0.9129411764705883f}, 
						 {0.9990274509803921f, 0.9403607843137255f, 0.912f}, 
						 {0.9989960784313725f, 0.9397019607843138f, 0.9110588235294117f}, 
						 {0.998964705882353f, 0.939043137254902f, 0.9101176470588235f}, 
						 {0.9989333333333333f, 0.9383843137254902f, 0.9091764705882353f}, 
						 {0.9989019607843137f, 0.9377254901960784f, 0.908235294117647f}, 
						 {0.9988705882352942f, 0.9370666666666667f, 0.9072941176470588f}, 
						 {0.9988392156862745f, 0.9364078431372549f, 0.9063529411764706f}, 
						 {0.9988078431372549f, 0.9357490196078432f, 0.9054117647058824f}, 
						 {0.9987764705882353f, 0.9350901960784314f, 0.9044705882352941f}, 
						 {0.9987450980392157f, 0.9344313725490196f, 0.9035294117647059f}, 
						 {0.9987137254901961f, 0.9337725490196078f, 0.9025882352941176f}, 
						 {0.9986823529411765f, 0.9331137254901961f, 0.9016470588235294f}, 
						 {0.9986509803921568f, 0.9324549019607843f, 0.9007058823529411f}, 
						 {0.9986196078431373f, 0.9317960784313726f, 0.8997647058823529f}, 
						 {0.9985882352941177f, 0.9311372549019608f, 0.8988235294117647f}, 
						 {0.998556862745098f, 0.930478431372549f, 0.8978823529411765f}, 
						 {0.9985254901960784f, 0.9298196078431372f, 0.8969411764705882f}, 
						 {0.9984941176470589f, 0.9291607843137255f, 0.896f}, 
						 {0.9984627450980392f, 0.9285019607843137f, 0.8950588235294117f}, 
						 {0.9984313725490196f, 0.927843137254902f, 0.8941176470588235f}, 
						 {0.9984f, 0.9271843137254903f, 0.8931764705882352f}, 
						 {0.9983686274509804f, 0.9265254901960784f, 0.892235294117647f}, 
						 {0.9983372549019608f, 0.9258666666666667f, 0.8912941176470588f}, 
						 {0.9983058823529412f, 0.9252078431372549f, 0.8903529411764706f}, 
						 {0.9982745098039216f, 0.9245490196078432f, 0.8894117647058823f}, 
						 {0.998243137254902f, 0.9238901960784314f, 0.8884705882352941f}, 
						 {0.9982117647058824f, 0.9232313725490197f, 0.8875294117647059f}, 
						 {0.9981803921568627f, 0.9225725490196078f, 0.8865882352941177f}, 
						 {0.9981490196078432f, 0.9219137254901961f, 0.8856470588235293f}, 
						 {0.9981176470588236f, 0.9212549019607843f, 0.8847058823529411f}, 
						 {0.9980862745098039f, 0.9205960784313726f, 0.8837647058823529f}, 
						 {0.9980549019607843f, 0.9199372549019608f, 0.8828235294117647f}, 
						 {0.9980235294117648f, 0.919278431372549f, 0.8818823529411765f}, 
						 {0.9979921568627451f, 0.9186196078431372f, 0.8809411764705882f}, 
						 {0.9979607843137255f, 0.9179607843137255f, 0.88f}, 
						 {0.9979294117647058f, 0.9173019607843137f, 0.8790588235294118f}, 
						 {0.9978980392156863f, 0.916643137254902f, 0.8781176470588234f}, 
						 {0.9978666666666667f, 0.9159843137254902f, 0.8771764705882352f}, 
						 {0.997835294117647f, 0.9153254901960785f, 0.876235294117647f}, 
						 {0.9978039215686274f, 0.9146666666666666f, 0.8752941176470588f}, 
						 {0.9977725490196079f, 0.9140078431372549f, 0.8743529411764706f}, 
						 {0.9977411764705882f, 0.9133490196078431f, 0.8734117647058823f}, 
						 {0.9977098039215686f, 0.9126901960784314f, 0.8724705882352941f}, 
						 {0.9976784313725491f, 0.9120313725490197f, 0.8715294117647059f}, 
						 {0.9976470588235294f, 0.9113725490196078f, 0.8705882352941177f}, 
						 {0.9976156862745098f, 0.910713725490196f, 0.8696470588235294f}, 
						 {0.9975843137254902f, 0.9100549019607843f, 0.8687058823529411f}, 
						 {0.9975529411764706f, 0.9093960784313726f, 0.8677647058823529f}, 
						 {0.997521568627451f, 0.9087372549019608f, 0.8668235294117647f}, 
						 {0.9974901960784314f, 0.9080784313725491f, 0.8658823529411764f}, 
						 {0.9974588235294117f, 0.9074196078431372f, 0.8649411764705882f}, 
						 {0.9974274509803922f, 0.9067607843137255f, 0.864f}, 
						 {0.9973960784313726f, 0.9061019607843137f, 0.8630588235294118f}, 
						 {0.9973647058823529f, 0.905443137254902f, 0.8621176470588234f}, 
						 {0.9973333333333333f, 0.9047843137254902f, 0.8611764705882352f}, 
						 {0.9973019607843138f, 0.9041254901960785f, 0.860235294117647f}, 
						 {0.9972705882352941f, 0.9034666666666666f, 0.8592941176470588f}, 
						 {0.9972392156862745f, 0.9028078431372549f, 0.8583529411764705f}, 
						 {0.9972078431372549f, 0.9021490196078431f, 0.8574117647058823f}, 
						 {0.9971764705882353f, 0.9014901960784314f, 0.8564705882352941f}, 
						 {0.9971450980392157f, 0.9008313725490196f, 0.8555294117647059f}, 
						 {0.9971137254901961f, 0.9001725490196079f, 0.8545882352941176f}, 
						 {0.9970823529411765f, 0.899513725490196f, 0.8536470588235294f}, 
						 {0.9970509803921569f, 0.8988549019607843f, 0.8527058823529412f}, 
						 {0.9970196078431373f, 0.8981960784313725f, 0.8517647058823529f}, 
						 {0.9969882352941176f, 0.8975372549019608f, 0.8508235294117646f}, 
						 {0.9969568627450981f, 0.896878431372549f, 0.8498823529411764f}, 
						 {0.9969254901960785f, 0.8962196078431373f, 0.8489411764705882f}, 
						 {0.9968941176470588f, 0.8955607843137254f, 0.848f}, 
						 {0.9968627450980392f, 0.8949019607843137f, 0.8470588235294118f}, 
						 {0.9968313725490197f, 0.894243137254902f, 0.8461176470588235f}, 
						 {0.9968f, 0.8935843137254902f, 0.8451764705882352f}, 
						 {0.9967686274509804f, 0.8929254901960784f, 0.844235294117647f}, 
						 {0.9967372549019607f, 0.8922666666666667f, 0.8432941176470587f}, 
						 {0.9967058823529412f, 0.8916078431372549f, 0.8423529411764705f}, 
						 {0.9966745098039216f, 0.8909490196078431f, 0.8414117647058823f}, 
						 {0.996643137254902f, 0.8902901960784314f, 0.8404705882352941f}, 
						 {0.9966117647058824f, 0.8896313725490196f, 0.8395294117647059f}, 
						 {0.9965803921568628f, 0.8889725490196079f, 0.8385882352941176f}, 
						 {0.9965490196078431f, 0.888313725490196f, 0.8376470588235294f}, 
						 {0.9965176470588235f, 0.8876549019607843f, 0.8367058823529412f}, 
						 {0.996486274509804f, 0.8869960784313725f, 0.8357647058823529f}, 
						 {0.9964549019607843f, 0.8863372549019608f, 0.8348235294117646f}, 
						 {0.9964235294117647f, 0.885678431372549f, 0.8338823529411764f}, 
						 {0.9963921568627451f, 0.8850196078431373f, 0.8329411764705882f}, 
						 {0.9963607843137255f, 0.8843607843137254f, 0.832f}, 
						 {0.9963294117647059f, 0.8837019607843137f, 0.8310588235294117f}, 
						 {0.9962980392156863f, 0.8830431372549019f, 0.8301176470588235f}, 
						 {0.9962666666666666f, 0.8823843137254902f, 0.8291764705882353f}, 
						 {0.9962352941176471f, 0.8817254901960784f, 0.8282352941176471f}, 
						 {0.9962039215686275f, 0.8810666666666667f, 0.8272941176470587f}, 
						 {0.9961725490196078f, 0.8804078431372548f, 0.8263529411764705f}, 
						 {0.9961411764705882f, 0.8797490196078431f, 0.8254117647058823f}, 
						 {0.9961098039215687f, 0.8790901960784314f, 0.8244705882352941f}, 
						 {0.996078431372549f, 0.8784313725490196f, 0.8235294117647058f}, 
						 {0.9960156862745099f, 0.8772705882352941f, 0.8219921568627451f}, 
						 {0.9959529411764706f, 0.8761098039215686f, 0.8204549019607843f}, 
						 {0.9958901960784314f, 0.8749490196078431f, 0.8189176470588235f}, 
						 {0.9958274509803922f, 0.8737882352941176f, 0.8173803921568628f}, 
						 {0.995764705882353f, 0.8726274509803922f, 0.8158431372549019f}, 
						 {0.9957019607843137f, 0.8714666666666666f, 0.8143058823529411f}, 
						 {0.9956392156862746f, 0.8703058823529412f, 0.8127686274509803f}, 
						 {0.9955764705882353f, 0.8691450980392157f, 0.8112313725490196f}, 
						 {0.9955137254901961f, 0.8679843137254901f, 0.8096941176470588f}, 
						 {0.9954509803921568f, 0.8668235294117647f, 0.808156862745098f}, 
						 {0.9953882352941177f, 0.8656627450980392f, 0.8066196078431372f}, 
						 {0.9953254901960784f, 0.8645019607843137f, 0.8050823529411764f}, 
						 {0.9952627450980392f, 0.8633411764705882f, 0.8035450980392156f}, 
						 {0.9952f, 0.8621803921568627f, 0.8020078431372548f}, 
						 {0.9951372549019608f, 0.8610196078431372f, 0.800470588235294f}, 
						 {0.9950745098039215f, 0.8598588235294118f, 0.7989333333333333f}, 
						 {0.9950117647058824f, 0.8586980392156862f, 0.7973960784313725f}, 
						 {0.9949490196078431f, 0.8575372549019608f, 0.7958588235294117f}, 
						 {0.9948862745098039f, 0.8563764705882353f, 0.794321568627451f}, 
						 {0.9948235294117648f, 0.8552156862745098f, 0.7927843137254902f}, 
						 {0.9947607843137255f, 0.8540549019607843f, 0.7912470588235294f}, 
						 {0.9946980392156863f, 0.8528941176470588f, 0.7897098039215686f}, 
						 {0.9946352941176471f, 0.8517333333333333f, 0.7881725490196079f}, 
						 {0.9945725490196079f, 0.8505725490196079f, 0.786635294117647f}, 
						 {0.9945098039215686f, 0.8494117647058823f, 0.7850980392156862f}, 
						 {0.9944470588235295f, 0.8482509803921569f, 0.7835607843137254f}, 
						 {0.9943843137254902f, 0.8470901960784314f, 0.7820235294117647f}, 
						 {0.994321568627451f, 0.8459294117647058f, 0.7804862745098039f}, 
						 {0.9942588235294118f, 0.8447686274509804f, 0.7789490196078431f}, 
						 {0.9941960784313726f, 0.8436078431372549f, 0.7774117647058824f}, 
						 {0.9941333333333333f, 0.8424470588235294f, 0.7758745098039215f}, 
						 {0.9940705882352942f, 0.8412862745098039f, 0.7743372549019607f}, 
						 {0.9940078431372549f, 0.8401254901960784f, 0.7727999999999999f}, 
						 {0.9939450980392157f, 0.838964705882353f, 0.7712627450980392f}, 
						 {0.9938823529411764f, 0.8378039215686274f, 0.7697254901960784f}, 
						 {0.9938196078431373f, 0.8366431372549019f, 0.7681882352941176f}, 
						 {0.9937568627450981f, 0.8354823529411765f, 0.7666509803921568f}, 
						 {0.9936941176470588f, 0.834321568627451f, 0.7651137254901961f}, 
						 {0.9936313725490197f, 0.8331607843137254f, 0.7635764705882353f}, 
						 {0.9935686274509804f, 0.832f, 0.7620392156862744f}, 
						 {0.9935058823529412f, 0.8308392156862745f, 0.7605019607843136f}, 
						 {0.993443137254902f, 0.8296784313725489f, 0.7589647058823529f}, 
						 {0.9933803921568628f, 0.8285176470588235f, 0.7574274509803921f}, 
						 {0.9933176470588235f, 0.827356862745098f, 0.7558901960784313f}, 
						 {0.9932549019607844f, 0.8261960784313725f, 0.7543529411764706f}, 
						 {0.9931921568627451f, 0.825035294117647f, 0.7528156862745098f}, 
						 {0.9931294117647059f, 0.8238745098039215f, 0.7512784313725489f}, 
						 {0.9930666666666667f, 0.8227137254901961f, 0.7497411764705881f}, 
						 {0.9930039215686275f, 0.8215529411764706f, 0.7482039215686274f}, 
						 {0.9929411764705882f, 0.820392156862745f, 0.7466666666666666f}, 
						 {0.992878431372549f, 0.8192313725490196f, 0.7451294117647058f}, 
						 {0.9928156862745098f, 0.8180705882352941f, 0.743592156862745f}, 
						 {0.9927529411764706f, 0.8169098039215686f, 0.7420549019607843f}, 
						 {0.9926901960784315f, 0.8157490196078431f, 0.7405176470588235f}, 
						 {0.9926274509803922f, 0.8145882352941176f, 0.7389803921568627f}, 
						 {0.992564705882353f, 0.8134274509803922f, 0.737443137254902f}, 
						 {0.9925019607843137f, 0.8122666666666667f, 0.7359058823529412f}, 
						 {0.9924392156862746f, 0.8111058823529411f, 0.7343686274509804f}, 
						 {0.9923764705882353f, 0.8099450980392157f, 0.7328313725490195f}, 
						 {0.9923137254901961f, 0.8087843137254902f, 0.7312941176470588f}, 
						 {0.9922509803921569f, 0.8076235294117646f, 0.729756862745098f}, 
						 {0.9921882352941177f, 0.8064627450980392f, 0.7282196078431372f}, 
						 {0.9921254901960784f, 0.8053019607843137f, 0.7266823529411764f}, 
						 {0.9920627450980393f, 0.8041411764705882f, 0.7251450980392157f}, 
						 {0.992f, 0.8029803921568627f, 0.7236078431372549f}, 
						 {0.9919372549019608f, 0.8018196078431372f, 0.7220705882352941f}, 
						 {0.9918745098039216f, 0.8006588235294118f, 0.7205333333333332f}, 
						 {0.9918117647058824f, 0.7994980392156863f, 0.7189960784313725f}, 
						 {0.9917490196078431f, 0.7983372549019607f, 0.7174588235294117f}, 
						 {0.991686274509804f, 0.7971764705882353f, 0.7159215686274509f}, 
						 {0.9916235294117647f, 0.7960156862745098f, 0.7143843137254902f}, 
						 {0.9915607843137255f, 0.7948549019607842f, 0.7128470588235294f}, 
						 {0.9914980392156864f, 0.7936941176470588f, 0.7113098039215686f}, 
						 {0.9914352941176471f, 0.7925333333333333f, 0.7097725490196078f}, 
						 {0.9913725490196079f, 0.7913725490196077f, 0.7082352941176471f}, 
						 {0.9913098039215686f, 0.7902117647058823f, 0.7066980392156862f}, 
						 {0.9912470588235295f, 0.7890509803921568f, 0.7051607843137254f}, 
						 {0.9911843137254902f, 0.7878901960784314f, 0.7036235294117646f}, 
						 {0.991121568627451f, 0.7867294117647058f, 0.7020862745098039f}, 
						 {0.9910588235294118f, 0.7855686274509803f, 0.7005490196078431f}, 
						 {0.9909960784313726f, 0.7844078431372549f, 0.6990117647058823f}, 
						 {0.9909333333333333f, 0.7832470588235294f, 0.6974745098039214f}, 
						 {0.9908705882352942f, 0.7820862745098038f, 0.6959372549019607f}, 
						 {0.9908078431372549f, 0.7809254901960784f, 0.6944f}, 
						 {0.9907450980392157f, 0.7797647058823529f, 0.6928627450980391f}, 
						 {0.9906823529411765f, 0.7786039215686275f, 0.6913254901960784f}, 
						 {0.9906196078431373f, 0.7774431372549019f, 0.6897882352941176f}, 
						 {0.990556862745098f, 0.7762823529411764f, 0.6882509803921568f}, 
						 {0.9904941176470589f, 0.775121568627451f, 0.686713725490196f}, 
						 {0.9904313725490197f, 0.7739607843137255f, 0.6851764705882353f}, 
						 {0.9903686274509804f, 0.7727999999999999f, 0.6836392156862745f}, 
						 {0.9903058823529413f, 0.7716392156862745f, 0.6821019607843137f}, 
						 {0.990243137254902f, 0.770478431372549f, 0.680564705882353f}, 
						 {0.9901803921568628f, 0.7693176470588234f, 0.6790274509803922f}, 
						 {0.9901176470588235f, 0.768156862745098f, 0.6774901960784313f}, 
						 {0.9900549019607844f, 0.7669960784313725f, 0.6759529411764705f}, 
						 {0.9899921568627451f, 0.7658352941176471f, 0.6744156862745098f}, 
						 {0.989929411764706f, 0.7646745098039215f, 0.672878431372549f}, 
						 {0.9898666666666667f, 0.763513725490196f, 0.6713411764705882f}, 
						 {0.9898039215686275f, 0.7623529411764706f, 0.6698039215686274f}, 
						 {0.9897411764705882f, 0.7611921568627451f, 0.6682666666666666f}, 
						 {0.9896784313725491f, 0.7600313725490195f, 0.6667294117647058f}, 
						 {0.9896156862745098f, 0.7588705882352941f, 0.665192156862745f}, 
						 {0.9895529411764706f, 0.7577098039215686f, 0.6636549019607842f}, 
						 {0.9894901960784314f, 0.756549019607843f, 0.6621176470588235f}, 
						 {0.9894274509803922f, 0.7553882352941176f, 0.6605803921568627f}, 
						 {0.9893647058823529f, 0.7542274509803921f, 0.6590431372549019f}, 
						 {0.9893019607843138f, 0.7530666666666666f, 0.6575058823529412f}, 
						 {0.9892392156862746f, 0.7519058823529411f, 0.6559686274509804f}, 
						 {0.9891764705882353f, 0.7507450980392156f, 0.6544313725490196f}, 
						 {0.9891137254901962f, 0.7495843137254902f, 0.6528941176470587f}, 
						 {0.9890509803921569f, 0.7484235294117646f, 0.651356862745098f}, 
						 {0.9889882352941177f, 0.7472627450980391f, 0.6498196078431372f}, 
						 {0.9889254901960784f, 0.7461019607843137f, 0.6482823529411764f}, 
						 {0.9888627450980393f, 0.7449411764705882f, 0.6467450980392156f}, 
						 {0.9888f, 0.7437803921568626f, 0.6452078431372549f}, 
						 {0.9887372549019608f, 0.7426196078431372f, 0.6436705882352941f}, 
						 {0.9886745098039216f, 0.7414588235294117f, 0.6421333333333333f}, 
						 {0.9886117647058824f, 0.7402980392156863f, 0.6405960784313726f}, 
						 {0.9885490196078431f, 0.7391372549019608f, 0.6390588235294117f}, 
						 {0.988486274509804f, 0.7379764705882352f, 0.6375215686274509f}, 
						 {0.9884235294117647f, 0.7368156862745098f, 0.6359843137254901f}, 
						 {0.9883607843137255f, 0.7356549019607843f, 0.6344470588235294f}, 
						 {0.9882980392156863f, 0.7344941176470587f, 0.6329098039215686f}, 
						 {0.9882352941176471f, 0.7333333333333333f, 0.6313725490196078f}, 
						 {0.9882352941176471f, 0.7320470588235294f, 0.6298980392156862f}, 
						 {0.9882352941176471f, 0.7307607843137255f, 0.6284235294117647f}, 
						 {0.9882352941176471f, 0.7294745098039215f, 0.6269490196078431f}, 
						 {0.9882352941176471f, 0.7281882352941176f, 0.6254745098039215f}, 
						 {0.9882352941176471f, 0.7269019607843137f, 0.624f}, 
						 {0.9882352941176471f, 0.7256156862745098f, 0.6225254901960784f}, 
						 {0.9882352941176471f, 0.7243294117647058f, 0.6210509803921568f}, 
						 {0.9882352941176471f, 0.7230431372549019f, 0.6195764705882353f}, 
						 {0.9882352941176471f, 0.721756862745098f, 0.6181019607843137f}, 
						 {0.9882352941176471f, 0.7204705882352941f, 0.6166274509803922f}, 
						 {0.9882352941176471f, 0.7191843137254902f, 0.6151529411764706f}, 
						 {0.9882352941176471f, 0.7178980392156862f, 0.613678431372549f}, 
						 {0.9882352941176471f, 0.7166117647058823f, 0.6122039215686275f}, 
						 {0.9882352941176471f, 0.7153254901960784f, 0.6107294117647059f}, 
						 {0.9882352941176471f, 0.7140392156862745f, 0.6092549019607842f}, 
						 {0.9882352941176471f, 0.7127529411764705f, 0.6077803921568627f}, 
						 {0.9882352941176471f, 0.7114666666666666f, 0.6063058823529411f}, 
						 {0.9882352941176471f, 0.7101803921568627f, 0.6048313725490195f}, 
						 {0.9882352941176471f, 0.7088941176470588f, 0.603356862745098f}, 
						 {0.9882352941176471f, 0.7076078431372548f, 0.6018823529411764f}, 
						 {0.9882352941176471f, 0.7063215686274509f, 0.6004078431372548f}, 
						 {0.9882352941176471f, 0.705035294117647f, 0.5989333333333333f}, 
						 {0.9882352941176471f, 0.7037490196078431f, 0.5974588235294117f}, 
						 {0.9882352941176471f, 0.7024627450980392f, 0.5959843137254901f}, 
						 {0.9882352941176471f, 0.7011764705882352f, 0.5945098039215686f}, 
						 {0.9882352941176471f, 0.6998901960784313f, 0.593035294117647f}, 
						 {0.9882352941176471f, 0.6986039215686274f, 0.5915607843137254f}, 
						 {0.9882352941176471f, 0.6973176470588235f, 0.5900862745098039f}, 
						 {0.9882352941176471f, 0.6960313725490195f, 0.5886117647058823f}, 
						 {0.9882352941176471f, 0.6947450980392156f, 0.5871372549019608f}, 
						 {0.9882352941176471f, 0.6934588235294117f, 0.5856627450980392f}, 
						 {0.9882352941176471f, 0.6921725490196078f, 0.5841882352941176f}, 
						 {0.9882352941176471f, 0.6908862745098039f, 0.5827137254901961f}, 
						 {0.9882352941176471f, 0.6895999999999999f, 0.5812392156862745f}, 
						 {0.9882352941176471f, 0.688313725490196f, 0.5797647058823528f}, 
						 {0.9882352941176471f, 0.6870274509803921f, 0.5782901960784314f}, 
						 {0.9882352941176471f, 0.6857411764705882f, 0.5768156862745097f}, 
						 {0.9882352941176471f, 0.6844549019607842f, 0.5753411764705881f}, 
						 {0.9882352941176471f, 0.6831686274509804f, 0.5738666666666667f}, 
						 {0.9882352941176471f, 0.6818823529411765f, 0.5723921568627451f}, 
						 {0.9882352941176471f, 0.6805960784313725f, 0.5709176470588235f}, 
						 {0.9882352941176471f, 0.6793098039215686f, 0.569443137254902f}, 
						 {0.9882352941176471f, 0.6780235294117647f, 0.5679686274509804f}, 
						 {0.9882352941176471f, 0.6767372549019608f, 0.5664941176470588f}, 
						 {0.9882352941176471f, 0.6754509803921568f, 0.5650196078431373f}, 
						 {0.9882352941176471f, 0.6741647058823529f, 0.5635450980392157f}, 
						 {0.9882352941176471f, 0.672878431372549f, 0.5620705882352941f}, 
						 {0.9882352941176471f, 0.6715921568627451f, 0.5605960784313726f}, 
						 {0.9882352941176471f, 0.6703058823529411f, 0.559121568627451f}, 
						 {0.9882352941176471f, 0.6690196078431372f, 0.5576470588235294f}, 
						 {0.9882352941176471f, 0.6677333333333333f, 0.5561725490196079f}, 
						 {0.9882352941176471f, 0.6664470588235294f, 0.5546980392156863f}, 
						 {0.9882352941176471f, 0.6651607843137255f, 0.5532235294117647f}, 
						 {0.9882352941176471f, 0.6638745098039215f, 0.5517490196078432f}, 
						 {0.9882352941176471f, 0.6625882352941176f, 0.5502745098039216f}, 
						 {0.9882352941176471f, 0.6613019607843137f, 0.5488f}, 
						 {0.9882352941176471f, 0.6600156862745098f, 0.5473254901960785f}, 
						 {0.9882352941176471f, 0.6587294117647058f, 0.5458509803921568f}, 
						 {0.9882352941176471f, 0.6574431372549019f, 0.5443764705882352f}, 
						 {0.9882352941176471f, 0.656156862745098f, 0.5429019607843137f}, 
						 {0.9882352941176471f, 0.6548705882352941f, 0.5414274509803921f}, 
						 {0.9882352941176471f, 0.6535843137254902f, 0.5399529411764706f}, 
						 {0.9882352941176471f, 0.6522980392156862f, 0.538478431372549f}, 
						 {0.9882352941176471f, 0.6510117647058823f, 0.5370039215686274f}, 
						 {0.9882352941176471f, 0.6497254901960784f, 0.5355294117647059f}, 
						 {0.9882352941176471f, 0.6484392156862745f, 0.5340549019607843f}, 
						 {0.9882352941176471f, 0.6471529411764705f, 0.5325803921568627f}, 
						 {0.9882352941176471f, 0.6458666666666666f, 0.5311058823529412f}, 
						 {0.9882352941176471f, 0.6445803921568627f, 0.5296313725490196f}, 
						 {0.9882352941176471f, 0.6432941176470588f, 0.528156862745098f}, 
						 {0.9882352941176471f, 0.6420078431372549f, 0.5266823529411765f}, 
						 {0.9882352941176471f, 0.6407215686274509f, 0.5252078431372549f}, 
						 {0.9882352941176471f, 0.639435294117647f, 0.5237333333333334f}, 
						 {0.9882352941176471f, 0.6381490196078431f, 0.5222588235294118f}, 
						 {0.9882352941176471f, 0.6368627450980392f, 0.5207843137254902f}, 
						 {0.9882352941176471f, 0.6355764705882352f, 0.5193098039215687f}, 
						 {0.9882352941176471f, 0.6342901960784313f, 0.5178352941176471f}, 
						 {0.9882352941176471f, 0.6330039215686274f, 0.5163607843137255f}, 
						 {0.9882352941176471f, 0.6317176470588235f, 0.514886274509804f}, 
						 {0.9882352941176471f, 0.6304313725490196f, 0.5134117647058823f}, 
						 {0.9882352941176471f, 0.6291450980392156f, 0.5119372549019607f}, 
						 {0.9882352941176471f, 0.6278588235294117f, 0.5104627450980392f}, 
						 {0.9882352941176471f, 0.6265725490196078f, 0.5089882352941176f}, 
						 {0.9882352941176471f, 0.6252862745098039f, 0.507513725490196f}, 
						 {0.9882352941176471f, 0.6239999999999999f, 0.5060392156862745f}, 
						 {0.9882352941176471f, 0.622713725490196f, 0.5045647058823529f}, 
						 {0.9882352941176471f, 0.6214274509803921f, 0.5030901960784313f}, 
						 {0.9882352941176471f, 0.6201411764705882f, 0.5016156862745098f}, 
						 {0.9882352941176471f, 0.6188549019607843f, 0.5001411764705882f}, 
						 {0.9882352941176471f, 0.6175686274509803f, 0.49866666666666665f}, 
						 {0.9882352941176471f, 0.6162823529411764f, 0.4971921568627451f}, 
						 {0.9882352941176471f, 0.6149960784313725f, 0.4957176470588235f}, 
						 {0.9882352941176471f, 0.6137098039215686f, 0.49424313725490193f}, 
						 {0.9882352941176471f, 0.6124235294117646f, 0.4927686274509804f}, 
						 {0.9882352941176471f, 0.6111372549019607f, 0.49129411764705877f}, 
						 {0.9882352941176471f, 0.6098509803921568f, 0.4898196078431372f}, 
						 {0.9882352941176471f, 0.6085647058823529f, 0.48834509803921566f}, 
						 {0.9882352941176471f, 0.607278431372549f, 0.48687058823529406f}, 
						 {0.9882352941176471f, 0.605992156862745f, 0.4853960784313725f}, 
						 {0.9882352941176471f, 0.6047058823529411f, 0.48392156862745095f}, 
						 {0.9882352941176471f, 0.6034196078431372f, 0.48244705882352934f}, 
						 {0.9882352941176471f, 0.6021333333333333f, 0.4809725490196079f}, 
						 {0.9882352941176471f, 0.6008470588235294f, 0.47949803921568634f}, 
						 {0.9882352941176471f, 0.5995607843137255f, 0.47802352941176474f}, 
						 {0.9882352941176471f, 0.5982745098039215f, 0.4765490196078432f}, 
						 {0.9882352941176471f, 0.5969882352941176f, 0.47507450980392163f}, 
						 {0.9882352941176471f, 0.5957019607843137f, 0.4736f}, 
						 {0.9882352941176471f, 0.5944156862745098f, 0.47212549019607847f}, 
						 {0.9882352941176471f, 0.5931294117647059f, 0.4706509803921569f}, 
						 {0.9882352941176471f, 0.591843137254902f, 0.4691764705882353f}, 
						 {0.9882352941176471f, 0.590556862745098f, 0.46770196078431375f}, 
						 {0.9882352941176471f, 0.5892705882352941f, 0.4662274509803922f}, 
						 {0.9882352941176471f, 0.5879843137254902f, 0.4647529411764706f}, 
						 {0.9882352941176471f, 0.5866980392156862f, 0.4632784313725491f}, 
						 {0.9882352941176471f, 0.5854117647058823f, 0.4618039215686275f}, 
						 {0.9882352941176471f, 0.5841254901960784f, 0.4603294117647059f}, 
						 {0.9882352941176471f, 0.5828392156862745f, 0.4588549019607844f}, 
						 {0.9882352941176471f, 0.5815529411764706f, 0.45738039215686277f}, 
						 {0.9882352941176471f, 0.5802666666666666f, 0.4559058823529412f}, 
						 {0.9882352941176471f, 0.5789803921568627f, 0.45443137254901966f}, 
						 {0.9882352941176471f, 0.5776941176470588f, 0.45295686274509805f}, 
						 {0.9882352941176471f, 0.5764078431372549f, 0.4514823529411765f}, 
						 {0.9882352941176471f, 0.5751215686274509f, 0.45000784313725495f}, 
						 {0.9882352941176471f, 0.573835294117647f, 0.44853333333333334f}, 
						 {0.9882352941176471f, 0.5725490196078431f, 0.4470588235294118f}, 
						 {0.9882039215686275f, 0.5712941176470588f, 0.44580392156862747f}, 
						 {0.9881725490196079f, 0.5700392156862745f, 0.44454901960784315f}, 
						 {0.9881411764705883f, 0.5687843137254902f, 0.44329411764705884f}, 
						 {0.9881098039215687f, 0.5675294117647058f, 0.4420392156862745f}, 
						 {0.988078431372549f, 0.5662745098039216f, 0.4407843137254902f}, 
						 {0.9880470588235295f, 0.5650196078431372f, 0.4395294117647059f}, 
						 {0.9880156862745099f, 0.563764705882353f, 0.4382745098039216f}, 
						 {0.9879843137254902f, 0.5625098039215686f, 0.43701960784313726f}, 
						 {0.9879529411764706f, 0.5612549019607843f, 0.43576470588235294f}, 
						 {0.9879215686274511f, 0.5599999999999999f, 0.4345098039215686f}, 
						 {0.9878901960784314f, 0.5587450980392157f, 0.4332549019607843f}, 
						 {0.9878588235294118f, 0.5574901960784313f, 0.432f}, 
						 {0.9878274509803922f, 0.556235294117647f, 0.4307450980392157f}, 
						 {0.9877960784313726f, 0.5549803921568627f, 0.42949019607843136f}, 
						 {0.987764705882353f, 0.5537254901960784f, 0.42823529411764705f}, 
						 {0.9877333333333334f, 0.552470588235294f, 0.42698039215686273f}, 
						 {0.9877019607843137f, 0.5512156862745098f, 0.4257254901960784f}, 
						 {0.9876705882352942f, 0.5499607843137254f, 0.4244705882352941f}, 
						 {0.9876392156862746f, 0.5487058823529412f, 0.4232156862745098f}, 
						 {0.9876078431372549f, 0.5474509803921568f, 0.42196078431372547f}, 
						 {0.9875764705882353f, 0.5461960784313725f, 0.42070588235294115f}, 
						 {0.9875450980392158f, 0.5449411764705882f, 0.41945098039215684f}, 
						 {0.9875137254901961f, 0.5436862745098039f, 0.4181960784313725f}, 
						 {0.9874823529411765f, 0.5424313725490195f, 0.41694117647058826f}, 
						 {0.9874509803921568f, 0.5411764705882353f, 0.4156862745098039f}, 
						 {0.9874196078431373f, 0.5399215686274509f, 0.4144313725490196f}, 
						 {0.9873882352941177f, 0.5386666666666666f, 0.41317647058823526f}, 
						 {0.987356862745098f, 0.5374117647058823f, 0.411921568627451f}, 
						 {0.9873254901960784f, 0.536156862745098f, 0.4106666666666667f}, 
						 {0.9872941176470589f, 0.5349019607843136f, 0.40941176470588236f}, 
						 {0.9872627450980392f, 0.5336470588235294f, 0.40815686274509805f}, 
						 {0.9872313725490196f, 0.532392156862745f, 0.40690196078431373f}, 
						 {0.9872f, 0.5311372549019607f, 0.4056470588235294f}, 
						 {0.9871686274509804f, 0.5298823529411765f, 0.4043921568627451f}, 
						 {0.9871372549019608f, 0.5286274509803921f, 0.4031372549019608f}, 
						 {0.9871058823529412f, 0.5273725490196077f, 0.40188235294117647f}, 
						 {0.9870745098039215f, 0.5261176470588235f, 0.40062745098039215f}, 
						 {0.987043137254902f, 0.5248627450980392f, 0.39937254901960784f}, 
						 {0.9870117647058824f, 0.5236078431372548f, 0.3981176470588235f}, 
						 {0.9869803921568627f, 0.5223529411764706f, 0.3968627450980392f}, 
						 {0.9869490196078431f, 0.5210980392156862f, 0.3956078431372549f}, 
						 {0.9869176470588236f, 0.5198431372549019f, 0.39435294117647063f}, 
						 {0.9868862745098039f, 0.5185882352941177f, 0.3930980392156863f}, 
						 {0.9868549019607843f, 0.5173333333333333f, 0.391843137254902f}, 
						 {0.9868235294117648f, 0.516078431372549f, 0.3905882352941177f}, 
						 {0.9867921568627451f, 0.5148235294117647f, 0.38933333333333336f}, 
						 {0.9867607843137255f, 0.5135686274509804f, 0.38807843137254905f}, 
						 {0.9867294117647059f, 0.512313725490196f, 0.38682352941176473f}, 
						 {0.9866980392156863f, 0.5110588235294118f, 0.3855686274509804f}, 
						 {0.9866666666666667f, 0.5098039215686274f, 0.3843137254901961f}, 
						 {0.986635294117647f, 0.5085490196078432f, 0.3830588235294118f}, 
						 {0.9866039215686274f, 0.5072941176470588f, 0.38180392156862747f}, 
						 {0.9865725490196079f, 0.5060392156862745f, 0.38054901960784315f}, 
						 {0.9865411764705883f, 0.5047843137254902f, 0.37929411764705884f}, 
						 {0.9865098039215686f, 0.5035294117647059f, 0.3780392156862745f}, 
						 {0.986478431372549f, 0.5022745098039215f, 0.3767843137254902f}, 
						 {0.9864470588235295f, 0.5010196078431373f, 0.3755294117647059f}, 
						 {0.9864156862745098f, 0.49976470588235294f, 0.37427450980392163f}, 
						 {0.9863843137254902f, 0.49850980392156863f, 0.37301960784313726f}, 
						 {0.9863529411764705f, 0.4972549019607843f, 0.371764705882353f}, 
						 {0.986321568627451f, 0.496f, 0.3705098039215686f}, 
						 {0.9862901960784314f, 0.4947450980392157f, 0.36925490196078437f}, 
						 {0.9862588235294117f, 0.49349019607843136f, 0.368f}, 
						 {0.9862274509803921f, 0.49223529411764705f, 0.36674509803921573f}, 
						 {0.9861960784313726f, 0.49098039215686273f, 0.36549019607843136f}, 
						 {0.9861647058823529f, 0.4897254901960784f, 0.3642352941176471f}, 
						 {0.9861333333333333f, 0.4884705882352941f, 0.36298039215686273f}, 
						 {0.9861019607843137f, 0.4872156862745098f, 0.36172549019607847f}, 
						 {0.9860705882352941f, 0.48596078431372547f, 0.36047058823529415f}, 
						 {0.9860392156862745f, 0.48470588235294115f, 0.35921568627450984f}, 
						 {0.9860078431372549f, 0.48345098039215684f, 0.3579607843137255f}, 
						 {0.9859764705882352f, 0.4821960784313725f, 0.3567058823529412f}, 
						 {0.9859450980392157f, 0.4809411764705882f, 0.3554509803921569f}, 
						 {0.9859137254901961f, 0.4796862745098039f, 0.3541960784313726f}, 
						 {0.9858823529411764f, 0.4784313725490196f, 0.35294117647058826f}, 
						 {0.9858509803921568f, 0.4771764705882353f, 0.35168627450980394f}, 
						 {0.9858196078431373f, 0.47592156862745094f, 0.3504313725490196f}, 
						 {0.9857882352941176f, 0.4746666666666667f, 0.3491764705882353f}, 
						 {0.985756862745098f, 0.4734117647058823f, 0.347921568627451f}, 
						 {0.9857254901960784f, 0.47215686274509805f, 0.3466666666666667f}, 
						 {0.9856941176470588f, 0.4709019607843137f, 0.34541176470588236f}, 
						 {0.9856627450980392f, 0.4696470588235294f, 0.34415686274509805f}, 
						 {0.9856313725490196f, 0.46839215686274505f, 0.34290196078431373f}, 
						 {0.9856f, 0.4671372549019608f, 0.3416470588235294f}, 
						 {0.9855686274509804f, 0.46588235294117647f, 0.3403921568627451f}, 
						 {0.9855372549019608f, 0.46462745098039215f, 0.3391372549019608f}, 
						 {0.9855058823529411f, 0.46337254901960784f, 0.33788235294117647f}, 
						 {0.9854745098039216f, 0.4621176470588235f, 0.33662745098039215f}, 
						 {0.985443137254902f, 0.4608627450980392f, 0.33537254901960784f}, 
						 {0.9854117647058823f, 0.4596078431372549f, 0.3341176470588235f}, 
						 {0.9853803921568627f, 0.4583529411764706f, 0.3328627450980392f}, 
						 {0.9853490196078432f, 0.45709803921568626f, 0.3316078431372549f}, 
						 {0.9853176470588235f, 0.45584313725490194f, 0.33035294117647057f}, 
						 {0.9852862745098039f, 0.4545882352941176f, 0.32909803921568626f}, 
						 {0.9852549019607842f, 0.4533333333333333f, 0.32784313725490194f}, 
						 {0.9852235294117647f, 0.452078431372549f, 0.3265882352941176f}, 
						 {0.9851921568627451f, 0.4508235294117647f, 0.3253333333333333f}, 
						 {0.9851607843137254f, 0.44956862745098036f, 0.324078431372549f}, 
						 {0.9851294117647058f, 0.44831372549019605f, 0.3228235294117647f}, 
						 {0.9850980392156863f, 0.44705882352941173f, 0.32156862745098036f}, 
						 {0.9850666666666666f, 0.4458039215686274f, 0.3203137254901961f}, 
						 {0.985035294117647f, 0.4445490196078431f, 0.31905882352941173f}, 
						 {0.9850039215686274f, 0.4432941176470588f, 0.31780392156862747f}, 
						 {0.9849725490196078f, 0.44203921568627447f, 0.3165490196078431f}, 
						 {0.9849411764705882f, 0.4407843137254902f, 0.31529411764705884f}, 
						 {0.9849098039215686f, 0.43952941176470595f, 0.3140392156862746f}, 
						 {0.9848784313725489f, 0.4382745098039216f, 0.3127843137254902f}, 
						 {0.9848470588235294f, 0.4370196078431373f, 0.31152941176470594f}, 
						 {0.9848156862745098f, 0.43576470588235294f, 0.31027450980392157f}, 
						 {0.9847843137254901f, 0.4345098039215687f, 0.3090196078431373f}, 
						 {0.9847529411764705f, 0.4332549019607843f, 0.30776470588235294f}, 
						 {0.984721568627451f, 0.43200000000000005f, 0.3065098039215687f}, 
						 {0.9846901960784313f, 0.4307450980392157f, 0.30525490196078436f}, 
						 {0.9846588235294117f, 0.4294901960784314f, 0.30400000000000005f}, 
						 {0.9846274509803921f, 0.42823529411764705f, 0.30274509803921573f}, 
						 {0.9845960784313725f, 0.4269803921568628f, 0.3014901960784314f}, 
						 {0.9845647058823529f, 0.42572549019607847f, 0.3002352941176471f}, 
						 {0.9845333333333333f, 0.42447058823529416f, 0.2989803921568628f}, 
						 {0.9845019607843136f, 0.42321568627450984f, 0.29772549019607847f}, 
						 {0.9844705882352941f, 0.4219607843137255f, 0.29647058823529415f}, 
						 {0.9844392156862745f, 0.4207058823529412f, 0.29521568627450984f}, 
						 {0.9844078431372548f, 0.4194509803921569f, 0.2939607843137255f}, 
						 {0.9843764705882352f, 0.4181960784313726f, 0.2927058823529412f}, 
						 {0.9843450980392157f, 0.41694117647058826f, 0.2914509803921569f}, 
						 {0.984313725490196f, 0.41568627450980394f, 0.2901960784313726f}, 
						 {0.9839372549019607f, 0.4142117647058824f, 0.28925490196078435f}, 
						 {0.9835607843137254f, 0.4127372549019608f, 0.2883137254901961f}, 
						 {0.9831843137254901f, 0.41126274509803923f, 0.28737254901960785f}, 
						 {0.9828078431372549f, 0.4097882352941177f, 0.2864313725490196f}, 
						 {0.9824313725490196f, 0.40831372549019607f, 0.2854901960784314f}, 
						 {0.9820549019607843f, 0.4068392156862745f, 0.2845490196078432f}, 
						 {0.981678431372549f, 0.40536470588235296f, 0.2836078431372549f}, 
						 {0.9813019607843136f, 0.4038901960784314f, 0.2826666666666667f}, 
						 {0.9809254901960783f, 0.4024156862745098f, 0.28172549019607845f}, 
						 {0.9805490196078431f, 0.40094117647058825f, 0.28078431372549023f}, 
						 {0.9801725490196078f, 0.3994666666666667f, 0.27984313725490195f}, 
						 {0.9797960784313725f, 0.3979921568627451f, 0.27890196078431373f}, 
						 {0.9794196078431372f, 0.39651764705882353f, 0.2779607843137255f}, 
						 {0.9790431372549019f, 0.395043137254902f, 0.2770196078431373f}, 
						 {0.9786666666666666f, 0.39356862745098037f, 0.276078431372549f}, 
						 {0.9782901960784314f, 0.3920941176470588f, 0.2751372549019608f}, 
						 {0.9779137254901961f, 0.39061960784313726f, 0.27419607843137256f}, 
						 {0.9775372549019608f, 0.3891450980392157f, 0.27325490196078434f}, 
						 {0.9771607843137254f, 0.3876705882352941f, 0.27231372549019606f}, 
						 {0.9767843137254901f, 0.38619607843137255f, 0.27137254901960783f}, 
						 {0.9764078431372548f, 0.384721568627451f, 0.2704313725490196f}, 
						 {0.9760313725490195f, 0.3832470588235294f, 0.2694901960784314f}, 
						 {0.9756549019607843f, 0.38177254901960783f, 0.26854901960784316f}, 
						 {0.975278431372549f, 0.3802980392156863f, 0.2676078431372549f}, 
						 {0.9749019607843137f, 0.37882352941176467f, 0.26666666666666666f}, 
						 {0.9745254901960784f, 0.3773490196078431f, 0.26572549019607844f}, 
						 {0.9741490196078431f, 0.37587450980392156f, 0.2647843137254902f}, 
						 {0.9737725490196077f, 0.37439999999999996f, 0.26384313725490194f}, 
						 {0.9733960784313725f, 0.3729254901960784f, 0.2629019607843137f}, 
						 {0.9730196078431372f, 0.37145098039215685f, 0.2619607843137255f}, 
						 {0.9726431372549019f, 0.3699764705882353f, 0.26101960784313727f}, 
						 {0.9722666666666666f, 0.3685019607843137f, 0.260078431372549f}, 
						 {0.9718901960784313f, 0.36702745098039213f, 0.25913725490196077f}, 
						 {0.971513725490196f, 0.3655529411764706f, 0.25819607843137254f}, 
						 {0.9711372549019608f, 0.36407843137254897f, 0.2572549019607843f}, 
						 {0.9707607843137255f, 0.3626039215686274f, 0.25631372549019604f}, 
						 {0.9703843137254902f, 0.36112941176470587f, 0.2553725490196078f}, 
						 {0.9700078431372549f, 0.3596549019607843f, 0.2544313725490196f}, 
						 {0.9696313725490195f, 0.3581803921568627f, 0.2534901960784314f}, 
						 {0.9692549019607842f, 0.35670588235294115f, 0.25254901960784315f}, 
						 {0.9688784313725489f, 0.3552313725490196f, 0.25160784313725487f}, 
						 {0.9685019607843137f, 0.353756862745098f, 0.25066666666666665f}, 
						 {0.9681254901960784f, 0.35228235294117644f, 0.24972549019607843f}, 
						 {0.9677490196078431f, 0.3508078431372549f, 0.24878431372549017f}, 
						 {0.9673725490196078f, 0.3493333333333333f, 0.24784313725490192f}, 
						 {0.9669960784313725f, 0.3478588235294117f, 0.2469019607843137f}, 
						 {0.9666196078431372f, 0.34638431372549017f, 0.24596078431372548f}, 
						 {0.966243137254902f, 0.34490980392156856f, 0.24501960784313723f}, 
						 {0.9658666666666667f, 0.343435294117647f, 0.24407843137254898f}, 
						 {0.9654901960784313f, 0.34196078431372545f, 0.24313725490196075f}, 
						 {0.965113725490196f, 0.34048627450980384f, 0.24219607843137253f}, 
						 {0.9647372549019607f, 0.3390117647058823f, 0.24125490196078428f}, 
						 {0.9643607843137254f, 0.33753725490196074f, 0.24031372549019606f}, 
						 {0.9639843137254901f, 0.33606274509803913f, 0.2393725490196078f}, 
						 {0.9636078431372549f, 0.3345882352941176f, 0.23843137254901958f}, 
						 {0.9632313725490196f, 0.333113725490196f, 0.23749019607843133f}, 
						 {0.9628549019607843f, 0.33163921568627447f, 0.2365490196078431f}, 
						 {0.962478431372549f, 0.3301647058823529f, 0.23560784313725486f}, 
						 {0.9621019607843136f, 0.3286901960784313f, 0.23466666666666663f}, 
						 {0.9617254901960783f, 0.32721568627450975f, 0.23372549019607838f}, 
						 {0.9613490196078431f, 0.3257411764705882f, 0.23278431372549016f}, 
						 {0.9609725490196078f, 0.3242666666666666f, 0.2318431372549019f}, 
						 {0.9605960784313725f, 0.32279215686274504f, 0.2309019607843137f}, 
						 {0.9602196078431372f, 0.3213176470588235f, 0.22996078431372546f}, 
						 {0.9598431372549019f, 0.3198431372549019f, 0.2290196078431372f}, 
						 {0.9594666666666666f, 0.3183686274509803f, 0.22807843137254896f}, 
						 {0.9590901960784314f, 0.31689411764705877f, 0.22713725490196074f}, 
						 {0.9587137254901961f, 0.31541960784313716f, 0.22619607843137252f}, 
						 {0.9583372549019608f, 0.3139450980392156f, 0.22525490196078427f}, 
						 {0.9579607843137254f, 0.31247058823529406f, 0.22431372549019601f}, 
						 {0.9575843137254901f, 0.31099607843137245f, 0.2233725490196078f}, 
						 {0.9572078431372548f, 0.3095215686274509f, 0.22243137254901957f}, 
						 {0.9568313725490195f, 0.30804705882352934f, 0.22149019607843132f}, 
						 {0.9564549019607843f, 0.30657254901960773f, 0.22054901960784307f}, 
						 {0.956078431372549f, 0.3050980392156862f, 0.21960784313725484f}, 
						 {0.9557019607843137f, 0.3036235294117646f, 0.21866666666666662f}, 
						 {0.9553254901960784f, 0.30214901960784324f, 0.21772549019607848f}, 
						 {0.9549490196078432f, 0.30067450980392163f, 0.21678431372549023f}, 
						 {0.9545725490196079f, 0.2992000000000001f, 0.215843137254902f}, 
						 {0.9541960784313726f, 0.2977254901960785f, 0.21490196078431378f}, 
						 {0.9538196078431372f, 0.2962509803921569f, 0.21396078431372553f}, 
						 {0.9534431372549019f, 0.29477647058823536f, 0.21301960784313728f}, 
						 {0.9530666666666666f, 0.2933019607843138f, 0.21207843137254906f}, 
						 {0.9526901960784314f, 0.2918274509803922f, 0.21113725490196084f}, 
						 {0.9523137254901961f, 0.29035294117647065f, 0.21019607843137258f}, 
						 {0.9519372549019608f, 0.2888784313725491f, 0.20925490196078433f}, 
						 {0.9515607843137255f, 0.2874039215686275f, 0.2083137254901961f}, 
						 {0.9511843137254902f, 0.28592941176470593f, 0.2073725490196079f}, 
						 {0.9508078431372549f, 0.2844549019607844f, 0.20643137254901964f}, 
						 {0.9504313725490197f, 0.28298039215686277f, 0.2054901960784314f}, 
						 {0.9500549019607843f, 0.2815058823529413f, 0.20454901960784316f}, 
						 {0.949678431372549f, 0.28003137254901966f, 0.20360784313725494f}, 
						 {0.9493019607843137f, 0.27855686274509806f, 0.20266666666666672f}, 
						 {0.9489254901960784f, 0.27708235294117656f, 0.20172549019607847f}, 
						 {0.9485490196078431f, 0.27560784313725495f, 0.20078431372549022f}, 
						 {0.9481725490196078f, 0.2741333333333334f, 0.199843137254902f}, 
						 {0.9477960784313726f, 0.27265882352941184f, 0.19890196078431377f}, 
						 {0.9474196078431373f, 0.27118431372549023f, 0.19796078431372552f}, 
						 {0.947043137254902f, 0.2697098039215687f, 0.19701960784313727f}, 
						 {0.9466666666666667f, 0.2682352941176471f, 0.19607843137254904f}, 
						 {0.9462901960784313f, 0.2667607843137255f, 0.19513725490196082f}, 
						 {0.945913725490196f, 0.26528627450980397f, 0.19419607843137257f}, 
						 {0.9455372549019608f, 0.2638117647058824f, 0.19325490196078432f}, 
						 {0.9451607843137255f, 0.2623372549019608f, 0.1923137254901961f}, 
						 {0.9447843137254902f, 0.26086274509803925f, 0.19137254901960787f}, 
						 {0.9444078431372549f, 0.2593882352941177f, 0.19043137254901962f}, 
						 {0.9440313725490196f, 0.2579137254901961f, 0.18949019607843137f}, 
						 {0.9436549019607843f, 0.25643921568627454f, 0.18854901960784315f}, 
						 {0.9432784313725491f, 0.254964705882353f, 0.18760784313725493f}, 
						 {0.9429019607843138f, 0.2534901960784314f, 0.18666666666666668f}, 
						 {0.9425254901960785f, 0.2520156862745099f, 0.18572549019607842f}, 
						 {0.9421490196078431f, 0.25054117647058827f, 0.1847843137254902f}, 
						 {0.9417725490196078f, 0.2490666666666667f, 0.18384313725490198f}, 
						 {0.9413960784313725f, 0.24759215686274513f, 0.18290196078431376f}, 
						 {0.9410196078431372f, 0.24611764705882355f, 0.1819607843137255f}, 
						 {0.940643137254902f, 0.24464313725490197f, 0.18101960784313725f}, 
						 {0.9402666666666667f, 0.24316862745098042f, 0.18007843137254903f}, 
						 {0.9398901960784314f, 0.24169411764705884f, 0.1791372549019608f}, 
						 {0.9395137254901961f, 0.24021960784313728f, 0.17819607843137256f}, 
						 {0.9391372549019608f, 0.2387450980392157f, 0.1772549019607843f}, 
						 {0.9387607843137254f, 0.23727058823529412f, 0.17631372549019608f}, 
						 {0.9383843137254901f, 0.23579607843137257f, 0.17537254901960786f}, 
						 {0.9380078431372549f, 0.234321568627451f, 0.1744313725490196f}, 
						 {0.9376313725490196f, 0.23284705882352943f, 0.17349019607843136f}, 
						 {0.9372549019607843f, 0.23137254901960785f, 0.17254901960784313f}, 
						 {0.9361254901960784f, 0.23027450980392158f, 0.17207843137254902f}, 
						 {0.9349960784313726f, 0.22917647058823531f, 0.1716078431372549f}, 
						 {0.9338666666666666f, 0.22807843137254902f, 0.17113725490196077f}, 
						 {0.9327372549019608f, 0.22698039215686275f, 0.17066666666666666f}, 
						 {0.9316078431372549f, 0.22588235294117648f, 0.17019607843137255f}, 
						 {0.930478431372549f, 0.2247843137254902f, 0.16972549019607844f}, 
						 {0.9293490196078431f, 0.2236862745098039f, 0.1692549019607843f}, 
						 {0.9282196078431373f, 0.22258823529411764f, 0.1687843137254902f}, 
						 {0.9270901960784314f, 0.22149019607843137f, 0.16831372549019608f}, 
						 {0.9259607843137255f, 0.2203921568627451f, 0.16784313725490196f}, 
						 {0.9248313725490196f, 0.21929411764705883f, 0.16737254901960782f}, 
						 {0.9237019607843137f, 0.21819607843137254f, 0.1669019607843137f}, 
						 {0.9225725490196078f, 0.21709803921568627f, 0.1664313725490196f}, 
						 {0.9214431372549019f, 0.216f, 0.1659607843137255f}, 
						 {0.9203137254901961f, 0.21490196078431373f, 0.16549019607843135f}, 
						 {0.9191843137254901f, 0.21380392156862743f, 0.16501960784313724f}, 
						 {0.9180549019607843f, 0.21270588235294116f, 0.16454901960784313f}, 
						 {0.9169254901960784f, 0.2116078431372549f, 0.16407843137254902f}, 
						 {0.9157960784313726f, 0.21050980392156862f, 0.1636078431372549f}, 
						 {0.9146666666666666f, 0.20941176470588235f, 0.16313725490196077f}, 
						 {0.9135372549019608f, 0.20831372549019606f, 0.16266666666666665f}, 
						 {0.9124078431372549f, 0.20721568627450979f, 0.16219607843137254f}, 
						 {0.9112784313725489f, 0.20611764705882352f, 0.16172549019607843f}, 
						 {0.9101490196078431f, 0.20501960784313725f, 0.1612549019607843f}, 
						 {0.9090196078431372f, 0.20392156862745098f, 0.16078431372549018f}, 
						 {0.9078901960784314f, 0.20282352941176468f, 0.16031372549019607f}, 
						 {0.9067607843137254f, 0.2017254901960784f, 0.15984313725490196f}, 
						 {0.9056313725490196f, 0.20062745098039214f, 0.15937254901960782f}, 
						 {0.9045019607843137f, 0.19952941176470587f, 0.1589019607843137f}, 
						 {0.9033725490196078f, 0.1984313725490196f, 0.1584313725490196f}, 
						 {0.9022431372549019f, 0.1973333333333333f, 0.15796078431372548f}, 
						 {0.9011137254901961f, 0.19623529411764704f, 0.15749019607843134f}, 
						 {0.8999843137254901f, 0.19513725490196077f, 0.15701960784313723f}, 
						 {0.8988549019607843f, 0.19403921568627447f, 0.15654901960784312f}, 
						 {0.8977254901960784f, 0.1929411764705882f, 0.156078431372549f}, 
						 {0.8965960784313725f, 0.19184313725490193f, 0.1556078431372549f}, 
						 {0.8954666666666666f, 0.19074509803921566f, 0.15513725490196076f}, 
						 {0.8943372549019607f, 0.1896470588235294f, 0.15466666666666665f}, 
						 {0.8932078431372549f, 0.1885490196078431f, 0.15419607843137254f}, 
						 {0.8920784313725489f, 0.18745098039215682f, 0.15372549019607842f}, 
						 {0.8909490196078431f, 0.18635294117647055f, 0.15325490196078428f}, 
						 {0.8898196078431372f, 0.18525490196078429f, 0.15278431372549017f}, 
						 {0.8886901960784314f, 0.18415686274509802f, 0.15231372549019606f}, 
						 {0.8875607843137254f, 0.18305882352941172f, 0.15184313725490195f}, 
						 {0.8864313725490196f, 0.18196078431372545f, 0.1513725490196078f}, 
						 {0.8853019607843137f, 0.18086274509803918f, 0.1509019607843137f}, 
						 {0.8841725490196077f, 0.1797647058823529f, 0.1504313725490196f}, 
						 {0.8830431372549019f, 0.17866666666666664f, 0.14996078431372548f}, 
						 {0.881913725490196f, 0.17756862745098034f, 0.14949019607843134f}, 
						 {0.8807843137254902f, 0.17647058823529407f, 0.14901960784313723f}, 
						 {0.8796549019607842f, 0.1753725490196078f, 0.1485490196078431f}, 
						 {0.8785254901960784f, 0.1742745098039215f, 0.148078431372549f}, 
						 {0.8773960784313725f, 0.17317647058823527f, 0.1476078431372549f}, 
						 {0.8762666666666666f, 0.17207843137254897f, 0.14713725490196075f}, 
						 {0.8751372549019607f, 0.1709803921568627f, 0.14666666666666664f}, 
						 {0.8740078431372549f, 0.16988235294117643f, 0.14619607843137253f}, 
						 {0.872878431372549f, 0.16878431372549013f, 0.14572549019607842f}, 
						 {0.871749019607843f, 0.1676862745098039f, 0.14525490196078428f}, 
						 {0.8706196078431372f, 0.1665882352941176f, 0.14478431372549017f}, 
						 {0.8694901960784313f, 0.16549019607843132f, 0.14431372549019605f}, 
						 {0.8683607843137254f, 0.16439215686274505f, 0.14384313725490194f}, 
						 {0.8672313725490195f, 0.16329411764705876f, 0.1433725490196078f}, 
						 {0.8661019607843137f, 0.1621960784313725f, 0.1429019607843137f}, 
						 {0.8649725490196077f, 0.16109803921568622f, 0.14243137254901958f}, 
						 {0.8638431372549019f, 0.15999999999999995f, 0.14196078431372547f}, 
						 {0.862713725490196f, 0.15890196078431368f, 0.14149019607843133f}, 
						 {0.8615843137254902f, 0.15780392156862738f, 0.14101960784313722f}, 
						 {0.8604549019607842f, 0.1567058823529411f, 0.1405490196078431f}, 
						 {0.8593254901960783f, 0.15560784313725484f, 0.140078431372549f}, 
						 {0.8581960784313725f, 0.15450980392156854f, 0.13960784313725488f}, 
						 {0.8570666666666665f, 0.1534117647058823f, 0.13913725490196074f}, 
						 {0.8559372549019607f, 0.152313725490196f, 0.13866666666666663f}, 
						 {0.8548078431372548f, 0.15121568627450974f, 0.13819607843137252f}, 
						 {0.853678431372549f, 0.15011764705882347f, 0.13772549019607838f}, 
						 {0.852549019607843f, 0.14901960784313717f, 0.13725490196078427f}, 
						 {0.8514196078431372f, 0.14792156862745093f, 0.13678431372549016f}, 
						 {0.8502901960784313f, 0.14682352941176463f, 0.13631372549019605f}, 
						 {0.8491607843137254f, 0.14572549019607836f, 0.13584313725490194f}, 
						 {0.8480313725490196f, 0.1446274509803922f, 0.13537254901960785f}, 
						 {0.8469019607843138f, 0.14352941176470593f, 0.13490196078431374f}, 
						 {0.8457725490196079f, 0.14243137254901966f, 0.13443137254901963f}, 
						 {0.8446431372549019f, 0.14133333333333337f, 0.1339607843137255f}, 
						 {0.8435137254901961f, 0.1402352941176471f, 0.13349019607843138f}, 
						 {0.8423843137254902f, 0.13913725490196083f, 0.13301960784313727f}, 
						 {0.8412549019607843f, 0.13803921568627456f, 0.13254901960784315f}, 
						 {0.8401254901960784f, 0.1369411764705883f, 0.13207843137254904f}, 
						 {0.8389960784313726f, 0.135843137254902f, 0.13160784313725493f}, 
						 {0.8378666666666666f, 0.13474509803921572f, 0.1311372549019608f}, 
						 {0.8367372549019608f, 0.13364705882352945f, 0.13066666666666668f}, 
						 {0.8356078431372549f, 0.13254901960784315f, 0.13019607843137257f}, 
						 {0.8344784313725491f, 0.1314509803921569f, 0.12972549019607843f}, 
						 {0.8333490196078431f, 0.13035294117647062f, 0.12925490196078432f}, 
						 {0.8322196078431372f, 0.12925490196078435f, 0.1287843137254902f}, 
						 {0.8310901960784314f, 0.12815686274509808f, 0.1283137254901961f}, 
						 {0.8299607843137254f, 0.12705882352941178f, 0.12784313725490198f}, 
						 {0.8288313725490196f, 0.12596078431372554f, 0.12737254901960784f}, 
						 {0.8277019607843137f, 0.12486274509803924f, 0.12690196078431373f}, 
						 {0.8265725490196079f, 0.12376470588235297f, 0.12643137254901962f}, 
						 {0.8254431372549019f, 0.12266666666666669f, 0.12596078431372548f}, 
						 {0.8243137254901961f, 0.12156862745098042f, 0.12549019607843137f}, 
						 {0.8231843137254902f, 0.12047058823529415f, 0.12501960784313726f}, 
						 {0.8220549019607843f, 0.11937254901960787f, 0.12454901960784315f}, 
						 {0.8209254901960784f, 0.1182745098039216f, 0.12407843137254904f}, 
						 {0.8197960784313725f, 0.11717647058823531f, 0.12360784313725491f}, 
						 {0.8186666666666667f, 0.11607843137254904f, 0.12313725490196079f}, 
						 {0.8175372549019607f, 0.11498039215686276f, 0.12266666666666667f}, 
						 {0.8164078431372549f, 0.11388235294117649f, 0.12219607843137256f}, 
						 {0.815278431372549f, 0.1127843137254902f, 0.12172549019607844f}, 
						 {0.8141490196078431f, 0.11168627450980394f, 0.12125490196078431f}, 
						 {0.8130196078431372f, 0.11058823529411767f, 0.1207843137254902f}, 
						 {0.8118901960784314f, 0.10949019607843138f, 0.12031372549019609f}, 
						 {0.8107607843137254f, 0.10839215686274511f, 0.11984313725490196f}, 
						 {0.8096313725490196f, 0.10729411764705883f, 0.11937254901960784f}, 
						 {0.8085019607843137f, 0.10619607843137255f, 0.11890196078431373f}, 
						 {0.8073725490196078f, 0.10509803921568628f, 0.11843137254901961f}, 
						 {0.8062431372549019f, 0.10400000000000001f, 0.11796078431372549f}, 
						 {0.805113725490196f, 0.10290196078431374f, 0.11749019607843138f}, 
						 {0.8039843137254902f, 0.10180392156862747f, 0.11701960784313725f}, 
						 {0.8028549019607842f, 0.10070588235294117f, 0.11654901960784314f}, 
						 {0.8017254901960784f, 0.0996078431372549f, 0.11607843137254903f}, 
						 {0.8005960784313725f, 0.09850980392156863f, 0.1156078431372549f}, 
						 {0.7994666666666667f, 0.09741176470588236f, 0.11513725490196078f}, 
						 {0.7983372549019607f, 0.09631372549019607f, 0.11466666666666667f}, 
						 {0.7972078431372549f, 0.0952156862745098f, 0.11419607843137256f}, 
						 {0.796078431372549f, 0.09411764705882353f, 0.11372549019607843f}, 
						 {0.7948862745098039f, 0.09383529411764706f, 0.11347450980392157f}, 
						 {0.7936941176470588f, 0.09355294117647059f, 0.11322352941176471f}, 
						 {0.7925019607843137f, 0.09327058823529412f, 0.11297254901960783f}, 
						 {0.7913098039215686f, 0.09298823529411765f, 0.11272156862745097f}, 
						 {0.7901176470588235f, 0.09270588235294118f, 0.11247058823529411f}, 
						 {0.7889254901960784f, 0.09242352941176471f, 0.11221960784313725f}, 
						 {0.7877333333333333f, 0.09214117647058823f, 0.11196862745098039f}, 
						 {0.7865411764705882f, 0.09185882352941176f, 0.11171764705882353f}, 
						 {0.7853490196078431f, 0.09157647058823529f, 0.11146666666666666f}, 
						 {0.784156862745098f, 0.09129411764705882f, 0.1112156862745098f}, 
						 {0.7829647058823529f, 0.09101176470588235f, 0.11096470588235294f}, 
						 {0.7817725490196078f, 0.09072941176470588f, 0.11071372549019608f}, 
						 {0.7805803921568627f, 0.09044705882352941f, 0.11046274509803922f}, 
						 {0.7793882352941176f, 0.09016470588235294f, 0.11021176470588234f}, 
						 {0.7781960784313725f, 0.08988235294117647f, 0.10996078431372548f}, 
						 {0.7770039215686274f, 0.0896f, 0.10970980392156862f}, 
						 {0.7758117647058823f, 0.08931764705882353f, 0.10945882352941176f}, 
						 {0.7746196078431372f, 0.08903529411764705f, 0.1092078431372549f}, 
						 {0.7734274509803921f, 0.08875294117647058f, 0.10895686274509803f}, 
						 {0.772235294117647f, 0.0884705882352941f, 0.10870588235294117f}, 
						 {0.7710431372549019f, 0.08818823529411764f, 0.1084549019607843f}, 
						 {0.7698509803921568f, 0.08790588235294117f, 0.10820392156862745f}, 
						 {0.7686588235294117f, 0.0876235294117647f, 0.10795294117647058f}, 
						 {0.7674666666666666f, 0.08734117647058823f, 0.10770196078431372f}, 
						 {0.7662745098039215f, 0.08705882352941176f, 0.10745098039215685f}, 
						 {0.7650823529411764f, 0.08677647058823529f, 0.10719999999999999f}, 
						 {0.7638901960784313f, 0.08649411764705882f, 0.10694901960784313f}, 
						 {0.7626980392156862f, 0.08621176470588235f, 0.10669803921568627f}, 
						 {0.7615058823529411f, 0.08592941176470588f, 0.10644705882352941f}, 
						 {0.760313725490196f, 0.08564705882352941f, 0.10619607843137255f}, 
						 {0.759121568627451f, 0.08536470588235293f, 0.10594509803921567f}, 
						 {0.7579294117647059f, 0.08508235294117646f, 0.10569411764705881f}, 
						 {0.7567372549019608f, 0.08479999999999999f, 0.10544313725490195f}, 
						 {0.7555450980392157f, 0.08451764705882352f, 0.10519215686274509f}, 
						 {0.7543529411764706f, 0.08423529411764705f, 0.10494117647058823f}, 
						 {0.7531607843137255f, 0.08395294117647058f, 0.10469019607843136f}, 
						 {0.7519686274509804f, 0.08367058823529411f, 0.1044392156862745f}, 
						 {0.7507764705882353f, 0.08338823529411764f, 0.10418823529411764f}, 
						 {0.7495843137254902f, 0.08310588235294117f, 0.10393725490196078f}, 
						 {0.7483921568627451f, 0.0828235294117647f, 0.10368627450980392f}, 
						 {0.7472f, 0.08254117647058823f, 0.10343529411764704f}, 
						 {0.7460078431372549f, 0.08225882352941175f, 0.10318431372549018f}, 
						 {0.7448156862745098f, 0.08197647058823529f, 0.10293333333333332f}, 
						 {0.7436235294117647f, 0.0816941176470588f, 0.10268235294117646f}, 
						 {0.7424313725490196f, 0.08141176470588234f, 0.1024313725490196f}, 
						 {0.7412392156862745f, 0.08112941176470587f, 0.10218039215686273f}, 
						 {0.7400470588235294f, 0.0808470588235294f, 0.10192941176470587f}, 
						 {0.7388549019607843f, 0.08056470588235293f, 0.101678431372549f}, 
						 {0.7376627450980392f, 0.08028235294117646f, 0.10142745098039214f}, 
						 {0.736470588235294f, 0.07999999999999999f, 0.10117647058823528f}, 
						 {0.7352784313725489f, 0.07971764705882352f, 0.10092549019607842f}, 
						 {0.7340862745098038f, 0.07943529411764705f, 0.10067450980392155f}, 
						 {0.7328941176470587f, 0.07915294117647058f, 0.10042352941176469f}, 
						 {0.7317019607843136f, 0.07887058823529411f, 0.10017254901960783f}, 
						 {0.7305098039215685f, 0.07858823529411763f, 0.09992156862745097f}, 
						 {0.7293176470588234f, 0.07830588235294117f, 0.09967058823529411f}, 
						 {0.7281254901960783f, 0.07802352941176469f, 0.09941960784313725f}, 
						 {0.7269333333333332f, 0.07774117647058822f, 0.09916862745098037f}, 
						 {0.7257411764705881f, 0.07745882352941175f, 0.09891764705882351f}, 
						 {0.724549019607843f, 0.07717647058823528f, 0.09866666666666665f}, 
						 {0.7233568627450979f, 0.07689411764705881f, 0.09841568627450979f}, 
						 {0.7221647058823528f, 0.07661176470588234f, 0.09816470588235293f}, 
						 {0.7209725490196077f, 0.07632941176470587f, 0.09791372549019606f}, 
						 {0.7197803921568626f, 0.0760470588235294f, 0.0976627450980392f}, 
						 {0.7185882352941175f, 0.07576470588235293f, 0.09741176470588234f}, 
						 {0.7173960784313724f, 0.07548235294117644f, 0.09716078431372548f}, 
						 {0.7162039215686273f, 0.07519999999999999f, 0.09690980392156862f}, 
						 {0.7150117647058822f, 0.0749176470588235f, 0.09665882352941174f}, 
						 {0.7138196078431371f, 0.07463529411764704f, 0.09640784313725488f}, 
						 {0.712627450980392f, 0.07435294117647057f, 0.09615686274509802f}, 
						 {0.7114352941176469f, 0.0740705882352941f, 0.09590588235294116f}, 
						 {0.7102431372549018f, 0.07378823529411763f, 0.0956549019607843f}, 
						 {0.7090509803921567f, 0.07350588235294116f, 0.09540392156862743f}, 
						 {0.7078588235294117f, 0.07322352941176469f, 0.09515294117647058f}, 
						 {0.7066666666666666f, 0.07294117647058822f, 0.0949019607843137f}, 
						 {0.7054745098039215f, 0.07265882352941175f, 0.09465098039215684f}, 
						 {0.7042823529411764f, 0.07237647058823528f, 0.09439999999999998f}, 
						 {0.7030901960784313f, 0.07209411764705881f, 0.09414901960784312f}, 
						 {0.7018980392156862f, 0.07181176470588232f, 0.09389803921568626f}, 
						 {0.7007058823529411f, 0.07152941176470587f, 0.09364705882352939f}, 
						 {0.699513725490196f, 0.07124705882352939f, 0.09339607843137253f}, 
						 {0.6983215686274509f, 0.07096470588235292f, 0.09314509803921567f}, 
						 {0.6971294117647059f, 0.07068235294117647f, 0.09289411764705884f}, 
						 {0.6959372549019608f, 0.0704f, 0.09264313725490197f}, 
						 {0.6947450980392157f, 0.07011764705882353f, 0.0923921568627451f}, 
						 {0.6935529411764706f, 0.06983529411764706f, 0.09214117647058824f}, 
						 {0.6923607843137255f, 0.0695529411764706f, 0.09189019607843138f}, 
						 {0.6911686274509804f, 0.06927058823529413f, 0.09163921568627452f}, 
						 {0.6899764705882353f, 0.06898823529411766f, 0.09138823529411766f}, 
						 {0.6887843137254902f, 0.06870588235294119f, 0.09113725490196078f}, 
						 {0.6875921568627451f, 0.06842352941176472f, 0.09088627450980392f}, 
						 {0.6864f, 0.06814117647058825f, 0.09063529411764706f}, 
						 {0.6852078431372549f, 0.06785882352941178f, 0.0903843137254902f}, 
						 {0.6840156862745098f, 0.0675764705882353f, 0.09013333333333334f}, 
						 {0.6828235294117647f, 0.06729411764705884f, 0.08988235294117647f}, 
						 {0.6816313725490196f, 0.06701176470588235f, 0.08963137254901961f}, 
						 {0.6804392156862745f, 0.06672941176470588f, 0.08938039215686275f}, 
						 {0.6792470588235294f, 0.06644705882352941f, 0.08912941176470589f}, 
						 {0.6780549019607843f, 0.06616470588235294f, 0.08887843137254903f}, 
						 {0.6768627450980392f, 0.06588235294117648f, 0.08862745098039215f}, 
						 {0.6756705882352941f, 0.0656f, 0.0883764705882353f}, 
						 {0.674478431372549f, 0.06531764705882354f, 0.08812549019607843f}, 
						 {0.6732862745098039f, 0.06503529411764707f, 0.08787450980392157f}, 
						 {0.6720941176470588f, 0.0647529411764706f, 0.08762352941176471f}, 
						 {0.6709019607843137f, 0.06447058823529413f, 0.08737254901960785f}, 
						 {0.6697098039215686f, 0.06418823529411766f, 0.08712156862745099f}, 
						 {0.6685176470588235f, 0.06390588235294117f, 0.08687058823529412f}, 
						 {0.6673254901960785f, 0.06362352941176472f, 0.08661960784313726f}, 
						 {0.6661333333333334f, 0.06334117647058823f, 0.0863686274509804f}, 
						 {0.6649411764705883f, 0.06305882352941176f, 0.08611764705882353f}, 
						 {0.6637490196078432f, 0.0627764705882353f, 0.08586666666666667f}, 
						 {0.6625568627450981f, 0.062494117647058825f, 0.0856156862745098f}, 
						 {0.661364705882353f, 0.062211764705882355f, 0.08536470588235294f}, 
						 {0.6601725490196079f, 0.061929411764705886f, 0.08511372549019608f}, 
						 {0.6589803921568628f, 0.061647058823529416f, 0.08486274509803922f}, 
						 {0.6577882352941177f, 0.06136470588235294f, 0.08461176470588236f}, 
						 {0.6565960784313726f, 0.06108235294117647f, 0.08436078431372548f}, 
						 {0.6554039215686275f, 0.0608f, 0.08410980392156862f}, 
						 {0.6542117647058824f, 0.06051764705882353f, 0.08385882352941176f}, 
						 {0.6530196078431373f, 0.06023529411764706f, 0.0836078431372549f}, 
						 {0.6518274509803922f, 0.05995294117647059f, 0.08335686274509804f}, 
						 {0.6506352941176471f, 0.059670588235294114f, 0.08310588235294117f}, 
						 {0.649443137254902f, 0.059388235294117644f, 0.08285490196078431f}, 
						 {0.6482509803921569f, 0.059105882352941175f, 0.08260392156862745f}, 
						 {0.6470588235294118f, 0.058823529411764705f, 0.08235294117647059f}, 
						 {0.6451137254901961f, 0.05835294117647059f, 0.08210196078431373f}, 
						 {0.6431686274509805f, 0.05788235294117647f, 0.08185098039215687f}, 
						 {0.6412235294117647f, 0.05741176470588235f, 0.08159999999999999f}, 
						 {0.639278431372549f, 0.05694117647058823f, 0.08134901960784313f}, 
						 {0.6373333333333333f, 0.05647058823529411f, 0.08109803921568627f}, 
						 {0.6353882352941177f, 0.055999999999999994f, 0.08084705882352941f}, 
						 {0.633443137254902f, 0.055529411764705876f, 0.08059607843137255f}, 
						 {0.6314980392156863f, 0.05505882352941176f, 0.08034509803921569f}, 
						 {0.6295529411764706f, 0.054588235294117646f, 0.08009411764705882f}, 
						 {0.6276078431372549f, 0.05411764705882353f, 0.07984313725490196f}, 
						 {0.6256627450980392f, 0.05364705882352941f, 0.0795921568627451f}, 
						 {0.6237176470588235f, 0.05317647058823529f, 0.07934117647058823f}, 
						 {0.6217725490196079f, 0.05270588235294117f, 0.07909019607843137f}, 
						 {0.6198274509803922f, 0.05223529411764705f, 0.0788392156862745f}, 
						 {0.6178823529411764f, 0.051764705882352935f, 0.07858823529411764f}, 
						 {0.6159372549019608f, 0.051294117647058816f, 0.07833725490196078f}, 
						 {0.6139921568627451f, 0.0508235294117647f, 0.07808627450980392f}, 
						 {0.6120470588235294f, 0.05035294117647058f, 0.07783529411764706f}, 
						 {0.6101019607843137f, 0.04988235294117646f, 0.07758431372549018f}, 
						 {0.6081568627450981f, 0.04941176470588234f, 0.07733333333333332f}, 
						 {0.6062117647058823f, 0.048941176470588224f, 0.07708235294117646f}, 
						 {0.6042666666666666f, 0.048470588235294106f, 0.0768313725490196f}, 
						 {0.602321568627451f, 0.04799999999999999f, 0.07658039215686274f}, 
						 {0.6003764705882353f, 0.047529411764705876f, 0.07632941176470588f}, 
						 {0.5984313725490196f, 0.04705882352941175f, 0.07607843137254901f}, 
						 {0.5964862745098038f, 0.04658823529411764f, 0.07582745098039215f}, 
						 {0.5945411764705882f, 0.04611764705882351f, 0.07557647058823529f}, 
						 {0.5925960784313725f, 0.0456470588235294f, 0.07532549019607843f}, 
						 {0.5906509803921568f, 0.04517647058823528f, 0.07507450980392157f}, 
						 {0.5887058823529412f, 0.044705882352941165f, 0.0748235294117647f}, 
						 {0.5867607843137255f, 0.044235294117647046f, 0.07457254901960783f}, 
						 {0.5848156862745097f, 0.04376470588235293f, 0.07432156862745097f}, 
						 {0.582870588235294f, 0.04329411764705881f, 0.07407058823529411f}, 
						 {0.5809254901960784f, 0.04282352941176469f, 0.07381960784313725f}, 
						 {0.5789803921568627f, 0.04235294117647057f, 0.07356862745098039f}, 
						 {0.577035294117647f, 0.041882352941176454f, 0.07331764705882352f}, 
						 {0.5750901960784314f, 0.041411764705882335f, 0.07306666666666665f}, 
						 {0.5731450980392157f, 0.04094117647058822f, 0.0728156862745098f}, 
						 {0.5711999999999999f, 0.040470588235294105f, 0.07256470588235293f}, 
						 {0.5692549019607842f, 0.03999999999999998f, 0.07231372549019607f}, 
						 {0.5673098039215686f, 0.03952941176470587f, 0.0720627450980392f}, 
						 {0.5653647058823529f, 0.03905882352941174f, 0.07181176470588234f}, 
						 {0.5634196078431372f, 0.03858823529411763f, 0.07156078431372548f}, 
						 {0.5614745098039216f, 0.038117647058823506f, 0.07130980392156862f}, 
						 {0.5595294117647058f, 0.037647058823529395f, 0.07105882352941176f}, 
						 {0.5575843137254901f, 0.03717647058823527f, 0.07080784313725488f}, 
						 {0.5556392156862744f, 0.03670588235294116f, 0.07055686274509802f}, 
						 {0.5536941176470588f, 0.03623529411764704f, 0.07030588235294116f}, 
						 {0.5517490196078431f, 0.03576470588235292f, 0.0700549019607843f}, 
						 {0.5498039215686273f, 0.0352941176470588f, 0.06980392156862744f}, 
						 {0.5478588235294117f, 0.034823529411764684f, 0.06955294117647058f}, 
						 {0.545913725490196f, 0.034352941176470565f, 0.06930196078431371f}, 
						 {0.5439686274509803f, 0.03388235294117645f, 0.06905098039215685f}, 
						 {0.5420235294117647f, 0.03341176470588233f, 0.06879999999999999f}, 
						 {0.540078431372549f, 0.03294117647058821f, 0.06854901960784313f}, 
						 {0.5381333333333332f, 0.0324705882352941f, 0.06829803921568627f}, 
						 {0.5361882352941176f, 0.03199999999999997f, 0.0680470588235294f}, 
						 {0.5342431372549019f, 0.03152941176470586f, 0.06779607843137253f}, 
						 {0.5322980392156862f, 0.03105882352941174f, 0.06754509803921567f}, 
						 {0.5303529411764705f, 0.03058823529411762f, 0.06729411764705881f}, 
						 {0.5284078431372549f, 0.030117647058823502f, 0.06704313725490195f}, 
						 {0.5264627450980391f, 0.029647058823529384f, 0.06679215686274509f}, 
						 {0.5245176470588234f, 0.02917647058823527f, 0.06654117647058821f}, 
						 {0.5225725490196078f, 0.02870588235294115f, 0.06629019607843135f}, 
						 {0.5206274509803921f, 0.028235294117647032f, 0.0660392156862745f}, 
						 {0.5186823529411764f, 0.027764705882352914f, 0.06578823529411763f}, 
						 {0.5167372549019607f, 0.027294117647058795f, 0.06553725490196077f}, 
						 {0.5147921568627449f, 0.026823529411764677f, 0.0652862745098039f}, 
						 {0.5128470588235293f, 0.026352941176470558f, 0.06503529411764704f}, 
						 {0.5109019607843136f, 0.02588235294117644f, 0.06478431372549018f}, 
						 {0.508956862745098f, 0.02541176470588232f, 0.06453333333333332f}, 
						 {0.5070117647058823f, 0.024941176470588203f, 0.06428235294117646f}, 
						 {0.5050666666666666f, 0.024470588235294084f, 0.06403137254901958f}, 
						 {0.5031215686274508f, 0.023999999999999966f, 0.06378039215686274f}, 
						 {0.5011764705882352f, 0.023529411764705847f, 0.06352941176470586f}, 
						 {0.4992313725490195f, 0.023058823529411736f, 0.063278431372549f}, 
						 {0.4972862745098038f, 0.022588235294117617f, 0.06302745098039214f}, 
						 {0.4953411764705881f, 0.0221176470588235f, 0.06277647058823528f}, 
						 {0.49339607843137245f, 0.02164705882352938f, 0.06252549019607842f}, 
						 {0.49145098039215673f, 0.021176470588235262f, 0.062274509803921546f}, 
						 {0.489505882352941f, 0.020705882352941143f, 0.062023529411764686f}, 
						 {0.4875607843137254f, 0.020235294117647025f, 0.061772549019607825f}, 
						 {0.4856156862745097f, 0.019764705882352906f, 0.061521568627450965f}, 
						 {0.48367058823529396f, 0.019294117647058788f, 0.0612705882352941f}, 
						 {0.4817254901960785f, 0.018823529411764725f, 0.06101960784313726f}, 
						 {0.47978039215686286f, 0.018352941176470607f, 0.0607686274509804f}, 
						 {0.47783529411764714f, 0.017882352941176488f, 0.06051764705882354f}, 
						 {0.4758901960784314f, 0.01741176470588237f, 0.06026666666666668f}, 
						 {0.47394509803921575f, 0.01694117647058825f, 0.060015686274509816f}, 
						 {0.4720000000000001f, 0.016470588235294133f, 0.05976470588235295f}, 
						 {0.47005490196078437f, 0.016000000000000014f, 0.05951372549019608f}, 
						 {0.4681098039215687f, 0.015529411764705896f, 0.05926274509803922f}, 
						 {0.46616470588235304f, 0.015058823529411777f, 0.05901176470588236f}, 
						 {0.4642196078431373f, 0.014588235294117659f, 0.0587607843137255f}, 
						 {0.4622745098039216f, 0.01411764705882354f, 0.05850980392156863f}, 
						 {0.460329411764706f, 0.013647058823529422f, 0.058258823529411766f}, 
						 {0.45838431372549027f, 0.013176470588235303f, 0.058007843137254905f}, 
						 {0.45643921568627455f, 0.012705882352941185f, 0.057756862745098045f}, 
						 {0.4544941176470589f, 0.012235294117647066f, 0.057505882352941184f}, 
						 {0.4525490196078432f, 0.011764705882352955f, 0.05725490196078432f}, 
						 {0.4506039215686275f, 0.011294117647058836f, 0.05700392156862746f}, 
						 {0.4486588235294118f, 0.010823529411764718f, 0.05675294117647059f}, 
						 {0.44671372549019617f, 0.0103529411764706f, 0.05650196078431373f}, 
						 {0.44476862745098045f, 0.009882352941176481f, 0.05625098039215687f}, 
						 {0.4428235294117647f, 0.009411764705882363f, 0.05600000000000001f}, 
						 {0.44087843137254906f, 0.008941176470588244f, 0.05574901960784314f}, 
						 {0.4389333333333334f, 0.008470588235294126f, 0.05549803921568627f}, 
						 {0.4369882352941177f, 0.008000000000000007f, 0.05524705882352941f}, 
						 {0.435043137254902f, 0.007529411764705889f, 0.05499607843137255f}, 
						 {0.43309803921568635f, 0.00705882352941177f, 0.05474509803921569f}, 
						 {0.4311529411764706f, 0.006588235294117652f, 0.054494117647058825f}, 
						 {0.4292078431372549f, 0.006117647058823533f, 0.054243137254901964f}, 
						 {0.42726274509803924f, 0.005647058823529415f, 0.0539921568627451f}, 
						 {0.4253176470588236f, 0.005176470588235296f, 0.05374117647058824f}, 
						 {0.42337254901960786f, 0.004705882352941178f, 0.053490196078431376f}, 
						 {0.4214274509803922f, 0.004235294117647059f, 0.053239215686274516f}, 
						 {0.41948235294117653f, 0.003764705882352948f, 0.05298823529411765f}, 
						 {0.4175372549019608f, 0.0032941176470588293f, 0.05273725490196078f}, 
						 {0.4155921568627451f, 0.002823529411764711f, 0.05248627450980392f}, 
						 {0.4136470588235294f, 0.0023529411764705924f, 0.05223529411764706f}, 
						 {0.41170196078431376f, 0.001882352941176474f, 0.0519843137254902f}, 
						 {0.40975686274509804f, 0.0014117647058823554f, 0.05173333333333333f}, 
						 {0.4078117647058824f, 0.000941176470588237f, 0.051482352941176465f}, 
						 {0.4058666666666667f, 0.0004705882352941185f, 0.051231372549019605f}, 
						 {0.403921568627451f, 0.f, 0.050980392156862744f}};

/*(Table[Blend[
  Map[(RGBColor @@ # &), ({{255, 245, 240}, {254, 224, 210}, {252, 
  187, 161}, {252, 146, 114}, {251, 106, 74}}/255), {1}], 
  x/1000], {x, 0, 1000, 1.}] /. RGBColor -> List) >> /tmp/1
*/
float palette_sequential_singlehue_red_lighter[1001][3]={{1.f, 0.9607843137254902f, 0.9411764705882353f}, 
							 {0.9999843137254902f, 0.9604549019607843f, 0.9407058823529412f}, 
							 {0.9999686274509804f, 0.9601254901960785f, 0.9402352941176471f}, 
							 {0.9999529411764706f, 0.9597960784313726f, 0.939764705882353f}, 
							 {0.9999372549019608f, 0.9594666666666667f, 0.9392941176470588f}, 
							 {0.999921568627451f, 0.9591372549019608f, 0.9388235294117647f}, 
							 {0.9999058823529412f, 0.958807843137255f, 0.9383529411764706f}, 
							 {0.9998901960784313f, 0.9584784313725491f, 0.9378823529411765f}, 
							 {0.9998745098039216f, 0.9581490196078432f, 0.9374117647058824f}, 
							 {0.9998588235294118f, 0.9578196078431372f, 0.9369411764705882f}, 
							 {0.9998431372549019f, 0.9574901960784314f, 0.936470588235294f}, 
							 {0.9998274509803922f, 0.9571607843137255f, 0.9359999999999999f}, 
							 {0.9998117647058824f, 0.9568313725490196f, 0.9355294117647058f}, 
							 {0.9997960784313725f, 0.9565019607843137f, 0.9350588235294117f}, 
							 {0.9997803921568628f, 0.9561725490196079f, 0.9345882352941176f}, 
							 {0.9997647058823529f, 0.955843137254902f, 0.9341176470588235f}, 
							 {0.9997490196078431f, 0.9555137254901961f, 0.9336470588235294f}, 
							 {0.9997333333333334f, 0.9551843137254902f, 0.9331764705882353f}, 
							 {0.9997176470588235f, 0.9548549019607844f, 0.9327058823529412f}, 
							 {0.9997019607843137f, 0.9545254901960785f, 0.932235294117647f}, 
							 {0.999686274509804f, 0.9541960784313726f, 0.9317647058823529f}, 
							 {0.9996705882352941f, 0.9538666666666666f, 0.9312941176470588f}, 
							 {0.9996549019607843f, 0.9535372549019608f, 0.9308235294117647f}, 
							 {0.9996392156862746f, 0.9532078431372549f, 0.9303529411764706f}, 
							 {0.9996235294117647f, 0.952878431372549f, 0.9298823529411765f}, 
							 {0.9996078431372549f, 0.9525490196078432f, 0.9294117647058824f}, 
							 {0.999592156862745f, 0.9522196078431373f, 0.9289411764705883f}, 
							 {0.9995764705882353f, 0.9518901960784314f, 0.928470588235294f}, 
							 {0.9995607843137255f, 0.9515607843137255f, 0.9279999999999999f}, 
							 {0.9995450980392157f, 0.9512313725490197f, 0.9275294117647058f}, 
							 {0.9995294117647059f, 0.9509019607843138f, 0.9270588235294117f}, 
							 {0.9995137254901961f, 0.9505725490196079f, 0.9265882352941176f}, 
							 {0.9994980392156863f, 0.950243137254902f, 0.9261176470588235f}, 
							 {0.9994823529411765f, 0.9499137254901961f, 0.9256470588235294f}, 
							 {0.9994666666666666f, 0.9495843137254902f, 0.9251764705882353f}, 
							 {0.9994509803921569f, 0.9492549019607843f, 0.9247058823529412f}, 
							 {0.9994352941176471f, 0.9489254901960784f, 0.924235294117647f}, 
							 {0.9994196078431372f, 0.9485960784313726f, 0.9237647058823529f}, 
							 {0.9994039215686275f, 0.9482666666666667f, 0.9232941176470588f}, 
							 {0.9993882352941177f, 0.9479372549019608f, 0.9228235294117647f}, 
							 {0.9993725490196078f, 0.9476078431372549f, 0.9223529411764706f}, 
							 {0.999356862745098f, 0.9472784313725491f, 0.9218823529411765f}, 
							 {0.9993411764705883f, 0.9469490196078432f, 0.9214117647058824f}, 
							 {0.9993254901960784f, 0.9466196078431373f, 0.9209411764705883f}, 
							 {0.9993098039215687f, 0.9462901960784313f, 0.9204705882352942f}, 
							 {0.9992941176470588f, 0.9459607843137255f, 0.9199999999999999f}, 
							 {0.999278431372549f, 0.9456313725490196f, 0.9195294117647058f}, 
							 {0.9992627450980393f, 0.9453019607843137f, 0.9190588235294117f}, 
							 {0.9992470588235294f, 0.9449725490196078f, 0.9185882352941176f}, 
							 {0.9992313725490196f, 0.944643137254902f, 0.9181176470588235f}, 
							 {0.9992156862745099f, 0.9443137254901961f, 0.9176470588235294f}, 
							 {0.9992f, 0.9439843137254902f, 0.9171764705882353f}, 
							 {0.9991843137254902f, 0.9436549019607843f, 0.9167058823529411f}, 
							 {0.9991686274509803f, 0.9433254901960785f, 0.916235294117647f}, 
							 {0.9991529411764706f, 0.9429960784313726f, 0.9157647058823529f}, 
							 {0.9991372549019608f, 0.9426666666666667f, 0.9152941176470588f}, 
							 {0.9991215686274509f, 0.9423372549019609f, 0.9148235294117647f}, 
							 {0.9991058823529412f, 0.9420078431372549f, 0.9143529411764706f}, 
							 {0.9990901960784314f, 0.941678431372549f, 0.9138823529411765f}, 
							 {0.9990745098039215f, 0.9413490196078431f, 0.9134117647058824f}, 
							 {0.9990588235294118f, 0.9410196078431373f, 0.9129411764705883f}, 
							 {0.999043137254902f, 0.9406901960784314f, 0.9124705882352941f}, 
							 {0.9990274509803921f, 0.9403607843137255f, 0.912f}, 
							 {0.9990117647058824f, 0.9400313725490196f, 0.9115294117647058f}, 
							 {0.9989960784313725f, 0.9397019607843138f, 0.9110588235294117f}, 
							 {0.9989803921568627f, 0.9393725490196079f, 0.9105882352941176f}, 
							 {0.998964705882353f, 0.939043137254902f, 0.9101176470588235f}, 
							 {0.9989490196078431f, 0.938713725490196f, 0.9096470588235294f}, 
							 {0.9989333333333333f, 0.9383843137254902f, 0.9091764705882353f}, 
							 {0.9989176470588236f, 0.9380549019607843f, 0.9087058823529411f}, 
							 {0.9989019607843137f, 0.9377254901960784f, 0.908235294117647f}, 
							 {0.9988862745098039f, 0.9373960784313725f, 0.9077647058823529f}, 
							 {0.9988705882352942f, 0.9370666666666667f, 0.9072941176470588f}, 
							 {0.9988549019607843f, 0.9367372549019608f, 0.9068235294117647f}, 
							 {0.9988392156862745f, 0.9364078431372549f, 0.9063529411764706f}, 
							 {0.9988235294117647f, 0.936078431372549f, 0.9058823529411765f}, 
							 {0.9988078431372549f, 0.9357490196078432f, 0.9054117647058824f}, 
							 {0.9987921568627451f, 0.9354196078431373f, 0.9049411764705882f}, 
							 {0.9987764705882353f, 0.9350901960784314f, 0.9044705882352941f}, 
							 {0.9987607843137255f, 0.9347607843137256f, 0.904f}, 
							 {0.9987450980392157f, 0.9344313725490196f, 0.9035294117647059f}, 
							 {0.9987294117647059f, 0.9341019607843137f, 0.9030588235294117f}, 
							 {0.9987137254901961f, 0.9337725490196078f, 0.9025882352941176f}, 
							 {0.9986980392156862f, 0.933443137254902f, 0.9021176470588235f}, 
							 {0.9986823529411765f, 0.9331137254901961f, 0.9016470588235294f}, 
							 {0.9986666666666667f, 0.9327843137254902f, 0.9011764705882352f}, 
							 {0.9986509803921568f, 0.9324549019607843f, 0.9007058823529411f}, 
							 {0.9986352941176471f, 0.9321254901960785f, 0.900235294117647f}, 
							 {0.9986196078431373f, 0.9317960784313726f, 0.8997647058823529f}, 
							 {0.9986039215686274f, 0.9314666666666667f, 0.8992941176470588f}, 
							 {0.9985882352941177f, 0.9311372549019608f, 0.8988235294117647f}, 
							 {0.9985725490196079f, 0.930807843137255f, 0.8983529411764706f}, 
							 {0.998556862745098f, 0.930478431372549f, 0.8978823529411765f}, 
							 {0.9985411764705883f, 0.9301490196078431f, 0.8974117647058824f}, 
							 {0.9985254901960784f, 0.9298196078431372f, 0.8969411764705882f}, 
							 {0.9985098039215686f, 0.9294901960784314f, 0.8964705882352941f}, 
							 {0.9984941176470589f, 0.9291607843137255f, 0.896f}, 
							 {0.998478431372549f, 0.9288313725490196f, 0.8955294117647059f}, 
							 {0.9984627450980392f, 0.9285019607843137f, 0.8950588235294117f}, 
							 {0.9984470588235295f, 0.9281725490196079f, 0.8945882352941176f}, 
							 {0.9984313725490196f, 0.927843137254902f, 0.8941176470588235f}, 
							 {0.9984156862745098f, 0.9275137254901961f, 0.8936470588235293f}, 
							 {0.9984f, 0.9271843137254903f, 0.8931764705882352f}, 
							 {0.9983843137254902f, 0.9268549019607843f, 0.8927058823529411f}, 
							 {0.9983686274509804f, 0.9265254901960784f, 0.892235294117647f}, 
							 {0.9983529411764706f, 0.9261960784313725f, 0.8917647058823529f}, 
							 {0.9983372549019608f, 0.9258666666666667f, 0.8912941176470588f}, 
							 {0.998321568627451f, 0.9255372549019608f, 0.8908235294117647f}, 
							 {0.9983058823529412f, 0.9252078431372549f, 0.8903529411764706f}, 
							 {0.9982901960784314f, 0.924878431372549f, 0.8898823529411765f}, 
							 {0.9982745098039216f, 0.9245490196078432f, 0.8894117647058823f}, 
							 {0.9982588235294118f, 0.9242196078431373f, 0.8889411764705882f}, 
							 {0.998243137254902f, 0.9238901960784314f, 0.8884705882352941f}, 
							 {0.9982274509803921f, 0.9235607843137255f, 0.888f}, 
							 {0.9982117647058824f, 0.9232313725490197f, 0.8875294117647059f}, 
							 {0.9981960784313726f, 0.9229019607843137f, 0.8870588235294118f}, 
							 {0.9981803921568627f, 0.9225725490196078f, 0.8865882352941177f}, 
							 {0.998164705882353f, 0.9222431372549019f, 0.8861176470588235f}, 
							 {0.9981490196078432f, 0.9219137254901961f, 0.8856470588235293f}, 
							 {0.9981333333333333f, 0.9215843137254902f, 0.8851764705882352f}, 
							 {0.9981176470588236f, 0.9212549019607843f, 0.8847058823529411f}, 
							 {0.9981019607843137f, 0.9209254901960784f, 0.884235294117647f}, 
							 {0.9980862745098039f, 0.9205960784313726f, 0.8837647058823529f}, 
							 {0.9980705882352942f, 0.9202666666666667f, 0.8832941176470588f}, 
							 {0.9980549019607843f, 0.9199372549019608f, 0.8828235294117647f}, 
							 {0.9980392156862745f, 0.919607843137255f, 0.8823529411764706f}, 
							 {0.9980235294117648f, 0.919278431372549f, 0.8818823529411765f}, 
							 {0.9980078431372549f, 0.9189490196078431f, 0.8814117647058823f}, 
							 {0.9979921568627451f, 0.9186196078431372f, 0.8809411764705882f}, 
							 {0.9979764705882354f, 0.9182901960784313f, 0.8804705882352941f}, 
							 {0.9979607843137255f, 0.9179607843137255f, 0.88f}, 
							 {0.9979450980392157f, 0.9176313725490196f, 0.8795294117647059f}, 
							 {0.9979294117647058f, 0.9173019607843137f, 0.8790588235294118f}, 
							 {0.9979137254901961f, 0.9169725490196079f, 0.8785882352941177f}, 
							 {0.9978980392156863f, 0.916643137254902f, 0.8781176470588234f}, 
							 {0.9978823529411764f, 0.9163137254901961f, 0.8776470588235293f}, 
							 {0.9978666666666667f, 0.9159843137254902f, 0.8771764705882352f}, 
							 {0.9978509803921569f, 0.9156549019607844f, 0.8767058823529411f}, 
							 {0.997835294117647f, 0.9153254901960785f, 0.876235294117647f}, 
							 {0.9978196078431373f, 0.9149960784313725f, 0.8757647058823529f}, 
							 {0.9978039215686274f, 0.9146666666666666f, 0.8752941176470588f}, 
							 {0.9977882352941176f, 0.9143372549019608f, 0.8748235294117647f}, 
							 {0.9977725490196079f, 0.9140078431372549f, 0.8743529411764706f}, 
							 {0.997756862745098f, 0.913678431372549f, 0.8738823529411764f}, 
							 {0.9977411764705882f, 0.9133490196078431f, 0.8734117647058823f}, 
							 {0.9977254901960785f, 0.9130196078431373f, 0.8729411764705882f}, 
							 {0.9977098039215686f, 0.9126901960784314f, 0.8724705882352941f}, 
							 {0.9976941176470588f, 0.9123607843137255f, 0.872f}, 
							 {0.9976784313725491f, 0.9120313725490197f, 0.8715294117647059f}, 
							 {0.9976627450980392f, 0.9117019607843138f, 0.8710588235294118f}, 
							 {0.9976470588235294f, 0.9113725490196078f, 0.8705882352941177f}, 
							 {0.9976313725490196f, 0.9110431372549019f, 0.8701176470588236f}, 
							 {0.9976156862745098f, 0.910713725490196f, 0.8696470588235294f}, 
							 {0.9976f, 0.9103843137254902f, 0.8691764705882352f}, 
							 {0.9975843137254902f, 0.9100549019607843f, 0.8687058823529411f}, 
							 {0.9975686274509804f, 0.9097254901960784f, 0.868235294117647f}, 
							 {0.9975529411764706f, 0.9093960784313726f, 0.8677647058823529f}, 
							 {0.9975372549019608f, 0.9090666666666667f, 0.8672941176470588f}, 
							 {0.997521568627451f, 0.9087372549019608f, 0.8668235294117647f}, 
							 {0.9975058823529411f, 0.9084078431372549f, 0.8663529411764705f}, 
							 {0.9974901960784314f, 0.9080784313725491f, 0.8658823529411764f}, 
							 {0.9974745098039216f, 0.9077490196078432f, 0.8654117647058823f}, 
							 {0.9974588235294117f, 0.9074196078431372f, 0.8649411764705882f}, 
							 {0.997443137254902f, 0.9070901960784313f, 0.8644705882352941f}, 
							 {0.9974274509803922f, 0.9067607843137255f, 0.864f}, 
							 {0.9974117647058823f, 0.9064313725490196f, 0.8635294117647059f}, 
							 {0.9973960784313726f, 0.9061019607843137f, 0.8630588235294118f}, 
							 {0.9973803921568628f, 0.9057725490196078f, 0.8625882352941177f}, 
							 {0.9973647058823529f, 0.905443137254902f, 0.8621176470588234f}, 
							 {0.9973490196078432f, 0.9051137254901961f, 0.8616470588235294f}, 
							 {0.9973333333333333f, 0.9047843137254902f, 0.8611764705882352f}, 
							 {0.9973176470588235f, 0.9044549019607843f, 0.8607058823529411f}, 
							 {0.9973019607843138f, 0.9041254901960785f, 0.860235294117647f}, 
							 {0.9972862745098039f, 0.9037960784313726f, 0.8597647058823529f}, 
							 {0.9972705882352941f, 0.9034666666666666f, 0.8592941176470588f}, 
							 {0.9972549019607844f, 0.9031372549019607f, 0.8588235294117647f}, 
							 {0.9972392156862745f, 0.9028078431372549f, 0.8583529411764705f}, 
							 {0.9972235294117647f, 0.902478431372549f, 0.8578823529411764f}, 
							 {0.9972078431372549f, 0.9021490196078431f, 0.8574117647058823f}, 
							 {0.9971921568627451f, 0.9018196078431373f, 0.8569411764705882f}, 
							 {0.9971764705882353f, 0.9014901960784314f, 0.8564705882352941f}, 
							 {0.9971607843137255f, 0.9011607843137255f, 0.856f}, 
							 {0.9971450980392157f, 0.9008313725490196f, 0.8555294117647059f}, 
							 {0.9971294117647059f, 0.9005019607843138f, 0.8550588235294118f}, 
							 {0.9971137254901961f, 0.9001725490196079f, 0.8545882352941176f}, 
							 {0.9970980392156863f, 0.899843137254902f, 0.8541176470588235f}, 
							 {0.9970823529411765f, 0.899513725490196f, 0.8536470588235294f}, 
							 {0.9970666666666667f, 0.8991843137254902f, 0.8531764705882352f}, 
							 {0.9970509803921569f, 0.8988549019607843f, 0.8527058823529412f}, 
							 {0.997035294117647f, 0.8985254901960784f, 0.852235294117647f}, 
							 {0.9970196078431373f, 0.8981960784313725f, 0.8517647058823529f}, 
							 {0.9970039215686275f, 0.8978666666666667f, 0.8512941176470588f}, 
							 {0.9969882352941176f, 0.8975372549019608f, 0.8508235294117646f}, 
							 {0.9969725490196079f, 0.8972078431372549f, 0.8503529411764705f}, 
							 {0.9969568627450981f, 0.896878431372549f, 0.8498823529411764f}, 
							 {0.9969411764705882f, 0.8965490196078432f, 0.8494117647058823f}, 
							 {0.9969254901960785f, 0.8962196078431373f, 0.8489411764705882f}, 
							 {0.9969098039215687f, 0.8958901960784313f, 0.8484705882352941f}, 
							 {0.9968941176470588f, 0.8955607843137254f, 0.848f}, 
							 {0.9968784313725491f, 0.8952313725490196f, 0.8475294117647059f}, 
							 {0.9968627450980392f, 0.8949019607843137f, 0.8470588235294118f}, 
							 {0.9968470588235294f, 0.8945725490196078f, 0.8465882352941176f}, 
							 {0.9968313725490197f, 0.894243137254902f, 0.8461176470588235f}, 
							 {0.9968156862745098f, 0.8939137254901961f, 0.8456470588235294f}, 
							 {0.9968f, 0.8935843137254902f, 0.8451764705882352f}, 
							 {0.9967843137254903f, 0.8932549019607843f, 0.8447058823529412f}, 
							 {0.9967686274509804f, 0.8929254901960784f, 0.844235294117647f}, 
							 {0.9967529411764706f, 0.8925960784313726f, 0.8437647058823529f}, 
							 {0.9967372549019607f, 0.8922666666666667f, 0.8432941176470587f}, 
							 {0.996721568627451f, 0.8919372549019607f, 0.8428235294117646f}, 
							 {0.9967058823529412f, 0.8916078431372549f, 0.8423529411764705f}, 
							 {0.9966901960784313f, 0.891278431372549f, 0.8418823529411764f}, 
							 {0.9966745098039216f, 0.8909490196078431f, 0.8414117647058823f}, 
							 {0.9966588235294118f, 0.8906196078431372f, 0.8409411764705882f}, 
							 {0.996643137254902f, 0.8902901960784314f, 0.8404705882352941f}, 
							 {0.9966274509803922f, 0.8899607843137255f, 0.84f}, 
							 {0.9966117647058824f, 0.8896313725490196f, 0.8395294117647059f}, 
							 {0.9965960784313725f, 0.8893019607843137f, 0.8390588235294117f}, 
							 {0.9965803921568628f, 0.8889725490196079f, 0.8385882352941176f}, 
							 {0.9965647058823529f, 0.888643137254902f, 0.8381176470588235f}, 
							 {0.9965490196078431f, 0.888313725490196f, 0.8376470588235294f}, 
							 {0.9965333333333334f, 0.8879843137254901f, 0.8371764705882353f}, 
							 {0.9965176470588235f, 0.8876549019607843f, 0.8367058823529412f}, 
							 {0.9965019607843137f, 0.8873254901960784f, 0.836235294117647f}, 
							 {0.996486274509804f, 0.8869960784313725f, 0.8357647058823529f}, 
							 {0.9964705882352941f, 0.8866666666666667f, 0.8352941176470587f}, 
							 {0.9964549019607843f, 0.8863372549019608f, 0.8348235294117646f}, 
							 {0.9964392156862745f, 0.8860078431372549f, 0.8343529411764705f}, 
							 {0.9964235294117647f, 0.885678431372549f, 0.8338823529411764f}, 
							 {0.996407843137255f, 0.8853490196078431f, 0.8334117647058823f}, 
							 {0.9963921568627451f, 0.8850196078431373f, 0.8329411764705882f}, 
							 {0.9963764705882353f, 0.8846901960784314f, 0.8324705882352941f}, 
							 {0.9963607843137255f, 0.8843607843137254f, 0.832f}, 
							 {0.9963450980392157f, 0.8840313725490196f, 0.8315294117647059f}, 
							 {0.9963294117647059f, 0.8837019607843137f, 0.8310588235294117f}, 
							 {0.9963137254901961f, 0.8833725490196078f, 0.8305882352941176f}, 
							 {0.9962980392156863f, 0.8830431372549019f, 0.8301176470588235f}, 
							 {0.9962823529411765f, 0.8827137254901961f, 0.8296470588235294f}, 
							 {0.9962666666666666f, 0.8823843137254902f, 0.8291764705882353f}, 
							 {0.9962509803921569f, 0.8820549019607843f, 0.8287058823529412f}, 
							 {0.9962352941176471f, 0.8817254901960784f, 0.8282352941176471f}, 
							 {0.9962196078431372f, 0.8813960784313726f, 0.827764705882353f}, 
							 {0.9962039215686275f, 0.8810666666666667f, 0.8272941176470587f}, 
							 {0.9961882352941177f, 0.8807372549019608f, 0.8268235294117646f}, 
							 {0.9961725490196078f, 0.8804078431372548f, 0.8263529411764705f}, 
							 {0.9961568627450981f, 0.880078431372549f, 0.8258823529411764f}, 
							 {0.9961411764705882f, 0.8797490196078431f, 0.8254117647058823f}, 
							 {0.9961254901960784f, 0.8794196078431372f, 0.8249411764705882f}, 
							 {0.9961098039215687f, 0.8790901960784314f, 0.8244705882352941f}, 
							 {0.9960941176470588f, 0.8787607843137255f, 0.824f}, 
							 {0.996078431372549f, 0.8784313725490196f, 0.8235294117647058f}, 
							 {0.9960470588235294f, 0.8778509803921568f, 0.8227607843137255f}, 
							 {0.9960156862745099f, 0.8772705882352941f, 0.8219921568627451f}, 
							 {0.9959843137254902f, 0.8766901960784313f, 0.8212235294117647f}, 
							 {0.9959529411764706f, 0.8761098039215686f, 0.8204549019607843f}, 
							 {0.995921568627451f, 0.8755294117647059f, 0.8196862745098039f}, 
							 {0.9958901960784314f, 0.8749490196078431f, 0.8189176470588235f}, 
							 {0.9958588235294118f, 0.8743686274509804f, 0.8181490196078431f}, 
							 {0.9958274509803922f, 0.8737882352941176f, 0.8173803921568628f}, 
							 {0.9957960784313725f, 0.8732078431372549f, 0.8166117647058823f}, 
							 {0.995764705882353f, 0.8726274509803922f, 0.8158431372549019f}, 
							 {0.9957333333333334f, 0.8720470588235294f, 0.8150745098039215f}, 
							 {0.9957019607843137f, 0.8714666666666666f, 0.8143058823529411f}, 
							 {0.9956705882352941f, 0.8708862745098039f, 0.8135372549019607f}, 
							 {0.9956392156862746f, 0.8703058823529412f, 0.8127686274509803f}, 
							 {0.9956078431372549f, 0.8697254901960784f, 0.8119999999999999f}, 
							 {0.9955764705882353f, 0.8691450980392157f, 0.8112313725490196f}, 
							 {0.9955450980392156f, 0.8685647058823529f, 0.8104627450980392f}, 
							 {0.9955137254901961f, 0.8679843137254901f, 0.8096941176470588f}, 
							 {0.9954823529411765f, 0.8674039215686274f, 0.8089254901960784f}, 
							 {0.9954509803921568f, 0.8668235294117647f, 0.808156862745098f}, 
							 {0.9954196078431373f, 0.866243137254902f, 0.8073882352941176f}, 
							 {0.9953882352941177f, 0.8656627450980392f, 0.8066196078431372f}, 
							 {0.995356862745098f, 0.8650823529411764f, 0.8058509803921569f}, 
							 {0.9953254901960784f, 0.8645019607843137f, 0.8050823529411764f}, 
							 {0.9952941176470589f, 0.863921568627451f, 0.804313725490196f}, 
							 {0.9952627450980392f, 0.8633411764705882f, 0.8035450980392156f}, 
							 {0.9952313725490196f, 0.8627607843137255f, 0.8027764705882352f}, 
							 {0.9952f, 0.8621803921568627f, 0.8020078431372548f}, 
							 {0.9951686274509804f, 0.8615999999999999f, 0.8012392156862744f}, 
							 {0.9951372549019608f, 0.8610196078431372f, 0.800470588235294f}, 
							 {0.9951058823529412f, 0.8604392156862745f, 0.7997019607843137f}, 
							 {0.9950745098039215f, 0.8598588235294118f, 0.7989333333333333f}, 
							 {0.995043137254902f, 0.859278431372549f, 0.7981647058823529f}, 
							 {0.9950117647058824f, 0.8586980392156862f, 0.7973960784313725f}, 
							 {0.9949803921568627f, 0.8581176470588235f, 0.7966274509803921f}, 
							 {0.9949490196078431f, 0.8575372549019608f, 0.7958588235294117f}, 
							 {0.9949176470588236f, 0.856956862745098f, 0.7950901960784313f}, 
							 {0.9948862745098039f, 0.8563764705882353f, 0.794321568627451f}, 
							 {0.9948549019607843f, 0.8557960784313725f, 0.7935529411764706f}, 
							 {0.9948235294117648f, 0.8552156862745098f, 0.7927843137254902f}, 
							 {0.9947921568627451f, 0.854635294117647f, 0.7920156862745098f}, 
							 {0.9947607843137255f, 0.8540549019607843f, 0.7912470588235294f}, 
							 {0.9947294117647059f, 0.8534745098039216f, 0.790478431372549f}, 
							 {0.9946980392156863f, 0.8528941176470588f, 0.7897098039215686f}, 
							 {0.9946666666666667f, 0.852313725490196f, 0.7889411764705883f}, 
							 {0.9946352941176471f, 0.8517333333333333f, 0.7881725490196079f}, 
							 {0.9946039215686274f, 0.8511529411764706f, 0.7874039215686274f}, 
							 {0.9945725490196079f, 0.8505725490196079f, 0.786635294117647f}, 
							 {0.9945411764705883f, 0.8499921568627451f, 0.7858666666666666f}, 
							 {0.9945098039215686f, 0.8494117647058823f, 0.7850980392156862f}, 
							 {0.994478431372549f, 0.8488313725490196f, 0.7843294117647058f}, 
							 {0.9944470588235295f, 0.8482509803921569f, 0.7835607843137254f}, 
							 {0.9944156862745098f, 0.8476705882352941f, 0.7827921568627451f}, 
							 {0.9943843137254902f, 0.8470901960784314f, 0.7820235294117647f}, 
							 {0.9943529411764707f, 0.8465098039215686f, 0.7812549019607843f}, 
							 {0.994321568627451f, 0.8459294117647058f, 0.7804862745098039f}, 
							 {0.9942901960784314f, 0.8453490196078431f, 0.7797176470588235f}, 
							 {0.9942588235294118f, 0.8447686274509804f, 0.7789490196078431f}, 
							 {0.9942274509803922f, 0.8441882352941177f, 0.7781803921568627f}, 
							 {0.9941960784313726f, 0.8436078431372549f, 0.7774117647058824f}, 
							 {0.994164705882353f, 0.8430274509803921f, 0.776643137254902f}, 
							 {0.9941333333333333f, 0.8424470588235294f, 0.7758745098039215f}, 
							 {0.9941019607843138f, 0.8418666666666667f, 0.7751058823529411f}, 
							 {0.9940705882352942f, 0.8412862745098039f, 0.7743372549019607f}, 
							 {0.9940392156862745f, 0.8407058823529412f, 0.7735686274509803f}, 
							 {0.9940078431372549f, 0.8401254901960784f, 0.7727999999999999f}, 
							 {0.9939764705882354f, 0.8395450980392156f, 0.7720313725490195f}, 
							 {0.9939450980392157f, 0.838964705882353f, 0.7712627450980392f}, 
							 {0.9939137254901961f, 0.8383843137254902f, 0.7704941176470588f}, 
							 {0.9938823529411764f, 0.8378039215686274f, 0.7697254901960784f}, 
							 {0.9938509803921569f, 0.8372235294117647f, 0.768956862745098f}, 
							 {0.9938196078431373f, 0.8366431372549019f, 0.7681882352941176f}, 
							 {0.9937882352941176f, 0.8360627450980391f, 0.7674196078431372f}, 
							 {0.9937568627450981f, 0.8354823529411765f, 0.7666509803921568f}, 
							 {0.9937254901960785f, 0.8349019607843137f, 0.7658823529411765f}, 
							 {0.9936941176470588f, 0.834321568627451f, 0.7651137254901961f}, 
							 {0.9936627450980392f, 0.8337411764705882f, 0.7643450980392157f}, 
							 {0.9936313725490197f, 0.8331607843137254f, 0.7635764705882353f}, 
							 {0.9936f, 0.8325803921568627f, 0.7628078431372549f}, 
							 {0.9935686274509804f, 0.832f, 0.7620392156862744f}, 
							 {0.9935372549019608f, 0.8314196078431372f, 0.761270588235294f}, 
							 {0.9935058823529412f, 0.8308392156862745f, 0.7605019607843136f}, 
							 {0.9934745098039216f, 0.8302588235294117f, 0.7597333333333333f}, 
							 {0.993443137254902f, 0.8296784313725489f, 0.7589647058823529f}, 
							 {0.9934117647058823f, 0.8290980392156863f, 0.7581960784313725f}, 
							 {0.9933803921568628f, 0.8285176470588235f, 0.7574274509803921f}, 
							 {0.9933490196078432f, 0.8279372549019608f, 0.7566588235294117f}, 
							 {0.9933176470588235f, 0.827356862745098f, 0.7558901960784313f}, 
							 {0.9932862745098039f, 0.8267764705882352f, 0.755121568627451f}, 
							 {0.9932549019607844f, 0.8261960784313725f, 0.7543529411764706f}, 
							 {0.9932235294117647f, 0.8256156862745098f, 0.7535843137254902f}, 
							 {0.9931921568627451f, 0.825035294117647f, 0.7528156862745098f}, 
							 {0.9931607843137256f, 0.8244549019607843f, 0.7520470588235294f}, 
							 {0.9931294117647059f, 0.8238745098039215f, 0.7512784313725489f}, 
							 {0.9930980392156863f, 0.8232941176470587f, 0.7505098039215685f}, 
							 {0.9930666666666667f, 0.8227137254901961f, 0.7497411764705881f}, 
							 {0.9930352941176471f, 0.8221333333333333f, 0.7489725490196077f}, 
							 {0.9930039215686275f, 0.8215529411764706f, 0.7482039215686274f}, 
							 {0.9929725490196079f, 0.8209725490196078f, 0.747435294117647f}, 
							 {0.9929411764705882f, 0.820392156862745f, 0.7466666666666666f}, 
							 {0.9929098039215687f, 0.8198117647058824f, 0.7458980392156862f}, 
							 {0.992878431372549f, 0.8192313725490196f, 0.7451294117647058f}, 
							 {0.9928470588235294f, 0.8186509803921569f, 0.7443607843137254f}, 
							 {0.9928156862745098f, 0.8180705882352941f, 0.743592156862745f}, 
							 {0.9927843137254903f, 0.8174901960784313f, 0.7428235294117647f}, 
							 {0.9927529411764706f, 0.8169098039215686f, 0.7420549019607843f}, 
							 {0.992721568627451f, 0.8163294117647059f, 0.7412862745098039f}, 
							 {0.9926901960784315f, 0.8157490196078431f, 0.7405176470588235f}, 
							 {0.9926588235294118f, 0.8151686274509804f, 0.7397490196078431f}, 
							 {0.9926274509803922f, 0.8145882352941176f, 0.7389803921568627f}, 
							 {0.9925960784313725f, 0.8140078431372548f, 0.7382117647058823f}, 
							 {0.992564705882353f, 0.8134274509803922f, 0.737443137254902f}, 
							 {0.9925333333333334f, 0.8128470588235294f, 0.7366745098039216f}, 
							 {0.9925019607843137f, 0.8122666666666667f, 0.7359058823529412f}, 
							 {0.9924705882352941f, 0.8116862745098039f, 0.7351372549019608f}, 
							 {0.9924392156862746f, 0.8111058823529411f, 0.7343686274509804f}, 
							 {0.9924078431372549f, 0.8105254901960784f, 0.7336f}, 
							 {0.9923764705882353f, 0.8099450980392157f, 0.7328313725490195f}, 
							 {0.9923450980392157f, 0.8093647058823529f, 0.7320627450980391f}, 
							 {0.9923137254901961f, 0.8087843137254902f, 0.7312941176470588f}, 
							 {0.9922823529411765f, 0.8082039215686274f, 0.7305254901960784f}, 
							 {0.9922509803921569f, 0.8076235294117646f, 0.729756862745098f}, 
							 {0.9922196078431372f, 0.807043137254902f, 0.7289882352941176f}, 
							 {0.9921882352941177f, 0.8064627450980392f, 0.7282196078431372f}, 
							 {0.9921568627450981f, 0.8058823529411765f, 0.7274509803921568f}, 
							 {0.9921254901960784f, 0.8053019607843137f, 0.7266823529411764f}, 
							 {0.9920941176470589f, 0.8047215686274509f, 0.7259137254901961f}, 
							 {0.9920627450980393f, 0.8041411764705882f, 0.7251450980392157f}, 
							 {0.9920313725490196f, 0.8035607843137255f, 0.7243764705882353f}, 
							 {0.992f, 0.8029803921568627f, 0.7236078431372549f}, 
							 {0.9919686274509805f, 0.8024f, 0.7228392156862745f}, 
							 {0.9919372549019608f, 0.8018196078431372f, 0.7220705882352941f}, 
							 {0.9919058823529412f, 0.8012392156862744f, 0.7213019607843136f}, 
							 {0.9918745098039216f, 0.8006588235294118f, 0.7205333333333332f}, 
							 {0.991843137254902f, 0.800078431372549f, 0.7197647058823529f}, 
							 {0.9918117647058824f, 0.7994980392156863f, 0.7189960784313725f}, 
							 {0.9917803921568628f, 0.7989176470588235f, 0.7182274509803921f}, 
							 {0.9917490196078431f, 0.7983372549019607f, 0.7174588235294117f}, 
							 {0.9917176470588236f, 0.7977568627450979f, 0.7166901960784313f}, 
							 {0.991686274509804f, 0.7971764705882353f, 0.7159215686274509f}, 
							 {0.9916549019607843f, 0.7965960784313725f, 0.7151529411764705f}, 
							 {0.9916235294117647f, 0.7960156862745098f, 0.7143843137254902f}, 
							 {0.9915921568627452f, 0.795435294117647f, 0.7136156862745098f}, 
							 {0.9915607843137255f, 0.7948549019607842f, 0.7128470588235294f}, 
							 {0.9915294117647059f, 0.7942745098039216f, 0.712078431372549f}, 
							 {0.9914980392156864f, 0.7936941176470588f, 0.7113098039215686f}, 
							 {0.9914666666666667f, 0.793113725490196f, 0.7105411764705882f}, 
							 {0.9914352941176471f, 0.7925333333333333f, 0.7097725490196078f}, 
							 {0.9914039215686274f, 0.7919529411764705f, 0.7090039215686275f}, 
							 {0.9913725490196079f, 0.7913725490196077f, 0.7082352941176471f}, 
							 {0.9913411764705883f, 0.7907921568627451f, 0.7074666666666666f}, 
							 {0.9913098039215686f, 0.7902117647058823f, 0.7066980392156862f}, 
							 {0.991278431372549f, 0.7896313725490196f, 0.7059294117647058f}, 
							 {0.9912470588235295f, 0.7890509803921568f, 0.7051607843137254f}, 
							 {0.9912156862745098f, 0.788470588235294f, 0.704392156862745f}, 
							 {0.9911843137254902f, 0.7878901960784314f, 0.7036235294117646f}, 
							 {0.9911529411764706f, 0.7873098039215686f, 0.7028549019607843f}, 
							 {0.991121568627451f, 0.7867294117647058f, 0.7020862745098039f}, 
							 {0.9910901960784314f, 0.7861490196078431f, 0.7013176470588235f}, 
							 {0.9910588235294118f, 0.7855686274509803f, 0.7005490196078431f}, 
							 {0.9910274509803921f, 0.7849882352941175f, 0.6997803921568627f}, 
							 {0.9909960784313726f, 0.7844078431372549f, 0.6990117647058823f}, 
							 {0.990964705882353f, 0.7838274509803921f, 0.698243137254902f}, 
							 {0.9909333333333333f, 0.7832470588235294f, 0.6974745098039214f}, 
							 {0.9909019607843138f, 0.7826666666666666f, 0.6967058823529411f}, 
							 {0.9908705882352942f, 0.7820862745098038f, 0.6959372549019607f}, 
							 {0.9908392156862745f, 0.7815058823529412f, 0.6951686274509804f}, 
							 {0.9908078431372549f, 0.7809254901960784f, 0.6944f}, 
							 {0.9907764705882354f, 0.7803450980392157f, 0.6936313725490196f}, 
							 {0.9907450980392157f, 0.7797647058823529f, 0.6928627450980391f}, 
							 {0.9907137254901961f, 0.7791843137254901f, 0.6920941176470587f}, 
							 {0.9906823529411765f, 0.7786039215686275f, 0.6913254901960784f}, 
							 {0.9906509803921569f, 0.7780235294117647f, 0.690556862745098f}, 
							 {0.9906196078431373f, 0.7774431372549019f, 0.6897882352941176f}, 
							 {0.9905882352941177f, 0.7768627450980392f, 0.6890196078431372f}, 
							 {0.990556862745098f, 0.7762823529411764f, 0.6882509803921568f}, 
							 {0.9905254901960785f, 0.7757019607843136f, 0.6874823529411764f}, 
							 {0.9904941176470589f, 0.775121568627451f, 0.686713725490196f}, 
							 {0.9904627450980392f, 0.7745411764705882f, 0.6859450980392157f}, 
							 {0.9904313725490197f, 0.7739607843137255f, 0.6851764705882353f}, 
							 {0.9904000000000001f, 0.7733803921568627f, 0.6844078431372549f}, 
							 {0.9903686274509804f, 0.7727999999999999f, 0.6836392156862745f}, 
							 {0.9903372549019608f, 0.7722196078431373f, 0.6828705882352941f}, 
							 {0.9903058823529413f, 0.7716392156862745f, 0.6821019607843137f}, 
							 {0.9902745098039216f, 0.7710588235294117f, 0.6813333333333333f}, 
							 {0.990243137254902f, 0.770478431372549f, 0.680564705882353f}, 
							 {0.9902117647058823f, 0.7698980392156862f, 0.6797960784313726f}, 
							 {0.9901803921568628f, 0.7693176470588234f, 0.6790274509803922f}, 
							 {0.9901490196078432f, 0.7687372549019608f, 0.6782588235294118f}, 
							 {0.9901176470588235f, 0.768156862745098f, 0.6774901960784313f}, 
							 {0.9900862745098039f, 0.7675764705882353f, 0.6767215686274509f}, 
							 {0.9900549019607844f, 0.7669960784313725f, 0.6759529411764705f}, 
							 {0.9900235294117647f, 0.7664156862745097f, 0.6751843137254901f}, 
							 {0.9899921568627451f, 0.7658352941176471f, 0.6744156862745098f}, 
							 {0.9899607843137255f, 0.7652549019607843f, 0.6736470588235294f}, 
							 {0.989929411764706f, 0.7646745098039215f, 0.672878431372549f}, 
							 {0.9898980392156863f, 0.7640941176470588f, 0.6721098039215686f}, 
							 {0.9898666666666667f, 0.763513725490196f, 0.6713411764705882f}, 
							 {0.9898352941176471f, 0.7629333333333332f, 0.6705725490196078f}, 
							 {0.9898039215686275f, 0.7623529411764706f, 0.6698039215686274f}, 
							 {0.9897725490196079f, 0.7617725490196078f, 0.6690352941176471f}, 
							 {0.9897411764705882f, 0.7611921568627451f, 0.6682666666666666f}, 
							 {0.9897098039215687f, 0.7606117647058823f, 0.6674980392156862f}, 
							 {0.9896784313725491f, 0.7600313725490195f, 0.6667294117647058f}, 
							 {0.9896470588235294f, 0.7594509803921567f, 0.6659607843137254f}, 
							 {0.9896156862745098f, 0.7588705882352941f, 0.665192156862745f}, 
							 {0.9895843137254903f, 0.7582901960784313f, 0.6644235294117646f}, 
							 {0.9895529411764706f, 0.7577098039215686f, 0.6636549019607842f}, 
							 {0.989521568627451f, 0.7571294117647058f, 0.6628862745098039f}, 
							 {0.9894901960784314f, 0.756549019607843f, 0.6621176470588235f}, 
							 {0.9894588235294118f, 0.7559686274509804f, 0.6613490196078431f}, 
							 {0.9894274509803922f, 0.7553882352941176f, 0.6605803921568627f}, 
							 {0.9893960784313726f, 0.7548078431372548f, 0.6598117647058823f}, 
							 {0.9893647058823529f, 0.7542274509803921f, 0.6590431372549019f}, 
							 {0.9893333333333334f, 0.7536470588235293f, 0.6582745098039215f}, 
							 {0.9893019607843138f, 0.7530666666666666f, 0.6575058823529412f}, 
							 {0.9892705882352941f, 0.7524862745098039f, 0.6567372549019608f}, 
							 {0.9892392156862746f, 0.7519058823529411f, 0.6559686274509804f}, 
							 {0.989207843137255f, 0.7513254901960784f, 0.6552f}, 
							 {0.9891764705882353f, 0.7507450980392156f, 0.6544313725490196f}, 
							 {0.9891450980392157f, 0.7501647058823528f, 0.6536627450980392f}, 
							 {0.9891137254901962f, 0.7495843137254902f, 0.6528941176470587f}, 
							 {0.9890823529411765f, 0.7490039215686274f, 0.6521254901960784f}, 
							 {0.9890509803921569f, 0.7484235294117646f, 0.651356862745098f}, 
							 {0.9890196078431372f, 0.7478431372549019f, 0.6505882352941176f}, 
							 {0.9889882352941177f, 0.7472627450980391f, 0.6498196078431372f}, 
							 {0.9889568627450981f, 0.7466823529411764f, 0.6490509803921568f}, 
							 {0.9889254901960784f, 0.7461019607843137f, 0.6482823529411764f}, 
							 {0.9888941176470588f, 0.7455215686274509f, 0.647513725490196f}, 
							 {0.9888627450980393f, 0.7449411764705882f, 0.6467450980392156f}, 
							 {0.9888313725490196f, 0.7443607843137254f, 0.6459764705882353f}, 
							 {0.9888f, 0.7437803921568626f, 0.6452078431372549f}, 
							 {0.9887686274509805f, 0.7432f, 0.6444392156862745f}, 
							 {0.9887372549019608f, 0.7426196078431372f, 0.6436705882352941f}, 
							 {0.9887058823529412f, 0.7420392156862745f, 0.6429019607843137f}, 
							 {0.9886745098039216f, 0.7414588235294117f, 0.6421333333333333f}, 
							 {0.988643137254902f, 0.7408784313725489f, 0.641364705882353f}, 
							 {0.9886117647058824f, 0.7402980392156863f, 0.6405960784313726f}, 
							 {0.9885803921568628f, 0.7397176470588235f, 0.6398274509803922f}, 
							 {0.9885490196078431f, 0.7391372549019608f, 0.6390588235294117f}, 
							 {0.9885176470588236f, 0.738556862745098f, 0.6382901960784313f}, 
							 {0.988486274509804f, 0.7379764705882352f, 0.6375215686274509f}, 
							 {0.9884549019607843f, 0.7373960784313724f, 0.6367529411764705f}, 
							 {0.9884235294117647f, 0.7368156862745098f, 0.6359843137254901f}, 
							 {0.9883921568627452f, 0.736235294117647f, 0.6352156862745097f}, 
							 {0.9883607843137255f, 0.7356549019607843f, 0.6344470588235294f}, 
							 {0.9883294117647059f, 0.7350745098039215f, 0.633678431372549f}, 
							 {0.9882980392156863f, 0.7344941176470587f, 0.6329098039215686f}, 
							 {0.9882666666666667f, 0.7339137254901961f, 0.6321411764705882f}, 
							 {0.9882352941176471f, 0.7333333333333333f, 0.6313725490196078f}, 
							 {0.9882352941176471f, 0.7326901960784313f, 0.6306352941176471f}, 
							 {0.9882352941176471f, 0.7320470588235294f, 0.6298980392156862f}, 
							 {0.9882352941176471f, 0.7314039215686274f, 0.6291607843137255f}, 
							 {0.9882352941176471f, 0.7307607843137255f, 0.6284235294117647f}, 
							 {0.9882352941176471f, 0.7301176470588234f, 0.6276862745098039f}, 
							 {0.9882352941176471f, 0.7294745098039215f, 0.6269490196078431f}, 
							 {0.9882352941176471f, 0.7288313725490195f, 0.6262117647058824f}, 
							 {0.9882352941176471f, 0.7281882352941176f, 0.6254745098039215f}, 
							 {0.9882352941176471f, 0.7275450980392156f, 0.6247372549019607f}, 
							 {0.9882352941176471f, 0.7269019607843137f, 0.624f}, 
							 {0.9882352941176471f, 0.7262588235294117f, 0.6232627450980391f}, 
							 {0.9882352941176471f, 0.7256156862745098f, 0.6225254901960784f}, 
							 {0.9882352941176471f, 0.7249725490196078f, 0.6217882352941176f}, 
							 {0.9882352941176471f, 0.7243294117647058f, 0.6210509803921568f}, 
							 {0.9882352941176471f, 0.7236862745098038f, 0.620313725490196f}, 
							 {0.9882352941176471f, 0.7230431372549019f, 0.6195764705882353f}, 
							 {0.9882352941176471f, 0.7223999999999999f, 0.6188392156862745f}, 
							 {0.9882352941176471f, 0.721756862745098f, 0.6181019607843137f}, 
							 {0.9882352941176471f, 0.721113725490196f, 0.6173647058823529f}, 
							 {0.9882352941176471f, 0.7204705882352941f, 0.6166274509803922f}, 
							 {0.9882352941176471f, 0.7198274509803921f, 0.6158901960784313f}, 
							 {0.9882352941176471f, 0.7191843137254902f, 0.6151529411764706f}, 
							 {0.9882352941176471f, 0.7185411764705881f, 0.6144156862745098f}, 
							 {0.9882352941176471f, 0.7178980392156862f, 0.613678431372549f}, 
							 {0.9882352941176471f, 0.7172549019607842f, 0.6129411764705882f}, 
							 {0.9882352941176471f, 0.7166117647058823f, 0.6122039215686275f}, 
							 {0.9882352941176471f, 0.7159686274509803f, 0.6114666666666666f}, 
							 {0.9882352941176471f, 0.7153254901960784f, 0.6107294117647059f}, 
							 {0.9882352941176471f, 0.7146823529411764f, 0.6099921568627451f}, 
							 {0.9882352941176471f, 0.7140392156862745f, 0.6092549019607842f}, 
							 {0.9882352941176471f, 0.7133960784313724f, 0.6085176470588235f}, 
							 {0.9882352941176471f, 0.7127529411764705f, 0.6077803921568627f}, 
							 {0.9882352941176471f, 0.7121098039215685f, 0.6070431372549019f}, 
							 {0.9882352941176471f, 0.7114666666666666f, 0.6063058823529411f}, 
							 {0.9882352941176471f, 0.7108235294117646f, 0.6055686274509804f}, 
							 {0.9882352941176471f, 0.7101803921568627f, 0.6048313725490195f}, 
							 {0.9882352941176471f, 0.7095372549019607f, 0.6040941176470588f}, 
							 {0.9882352941176471f, 0.7088941176470588f, 0.603356862745098f}, 
							 {0.9882352941176471f, 0.7082509803921568f, 0.6026196078431372f}, 
							 {0.9882352941176471f, 0.7076078431372548f, 0.6018823529411764f}, 
							 {0.9882352941176471f, 0.7069647058823528f, 0.6011450980392157f}, 
							 {0.9882352941176471f, 0.7063215686274509f, 0.6004078431372548f}, 
							 {0.9882352941176471f, 0.7056784313725489f, 0.5996705882352941f}, 
							 {0.9882352941176471f, 0.705035294117647f, 0.5989333333333333f}, 
							 {0.9882352941176471f, 0.704392156862745f, 0.5981960784313725f}, 
							 {0.9882352941176471f, 0.7037490196078431f, 0.5974588235294117f}, 
							 {0.9882352941176471f, 0.7031058823529411f, 0.596721568627451f}, 
							 {0.9882352941176471f, 0.7024627450980392f, 0.5959843137254901f}, 
							 {0.9882352941176471f, 0.7018196078431371f, 0.5952470588235294f}, 
							 {0.9882352941176471f, 0.7011764705882352f, 0.5945098039215686f}, 
							 {0.9882352941176471f, 0.7005333333333332f, 0.5937725490196077f}, 
							 {0.9882352941176471f, 0.6998901960784313f, 0.593035294117647f}, 
							 {0.9882352941176471f, 0.6992470588235293f, 0.5922980392156862f}, 
							 {0.9882352941176471f, 0.6986039215686274f, 0.5915607843137254f}, 
							 {0.9882352941176471f, 0.6979607843137254f, 0.5908235294117646f}, 
							 {0.9882352941176471f, 0.6973176470588235f, 0.5900862745098039f}, 
							 {0.9882352941176471f, 0.6966745098039215f, 0.5893490196078431f}, 
							 {0.9882352941176471f, 0.6960313725490195f, 0.5886117647058823f}, 
							 {0.9882352941176471f, 0.6953882352941175f, 0.5878745098039215f}, 
							 {0.9882352941176471f, 0.6947450980392156f, 0.5871372549019608f}, 
							 {0.9882352941176471f, 0.6941019607843136f, 0.5863999999999999f}, 
							 {0.9882352941176471f, 0.6934588235294117f, 0.5856627450980392f}, 
							 {0.9882352941176471f, 0.6928156862745097f, 0.5849254901960784f}, 
							 {0.9882352941176471f, 0.6921725490196078f, 0.5841882352941176f}, 
							 {0.9882352941176471f, 0.6915294117647058f, 0.5834509803921568f}, 
							 {0.9882352941176471f, 0.6908862745098039f, 0.5827137254901961f}, 
							 {0.9882352941176471f, 0.6902431372549018f, 0.5819764705882352f}, 
							 {0.9882352941176471f, 0.6895999999999999f, 0.5812392156862745f}, 
							 {0.9882352941176471f, 0.6889568627450979f, 0.5805019607843137f}, 
							 {0.9882352941176471f, 0.688313725490196f, 0.5797647058823528f}, 
							 {0.9882352941176471f, 0.687670588235294f, 0.5790274509803921f}, 
							 {0.9882352941176471f, 0.6870274509803921f, 0.5782901960784314f}, 
							 {0.9882352941176471f, 0.6863843137254901f, 0.5775529411764705f}, 
							 {0.9882352941176471f, 0.6857411764705882f, 0.5768156862745097f}, 
							 {0.9882352941176471f, 0.6850980392156862f, 0.576078431372549f}, 
							 {0.9882352941176471f, 0.6844549019607842f, 0.5753411764705881f}, 
							 {0.9882352941176471f, 0.6838117647058823f, 0.5746039215686275f}, 
							 {0.9882352941176471f, 0.6831686274509804f, 0.5738666666666667f}, 
							 {0.9882352941176471f, 0.6825254901960784f, 0.5731294117647059f}, 
							 {0.9882352941176471f, 0.6818823529411765f, 0.5723921568627451f}, 
							 {0.9882352941176471f, 0.6812392156862745f, 0.5716549019607844f}, 
							 {0.9882352941176471f, 0.6805960784313725f, 0.5709176470588235f}, 
							 {0.9882352941176471f, 0.6799529411764705f, 0.5701803921568628f}, 
							 {0.9882352941176471f, 0.6793098039215686f, 0.569443137254902f}, 
							 {0.9882352941176471f, 0.6786666666666666f, 0.5687058823529412f}, 
							 {0.9882352941176471f, 0.6780235294117647f, 0.5679686274509804f}, 
							 {0.9882352941176471f, 0.6773803921568627f, 0.5672313725490197f}, 
							 {0.9882352941176471f, 0.6767372549019608f, 0.5664941176470588f}, 
							 {0.9882352941176471f, 0.6760941176470588f, 0.5657568627450981f}, 
							 {0.9882352941176471f, 0.6754509803921568f, 0.5650196078431373f}, 
							 {0.9882352941176471f, 0.6748078431372548f, 0.5642823529411765f}, 
							 {0.9882352941176471f, 0.6741647058823529f, 0.5635450980392157f}, 
							 {0.9882352941176471f, 0.6735215686274509f, 0.562807843137255f}, 
							 {0.9882352941176471f, 0.672878431372549f, 0.5620705882352941f}, 
							 {0.9882352941176471f, 0.672235294117647f, 0.5613333333333334f}, 
							 {0.9882352941176471f, 0.6715921568627451f, 0.5605960784313726f}, 
							 {0.9882352941176471f, 0.6709490196078431f, 0.5598588235294117f}, 
							 {0.9882352941176471f, 0.6703058823529411f, 0.559121568627451f}, 
							 {0.9882352941176471f, 0.6696627450980392f, 0.5583843137254902f}, 
							 {0.9882352941176471f, 0.6690196078431372f, 0.5576470588235294f}, 
							 {0.9882352941176471f, 0.6683764705882352f, 0.5569098039215686f}, 
							 {0.9882352941176471f, 0.6677333333333333f, 0.5561725490196079f}, 
							 {0.9882352941176471f, 0.6670901960784313f, 0.555435294117647f}, 
							 {0.9882352941176471f, 0.6664470588235294f, 0.5546980392156863f}, 
							 {0.9882352941176471f, 0.6658039215686274f, 0.5539607843137255f}, 
							 {0.9882352941176471f, 0.6651607843137255f, 0.5532235294117647f}, 
							 {0.9882352941176471f, 0.6645176470588234f, 0.5524862745098039f}, 
							 {0.9882352941176471f, 0.6638745098039215f, 0.5517490196078432f}, 
							 {0.9882352941176471f, 0.6632313725490195f, 0.5510117647058823f}, 
							 {0.9882352941176471f, 0.6625882352941176f, 0.5502745098039216f}, 
							 {0.9882352941176471f, 0.6619450980392156f, 0.5495372549019608f}, 
							 {0.9882352941176471f, 0.6613019607843137f, 0.5488f}, 
							 {0.9882352941176471f, 0.6606588235294117f, 0.5480627450980392f}, 
							 {0.9882352941176471f, 0.6600156862745098f, 0.5473254901960785f}, 
							 {0.9882352941176471f, 0.6593725490196078f, 0.5465882352941176f}, 
							 {0.9882352941176471f, 0.6587294117647058f, 0.5458509803921568f}, 
							 {0.9882352941176471f, 0.6580862745098038f, 0.5451137254901961f}, 
							 {0.9882352941176471f, 0.6574431372549019f, 0.5443764705882352f}, 
							 {0.9882352941176471f, 0.6567999999999999f, 0.5436392156862745f}, 
							 {0.9882352941176471f, 0.656156862745098f, 0.5429019607843137f}, 
							 {0.9882352941176471f, 0.655513725490196f, 0.5421647058823529f}, 
							 {0.9882352941176471f, 0.6548705882352941f, 0.5414274509803921f}, 
							 {0.9882352941176471f, 0.6542274509803921f, 0.5406901960784314f}, 
							 {0.9882352941176471f, 0.6535843137254902f, 0.5399529411764706f}, 
							 {0.9882352941176471f, 0.6529411764705881f, 0.5392156862745098f}, 
							 {0.9882352941176471f, 0.6522980392156862f, 0.538478431372549f}, 
							 {0.9882352941176471f, 0.6516549019607842f, 0.5377411764705883f}, 
							 {0.9882352941176471f, 0.6510117647058823f, 0.5370039215686274f}, 
							 {0.9882352941176471f, 0.6503686274509803f, 0.5362666666666667f}, 
							 {0.9882352941176471f, 0.6497254901960784f, 0.5355294117647059f}, 
							 {0.9882352941176471f, 0.6490823529411764f, 0.5347921568627451f}, 
							 {0.9882352941176471f, 0.6484392156862745f, 0.5340549019607843f}, 
							 {0.9882352941176471f, 0.6477960784313725f, 0.5333176470588236f}, 
							 {0.9882352941176471f, 0.6471529411764705f, 0.5325803921568627f}, 
							 {0.9882352941176471f, 0.6465098039215685f, 0.531843137254902f}, 
							 {0.9882352941176471f, 0.6458666666666666f, 0.5311058823529412f}, 
							 {0.9882352941176471f, 0.6452235294117646f, 0.5303686274509803f}, 
							 {0.9882352941176471f, 0.6445803921568627f, 0.5296313725490196f}, 
							 {0.9882352941176471f, 0.6439372549019607f, 0.5288941176470588f}, 
							 {0.9882352941176471f, 0.6432941176470588f, 0.528156862745098f}, 
							 {0.9882352941176471f, 0.6426509803921568f, 0.5274196078431372f}, 
							 {0.9882352941176471f, 0.6420078431372549f, 0.5266823529411765f}, 
							 {0.9882352941176471f, 0.6413647058823528f, 0.5259450980392156f}, 
							 {0.9882352941176471f, 0.6407215686274509f, 0.5252078431372549f}, 
							 {0.9882352941176471f, 0.6400784313725489f, 0.5244705882352941f}, 
							 {0.9882352941176471f, 0.639435294117647f, 0.5237333333333334f}, 
							 {0.9882352941176471f, 0.638792156862745f, 0.5229960784313725f}, 
							 {0.9882352941176471f, 0.6381490196078431f, 0.5222588235294118f}, 
							 {0.9882352941176471f, 0.6375058823529411f, 0.521521568627451f}, 
							 {0.9882352941176471f, 0.6368627450980392f, 0.5207843137254902f}, 
							 {0.9882352941176471f, 0.6362196078431372f, 0.5200470588235294f}, 
							 {0.9882352941176471f, 0.6355764705882352f, 0.5193098039215687f}, 
							 {0.9882352941176471f, 0.6349333333333332f, 0.5185725490196078f}, 
							 {0.9882352941176471f, 0.6342901960784313f, 0.5178352941176471f}, 
							 {0.9882352941176471f, 0.6336470588235293f, 0.5170980392156863f}, 
							 {0.9882352941176471f, 0.6330039215686274f, 0.5163607843137255f}, 
							 {0.9882352941176471f, 0.6323607843137254f, 0.5156235294117647f}, 
							 {0.9882352941176471f, 0.6317176470588235f, 0.514886274509804f}, 
							 {0.9882352941176471f, 0.6310745098039215f, 0.5141490196078431f}, 
							 {0.9882352941176471f, 0.6304313725490196f, 0.5134117647058823f}, 
							 {0.9882352941176471f, 0.6297882352941175f, 0.5126745098039216f}, 
							 {0.9882352941176471f, 0.6291450980392156f, 0.5119372549019607f}, 
							 {0.9882352941176471f, 0.6285019607843136f, 0.5112f}, 
							 {0.9882352941176471f, 0.6278588235294117f, 0.5104627450980392f}, 
							 {0.9882352941176471f, 0.6272156862745097f, 0.5097254901960784f}, 
							 {0.9882352941176471f, 0.6265725490196078f, 0.5089882352941176f}, 
							 {0.9882352941176471f, 0.6259294117647058f, 0.5082509803921569f}, 
							 {0.9882352941176471f, 0.6252862745098039f, 0.507513725490196f}, 
							 {0.9882352941176471f, 0.624643137254902f, 0.5067764705882353f}, 
							 {0.9882352941176471f, 0.6239999999999999f, 0.5060392156862745f}, 
							 {0.9882352941176471f, 0.6233568627450979f, 0.5053019607843137f}, 
							 {0.9882352941176471f, 0.622713725490196f, 0.5045647058823529f}, 
							 {0.9882352941176471f, 0.622070588235294f, 0.5038274509803922f}, 
							 {0.9882352941176471f, 0.6214274509803921f, 0.5030901960784313f}, 
							 {0.9882352941176471f, 0.6207843137254901f, 0.5023529411764706f}, 
							 {0.9882352941176471f, 0.6201411764705882f, 0.5016156862745098f}, 
							 {0.9882352941176471f, 0.6194980392156862f, 0.500878431372549f}, 
							 {0.9882352941176471f, 0.6188549019607843f, 0.5001411764705882f}, 
							 {0.9882352941176471f, 0.6182117647058822f, 0.49940392156862745f}, 
							 {0.9882352941176471f, 0.6175686274509803f, 0.49866666666666665f}, 
							 {0.9882352941176471f, 0.6169254901960783f, 0.49792941176470584f}, 
							 {0.9882352941176471f, 0.6162823529411764f, 0.4971921568627451f}, 
							 {0.9882352941176471f, 0.6156392156862744f, 0.4964549019607843f}, 
							 {0.9882352941176471f, 0.6149960784313725f, 0.4957176470588235f}, 
							 {0.9882352941176471f, 0.6143529411764705f, 0.49498039215686274f}, 
							 {0.9882352941176471f, 0.6137098039215686f, 0.49424313725490193f}, 
							 {0.9882352941176471f, 0.6130666666666666f, 0.4935058823529411f}, 
							 {0.9882352941176471f, 0.6124235294117646f, 0.4927686274509804f}, 
							 {0.9882352941176471f, 0.6117803921568626f, 0.4920313725490196f}, 
							 {0.9882352941176471f, 0.6111372549019607f, 0.49129411764705877f}, 
							 {0.9882352941176471f, 0.6104941176470587f, 0.490556862745098f}, 
							 {0.9882352941176471f, 0.6098509803921568f, 0.4898196078431372f}, 
							 {0.9882352941176471f, 0.6092078431372548f, 0.4890823529411764f}, 
							 {0.9882352941176471f, 0.6085647058823529f, 0.48834509803921566f}, 
							 {0.9882352941176471f, 0.6079215686274508f, 0.48760784313725486f}, 
							 {0.9882352941176471f, 0.607278431372549f, 0.48687058823529406f}, 
							 {0.9882352941176471f, 0.6066352941176469f, 0.4861333333333333f}, 
							 {0.9882352941176471f, 0.605992156862745f, 0.4853960784313725f}, 
							 {0.9882352941176471f, 0.605349019607843f, 0.4846588235294117f}, 
							 {0.9882352941176471f, 0.6047058823529411f, 0.48392156862745095f}, 
							 {0.9882352941176471f, 0.6040627450980391f, 0.4831843137254902f}, 
							 {0.9882352941176471f, 0.6034196078431372f, 0.48244705882352934f}, 
							 {0.9882352941176471f, 0.6027764705882352f, 0.4817098039215686f}, 
							 {0.9882352941176471f, 0.6021333333333333f, 0.4809725490196079f}, 
							 {0.9882352941176471f, 0.6014901960784313f, 0.4802352941176471f}, 
							 {0.9882352941176471f, 0.6008470588235294f, 0.47949803921568634f}, 
							 {0.9882352941176471f, 0.6002039215686275f, 0.47876078431372554f}, 
							 {0.9882352941176471f, 0.5995607843137255f, 0.47802352941176474f}, 
							 {0.9882352941176471f, 0.5989176470588236f, 0.477286274509804f}, 
							 {0.9882352941176471f, 0.5982745098039215f, 0.4765490196078432f}, 
							 {0.9882352941176471f, 0.5976313725490197f, 0.4758117647058824f}, 
							 {0.9882352941176471f, 0.5969882352941176f, 0.47507450980392163f}, 
							 {0.9882352941176471f, 0.5963450980392156f, 0.4743372549019608f}, 
							 {0.9882352941176471f, 0.5957019607843137f, 0.4736f}, 
							 {0.9882352941176471f, 0.5950588235294118f, 0.47286274509803927f}, 
							 {0.9882352941176471f, 0.5944156862745098f, 0.47212549019607847f}, 
							 {0.9882352941176471f, 0.5937725490196079f, 0.47138823529411766f}, 
							 {0.9882352941176471f, 0.5931294117647059f, 0.4706509803921569f}, 
							 {0.9882352941176471f, 0.5924862745098038f, 0.4699137254901961f}, 
							 {0.9882352941176471f, 0.591843137254902f, 0.4691764705882353f}, 
							 {0.9882352941176471f, 0.5912f, 0.46843921568627456f}, 
							 {0.9882352941176471f, 0.590556862745098f, 0.46770196078431375f}, 
							 {0.9882352941176471f, 0.589913725490196f, 0.46696470588235295f}, 
							 {0.9882352941176471f, 0.5892705882352941f, 0.4662274509803922f}, 
							 {0.9882352941176471f, 0.5886274509803922f, 0.4654901960784314f}, 
							 {0.9882352941176471f, 0.5879843137254902f, 0.4647529411764706f}, 
							 {0.9882352941176471f, 0.5873411764705883f, 0.46401568627450984f}, 
							 {0.9882352941176471f, 0.5866980392156862f, 0.4632784313725491f}, 
							 {0.9882352941176471f, 0.5860549019607844f, 0.46254117647058823f}, 
							 {0.9882352941176471f, 0.5854117647058823f, 0.4618039215686275f}, 
							 {0.9882352941176471f, 0.5847686274509803f, 0.46106666666666674f}, 
							 {0.9882352941176471f, 0.5841254901960784f, 0.4603294117647059f}, 
							 {0.9882352941176471f, 0.5834823529411765f, 0.4595921568627451f}, 
							 {0.9882352941176471f, 0.5828392156862745f, 0.4588549019607844f}, 
							 {0.9882352941176471f, 0.5821960784313726f, 0.4581176470588235f}, 
							 {0.9882352941176471f, 0.5815529411764706f, 0.45738039215686277f}, 
							 {0.9882352941176471f, 0.5809098039215685f, 0.456643137254902f}, 
							 {0.9882352941176471f, 0.5802666666666666f, 0.4559058823529412f}, 
							 {0.9882352941176471f, 0.5796235294117646f, 0.4551686274509804f}, 
							 {0.9882352941176471f, 0.5789803921568627f, 0.45443137254901966f}, 
							 {0.9882352941176471f, 0.5783372549019608f, 0.45369411764705886f}, 
							 {0.9882352941176471f, 0.5776941176470588f, 0.45295686274509805f}, 
							 {0.9882352941176471f, 0.5770509803921569f, 0.4522196078431373f}, 
							 {0.9882352941176471f, 0.5764078431372549f, 0.4514823529411765f}, 
							 {0.9882352941176471f, 0.575764705882353f, 0.4507450980392157f}, 
							 {0.9882352941176471f, 0.5751215686274509f, 0.45000784313725495f}, 
							 {0.9882352941176471f, 0.574478431372549f, 0.44927058823529414f}, 
							 {0.9882352941176471f, 0.573835294117647f, 0.44853333333333334f}, 
							 {0.9882352941176471f, 0.573192156862745f, 0.4477960784313726f}, 
							 {0.9882352941176471f, 0.5725490196078431f, 0.4470588235294118f}, 
							 {0.9882196078431373f, 0.5719215686274509f, 0.44643137254901966f}, 
							 {0.9882039215686275f, 0.5712941176470588f, 0.44580392156862747f}, 
							 {0.9881882352941177f, 0.5706666666666667f, 0.44517647058823534f}, 
							 {0.9881725490196079f, 0.5700392156862745f, 0.44454901960784315f}, 
							 {0.9881568627450981f, 0.5694117647058823f, 0.443921568627451f}, 
							 {0.9881411764705883f, 0.5687843137254902f, 0.44329411764705884f}, 
							 {0.9881254901960784f, 0.568156862745098f, 0.4426666666666667f}, 
							 {0.9881098039215687f, 0.5675294117647058f, 0.4420392156862745f}, 
							 {0.9880941176470589f, 0.5669019607843137f, 0.4414117647058824f}, 
							 {0.988078431372549f, 0.5662745098039216f, 0.4407843137254902f}, 
							 {0.9880627450980393f, 0.5656470588235294f, 0.4401568627450981f}, 
							 {0.9880470588235295f, 0.5650196078431372f, 0.4395294117647059f}, 
							 {0.9880313725490196f, 0.564392156862745f, 0.43890196078431376f}, 
							 {0.9880156862745099f, 0.563764705882353f, 0.4382745098039216f}, 
							 {0.988f, 0.5631372549019608f, 0.43764705882352944f}, 
							 {0.9879843137254902f, 0.5625098039215686f, 0.43701960784313726f}, 
							 {0.9879686274509805f, 0.5618823529411764f, 0.43639215686274513f}, 
							 {0.9879529411764706f, 0.5612549019607843f, 0.43576470588235294f}, 
							 {0.9879372549019608f, 0.5606274509803921f, 0.4351372549019608f}, 
							 {0.9879215686274511f, 0.5599999999999999f, 0.4345098039215686f}, 
							 {0.9879058823529412f, 0.5593725490196078f, 0.4338823529411765f}, 
							 {0.9878901960784314f, 0.5587450980392157f, 0.4332549019607843f}, 
							 {0.9878745098039216f, 0.5581176470588235f, 0.4326274509803922f}, 
							 {0.9878588235294118f, 0.5574901960784313f, 0.432f}, 
							 {0.987843137254902f, 0.5568627450980391f, 0.43137254901960786f}, 
							 {0.9878274509803922f, 0.556235294117647f, 0.4307450980392157f}, 
							 {0.9878117647058824f, 0.5556078431372549f, 0.43011764705882355f}, 
							 {0.9877960784313726f, 0.5549803921568627f, 0.42949019607843136f}, 
							 {0.9877803921568628f, 0.5543529411764705f, 0.42886274509803923f}, 
							 {0.987764705882353f, 0.5537254901960784f, 0.42823529411764705f}, 
							 {0.9877490196078431f, 0.5530980392156862f, 0.4276078431372549f}, 
							 {0.9877333333333334f, 0.552470588235294f, 0.42698039215686273f}, 
							 {0.9877176470588236f, 0.5518431372549019f, 0.4263529411764706f}, 
							 {0.9877019607843137f, 0.5512156862745098f, 0.4257254901960784f}, 
							 {0.987686274509804f, 0.5505882352941176f, 0.4250980392156863f}, 
							 {0.9876705882352942f, 0.5499607843137254f, 0.4244705882352941f}, 
							 {0.9876549019607843f, 0.5493333333333332f, 0.42384313725490197f}, 
							 {0.9876392156862746f, 0.5487058823529412f, 0.4232156862745098f}, 
							 {0.9876235294117647f, 0.548078431372549f, 0.42258823529411765f}, 
							 {0.9876078431372549f, 0.5474509803921568f, 0.42196078431372547f}, 
							 {0.9875921568627452f, 0.5468235294117647f, 0.42133333333333334f}, 
							 {0.9875764705882353f, 0.5461960784313725f, 0.42070588235294115f}, 
							 {0.9875607843137255f, 0.5455686274509803f, 0.420078431372549f}, 
							 {0.9875450980392158f, 0.5449411764705882f, 0.41945098039215684f}, 
							 {0.9875294117647059f, 0.5443137254901961f, 0.4188235294117647f}, 
							 {0.9875137254901961f, 0.5436862745098039f, 0.4181960784313725f}, 
							 {0.9874980392156864f, 0.5430588235294117f, 0.4175686274509804f}, 
							 {0.9874823529411765f, 0.5424313725490195f, 0.41694117647058826f}, 
							 {0.9874666666666667f, 0.5418039215686274f, 0.4163137254901961f}, 
							 {0.9874509803921568f, 0.5411764705882353f, 0.4156862745098039f}, 
							 {0.9874352941176471f, 0.5405490196078431f, 0.41505882352941176f}, 
							 {0.9874196078431373f, 0.5399215686274509f, 0.4144313725490196f}, 
							 {0.9874039215686274f, 0.5392941176470588f, 0.41380392156862744f}, 
							 {0.9873882352941177f, 0.5386666666666666f, 0.41317647058823526f}, 
							 {0.9873725490196079f, 0.5380392156862744f, 0.4125490196078431f}, 
							 {0.987356862745098f, 0.5374117647058823f, 0.411921568627451f}, 
							 {0.9873411764705883f, 0.5367843137254902f, 0.4112941176470588f}, 
							 {0.9873254901960784f, 0.536156862745098f, 0.4106666666666667f}, 
							 {0.9873098039215686f, 0.5355294117647058f, 0.4100392156862745f}, 
							 {0.9872941176470589f, 0.5349019607843136f, 0.40941176470588236f}, 
							 {0.987278431372549f, 0.5342745098039215f, 0.4087843137254902f}, 
							 {0.9872627450980392f, 0.5336470588235294f, 0.40815686274509805f}, 
							 {0.9872470588235295f, 0.5330196078431372f, 0.40752941176470586f}, 
							 {0.9872313725490196f, 0.532392156862745f, 0.40690196078431373f}, 
							 {0.9872156862745098f, 0.5317647058823529f, 0.40627450980392155f}, 
							 {0.9872f, 0.5311372549019607f, 0.4056470588235294f}, 
							 {0.9871843137254902f, 0.5305098039215685f, 0.40501960784313723f}, 
							 {0.9871686274509804f, 0.5298823529411765f, 0.4043921568627451f}, 
							 {0.9871529411764706f, 0.5292549019607843f, 0.4037647058823529f}, 
							 {0.9871372549019608f, 0.5286274509803921f, 0.4031372549019608f}, 
							 {0.987121568627451f, 0.5279999999999999f, 0.4025098039215686f}, 
							 {0.9871058823529412f, 0.5273725490196077f, 0.40188235294117647f}, 
							 {0.9870901960784314f, 0.5267450980392157f, 0.4012549019607843f}, 
							 {0.9870745098039215f, 0.5261176470588235f, 0.40062745098039215f}, 
							 {0.9870588235294118f, 0.5254901960784313f, 0.39999999999999997f}, 
							 {0.987043137254902f, 0.5248627450980392f, 0.39937254901960784f}, 
							 {0.9870274509803921f, 0.524235294117647f, 0.39874509803921565f}, 
							 {0.9870117647058824f, 0.5236078431372548f, 0.3981176470588235f}, 
							 {0.9869960784313726f, 0.5229803921568627f, 0.39749019607843133f}, 
							 {0.9869803921568627f, 0.5223529411764706f, 0.3968627450980392f}, 
							 {0.986964705882353f, 0.5217254901960784f, 0.396235294117647f}, 
							 {0.9869490196078431f, 0.5210980392156862f, 0.3956078431372549f}, 
							 {0.9869333333333333f, 0.5204705882352941f, 0.3949803921568628f}, 
							 {0.9869176470588236f, 0.5198431372549019f, 0.39435294117647063f}, 
							 {0.9869019607843137f, 0.5192156862745099f, 0.3937254901960785f}, 
							 {0.9868862745098039f, 0.5185882352941177f, 0.3930980392156863f}, 
							 {0.9868705882352942f, 0.5179607843137255f, 0.3924705882352942f}, 
							 {0.9868549019607843f, 0.5173333333333333f, 0.391843137254902f}, 
							 {0.9868392156862745f, 0.5167058823529411f, 0.39121568627450987f}, 
							 {0.9868235294117648f, 0.516078431372549f, 0.3905882352941177f}, 
							 {0.9868078431372549f, 0.5154509803921569f, 0.38996078431372555f}, 
							 {0.9867921568627451f, 0.5148235294117647f, 0.38933333333333336f}, 
							 {0.9867764705882353f, 0.5141960784313726f, 0.38870588235294123f}, 
							 {0.9867607843137255f, 0.5135686274509804f, 0.38807843137254905f}, 
							 {0.9867450980392157f, 0.5129411764705882f, 0.3874509803921569f}, 
							 {0.9867294117647059f, 0.512313725490196f, 0.38682352941176473f}, 
							 {0.9867137254901961f, 0.511686274509804f, 0.3861960784313726f}, 
							 {0.9866980392156863f, 0.5110588235294118f, 0.3855686274509804f}, 
							 {0.9866823529411765f, 0.5104313725490196f, 0.3849411764705883f}, 
							 {0.9866666666666667f, 0.5098039215686274f, 0.3843137254901961f}, 
							 {0.9866509803921568f, 0.5091764705882353f, 0.38368627450980397f}, 
							 {0.986635294117647f, 0.5085490196078432f, 0.3830588235294118f}, 
							 {0.9866196078431373f, 0.507921568627451f, 0.38243137254901965f}, 
							 {0.9866039215686274f, 0.5072941176470588f, 0.38180392156862747f}, 
							 {0.9865882352941177f, 0.5066666666666667f, 0.38117647058823534f}, 
							 {0.9865725490196079f, 0.5060392156862745f, 0.38054901960784315f}, 
							 {0.986556862745098f, 0.5054117647058823f, 0.379921568627451f}, 
							 {0.9865411764705883f, 0.5047843137254902f, 0.37929411764705884f}, 
							 {0.9865254901960784f, 0.5041568627450981f, 0.3786666666666667f}, 
							 {0.9865098039215686f, 0.5035294117647059f, 0.3780392156862745f}, 
							 {0.9864941176470589f, 0.5029019607843137f, 0.3774117647058824f}, 
							 {0.986478431372549f, 0.5022745098039215f, 0.3767843137254902f}, 
							 {0.9864627450980392f, 0.5016470588235294f, 0.3761568627450981f}, 
							 {0.9864470588235295f, 0.5010196078431373f, 0.3755294117647059f}, 
							 {0.9864313725490196f, 0.5003921568627451f, 0.37490196078431376f}, 
							 {0.9864156862745098f, 0.49976470588235294f, 0.37427450980392163f}, 
							 {0.9863999999999999f, 0.4991372549019608f, 0.37364705882352944f}, 
							 {0.9863843137254902f, 0.49850980392156863f, 0.37301960784313726f}, 
							 {0.9863686274509804f, 0.49788235294117644f, 0.3723921568627451f}, 
							 {0.9863529411764705f, 0.4972549019607843f, 0.371764705882353f}, 
							 {0.9863372549019608f, 0.4966274509803922f, 0.3711372549019608f}, 
							 {0.986321568627451f, 0.496f, 0.3705098039215686f}, 
							 {0.9863058823529411f, 0.4953725490196078f, 0.3698823529411765f}, 
							 {0.9862901960784314f, 0.4947450980392157f, 0.36925490196078437f}, 
							 {0.9862745098039216f, 0.49411764705882355f, 0.3686274509803922f}, 
							 {0.9862588235294117f, 0.49349019607843136f, 0.368f}, 
							 {0.986243137254902f, 0.4928627450980392f, 0.36737254901960786f}, 
							 {0.9862274509803921f, 0.49223529411764705f, 0.36674509803921573f}, 
							 {0.9862117647058823f, 0.4916078431372549f, 0.36611764705882355f}, 
							 {0.9861960784313726f, 0.49098039215686273f, 0.36549019607843136f}, 
							 {0.9861803921568627f, 0.49035294117647055f, 0.36486274509803923f}, 
							 {0.9861647058823529f, 0.4897254901960784f, 0.3642352941176471f}, 
							 {0.9861490196078432f, 0.4890980392156863f, 0.3636078431372549f}, 
							 {0.9861333333333333f, 0.4884705882352941f, 0.36298039215686273f}, 
							 {0.9861176470588235f, 0.48784313725490197f, 0.3623529411764706f}, 
							 {0.9861019607843137f, 0.4872156862745098f, 0.36172549019607847f}, 
							 {0.9860862745098039f, 0.48658823529411765f, 0.3610980392156863f}, 
							 {0.9860705882352941f, 0.48596078431372547f, 0.36047058823529415f}, 
							 {0.9860549019607843f, 0.48533333333333334f, 0.35984313725490197f}, 
							 {0.9860392156862745f, 0.48470588235294115f, 0.35921568627450984f}, 
							 {0.9860235294117647f, 0.484078431372549f, 0.35858823529411765f}, 
							 {0.9860078431372549f, 0.48345098039215684f, 0.3579607843137255f}, 
							 {0.9859921568627451f, 0.4828235294117647f, 0.35733333333333334f}, 
							 {0.9859764705882352f, 0.4821960784313725f, 0.3567058823529412f}, 
							 {0.9859607843137255f, 0.4815686274509804f, 0.356078431372549f}, 
							 {0.9859450980392157f, 0.4809411764705882f, 0.3554509803921569f}, 
							 {0.9859294117647058f, 0.4803137254901961f, 0.3548235294117647f}, 
							 {0.9859137254901961f, 0.4796862745098039f, 0.3541960784313726f}, 
							 {0.9858980392156863f, 0.47905882352941176f, 0.3535686274509804f}, 
							 {0.9858823529411764f, 0.4784313725490196f, 0.35294117647058826f}, 
							 {0.9858666666666667f, 0.47780392156862744f, 0.3523137254901961f}, 
							 {0.9858509803921568f, 0.4771764705882353f, 0.35168627450980394f}, 
							 {0.985835294117647f, 0.4765490196078431f, 0.35105882352941176f}, 
							 {0.9858196078431373f, 0.47592156862745094f, 0.3504313725490196f}, 
							 {0.9858039215686274f, 0.4752941176470588f, 0.34980392156862744f}, 
							 {0.9857882352941176f, 0.4746666666666667f, 0.3491764705882353f}, 
							 {0.9857725490196079f, 0.4740392156862745f, 0.3485490196078431f}, 
							 {0.985756862745098f, 0.4734117647058823f, 0.347921568627451f}, 
							 {0.9857411764705882f, 0.4727843137254902f, 0.3472941176470588f}, 
							 {0.9857254901960784f, 0.47215686274509805f, 0.3466666666666667f}, 
							 {0.9857098039215686f, 0.47152941176470586f, 0.3460392156862745f}, 
							 {0.9856941176470588f, 0.4709019607843137f, 0.34541176470588236f}, 
							 {0.985678431372549f, 0.47027450980392155f, 0.34478431372549023f}, 
							 {0.9856627450980392f, 0.4696470588235294f, 0.34415686274509805f}, 
							 {0.9856470588235294f, 0.46901960784313723f, 0.34352941176470586f}, 
							 {0.9856313725490196f, 0.46839215686274505f, 0.34290196078431373f}, 
							 {0.9856156862745098f, 0.4677647058823529f, 0.3422745098039216f}, 
							 {0.9856f, 0.4671372549019608f, 0.3416470588235294f}, 
							 {0.9855843137254902f, 0.4665098039215686f, 0.34101960784313723f}, 
							 {0.9855686274509804f, 0.46588235294117647f, 0.3403921568627451f}, 
							 {0.9855529411764705f, 0.4652549019607843f, 0.33976470588235297f}, 
							 {0.9855372549019608f, 0.46462745098039215f, 0.3391372549019608f}, 
							 {0.985521568627451f, 0.46399999999999997f, 0.3385098039215686f}, 
							 {0.9855058823529411f, 0.46337254901960784f, 0.33788235294117647f}, 
							 {0.9854901960784314f, 0.46274509803921565f, 0.33725490196078434f}, 
							 {0.9854745098039216f, 0.4621176470588235f, 0.33662745098039215f}, 
							 {0.9854588235294117f, 0.46149019607843134f, 0.33599999999999997f}, 
							 {0.985443137254902f, 0.4608627450980392f, 0.33537254901960784f}, 
							 {0.9854274509803921f, 0.460235294117647f, 0.3347450980392157f}, 
							 {0.9854117647058823f, 0.4596078431372549f, 0.3341176470588235f}, 
							 {0.9853960784313726f, 0.4589803921568627f, 0.33349019607843133f}, 
							 {0.9853803921568627f, 0.4583529411764706f, 0.3328627450980392f}, 
							 {0.9853647058823529f, 0.4577254901960784f, 0.3322352941176471f}, 
							 {0.9853490196078432f, 0.45709803921568626f, 0.3316078431372549f}, 
							 {0.9853333333333333f, 0.4564705882352941f, 0.3309803921568627f}, 
							 {0.9853176470588235f, 0.45584313725490194f, 0.33035294117647057f}, 
							 {0.9853019607843136f, 0.45521568627450976f, 0.32972549019607844f}, 
							 {0.9852862745098039f, 0.4545882352941176f, 0.32909803921568626f}, 
							 {0.9852705882352941f, 0.45396078431372544f, 0.3284705882352941f}, 
							 {0.9852549019607842f, 0.4533333333333333f, 0.32784313725490194f}, 
							 {0.9852392156862745f, 0.4527058823529412f, 0.3272156862745098f}, 
							 {0.9852235294117647f, 0.452078431372549f, 0.3265882352941176f}, 
							 {0.9852078431372548f, 0.4514509803921568f, 0.3259607843137255f}, 
							 {0.9851921568627451f, 0.4508235294117647f, 0.3253333333333333f}, 
							 {0.9851764705882352f, 0.45019607843137255f, 0.3247058823529412f}, 
							 {0.9851607843137254f, 0.44956862745098036f, 0.324078431372549f}, 
							 {0.9851450980392157f, 0.4489411764705882f, 0.32345098039215686f}, 
							 {0.9851294117647058f, 0.44831372549019605f, 0.3228235294117647f}, 
							 {0.985113725490196f, 0.4476862745098039f, 0.32219607843137255f}, 
							 {0.9850980392156863f, 0.44705882352941173f, 0.32156862745098036f}, 
							 {0.9850823529411764f, 0.44643137254901955f, 0.32094117647058823f}, 
							 {0.9850666666666666f, 0.4458039215686274f, 0.3203137254901961f}, 
							 {0.9850509803921568f, 0.4451764705882353f, 0.3196862745098039f}, 
							 {0.985035294117647f, 0.4445490196078431f, 0.31905882352941173f}, 
							 {0.9850196078431372f, 0.4439215686274509f, 0.3184313725490196f}, 
							 {0.9850039215686274f, 0.4432941176470588f, 0.31780392156862747f}, 
							 {0.9849882352941176f, 0.44266666666666665f, 0.3171764705882353f}, 
							 {0.9849725490196078f, 0.44203921568627447f, 0.3165490196078431f}, 
							 {0.984956862745098f, 0.4414117647058823f, 0.31592156862745097f}, 
							 {0.9849411764705882f, 0.4407843137254902f, 0.31529411764705884f}, 
							 {0.9849254901960784f, 0.4401568627450981f, 0.3146666666666667f}, 
							 {0.9849098039215686f, 0.43952941176470595f, 0.3140392156862746f}, 
							 {0.9848941176470588f, 0.43890196078431376f, 0.3134117647058824f}, 
							 {0.9848784313725489f, 0.4382745098039216f, 0.3127843137254902f}, 
							 {0.9848627450980392f, 0.43764705882352944f, 0.3121568627450981f}, 
							 {0.9848470588235294f, 0.4370196078431373f, 0.31152941176470594f}, 
							 {0.9848313725490195f, 0.43639215686274513f, 0.31090196078431376f}, 
							 {0.9848156862745098f, 0.43576470588235294f, 0.31027450980392157f}, 
							 {0.9848f, 0.4351372549019608f, 0.30964705882352944f}, 
							 {0.9847843137254901f, 0.4345098039215687f, 0.3090196078431373f}, 
							 {0.9847686274509804f, 0.4338823529411765f, 0.3083921568627451f}, 
							 {0.9847529411764705f, 0.4332549019607843f, 0.30776470588235294f}, 
							 {0.9847372549019607f, 0.4326274509803922f, 0.3071372549019608f}, 
							 {0.984721568627451f, 0.43200000000000005f, 0.3065098039215687f}, 
							 {0.9847058823529411f, 0.43137254901960786f, 0.3058823529411765f}, 
							 {0.9846901960784313f, 0.4307450980392157f, 0.30525490196078436f}, 
							 {0.9846745098039216f, 0.43011764705882355f, 0.30462745098039223f}, 
							 {0.9846588235294117f, 0.4294901960784314f, 0.30400000000000005f}, 
							 {0.9846431372549019f, 0.42886274509803923f, 0.30337254901960786f}, 
							 {0.9846274509803921f, 0.42823529411764705f, 0.30274509803921573f}, 
							 {0.9846117647058823f, 0.4276078431372549f, 0.3021176470588236f}, 
							 {0.9845960784313725f, 0.4269803921568628f, 0.3014901960784314f}, 
							 {0.9845803921568627f, 0.4263529411764706f, 0.30086274509803923f}, 
							 {0.9845647058823529f, 0.42572549019607847f, 0.3002352941176471f}, 
							 {0.9845490196078431f, 0.42509803921568634f, 0.29960784313725497f}, 
							 {0.9845333333333333f, 0.42447058823529416f, 0.2989803921568628f}, 
							 {0.9845176470588235f, 0.42384313725490197f, 0.2983529411764706f}, 
							 {0.9845019607843136f, 0.42321568627450984f, 0.29772549019607847f}, 
							 {0.9844862745098039f, 0.4225882352941177f, 0.29709803921568634f}, 
							 {0.9844705882352941f, 0.4219607843137255f, 0.29647058823529415f}, 
							 {0.9844549019607842f, 0.42133333333333334f, 0.29584313725490197f}, 
							 {0.9844392156862745f, 0.4207058823529412f, 0.29521568627450984f}, 
							 {0.9844235294117647f, 0.4200784313725491f, 0.2945882352941177f}, 
							 {0.9844078431372548f, 0.4194509803921569f, 0.2939607843137255f}, 
							 {0.9843921568627451f, 0.4188235294117647f, 0.29333333333333333f}, 
							 {0.9843764705882352f, 0.4181960784313726f, 0.2927058823529412f}, 
							 {0.9843607843137254f, 0.41756862745098045f, 0.2920784313725491f}, 
							 {0.9843450980392157f, 0.41694117647058826f, 0.2914509803921569f}, 
							 {0.9843294117647058f, 0.4163137254901961f, 0.2908235294117647f}, 
							 {0.984313725490196f, 0.41568627450980394f, 0.2901960784313726f}};

/*
  Map[List @@ # &, 
  Table[Blend[
  Map[(RGBColor@(#/255.)) &, {{255, 114, 0}, {245, 119, 23}, {65, 
  179, 220}, {236, 0, 140}, {6, 122, 180}, {12, 37, 119}, {129, 
  1, 26}, {198, 212, 61}, {110, 187, 31}, {179, 10, 60}, {128, 
  128, 128}}], i/1001], {i, 0, 1000}]] >> /tmp/111
*/

float palette_adam_blend[1001][3]={{1.f, 0.44705882352941173f, 0.f}, 
				   {0.9996082349023525f, 0.4472547060782355f,   0.0009010597245891363f}, 
				   {0.9992164698047051f, 0.44745058862705916f,   0.0018021194491782725f}, 
				   {0.9988247047070576f, 0.4476464711758829f,   0.002703179173767409f}, 
				   {0.9984329396094102f, 0.44784235372470665f,   0.003604238898356545f}, 
				   {0.9980411745117628f, 0.44803823627353034f,   0.004505298622945682f}, 
				   {0.9976494094141153f, 0.4482341188223541f,   0.005406358347534818f}, 
				   {0.9972576443164678f, 0.44843000137117783f,   0.006307418072123954f}, 
				   {0.9968658792188204f, 0.4486258839200015f,   0.00720847779671309f}, 
				   {0.9964741141211729f, 0.44882176646882527f,   0.008109537521302227f}, 
				   {0.9960823490235255f, 0.449017649017649f,   0.009010597245891363f}, 
				   {0.9956905839258781f, 0.4492135315664727f,   0.0099116569704805f}, 
				   {0.9952988188282306f, 0.44940941411529645f,   0.010812716695069636f}, 
				   {0.9949070537305832f, 0.4496052966641202f,   0.011713776419658772f}, 
				   {0.9945152886329357f, 0.4498011792129439f,   0.012614836144247908f}, 
				   {0.9941235235352882f, 0.4499970617617676f,   0.013515895868837044f}, 
				   {0.9937317584376408f, 0.4501929443105913f,   0.01441695559342618f}, 
				   {0.9933399933399933f, 0.45038882685941506f,   0.015318015318015318f}, 
				   {0.9929482282423459f, 0.4505847094082388f,   0.016219075042604454f}, 
				   {0.9925564631446985f, 0.4507805919570625f,   0.01712013476719359f}, 
				   {0.992164698047051f, 0.45097647450588624f,   0.018021194491782726f}, 
				   {0.9917729329494035f, 0.45117235705471f,   0.01892225421637186f}, 
				   {0.9913811678517561f, 0.45136823960353367f,   0.019823313940961f}, 
				   {0.9909894027541086f, 0.4515641221523574f,   0.020724373665550133f}, 
				   {0.9905976376564611f, 0.45176000470118116f,   0.02162543339013927f}, 
				   {0.9902058725588138f, 0.45195588725000485f,   0.02252649311472841f}, 
				   {0.9898141074611663f, 0.4521517697988286f,   0.023427552839317543f}, 
				   {0.9894223423635189f, 0.45234765234765234f,   0.024328612563906678f}, 
				   {0.9890305772658714f, 0.45254353489647603f,   0.025229672288495816f}, 
				   {0.9886388121682239f, 0.4527394174452998f,   0.026130732013084954f}, 
				   {0.9882470470705765f, 0.4529352999941235f,   0.027031791737674088f}, 
				   {0.987855281972929f, 0.4531311825429472f,   0.027932851462263222f}, 
				   {0.9874635168752816f, 0.45332706509177095f,   0.02883391118685236f}, 
				   {0.9870717517776342f, 0.4535229476405947f,   0.029734970911441498f}, 
				   {0.9866799866799867f, 0.4537188301894184f,   0.030636030636030636f}, 
				   {0.9862882215823392f, 0.45391471273824213f,   0.031537090360619774f}, 
				   {0.9858964564846918f, 0.4541105952870659f,   0.03243815008520891f}, 
				   {0.9855046913870443f, 0.45430647783588957f,   0.033339209809798036f}, 
				   {0.9851129262893968f, 0.4545023603847133f,   0.03424026953438718f}, 
				   {0.9847211611917495f, 0.45469824293353706f,   0.03514132925897631f}, 
				   {0.984329396094102f, 0.45489412548236074f,   0.03604238898356545f}, 
				   {0.9839376309964545f, 0.4550900080311845f,   0.03694344870815459f}, 
				   {0.9835458658988071f, 0.45528589058000823f,   0.03784450843274372f}, 
				   {0.9831541008011596f, 0.4554817731288319f,   0.03874556815733286f}, 
				   {0.9827623357035122f, 0.45567765567765567f,   0.039646627881922f}, 
				   {0.9823705706058647f, 0.4558735382264794f,   0.04054768760651113f}, 
				   {0.9819788055082173f, 0.4560694207753031f,   0.041448747331100266f}, 
				   {0.9815870404105699f, 0.45626530332412685f,   0.0423498070556894f}, 
				   {0.9811952753129224f, 0.4564611858729506f,   0.04325086678027854f}, 
				   {0.9808035102152749f, 0.4566570684217743f,   0.044151926504867677f}, 
				   {0.9804117451176275f, 0.456852950970598f,   0.04505298622945682f}, 
				   {0.98001998001998f, 0.4570488335194217f,   0.04595404595404595f}, 
				   {0.9796282149223325f, 0.45724471606824546f,   0.04685510567863509f}, 
				   {0.9792364498246852f, 0.4574405986170692f,   0.04775616540322422f}, 
				   {0.9788446847270377f, 0.4576364811658929f,   0.048657225127813356f}, 
				   {0.9784529196293902f, 0.45783236371471664f,   0.04955828485240249f}, 
				   {0.9780611545317428f, 0.4580282462635404f,   0.05045934457699163f}, 
				   {0.9776693894340953f, 0.4582241288123641f,   0.051360404301580766f}, 
				   {0.9772776243364478f, 0.4584200113611878f,   0.05226146402616991f}, 
				   {0.9768858592388004f, 0.45861589391001156f,   0.05316252375075904f}, 
				   {0.976494094141153f, 0.45881177645883525f,   0.054063583475348176f}, 
				   {0.9761023290435056f, 0.459007659007659f,   0.05496464319993731f}, 
				   {0.9757105639458581f, 0.45920354155648274f,   0.055865702924526445f}, 
				   {0.9753187988482106f, 0.45939942410530643f,   0.05676676264911559f}, 
				   {0.9749270337505632f, 0.4595953066541302f,   0.05766782237370472f}, 
				   {0.9745352686529157f, 0.4597911892029539f,   0.05856888209829385f}, 
				   {0.9741435035552682f, 0.4599870717517776f,   0.059469941822882996f}, 
				   {0.9737517384576209f, 0.46018295430060135f,   0.060371001547472124f}, 
				   {0.9733599733599734f, 0.4603788368494251f,   0.06127206127206127f}, 
				   {0.9729682082623259f, 0.4605747193982488f,   0.0621731209966504f}, 
				   {0.9725764431646785f, 0.46077060194707253f,   0.06307418072123955f}, 
				   {0.972184678067031f, 0.4609664844958963f,   0.06397524044582867f}, 
				   {0.9717929129693835f, 0.46116236704471997f,   0.06487630017041782f}, 
				   {0.9714011478717361f, 0.4613582495935437f,   0.06577735989500695f}, 
				   {0.9710093827740887f, 0.46155413214236746f,   0.06667841961959607f}, 
				   {0.9706176176764412f, 0.46175001469119115f,   0.06757947934418522f}, 
				   {0.9702258525787938f, 0.4619458972400149f,   0.06848053906877435f}, 
				   {0.9698340874811463f, 0.46214177978883864f,   0.0693815987933635f}, 
				   {0.9694423223834989f, 0.4623376623376623f,   0.07028265851795262f}, 
				   {0.9690505572858514f, 0.46253354488648607f,   0.07118371824254177f}, 
				   {0.9686587921882039f, 0.46272942743530976f,   0.0720847779671309f}, 
				   {0.9682670270905566f, 0.4629253099841335f,   0.07298583769172003f}, 
				   {0.9678752619929091f, 0.46312119253295725f,   0.07388689741630917f}, 
				   {0.9674834968952616f, 0.46331707508178094f,   0.07478795714089831f}, 
				   {0.9670917317976142f, 0.4635129576306047f,   0.07568901686548744f}, 
				   {0.9666999666999667f, 0.4637088401794284f,   0.07659007659007658f}, 
				   {0.9663082016023192f, 0.4639047227282521f,   0.07749113631466573f}, 
				   {0.9659164365046718f, 0.46410060527707586f,   0.07839219603925485f}, 
				   {0.9655246714070244f, 0.4642964878258996f,   0.079293255763844f}, 
				   {0.965132906309377f, 0.4644923703747233f,   0.08019431548843313f}, 
				   {0.9647411412117295f, 0.46468825292354704f,   0.08109537521302226f}, 
				   {0.964349376114082f, 0.4648841354723708f,   0.0819964349376114f}, 
				   {0.9639576110164346f, 0.4650800180211945f,   0.08289749466220053f}, 
				   {0.9635658459187871f, 0.4652759005700182f,   0.08379855438678968f}, 
				   {0.9631740808211396f, 0.46547178311884196f,   0.0846996141113788f}, 
				   {0.9627823157234923f, 0.46566766566766565f,   0.08560067383596795f}, 
				   {0.9623905506258448f, 0.4658635482164894f,   0.08650173356055708f}, 
				   {0.9619987855281973f, 0.46605943076531314f,   0.0874027932851462f}, 
				   {0.9616070204305499f, 0.46625531331413683f,   0.08830385300973535f}, 
				   {0.9612152553329024f, 0.4664511958629606f,   0.08920491273432449f}, 
				   {0.9608234902352549f, 0.4666470784117843f,   0.09010597245891364f}, 
				   {0.9544377191436015f, 0.4687821981939629f,   0.09714207361266185f}, 
				   {0.9473859473859474f, 0.4711327887798476f,   0.10485984603631662f}, 
				   {0.9403341756282934f, 0.4734833793657323f,   0.1125776184599714f}, 
				   {0.9332824038706392f, 0.47583396995161703f,   0.12029539088362617f}, 
				   {0.9262306321129851f, 0.4781845605375017f,   0.12801316330728096f}, 
				   {0.919178860355331f, 0.4805351511233864f,   0.13573093573093573f}, 
				   {0.9121270885976769f, 0.4828857417092711f,   0.14344870815459052f}, 
				   {0.9050753168400227f, 0.48523633229515584f,   0.15116648057824528f}, 
				   {0.8980235450823686f, 0.48758692288104055f,   0.15888425300190007f}, 
				   {0.8909717733247146f, 0.4899375134669252f,   0.16660202542555483f}, 
				   {0.8839200015670604f, 0.4922881040528099f,   0.17431979784920962f}, 
				   {0.8768682298094064f, 0.49463869463869464f,   0.18203757027286438f}, 
				   {0.8698164580517522f, 0.49698928522457936f,   0.18975534269651917f}, 
				   {0.8627646862940981f, 0.499339875810464f,   0.19747311512017396f}, 
				   {0.8557129145364439f, 0.5016904663963487f,   0.20519088754382872f}, 
				   {0.8486611427787899f, 0.5040410569822334f,   0.2129086599674835f}, 
				   {0.8416093710211358f, 0.5063916475681182f,   0.22062643239113827f}, 
				   {0.8345575992634817f, 0.5087422381540029f,   0.22834420481479306f}, 
				   {0.8275058275058276f, 0.5110928287398876f,   0.23606197723844785f}, 
				   {0.8204540557481734f, 0.5134434193257723f,   0.24377974966210264f}, 
				   {0.8134022839905193f, 0.5157940099116569f,   0.2514975220857574f}, 
				   {0.8063505122328652f, 0.5181446004975416f,   0.25921529450941216f}, 
				   {0.7992987404752111f, 0.5204951910834263f,   0.26693306693306695f}, 
				   {0.792246968717557f, 0.5228457816693111f,   0.27465083935672174f}, 
				   {0.7851951969599029f, 0.5251963722551958f,   0.2823686117803765f}, 
				   {0.7781434252022488f, 0.5275469628410805f,   0.29008638420403127f}, 
				   {0.7710916534445946f, 0.5298975534269652f,   0.29780415662768606f}, 
				   {0.7640398816869405f, 0.5322481440128499f,   0.30552192905134085f}, 
				   {0.7569881099292864f, 0.5345987345987346f,   0.3132397014749956f}, 
				   {0.7499363381716323f, 0.5369493251846192f,   0.32095747389865037f}, 
				   {0.7428845664139783f, 0.539299915770504f,   0.32867524632230516f}, 
				   {0.7358327946563241f, 0.5416505063563887f,   0.3363930187459599f}, 
				   {0.72878102289867f, 0.5440010969422734f,   0.3441107911696147f}, 
				   {0.7217292511410158f, 0.5463516875281581f,   0.35182856359326947f}, 
				   {0.7146774793833618f, 0.5487022781140428f,   0.35954633601692426f}, 
				   {0.7076257076257076f, 0.5510528686999275f,   0.36726410844057905f}, 
				   {0.7005739358680536f, 0.5534034592858122f,   0.37498188086423384f}, 
				   {0.6935221641103995f, 0.5557540498716969f,   0.38269965328788863f}, 
				   {0.6864703923527453f, 0.5581046404575816f,   0.39041742571154336f}, 
				   {0.6794186205950912f, 0.5604552310434663f,   0.39813519813519815f}, 
				   {0.6723668488374371f, 0.562805821629351f,   0.40585297055885294f}, 
				   {0.665315077079783f, 0.5651564122152357f,   0.4135707429825077f}, 
				   {0.658263305322129f, 0.5675070028011204f,   0.42128851540616247f}, 
				   {0.6512115335644748f, 0.5698575933870051f,   0.42900628782981726f}, 
				   {0.6441597618068207f, 0.5722081839728899f,   0.43672406025347205f}, 
				   {0.6371079900491665f, 0.5745587745587746f,   0.44444183267712684f}, 
				   {0.6300562182915125f, 0.5769093651446592f,   0.45215960510078157f}, 
				   {0.6230044465338583f, 0.5792599557305439f,   0.45987737752443636f}, 
				   {0.6159526747762043f, 0.5816105463164286f,   0.46759514994809115f}, 
				   {0.6089009030185502f, 0.5839611369023133f,   0.47531292237174594f}, 
				   {0.601849131260896f, 0.586311727488198f,   0.4830306947954007f}, 
				   {0.5947973595032419f, 0.5886623180740828f,   0.49074846721905546f}, 
				   {0.5877455877455877f, 0.5910129086599675f,   0.49846623964271025f}, 
				   {0.5806938159879336f, 0.5933634992458522f,   0.506184012066365f}, 
				   {0.5736420442302796f, 0.5957140898317368f,   0.5139017844900198f}, 
				   {0.5665902724726255f, 0.5980646804176215f,   0.5216195569136746f}, 
				   {0.5595385007149714f, 0.6004152710035062f,   0.5293373293373294f}, 
				   {0.5524867289573172f, 0.6027658615893909f,   0.5370551017609841f}, 
				   {0.5454349571996631f, 0.6051164521752757f,   0.5447728741846389f}, 
				   {0.538383185442009f, 0.6074670427611604f,   0.5524906466082936f}, 
				   {0.5313314136843549f, 0.6098176333470451f,   0.5602084190319484f}, 
				   {0.5242796419267008f, 0.6121682239329298f,   0.5679261914556032f}, 
				   {0.5172278701690467f, 0.6145188145188145f,   0.575643963879258f}, 
				   {0.5101760984113926f, 0.6168694051046992f,   0.5833617363029128f}, 
				   {0.5031243266537384f, 0.619219995690584f,   0.5910795087265676f}, 
				   {0.4960725548960844f, 0.6215705862764686f,   0.5987972811502223f}, 
				   {0.4890207831384303f, 0.6239211768623533f,   0.606515053573877f}, 
				   {0.48196901138077614f, 0.626271767448238f,   0.6142328259975319f}, 
				   {0.47491723962312204f, 0.6286223580341227f,   0.6219505984211866f}, 
				   {0.4678654678654679f, 0.6309729486200074f,   0.6296683708448415f}, 
				   {0.4608136961078138f, 0.6333235392058921f,   0.6373861432684962f}, 
				   {0.4537619243501596f, 0.6356741297917768f,   0.6451039156921511f}, 
				   {0.44671015259250557f, 0.6380247203776614f,   0.6528216881158058f}, 
				   {0.4396583808348514f, 0.6403753109635462f,   0.6605394605394606f}, 
				   {0.4326066090771974f, 0.6427259015494309f,   0.6682572329631153f}, 
				   {0.42555483731954324f, 0.6450764921353156f,   0.67597500538677f}, 
				   {0.4185030655618891f, 0.6474270827212003f,   0.6836927778104249f}, 
				   {0.41145129380423506f, 0.649777673307085f,   0.6914105502340796f}, 
				   {0.4043995220465809f, 0.6521282638929697f,   0.6991283226577345f}, 
				   {0.39734775028892677f, 0.6544788544788545f,   0.7068460950813892f}, 
				   {0.3902959785312726f, 0.6568294450647392f,   0.7145638675050441f}, 
				   {0.3832442067736186f, 0.6591800356506239f,   0.7222816399286988f}, 
				   {0.37619243501596455f, 0.6615306262365085f,   0.7299994123523535f}, 
				   {0.3691406632583104f, 0.6638812168223932f,   0.7377171847760083f}, 
				   {0.36208889150065626f, 0.6662318074082779f,   0.745434957199663f}, 
				   {0.3550371197430021f, 0.6685823979941626f,   0.7531527296233179f}, 
				   {0.3479853479853481f, 0.6709329885800474f,   0.7608705020469726f}, 
				   {0.34093357622769394f, 0.6732835791659321f,   0.7685882744706275f}, 
				   {0.3338818044700398f, 0.6756341697518168f,   0.7763060468942822f}, 
				   {0.32683003271238564f, 0.6779847603377015f,   0.7840238193179371f}, 
				   {0.3197782609547316f, 0.6803353509235861f,   0.7917415917415918f}, 
				   {0.3127264891970776f, 0.6826859415094708f,   0.7994593641652465f}, 
				   {0.3056747174394233f, 0.6850365320953555f,   0.8071771365889013f}, 
				   {0.2986229456817693f, 0.6873871226812402f,   0.814894909012556f}, 
				   {0.29157117392411513f, 0.689737713267125f,   0.8226126814362109f}, 
				   {0.2845194021664611f, 0.6920883038530097f,   0.8303304538598656f}, 
				   {0.27746763040880684f, 0.6944388944388944f,   0.8380482262835205f}, 
				   {0.2704158586511528f, 0.6967894850247791f,   0.8457659987071752f}, 
				   {0.26336408689349877f, 0.6991400756106638f,   0.85348377113083f}, 
				   {0.2563123151358446f, 0.7014906661965485f,   0.8612015435544847f}, 
				   {0.2602613073201308f, 0.696350708115414f,   0.8602378014142721f}, 
				   {0.2669604904899022f, 0.6893381128675246f,   0.8571036806330924f}, 
				   {0.27365967365967364f, 0.6823255176196352f,   0.8539695598519128f}, 
				   {0.28035885682944506f, 0.6753129223717459f,   0.8508354390707332f}, 
				   {0.2870580399992165f, 0.6683003271238565f,   0.8477013182895536f}, 
				   {0.29375722316898784f, 0.6612877318759671f,   0.8445671975083741f}, 
				   {0.30045640633875925f, 0.6542751366280778f,   0.8414330767271945f}, 
				   {0.30715558950853067f, 0.6472625413801883f,   0.8382989559460148f}, 
				   {0.3138547726783021f, 0.640249946132299f,   0.8351648351648352f}, 
				   {0.3205539558480735f, 0.6332373508844097f,   0.8320307143836556f}, 
				   {0.3272531390178449f, 0.6262247556365204f,   0.828896593602476f}, 
				   {0.3339523221876163f, 0.6192121603886309f,   0.8257624728212964f}, 
				   {0.3406515053573877f, 0.6121995651407416f,   0.8226283520401168f}, 
				   {0.3473506885271591f, 0.6051869698928523f,   0.8194942312589372f}, 
				   {0.3540498716969305f, 0.5981743746449628f,   0.8163601104777576f}, 
				   {0.3607490548667019f, 0.5911617793970735f,   0.813225989696578f}, 
				   {0.3674482380364733f, 0.5841491841491842f,   0.8100918689153984f}, 
				   {0.3741474212062447f, 0.5771365889012947f,   0.8069577481342187f}, 
				   {0.38084660437601614f, 0.5701239936534054f,   0.8038236273530391f}, 
				   {0.3875457875457875f, 0.563111398405516f,   0.8006895065718596f}, 
				   {0.394244970715559f, 0.5560988031576266f,   0.79755538579068f}, 
				   {0.40094415388533033f, 0.5490862079097373f,   0.7944212650095004f}, 
				   {0.40764333705510175f, 0.542073612661848f,   0.7912871442283207f}, 
				   {0.41434252022487317f, 0.5350610174139585f,   0.7881530234471411f}, 
				   {0.42104170339464453f, 0.5280484221660692f,   0.7850189026659615f}, 
				   {0.427740886564416f, 0.5210358269181798f,   0.7818847818847819f}, 
				   {0.43444006973418736f, 0.5140232316702904f,   0.7787506611036024f}, 
				   {0.4411392529039588f, 0.5070106364224011f,   0.7756165403224227f}, 
				   {0.4478384360737302f, 0.49999804117451174f,   0.7724824195412431f}, 
				   {0.45453761924350156f, 0.49298544592662236f,   0.7693482987600635f}, 
				   {0.46123680241327303f, 0.48597285067873297f,   0.7662141779788839f}, 
				   {0.4679359855830444f, 0.47896025543084364f,   0.7630800571977043f}, 
				   {0.47463516875281586f, 0.47194766018295425f,   0.7599459364165246f}, 
				   {0.4813343519225872f, 0.4649350649350649f,   0.756811815635345f}, 
				   {0.4880335350923586f, 0.45792246968717554f,   0.7536776948541655f}, 
				   {0.49473271826213f, 0.4509098744392862f,   0.7505435740729859f}, 
				   {0.5014319014319014f, 0.4438972791913968f,   0.7474094532918063f}, 
				   {0.5081310846016729f, 0.43688468394350743f,   0.7442753325106267f}, 
				   {0.5148302677714442f, 0.4298720886956181f,   0.741141211729447f}, 
				   {0.5215294509412156f, 0.4228594934477287f,   0.7380070909482674f}, 
				   {0.5282286341109871f, 0.41584689819983933f,   0.7348729701670879f}, 
				   {0.5349278172807584f, 0.40883430295195f,   0.7317388493859083f}, 
				   {0.5416270004505299f, 0.40182170770406067f,   0.7286047286047287f}, 
				   {0.5483261836203013f, 0.3948091124561713f,   0.7254706078235491f}, 
				   {0.5550253667900726f, 0.3877965172082819f,   0.7223364870423694f}, 
				   {0.561724549959844f, 0.3807839219603925f,   0.7192023662611898f}, 
				   {0.5684237331296155f, 0.3737713267125032f,   0.7160682454800102f}, 
				   {0.5751229162993869f, 0.3667587314646138f,   0.7129341246988306f}, 
				   {0.5818220994691583f, 0.3597461362167244f,   0.7098000039176511f}, 
				   {0.5885212826389297f, 0.3527335409688351f,   0.7066658831364714f}, 
				   {0.595220465808701f, 0.34572094572094575f,   0.7035317623552918f}, 
				   {0.6019196489784725f, 0.33870835047305636f,   0.7003976415741122f}, 
				   {0.608618832148244f, 0.331695755225167f,   0.6972635207929326f}, 
				   {0.6153180153180153f, 0.3246831599772776f,   0.694129400011753f}, 
				   {0.6220171984877867f, 0.31767056472938826f,   0.6909952792305734f}, 
				   {0.628716381657558f, 0.3106579694814989f,   0.6878611584493938f}, 
				   {0.6354155648273295f, 0.3036453742336095f,   0.6847270376682142f}, 
				   {0.6421147479971009f, 0.29663277898572016f,   0.6815929168870346f}, 
				   {0.6488139311668724f, 0.2896201837378308f,   0.678458796105855f}, 
				   {0.6555131143366437f, 0.28260758848994144f,   0.6753246753246753f}, 
				   {0.6622122975064151f, 0.27559499324205206f,   0.6721905545434957f}, 
				   {0.6689114806761866f, 0.2685823979941627f,   0.6690564337623162f}, 
				   {0.675610663845958f, 0.26156980274627334f,   0.6659223129811366f}, 
				   {0.6823098470157294f, 0.254557207498384f,   0.662788192199957f}, 
				   {0.6890090301855007f, 0.24754461225049457f,   0.6596540714187773f}, 
				   {0.6957082133552721f, 0.2405320170026053f,   0.6565199506375977f}, 
				   {0.7024073965250437f, 0.23351942175471585f,   0.6533858298564181f}, 
				   {0.709106579694815f, 0.22650682650682652f,   0.6502517090752385f}, 
				   {0.7158057628645864f, 0.21949423125893713f,   0.647117588294059f}, 
				   {0.7225049460343578f, 0.2124816360110478f,   0.6439834675128793f}, 
				   {0.7292041292041291f, 0.20546904076315847f,   0.6408493467316998f}, 
				   {0.7359033123739006f, 0.1984564455152691f,   0.6377152259505201f}, 
				   {0.742602495543672f, 0.19144385026737976f,   0.6345811051693405f}, 
				   {0.7493016787134434f, 0.18443125501949031f,   0.6314469843881609f}, 
				   {0.7560008618832148f, 0.17741865977160098f,   0.6283128636069812f}, 
				   {0.7627000450529863f, 0.17040606452371154f,   0.6251787428258017f}, 
				   {0.7693992282227576f, 0.1633934692758222f,   0.6220446220446221f}, 
				   {0.776098411392529f, 0.15638087402793288f,   0.6189105012634425f}, 
				   {0.7827975945623005f, 0.14936827878004355f,   0.6157763804822629f}, 
				   {0.7894967777320718f, 0.14235568353215422f,   0.6126422597010832f}, 
				   {0.7961959609018433f, 0.13534308828426478f,   0.6095081389199037f}, 
				   {0.8028951440716147f, 0.12833049303637545f,   0.606374018138724f}, 
				   {0.8095943272413861f, 0.121317897788486f,   0.6032398973575445f}, 
				   {0.8162935104111575f, 0.11430530254059668f,   0.6001057765763649f}, 
				   {0.822992693580929f, 0.10729270729270723f,   0.5969716557951852f}, 
				   {0.8296918767507003f, 0.1002801120448179f,   0.5938375350140057f}, 
				   {0.8363910599204717f, 0.09326751679692868f,   0.590703414232826f}, 
				   {0.843090243090243f, 0.08625492154903924f,   0.5875692934516464f}, 
				   {0.8497894262600144f, 0.07924232630114991f,   0.5844351726704669f}, 
				   {0.8564886094297859f, 0.07222973105326047f,   0.5813010518892872f}, 
				   {0.8631877925995572f, 0.06521713580537114f,   0.5781669311081077f}, 
				   {0.8698869757693287f, 0.0582045405574817f,   0.575032810326928f}, 
				   {0.8765861589391001f, 0.05119194530959237f,   0.5718986895457484f}, 
				   {0.8832853421088714f, 0.04417935006170304f,   0.5687645687645688f}, 
				   {0.8899845252786429f, 0.03716675481381371f,   0.5656304479833891f}, 
				   {0.8966837084484143f, 0.030154159565924377f,   0.5624963272022097f}, 
				   {0.9033828916181857f, 0.023141564318034935f,   0.55936220642103f}, 
				   {0.9100820747879571f, 0.016128969070145605f,   0.5562280856398504f}, 
				   {0.9167812579577286f, 0.009116373822256163f,   0.5530939648586708f}, 
				   {0.9234804411274999f, 0.0021037785743668325f,   0.5499598440774912f}, 
				   {0.9191827780063074f, 0.0033456739339092273f,   0.5501165501165501f}, 
				   {0.9101721807604161f, 0.008125208125208123f,   0.55168361050714f}, 
				   {0.9011615835145247f, 0.012904742316507019f,   0.5532506708977297f}, 
				   {0.8921509862686334f, 0.017684276507805914f,   0.5548177312883196f}, 
				   {0.8831403890227421f, 0.022463810699104813f,   0.5563847916789094f}, 
				   {0.8741297917768507f, 0.027243344890403712f,   0.5579518520694992f}, 
				   {0.8651191945309593f, 0.03202287908170261f,   0.559518912460089f}, 
				   {0.8561085972850679f, 0.0368024132730015f,   0.5610859728506787f}, 
				   {0.8470980000391766f, 0.0415819474643004f,   0.5626530332412686f}, 
				   {0.8380874027932852f, 0.04636148165559929f,   0.5642200936318583f}, 
				   {0.8290768055473938f, 0.05114101584689819f,   0.5657871540224482f}, 
				   {0.8200662083015025f, 0.055920550038197084f,   0.567354214413038f}, 
				   {0.8110556110556111f, 0.06070008422949598f,   0.5689212748036278f}, 
				   {0.8020450138097197f, 0.06547961842079487f,   0.5704883351942176f}, 
				   {0.7930344165638283f, 0.07025915261209377f,   0.5720553955848073f}, 
				   {0.784023819317937f, 0.07503868680339267f,   0.5736224559753972f}, 
				   {0.7750132220720456f, 0.07981822099469157f,   0.575189516365987f}, 
				   {0.7660026248261543f, 0.08459775518599046f,   0.5767565767565768f}, 
				   {0.756992027580263f, 0.08937728937728935f,   0.5783236371471666f}, 
				   {0.7479814303343716f, 0.09415682356858826f,   0.5798906975377563f}, 
				   {0.7389708330884802f, 0.09893635775988716f,   0.5814577579283462f}, 
				   {0.7299602358425888f, 0.10371589195118604f,   0.5830248183189359f}, 
				   {0.7209496385966975f, 0.10849542614248495f,   0.5845918787095258f}, 
				   {0.7119390413508061f, 0.11327496033378384f,   0.5861589391001156f}, 
				   {0.7029284441049147f, 0.11805449452508274f,   0.5877259994907054f}, 
				   {0.6939178468590234f, 0.12283402871638162f,   0.5892930598812952f}, 
				   {0.684907249613132f, 0.12761356290768053f,   0.590860120271885f}, 
				   {0.6758966523672406f, 0.13239309709897942f,   0.5924271806624748f}, 
				   {0.6668860551213494f, 0.13717263129027832f,   0.5939942410530646f}, 
				   {0.657875457875458f, 0.1419521654815772f,   0.5955613014436544f}, 
				   {0.6488648606295666f, 0.1467316996728761f,   0.5971283618342442f}, 
				   {0.6398542633836752f, 0.151511233864175f,   0.598695422224834f}, 
				   {0.6308436661377839f, 0.1562907680554739f,   0.6002624826154238f}, 
				   {0.6218330688918925f, 0.16107030224677282f,   0.6018295430060137f}, 
				   {0.6128224716460011f, 0.16584983643807172f,   0.6033966033966034f}, 
				   {0.6038118744001097f, 0.17062937062937059f,   0.6049636637871932f}, 
				   {0.5948012771542184f, 0.17540890482066948f,   0.606530724177783f}, 
				   {0.585790679908327f, 0.18018843901196838f,   0.6080977845683728f}, 
				   {0.5767800826624356f, 0.18496797320326727f,   0.6096648449589626f}, 
				   {0.5677694854165443f, 0.18974750739456617f,   0.6112319053495524f}, 
				   {0.5587588881706529f, 0.1945270415858651f,   0.6127989657401423f}, 
				   {0.5497482909247615f, 0.19930657577716399f,   0.614366026130732f}, 
				   {0.5407376936788701f, 0.20408610996846288f,   0.6159330865213218f}, 
				   {0.5317270964329789f, 0.20886564415976175f,   0.6175001469119116f}, 
				   {0.5227164991870875f, 0.21364517835106064f,   0.6190672073025014f}, 
				   {0.5137059019411961f, 0.21842471254235954f,   0.6206342676930912f}, 
				   {0.5046953046953048f, 0.22320424673365846f,   0.622201328083681f}, 
				   {0.4956847074494134f, 0.22798378092495736f,   0.6237683884742709f}, 
				   {0.486674110203522f, 0.23276331511625625f,   0.6253354488648606f}, 
				   {0.47766351295763065f, 0.23754284930755515f,   0.6269025092554504f}, 
				   {0.4686529157117393f, 0.24232238349885404f,   0.6284695696460403f}, 
				   {0.45964231846584797f, 0.2471019176901529f,   0.63003663003663f}, 
				   {0.4506317212199566f, 0.25188145188145183f,   0.6316036904272199f}, 
				   {0.4416211239740652f, 0.25666098607275073f,   0.6331707508178096f}, 
				   {0.43261052672817385f, 0.2614405202640496f,   0.6347378112083994f}, 
				   {0.4235999294822824f, 0.2662200544553485f,   0.6363048715989892f}, 
				   {0.41458933223639105f, 0.2709995886466474f,   0.637871931989579f}, 
				   {0.4055787349904997f, 0.2757791228379463f,   0.6394389923801689f}, 
				   {0.3965681377446083f, 0.2805586570292452f,   0.6410060527707586f}, 
				   {0.38755754049871705f, 0.2853381912205441f,   0.6425731131613485f}, 
				   {0.3785469432528257f, 0.290117725411843f,   0.6441401735519382f}, 
				   {0.3695363460069343f, 0.2948972596031419f,   0.645707233942528f}, 
				   {0.36052574876104293f, 0.2996767937944408f,   0.6472742943331178f}, 
				   {0.35151515151515167f, 0.3044563279857396f,   0.6488413547237076f}, 
				   {0.3425045542692602f, 0.3092358621770386f,   0.6504084151142975f}, 
				   {0.3334939570233689f, 0.3140153963683375f,   0.6519754755048872f}, 
				   {0.32448335977747744f, 0.31879493055963637f,   0.6535425358954771f}, 
				   {0.3154727625315862f, 0.32357446475093526f,   0.6551095962860668f}, 
				   {0.3064621652856947f, 0.3283539989422342f,   0.6566766566766566f}, 
				   {0.29745156803980344f, 0.33313353313353306f,   0.6582437170672465f}, 
				   {0.28844097079391195f, 0.337913067324832f,   0.6598107774578362f}, 
				   {0.2794303735480207f, 0.34269260151613085f,   0.6613778378484261f}, 
				   {0.2704197763021293f, 0.34747213570742974f,   0.6629448982390158f}, 
				   {0.26140917905623795f, 0.35225166989872864f,   0.6645119586296057f}, 
				   {0.2523985818103466f, 0.35703120409002753f,   0.6660790190201955f}, 
				   {0.2433879845644552f, 0.3618107382813265f,   0.6676460794107852f}, 
				   {0.23437738731856383f, 0.3665902724726253f,   0.6692131398013751f}, 
				   {0.22536679007267246f, 0.3713698066639243f,   0.6707802001919648f}, 
				   {0.2163561928267811f, 0.3761493408552231f,   0.6723472605825547f}, 
				   {0.20734559558088983f, 0.380928875046522f,   0.6739143209731444f}, 
				   {0.19833499833499835f, 0.3857084092378209f,   0.6754813813637343f}, 
				   {0.18932440108910709f, 0.3904879434291198f,   0.6770484417543241f}, 
				   {0.1803138038432156f, 0.39526747762041875f,   0.6786155021449138f}, 
				   {0.17130320659732434f, 0.4000470118117176f,   0.6801825625355037f}, 
				   {0.16229260935143286f, 0.40482654600301654f,   0.6817496229260935f}, 
				   {0.1532820121055416f, 0.4096060801943154f,   0.6833166833166833f}, 
				   {0.14427141485965012f, 0.41438561438561433f,   0.6848837437072731f}, 
				   {0.13526081761375885f, 0.41916514857691317f,   0.6864508040978629f}, 
				   {0.12625022036786748f, 0.42394468276821207f,   0.6880178644884527f}, 
				   {0.11723962312197611f, 0.428724216959511f,   0.6895849248790424f}, 
				   {0.10822902587608474f, 0.43350375115080986f,   0.6911519852696323f}, 
				   {0.09921842863019337f, 0.4382832853421088f,   0.6927190456602221f}, 
				   {0.090207831384302f, 0.44306281953340765f,   0.6942861060508119f}, 
				   {0.08119723413841062f, 0.4478423537247066f,   0.6958531664414017f}, 
				   {0.07218663689251925f, 0.45262188791600544f,   0.6974202268319915f}, 
				   {0.06317603964662799f, 0.45740142210730433f,   0.6989872872225813f}, 
				   {0.05416544240073651f, 0.4621809562986033f,   0.700554347613171f}, 
				   {0.04515484515484525f, 0.4669604904899021f,   0.7021214080037609f}, 
				   {0.036144247908953764f, 0.4717400246812011f,   0.7036884683943507f}, 
				   {0.027133650663062503f, 0.4765195588724999f,   0.7052555287849405f}, 
				   {0.023670447199858963f, 0.4764333705510176f,   0.7044484926837867f}, 
				   {0.023905506258447434f, 0.47310336722101426f,   0.7020587255881373f}, 
				   {0.024140565317035904f, 0.46977336389101093f,   0.6996689584924879f}, 
				   {0.024375624375624374f, 0.4664433605610076f,   0.6972791913968384f}, 
				   {0.024610683434212844f, 0.4631133572310043f,   0.6948894243011889f}, 
				   {0.024845742492801318f, 0.45978335390100095f,   0.6924996572055395f}, 
				   {0.025080801551389788f, 0.4564533505709976f,   0.6901098901098901f}, 
				   {0.025315860609978258f, 0.4531233472409943f,   0.6877201230142406f}, 
				   {0.025550919668566728f, 0.4497933439109909f,   0.6853303559185911f}, 
				   {0.025785978727155198f, 0.4464633405809876f,   0.6829405888229417f}, 
				   {0.02602103778574367f, 0.44313333725098425f,   0.6805508217272923f}, 
				   {0.02625609684433214f, 0.4398033339209809f,   0.6781610546316428f}, 
				   {0.02649115590292061f, 0.4364733305909776f,   0.6757712875359934f}, 
				   {0.02672621496150908f, 0.43314332726097426f,   0.6733815204403439f}, 
				   {0.02696127402009755f, 0.42981332393097094f,   0.6709917533446945f}, 
				   {0.02719633307868602f, 0.4264833206009676f,   0.668601986249045f}, 
				   {0.02743139213727449f, 0.4231533172709643f,   0.6662122191533956f}, 
				   {0.02766645119586296f, 0.41982331394096095f,   0.6638224520577461f}, 
				   {0.02790151025445143f, 0.4164933106109576f,   0.6614326849620967f}, 
				   {0.0281365693130399f, 0.4131633072809543f,   0.6590429178664472f}, 
				   {0.02837162837162837f, 0.40983330395095097f,   0.6566531507707978f}, 
				   {0.02860668743021684f, 0.40650330062094764f,   0.6542633836751484f}, 
				   {0.02884174648880531f, 0.4031732972909443f,   0.6518736165794989f}, 
				   {0.029076805547393784f, 0.399843293960941f,   0.6494838494838494f}, 
				   {0.02931186460598225f, 0.39651329063093765f,   0.6470940823882f}, 
				   {0.029546923664570724f, 0.3931832873009343f,   0.6447043152925506f}, 
				   {0.029781982723159194f, 0.389853283970931f,   0.642314548196901f}, 
				   {0.030017041781747664f, 0.38652328064092767f,   0.6399247811012516f}, 
				   {0.030252100840336135f, 0.38319327731092434f,   0.6375350140056022f}, 
				   {0.030487159898924605f, 0.379863273980921f,   0.6351452469099528f}, 
				   {0.030722218957513075f, 0.3765332706509177f,   0.6327554798143034f}, 
				   {0.030957278016101545f, 0.37320326732091436f,   0.6303657127186538f}, 
				   {0.031192337074690015f, 0.369873263990911f,   0.6279759456230044f}, 
				   {0.03142739613327848f, 0.3665432606609077f,   0.625586178527355f}, 
				   {0.03166245519186696f, 0.36321325733090437f,   0.6231964114317055f}, 
				   {0.03189751425045543f, 0.35988325400090104f,   0.620806644336056f}, 
				   {0.0321325733090439f, 0.3565532506708977f,   0.6184168772404066f}, 
				   {0.03236763236763237f, 0.3532232473408944f,   0.6160271101447572f}, 
				   {0.03260269142622084f, 0.34989324401089106f,   0.6136373430491078f}, 
				   {0.03283775048480931f, 0.34656324068088773f,   0.6112475759534582f}, 
				   {0.03307280954339778f, 0.3432332373508844f,   0.6088578088578088f}, 
				   {0.03330786860198625f, 0.3399032340208811f,   0.6064680417621594f}, 
				   {0.03354292766057472f, 0.33657323069087774f,   0.6040782746665099f}, 
				   {0.03377798671916319f, 0.3332432273608744f,   0.6016885075708605f}, 
				   {0.03401304577775166f, 0.3299132240308711f,   0.599298740475211f}, 
				   {0.03424810483634013f, 0.32658322070086776f,   0.5969089733795616f}, 
				   {0.0344831638949286f, 0.32325321737086443f,   0.5945192062839122f}, 
				   {0.03471822295351707f, 0.3199232140408611f,   0.5921294391882627f}, 
				   {0.03495328201210554f, 0.3165932107108578f,   0.5897396720926132f}, 
				   {0.03518834107069401f, 0.31326320738085445f,   0.5873499049969638f}, 
				   {0.03542340012928248f, 0.3099332040508511f,   0.5849601379013143f}, 
				   {0.03565845918787095f, 0.3066032007208478f,   0.5825703708056649f}, 
				   {0.03589351824645942f, 0.30327319739084446f,   0.5801806037100155f}, 
				   {0.03612857730504789f, 0.2999431940608411f,   0.577790836614366f}, 
				   {0.03636363636363636f, 0.2966131907308378f,   0.5754010695187166f}, 
				   {0.03659869542222483f, 0.2932831874008345f,   0.5730113024230671f}, 
				   {0.0368337544808133f, 0.28995318407083115f,   0.5706215353274177f}, 
				   {0.03706881353940177f, 0.2866231807408278f,   0.5682317682317682f}, 
				   {0.03730387259799024f, 0.28329317741082444f,   0.5658420011361187f}, 
				   {0.03753893165657872f, 0.2799631740808211f,   0.5634522340404693f}, 
				   {0.03777399071516718f, 0.2766331707508178f,   0.5610624669448199f}, 
				   {0.03800904977375566f, 0.27330316742081445f,   0.5586726998491705f}, 
				   {0.03824410883234412f, 0.2699731640908112f,   0.556282932753521f}, 
				   {0.0384791678909326f, 0.2666431607608078f,   0.5538931656578715f}, 
				   {0.03871422694952106f, 0.26331315743080447f,   0.5515033985622221f}, 
				   {0.03894928600810954f, 0.2599831541008011f,   0.5491136314665727f}, 
				   {0.039184345066698004f, 0.2566531507707978f,   0.5467238643709231f}, 
				   {0.03941940412528648f, 0.25332314744079454f,   0.5443340972752737f}, 
				   {0.039654463183874944f, 0.24999314411079115f,   0.5419443301796243f}, 
				   {0.03988952224246342f, 0.24666314078078783f,   0.5395545630839749f}, 
				   {0.04012458130105189f, 0.24333313745078447f,   0.5371647959883254f}, 
				   {0.04035964035964036f, 0.24000313412078117f,   0.5347750288926759f}, 
				   {0.04059469941822883f, 0.2366731307907778f,   0.5323852617970265f}, 
				   {0.0408297584768173f, 0.2333431274607745f,   0.5299954947013771f}, 
				   {0.041064817535405765f, 0.23001312413077118f,   0.5276057276057277f}, 
				   {0.04129987659399424f, 0.22668312080076786f,   0.5252159605100781f}, 
				   {0.041534935652582705f, 0.22335311747076453f,   0.5228261934144287f}, 
				   {0.04176999471117118f, 0.2200231141407612f,   0.5204364263187793f}, 
				   {0.04200505376975965f, 0.21669311081075787f,   0.5180466592231299f}, 
				   {0.04224011282834812f, 0.2133631074807545f,   0.5156568921274803f}, 
				   {0.04247517188693659f, 0.21003310415075122f,   0.5132671250318309f}, 
				   {0.04271023094552506f, 0.20670310082074783f,   0.5108773579361815f}, 
				   {0.04294529000411353f, 0.20337309749074456f,   0.508487590840532f}, 
				   {0.043180349062702f, 0.20004309416074123f,   0.5060978237448825f}, 
				   {0.04341540812129047f, 0.19671309083073785f,   0.5037080566492331f}, 
				   {0.04365046717987894f, 0.19338308750073457f,   0.5013182895535837f}, 
				   {0.04388552623846742f, 0.1900530841707312f,   0.49892852245793423f}, 
				   {0.044120585297055884f, 0.18672308084072792f,   0.49653875536228476f}, 
				   {0.04435564435564436f, 0.18339307751072453f,   0.49414898826663534f}, 
				   {0.044590703414232824f, 0.1800630741807212f,   0.4917592211709859f}, 
				   {0.044825762472821294f, 0.17673307085071793f,   0.4893694540753365f}, 
				   {0.045060821531409764f, 0.17340306752071455f,   0.48697968697968697f}, 
				   {0.045295880589998234f, 0.17007306419071128f,   0.48458991988403755f}, 
				   {0.045530939648586705f, 0.1667430608607079f,   0.4822001527883881f}, 
				   {0.045765998707175175f, 0.16341305753070462f,   0.4798103856927387f}, 
				   {0.046001057765763645f, 0.16008305420070124f,   0.4774206185970892f}, 
				   {0.04623611682435212f, 0.1567530508706979f,   0.47503085150143975f}, 
				   {0.046471175882940585f, 0.15342304754069458f,   0.47264108440579033f}, 
				   {0.04670623494152906f, 0.15009304421069125f,   0.47025131731014086f}, 
				   {0.046941294000117526f, 0.14676304088068798f,   0.46786155021449144f}, 
				   {0.04935064935064935f, 0.14439286203992086f,   0.464844958962606f}, 
				   {0.05393430099312452f, 0.14298250768839002f,   0.4612015435544847f}, 
				   {0.058517952635599696f, 0.1415721533368592f,   0.45755812814636343f}, 
				   {0.06310160427807486f, 0.14016179898532838f,   0.45391471273824213f}, 
				   {0.06768525592055004f, 0.13875144463379757f,   0.45027129733012083f}, 
				   {0.0722689075630252f, 0.13734109028226674f,   0.4466278819219996f}, 
				   {0.07685255920550038f, 0.1359307359307359f,   0.4429844665138783f}, 
				   {0.08143621084797556f, 0.1345203815792051f,   0.439341051105757f}, 
				   {0.08601986249045072f, 0.13311002722767426f,   0.4356976356976357f}, 
				   {0.09060351413292589f, 0.13169967287614345f,   0.4320542202895144f}, 
				   {0.09518716577540107f, 0.13028931852461262f,   0.4284108048813931f}, 
				   {0.09977081741787625f, 0.1288789641730818f,   0.42476738947327186f}, 
				   {0.10435446906035141f, 0.12746860982155098f,   0.42112397406515056f}, 
				   {0.10893812070282657f, 0.12605825547002017f,   0.41748055865702927f}, 
				   {0.11352177234530175f, 0.12464790111848933f,   0.41383714324890797f}, 
				   {0.11810542398777692f, 0.12323754676695851f,   0.41019372784078667f}, 
				   {0.1226890756302521f, 0.1218271924154277f,   0.4065503124326654f}, 
				   {0.12727272727272726f, 0.12041683806389687f,   0.4029068970245441f}, 
				   {0.13185637891520244f, 0.11900648371236605f,   0.3992634816164228f}, 
				   {0.13644003055767762f, 0.11759612936083523f,   0.3956200662083015f}, 
				   {0.14102368220015277f, 0.11618577500930441f,   0.3919766508001802f}, 
				   {0.14560733384262797f, 0.11477542065777359f,   0.3883332353920589f}, 
				   {0.15019098548510312f, 0.11336506630624277f,   0.38468981998393764f}, 
				   {0.15477463712757827f, 0.11195471195471193f,   0.38104640457581634f}, 
				   {0.15935828877005348f, 0.11054435760318113f,   0.37740298916769505f}, 
				   {0.16394194041252863f, 0.10913400325165029f,   0.37375957375957375f}, 
				   {0.1685255920550038f, 0.10772364890011948f,   0.37011615835145245f}, 
				   {0.173109243697479f, 0.10631329454858865f,   0.3664727429433312f}, 
				   {0.17769289533995417f, 0.10490294019705783f,   0.3628293275352099f}, 
				   {0.18227654698242934f, 0.10349258584552701f,   0.3591859121270886f}, 
				   {0.1868601986249045f, 0.10208223149399619f,   0.3555424967189673f}, 
				   {0.19144385026737967f, 0.10067187714246537f,   0.351899081310846f}, 
				   {0.19602750190985482f, 0.09926152279093454f,   0.3482556659027247f}, 
				   {0.20061115355233f, 0.09785116843940372f,   0.3446122504946034f}, 
				   {0.20519480519480518f, 0.0964408140878729f,   0.3409688350864821f}, 
				   {0.20977845683728036f, 0.09503045973634208f,   0.3373254196783608f}, 
				   {0.21436210847975554f, 0.09362010538481125f,   0.33368200427023953f}, 
				   {0.21894576012223071f, 0.09220975103328044f,   0.33003858886211823f}, 
				   {0.2235294117647059f, 0.0907993966817496f,   0.32639517345399693f}, 
				   {0.22811306340718104f, 0.08938904233021878f,   0.32275175804587564f}, 
				   {0.2326967150496562f, 0.08797868797868796f,   0.3191083426377544f}, 
				   {0.23728036669213137f, 0.08656833362715716f,   0.31546492722963315f}, 
				   {0.24186401833460655f, 0.08515797927562632f,   0.31182151182151185f}, 
				   {0.24644766997708173f, 0.0837476249240955f,   0.30817809641339056f}, 
				   {0.2510313216195569f, 0.08233727057256468f,   0.30453468100526926f}, 
				   {0.2556149732620321f, 0.08092691622103386f,   0.30089126559714796f}, 
				   {0.2601986249045073f, 0.07951656186950304f,   0.29724785018902666f}, 
				   {0.2647822765469824f, 0.0781062075179722f,   0.29360443478090537f}, 
				   {0.2693659281894576f, 0.0766958531664414f,   0.28996101937278407f}, 
				   {0.27394957983193274f, 0.07528549881491058f,   0.28631760396466277f}, 
				   {0.2785332314744079f, 0.07387514446337975f,   0.2826741885565415f}, 
				   {0.2831168831168831f, 0.07246479011184892f,   0.2790307731484202f}, 
				   {0.2877005347593583f, 0.0710544357603181f,   0.2753873577402989f}, 
				   {0.29228418640183346f, 0.06964408140878728f,   0.2717439423321776f}, 
				   {0.2968678380443086f, 0.06823372705725646f,   0.2681005269240563f}, 
				   {0.3014514896867838f, 0.06682337270572564f,   0.264457111515935f}, 
				   {0.30603514132925896f, 0.06541301835419482f,   0.26081369610781374f}, 
				   {0.3106187929717341f, 0.064002664002664f,   0.2571702806996925f}, 
				   {0.3152024446142093f, 0.06259230965113317f,   0.2535268652915712f}, 
				   {0.31978609625668447f, 0.06118195529960235f,   0.24988344988344988f}, 
				   {0.3243697478991596f, 0.05977160094807153f,   0.24624003447532858f}, 
				   {0.32895339954163483f, 0.05836124659654071f,   0.24259661906720728f}, 
				   {0.33353705118411f, 0.056950892245009876f,   0.23895320365908598f}, 
				   {0.3381207028265852f, 0.055540537893479056f,   0.23530978825096469f}, 
				   {0.34270435446906033f, 0.05413018354194825f,   0.23166637284284342f}, 
				   {0.34728800611153554f, 0.052719829190417414f,   0.22802295743472212f}, 
				   {0.3518716577540107f, 0.05130947483888659f,   0.22437954202660085f}, 
				   {0.3564553093964859f, 0.04989912048735577f,   0.22073612661847952f}, 
				   {0.361038961038961f, 0.04848876613582495f,   0.21709271121035825f}, 
				   {0.36562261268143614f, 0.047078411784294144f,   0.21344929580223698f}, 
				   {0.37020626432391135f, 0.04566805743276331f,   0.20980588039411568f}, 
				   {0.3747899159663865f, 0.04425770308123249f,   0.2061624649859944f}, 
				   {0.3793735676088617f, 0.042847348729701654f,   0.2025190495778731f}, 
				   {0.38395721925133686f, 0.04143699437817085f,   0.1988756341697518f}, 
				   {0.38854087089381206f, 0.04002664002664001f,   0.1952322187616305f}, 
				   {0.3931245225362872f, 0.038616285675109205f,   0.1915888033535092f}, 
				   {0.39770817417876236f, 0.037205931323578384f,   0.18794538794538795f}, 
				   {0.40229182582123757f, 0.03579557697204755f,   0.18430197253726666f}, 
				   {0.4068754774637127f, 0.03438522262051674f,   0.18065855712914536f}, 
				   {0.4114591291061879f, 0.03297486826898591f,   0.17701514172102406f}, 
				   {0.4160427807486631f, 0.031564513917455087f,   0.17337172631290276f}, 
				   {0.4206264323911383f, 0.030154159565924266f,   0.16972831090478147f}, 
				   {0.42521008403361343f, 0.028743805214393445f,   0.16608489549666017f}, 
				   {0.42979373567608864f, 0.02733345086286261f,   0.16244148008853887f}, 
				   {0.4343773873185638f, 0.025923096511331803f,   0.15879806468041757f}, 
				   {0.4389610389610389f, 0.024512742159800982f,   0.15515464927229633f}, 
				   {0.4435446906035141f, 0.023102387808270147f,   0.15151123386417503f}, 
				   {0.44812834224598924f, 0.02169203345673934f,   0.14786781845605373f}, 
				   {0.45271199388846445f, 0.020281679105208505f,   0.14422440304793244f}, 
				   {0.4572956455309396f, 0.0188713247536777f,   0.14058098763981114f}, 
				   {0.4618792971734148f, 0.017460970402146864f,   0.13693757223168984f}, 
				   {0.46646294881588996f, 0.016050616050616057f,   0.13329415682356854f}, 
				   {0.4710466004583651f, 0.014640261699085222f,   0.1296507414154473f}, 
				   {0.4756302521008403f, 0.013229907347554387f,   0.126007326007326f}, 
				   {0.48021390374331546f, 0.01181955299602358f,   0.1223639105992047f}, 
				   {0.48479755538579067f, 0.010409198644492745f,   0.11872049519108341f}, 
				   {0.4893812070282658f, 0.008998844292961938f,   0.11507707978296211f}, 
				   {0.493964858670741f, 0.0075884899414311036f,   0.11143366437484081f}, 
				   {0.4985485103132162f, 0.0061781355899002965f,   0.10779024896671952f}, 
				   {0.5031321619556914f, 0.004767781238369462f,   0.10414683355859822f}, 
				   {0.5069636246106834f, 0.007228066051595462f,   0.10250925545043192f}, 
				   {0.5096668037844508f, 0.015494309611956669f,   0.103880433292198f}, 
				   {0.5123699829582182f, 0.023760553172317875f,   0.10525161113396407f}, 
				   {0.5150731621319856f, 0.03202679673267908f,   0.10662278897573015f}, 
				   {0.517776341305753f, 0.04029304029304029f,   0.10799396681749623f}, 
				   {0.5204795204795205f, 0.0485592838534015f,   0.10936514465926231f}, 
				   {0.5231826996532879f, 0.0568255274137627f,   0.11073632250102838f}, 
				   {0.5258858788270553f, 0.06509177097412391f,   0.11210750034279446f}, 
				   {0.5285890580008227f, 0.07335801453448511f,   0.11347867818456053f}, 
				   {0.5312922371745901f, 0.08162425809484633f,   0.11484985602632661f}, 
				   {0.5339954163483575f, 0.08989050165520752f,   0.11622103386809268f}, 
				   {0.536698595522125f, 0.09815674521556875f,   0.11759221170985877f}, 
				   {0.5394017746958923f, 0.10642298877592994f,   0.11896338955162485f}, 
				   {0.5421049538696597f, 0.11468923233629115f,   0.12033456739339092f}, 
				   {0.5448081330434271f, 0.12295547589665236f,   0.121705745235157f}, 
				   {0.5475113122171945f, 0.13122171945701355f,   0.12307692307692307f}, 
				   {0.550214491390962f, 0.13948796301737476f,   0.12444810091868916f}, 
				   {0.5529176705647294f, 0.14775420657773597f,   0.12581927876045523f}, 
				   {0.5556208497384968f, 0.15602045013809718f,   0.1271904566022213f}, 
				   {0.5583240289122642f, 0.16428669369845839f,   0.12856163444398738f}, 
				   {0.5610272080860316f, 0.1725529372588196f,   0.12993281228575346f}, 
				   {0.563730387259799f, 0.1808191808191808f,   0.13130399012751953f}, 
				   {0.5664335664335665f, 0.189085424379542f,   0.1326751679692856f}, 
				   {0.5691367456073338f, 0.19735166793990322f,   0.13404634581105168f}, 
				   {0.5718399247811012f, 0.20561791150026443f,   0.13541752365281776f}, 
				   {0.5745431039548686f, 0.21388415506062564f,   0.13678870149458383f}, 
				   {0.577246283128636f, 0.22215039862098684f,   0.13815987933634993f}, 
				   {0.5799494623024035f, 0.23041664218134805f,   0.13953105717811598f}, 
				   {0.5826526414761709f, 0.23868288574170926f,   0.14090223501988208f}, 
				   {0.5853558206499383f, 0.24694912930207047f,   0.14227341286164813f}, 
				   {0.5880589998237057f, 0.2552153728624316f,   0.14364459070341423f}, 
				   {0.5907621789974731f, 0.26348161642279283f,   0.1450157685451803f}, 
				   {0.5934653581712405f, 0.2717478599831541f,   0.14638694638694638f}, 
				   {0.596168537345008f, 0.2800141035435153f,   0.14775812422871246f}, 
				   {0.5988717165187754f, 0.2882803471038765f,   0.14912930207047853f}, 
				   {0.6015748956925427f, 0.29654659066423766f,   0.1505004799122446f}, 
				   {0.6042780748663101f, 0.30481283422459887f,   0.15187165775401068f}, 
				   {0.6069812540400775f, 0.3130790777849601f,   0.15324283559577676f}, 
				   {0.6096844332138449f, 0.3213453213453213f,   0.15461401343754283f}, 
				   {0.6123876123876124f, 0.3296115649056825f,   0.15598519127930893f}, 
				   {0.6150907915613798f, 0.3378778084660437f,   0.15735636912107498f}, 
				   {0.6177939707351472f, 0.3461440520264049f,   0.15872754696284108f}, 
				   {0.6204971499089146f, 0.3544102955867661f,   0.16009872480460716f}, 
				   {0.623200329082682f, 0.36267653914712733f,   0.16146990264637323f}, 
				   {0.6259035082564495f, 0.37094278270748854f,   0.1628410804881393f}, 
				   {0.6286066874302169f, 0.37920902626784975f,   0.16421225832990538f}, 
				   {0.6313098666039842f, 0.38747526982821096f,   0.16558343617167146f}, 
				   {0.6340130457777516f, 0.39574151338857216f,   0.16695461401343753f}, 
				   {0.636716224951519f, 0.40400775694893337f,   0.1683257918552036f}, 
				   {0.6394194041252865f, 0.4122740005092946f,   0.16969696969696968f}, 
				   {0.6421225832990539f, 0.4205402440696558f,   0.17106814753873578f}, 
				   {0.6448257624728213f, 0.42880648763001694f,   0.17243932538050183f}, 
				   {0.6475289416465887f, 0.43707273119037815f,   0.17381050322226793f}, 
				   {0.6502321208203561f, 0.44533897475073936f,   0.17518168106403398f}, 
				   {0.6529352999941235f, 0.4536052183111006f,   0.17655285890580008f}, 
				   {0.6556384791678909f, 0.46187146187146183f,   0.17792403674756613f}, 
				   {0.6583416583416584f, 0.47013770543182304f,   0.17929521458933223f}, 
				   {0.6610448375154258f, 0.47840394899218425f,   0.1806663924310983f}, 
				   {0.6637480166891931f, 0.48667019255254546f,   0.18203757027286438f}, 
				   {0.6664511958629605f, 0.4949364361129066f,   0.18340874811463045f}, 
				   {0.6691543750367279f, 0.5032026796732678f,   0.18477992595639653f}, 
				   {0.6718575542104954f, 0.511468923233629f,   0.1861511037981626f}, 
				   {0.6745607333842628f, 0.5197351667939902f,   0.18752228163992868f}, 
				   {0.6772639125580302f, 0.5280014103543514f,   0.18889345948169478f}, 
				   {0.6799670917317976f, 0.5362676539147126f,   0.19026463732346083f}, 
				   {0.682670270905565f, 0.5445338974750739f,   0.19163581516522693f}, 
				   {0.6853734500793325f, 0.5528001410354351f,   0.19300699300699298f}, 
				   {0.6880766292530999f, 0.5610663845957963f,   0.19437817084875908f}, 
				   {0.6907798084268673f, 0.5693326281561575f,   0.19574934869052513f}, 
				   {0.6934829876006346f, 0.5775988717165187f,   0.19712052653229123f}, 
				   {0.696186166774402f, 0.5858651152768799f,   0.1984917043740573f}, 
				   {0.6988893459481694f, 0.5941313588372411f,   0.19986288221582338f}, 
				   {0.7015925251219368f, 0.6023976023976023f,   0.20123406005758945f}, 
				   {0.7042957042957043f, 0.6106638459579635f,   0.20260523789935553f}, 
				   {0.7069988834694717f, 0.6189300895183247f,   0.20397641574112163f}, 
				   {0.7097020626432391f, 0.6271963330786859f,   0.20534759358288768f}, 
				   {0.7124052418170066f, 0.6354625766390471f,   0.20671877142465378f}, 
				   {0.7151084209907739f, 0.6437288201994084f,   0.20808994926641983f}, 
				   {0.7178116001645414f, 0.6519950637597696f,   0.20946112710818593f}, 
				   {0.7205147793383088f, 0.6602613073201308f,   0.21083230494995198f}, 
				   {0.7232179585120762f, 0.6685275508804919f,   0.21220348279171808f}, 
				   {0.7259211376858435f, 0.6767937944408532f,   0.21357466063348415f}, 
				   {0.7286243168596109f, 0.6850600380012144f,   0.21494583847525023f}, 
				   {0.7313274960333784f, 0.6933262815615756f,   0.2163170163170163f}, 
				   {0.7340306752071458f, 0.7015925251219368f,   0.21768819415878238f}, 
				   {0.7367338543809132f, 0.709858768682298f,   0.21905937200054848f}, 
				   {0.7394370335546806f, 0.7181250122426592f,   0.22043054984231453f}, 
				   {0.742140212728448f, 0.7263912558030203f,   0.2218017276840806f}, 
				   {0.7448433919022155f, 0.7346574993633816f,   0.22317290552584668f}, 
				   {0.7475465710759828f, 0.7429237429237427f,   0.22454408336761275f}, 
				   {0.7502497502497503f, 0.7511899864841041f,   0.22591526120937883f}, 
				   {0.7529529294235177f, 0.7594562300444652f,   0.2272864390511449f}, 
				   {0.755656108597285f, 0.7677224736048265f,   0.228657616892911f}, 
				   {0.7583592877710525f, 0.7759887171651877f,   0.23002879473467708f}, 
				   {0.7610624669448198f, 0.7842549607255489f,   0.23139997257644315f}, 
				   {0.7637656461185873f, 0.7925212042859101f,   0.23277115041820923f}, 
				   {0.7664688252923546f, 0.8007874478462712f,   0.2341423282599753f}, 
				   {0.7691720044661221f, 0.8090536914066325f,   0.23551350610174138f}, 
				   {0.7718751836398895f, 0.8173199349669936f,   0.23688468394350745f}, 
				   {0.7745783628136569f, 0.8255861785273549f,   0.23825586178527353f}, 
				   {0.7754363283775049f, 0.8310787251963722f,   0.23886309768662708f}, 
				   {0.7719887955182073f, 0.8300993124522535f,   0.23768780239368473f}, 
				   {0.7685412626589098f, 0.8291198997081349f,   0.23651250710074237f}, 
				   {0.7650937297996122f, 0.8281404869640163f,   0.23533721180780004f}, 
				   {0.7616461969403147f, 0.8271610742198977f,   0.23416191651485768f}, 
				   {0.758198664081017f, 0.8261816614757791f,   0.23298662122191532f}, 
				   {0.7547511312217194f, 0.8252022487316605f,   0.23181132592897297f}, 
				   {0.7513035983624219f, 0.8242228359875418f,   0.2306360306360306f}, 
				   {0.7478560655031243f, 0.8232434232434231f,   0.22946073534308828f}, 
				   {0.7444085326438268f, 0.8222640104993045f,   0.22828544005014592f}, 
				   {0.7409609997845292f, 0.8212845977551859f,   0.22711014475720356f}, 
				   {0.7375134669252317f, 0.8203051850110673f,   0.2259348494642612f}, 
				   {0.7340659340659341f, 0.8193257722669487f,   0.22475955417131888f}, 
				   {0.7306184012066366f, 0.8183463595228301f,   0.22358425887837652f}, 
				   {0.727170868347339f, 0.8173669467787115f,   0.22240896358543416f}, 
				   {0.7237233354880414f, 0.8163875340345927f,   0.2212336682924918f}, 
				   {0.7202758026287438f, 0.8154081212904741f,   0.22005837299954945f}, 
				   {0.7168282697694462f, 0.8144287085463555f,   0.21888307770660712f}, 
				   {0.7133807369101487f, 0.8134492958022369f,   0.21770778241366476f}, 
				   {0.7099332040508511f, 0.8124698830581183f,   0.2165324871207224f}, 
				   {0.7064856711915536f, 0.8114904703139997f,   0.21535719182778004f}, 
				   {0.703038138332256f, 0.8105110575698811f,   0.2141818965348377f}, 
				   {0.6995906054729584f, 0.8095316448257625f,   0.21300660124189535f}, 
				   {0.6961430726136608f, 0.8085522320816438f,   0.211831305948953f}, 
				   {0.6926955397543633f, 0.8075728193375251f,   0.21065601065601064f}, 
				   {0.6892480068950657f, 0.8065934065934065f,   0.20948071536306828f}, 
				   {0.6858004740357682f, 0.8056139938492879f,   0.20830542007012592f}, 
				   {0.6823529411764706f, 0.8046345811051693f,   0.2071301247771836f}, 
				   {0.678905408317173f, 0.8036551683610507f,   0.20595482948424124f}, 
				   {0.6754578754578755f, 0.802675755616932f,   0.20477953419129888f}, 
				   {0.672010342598578f, 0.8016963428728134f,   0.20360423889835655f}, 
				   {0.6685628097392804f, 0.8007169301286948f,   0.2024289436054142f}, 
				   {0.6651152768799828f, 0.7997375173845761f,   0.20125364831247183f}, 
				   {0.6616677440206852f, 0.7987581046404575f,   0.20007835301952948f}, 
				   {0.6582202111613876f, 0.7977786918963389f,   0.19890305772658712f}, 
				   {0.6547726783020901f, 0.7967992791522203f,   0.19772776243364476f}, 
				   {0.6513251454427925f, 0.7958198664081017f,   0.19655246714070243f}, 
				   {0.647877612583495f, 0.794840453663983f,   0.19537717184776007f}, 
				   {0.6444300797241974f, 0.7938610409198644f,   0.19420187655481772f}, 
				   {0.6409825468648999f, 0.7928816281757458f,   0.19302658126187539f}, 
				   {0.6375350140056023f, 0.7919022154316271f,   0.19185128596893303f}, 
				   {0.6340874811463046f, 0.7909228026875085f,   0.19067599067599067f}, 
				   {0.6306399482870071f, 0.7899433899433899f,   0.1895006953830483f}, 
				   {0.6271924154277095f, 0.7889639771992712f,   0.18832540009010595f}, 
				   {0.623744882568412f, 0.7879845644551526f,   0.1871501047971636f}, 
				   {0.6202973497091144f, 0.787005151711034f,   0.18597480950422127f}, 
				   {0.6168498168498169f, 0.7860257389669154f,   0.1847995142112789f}, 
				   {0.6134022839905193f, 0.7850463262227968f,   0.18362421891833655f}, 
				   {0.6099547511312218f, 0.7840669134786781f,   0.18244892362539422f}, 
				   {0.6065072182719242f, 0.7830875007345595f,   0.18127362833245186f}, 
				   {0.6030596854126267f, 0.7821080879904408f,   0.1800983330395095f}, 
				   {0.5996121525533291f, 0.7811286752463222f,   0.17892303774656715f}, 
				   {0.5961646196940315f, 0.7801492625022036f,   0.1777477424536248f}, 
				   {0.5927170868347339f, 0.779169849758085f,   0.17657244716068243f}, 
				   {0.5892695539754363f, 0.7781904370139664f,   0.1753971518677401f}, 
				   {0.5858220211161388f, 0.7772110242698478f,   0.17422185657479775f}, 
				   {0.5823744882568412f, 0.7762316115257291f,   0.1730465612818554f}, 
				   {0.5789269553975437f, 0.7752521987816104f,   0.17187126598891306f}, 
				   {0.5754794225382461f, 0.7742727860374918f,   0.1706959706959707f}, 
				   {0.5720318896789485f, 0.7732933732933732f,   0.16952067540302834f}, 
				   {0.5685843568196509f, 0.7723139605492546f,   0.16834538011008598f}, 
				   {0.5651368239603534f, 0.771334547805136f,   0.16717008481714363f}, 
				   {0.5616892911010558f, 0.7703551350610174f,   0.16599478952420127f}, 
				   {0.5582417582417583f, 0.7693757223168988f,   0.16481949423125894f}, 
				   {0.5547942253824607f, 0.7683963095727802f,   0.16364419893831655f}, 
				   {0.5513466925231632f, 0.7674168968286614f,   0.16246890364537422f}, 
				   {0.5478991596638656f, 0.7664374840845428f,   0.1612936083524319f}, 
				   {0.544451626804568f, 0.7654580713404242f,   0.16011831305948954f}, 
				   {0.5410040939452705f, 0.7644786585963056f,   0.15894301776654718f}, 
				   {0.5375565610859729f, 0.763499245852187f,   0.15776772247360482f}, 
				   {0.5341090282266754f, 0.7625198331080684f,   0.15659242718066246f}, 
				   {0.5306614953673777f, 0.7615404203639498f,   0.1554171318877201f}, 
				   {0.5272139625080802f, 0.7605610076198311f,   0.15424183659477775f}, 
				   {0.5237664296487827f, 0.7595815948757125f,   0.15306654130183542f}, 
				   {0.5203188967894851f, 0.7586021821315938f,   0.15189124600889306f}, 
				   {0.5168713639301875f, 0.7576227693874752f,   0.15071595071595073f}, 
				   {0.5134238310708898f, 0.7566433566433566f,   0.14954065542300837f}, 
				   {0.5099762982115924f, 0.755663943899238f,   0.14836536013006602f}, 
				   {0.5065287653522947f, 0.7546845311551194f,   0.14719006483712366f}, 
				   {0.5030812324929972f, 0.7537051184110007f,   0.1460147695441813f}, 
				   {0.49963369963369964f, 0.7527257056668821f,   0.14483947425123894f}, 
				   {0.4961861667744021f, 0.7517462929227634f,   0.14366417895829658f}, 
				   {0.4927386339151046f, 0.7507668801786448f,   0.14248888366535425f}, 
				   {0.489291101055807f, 0.7497874674345262f,   0.1413135883724119f}, 
				   {0.4858435681965094f, 0.7488080546904076f,   0.14013829307946957f}, 
				   {0.4823960353372118f, 0.747828641946289f,   0.1389629977865272f}, 
				   {0.4789485024779143f, 0.7468492292021703f,   0.13778770249358485f}, 
				   {0.4755009696186167f, 0.7458698164580517f,   0.1366124072006425f}, 
				   {0.47205343675931916f, 0.7448904037139331f,   0.13543711190770014f}, 
				   {0.4686059039000216f, 0.7439109909698145f,   0.13426181661475778f}, 
				   {0.465158371040724f, 0.7429315782256958f,   0.13308652132181542f}, 
				   {0.4617108381814265f, 0.7419521654815772f,   0.1319112260288731f}, 
				   {0.4582633053221289f, 0.7409727527374586f,   0.13073593073593073f}, 
				   {0.45481577246283134f, 0.7399933399933399f,   0.1295606354429884f}, 
				   {0.4513682396035337f, 0.7390139272492213f,   0.12838534015004605f}, 
				   {0.44792070674423623f, 0.7380345145051027f,   0.1272100448571037f}, 
				   {0.4444731738849386f, 0.7370551017609841f,   0.12603474956416133f}, 
				   {0.44102564102564107f, 0.7360756890168654f,   0.12485945427121897f}, 
				   {0.4375781081663435f, 0.7350962762727469f,   0.12368415897827663f}, 
				   {0.4341305753070459f, 0.7341168635286281f,   0.12250886368533427f}, 
				   {0.43191318485436136f, 0.7319464848876613f,   0.12179585120761591f}, 
				   {0.43461636402812875f, 0.7250122426593014f,   0.12293196999079352f}, 
				   {0.43731954320189614f, 0.7180780004309416f,   0.12406808877397113f}, 
				   {0.4400227223756636f, 0.7111437582025817f,   0.12520420755714873f}, 
				   {0.442725901549431f, 0.7042095159742218f,   0.12634032634032633f}, 
				   {0.44542908072319837f, 0.697275273745862f,   0.12747644512350395f}, 
				   {0.4481322598969658f, 0.690341031517502f,   0.12861256390668155f}, 
				   {0.4508354390707332f, 0.6834067892891422f,   0.12974868268985915f}, 
				   {0.4535386182445006f, 0.6764725470607823f,   0.13088480147303677f}, 
				   {0.45624179741826804f, 0.6695383048324224f,   0.13202092025621437f}, 
				   {0.4589449765920354f, 0.6626040626040626f,   0.13315703903939197f}, 
				   {0.4616481557658028f, 0.6556698203757026f,   0.1342931578225696f}, 
				   {0.46435133493957026f, 0.6487355781473428f,   0.1354292766057472f}, 
				   {0.46705451411333765f, 0.6418013359189829f,   0.1365653953889248f}, 
				   {0.46975769328710504f, 0.6348670936906231f,   0.1377015141721024f}, 
				   {0.4724608724608725f, 0.6279328514622632f,   0.13883763295528f}, 
				   {0.4751640516346399f, 0.6209986092339033f,   0.1399737517384576f}, 
				   {0.4778672308084073f, 0.6140643670055435f,   0.14110987052163523f}, 
				   {0.4805704099821747f, 0.6071301247771835f,   0.14224598930481283f}, 
				   {0.4832735891559421f, 0.6001958825488237f,   0.14338210808799043f}, 
				   {0.4859767683297095f, 0.5932616403204638f,   0.14451822687116805f}, 
				   {0.48867994750347693f, 0.586327398092104f,   0.14565434565434565f}, 
				   {0.4913831266772443f, 0.5793931558637441f,   0.14679046443752325f}, 
				   {0.49408630585101176f, 0.5724589136353841f,   0.14792658322070087f}, 
				   {0.49678948502477915f, 0.5655246714070243f,   0.14906270200387847f}, 
				   {0.49949266419854654f, 0.5585904291786644f,   0.15019882078705607f}, 
				   {0.5021958433723139f, 0.5516561869503046f,   0.1513349395702337f}, 
				   {0.5048990225460814f, 0.5447219447219447f,   0.1524710583534113f}, 
				   {0.5076022017198488f, 0.5377877024935849f,   0.1536071771365889f}, 
				   {0.5103053808936162f, 0.530853460265225f,   0.15474329591976652f}, 
				   {0.5130085600673836f, 0.523919218036865f,   0.1558794147029441f}, 
				   {0.515711739241151f, 0.5169849758085052f,   0.1570155334861217f}, 
				   {0.5184149184149184f, 0.5100507335801453f,   0.15815165226929934f}, 
				   {0.5211180975886858f, 0.5031164913517855f,   0.15928777105247693f}, 
				   {0.5238212767624533f, 0.49618224912342557f,   0.16042388983565453f}, 
				   {0.5265244559362207f, 0.4892480068950657f,   0.16156000861883213f}, 
				   {0.529227635109988f, 0.48231376466670584f,   0.16269612740200975f}, 
				   {0.5319308142837554f, 0.4753795224383459f,   0.16383224618518735f}, 
				   {0.5346339934575228f, 0.46844528020998605f,   0.16496836496836498f}, 
				   {0.5373371726312903f, 0.4615110379816262f,   0.16610448375154258f}, 
				   {0.5400403518050577f, 0.4545767957532663f,   0.16724060253472017f}, 
				   {0.5427435309788251f, 0.44764255352490645f,   0.16837672131789777f}, 
				   {0.5454467101525925f, 0.4407083112965466f,   0.1695128401010754f}, 
				   {0.5481498893263599f, 0.4337740690681867f,   0.170648958884253f}, 
				   {0.5508530685001273f, 0.4268398268398268f,   0.17178507766743062f}, 
				   {0.5535562476738948f, 0.41990558461146693f,   0.17292119645060822f}, 
				   {0.5562594268476622f, 0.41297134238310707f,   0.17405731523378581f}, 
				   {0.5589626060214296f, 0.40603710015474714f,   0.1751934340169634f}, 
				   {0.5616657851951969f, 0.39910285792638733f,   0.17632955280014104f}, 
				   {0.5643689643689643f, 0.39216861569802747f,   0.17746567158331863f}, 
				   {0.5670721435427317f, 0.3852343734696676f,   0.17860179036649626f}, 
				   {0.5697753227164992f, 0.3783001312413077f,   0.17973790914967386f}, 
				   {0.5724785018902666f, 0.3713658890129478f,   0.18087402793285146f}, 
				   {0.575181681064034f, 0.36443164678458795f,   0.18201014671602905f}, 
				   {0.5778848602378014f, 0.357497404556228f,   0.18314626549920668f}, 
				   {0.5805880394115688f, 0.35056316232786816f,   0.18428238428238428f}, 
				   {0.5832912185853362f, 0.34362892009950835f,   0.1854185030655619f}, 
				   {0.5859943977591036f, 0.3366946778711485f,   0.1865546218487395f}, 
				   {0.5886975769328711f, 0.32976043564278856f,   0.1876907406319171f}, 
				   {0.5914007561066384f, 0.3228261934144287f,   0.1888268594150947f}, 
				   {0.5941039352804058f, 0.31589195118606883f,   0.1899629781982723f}, 
				   {0.5968071144541732f, 0.3089577089577089f,   0.19109909698144992f}, 
				   {0.5995102936279406f, 0.30202346672934904f,   0.19223521576462754f}, 
				   {0.6022134728017081f, 0.29508922450098923f,   0.19337133454780514f}, 
				   {0.6049166519754755f, 0.2881549822726293f,   0.19450745333098274f}, 
				   {0.6076198311492429f, 0.28122074004426945f,   0.19564357211416034f}, 
				   {0.6103230103230103f, 0.2742864978159095f,   0.19677969089733796f}, 
				   {0.6130261894967777f, 0.2673522555875497f,   0.19791580968051556f}, 
				   {0.6157293686705451f, 0.26041801335918985f,   0.19905192846369316f}, 
				   {0.6184325478443126f, 0.2534837711308299f,   0.20018804724687078f}, 
				   {0.62113572701808f, 0.24654952890247012f,   0.20132416603004838f}, 
				   {0.6238389061918473f, 0.2396152866741102f,   0.20246028481322598f}, 
				   {0.6265420853656147f, 0.23268104444575033f,   0.20359640359640357f}, 
				   {0.6292452645393822f, 0.2257468022173904f,   0.2047325223795812f}, 
				   {0.6319484437131495f, 0.2188125599890306f,   0.2058686411627588f}, 
				   {0.634651622886917f, 0.21187831776067068f,   0.20700475994593642f}, 
				   {0.6373548020606844f, 0.20494407553231087f,   0.20814087872911402f}, 
				   {0.6400579812344518f, 0.19800983330395094f,   0.20927699751229162f}, 
				   {0.6427611604082192f, 0.19107559107559102f,   0.21041311629546922f}, 
				   {0.6454643395819866f, 0.1841413488472312f,   0.2115492350786468f}, 
				   {0.6481675187557541f, 0.1772071066188713f,   0.21268535386182447f}, 
				   {0.6508706979295215f, 0.17027286439051148f,   0.21382147264500206f}, 
				   {0.6535738771032888f, 0.16333862216215156f,   0.21495759142817966f}, 
				   {0.6562770562770562f, 0.15640437993379175f,   0.21609371021135726f}, 
				   {0.6589802354508236f, 0.14947013770543183f,   0.21722982899453486f}, 
				   {0.6616834146245911f, 0.1425358954770719f,   0.21836594777771248f}, 
				   {0.6643865937983584f, 0.1356016532487121f,   0.21950206656089008f}, 
				   {0.6670897729721259f, 0.12866741102035217f,   0.2206381853440677f}, 
				   {0.6697929521458933f, 0.12173316879199236f,   0.2217743041272453f}, 
				   {0.6724961313196607f, 0.11479892656363244f,   0.2229104229104229f}, 
				   {0.6751993104934281f, 0.10786468433527263f,   0.2240465416936005f}, 
				   {0.6779024896671955f, 0.10093044210691271f,   0.22518266047677812f}, 
				   {0.680605668840963f, 0.09399619987855279f,   0.22631877925995572f}, 
				   {0.6833088480147302f, 0.08706195765019298f,   0.22745489804313332f}, 
				   {0.6860120271884977f, 0.08012771542183306f,   0.22859101682631094f}, 
				   {0.6887152063622651f, 0.07319347319347325f,   0.22972713560948854f}, 
				   {0.6914183855360325f, 0.06625923096511332f,   0.23086325439266614f}, 
				   {0.6941215647098f, 0.059324988736753514f,   0.23199937317584374f}, 
				   {0.6968247438835673f, 0.05239074650839359f,   0.2331354919590214f}, 
				   {0.6995279230573348f, 0.04545650428003367f,   0.234271610742199f}, 
				   {0.7017609841139253f, 0.0396779690897338f,   0.23556051791345908f}, 
				   {0.6997629821159232f, 0.04430079724197371f,   0.23822452057746174f}, 
				   {0.6977649801179212f, 0.04892362539421363f,   0.24088852324146443f}, 
				   {0.6957669781199193f, 0.05354645354645354f,   0.24355252590546708f}, 
				   {0.6937689761219172f, 0.05816928169869347f,   0.24621652856946974f}, 
				   {0.6917709741239153f, 0.06279210985093338f,   0.2488805312334724f}, 
				   {0.6897729721259133f, 0.0674149380031733f,   0.25154453389747505f}, 
				   {0.6877749701279112f, 0.07203776615541321f,   0.25420853656147774f}, 
				   {0.6857769681299093f, 0.07666059430765312f,   0.2568725392254804f}, 
				   {0.6837789661319073f, 0.08128342245989303f,   0.25953654188948305f}, 
				   {0.6817809641339052f, 0.08590625061213296f,   0.26220054455348574f}, 
				   {0.6797829621359033f, 0.09052907876437288f,   0.26486454721748837f}, 
				   {0.6777849601379012f, 0.0951519069166128f,   0.26752854988149105f}, 
				   {0.6757869581398993f, 0.0997747350688527f,   0.27019255254549374f}, 
				   {0.6737889561418973f, 0.10439756322109263f,   0.27285655520949637f}, 
				   {0.6717909541438952f, 0.10902039137333254f,   0.27552055787349905f}, 
				   {0.6697929521458933f, 0.11364321952557245f,   0.27818456053750173f}, 
				   {0.6677949501478913f, 0.11826604767781237f,   0.28084856320150436f}, 
				   {0.6657969481498893f, 0.1228888758300523f,   0.28351256586550705f}, 
				   {0.6637989461518873f, 0.12751170398229222f,   0.2861765685295097f}, 
				   {0.6618009441538852f, 0.13213453213453213f,   0.28884057119351236f}, 
				   {0.6598029421558833f, 0.13675736028677205f,   0.29150457385751505f}, 
				   {0.6578049401578813f, 0.14138018843901196f,   0.2941685765215177f}, 
				   {0.6558069381598793f, 0.14600301659125187f,   0.29683257918552036f}, 
				   {0.6538089361618773f, 0.15062584474349178f,   0.299496581849523f}, 
				   {0.6518109341638753f, 0.1552486728957317f,   0.3021605845135257f}, 
				   {0.6498129321658733f, 0.15987150104797163f,   0.30482458717752836f}, 
				   {0.6478149301678713f, 0.16449432920021154f,   0.30748858984153105f}, 
				   {0.6458169281698694f, 0.16911715735245145f,   0.3101525925055337f}, 
				   {0.6438189261718673f, 0.17373998550469136f,   0.3128165951695363f}, 
				   {0.6418209241738653f, 0.1783628136569313f,   0.315480597833539f}, 
				   {0.6398229221758633f, 0.1829856418091712f,   0.3181446004975417f}, 
				   {0.6378249201778613f, 0.18760846996141115f,   0.32080860316154436f}, 
				   {0.6358269181798593f, 0.19223129811365106f,   0.323472605825547f}, 
				   {0.6338289161818573f, 0.19685412626589094f,   0.3261366084895496f}, 
				   {0.6318309141838553f, 0.20147695441813085f,   0.3288006111535523f}, 
				   {0.6298329121858534f, 0.2060997825703708f,   0.331464613817555f}, 
				   {0.6278349101878513f, 0.2107226107226107f,   0.33412861648155767f}, 
				   {0.6258369081898494f, 0.21534543887485064f,   0.3367926191455603f}, 
				   {0.6238389061918473f, 0.21996826702709055f,   0.339456621809563f}, 
				   {0.6218409041938453f, 0.22459109517933046f,   0.3421206244735656f}, 
				   {0.6198429021958434f, 0.2292139233315704f,   0.3447846271375683f}, 
				   {0.6178449001978413f, 0.23383675148381028f,   0.347448629801571f}, 
				   {0.6158468981998393f, 0.2384595796360502f,   0.3501126324655736f}, 
				   {0.6138488962018374f, 0.24308240778829013f,   0.3527766351295763f}, 
				   {0.6118508942038353f, 0.24770523594053004f,   0.35544063779357893f}, 
				   {0.6098528922058334f, 0.25232806409277f,   0.3581046404575816f}, 
				   {0.6078548902078313f, 0.2569508922450099f,   0.3607686431215843f}, 
				   {0.6058568882098294f, 0.2615737203972498f,   0.363432645785587f}, 
				   {0.6038588862118274f, 0.2661965485494897f,   0.3660966484495896f}, 
				   {0.6018608842138253f, 0.2708193767017296f,   0.36876065111359224f}, 
				   {0.5998628822158234f, 0.27544220485396953f,   0.3714246537775949f}, 
				   {0.5978648802178214f, 0.28006503300620944f,   0.3740886564415976f}, 
				   {0.5958668782198193f, 0.28468786115844935f,   0.3767526591056003f}, 
				   {0.5938688762218174f, 0.28931068931068926f,   0.3794166617696029f}, 
				   {0.5918708742238153f, 0.2939335174629292f,   0.3820806644336056f}, 
				   {0.5898728722258134f, 0.2985563456151691f,   0.38474466709760824f}, 
				   {0.5878748702278114f, 0.303179173767409f,   0.3874086697616109f}, 
				   {0.5858768682298094f, 0.3078020019196489f,   0.3900726724256136f}, 
				   {0.5838788662318074f, 0.3124248300718888f,   0.39273667508961624f}, 
				   {0.5818808642338054f, 0.3170476582241287f,   0.3954006777536189f}, 
				   {0.5798828622358034f, 0.32167048637636875f,   0.39806468041762155f}, 
				   {0.5778848602378014f, 0.32629331452860866f,   0.40072868308162424f}, 
				   {0.5758868582397993f, 0.33091614268084846f,   0.4033926857456269f}, 
				   {0.5738888562417974f, 0.3355389708330885f,   0.4060566884096296f}, 
				   {0.5718908542437954f, 0.3401617989853284f,   0.40872069107363224f}, 
				   {0.5698928522457933f, 0.3447846271375683f,   0.4113846937376349f}, 
				   {0.5678948502477914f, 0.3494074552898082f,   0.41404869640163755f}, 
				   {0.5658968482497894f, 0.3540302834420481f,   0.41671269906564024f}, 
				   {0.5638988462517874f, 0.35865311159428803f,   0.4193767017296429f}, 
				   {0.5619008442537854f, 0.36327593974652794f,   0.42204070439364555f}, 
				   {0.5599028422557835f, 0.36789876789876785f,   0.42470470705764823f}, 
				   {0.5579048402577814f, 0.37252159605100776f,   0.42736870972165086f}, 
				   {0.5559068382597794f, 0.3771444242032477f,   0.43003271238565355f}, 
				   {0.5539088362617774f, 0.3817672523554876f,   0.43269671504965623f}, 
				   {0.5519108342637754f, 0.3863900805077276f,   0.4353607177136589f}, 
				   {0.5499128322657734f, 0.3910129086599674f,   0.43802472037766155f}, 
				   {0.5479148302677714f, 0.39563573681220743f,   0.44068872304166423f}, 
				   {0.5459168282697694f, 0.40025856496444734f,   0.44335272570566686f}, 
				   {0.5439188262717675f, 0.40488139311668714f,   0.44601672836966955f}, 
				   {0.5419208242737654f, 0.40950422126892716f,   0.44868073103367223f}, 
				   {0.5399228222757635f, 0.41412704942116696f,   0.45134473369767486f}, 
				   {0.5379248202777615f, 0.418749877573407f,   0.45400873636167755f}, 
				   {0.5359268182797594f, 0.4233727057256469f,   0.4566727390256802f}, 
				   {0.5339288162817575f, 0.4279955338778868f,   0.45933674168968286f}, 
				   {0.5319308142837554f, 0.4326183620301267f,   0.46200074435368554f}, 
				   {0.5299328122857534f, 0.4372411901823666f,   0.4646647470176882f}, 
				   {0.5279348102877515f, 0.44186401833460653f,   0.46732874968169086f}, 
				   {0.5259368082897494f, 0.44648684648684644f,   0.4699927523456935f}, 
				   {0.5239388062917474f, 0.45110967463908636f,   0.4726567550096962f}, 
				   {0.5219408042937455f, 0.45573250279132627f,   0.47532075767369886f}, 
				   {0.5199428022957434f, 0.4603553309435662f,   0.47798476033770154f}, 
				   {0.5179448002977415f, 0.4649781590958061f,   0.48064876300170417f}, 
				   {0.5159467982997394f, 0.4696009872480461f,   0.48331276566570686f}, 
				   {0.5139487963017375f, 0.4742238154002859f,   0.4859767683297095f}, 
				   {0.5119507943037355f, 0.4788466435525258f,   0.4886407709937121f}, 
				   {0.5099527923057334f, 0.48346947170476584f,   0.4913047736577148f}, 
				   {0.5079547903077315f, 0.48809229985700564f,   0.4939687763217175f}, 
				   {0.5059567883097295f, 0.49271512800924566f,   0.49663277898572017f}, 
				   {0.5039587863117275f, 0.4973379561614856f,  0.4992967816497228f}};

float palette_adam[11][3]={{1.f, 0.44705882352941173f, 0.f}, 
			   {0.9607843137254902f, 0.4666666666666667f,  0.09019607843137255f}, 
			   {0.2549019607843137f, 0.7019607843137254f, 0.8627450980392157f}, 
			   {0.9254901960784314f, 0.f, 0.5490196078431373f}, 
			   {0.023529411764705882f, 0.4784313725490196f, 0.7058823529411764f}, 
			   {0.047058823529411764f, 0.14509803921568626f, 0.4666666666666667f}, 
			   {0.5058823529411764f, 0.00392156862745098f, 0.10196078431372549f}, 
			   {0.7764705882352941f, 0.8313725490196078f, 0.2392156862745098f}, 
			   {0.43137254901960786f, 0.7333333333333333f, 0.12156862745098039f}, 
			   {0.7019607843137254f, 0.0392156862745098f, 0.23529411764705882f}, 
			   {0.5019607843137255f, 0.5019607843137255f, 0.5019607843137255f}};



