/*
 *  GRUB  --  GRand Unified Bootloader
 *  Copyright (C) 2013  Free Software Foundation, Inc.
 *
 *  GRUB is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  GRUB is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GRUB.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <grub/symbol.h>
#include <grub/dl.h>

	.file	"misc.S"
	.text
	.syntax	unified
#if !defined (__thumb2__)
	.arm
#define ARM(x...)	x
#define THUMB(x...)
#else
	.thumb
#define THUMB(x...)	x
#define ARM(x...)
#endif

	.align	2

/*
 * Null divide-by-zero handler
 */
FUNCTION(raise)
	mov	r0, #0
	bx	lr
	
	.end
