#! /usr/bin/awk -f

function launchdialog( dialog, array ){
  tempfile= "/tmp/awk" PROCINFO["pid"]
  print dialog >tempfile; close(tempfile)
  
  oldfs=FS; FS="="
  while( (("gtkdialog -f " tempfile) | getline)>0 )
    array[$1]=substr($2, 2, length($2)-2 )
 
  close("gtkdialog -f " tempfile)

  FS=oldfs
  system( "rm -f " tempfile )
}#launchdialog

BEGIN {
MAIN_DIALOG="\n\
<vbox>\n\
  <frame Print fields>\n\
    <hbox>\n\
      <text>\n\
        <label>From:</label>\n\
      </text>\n\
      <entry><variable>FROM</variable>\
            <default>1</default> </entry>\n\
    </hbox>\n\
    <hbox>\n\
      <text>\n\
        <label>To:</label>\n\
      </text>\n\
      <entry><variable>TO</variable>\
             <default>3</default></entry>\n\
    </hbox>\n\
  </frame>\n\
  <hbox>\
    <button ok></button>\n\
    <button cancel></button>\n\
  </hbox>\
</vbox>\n\
"
  launchdialog( MAIN_DIALOG, variables)
  if( variables["EXIT"]=="Cancel" )
    exit
}

{
  for( n=1; n<=NF; ++n )
    if( n>=strtonum(variables["FROM"]) && 
        n<=strtonum(variables["TO"]) )
      printf "%6.2f ", $n

  printf "\n"
}

