%{
/*
** $Id: lexer.l,v 1.2 2004/11/20 20:01:25 root Exp root $
** $Log: lexer.l,v $
** Revision 1.2  2004/11/20 20:01:25  root
** - Log entries.
**
*/
#define YY_INPUT(buf,result,max_size) \
    { \
    int c = getnextchar(); \
    result = (c == EOF) ? YY_NULL : (buf[0] = c, 1); \
    }

#include <string.h>
#include "gtkdialog.h"
#include "parser.h"

char *process_string(char *str);

extern int linenumber;
char *Token;
%}

%%

">"       { Token=">"; return(yytext[0]); }
$[ \t\n]* { Token="indent chars"; }

[a-zA-Z_]+=/\" { 
                 Token="tag attribute";
		 yylval.cval=strdup(yytext);
		 return TAG_ATTR_NAME;
               }


\<title\>    { Token="<title>"; return(BEGINTITLE); }
\<\/title\>  { Token="</title>"; return(ENDTITLE);   }

\<vbox\>     { Token="<vbox>"; return(VBOX);    }
\<\/vbox\>   { Token="</vbox>"; return(EVBOX);   }
\<notebook\>     { Token="<notebook>"; return(NOTEBOOK);    }
\<\/notebook\>   { Token="</notebook>"; return(ENOTEBOOK);   }
\<notebook[ ]+  { Token="<notebook>"; return(PART_NOTEBOOK); }
\<hbox\>     { Token="<hbox>"; return(HBOX);    }
\<\/hbox\>   { Token="</hbox>"; return(EHBOX);   }
\<frame\>    { Token="<frame>"; yylval.cval=NULL;  return(FRAME); }
\<frame\ [^\>]+\>     {
       			Token="<frame>";
                        yylval.cval=strdup(&yytext[7]);  
                        yylval.cval[strlen(yylval.cval)-1]=0;
                        return(FRAME); 
                      }
\<\/frame\>   { Token="</frame>"; return(EFRAME);   }


\<text\>     { Token="<text>"; return(TEXT);   }
\<\/text\>   { Token="</text>"; return(ETEXT);   }
\<pixmap\>   { Token="<pixmap>"; return(PIXMAP); }
\<\/pixmap\> { Token="</pixmap>"; return(EPIXMAP); }

\<entry\>    { Token="<entry>"; return(ENTRY);   }
\<\/entry\>  { Token="</entry>"; return(EENTRY); }
\<entry[ ]+  { Token="<entry>"; return(PART_ENTRY); }
\<edit\>     { Token="<edit>"; return(EDIT);     }
\<\/edit\>   { Token="</edit>"; return(EEDIT);   }
\<tree\>     { Token="<tree>"; return(TREE);     }
\<\/tree\>   { Token="</tree>"; return(ETREE);   }
\<chooser\>     { Token="<chooser>"; return(CHOOSER);     }
\<\/chooser\>   { Token="</chooser>"; return(ECHOOSER);   }

\<button\>    { Token="<button>"; return(BUTTON);  }
\<\/button\>  { Token="</button>"; return(EBUTTON);  }
\<button\ ok\>      { Token="<button>"; return(BUTTONOK);  }
\<button\ cancel\>  { Token="<button>"; return(BUTTONCANCEL);  }
\<button\ help\>    { Token="<button>"; return(BUTTONHELP);  }
\<button\ yes\>     { Token="<button>"; return(BUTTONYES);  }
\<button\ no\>      { Token="<button>"; return(BUTTONNO);  }

\<checkbox\>	{ Token="<checkbox>"; return(CHECKBOX);  }
\<\/checkbox\>  { Token="</checkbox>"; return(ECHECKBOX);  }
\<radiobutton\>    { Token="<radiobutton>"; return(RADIO);  }
\<\/radiobutton\>  { Token="</radiobutton>"; return(ERADIO);  }
\<radio\>    { Token="<radio>"; return(RADIO);  }
\<\/radio\>  { Token="</radio>"; return(ERADIO);  }
\<gvim\>     { Token="<gvim>"; return(GVIM);  }
\<\/gvim\>   { Token="</gvim>"; return(EGVIM);  }

\<combobox\>    { Token="<combobox>"; return(COMBO);  	}
\<\/combobox\>  { Token="</combobox>"; return(ECOMBO);  }
\<list\>    	{ Token="<list>"; return(LIST);  	}
\<\/list\>  	{ Token="</list>"; return(ELIST);  	}
\<table\>    	{ Token="<table>"; return(TABLE);  	}
\<\/table\>  	{ Token="</table>"; return(ETABLE);  	}
\<menubar\>    	{ Token="<menubar>"; return(MENUBAR);  	}
\<\/menubar\>  	{ Token="</menubar>"; return(EMENUBAR);	}
\<menu\>    	{ Token="<menu>"; return(MENU);  	}
\<\/menu\>  	{ Token="</menu>"; return(EMENU);	}
\<menuitem\>    { Token="<menuitem>"; return(MENUITEM);  	}
\<\/menuitem\>  { Token="</menuitem>"; return(EMENUITEM);	}


\<wtitle\>    	{ Token="<wtitle>"; return(WTITLE);  	}
\<\/wtitle\>  	{ Token="</wtitle>"; return(EWTITLE);  	}

\<label\>    { Token="<label>"; return(LABEL);    }
\<\/label\>  { Token="</label>"; return(ELABEL);  }
\<item\>     { Token="<item>"; return(ITEM);      }
\<\/item\>   { Token="</item>"; return(EITEM);    }
\<item[ ]+   { Token="<item>"; return(PART_ITEM); }


\<default\>      { Token="<default>"; return(DEFAULT);  }
\<\/default\>    { Token="</default>"; return(EDEFAULT);  }
\<visible\>      { Token="<visible>"; return(VISIBLE);  }
\<\/visible\>    { Token="</visible>"; return(EVISIBLE);  }
\<variable\>     { Token="<variable>"; return(VARIABLE); }
\<\/variable\>   { Token="</variable>"; return(EVARIABLE); }
\<height\>       { Token="<height>"; return(HEIGHT);  }
\<\/height\>     { Token="</height>"; return(EHEIGHT);  }
\<width\>        { Token="<width>"; return(WIDTH);   }
\<\/width\>      { Token="</width>"; return(EWIDTH);   }
\<input\>        { Token="<input>"; return(INPUT);   }
\<\/input\>      { Token="</input>"; return(EINPUT);   }
\<\input\ file\> { Token="<input file>"; return(INPUTFILE);   }
\<\input\ file[ ]+ { Token="<input file>"; return(PART_INPUTFILE);   }
\<\input\ [ ]*   { Token="<input>"; return(PART_INPUT);   }


\<output\>        { Token="<output>"; return(OUTPUT);   }
\<\/output\>      { Token="</output>"; return(EOUTPUT);   }
\<\output\ file\> { Token="<output>"; return(OUTPUTFILE);   }

\<action\ clear\>            { Token="<action>"; return(ACTIONCLEAR);}
\<action\ removeselected\>   { Token="<action>"; return(ACTIONREMOVE);}
\<action\ fileselection\>    { Token="<action>"; return(ACTIONFILESEL);}
\<action\ refresh\>          { Token="<action>"; return(ACTIONREFRESH);}
\<action\ launchwindow\>     { Token="<action>"; return(ACTIONLAUNCH);}
\<action\ append\>           { Token="<action>"; return(ACTIONAPPEND);}
\<action\ copy\>             { Token="<action>"; return(ACTIONAPPEND);}

\<action\>                   { Token="<action>"; return(ACTION);      }
\<action[ ]+                 { Token="<action>"; return(PART_ACTION); }
\<\/action\>                 { Token="</action>"; return(EACTION);    }

\<\/[^> ]*\>   { Token=strdup(yytext); 
		yyerror("Unknown end tag.");    }
\<[^> ]*\>     { Token=strdup(yytext); 
		yyerror("Unknown tag.");    }

\"[^\"]*\"  {
	Token="quoted string";
	yylval.cval=process_string(&yytext[1]);
	yylval.cval[strlen(yylval.cval)-1]='\0';
	return(STRING);
}


[^ \n\t\>\<\"][^\<\>\n\"]*  {
	yylval.cval=strdup(yytext);
	Token=yylval.cval;
	return(STRING);
}

\n { 
	++linenumber;
   }

[\t ] {
 /* 
  */
}

%%

char *process_string(char *str){
  //fprintf(stderr, "%s(): Input = '%s'\n", __func__, str);
  // FIXME: Well, this will come tomorrow...
  return strdup(str);
}
