// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/sql/v1beta4/cloud_sql_users.proto

package sql

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The user type.
type User_SqlUserType int32

const (
	// The database's built-in user type.
	User_BUILT_IN User_SqlUserType = 0
	// Cloud IAM user.
	User_CLOUD_IAM_USER User_SqlUserType = 1
	// Cloud IAM service account.
	User_CLOUD_IAM_SERVICE_ACCOUNT User_SqlUserType = 2
)

// Enum value maps for User_SqlUserType.
var (
	User_SqlUserType_name = map[int32]string{
		0: "BUILT_IN",
		1: "CLOUD_IAM_USER",
		2: "CLOUD_IAM_SERVICE_ACCOUNT",
	}
	User_SqlUserType_value = map[string]int32{
		"BUILT_IN":                  0,
		"CLOUD_IAM_USER":            1,
		"CLOUD_IAM_SERVICE_ACCOUNT": 2,
	}
)

func (x User_SqlUserType) Enum() *User_SqlUserType {
	p := new(User_SqlUserType)
	*p = x
	return p
}

func (x User_SqlUserType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (User_SqlUserType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_enumTypes[0].Descriptor()
}

func (User_SqlUserType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_enumTypes[0]
}

func (x User_SqlUserType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use User_SqlUserType.Descriptor instead.
func (User_SqlUserType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP(), []int{6, 0}
}

type SqlUsersDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Host of the user in the instance.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the user in the instance.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlUsersDeleteRequest) Reset() {
	*x = SqlUsersDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlUsersDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlUsersDeleteRequest) ProtoMessage() {}

func (x *SqlUsersDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlUsersDeleteRequest.ProtoReflect.Descriptor instead.
func (*SqlUsersDeleteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP(), []int{0}
}

func (x *SqlUsersDeleteRequest) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *SqlUsersDeleteRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlUsersDeleteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SqlUsersDeleteRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlUsersUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Host of the user in the instance.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the user in the instance.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
	Body    *User  `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlUsersUpdateRequest) Reset() {
	*x = SqlUsersUpdateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlUsersUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlUsersUpdateRequest) ProtoMessage() {}

func (x *SqlUsersUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlUsersUpdateRequest.ProtoReflect.Descriptor instead.
func (*SqlUsersUpdateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP(), []int{1}
}

func (x *SqlUsersUpdateRequest) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *SqlUsersUpdateRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlUsersUpdateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SqlUsersUpdateRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlUsersUpdateRequest) GetBody() *User {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlUsersInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *User  `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlUsersInsertRequest) Reset() {
	*x = SqlUsersInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlUsersInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlUsersInsertRequest) ProtoMessage() {}

func (x *SqlUsersInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlUsersInsertRequest.ProtoReflect.Descriptor instead.
func (*SqlUsersInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP(), []int{2}
}

func (x *SqlUsersInsertRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlUsersInsertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlUsersInsertRequest) GetBody() *User {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlUsersListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlUsersListRequest) Reset() {
	*x = SqlUsersListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlUsersListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlUsersListRequest) ProtoMessage() {}

func (x *SqlUsersListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlUsersListRequest.ProtoReflect.Descriptor instead.
func (*SqlUsersListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP(), []int{3}
}

func (x *SqlUsersListRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlUsersListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// User level password validation policy.
type UserPasswordValidationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of failed login attempts allowed before user get locked.
	AllowedFailedAttempts int32 `protobuf:"varint,1,opt,name=allowed_failed_attempts,json=allowedFailedAttempts,proto3" json:"allowed_failed_attempts,omitempty"`
	// Expiration duration after password is updated.
	PasswordExpirationDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=password_expiration_duration,json=passwordExpirationDuration,proto3" json:"password_expiration_duration,omitempty"`
	// If true, failed login attempts check will be enabled.
	EnableFailedAttemptsCheck bool `protobuf:"varint,3,opt,name=enable_failed_attempts_check,json=enableFailedAttemptsCheck,proto3" json:"enable_failed_attempts_check,omitempty"`
	// Output only. Read-only password status.
	Status *PasswordStatus `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *UserPasswordValidationPolicy) Reset() {
	*x = UserPasswordValidationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserPasswordValidationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserPasswordValidationPolicy) ProtoMessage() {}

func (x *UserPasswordValidationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserPasswordValidationPolicy.ProtoReflect.Descriptor instead.
func (*UserPasswordValidationPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP(), []int{4}
}

func (x *UserPasswordValidationPolicy) GetAllowedFailedAttempts() int32 {
	if x != nil {
		return x.AllowedFailedAttempts
	}
	return 0
}

func (x *UserPasswordValidationPolicy) GetPasswordExpirationDuration() *durationpb.Duration {
	if x != nil {
		return x.PasswordExpirationDuration
	}
	return nil
}

func (x *UserPasswordValidationPolicy) GetEnableFailedAttemptsCheck() bool {
	if x != nil {
		return x.EnableFailedAttemptsCheck
	}
	return false
}

func (x *UserPasswordValidationPolicy) GetStatus() *PasswordStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

// Read-only password status.
type PasswordStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, user does not have login privileges.
	Locked bool `protobuf:"varint,1,opt,name=locked,proto3" json:"locked,omitempty"`
	// The expiration time of the current password.
	PasswordExpirationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=password_expiration_time,json=passwordExpirationTime,proto3" json:"password_expiration_time,omitempty"`
}

func (x *PasswordStatus) Reset() {
	*x = PasswordStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PasswordStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PasswordStatus) ProtoMessage() {}

func (x *PasswordStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PasswordStatus.ProtoReflect.Descriptor instead.
func (*PasswordStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP(), []int{5}
}

func (x *PasswordStatus) GetLocked() bool {
	if x != nil {
		return x.Locked
	}
	return false
}

func (x *PasswordStatus) GetPasswordExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PasswordExpirationTime
	}
	return nil
}

// A Cloud SQL user resource.
type User struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always <b>sql#user</b>.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The password for the user.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// This field is deprecated and will be removed from a future version of the
	// API.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// The name of the user in the Cloud SQL instance. Can be omitted for
	// **update** since it is already specified in the URL.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The host name from which the user can connect. For **insert**
	// operations, host defaults to an empty string. For **update**
	// operations, host is specified as part of the request URL. The host name
	// cannot be updated after insertion.  For a MySQL instance, it's required;
	// for a PostgreSQL or SQL Server instance, it's optional.
	Host string `protobuf:"bytes,5,opt,name=host,proto3" json:"host,omitempty"`
	// The name of the Cloud SQL instance. This does not include the project ID.
	// Can be omitted for <b>update</b> since it is already specified on the
	// URL.
	Instance string `protobuf:"bytes,6,opt,name=instance,proto3" json:"instance,omitempty"`
	// The project ID of the project containing the Cloud SQL database. The Google
	// apps domain is prefixed if applicable. Can be omitted for
	// <b>update</b> since it is already specified on the URL.
	Project string `protobuf:"bytes,7,opt,name=project,proto3" json:"project,omitempty"`
	// The user type. It determines the method to authenticate the user during
	// login. The default is the database's built-in user type.
	Type User_SqlUserType `protobuf:"varint,8,opt,name=type,proto3,enum=google.cloud.sql.v1beta4.User_SqlUserType" json:"type,omitempty"`
	// User details for specific database type
	//
	// Types that are assignable to UserDetails:
	//	*User_SqlserverUserDetails
	UserDetails isUser_UserDetails `protobuf_oneof:"user_details"`
	// User level password validation policy.
	PasswordPolicy *UserPasswordValidationPolicy `protobuf:"bytes,12,opt,name=password_policy,json=passwordPolicy,proto3" json:"password_policy,omitempty"`
}

func (x *User) Reset() {
	*x = User{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *User) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*User) ProtoMessage() {}

func (x *User) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use User.ProtoReflect.Descriptor instead.
func (*User) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP(), []int{6}
}

func (x *User) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *User) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *User) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *User) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *User) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *User) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *User) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *User) GetType() User_SqlUserType {
	if x != nil {
		return x.Type
	}
	return User_BUILT_IN
}

func (m *User) GetUserDetails() isUser_UserDetails {
	if m != nil {
		return m.UserDetails
	}
	return nil
}

func (x *User) GetSqlserverUserDetails() *SqlServerUserDetails {
	if x, ok := x.GetUserDetails().(*User_SqlserverUserDetails); ok {
		return x.SqlserverUserDetails
	}
	return nil
}

func (x *User) GetPasswordPolicy() *UserPasswordValidationPolicy {
	if x != nil {
		return x.PasswordPolicy
	}
	return nil
}

type isUser_UserDetails interface {
	isUser_UserDetails()
}

type User_SqlserverUserDetails struct {
	SqlserverUserDetails *SqlServerUserDetails `protobuf:"bytes,9,opt,name=sqlserver_user_details,json=sqlserverUserDetails,proto3,oneof"`
}

func (*User_SqlserverUserDetails) isUser_UserDetails() {}

// Represents a Sql Server user on the Cloud SQL instance.
type SqlServerUserDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If the user has been disabled
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// The server roles for this user
	ServerRoles []string `protobuf:"bytes,2,rep,name=server_roles,json=serverRoles,proto3" json:"server_roles,omitempty"`
}

func (x *SqlServerUserDetails) Reset() {
	*x = SqlServerUserDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlServerUserDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlServerUserDetails) ProtoMessage() {}

func (x *SqlServerUserDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlServerUserDetails.ProtoReflect.Descriptor instead.
func (*SqlServerUserDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP(), []int{7}
}

func (x *SqlServerUserDetails) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *SqlServerUserDetails) GetServerRoles() []string {
	if x != nil {
		return x.ServerRoles
	}
	return nil
}

// User list response.
type UsersListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always <b>sql#usersList</b>.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of user resources in the instance.
	Items []*User `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	// An identifier that uniquely identifies the operation. You can use this
	// identifier to retrieve the Operations resource that has information about
	// the operation.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *UsersListResponse) Reset() {
	*x = UsersListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UsersListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsersListResponse) ProtoMessage() {}

func (x *UsersListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsersListResponse.ProtoReflect.Descriptor instead.
func (*UsersListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP(), []int{8}
}

func (x *UsersListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *UsersListResponse) GetItems() []*User {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *UsersListResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_sql_v1beta4_cloud_sql_users_proto protoreflect.FileDescriptor

var file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x75, 0x0a, 0x15, 0x53, 0x71, 0x6c, 0x55, 0x73,
	0x65, 0x72, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x68, 0x6f, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xae,
	0x01, 0x0a, 0x15, 0x53, 0x71, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x68, 0x6f, 0x73,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x32, 0x0a, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22,
	0x81, 0x01, 0x0a, 0x15, 0x53, 0x71, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x49, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x32, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x22, 0x4b, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x22, 0xbb, 0x02, 0x0a, 0x1c, 0x55, 0x73, 0x65, 0x72, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x36, 0x0a, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x66, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x46, 0x61, 0x69, 0x6c, 0x65,
	0x64, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x5b, 0x0a, 0x1c, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1a, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73,
	0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70,
	0x74, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x45, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x7e,
	0x0a, 0x0e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x12, 0x54, 0x0a, 0x18, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x16, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x96,
	0x04, 0x0a, 0x04, 0x55, 0x73, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x3e,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x2e, 0x53, 0x71, 0x6c,
	0x55, 0x73, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x66,
	0x0a, 0x16, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00,
	0x52, 0x14, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x5f, 0x0a, 0x0f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x50,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0e, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x4e, 0x0a, 0x0b, 0x53, 0x71, 0x6c, 0x55, 0x73,
	0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x42, 0x55, 0x49, 0x4c, 0x54, 0x5f,
	0x49, 0x4e, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x49, 0x41,
	0x4d, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4c, 0x4f, 0x55,
	0x44, 0x5f, 0x49, 0x41, 0x4d, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x43,
	0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x02, 0x42, 0x0e, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x55, 0x0a, 0x14, 0x53, 0x71, 0x6c, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x22, 0x85,
	0x01, 0x0a, 0x11, 0x55, 0x73, 0x65, 0x72, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x34, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xb3, 0x06, 0x0a, 0x0f, 0x53, 0x71, 0x6c, 0x55, 0x73,
	0x65, 0x72, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xa2, 0x01, 0x0a, 0x06, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x53, 0x71, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x42, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3c, 0x2a, 0x3a, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x12,
	0xa8, 0x01, 0x0a, 0x06, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x49, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x3a, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x75,
	0x73, 0x65, 0x72, 0x73, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xa6, 0x01, 0x0a, 0x04, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53,
	0x71, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x75, 0x73,
	0x65, 0x72, 0x73, 0x12, 0xa8, 0x01, 0x0a, 0x06, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x55, 0x73, 0x65,
	0x72, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x1a, 0x3a, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x1a, 0x7c,
	0xca, 0x41, 0x17, 0x73, 0x71, 0x6c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5f, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x71, 0x6c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x42, 0x71, 0x0a, 0x1c,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x42, 0x12, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x3b, 0x73, 0x71, 0x6c, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescOnce sync.Once
	file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescData = file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDesc
)

func file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescGZIP() []byte {
	file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescOnce.Do(func() {
		file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescData)
	})
	return file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDescData
}

var file_google_cloud_sql_v1beta4_cloud_sql_users_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_sql_v1beta4_cloud_sql_users_proto_goTypes = []interface{}{
	(User_SqlUserType)(0),                // 0: google.cloud.sql.v1beta4.User.SqlUserType
	(*SqlUsersDeleteRequest)(nil),        // 1: google.cloud.sql.v1beta4.SqlUsersDeleteRequest
	(*SqlUsersUpdateRequest)(nil),        // 2: google.cloud.sql.v1beta4.SqlUsersUpdateRequest
	(*SqlUsersInsertRequest)(nil),        // 3: google.cloud.sql.v1beta4.SqlUsersInsertRequest
	(*SqlUsersListRequest)(nil),          // 4: google.cloud.sql.v1beta4.SqlUsersListRequest
	(*UserPasswordValidationPolicy)(nil), // 5: google.cloud.sql.v1beta4.UserPasswordValidationPolicy
	(*PasswordStatus)(nil),               // 6: google.cloud.sql.v1beta4.PasswordStatus
	(*User)(nil),                         // 7: google.cloud.sql.v1beta4.User
	(*SqlServerUserDetails)(nil),         // 8: google.cloud.sql.v1beta4.SqlServerUserDetails
	(*UsersListResponse)(nil),            // 9: google.cloud.sql.v1beta4.UsersListResponse
	(*durationpb.Duration)(nil),          // 10: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),        // 11: google.protobuf.Timestamp
	(*Operation)(nil),                    // 12: google.cloud.sql.v1beta4.Operation
}
var file_google_cloud_sql_v1beta4_cloud_sql_users_proto_depIdxs = []int32{
	7,  // 0: google.cloud.sql.v1beta4.SqlUsersUpdateRequest.body:type_name -> google.cloud.sql.v1beta4.User
	7,  // 1: google.cloud.sql.v1beta4.SqlUsersInsertRequest.body:type_name -> google.cloud.sql.v1beta4.User
	10, // 2: google.cloud.sql.v1beta4.UserPasswordValidationPolicy.password_expiration_duration:type_name -> google.protobuf.Duration
	6,  // 3: google.cloud.sql.v1beta4.UserPasswordValidationPolicy.status:type_name -> google.cloud.sql.v1beta4.PasswordStatus
	11, // 4: google.cloud.sql.v1beta4.PasswordStatus.password_expiration_time:type_name -> google.protobuf.Timestamp
	0,  // 5: google.cloud.sql.v1beta4.User.type:type_name -> google.cloud.sql.v1beta4.User.SqlUserType
	8,  // 6: google.cloud.sql.v1beta4.User.sqlserver_user_details:type_name -> google.cloud.sql.v1beta4.SqlServerUserDetails
	5,  // 7: google.cloud.sql.v1beta4.User.password_policy:type_name -> google.cloud.sql.v1beta4.UserPasswordValidationPolicy
	7,  // 8: google.cloud.sql.v1beta4.UsersListResponse.items:type_name -> google.cloud.sql.v1beta4.User
	1,  // 9: google.cloud.sql.v1beta4.SqlUsersService.Delete:input_type -> google.cloud.sql.v1beta4.SqlUsersDeleteRequest
	3,  // 10: google.cloud.sql.v1beta4.SqlUsersService.Insert:input_type -> google.cloud.sql.v1beta4.SqlUsersInsertRequest
	4,  // 11: google.cloud.sql.v1beta4.SqlUsersService.List:input_type -> google.cloud.sql.v1beta4.SqlUsersListRequest
	2,  // 12: google.cloud.sql.v1beta4.SqlUsersService.Update:input_type -> google.cloud.sql.v1beta4.SqlUsersUpdateRequest
	12, // 13: google.cloud.sql.v1beta4.SqlUsersService.Delete:output_type -> google.cloud.sql.v1beta4.Operation
	12, // 14: google.cloud.sql.v1beta4.SqlUsersService.Insert:output_type -> google.cloud.sql.v1beta4.Operation
	9,  // 15: google.cloud.sql.v1beta4.SqlUsersService.List:output_type -> google.cloud.sql.v1beta4.UsersListResponse
	12, // 16: google.cloud.sql.v1beta4.SqlUsersService.Update:output_type -> google.cloud.sql.v1beta4.Operation
	13, // [13:17] is the sub-list for method output_type
	9,  // [9:13] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_sql_v1beta4_cloud_sql_users_proto_init() }
func file_google_cloud_sql_v1beta4_cloud_sql_users_proto_init() {
	if File_google_cloud_sql_v1beta4_cloud_sql_users_proto != nil {
		return
	}
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlUsersDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlUsersUpdateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlUsersInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlUsersListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserPasswordValidationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PasswordStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*User); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlServerUserDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UsersListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*User_SqlserverUserDetails)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_sql_v1beta4_cloud_sql_users_proto_goTypes,
		DependencyIndexes: file_google_cloud_sql_v1beta4_cloud_sql_users_proto_depIdxs,
		EnumInfos:         file_google_cloud_sql_v1beta4_cloud_sql_users_proto_enumTypes,
		MessageInfos:      file_google_cloud_sql_v1beta4_cloud_sql_users_proto_msgTypes,
	}.Build()
	File_google_cloud_sql_v1beta4_cloud_sql_users_proto = out.File
	file_google_cloud_sql_v1beta4_cloud_sql_users_proto_rawDesc = nil
	file_google_cloud_sql_v1beta4_cloud_sql_users_proto_goTypes = nil
	file_google_cloud_sql_v1beta4_cloud_sql_users_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SqlUsersServiceClient is the client API for SqlUsersService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlUsersServiceClient interface {
	// Deletes a user from a Cloud SQL instance.
	Delete(ctx context.Context, in *SqlUsersDeleteRequest, opts ...grpc.CallOption) (*Operation, error)
	// Creates a new user in a Cloud SQL instance.
	Insert(ctx context.Context, in *SqlUsersInsertRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists users in the specified Cloud SQL instance.
	List(ctx context.Context, in *SqlUsersListRequest, opts ...grpc.CallOption) (*UsersListResponse, error)
	// Updates an existing user in a Cloud SQL instance.
	Update(ctx context.Context, in *SqlUsersUpdateRequest, opts ...grpc.CallOption) (*Operation, error)
}

type sqlUsersServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlUsersServiceClient(cc grpc.ClientConnInterface) SqlUsersServiceClient {
	return &sqlUsersServiceClient{cc}
}

func (c *sqlUsersServiceClient) Delete(ctx context.Context, in *SqlUsersDeleteRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlUsersService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlUsersServiceClient) Insert(ctx context.Context, in *SqlUsersInsertRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlUsersService/Insert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlUsersServiceClient) List(ctx context.Context, in *SqlUsersListRequest, opts ...grpc.CallOption) (*UsersListResponse, error) {
	out := new(UsersListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlUsersService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlUsersServiceClient) Update(ctx context.Context, in *SqlUsersUpdateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlUsersService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlUsersServiceServer is the server API for SqlUsersService service.
type SqlUsersServiceServer interface {
	// Deletes a user from a Cloud SQL instance.
	Delete(context.Context, *SqlUsersDeleteRequest) (*Operation, error)
	// Creates a new user in a Cloud SQL instance.
	Insert(context.Context, *SqlUsersInsertRequest) (*Operation, error)
	// Lists users in the specified Cloud SQL instance.
	List(context.Context, *SqlUsersListRequest) (*UsersListResponse, error)
	// Updates an existing user in a Cloud SQL instance.
	Update(context.Context, *SqlUsersUpdateRequest) (*Operation, error)
}

// UnimplementedSqlUsersServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlUsersServiceServer struct {
}

func (*UnimplementedSqlUsersServiceServer) Delete(context.Context, *SqlUsersDeleteRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSqlUsersServiceServer) Insert(context.Context, *SqlUsersInsertRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (*UnimplementedSqlUsersServiceServer) List(context.Context, *SqlUsersListRequest) (*UsersListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedSqlUsersServiceServer) Update(context.Context, *SqlUsersUpdateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

func RegisterSqlUsersServiceServer(s *grpc.Server, srv SqlUsersServiceServer) {
	s.RegisterService(&_SqlUsersService_serviceDesc, srv)
}

func _SqlUsersService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlUsersDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlUsersServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlUsersService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlUsersServiceServer).Delete(ctx, req.(*SqlUsersDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlUsersService_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlUsersInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlUsersServiceServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlUsersService/Insert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlUsersServiceServer).Insert(ctx, req.(*SqlUsersInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlUsersService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlUsersListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlUsersServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlUsersService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlUsersServiceServer).List(ctx, req.(*SqlUsersListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlUsersService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlUsersUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlUsersServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlUsersService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlUsersServiceServer).Update(ctx, req.(*SqlUsersUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlUsersService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1beta4.SqlUsersService",
	HandlerType: (*SqlUsersServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _SqlUsersService_Delete_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _SqlUsersService_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SqlUsersService_List_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SqlUsersService_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1beta4/cloud_sql_users.proto",
}
