{-
    Extra components.
    Copyright (C) 2007, 2008 Luis Francisco Araujo <araujo@gentoo.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
-}

module Components 
    where

import Util
import Graphics.UI.Gtk


comment :: String
comment = "Haskell Graphical User Interface for Emerge"

copyright :: String
copyright = "Copyright 2007-2008"

url :: String
url = "http://www.haskell.org/himerge/"

aboutHimerge :: IO ()
{- | Himerge programm information dialog. -}
aboutHimerge =
    do
    about <- aboutDialogNew
    aboutDialogSetName about hname
    aboutDialogSetVersion about hversion
    aboutDialogSetComments about comment
    aboutDialogSetWebsite about url
    aboutDialogSetCopyright about (copyright ++ " Luis Francisco Araujo\n\
				  \ <araujo@gentoo.org>")
    pix <- pixbufNewFromFile =<< iconpath (IconName "himerge")
    aboutDialogSetLogo about (Just pix)
    aboutDialogSetLicense about (Just license)
    aboutDialogSetArtists about ["Josef Vybíral <cornelius@vybiral.info>"
				, "Most of the icons designed by the Tango Project \
				 \on\n<http://tango.freedesktop.org> under the \
				 \\nCC License <http://creativecommons.org/licenses/by-sa/2.5/>" ]

    about `onResponse` 
	  \ _ -> widgetDestroy about
    widgetShowAll about

license :: String
license =  
    "This program is free software; you can redistribute it and/or modify\n\
    \ it under the terms of the GNU General Public License as published by\n\
    \ the Free Software Foundation; either version 2 of the License, or\n\
    \ (at your option) any later version.\n\n\
    \This program is distributed in the hope that it will be useful,\n\
    \but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
    \MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
    \GNU General Public License for more details.\n\n\
    \You should have received a copy of the GNU General Public License\n\
    \along with this program; if not, write to the Free Software\n\
    \nFoundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA"
