{-
    All the short-cut keys for Himerge.
    Copyright (C) 2007, 2008 Luis Francisco Araujo <araujo@gentoo.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
-}

module SCKeys
    where

import Graphics.UI.Gtk

{- | Accelerators short cut keys -}
acceOpenNew :: IO () -> Event -> IO Bool
acceOpenNew func (Key { eventModifier = [Control], eventKeyName = "n" }) = func >> return True
acceOpenNew _ _ = return False

acceOpenNewRepo :: IO () -> Event -> IO Bool
acceOpenNewRepo func (Key { eventModifier = [Control], eventKeyName = "r" }) = func >> return True
acceOpenNewRepo _ _ = return False

acceUseFlag :: IO () -> Event -> IO Bool
acceUseFlag func (Key { eventModifier = [Control], eventKeyName = "f" }) = func >> return True
acceUseFlag _ _ = return False

acceSaveCurrentPage :: IO () -> Event -> IO Bool
acceSaveCurrentPage func (Key { eventModifier = [Control], eventKeyName = "s" }) = func >> return True
acceSaveCurrentPage _ _ = return False

acceSaveAllPages :: IO () -> Event -> IO Bool
acceSaveAllPages func (Key { eventModifier = [Control], eventKeyName = "a" }) = func >> return True
acceSaveAllPages _ _ = return False

accePackagesBranch :: IO () -> Event -> IO Bool
accePackagesBranch func (Key { eventModifier = [Control], eventKeyName = "b" }) = func >> return True
accePackagesBranch _ _ = return False

acceUpdateEix :: IO () -> Event -> IO Bool
acceUpdateEix func (Key { eventModifier = [Control], eventKeyName = "u" }) = func >> return True
acceUpdateEix _ _ = return False

accePortageInfo :: IO () -> Event -> IO Bool
accePortageInfo func (Key { eventModifier = [Control], eventKeyName = "i" }) = func >> return True
accePortageInfo _ _ = return False

acceMetadata :: IO () -> Event -> IO Bool
acceMetadata func (Key { eventModifier = [Control], eventKeyName = "m" }) = func >> return True
acceMetadata _ _ = return False

acceHelp :: IO () -> Event -> IO Bool
acceHelp func (Key { eventModifier = [Control], eventKeyName = "h" }) = func >> return True
acceHelp _ _ = return False

{- | Short-Cut-Keys to the basic emerge operations (toolbar buttons) -}
queueSCK :: IO () -> Event -> IO Bool
queueSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "q" }) = func >> return True
queueSCK _ _ = return False

revdepSCK :: IO () -> Event -> IO Bool
revdepSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "r" }) = func >> return True
revdepSCK _ _ = return False

worldSCK :: IO () -> Event -> IO Bool
worldSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "w" }) = func >> return True
worldSCK _ _ = return False

neworldSCK :: IO () -> Event -> IO Bool
neworldSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "n" }) = func >> return True
neworldSCK _ _ = return False

systemSCK :: IO () -> Event -> IO Bool
systemSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "m" }) = func >> return True
systemSCK _ _ = return False

depcleanSCK :: IO () -> Event -> IO Bool
depcleanSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "d" }) = func >> return True
depcleanSCK _ _ = return False

allSCK :: IO () -> Event -> IO Bool
allSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "a" }) = func >> return True
allSCK _ _ = return False

syncSCK :: IO () -> Event -> IO Bool
syncSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "s" }) = func >> return True
syncSCK _ _ = return False

emergeSCK :: IO () -> Event -> IO Bool
emergeSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "e" }) = func >> return True
emergeSCK _ _ = return False

unmergeSCK :: IO () -> Event -> IO Bool
unmergeSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "u" }) = func >> return True
unmergeSCK _ _ = return False

binarySCK :: IO () -> Event -> IO Bool
binarySCK func (Key { eventModifier = [Control, Alt], eventKeyName = "b" }) = func >> return True
binarySCK _ _ = return False

usepkgSCK :: IO () -> Event -> IO Bool
usepkgSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "k" }) = func >> return True
usepkgSCK _ _ = return False

fetchSCK :: IO () -> Event -> IO Bool
fetchSCK func (Key { eventModifier = [Control, Alt], eventKeyName = "f" }) = func >> return True
fetchSCK _ _ = return False

-- Search box short-cut key
searchSCK :: IO () -> Event -> IO Bool
searchSCK func (Key { eventModifier = [Control], eventKeyName = "o" }) = func >> return True
searchSCK _ _ = return False

{- | Main Tree Views sort-cut keys -}
categorySCK:: IO () -> Event -> IO Bool
categorySCK func (Key { eventModifier = [Control], eventKeyName = "j" }) = func >> return True
categorySCK _ _ = return False

packageSCK:: IO () -> Event -> IO Bool
packageSCK func (Key { eventModifier = [Control], eventKeyName = "k" }) = func >> return True
packageSCK _ _ = return False

versionSCK:: IO () -> Event -> IO Bool
versionSCK func (Key { eventModifier = [Control], eventKeyName = "l" }) = func >> return True
versionSCK _ _ = return False

-- Close panel tab
closeProcTab :: IO () -> Event -> IO Bool
closeProcTab func (Key { eventModifier = [Control], eventKeyName = "c" }) = func >> return True
closeProcTab _ _ = return False

queuePopup :: IO () -> Event -> IO Bool
queuePopup func (Button { eventClick = ReleaseClick , eventButton = RightButton }) = func >> return True
queuePopup func (Key { eventModifier = [Control], eventKeyName = "Right" }) = func >> return True
queuePopup _ _ = return False