/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import sun.misc.FloatingDecimal;

abstract class AbstractStringBuilder
implements Appendable,
CharSequence {
    char[] value;
    int count;

    AbstractStringBuilder() {
    }

    AbstractStringBuilder(int capacity) {
        this.value = new char[capacity];
    }

    @Override
    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > 0) {
            this.ensureCapacityInternal(minimumCapacity);
        }
    }

    private void ensureCapacityInternal(int minimumCapacity) {
        if (minimumCapacity - this.value.length > 0) {
            this.expandCapacity(minimumCapacity);
        }
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = this.value.length * 2 + 2;
        if (newCapacity - minimumCapacity < 0) {
            newCapacity = minimumCapacity;
        }
        if (newCapacity < 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.value = Arrays.copyOf(this.value, newCapacity);
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            this.value = Arrays.copyOf(this.value, this.count);
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.ensureCapacityInternal(newLength);
        if (this.count < newLength) {
            Arrays.fill(this.value, this.count, newLength, '\u0000');
        }
        this.count = newLength;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public int codePointAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointAtImpl(this.value, index, this.count);
    }

    public int codePointBefore(int index) {
        int i = index - 1;
        if (i < 0 || i >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointBeforeImpl(this.value, index, 0);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.count || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(this.value, beginIndex, endIndex - beginIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        if (index < 0 || index > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(this.value, 0, this.count, index, codePointOffset);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public AbstractStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public AbstractStringBuilder append(String str) {
        if (str == null) {
            return this.appendNull();
        }
        int len = str.length();
        this.ensureCapacityInternal(this.count + len);
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public AbstractStringBuilder append(StringBuffer sb) {
        if (sb == null) {
            return this.appendNull();
        }
        int len = sb.length();
        this.ensureCapacityInternal(this.count + len);
        sb.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    AbstractStringBuilder append(AbstractStringBuilder asb) {
        if (asb == null) {
            return this.appendNull();
        }
        int len = asb.length();
        this.ensureCapacityInternal(this.count + len);
        asb.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence s) {
        if (s == null) {
            return this.appendNull();
        }
        if (s instanceof String) {
            return this.append((String)s);
        }
        if (s instanceof AbstractStringBuilder) {
            return this.append((AbstractStringBuilder)s);
        }
        return this.append(s, 0, s.length());
    }

    private AbstractStringBuilder appendNull() {
        int c = this.count;
        this.ensureCapacityInternal(c + 4);
        char[] value = this.value;
        value[c++] = 110;
        value[c++] = 117;
        value[c++] = 108;
        value[c++] = 108;
        this.count = c;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if (start < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
        }
        int len = end - start;
        this.ensureCapacityInternal(this.count + len);
        int i = start;
        int j = this.count;
        while (i < end) {
            this.value[j] = s.charAt(i);
            ++i;
            ++j;
        }
        this.count += len;
        return this;
    }

    public AbstractStringBuilder append(char[] str) {
        int len = str.length;
        this.ensureCapacityInternal(this.count + len);
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public AbstractStringBuilder append(char[] str, int offset, int len) {
        if (len > 0) {
            this.ensureCapacityInternal(this.count + len);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public AbstractStringBuilder append(boolean b) {
        if (b) {
            this.ensureCapacityInternal(this.count + 4);
            this.value[this.count++] = 116;
            this.value[this.count++] = 114;
            this.value[this.count++] = 117;
            this.value[this.count++] = 101;
        } else {
            this.ensureCapacityInternal(this.count + 5);
            this.value[this.count++] = 102;
            this.value[this.count++] = 97;
            this.value[this.count++] = 108;
            this.value[this.count++] = 115;
            this.value[this.count++] = 101;
        }
        return this;
    }

    @Override
    public AbstractStringBuilder append(char c) {
        this.ensureCapacityInternal(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public AbstractStringBuilder append(int i) {
        if (i == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        int appendedLength = i < 0 ? Integer.stringSize(-i) + 1 : Integer.stringSize(i);
        int spaceNeeded = this.count + appendedLength;
        this.ensureCapacityInternal(spaceNeeded);
        Integer.getChars(i, spaceNeeded, this.value);
        this.count = spaceNeeded;
        return this;
    }

    public AbstractStringBuilder append(long l) {
        if (l == Long.MIN_VALUE) {
            this.append("-9223372036854775808");
            return this;
        }
        int appendedLength = l < 0L ? Long.stringSize(-l) + 1 : Long.stringSize(l);
        int spaceNeeded = this.count + appendedLength;
        this.ensureCapacityInternal(spaceNeeded);
        Long.getChars(l, spaceNeeded, this.value);
        this.count = spaceNeeded;
        return this;
    }

    public AbstractStringBuilder append(float f) {
        FloatingDecimal.appendTo(f, (Appendable)this);
        return this;
    }

    public AbstractStringBuilder append(double d) {
        FloatingDecimal.appendTo(d, (Appendable)this);
        return this;
    }

    public AbstractStringBuilder delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public AbstractStringBuilder appendCodePoint(int codePoint) {
        int count = this.count;
        if (Character.isBmpCodePoint(codePoint)) {
            this.ensureCapacityInternal(count + 1);
            this.value[count] = (char)codePoint;
            this.count = count + 1;
        } else if (Character.isValidCodePoint(codePoint)) {
            this.ensureCapacityInternal(count + 2);
            Character.toSurrogates(codePoint, this.value, count);
            this.count = count + 2;
        } else {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public AbstractStringBuilder deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public AbstractStringBuilder replace(int start, int end, String str) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (end > this.count) {
            end = this.count;
        }
        int len = str.length();
        int newCount = this.count + len - (end - start);
        this.ensureCapacityInternal(newCount);
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        str.getChars(this.value, start);
        this.count = newCount;
        return this;
    }

    public String substring(int start) {
        return this.substring(start, this.count);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.value, start, end - start);
    }

    public AbstractStringBuilder insert(int index, char[] str, int offset, int len) {
        if (index < 0 || index > this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (offset < 0 || len < 0 || offset > str.length - len) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ", len " + len + ", str.length " + str.length);
        }
        this.ensureCapacityInternal(this.count + len);
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(str, offset, this.value, index, len);
        this.count += len;
        return this;
    }

    public AbstractStringBuilder insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public AbstractStringBuilder insert(int offset, String str) {
        if (offset < 0 || offset > this.length()) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (str == null) {
            str = "null";
        }
        int len = str.length();
        this.ensureCapacityInternal(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(this.value, offset);
        this.count += len;
        return this;
    }

    public AbstractStringBuilder insert(int offset, char[] str) {
        if (offset < 0 || offset > this.length()) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        int len = str.length;
        this.ensureCapacityInternal(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count += len;
        return this;
    }

    public AbstractStringBuilder insert(int dstOffset, CharSequence s) {
        if (s == null) {
            s = "null";
        }
        if (s instanceof String) {
            return this.insert(dstOffset, (String)s);
        }
        return this.insert(dstOffset, s, 0, s.length());
    }

    public AbstractStringBuilder insert(int dstOffset, CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if (dstOffset < 0 || dstOffset > this.length()) {
            throw new IndexOutOfBoundsException("dstOffset " + dstOffset);
        }
        if (start < 0 || end < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
        }
        int len = end - start;
        this.ensureCapacityInternal(this.count + len);
        System.arraycopy(this.value, dstOffset, this.value, dstOffset + len, this.count - dstOffset);
        for (int i = start; i < end; ++i) {
            this.value[dstOffset++] = s.charAt(i);
        }
        this.count += len;
        return this;
    }

    public AbstractStringBuilder insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public AbstractStringBuilder insert(int offset, char c) {
        this.ensureCapacityInternal(this.count + 1);
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        ++this.count;
        return this;
    }

    public AbstractStringBuilder insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public AbstractStringBuilder insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public AbstractStringBuilder insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public AbstractStringBuilder insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return String.indexOf(this.value, 0, this.count, str, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.value, 0, this.count, str, fromIndex);
    }

    public AbstractStringBuilder reverse() {
        boolean hasSurrogates = false;
        int n = this.count - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char ck;
            int k = n - j;
            char cj = this.value[j];
            this.value[j] = ck = this.value[k];
            this.value[k] = cj;
            if (!Character.isSurrogate(cj) && !Character.isSurrogate(ck)) continue;
            hasSurrogates = true;
        }
        if (hasSurrogates) {
            this.reverseAllValidSurrogatePairs();
        }
        return this;
    }

    private void reverseAllValidSurrogatePairs() {
        for (int i = 0; i < this.count - 1; ++i) {
            char c1;
            char c2 = this.value[i];
            if (!Character.isLowSurrogate(c2) || !Character.isHighSurrogate(c1 = this.value[i + 1])) continue;
            this.value[i++] = c1;
            this.value[i] = c2;
        }
    }

    @Override
    public abstract String toString();

    final char[] getValue() {
        return this.value;
    }
}

