/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import sun.awt.SunToolkit;
import sun.java2d.opengl.OGLRenderQueue;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public abstract class UNIXToolkit
extends SunToolkit {
    public static final Object GTK_LOCK = new Object();
    private static final int[] BAND_OFFSETS = new int[]{0, 1, 2};
    private static final int[] BAND_OFFSETS_ALPHA = new int[]{0, 1, 2, 3};
    private static final int DEFAULT_DATATRANSFER_TIMEOUT = 10000;
    private Boolean nativeGTKAvailable;
    private Boolean nativeGTKLoaded;
    private BufferedImage tmpImage = null;
    public static final String FONTCONFIGAAHINT = "fontconfig/Antialias";

    public static int getDatatransferTimeout() {
        Integer dt = AccessController.doPrivileged(new GetIntegerAction("sun.awt.datatransfer.timeout"));
        if (dt == null || dt <= 0) {
            return 10000;
        }
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNativeGTKAvailable() {
        Object object = GTK_LOCK;
        synchronized (object) {
            if (this.nativeGTKLoaded != null) {
                return this.nativeGTKLoaded;
            }
            if (this.nativeGTKAvailable != null) {
                return this.nativeGTKAvailable;
            }
            boolean success = UNIXToolkit.check_gtk(UNIXToolkit.getEnabledGtkVersion().getNumber());
            this.nativeGTKAvailable = success;
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadGTK() {
        Object object = GTK_LOCK;
        synchronized (object) {
            if (this.nativeGTKLoaded == null) {
                this.nativeGTKLoaded = UNIXToolkit.load_gtk(UNIXToolkit.getEnabledGtkVersion().getNumber(), UNIXToolkit.isGtkVerbose());
            }
        }
        return this.nativeGTKLoaded;
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String name) {
        if (name.startsWith("gtk.icon.")) {
            return this.lazilyLoadGTKIcon(name);
        }
        return super.lazilyLoadDesktopProperty(name);
    }

    protected Object lazilyLoadGTKIcon(String longname) {
        Object result = this.desktopProperties.get(longname);
        if (result != null) {
            return result;
        }
        String[] str = longname.split("\\.");
        if (str.length != 5) {
            return null;
        }
        int size = 0;
        try {
            size = Integer.parseInt(str[3]);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        GTKConstants.TextDirection dir = "ltr".equals(str[4]) ? GTKConstants.TextDirection.LTR : GTKConstants.TextDirection.RTL;
        BufferedImage img = this.getStockIcon(-1, str[2], size, dir.ordinal(), null);
        if (img != null) {
            this.setDesktopProperty(longname, img);
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getGTKIcon(String filename) {
        if (!this.loadGTK()) {
            return null;
        }
        Object object = GTK_LOCK;
        synchronized (object) {
            if (!this.load_gtk_icon(filename)) {
                this.tmpImage = null;
            }
        }
        return this.tmpImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getStockIcon(int widgetType, String stockId, int iconSize, int direction, String detail) {
        if (!this.loadGTK()) {
            return null;
        }
        Object object = GTK_LOCK;
        synchronized (object) {
            if (!this.load_stock_icon(widgetType, stockId, iconSize, direction, detail)) {
                this.tmpImage = null;
            }
        }
        return this.tmpImage;
    }

    public void loadIconCallback(byte[] data, int width, int height, int rowStride, int bps, int channels, boolean alpha) {
        this.tmpImage = null;
        DataBufferByte dataBuf = new DataBufferByte(data, rowStride * height);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuf, width, height, rowStride, channels, alpha ? BAND_OFFSETS_ALPHA : BAND_OFFSETS, null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), alpha, false, 3, 0);
        this.tmpImage = new BufferedImage(colorModel, raster, false, null);
    }

    private static native boolean check_gtk(int var0);

    private static native boolean load_gtk(int var0, boolean var1);

    private static native boolean unload_gtk();

    private native boolean load_gtk_icon(String var1);

    private native boolean load_stock_icon(int var1, String var2, int var3, int var4, String var5);

    private native void nativeSync();

    private static native int get_gtk_version();

    @Override
    public void sync() {
        this.nativeSync();
        OGLRenderQueue.sync();
    }

    @Override
    protected RenderingHints getDesktopAAHints() {
        String subpixOrder;
        boolean aa;
        Object aaValue = this.getDesktopProperty("gnome.Xft/Antialias");
        if (aaValue == null) {
            aaValue = this.getDesktopProperty(FONTCONFIGAAHINT);
            if (aaValue != null) {
                return new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, aaValue);
            }
            return null;
        }
        boolean bl = aa = aaValue instanceof Number && ((Number)aaValue).intValue() != 0;
        Object aaHint = aa ? ((subpixOrder = (String)this.getDesktopProperty("gnome.Xft/RGBA")) == null || subpixOrder.equals("none") ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : (subpixOrder.equals("rgb") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB : (subpixOrder.equals("bgr") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR : (subpixOrder.equals("vrgb") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB : (subpixOrder.equals("vbgr") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR : RenderingHints.VALUE_TEXT_ANTIALIAS_ON))))) : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
        return new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, aaHint);
    }

    private native boolean gtkCheckVersionImpl(int var1, int var2, int var3);

    public boolean checkGtkVersion(int major, int minor, int micro) {
        if (this.loadGTK()) {
            return this.gtkCheckVersionImpl(major, minor, micro);
        }
        return false;
    }

    public static GtkVersions getEnabledGtkVersion() {
        String version = AccessController.doPrivileged(new GetPropertyAction("jdk.gtk.version"));
        if (version == null) {
            return GtkVersions.ANY;
        }
        if (version.startsWith("2")) {
            return GtkVersions.GTK2;
        }
        if ("3".equals(version)) {
            return GtkVersions.GTK3;
        }
        return GtkVersions.ANY;
    }

    public static GtkVersions getGtkVersion() {
        return GtkVersions.getVersion(UNIXToolkit.get_gtk_version());
    }

    public static boolean isGtkVerbose() {
        return AccessController.doPrivileged(() -> Boolean.getBoolean("jdk.gtk.verbose"));
    }

    public static enum GtkVersions {
        ANY(0),
        GTK2(2),
        GTK3(3);

        final int number;

        private GtkVersions(int number) {
            this.number = number;
        }

        public static GtkVersions getVersion(int number) {
            switch (number) {
                case 2: {
                    return GTK2;
                }
                case 3: {
                    return GTK3;
                }
            }
            return ANY;
        }

        public int getNumber() {
            return this.number;
        }

        static class Constants {
            static final int GTK2_MAJOR_NUMBER = 2;
            static final int GTK3_MAJOR_NUMBER = 3;

            Constants() {
            }
        }
    }
}

