/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Desktop;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sun.awt.UNIXToolkit;
import sun.awt.X11.XToolkit;

public class XDesktopPeer
implements DesktopPeer {
    private static final List<Desktop.Action> supportedActions = new ArrayList<Desktop.Action>(Arrays.asList(Desktop.Action.OPEN, Desktop.Action.MAIL, Desktop.Action.BROWSE));
    private static boolean nativeLibraryLoaded = false;
    private static boolean initExecuted = false;

    private static void initWithLock() {
        XToolkit.awtLock();
        try {
            if (!initExecuted) {
                nativeLibraryLoaded = XDesktopPeer.init(UNIXToolkit.getEnabledGtkVersion().ordinal(), UNIXToolkit.isGtkVerbose());
            }
        }
        finally {
            initExecuted = true;
            XToolkit.awtUnlock();
        }
    }

    XDesktopPeer() {
        XDesktopPeer.initWithLock();
    }

    static boolean isDesktopSupported() {
        XDesktopPeer.initWithLock();
        return nativeLibraryLoaded && !supportedActions.isEmpty();
    }

    @Override
    public boolean isSupported(Desktop.Action type) {
        return supportedActions.contains((Object)type);
    }

    @Override
    public void open(File file) throws IOException {
        try {
            this.launch(file.toURI());
        }
        catch (MalformedURLException e) {
            throw new IOException(file.toString());
        }
    }

    @Override
    public void edit(File file) throws IOException {
        throw new UnsupportedOperationException("The current platform doesn't support the EDIT action.");
    }

    @Override
    public void print(File file) throws IOException {
        throw new UnsupportedOperationException("The current platform doesn't support the PRINT action.");
    }

    @Override
    public void mail(URI uri) throws IOException {
        this.launch(uri);
    }

    @Override
    public void browse(URI uri) throws IOException {
        this.launch(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launch(URI uri) throws IOException {
        byte[] uriByteArray = (uri.toString() + '\u0000').getBytes();
        boolean result = false;
        XToolkit.awtLock();
        try {
            if (!nativeLibraryLoaded) {
                throw new IOException("Failed to load native libraries.");
            }
            result = this.gnome_url_show(uriByteArray);
        }
        finally {
            XToolkit.awtUnlock();
        }
        if (!result) {
            throw new IOException("Failed to show URI:" + uri);
        }
    }

    private native boolean gnome_url_show(byte[] var1);

    private static native boolean init(int var0, boolean var1);
}

