/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.anon;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import sun.invoke.anon.ConstantPoolParser;
import sun.invoke.anon.ConstantPoolVisitor;
import sun.invoke.anon.InvalidConstantPoolFormatException;

public class ConstantPoolPatch {
    final ConstantPoolParser outer;
    final Object[] patchArray;
    private static final int CONSTANT_MemberRef_MASK = 11;
    private static final Map<Class<?>, Byte> CONSTANT_VALUE_CLASS_TAG;
    private static final Class<?>[] CONSTANT_VALUE_CLASS;

    ConstantPoolPatch(ConstantPoolParser outer) {
        this.outer = outer;
        this.patchArray = new Object[outer.getLength()];
    }

    public ConstantPoolPatch(byte[] classFile) throws InvalidConstantPoolFormatException {
        this(new ConstantPoolParser(classFile));
    }

    public ConstantPoolPatch(Class<?> templateClass) throws IOException, InvalidConstantPoolFormatException {
        this(new ConstantPoolParser(templateClass));
    }

    public ConstantPoolPatch(ConstantPoolPatch patch) {
        this.outer = patch.outer;
        this.patchArray = (Object[])patch.patchArray.clone();
    }

    public ConstantPoolParser getParser() {
        return this.outer;
    }

    public byte getTag(int index) {
        return this.outer.getTag(index);
    }

    public Object getPatch(int index) {
        String[] value = this.patchArray[index];
        if (value == null) {
            return null;
        }
        switch (this.getTag(index)) {
            case 9: 
            case 10: 
            case 11: {
                if (!(value instanceof String)) break;
                value = ConstantPoolPatch.stripSemis(2, (String)value);
                break;
            }
            case 12: {
                if (!(value instanceof String)) break;
                value = ConstantPoolPatch.stripSemis(1, (String)value);
            }
        }
        return value;
    }

    public void clear() {
        Arrays.fill(this.patchArray, null);
    }

    public void clear(int index) {
        this.patchArray[index] = null;
    }

    public Object[] getPatches() {
        return (Object[])this.patchArray.clone();
    }

    public Object[] getOriginalCP() throws InvalidConstantPoolFormatException {
        return this.getOriginalCP(0, this.patchArray.length, -1);
    }

    public void putPatches(final Map<String, String> utf8Map, final Map<String, Object> classMap, final Map<Object, Object> valueMap, boolean deleteUsedEntries) throws InvalidConstantPoolFormatException {
        HashSet usedValueKeys;
        HashSet usedClassKeys;
        HashSet usedUtf8Keys;
        if (deleteUsedEntries) {
            usedUtf8Keys = utf8Map == null ? null : new HashSet();
            usedClassKeys = classMap == null ? null : new HashSet();
            usedValueKeys = valueMap == null ? null : new HashSet();
        } else {
            usedUtf8Keys = null;
            usedClassKeys = null;
            usedValueKeys = null;
        }
        this.outer.parse(new ConstantPoolVisitor(){

            @Override
            public void visitUTF8(int index, byte tag, String utf8) {
                ConstantPoolPatch.this.putUTF8(index, (String)utf8Map.get(utf8));
                if (usedUtf8Keys != null) {
                    usedUtf8Keys.add(utf8);
                }
            }

            @Override
            public void visitConstantValue(int index, byte tag, Object value) {
                ConstantPoolPatch.this.putConstantValue(index, tag, valueMap.get(value));
                if (usedValueKeys != null) {
                    usedValueKeys.add(value);
                }
            }

            @Override
            public void visitConstantString(int index, byte tag, String name, int nameIndex) {
                if (tag == 7) {
                    ConstantPoolPatch.this.putConstantValue(index, tag, classMap.get(name));
                    if (usedClassKeys != null) {
                        usedClassKeys.add(name);
                    }
                } else {
                    assert (tag == 8);
                    this.visitConstantValue(index, tag, name);
                }
            }
        });
        if (usedUtf8Keys != null) {
            utf8Map.keySet().removeAll(usedUtf8Keys);
        }
        if (usedClassKeys != null) {
            classMap.keySet().removeAll(usedClassKeys);
        }
        if (usedValueKeys != null) {
            valueMap.keySet().removeAll(usedValueKeys);
        }
    }

    Object[] getOriginalCP(final int startIndex, final int endIndex, final int tagMask) throws InvalidConstantPoolFormatException {
        final Object[] cpArray = new Object[endIndex - startIndex];
        this.outer.parse(new ConstantPoolVisitor(){

            void show(int index, byte tag, Object value) {
                if (index < startIndex || index >= endIndex) {
                    return;
                }
                if ((1 << tag & tagMask) == 0) {
                    return;
                }
                cpArray[index - startIndex] = value;
            }

            @Override
            public void visitUTF8(int index, byte tag, String utf8) {
                this.show(index, tag, utf8);
            }

            @Override
            public void visitConstantValue(int index, byte tag, Object value) {
                assert (tag != 8);
                this.show(index, tag, value);
            }

            @Override
            public void visitConstantString(int index, byte tag, String value, int j) {
                this.show(index, tag, value);
            }

            @Override
            public void visitMemberRef(int index, byte tag, String className, String memberName, String signature, int j, int k) {
                this.show(index, tag, new String[]{className, memberName, signature});
            }

            @Override
            public void visitDescriptor(int index, byte tag, String memberName, String signature, int j, int k) {
                this.show(index, tag, new String[]{memberName, signature});
            }
        });
        return cpArray;
    }

    void writeHead(OutputStream out) throws IOException {
        this.outer.writePatchedHead(out, this.patchArray);
    }

    void writeTail(OutputStream out) throws IOException {
        this.outer.writeTail(out);
    }

    private void checkConstantTag(byte tag, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("invalid null constant value");
        }
        if (ConstantPoolPatch.classForTag(tag) != value.getClass()) {
            throw new IllegalArgumentException("invalid constant value" + (tag == 0 ? "" : " for tag " + ConstantPoolVisitor.tagName(tag)) + " of class " + value.getClass());
        }
    }

    private void checkTag(int index, byte putTag) {
        byte tag = this.outer.tags[index];
        if (tag != putTag) {
            throw new IllegalArgumentException("invalid put operation for " + ConstantPoolVisitor.tagName(putTag) + " at index " + index + " found " + ConstantPoolVisitor.tagName(tag));
        }
    }

    private void checkTagMask(int index, int tagBitMask) {
        int tagBit;
        byte tag = this.outer.tags[index];
        int n = tagBit = (tag & 0x1F) == tag ? 1 << tag : 0;
        if ((tagBit & tagBitMask) == 0) {
            throw new IllegalArgumentException("invalid put operation at index " + index + " found " + ConstantPoolVisitor.tagName(tag));
        }
    }

    private static void checkMemberName(String memberName) {
        if (memberName.indexOf(59) >= 0) {
            throw new IllegalArgumentException("memberName " + memberName + " contains a ';'");
        }
    }

    public void putUTF8(int index, String utf8) {
        if (utf8 == null) {
            this.clear(index);
            return;
        }
        this.checkTag(index, (byte)1);
        this.patchArray[index] = utf8;
    }

    public void putConstantValue(int index, Object value) {
        if (value == null) {
            this.clear(index);
            return;
        }
        byte tag = ConstantPoolPatch.tagForConstant(value.getClass());
        this.checkConstantTag(tag, value);
        this.checkTag(index, tag);
        this.patchArray[index] = value;
    }

    public void putConstantValue(int index, byte tag, Object value) {
        if (value == null) {
            this.clear(index);
            return;
        }
        this.checkTag(index, tag);
        if (tag == 7 && value instanceof String) {
            ConstantPoolPatch.checkClassName((String)value);
        } else if (tag != 8) {
            this.checkConstantTag(tag, value);
        }
        this.checkTag(index, tag);
        this.patchArray[index] = value;
    }

    public void putDescriptor(int index, String memberName, String signature) {
        this.checkTag(index, (byte)12);
        ConstantPoolPatch.checkMemberName(memberName);
        this.patchArray[index] = ConstantPoolPatch.addSemis(memberName, signature);
    }

    public void putMemberRef(int index, byte tag, String className, String memberName, String signature) {
        this.checkTagMask(tag, 11);
        this.checkTag(index, tag);
        ConstantPoolPatch.checkClassName(className);
        ConstantPoolPatch.checkMemberName(memberName);
        if (signature.startsWith("(") == (tag == 9)) {
            throw new IllegalArgumentException("bad signature: " + signature);
        }
        this.patchArray[index] = ConstantPoolPatch.addSemis(className, memberName, signature);
    }

    static Class<?> classForTag(byte tag) {
        if ((tag & 0xFF) >= CONSTANT_VALUE_CLASS.length) {
            return null;
        }
        return CONSTANT_VALUE_CLASS[tag];
    }

    static byte tagForConstant(Class<?> cls) {
        Byte tag = CONSTANT_VALUE_CLASS_TAG.get(cls);
        return tag == null ? (byte)0 : tag;
    }

    private static void checkClassName(String className) {
        if (className.indexOf(47) >= 0 || className.indexOf(59) >= 0) {
            throw new IllegalArgumentException("invalid class name " + className);
        }
    }

    static String addSemis(String name, String ... names) {
        StringBuilder buf = new StringBuilder(name.length() * 5);
        buf.append(name);
        for (String name2 : names) {
            buf.append(';').append(name2);
        }
        String res = buf.toString();
        assert (ConstantPoolPatch.stripSemis(names.length, res)[0].equals(name));
        assert (ConstantPoolPatch.stripSemis(names.length, res)[1].equals(names[0]));
        assert (names.length == 1 || ConstantPoolPatch.stripSemis(names.length, res)[2].equals(names[1]));
        return res;
    }

    static String[] stripSemis(int count, String string) {
        String[] res = new String[count + 1];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            int pos2 = string.indexOf(59, pos);
            if (pos2 < 0) {
                pos2 = string.length();
            }
            res[i] = string.substring(pos, pos2);
            pos = pos2;
        }
        res[count] = string.substring(pos);
        return res;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        buf.append("{");
        Object[] origCP = null;
        for (int i = 0; i < this.patchArray.length; ++i) {
            if (this.patchArray[i] == null) continue;
            if (origCP != null) {
                buf.append(", ");
            } else {
                try {
                    origCP = this.getOriginalCP();
                }
                catch (InvalidConstantPoolFormatException ee) {
                    origCP = new Object[]{};
                }
            }
            String orig = i < origCP.length ? origCP[i] : "?";
            buf.append((Object)orig).append("=").append(this.patchArray[i]);
        }
        buf.append("}");
        return buf.toString();
    }

    static {
        Object[][] values;
        CONSTANT_VALUE_CLASS_TAG = new IdentityHashMap();
        CONSTANT_VALUE_CLASS = new Class[16];
        for (Object[] value : values = new Object[][]{{Integer.class, (byte)3}, {Long.class, (byte)5}, {Float.class, (byte)4}, {Double.class, (byte)6}, {String.class, (byte)8}, {Class.class, (byte)7}}) {
            Class cls = (Class)value[0];
            Byte tag = (Byte)value[1];
            CONSTANT_VALUE_CLASS_TAG.put(cls, tag);
            ConstantPoolPatch.CONSTANT_VALUE_CLASS[tag.byteValue()] = cls;
        }
    }
}

