/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Color;
import java.awt.Transparency;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.xr.XRGraphicsConfig;
import sun.java2d.xr.XRSurfaceData;

public class XRSurfaceDataProxy
extends SurfaceDataProxy
implements Transparency {
    XRGraphicsConfig xrgc;
    int transparency;

    public static SurfaceDataProxy createProxy(SurfaceData srcData, XRGraphicsConfig dstConfig) {
        if (srcData instanceof XRSurfaceData) {
            return UNCACHED;
        }
        return new XRSurfaceDataProxy(dstConfig, srcData.getTransparency());
    }

    public XRSurfaceDataProxy(XRGraphicsConfig x11gc) {
        this.xrgc = x11gc;
    }

    @Override
    public SurfaceData validateSurfaceData(SurfaceData srcData, SurfaceData cachedData, int w, int h) {
        if (cachedData == null) {
            cachedData = XRSurfaceData.createData(this.xrgc, w, h, this.xrgc.getColorModel(), null, 0L, this.getTransparency(), true);
        }
        return cachedData;
    }

    public XRSurfaceDataProxy(XRGraphicsConfig x11gc, int transparency) {
        this.xrgc = x11gc;
        this.transparency = transparency;
    }

    @Override
    public boolean isSupportedOperation(SurfaceData srcData, int txtype, CompositeType comp, Color bgColor) {
        return bgColor == null || this.transparency == 3;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }
}

